/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.fixes;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.fixes.AdjustedPosition;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.IndexedPosition;
import com.google.errorprone.fixes.Replacement;
import com.google.errorprone.fixes.Replacements;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.tree.EndPosTable;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.JCDiagnostic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

public class SuggestedFix
implements Fix {
    private final String shortDescription;
    private final ImmutableList<FixOperation> fixes;
    private final ImmutableSet<String> importsToAdd;
    private final ImmutableSet<String> importsToRemove;
    private static final SuggestedFix EMPTY = SuggestedFix.builder().build();

    private SuggestedFix(Builder builder) {
        this.shortDescription = builder.shortDescription;
        this.fixes = ImmutableList.copyOf((Collection)builder.fixes);
        this.importsToAdd = ImmutableSet.copyOf((Collection)builder.importsToAdd);
        this.importsToRemove = ImmutableSet.copyOf((Collection)builder.importsToRemove);
    }

    @Override
    public boolean isEmpty() {
        return this.fixes.isEmpty() && this.importsToAdd.isEmpty() && this.importsToRemove.isEmpty();
    }

    @Override
    public Collection<String> getImportsToAdd() {
        return this.importsToAdd;
    }

    @Override
    public Collection<String> getImportsToRemove() {
        return this.importsToRemove;
    }

    @Override
    public String toString(JCTree.JCCompilationUnit compilationUnit) {
        StringBuilder result = new StringBuilder("replace ");
        for (Replacement replacement : this.getReplacements(compilationUnit.endPositions)) {
            result.append(String.format("position %d:%d with \"%s\" ", replacement.startPosition(), replacement.endPosition(), replacement.replaceWith()));
        }
        return result.toString();
    }

    @Override
    public String getShortDescription() {
        return this.shortDescription;
    }

    @Override
    public Set<Replacement> getReplacements(EndPosTable endPositions) {
        if (endPositions == null) {
            throw new IllegalArgumentException("Cannot produce correct replacements without endPositions.");
        }
        Replacements replacements = new Replacements();
        for (FixOperation fix : this.fixes) {
            replacements.add(fix.getReplacement(endPositions), Replacements.CoalescePolicy.EXISTING_FIRST);
        }
        return replacements.descending();
    }

    public static SuggestedFix replace(Tree tree, String replaceWith) {
        return SuggestedFix.builder().replace(tree, replaceWith).build();
    }

    public static SuggestedFix replace(int startPos, int endPos, String replaceWith) {
        return SuggestedFix.builder().replace(startPos, endPos, replaceWith).build();
    }

    public static SuggestedFix replace(Tree node, String replaceWith, int startPosAdjustment, int endPosAdjustment) {
        return SuggestedFix.builder().replace(node, replaceWith, startPosAdjustment, endPosAdjustment).build();
    }

    public static SuggestedFix prefixWith(Tree node, String prefix) {
        return SuggestedFix.builder().prefixWith(node, prefix).build();
    }

    public static SuggestedFix postfixWith(Tree node, String postfix) {
        return SuggestedFix.builder().postfixWith(node, postfix).build();
    }

    public static SuggestedFix delete(Tree node) {
        return SuggestedFix.builder().delete(node).build();
    }

    public static SuggestedFix swap(Tree node1, Tree node2) {
        return SuggestedFix.builder().swap(node1, node2).build();
    }

    public static SuggestedFix emptyFix() {
        return EMPTY;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static class ReplacementFix
    implements FixOperation {
        private final JCDiagnostic.DiagnosticPosition original;
        private final String replacement;

        public ReplacementFix(JCDiagnostic.DiagnosticPosition original, String replacement) {
            Preconditions.checkArgument((original.getStartPosition() >= 0 ? 1 : 0) != 0, (Object)"invalid start position");
            this.original = original;
            this.replacement = replacement;
        }

        @Override
        public Replacement getReplacement(EndPosTable endPositions) {
            return Replacement.create(this.original.getStartPosition(), this.original.getEndPosition(endPositions), this.replacement);
        }
    }

    private static class PrefixInsertion
    extends InsertionFix {
        public PrefixInsertion(JCDiagnostic.DiagnosticPosition tree, String insertion) {
            super(tree, insertion);
        }

        @Override
        protected int getInsertionIndex(EndPosTable endPositions) {
            return this.position.getStartPosition();
        }
    }

    private static class PostfixInsertion
    extends InsertionFix {
        public PostfixInsertion(JCDiagnostic.DiagnosticPosition tree, String insertion) {
            super(tree, insertion);
        }

        @Override
        protected int getInsertionIndex(EndPosTable endPositions) {
            return this.position.getEndPosition(endPositions);
        }
    }

    private static abstract class InsertionFix
    implements FixOperation {
        protected final JCDiagnostic.DiagnosticPosition position;
        protected final String insertion;

        protected abstract int getInsertionIndex(EndPosTable var1);

        protected InsertionFix(JCDiagnostic.DiagnosticPosition position, String insertion) {
            Preconditions.checkArgument((position.getStartPosition() >= 0 ? 1 : 0) != 0, (Object)"invalid start position");
            this.position = position;
            this.insertion = insertion;
        }

        @Override
        public Replacement getReplacement(EndPosTable endPositions) {
            int insertionIndex = this.getInsertionIndex(endPositions);
            return Replacement.create(insertionIndex, insertionIndex, this.insertion);
        }
    }

    private static interface FixOperation {
        public Replacement getReplacement(EndPosTable var1);
    }

    public static class Builder {
        private final List<FixOperation> fixes = new ArrayList<FixOperation>();
        private final Set<String> importsToAdd = new LinkedHashSet<String>();
        private final Set<String> importsToRemove = new LinkedHashSet<String>();
        private String shortDescription = "";

        protected Builder() {
        }

        public boolean isEmpty() {
            return this.fixes.isEmpty() && this.importsToAdd.isEmpty() && this.importsToRemove.isEmpty();
        }

        public SuggestedFix build() {
            return new SuggestedFix(this);
        }

        private Builder with(FixOperation fix) {
            this.fixes.add(fix);
            return this;
        }

        public Builder setShortDescription(String shortDescription) {
            this.shortDescription = shortDescription;
            return this;
        }

        public Builder replace(Tree node, String replaceWith) {
            Builder.checkNotSyntheticConstructor(node);
            return this.with(new ReplacementFix((JCDiagnostic.DiagnosticPosition)((Object)node), replaceWith));
        }

        public Builder replace(int startPos, int endPos, String replaceWith) {
            IndexedPosition pos = new IndexedPosition(startPos, endPos);
            return this.with(new ReplacementFix(pos, replaceWith));
        }

        public Builder replace(Tree node, String replaceWith, int startPosAdjustment, int endPosAdjustment) {
            Builder.checkNotSyntheticConstructor(node);
            return this.with(new ReplacementFix(new AdjustedPosition((JCTree)node, startPosAdjustment, endPosAdjustment), replaceWith));
        }

        public Builder prefixWith(Tree node, String prefix) {
            Builder.checkNotSyntheticConstructor(node);
            return this.with(new PrefixInsertion((JCDiagnostic.DiagnosticPosition)((Object)node), prefix));
        }

        public Builder postfixWith(Tree node, String postfix) {
            Builder.checkNotSyntheticConstructor(node);
            return this.with(new PostfixInsertion((JCDiagnostic.DiagnosticPosition)((Object)node), postfix));
        }

        public Builder delete(Tree node) {
            Builder.checkNotSyntheticConstructor(node);
            return this.replace(node, "");
        }

        public Builder swap(Tree node1, Tree node2) {
            Builder.checkNotSyntheticConstructor(node1);
            Builder.checkNotSyntheticConstructor(node2);
            this.fixes.add(new ReplacementFix((JCDiagnostic.DiagnosticPosition)((Object)node1), node2.toString()));
            this.fixes.add(new ReplacementFix((JCDiagnostic.DiagnosticPosition)((Object)node2), node1.toString()));
            return this;
        }

        public Builder addImport(String importString) {
            this.importsToAdd.add("import " + importString);
            return this;
        }

        public Builder addStaticImport(String importString) {
            this.importsToAdd.add("import static " + importString);
            return this;
        }

        public Builder removeImport(String importString) {
            this.importsToRemove.add("import " + importString);
            return this;
        }

        public Builder removeStaticImport(String importString) {
            this.importsToRemove.add("import static " + importString);
            return this;
        }

        public Builder merge(@Nullable Builder other) {
            if (other == null) {
                return this;
            }
            if (this.shortDescription.isEmpty()) {
                this.shortDescription = other.shortDescription;
            }
            this.fixes.addAll(other.fixes);
            this.importsToAdd.addAll(other.importsToAdd);
            this.importsToRemove.addAll(other.importsToRemove);
            return this;
        }

        public Builder merge(@Nullable SuggestedFix other) {
            if (other == null) {
                return this;
            }
            if (this.shortDescription.isEmpty()) {
                this.shortDescription = other.getShortDescription();
            }
            this.fixes.addAll((Collection<FixOperation>)other.fixes);
            this.importsToAdd.addAll((Collection<String>)other.importsToAdd);
            this.importsToRemove.addAll((Collection<String>)other.importsToRemove);
            return this;
        }

        private static void checkNotSyntheticConstructor(Tree tree) {
            if (tree instanceof MethodTree && ASTHelpers.isGeneratedConstructor((MethodTree)tree)) {
                throw new AssertionError((Object)"Cannot edit synthetic AST nodes");
            }
        }
    }
}

