<?php

use Utopia\Config\Config;
use Utopia\Database\Database;
use Utopia\Database\Helpers\ID;

$providers = Config::getParam('oAuthProviders', []);

return [
    'projects' => [
        '$collection' => ID::custom(Database::METADATA),
        '$id' => ID::custom('projects'),
        'name' => 'Projects',
        'attributes' => [
            [
                '$id' => ID::custom('teamInternalId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('teamId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('name'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 128,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('region'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 128,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('description'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('database'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('logo'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('url'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('version'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('legalName'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('legalCountry'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('legalState'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('legalCity'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('legalAddress'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('legalTaxId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => 'accessedAt',
                'type' => Database::VAR_DATETIME,
                'format' => '',
                'size' => 0,
                'signed' => false,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['datetime'],
            ],
            [
                '$id' => ID::custom('services'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => [],
                'array' => false,
                'filters' => ['json'],
            ],
            [
                '$id' => ID::custom('apis'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => [],
                'array' => false,
                'filters' => ['json'],
            ],
            [
                '$id' => ID::custom('smtp'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => [],
                'array' => false,
                'filters' => ['json', 'encrypt'],
            ],
            [
                '$id' => ID::custom('templates'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 1_000_000, // TODO make sure size fits
                'signed' => true,
                'required' => false,
                'default' => [],
                'array' => false,
                'filters' => ['json'],
            ],
            [
                '$id' => ID::custom('auths'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => [],
                'array' => false,
                'filters' => ['json'],
            ],
            [
                '$id' => ID::custom('oAuthProviders'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => [],
                'array' => false,
                'filters' => ['json', 'encrypt'],
            ],
            [
                '$id' => ID::custom('platforms'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['subQueryPlatforms'],
            ],
            [
                '$id' => ID::custom('webhooks'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['subQueryWebhooks'],
            ],
            [
                '$id' => ID::custom('keys'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['subQueryKeys'],
            ],
            [
                '$id' => ID::custom('devKeys'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['subQueryDevKeys'],
            ],
            [
                '$id' => ID::custom('search'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('pingCount'),
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 0,
                'signed' => false,
                'required' => false,
                'default' => 0,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('pingedAt'),
                'type' => Database::VAR_DATETIME,
                'format' => '',
                'size' => 0,
                'signed' => false,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['datetime'],
            ]
        ],
        'indexes' => [
            [
                '$id' => ID::custom('_key_search'),
                'type' => Database::INDEX_FULLTEXT,
                'attributes' => ['search'],
                'lengths' => [],
                'orders' => [],
            ],
            [
                '$id' => ID::custom('_key_name'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['name'],
                'lengths' => [128],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_team'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['teamId'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_pingCount'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['pingCount'],
                'lengths' => [],
                'orders' => [],
            ],
            [
                '$id' => ID::custom('_key_pingedAt'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['pingedAt'],
                'lengths' => [],
                'orders' => [],
            ],
            [
                '$id' => ID::custom('_key_database'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['database'],
                'lengths' => [],
                'orders' => [],
            ],
            [
                '$id' => ID::custom('_key_region_accessed_at'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['region', 'accessedAt'],
                'lengths' => [],
                'orders' => [],
            ],
        ],
    ],

    'schedules' => [
        '$collection' => ID::custom(Database::METADATA),
        '$id' => ID::custom('schedules'),
        'name' => 'schedules',
        'attributes' => [
            [
                '$id' => ID::custom('resourceType'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 100,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('resourceInternalId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('resourceId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('resourceUpdatedAt'),
                'type' => Database::VAR_DATETIME,
                'format' => '',
                'size' => 0,
                'signed' => false,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['datetime'],
            ],
            [
                '$id' => ID::custom('projectId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('schedule'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 100,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('data'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 65535,
                'signed' => true,
                'required' => false,
                'default' => new \stdClass(),
                'array' => false,
                'filters' => ['json', 'encrypt'],
            ],
            [
                '$id' => ID::custom('active'),
                'type' => Database::VAR_BOOLEAN,
                'signed' => true,
                'size' => 0,
                'format' => '',
                'filters' => [],
                'required' => false,
                'default' => null,
                'array' => false,
            ],
            [
                '$id' => ID::custom('region'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 10,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
        ],
        'indexes' => [
            [
                '$id' => ID::custom('_key_region_resourceType_resourceUpdatedAt'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['region', 'resourceType', 'resourceUpdatedAt'],
                'lengths' => [],
                'orders' => [],
            ],
            [
                '$id' => ID::custom('_key_region_resourceType_projectId_resourceId'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['region', 'resourceType', 'projectId', 'resourceId'],
                'lengths' => [],
                'orders' => [],
            ],
            [
                '$id' => ID::custom('_key_project_id_region'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['projectId', 'region'],
                'lengths' => [],
                'orders' => [],
            ],
            [
                '$id' => ID::custom('_key_region_rt_active'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['region', 'resourceType', 'active'],
                'lengths' => [],
                'orders' => [],
            ],
        ],
    ],

    'platforms' => [
        '$collection' => ID::custom(Database::METADATA),
        '$id' => ID::custom('platforms'),
        'name' => 'platforms',
        'attributes' => [
            [
                '$id' => ID::custom('projectInternalId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('projectId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('type'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('name'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('key'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('store'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('hostname'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ]
        ],
        'indexes' => [
            [
                '$id' => ID::custom('_key_project'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['projectInternalId'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
        ],
    ],

    'keys' => [
        '$collection' => ID::custom(Database::METADATA),
        '$id' => ID::custom('keys'),
        'name' => 'keys',
        'attributes' => [
            [
                '$id' => ID::custom('projectInternalId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('projectId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => 0,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('name'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('scopes'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => true,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('secret'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 512, // var_dump of \bin2hex(\random_bytes(128)) => string(256) doubling for encryption
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => ['encrypt'],
            ],
            [
                '$id' => ID::custom('expire'),
                'type' => Database::VAR_DATETIME,
                'format' => '',
                'size' => 0,
                'signed' => false,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['datetime'],
            ],
            [
                '$id' => ID::custom('accessedAt'),
                'type' => Database::VAR_DATETIME,
                'format' => '',
                'size' => 0,
                'signed' => false,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['datetime'],
            ],
            [
                '$id' => ID::custom('sdks'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => true,
                'filters' => [],
            ],
        ],
        'indexes' => [
            [
                '$id' => ID::custom('_key_project'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['projectInternalId'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => '_key_accessedAt',
                'type' => Database::INDEX_KEY,
                'attributes' => ['accessedAt'],
                'lengths' => [],
                'orders' => [],
            ],
        ],
    ],

    'devKeys' => [
        '$collection' => ID::custom(Database::METADATA),
        '$id' => ID::custom('devKeys'),
        'name' => 'Dev keys',
        'attributes' => [
            [
                '$id' => ID::custom('projectInternalId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('projectId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => 0,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('name'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('secret'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 512, // var_dump of \bin2hex(\random_bytes(128)) => string(256) doubling for encryption
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => ['encrypt'],
            ],
            [
                '$id' => ID::custom('expire'),
                'type' => Database::VAR_DATETIME,
                'format' => '',
                'size' => 0,
                'signed' => false,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['datetime'],
            ],
            [
                '$id' => ID::custom('accessedAt'),
                'type' => Database::VAR_DATETIME,
                'format' => '',
                'size' => 0,
                'signed' => false,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['datetime'],
            ],
            [
                '$id' => ID::custom('sdks'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => true,
                'filters' => [],
            ],
        ],
        'indexes' => [
            [
                '$id' => ID::custom('_key_project'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['projectInternalId'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => '_key_accessedAt',
                'type' => Database::INDEX_KEY,
                'attributes' => ['accessedAt'],
                'lengths' => [],
                'orders' => [],
            ],
        ],
    ],

    'webhooks' => [
        '$collection' => ID::custom(Database::METADATA),
        '$id' => ID::custom('webhooks'),
        'name' => 'webhooks',
        'attributes' => [
            [
                '$id' => ID::custom('projectInternalId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('projectId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('name'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('url'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('httpUser'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('httpPass'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY, // TODO will the length suffice after encryption?
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['encrypt'],
            ],
            [
                '$id' => ID::custom('security'),
                'type' => Database::VAR_BOOLEAN,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('events'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => true,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('signatureKey'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 2048,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('enabled'),
                'type' => Database::VAR_BOOLEAN,
                'signed' => true,
                'size' => 0,
                'format' => '',
                'filters' => [],
                'required' => false,
                'default' => true,
                'array' => false,
            ],
            [
                '$id' => ID::custom('logs'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 1000000,
                'signed' => true,
                'required' => false,
                'default' => '',
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('attempts'),
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => 0,
                'array' => false,
                'filters' => [],
            ],
        ],
        'indexes' => [
            [
                '$id' => ID::custom('_key_project'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['projectInternalId'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ]
        ],
    ],

    'certificates' => [
        '$collection' => ID::custom(Database::METADATA),
        '$id' => ID::custom('certificates'),
        'name' => 'Certificates',
        'attributes' => [
            [
                '$id' => ID::custom('domain'),
                'type' => Database::VAR_STRING,
                'format' => '',
                // The maximum total length of a domain name or number is 255 characters.
                // https://datatracker.ietf.org/doc/html/rfc2821#section-4.5.3.1
                // https://datatracker.ietf.org/doc/html/rfc5321#section-4.5.3.1.2
                'size' => 255,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('issueDate'),
                'type' => Database::VAR_DATETIME,
                'format' => '',
                'size' => 0,
                'signed' => false,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['datetime'],
            ],
            [
                '$id' => ID::custom('renewDate'),
                'type' => Database::VAR_DATETIME,
                'format' => '',
                'size' => 0,
                'signed' => false,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['datetime'],
            ],
            [
                '$id' => ID::custom('attempts'),
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('logs'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 1000000,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('updated'),
                'type' => Database::VAR_DATETIME,
                'format' => '',
                'size' => 0,
                'signed' => false,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['datetime'],
            ],
        ],
        'indexes' => [
            [
                '$id' => ID::custom('_key_domain'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['domain'],
                'lengths' => [255],
                'orders' => [Database::ORDER_ASC],
            ],
        ],
    ],

    'realtime' => [
        '$collection' => ID::custom(Database::METADATA),
        '$id' => ID::custom('realtime'),
        'name' => 'Realtime Connections',
        'attributes' => [
            [
                '$id' => ID::custom('container'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('timestamp'),
                'type' => Database::VAR_DATETIME,
                'format' => '',
                'size' => 0,
                'signed' => false,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['datetime'],
            ],
            [
                '$id' => ID::custom('value'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [], //TODO: use json filter
            ]
        ],
        'indexes' => [
            [
                '$id' => ID::custom('_key_timestamp'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['timestamp'],
                'lengths' => [],
                'orders' => [Database::ORDER_DESC],
            ],
        ]
    ],

    'rules' => [
        '$collection' => ID::custom(Database::METADATA),
        '$id' => ID::custom('rules'),
        'name' => 'Rules',
        'attributes' => [
            [
                '$id' => ID::custom('projectId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('projectInternalId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('domain'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('type'), // 'api', 'redirect', 'deployment' (site or function)
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 32,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('trigger'), // 'manual', 'deployment', '' (empty)
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 32,
                'signed' => true,
                'required' => false,
                'default' => '',
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('redirectUrl'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 2048,
                'signed' => true,
                'required' => false,
                'default' => '',
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('redirectStatusCode'),
                'type' => Database::VAR_INTEGER,
                'format' => '',
                'size' => 0,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('deploymentResourceType'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 32,
                'signed' => true,
                'required' => false,
                'default' => '',
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('deploymentId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => '',
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('deploymentInternalId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => '',
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('deploymentResourceId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => '',
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('deploymentResourceInternalId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => '',
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('deploymentVcsProviderBranch'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => '',
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('status'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('certificateId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('search'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16384,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('owner'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16,
                'signed' => true,
                'required' => false,
                'default' => '', // "Appwrite" or empty string
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('region'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 16,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
        ],
        'indexes' => [
            [
                '$id' => ID::custom('_key_search'),
                'type' => Database::INDEX_FULLTEXT,
                'attributes' => ['search'],
                'lengths' => [],
                'orders' => [],
            ],
            [
                '$id' => ID::custom('_key_domain'),
                'type' => Database::INDEX_UNIQUE,
                'attributes' => ['domain'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_projectInternalId'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['projectInternalId'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_projectId'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['projectId'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => '_key_type',
                'type' => Database::INDEX_KEY,
                'attributes' => ['type'],
                'lengths' => [32],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => '_key_trigger',
                'type' => Database::INDEX_KEY,
                'attributes' => ['trigger'],
                'lengths' => [32],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => '_key_deploymentResourceType',
                'type' => Database::INDEX_KEY,
                'attributes' => ['deploymentResourceType'],
                'lengths' => [32],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => '_key_deploymentResourceId',
                'type' => Database::INDEX_KEY,
                'attributes' => ['deploymentResourceId'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => '_key_deploymentResourceInternalId',
                'type' => Database::INDEX_KEY,
                'attributes' => ['deploymentResourceInternalId'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => '_key_deploymentId',
                'type' => Database::INDEX_KEY,
                'attributes' => ['deploymentId'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => '_key_deploymentInternalId',
                'type' => Database::INDEX_KEY,
                'attributes' => ['deploymentInternalId'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => '_key_deploymentVcsProviderBranch',
                'type' => Database::INDEX_KEY,
                'attributes' => ['deploymentVcsProviderBranch'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_owner'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['owner'],
                'lengths' => [16],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_region'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['region'],
                'lengths' => [16],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_piid_riid_rt'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['projectInternalId', 'deploymentInternalId', 'deploymentResourceType'],
                'lengths' => [],
                'orders' => [],
            ],
        ],
    ],

    'installations' => [
        '$collection' => ID::custom(Database::METADATA),
        '$id' => ID::custom('installations'),
        'name' => 'installations',
        'attributes' => [
            [
                '$id' => ID::custom('projectId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('projectInternalId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('providerInstallationId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('organization'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('provider'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('personal'),
                'type' => Database::VAR_BOOLEAN,
                'signed' => true,
                'size' => 0,
                'format' => '',
                'filters' => [],
                'required' => false,
                'default' => false,
                'array' => false,
            ],
            [
                '$id' => ID::custom('personalAccessToken'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['encrypt'],
            ],
            [
                '$id' => ID::custom('personalAccessTokenExpiry'),
                'type' => Database::VAR_DATETIME,
                'format' => '',
                'size' => 0,
                'signed' => false,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['datetime'],
            ],
            [
                '$id' => ID::custom('personalRefreshToken'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 256,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => ['encrypt'],
            ],
        ],
        'indexes' => [

            [
                '$id' => ID::custom('_key_projectInternalId'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['projectInternalId'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_projectId'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['projectId'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_providerInstallationId'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['providerInstallationId'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
        ],
    ],

    'repositories' => [
        '$collection' => ID::custom(Database::METADATA),
        '$id' => ID::custom('repositories'),
        'name' => 'repositories',
        'attributes' => [
            [
                '$id' => ID::custom('installationId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => []
            ],
            [
                '$id' => ID::custom('installationInternalId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('projectId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => []
            ],
            [
                '$id' => ID::custom('projectInternalId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('providerRepositoryId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => []
            ],
            [
                '$id' => ID::custom('resourceId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('resourceInternalId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('resourceType'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => []
            ],
            [
                '$id' => ID::custom('providerPullRequestIds'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => 128,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => true,
                'filters' => [],
            ],
        ],
        'indexes' => [
            [
                '$id' => ID::custom('_key_installationId'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['installationId'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_installationInternalId'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['installationInternalId'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_projectInternalId'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['projectInternalId'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_projectId'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['projectId'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_providerRepositoryId'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['providerRepositoryId'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_resourceId'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['resourceId'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => '_key_resourceInternalId',
                'type' => Database::INDEX_KEY,
                'attributes' => ['resourceInternalId'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_resourceType'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['resourceType'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_piid_riid_rt'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['projectInternalId', 'resourceInternalId', 'resourceType'],
                'lengths' => [],
                'orders' => [],
            ],
        ],
    ],

    'vcsComments' => [
        '$collection' => ID::custom(Database::METADATA),
        '$id' => ID::custom('vcsComments'),
        'name' => 'vcsComments',
        'attributes' => [
            [
                '$id' => ID::custom('installationId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => []
            ],
            [
                '$id' => ID::custom('installationInternalId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => false,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('projectId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => []
            ],
            [
                '$id' => ID::custom('projectInternalId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => [],
            ],
            [
                '$id' => ID::custom('providerRepositoryId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => []
            ],
            [
                '$id' => ID::custom('providerCommentId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => []
            ],
            [
                '$id' => ID::custom('providerPullRequestId'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => []
            ],
            [
                '$id' => ID::custom('providerBranch'),
                'type' => Database::VAR_STRING,
                'format' => '',
                'size' => Database::LENGTH_KEY,
                'signed' => true,
                'required' => true,
                'default' => null,
                'array' => false,
                'filters' => []
            ],
        ],
        'indexes' => [
            [
                '$id' => ID::custom('_key_installationId'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['installationId'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_installationInternalId'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['installationInternalId'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_projectInternalId'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['projectInternalId'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_projectId'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['projectId'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_providerRepositoryId'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['providerRepositoryId'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_providerPullRequestId'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['providerPullRequestId'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_providerBranch'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['providerBranch'],
                'lengths' => [Database::LENGTH_KEY],
                'orders' => [Database::ORDER_ASC],
            ],
            [
                '$id' => ID::custom('_key_piid_prid_rt'),
                'type' => Database::INDEX_KEY,
                'attributes' => ['projectInternalId', 'providerRepositoryId'],
                'lengths' => [],
                'orders' => [],
            ],
        ],
    ],

    'vcsCommentLocks' => [
        '$collection' => ID::custom(Database::METADATA),
        '$id' => ID::custom('vcsCommentLocks'),
        'name' => 'vcsCommentLocks',
        'attributes' => [],
        'indexes' => []
    ],
];
