package network

// Code generated by github.com/algorand/msgp DO NOT EDIT.

import (
	"sort"

	"github.com/algorand/msgp/msgp"

	"github.com/algorand/go-algorand/crypto"
)

// The following msgp objects are implemented in this file:
// disconnectReason
//         |-----> MarshalMsg
//         |-----> CanMarshalMsg
//         |-----> (*) UnmarshalMsg
//         |-----> (*) UnmarshalMsgWithState
//         |-----> (*) CanUnmarshalMsg
//         |-----> Msgsize
//         |-----> MsgIsZero
//         |-----> DisconnectReasonMaxSize()
//
// identityChallenge
//         |-----> (*) MarshalMsg
//         |-----> (*) CanMarshalMsg
//         |-----> (*) UnmarshalMsg
//         |-----> (*) UnmarshalMsgWithState
//         |-----> (*) CanUnmarshalMsg
//         |-----> (*) Msgsize
//         |-----> (*) MsgIsZero
//         |-----> IdentityChallengeMaxSize()
//
// identityChallengeResponse
//             |-----> (*) MarshalMsg
//             |-----> (*) CanMarshalMsg
//             |-----> (*) UnmarshalMsg
//             |-----> (*) UnmarshalMsgWithState
//             |-----> (*) CanUnmarshalMsg
//             |-----> (*) Msgsize
//             |-----> (*) MsgIsZero
//             |-----> IdentityChallengeResponseMaxSize()
//
// identityChallengeResponseSigned
//                |-----> (*) MarshalMsg
//                |-----> (*) CanMarshalMsg
//                |-----> (*) UnmarshalMsg
//                |-----> (*) UnmarshalMsgWithState
//                |-----> (*) CanUnmarshalMsg
//                |-----> (*) Msgsize
//                |-----> (*) MsgIsZero
//                |-----> IdentityChallengeResponseSignedMaxSize()
//
// identityChallengeSigned
//            |-----> (*) MarshalMsg
//            |-----> (*) CanMarshalMsg
//            |-----> (*) UnmarshalMsg
//            |-----> (*) UnmarshalMsgWithState
//            |-----> (*) CanUnmarshalMsg
//            |-----> (*) Msgsize
//            |-----> (*) MsgIsZero
//            |-----> IdentityChallengeSignedMaxSize()
//
// identityChallengeValue
//            |-----> (*) MarshalMsg
//            |-----> (*) CanMarshalMsg
//            |-----> (*) UnmarshalMsg
//            |-----> (*) UnmarshalMsgWithState
//            |-----> (*) CanUnmarshalMsg
//            |-----> (*) Msgsize
//            |-----> (*) MsgIsZero
//            |-----> IdentityChallengeValueMaxSize()
//
// identityVerificationMessage
//              |-----> (*) MarshalMsg
//              |-----> (*) CanMarshalMsg
//              |-----> (*) UnmarshalMsg
//              |-----> (*) UnmarshalMsgWithState
//              |-----> (*) CanUnmarshalMsg
//              |-----> (*) Msgsize
//              |-----> (*) MsgIsZero
//              |-----> IdentityVerificationMessageMaxSize()
//
// identityVerificationMessageSigned
//                 |-----> (*) MarshalMsg
//                 |-----> (*) CanMarshalMsg
//                 |-----> (*) UnmarshalMsg
//                 |-----> (*) UnmarshalMsgWithState
//                 |-----> (*) CanUnmarshalMsg
//                 |-----> (*) Msgsize
//                 |-----> (*) MsgIsZero
//                 |-----> IdentityVerificationMessageSignedMaxSize()
//
// peerMetaHeaders
//        |-----> MarshalMsg
//        |-----> CanMarshalMsg
//        |-----> (*) UnmarshalMsg
//        |-----> (*) UnmarshalMsgWithState
//        |-----> (*) CanUnmarshalMsg
//        |-----> Msgsize
//        |-----> MsgIsZero
//        |-----> PeerMetaHeadersMaxSize()
//
// peerMetaValues
//        |-----> MarshalMsg
//        |-----> CanMarshalMsg
//        |-----> (*) UnmarshalMsg
//        |-----> (*) UnmarshalMsgWithState
//        |-----> (*) CanUnmarshalMsg
//        |-----> Msgsize
//        |-----> MsgIsZero
//        |-----> PeerMetaValuesMaxSize()
//

// MarshalMsg implements msgp.Marshaler
func (z disconnectReason) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	o = msgp.AppendString(o, string(z))
	return
}

func (_ disconnectReason) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(disconnectReason)
	if !ok {
		_, ok = (z).(*disconnectReason)
	}
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *disconnectReason) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	{
		var zb0001 string
		zb0001, bts, err = msgp.ReadStringBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		(*z) = disconnectReason(zb0001)
	}
	o = bts
	return
}

func (z *disconnectReason) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *disconnectReason) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*disconnectReason)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z disconnectReason) Msgsize() (s int) {
	s = msgp.StringPrefixSize + len(string(z))
	return
}

// MsgIsZero returns whether this is a zero value
func (z disconnectReason) MsgIsZero() bool {
	return z == ""
}

// MaxSize returns a maximum valid message size for this message type
func DisconnectReasonMaxSize() (s int) {
	panic("Unable to determine max size: String type string(z) is unbounded")
}

// MarshalMsg implements msgp.Marshaler
func (z *identityChallenge) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0002Len := uint32(3)
	var zb0002Mask uint8 /* 4 bits */
	if len((*z).PublicAddress) == 0 {
		zb0002Len--
		zb0002Mask |= 0x2
	}
	if (*z).Challenge == (identityChallengeValue{}) {
		zb0002Len--
		zb0002Mask |= 0x4
	}
	if (*z).Key.MsgIsZero() {
		zb0002Len--
		zb0002Mask |= 0x8
	}
	// variable map header, size zb0002Len
	o = append(o, 0x80|uint8(zb0002Len))
	if zb0002Len != 0 {
		if (zb0002Mask & 0x2) == 0 { // if not empty
			// string "a"
			o = append(o, 0xa1, 0x61)
			o = msgp.AppendBytes(o, (*z).PublicAddress)
		}
		if (zb0002Mask & 0x4) == 0 { // if not empty
			// string "c"
			o = append(o, 0xa1, 0x63)
			o = msgp.AppendBytes(o, ((*z).Challenge)[:])
		}
		if (zb0002Mask & 0x8) == 0 { // if not empty
			// string "pk"
			o = append(o, 0xa2, 0x70, 0x6b)
			o = (*z).Key.MarshalMsg(o)
		}
	}
	return
}

func (_ *identityChallenge) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*identityChallenge)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *identityChallenge) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0002 int
	var zb0003 bool
	zb0002, zb0003, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0002, zb0003, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 > 0 {
			zb0002--
			bts, err = (*z).Key.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Key")
				return
			}
		}
		if zb0002 > 0 {
			zb0002--
			bts, err = msgp.ReadExactBytes(bts, ((*z).Challenge)[:])
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Challenge")
				return
			}
		}
		if zb0002 > 0 {
			zb0002--
			var zb0004 int
			zb0004, err = msgp.ReadBytesBytesHeader(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "PublicAddress")
				return
			}
			if zb0004 > maxAddressLen {
				err = msgp.ErrOverflow(uint64(zb0004), uint64(maxAddressLen))
				return
			}
			(*z).PublicAddress, bts, err = msgp.ReadBytesBytes(bts, (*z).PublicAddress)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "PublicAddress")
				return
			}
		}
		if zb0002 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0002)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0003 {
			(*z) = identityChallenge{}
		}
		for zb0002 > 0 {
			zb0002--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "pk":
				bts, err = (*z).Key.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Key")
					return
				}
			case "c":
				bts, err = msgp.ReadExactBytes(bts, ((*z).Challenge)[:])
				if err != nil {
					err = msgp.WrapError(err, "Challenge")
					return
				}
			case "a":
				var zb0005 int
				zb0005, err = msgp.ReadBytesBytesHeader(bts)
				if err != nil {
					err = msgp.WrapError(err, "PublicAddress")
					return
				}
				if zb0005 > maxAddressLen {
					err = msgp.ErrOverflow(uint64(zb0005), uint64(maxAddressLen))
					return
				}
				(*z).PublicAddress, bts, err = msgp.ReadBytesBytes(bts, (*z).PublicAddress)
				if err != nil {
					err = msgp.WrapError(err, "PublicAddress")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *identityChallenge) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *identityChallenge) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*identityChallenge)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *identityChallenge) Msgsize() (s int) {
	s = 1 + 3 + (*z).Key.Msgsize() + 2 + msgp.ArrayHeaderSize + (32 * (msgp.ByteSize)) + 2 + msgp.BytesPrefixSize + len((*z).PublicAddress)
	return
}

// MsgIsZero returns whether this is a zero value
func (z *identityChallenge) MsgIsZero() bool {
	return ((*z).Key.MsgIsZero()) && ((*z).Challenge == (identityChallengeValue{})) && (len((*z).PublicAddress) == 0)
}

// MaxSize returns a maximum valid message size for this message type
func IdentityChallengeMaxSize() (s int) {
	s = 1 + 3 + crypto.PublicKeyMaxSize() + 2
	// Calculating size of array: z.Challenge
	s += msgp.ArrayHeaderSize + ((32) * (msgp.ByteSize))
	s += 2 + msgp.BytesPrefixSize + maxAddressLen
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *identityChallengeResponse) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0003Len := uint32(3)
	var zb0003Mask uint8 /* 4 bits */
	if (*z).Challenge == (identityChallengeValue{}) {
		zb0003Len--
		zb0003Mask |= 0x2
	}
	if (*z).Key.MsgIsZero() {
		zb0003Len--
		zb0003Mask |= 0x4
	}
	if (*z).ResponseChallenge == (identityChallengeValue{}) {
		zb0003Len--
		zb0003Mask |= 0x8
	}
	// variable map header, size zb0003Len
	o = append(o, 0x80|uint8(zb0003Len))
	if zb0003Len != 0 {
		if (zb0003Mask & 0x2) == 0 { // if not empty
			// string "c"
			o = append(o, 0xa1, 0x63)
			o = msgp.AppendBytes(o, ((*z).Challenge)[:])
		}
		if (zb0003Mask & 0x4) == 0 { // if not empty
			// string "pk"
			o = append(o, 0xa2, 0x70, 0x6b)
			o = (*z).Key.MarshalMsg(o)
		}
		if (zb0003Mask & 0x8) == 0 { // if not empty
			// string "rc"
			o = append(o, 0xa2, 0x72, 0x63)
			o = msgp.AppendBytes(o, ((*z).ResponseChallenge)[:])
		}
	}
	return
}

func (_ *identityChallengeResponse) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*identityChallengeResponse)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *identityChallengeResponse) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0003 int
	var zb0004 bool
	zb0003, zb0004, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0003, zb0004, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0003 > 0 {
			zb0003--
			bts, err = (*z).Key.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Key")
				return
			}
		}
		if zb0003 > 0 {
			zb0003--
			bts, err = msgp.ReadExactBytes(bts, ((*z).Challenge)[:])
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Challenge")
				return
			}
		}
		if zb0003 > 0 {
			zb0003--
			bts, err = msgp.ReadExactBytes(bts, ((*z).ResponseChallenge)[:])
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "ResponseChallenge")
				return
			}
		}
		if zb0003 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0003)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0004 {
			(*z) = identityChallengeResponse{}
		}
		for zb0003 > 0 {
			zb0003--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "pk":
				bts, err = (*z).Key.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Key")
					return
				}
			case "c":
				bts, err = msgp.ReadExactBytes(bts, ((*z).Challenge)[:])
				if err != nil {
					err = msgp.WrapError(err, "Challenge")
					return
				}
			case "rc":
				bts, err = msgp.ReadExactBytes(bts, ((*z).ResponseChallenge)[:])
				if err != nil {
					err = msgp.WrapError(err, "ResponseChallenge")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *identityChallengeResponse) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *identityChallengeResponse) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*identityChallengeResponse)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *identityChallengeResponse) Msgsize() (s int) {
	s = 1 + 3 + (*z).Key.Msgsize() + 2 + msgp.ArrayHeaderSize + (32 * (msgp.ByteSize)) + 3 + msgp.ArrayHeaderSize + (32 * (msgp.ByteSize))
	return
}

// MsgIsZero returns whether this is a zero value
func (z *identityChallengeResponse) MsgIsZero() bool {
	return ((*z).Key.MsgIsZero()) && ((*z).Challenge == (identityChallengeValue{})) && ((*z).ResponseChallenge == (identityChallengeValue{}))
}

// MaxSize returns a maximum valid message size for this message type
func IdentityChallengeResponseMaxSize() (s int) {
	s = 1 + 3 + crypto.PublicKeyMaxSize() + 2
	// Calculating size of array: z.Challenge
	s += msgp.ArrayHeaderSize + ((32) * (msgp.ByteSize))
	s += 3
	// Calculating size of array: z.ResponseChallenge
	s += msgp.ArrayHeaderSize + ((32) * (msgp.ByteSize))
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *identityChallengeResponseSigned) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0001Len := uint32(2)
	var zb0001Mask uint8 /* 3 bits */
	if (*z).Msg.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x2
	}
	if (*z).Signature.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x4
	}
	// variable map header, size zb0001Len
	o = append(o, 0x80|uint8(zb0001Len))
	if zb0001Len != 0 {
		if (zb0001Mask & 0x2) == 0 { // if not empty
			// string "icr"
			o = append(o, 0xa3, 0x69, 0x63, 0x72)
			o = (*z).Msg.MarshalMsg(o)
		}
		if (zb0001Mask & 0x4) == 0 { // if not empty
			// string "sig"
			o = append(o, 0xa3, 0x73, 0x69, 0x67)
			o = (*z).Signature.MarshalMsg(o)
		}
	}
	return
}

func (_ *identityChallengeResponseSigned) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*identityChallengeResponseSigned)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *identityChallengeResponseSigned) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0001 int
	var zb0002 bool
	zb0001, zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0001, zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).Msg.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Msg")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).Signature.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Signature")
				return
			}
		}
		if zb0001 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0001)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 {
			(*z) = identityChallengeResponseSigned{}
		}
		for zb0001 > 0 {
			zb0001--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "icr":
				bts, err = (*z).Msg.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Msg")
					return
				}
			case "sig":
				bts, err = (*z).Signature.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Signature")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *identityChallengeResponseSigned) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *identityChallengeResponseSigned) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*identityChallengeResponseSigned)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *identityChallengeResponseSigned) Msgsize() (s int) {
	s = 1 + 4 + (*z).Msg.Msgsize() + 4 + (*z).Signature.Msgsize()
	return
}

// MsgIsZero returns whether this is a zero value
func (z *identityChallengeResponseSigned) MsgIsZero() bool {
	return ((*z).Msg.MsgIsZero()) && ((*z).Signature.MsgIsZero())
}

// MaxSize returns a maximum valid message size for this message type
func IdentityChallengeResponseSignedMaxSize() (s int) {
	s = 1 + 4 + IdentityChallengeResponseMaxSize() + 4 + crypto.SignatureMaxSize()
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *identityChallengeSigned) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0001Len := uint32(2)
	var zb0001Mask uint8 /* 3 bits */
	if (*z).Msg.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x2
	}
	if (*z).Signature.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x4
	}
	// variable map header, size zb0001Len
	o = append(o, 0x80|uint8(zb0001Len))
	if zb0001Len != 0 {
		if (zb0001Mask & 0x2) == 0 { // if not empty
			// string "ic"
			o = append(o, 0xa2, 0x69, 0x63)
			o = (*z).Msg.MarshalMsg(o)
		}
		if (zb0001Mask & 0x4) == 0 { // if not empty
			// string "sig"
			o = append(o, 0xa3, 0x73, 0x69, 0x67)
			o = (*z).Signature.MarshalMsg(o)
		}
	}
	return
}

func (_ *identityChallengeSigned) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*identityChallengeSigned)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *identityChallengeSigned) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0001 int
	var zb0002 bool
	zb0001, zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0001, zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).Msg.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Msg")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).Signature.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Signature")
				return
			}
		}
		if zb0001 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0001)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 {
			(*z) = identityChallengeSigned{}
		}
		for zb0001 > 0 {
			zb0001--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "ic":
				bts, err = (*z).Msg.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Msg")
					return
				}
			case "sig":
				bts, err = (*z).Signature.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Signature")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *identityChallengeSigned) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *identityChallengeSigned) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*identityChallengeSigned)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *identityChallengeSigned) Msgsize() (s int) {
	s = 1 + 3 + (*z).Msg.Msgsize() + 4 + (*z).Signature.Msgsize()
	return
}

// MsgIsZero returns whether this is a zero value
func (z *identityChallengeSigned) MsgIsZero() bool {
	return ((*z).Msg.MsgIsZero()) && ((*z).Signature.MsgIsZero())
}

// MaxSize returns a maximum valid message size for this message type
func IdentityChallengeSignedMaxSize() (s int) {
	s = 1 + 3 + IdentityChallengeMaxSize() + 4 + crypto.SignatureMaxSize()
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *identityChallengeValue) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	o = msgp.AppendBytes(o, (*z)[:])
	return
}

func (_ *identityChallengeValue) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*identityChallengeValue)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *identityChallengeValue) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	bts, err = msgp.ReadExactBytes(bts, (*z)[:])
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	o = bts
	return
}

func (z *identityChallengeValue) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *identityChallengeValue) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*identityChallengeValue)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *identityChallengeValue) Msgsize() (s int) {
	s = msgp.ArrayHeaderSize + (32 * (msgp.ByteSize))
	return
}

// MsgIsZero returns whether this is a zero value
func (z *identityChallengeValue) MsgIsZero() bool {
	return (*z) == (identityChallengeValue{})
}

// MaxSize returns a maximum valid message size for this message type
func IdentityChallengeValueMaxSize() (s int) {
	// Calculating size of array: z
	s = msgp.ArrayHeaderSize + ((32) * (msgp.ByteSize))
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *identityVerificationMessage) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0002Len := uint32(1)
	var zb0002Mask uint8 /* 2 bits */
	if (*z).ResponseChallenge == (identityChallengeValue{}) {
		zb0002Len--
		zb0002Mask |= 0x2
	}
	// variable map header, size zb0002Len
	o = append(o, 0x80|uint8(zb0002Len))
	if zb0002Len != 0 {
		if (zb0002Mask & 0x2) == 0 { // if not empty
			// string "rc"
			o = append(o, 0xa2, 0x72, 0x63)
			o = msgp.AppendBytes(o, ((*z).ResponseChallenge)[:])
		}
	}
	return
}

func (_ *identityVerificationMessage) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*identityVerificationMessage)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *identityVerificationMessage) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0002 int
	var zb0003 bool
	zb0002, zb0003, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0002, zb0003, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 > 0 {
			zb0002--
			bts, err = msgp.ReadExactBytes(bts, ((*z).ResponseChallenge)[:])
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "ResponseChallenge")
				return
			}
		}
		if zb0002 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0002)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0003 {
			(*z) = identityVerificationMessage{}
		}
		for zb0002 > 0 {
			zb0002--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "rc":
				bts, err = msgp.ReadExactBytes(bts, ((*z).ResponseChallenge)[:])
				if err != nil {
					err = msgp.WrapError(err, "ResponseChallenge")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *identityVerificationMessage) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *identityVerificationMessage) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*identityVerificationMessage)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *identityVerificationMessage) Msgsize() (s int) {
	s = 1 + 3 + msgp.ArrayHeaderSize + (32 * (msgp.ByteSize))
	return
}

// MsgIsZero returns whether this is a zero value
func (z *identityVerificationMessage) MsgIsZero() bool {
	return ((*z).ResponseChallenge == (identityChallengeValue{}))
}

// MaxSize returns a maximum valid message size for this message type
func IdentityVerificationMessageMaxSize() (s int) {
	s = 1 + 3
	// Calculating size of array: z.ResponseChallenge
	s += msgp.ArrayHeaderSize + ((32) * (msgp.ByteSize))
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *identityVerificationMessageSigned) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0002Len := uint32(2)
	var zb0002Mask uint8 /* 3 bits */
	if (*z).Msg.ResponseChallenge == (identityChallengeValue{}) {
		zb0002Len--
		zb0002Mask |= 0x2
	}
	if (*z).Signature.MsgIsZero() {
		zb0002Len--
		zb0002Mask |= 0x4
	}
	// variable map header, size zb0002Len
	o = append(o, 0x80|uint8(zb0002Len))
	if zb0002Len != 0 {
		if (zb0002Mask & 0x2) == 0 { // if not empty
			// string "ivm"
			o = append(o, 0xa3, 0x69, 0x76, 0x6d)
			// omitempty: check for empty values
			zb0003Len := uint32(1)
			var zb0003Mask uint8 /* 2 bits */
			if (*z).Msg.ResponseChallenge == (identityChallengeValue{}) {
				zb0003Len--
				zb0003Mask |= 0x2
			}
			// variable map header, size zb0003Len
			o = append(o, 0x80|uint8(zb0003Len))
			if (zb0003Mask & 0x2) == 0 { // if not empty
				// string "rc"
				o = append(o, 0xa2, 0x72, 0x63)
				o = msgp.AppendBytes(o, ((*z).Msg.ResponseChallenge)[:])
			}
		}
		if (zb0002Mask & 0x4) == 0 { // if not empty
			// string "sig"
			o = append(o, 0xa3, 0x73, 0x69, 0x67)
			o = (*z).Signature.MarshalMsg(o)
		}
	}
	return
}

func (_ *identityVerificationMessageSigned) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*identityVerificationMessageSigned)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *identityVerificationMessageSigned) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0002 int
	var zb0003 bool
	zb0002, zb0003, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0002, zb0003, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 > 0 {
			zb0002--
			var zb0004 int
			var zb0005 bool
			zb0004, zb0005, bts, err = msgp.ReadMapHeaderBytes(bts)
			if _, ok := err.(msgp.TypeError); ok {
				zb0004, zb0005, bts, err = msgp.ReadArrayHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Msg")
					return
				}
				if zb0004 > 0 {
					zb0004--
					bts, err = msgp.ReadExactBytes(bts, ((*z).Msg.ResponseChallenge)[:])
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "Msg", "struct-from-array", "ResponseChallenge")
						return
					}
				}
				if zb0004 > 0 {
					err = msgp.ErrTooManyArrayFields(zb0004)
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "Msg", "struct-from-array")
						return
					}
				}
			} else {
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Msg")
					return
				}
				if zb0005 {
					(*z).Msg = identityVerificationMessage{}
				}
				for zb0004 > 0 {
					zb0004--
					field, bts, err = msgp.ReadMapKeyZC(bts)
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "Msg")
						return
					}
					switch string(field) {
					case "rc":
						bts, err = msgp.ReadExactBytes(bts, ((*z).Msg.ResponseChallenge)[:])
						if err != nil {
							err = msgp.WrapError(err, "struct-from-array", "Msg", "ResponseChallenge")
							return
						}
					default:
						err = msgp.ErrNoField(string(field))
						if err != nil {
							err = msgp.WrapError(err, "struct-from-array", "Msg")
							return
						}
					}
				}
			}
		}
		if zb0002 > 0 {
			zb0002--
			bts, err = (*z).Signature.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Signature")
				return
			}
		}
		if zb0002 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0002)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0003 {
			(*z) = identityVerificationMessageSigned{}
		}
		for zb0002 > 0 {
			zb0002--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "ivm":
				var zb0006 int
				var zb0007 bool
				zb0006, zb0007, bts, err = msgp.ReadMapHeaderBytes(bts)
				if _, ok := err.(msgp.TypeError); ok {
					zb0006, zb0007, bts, err = msgp.ReadArrayHeaderBytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "Msg")
						return
					}
					if zb0006 > 0 {
						zb0006--
						bts, err = msgp.ReadExactBytes(bts, ((*z).Msg.ResponseChallenge)[:])
						if err != nil {
							err = msgp.WrapError(err, "Msg", "struct-from-array", "ResponseChallenge")
							return
						}
					}
					if zb0006 > 0 {
						err = msgp.ErrTooManyArrayFields(zb0006)
						if err != nil {
							err = msgp.WrapError(err, "Msg", "struct-from-array")
							return
						}
					}
				} else {
					if err != nil {
						err = msgp.WrapError(err, "Msg")
						return
					}
					if zb0007 {
						(*z).Msg = identityVerificationMessage{}
					}
					for zb0006 > 0 {
						zb0006--
						field, bts, err = msgp.ReadMapKeyZC(bts)
						if err != nil {
							err = msgp.WrapError(err, "Msg")
							return
						}
						switch string(field) {
						case "rc":
							bts, err = msgp.ReadExactBytes(bts, ((*z).Msg.ResponseChallenge)[:])
							if err != nil {
								err = msgp.WrapError(err, "Msg", "ResponseChallenge")
								return
							}
						default:
							err = msgp.ErrNoField(string(field))
							if err != nil {
								err = msgp.WrapError(err, "Msg")
								return
							}
						}
					}
				}
			case "sig":
				bts, err = (*z).Signature.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Signature")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *identityVerificationMessageSigned) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *identityVerificationMessageSigned) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*identityVerificationMessageSigned)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *identityVerificationMessageSigned) Msgsize() (s int) {
	s = 1 + 4 + 1 + 3 + msgp.ArrayHeaderSize + (32 * (msgp.ByteSize)) + 4 + (*z).Signature.Msgsize()
	return
}

// MsgIsZero returns whether this is a zero value
func (z *identityVerificationMessageSigned) MsgIsZero() bool {
	return ((*z).Msg.ResponseChallenge == (identityChallengeValue{})) && ((*z).Signature.MsgIsZero())
}

// MaxSize returns a maximum valid message size for this message type
func IdentityVerificationMessageSignedMaxSize() (s int) {
	s = 1 + 4 + 1 + 3
	// Calculating size of array: z.Msg.ResponseChallenge
	s += msgp.ArrayHeaderSize + ((32) * (msgp.ByteSize))
	s += 4 + crypto.SignatureMaxSize()
	return
}

// MarshalMsg implements msgp.Marshaler
func (z peerMetaHeaders) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	if z == nil {
		o = msgp.AppendNil(o)
	} else {
		o = msgp.AppendMapHeader(o, uint32(len(z)))
	}
	za0006_keys := make([]string, 0, len(z))
	for za0006 := range z {
		za0006_keys = append(za0006_keys, za0006)
	}
	sort.Sort(SortString(za0006_keys))
	for _, za0006 := range za0006_keys {
		za0007 := z[za0006]
		_ = za0007
		o = msgp.AppendString(o, za0006)
		if za0007 == nil {
			o = msgp.AppendNil(o)
		} else {
			o = msgp.AppendArrayHeader(o, uint32(len(za0007)))
		}
		for za0008 := range za0007 {
			o = msgp.AppendString(o, za0007[za0008])
		}
	}
	return
}

func (_ peerMetaHeaders) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(peerMetaHeaders)
	if !ok {
		_, ok = (z).(*peerMetaHeaders)
	}
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *peerMetaHeaders) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var zb0004 int
	var zb0005 bool
	zb0004, zb0005, bts, err = msgp.ReadMapHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	if zb0004 > maxHeaderKeys {
		err = msgp.ErrOverflow(uint64(zb0004), uint64(maxHeaderKeys))
		err = msgp.WrapError(err)
		return
	}
	if zb0005 {
		(*z) = nil
	} else if (*z) == nil {
		(*z) = make(peerMetaHeaders, zb0004)
	}
	for zb0004 > 0 {
		var zb0001 string
		var zb0002 peerMetaValues
		zb0004--
		zb0001, bts, err = msgp.ReadStringBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		var zb0006 int
		var zb0007 bool
		zb0006, zb0007, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err, zb0001)
			return
		}
		if zb0006 > maxHeaderValues {
			err = msgp.ErrOverflow(uint64(zb0006), uint64(maxHeaderValues))
			err = msgp.WrapError(err, zb0001)
			return
		}
		if zb0007 {
			zb0002 = nil
		} else if zb0002 != nil && cap(zb0002) >= zb0006 {
			zb0002 = (zb0002)[:zb0006]
		} else {
			zb0002 = make(peerMetaValues, zb0006)
		}
		for zb0003 := range zb0002 {
			zb0002[zb0003], bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, zb0001, zb0003)
				return
			}
		}
		(*z)[zb0001] = zb0002
	}
	o = bts
	return
}

func (z *peerMetaHeaders) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *peerMetaHeaders) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*peerMetaHeaders)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z peerMetaHeaders) Msgsize() (s int) {
	s = msgp.MapHeaderSize
	if z != nil {
		for za0006, za0007 := range z {
			_ = za0006
			_ = za0007
			s += 0 + msgp.StringPrefixSize + len(za0006) + msgp.ArrayHeaderSize
			for za0008 := range za0007 {
				s += msgp.StringPrefixSize + len(za0007[za0008])
			}
		}
	}
	return
}

// MsgIsZero returns whether this is a zero value
func (z peerMetaHeaders) MsgIsZero() bool {
	return len(z) == 0
}

// MaxSize returns a maximum valid message size for this message type
func PeerMetaHeadersMaxSize() (s int) {
	s += msgp.MapHeaderSize
	// Adding size of map keys for z
	s += maxHeaderKeys
	panic("Unable to determine max size: String type za0006 is unbounded")
}

// MarshalMsg implements msgp.Marshaler
func (z peerMetaValues) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	if z == nil {
		o = msgp.AppendNil(o)
	} else {
		o = msgp.AppendArrayHeader(o, uint32(len(z)))
	}
	for za0001 := range z {
		o = msgp.AppendString(o, z[za0001])
	}
	return
}

func (_ peerMetaValues) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(peerMetaValues)
	if !ok {
		_, ok = (z).(*peerMetaValues)
	}
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *peerMetaValues) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var zb0002 int
	var zb0003 bool
	zb0002, zb0003, bts, err = msgp.ReadArrayHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	if zb0002 > maxHeaderValues {
		err = msgp.ErrOverflow(uint64(zb0002), uint64(maxHeaderValues))
		err = msgp.WrapError(err)
		return
	}
	if zb0003 {
		(*z) = nil
	} else if (*z) != nil && cap((*z)) >= zb0002 {
		(*z) = (*z)[:zb0002]
	} else {
		(*z) = make(peerMetaValues, zb0002)
	}
	for zb0001 := range *z {
		(*z)[zb0001], bts, err = msgp.ReadStringBytes(bts)
		if err != nil {
			err = msgp.WrapError(err, zb0001)
			return
		}
	}
	o = bts
	return
}

func (z *peerMetaValues) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *peerMetaValues) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*peerMetaValues)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z peerMetaValues) Msgsize() (s int) {
	s = msgp.ArrayHeaderSize
	for za0001 := range z {
		s += msgp.StringPrefixSize + len(z[za0001])
	}
	return
}

// MsgIsZero returns whether this is a zero value
func (z peerMetaValues) MsgIsZero() bool {
	return len(z) == 0
}

// MaxSize returns a maximum valid message size for this message type
func PeerMetaValuesMaxSize() (s int) {
	// Calculating size of slice: z
	s += msgp.ArrayHeaderSize
	panic("Unable to determine max size: String type is unbounded for z[za0001]")
}
