package account

// Code generated by github.com/algorand/msgp DO NOT EDIT.

import (
	"github.com/algorand/msgp/msgp"

	"github.com/algorand/go-algorand/crypto"
	"github.com/algorand/go-algorand/crypto/merklesignature"
	"github.com/algorand/go-algorand/data/basics"
)

// The following msgp objects are implemented in this file:
// ParticipationKeyIdentity
//             |-----> (*) MarshalMsg
//             |-----> (*) CanMarshalMsg
//             |-----> (*) UnmarshalMsg
//             |-----> (*) UnmarshalMsgWithState
//             |-----> (*) CanUnmarshalMsg
//             |-----> (*) Msgsize
//             |-----> (*) MsgIsZero
//             |-----> ParticipationKeyIdentityMaxSize()
//
// StateProofKeys
//        |-----> MarshalMsg
//        |-----> CanMarshalMsg
//        |-----> (*) UnmarshalMsg
//        |-----> (*) UnmarshalMsgWithState
//        |-----> (*) CanUnmarshalMsg
//        |-----> Msgsize
//        |-----> MsgIsZero
//        |-----> StateProofKeysMaxSize()
//

// MarshalMsg implements msgp.Marshaler
func (z *ParticipationKeyIdentity) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0001Len := uint32(6)
	var zb0001Mask uint8 /* 7 bits */
	if (*z).Parent.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x2
	}
	if (*z).FirstValid.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x4
	}
	if (*z).KeyDilution == 0 {
		zb0001Len--
		zb0001Mask |= 0x8
	}
	if (*z).LastValid.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x10
	}
	if (*z).VoteID.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x20
	}
	if (*z).VRFSK.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x40
	}
	// variable map header, size zb0001Len
	o = append(o, 0x80|uint8(zb0001Len))
	if zb0001Len != 0 {
		if (zb0001Mask & 0x2) == 0 { // if not empty
			// string "addr"
			o = append(o, 0xa4, 0x61, 0x64, 0x64, 0x72)
			o = (*z).Parent.MarshalMsg(o)
		}
		if (zb0001Mask & 0x4) == 0 { // if not empty
			// string "fv"
			o = append(o, 0xa2, 0x66, 0x76)
			o = (*z).FirstValid.MarshalMsg(o)
		}
		if (zb0001Mask & 0x8) == 0 { // if not empty
			// string "kd"
			o = append(o, 0xa2, 0x6b, 0x64)
			o = msgp.AppendUint64(o, (*z).KeyDilution)
		}
		if (zb0001Mask & 0x10) == 0 { // if not empty
			// string "lv"
			o = append(o, 0xa2, 0x6c, 0x76)
			o = (*z).LastValid.MarshalMsg(o)
		}
		if (zb0001Mask & 0x20) == 0 { // if not empty
			// string "vote-id"
			o = append(o, 0xa7, 0x76, 0x6f, 0x74, 0x65, 0x2d, 0x69, 0x64)
			o = (*z).VoteID.MarshalMsg(o)
		}
		if (zb0001Mask & 0x40) == 0 { // if not empty
			// string "vrfsk"
			o = append(o, 0xa5, 0x76, 0x72, 0x66, 0x73, 0x6b)
			o = (*z).VRFSK.MarshalMsg(o)
		}
	}
	return
}

func (_ *ParticipationKeyIdentity) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*ParticipationKeyIdentity)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *ParticipationKeyIdentity) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0001 int
	var zb0002 bool
	zb0001, zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0001, zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).Parent.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Parent")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).VRFSK.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "VRFSK")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).VoteID.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "VoteID")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).FirstValid.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "FirstValid")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).LastValid.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "LastValid")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			(*z).KeyDilution, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "KeyDilution")
				return
			}
		}
		if zb0001 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0001)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 {
			(*z) = ParticipationKeyIdentity{}
		}
		for zb0001 > 0 {
			zb0001--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "addr":
				bts, err = (*z).Parent.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Parent")
					return
				}
			case "vrfsk":
				bts, err = (*z).VRFSK.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "VRFSK")
					return
				}
			case "vote-id":
				bts, err = (*z).VoteID.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "VoteID")
					return
				}
			case "fv":
				bts, err = (*z).FirstValid.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "FirstValid")
					return
				}
			case "lv":
				bts, err = (*z).LastValid.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "LastValid")
					return
				}
			case "kd":
				(*z).KeyDilution, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "KeyDilution")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *ParticipationKeyIdentity) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *ParticipationKeyIdentity) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*ParticipationKeyIdentity)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *ParticipationKeyIdentity) Msgsize() (s int) {
	s = 1 + 5 + (*z).Parent.Msgsize() + 6 + (*z).VRFSK.Msgsize() + 8 + (*z).VoteID.Msgsize() + 3 + (*z).FirstValid.Msgsize() + 3 + (*z).LastValid.Msgsize() + 3 + msgp.Uint64Size
	return
}

// MsgIsZero returns whether this is a zero value
func (z *ParticipationKeyIdentity) MsgIsZero() bool {
	return ((*z).Parent.MsgIsZero()) && ((*z).VRFSK.MsgIsZero()) && ((*z).VoteID.MsgIsZero()) && ((*z).FirstValid.MsgIsZero()) && ((*z).LastValid.MsgIsZero()) && ((*z).KeyDilution == 0)
}

// MaxSize returns a maximum valid message size for this message type
func ParticipationKeyIdentityMaxSize() (s int) {
	s = 1 + 5 + basics.AddressMaxSize() + 6 + crypto.VrfPrivkeyMaxSize() + 8 + crypto.OneTimeSignatureVerifierMaxSize() + 3 + basics.RoundMaxSize() + 3 + basics.RoundMaxSize() + 3 + msgp.Uint64Size
	return
}

// MarshalMsg implements msgp.Marshaler
func (z StateProofKeys) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	if z == nil {
		o = msgp.AppendNil(o)
	} else {
		o = msgp.AppendArrayHeader(o, uint32(len(z)))
	}
	for za0001 := range z {
		o = z[za0001].MarshalMsg(o)
	}
	return
}

func (_ StateProofKeys) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(StateProofKeys)
	if !ok {
		_, ok = (z).(*StateProofKeys)
	}
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *StateProofKeys) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var zb0002 int
	var zb0003 bool
	zb0002, zb0003, bts, err = msgp.ReadArrayHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	if zb0002 > 1000 {
		err = msgp.ErrOverflow(uint64(zb0002), uint64(1000))
		err = msgp.WrapError(err)
		return
	}
	if zb0003 {
		(*z) = nil
	} else if (*z) != nil && cap((*z)) >= zb0002 {
		(*z) = (*z)[:zb0002]
	} else {
		(*z) = make(StateProofKeys, zb0002)
	}
	for zb0001 := range *z {
		bts, err = (*z)[zb0001].UnmarshalMsgWithState(bts, st)
		if err != nil {
			err = msgp.WrapError(err, zb0001)
			return
		}
	}
	o = bts
	return
}

func (z *StateProofKeys) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *StateProofKeys) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*StateProofKeys)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z StateProofKeys) Msgsize() (s int) {
	s = msgp.ArrayHeaderSize
	for za0001 := range z {
		s += z[za0001].Msgsize()
	}
	return
}

// MsgIsZero returns whether this is a zero value
func (z StateProofKeys) MsgIsZero() bool {
	return len(z) == 0
}

// MaxSize returns a maximum valid message size for this message type
func StateProofKeysMaxSize() (s int) {
	// Calculating size of slice: z
	s += msgp.ArrayHeaderSize + ((1000) * (merklesignature.KeyRoundPairMaxSize()))
	return
}
