package transactions

// Code generated by github.com/algorand/msgp DO NOT EDIT.

import (
	"sort"

	"github.com/algorand/msgp/msgp"

	"github.com/algorand/go-algorand/config/bounds"
	"github.com/algorand/go-algorand/crypto"
	"github.com/algorand/go-algorand/crypto/merklesignature"
	"github.com/algorand/go-algorand/crypto/stateproof"
	"github.com/algorand/go-algorand/data/basics"
	"github.com/algorand/go-algorand/data/committee"
	"github.com/algorand/go-algorand/data/stateproofmsg"
	"github.com/algorand/go-algorand/protocol"
)

// The following msgp objects are implemented in this file:
// ApplicationCallTxnFields
//             |-----> (*) MarshalMsg
//             |-----> (*) CanMarshalMsg
//             |-----> (*) UnmarshalMsg
//             |-----> (*) UnmarshalMsgWithState
//             |-----> (*) CanUnmarshalMsg
//             |-----> (*) Msgsize
//             |-----> (*) MsgIsZero
//             |-----> ApplicationCallTxnFieldsMaxSize()
//
// ApplyData
//     |-----> (*) MarshalMsg
//     |-----> (*) CanMarshalMsg
//     |-----> (*) UnmarshalMsg
//     |-----> (*) UnmarshalMsgWithState
//     |-----> (*) CanUnmarshalMsg
//     |-----> (*) Msgsize
//     |-----> (*) MsgIsZero
//     |-----> ApplyDataMaxSize()
//
// AssetConfigTxnFields
//           |-----> (*) MarshalMsg
//           |-----> (*) CanMarshalMsg
//           |-----> (*) UnmarshalMsg
//           |-----> (*) UnmarshalMsgWithState
//           |-----> (*) CanUnmarshalMsg
//           |-----> (*) Msgsize
//           |-----> (*) MsgIsZero
//           |-----> AssetConfigTxnFieldsMaxSize()
//
// AssetFreezeTxnFields
//           |-----> (*) MarshalMsg
//           |-----> (*) CanMarshalMsg
//           |-----> (*) UnmarshalMsg
//           |-----> (*) UnmarshalMsgWithState
//           |-----> (*) CanUnmarshalMsg
//           |-----> (*) Msgsize
//           |-----> (*) MsgIsZero
//           |-----> AssetFreezeTxnFieldsMaxSize()
//
// AssetTransferTxnFields
//            |-----> (*) MarshalMsg
//            |-----> (*) CanMarshalMsg
//            |-----> (*) UnmarshalMsg
//            |-----> (*) UnmarshalMsgWithState
//            |-----> (*) CanUnmarshalMsg
//            |-----> (*) Msgsize
//            |-----> (*) MsgIsZero
//            |-----> AssetTransferTxnFieldsMaxSize()
//
// BoxRef
//    |-----> (*) MarshalMsg
//    |-----> (*) CanMarshalMsg
//    |-----> (*) UnmarshalMsg
//    |-----> (*) UnmarshalMsgWithState
//    |-----> (*) CanUnmarshalMsg
//    |-----> (*) Msgsize
//    |-----> (*) MsgIsZero
//    |-----> BoxRefMaxSize()
//
// EvalDelta
//     |-----> (*) MarshalMsg
//     |-----> (*) CanMarshalMsg
//     |-----> (*) UnmarshalMsg
//     |-----> (*) UnmarshalMsgWithState
//     |-----> (*) CanUnmarshalMsg
//     |-----> (*) Msgsize
//     |-----> (*) MsgIsZero
//     |-----> EvalDeltaMaxSize()
//
// Header
//    |-----> (*) MarshalMsg
//    |-----> (*) CanMarshalMsg
//    |-----> (*) UnmarshalMsg
//    |-----> (*) UnmarshalMsgWithState
//    |-----> (*) CanUnmarshalMsg
//    |-----> (*) Msgsize
//    |-----> (*) MsgIsZero
//    |-----> HeaderMaxSize()
//
// HeartbeatTxnFields
//          |-----> (*) MarshalMsg
//          |-----> (*) CanMarshalMsg
//          |-----> (*) UnmarshalMsg
//          |-----> (*) UnmarshalMsgWithState
//          |-----> (*) CanUnmarshalMsg
//          |-----> (*) Msgsize
//          |-----> (*) MsgIsZero
//          |-----> HeartbeatTxnFieldsMaxSize()
//
// HoldingRef
//      |-----> (*) MarshalMsg
//      |-----> (*) CanMarshalMsg
//      |-----> (*) UnmarshalMsg
//      |-----> (*) UnmarshalMsgWithState
//      |-----> (*) CanUnmarshalMsg
//      |-----> (*) Msgsize
//      |-----> (*) MsgIsZero
//      |-----> HoldingRefMaxSize()
//
// KeyregTxnFields
//        |-----> (*) MarshalMsg
//        |-----> (*) CanMarshalMsg
//        |-----> (*) UnmarshalMsg
//        |-----> (*) UnmarshalMsgWithState
//        |-----> (*) CanUnmarshalMsg
//        |-----> (*) Msgsize
//        |-----> (*) MsgIsZero
//        |-----> KeyregTxnFieldsMaxSize()
//
// LocalsRef
//     |-----> (*) MarshalMsg
//     |-----> (*) CanMarshalMsg
//     |-----> (*) UnmarshalMsg
//     |-----> (*) UnmarshalMsgWithState
//     |-----> (*) CanUnmarshalMsg
//     |-----> (*) Msgsize
//     |-----> (*) MsgIsZero
//     |-----> LocalsRefMaxSize()
//
// LogicSig
//     |-----> (*) MarshalMsg
//     |-----> (*) CanMarshalMsg
//     |-----> (*) UnmarshalMsg
//     |-----> (*) UnmarshalMsgWithState
//     |-----> (*) CanUnmarshalMsg
//     |-----> (*) Msgsize
//     |-----> (*) MsgIsZero
//     |-----> LogicSigMaxSize()
//
// OnCompletion
//       |-----> MarshalMsg
//       |-----> CanMarshalMsg
//       |-----> (*) UnmarshalMsg
//       |-----> (*) UnmarshalMsgWithState
//       |-----> (*) CanUnmarshalMsg
//       |-----> Msgsize
//       |-----> MsgIsZero
//       |-----> OnCompletionMaxSize()
//
// PaymentTxnFields
//         |-----> (*) MarshalMsg
//         |-----> (*) CanMarshalMsg
//         |-----> (*) UnmarshalMsg
//         |-----> (*) UnmarshalMsgWithState
//         |-----> (*) CanUnmarshalMsg
//         |-----> (*) Msgsize
//         |-----> (*) MsgIsZero
//         |-----> PaymentTxnFieldsMaxSize()
//
// Payset
//    |-----> MarshalMsg
//    |-----> CanMarshalMsg
//    |-----> (*) UnmarshalMsg
//    |-----> (*) UnmarshalMsgWithState
//    |-----> (*) CanUnmarshalMsg
//    |-----> Msgsize
//    |-----> MsgIsZero
//    |-----> PaysetMaxSize()
//
// ResourceRef
//      |-----> (*) MarshalMsg
//      |-----> (*) CanMarshalMsg
//      |-----> (*) UnmarshalMsg
//      |-----> (*) UnmarshalMsgWithState
//      |-----> (*) CanUnmarshalMsg
//      |-----> (*) Msgsize
//      |-----> (*) MsgIsZero
//      |-----> ResourceRefMaxSize()
//
// SignedTxn
//     |-----> (*) MarshalMsg
//     |-----> (*) CanMarshalMsg
//     |-----> (*) UnmarshalMsg
//     |-----> (*) UnmarshalMsgWithState
//     |-----> (*) CanUnmarshalMsg
//     |-----> (*) Msgsize
//     |-----> (*) MsgIsZero
//     |-----> SignedTxnMaxSize()
//
// SignedTxnInBlock
//         |-----> (*) MarshalMsg
//         |-----> (*) CanMarshalMsg
//         |-----> (*) UnmarshalMsg
//         |-----> (*) UnmarshalMsgWithState
//         |-----> (*) CanUnmarshalMsg
//         |-----> (*) Msgsize
//         |-----> (*) MsgIsZero
//         |-----> SignedTxnInBlockMaxSize()
//
// SignedTxnWithAD
//        |-----> (*) MarshalMsg
//        |-----> (*) CanMarshalMsg
//        |-----> (*) UnmarshalMsg
//        |-----> (*) UnmarshalMsgWithState
//        |-----> (*) CanUnmarshalMsg
//        |-----> (*) Msgsize
//        |-----> (*) MsgIsZero
//        |-----> SignedTxnWithADMaxSize()
//
// StateProofTxnFields
//          |-----> (*) MarshalMsg
//          |-----> (*) CanMarshalMsg
//          |-----> (*) UnmarshalMsg
//          |-----> (*) UnmarshalMsgWithState
//          |-----> (*) CanUnmarshalMsg
//          |-----> (*) Msgsize
//          |-----> (*) MsgIsZero
//          |-----> StateProofTxnFieldsMaxSize()
//
// Transaction
//      |-----> (*) MarshalMsg
//      |-----> (*) CanMarshalMsg
//      |-----> (*) UnmarshalMsg
//      |-----> (*) UnmarshalMsgWithState
//      |-----> (*) CanUnmarshalMsg
//      |-----> (*) Msgsize
//      |-----> (*) MsgIsZero
//      |-----> TransactionMaxSize()
//
// TxGroup
//    |-----> (*) MarshalMsg
//    |-----> (*) CanMarshalMsg
//    |-----> (*) UnmarshalMsg
//    |-----> (*) UnmarshalMsgWithState
//    |-----> (*) CanUnmarshalMsg
//    |-----> (*) Msgsize
//    |-----> (*) MsgIsZero
//    |-----> TxGroupMaxSize()
//
// Txid
//   |-----> (*) MarshalMsg
//   |-----> (*) CanMarshalMsg
//   |-----> (*) UnmarshalMsg
//   |-----> (*) UnmarshalMsgWithState
//   |-----> (*) CanUnmarshalMsg
//   |-----> (*) Msgsize
//   |-----> (*) MsgIsZero
//
// crypto.Digest
//       |-----> crypto.DigestMaxSize()
//

// MarshalMsg implements msgp.Marshaler
func (z *ApplicationCallTxnFields) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0007Len := uint32(14)
	var zb0007Mask uint16 /* 15 bits */
	if len((*z).Access) == 0 {
		zb0007Len--
		zb0007Mask |= 0x2
	}
	if len((*z).ApplicationArgs) == 0 {
		zb0007Len--
		zb0007Mask |= 0x4
	}
	if (*z).OnCompletion == 0 {
		zb0007Len--
		zb0007Mask |= 0x8
	}
	if len((*z).ApprovalProgram) == 0 {
		zb0007Len--
		zb0007Mask |= 0x10
	}
	if len((*z).ForeignAssets) == 0 {
		zb0007Len--
		zb0007Mask |= 0x20
	}
	if len((*z).Accounts) == 0 {
		zb0007Len--
		zb0007Mask |= 0x40
	}
	if len((*z).Boxes) == 0 {
		zb0007Len--
		zb0007Mask |= 0x80
	}
	if (*z).ExtraProgramPages == 0 {
		zb0007Len--
		zb0007Mask |= 0x100
	}
	if len((*z).ForeignApps) == 0 {
		zb0007Len--
		zb0007Mask |= 0x200
	}
	if (*z).GlobalStateSchema.MsgIsZero() {
		zb0007Len--
		zb0007Mask |= 0x400
	}
	if (*z).ApplicationID.MsgIsZero() {
		zb0007Len--
		zb0007Mask |= 0x800
	}
	if (*z).LocalStateSchema.MsgIsZero() {
		zb0007Len--
		zb0007Mask |= 0x1000
	}
	if (*z).RejectVersion == 0 {
		zb0007Len--
		zb0007Mask |= 0x2000
	}
	if len((*z).ClearStateProgram) == 0 {
		zb0007Len--
		zb0007Mask |= 0x4000
	}
	// variable map header, size zb0007Len
	o = append(o, 0x80|uint8(zb0007Len))
	if zb0007Len != 0 {
		if (zb0007Mask & 0x2) == 0 { // if not empty
			// string "al"
			o = append(o, 0xa2, 0x61, 0x6c)
			if (*z).Access == nil {
				o = msgp.AppendNil(o)
			} else {
				o = msgp.AppendArrayHeader(o, uint32(len((*z).Access)))
			}
			for zb0005 := range (*z).Access {
				o = (*z).Access[zb0005].MarshalMsg(o)
			}
		}
		if (zb0007Mask & 0x4) == 0 { // if not empty
			// string "apaa"
			o = append(o, 0xa4, 0x61, 0x70, 0x61, 0x61)
			if (*z).ApplicationArgs == nil {
				o = msgp.AppendNil(o)
			} else {
				o = msgp.AppendArrayHeader(o, uint32(len((*z).ApplicationArgs)))
			}
			for zb0001 := range (*z).ApplicationArgs {
				o = msgp.AppendBytes(o, (*z).ApplicationArgs[zb0001])
			}
		}
		if (zb0007Mask & 0x8) == 0 { // if not empty
			// string "apan"
			o = append(o, 0xa4, 0x61, 0x70, 0x61, 0x6e)
			o = msgp.AppendUint64(o, uint64((*z).OnCompletion))
		}
		if (zb0007Mask & 0x10) == 0 { // if not empty
			// string "apap"
			o = append(o, 0xa4, 0x61, 0x70, 0x61, 0x70)
			o = msgp.AppendBytes(o, (*z).ApprovalProgram)
		}
		if (zb0007Mask & 0x20) == 0 { // if not empty
			// string "apas"
			o = append(o, 0xa4, 0x61, 0x70, 0x61, 0x73)
			if (*z).ForeignAssets == nil {
				o = msgp.AppendNil(o)
			} else {
				o = msgp.AppendArrayHeader(o, uint32(len((*z).ForeignAssets)))
			}
			for zb0003 := range (*z).ForeignAssets {
				o = (*z).ForeignAssets[zb0003].MarshalMsg(o)
			}
		}
		if (zb0007Mask & 0x40) == 0 { // if not empty
			// string "apat"
			o = append(o, 0xa4, 0x61, 0x70, 0x61, 0x74)
			if (*z).Accounts == nil {
				o = msgp.AppendNil(o)
			} else {
				o = msgp.AppendArrayHeader(o, uint32(len((*z).Accounts)))
			}
			for zb0002 := range (*z).Accounts {
				o = (*z).Accounts[zb0002].MarshalMsg(o)
			}
		}
		if (zb0007Mask & 0x80) == 0 { // if not empty
			// string "apbx"
			o = append(o, 0xa4, 0x61, 0x70, 0x62, 0x78)
			if (*z).Boxes == nil {
				o = msgp.AppendNil(o)
			} else {
				o = msgp.AppendArrayHeader(o, uint32(len((*z).Boxes)))
			}
			for zb0006 := range (*z).Boxes {
				// omitempty: check for empty values
				zb0008Len := uint32(2)
				var zb0008Mask uint8 /* 3 bits */
				if (*z).Boxes[zb0006].Index == 0 {
					zb0008Len--
					zb0008Mask |= 0x2
				}
				if len((*z).Boxes[zb0006].Name) == 0 {
					zb0008Len--
					zb0008Mask |= 0x4
				}
				// variable map header, size zb0008Len
				o = append(o, 0x80|uint8(zb0008Len))
				if (zb0008Mask & 0x2) == 0 { // if not empty
					// string "i"
					o = append(o, 0xa1, 0x69)
					o = msgp.AppendUint64(o, (*z).Boxes[zb0006].Index)
				}
				if (zb0008Mask & 0x4) == 0 { // if not empty
					// string "n"
					o = append(o, 0xa1, 0x6e)
					o = msgp.AppendBytes(o, (*z).Boxes[zb0006].Name)
				}
			}
		}
		if (zb0007Mask & 0x100) == 0 { // if not empty
			// string "apep"
			o = append(o, 0xa4, 0x61, 0x70, 0x65, 0x70)
			o = msgp.AppendUint32(o, (*z).ExtraProgramPages)
		}
		if (zb0007Mask & 0x200) == 0 { // if not empty
			// string "apfa"
			o = append(o, 0xa4, 0x61, 0x70, 0x66, 0x61)
			if (*z).ForeignApps == nil {
				o = msgp.AppendNil(o)
			} else {
				o = msgp.AppendArrayHeader(o, uint32(len((*z).ForeignApps)))
			}
			for zb0004 := range (*z).ForeignApps {
				o = (*z).ForeignApps[zb0004].MarshalMsg(o)
			}
		}
		if (zb0007Mask & 0x400) == 0 { // if not empty
			// string "apgs"
			o = append(o, 0xa4, 0x61, 0x70, 0x67, 0x73)
			o = (*z).GlobalStateSchema.MarshalMsg(o)
		}
		if (zb0007Mask & 0x800) == 0 { // if not empty
			// string "apid"
			o = append(o, 0xa4, 0x61, 0x70, 0x69, 0x64)
			o = (*z).ApplicationID.MarshalMsg(o)
		}
		if (zb0007Mask & 0x1000) == 0 { // if not empty
			// string "apls"
			o = append(o, 0xa4, 0x61, 0x70, 0x6c, 0x73)
			o = (*z).LocalStateSchema.MarshalMsg(o)
		}
		if (zb0007Mask & 0x2000) == 0 { // if not empty
			// string "aprv"
			o = append(o, 0xa4, 0x61, 0x70, 0x72, 0x76)
			o = msgp.AppendUint64(o, (*z).RejectVersion)
		}
		if (zb0007Mask & 0x4000) == 0 { // if not empty
			// string "apsu"
			o = append(o, 0xa4, 0x61, 0x70, 0x73, 0x75)
			o = msgp.AppendBytes(o, (*z).ClearStateProgram)
		}
	}
	return
}

func (_ *ApplicationCallTxnFields) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*ApplicationCallTxnFields)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *ApplicationCallTxnFields) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0007 int
	var zb0008 bool
	zb0007, zb0008, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0007, zb0008, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0007 > 0 {
			zb0007--
			bts, err = (*z).ApplicationID.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "ApplicationID")
				return
			}
		}
		if zb0007 > 0 {
			zb0007--
			{
				var zb0009 uint64
				zb0009, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "OnCompletion")
					return
				}
				(*z).OnCompletion = OnCompletion(zb0009)
			}
		}
		if zb0007 > 0 {
			zb0007--
			var zb0010 int
			var zb0011 bool
			zb0010, zb0011, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "ApplicationArgs")
				return
			}
			if zb0010 > encodedMaxApplicationArgs {
				err = msgp.ErrOverflow(uint64(zb0010), uint64(encodedMaxApplicationArgs))
				err = msgp.WrapError(err, "struct-from-array", "ApplicationArgs")
				return
			}
			if zb0011 {
				(*z).ApplicationArgs = nil
			} else if (*z).ApplicationArgs != nil && cap((*z).ApplicationArgs) >= zb0010 {
				(*z).ApplicationArgs = ((*z).ApplicationArgs)[:zb0010]
			} else {
				(*z).ApplicationArgs = make([][]byte, zb0010)
			}
			for zb0001 := range (*z).ApplicationArgs {
				(*z).ApplicationArgs[zb0001], bts, err = msgp.ReadBytesBytes(bts, (*z).ApplicationArgs[zb0001])
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "ApplicationArgs", zb0001)
					return
				}
			}
		}
		if zb0007 > 0 {
			zb0007--
			var zb0012 int
			var zb0013 bool
			zb0012, zb0013, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Accounts")
				return
			}
			if zb0012 > encodedMaxAccounts {
				err = msgp.ErrOverflow(uint64(zb0012), uint64(encodedMaxAccounts))
				err = msgp.WrapError(err, "struct-from-array", "Accounts")
				return
			}
			if zb0013 {
				(*z).Accounts = nil
			} else if (*z).Accounts != nil && cap((*z).Accounts) >= zb0012 {
				(*z).Accounts = ((*z).Accounts)[:zb0012]
			} else {
				(*z).Accounts = make([]basics.Address, zb0012)
			}
			for zb0002 := range (*z).Accounts {
				bts, err = (*z).Accounts[zb0002].UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Accounts", zb0002)
					return
				}
			}
		}
		if zb0007 > 0 {
			zb0007--
			var zb0014 int
			var zb0015 bool
			zb0014, zb0015, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "ForeignAssets")
				return
			}
			if zb0014 > encodedMaxForeignAssets {
				err = msgp.ErrOverflow(uint64(zb0014), uint64(encodedMaxForeignAssets))
				err = msgp.WrapError(err, "struct-from-array", "ForeignAssets")
				return
			}
			if zb0015 {
				(*z).ForeignAssets = nil
			} else if (*z).ForeignAssets != nil && cap((*z).ForeignAssets) >= zb0014 {
				(*z).ForeignAssets = ((*z).ForeignAssets)[:zb0014]
			} else {
				(*z).ForeignAssets = make([]basics.AssetIndex, zb0014)
			}
			for zb0003 := range (*z).ForeignAssets {
				bts, err = (*z).ForeignAssets[zb0003].UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "ForeignAssets", zb0003)
					return
				}
			}
		}
		if zb0007 > 0 {
			zb0007--
			var zb0016 int
			var zb0017 bool
			zb0016, zb0017, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "ForeignApps")
				return
			}
			if zb0016 > encodedMaxForeignApps {
				err = msgp.ErrOverflow(uint64(zb0016), uint64(encodedMaxForeignApps))
				err = msgp.WrapError(err, "struct-from-array", "ForeignApps")
				return
			}
			if zb0017 {
				(*z).ForeignApps = nil
			} else if (*z).ForeignApps != nil && cap((*z).ForeignApps) >= zb0016 {
				(*z).ForeignApps = ((*z).ForeignApps)[:zb0016]
			} else {
				(*z).ForeignApps = make([]basics.AppIndex, zb0016)
			}
			for zb0004 := range (*z).ForeignApps {
				bts, err = (*z).ForeignApps[zb0004].UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "ForeignApps", zb0004)
					return
				}
			}
		}
		if zb0007 > 0 {
			zb0007--
			var zb0018 int
			var zb0019 bool
			zb0018, zb0019, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Access")
				return
			}
			if zb0018 > encodedMaxAccess {
				err = msgp.ErrOverflow(uint64(zb0018), uint64(encodedMaxAccess))
				err = msgp.WrapError(err, "struct-from-array", "Access")
				return
			}
			if zb0019 {
				(*z).Access = nil
			} else if (*z).Access != nil && cap((*z).Access) >= zb0018 {
				(*z).Access = ((*z).Access)[:zb0018]
			} else {
				(*z).Access = make([]ResourceRef, zb0018)
			}
			for zb0005 := range (*z).Access {
				bts, err = (*z).Access[zb0005].UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Access", zb0005)
					return
				}
			}
		}
		if zb0007 > 0 {
			zb0007--
			var zb0020 int
			var zb0021 bool
			zb0020, zb0021, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Boxes")
				return
			}
			if zb0020 > encodedMaxBoxes {
				err = msgp.ErrOverflow(uint64(zb0020), uint64(encodedMaxBoxes))
				err = msgp.WrapError(err, "struct-from-array", "Boxes")
				return
			}
			if zb0021 {
				(*z).Boxes = nil
			} else if (*z).Boxes != nil && cap((*z).Boxes) >= zb0020 {
				(*z).Boxes = ((*z).Boxes)[:zb0020]
			} else {
				(*z).Boxes = make([]BoxRef, zb0020)
			}
			for zb0006 := range (*z).Boxes {
				var zb0022 int
				var zb0023 bool
				zb0022, zb0023, bts, err = msgp.ReadMapHeaderBytes(bts)
				if _, ok := err.(msgp.TypeError); ok {
					zb0022, zb0023, bts, err = msgp.ReadArrayHeaderBytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "Boxes", zb0006)
						return
					}
					if zb0022 > 0 {
						zb0022--
						(*z).Boxes[zb0006].Index, bts, err = msgp.ReadUint64Bytes(bts)
						if err != nil {
							err = msgp.WrapError(err, "struct-from-array", "Boxes", zb0006, "struct-from-array", "Index")
							return
						}
					}
					if zb0022 > 0 {
						zb0022--
						var zb0024 int
						zb0024, err = msgp.ReadBytesBytesHeader(bts)
						if err != nil {
							err = msgp.WrapError(err, "struct-from-array", "Boxes", zb0006, "struct-from-array", "Name")
							return
						}
						if zb0024 > bounds.MaxBytesKeyValueLen {
							err = msgp.ErrOverflow(uint64(zb0024), uint64(bounds.MaxBytesKeyValueLen))
							return
						}
						(*z).Boxes[zb0006].Name, bts, err = msgp.ReadBytesBytes(bts, (*z).Boxes[zb0006].Name)
						if err != nil {
							err = msgp.WrapError(err, "struct-from-array", "Boxes", zb0006, "struct-from-array", "Name")
							return
						}
					}
					if zb0022 > 0 {
						err = msgp.ErrTooManyArrayFields(zb0022)
						if err != nil {
							err = msgp.WrapError(err, "struct-from-array", "Boxes", zb0006, "struct-from-array")
							return
						}
					}
				} else {
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "Boxes", zb0006)
						return
					}
					if zb0023 {
						(*z).Boxes[zb0006] = BoxRef{}
					}
					for zb0022 > 0 {
						zb0022--
						field, bts, err = msgp.ReadMapKeyZC(bts)
						if err != nil {
							err = msgp.WrapError(err, "struct-from-array", "Boxes", zb0006)
							return
						}
						switch string(field) {
						case "i":
							(*z).Boxes[zb0006].Index, bts, err = msgp.ReadUint64Bytes(bts)
							if err != nil {
								err = msgp.WrapError(err, "struct-from-array", "Boxes", zb0006, "Index")
								return
							}
						case "n":
							var zb0025 int
							zb0025, err = msgp.ReadBytesBytesHeader(bts)
							if err != nil {
								err = msgp.WrapError(err, "struct-from-array", "Boxes", zb0006, "Name")
								return
							}
							if zb0025 > bounds.MaxBytesKeyValueLen {
								err = msgp.ErrOverflow(uint64(zb0025), uint64(bounds.MaxBytesKeyValueLen))
								return
							}
							(*z).Boxes[zb0006].Name, bts, err = msgp.ReadBytesBytes(bts, (*z).Boxes[zb0006].Name)
							if err != nil {
								err = msgp.WrapError(err, "struct-from-array", "Boxes", zb0006, "Name")
								return
							}
						default:
							err = msgp.ErrNoField(string(field))
							if err != nil {
								err = msgp.WrapError(err, "struct-from-array", "Boxes", zb0006)
								return
							}
						}
					}
				}
			}
		}
		if zb0007 > 0 {
			zb0007--
			bts, err = (*z).LocalStateSchema.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "LocalStateSchema")
				return
			}
		}
		if zb0007 > 0 {
			zb0007--
			bts, err = (*z).GlobalStateSchema.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "GlobalStateSchema")
				return
			}
		}
		if zb0007 > 0 {
			zb0007--
			var zb0026 int
			zb0026, err = msgp.ReadBytesBytesHeader(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "ApprovalProgram")
				return
			}
			if zb0026 > bounds.MaxAvailableAppProgramLen {
				err = msgp.ErrOverflow(uint64(zb0026), uint64(bounds.MaxAvailableAppProgramLen))
				return
			}
			(*z).ApprovalProgram, bts, err = msgp.ReadBytesBytes(bts, (*z).ApprovalProgram)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "ApprovalProgram")
				return
			}
		}
		if zb0007 > 0 {
			zb0007--
			var zb0027 int
			zb0027, err = msgp.ReadBytesBytesHeader(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "ClearStateProgram")
				return
			}
			if zb0027 > bounds.MaxAvailableAppProgramLen {
				err = msgp.ErrOverflow(uint64(zb0027), uint64(bounds.MaxAvailableAppProgramLen))
				return
			}
			(*z).ClearStateProgram, bts, err = msgp.ReadBytesBytes(bts, (*z).ClearStateProgram)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "ClearStateProgram")
				return
			}
		}
		if zb0007 > 0 {
			zb0007--
			(*z).ExtraProgramPages, bts, err = msgp.ReadUint32Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "ExtraProgramPages")
				return
			}
		}
		if zb0007 > 0 {
			zb0007--
			(*z).RejectVersion, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "RejectVersion")
				return
			}
		}
		if zb0007 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0007)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0008 {
			(*z) = ApplicationCallTxnFields{}
		}
		for zb0007 > 0 {
			zb0007--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "apid":
				bts, err = (*z).ApplicationID.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "ApplicationID")
					return
				}
			case "apan":
				{
					var zb0028 uint64
					zb0028, bts, err = msgp.ReadUint64Bytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "OnCompletion")
						return
					}
					(*z).OnCompletion = OnCompletion(zb0028)
				}
			case "apaa":
				var zb0029 int
				var zb0030 bool
				zb0029, zb0030, bts, err = msgp.ReadArrayHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "ApplicationArgs")
					return
				}
				if zb0029 > encodedMaxApplicationArgs {
					err = msgp.ErrOverflow(uint64(zb0029), uint64(encodedMaxApplicationArgs))
					err = msgp.WrapError(err, "ApplicationArgs")
					return
				}
				if zb0030 {
					(*z).ApplicationArgs = nil
				} else if (*z).ApplicationArgs != nil && cap((*z).ApplicationArgs) >= zb0029 {
					(*z).ApplicationArgs = ((*z).ApplicationArgs)[:zb0029]
				} else {
					(*z).ApplicationArgs = make([][]byte, zb0029)
				}
				for zb0001 := range (*z).ApplicationArgs {
					(*z).ApplicationArgs[zb0001], bts, err = msgp.ReadBytesBytes(bts, (*z).ApplicationArgs[zb0001])
					if err != nil {
						err = msgp.WrapError(err, "ApplicationArgs", zb0001)
						return
					}
				}
			case "apat":
				var zb0031 int
				var zb0032 bool
				zb0031, zb0032, bts, err = msgp.ReadArrayHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Accounts")
					return
				}
				if zb0031 > encodedMaxAccounts {
					err = msgp.ErrOverflow(uint64(zb0031), uint64(encodedMaxAccounts))
					err = msgp.WrapError(err, "Accounts")
					return
				}
				if zb0032 {
					(*z).Accounts = nil
				} else if (*z).Accounts != nil && cap((*z).Accounts) >= zb0031 {
					(*z).Accounts = ((*z).Accounts)[:zb0031]
				} else {
					(*z).Accounts = make([]basics.Address, zb0031)
				}
				for zb0002 := range (*z).Accounts {
					bts, err = (*z).Accounts[zb0002].UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "Accounts", zb0002)
						return
					}
				}
			case "apas":
				var zb0033 int
				var zb0034 bool
				zb0033, zb0034, bts, err = msgp.ReadArrayHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "ForeignAssets")
					return
				}
				if zb0033 > encodedMaxForeignAssets {
					err = msgp.ErrOverflow(uint64(zb0033), uint64(encodedMaxForeignAssets))
					err = msgp.WrapError(err, "ForeignAssets")
					return
				}
				if zb0034 {
					(*z).ForeignAssets = nil
				} else if (*z).ForeignAssets != nil && cap((*z).ForeignAssets) >= zb0033 {
					(*z).ForeignAssets = ((*z).ForeignAssets)[:zb0033]
				} else {
					(*z).ForeignAssets = make([]basics.AssetIndex, zb0033)
				}
				for zb0003 := range (*z).ForeignAssets {
					bts, err = (*z).ForeignAssets[zb0003].UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "ForeignAssets", zb0003)
						return
					}
				}
			case "apfa":
				var zb0035 int
				var zb0036 bool
				zb0035, zb0036, bts, err = msgp.ReadArrayHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "ForeignApps")
					return
				}
				if zb0035 > encodedMaxForeignApps {
					err = msgp.ErrOverflow(uint64(zb0035), uint64(encodedMaxForeignApps))
					err = msgp.WrapError(err, "ForeignApps")
					return
				}
				if zb0036 {
					(*z).ForeignApps = nil
				} else if (*z).ForeignApps != nil && cap((*z).ForeignApps) >= zb0035 {
					(*z).ForeignApps = ((*z).ForeignApps)[:zb0035]
				} else {
					(*z).ForeignApps = make([]basics.AppIndex, zb0035)
				}
				for zb0004 := range (*z).ForeignApps {
					bts, err = (*z).ForeignApps[zb0004].UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "ForeignApps", zb0004)
						return
					}
				}
			case "al":
				var zb0037 int
				var zb0038 bool
				zb0037, zb0038, bts, err = msgp.ReadArrayHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Access")
					return
				}
				if zb0037 > encodedMaxAccess {
					err = msgp.ErrOverflow(uint64(zb0037), uint64(encodedMaxAccess))
					err = msgp.WrapError(err, "Access")
					return
				}
				if zb0038 {
					(*z).Access = nil
				} else if (*z).Access != nil && cap((*z).Access) >= zb0037 {
					(*z).Access = ((*z).Access)[:zb0037]
				} else {
					(*z).Access = make([]ResourceRef, zb0037)
				}
				for zb0005 := range (*z).Access {
					bts, err = (*z).Access[zb0005].UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "Access", zb0005)
						return
					}
				}
			case "apbx":
				var zb0039 int
				var zb0040 bool
				zb0039, zb0040, bts, err = msgp.ReadArrayHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Boxes")
					return
				}
				if zb0039 > encodedMaxBoxes {
					err = msgp.ErrOverflow(uint64(zb0039), uint64(encodedMaxBoxes))
					err = msgp.WrapError(err, "Boxes")
					return
				}
				if zb0040 {
					(*z).Boxes = nil
				} else if (*z).Boxes != nil && cap((*z).Boxes) >= zb0039 {
					(*z).Boxes = ((*z).Boxes)[:zb0039]
				} else {
					(*z).Boxes = make([]BoxRef, zb0039)
				}
				for zb0006 := range (*z).Boxes {
					var zb0041 int
					var zb0042 bool
					zb0041, zb0042, bts, err = msgp.ReadMapHeaderBytes(bts)
					if _, ok := err.(msgp.TypeError); ok {
						zb0041, zb0042, bts, err = msgp.ReadArrayHeaderBytes(bts)
						if err != nil {
							err = msgp.WrapError(err, "Boxes", zb0006)
							return
						}
						if zb0041 > 0 {
							zb0041--
							(*z).Boxes[zb0006].Index, bts, err = msgp.ReadUint64Bytes(bts)
							if err != nil {
								err = msgp.WrapError(err, "Boxes", zb0006, "struct-from-array", "Index")
								return
							}
						}
						if zb0041 > 0 {
							zb0041--
							var zb0043 int
							zb0043, err = msgp.ReadBytesBytesHeader(bts)
							if err != nil {
								err = msgp.WrapError(err, "Boxes", zb0006, "struct-from-array", "Name")
								return
							}
							if zb0043 > bounds.MaxBytesKeyValueLen {
								err = msgp.ErrOverflow(uint64(zb0043), uint64(bounds.MaxBytesKeyValueLen))
								return
							}
							(*z).Boxes[zb0006].Name, bts, err = msgp.ReadBytesBytes(bts, (*z).Boxes[zb0006].Name)
							if err != nil {
								err = msgp.WrapError(err, "Boxes", zb0006, "struct-from-array", "Name")
								return
							}
						}
						if zb0041 > 0 {
							err = msgp.ErrTooManyArrayFields(zb0041)
							if err != nil {
								err = msgp.WrapError(err, "Boxes", zb0006, "struct-from-array")
								return
							}
						}
					} else {
						if err != nil {
							err = msgp.WrapError(err, "Boxes", zb0006)
							return
						}
						if zb0042 {
							(*z).Boxes[zb0006] = BoxRef{}
						}
						for zb0041 > 0 {
							zb0041--
							field, bts, err = msgp.ReadMapKeyZC(bts)
							if err != nil {
								err = msgp.WrapError(err, "Boxes", zb0006)
								return
							}
							switch string(field) {
							case "i":
								(*z).Boxes[zb0006].Index, bts, err = msgp.ReadUint64Bytes(bts)
								if err != nil {
									err = msgp.WrapError(err, "Boxes", zb0006, "Index")
									return
								}
							case "n":
								var zb0044 int
								zb0044, err = msgp.ReadBytesBytesHeader(bts)
								if err != nil {
									err = msgp.WrapError(err, "Boxes", zb0006, "Name")
									return
								}
								if zb0044 > bounds.MaxBytesKeyValueLen {
									err = msgp.ErrOverflow(uint64(zb0044), uint64(bounds.MaxBytesKeyValueLen))
									return
								}
								(*z).Boxes[zb0006].Name, bts, err = msgp.ReadBytesBytes(bts, (*z).Boxes[zb0006].Name)
								if err != nil {
									err = msgp.WrapError(err, "Boxes", zb0006, "Name")
									return
								}
							default:
								err = msgp.ErrNoField(string(field))
								if err != nil {
									err = msgp.WrapError(err, "Boxes", zb0006)
									return
								}
							}
						}
					}
				}
			case "apls":
				bts, err = (*z).LocalStateSchema.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "LocalStateSchema")
					return
				}
			case "apgs":
				bts, err = (*z).GlobalStateSchema.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "GlobalStateSchema")
					return
				}
			case "apap":
				var zb0045 int
				zb0045, err = msgp.ReadBytesBytesHeader(bts)
				if err != nil {
					err = msgp.WrapError(err, "ApprovalProgram")
					return
				}
				if zb0045 > bounds.MaxAvailableAppProgramLen {
					err = msgp.ErrOverflow(uint64(zb0045), uint64(bounds.MaxAvailableAppProgramLen))
					return
				}
				(*z).ApprovalProgram, bts, err = msgp.ReadBytesBytes(bts, (*z).ApprovalProgram)
				if err != nil {
					err = msgp.WrapError(err, "ApprovalProgram")
					return
				}
			case "apsu":
				var zb0046 int
				zb0046, err = msgp.ReadBytesBytesHeader(bts)
				if err != nil {
					err = msgp.WrapError(err, "ClearStateProgram")
					return
				}
				if zb0046 > bounds.MaxAvailableAppProgramLen {
					err = msgp.ErrOverflow(uint64(zb0046), uint64(bounds.MaxAvailableAppProgramLen))
					return
				}
				(*z).ClearStateProgram, bts, err = msgp.ReadBytesBytes(bts, (*z).ClearStateProgram)
				if err != nil {
					err = msgp.WrapError(err, "ClearStateProgram")
					return
				}
			case "apep":
				(*z).ExtraProgramPages, bts, err = msgp.ReadUint32Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "ExtraProgramPages")
					return
				}
			case "aprv":
				(*z).RejectVersion, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "RejectVersion")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *ApplicationCallTxnFields) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *ApplicationCallTxnFields) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*ApplicationCallTxnFields)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *ApplicationCallTxnFields) Msgsize() (s int) {
	s = 1 + 5 + (*z).ApplicationID.Msgsize() + 5 + msgp.Uint64Size + 5 + msgp.ArrayHeaderSize
	for zb0001 := range (*z).ApplicationArgs {
		s += msgp.BytesPrefixSize + len((*z).ApplicationArgs[zb0001])
	}
	s += 5 + msgp.ArrayHeaderSize
	for zb0002 := range (*z).Accounts {
		s += (*z).Accounts[zb0002].Msgsize()
	}
	s += 5 + msgp.ArrayHeaderSize
	for zb0003 := range (*z).ForeignAssets {
		s += (*z).ForeignAssets[zb0003].Msgsize()
	}
	s += 5 + msgp.ArrayHeaderSize
	for zb0004 := range (*z).ForeignApps {
		s += (*z).ForeignApps[zb0004].Msgsize()
	}
	s += 3 + msgp.ArrayHeaderSize
	for zb0005 := range (*z).Access {
		s += (*z).Access[zb0005].Msgsize()
	}
	s += 5 + msgp.ArrayHeaderSize
	for zb0006 := range (*z).Boxes {
		s += 1 + 2 + msgp.Uint64Size + 2 + msgp.BytesPrefixSize + len((*z).Boxes[zb0006].Name)
	}
	s += 5 + (*z).LocalStateSchema.Msgsize() + 5 + (*z).GlobalStateSchema.Msgsize() + 5 + msgp.BytesPrefixSize + len((*z).ApprovalProgram) + 5 + msgp.BytesPrefixSize + len((*z).ClearStateProgram) + 5 + msgp.Uint32Size + 5 + msgp.Uint64Size
	return
}

// MsgIsZero returns whether this is a zero value
func (z *ApplicationCallTxnFields) MsgIsZero() bool {
	return ((*z).ApplicationID.MsgIsZero()) && ((*z).OnCompletion == 0) && (len((*z).ApplicationArgs) == 0) && (len((*z).Accounts) == 0) && (len((*z).ForeignAssets) == 0) && (len((*z).ForeignApps) == 0) && (len((*z).Access) == 0) && (len((*z).Boxes) == 0) && ((*z).LocalStateSchema.MsgIsZero()) && ((*z).GlobalStateSchema.MsgIsZero()) && (len((*z).ApprovalProgram) == 0) && (len((*z).ClearStateProgram) == 0) && ((*z).ExtraProgramPages == 0) && ((*z).RejectVersion == 0)
}

// MaxSize returns a maximum valid message size for this message type
func ApplicationCallTxnFieldsMaxSize() (s int) {
	s = 1 + 5 + basics.AppIndexMaxSize() + 5 + msgp.Uint64Size + 5
	// Calculating size of slice: z.ApplicationArgs
	s += msgp.ArrayHeaderSize + bounds.MaxAppTotalArgLen + 5
	// Calculating size of slice: z.Accounts
	s += msgp.ArrayHeaderSize + ((encodedMaxAccounts) * (basics.AddressMaxSize()))
	s += 5
	// Calculating size of slice: z.ForeignAssets
	s += msgp.ArrayHeaderSize + ((encodedMaxForeignAssets) * (basics.AssetIndexMaxSize()))
	s += 5
	// Calculating size of slice: z.ForeignApps
	s += msgp.ArrayHeaderSize + ((encodedMaxForeignApps) * (basics.AppIndexMaxSize()))
	s += 3
	// Calculating size of slice: z.Access
	s += msgp.ArrayHeaderSize + ((encodedMaxAccess) * (ResourceRefMaxSize()))
	s += 5
	// Calculating size of slice: z.Boxes
	s += msgp.ArrayHeaderSize + ((encodedMaxBoxes) * (BoxRefMaxSize()))
	s += 5 + basics.StateSchemaMaxSize() + 5 + basics.StateSchemaMaxSize() + 5 + msgp.BytesPrefixSize + bounds.MaxAvailableAppProgramLen + 5 + msgp.BytesPrefixSize + bounds.MaxAvailableAppProgramLen + 5 + msgp.Uint32Size + 5 + msgp.Uint64Size
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *ApplyData) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0001Len := uint32(8)
	var zb0001Mask uint16 /* 9 bits */
	if (*z).AssetClosingAmount == 0 {
		zb0001Len--
		zb0001Mask |= 0x2
	}
	if (*z).ApplicationID.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x4
	}
	if (*z).ClosingAmount.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x8
	}
	if (*z).ConfigAsset.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x10
	}
	if (*z).EvalDelta.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x20
	}
	if (*z).CloseRewards.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x40
	}
	if (*z).ReceiverRewards.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x80
	}
	if (*z).SenderRewards.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x100
	}
	// variable map header, size zb0001Len
	o = append(o, 0x80|uint8(zb0001Len))
	if zb0001Len != 0 {
		if (zb0001Mask & 0x2) == 0 { // if not empty
			// string "aca"
			o = append(o, 0xa3, 0x61, 0x63, 0x61)
			o = msgp.AppendUint64(o, (*z).AssetClosingAmount)
		}
		if (zb0001Mask & 0x4) == 0 { // if not empty
			// string "apid"
			o = append(o, 0xa4, 0x61, 0x70, 0x69, 0x64)
			o = (*z).ApplicationID.MarshalMsg(o)
		}
		if (zb0001Mask & 0x8) == 0 { // if not empty
			// string "ca"
			o = append(o, 0xa2, 0x63, 0x61)
			o = (*z).ClosingAmount.MarshalMsg(o)
		}
		if (zb0001Mask & 0x10) == 0 { // if not empty
			// string "caid"
			o = append(o, 0xa4, 0x63, 0x61, 0x69, 0x64)
			o = (*z).ConfigAsset.MarshalMsg(o)
		}
		if (zb0001Mask & 0x20) == 0 { // if not empty
			// string "dt"
			o = append(o, 0xa2, 0x64, 0x74)
			o = (*z).EvalDelta.MarshalMsg(o)
		}
		if (zb0001Mask & 0x40) == 0 { // if not empty
			// string "rc"
			o = append(o, 0xa2, 0x72, 0x63)
			o = (*z).CloseRewards.MarshalMsg(o)
		}
		if (zb0001Mask & 0x80) == 0 { // if not empty
			// string "rr"
			o = append(o, 0xa2, 0x72, 0x72)
			o = (*z).ReceiverRewards.MarshalMsg(o)
		}
		if (zb0001Mask & 0x100) == 0 { // if not empty
			// string "rs"
			o = append(o, 0xa2, 0x72, 0x73)
			o = (*z).SenderRewards.MarshalMsg(o)
		}
	}
	return
}

func (_ *ApplyData) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*ApplyData)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *ApplyData) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0001 int
	var zb0002 bool
	zb0001, zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0001, zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).ClosingAmount.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "ClosingAmount")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			(*z).AssetClosingAmount, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "AssetClosingAmount")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).SenderRewards.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "SenderRewards")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).ReceiverRewards.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "ReceiverRewards")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).CloseRewards.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "CloseRewards")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).EvalDelta.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "EvalDelta")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).ConfigAsset.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "ConfigAsset")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).ApplicationID.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "ApplicationID")
				return
			}
		}
		if zb0001 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0001)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 {
			(*z) = ApplyData{}
		}
		for zb0001 > 0 {
			zb0001--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "ca":
				bts, err = (*z).ClosingAmount.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "ClosingAmount")
					return
				}
			case "aca":
				(*z).AssetClosingAmount, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "AssetClosingAmount")
					return
				}
			case "rs":
				bts, err = (*z).SenderRewards.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "SenderRewards")
					return
				}
			case "rr":
				bts, err = (*z).ReceiverRewards.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "ReceiverRewards")
					return
				}
			case "rc":
				bts, err = (*z).CloseRewards.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "CloseRewards")
					return
				}
			case "dt":
				bts, err = (*z).EvalDelta.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "EvalDelta")
					return
				}
			case "caid":
				bts, err = (*z).ConfigAsset.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "ConfigAsset")
					return
				}
			case "apid":
				bts, err = (*z).ApplicationID.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "ApplicationID")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *ApplyData) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *ApplyData) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*ApplyData)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *ApplyData) Msgsize() (s int) {
	s = 1 + 3 + (*z).ClosingAmount.Msgsize() + 4 + msgp.Uint64Size + 3 + (*z).SenderRewards.Msgsize() + 3 + (*z).ReceiverRewards.Msgsize() + 3 + (*z).CloseRewards.Msgsize() + 3 + (*z).EvalDelta.Msgsize() + 5 + (*z).ConfigAsset.Msgsize() + 5 + (*z).ApplicationID.Msgsize()
	return
}

// MsgIsZero returns whether this is a zero value
func (z *ApplyData) MsgIsZero() bool {
	return ((*z).ClosingAmount.MsgIsZero()) && ((*z).AssetClosingAmount == 0) && ((*z).SenderRewards.MsgIsZero()) && ((*z).ReceiverRewards.MsgIsZero()) && ((*z).CloseRewards.MsgIsZero()) && ((*z).EvalDelta.MsgIsZero()) && ((*z).ConfigAsset.MsgIsZero()) && ((*z).ApplicationID.MsgIsZero())
}

// MaxSize returns a maximum valid message size for this message type
func ApplyDataMaxSize() (s int) {
	s = 1 + 3 + basics.MicroAlgosMaxSize() + 4 + msgp.Uint64Size + 3 + basics.MicroAlgosMaxSize() + 3 + basics.MicroAlgosMaxSize() + 3 + basics.MicroAlgosMaxSize() + 3 + EvalDeltaMaxSize() + 5 + basics.AssetIndexMaxSize() + 5 + basics.AppIndexMaxSize()
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *AssetConfigTxnFields) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0001Len := uint32(2)
	var zb0001Mask uint8 /* 3 bits */
	if (*z).AssetParams.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x2
	}
	if (*z).ConfigAsset.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x4
	}
	// variable map header, size zb0001Len
	o = append(o, 0x80|uint8(zb0001Len))
	if zb0001Len != 0 {
		if (zb0001Mask & 0x2) == 0 { // if not empty
			// string "apar"
			o = append(o, 0xa4, 0x61, 0x70, 0x61, 0x72)
			o = (*z).AssetParams.MarshalMsg(o)
		}
		if (zb0001Mask & 0x4) == 0 { // if not empty
			// string "caid"
			o = append(o, 0xa4, 0x63, 0x61, 0x69, 0x64)
			o = (*z).ConfigAsset.MarshalMsg(o)
		}
	}
	return
}

func (_ *AssetConfigTxnFields) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*AssetConfigTxnFields)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *AssetConfigTxnFields) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0001 int
	var zb0002 bool
	zb0001, zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0001, zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).ConfigAsset.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "ConfigAsset")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).AssetParams.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "AssetParams")
				return
			}
		}
		if zb0001 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0001)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 {
			(*z) = AssetConfigTxnFields{}
		}
		for zb0001 > 0 {
			zb0001--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "caid":
				bts, err = (*z).ConfigAsset.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "ConfigAsset")
					return
				}
			case "apar":
				bts, err = (*z).AssetParams.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "AssetParams")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *AssetConfigTxnFields) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *AssetConfigTxnFields) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*AssetConfigTxnFields)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *AssetConfigTxnFields) Msgsize() (s int) {
	s = 1 + 5 + (*z).ConfigAsset.Msgsize() + 5 + (*z).AssetParams.Msgsize()
	return
}

// MsgIsZero returns whether this is a zero value
func (z *AssetConfigTxnFields) MsgIsZero() bool {
	return ((*z).ConfigAsset.MsgIsZero()) && ((*z).AssetParams.MsgIsZero())
}

// MaxSize returns a maximum valid message size for this message type
func AssetConfigTxnFieldsMaxSize() (s int) {
	s = 1 + 5 + basics.AssetIndexMaxSize() + 5 + basics.AssetParamsMaxSize()
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *AssetFreezeTxnFields) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0001Len := uint32(3)
	var zb0001Mask uint8 /* 4 bits */
	if (*z).AssetFrozen == false {
		zb0001Len--
		zb0001Mask |= 0x2
	}
	if (*z).FreezeAccount.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x4
	}
	if (*z).FreezeAsset.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x8
	}
	// variable map header, size zb0001Len
	o = append(o, 0x80|uint8(zb0001Len))
	if zb0001Len != 0 {
		if (zb0001Mask & 0x2) == 0 { // if not empty
			// string "afrz"
			o = append(o, 0xa4, 0x61, 0x66, 0x72, 0x7a)
			o = msgp.AppendBool(o, (*z).AssetFrozen)
		}
		if (zb0001Mask & 0x4) == 0 { // if not empty
			// string "fadd"
			o = append(o, 0xa4, 0x66, 0x61, 0x64, 0x64)
			o = (*z).FreezeAccount.MarshalMsg(o)
		}
		if (zb0001Mask & 0x8) == 0 { // if not empty
			// string "faid"
			o = append(o, 0xa4, 0x66, 0x61, 0x69, 0x64)
			o = (*z).FreezeAsset.MarshalMsg(o)
		}
	}
	return
}

func (_ *AssetFreezeTxnFields) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*AssetFreezeTxnFields)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *AssetFreezeTxnFields) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0001 int
	var zb0002 bool
	zb0001, zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0001, zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).FreezeAccount.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "FreezeAccount")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).FreezeAsset.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "FreezeAsset")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			(*z).AssetFrozen, bts, err = msgp.ReadBoolBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "AssetFrozen")
				return
			}
		}
		if zb0001 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0001)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 {
			(*z) = AssetFreezeTxnFields{}
		}
		for zb0001 > 0 {
			zb0001--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "fadd":
				bts, err = (*z).FreezeAccount.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "FreezeAccount")
					return
				}
			case "faid":
				bts, err = (*z).FreezeAsset.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "FreezeAsset")
					return
				}
			case "afrz":
				(*z).AssetFrozen, bts, err = msgp.ReadBoolBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "AssetFrozen")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *AssetFreezeTxnFields) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *AssetFreezeTxnFields) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*AssetFreezeTxnFields)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *AssetFreezeTxnFields) Msgsize() (s int) {
	s = 1 + 5 + (*z).FreezeAccount.Msgsize() + 5 + (*z).FreezeAsset.Msgsize() + 5 + msgp.BoolSize
	return
}

// MsgIsZero returns whether this is a zero value
func (z *AssetFreezeTxnFields) MsgIsZero() bool {
	return ((*z).FreezeAccount.MsgIsZero()) && ((*z).FreezeAsset.MsgIsZero()) && ((*z).AssetFrozen == false)
}

// MaxSize returns a maximum valid message size for this message type
func AssetFreezeTxnFieldsMaxSize() (s int) {
	s = 1 + 5 + basics.AddressMaxSize() + 5 + basics.AssetIndexMaxSize() + 5 + msgp.BoolSize
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *AssetTransferTxnFields) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0001Len := uint32(5)
	var zb0001Mask uint8 /* 6 bits */
	if (*z).AssetAmount == 0 {
		zb0001Len--
		zb0001Mask |= 0x2
	}
	if (*z).AssetCloseTo.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x4
	}
	if (*z).AssetReceiver.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x8
	}
	if (*z).AssetSender.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x10
	}
	if (*z).XferAsset.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x20
	}
	// variable map header, size zb0001Len
	o = append(o, 0x80|uint8(zb0001Len))
	if zb0001Len != 0 {
		if (zb0001Mask & 0x2) == 0 { // if not empty
			// string "aamt"
			o = append(o, 0xa4, 0x61, 0x61, 0x6d, 0x74)
			o = msgp.AppendUint64(o, (*z).AssetAmount)
		}
		if (zb0001Mask & 0x4) == 0 { // if not empty
			// string "aclose"
			o = append(o, 0xa6, 0x61, 0x63, 0x6c, 0x6f, 0x73, 0x65)
			o = (*z).AssetCloseTo.MarshalMsg(o)
		}
		if (zb0001Mask & 0x8) == 0 { // if not empty
			// string "arcv"
			o = append(o, 0xa4, 0x61, 0x72, 0x63, 0x76)
			o = (*z).AssetReceiver.MarshalMsg(o)
		}
		if (zb0001Mask & 0x10) == 0 { // if not empty
			// string "asnd"
			o = append(o, 0xa4, 0x61, 0x73, 0x6e, 0x64)
			o = (*z).AssetSender.MarshalMsg(o)
		}
		if (zb0001Mask & 0x20) == 0 { // if not empty
			// string "xaid"
			o = append(o, 0xa4, 0x78, 0x61, 0x69, 0x64)
			o = (*z).XferAsset.MarshalMsg(o)
		}
	}
	return
}

func (_ *AssetTransferTxnFields) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*AssetTransferTxnFields)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *AssetTransferTxnFields) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0001 int
	var zb0002 bool
	zb0001, zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0001, zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).XferAsset.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "XferAsset")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			(*z).AssetAmount, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "AssetAmount")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).AssetSender.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "AssetSender")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).AssetReceiver.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "AssetReceiver")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).AssetCloseTo.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "AssetCloseTo")
				return
			}
		}
		if zb0001 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0001)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 {
			(*z) = AssetTransferTxnFields{}
		}
		for zb0001 > 0 {
			zb0001--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "xaid":
				bts, err = (*z).XferAsset.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "XferAsset")
					return
				}
			case "aamt":
				(*z).AssetAmount, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "AssetAmount")
					return
				}
			case "asnd":
				bts, err = (*z).AssetSender.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "AssetSender")
					return
				}
			case "arcv":
				bts, err = (*z).AssetReceiver.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "AssetReceiver")
					return
				}
			case "aclose":
				bts, err = (*z).AssetCloseTo.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "AssetCloseTo")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *AssetTransferTxnFields) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *AssetTransferTxnFields) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*AssetTransferTxnFields)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *AssetTransferTxnFields) Msgsize() (s int) {
	s = 1 + 5 + (*z).XferAsset.Msgsize() + 5 + msgp.Uint64Size + 5 + (*z).AssetSender.Msgsize() + 5 + (*z).AssetReceiver.Msgsize() + 7 + (*z).AssetCloseTo.Msgsize()
	return
}

// MsgIsZero returns whether this is a zero value
func (z *AssetTransferTxnFields) MsgIsZero() bool {
	return ((*z).XferAsset.MsgIsZero()) && ((*z).AssetAmount == 0) && ((*z).AssetSender.MsgIsZero()) && ((*z).AssetReceiver.MsgIsZero()) && ((*z).AssetCloseTo.MsgIsZero())
}

// MaxSize returns a maximum valid message size for this message type
func AssetTransferTxnFieldsMaxSize() (s int) {
	s = 1 + 5 + basics.AssetIndexMaxSize() + 5 + msgp.Uint64Size + 5 + basics.AddressMaxSize() + 5 + basics.AddressMaxSize() + 7 + basics.AddressMaxSize()
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *BoxRef) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0001Len := uint32(2)
	var zb0001Mask uint8 /* 3 bits */
	if (*z).Index == 0 {
		zb0001Len--
		zb0001Mask |= 0x2
	}
	if len((*z).Name) == 0 {
		zb0001Len--
		zb0001Mask |= 0x4
	}
	// variable map header, size zb0001Len
	o = append(o, 0x80|uint8(zb0001Len))
	if zb0001Len != 0 {
		if (zb0001Mask & 0x2) == 0 { // if not empty
			// string "i"
			o = append(o, 0xa1, 0x69)
			o = msgp.AppendUint64(o, (*z).Index)
		}
		if (zb0001Mask & 0x4) == 0 { // if not empty
			// string "n"
			o = append(o, 0xa1, 0x6e)
			o = msgp.AppendBytes(o, (*z).Name)
		}
	}
	return
}

func (_ *BoxRef) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*BoxRef)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *BoxRef) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0001 int
	var zb0002 bool
	zb0001, zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0001, zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0001 > 0 {
			zb0001--
			(*z).Index, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Index")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			var zb0003 int
			zb0003, err = msgp.ReadBytesBytesHeader(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Name")
				return
			}
			if zb0003 > bounds.MaxBytesKeyValueLen {
				err = msgp.ErrOverflow(uint64(zb0003), uint64(bounds.MaxBytesKeyValueLen))
				return
			}
			(*z).Name, bts, err = msgp.ReadBytesBytes(bts, (*z).Name)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Name")
				return
			}
		}
		if zb0001 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0001)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 {
			(*z) = BoxRef{}
		}
		for zb0001 > 0 {
			zb0001--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "i":
				(*z).Index, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Index")
					return
				}
			case "n":
				var zb0004 int
				zb0004, err = msgp.ReadBytesBytesHeader(bts)
				if err != nil {
					err = msgp.WrapError(err, "Name")
					return
				}
				if zb0004 > bounds.MaxBytesKeyValueLen {
					err = msgp.ErrOverflow(uint64(zb0004), uint64(bounds.MaxBytesKeyValueLen))
					return
				}
				(*z).Name, bts, err = msgp.ReadBytesBytes(bts, (*z).Name)
				if err != nil {
					err = msgp.WrapError(err, "Name")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *BoxRef) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *BoxRef) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*BoxRef)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *BoxRef) Msgsize() (s int) {
	s = 1 + 2 + msgp.Uint64Size + 2 + msgp.BytesPrefixSize + len((*z).Name)
	return
}

// MsgIsZero returns whether this is a zero value
func (z *BoxRef) MsgIsZero() bool {
	return ((*z).Index == 0) && (len((*z).Name) == 0)
}

// MaxSize returns a maximum valid message size for this message type
func BoxRefMaxSize() (s int) {
	s = 1 + 2 + msgp.Uint64Size + 2 + msgp.BytesPrefixSize + bounds.MaxBytesKeyValueLen
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *EvalDelta) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0006Len := uint32(5)
	var zb0006Mask uint8 /* 6 bits */
	if (*z).GlobalDelta.MsgIsZero() {
		zb0006Len--
		zb0006Mask |= 0x2
	}
	if len((*z).InnerTxns) == 0 {
		zb0006Len--
		zb0006Mask |= 0x4
	}
	if len((*z).LocalDeltas) == 0 {
		zb0006Len--
		zb0006Mask |= 0x8
	}
	if len((*z).Logs) == 0 {
		zb0006Len--
		zb0006Mask |= 0x10
	}
	if len((*z).SharedAccts) == 0 {
		zb0006Len--
		zb0006Mask |= 0x20
	}
	// variable map header, size zb0006Len
	o = append(o, 0x80|uint8(zb0006Len))
	if zb0006Len != 0 {
		if (zb0006Mask & 0x2) == 0 { // if not empty
			// string "gd"
			o = append(o, 0xa2, 0x67, 0x64)
			o = (*z).GlobalDelta.MarshalMsg(o)
		}
		if (zb0006Mask & 0x4) == 0 { // if not empty
			// string "itx"
			o = append(o, 0xa3, 0x69, 0x74, 0x78)
			if (*z).InnerTxns == nil {
				o = msgp.AppendNil(o)
			} else {
				o = msgp.AppendArrayHeader(o, uint32(len((*z).InnerTxns)))
			}
			for zb0005 := range (*z).InnerTxns {
				o = (*z).InnerTxns[zb0005].MarshalMsg(o)
			}
		}
		if (zb0006Mask & 0x8) == 0 { // if not empty
			// string "ld"
			o = append(o, 0xa2, 0x6c, 0x64)
			if (*z).LocalDeltas == nil {
				o = msgp.AppendNil(o)
			} else {
				o = msgp.AppendMapHeader(o, uint32(len((*z).LocalDeltas)))
			}
			zb0001_keys := make([]uint64, 0, len((*z).LocalDeltas))
			for zb0001 := range (*z).LocalDeltas {
				zb0001_keys = append(zb0001_keys, zb0001)
			}
			sort.Sort(SortUint64(zb0001_keys))
			for _, zb0001 := range zb0001_keys {
				zb0002 := (*z).LocalDeltas[zb0001]
				_ = zb0002
				o = msgp.AppendUint64(o, zb0001)
				o = zb0002.MarshalMsg(o)
			}
		}
		if (zb0006Mask & 0x10) == 0 { // if not empty
			// string "lg"
			o = append(o, 0xa2, 0x6c, 0x67)
			if (*z).Logs == nil {
				o = msgp.AppendNil(o)
			} else {
				o = msgp.AppendArrayHeader(o, uint32(len((*z).Logs)))
			}
			for zb0004 := range (*z).Logs {
				o = msgp.AppendString(o, (*z).Logs[zb0004])
			}
		}
		if (zb0006Mask & 0x20) == 0 { // if not empty
			// string "sa"
			o = append(o, 0xa2, 0x73, 0x61)
			if (*z).SharedAccts == nil {
				o = msgp.AppendNil(o)
			} else {
				o = msgp.AppendArrayHeader(o, uint32(len((*z).SharedAccts)))
			}
			for zb0003 := range (*z).SharedAccts {
				o = (*z).SharedAccts[zb0003].MarshalMsg(o)
			}
		}
	}
	return
}

func (_ *EvalDelta) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*EvalDelta)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *EvalDelta) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0006 int
	var zb0007 bool
	zb0006, zb0007, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0006, zb0007, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0006 > 0 {
			zb0006--
			bts, err = (*z).GlobalDelta.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "GlobalDelta")
				return
			}
		}
		if zb0006 > 0 {
			zb0006--
			var zb0008 int
			var zb0009 bool
			zb0008, zb0009, bts, err = msgp.ReadMapHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "LocalDeltas")
				return
			}
			if zb0008 > bounds.MaxEvalDeltaAccounts {
				err = msgp.ErrOverflow(uint64(zb0008), uint64(bounds.MaxEvalDeltaAccounts))
				err = msgp.WrapError(err, "struct-from-array", "LocalDeltas")
				return
			}
			if zb0009 {
				(*z).LocalDeltas = nil
			} else if (*z).LocalDeltas == nil {
				(*z).LocalDeltas = make(map[uint64]basics.StateDelta, zb0008)
			}
			for zb0008 > 0 {
				var zb0001 uint64
				var zb0002 basics.StateDelta
				zb0008--
				zb0001, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "LocalDeltas")
					return
				}
				bts, err = zb0002.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "LocalDeltas", zb0001)
					return
				}
				(*z).LocalDeltas[zb0001] = zb0002
			}
		}
		if zb0006 > 0 {
			zb0006--
			var zb0010 int
			var zb0011 bool
			zb0010, zb0011, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "SharedAccts")
				return
			}
			if zb0010 > bounds.MaxEvalDeltaAccounts {
				err = msgp.ErrOverflow(uint64(zb0010), uint64(bounds.MaxEvalDeltaAccounts))
				err = msgp.WrapError(err, "struct-from-array", "SharedAccts")
				return
			}
			if zb0011 {
				(*z).SharedAccts = nil
			} else if (*z).SharedAccts != nil && cap((*z).SharedAccts) >= zb0010 {
				(*z).SharedAccts = ((*z).SharedAccts)[:zb0010]
			} else {
				(*z).SharedAccts = make([]basics.Address, zb0010)
			}
			for zb0003 := range (*z).SharedAccts {
				bts, err = (*z).SharedAccts[zb0003].UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "SharedAccts", zb0003)
					return
				}
			}
		}
		if zb0006 > 0 {
			zb0006--
			var zb0012 int
			var zb0013 bool
			zb0012, zb0013, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Logs")
				return
			}
			if zb0012 > bounds.MaxLogCalls {
				err = msgp.ErrOverflow(uint64(zb0012), uint64(bounds.MaxLogCalls))
				err = msgp.WrapError(err, "struct-from-array", "Logs")
				return
			}
			if zb0013 {
				(*z).Logs = nil
			} else if (*z).Logs != nil && cap((*z).Logs) >= zb0012 {
				(*z).Logs = ((*z).Logs)[:zb0012]
			} else {
				(*z).Logs = make([]string, zb0012)
			}
			for zb0004 := range (*z).Logs {
				(*z).Logs[zb0004], bts, err = msgp.ReadStringBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Logs", zb0004)
					return
				}
			}
		}
		if zb0006 > 0 {
			zb0006--
			var zb0014 int
			var zb0015 bool
			zb0014, zb0015, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "InnerTxns")
				return
			}
			if zb0014 > bounds.MaxInnerTransactionsPerDelta {
				err = msgp.ErrOverflow(uint64(zb0014), uint64(bounds.MaxInnerTransactionsPerDelta))
				err = msgp.WrapError(err, "struct-from-array", "InnerTxns")
				return
			}
			if zb0015 {
				(*z).InnerTxns = nil
			} else if (*z).InnerTxns != nil && cap((*z).InnerTxns) >= zb0014 {
				(*z).InnerTxns = ((*z).InnerTxns)[:zb0014]
			} else {
				(*z).InnerTxns = make([]SignedTxnWithAD, zb0014)
			}
			for zb0005 := range (*z).InnerTxns {
				bts, err = (*z).InnerTxns[zb0005].UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "InnerTxns", zb0005)
					return
				}
			}
		}
		if zb0006 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0006)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0007 {
			(*z) = EvalDelta{}
		}
		for zb0006 > 0 {
			zb0006--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "gd":
				bts, err = (*z).GlobalDelta.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "GlobalDelta")
					return
				}
			case "ld":
				var zb0016 int
				var zb0017 bool
				zb0016, zb0017, bts, err = msgp.ReadMapHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "LocalDeltas")
					return
				}
				if zb0016 > bounds.MaxEvalDeltaAccounts {
					err = msgp.ErrOverflow(uint64(zb0016), uint64(bounds.MaxEvalDeltaAccounts))
					err = msgp.WrapError(err, "LocalDeltas")
					return
				}
				if zb0017 {
					(*z).LocalDeltas = nil
				} else if (*z).LocalDeltas == nil {
					(*z).LocalDeltas = make(map[uint64]basics.StateDelta, zb0016)
				}
				for zb0016 > 0 {
					var zb0001 uint64
					var zb0002 basics.StateDelta
					zb0016--
					zb0001, bts, err = msgp.ReadUint64Bytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "LocalDeltas")
						return
					}
					bts, err = zb0002.UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "LocalDeltas", zb0001)
						return
					}
					(*z).LocalDeltas[zb0001] = zb0002
				}
			case "sa":
				var zb0018 int
				var zb0019 bool
				zb0018, zb0019, bts, err = msgp.ReadArrayHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "SharedAccts")
					return
				}
				if zb0018 > bounds.MaxEvalDeltaAccounts {
					err = msgp.ErrOverflow(uint64(zb0018), uint64(bounds.MaxEvalDeltaAccounts))
					err = msgp.WrapError(err, "SharedAccts")
					return
				}
				if zb0019 {
					(*z).SharedAccts = nil
				} else if (*z).SharedAccts != nil && cap((*z).SharedAccts) >= zb0018 {
					(*z).SharedAccts = ((*z).SharedAccts)[:zb0018]
				} else {
					(*z).SharedAccts = make([]basics.Address, zb0018)
				}
				for zb0003 := range (*z).SharedAccts {
					bts, err = (*z).SharedAccts[zb0003].UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "SharedAccts", zb0003)
						return
					}
				}
			case "lg":
				var zb0020 int
				var zb0021 bool
				zb0020, zb0021, bts, err = msgp.ReadArrayHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Logs")
					return
				}
				if zb0020 > bounds.MaxLogCalls {
					err = msgp.ErrOverflow(uint64(zb0020), uint64(bounds.MaxLogCalls))
					err = msgp.WrapError(err, "Logs")
					return
				}
				if zb0021 {
					(*z).Logs = nil
				} else if (*z).Logs != nil && cap((*z).Logs) >= zb0020 {
					(*z).Logs = ((*z).Logs)[:zb0020]
				} else {
					(*z).Logs = make([]string, zb0020)
				}
				for zb0004 := range (*z).Logs {
					(*z).Logs[zb0004], bts, err = msgp.ReadStringBytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "Logs", zb0004)
						return
					}
				}
			case "itx":
				var zb0022 int
				var zb0023 bool
				zb0022, zb0023, bts, err = msgp.ReadArrayHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "InnerTxns")
					return
				}
				if zb0022 > bounds.MaxInnerTransactionsPerDelta {
					err = msgp.ErrOverflow(uint64(zb0022), uint64(bounds.MaxInnerTransactionsPerDelta))
					err = msgp.WrapError(err, "InnerTxns")
					return
				}
				if zb0023 {
					(*z).InnerTxns = nil
				} else if (*z).InnerTxns != nil && cap((*z).InnerTxns) >= zb0022 {
					(*z).InnerTxns = ((*z).InnerTxns)[:zb0022]
				} else {
					(*z).InnerTxns = make([]SignedTxnWithAD, zb0022)
				}
				for zb0005 := range (*z).InnerTxns {
					bts, err = (*z).InnerTxns[zb0005].UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "InnerTxns", zb0005)
						return
					}
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *EvalDelta) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *EvalDelta) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*EvalDelta)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *EvalDelta) Msgsize() (s int) {
	s = 1 + 3 + (*z).GlobalDelta.Msgsize() + 3 + msgp.MapHeaderSize
	if (*z).LocalDeltas != nil {
		for zb0001, zb0002 := range (*z).LocalDeltas {
			_ = zb0001
			_ = zb0002
			s += 0 + msgp.Uint64Size + zb0002.Msgsize()
		}
	}
	s += 3 + msgp.ArrayHeaderSize
	for zb0003 := range (*z).SharedAccts {
		s += (*z).SharedAccts[zb0003].Msgsize()
	}
	s += 3 + msgp.ArrayHeaderSize
	for zb0004 := range (*z).Logs {
		s += msgp.StringPrefixSize + len((*z).Logs[zb0004])
	}
	s += 4 + msgp.ArrayHeaderSize
	for zb0005 := range (*z).InnerTxns {
		s += (*z).InnerTxns[zb0005].Msgsize()
	}
	return
}

// MsgIsZero returns whether this is a zero value
func (z *EvalDelta) MsgIsZero() bool {
	return ((*z).GlobalDelta.MsgIsZero()) && (len((*z).LocalDeltas) == 0) && (len((*z).SharedAccts) == 0) && (len((*z).Logs) == 0) && (len((*z).InnerTxns) == 0)
}

// MaxSize returns a maximum valid message size for this message type
func EvalDeltaMaxSize() (s int) {
	s = 1 + 3 + basics.StateDeltaMaxSize() + 3
	s += msgp.MapHeaderSize
	// Adding size of map keys for z.LocalDeltas
	s += bounds.MaxEvalDeltaAccounts * (msgp.Uint64Size)
	// Adding size of map values for z.LocalDeltas
	s += bounds.MaxEvalDeltaAccounts * (basics.StateDeltaMaxSize())
	s += 3
	// Calculating size of slice: z.SharedAccts
	s += msgp.ArrayHeaderSize + ((bounds.MaxEvalDeltaAccounts) * (basics.AddressMaxSize()))
	s += 3
	// Calculating size of slice: z.Logs
	s += msgp.ArrayHeaderSize + (bounds.MaxLogCalls * msgp.StringPrefixSize) + bounds.MaxEvalDeltaTotalLogSize + 4
	// Calculating size of slice: z.InnerTxns
	s += msgp.ArrayHeaderSize + ((bounds.MaxInnerTransactionsPerDelta) * (SignedTxnWithADMaxSize()))
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *Header) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0002Len := uint32(10)
	var zb0002Mask uint16 /* 11 bits */
	if (*z).Fee.MsgIsZero() {
		zb0002Len--
		zb0002Mask |= 0x2
	}
	if (*z).FirstValid.MsgIsZero() {
		zb0002Len--
		zb0002Mask |= 0x4
	}
	if (*z).GenesisID == "" {
		zb0002Len--
		zb0002Mask |= 0x8
	}
	if (*z).GenesisHash.MsgIsZero() {
		zb0002Len--
		zb0002Mask |= 0x10
	}
	if (*z).Group.MsgIsZero() {
		zb0002Len--
		zb0002Mask |= 0x20
	}
	if (*z).LastValid.MsgIsZero() {
		zb0002Len--
		zb0002Mask |= 0x40
	}
	if (*z).Lease == ([32]byte{}) {
		zb0002Len--
		zb0002Mask |= 0x80
	}
	if len((*z).Note) == 0 {
		zb0002Len--
		zb0002Mask |= 0x100
	}
	if (*z).RekeyTo.MsgIsZero() {
		zb0002Len--
		zb0002Mask |= 0x200
	}
	if (*z).Sender.MsgIsZero() {
		zb0002Len--
		zb0002Mask |= 0x400
	}
	// variable map header, size zb0002Len
	o = append(o, 0x80|uint8(zb0002Len))
	if zb0002Len != 0 {
		if (zb0002Mask & 0x2) == 0 { // if not empty
			// string "fee"
			o = append(o, 0xa3, 0x66, 0x65, 0x65)
			o = (*z).Fee.MarshalMsg(o)
		}
		if (zb0002Mask & 0x4) == 0 { // if not empty
			// string "fv"
			o = append(o, 0xa2, 0x66, 0x76)
			o = (*z).FirstValid.MarshalMsg(o)
		}
		if (zb0002Mask & 0x8) == 0 { // if not empty
			// string "gen"
			o = append(o, 0xa3, 0x67, 0x65, 0x6e)
			o = msgp.AppendString(o, (*z).GenesisID)
		}
		if (zb0002Mask & 0x10) == 0 { // if not empty
			// string "gh"
			o = append(o, 0xa2, 0x67, 0x68)
			o = (*z).GenesisHash.MarshalMsg(o)
		}
		if (zb0002Mask & 0x20) == 0 { // if not empty
			// string "grp"
			o = append(o, 0xa3, 0x67, 0x72, 0x70)
			o = (*z).Group.MarshalMsg(o)
		}
		if (zb0002Mask & 0x40) == 0 { // if not empty
			// string "lv"
			o = append(o, 0xa2, 0x6c, 0x76)
			o = (*z).LastValid.MarshalMsg(o)
		}
		if (zb0002Mask & 0x80) == 0 { // if not empty
			// string "lx"
			o = append(o, 0xa2, 0x6c, 0x78)
			o = msgp.AppendBytes(o, ((*z).Lease)[:])
		}
		if (zb0002Mask & 0x100) == 0 { // if not empty
			// string "note"
			o = append(o, 0xa4, 0x6e, 0x6f, 0x74, 0x65)
			o = msgp.AppendBytes(o, (*z).Note)
		}
		if (zb0002Mask & 0x200) == 0 { // if not empty
			// string "rekey"
			o = append(o, 0xa5, 0x72, 0x65, 0x6b, 0x65, 0x79)
			o = (*z).RekeyTo.MarshalMsg(o)
		}
		if (zb0002Mask & 0x400) == 0 { // if not empty
			// string "snd"
			o = append(o, 0xa3, 0x73, 0x6e, 0x64)
			o = (*z).Sender.MarshalMsg(o)
		}
	}
	return
}

func (_ *Header) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*Header)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *Header) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0002 int
	var zb0003 bool
	zb0002, zb0003, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0002, zb0003, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 > 0 {
			zb0002--
			bts, err = (*z).Sender.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Sender")
				return
			}
		}
		if zb0002 > 0 {
			zb0002--
			bts, err = (*z).Fee.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Fee")
				return
			}
		}
		if zb0002 > 0 {
			zb0002--
			bts, err = (*z).FirstValid.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "FirstValid")
				return
			}
		}
		if zb0002 > 0 {
			zb0002--
			bts, err = (*z).LastValid.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "LastValid")
				return
			}
		}
		if zb0002 > 0 {
			zb0002--
			var zb0004 int
			zb0004, err = msgp.ReadBytesBytesHeader(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Note")
				return
			}
			if zb0004 > bounds.MaxTxnNoteBytes {
				err = msgp.ErrOverflow(uint64(zb0004), uint64(bounds.MaxTxnNoteBytes))
				return
			}
			(*z).Note, bts, err = msgp.ReadBytesBytes(bts, (*z).Note)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Note")
				return
			}
		}
		if zb0002 > 0 {
			zb0002--
			var zb0005 int
			zb0005, err = msgp.ReadBytesBytesHeader(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "GenesisID")
				return
			}
			if zb0005 > bounds.MaxGenesisIDLen {
				err = msgp.ErrOverflow(uint64(zb0005), uint64(bounds.MaxGenesisIDLen))
				return
			}
			(*z).GenesisID, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "GenesisID")
				return
			}
		}
		if zb0002 > 0 {
			zb0002--
			bts, err = (*z).GenesisHash.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "GenesisHash")
				return
			}
		}
		if zb0002 > 0 {
			zb0002--
			bts, err = (*z).Group.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Group")
				return
			}
		}
		if zb0002 > 0 {
			zb0002--
			bts, err = msgp.ReadExactBytes(bts, ((*z).Lease)[:])
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Lease")
				return
			}
		}
		if zb0002 > 0 {
			zb0002--
			bts, err = (*z).RekeyTo.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "RekeyTo")
				return
			}
		}
		if zb0002 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0002)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0003 {
			(*z) = Header{}
		}
		for zb0002 > 0 {
			zb0002--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "snd":
				bts, err = (*z).Sender.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Sender")
					return
				}
			case "fee":
				bts, err = (*z).Fee.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Fee")
					return
				}
			case "fv":
				bts, err = (*z).FirstValid.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "FirstValid")
					return
				}
			case "lv":
				bts, err = (*z).LastValid.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "LastValid")
					return
				}
			case "note":
				var zb0006 int
				zb0006, err = msgp.ReadBytesBytesHeader(bts)
				if err != nil {
					err = msgp.WrapError(err, "Note")
					return
				}
				if zb0006 > bounds.MaxTxnNoteBytes {
					err = msgp.ErrOverflow(uint64(zb0006), uint64(bounds.MaxTxnNoteBytes))
					return
				}
				(*z).Note, bts, err = msgp.ReadBytesBytes(bts, (*z).Note)
				if err != nil {
					err = msgp.WrapError(err, "Note")
					return
				}
			case "gen":
				var zb0007 int
				zb0007, err = msgp.ReadBytesBytesHeader(bts)
				if err != nil {
					err = msgp.WrapError(err, "GenesisID")
					return
				}
				if zb0007 > bounds.MaxGenesisIDLen {
					err = msgp.ErrOverflow(uint64(zb0007), uint64(bounds.MaxGenesisIDLen))
					return
				}
				(*z).GenesisID, bts, err = msgp.ReadStringBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "GenesisID")
					return
				}
			case "gh":
				bts, err = (*z).GenesisHash.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "GenesisHash")
					return
				}
			case "grp":
				bts, err = (*z).Group.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Group")
					return
				}
			case "lx":
				bts, err = msgp.ReadExactBytes(bts, ((*z).Lease)[:])
				if err != nil {
					err = msgp.WrapError(err, "Lease")
					return
				}
			case "rekey":
				bts, err = (*z).RekeyTo.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "RekeyTo")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *Header) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *Header) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*Header)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *Header) Msgsize() (s int) {
	s = 1 + 4 + (*z).Sender.Msgsize() + 4 + (*z).Fee.Msgsize() + 3 + (*z).FirstValid.Msgsize() + 3 + (*z).LastValid.Msgsize() + 5 + msgp.BytesPrefixSize + len((*z).Note) + 4 + msgp.StringPrefixSize + len((*z).GenesisID) + 3 + (*z).GenesisHash.Msgsize() + 4 + (*z).Group.Msgsize() + 3 + msgp.ArrayHeaderSize + (32 * (msgp.ByteSize)) + 6 + (*z).RekeyTo.Msgsize()
	return
}

// MsgIsZero returns whether this is a zero value
func (z *Header) MsgIsZero() bool {
	return ((*z).Sender.MsgIsZero()) && ((*z).Fee.MsgIsZero()) && ((*z).FirstValid.MsgIsZero()) && ((*z).LastValid.MsgIsZero()) && (len((*z).Note) == 0) && ((*z).GenesisID == "") && ((*z).GenesisHash.MsgIsZero()) && ((*z).Group.MsgIsZero()) && ((*z).Lease == ([32]byte{})) && ((*z).RekeyTo.MsgIsZero())
}

// MaxSize returns a maximum valid message size for this message type
func HeaderMaxSize() (s int) {
	s = 1 + 4 + basics.AddressMaxSize() + 4 + basics.MicroAlgosMaxSize() + 3 + basics.RoundMaxSize() + 3 + basics.RoundMaxSize() + 5 + msgp.BytesPrefixSize + bounds.MaxTxnNoteBytes + 4 + msgp.StringPrefixSize + bounds.MaxGenesisIDLen + 3 + crypto.DigestMaxSize() + 4 + crypto.DigestMaxSize() + 3
	// Calculating size of array: z.Lease
	s += msgp.ArrayHeaderSize + ((32) * (msgp.ByteSize))
	s += 6 + basics.AddressMaxSize()
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *HeartbeatTxnFields) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0001Len := uint32(5)
	var zb0001Mask uint8 /* 6 bits */
	if (*z).HbAddress.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x2
	}
	if (*z).HbKeyDilution == 0 {
		zb0001Len--
		zb0001Mask |= 0x4
	}
	if (*z).HbProof.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x8
	}
	if (*z).HbSeed.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x10
	}
	if (*z).HbVoteID.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x20
	}
	// variable map header, size zb0001Len
	o = append(o, 0x80|uint8(zb0001Len))
	if zb0001Len != 0 {
		if (zb0001Mask & 0x2) == 0 { // if not empty
			// string "a"
			o = append(o, 0xa1, 0x61)
			o = (*z).HbAddress.MarshalMsg(o)
		}
		if (zb0001Mask & 0x4) == 0 { // if not empty
			// string "kd"
			o = append(o, 0xa2, 0x6b, 0x64)
			o = msgp.AppendUint64(o, (*z).HbKeyDilution)
		}
		if (zb0001Mask & 0x8) == 0 { // if not empty
			// string "prf"
			o = append(o, 0xa3, 0x70, 0x72, 0x66)
			o = (*z).HbProof.MarshalMsg(o)
		}
		if (zb0001Mask & 0x10) == 0 { // if not empty
			// string "sd"
			o = append(o, 0xa2, 0x73, 0x64)
			o = (*z).HbSeed.MarshalMsg(o)
		}
		if (zb0001Mask & 0x20) == 0 { // if not empty
			// string "vid"
			o = append(o, 0xa3, 0x76, 0x69, 0x64)
			o = (*z).HbVoteID.MarshalMsg(o)
		}
	}
	return
}

func (_ *HeartbeatTxnFields) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*HeartbeatTxnFields)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *HeartbeatTxnFields) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0001 int
	var zb0002 bool
	zb0001, zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0001, zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).HbAddress.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "HbAddress")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).HbProof.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "HbProof")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).HbSeed.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "HbSeed")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).HbVoteID.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "HbVoteID")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			(*z).HbKeyDilution, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "HbKeyDilution")
				return
			}
		}
		if zb0001 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0001)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 {
			(*z) = HeartbeatTxnFields{}
		}
		for zb0001 > 0 {
			zb0001--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "a":
				bts, err = (*z).HbAddress.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "HbAddress")
					return
				}
			case "prf":
				bts, err = (*z).HbProof.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "HbProof")
					return
				}
			case "sd":
				bts, err = (*z).HbSeed.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "HbSeed")
					return
				}
			case "vid":
				bts, err = (*z).HbVoteID.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "HbVoteID")
					return
				}
			case "kd":
				(*z).HbKeyDilution, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "HbKeyDilution")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *HeartbeatTxnFields) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *HeartbeatTxnFields) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*HeartbeatTxnFields)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *HeartbeatTxnFields) Msgsize() (s int) {
	s = 1 + 2 + (*z).HbAddress.Msgsize() + 4 + (*z).HbProof.Msgsize() + 3 + (*z).HbSeed.Msgsize() + 4 + (*z).HbVoteID.Msgsize() + 3 + msgp.Uint64Size
	return
}

// MsgIsZero returns whether this is a zero value
func (z *HeartbeatTxnFields) MsgIsZero() bool {
	return ((*z).HbAddress.MsgIsZero()) && ((*z).HbProof.MsgIsZero()) && ((*z).HbSeed.MsgIsZero()) && ((*z).HbVoteID.MsgIsZero()) && ((*z).HbKeyDilution == 0)
}

// MaxSize returns a maximum valid message size for this message type
func HeartbeatTxnFieldsMaxSize() (s int) {
	s = 1 + 2 + basics.AddressMaxSize() + 4 + crypto.HeartbeatProofMaxSize() + 3 + committee.SeedMaxSize() + 4 + crypto.OneTimeSignatureVerifierMaxSize() + 3 + msgp.Uint64Size
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *HoldingRef) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0001Len := uint32(2)
	var zb0001Mask uint8 /* 3 bits */
	if (*z).Address == 0 {
		zb0001Len--
		zb0001Mask |= 0x2
	}
	if (*z).Asset == 0 {
		zb0001Len--
		zb0001Mask |= 0x4
	}
	// variable map header, size zb0001Len
	o = append(o, 0x80|uint8(zb0001Len))
	if zb0001Len != 0 {
		if (zb0001Mask & 0x2) == 0 { // if not empty
			// string "d"
			o = append(o, 0xa1, 0x64)
			o = msgp.AppendUint64(o, (*z).Address)
		}
		if (zb0001Mask & 0x4) == 0 { // if not empty
			// string "s"
			o = append(o, 0xa1, 0x73)
			o = msgp.AppendUint64(o, (*z).Asset)
		}
	}
	return
}

func (_ *HoldingRef) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*HoldingRef)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *HoldingRef) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0001 int
	var zb0002 bool
	zb0001, zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0001, zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0001 > 0 {
			zb0001--
			(*z).Address, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Address")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			(*z).Asset, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Asset")
				return
			}
		}
		if zb0001 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0001)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 {
			(*z) = HoldingRef{}
		}
		for zb0001 > 0 {
			zb0001--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "d":
				(*z).Address, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Address")
					return
				}
			case "s":
				(*z).Asset, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Asset")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *HoldingRef) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *HoldingRef) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*HoldingRef)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *HoldingRef) Msgsize() (s int) {
	s = 1 + 2 + msgp.Uint64Size + 2 + msgp.Uint64Size
	return
}

// MsgIsZero returns whether this is a zero value
func (z *HoldingRef) MsgIsZero() bool {
	return ((*z).Address == 0) && ((*z).Asset == 0)
}

// MaxSize returns a maximum valid message size for this message type
func HoldingRefMaxSize() (s int) {
	s = 1 + 2 + msgp.Uint64Size + 2 + msgp.Uint64Size
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *KeyregTxnFields) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0001Len := uint32(7)
	var zb0001Mask uint8 /* 8 bits */
	if (*z).Nonparticipation == false {
		zb0001Len--
		zb0001Mask |= 0x2
	}
	if (*z).SelectionPK.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x4
	}
	if (*z).StateProofPK.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x8
	}
	if (*z).VoteFirst.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x10
	}
	if (*z).VoteKeyDilution == 0 {
		zb0001Len--
		zb0001Mask |= 0x20
	}
	if (*z).VotePK.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x40
	}
	if (*z).VoteLast.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x80
	}
	// variable map header, size zb0001Len
	o = append(o, 0x80|uint8(zb0001Len))
	if zb0001Len != 0 {
		if (zb0001Mask & 0x2) == 0 { // if not empty
			// string "nonpart"
			o = append(o, 0xa7, 0x6e, 0x6f, 0x6e, 0x70, 0x61, 0x72, 0x74)
			o = msgp.AppendBool(o, (*z).Nonparticipation)
		}
		if (zb0001Mask & 0x4) == 0 { // if not empty
			// string "selkey"
			o = append(o, 0xa6, 0x73, 0x65, 0x6c, 0x6b, 0x65, 0x79)
			o = (*z).SelectionPK.MarshalMsg(o)
		}
		if (zb0001Mask & 0x8) == 0 { // if not empty
			// string "sprfkey"
			o = append(o, 0xa7, 0x73, 0x70, 0x72, 0x66, 0x6b, 0x65, 0x79)
			o = (*z).StateProofPK.MarshalMsg(o)
		}
		if (zb0001Mask & 0x10) == 0 { // if not empty
			// string "votefst"
			o = append(o, 0xa7, 0x76, 0x6f, 0x74, 0x65, 0x66, 0x73, 0x74)
			o = (*z).VoteFirst.MarshalMsg(o)
		}
		if (zb0001Mask & 0x20) == 0 { // if not empty
			// string "votekd"
			o = append(o, 0xa6, 0x76, 0x6f, 0x74, 0x65, 0x6b, 0x64)
			o = msgp.AppendUint64(o, (*z).VoteKeyDilution)
		}
		if (zb0001Mask & 0x40) == 0 { // if not empty
			// string "votekey"
			o = append(o, 0xa7, 0x76, 0x6f, 0x74, 0x65, 0x6b, 0x65, 0x79)
			o = (*z).VotePK.MarshalMsg(o)
		}
		if (zb0001Mask & 0x80) == 0 { // if not empty
			// string "votelst"
			o = append(o, 0xa7, 0x76, 0x6f, 0x74, 0x65, 0x6c, 0x73, 0x74)
			o = (*z).VoteLast.MarshalMsg(o)
		}
	}
	return
}

func (_ *KeyregTxnFields) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*KeyregTxnFields)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *KeyregTxnFields) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0001 int
	var zb0002 bool
	zb0001, zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0001, zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).VotePK.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "VotePK")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).SelectionPK.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "SelectionPK")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).StateProofPK.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "StateProofPK")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).VoteFirst.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "VoteFirst")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).VoteLast.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "VoteLast")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			(*z).VoteKeyDilution, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "VoteKeyDilution")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			(*z).Nonparticipation, bts, err = msgp.ReadBoolBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Nonparticipation")
				return
			}
		}
		if zb0001 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0001)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 {
			(*z) = KeyregTxnFields{}
		}
		for zb0001 > 0 {
			zb0001--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "votekey":
				bts, err = (*z).VotePK.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "VotePK")
					return
				}
			case "selkey":
				bts, err = (*z).SelectionPK.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "SelectionPK")
					return
				}
			case "sprfkey":
				bts, err = (*z).StateProofPK.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "StateProofPK")
					return
				}
			case "votefst":
				bts, err = (*z).VoteFirst.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "VoteFirst")
					return
				}
			case "votelst":
				bts, err = (*z).VoteLast.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "VoteLast")
					return
				}
			case "votekd":
				(*z).VoteKeyDilution, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "VoteKeyDilution")
					return
				}
			case "nonpart":
				(*z).Nonparticipation, bts, err = msgp.ReadBoolBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Nonparticipation")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *KeyregTxnFields) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *KeyregTxnFields) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*KeyregTxnFields)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *KeyregTxnFields) Msgsize() (s int) {
	s = 1 + 8 + (*z).VotePK.Msgsize() + 7 + (*z).SelectionPK.Msgsize() + 8 + (*z).StateProofPK.Msgsize() + 8 + (*z).VoteFirst.Msgsize() + 8 + (*z).VoteLast.Msgsize() + 7 + msgp.Uint64Size + 8 + msgp.BoolSize
	return
}

// MsgIsZero returns whether this is a zero value
func (z *KeyregTxnFields) MsgIsZero() bool {
	return ((*z).VotePK.MsgIsZero()) && ((*z).SelectionPK.MsgIsZero()) && ((*z).StateProofPK.MsgIsZero()) && ((*z).VoteFirst.MsgIsZero()) && ((*z).VoteLast.MsgIsZero()) && ((*z).VoteKeyDilution == 0) && ((*z).Nonparticipation == false)
}

// MaxSize returns a maximum valid message size for this message type
func KeyregTxnFieldsMaxSize() (s int) {
	s = 1 + 8 + crypto.OneTimeSignatureVerifierMaxSize() + 7 + crypto.VRFVerifierMaxSize() + 8 + merklesignature.CommitmentMaxSize() + 8 + basics.RoundMaxSize() + 8 + basics.RoundMaxSize() + 7 + msgp.Uint64Size + 8 + msgp.BoolSize
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *LocalsRef) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0001Len := uint32(2)
	var zb0001Mask uint8 /* 3 bits */
	if (*z).Address == 0 {
		zb0001Len--
		zb0001Mask |= 0x2
	}
	if (*z).App == 0 {
		zb0001Len--
		zb0001Mask |= 0x4
	}
	// variable map header, size zb0001Len
	o = append(o, 0x80|uint8(zb0001Len))
	if zb0001Len != 0 {
		if (zb0001Mask & 0x2) == 0 { // if not empty
			// string "d"
			o = append(o, 0xa1, 0x64)
			o = msgp.AppendUint64(o, (*z).Address)
		}
		if (zb0001Mask & 0x4) == 0 { // if not empty
			// string "p"
			o = append(o, 0xa1, 0x70)
			o = msgp.AppendUint64(o, (*z).App)
		}
	}
	return
}

func (_ *LocalsRef) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*LocalsRef)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *LocalsRef) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0001 int
	var zb0002 bool
	zb0001, zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0001, zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0001 > 0 {
			zb0001--
			(*z).Address, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Address")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			(*z).App, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "App")
				return
			}
		}
		if zb0001 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0001)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 {
			(*z) = LocalsRef{}
		}
		for zb0001 > 0 {
			zb0001--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "d":
				(*z).Address, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Address")
					return
				}
			case "p":
				(*z).App, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "App")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *LocalsRef) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *LocalsRef) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*LocalsRef)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *LocalsRef) Msgsize() (s int) {
	s = 1 + 2 + msgp.Uint64Size + 2 + msgp.Uint64Size
	return
}

// MsgIsZero returns whether this is a zero value
func (z *LocalsRef) MsgIsZero() bool {
	return ((*z).Address == 0) && ((*z).App == 0)
}

// MaxSize returns a maximum valid message size for this message type
func LocalsRefMaxSize() (s int) {
	s = 1 + 2 + msgp.Uint64Size + 2 + msgp.Uint64Size
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *LogicSig) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0002Len := uint32(5)
	var zb0002Mask uint8 /* 6 bits */
	if len((*z).Args) == 0 {
		zb0002Len--
		zb0002Mask |= 0x2
	}
	if len((*z).Logic) == 0 {
		zb0002Len--
		zb0002Mask |= 0x4
	}
	if (*z).LMsig.MsgIsZero() {
		zb0002Len--
		zb0002Mask |= 0x8
	}
	if (*z).Msig.MsgIsZero() {
		zb0002Len--
		zb0002Mask |= 0x10
	}
	if (*z).Sig.MsgIsZero() {
		zb0002Len--
		zb0002Mask |= 0x20
	}
	// variable map header, size zb0002Len
	o = append(o, 0x80|uint8(zb0002Len))
	if zb0002Len != 0 {
		if (zb0002Mask & 0x2) == 0 { // if not empty
			// string "arg"
			o = append(o, 0xa3, 0x61, 0x72, 0x67)
			if (*z).Args == nil {
				o = msgp.AppendNil(o)
			} else {
				o = msgp.AppendArrayHeader(o, uint32(len((*z).Args)))
			}
			for zb0001 := range (*z).Args {
				o = msgp.AppendBytes(o, (*z).Args[zb0001])
			}
		}
		if (zb0002Mask & 0x4) == 0 { // if not empty
			// string "l"
			o = append(o, 0xa1, 0x6c)
			o = msgp.AppendBytes(o, (*z).Logic)
		}
		if (zb0002Mask & 0x8) == 0 { // if not empty
			// string "lmsig"
			o = append(o, 0xa5, 0x6c, 0x6d, 0x73, 0x69, 0x67)
			o = (*z).LMsig.MarshalMsg(o)
		}
		if (zb0002Mask & 0x10) == 0 { // if not empty
			// string "msig"
			o = append(o, 0xa4, 0x6d, 0x73, 0x69, 0x67)
			o = (*z).Msig.MarshalMsg(o)
		}
		if (zb0002Mask & 0x20) == 0 { // if not empty
			// string "sig"
			o = append(o, 0xa3, 0x73, 0x69, 0x67)
			o = (*z).Sig.MarshalMsg(o)
		}
	}
	return
}

func (_ *LogicSig) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*LogicSig)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *LogicSig) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0002 int
	var zb0003 bool
	zb0002, zb0003, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0002, zb0003, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 > 0 {
			zb0002--
			var zb0004 int
			zb0004, err = msgp.ReadBytesBytesHeader(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Logic")
				return
			}
			if zb0004 > bounds.MaxLogicSigMaxSize {
				err = msgp.ErrOverflow(uint64(zb0004), uint64(bounds.MaxLogicSigMaxSize))
				return
			}
			(*z).Logic, bts, err = msgp.ReadBytesBytes(bts, (*z).Logic)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Logic")
				return
			}
		}
		if zb0002 > 0 {
			zb0002--
			bts, err = (*z).Sig.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Sig")
				return
			}
		}
		if zb0002 > 0 {
			zb0002--
			bts, err = (*z).Msig.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Msig")
				return
			}
		}
		if zb0002 > 0 {
			zb0002--
			bts, err = (*z).LMsig.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "LMsig")
				return
			}
		}
		if zb0002 > 0 {
			zb0002--
			var zb0005 int
			var zb0006 bool
			zb0005, zb0006, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Args")
				return
			}
			if zb0005 > EvalMaxArgs {
				err = msgp.ErrOverflow(uint64(zb0005), uint64(EvalMaxArgs))
				err = msgp.WrapError(err, "struct-from-array", "Args")
				return
			}
			if zb0006 {
				(*z).Args = nil
			} else if (*z).Args != nil && cap((*z).Args) >= zb0005 {
				(*z).Args = ((*z).Args)[:zb0005]
			} else {
				(*z).Args = make([][]byte, zb0005)
			}
			for zb0001 := range (*z).Args {
				var zb0007 int
				zb0007, err = msgp.ReadBytesBytesHeader(bts)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Args", zb0001)
					return
				}
				if zb0007 > MaxLogicSigArgSize {
					err = msgp.ErrOverflow(uint64(zb0007), uint64(MaxLogicSigArgSize))
					return
				}
				(*z).Args[zb0001], bts, err = msgp.ReadBytesBytes(bts, (*z).Args[zb0001])
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Args", zb0001)
					return
				}
			}
		}
		if zb0002 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0002)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0003 {
			(*z) = LogicSig{}
		}
		for zb0002 > 0 {
			zb0002--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "l":
				var zb0008 int
				zb0008, err = msgp.ReadBytesBytesHeader(bts)
				if err != nil {
					err = msgp.WrapError(err, "Logic")
					return
				}
				if zb0008 > bounds.MaxLogicSigMaxSize {
					err = msgp.ErrOverflow(uint64(zb0008), uint64(bounds.MaxLogicSigMaxSize))
					return
				}
				(*z).Logic, bts, err = msgp.ReadBytesBytes(bts, (*z).Logic)
				if err != nil {
					err = msgp.WrapError(err, "Logic")
					return
				}
			case "sig":
				bts, err = (*z).Sig.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Sig")
					return
				}
			case "msig":
				bts, err = (*z).Msig.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Msig")
					return
				}
			case "lmsig":
				bts, err = (*z).LMsig.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "LMsig")
					return
				}
			case "arg":
				var zb0009 int
				var zb0010 bool
				zb0009, zb0010, bts, err = msgp.ReadArrayHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Args")
					return
				}
				if zb0009 > EvalMaxArgs {
					err = msgp.ErrOverflow(uint64(zb0009), uint64(EvalMaxArgs))
					err = msgp.WrapError(err, "Args")
					return
				}
				if zb0010 {
					(*z).Args = nil
				} else if (*z).Args != nil && cap((*z).Args) >= zb0009 {
					(*z).Args = ((*z).Args)[:zb0009]
				} else {
					(*z).Args = make([][]byte, zb0009)
				}
				for zb0001 := range (*z).Args {
					var zb0011 int
					zb0011, err = msgp.ReadBytesBytesHeader(bts)
					if err != nil {
						err = msgp.WrapError(err, "Args", zb0001)
						return
					}
					if zb0011 > MaxLogicSigArgSize {
						err = msgp.ErrOverflow(uint64(zb0011), uint64(MaxLogicSigArgSize))
						return
					}
					(*z).Args[zb0001], bts, err = msgp.ReadBytesBytes(bts, (*z).Args[zb0001])
					if err != nil {
						err = msgp.WrapError(err, "Args", zb0001)
						return
					}
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *LogicSig) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *LogicSig) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*LogicSig)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *LogicSig) Msgsize() (s int) {
	s = 1 + 2 + msgp.BytesPrefixSize + len((*z).Logic) + 4 + (*z).Sig.Msgsize() + 5 + (*z).Msig.Msgsize() + 6 + (*z).LMsig.Msgsize() + 4 + msgp.ArrayHeaderSize
	for zb0001 := range (*z).Args {
		s += msgp.BytesPrefixSize + len((*z).Args[zb0001])
	}
	return
}

// MsgIsZero returns whether this is a zero value
func (z *LogicSig) MsgIsZero() bool {
	return (len((*z).Logic) == 0) && ((*z).Sig.MsgIsZero()) && ((*z).Msig.MsgIsZero()) && ((*z).LMsig.MsgIsZero()) && (len((*z).Args) == 0)
}

// MaxSize returns a maximum valid message size for this message type
func LogicSigMaxSize() (s int) {
	s = 1 + 2 + msgp.BytesPrefixSize + bounds.MaxLogicSigMaxSize + 4 + crypto.SignatureMaxSize() + 5 + crypto.MultisigSigMaxSize() + 6 + crypto.MultisigSigMaxSize() + 4
	// Calculating size of slice: z.Args
	s += msgp.ArrayHeaderSize + bounds.MaxLogicSigMaxSize
	return
}

// MarshalMsg implements msgp.Marshaler
func (z OnCompletion) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	o = msgp.AppendUint64(o, uint64(z))
	return
}

func (_ OnCompletion) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(OnCompletion)
	if !ok {
		_, ok = (z).(*OnCompletion)
	}
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *OnCompletion) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	{
		var zb0001 uint64
		zb0001, bts, err = msgp.ReadUint64Bytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		(*z) = OnCompletion(zb0001)
	}
	o = bts
	return
}

func (z *OnCompletion) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *OnCompletion) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*OnCompletion)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z OnCompletion) Msgsize() (s int) {
	s = msgp.Uint64Size
	return
}

// MsgIsZero returns whether this is a zero value
func (z OnCompletion) MsgIsZero() bool {
	return z == 0
}

// MaxSize returns a maximum valid message size for this message type
func OnCompletionMaxSize() (s int) {
	s = msgp.Uint64Size
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *PaymentTxnFields) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0001Len := uint32(3)
	var zb0001Mask uint8 /* 4 bits */
	if (*z).Amount.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x2
	}
	if (*z).CloseRemainderTo.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x4
	}
	if (*z).Receiver.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x8
	}
	// variable map header, size zb0001Len
	o = append(o, 0x80|uint8(zb0001Len))
	if zb0001Len != 0 {
		if (zb0001Mask & 0x2) == 0 { // if not empty
			// string "amt"
			o = append(o, 0xa3, 0x61, 0x6d, 0x74)
			o = (*z).Amount.MarshalMsg(o)
		}
		if (zb0001Mask & 0x4) == 0 { // if not empty
			// string "close"
			o = append(o, 0xa5, 0x63, 0x6c, 0x6f, 0x73, 0x65)
			o = (*z).CloseRemainderTo.MarshalMsg(o)
		}
		if (zb0001Mask & 0x8) == 0 { // if not empty
			// string "rcv"
			o = append(o, 0xa3, 0x72, 0x63, 0x76)
			o = (*z).Receiver.MarshalMsg(o)
		}
	}
	return
}

func (_ *PaymentTxnFields) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*PaymentTxnFields)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *PaymentTxnFields) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0001 int
	var zb0002 bool
	zb0001, zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0001, zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).Receiver.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Receiver")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).Amount.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Amount")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).CloseRemainderTo.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "CloseRemainderTo")
				return
			}
		}
		if zb0001 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0001)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 {
			(*z) = PaymentTxnFields{}
		}
		for zb0001 > 0 {
			zb0001--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "rcv":
				bts, err = (*z).Receiver.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Receiver")
					return
				}
			case "amt":
				bts, err = (*z).Amount.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Amount")
					return
				}
			case "close":
				bts, err = (*z).CloseRemainderTo.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "CloseRemainderTo")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *PaymentTxnFields) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *PaymentTxnFields) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*PaymentTxnFields)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *PaymentTxnFields) Msgsize() (s int) {
	s = 1 + 4 + (*z).Receiver.Msgsize() + 4 + (*z).Amount.Msgsize() + 6 + (*z).CloseRemainderTo.Msgsize()
	return
}

// MsgIsZero returns whether this is a zero value
func (z *PaymentTxnFields) MsgIsZero() bool {
	return ((*z).Receiver.MsgIsZero()) && ((*z).Amount.MsgIsZero()) && ((*z).CloseRemainderTo.MsgIsZero())
}

// MaxSize returns a maximum valid message size for this message type
func PaymentTxnFieldsMaxSize() (s int) {
	s = 1 + 4 + basics.AddressMaxSize() + 4 + basics.MicroAlgosMaxSize() + 6 + basics.AddressMaxSize()
	return
}

// MarshalMsg implements msgp.Marshaler
func (z Payset) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	if z == nil {
		o = msgp.AppendNil(o)
	} else {
		o = msgp.AppendArrayHeader(o, uint32(len(z)))
	}
	for za0001 := range z {
		o = z[za0001].MarshalMsg(o)
	}
	return
}

func (_ Payset) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(Payset)
	if !ok {
		_, ok = (z).(*Payset)
	}
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *Payset) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var zb0002 int
	var zb0003 bool
	zb0002, zb0003, bts, err = msgp.ReadArrayHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	if zb0002 > 100000 {
		err = msgp.ErrOverflow(uint64(zb0002), uint64(100000))
		err = msgp.WrapError(err)
		return
	}
	if zb0003 {
		(*z) = nil
	} else if (*z) != nil && cap((*z)) >= zb0002 {
		(*z) = (*z)[:zb0002]
	} else {
		(*z) = make(Payset, zb0002)
	}
	for zb0001 := range *z {
		bts, err = (*z)[zb0001].UnmarshalMsgWithState(bts, st)
		if err != nil {
			err = msgp.WrapError(err, zb0001)
			return
		}
	}
	o = bts
	return
}

func (z *Payset) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *Payset) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*Payset)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z Payset) Msgsize() (s int) {
	s = msgp.ArrayHeaderSize
	for za0001 := range z {
		s += z[za0001].Msgsize()
	}
	return
}

// MsgIsZero returns whether this is a zero value
func (z Payset) MsgIsZero() bool {
	return len(z) == 0
}

// MaxSize returns a maximum valid message size for this message type
func PaysetMaxSize() (s int) {
	// Calculating size of slice: z
	s += msgp.ArrayHeaderSize + ((100000) * (SignedTxnInBlockMaxSize()))
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *ResourceRef) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0001Len := uint32(6)
	var zb0001Mask uint8 /* 7 bits */
	if ((*z).Box.Index == 0) && (len((*z).Box.Name) == 0) {
		zb0001Len--
		zb0001Mask |= 0x2
	}
	if (*z).Address.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x4
	}
	if ((*z).Holding.Address == 0) && ((*z).Holding.Asset == 0) {
		zb0001Len--
		zb0001Mask |= 0x8
	}
	if ((*z).Locals.Address == 0) && ((*z).Locals.App == 0) {
		zb0001Len--
		zb0001Mask |= 0x10
	}
	if (*z).App.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x20
	}
	if (*z).Asset.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x40
	}
	// variable map header, size zb0001Len
	o = append(o, 0x80|uint8(zb0001Len))
	if zb0001Len != 0 {
		if (zb0001Mask & 0x2) == 0 { // if not empty
			// string "b"
			o = append(o, 0xa1, 0x62)
			// omitempty: check for empty values
			zb0002Len := uint32(2)
			var zb0002Mask uint8 /* 3 bits */
			if (*z).Box.Index == 0 {
				zb0002Len--
				zb0002Mask |= 0x2
			}
			if len((*z).Box.Name) == 0 {
				zb0002Len--
				zb0002Mask |= 0x4
			}
			// variable map header, size zb0002Len
			o = append(o, 0x80|uint8(zb0002Len))
			if (zb0002Mask & 0x2) == 0 { // if not empty
				// string "i"
				o = append(o, 0xa1, 0x69)
				o = msgp.AppendUint64(o, (*z).Box.Index)
			}
			if (zb0002Mask & 0x4) == 0 { // if not empty
				// string "n"
				o = append(o, 0xa1, 0x6e)
				o = msgp.AppendBytes(o, (*z).Box.Name)
			}
		}
		if (zb0001Mask & 0x4) == 0 { // if not empty
			// string "d"
			o = append(o, 0xa1, 0x64)
			o = (*z).Address.MarshalMsg(o)
		}
		if (zb0001Mask & 0x8) == 0 { // if not empty
			// string "h"
			o = append(o, 0xa1, 0x68)
			// omitempty: check for empty values
			zb0003Len := uint32(2)
			var zb0003Mask uint8 /* 3 bits */
			if (*z).Holding.Address == 0 {
				zb0003Len--
				zb0003Mask |= 0x2
			}
			if (*z).Holding.Asset == 0 {
				zb0003Len--
				zb0003Mask |= 0x4
			}
			// variable map header, size zb0003Len
			o = append(o, 0x80|uint8(zb0003Len))
			if (zb0003Mask & 0x2) == 0 { // if not empty
				// string "d"
				o = append(o, 0xa1, 0x64)
				o = msgp.AppendUint64(o, (*z).Holding.Address)
			}
			if (zb0003Mask & 0x4) == 0 { // if not empty
				// string "s"
				o = append(o, 0xa1, 0x73)
				o = msgp.AppendUint64(o, (*z).Holding.Asset)
			}
		}
		if (zb0001Mask & 0x10) == 0 { // if not empty
			// string "l"
			o = append(o, 0xa1, 0x6c)
			// omitempty: check for empty values
			zb0004Len := uint32(2)
			var zb0004Mask uint8 /* 3 bits */
			if (*z).Locals.Address == 0 {
				zb0004Len--
				zb0004Mask |= 0x2
			}
			if (*z).Locals.App == 0 {
				zb0004Len--
				zb0004Mask |= 0x4
			}
			// variable map header, size zb0004Len
			o = append(o, 0x80|uint8(zb0004Len))
			if (zb0004Mask & 0x2) == 0 { // if not empty
				// string "d"
				o = append(o, 0xa1, 0x64)
				o = msgp.AppendUint64(o, (*z).Locals.Address)
			}
			if (zb0004Mask & 0x4) == 0 { // if not empty
				// string "p"
				o = append(o, 0xa1, 0x70)
				o = msgp.AppendUint64(o, (*z).Locals.App)
			}
		}
		if (zb0001Mask & 0x20) == 0 { // if not empty
			// string "p"
			o = append(o, 0xa1, 0x70)
			o = (*z).App.MarshalMsg(o)
		}
		if (zb0001Mask & 0x40) == 0 { // if not empty
			// string "s"
			o = append(o, 0xa1, 0x73)
			o = (*z).Asset.MarshalMsg(o)
		}
	}
	return
}

func (_ *ResourceRef) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*ResourceRef)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *ResourceRef) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0001 int
	var zb0002 bool
	zb0001, zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0001, zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).Address.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Address")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).Asset.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Asset")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).App.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "App")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			var zb0003 int
			var zb0004 bool
			zb0003, zb0004, bts, err = msgp.ReadMapHeaderBytes(bts)
			if _, ok := err.(msgp.TypeError); ok {
				zb0003, zb0004, bts, err = msgp.ReadArrayHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Holding")
					return
				}
				if zb0003 > 0 {
					zb0003--
					(*z).Holding.Address, bts, err = msgp.ReadUint64Bytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "Holding", "struct-from-array", "Address")
						return
					}
				}
				if zb0003 > 0 {
					zb0003--
					(*z).Holding.Asset, bts, err = msgp.ReadUint64Bytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "Holding", "struct-from-array", "Asset")
						return
					}
				}
				if zb0003 > 0 {
					err = msgp.ErrTooManyArrayFields(zb0003)
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "Holding", "struct-from-array")
						return
					}
				}
			} else {
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Holding")
					return
				}
				if zb0004 {
					(*z).Holding = HoldingRef{}
				}
				for zb0003 > 0 {
					zb0003--
					field, bts, err = msgp.ReadMapKeyZC(bts)
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "Holding")
						return
					}
					switch string(field) {
					case "d":
						(*z).Holding.Address, bts, err = msgp.ReadUint64Bytes(bts)
						if err != nil {
							err = msgp.WrapError(err, "struct-from-array", "Holding", "Address")
							return
						}
					case "s":
						(*z).Holding.Asset, bts, err = msgp.ReadUint64Bytes(bts)
						if err != nil {
							err = msgp.WrapError(err, "struct-from-array", "Holding", "Asset")
							return
						}
					default:
						err = msgp.ErrNoField(string(field))
						if err != nil {
							err = msgp.WrapError(err, "struct-from-array", "Holding")
							return
						}
					}
				}
			}
		}
		if zb0001 > 0 {
			zb0001--
			var zb0005 int
			var zb0006 bool
			zb0005, zb0006, bts, err = msgp.ReadMapHeaderBytes(bts)
			if _, ok := err.(msgp.TypeError); ok {
				zb0005, zb0006, bts, err = msgp.ReadArrayHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Locals")
					return
				}
				if zb0005 > 0 {
					zb0005--
					(*z).Locals.Address, bts, err = msgp.ReadUint64Bytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "Locals", "struct-from-array", "Address")
						return
					}
				}
				if zb0005 > 0 {
					zb0005--
					(*z).Locals.App, bts, err = msgp.ReadUint64Bytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "Locals", "struct-from-array", "App")
						return
					}
				}
				if zb0005 > 0 {
					err = msgp.ErrTooManyArrayFields(zb0005)
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "Locals", "struct-from-array")
						return
					}
				}
			} else {
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Locals")
					return
				}
				if zb0006 {
					(*z).Locals = LocalsRef{}
				}
				for zb0005 > 0 {
					zb0005--
					field, bts, err = msgp.ReadMapKeyZC(bts)
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "Locals")
						return
					}
					switch string(field) {
					case "d":
						(*z).Locals.Address, bts, err = msgp.ReadUint64Bytes(bts)
						if err != nil {
							err = msgp.WrapError(err, "struct-from-array", "Locals", "Address")
							return
						}
					case "p":
						(*z).Locals.App, bts, err = msgp.ReadUint64Bytes(bts)
						if err != nil {
							err = msgp.WrapError(err, "struct-from-array", "Locals", "App")
							return
						}
					default:
						err = msgp.ErrNoField(string(field))
						if err != nil {
							err = msgp.WrapError(err, "struct-from-array", "Locals")
							return
						}
					}
				}
			}
		}
		if zb0001 > 0 {
			zb0001--
			var zb0007 int
			var zb0008 bool
			zb0007, zb0008, bts, err = msgp.ReadMapHeaderBytes(bts)
			if _, ok := err.(msgp.TypeError); ok {
				zb0007, zb0008, bts, err = msgp.ReadArrayHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Box")
					return
				}
				if zb0007 > 0 {
					zb0007--
					(*z).Box.Index, bts, err = msgp.ReadUint64Bytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "Box", "struct-from-array", "Index")
						return
					}
				}
				if zb0007 > 0 {
					zb0007--
					var zb0009 int
					zb0009, err = msgp.ReadBytesBytesHeader(bts)
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "Box", "struct-from-array", "Name")
						return
					}
					if zb0009 > bounds.MaxBytesKeyValueLen {
						err = msgp.ErrOverflow(uint64(zb0009), uint64(bounds.MaxBytesKeyValueLen))
						return
					}
					(*z).Box.Name, bts, err = msgp.ReadBytesBytes(bts, (*z).Box.Name)
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "Box", "struct-from-array", "Name")
						return
					}
				}
				if zb0007 > 0 {
					err = msgp.ErrTooManyArrayFields(zb0007)
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "Box", "struct-from-array")
						return
					}
				}
			} else {
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Box")
					return
				}
				if zb0008 {
					(*z).Box = BoxRef{}
				}
				for zb0007 > 0 {
					zb0007--
					field, bts, err = msgp.ReadMapKeyZC(bts)
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "Box")
						return
					}
					switch string(field) {
					case "i":
						(*z).Box.Index, bts, err = msgp.ReadUint64Bytes(bts)
						if err != nil {
							err = msgp.WrapError(err, "struct-from-array", "Box", "Index")
							return
						}
					case "n":
						var zb0010 int
						zb0010, err = msgp.ReadBytesBytesHeader(bts)
						if err != nil {
							err = msgp.WrapError(err, "struct-from-array", "Box", "Name")
							return
						}
						if zb0010 > bounds.MaxBytesKeyValueLen {
							err = msgp.ErrOverflow(uint64(zb0010), uint64(bounds.MaxBytesKeyValueLen))
							return
						}
						(*z).Box.Name, bts, err = msgp.ReadBytesBytes(bts, (*z).Box.Name)
						if err != nil {
							err = msgp.WrapError(err, "struct-from-array", "Box", "Name")
							return
						}
					default:
						err = msgp.ErrNoField(string(field))
						if err != nil {
							err = msgp.WrapError(err, "struct-from-array", "Box")
							return
						}
					}
				}
			}
		}
		if zb0001 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0001)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 {
			(*z) = ResourceRef{}
		}
		for zb0001 > 0 {
			zb0001--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "d":
				bts, err = (*z).Address.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Address")
					return
				}
			case "s":
				bts, err = (*z).Asset.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Asset")
					return
				}
			case "p":
				bts, err = (*z).App.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "App")
					return
				}
			case "h":
				var zb0011 int
				var zb0012 bool
				zb0011, zb0012, bts, err = msgp.ReadMapHeaderBytes(bts)
				if _, ok := err.(msgp.TypeError); ok {
					zb0011, zb0012, bts, err = msgp.ReadArrayHeaderBytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "Holding")
						return
					}
					if zb0011 > 0 {
						zb0011--
						(*z).Holding.Address, bts, err = msgp.ReadUint64Bytes(bts)
						if err != nil {
							err = msgp.WrapError(err, "Holding", "struct-from-array", "Address")
							return
						}
					}
					if zb0011 > 0 {
						zb0011--
						(*z).Holding.Asset, bts, err = msgp.ReadUint64Bytes(bts)
						if err != nil {
							err = msgp.WrapError(err, "Holding", "struct-from-array", "Asset")
							return
						}
					}
					if zb0011 > 0 {
						err = msgp.ErrTooManyArrayFields(zb0011)
						if err != nil {
							err = msgp.WrapError(err, "Holding", "struct-from-array")
							return
						}
					}
				} else {
					if err != nil {
						err = msgp.WrapError(err, "Holding")
						return
					}
					if zb0012 {
						(*z).Holding = HoldingRef{}
					}
					for zb0011 > 0 {
						zb0011--
						field, bts, err = msgp.ReadMapKeyZC(bts)
						if err != nil {
							err = msgp.WrapError(err, "Holding")
							return
						}
						switch string(field) {
						case "d":
							(*z).Holding.Address, bts, err = msgp.ReadUint64Bytes(bts)
							if err != nil {
								err = msgp.WrapError(err, "Holding", "Address")
								return
							}
						case "s":
							(*z).Holding.Asset, bts, err = msgp.ReadUint64Bytes(bts)
							if err != nil {
								err = msgp.WrapError(err, "Holding", "Asset")
								return
							}
						default:
							err = msgp.ErrNoField(string(field))
							if err != nil {
								err = msgp.WrapError(err, "Holding")
								return
							}
						}
					}
				}
			case "l":
				var zb0013 int
				var zb0014 bool
				zb0013, zb0014, bts, err = msgp.ReadMapHeaderBytes(bts)
				if _, ok := err.(msgp.TypeError); ok {
					zb0013, zb0014, bts, err = msgp.ReadArrayHeaderBytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "Locals")
						return
					}
					if zb0013 > 0 {
						zb0013--
						(*z).Locals.Address, bts, err = msgp.ReadUint64Bytes(bts)
						if err != nil {
							err = msgp.WrapError(err, "Locals", "struct-from-array", "Address")
							return
						}
					}
					if zb0013 > 0 {
						zb0013--
						(*z).Locals.App, bts, err = msgp.ReadUint64Bytes(bts)
						if err != nil {
							err = msgp.WrapError(err, "Locals", "struct-from-array", "App")
							return
						}
					}
					if zb0013 > 0 {
						err = msgp.ErrTooManyArrayFields(zb0013)
						if err != nil {
							err = msgp.WrapError(err, "Locals", "struct-from-array")
							return
						}
					}
				} else {
					if err != nil {
						err = msgp.WrapError(err, "Locals")
						return
					}
					if zb0014 {
						(*z).Locals = LocalsRef{}
					}
					for zb0013 > 0 {
						zb0013--
						field, bts, err = msgp.ReadMapKeyZC(bts)
						if err != nil {
							err = msgp.WrapError(err, "Locals")
							return
						}
						switch string(field) {
						case "d":
							(*z).Locals.Address, bts, err = msgp.ReadUint64Bytes(bts)
							if err != nil {
								err = msgp.WrapError(err, "Locals", "Address")
								return
							}
						case "p":
							(*z).Locals.App, bts, err = msgp.ReadUint64Bytes(bts)
							if err != nil {
								err = msgp.WrapError(err, "Locals", "App")
								return
							}
						default:
							err = msgp.ErrNoField(string(field))
							if err != nil {
								err = msgp.WrapError(err, "Locals")
								return
							}
						}
					}
				}
			case "b":
				var zb0015 int
				var zb0016 bool
				zb0015, zb0016, bts, err = msgp.ReadMapHeaderBytes(bts)
				if _, ok := err.(msgp.TypeError); ok {
					zb0015, zb0016, bts, err = msgp.ReadArrayHeaderBytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "Box")
						return
					}
					if zb0015 > 0 {
						zb0015--
						(*z).Box.Index, bts, err = msgp.ReadUint64Bytes(bts)
						if err != nil {
							err = msgp.WrapError(err, "Box", "struct-from-array", "Index")
							return
						}
					}
					if zb0015 > 0 {
						zb0015--
						var zb0017 int
						zb0017, err = msgp.ReadBytesBytesHeader(bts)
						if err != nil {
							err = msgp.WrapError(err, "Box", "struct-from-array", "Name")
							return
						}
						if zb0017 > bounds.MaxBytesKeyValueLen {
							err = msgp.ErrOverflow(uint64(zb0017), uint64(bounds.MaxBytesKeyValueLen))
							return
						}
						(*z).Box.Name, bts, err = msgp.ReadBytesBytes(bts, (*z).Box.Name)
						if err != nil {
							err = msgp.WrapError(err, "Box", "struct-from-array", "Name")
							return
						}
					}
					if zb0015 > 0 {
						err = msgp.ErrTooManyArrayFields(zb0015)
						if err != nil {
							err = msgp.WrapError(err, "Box", "struct-from-array")
							return
						}
					}
				} else {
					if err != nil {
						err = msgp.WrapError(err, "Box")
						return
					}
					if zb0016 {
						(*z).Box = BoxRef{}
					}
					for zb0015 > 0 {
						zb0015--
						field, bts, err = msgp.ReadMapKeyZC(bts)
						if err != nil {
							err = msgp.WrapError(err, "Box")
							return
						}
						switch string(field) {
						case "i":
							(*z).Box.Index, bts, err = msgp.ReadUint64Bytes(bts)
							if err != nil {
								err = msgp.WrapError(err, "Box", "Index")
								return
							}
						case "n":
							var zb0018 int
							zb0018, err = msgp.ReadBytesBytesHeader(bts)
							if err != nil {
								err = msgp.WrapError(err, "Box", "Name")
								return
							}
							if zb0018 > bounds.MaxBytesKeyValueLen {
								err = msgp.ErrOverflow(uint64(zb0018), uint64(bounds.MaxBytesKeyValueLen))
								return
							}
							(*z).Box.Name, bts, err = msgp.ReadBytesBytes(bts, (*z).Box.Name)
							if err != nil {
								err = msgp.WrapError(err, "Box", "Name")
								return
							}
						default:
							err = msgp.ErrNoField(string(field))
							if err != nil {
								err = msgp.WrapError(err, "Box")
								return
							}
						}
					}
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *ResourceRef) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *ResourceRef) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*ResourceRef)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *ResourceRef) Msgsize() (s int) {
	s = 1 + 2 + (*z).Address.Msgsize() + 2 + (*z).Asset.Msgsize() + 2 + (*z).App.Msgsize() + 2 + 1 + 2 + msgp.Uint64Size + 2 + msgp.Uint64Size + 2 + 1 + 2 + msgp.Uint64Size + 2 + msgp.Uint64Size + 2 + 1 + 2 + msgp.Uint64Size + 2 + msgp.BytesPrefixSize + len((*z).Box.Name)
	return
}

// MsgIsZero returns whether this is a zero value
func (z *ResourceRef) MsgIsZero() bool {
	return ((*z).Address.MsgIsZero()) && ((*z).Asset.MsgIsZero()) && ((*z).App.MsgIsZero()) && (((*z).Holding.Address == 0) && ((*z).Holding.Asset == 0)) && (((*z).Locals.Address == 0) && ((*z).Locals.App == 0)) && (((*z).Box.Index == 0) && (len((*z).Box.Name) == 0))
}

// MaxSize returns a maximum valid message size for this message type
func ResourceRefMaxSize() (s int) {
	s = 1 + 2 + basics.AddressMaxSize() + 2 + basics.AssetIndexMaxSize() + 2 + basics.AppIndexMaxSize() + 2 + 1 + 2 + msgp.Uint64Size + 2 + msgp.Uint64Size + 2 + 1 + 2 + msgp.Uint64Size + 2 + msgp.Uint64Size + 2 + 1 + 2 + msgp.Uint64Size + 2 + msgp.BytesPrefixSize + bounds.MaxBytesKeyValueLen
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *SignedTxn) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0001Len := uint32(5)
	var zb0001Mask uint8 /* 6 bits */
	if (*z).Lsig.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x2
	}
	if (*z).Msig.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x4
	}
	if (*z).AuthAddr.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x8
	}
	if (*z).Sig.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x10
	}
	if (*z).Txn.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x20
	}
	// variable map header, size zb0001Len
	o = append(o, 0x80|uint8(zb0001Len))
	if zb0001Len != 0 {
		if (zb0001Mask & 0x2) == 0 { // if not empty
			// string "lsig"
			o = append(o, 0xa4, 0x6c, 0x73, 0x69, 0x67)
			o = (*z).Lsig.MarshalMsg(o)
		}
		if (zb0001Mask & 0x4) == 0 { // if not empty
			// string "msig"
			o = append(o, 0xa4, 0x6d, 0x73, 0x69, 0x67)
			o = (*z).Msig.MarshalMsg(o)
		}
		if (zb0001Mask & 0x8) == 0 { // if not empty
			// string "sgnr"
			o = append(o, 0xa4, 0x73, 0x67, 0x6e, 0x72)
			o = (*z).AuthAddr.MarshalMsg(o)
		}
		if (zb0001Mask & 0x10) == 0 { // if not empty
			// string "sig"
			o = append(o, 0xa3, 0x73, 0x69, 0x67)
			o = (*z).Sig.MarshalMsg(o)
		}
		if (zb0001Mask & 0x20) == 0 { // if not empty
			// string "txn"
			o = append(o, 0xa3, 0x74, 0x78, 0x6e)
			o = (*z).Txn.MarshalMsg(o)
		}
	}
	return
}

func (_ *SignedTxn) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*SignedTxn)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *SignedTxn) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0001 int
	var zb0002 bool
	zb0001, zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0001, zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).Sig.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Sig")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).Msig.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Msig")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).Lsig.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Lsig")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).Txn.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Txn")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).AuthAddr.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "AuthAddr")
				return
			}
		}
		if zb0001 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0001)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 {
			(*z) = SignedTxn{}
		}
		for zb0001 > 0 {
			zb0001--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "sig":
				bts, err = (*z).Sig.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Sig")
					return
				}
			case "msig":
				bts, err = (*z).Msig.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Msig")
					return
				}
			case "lsig":
				bts, err = (*z).Lsig.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Lsig")
					return
				}
			case "txn":
				bts, err = (*z).Txn.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Txn")
					return
				}
			case "sgnr":
				bts, err = (*z).AuthAddr.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "AuthAddr")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *SignedTxn) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *SignedTxn) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*SignedTxn)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *SignedTxn) Msgsize() (s int) {
	s = 1 + 4 + (*z).Sig.Msgsize() + 5 + (*z).Msig.Msgsize() + 5 + (*z).Lsig.Msgsize() + 4 + (*z).Txn.Msgsize() + 5 + (*z).AuthAddr.Msgsize()
	return
}

// MsgIsZero returns whether this is a zero value
func (z *SignedTxn) MsgIsZero() bool {
	return ((*z).Sig.MsgIsZero()) && ((*z).Msig.MsgIsZero()) && ((*z).Lsig.MsgIsZero()) && ((*z).Txn.MsgIsZero()) && ((*z).AuthAddr.MsgIsZero())
}

// MaxSize returns a maximum valid message size for this message type
func SignedTxnMaxSize() (s int) {
	s = 1 + 4 + crypto.SignatureMaxSize() + 5 + crypto.MultisigSigMaxSize() + 5 + LogicSigMaxSize() + 4 + TransactionMaxSize() + 5 + basics.AddressMaxSize()
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *SignedTxnInBlock) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0001Len := uint32(15)
	var zb0001Mask uint32 /* 19 bits */
	if (*z).SignedTxnWithAD.ApplyData.AssetClosingAmount == 0 {
		zb0001Len--
		zb0001Mask |= 0x10
	}
	if (*z).SignedTxnWithAD.ApplyData.ApplicationID.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x20
	}
	if (*z).SignedTxnWithAD.ApplyData.ClosingAmount.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x40
	}
	if (*z).SignedTxnWithAD.ApplyData.ConfigAsset.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x80
	}
	if (*z).SignedTxnWithAD.ApplyData.EvalDelta.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x100
	}
	if (*z).HasGenesisHash == false {
		zb0001Len--
		zb0001Mask |= 0x200
	}
	if (*z).HasGenesisID == false {
		zb0001Len--
		zb0001Mask |= 0x400
	}
	if (*z).SignedTxnWithAD.SignedTxn.Lsig.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x800
	}
	if (*z).SignedTxnWithAD.SignedTxn.Msig.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x1000
	}
	if (*z).SignedTxnWithAD.ApplyData.CloseRewards.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x2000
	}
	if (*z).SignedTxnWithAD.ApplyData.ReceiverRewards.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x4000
	}
	if (*z).SignedTxnWithAD.ApplyData.SenderRewards.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x8000
	}
	if (*z).SignedTxnWithAD.SignedTxn.AuthAddr.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x10000
	}
	if (*z).SignedTxnWithAD.SignedTxn.Sig.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x20000
	}
	if (*z).SignedTxnWithAD.SignedTxn.Txn.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x40000
	}
	// variable map header, size zb0001Len
	o = append(o, 0x80|uint8(zb0001Len))
	if zb0001Len != 0 {
		if (zb0001Mask & 0x10) == 0 { // if not empty
			// string "aca"
			o = append(o, 0xa3, 0x61, 0x63, 0x61)
			o = msgp.AppendUint64(o, (*z).SignedTxnWithAD.ApplyData.AssetClosingAmount)
		}
		if (zb0001Mask & 0x20) == 0 { // if not empty
			// string "apid"
			o = append(o, 0xa4, 0x61, 0x70, 0x69, 0x64)
			o = (*z).SignedTxnWithAD.ApplyData.ApplicationID.MarshalMsg(o)
		}
		if (zb0001Mask & 0x40) == 0 { // if not empty
			// string "ca"
			o = append(o, 0xa2, 0x63, 0x61)
			o = (*z).SignedTxnWithAD.ApplyData.ClosingAmount.MarshalMsg(o)
		}
		if (zb0001Mask & 0x80) == 0 { // if not empty
			// string "caid"
			o = append(o, 0xa4, 0x63, 0x61, 0x69, 0x64)
			o = (*z).SignedTxnWithAD.ApplyData.ConfigAsset.MarshalMsg(o)
		}
		if (zb0001Mask & 0x100) == 0 { // if not empty
			// string "dt"
			o = append(o, 0xa2, 0x64, 0x74)
			o = (*z).SignedTxnWithAD.ApplyData.EvalDelta.MarshalMsg(o)
		}
		if (zb0001Mask & 0x200) == 0 { // if not empty
			// string "hgh"
			o = append(o, 0xa3, 0x68, 0x67, 0x68)
			o = msgp.AppendBool(o, (*z).HasGenesisHash)
		}
		if (zb0001Mask & 0x400) == 0 { // if not empty
			// string "hgi"
			o = append(o, 0xa3, 0x68, 0x67, 0x69)
			o = msgp.AppendBool(o, (*z).HasGenesisID)
		}
		if (zb0001Mask & 0x800) == 0 { // if not empty
			// string "lsig"
			o = append(o, 0xa4, 0x6c, 0x73, 0x69, 0x67)
			o = (*z).SignedTxnWithAD.SignedTxn.Lsig.MarshalMsg(o)
		}
		if (zb0001Mask & 0x1000) == 0 { // if not empty
			// string "msig"
			o = append(o, 0xa4, 0x6d, 0x73, 0x69, 0x67)
			o = (*z).SignedTxnWithAD.SignedTxn.Msig.MarshalMsg(o)
		}
		if (zb0001Mask & 0x2000) == 0 { // if not empty
			// string "rc"
			o = append(o, 0xa2, 0x72, 0x63)
			o = (*z).SignedTxnWithAD.ApplyData.CloseRewards.MarshalMsg(o)
		}
		if (zb0001Mask & 0x4000) == 0 { // if not empty
			// string "rr"
			o = append(o, 0xa2, 0x72, 0x72)
			o = (*z).SignedTxnWithAD.ApplyData.ReceiverRewards.MarshalMsg(o)
		}
		if (zb0001Mask & 0x8000) == 0 { // if not empty
			// string "rs"
			o = append(o, 0xa2, 0x72, 0x73)
			o = (*z).SignedTxnWithAD.ApplyData.SenderRewards.MarshalMsg(o)
		}
		if (zb0001Mask & 0x10000) == 0 { // if not empty
			// string "sgnr"
			o = append(o, 0xa4, 0x73, 0x67, 0x6e, 0x72)
			o = (*z).SignedTxnWithAD.SignedTxn.AuthAddr.MarshalMsg(o)
		}
		if (zb0001Mask & 0x20000) == 0 { // if not empty
			// string "sig"
			o = append(o, 0xa3, 0x73, 0x69, 0x67)
			o = (*z).SignedTxnWithAD.SignedTxn.Sig.MarshalMsg(o)
		}
		if (zb0001Mask & 0x40000) == 0 { // if not empty
			// string "txn"
			o = append(o, 0xa3, 0x74, 0x78, 0x6e)
			o = (*z).SignedTxnWithAD.SignedTxn.Txn.MarshalMsg(o)
		}
	}
	return
}

func (_ *SignedTxnInBlock) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*SignedTxnInBlock)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *SignedTxnInBlock) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0001 int
	var zb0002 bool
	zb0001, zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0001, zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).SignedTxnWithAD.SignedTxn.Sig.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Sig")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).SignedTxnWithAD.SignedTxn.Msig.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Msig")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).SignedTxnWithAD.SignedTxn.Lsig.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Lsig")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).SignedTxnWithAD.SignedTxn.Txn.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Txn")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).SignedTxnWithAD.SignedTxn.AuthAddr.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "AuthAddr")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).SignedTxnWithAD.ApplyData.ClosingAmount.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "ClosingAmount")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			(*z).SignedTxnWithAD.ApplyData.AssetClosingAmount, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "AssetClosingAmount")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).SignedTxnWithAD.ApplyData.SenderRewards.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "SenderRewards")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).SignedTxnWithAD.ApplyData.ReceiverRewards.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "ReceiverRewards")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).SignedTxnWithAD.ApplyData.CloseRewards.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "CloseRewards")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).SignedTxnWithAD.ApplyData.EvalDelta.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "EvalDelta")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).SignedTxnWithAD.ApplyData.ConfigAsset.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "ConfigAsset")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).SignedTxnWithAD.ApplyData.ApplicationID.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "ApplicationID")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			(*z).HasGenesisID, bts, err = msgp.ReadBoolBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "HasGenesisID")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			(*z).HasGenesisHash, bts, err = msgp.ReadBoolBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "HasGenesisHash")
				return
			}
		}
		if zb0001 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0001)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 {
			(*z) = SignedTxnInBlock{}
		}
		for zb0001 > 0 {
			zb0001--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "sig":
				bts, err = (*z).SignedTxnWithAD.SignedTxn.Sig.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Sig")
					return
				}
			case "msig":
				bts, err = (*z).SignedTxnWithAD.SignedTxn.Msig.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Msig")
					return
				}
			case "lsig":
				bts, err = (*z).SignedTxnWithAD.SignedTxn.Lsig.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Lsig")
					return
				}
			case "txn":
				bts, err = (*z).SignedTxnWithAD.SignedTxn.Txn.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Txn")
					return
				}
			case "sgnr":
				bts, err = (*z).SignedTxnWithAD.SignedTxn.AuthAddr.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "AuthAddr")
					return
				}
			case "ca":
				bts, err = (*z).SignedTxnWithAD.ApplyData.ClosingAmount.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "ClosingAmount")
					return
				}
			case "aca":
				(*z).SignedTxnWithAD.ApplyData.AssetClosingAmount, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "AssetClosingAmount")
					return
				}
			case "rs":
				bts, err = (*z).SignedTxnWithAD.ApplyData.SenderRewards.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "SenderRewards")
					return
				}
			case "rr":
				bts, err = (*z).SignedTxnWithAD.ApplyData.ReceiverRewards.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "ReceiverRewards")
					return
				}
			case "rc":
				bts, err = (*z).SignedTxnWithAD.ApplyData.CloseRewards.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "CloseRewards")
					return
				}
			case "dt":
				bts, err = (*z).SignedTxnWithAD.ApplyData.EvalDelta.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "EvalDelta")
					return
				}
			case "caid":
				bts, err = (*z).SignedTxnWithAD.ApplyData.ConfigAsset.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "ConfigAsset")
					return
				}
			case "apid":
				bts, err = (*z).SignedTxnWithAD.ApplyData.ApplicationID.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "ApplicationID")
					return
				}
			case "hgi":
				(*z).HasGenesisID, bts, err = msgp.ReadBoolBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "HasGenesisID")
					return
				}
			case "hgh":
				(*z).HasGenesisHash, bts, err = msgp.ReadBoolBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "HasGenesisHash")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *SignedTxnInBlock) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *SignedTxnInBlock) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*SignedTxnInBlock)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *SignedTxnInBlock) Msgsize() (s int) {
	s = 1 + 4 + (*z).SignedTxnWithAD.SignedTxn.Sig.Msgsize() + 5 + (*z).SignedTxnWithAD.SignedTxn.Msig.Msgsize() + 5 + (*z).SignedTxnWithAD.SignedTxn.Lsig.Msgsize() + 4 + (*z).SignedTxnWithAD.SignedTxn.Txn.Msgsize() + 5 + (*z).SignedTxnWithAD.SignedTxn.AuthAddr.Msgsize() + 3 + (*z).SignedTxnWithAD.ApplyData.ClosingAmount.Msgsize() + 4 + msgp.Uint64Size + 3 + (*z).SignedTxnWithAD.ApplyData.SenderRewards.Msgsize() + 3 + (*z).SignedTxnWithAD.ApplyData.ReceiverRewards.Msgsize() + 3 + (*z).SignedTxnWithAD.ApplyData.CloseRewards.Msgsize() + 3 + (*z).SignedTxnWithAD.ApplyData.EvalDelta.Msgsize() + 5 + (*z).SignedTxnWithAD.ApplyData.ConfigAsset.Msgsize() + 5 + (*z).SignedTxnWithAD.ApplyData.ApplicationID.Msgsize() + 4 + msgp.BoolSize + 4 + msgp.BoolSize
	return
}

// MsgIsZero returns whether this is a zero value
func (z *SignedTxnInBlock) MsgIsZero() bool {
	return ((*z).SignedTxnWithAD.SignedTxn.Sig.MsgIsZero()) && ((*z).SignedTxnWithAD.SignedTxn.Msig.MsgIsZero()) && ((*z).SignedTxnWithAD.SignedTxn.Lsig.MsgIsZero()) && ((*z).SignedTxnWithAD.SignedTxn.Txn.MsgIsZero()) && ((*z).SignedTxnWithAD.SignedTxn.AuthAddr.MsgIsZero()) && ((*z).SignedTxnWithAD.ApplyData.ClosingAmount.MsgIsZero()) && ((*z).SignedTxnWithAD.ApplyData.AssetClosingAmount == 0) && ((*z).SignedTxnWithAD.ApplyData.SenderRewards.MsgIsZero()) && ((*z).SignedTxnWithAD.ApplyData.ReceiverRewards.MsgIsZero()) && ((*z).SignedTxnWithAD.ApplyData.CloseRewards.MsgIsZero()) && ((*z).SignedTxnWithAD.ApplyData.EvalDelta.MsgIsZero()) && ((*z).SignedTxnWithAD.ApplyData.ConfigAsset.MsgIsZero()) && ((*z).SignedTxnWithAD.ApplyData.ApplicationID.MsgIsZero()) && ((*z).HasGenesisID == false) && ((*z).HasGenesisHash == false)
}

// MaxSize returns a maximum valid message size for this message type
func SignedTxnInBlockMaxSize() (s int) {
	s = 1 + 4 + crypto.SignatureMaxSize() + 5 + crypto.MultisigSigMaxSize() + 5 + LogicSigMaxSize() + 4 + TransactionMaxSize() + 5 + basics.AddressMaxSize() + 3 + basics.MicroAlgosMaxSize() + 4 + msgp.Uint64Size + 3 + basics.MicroAlgosMaxSize() + 3 + basics.MicroAlgosMaxSize() + 3 + basics.MicroAlgosMaxSize() + 3 + EvalDeltaMaxSize() + 5 + basics.AssetIndexMaxSize() + 5 + basics.AppIndexMaxSize() + 4 + msgp.BoolSize + 4 + msgp.BoolSize
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *SignedTxnWithAD) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0001Len := uint32(13)
	var zb0001Mask uint16 /* 16 bits */
	if (*z).ApplyData.AssetClosingAmount == 0 {
		zb0001Len--
		zb0001Mask |= 0x8
	}
	if (*z).ApplyData.ApplicationID.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x10
	}
	if (*z).ApplyData.ClosingAmount.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x20
	}
	if (*z).ApplyData.ConfigAsset.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x40
	}
	if (*z).ApplyData.EvalDelta.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x80
	}
	if (*z).SignedTxn.Lsig.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x100
	}
	if (*z).SignedTxn.Msig.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x200
	}
	if (*z).ApplyData.CloseRewards.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x400
	}
	if (*z).ApplyData.ReceiverRewards.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x800
	}
	if (*z).ApplyData.SenderRewards.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x1000
	}
	if (*z).SignedTxn.AuthAddr.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x2000
	}
	if (*z).SignedTxn.Sig.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x4000
	}
	if (*z).SignedTxn.Txn.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x8000
	}
	// variable map header, size zb0001Len
	o = append(o, 0x80|uint8(zb0001Len))
	if zb0001Len != 0 {
		if (zb0001Mask & 0x8) == 0 { // if not empty
			// string "aca"
			o = append(o, 0xa3, 0x61, 0x63, 0x61)
			o = msgp.AppendUint64(o, (*z).ApplyData.AssetClosingAmount)
		}
		if (zb0001Mask & 0x10) == 0 { // if not empty
			// string "apid"
			o = append(o, 0xa4, 0x61, 0x70, 0x69, 0x64)
			o = (*z).ApplyData.ApplicationID.MarshalMsg(o)
		}
		if (zb0001Mask & 0x20) == 0 { // if not empty
			// string "ca"
			o = append(o, 0xa2, 0x63, 0x61)
			o = (*z).ApplyData.ClosingAmount.MarshalMsg(o)
		}
		if (zb0001Mask & 0x40) == 0 { // if not empty
			// string "caid"
			o = append(o, 0xa4, 0x63, 0x61, 0x69, 0x64)
			o = (*z).ApplyData.ConfigAsset.MarshalMsg(o)
		}
		if (zb0001Mask & 0x80) == 0 { // if not empty
			// string "dt"
			o = append(o, 0xa2, 0x64, 0x74)
			o = (*z).ApplyData.EvalDelta.MarshalMsg(o)
		}
		if (zb0001Mask & 0x100) == 0 { // if not empty
			// string "lsig"
			o = append(o, 0xa4, 0x6c, 0x73, 0x69, 0x67)
			o = (*z).SignedTxn.Lsig.MarshalMsg(o)
		}
		if (zb0001Mask & 0x200) == 0 { // if not empty
			// string "msig"
			o = append(o, 0xa4, 0x6d, 0x73, 0x69, 0x67)
			o = (*z).SignedTxn.Msig.MarshalMsg(o)
		}
		if (zb0001Mask & 0x400) == 0 { // if not empty
			// string "rc"
			o = append(o, 0xa2, 0x72, 0x63)
			o = (*z).ApplyData.CloseRewards.MarshalMsg(o)
		}
		if (zb0001Mask & 0x800) == 0 { // if not empty
			// string "rr"
			o = append(o, 0xa2, 0x72, 0x72)
			o = (*z).ApplyData.ReceiverRewards.MarshalMsg(o)
		}
		if (zb0001Mask & 0x1000) == 0 { // if not empty
			// string "rs"
			o = append(o, 0xa2, 0x72, 0x73)
			o = (*z).ApplyData.SenderRewards.MarshalMsg(o)
		}
		if (zb0001Mask & 0x2000) == 0 { // if not empty
			// string "sgnr"
			o = append(o, 0xa4, 0x73, 0x67, 0x6e, 0x72)
			o = (*z).SignedTxn.AuthAddr.MarshalMsg(o)
		}
		if (zb0001Mask & 0x4000) == 0 { // if not empty
			// string "sig"
			o = append(o, 0xa3, 0x73, 0x69, 0x67)
			o = (*z).SignedTxn.Sig.MarshalMsg(o)
		}
		if (zb0001Mask & 0x8000) == 0 { // if not empty
			// string "txn"
			o = append(o, 0xa3, 0x74, 0x78, 0x6e)
			o = (*z).SignedTxn.Txn.MarshalMsg(o)
		}
	}
	return
}

func (_ *SignedTxnWithAD) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*SignedTxnWithAD)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *SignedTxnWithAD) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0001 int
	var zb0002 bool
	zb0001, zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0001, zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).SignedTxn.Sig.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Sig")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).SignedTxn.Msig.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Msig")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).SignedTxn.Lsig.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Lsig")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).SignedTxn.Txn.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Txn")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).SignedTxn.AuthAddr.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "AuthAddr")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).ApplyData.ClosingAmount.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "ClosingAmount")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			(*z).ApplyData.AssetClosingAmount, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "AssetClosingAmount")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).ApplyData.SenderRewards.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "SenderRewards")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).ApplyData.ReceiverRewards.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "ReceiverRewards")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).ApplyData.CloseRewards.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "CloseRewards")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).ApplyData.EvalDelta.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "EvalDelta")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).ApplyData.ConfigAsset.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "ConfigAsset")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).ApplyData.ApplicationID.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "ApplicationID")
				return
			}
		}
		if zb0001 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0001)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 {
			(*z) = SignedTxnWithAD{}
		}
		for zb0001 > 0 {
			zb0001--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "sig":
				bts, err = (*z).SignedTxn.Sig.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Sig")
					return
				}
			case "msig":
				bts, err = (*z).SignedTxn.Msig.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Msig")
					return
				}
			case "lsig":
				bts, err = (*z).SignedTxn.Lsig.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Lsig")
					return
				}
			case "txn":
				bts, err = (*z).SignedTxn.Txn.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Txn")
					return
				}
			case "sgnr":
				bts, err = (*z).SignedTxn.AuthAddr.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "AuthAddr")
					return
				}
			case "ca":
				bts, err = (*z).ApplyData.ClosingAmount.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "ClosingAmount")
					return
				}
			case "aca":
				(*z).ApplyData.AssetClosingAmount, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "AssetClosingAmount")
					return
				}
			case "rs":
				bts, err = (*z).ApplyData.SenderRewards.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "SenderRewards")
					return
				}
			case "rr":
				bts, err = (*z).ApplyData.ReceiverRewards.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "ReceiverRewards")
					return
				}
			case "rc":
				bts, err = (*z).ApplyData.CloseRewards.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "CloseRewards")
					return
				}
			case "dt":
				bts, err = (*z).ApplyData.EvalDelta.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "EvalDelta")
					return
				}
			case "caid":
				bts, err = (*z).ApplyData.ConfigAsset.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "ConfigAsset")
					return
				}
			case "apid":
				bts, err = (*z).ApplyData.ApplicationID.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "ApplicationID")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *SignedTxnWithAD) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *SignedTxnWithAD) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*SignedTxnWithAD)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *SignedTxnWithAD) Msgsize() (s int) {
	s = 1 + 4 + (*z).SignedTxn.Sig.Msgsize() + 5 + (*z).SignedTxn.Msig.Msgsize() + 5 + (*z).SignedTxn.Lsig.Msgsize() + 4 + (*z).SignedTxn.Txn.Msgsize() + 5 + (*z).SignedTxn.AuthAddr.Msgsize() + 3 + (*z).ApplyData.ClosingAmount.Msgsize() + 4 + msgp.Uint64Size + 3 + (*z).ApplyData.SenderRewards.Msgsize() + 3 + (*z).ApplyData.ReceiverRewards.Msgsize() + 3 + (*z).ApplyData.CloseRewards.Msgsize() + 3 + (*z).ApplyData.EvalDelta.Msgsize() + 5 + (*z).ApplyData.ConfigAsset.Msgsize() + 5 + (*z).ApplyData.ApplicationID.Msgsize()
	return
}

// MsgIsZero returns whether this is a zero value
func (z *SignedTxnWithAD) MsgIsZero() bool {
	return ((*z).SignedTxn.Sig.MsgIsZero()) && ((*z).SignedTxn.Msig.MsgIsZero()) && ((*z).SignedTxn.Lsig.MsgIsZero()) && ((*z).SignedTxn.Txn.MsgIsZero()) && ((*z).SignedTxn.AuthAddr.MsgIsZero()) && ((*z).ApplyData.ClosingAmount.MsgIsZero()) && ((*z).ApplyData.AssetClosingAmount == 0) && ((*z).ApplyData.SenderRewards.MsgIsZero()) && ((*z).ApplyData.ReceiverRewards.MsgIsZero()) && ((*z).ApplyData.CloseRewards.MsgIsZero()) && ((*z).ApplyData.EvalDelta.MsgIsZero()) && ((*z).ApplyData.ConfigAsset.MsgIsZero()) && ((*z).ApplyData.ApplicationID.MsgIsZero())
}

// MaxSize returns a maximum valid message size for this message type
func SignedTxnWithADMaxSize() (s int) {
	s = 1 + 4 + crypto.SignatureMaxSize() + 5 + crypto.MultisigSigMaxSize() + 5 + LogicSigMaxSize() + 4 + TransactionMaxSize() + 5 + basics.AddressMaxSize() + 3 + basics.MicroAlgosMaxSize() + 4 + msgp.Uint64Size + 3 + basics.MicroAlgosMaxSize() + 3 + basics.MicroAlgosMaxSize() + 3 + basics.MicroAlgosMaxSize() + 3 + EvalDeltaMaxSize() + 5 + basics.AssetIndexMaxSize() + 5 + basics.AppIndexMaxSize()
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *StateProofTxnFields) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0001Len := uint32(3)
	var zb0001Mask uint8 /* 4 bits */
	if (*z).StateProof.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x2
	}
	if (*z).Message.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x4
	}
	if (*z).StateProofType.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x8
	}
	// variable map header, size zb0001Len
	o = append(o, 0x80|uint8(zb0001Len))
	if zb0001Len != 0 {
		if (zb0001Mask & 0x2) == 0 { // if not empty
			// string "sp"
			o = append(o, 0xa2, 0x73, 0x70)
			o = (*z).StateProof.MarshalMsg(o)
		}
		if (zb0001Mask & 0x4) == 0 { // if not empty
			// string "spmsg"
			o = append(o, 0xa5, 0x73, 0x70, 0x6d, 0x73, 0x67)
			o = (*z).Message.MarshalMsg(o)
		}
		if (zb0001Mask & 0x8) == 0 { // if not empty
			// string "sptype"
			o = append(o, 0xa6, 0x73, 0x70, 0x74, 0x79, 0x70, 0x65)
			o = (*z).StateProofType.MarshalMsg(o)
		}
	}
	return
}

func (_ *StateProofTxnFields) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*StateProofTxnFields)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *StateProofTxnFields) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0001 int
	var zb0002 bool
	zb0001, zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0001, zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).StateProofType.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "StateProofType")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).StateProof.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "StateProof")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).Message.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Message")
				return
			}
		}
		if zb0001 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0001)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 {
			(*z) = StateProofTxnFields{}
		}
		for zb0001 > 0 {
			zb0001--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "sptype":
				bts, err = (*z).StateProofType.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "StateProofType")
					return
				}
			case "sp":
				bts, err = (*z).StateProof.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "StateProof")
					return
				}
			case "spmsg":
				bts, err = (*z).Message.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Message")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *StateProofTxnFields) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *StateProofTxnFields) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*StateProofTxnFields)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *StateProofTxnFields) Msgsize() (s int) {
	s = 1 + 7 + (*z).StateProofType.Msgsize() + 3 + (*z).StateProof.Msgsize() + 6 + (*z).Message.Msgsize()
	return
}

// MsgIsZero returns whether this is a zero value
func (z *StateProofTxnFields) MsgIsZero() bool {
	return ((*z).StateProofType.MsgIsZero()) && ((*z).StateProof.MsgIsZero()) && ((*z).Message.MsgIsZero())
}

// MaxSize returns a maximum valid message size for this message type
func StateProofTxnFieldsMaxSize() (s int) {
	s = 1 + 7 + protocol.StateProofTypeMaxSize() + 3 + stateproof.StateProofMaxSize() + 6 + stateproofmsg.MessageMaxSize()
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *Transaction) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0008Len := uint32(49)
	var zb0008Mask uint64 /* 58 bits */
	if (*z).AssetTransferTxnFields.AssetAmount == 0 {
		zb0008Len--
		zb0008Mask |= 0x200
	}
	if (*z).AssetTransferTxnFields.AssetCloseTo.MsgIsZero() {
		zb0008Len--
		zb0008Mask |= 0x400
	}
	if (*z).AssetFreezeTxnFields.AssetFrozen == false {
		zb0008Len--
		zb0008Mask |= 0x800
	}
	if len((*z).ApplicationCallTxnFields.Access) == 0 {
		zb0008Len--
		zb0008Mask |= 0x1000
	}
	if (*z).PaymentTxnFields.Amount.MsgIsZero() {
		zb0008Len--
		zb0008Mask |= 0x2000
	}
	if len((*z).ApplicationCallTxnFields.ApplicationArgs) == 0 {
		zb0008Len--
		zb0008Mask |= 0x4000
	}
	if (*z).ApplicationCallTxnFields.OnCompletion == 0 {
		zb0008Len--
		zb0008Mask |= 0x8000
	}
	if len((*z).ApplicationCallTxnFields.ApprovalProgram) == 0 {
		zb0008Len--
		zb0008Mask |= 0x10000
	}
	if (*z).AssetConfigTxnFields.AssetParams.MsgIsZero() {
		zb0008Len--
		zb0008Mask |= 0x20000
	}
	if len((*z).ApplicationCallTxnFields.ForeignAssets) == 0 {
		zb0008Len--
		zb0008Mask |= 0x40000
	}
	if len((*z).ApplicationCallTxnFields.Accounts) == 0 {
		zb0008Len--
		zb0008Mask |= 0x80000
	}
	if len((*z).ApplicationCallTxnFields.Boxes) == 0 {
		zb0008Len--
		zb0008Mask |= 0x100000
	}
	if (*z).ApplicationCallTxnFields.ExtraProgramPages == 0 {
		zb0008Len--
		zb0008Mask |= 0x200000
	}
	if len((*z).ApplicationCallTxnFields.ForeignApps) == 0 {
		zb0008Len--
		zb0008Mask |= 0x400000
	}
	if (*z).ApplicationCallTxnFields.GlobalStateSchema.MsgIsZero() {
		zb0008Len--
		zb0008Mask |= 0x800000
	}
	if (*z).ApplicationCallTxnFields.ApplicationID.MsgIsZero() {
		zb0008Len--
		zb0008Mask |= 0x1000000
	}
	if (*z).ApplicationCallTxnFields.LocalStateSchema.MsgIsZero() {
		zb0008Len--
		zb0008Mask |= 0x2000000
	}
	if (*z).ApplicationCallTxnFields.RejectVersion == 0 {
		zb0008Len--
		zb0008Mask |= 0x4000000
	}
	if len((*z).ApplicationCallTxnFields.ClearStateProgram) == 0 {
		zb0008Len--
		zb0008Mask |= 0x8000000
	}
	if (*z).AssetTransferTxnFields.AssetReceiver.MsgIsZero() {
		zb0008Len--
		zb0008Mask |= 0x10000000
	}
	if (*z).AssetTransferTxnFields.AssetSender.MsgIsZero() {
		zb0008Len--
		zb0008Mask |= 0x20000000
	}
	if (*z).AssetConfigTxnFields.ConfigAsset.MsgIsZero() {
		zb0008Len--
		zb0008Mask |= 0x40000000
	}
	if (*z).PaymentTxnFields.CloseRemainderTo.MsgIsZero() {
		zb0008Len--
		zb0008Mask |= 0x80000000
	}
	if (*z).AssetFreezeTxnFields.FreezeAccount.MsgIsZero() {
		zb0008Len--
		zb0008Mask |= 0x100000000
	}
	if (*z).AssetFreezeTxnFields.FreezeAsset.MsgIsZero() {
		zb0008Len--
		zb0008Mask |= 0x200000000
	}
	if (*z).Header.Fee.MsgIsZero() {
		zb0008Len--
		zb0008Mask |= 0x400000000
	}
	if (*z).Header.FirstValid.MsgIsZero() {
		zb0008Len--
		zb0008Mask |= 0x800000000
	}
	if (*z).Header.GenesisID == "" {
		zb0008Len--
		zb0008Mask |= 0x1000000000
	}
	if (*z).Header.GenesisHash.MsgIsZero() {
		zb0008Len--
		zb0008Mask |= 0x2000000000
	}
	if (*z).Header.Group.MsgIsZero() {
		zb0008Len--
		zb0008Mask |= 0x4000000000
	}
	if (*z).HeartbeatTxnFields == nil {
		zb0008Len--
		zb0008Mask |= 0x8000000000
	}
	if (*z).Header.LastValid.MsgIsZero() {
		zb0008Len--
		zb0008Mask |= 0x10000000000
	}
	if (*z).Header.Lease == ([32]byte{}) {
		zb0008Len--
		zb0008Mask |= 0x20000000000
	}
	if (*z).KeyregTxnFields.Nonparticipation == false {
		zb0008Len--
		zb0008Mask |= 0x40000000000
	}
	if len((*z).Header.Note) == 0 {
		zb0008Len--
		zb0008Mask |= 0x80000000000
	}
	if (*z).PaymentTxnFields.Receiver.MsgIsZero() {
		zb0008Len--
		zb0008Mask |= 0x100000000000
	}
	if (*z).Header.RekeyTo.MsgIsZero() {
		zb0008Len--
		zb0008Mask |= 0x200000000000
	}
	if (*z).KeyregTxnFields.SelectionPK.MsgIsZero() {
		zb0008Len--
		zb0008Mask |= 0x400000000000
	}
	if (*z).Header.Sender.MsgIsZero() {
		zb0008Len--
		zb0008Mask |= 0x800000000000
	}
	if (*z).StateProofTxnFields.StateProof.MsgIsZero() {
		zb0008Len--
		zb0008Mask |= 0x1000000000000
	}
	if (*z).StateProofTxnFields.Message.MsgIsZero() {
		zb0008Len--
		zb0008Mask |= 0x2000000000000
	}
	if (*z).KeyregTxnFields.StateProofPK.MsgIsZero() {
		zb0008Len--
		zb0008Mask |= 0x4000000000000
	}
	if (*z).StateProofTxnFields.StateProofType.MsgIsZero() {
		zb0008Len--
		zb0008Mask |= 0x8000000000000
	}
	if (*z).Type.MsgIsZero() {
		zb0008Len--
		zb0008Mask |= 0x10000000000000
	}
	if (*z).KeyregTxnFields.VoteFirst.MsgIsZero() {
		zb0008Len--
		zb0008Mask |= 0x20000000000000
	}
	if (*z).KeyregTxnFields.VoteKeyDilution == 0 {
		zb0008Len--
		zb0008Mask |= 0x40000000000000
	}
	if (*z).KeyregTxnFields.VotePK.MsgIsZero() {
		zb0008Len--
		zb0008Mask |= 0x80000000000000
	}
	if (*z).KeyregTxnFields.VoteLast.MsgIsZero() {
		zb0008Len--
		zb0008Mask |= 0x100000000000000
	}
	if (*z).AssetTransferTxnFields.XferAsset.MsgIsZero() {
		zb0008Len--
		zb0008Mask |= 0x200000000000000
	}
	// variable map header, size zb0008Len
	o = msgp.AppendMapHeader(o, zb0008Len)
	if zb0008Len != 0 {
		if (zb0008Mask & 0x200) == 0 { // if not empty
			// string "aamt"
			o = append(o, 0xa4, 0x61, 0x61, 0x6d, 0x74)
			o = msgp.AppendUint64(o, (*z).AssetTransferTxnFields.AssetAmount)
		}
		if (zb0008Mask & 0x400) == 0 { // if not empty
			// string "aclose"
			o = append(o, 0xa6, 0x61, 0x63, 0x6c, 0x6f, 0x73, 0x65)
			o = (*z).AssetTransferTxnFields.AssetCloseTo.MarshalMsg(o)
		}
		if (zb0008Mask & 0x800) == 0 { // if not empty
			// string "afrz"
			o = append(o, 0xa4, 0x61, 0x66, 0x72, 0x7a)
			o = msgp.AppendBool(o, (*z).AssetFreezeTxnFields.AssetFrozen)
		}
		if (zb0008Mask & 0x1000) == 0 { // if not empty
			// string "al"
			o = append(o, 0xa2, 0x61, 0x6c)
			if (*z).ApplicationCallTxnFields.Access == nil {
				o = msgp.AppendNil(o)
			} else {
				o = msgp.AppendArrayHeader(o, uint32(len((*z).ApplicationCallTxnFields.Access)))
			}
			for zb0006 := range (*z).ApplicationCallTxnFields.Access {
				o = (*z).ApplicationCallTxnFields.Access[zb0006].MarshalMsg(o)
			}
		}
		if (zb0008Mask & 0x2000) == 0 { // if not empty
			// string "amt"
			o = append(o, 0xa3, 0x61, 0x6d, 0x74)
			o = (*z).PaymentTxnFields.Amount.MarshalMsg(o)
		}
		if (zb0008Mask & 0x4000) == 0 { // if not empty
			// string "apaa"
			o = append(o, 0xa4, 0x61, 0x70, 0x61, 0x61)
			if (*z).ApplicationCallTxnFields.ApplicationArgs == nil {
				o = msgp.AppendNil(o)
			} else {
				o = msgp.AppendArrayHeader(o, uint32(len((*z).ApplicationCallTxnFields.ApplicationArgs)))
			}
			for zb0002 := range (*z).ApplicationCallTxnFields.ApplicationArgs {
				o = msgp.AppendBytes(o, (*z).ApplicationCallTxnFields.ApplicationArgs[zb0002])
			}
		}
		if (zb0008Mask & 0x8000) == 0 { // if not empty
			// string "apan"
			o = append(o, 0xa4, 0x61, 0x70, 0x61, 0x6e)
			o = msgp.AppendUint64(o, uint64((*z).ApplicationCallTxnFields.OnCompletion))
		}
		if (zb0008Mask & 0x10000) == 0 { // if not empty
			// string "apap"
			o = append(o, 0xa4, 0x61, 0x70, 0x61, 0x70)
			o = msgp.AppendBytes(o, (*z).ApplicationCallTxnFields.ApprovalProgram)
		}
		if (zb0008Mask & 0x20000) == 0 { // if not empty
			// string "apar"
			o = append(o, 0xa4, 0x61, 0x70, 0x61, 0x72)
			o = (*z).AssetConfigTxnFields.AssetParams.MarshalMsg(o)
		}
		if (zb0008Mask & 0x40000) == 0 { // if not empty
			// string "apas"
			o = append(o, 0xa4, 0x61, 0x70, 0x61, 0x73)
			if (*z).ApplicationCallTxnFields.ForeignAssets == nil {
				o = msgp.AppendNil(o)
			} else {
				o = msgp.AppendArrayHeader(o, uint32(len((*z).ApplicationCallTxnFields.ForeignAssets)))
			}
			for zb0004 := range (*z).ApplicationCallTxnFields.ForeignAssets {
				o = (*z).ApplicationCallTxnFields.ForeignAssets[zb0004].MarshalMsg(o)
			}
		}
		if (zb0008Mask & 0x80000) == 0 { // if not empty
			// string "apat"
			o = append(o, 0xa4, 0x61, 0x70, 0x61, 0x74)
			if (*z).ApplicationCallTxnFields.Accounts == nil {
				o = msgp.AppendNil(o)
			} else {
				o = msgp.AppendArrayHeader(o, uint32(len((*z).ApplicationCallTxnFields.Accounts)))
			}
			for zb0003 := range (*z).ApplicationCallTxnFields.Accounts {
				o = (*z).ApplicationCallTxnFields.Accounts[zb0003].MarshalMsg(o)
			}
		}
		if (zb0008Mask & 0x100000) == 0 { // if not empty
			// string "apbx"
			o = append(o, 0xa4, 0x61, 0x70, 0x62, 0x78)
			if (*z).ApplicationCallTxnFields.Boxes == nil {
				o = msgp.AppendNil(o)
			} else {
				o = msgp.AppendArrayHeader(o, uint32(len((*z).ApplicationCallTxnFields.Boxes)))
			}
			for zb0007 := range (*z).ApplicationCallTxnFields.Boxes {
				// omitempty: check for empty values
				zb0009Len := uint32(2)
				var zb0009Mask uint8 /* 3 bits */
				if (*z).ApplicationCallTxnFields.Boxes[zb0007].Index == 0 {
					zb0009Len--
					zb0009Mask |= 0x2
				}
				if len((*z).ApplicationCallTxnFields.Boxes[zb0007].Name) == 0 {
					zb0009Len--
					zb0009Mask |= 0x4
				}
				// variable map header, size zb0009Len
				o = append(o, 0x80|uint8(zb0009Len))
				if (zb0009Mask & 0x2) == 0 { // if not empty
					// string "i"
					o = append(o, 0xa1, 0x69)
					o = msgp.AppendUint64(o, (*z).ApplicationCallTxnFields.Boxes[zb0007].Index)
				}
				if (zb0009Mask & 0x4) == 0 { // if not empty
					// string "n"
					o = append(o, 0xa1, 0x6e)
					o = msgp.AppendBytes(o, (*z).ApplicationCallTxnFields.Boxes[zb0007].Name)
				}
			}
		}
		if (zb0008Mask & 0x200000) == 0 { // if not empty
			// string "apep"
			o = append(o, 0xa4, 0x61, 0x70, 0x65, 0x70)
			o = msgp.AppendUint32(o, (*z).ApplicationCallTxnFields.ExtraProgramPages)
		}
		if (zb0008Mask & 0x400000) == 0 { // if not empty
			// string "apfa"
			o = append(o, 0xa4, 0x61, 0x70, 0x66, 0x61)
			if (*z).ApplicationCallTxnFields.ForeignApps == nil {
				o = msgp.AppendNil(o)
			} else {
				o = msgp.AppendArrayHeader(o, uint32(len((*z).ApplicationCallTxnFields.ForeignApps)))
			}
			for zb0005 := range (*z).ApplicationCallTxnFields.ForeignApps {
				o = (*z).ApplicationCallTxnFields.ForeignApps[zb0005].MarshalMsg(o)
			}
		}
		if (zb0008Mask & 0x800000) == 0 { // if not empty
			// string "apgs"
			o = append(o, 0xa4, 0x61, 0x70, 0x67, 0x73)
			o = (*z).ApplicationCallTxnFields.GlobalStateSchema.MarshalMsg(o)
		}
		if (zb0008Mask & 0x1000000) == 0 { // if not empty
			// string "apid"
			o = append(o, 0xa4, 0x61, 0x70, 0x69, 0x64)
			o = (*z).ApplicationCallTxnFields.ApplicationID.MarshalMsg(o)
		}
		if (zb0008Mask & 0x2000000) == 0 { // if not empty
			// string "apls"
			o = append(o, 0xa4, 0x61, 0x70, 0x6c, 0x73)
			o = (*z).ApplicationCallTxnFields.LocalStateSchema.MarshalMsg(o)
		}
		if (zb0008Mask & 0x4000000) == 0 { // if not empty
			// string "aprv"
			o = append(o, 0xa4, 0x61, 0x70, 0x72, 0x76)
			o = msgp.AppendUint64(o, (*z).ApplicationCallTxnFields.RejectVersion)
		}
		if (zb0008Mask & 0x8000000) == 0 { // if not empty
			// string "apsu"
			o = append(o, 0xa4, 0x61, 0x70, 0x73, 0x75)
			o = msgp.AppendBytes(o, (*z).ApplicationCallTxnFields.ClearStateProgram)
		}
		if (zb0008Mask & 0x10000000) == 0 { // if not empty
			// string "arcv"
			o = append(o, 0xa4, 0x61, 0x72, 0x63, 0x76)
			o = (*z).AssetTransferTxnFields.AssetReceiver.MarshalMsg(o)
		}
		if (zb0008Mask & 0x20000000) == 0 { // if not empty
			// string "asnd"
			o = append(o, 0xa4, 0x61, 0x73, 0x6e, 0x64)
			o = (*z).AssetTransferTxnFields.AssetSender.MarshalMsg(o)
		}
		if (zb0008Mask & 0x40000000) == 0 { // if not empty
			// string "caid"
			o = append(o, 0xa4, 0x63, 0x61, 0x69, 0x64)
			o = (*z).AssetConfigTxnFields.ConfigAsset.MarshalMsg(o)
		}
		if (zb0008Mask & 0x80000000) == 0 { // if not empty
			// string "close"
			o = append(o, 0xa5, 0x63, 0x6c, 0x6f, 0x73, 0x65)
			o = (*z).PaymentTxnFields.CloseRemainderTo.MarshalMsg(o)
		}
		if (zb0008Mask & 0x100000000) == 0 { // if not empty
			// string "fadd"
			o = append(o, 0xa4, 0x66, 0x61, 0x64, 0x64)
			o = (*z).AssetFreezeTxnFields.FreezeAccount.MarshalMsg(o)
		}
		if (zb0008Mask & 0x200000000) == 0 { // if not empty
			// string "faid"
			o = append(o, 0xa4, 0x66, 0x61, 0x69, 0x64)
			o = (*z).AssetFreezeTxnFields.FreezeAsset.MarshalMsg(o)
		}
		if (zb0008Mask & 0x400000000) == 0 { // if not empty
			// string "fee"
			o = append(o, 0xa3, 0x66, 0x65, 0x65)
			o = (*z).Header.Fee.MarshalMsg(o)
		}
		if (zb0008Mask & 0x800000000) == 0 { // if not empty
			// string "fv"
			o = append(o, 0xa2, 0x66, 0x76)
			o = (*z).Header.FirstValid.MarshalMsg(o)
		}
		if (zb0008Mask & 0x1000000000) == 0 { // if not empty
			// string "gen"
			o = append(o, 0xa3, 0x67, 0x65, 0x6e)
			o = msgp.AppendString(o, (*z).Header.GenesisID)
		}
		if (zb0008Mask & 0x2000000000) == 0 { // if not empty
			// string "gh"
			o = append(o, 0xa2, 0x67, 0x68)
			o = (*z).Header.GenesisHash.MarshalMsg(o)
		}
		if (zb0008Mask & 0x4000000000) == 0 { // if not empty
			// string "grp"
			o = append(o, 0xa3, 0x67, 0x72, 0x70)
			o = (*z).Header.Group.MarshalMsg(o)
		}
		if (zb0008Mask & 0x8000000000) == 0 { // if not empty
			// string "hb"
			o = append(o, 0xa2, 0x68, 0x62)
			if (*z).HeartbeatTxnFields == nil {
				o = msgp.AppendNil(o)
			} else {
				o = (*z).HeartbeatTxnFields.MarshalMsg(o)
			}
		}
		if (zb0008Mask & 0x10000000000) == 0 { // if not empty
			// string "lv"
			o = append(o, 0xa2, 0x6c, 0x76)
			o = (*z).Header.LastValid.MarshalMsg(o)
		}
		if (zb0008Mask & 0x20000000000) == 0 { // if not empty
			// string "lx"
			o = append(o, 0xa2, 0x6c, 0x78)
			o = msgp.AppendBytes(o, ((*z).Header.Lease)[:])
		}
		if (zb0008Mask & 0x40000000000) == 0 { // if not empty
			// string "nonpart"
			o = append(o, 0xa7, 0x6e, 0x6f, 0x6e, 0x70, 0x61, 0x72, 0x74)
			o = msgp.AppendBool(o, (*z).KeyregTxnFields.Nonparticipation)
		}
		if (zb0008Mask & 0x80000000000) == 0 { // if not empty
			// string "note"
			o = append(o, 0xa4, 0x6e, 0x6f, 0x74, 0x65)
			o = msgp.AppendBytes(o, (*z).Header.Note)
		}
		if (zb0008Mask & 0x100000000000) == 0 { // if not empty
			// string "rcv"
			o = append(o, 0xa3, 0x72, 0x63, 0x76)
			o = (*z).PaymentTxnFields.Receiver.MarshalMsg(o)
		}
		if (zb0008Mask & 0x200000000000) == 0 { // if not empty
			// string "rekey"
			o = append(o, 0xa5, 0x72, 0x65, 0x6b, 0x65, 0x79)
			o = (*z).Header.RekeyTo.MarshalMsg(o)
		}
		if (zb0008Mask & 0x400000000000) == 0 { // if not empty
			// string "selkey"
			o = append(o, 0xa6, 0x73, 0x65, 0x6c, 0x6b, 0x65, 0x79)
			o = (*z).KeyregTxnFields.SelectionPK.MarshalMsg(o)
		}
		if (zb0008Mask & 0x800000000000) == 0 { // if not empty
			// string "snd"
			o = append(o, 0xa3, 0x73, 0x6e, 0x64)
			o = (*z).Header.Sender.MarshalMsg(o)
		}
		if (zb0008Mask & 0x1000000000000) == 0 { // if not empty
			// string "sp"
			o = append(o, 0xa2, 0x73, 0x70)
			o = (*z).StateProofTxnFields.StateProof.MarshalMsg(o)
		}
		if (zb0008Mask & 0x2000000000000) == 0 { // if not empty
			// string "spmsg"
			o = append(o, 0xa5, 0x73, 0x70, 0x6d, 0x73, 0x67)
			o = (*z).StateProofTxnFields.Message.MarshalMsg(o)
		}
		if (zb0008Mask & 0x4000000000000) == 0 { // if not empty
			// string "sprfkey"
			o = append(o, 0xa7, 0x73, 0x70, 0x72, 0x66, 0x6b, 0x65, 0x79)
			o = (*z).KeyregTxnFields.StateProofPK.MarshalMsg(o)
		}
		if (zb0008Mask & 0x8000000000000) == 0 { // if not empty
			// string "sptype"
			o = append(o, 0xa6, 0x73, 0x70, 0x74, 0x79, 0x70, 0x65)
			o = (*z).StateProofTxnFields.StateProofType.MarshalMsg(o)
		}
		if (zb0008Mask & 0x10000000000000) == 0 { // if not empty
			// string "type"
			o = append(o, 0xa4, 0x74, 0x79, 0x70, 0x65)
			o = (*z).Type.MarshalMsg(o)
		}
		if (zb0008Mask & 0x20000000000000) == 0 { // if not empty
			// string "votefst"
			o = append(o, 0xa7, 0x76, 0x6f, 0x74, 0x65, 0x66, 0x73, 0x74)
			o = (*z).KeyregTxnFields.VoteFirst.MarshalMsg(o)
		}
		if (zb0008Mask & 0x40000000000000) == 0 { // if not empty
			// string "votekd"
			o = append(o, 0xa6, 0x76, 0x6f, 0x74, 0x65, 0x6b, 0x64)
			o = msgp.AppendUint64(o, (*z).KeyregTxnFields.VoteKeyDilution)
		}
		if (zb0008Mask & 0x80000000000000) == 0 { // if not empty
			// string "votekey"
			o = append(o, 0xa7, 0x76, 0x6f, 0x74, 0x65, 0x6b, 0x65, 0x79)
			o = (*z).KeyregTxnFields.VotePK.MarshalMsg(o)
		}
		if (zb0008Mask & 0x100000000000000) == 0 { // if not empty
			// string "votelst"
			o = append(o, 0xa7, 0x76, 0x6f, 0x74, 0x65, 0x6c, 0x73, 0x74)
			o = (*z).KeyregTxnFields.VoteLast.MarshalMsg(o)
		}
		if (zb0008Mask & 0x200000000000000) == 0 { // if not empty
			// string "xaid"
			o = append(o, 0xa4, 0x78, 0x61, 0x69, 0x64)
			o = (*z).AssetTransferTxnFields.XferAsset.MarshalMsg(o)
		}
	}
	return
}

func (_ *Transaction) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*Transaction)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *Transaction) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0008 int
	var zb0009 bool
	zb0008, zb0009, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0008, zb0009, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0008 > 0 {
			zb0008--
			bts, err = (*z).Type.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Type")
				return
			}
		}
		if zb0008 > 0 {
			zb0008--
			bts, err = (*z).Header.Sender.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Sender")
				return
			}
		}
		if zb0008 > 0 {
			zb0008--
			bts, err = (*z).Header.Fee.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Fee")
				return
			}
		}
		if zb0008 > 0 {
			zb0008--
			bts, err = (*z).Header.FirstValid.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "FirstValid")
				return
			}
		}
		if zb0008 > 0 {
			zb0008--
			bts, err = (*z).Header.LastValid.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "LastValid")
				return
			}
		}
		if zb0008 > 0 {
			zb0008--
			var zb0010 int
			zb0010, err = msgp.ReadBytesBytesHeader(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Note")
				return
			}
			if zb0010 > bounds.MaxTxnNoteBytes {
				err = msgp.ErrOverflow(uint64(zb0010), uint64(bounds.MaxTxnNoteBytes))
				return
			}
			(*z).Header.Note, bts, err = msgp.ReadBytesBytes(bts, (*z).Header.Note)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Note")
				return
			}
		}
		if zb0008 > 0 {
			zb0008--
			var zb0011 int
			zb0011, err = msgp.ReadBytesBytesHeader(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "GenesisID")
				return
			}
			if zb0011 > bounds.MaxGenesisIDLen {
				err = msgp.ErrOverflow(uint64(zb0011), uint64(bounds.MaxGenesisIDLen))
				return
			}
			(*z).Header.GenesisID, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "GenesisID")
				return
			}
		}
		if zb0008 > 0 {
			zb0008--
			bts, err = (*z).Header.GenesisHash.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "GenesisHash")
				return
			}
		}
		if zb0008 > 0 {
			zb0008--
			bts, err = (*z).Header.Group.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Group")
				return
			}
		}
		if zb0008 > 0 {
			zb0008--
			bts, err = msgp.ReadExactBytes(bts, ((*z).Header.Lease)[:])
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Lease")
				return
			}
		}
		if zb0008 > 0 {
			zb0008--
			bts, err = (*z).Header.RekeyTo.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "RekeyTo")
				return
			}
		}
		if zb0008 > 0 {
			zb0008--
			bts, err = (*z).KeyregTxnFields.VotePK.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "VotePK")
				return
			}
		}
		if zb0008 > 0 {
			zb0008--
			bts, err = (*z).KeyregTxnFields.SelectionPK.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "SelectionPK")
				return
			}
		}
		if zb0008 > 0 {
			zb0008--
			bts, err = (*z).KeyregTxnFields.StateProofPK.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "StateProofPK")
				return
			}
		}
		if zb0008 > 0 {
			zb0008--
			bts, err = (*z).KeyregTxnFields.VoteFirst.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "VoteFirst")
				return
			}
		}
		if zb0008 > 0 {
			zb0008--
			bts, err = (*z).KeyregTxnFields.VoteLast.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "VoteLast")
				return
			}
		}
		if zb0008 > 0 {
			zb0008--
			(*z).KeyregTxnFields.VoteKeyDilution, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "VoteKeyDilution")
				return
			}
		}
		if zb0008 > 0 {
			zb0008--
			(*z).KeyregTxnFields.Nonparticipation, bts, err = msgp.ReadBoolBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Nonparticipation")
				return
			}
		}
		if zb0008 > 0 {
			zb0008--
			bts, err = (*z).PaymentTxnFields.Receiver.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Receiver")
				return
			}
		}
		if zb0008 > 0 {
			zb0008--
			bts, err = (*z).PaymentTxnFields.Amount.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Amount")
				return
			}
		}
		if zb0008 > 0 {
			zb0008--
			bts, err = (*z).PaymentTxnFields.CloseRemainderTo.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "CloseRemainderTo")
				return
			}
		}
		if zb0008 > 0 {
			zb0008--
			bts, err = (*z).AssetConfigTxnFields.ConfigAsset.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "ConfigAsset")
				return
			}
		}
		if zb0008 > 0 {
			zb0008--
			bts, err = (*z).AssetConfigTxnFields.AssetParams.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "AssetParams")
				return
			}
		}
		if zb0008 > 0 {
			zb0008--
			bts, err = (*z).AssetTransferTxnFields.XferAsset.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "XferAsset")
				return
			}
		}
		if zb0008 > 0 {
			zb0008--
			(*z).AssetTransferTxnFields.AssetAmount, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "AssetAmount")
				return
			}
		}
		if zb0008 > 0 {
			zb0008--
			bts, err = (*z).AssetTransferTxnFields.AssetSender.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "AssetSender")
				return
			}
		}
		if zb0008 > 0 {
			zb0008--
			bts, err = (*z).AssetTransferTxnFields.AssetReceiver.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "AssetReceiver")
				return
			}
		}
		if zb0008 > 0 {
			zb0008--
			bts, err = (*z).AssetTransferTxnFields.AssetCloseTo.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "AssetCloseTo")
				return
			}
		}
		if zb0008 > 0 {
			zb0008--
			bts, err = (*z).AssetFreezeTxnFields.FreezeAccount.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "FreezeAccount")
				return
			}
		}
		if zb0008 > 0 {
			zb0008--
			bts, err = (*z).AssetFreezeTxnFields.FreezeAsset.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "FreezeAsset")
				return
			}
		}
		if zb0008 > 0 {
			zb0008--
			(*z).AssetFreezeTxnFields.AssetFrozen, bts, err = msgp.ReadBoolBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "AssetFrozen")
				return
			}
		}
		if zb0008 > 0 {
			zb0008--
			bts, err = (*z).ApplicationCallTxnFields.ApplicationID.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "ApplicationID")
				return
			}
		}
		if zb0008 > 0 {
			zb0008--
			{
				var zb0012 uint64
				zb0012, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "OnCompletion")
					return
				}
				(*z).ApplicationCallTxnFields.OnCompletion = OnCompletion(zb0012)
			}
		}
		if zb0008 > 0 {
			zb0008--
			var zb0013 int
			var zb0014 bool
			zb0013, zb0014, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "ApplicationArgs")
				return
			}
			if zb0013 > encodedMaxApplicationArgs {
				err = msgp.ErrOverflow(uint64(zb0013), uint64(encodedMaxApplicationArgs))
				err = msgp.WrapError(err, "struct-from-array", "ApplicationArgs")
				return
			}
			if zb0014 {
				(*z).ApplicationCallTxnFields.ApplicationArgs = nil
			} else if (*z).ApplicationCallTxnFields.ApplicationArgs != nil && cap((*z).ApplicationCallTxnFields.ApplicationArgs) >= zb0013 {
				(*z).ApplicationCallTxnFields.ApplicationArgs = ((*z).ApplicationCallTxnFields.ApplicationArgs)[:zb0013]
			} else {
				(*z).ApplicationCallTxnFields.ApplicationArgs = make([][]byte, zb0013)
			}
			for zb0002 := range (*z).ApplicationCallTxnFields.ApplicationArgs {
				(*z).ApplicationCallTxnFields.ApplicationArgs[zb0002], bts, err = msgp.ReadBytesBytes(bts, (*z).ApplicationCallTxnFields.ApplicationArgs[zb0002])
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "ApplicationArgs", zb0002)
					return
				}
			}
		}
		if zb0008 > 0 {
			zb0008--
			var zb0015 int
			var zb0016 bool
			zb0015, zb0016, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Accounts")
				return
			}
			if zb0015 > encodedMaxAccounts {
				err = msgp.ErrOverflow(uint64(zb0015), uint64(encodedMaxAccounts))
				err = msgp.WrapError(err, "struct-from-array", "Accounts")
				return
			}
			if zb0016 {
				(*z).ApplicationCallTxnFields.Accounts = nil
			} else if (*z).ApplicationCallTxnFields.Accounts != nil && cap((*z).ApplicationCallTxnFields.Accounts) >= zb0015 {
				(*z).ApplicationCallTxnFields.Accounts = ((*z).ApplicationCallTxnFields.Accounts)[:zb0015]
			} else {
				(*z).ApplicationCallTxnFields.Accounts = make([]basics.Address, zb0015)
			}
			for zb0003 := range (*z).ApplicationCallTxnFields.Accounts {
				bts, err = (*z).ApplicationCallTxnFields.Accounts[zb0003].UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Accounts", zb0003)
					return
				}
			}
		}
		if zb0008 > 0 {
			zb0008--
			var zb0017 int
			var zb0018 bool
			zb0017, zb0018, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "ForeignAssets")
				return
			}
			if zb0017 > encodedMaxForeignAssets {
				err = msgp.ErrOverflow(uint64(zb0017), uint64(encodedMaxForeignAssets))
				err = msgp.WrapError(err, "struct-from-array", "ForeignAssets")
				return
			}
			if zb0018 {
				(*z).ApplicationCallTxnFields.ForeignAssets = nil
			} else if (*z).ApplicationCallTxnFields.ForeignAssets != nil && cap((*z).ApplicationCallTxnFields.ForeignAssets) >= zb0017 {
				(*z).ApplicationCallTxnFields.ForeignAssets = ((*z).ApplicationCallTxnFields.ForeignAssets)[:zb0017]
			} else {
				(*z).ApplicationCallTxnFields.ForeignAssets = make([]basics.AssetIndex, zb0017)
			}
			for zb0004 := range (*z).ApplicationCallTxnFields.ForeignAssets {
				bts, err = (*z).ApplicationCallTxnFields.ForeignAssets[zb0004].UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "ForeignAssets", zb0004)
					return
				}
			}
		}
		if zb0008 > 0 {
			zb0008--
			var zb0019 int
			var zb0020 bool
			zb0019, zb0020, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "ForeignApps")
				return
			}
			if zb0019 > encodedMaxForeignApps {
				err = msgp.ErrOverflow(uint64(zb0019), uint64(encodedMaxForeignApps))
				err = msgp.WrapError(err, "struct-from-array", "ForeignApps")
				return
			}
			if zb0020 {
				(*z).ApplicationCallTxnFields.ForeignApps = nil
			} else if (*z).ApplicationCallTxnFields.ForeignApps != nil && cap((*z).ApplicationCallTxnFields.ForeignApps) >= zb0019 {
				(*z).ApplicationCallTxnFields.ForeignApps = ((*z).ApplicationCallTxnFields.ForeignApps)[:zb0019]
			} else {
				(*z).ApplicationCallTxnFields.ForeignApps = make([]basics.AppIndex, zb0019)
			}
			for zb0005 := range (*z).ApplicationCallTxnFields.ForeignApps {
				bts, err = (*z).ApplicationCallTxnFields.ForeignApps[zb0005].UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "ForeignApps", zb0005)
					return
				}
			}
		}
		if zb0008 > 0 {
			zb0008--
			var zb0021 int
			var zb0022 bool
			zb0021, zb0022, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Access")
				return
			}
			if zb0021 > encodedMaxAccess {
				err = msgp.ErrOverflow(uint64(zb0021), uint64(encodedMaxAccess))
				err = msgp.WrapError(err, "struct-from-array", "Access")
				return
			}
			if zb0022 {
				(*z).ApplicationCallTxnFields.Access = nil
			} else if (*z).ApplicationCallTxnFields.Access != nil && cap((*z).ApplicationCallTxnFields.Access) >= zb0021 {
				(*z).ApplicationCallTxnFields.Access = ((*z).ApplicationCallTxnFields.Access)[:zb0021]
			} else {
				(*z).ApplicationCallTxnFields.Access = make([]ResourceRef, zb0021)
			}
			for zb0006 := range (*z).ApplicationCallTxnFields.Access {
				bts, err = (*z).ApplicationCallTxnFields.Access[zb0006].UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Access", zb0006)
					return
				}
			}
		}
		if zb0008 > 0 {
			zb0008--
			var zb0023 int
			var zb0024 bool
			zb0023, zb0024, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Boxes")
				return
			}
			if zb0023 > encodedMaxBoxes {
				err = msgp.ErrOverflow(uint64(zb0023), uint64(encodedMaxBoxes))
				err = msgp.WrapError(err, "struct-from-array", "Boxes")
				return
			}
			if zb0024 {
				(*z).ApplicationCallTxnFields.Boxes = nil
			} else if (*z).ApplicationCallTxnFields.Boxes != nil && cap((*z).ApplicationCallTxnFields.Boxes) >= zb0023 {
				(*z).ApplicationCallTxnFields.Boxes = ((*z).ApplicationCallTxnFields.Boxes)[:zb0023]
			} else {
				(*z).ApplicationCallTxnFields.Boxes = make([]BoxRef, zb0023)
			}
			for zb0007 := range (*z).ApplicationCallTxnFields.Boxes {
				var zb0025 int
				var zb0026 bool
				zb0025, zb0026, bts, err = msgp.ReadMapHeaderBytes(bts)
				if _, ok := err.(msgp.TypeError); ok {
					zb0025, zb0026, bts, err = msgp.ReadArrayHeaderBytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "Boxes", zb0007)
						return
					}
					if zb0025 > 0 {
						zb0025--
						(*z).ApplicationCallTxnFields.Boxes[zb0007].Index, bts, err = msgp.ReadUint64Bytes(bts)
						if err != nil {
							err = msgp.WrapError(err, "struct-from-array", "Boxes", zb0007, "struct-from-array", "Index")
							return
						}
					}
					if zb0025 > 0 {
						zb0025--
						var zb0027 int
						zb0027, err = msgp.ReadBytesBytesHeader(bts)
						if err != nil {
							err = msgp.WrapError(err, "struct-from-array", "Boxes", zb0007, "struct-from-array", "Name")
							return
						}
						if zb0027 > bounds.MaxBytesKeyValueLen {
							err = msgp.ErrOverflow(uint64(zb0027), uint64(bounds.MaxBytesKeyValueLen))
							return
						}
						(*z).ApplicationCallTxnFields.Boxes[zb0007].Name, bts, err = msgp.ReadBytesBytes(bts, (*z).ApplicationCallTxnFields.Boxes[zb0007].Name)
						if err != nil {
							err = msgp.WrapError(err, "struct-from-array", "Boxes", zb0007, "struct-from-array", "Name")
							return
						}
					}
					if zb0025 > 0 {
						err = msgp.ErrTooManyArrayFields(zb0025)
						if err != nil {
							err = msgp.WrapError(err, "struct-from-array", "Boxes", zb0007, "struct-from-array")
							return
						}
					}
				} else {
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "Boxes", zb0007)
						return
					}
					if zb0026 {
						(*z).ApplicationCallTxnFields.Boxes[zb0007] = BoxRef{}
					}
					for zb0025 > 0 {
						zb0025--
						field, bts, err = msgp.ReadMapKeyZC(bts)
						if err != nil {
							err = msgp.WrapError(err, "struct-from-array", "Boxes", zb0007)
							return
						}
						switch string(field) {
						case "i":
							(*z).ApplicationCallTxnFields.Boxes[zb0007].Index, bts, err = msgp.ReadUint64Bytes(bts)
							if err != nil {
								err = msgp.WrapError(err, "struct-from-array", "Boxes", zb0007, "Index")
								return
							}
						case "n":
							var zb0028 int
							zb0028, err = msgp.ReadBytesBytesHeader(bts)
							if err != nil {
								err = msgp.WrapError(err, "struct-from-array", "Boxes", zb0007, "Name")
								return
							}
							if zb0028 > bounds.MaxBytesKeyValueLen {
								err = msgp.ErrOverflow(uint64(zb0028), uint64(bounds.MaxBytesKeyValueLen))
								return
							}
							(*z).ApplicationCallTxnFields.Boxes[zb0007].Name, bts, err = msgp.ReadBytesBytes(bts, (*z).ApplicationCallTxnFields.Boxes[zb0007].Name)
							if err != nil {
								err = msgp.WrapError(err, "struct-from-array", "Boxes", zb0007, "Name")
								return
							}
						default:
							err = msgp.ErrNoField(string(field))
							if err != nil {
								err = msgp.WrapError(err, "struct-from-array", "Boxes", zb0007)
								return
							}
						}
					}
				}
			}
		}
		if zb0008 > 0 {
			zb0008--
			bts, err = (*z).ApplicationCallTxnFields.LocalStateSchema.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "LocalStateSchema")
				return
			}
		}
		if zb0008 > 0 {
			zb0008--
			bts, err = (*z).ApplicationCallTxnFields.GlobalStateSchema.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "GlobalStateSchema")
				return
			}
		}
		if zb0008 > 0 {
			zb0008--
			var zb0029 int
			zb0029, err = msgp.ReadBytesBytesHeader(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "ApprovalProgram")
				return
			}
			if zb0029 > bounds.MaxAvailableAppProgramLen {
				err = msgp.ErrOverflow(uint64(zb0029), uint64(bounds.MaxAvailableAppProgramLen))
				return
			}
			(*z).ApplicationCallTxnFields.ApprovalProgram, bts, err = msgp.ReadBytesBytes(bts, (*z).ApplicationCallTxnFields.ApprovalProgram)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "ApprovalProgram")
				return
			}
		}
		if zb0008 > 0 {
			zb0008--
			var zb0030 int
			zb0030, err = msgp.ReadBytesBytesHeader(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "ClearStateProgram")
				return
			}
			if zb0030 > bounds.MaxAvailableAppProgramLen {
				err = msgp.ErrOverflow(uint64(zb0030), uint64(bounds.MaxAvailableAppProgramLen))
				return
			}
			(*z).ApplicationCallTxnFields.ClearStateProgram, bts, err = msgp.ReadBytesBytes(bts, (*z).ApplicationCallTxnFields.ClearStateProgram)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "ClearStateProgram")
				return
			}
		}
		if zb0008 > 0 {
			zb0008--
			(*z).ApplicationCallTxnFields.ExtraProgramPages, bts, err = msgp.ReadUint32Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "ExtraProgramPages")
				return
			}
		}
		if zb0008 > 0 {
			zb0008--
			(*z).ApplicationCallTxnFields.RejectVersion, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "RejectVersion")
				return
			}
		}
		if zb0008 > 0 {
			zb0008--
			bts, err = (*z).StateProofTxnFields.StateProofType.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "StateProofType")
				return
			}
		}
		if zb0008 > 0 {
			zb0008--
			bts, err = (*z).StateProofTxnFields.StateProof.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "StateProof")
				return
			}
		}
		if zb0008 > 0 {
			zb0008--
			bts, err = (*z).StateProofTxnFields.Message.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Message")
				return
			}
		}
		if zb0008 > 0 {
			zb0008--
			if msgp.IsNil(bts) {
				bts, err = msgp.ReadNilBytes(bts)
				if err != nil {
					return
				}
				(*z).HeartbeatTxnFields = nil
			} else {
				if (*z).HeartbeatTxnFields == nil {
					(*z).HeartbeatTxnFields = new(HeartbeatTxnFields)
				}
				bts, err = (*z).HeartbeatTxnFields.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "HeartbeatTxnFields")
					return
				}
			}
		}
		if zb0008 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0008)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0009 {
			(*z) = Transaction{}
		}
		for zb0008 > 0 {
			zb0008--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "type":
				bts, err = (*z).Type.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Type")
					return
				}
			case "snd":
				bts, err = (*z).Header.Sender.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Sender")
					return
				}
			case "fee":
				bts, err = (*z).Header.Fee.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Fee")
					return
				}
			case "fv":
				bts, err = (*z).Header.FirstValid.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "FirstValid")
					return
				}
			case "lv":
				bts, err = (*z).Header.LastValid.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "LastValid")
					return
				}
			case "note":
				var zb0031 int
				zb0031, err = msgp.ReadBytesBytesHeader(bts)
				if err != nil {
					err = msgp.WrapError(err, "Note")
					return
				}
				if zb0031 > bounds.MaxTxnNoteBytes {
					err = msgp.ErrOverflow(uint64(zb0031), uint64(bounds.MaxTxnNoteBytes))
					return
				}
				(*z).Header.Note, bts, err = msgp.ReadBytesBytes(bts, (*z).Header.Note)
				if err != nil {
					err = msgp.WrapError(err, "Note")
					return
				}
			case "gen":
				var zb0032 int
				zb0032, err = msgp.ReadBytesBytesHeader(bts)
				if err != nil {
					err = msgp.WrapError(err, "GenesisID")
					return
				}
				if zb0032 > bounds.MaxGenesisIDLen {
					err = msgp.ErrOverflow(uint64(zb0032), uint64(bounds.MaxGenesisIDLen))
					return
				}
				(*z).Header.GenesisID, bts, err = msgp.ReadStringBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "GenesisID")
					return
				}
			case "gh":
				bts, err = (*z).Header.GenesisHash.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "GenesisHash")
					return
				}
			case "grp":
				bts, err = (*z).Header.Group.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Group")
					return
				}
			case "lx":
				bts, err = msgp.ReadExactBytes(bts, ((*z).Header.Lease)[:])
				if err != nil {
					err = msgp.WrapError(err, "Lease")
					return
				}
			case "rekey":
				bts, err = (*z).Header.RekeyTo.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "RekeyTo")
					return
				}
			case "votekey":
				bts, err = (*z).KeyregTxnFields.VotePK.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "VotePK")
					return
				}
			case "selkey":
				bts, err = (*z).KeyregTxnFields.SelectionPK.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "SelectionPK")
					return
				}
			case "sprfkey":
				bts, err = (*z).KeyregTxnFields.StateProofPK.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "StateProofPK")
					return
				}
			case "votefst":
				bts, err = (*z).KeyregTxnFields.VoteFirst.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "VoteFirst")
					return
				}
			case "votelst":
				bts, err = (*z).KeyregTxnFields.VoteLast.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "VoteLast")
					return
				}
			case "votekd":
				(*z).KeyregTxnFields.VoteKeyDilution, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "VoteKeyDilution")
					return
				}
			case "nonpart":
				(*z).KeyregTxnFields.Nonparticipation, bts, err = msgp.ReadBoolBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Nonparticipation")
					return
				}
			case "rcv":
				bts, err = (*z).PaymentTxnFields.Receiver.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Receiver")
					return
				}
			case "amt":
				bts, err = (*z).PaymentTxnFields.Amount.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Amount")
					return
				}
			case "close":
				bts, err = (*z).PaymentTxnFields.CloseRemainderTo.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "CloseRemainderTo")
					return
				}
			case "caid":
				bts, err = (*z).AssetConfigTxnFields.ConfigAsset.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "ConfigAsset")
					return
				}
			case "apar":
				bts, err = (*z).AssetConfigTxnFields.AssetParams.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "AssetParams")
					return
				}
			case "xaid":
				bts, err = (*z).AssetTransferTxnFields.XferAsset.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "XferAsset")
					return
				}
			case "aamt":
				(*z).AssetTransferTxnFields.AssetAmount, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "AssetAmount")
					return
				}
			case "asnd":
				bts, err = (*z).AssetTransferTxnFields.AssetSender.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "AssetSender")
					return
				}
			case "arcv":
				bts, err = (*z).AssetTransferTxnFields.AssetReceiver.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "AssetReceiver")
					return
				}
			case "aclose":
				bts, err = (*z).AssetTransferTxnFields.AssetCloseTo.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "AssetCloseTo")
					return
				}
			case "fadd":
				bts, err = (*z).AssetFreezeTxnFields.FreezeAccount.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "FreezeAccount")
					return
				}
			case "faid":
				bts, err = (*z).AssetFreezeTxnFields.FreezeAsset.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "FreezeAsset")
					return
				}
			case "afrz":
				(*z).AssetFreezeTxnFields.AssetFrozen, bts, err = msgp.ReadBoolBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "AssetFrozen")
					return
				}
			case "apid":
				bts, err = (*z).ApplicationCallTxnFields.ApplicationID.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "ApplicationID")
					return
				}
			case "apan":
				{
					var zb0033 uint64
					zb0033, bts, err = msgp.ReadUint64Bytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "OnCompletion")
						return
					}
					(*z).ApplicationCallTxnFields.OnCompletion = OnCompletion(zb0033)
				}
			case "apaa":
				var zb0034 int
				var zb0035 bool
				zb0034, zb0035, bts, err = msgp.ReadArrayHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "ApplicationArgs")
					return
				}
				if zb0034 > encodedMaxApplicationArgs {
					err = msgp.ErrOverflow(uint64(zb0034), uint64(encodedMaxApplicationArgs))
					err = msgp.WrapError(err, "ApplicationArgs")
					return
				}
				if zb0035 {
					(*z).ApplicationCallTxnFields.ApplicationArgs = nil
				} else if (*z).ApplicationCallTxnFields.ApplicationArgs != nil && cap((*z).ApplicationCallTxnFields.ApplicationArgs) >= zb0034 {
					(*z).ApplicationCallTxnFields.ApplicationArgs = ((*z).ApplicationCallTxnFields.ApplicationArgs)[:zb0034]
				} else {
					(*z).ApplicationCallTxnFields.ApplicationArgs = make([][]byte, zb0034)
				}
				for zb0002 := range (*z).ApplicationCallTxnFields.ApplicationArgs {
					(*z).ApplicationCallTxnFields.ApplicationArgs[zb0002], bts, err = msgp.ReadBytesBytes(bts, (*z).ApplicationCallTxnFields.ApplicationArgs[zb0002])
					if err != nil {
						err = msgp.WrapError(err, "ApplicationArgs", zb0002)
						return
					}
				}
			case "apat":
				var zb0036 int
				var zb0037 bool
				zb0036, zb0037, bts, err = msgp.ReadArrayHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Accounts")
					return
				}
				if zb0036 > encodedMaxAccounts {
					err = msgp.ErrOverflow(uint64(zb0036), uint64(encodedMaxAccounts))
					err = msgp.WrapError(err, "Accounts")
					return
				}
				if zb0037 {
					(*z).ApplicationCallTxnFields.Accounts = nil
				} else if (*z).ApplicationCallTxnFields.Accounts != nil && cap((*z).ApplicationCallTxnFields.Accounts) >= zb0036 {
					(*z).ApplicationCallTxnFields.Accounts = ((*z).ApplicationCallTxnFields.Accounts)[:zb0036]
				} else {
					(*z).ApplicationCallTxnFields.Accounts = make([]basics.Address, zb0036)
				}
				for zb0003 := range (*z).ApplicationCallTxnFields.Accounts {
					bts, err = (*z).ApplicationCallTxnFields.Accounts[zb0003].UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "Accounts", zb0003)
						return
					}
				}
			case "apas":
				var zb0038 int
				var zb0039 bool
				zb0038, zb0039, bts, err = msgp.ReadArrayHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "ForeignAssets")
					return
				}
				if zb0038 > encodedMaxForeignAssets {
					err = msgp.ErrOverflow(uint64(zb0038), uint64(encodedMaxForeignAssets))
					err = msgp.WrapError(err, "ForeignAssets")
					return
				}
				if zb0039 {
					(*z).ApplicationCallTxnFields.ForeignAssets = nil
				} else if (*z).ApplicationCallTxnFields.ForeignAssets != nil && cap((*z).ApplicationCallTxnFields.ForeignAssets) >= zb0038 {
					(*z).ApplicationCallTxnFields.ForeignAssets = ((*z).ApplicationCallTxnFields.ForeignAssets)[:zb0038]
				} else {
					(*z).ApplicationCallTxnFields.ForeignAssets = make([]basics.AssetIndex, zb0038)
				}
				for zb0004 := range (*z).ApplicationCallTxnFields.ForeignAssets {
					bts, err = (*z).ApplicationCallTxnFields.ForeignAssets[zb0004].UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "ForeignAssets", zb0004)
						return
					}
				}
			case "apfa":
				var zb0040 int
				var zb0041 bool
				zb0040, zb0041, bts, err = msgp.ReadArrayHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "ForeignApps")
					return
				}
				if zb0040 > encodedMaxForeignApps {
					err = msgp.ErrOverflow(uint64(zb0040), uint64(encodedMaxForeignApps))
					err = msgp.WrapError(err, "ForeignApps")
					return
				}
				if zb0041 {
					(*z).ApplicationCallTxnFields.ForeignApps = nil
				} else if (*z).ApplicationCallTxnFields.ForeignApps != nil && cap((*z).ApplicationCallTxnFields.ForeignApps) >= zb0040 {
					(*z).ApplicationCallTxnFields.ForeignApps = ((*z).ApplicationCallTxnFields.ForeignApps)[:zb0040]
				} else {
					(*z).ApplicationCallTxnFields.ForeignApps = make([]basics.AppIndex, zb0040)
				}
				for zb0005 := range (*z).ApplicationCallTxnFields.ForeignApps {
					bts, err = (*z).ApplicationCallTxnFields.ForeignApps[zb0005].UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "ForeignApps", zb0005)
						return
					}
				}
			case "al":
				var zb0042 int
				var zb0043 bool
				zb0042, zb0043, bts, err = msgp.ReadArrayHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Access")
					return
				}
				if zb0042 > encodedMaxAccess {
					err = msgp.ErrOverflow(uint64(zb0042), uint64(encodedMaxAccess))
					err = msgp.WrapError(err, "Access")
					return
				}
				if zb0043 {
					(*z).ApplicationCallTxnFields.Access = nil
				} else if (*z).ApplicationCallTxnFields.Access != nil && cap((*z).ApplicationCallTxnFields.Access) >= zb0042 {
					(*z).ApplicationCallTxnFields.Access = ((*z).ApplicationCallTxnFields.Access)[:zb0042]
				} else {
					(*z).ApplicationCallTxnFields.Access = make([]ResourceRef, zb0042)
				}
				for zb0006 := range (*z).ApplicationCallTxnFields.Access {
					bts, err = (*z).ApplicationCallTxnFields.Access[zb0006].UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "Access", zb0006)
						return
					}
				}
			case "apbx":
				var zb0044 int
				var zb0045 bool
				zb0044, zb0045, bts, err = msgp.ReadArrayHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Boxes")
					return
				}
				if zb0044 > encodedMaxBoxes {
					err = msgp.ErrOverflow(uint64(zb0044), uint64(encodedMaxBoxes))
					err = msgp.WrapError(err, "Boxes")
					return
				}
				if zb0045 {
					(*z).ApplicationCallTxnFields.Boxes = nil
				} else if (*z).ApplicationCallTxnFields.Boxes != nil && cap((*z).ApplicationCallTxnFields.Boxes) >= zb0044 {
					(*z).ApplicationCallTxnFields.Boxes = ((*z).ApplicationCallTxnFields.Boxes)[:zb0044]
				} else {
					(*z).ApplicationCallTxnFields.Boxes = make([]BoxRef, zb0044)
				}
				for zb0007 := range (*z).ApplicationCallTxnFields.Boxes {
					var zb0046 int
					var zb0047 bool
					zb0046, zb0047, bts, err = msgp.ReadMapHeaderBytes(bts)
					if _, ok := err.(msgp.TypeError); ok {
						zb0046, zb0047, bts, err = msgp.ReadArrayHeaderBytes(bts)
						if err != nil {
							err = msgp.WrapError(err, "Boxes", zb0007)
							return
						}
						if zb0046 > 0 {
							zb0046--
							(*z).ApplicationCallTxnFields.Boxes[zb0007].Index, bts, err = msgp.ReadUint64Bytes(bts)
							if err != nil {
								err = msgp.WrapError(err, "Boxes", zb0007, "struct-from-array", "Index")
								return
							}
						}
						if zb0046 > 0 {
							zb0046--
							var zb0048 int
							zb0048, err = msgp.ReadBytesBytesHeader(bts)
							if err != nil {
								err = msgp.WrapError(err, "Boxes", zb0007, "struct-from-array", "Name")
								return
							}
							if zb0048 > bounds.MaxBytesKeyValueLen {
								err = msgp.ErrOverflow(uint64(zb0048), uint64(bounds.MaxBytesKeyValueLen))
								return
							}
							(*z).ApplicationCallTxnFields.Boxes[zb0007].Name, bts, err = msgp.ReadBytesBytes(bts, (*z).ApplicationCallTxnFields.Boxes[zb0007].Name)
							if err != nil {
								err = msgp.WrapError(err, "Boxes", zb0007, "struct-from-array", "Name")
								return
							}
						}
						if zb0046 > 0 {
							err = msgp.ErrTooManyArrayFields(zb0046)
							if err != nil {
								err = msgp.WrapError(err, "Boxes", zb0007, "struct-from-array")
								return
							}
						}
					} else {
						if err != nil {
							err = msgp.WrapError(err, "Boxes", zb0007)
							return
						}
						if zb0047 {
							(*z).ApplicationCallTxnFields.Boxes[zb0007] = BoxRef{}
						}
						for zb0046 > 0 {
							zb0046--
							field, bts, err = msgp.ReadMapKeyZC(bts)
							if err != nil {
								err = msgp.WrapError(err, "Boxes", zb0007)
								return
							}
							switch string(field) {
							case "i":
								(*z).ApplicationCallTxnFields.Boxes[zb0007].Index, bts, err = msgp.ReadUint64Bytes(bts)
								if err != nil {
									err = msgp.WrapError(err, "Boxes", zb0007, "Index")
									return
								}
							case "n":
								var zb0049 int
								zb0049, err = msgp.ReadBytesBytesHeader(bts)
								if err != nil {
									err = msgp.WrapError(err, "Boxes", zb0007, "Name")
									return
								}
								if zb0049 > bounds.MaxBytesKeyValueLen {
									err = msgp.ErrOverflow(uint64(zb0049), uint64(bounds.MaxBytesKeyValueLen))
									return
								}
								(*z).ApplicationCallTxnFields.Boxes[zb0007].Name, bts, err = msgp.ReadBytesBytes(bts, (*z).ApplicationCallTxnFields.Boxes[zb0007].Name)
								if err != nil {
									err = msgp.WrapError(err, "Boxes", zb0007, "Name")
									return
								}
							default:
								err = msgp.ErrNoField(string(field))
								if err != nil {
									err = msgp.WrapError(err, "Boxes", zb0007)
									return
								}
							}
						}
					}
				}
			case "apls":
				bts, err = (*z).ApplicationCallTxnFields.LocalStateSchema.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "LocalStateSchema")
					return
				}
			case "apgs":
				bts, err = (*z).ApplicationCallTxnFields.GlobalStateSchema.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "GlobalStateSchema")
					return
				}
			case "apap":
				var zb0050 int
				zb0050, err = msgp.ReadBytesBytesHeader(bts)
				if err != nil {
					err = msgp.WrapError(err, "ApprovalProgram")
					return
				}
				if zb0050 > bounds.MaxAvailableAppProgramLen {
					err = msgp.ErrOverflow(uint64(zb0050), uint64(bounds.MaxAvailableAppProgramLen))
					return
				}
				(*z).ApplicationCallTxnFields.ApprovalProgram, bts, err = msgp.ReadBytesBytes(bts, (*z).ApplicationCallTxnFields.ApprovalProgram)
				if err != nil {
					err = msgp.WrapError(err, "ApprovalProgram")
					return
				}
			case "apsu":
				var zb0051 int
				zb0051, err = msgp.ReadBytesBytesHeader(bts)
				if err != nil {
					err = msgp.WrapError(err, "ClearStateProgram")
					return
				}
				if zb0051 > bounds.MaxAvailableAppProgramLen {
					err = msgp.ErrOverflow(uint64(zb0051), uint64(bounds.MaxAvailableAppProgramLen))
					return
				}
				(*z).ApplicationCallTxnFields.ClearStateProgram, bts, err = msgp.ReadBytesBytes(bts, (*z).ApplicationCallTxnFields.ClearStateProgram)
				if err != nil {
					err = msgp.WrapError(err, "ClearStateProgram")
					return
				}
			case "apep":
				(*z).ApplicationCallTxnFields.ExtraProgramPages, bts, err = msgp.ReadUint32Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "ExtraProgramPages")
					return
				}
			case "aprv":
				(*z).ApplicationCallTxnFields.RejectVersion, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "RejectVersion")
					return
				}
			case "sptype":
				bts, err = (*z).StateProofTxnFields.StateProofType.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "StateProofType")
					return
				}
			case "sp":
				bts, err = (*z).StateProofTxnFields.StateProof.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "StateProof")
					return
				}
			case "spmsg":
				bts, err = (*z).StateProofTxnFields.Message.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Message")
					return
				}
			case "hb":
				if msgp.IsNil(bts) {
					bts, err = msgp.ReadNilBytes(bts)
					if err != nil {
						return
					}
					(*z).HeartbeatTxnFields = nil
				} else {
					if (*z).HeartbeatTxnFields == nil {
						(*z).HeartbeatTxnFields = new(HeartbeatTxnFields)
					}
					bts, err = (*z).HeartbeatTxnFields.UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "HeartbeatTxnFields")
						return
					}
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *Transaction) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *Transaction) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*Transaction)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *Transaction) Msgsize() (s int) {
	s = 3 + 5 + (*z).Type.Msgsize() + 4 + (*z).Header.Sender.Msgsize() + 4 + (*z).Header.Fee.Msgsize() + 3 + (*z).Header.FirstValid.Msgsize() + 3 + (*z).Header.LastValid.Msgsize() + 5 + msgp.BytesPrefixSize + len((*z).Header.Note) + 4 + msgp.StringPrefixSize + len((*z).Header.GenesisID) + 3 + (*z).Header.GenesisHash.Msgsize() + 4 + (*z).Header.Group.Msgsize() + 3 + msgp.ArrayHeaderSize + (32 * (msgp.ByteSize)) + 6 + (*z).Header.RekeyTo.Msgsize() + 8 + (*z).KeyregTxnFields.VotePK.Msgsize() + 7 + (*z).KeyregTxnFields.SelectionPK.Msgsize() + 8 + (*z).KeyregTxnFields.StateProofPK.Msgsize() + 8 + (*z).KeyregTxnFields.VoteFirst.Msgsize() + 8 + (*z).KeyregTxnFields.VoteLast.Msgsize() + 7 + msgp.Uint64Size + 8 + msgp.BoolSize + 4 + (*z).PaymentTxnFields.Receiver.Msgsize() + 4 + (*z).PaymentTxnFields.Amount.Msgsize() + 6 + (*z).PaymentTxnFields.CloseRemainderTo.Msgsize() + 5 + (*z).AssetConfigTxnFields.ConfigAsset.Msgsize() + 5 + (*z).AssetConfigTxnFields.AssetParams.Msgsize() + 5 + (*z).AssetTransferTxnFields.XferAsset.Msgsize() + 5 + msgp.Uint64Size + 5 + (*z).AssetTransferTxnFields.AssetSender.Msgsize() + 5 + (*z).AssetTransferTxnFields.AssetReceiver.Msgsize() + 7 + (*z).AssetTransferTxnFields.AssetCloseTo.Msgsize() + 5 + (*z).AssetFreezeTxnFields.FreezeAccount.Msgsize() + 5 + (*z).AssetFreezeTxnFields.FreezeAsset.Msgsize() + 5 + msgp.BoolSize + 5 + (*z).ApplicationCallTxnFields.ApplicationID.Msgsize() + 5 + msgp.Uint64Size + 5 + msgp.ArrayHeaderSize
	for zb0002 := range (*z).ApplicationCallTxnFields.ApplicationArgs {
		s += msgp.BytesPrefixSize + len((*z).ApplicationCallTxnFields.ApplicationArgs[zb0002])
	}
	s += 5 + msgp.ArrayHeaderSize
	for zb0003 := range (*z).ApplicationCallTxnFields.Accounts {
		s += (*z).ApplicationCallTxnFields.Accounts[zb0003].Msgsize()
	}
	s += 5 + msgp.ArrayHeaderSize
	for zb0004 := range (*z).ApplicationCallTxnFields.ForeignAssets {
		s += (*z).ApplicationCallTxnFields.ForeignAssets[zb0004].Msgsize()
	}
	s += 5 + msgp.ArrayHeaderSize
	for zb0005 := range (*z).ApplicationCallTxnFields.ForeignApps {
		s += (*z).ApplicationCallTxnFields.ForeignApps[zb0005].Msgsize()
	}
	s += 3 + msgp.ArrayHeaderSize
	for zb0006 := range (*z).ApplicationCallTxnFields.Access {
		s += (*z).ApplicationCallTxnFields.Access[zb0006].Msgsize()
	}
	s += 5 + msgp.ArrayHeaderSize
	for zb0007 := range (*z).ApplicationCallTxnFields.Boxes {
		s += 1 + 2 + msgp.Uint64Size + 2 + msgp.BytesPrefixSize + len((*z).ApplicationCallTxnFields.Boxes[zb0007].Name)
	}
	s += 5 + (*z).ApplicationCallTxnFields.LocalStateSchema.Msgsize() + 5 + (*z).ApplicationCallTxnFields.GlobalStateSchema.Msgsize() + 5 + msgp.BytesPrefixSize + len((*z).ApplicationCallTxnFields.ApprovalProgram) + 5 + msgp.BytesPrefixSize + len((*z).ApplicationCallTxnFields.ClearStateProgram) + 5 + msgp.Uint32Size + 5 + msgp.Uint64Size + 7 + (*z).StateProofTxnFields.StateProofType.Msgsize() + 3 + (*z).StateProofTxnFields.StateProof.Msgsize() + 6 + (*z).StateProofTxnFields.Message.Msgsize() + 3
	if (*z).HeartbeatTxnFields == nil {
		s += msgp.NilSize
	} else {
		s += (*z).HeartbeatTxnFields.Msgsize()
	}
	return
}

// MsgIsZero returns whether this is a zero value
func (z *Transaction) MsgIsZero() bool {
	return ((*z).Type.MsgIsZero()) && ((*z).Header.Sender.MsgIsZero()) && ((*z).Header.Fee.MsgIsZero()) && ((*z).Header.FirstValid.MsgIsZero()) && ((*z).Header.LastValid.MsgIsZero()) && (len((*z).Header.Note) == 0) && ((*z).Header.GenesisID == "") && ((*z).Header.GenesisHash.MsgIsZero()) && ((*z).Header.Group.MsgIsZero()) && ((*z).Header.Lease == ([32]byte{})) && ((*z).Header.RekeyTo.MsgIsZero()) && ((*z).KeyregTxnFields.VotePK.MsgIsZero()) && ((*z).KeyregTxnFields.SelectionPK.MsgIsZero()) && ((*z).KeyregTxnFields.StateProofPK.MsgIsZero()) && ((*z).KeyregTxnFields.VoteFirst.MsgIsZero()) && ((*z).KeyregTxnFields.VoteLast.MsgIsZero()) && ((*z).KeyregTxnFields.VoteKeyDilution == 0) && ((*z).KeyregTxnFields.Nonparticipation == false) && ((*z).PaymentTxnFields.Receiver.MsgIsZero()) && ((*z).PaymentTxnFields.Amount.MsgIsZero()) && ((*z).PaymentTxnFields.CloseRemainderTo.MsgIsZero()) && ((*z).AssetConfigTxnFields.ConfigAsset.MsgIsZero()) && ((*z).AssetConfigTxnFields.AssetParams.MsgIsZero()) && ((*z).AssetTransferTxnFields.XferAsset.MsgIsZero()) && ((*z).AssetTransferTxnFields.AssetAmount == 0) && ((*z).AssetTransferTxnFields.AssetSender.MsgIsZero()) && ((*z).AssetTransferTxnFields.AssetReceiver.MsgIsZero()) && ((*z).AssetTransferTxnFields.AssetCloseTo.MsgIsZero()) && ((*z).AssetFreezeTxnFields.FreezeAccount.MsgIsZero()) && ((*z).AssetFreezeTxnFields.FreezeAsset.MsgIsZero()) && ((*z).AssetFreezeTxnFields.AssetFrozen == false) && ((*z).ApplicationCallTxnFields.ApplicationID.MsgIsZero()) && ((*z).ApplicationCallTxnFields.OnCompletion == 0) && (len((*z).ApplicationCallTxnFields.ApplicationArgs) == 0) && (len((*z).ApplicationCallTxnFields.Accounts) == 0) && (len((*z).ApplicationCallTxnFields.ForeignAssets) == 0) && (len((*z).ApplicationCallTxnFields.ForeignApps) == 0) && (len((*z).ApplicationCallTxnFields.Access) == 0) && (len((*z).ApplicationCallTxnFields.Boxes) == 0) && ((*z).ApplicationCallTxnFields.LocalStateSchema.MsgIsZero()) && ((*z).ApplicationCallTxnFields.GlobalStateSchema.MsgIsZero()) && (len((*z).ApplicationCallTxnFields.ApprovalProgram) == 0) && (len((*z).ApplicationCallTxnFields.ClearStateProgram) == 0) && ((*z).ApplicationCallTxnFields.ExtraProgramPages == 0) && ((*z).ApplicationCallTxnFields.RejectVersion == 0) && ((*z).StateProofTxnFields.StateProofType.MsgIsZero()) && ((*z).StateProofTxnFields.StateProof.MsgIsZero()) && ((*z).StateProofTxnFields.Message.MsgIsZero()) && ((*z).HeartbeatTxnFields == nil)
}

// MaxSize returns a maximum valid message size for this message type
func TransactionMaxSize() (s int) {
	s = 3 + 5 + protocol.TxTypeMaxSize() + 4 + basics.AddressMaxSize() + 4 + basics.MicroAlgosMaxSize() + 3 + basics.RoundMaxSize() + 3 + basics.RoundMaxSize() + 5 + msgp.BytesPrefixSize + bounds.MaxTxnNoteBytes + 4 + msgp.StringPrefixSize + bounds.MaxGenesisIDLen + 3 + crypto.DigestMaxSize() + 4 + crypto.DigestMaxSize() + 3
	// Calculating size of array: z.Header.Lease
	s += msgp.ArrayHeaderSize + ((32) * (msgp.ByteSize))
	s += 6 + basics.AddressMaxSize() + 8 + crypto.OneTimeSignatureVerifierMaxSize() + 7 + crypto.VRFVerifierMaxSize() + 8 + merklesignature.CommitmentMaxSize() + 8 + basics.RoundMaxSize() + 8 + basics.RoundMaxSize() + 7 + msgp.Uint64Size + 8 + msgp.BoolSize + 4 + basics.AddressMaxSize() + 4 + basics.MicroAlgosMaxSize() + 6 + basics.AddressMaxSize() + 5 + basics.AssetIndexMaxSize() + 5 + basics.AssetParamsMaxSize() + 5 + basics.AssetIndexMaxSize() + 5 + msgp.Uint64Size + 5 + basics.AddressMaxSize() + 5 + basics.AddressMaxSize() + 7 + basics.AddressMaxSize() + 5 + basics.AddressMaxSize() + 5 + basics.AssetIndexMaxSize() + 5 + msgp.BoolSize + 5 + basics.AppIndexMaxSize() + 5 + msgp.Uint64Size + 5
	// Calculating size of slice: z.ApplicationCallTxnFields.ApplicationArgs
	s += msgp.ArrayHeaderSize + bounds.MaxAppTotalArgLen + 5
	// Calculating size of slice: z.ApplicationCallTxnFields.Accounts
	s += msgp.ArrayHeaderSize + ((encodedMaxAccounts) * (basics.AddressMaxSize()))
	s += 5
	// Calculating size of slice: z.ApplicationCallTxnFields.ForeignAssets
	s += msgp.ArrayHeaderSize + ((encodedMaxForeignAssets) * (basics.AssetIndexMaxSize()))
	s += 5
	// Calculating size of slice: z.ApplicationCallTxnFields.ForeignApps
	s += msgp.ArrayHeaderSize + ((encodedMaxForeignApps) * (basics.AppIndexMaxSize()))
	s += 3
	// Calculating size of slice: z.ApplicationCallTxnFields.Access
	s += msgp.ArrayHeaderSize + ((encodedMaxAccess) * (ResourceRefMaxSize()))
	s += 5
	// Calculating size of slice: z.ApplicationCallTxnFields.Boxes
	s += msgp.ArrayHeaderSize + ((encodedMaxBoxes) * (BoxRefMaxSize()))
	s += 5 + basics.StateSchemaMaxSize() + 5 + basics.StateSchemaMaxSize() + 5 + msgp.BytesPrefixSize + bounds.MaxAvailableAppProgramLen + 5 + msgp.BytesPrefixSize + bounds.MaxAvailableAppProgramLen + 5 + msgp.Uint32Size + 5 + msgp.Uint64Size + 7 + protocol.StateProofTypeMaxSize() + 3 + stateproof.StateProofMaxSize() + 6 + stateproofmsg.MessageMaxSize() + 3
	s += HeartbeatTxnFieldsMaxSize()
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *TxGroup) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0002Len := uint32(1)
	var zb0002Mask uint8 /* 2 bits */
	if len((*z).TxGroupHashes) == 0 {
		zb0002Len--
		zb0002Mask |= 0x2
	}
	// variable map header, size zb0002Len
	o = append(o, 0x80|uint8(zb0002Len))
	if zb0002Len != 0 {
		if (zb0002Mask & 0x2) == 0 { // if not empty
			// string "txlist"
			o = append(o, 0xa6, 0x74, 0x78, 0x6c, 0x69, 0x73, 0x74)
			if (*z).TxGroupHashes == nil {
				o = msgp.AppendNil(o)
			} else {
				o = msgp.AppendArrayHeader(o, uint32(len((*z).TxGroupHashes)))
			}
			for zb0001 := range (*z).TxGroupHashes {
				o = (*z).TxGroupHashes[zb0001].MarshalMsg(o)
			}
		}
	}
	return
}

func (_ *TxGroup) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*TxGroup)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *TxGroup) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0002 int
	var zb0003 bool
	zb0002, zb0003, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0002, zb0003, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 > 0 {
			zb0002--
			var zb0004 int
			var zb0005 bool
			zb0004, zb0005, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "TxGroupHashes")
				return
			}
			if zb0004 > bounds.MaxTxGroupSize {
				err = msgp.ErrOverflow(uint64(zb0004), uint64(bounds.MaxTxGroupSize))
				err = msgp.WrapError(err, "struct-from-array", "TxGroupHashes")
				return
			}
			if zb0005 {
				(*z).TxGroupHashes = nil
			} else if (*z).TxGroupHashes != nil && cap((*z).TxGroupHashes) >= zb0004 {
				(*z).TxGroupHashes = ((*z).TxGroupHashes)[:zb0004]
			} else {
				(*z).TxGroupHashes = make([]crypto.Digest, zb0004)
			}
			for zb0001 := range (*z).TxGroupHashes {
				bts, err = (*z).TxGroupHashes[zb0001].UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "TxGroupHashes", zb0001)
					return
				}
			}
		}
		if zb0002 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0002)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0003 {
			(*z) = TxGroup{}
		}
		for zb0002 > 0 {
			zb0002--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "txlist":
				var zb0006 int
				var zb0007 bool
				zb0006, zb0007, bts, err = msgp.ReadArrayHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "TxGroupHashes")
					return
				}
				if zb0006 > bounds.MaxTxGroupSize {
					err = msgp.ErrOverflow(uint64(zb0006), uint64(bounds.MaxTxGroupSize))
					err = msgp.WrapError(err, "TxGroupHashes")
					return
				}
				if zb0007 {
					(*z).TxGroupHashes = nil
				} else if (*z).TxGroupHashes != nil && cap((*z).TxGroupHashes) >= zb0006 {
					(*z).TxGroupHashes = ((*z).TxGroupHashes)[:zb0006]
				} else {
					(*z).TxGroupHashes = make([]crypto.Digest, zb0006)
				}
				for zb0001 := range (*z).TxGroupHashes {
					bts, err = (*z).TxGroupHashes[zb0001].UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "TxGroupHashes", zb0001)
						return
					}
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *TxGroup) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *TxGroup) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*TxGroup)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *TxGroup) Msgsize() (s int) {
	s = 1 + 7 + msgp.ArrayHeaderSize
	for zb0001 := range (*z).TxGroupHashes {
		s += (*z).TxGroupHashes[zb0001].Msgsize()
	}
	return
}

// MsgIsZero returns whether this is a zero value
func (z *TxGroup) MsgIsZero() bool {
	return (len((*z).TxGroupHashes) == 0)
}

// MaxSize returns a maximum valid message size for this message type
func TxGroupMaxSize() (s int) {
	s = 1 + 7
	// Calculating size of slice: z.TxGroupHashes
	s += msgp.ArrayHeaderSize + ((bounds.MaxTxGroupSize) * (crypto.DigestMaxSize()))
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *Txid) MarshalMsg(b []byte) []byte {
	return ((*(crypto.Digest))(z)).MarshalMsg(b)
}
func (_ *Txid) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*Txid)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *Txid) UnmarshalMsg(bts []byte) ([]byte, error) {
	return ((*(crypto.Digest))(z)).UnmarshalMsg(bts)
}
func (z *Txid) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) ([]byte, error) {
	return ((*(crypto.Digest))(z)).UnmarshalMsgWithState(bts, st)
}
func (_ *Txid) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*Txid)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *Txid) Msgsize() int {
	return ((*(crypto.Digest))(z)).Msgsize()
}

// MsgIsZero returns whether this is a zero value
func (z *Txid) MsgIsZero() bool {
	return ((*(crypto.Digest))(z)).MsgIsZero()
}

// MaxSize returns a maximum valid message size for this message type
func TxidMaxSize() int {
	return crypto.DigestMaxSize()
}
