// Package private provides primitives to interact with the openapi HTTP API.
//
// Code generated by github.com/oapi-codegen/oapi-codegen/v2 version v2.4.1 DO NOT EDIT.
package private

import (
	"bytes"
	"compress/gzip"
	"encoding/base64"
	"fmt"
	"net/http"
	"net/url"
	"path"
	"strings"

	. "github.com/algorand/go-algorand/daemon/algod/api/server/v2/generated/model"
	"github.com/getkin/kin-openapi/openapi3"
	"github.com/labstack/echo/v4"
	"github.com/oapi-codegen/runtime"
)

// ServerInterface represents all server handlers.
type ServerInterface interface {
	// Gets the merged config file.
	// (GET /debug/settings/config)
	GetConfig(ctx echo.Context) error

	// (GET /debug/settings/pprof)
	GetDebugSettingsProf(ctx echo.Context) error

	// (PUT /debug/settings/pprof)
	PutDebugSettingsProf(ctx echo.Context) error
	// Aborts a catchpoint catchup.
	// (DELETE /v2/catchup/{catchpoint})
	AbortCatchup(ctx echo.Context, catchpoint string) error
	// Starts a catchpoint catchup.
	// (POST /v2/catchup/{catchpoint})
	StartCatchup(ctx echo.Context, catchpoint string, params StartCatchupParams) error

	// (POST /v2/shutdown)
	ShutdownNode(ctx echo.Context, params ShutdownNodeParams) error
}

// ServerInterfaceWrapper converts echo contexts to parameters.
type ServerInterfaceWrapper struct {
	Handler ServerInterface
}

// GetConfig converts echo context to params.
func (w *ServerInterfaceWrapper) GetConfig(ctx echo.Context) error {
	var err error

	ctx.Set(Api_keyScopes, []string{})

	// Invoke the callback with all the unmarshaled arguments
	err = w.Handler.GetConfig(ctx)
	return err
}

// GetDebugSettingsProf converts echo context to params.
func (w *ServerInterfaceWrapper) GetDebugSettingsProf(ctx echo.Context) error {
	var err error

	ctx.Set(Api_keyScopes, []string{})

	// Invoke the callback with all the unmarshaled arguments
	err = w.Handler.GetDebugSettingsProf(ctx)
	return err
}

// PutDebugSettingsProf converts echo context to params.
func (w *ServerInterfaceWrapper) PutDebugSettingsProf(ctx echo.Context) error {
	var err error

	ctx.Set(Api_keyScopes, []string{})

	// Invoke the callback with all the unmarshaled arguments
	err = w.Handler.PutDebugSettingsProf(ctx)
	return err
}

// AbortCatchup converts echo context to params.
func (w *ServerInterfaceWrapper) AbortCatchup(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "catchpoint" -------------
	var catchpoint string

	err = runtime.BindStyledParameterWithOptions("simple", "catchpoint", ctx.Param("catchpoint"), &catchpoint, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter catchpoint: %s", err))
	}

	ctx.Set(Api_keyScopes, []string{})

	// Invoke the callback with all the unmarshaled arguments
	err = w.Handler.AbortCatchup(ctx, catchpoint)
	return err
}

// StartCatchup converts echo context to params.
func (w *ServerInterfaceWrapper) StartCatchup(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "catchpoint" -------------
	var catchpoint string

	err = runtime.BindStyledParameterWithOptions("simple", "catchpoint", ctx.Param("catchpoint"), &catchpoint, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter catchpoint: %s", err))
	}

	ctx.Set(Api_keyScopes, []string{})

	// Parameter object where we will unmarshal all parameters from the context
	var params StartCatchupParams
	// ------------- Optional query parameter "min" -------------

	err = runtime.BindQueryParameter("form", true, false, "min", ctx.QueryParams(), &params.Min)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter min: %s", err))
	}

	// Invoke the callback with all the unmarshaled arguments
	err = w.Handler.StartCatchup(ctx, catchpoint, params)
	return err
}

// ShutdownNode converts echo context to params.
func (w *ServerInterfaceWrapper) ShutdownNode(ctx echo.Context) error {
	var err error

	ctx.Set(Api_keyScopes, []string{})

	// Parameter object where we will unmarshal all parameters from the context
	var params ShutdownNodeParams
	// ------------- Optional query parameter "timeout" -------------

	err = runtime.BindQueryParameter("form", true, false, "timeout", ctx.QueryParams(), &params.Timeout)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter timeout: %s", err))
	}

	// Invoke the callback with all the unmarshaled arguments
	err = w.Handler.ShutdownNode(ctx, params)
	return err
}

// This is a simple interface which specifies echo.Route addition functions which
// are present on both echo.Echo and echo.Group, since we want to allow using
// either of them for path registration
type EchoRouter interface {
	CONNECT(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	DELETE(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	GET(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	HEAD(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	OPTIONS(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	PATCH(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	POST(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	PUT(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	TRACE(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
}

// RegisterHandlers adds each server route to the EchoRouter.
func RegisterHandlers(router EchoRouter, si ServerInterface, m ...echo.MiddlewareFunc) {
	RegisterHandlersWithBaseURL(router, si, "", m...)
}

// Registers handlers, and prepends BaseURL to the paths, so that the paths
// can be served under a prefix.
func RegisterHandlersWithBaseURL(router EchoRouter, si ServerInterface, baseURL string, m ...echo.MiddlewareFunc) {

	wrapper := ServerInterfaceWrapper{
		Handler: si,
	}

	router.GET(baseURL+"/debug/settings/config", wrapper.GetConfig, m...)
	router.GET(baseURL+"/debug/settings/pprof", wrapper.GetDebugSettingsProf, m...)
	router.PUT(baseURL+"/debug/settings/pprof", wrapper.PutDebugSettingsProf, m...)
	router.DELETE(baseURL+"/v2/catchup/:catchpoint", wrapper.AbortCatchup, m...)
	router.POST(baseURL+"/v2/catchup/:catchpoint", wrapper.StartCatchup, m...)
	router.POST(baseURL+"/v2/shutdown", wrapper.ShutdownNode, m...)

}

// Base64 encoded, gzipped, json marshaled Swagger object
var swaggerSpec = []string{

	"H4sIAAAAAAAC/+x9a3Mbt5LoX0Fxt8qPJSnZsbMnvnVqr2InOdo4sctSsnfX8k3AmSaJoyEwB8BIZHz1",
	"32+h8RjMDIYcUrST1O4nWxw8Go1Go9HPj6NMrErBgWs1evFxVFJJV6BB4l80zyUo/G8OKpOs1Ezw0YvR",
	"GSc0y0TFNSmrWcEycg2b6Wg8YuZrSfVyNB5xuoLRizDIeCThHxWTkI9eaFnBeKSyJayonVZrkKbv+7PJ",
	"f51Ovvrw8flf7kbjkd6UZgylJeOL0Xi0nizExP04o4planrmxr/b9ZWWZcEyapYwYXl6UXUTwnLgms0Z",
	"yL6FNcfbtr4V42xVrUYvTsOSGNewANmzprI85zms+xYVfaZKge5dj/k4YCV+jKOuwQy6dRWNBhnV2bIU",
	"jOvESgh+JfZzcglR922LmAu5orrdPiI/pL0n4yend/8USPHJ+PkXaWKkxUJIyvNJGPdlGJdc2HZ3ezT0",
	"X9sIeCn4nC0qCYrcLkEvQRK9BCJBlYIrIGL2d8g0YYr8+8WbH4mQ5AdQii7gLc2uCfBM5JBPyfmccKFJ",
	"KcUNyyEfkxzmtCq0Ilpgz0Af/6hAbmrsOrhiTAI3tPB+9Hcl+Gg8WqlFSbPr0Yc2mu7uxqOCrVhiVT/Q",
	"taEowqvVDCQRc7MgD44EXUneB5AdMYZnK0lWjOsvn7XpsP51Rddd8C5lxTOqIY8A1JJyRTPTAqHMmSoL",
	"ukHUruj6r6djB7gitChICTxnfEH0mqu+pZi5j7YQDusEoi+XQMwXUtIFRHiekp8UICXhVy2ugQfqILMN",
	"fiol3DBRqdCpZx04dWIhER1IUfEUoyL4waG5h0fZvsdkUO9wxLvt3xRbuE9tqC/Y4nJTApmzwtyX5O+V",
	"0oGAK4XbvgSiSsgM782JGcYgX7EFp7qS8OKKPzZ/kQm50JTnVObml5X96Yeq0OyCLcxPhf3ptViw7IIt",
	"enYgwJo6pwq7rew/Zrz0UdXr5F3yWojrqowXlMVnwdDK+as+yrBj9pNGmkGeBbkB98eNdbk+f9XHUrf3",
	"0OuwkT1A9uKupKbhNWwkGGhpNsd/1nMkLTqXv42seGF663KeQq0hf8euUaA6s/LTWS1EvHOfzddMcA32",
	"KozEjBNkti8+xpKTFCVIzeygtCwnhchoMVGaahzpnyXMRy9G/3RSC3ontrs6iSZ/bXpdYCdzGUswjG9C",
	"y3KPMd4a4RFFrZ6DbviQPepzIcntkmVLopdMEcbtJqLcZThNATeU6+lor5N8F3OH9w6IeivsJWm3osWA",
	"eveC2IYzUEj7Tuh9oBqSImKcIMYJ5TlZFGIWfnh4VpY1cvH7WVlaVI0JmxNgeJ/DmimtHiFmaH3I4nnO",
	"X03Jd/HYt6woiODFhszA3TuQmzEt33Z83AngBrG4hnrEB4rgTgs5Nbvm0WDksmMQI0qVS1GYK3AnGZnG",
	"f3NtYwo0vw/q/Kenvhjt/XSHEr1DKlKT/aV+uJGHLaLq0hT2MNR01u57GEWZUbbQkjqvEXxsusJfmIaV",
	"2kkkEUQRobntoVLSjZegJigJdSnoJwWWeEq6YByhHRuBnJMVvbb7IRDvhhBABUnbkpkVr26ZXtYiV0D9",
	"tPO++HMTcmrPidlwyoxsTAqmtBGGcDMVWUKBAicNioWYig4imgG0sGURAeZbSUtL5u6LleMYJzS8vyys",
	"97zJB16ySZhjtUWNd4TqYGa+k+EmIbEKhyYMXxciu/4bVcsjHP6ZH6t7LHAasgSagyRLqpaJM9Wi7Xq0",
	"IfRtGiLNklk01TQs8bVYqCMssRD7cLWyfEmLwkzd5Wat1eLAgw5yURDTmMCKafMAZhxPwILdALesZ0q+",
	"odnSCBMko0UxrvUSopwUcAMFEZIwzkGOiV5SXR9+HNk/lPAcKTB8UAOJVuN0GlNyuQQJcyHxoSqBrChe",
	"TivzPCqLZp/AXBVdQUt2wstSVNrAGL1czl/51cENcORJYWgEP6wRH/zx4FMzt/uEM3NhF0cloKKF8ayo",
	"8hp/gV80gDat66uW11MImaOih2rzG5MkE9IOYS9/N7n5D1BZd7bU+bCUMHFDSHoDUtHCrK61qEeBfI91",
	"OneczJxqGp1MR4XpF53lHNgPhUKQCe3GG/wPLYj5bAQcQ0k19TCUU1CmCfuBd7ZBlZ3JNDB8Swuysnoz",
	"UtLsei8oX9aTp9nMoJP3jVXVuS10iwg7dLlmuTrWNuFgfXvVPCFW5+PZUUdM2cp0ormGIOBSlMSyjxYI",
	"llPgaBYhYn30a+1rsU7B9LVYd640sYaj7IQZZzCz/1qsXznIhNyNeRx7CNLNAjldgcLbrWEGMbPUquqz",
	"mZCHSRMd00StgCfUjBoJU+MWkrBpVU7c2Uyox22D1kAkqJe2CwHt4VMYa2DhQtNPgAVlRj0GFpoDHRsL",
	"YlWyAo5A+sukEDejCr54Si7+dvb8ydNfnj7/0pBkKcVC0hWZbTQo8tDp+YjSmwIeJR9OKF2kR//ymTeI",
	"NMdNjaNEJTNY0bI7lDW02IexbUZMuy7WmmjGVQcAB3FEMFebRTt5Z/vdjUevYFYtLkBr8wh+K8X86Nyw",
	"M0MKOmz0tpRGsFBNo5STlk5y0+QE1lrSkxJbAs+t6c2sgynzBlzNjkJUfRuf17PkxGE0h52HYt9tqqfZ",
	"xFslN7I6huYDpBQyeQWXUmiRiWJi5DwmErqLt64FcS38dpXt3y205JYqYuZGA1jF8x4VhV7z4feXHfpy",
	"zWvcbL3B7HoTq3PzDtmXJvLrV0gJcqLXnCB1NjQncylWhJIcO6Ks8R1oK3+xFVxouirfzOfH0ZEKHCih",
	"4mErUGYmYlsY6UdBJniudmpzvDWwhUw31RCctbHlbVm6HyqHposNz1CNdIyz3K/9cqY+ojY8i1RhBsYC",
	"8kWDVj+pyqsPUxaKByoBqcHUa/yMFoFXUGj6rZCXtbj7nRRVeXR23p5z6HKoW4yzOeSmr9coM74ooCGp",
	"Lwzs09Qaf5cFvQxKB7sGhB6J9TVbLHX0vnwrxSe4Q5OzpADFD1a5VJg+XRXTjyI3zEdX6giiZz1YzREN",
	"3cZ8kM5EpQklXOSAm1+ptFDa47VjDmpWSQlcx3Iu6jOYIjMw1JXRyqy2KokWqful7jihmT2hE0SN6nFz",
	"CK4atpWdbklvgNBCAs03ZAbAiZiZRddeDrhIqkhpZGcn1jmReCi/bQBbSpGBUpBPnD57J7y+nb1/9Bbk",
	"4WpwFWEWogSZU/lpVnB9sxP4a9hMbmhRGfH8+5/Voz/KIrTQtNixBdgmtRFt9V13KfeAaRsRtyGKSdlq",
	"C+1JMCK2YToFaOhD9v2x17v9bTA7RPCJEHgDEj1qPunR8pN8AqIM8H/ig/VJllCVEyMG9qofjORq9ptT",
	"LrxsuGOGMEFBlZ7sulJMo4bexCw14uKpWwQH7pEnX1OlUQwkjOeov7VXIc5jZUszxWhPpzKcsvc1Zib9",
	"2T/EutNm5nrnqlLhVaaqshRSQ55aHtqse+f6EdZhLjGPxg5PPy1IpWDXyH0IjMZ3eHSKAPyD6mChdjbv",
	"7uLQ68CIL5t9sdyAr8bRNhgvfKsI8bFTbQ+MTNV7YMmNqRa9zYQogKLKVGlRloZD6UnFQ78+DF7Y1mf6",
	"p7ptlyStGchKKrkAhSYm195BfmuRrtDWtaSKODi8fwIqvKyLXBdmc6wnivEMJtvOCz6CTav44Bx03Kty",
	"IWkOkxwKukl4W9jPxH7ekzD82Eggtf5AaJjM0JqYppH6THh/08NmFTiVSgneBL+QzJxz84yqSc31PnzS",
	"HHDaFN90xPogzIJgJOnAj4fIsvSUGBHv/huhDVk5osPVuFvpnmvpwV6Y9ZMgEMed1IqA9uz/CcrNHQSw",
	"o86/AdW38HrqYy27R/2Pd3vjwmxdZa3bJnlF9PLlHYyxjwf12CLeUqlZxkp8rn4Pm6O/3tsTJH0lSA6a",
	"sgJyEn2wL/ky7k+sG3J7zMNe84PUrV3wO/rWxHK8Z1YT+GvYoNrkrY1oiLRVx1BHJEY1Fy7lBAH1XvPm",
	"xRM3gTXNdLExgq1ewobcggSiqpn1Wuma0LQoJ/EA6Zip/hmdQT5pDt/qIXCBQ0XLS3ke2tfWdvguW0+u",
	"BjrcK6sUokjoP9snvoOMJASD3IVIKcyuM1oUG6JD2IynpAaQ7oJAb4wgzzxQDTTjCsh/iopklOMLt9IQ",
	"hDQhUfJBYdnMYMTNMKdzVa0xBAWswL7m8cvjx+2FP37s9pwpModb63LDsWEbHY8foyrurVC6cbiOoO02",
	"x+08cemgrdJcsu7V1uYpu53c3MhDdvJta/Bg4DRnSilHuGb592YArZO5HrL2mEaGOfjhuIPMd02XsM66",
	"cd8v2KoqqD6GoRJuaDERNyAly2EnJ3cTM8G/uaHFm9DtbjyCNWSGRjOYZBglOHAsuDR9bGChGYdxZg6w",
	"DRwZChCc214XttOOl3btt8xWK8gZ1VBsSCkhAxslZ6RUFZY6JTZkIltSvsAXkBTVwrk623GQ4VfKasJk",
	"xTtD7CuK6TWfoAlDJcPU0Gzpoy2NEAbUvGzb9g/7WLulARR7GQ26tKPtaduDkibT8aj34W/wfVM//C3e",
	"miGjhxoTG/JhhLQamoHWM8SnkZW6SIy30Rw+QwyfxkpTD52Csjtx5BRef+zzC7+oyrLYHEFIsgMRCaUE",
	"hVdarAZU9quYkx9YJsVZsRDhzlMbpWHVNd7Yrr/0HNd3h7yABS8Yh8lKcEg86d/g1x/w42C1o72Ge0ZE",
	"gWivAdsPnwYSWgtoTj6EpO+7SUgy7bPftnSqb4U8lpXdDjj4TTHAcr3TrcNNeah9nRZFwiRt1Q8dLqLG",
	"wSmcSUKVEhlDQfE8V2PnfW6t2NatvYX+tyE06ggHuD1uy/YahWFZRT4UJaEkKxiq+QVXWlaZvuIUNX3R",
	"UhPOgl450K8WfumbpPXQCTWxG+qKU3QUDfq/pGPQHBJ6qG8BvHZYVYsFKN16YM0BrrhrxTipONM418oc",
	"l4k9LyVI9Nib2pYruiFzQxNakN9ACjKrdPPJsaqUJkqzonCGYDMNEfMrTjUpgCpNfmD8co3DeT8Sf2Q5",
	"6FshrwMWpsMZ1wI4KKYmaU/H7+xXDCpxOFm6ABOMtbCfvcdznRtiZNbeSFrxfx/+24v3Z5P/opPfTidf",
	"/cvJh4/P7h497vz49O6vf/1/zZ++uPvro3/759T2edhTweAO8vNX7o1+/gofYlGcSBv2P4JBZsX4JEmU",
	"sUNRixbJQ8yX4QjuUVPvp5dwxfWaG8K7oQXLDS86Gvm0r6nOgbZHrEVljY1rqfE8AvZ8Dt2DVZEEp2rx",
	"108iz7Un2OpwE295K8bAcUZ1dADdwCm42nOm3GoffPfNJTlxhKAeILG4oaPUAokXjItgbHj5mF2KA7uu",
	"+BV/BXN8Dwr+4ornVNMTe5pOKgXya1pQnsF0IcgLHxT5imp6xTvXUG8CqSioOcogleIUdJVey9XVe1os",
	"xNXVh44fQle2clPFXNSds66azE85MXKDqPTEJXGZSLilMmUL8Sk+XDQ09t4Kh5VJRGWVWD5JjBt/OhTK",
	"slTtZA9dFJVlYVAUkapy+QrMthKlRQgcM8zcxd4aGvhROKcSSW/9k7dSoMivK1q+Z1x/IJOr6vT0CwzB",
	"q1Mc/Op4oKHbTQmDH769ySja711cuJXL0al8UtJFymZydfVeAy2RQlDgWOFLsygIdmuEB/pIAByqXkCI",
	"Rd5jSyxke8f14nIvbC+f1iu9KPyEm9qMnb7XDkZR8Qdv4I7Ielrp5cRwhOSqlDkGfq98ggG6MFeO9yBQ",
	"bIEPALUUlVkykGwJ2bXLbAWrUm/Gje7e0cXdxZ7hMIU6IxccOGcGfxnlZsCqzKkTZCjftFPcKBsMgYO+",
	"g2vYXArbfTowO1iUjS5KsaL6ji7SbnTXGvKND7Ibo735zu/Kx4i6dCQYd+nJ4kWgC9+n/2hbAeAIxzpF",
	"FI08H32IoDKBCEv8PSg4YKFmvHuRfmp5jGfANbuBCRRswWZFgk3/R9eu4WE1VCkhA3bjo3rDgIqwOTGv",
	"o5m9jt2LSVK+AHOpm4tYKFqg0/40aehH6XAJVOoZUL1VX8vjNBMeOhTIbzFoGpUmY7MEWJv9ZhqVIBxu",
	"zQMP3962jXMknh7kTmXXBPmBoPrudZD09JBHhEN4Ip+dv+/DnoT3gvNPi6kTQbbfVwaHCyluzW4aAIVP",
	"3YgJXqJ7qlJ0AUOvo4apaGBKjIYFCAfZJf0k5R0xb4s1HRlj4CJs94nBS5I7gPli2AOaAVoujn5ua0J0",
	"VoU3vNh4pM4KFKiDg6glHSobdja+2A/YNBsDyWth1QPWxFp89JdU+aOfjyOOfqC0+PukktmWP+888r6j",
	"upsdz1/TbdY+tvqcGRDBTQ+fRc+nzvP58kbjvXLfjUcuxCG1d4KjFJ1DAQuLE9vY01mdn6neTQPHm/kc",
	"md4k5cgXKSMjycTNAeYh9pgQqzEng0dInYIIbLSs48DkRxEfdr7YB0ju8ktRPzbeXdHfkA4WtN74RkoW",
	"pbn1WY/VKvMsxaW3qEWeloszDkMYHxPDSW9oYTipCzytB+nkasO3Tyszm/PteNT3Jhp40NwaUTrZa5VW",
	"njlkfbHg7ZeRfhXstYaZWE9sZHTyaTVbz8yZSMYrYJx26vDazHkPFJmJNfoU4Q1nHdz3hq4fMg9Y5Aay",
	"ZgqpHPv1iY0WvP0A2S7Ip6hZIek5vVoguz5J9jBgesTpPrJ7GKXQOxJILQVmnQbcaXR26lma0lZXEqmv",
	"23HIDhvC1FKspu9wJneyB6Nd5Wkz193f6nSH/cnR/Fn9LEn+ukq5++RltJ1Lm2txn7SMbXJoALEFq2/b",
	"QmwSrU3HpSZeI6ylWJJh9F1jVxdtCgpATcCkIVdPrlNm6aur9wpQZrjw3SI9J+4e5ZtHkTechAVTGmrj",
	"gndy+fy2H1QnmseWmPevTpdybtb3ToggaFhzLHZsLPOzrwBd1+dMKj1By0xyCabRtwo1ad+apmlBuOlv",
	"x5Q19ewtByNE17CZ5Kyo0qTsQPr+lYHox3BzqWqGFyXj1ttohqnwkw66e9gmER7r2L0VQa8tgl7Tz4Gf",
	"YQfLNDUwSUN5zen/JEesxQu3cZYELaeIqbuhvSjdwmujWPouo42E6MjtYrrN5tM5l7kfe6c3lo/o7xMi",
	"7EjJtUQZEdMBhGKxgNxnenNBoTbrlcunVwi+qHMJmt+3pA+cEpvFD5Pwbcnf59zToc85vVFOBKtiJKGP",
	"HzMIeR1dh7kHcZIFcJu5ZbR/vZEiibjYMR5bRJrRz8vbO27zSdfhy5a7cO3Ta/cwbDZuTwE0d88qBX59",
	"2w9td7sc6sZ9TseNFLHbDxgOiBTHtIoEmA7R9HBuWpYsX7cMf3bU6QEkMVDc62aCb+EM2ZIbbAd+mo7F",
	"O2r1PDC3I7Z3xo4TfOafmEem9Wd2HrnmbNDMZRvIK4nWpIa3cDeffnhoDlz79z9faCHpApxFcGJButcQ",
	"uJx90BClpFdEM+sgnbP5HGJLmDrEitMArmPvyAcQdg8Jds1l4W25lT67RLaDtuoV7EZomp4SlNLnc3HZ",
	"tUf6h0ekWwuXTbRxBxgVkwkFvofN5GdaVOYlxKSqfVOdgbB5re9BEzer72GDI+90+TSA7dgVVMW9A6TQ",
	"lHUlfFJRlvAHqlF9Ad/AjS3cY6fO0rt0pK1xpTT6j0Z9QzXqSTSX8umOTe0iYyAdslcXaa8Tc7aguS1t",
	"Qt+1RSzfLftET5B4KobeG4dcciHTxk7vMqCFJ3xc7OhuPLqfv0fqnnQj7tiJt+FqTu4CemNa+3/D6WvP",
	"DaFlKcUNLSbOT6ZP6JDixgkd2Ny71Xzm91X6VFx+c/b6rQP/bjzKCqByElQdvavCduWfZlW2BMf2a8im",
	"Y3e6XasKizY/pMyOPWluMfV6S5vWqXVT+01FB9V51szTnuI7+aZz8bJL3OLqBWXw9Kot0tbRq+ncRW8o",
	"K7zh10M7VMtulzusulKST8QD3NtJLPL+u/dYvXECV1fvbzxma3uKdZQKKfETvnTqQE/nDq9Jn9Wa1ndw",
	"SFznG8xkmn53cZfnFBmjczijR5cDvxWycVG5qMakw9qnExDNY8LiMW2Uv3RW+I5YOCVWhPx18avhDY8f",
	"xwf/8eMx+bVwHyIA8feZ+x3fUY8fJw3DSVWfYVmoyeN0BY9CXETvRnxeNQSH22HiwtnNKsjIop8MA4Va",
	"zzOP7luHvVvJHD5z90sOBZifpkNUFfGmW3THwAw5QRd9UYnB+Xlly3kqIng7Bh+jZA1p4dXjKnhYO3v3",
	"CPFqhXbniSpYlnb64TNlWBK3Lr2mMcHGg23IZo6K9fiV84pFo5tm6iCTZ2sh0axJhKtkJuAavzPhWEDF",
	"2T8qiMr64k3cupz9UwhH7QjYaf2iG7hdNXh0SMHf+5sIvVZtm8Joq8n1VTADekSk6kztGe8Qz9hh/lti",
	"FRxF+esTA9uWznV4J2VtfedtLwLtzMCefTqLa/8DyZXDtJv5ashOMzWZS/EbpGUHNBImUnd46zZDBfxv",
	"wFM+qm1GFjwH6oLV9ey7CGS4bqGPVO6tS/CLDlXzDrnC03xiv43eU2kQ7Xe/2kCl04u7Teh7qMaOJ81A",
	"mh5mhgc2cgvHWj7e3Y1ye0JtXotG5Fn6nMeBoid2/PqcO5g7wbUFvZ3RVKEj8140MEXb33DM04L4zn6D",
	"VEjNYGcnUSxDaMtssr8SZG096qZKPvDtZ6cd/OqrH3lIcfHzbmx9VQolEsNU/JZy9CPEfpYDut4KrB+G",
	"6XUrJCb4VGkfwhwytkoqw6+u3udZ1/MrZwtmS4pXCgida5fn0Q1ki8pbKnLVvEMuEoea8zk5Hddn1u9G",
	"zm6YYrMCsMUT22JGFV7QwScidDHLA66XCps/HdB8WfFcQq6XyiJWCRLe5yh6Bk/YGehbAE5Osd2Tr8hD",
	"dBhW7AYepS8YJ6yNXjz5arytcjZiHIvEb2PyOXJ5H8iQpmz0qrZjGLbqRk1HJswlwG/Qf59sOV+265DT",
	"hS3dFbT7dK0opwYhKZhWO2CyfXF/0ZWjhRdurTOgtBQbwnR6ftDUcKyeaHLDEC0YJBOrFdMr5ymqxMpQ",
	"WF2G3E7qh8P6er4MmofLf0QX7DLxxv8dnlt01RPhiF71P6K9PUbrmFCbsbVgdfyFr1BLzn1maqwLF8rB",
	"WdyYuczSUV7FcIw5KSXjGrVGlZ5P/mKe75JmhiFO+8CdzL58lqiv1ixBxPcD/LPjXYICeZNGvewhey/l",
	"uL7kIRd8sjIcJX9Up3SITmWvr3jav7fP7bhn6HtL12bcSS8BVg0CpBE3vxcp8i0D3pM4w3r2otC9V/bZ",
	"abWSaYKhldmhn969dpLISshUpYuaATipRIKWDG4wvjS9SWbMe+6FLAbtwn2g/32927xYGolu/nQnHwuR",
	"VTnxTgtplYyk//MPdX58NG7buN2W9lLIhJ7WaRw/s1vqfvrCtg3dugPitx7MDUYbjtLFSk+4h43nCH1+",
	"D3+vNkh2zxuq0ie/Emne8SjrP36MQD9+PHai8q9Pm58te3/8eLjLbFpfaH5NoOawu6advdL0TW311yKh",
	"vfNVPIPfmEtVktCwJu8yc6XO3Bhj0iyV+PnljuPEK+7thpw+QB41+LmNm9+Zv+Jm1hEw/fyhWT02ST55",
	"+B7FUFDytVgPJaLWteXp6Q+Aoh6UDNQK4ko61XGTnhI73XwisjWjzqAQ5qUaF8Aa7LXyJ9oFg5rxlr2o",
	"WJH/XFuhWzeTpDxbJp3KZ6bjL/YZEDWINBjZknIORbK3fS3/4l/ViXf/30XPsCvG05/ahZgt7C1Ia7Ca",
	"QPgp/fgGV0wXZoIYRc2EXCHFSbEQOcF56solNWvsVjRPVZJNxPjjsKtKO69kTJ7gCorMWYFutGl7OLac",
	"SKp7uCqW/fclrsw4WIVfWbWEHR0koWyF17aiq7IAPIQ3IOkCuwoOre6YsQ1HjsqSEFWaT9gSk78IoivJ",
	"iZjPo2UA10xCsRmTkiplBzk1y4I1zj168eT09HSYkRHxNWDtFq9+4W/qxT05wSb2i6v8ZQsm7AX+IdDf",
	"1VS3z+Z3icuVX/1HBUqnWCx+sAHZaCE297otvRrKBE/Jd5ifzBB6o0QAKkV9huVmTtCqLATNx5gU+vKb",
	"s9fEzmr7SEDUYenXBWoAm0ckaeQZniPV51/ryV01fJztqXPMqpWehKKsqUyKpkVdS5a1vJ9QNxhjZ0pe",
	"WbVscOyxkxBMLS5XkEc1YK0aAInD/Edrmi1R3zkdbVUp91QDGl7C2HPA2lwUxb2GglnIwc0yXBVjW8R4",
	"TIRegrxlCjDvBNxAM2FjyHbqFPI+gWNztbLi3BLOdA/pNZTH2ncXPHBW9PX+FUnIWvtwb9tfnckDi5zv",
	"W+z5Anul43ZalaNbfg+2ZMbaF92Ykh+csSOjXHCWYbGJlAiOqRiHmVUH1OVI2zvVyJ3lxDFM1qsOAeoO",
	"i70VrD3LdIjrOjVEX81+W8Kxf2pYuyKAC9DK8UDIx758vDPQMa7AFUAz9BVzVCETrl/JsJjgQnJEl/Tx",
	"CLOp9ehavzXffnS6ecwZc8046twcUt1L0BrYCsXQzs4J02QhQLnVNuPC1HvTZ3q55gjCh+lrsWDZBVvg",
	"GNYV0SDFegF3hzrzPsHOB9e0fWnautoF4eeGS52d1K/7Q5KFqLD/qZrrvehP+X55R5oIuWH8eLQtxLjV",
	"1R/vZUOGcIOef1Difd4hm1C+vjnKN+bJaukNWxAbuZtMG8x4AozXjHuDbzoPVpa8S3Bj8DT39FOZpNo+",
	"OgZxvEugRU84DAbVW4+B+w7VrsRgUIJr9HP0b2Ndeb+HrYQG9euC8g3xh8JQdySUvKRFcIZP1NFH6cwJ",
	"Y9ZZuFVZP8VWDFuf+NDcBrp2BoKG7lgNZd97qi/b6KzKF6AnNM9Teee+xq8Ev/qAQlhDVoUiYCHOtJmu",
	"vUttbqJMcFWttszlG9xzupwpqhSsZkXC9fZV+Ah52GFMRDXb4L+pClj9O+Oc3veO/vYe7vl+NQq60ewp",
	"6dnQ9ESxxWQ4JvBOuT866qkPI/S6/1Ep3Qd+/yHiultcLt6jFH/7xlwccZrujo+/vVpCFm30pxf43ecD",
	"C5lcm1wJr7JOnTf0yMDNS2xZC3jfMAn4DS16Mi7EVht7v1pLRl/ehaw3rQjVLnudpqTmCUNUGP35v6wH",
	"dssy1DVv9vlYWxfrT2k8cfjYivR+S+P3Dbui9XqrGUqvPfEwk19NBPva/Fwphq6+lBaFyAZzBjfMmenU",
	"n6pXrFYu833CK+9mJfL4LMTeXABpxmYdlhOhFfiwTX7Dp1Xyi7xNj9bQjwSiGZq1DNHoljC2gZkePA+M",
	"nTqeKFLZOsySb1mBxaH+/eLNj6P+jYx2oLulLnV2UoXdtzEhUq1NHgvRwMcWHiB4kdZ/qx6VOuaGSp8G",
	"V504+eFbqyAcApLNk7RP69dDB+8QwELYqlCpuhnd7DSjejs88iNqqLfXcpSYOlJU0a62lHj7WKVn3YSE",
	"QqSDCpM2ZKQhxZ1SdYTcS8FrYO1F4/LR2eJKnbpMHQb6aohw2MHH3Xh0nu8lPqVqUY3sKCkG+5otlvrr",
	"QmTXfwOag7T1RFLPSVtNZAXmGaqWrMT3TykUq+sBF2Ywl8h7icNNh4bmXC7BZYXxSQI6Y3kH6hvINNaH",
	"rt1AJcBwP4cyvUQDgTcoYpPfwRVEAuRQ6uVWYck6d5d6WZcNBRd5xhSZgTNd3AAfEzaFaTtYLa+TQpEC",
	"6NwrYaUQekBd3RC2hGiMgU7RV6dG83YxsJPzLUppaEvpTocXYTkLMQE20PKWqjpzVCuNwuBw7fkcMkx4",
	"vzX93n8sgUf52MZedYewzKNsfCyEC2LJhqNqtGtYtyXC2wpqVJPqU0LalxDjGjYPFGnQULIicIiwPSQD",
	"PCLH2nF9UYE+04ZzjGQq0BMiyPvBuwT8dY2lQ4oARNkpDwTD07i5nuqMlYdB4yWaA8AwXaf3Ktpfp8ND",
	"wbQvu1+3unr/S/kVFrNXzqmUhnTzsT6JnHfLMd+6dPWYaDFYC33ielD+N5+g1c5SsGtXoQYRZm2zt1Tm",
	"vsVR0uTZe5OlgZ6HmVkdGNX18tnXL8dGKGaFMALQpC8wtBmpFFx4Hyjra10nLUOo5yAl5MEmWAgFEy18",
	"mNUeyT9d+OQW7Fkv84Pw1vLo3yNk2K6ot4bCu7qQBJaDpFgzgTrn8xgrRMKKGuhlVNwhrQbdtUMv7Xef",
	"U8SX99uuXu3DezgXuytk+9A7pjqYj0/XnDjhYG/u1UhEcoBmlnEOcuKNuO3SDryZJhPzKudVZkWV+GwG",
	"7fXgtGNbuFlSqZl1V9l6QkVZOa5hc2LVPr7quN/xGGgrQ1rQo4TSLaI4qq5apeBeHAW83zd9ZylEMemx",
	"DJ5361G0D8M1y64BE7OGyBQjBT9oHhszCXmIBqngM3K73PhqC2UJHPJHU0LOuI0O9O4jzQqkrcn5A71t",
	"/jXOmle2wozTQE+veDrMCiu9yHtyPz/MFp7Xx5sUGH55z/ntIAfMrte8z0fuFkvCNOsET4eqN7r+HS0R",
	"KiI/C0VKgLqwhuCXyBIS7yiC2VmiNELoH0CJMyATVYiUF/4hGWTMUGlMxZMhQBr4gOdqDYUbPIkA52S3",
	"Iyur++zzjoo5kVD7ZhyagNXlNLVMXPWpRtozh1manHEuJMQzop+pTdQcItswzzH+Z8a0pHJzSJrUJqpS",
	"aqheLO/0lgyOkvVCamfJLg6LQtxOkK1NQnWllDrAtFPNa9vXKa37maM+g8jtkionIm7IkuYkE1JCFvdI",
	"h3hbqFZCwqQQ6IWZcuyYa/NIWGFcJyeFWBBRZiIHWwgtTUF9c1WcU5S9IHJlS6LA0g6mDLB9IjoeOKW5",
	"fa15doLy2s5CG37zL00fm76iTn9nFz2xLgI98QWgXLo7hyHbuAsvEo7NyNRWyqZF5DlbI92ATB35OdGy",
	"gjFxLdpV+N3BpxLIiillQQm0dMuKArNHsHXk0BD8gdKo7ZGdz9EP+oahw1szk4gVqUtzO4b0KzEPuIgz",
	"shG9lKJaLKP6AAFO/3SXlXvYx6P8pCr0ScQQUTPFM7ISSrtnsR2pXnLtAvowE1xLURRNRZ6V8xfO6PsD",
	"XZ9lmX4txPWMZteP8BHOhQ4rzcc+pULbd7eeSbZyMA57Keg1nyB5qN1p1m079Gp19DyYd7a4X8fwsEuT",
	"H4H5YTdz3W3XOOsurL2uJp9Nv4XOOKFarFiWPm5/Lu/XXp/VFPdKZlq0VYhtFhpshnwgvseCOxNyzy6a",
	"gdNkGdUz4niEc+tATmT+i2J8e1wyB8eDeu7QLt9xAtYk6xUDWwAgpDYRgq6kLV0cC2mB4YiFTZyCTilt",
	"QAdeOOj7dz/YzAhHB0rDvYDqeCMHAB9aDcbYZsS0ns0zsfbfH9UpMw8C/m47lTeYR59T5UVNWtK6VfpE",
	"Vj0cIV2AYKsH4iUmwZgN9UMMpegHXv4RAP2eiQ0YBvkn7gvGnLIC8kmqSvF50IGNo+e6i7GMRvf1HC0n",
	"z2jlKwGbsSsJLrGSlf5l05xYUkNKIjTvasR5DmuwMVq/gRS2ju84MmdBYcv8tjQKopwUcAMNh02X7alC",
	"KZTdgO+rQmeSA5Ro8W0r2lKeiHGVwJb2xa19EvmyDcFuUh1jEWt3iuzQtSQ1Q2s+scdEDT1KBqIblle0",
	"gT+1r8jR1CWao5xAVef5MPFPzKHT/GRHeOcHOPP9U6KMx8SHYXxobxaURt02BrTTM7lSfaeepx2T41Rm",
	"wVCEs+XBrm1JvOYbqqS3vF+r2SX5+iU2cJ+Y4BFiv1lDhlKNewpB7h5DPZYTlwMJqZ0D5PbBYLoktPlL",
	"4ISLqObxLVXhFVNndfU/2ImxEePuoX2Ajb72H77/zhIcjKhWssV0idJA1vfT8f8uJ3HrQewdL0UjClwo",
	"7xbVmKdu9+zABqIqcsLNfhrZH2sEu1vMcfExmVV+oKIQt7aIcfxEfQXenmupz5uYnFjOwrXs/aTHLuFw",
	"WwvCogiRFd0QIfEf8yD9R0ULNt8gn7Hg+25ELakhIWdAtl4Uzu/aTLxdvBp7wLwiRvip7LrZ0DGj4TZm",
	"lAhoc5H7sm2CrOg1xNuADiKWf2baME5VzVCpYa7s1nZ2seAW79MzrWgeKwEw0eymwR18wnPT+3/VYavx",
	"VD7/Y1nQzJesdsXnmnwGq9p74tJLWG0Pc+7yNU8CoVJ+TbTSp8nID9Cm7sm6UjE/fcWxGmB3SoB36oLd",
	"axkDlcKtGkdbAsQHLeXYu3CcGM7OkuJSv7sWF1c+/jy7k8wQ3beMIeD/gXal4V7RiWxLV1CP12OLpX+G",
	"XWgk4knAatXgM7GeSJirXY40Vg8+E+saYBV0t4xnEqiyfkfnb9yztU6AzLh5Rluv3WBWDaPkMGe8ZrWM",
	"l5VOvIIwDzLfRAiLrQmI1h7bXJ+MYUTRG1q8uQEpWd63ceb02NLAcZEeb0FxfRMKkHAjdwdgqn4BYjx1",
	"rZ+Pm5nr3xYYtL6zSlOeU5nHzRknGUgjNZBbulGHm6qC1WGXsYpGslAzW0hktkLStoAUG2dtvqchKQBI",
	"j2hRGmAJQifthBXIKoa06DH8dGH4U1iCVnQ9KcQCo357DoTLc42mQ/uAFByV6Fa6G7ZuP49iv8H2abAU",
	"iWNEWuCsQ6bYfu7f4FbiI/QnzvTWk281nO0wbOvpbA+mRypf1OEZlli65zEVOe8SM8XR815U9WlKPO1B",
	"tIlJl+iOVr1nF9G/wqVdiFXow4tVNl04UvH5Vq8wQX2D2hKAAaqOK6CZ8xDrKuI6igqLlLHLbrCnns5q",
	"9/291AMeKlKUO+vNaYODjhlnnwqf2/MZTEpRTrIhvq22WlHujAwO0iaMPfQRmRB61h38blSo39XIidYo",
	"5LVvkdPeQmK7bGVltk1l0Kdk6uHoTQOGmCMvwyNsVWsYaxVUMWP/OPfG7qYSLTAJQomErJKoZL6lm92F",
	"H3uyz1/87ez5k6e/PH3+JTENSM4WoOqaBq3CibVrIuNtrdHndUbsLE+nN8FnC7GI89ZLH/YWNsWdNctt",
	"VZ2MuFM2ch/tdOICSAXndkvkHbRXOE4dFvHH2q7UIo++YykUfPo9k6Io0jVlglyVML+kdisywJgXSAlS",
	"MaUNI2zaT5munbLVEpWLmDX8xuaGEjwDr312VMB0jy9XaiF9Pr3IzzAXg7M5EViXheNV1k60bV3unWb1",
	"eyg0orvNDEgpSifaszlJQYQxW7KCoFd3alPUp0duuoHZWofdFCE65/c06Z1x9xIWc7Kd2zdLces0pzeb",
	"mBAv/KE8gDT7rBv9eUYO4SS1YeAPwz8SiVOOxjXCcj8Fr0i+D7ZEhZ91vCZC0pBBoHUTZCTIAwHoiYdu",
	"BK1GQXZRbnJpbQxojfDm57b48UNtlt4ZmYKQ+A47wItjmet2IZjCgfM7J/b+ISAlWsqHPkpoLH9XeLRn",
	"veEiibbIKU20BmXZkuiKhVFAvHoZ4sx7XiWdcHQphCbmZVoUiTB2q8fBMxUTjnkSyBtafH6u8S2TSp8h",
	"PiB/1x+4FYctx0i2qFRHT8j5mg4CKwpR/ixQ8bcYW/8fYHY2eTu6WZzhv3MHokqIFtbbex4s4MDJLY5p",
	"HbuefElmrtxPKSFjqu1QcOtFmhBvC5LNnX8trHU79vfeZYJ+Fvoex2Hu/YHIj5GRLXgOOJjro/47M6ce",
	"DpA8LSlS7RBKAn8pXhcXVd9x7dyzNMxhqZyixI17pnLqlosfujxcB15elYLuOgff+g3cJi78em1Dc5UN",
	"rjBzdfVez4YkFEtXgzHdMcfZUcrC3L8ozGdJcGZR6cZwkCQJqxa5d2WvaflLRnkamrtoxP2eAvJLi34z",
	"Gj4K5hW344UCqBgr7tm6mI+DF4PgptsLcsUfE7Wk/m3h/nz6/MvReAS8WpnF199H45H7+iH1UsvXybjS",
	"OpFOx0fUVRN4oEhJN0OC2Xemzknit84U9PlFGqXZLP2m+5vZM3y4ugCEc46sHtmLvUFd/pz/SQC0lRha",
	"hzWcGEuSdXqgsBW7MgX93JcW36Z+76n20eK+FSt2Osk1CrHcjUcLm6QMq5P84mrVfd5t9xD05At0S79P",
	"GjCLmMRaG5NHU0VJ3QYUZHHdEhUyMPI6qyTTmwuDf692Z79cp5JBfRfSM7mcX8EC72RfLa6Bex+zOplT",
	"pbx0/Z2gBUqf1jGAG5lTFFPyja0Q4q7Fvz6Y/St88Zdn+ekXT/519pfT56cZPHv+1ekp/eoZffLVF0/g",
	"6V+ePzuFJ/Mvv5o9zZ8+ezp79vTZl8+/yr549mT27Muv/vWBoXQDsgXUV/55Mfo/k7NiISZnb88nlwbY",
	"Gie0ZN+D2RvUsM0xQSEiNcMrFlaUFaMX/qf/7S/KaSZW9fD+15GrBzlaal2qFycnt7e307jLyQJzoEy0",
	"qLLliZ8Hc1k23itvz0NckPX9wx2tbU64qSG/n/n27puLS3L29nxaE8zoxeh0ejp9gvkUS+C0ZKMXoy/w",
	"Jzw9S9z3E8yifaJcMZ6TOnQ0ae1/h2Ey/kkvF5CThyEI8F+Cv4d65GMJ5y4L5d+VJcawivMcicvVTR9h",
	"3Vd0AEWwnp6e+r1w75pIvDzBiLMXH0eWf6TS4XaQelkDnISsrjrdXfRP/JqLW04w5a89QNVqReXGrqCB",
	"jWhw3Ca6UGiak+wGMzOa3m2cl6UrgdSHcqyq2TzlvjMSSKiPY06YLZvjChmpFMq75Zfuif2tKaA7kyV2",
	"Bxu9NTD7NGchbbK7CR3O0NPEIiycEaus7CB6PCqrBDq/wWA+tQ1n46hkj4VGFHnAeAejb6v/Jhg1pLsI",
	"6X/NX0ugBYpG5o+VIdTMf5JA8437v7qliwXIqVun+enm6YnXOZx8dPmk7rZ9O4m9UE8+NpJy5Tt6ej/K",
	"XU1OPro8VTsGjM0iJ86/PeowENBtzU5mWG9zaFOIV9e/FKR5dfIRdXO9v584OT39EdWn9oY98Y+PnpY2",
	"h1D6YwOFH/XaLGT7cKZNNF5GdbasypOP+B8k2zt72gtIJcizBb0oqZuPCdOEzoTUyv5quIEvPs9U1LJz",
	"5M9Mr5cWArxNvVPi6MX7bswpDkT8SCiimPu3liAaM9VCIhphI6YQROBG+1oQfn86+erDxyfjJ6d3/2QE",
	"Xffn8y/uBkbsvAzjkosgxQ5s+OGeHK+js60XaTcpMLDuI8PRQn9Moduq1kAkIGNHPenW8Im0zKbLsyPy",
	"+GZ1gQR//5rmxGdtwbmffL65z7mNSzGCqhWo78aj559z9efckDwtvEh2oPB2Zg9/zBSI2+yU8DYeccGj",
	"fLh8YcUMkcqc08NvlKYH8JsL0+t/+E2jYcc3AGN/rbXF1QKMVCz2MgmFcMFnDveaQJrfUJ75ANA6Igv3",
	"y0rejjCC236lYF4VPitSWThFlXnc+olUVZaG48ypCpTlwsDMg9kmdQlDk4pngluHS4y4824jmJwFXU/U",
	"NSsbXdjcUBXmgPPRn1O/6f+oQG7qXV8x8/LtvJmGpWTp//YpGb/F/hEYf3OgIzP+p3sy3z//iv97X3XP",
	"Tv/y+SDwGdgu2QpEpf+sV+2FvffuddU6yd/W5jrRa36CoSQnHxuPHPe588hp/l53j1tgSRn/8BDzuUKF",
	"zLbPJx/tv9FEsC5BshVwjWnL3a/2vjkxN0Kx6f684Vnyx+46Ggn5e34+8XrY1Nu62fJj48/me1EtK52L",
	"W1sZJinl4KVLC7KinC5supGgujS3pxugrhVA3pThenNZBgjFEr+i0rVu2YbNudQjwWcI78HgObpgHCdA",
	"Nw6chc5NVxpd+64Sd1fzeOEg+1Hk0JWoUteng7FxhYajcJqIsPlwHJ1mxHjv9jso6G5iPay6ZGQ+Vqr9",
	"98ktZdrIXS79PmK021kDLU5cidfWr3XdtM4XLAYX/RjnT0n+ekKb56KpdzFb1texo5RJfXV6h55GPnDP",
	"f65NPrEJBcklGE/efzC7rkDeeEqqLQIvTk4wDnwplD5B+bVpLYg/fggb/dGTn99w8209EZItGKfFxKnW",
	"6hLWo6fT09Hd/w8AAP//E+Why2YTAQA=",
}

// GetSwagger returns the content of the embedded swagger specification file
// or error if failed to decode
func decodeSpec() ([]byte, error) {
	zipped, err := base64.StdEncoding.DecodeString(strings.Join(swaggerSpec, ""))
	if err != nil {
		return nil, fmt.Errorf("error base64 decoding spec: %w", err)
	}
	zr, err := gzip.NewReader(bytes.NewReader(zipped))
	if err != nil {
		return nil, fmt.Errorf("error decompressing spec: %w", err)
	}
	var buf bytes.Buffer
	_, err = buf.ReadFrom(zr)
	if err != nil {
		return nil, fmt.Errorf("error decompressing spec: %w", err)
	}

	return buf.Bytes(), nil
}

var rawSpec = decodeSpecCached()

// a naive cached of a decoded swagger spec
func decodeSpecCached() func() ([]byte, error) {
	data, err := decodeSpec()
	return func() ([]byte, error) {
		return data, err
	}
}

// Constructs a synthetic filesystem for resolving external references when loading openapi specifications.
func PathToRawSpec(pathToFile string) map[string]func() ([]byte, error) {
	res := make(map[string]func() ([]byte, error))
	if len(pathToFile) > 0 {
		res[pathToFile] = rawSpec
	}

	return res
}

// GetSwagger returns the Swagger specification corresponding to the generated code
// in this file. The external references of Swagger specification are resolved.
// The logic of resolving external references is tightly connected to "import-mapping" feature.
// Externally referenced files must be embedded in the corresponding golang packages.
// Urls can be supported but this task was out of the scope.
func GetSwagger() (swagger *openapi3.T, err error) {
	resolvePath := PathToRawSpec("")

	loader := openapi3.NewLoader()
	loader.IsExternalRefsAllowed = true
	loader.ReadFromURIFunc = func(loader *openapi3.Loader, url *url.URL) ([]byte, error) {
		pathToFile := url.String()
		pathToFile = path.Clean(pathToFile)
		getSpec, ok := resolvePath[pathToFile]
		if !ok {
			err1 := fmt.Errorf("path not found: %s", pathToFile)
			return nil, err1
		}
		return getSpec()
	}
	var specData []byte
	specData, err = rawSpec()
	if err != nil {
		return
	}
	swagger, err = loader.LoadFromData(specData)
	if err != nil {
		return
	}
	return
}
