package agreement

// Code generated by github.com/algorand/msgp DO NOT EDIT.

import (
	"sort"

	"github.com/algorand/msgp/msgp"

	"github.com/algorand/go-algorand/config/bounds"
	"github.com/algorand/go-algorand/crypto"
	"github.com/algorand/go-algorand/data/basics"
	"github.com/algorand/go-algorand/data/bookkeeping"
	"github.com/algorand/go-algorand/data/committee"
	"github.com/algorand/go-algorand/protocol"
)

// The following msgp objects are implemented in this file:
// Certificate
//      |-----> (*) MarshalMsg
//      |-----> (*) CanMarshalMsg
//      |-----> (*) UnmarshalMsg
//      |-----> (*) UnmarshalMsgWithState
//      |-----> (*) CanUnmarshalMsg
//      |-----> (*) Msgsize
//      |-----> (*) MsgIsZero
//      |-----> CertificateMaxSize()
//
// ConsensusVersionView
//           |-----> (*) MarshalMsg
//           |-----> (*) CanMarshalMsg
//           |-----> (*) UnmarshalMsg
//           |-----> (*) UnmarshalMsgWithState
//           |-----> (*) CanUnmarshalMsg
//           |-----> (*) Msgsize
//           |-----> (*) MsgIsZero
//           |-----> ConsensusVersionViewMaxSize()
//
// Deadline
//     |-----> (*) MarshalMsg
//     |-----> (*) CanMarshalMsg
//     |-----> (*) UnmarshalMsg
//     |-----> (*) UnmarshalMsgWithState
//     |-----> (*) CanUnmarshalMsg
//     |-----> (*) Msgsize
//     |-----> (*) MsgIsZero
//     |-----> DeadlineMaxSize()
//
// LateCredentialTrackingEffect
//               |-----> MarshalMsg
//               |-----> CanMarshalMsg
//               |-----> (*) UnmarshalMsg
//               |-----> (*) UnmarshalMsgWithState
//               |-----> (*) CanUnmarshalMsg
//               |-----> Msgsize
//               |-----> MsgIsZero
//               |-----> LateCredentialTrackingEffectMaxSize()
//
// TimeoutType
//      |-----> MarshalMsg
//      |-----> CanMarshalMsg
//      |-----> (*) UnmarshalMsg
//      |-----> (*) UnmarshalMsgWithState
//      |-----> (*) CanUnmarshalMsg
//      |-----> Msgsize
//      |-----> MsgIsZero
//      |-----> TimeoutTypeMaxSize()
//
// actionType
//      |-----> MarshalMsg
//      |-----> CanMarshalMsg
//      |-----> (*) UnmarshalMsg
//      |-----> (*) UnmarshalMsgWithState
//      |-----> (*) CanUnmarshalMsg
//      |-----> Msgsize
//      |-----> MsgIsZero
//      |-----> ActionTypeMaxSize()
//
// blockAssembler
//        |-----> (*) MarshalMsg
//        |-----> (*) CanMarshalMsg
//        |-----> (*) UnmarshalMsg
//        |-----> (*) UnmarshalMsgWithState
//        |-----> (*) CanUnmarshalMsg
//        |-----> (*) Msgsize
//        |-----> (*) MsgIsZero
//        |-----> BlockAssemblerMaxSize()
//
// bundle
//    |-----> (*) MarshalMsg
//    |-----> (*) CanMarshalMsg
//    |-----> (*) UnmarshalMsg
//    |-----> (*) UnmarshalMsgWithState
//    |-----> (*) CanUnmarshalMsg
//    |-----> (*) Msgsize
//    |-----> (*) MsgIsZero
//    |-----> BundleMaxSize()
//
// compoundMessage
//        |-----> (*) MarshalMsg
//        |-----> (*) CanMarshalMsg
//        |-----> (*) UnmarshalMsg
//        |-----> (*) UnmarshalMsgWithState
//        |-----> (*) CanUnmarshalMsg
//        |-----> (*) Msgsize
//        |-----> (*) MsgIsZero
//        |-----> CompoundMessageMaxSize()
//
// diskState
//     |-----> (*) MarshalMsg
//     |-----> (*) CanMarshalMsg
//     |-----> (*) UnmarshalMsg
//     |-----> (*) UnmarshalMsgWithState
//     |-----> (*) CanUnmarshalMsg
//     |-----> (*) Msgsize
//     |-----> (*) MsgIsZero
//     |-----> DiskStateMaxSize()
//
// equivocationVote
//         |-----> (*) MarshalMsg
//         |-----> (*) CanMarshalMsg
//         |-----> (*) UnmarshalMsg
//         |-----> (*) UnmarshalMsgWithState
//         |-----> (*) CanUnmarshalMsg
//         |-----> (*) Msgsize
//         |-----> (*) MsgIsZero
//         |-----> EquivocationVoteMaxSize()
//
// equivocationVoteAuthenticator
//               |-----> (*) MarshalMsg
//               |-----> (*) CanMarshalMsg
//               |-----> (*) UnmarshalMsg
//               |-----> (*) UnmarshalMsgWithState
//               |-----> (*) CanUnmarshalMsg
//               |-----> (*) Msgsize
//               |-----> (*) MsgIsZero
//               |-----> EquivocationVoteAuthenticatorMaxSize()
//
// eventType
//     |-----> MarshalMsg
//     |-----> CanMarshalMsg
//     |-----> (*) UnmarshalMsg
//     |-----> (*) UnmarshalMsgWithState
//     |-----> (*) CanUnmarshalMsg
//     |-----> Msgsize
//     |-----> MsgIsZero
//     |-----> EventTypeMaxSize()
//
// freshnessData
//       |-----> (*) MarshalMsg
//       |-----> (*) CanMarshalMsg
//       |-----> (*) UnmarshalMsg
//       |-----> (*) UnmarshalMsgWithState
//       |-----> (*) CanUnmarshalMsg
//       |-----> (*) Msgsize
//       |-----> (*) MsgIsZero
//       |-----> FreshnessDataMaxSize()
//
// message
//    |-----> (*) MarshalMsg
//    |-----> (*) CanMarshalMsg
//    |-----> (*) UnmarshalMsg
//    |-----> (*) UnmarshalMsgWithState
//    |-----> (*) CanUnmarshalMsg
//    |-----> (*) Msgsize
//    |-----> (*) MsgIsZero
//    |-----> MessageMaxSize()
//
// messageEvent
//       |-----> (*) MarshalMsg
//       |-----> (*) CanMarshalMsg
//       |-----> (*) UnmarshalMsg
//       |-----> (*) UnmarshalMsgWithState
//       |-----> (*) CanUnmarshalMsg
//       |-----> (*) Msgsize
//       |-----> (*) MsgIsZero
//       |-----> MessageEventMaxSize()
//
// nextThresholdStatusEvent
//             |-----> (*) MarshalMsg
//             |-----> (*) CanMarshalMsg
//             |-----> (*) UnmarshalMsg
//             |-----> (*) UnmarshalMsgWithState
//             |-----> (*) CanUnmarshalMsg
//             |-----> (*) Msgsize
//             |-----> (*) MsgIsZero
//             |-----> NextThresholdStatusEventMaxSize()
//
// period
//    |-----> MarshalMsg
//    |-----> CanMarshalMsg
//    |-----> (*) UnmarshalMsg
//    |-----> (*) UnmarshalMsgWithState
//    |-----> (*) CanUnmarshalMsg
//    |-----> Msgsize
//    |-----> MsgIsZero
//    |-----> PeriodMaxSize()
//
// periodRouter
//       |-----> (*) MarshalMsg
//       |-----> (*) CanMarshalMsg
//       |-----> (*) UnmarshalMsg
//       |-----> (*) UnmarshalMsgWithState
//       |-----> (*) CanUnmarshalMsg
//       |-----> (*) Msgsize
//       |-----> (*) MsgIsZero
//       |-----> PeriodRouterMaxSize()
//
// player
//    |-----> (*) MarshalMsg
//    |-----> (*) CanMarshalMsg
//    |-----> (*) UnmarshalMsg
//    |-----> (*) UnmarshalMsgWithState
//    |-----> (*) CanUnmarshalMsg
//    |-----> (*) Msgsize
//    |-----> (*) MsgIsZero
//    |-----> PlayerMaxSize()
//
// proposal
//     |-----> (*) MarshalMsg
//     |-----> (*) CanMarshalMsg
//     |-----> (*) UnmarshalMsg
//     |-----> (*) UnmarshalMsgWithState
//     |-----> (*) CanUnmarshalMsg
//     |-----> (*) Msgsize
//     |-----> (*) MsgIsZero
//     |-----> ProposalMaxSize()
//
// proposalManager
//        |-----> (*) MarshalMsg
//        |-----> (*) CanMarshalMsg
//        |-----> (*) UnmarshalMsg
//        |-----> (*) UnmarshalMsgWithState
//        |-----> (*) CanUnmarshalMsg
//        |-----> (*) Msgsize
//        |-----> (*) MsgIsZero
//        |-----> ProposalManagerMaxSize()
//
// proposalSeeker
//        |-----> (*) MarshalMsg
//        |-----> (*) CanMarshalMsg
//        |-----> (*) UnmarshalMsg
//        |-----> (*) UnmarshalMsgWithState
//        |-----> (*) CanUnmarshalMsg
//        |-----> (*) Msgsize
//        |-----> (*) MsgIsZero
//        |-----> ProposalSeekerMaxSize()
//
// proposalStore
//       |-----> (*) MarshalMsg
//       |-----> (*) CanMarshalMsg
//       |-----> (*) UnmarshalMsg
//       |-----> (*) UnmarshalMsgWithState
//       |-----> (*) CanUnmarshalMsg
//       |-----> (*) Msgsize
//       |-----> (*) MsgIsZero
//       |-----> ProposalStoreMaxSize()
//
// proposalTable
//       |-----> (*) MarshalMsg
//       |-----> (*) CanMarshalMsg
//       |-----> (*) UnmarshalMsg
//       |-----> (*) UnmarshalMsgWithState
//       |-----> (*) CanUnmarshalMsg
//       |-----> (*) Msgsize
//       |-----> (*) MsgIsZero
//       |-----> ProposalTableMaxSize()
//
// proposalTracker
//        |-----> (*) MarshalMsg
//        |-----> (*) CanMarshalMsg
//        |-----> (*) UnmarshalMsg
//        |-----> (*) UnmarshalMsgWithState
//        |-----> (*) CanUnmarshalMsg
//        |-----> (*) Msgsize
//        |-----> (*) MsgIsZero
//        |-----> ProposalTrackerMaxSize()
//
// proposalTrackerContract
//            |-----> (*) MarshalMsg
//            |-----> (*) CanMarshalMsg
//            |-----> (*) UnmarshalMsg
//            |-----> (*) UnmarshalMsgWithState
//            |-----> (*) CanUnmarshalMsg
//            |-----> (*) Msgsize
//            |-----> (*) MsgIsZero
//            |-----> ProposalTrackerContractMaxSize()
//
// proposalValue
//       |-----> (*) MarshalMsg
//       |-----> (*) CanMarshalMsg
//       |-----> (*) UnmarshalMsg
//       |-----> (*) UnmarshalMsgWithState
//       |-----> (*) CanUnmarshalMsg
//       |-----> (*) Msgsize
//       |-----> (*) MsgIsZero
//       |-----> ProposalValueMaxSize()
//
// proposalVoteCounter
//          |-----> (*) MarshalMsg
//          |-----> (*) CanMarshalMsg
//          |-----> (*) UnmarshalMsg
//          |-----> (*) UnmarshalMsgWithState
//          |-----> (*) CanUnmarshalMsg
//          |-----> (*) Msgsize
//          |-----> (*) MsgIsZero
//          |-----> ProposalVoteCounterMaxSize()
//
// proposerSeed
//       |-----> (*) MarshalMsg
//       |-----> (*) CanMarshalMsg
//       |-----> (*) UnmarshalMsg
//       |-----> (*) UnmarshalMsgWithState
//       |-----> (*) CanUnmarshalMsg
//       |-----> (*) Msgsize
//       |-----> (*) MsgIsZero
//       |-----> ProposerSeedMaxSize()
//
// rawVote
//    |-----> (*) MarshalMsg
//    |-----> (*) CanMarshalMsg
//    |-----> (*) UnmarshalMsg
//    |-----> (*) UnmarshalMsgWithState
//    |-----> (*) CanUnmarshalMsg
//    |-----> (*) Msgsize
//    |-----> (*) MsgIsZero
//    |-----> RawVoteMaxSize()
//
// rootRouter
//      |-----> (*) MarshalMsg
//      |-----> (*) CanMarshalMsg
//      |-----> (*) UnmarshalMsg
//      |-----> (*) UnmarshalMsgWithState
//      |-----> (*) CanUnmarshalMsg
//      |-----> (*) Msgsize
//      |-----> (*) MsgIsZero
//      |-----> RootRouterMaxSize()
//
// roundRouter
//      |-----> (*) MarshalMsg
//      |-----> (*) CanMarshalMsg
//      |-----> (*) UnmarshalMsg
//      |-----> (*) UnmarshalMsgWithState
//      |-----> (*) CanUnmarshalMsg
//      |-----> (*) Msgsize
//      |-----> (*) MsgIsZero
//      |-----> RoundRouterMaxSize()
//
// seedInput
//     |-----> (*) MarshalMsg
//     |-----> (*) CanMarshalMsg
//     |-----> (*) UnmarshalMsg
//     |-----> (*) UnmarshalMsgWithState
//     |-----> (*) CanUnmarshalMsg
//     |-----> (*) Msgsize
//     |-----> (*) MsgIsZero
//     |-----> SeedInputMaxSize()
//
// selector
//     |-----> (*) MarshalMsg
//     |-----> (*) CanMarshalMsg
//     |-----> (*) UnmarshalMsg
//     |-----> (*) UnmarshalMsgWithState
//     |-----> (*) CanUnmarshalMsg
//     |-----> (*) Msgsize
//     |-----> (*) MsgIsZero
//     |-----> SelectorMaxSize()
//
// serializableError
//         |-----> MarshalMsg
//         |-----> CanMarshalMsg
//         |-----> (*) UnmarshalMsg
//         |-----> (*) UnmarshalMsgWithState
//         |-----> (*) CanUnmarshalMsg
//         |-----> Msgsize
//         |-----> MsgIsZero
//         |-----> SerializableErrorMaxSize()
//
// step
//   |-----> MarshalMsg
//   |-----> CanMarshalMsg
//   |-----> (*) UnmarshalMsg
//   |-----> (*) UnmarshalMsgWithState
//   |-----> (*) CanUnmarshalMsg
//   |-----> Msgsize
//   |-----> MsgIsZero
//   |-----> StepMaxSize()
//
// stepRouter
//      |-----> (*) MarshalMsg
//      |-----> (*) CanMarshalMsg
//      |-----> (*) UnmarshalMsg
//      |-----> (*) UnmarshalMsgWithState
//      |-----> (*) CanUnmarshalMsg
//      |-----> (*) Msgsize
//      |-----> (*) MsgIsZero
//      |-----> StepRouterMaxSize()
//
// thresholdEvent
//        |-----> (*) MarshalMsg
//        |-----> (*) CanMarshalMsg
//        |-----> (*) UnmarshalMsg
//        |-----> (*) UnmarshalMsgWithState
//        |-----> (*) CanUnmarshalMsg
//        |-----> (*) Msgsize
//        |-----> (*) MsgIsZero
//        |-----> ThresholdEventMaxSize()
//
// transmittedPayload
//          |-----> (*) MarshalMsg
//          |-----> (*) CanMarshalMsg
//          |-----> (*) UnmarshalMsg
//          |-----> (*) UnmarshalMsgWithState
//          |-----> (*) CanUnmarshalMsg
//          |-----> (*) Msgsize
//          |-----> (*) MsgIsZero
//          |-----> TransmittedPayloadMaxSize()
//
// unauthenticatedBundle
//           |-----> (*) MarshalMsg
//           |-----> (*) CanMarshalMsg
//           |-----> (*) UnmarshalMsg
//           |-----> (*) UnmarshalMsgWithState
//           |-----> (*) CanUnmarshalMsg
//           |-----> (*) Msgsize
//           |-----> (*) MsgIsZero
//           |-----> UnauthenticatedBundleMaxSize()
//
// unauthenticatedEquivocationVote
//                |-----> (*) MarshalMsg
//                |-----> (*) CanMarshalMsg
//                |-----> (*) UnmarshalMsg
//                |-----> (*) UnmarshalMsgWithState
//                |-----> (*) CanUnmarshalMsg
//                |-----> (*) Msgsize
//                |-----> (*) MsgIsZero
//                |-----> UnauthenticatedEquivocationVoteMaxSize()
//
// unauthenticatedProposal
//            |-----> (*) MarshalMsg
//            |-----> (*) CanMarshalMsg
//            |-----> (*) UnmarshalMsg
//            |-----> (*) UnmarshalMsgWithState
//            |-----> (*) CanUnmarshalMsg
//            |-----> (*) Msgsize
//            |-----> (*) MsgIsZero
//            |-----> UnauthenticatedProposalMaxSize()
//
// unauthenticatedVote
//          |-----> (*) MarshalMsg
//          |-----> (*) CanMarshalMsg
//          |-----> (*) UnmarshalMsg
//          |-----> (*) UnmarshalMsgWithState
//          |-----> (*) CanUnmarshalMsg
//          |-----> (*) Msgsize
//          |-----> (*) MsgIsZero
//          |-----> UnauthenticatedVoteMaxSize()
//
// vote
//   |-----> (*) MarshalMsg
//   |-----> (*) CanMarshalMsg
//   |-----> (*) UnmarshalMsg
//   |-----> (*) UnmarshalMsgWithState
//   |-----> (*) CanUnmarshalMsg
//   |-----> (*) Msgsize
//   |-----> (*) MsgIsZero
//   |-----> VoteMaxSize()
//
// voteAggregator
//        |-----> (*) MarshalMsg
//        |-----> (*) CanMarshalMsg
//        |-----> (*) UnmarshalMsg
//        |-----> (*) UnmarshalMsgWithState
//        |-----> (*) CanUnmarshalMsg
//        |-----> (*) Msgsize
//        |-----> (*) MsgIsZero
//        |-----> VoteAggregatorMaxSize()
//
// voteAuthenticator
//         |-----> (*) MarshalMsg
//         |-----> (*) CanMarshalMsg
//         |-----> (*) UnmarshalMsg
//         |-----> (*) UnmarshalMsgWithState
//         |-----> (*) CanUnmarshalMsg
//         |-----> (*) Msgsize
//         |-----> (*) MsgIsZero
//         |-----> VoteAuthenticatorMaxSize()
//
// voteTracker
//      |-----> (*) MarshalMsg
//      |-----> (*) CanMarshalMsg
//      |-----> (*) UnmarshalMsg
//      |-----> (*) UnmarshalMsgWithState
//      |-----> (*) CanUnmarshalMsg
//      |-----> (*) Msgsize
//      |-----> (*) MsgIsZero
//      |-----> VoteTrackerMaxSize()
//
// voteTrackerContract
//          |-----> (*) MarshalMsg
//          |-----> (*) CanMarshalMsg
//          |-----> (*) UnmarshalMsg
//          |-----> (*) UnmarshalMsgWithState
//          |-----> (*) CanUnmarshalMsg
//          |-----> (*) Msgsize
//          |-----> (*) MsgIsZero
//          |-----> VoteTrackerContractMaxSize()
//
// voteTrackerPeriod
//         |-----> (*) MarshalMsg
//         |-----> (*) CanMarshalMsg
//         |-----> (*) UnmarshalMsg
//         |-----> (*) UnmarshalMsgWithState
//         |-----> (*) CanUnmarshalMsg
//         |-----> (*) Msgsize
//         |-----> (*) MsgIsZero
//         |-----> VoteTrackerPeriodMaxSize()
//
// voteTrackerRound
//         |-----> (*) MarshalMsg
//         |-----> (*) CanMarshalMsg
//         |-----> (*) UnmarshalMsg
//         |-----> (*) UnmarshalMsgWithState
//         |-----> (*) CanUnmarshalMsg
//         |-----> (*) Msgsize
//         |-----> (*) MsgIsZero
//         |-----> VoteTrackerRoundMaxSize()
//

// MarshalMsg implements msgp.Marshaler
func (z *Certificate) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0003Len := uint32(6)
	var zb0003Mask uint8 /* 7 bits */
	if len((*z).EquivocationVotes) == 0 {
		zb0003Len--
		zb0003Mask |= 0x2
	}
	if (*z).Period == 0 {
		zb0003Len--
		zb0003Mask |= 0x4
	}
	if (*z).Proposal.MsgIsZero() {
		zb0003Len--
		zb0003Mask |= 0x8
	}
	if (*z).Round.MsgIsZero() {
		zb0003Len--
		zb0003Mask |= 0x10
	}
	if (*z).Step == 0 {
		zb0003Len--
		zb0003Mask |= 0x20
	}
	if len((*z).Votes) == 0 {
		zb0003Len--
		zb0003Mask |= 0x40
	}
	// variable map header, size zb0003Len
	o = append(o, 0x80|uint8(zb0003Len))
	if zb0003Len != 0 {
		if (zb0003Mask & 0x2) == 0 { // if not empty
			// string "eqv"
			o = append(o, 0xa3, 0x65, 0x71, 0x76)
			if (*z).EquivocationVotes == nil {
				o = msgp.AppendNil(o)
			} else {
				o = msgp.AppendArrayHeader(o, uint32(len((*z).EquivocationVotes)))
			}
			for zb0002 := range (*z).EquivocationVotes {
				o = (*z).EquivocationVotes[zb0002].MarshalMsg(o)
			}
		}
		if (zb0003Mask & 0x4) == 0 { // if not empty
			// string "per"
			o = append(o, 0xa3, 0x70, 0x65, 0x72)
			o = msgp.AppendUint64(o, uint64((*z).Period))
		}
		if (zb0003Mask & 0x8) == 0 { // if not empty
			// string "prop"
			o = append(o, 0xa4, 0x70, 0x72, 0x6f, 0x70)
			o = (*z).Proposal.MarshalMsg(o)
		}
		if (zb0003Mask & 0x10) == 0 { // if not empty
			// string "rnd"
			o = append(o, 0xa3, 0x72, 0x6e, 0x64)
			o = (*z).Round.MarshalMsg(o)
		}
		if (zb0003Mask & 0x20) == 0 { // if not empty
			// string "step"
			o = append(o, 0xa4, 0x73, 0x74, 0x65, 0x70)
			o = msgp.AppendUint64(o, uint64((*z).Step))
		}
		if (zb0003Mask & 0x40) == 0 { // if not empty
			// string "vote"
			o = append(o, 0xa4, 0x76, 0x6f, 0x74, 0x65)
			if (*z).Votes == nil {
				o = msgp.AppendNil(o)
			} else {
				o = msgp.AppendArrayHeader(o, uint32(len((*z).Votes)))
			}
			for zb0001 := range (*z).Votes {
				o = (*z).Votes[zb0001].MarshalMsg(o)
			}
		}
	}
	return
}

func (_ *Certificate) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*Certificate)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *Certificate) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0003 int
	var zb0004 bool
	zb0003, zb0004, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0003, zb0004, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0003 > 0 {
			zb0003--
			bts, err = (*z).Round.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Round")
				return
			}
		}
		if zb0003 > 0 {
			zb0003--
			{
				var zb0005 uint64
				zb0005, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Period")
					return
				}
				(*z).Period = period(zb0005)
			}
		}
		if zb0003 > 0 {
			zb0003--
			{
				var zb0006 uint64
				zb0006, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Step")
					return
				}
				(*z).Step = step(zb0006)
			}
		}
		if zb0003 > 0 {
			zb0003--
			bts, err = (*z).Proposal.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Proposal")
				return
			}
		}
		if zb0003 > 0 {
			zb0003--
			var zb0007 int
			var zb0008 bool
			zb0007, zb0008, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Votes")
				return
			}
			if zb0007 > bounds.MaxVoteThreshold {
				err = msgp.ErrOverflow(uint64(zb0007), uint64(bounds.MaxVoteThreshold))
				err = msgp.WrapError(err, "struct-from-array", "Votes")
				return
			}
			if zb0008 {
				(*z).Votes = nil
			} else if (*z).Votes != nil && cap((*z).Votes) >= zb0007 {
				(*z).Votes = ((*z).Votes)[:zb0007]
			} else {
				(*z).Votes = make([]voteAuthenticator, zb0007)
			}
			for zb0001 := range (*z).Votes {
				bts, err = (*z).Votes[zb0001].UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Votes", zb0001)
					return
				}
			}
		}
		if zb0003 > 0 {
			zb0003--
			var zb0009 int
			var zb0010 bool
			zb0009, zb0010, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "EquivocationVotes")
				return
			}
			if zb0009 > bounds.MaxVoteThreshold {
				err = msgp.ErrOverflow(uint64(zb0009), uint64(bounds.MaxVoteThreshold))
				err = msgp.WrapError(err, "struct-from-array", "EquivocationVotes")
				return
			}
			if zb0010 {
				(*z).EquivocationVotes = nil
			} else if (*z).EquivocationVotes != nil && cap((*z).EquivocationVotes) >= zb0009 {
				(*z).EquivocationVotes = ((*z).EquivocationVotes)[:zb0009]
			} else {
				(*z).EquivocationVotes = make([]equivocationVoteAuthenticator, zb0009)
			}
			for zb0002 := range (*z).EquivocationVotes {
				bts, err = (*z).EquivocationVotes[zb0002].UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "EquivocationVotes", zb0002)
					return
				}
			}
		}
		if zb0003 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0003)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0004 {
			(*z) = Certificate{}
		}
		for zb0003 > 0 {
			zb0003--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "rnd":
				bts, err = (*z).Round.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Round")
					return
				}
			case "per":
				{
					var zb0011 uint64
					zb0011, bts, err = msgp.ReadUint64Bytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "Period")
						return
					}
					(*z).Period = period(zb0011)
				}
			case "step":
				{
					var zb0012 uint64
					zb0012, bts, err = msgp.ReadUint64Bytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "Step")
						return
					}
					(*z).Step = step(zb0012)
				}
			case "prop":
				bts, err = (*z).Proposal.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Proposal")
					return
				}
			case "vote":
				var zb0013 int
				var zb0014 bool
				zb0013, zb0014, bts, err = msgp.ReadArrayHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Votes")
					return
				}
				if zb0013 > bounds.MaxVoteThreshold {
					err = msgp.ErrOverflow(uint64(zb0013), uint64(bounds.MaxVoteThreshold))
					err = msgp.WrapError(err, "Votes")
					return
				}
				if zb0014 {
					(*z).Votes = nil
				} else if (*z).Votes != nil && cap((*z).Votes) >= zb0013 {
					(*z).Votes = ((*z).Votes)[:zb0013]
				} else {
					(*z).Votes = make([]voteAuthenticator, zb0013)
				}
				for zb0001 := range (*z).Votes {
					bts, err = (*z).Votes[zb0001].UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "Votes", zb0001)
						return
					}
				}
			case "eqv":
				var zb0015 int
				var zb0016 bool
				zb0015, zb0016, bts, err = msgp.ReadArrayHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "EquivocationVotes")
					return
				}
				if zb0015 > bounds.MaxVoteThreshold {
					err = msgp.ErrOverflow(uint64(zb0015), uint64(bounds.MaxVoteThreshold))
					err = msgp.WrapError(err, "EquivocationVotes")
					return
				}
				if zb0016 {
					(*z).EquivocationVotes = nil
				} else if (*z).EquivocationVotes != nil && cap((*z).EquivocationVotes) >= zb0015 {
					(*z).EquivocationVotes = ((*z).EquivocationVotes)[:zb0015]
				} else {
					(*z).EquivocationVotes = make([]equivocationVoteAuthenticator, zb0015)
				}
				for zb0002 := range (*z).EquivocationVotes {
					bts, err = (*z).EquivocationVotes[zb0002].UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "EquivocationVotes", zb0002)
						return
					}
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *Certificate) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *Certificate) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*Certificate)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *Certificate) Msgsize() (s int) {
	s = 1 + 4 + (*z).Round.Msgsize() + 4 + msgp.Uint64Size + 5 + msgp.Uint64Size + 5 + (*z).Proposal.Msgsize() + 5 + msgp.ArrayHeaderSize
	for zb0001 := range (*z).Votes {
		s += (*z).Votes[zb0001].Msgsize()
	}
	s += 4 + msgp.ArrayHeaderSize
	for zb0002 := range (*z).EquivocationVotes {
		s += (*z).EquivocationVotes[zb0002].Msgsize()
	}
	return
}

// MsgIsZero returns whether this is a zero value
func (z *Certificate) MsgIsZero() bool {
	return ((*z).Round.MsgIsZero()) && ((*z).Period == 0) && ((*z).Step == 0) && ((*z).Proposal.MsgIsZero()) && (len((*z).Votes) == 0) && (len((*z).EquivocationVotes) == 0)
}

// MaxSize returns a maximum valid message size for this message type
func CertificateMaxSize() (s int) {
	s = 1 + 4 + basics.RoundMaxSize() + 4 + msgp.Uint64Size + 5 + msgp.Uint64Size + 5 + ProposalValueMaxSize() + 5
	// Calculating size of slice: z.Votes
	s += msgp.ArrayHeaderSize + ((bounds.MaxVoteThreshold) * (VoteAuthenticatorMaxSize()))
	s += 4
	// Calculating size of slice: z.EquivocationVotes
	s += msgp.ArrayHeaderSize + ((bounds.MaxVoteThreshold) * (EquivocationVoteAuthenticatorMaxSize()))
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *ConsensusVersionView) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 2
	// string "Err"
	o = append(o, 0x82, 0xa3, 0x45, 0x72, 0x72)
	if (*z).Err == nil {
		o = msgp.AppendNil(o)
	} else {
		o = msgp.AppendString(o, string(*(*z).Err))
	}
	// string "Version"
	o = append(o, 0xa7, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e)
	o = (*z).Version.MarshalMsg(o)
	return
}

func (_ *ConsensusVersionView) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*ConsensusVersionView)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *ConsensusVersionView) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0001 int
	var zb0002 bool
	zb0001, zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0001, zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0001 > 0 {
			zb0001--
			if msgp.IsNil(bts) {
				bts, err = msgp.ReadNilBytes(bts)
				if err != nil {
					return
				}
				(*z).Err = nil
			} else {
				if (*z).Err == nil {
					(*z).Err = new(serializableError)
				}
				{
					var zb0003 string
					zb0003, bts, err = msgp.ReadStringBytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "Err")
						return
					}
					*(*z).Err = serializableError(zb0003)
				}
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).Version.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Version")
				return
			}
		}
		if zb0001 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0001)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 {
			(*z) = ConsensusVersionView{}
		}
		for zb0001 > 0 {
			zb0001--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "Err":
				if msgp.IsNil(bts) {
					bts, err = msgp.ReadNilBytes(bts)
					if err != nil {
						return
					}
					(*z).Err = nil
				} else {
					if (*z).Err == nil {
						(*z).Err = new(serializableError)
					}
					{
						var zb0004 string
						zb0004, bts, err = msgp.ReadStringBytes(bts)
						if err != nil {
							err = msgp.WrapError(err, "Err")
							return
						}
						*(*z).Err = serializableError(zb0004)
					}
				}
			case "Version":
				bts, err = (*z).Version.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Version")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *ConsensusVersionView) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *ConsensusVersionView) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*ConsensusVersionView)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *ConsensusVersionView) Msgsize() (s int) {
	s = 1 + 4
	if (*z).Err == nil {
		s += msgp.NilSize
	} else {
		s += msgp.StringPrefixSize + len(string(*(*z).Err))
	}
	s += 8 + (*z).Version.Msgsize()
	return
}

// MsgIsZero returns whether this is a zero value
func (z *ConsensusVersionView) MsgIsZero() bool {
	return ((*z).Err == nil) && ((*z).Version.MsgIsZero())
}

// MaxSize returns a maximum valid message size for this message type
func ConsensusVersionViewMaxSize() (s int) {
	s = 1 + 4
	panic("Unable to determine max size: String type string(*z.Err) is unbounded")
}

// MarshalMsg implements msgp.Marshaler
func (z *Deadline) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 2
	// string "Duration"
	o = append(o, 0x82, 0xa8, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e)
	o = msgp.AppendDuration(o, (*z).Duration)
	// string "Type"
	o = append(o, 0xa4, 0x54, 0x79, 0x70, 0x65)
	o = msgp.AppendInt8(o, int8((*z).Type))
	return
}

func (_ *Deadline) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*Deadline)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *Deadline) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0001 int
	var zb0002 bool
	zb0001, zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0001, zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0001 > 0 {
			zb0001--
			(*z).Duration, bts, err = msgp.ReadDurationBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Duration")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			{
				var zb0003 int8
				zb0003, bts, err = msgp.ReadInt8Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Type")
					return
				}
				(*z).Type = TimeoutType(zb0003)
			}
		}
		if zb0001 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0001)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 {
			(*z) = Deadline{}
		}
		for zb0001 > 0 {
			zb0001--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "Duration":
				(*z).Duration, bts, err = msgp.ReadDurationBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Duration")
					return
				}
			case "Type":
				{
					var zb0004 int8
					zb0004, bts, err = msgp.ReadInt8Bytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "Type")
						return
					}
					(*z).Type = TimeoutType(zb0004)
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *Deadline) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *Deadline) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*Deadline)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *Deadline) Msgsize() (s int) {
	s = 1 + 9 + msgp.DurationSize + 5 + msgp.Int8Size
	return
}

// MsgIsZero returns whether this is a zero value
func (z *Deadline) MsgIsZero() bool {
	return ((*z).Duration == 0) && ((*z).Type == 0)
}

// MaxSize returns a maximum valid message size for this message type
func DeadlineMaxSize() (s int) {
	s = 1 + 9 + msgp.DurationSize + 5 + msgp.Int8Size
	return
}

// MarshalMsg implements msgp.Marshaler
func (z LateCredentialTrackingEffect) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	o = msgp.AppendUint8(o, uint8(z))
	return
}

func (_ LateCredentialTrackingEffect) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(LateCredentialTrackingEffect)
	if !ok {
		_, ok = (z).(*LateCredentialTrackingEffect)
	}
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *LateCredentialTrackingEffect) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	{
		var zb0001 uint8
		zb0001, bts, err = msgp.ReadUint8Bytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		(*z) = LateCredentialTrackingEffect(zb0001)
	}
	o = bts
	return
}

func (z *LateCredentialTrackingEffect) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *LateCredentialTrackingEffect) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*LateCredentialTrackingEffect)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z LateCredentialTrackingEffect) Msgsize() (s int) {
	s = msgp.Uint8Size
	return
}

// MsgIsZero returns whether this is a zero value
func (z LateCredentialTrackingEffect) MsgIsZero() bool {
	return z == 0
}

// MaxSize returns a maximum valid message size for this message type
func LateCredentialTrackingEffectMaxSize() (s int) {
	s = msgp.Uint8Size
	return
}

// MarshalMsg implements msgp.Marshaler
func (z TimeoutType) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	o = msgp.AppendInt8(o, int8(z))
	return
}

func (_ TimeoutType) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(TimeoutType)
	if !ok {
		_, ok = (z).(*TimeoutType)
	}
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *TimeoutType) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	{
		var zb0001 int8
		zb0001, bts, err = msgp.ReadInt8Bytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		(*z) = TimeoutType(zb0001)
	}
	o = bts
	return
}

func (z *TimeoutType) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *TimeoutType) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*TimeoutType)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z TimeoutType) Msgsize() (s int) {
	s = msgp.Int8Size
	return
}

// MsgIsZero returns whether this is a zero value
func (z TimeoutType) MsgIsZero() bool {
	return z == 0
}

// MaxSize returns a maximum valid message size for this message type
func TimeoutTypeMaxSize() (s int) {
	s = msgp.Int8Size
	return
}

// MarshalMsg implements msgp.Marshaler
func (z actionType) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	o = msgp.AppendUint8(o, uint8(z))
	return
}

func (_ actionType) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(actionType)
	if !ok {
		_, ok = (z).(*actionType)
	}
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *actionType) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	{
		var zb0001 uint8
		zb0001, bts, err = msgp.ReadUint8Bytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		(*z) = actionType(zb0001)
	}
	o = bts
	return
}

func (z *actionType) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *actionType) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*actionType)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z actionType) Msgsize() (s int) {
	s = msgp.Uint8Size
	return
}

// MsgIsZero returns whether this is a zero value
func (z actionType) MsgIsZero() bool {
	return z == 0
}

// MaxSize returns a maximum valid message size for this message type
func ActionTypeMaxSize() (s int) {
	s = msgp.Uint8Size
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *blockAssembler) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 5
	// string "Assembled"
	o = append(o, 0x85, 0xa9, 0x41, 0x73, 0x73, 0x65, 0x6d, 0x62, 0x6c, 0x65, 0x64)
	o = msgp.AppendBool(o, (*z).Assembled)
	// string "Authenticators"
	o = append(o, 0xae, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x6f, 0x72, 0x73)
	if (*z).Authenticators == nil {
		o = msgp.AppendNil(o)
	} else {
		o = msgp.AppendArrayHeader(o, uint32(len((*z).Authenticators)))
	}
	for zb0001 := range (*z).Authenticators {
		o = (*z).Authenticators[zb0001].MarshalMsg(o)
	}
	// string "Filled"
	o = append(o, 0xa6, 0x46, 0x69, 0x6c, 0x6c, 0x65, 0x64)
	o = msgp.AppendBool(o, (*z).Filled)
	// string "Payload"
	o = append(o, 0xa7, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64)
	o = (*z).Payload.MarshalMsg(o)
	// string "Pipeline"
	o = append(o, 0xa8, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65)
	o = (*z).Pipeline.MarshalMsg(o)
	return
}

func (_ *blockAssembler) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*blockAssembler)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *blockAssembler) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0002 int
	var zb0003 bool
	zb0002, zb0003, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0002, zb0003, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 > 0 {
			zb0002--
			bts, err = (*z).Pipeline.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Pipeline")
				return
			}
		}
		if zb0002 > 0 {
			zb0002--
			(*z).Filled, bts, err = msgp.ReadBoolBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Filled")
				return
			}
		}
		if zb0002 > 0 {
			zb0002--
			bts, err = (*z).Payload.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Payload")
				return
			}
		}
		if zb0002 > 0 {
			zb0002--
			(*z).Assembled, bts, err = msgp.ReadBoolBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Assembled")
				return
			}
		}
		if zb0002 > 0 {
			zb0002--
			var zb0004 int
			var zb0005 bool
			zb0004, zb0005, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Authenticators")
				return
			}
			if zb0005 {
				(*z).Authenticators = nil
			} else if (*z).Authenticators != nil && cap((*z).Authenticators) >= zb0004 {
				(*z).Authenticators = ((*z).Authenticators)[:zb0004]
			} else {
				(*z).Authenticators = make([]vote, zb0004)
			}
			for zb0001 := range (*z).Authenticators {
				bts, err = (*z).Authenticators[zb0001].UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Authenticators", zb0001)
					return
				}
			}
		}
		if zb0002 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0002)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0003 {
			(*z) = blockAssembler{}
		}
		for zb0002 > 0 {
			zb0002--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "Pipeline":
				bts, err = (*z).Pipeline.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Pipeline")
					return
				}
			case "Filled":
				(*z).Filled, bts, err = msgp.ReadBoolBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Filled")
					return
				}
			case "Payload":
				bts, err = (*z).Payload.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Payload")
					return
				}
			case "Assembled":
				(*z).Assembled, bts, err = msgp.ReadBoolBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Assembled")
					return
				}
			case "Authenticators":
				var zb0006 int
				var zb0007 bool
				zb0006, zb0007, bts, err = msgp.ReadArrayHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Authenticators")
					return
				}
				if zb0007 {
					(*z).Authenticators = nil
				} else if (*z).Authenticators != nil && cap((*z).Authenticators) >= zb0006 {
					(*z).Authenticators = ((*z).Authenticators)[:zb0006]
				} else {
					(*z).Authenticators = make([]vote, zb0006)
				}
				for zb0001 := range (*z).Authenticators {
					bts, err = (*z).Authenticators[zb0001].UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "Authenticators", zb0001)
						return
					}
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *blockAssembler) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *blockAssembler) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*blockAssembler)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *blockAssembler) Msgsize() (s int) {
	s = 1 + 9 + (*z).Pipeline.Msgsize() + 7 + msgp.BoolSize + 8 + (*z).Payload.Msgsize() + 10 + msgp.BoolSize + 15 + msgp.ArrayHeaderSize
	for zb0001 := range (*z).Authenticators {
		s += (*z).Authenticators[zb0001].Msgsize()
	}
	return
}

// MsgIsZero returns whether this is a zero value
func (z *blockAssembler) MsgIsZero() bool {
	return ((*z).Pipeline.MsgIsZero()) && ((*z).Filled == false) && ((*z).Payload.MsgIsZero()) && ((*z).Assembled == false) && (len((*z).Authenticators) == 0)
}

// MaxSize returns a maximum valid message size for this message type
func BlockAssemblerMaxSize() (s int) {
	s = 1 + 9 + UnauthenticatedProposalMaxSize() + 7 + msgp.BoolSize + 8 + ProposalMaxSize() + 10 + msgp.BoolSize + 15
	// Calculating size of slice: z.Authenticators
	panic("Slice z.Authenticators is unbounded")
}

// MarshalMsg implements msgp.Marshaler
func (z *bundle) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0003Len := uint32(3)
	var zb0003Mask uint8 /* 4 bits */
	if len((*z).EquivocationVotes) == 0 {
		zb0003Len--
		zb0003Mask |= 0x2
	}
	if (*z).U.MsgIsZero() {
		zb0003Len--
		zb0003Mask |= 0x4
	}
	if len((*z).Votes) == 0 {
		zb0003Len--
		zb0003Mask |= 0x8
	}
	// variable map header, size zb0003Len
	o = append(o, 0x80|uint8(zb0003Len))
	if zb0003Len != 0 {
		if (zb0003Mask & 0x2) == 0 { // if not empty
			// string "eqv"
			o = append(o, 0xa3, 0x65, 0x71, 0x76)
			if (*z).EquivocationVotes == nil {
				o = msgp.AppendNil(o)
			} else {
				o = msgp.AppendArrayHeader(o, uint32(len((*z).EquivocationVotes)))
			}
			for zb0002 := range (*z).EquivocationVotes {
				o = (*z).EquivocationVotes[zb0002].MarshalMsg(o)
			}
		}
		if (zb0003Mask & 0x4) == 0 { // if not empty
			// string "u"
			o = append(o, 0xa1, 0x75)
			o = (*z).U.MarshalMsg(o)
		}
		if (zb0003Mask & 0x8) == 0 { // if not empty
			// string "vote"
			o = append(o, 0xa4, 0x76, 0x6f, 0x74, 0x65)
			if (*z).Votes == nil {
				o = msgp.AppendNil(o)
			} else {
				o = msgp.AppendArrayHeader(o, uint32(len((*z).Votes)))
			}
			for zb0001 := range (*z).Votes {
				o = (*z).Votes[zb0001].MarshalMsg(o)
			}
		}
	}
	return
}

func (_ *bundle) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*bundle)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *bundle) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0003 int
	var zb0004 bool
	zb0003, zb0004, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0003, zb0004, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0003 > 0 {
			zb0003--
			bts, err = (*z).U.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "U")
				return
			}
		}
		if zb0003 > 0 {
			zb0003--
			var zb0005 int
			var zb0006 bool
			zb0005, zb0006, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Votes")
				return
			}
			if zb0005 > bounds.MaxVoteThreshold {
				err = msgp.ErrOverflow(uint64(zb0005), uint64(bounds.MaxVoteThreshold))
				err = msgp.WrapError(err, "struct-from-array", "Votes")
				return
			}
			if zb0006 {
				(*z).Votes = nil
			} else if (*z).Votes != nil && cap((*z).Votes) >= zb0005 {
				(*z).Votes = ((*z).Votes)[:zb0005]
			} else {
				(*z).Votes = make([]vote, zb0005)
			}
			for zb0001 := range (*z).Votes {
				bts, err = (*z).Votes[zb0001].UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Votes", zb0001)
					return
				}
			}
		}
		if zb0003 > 0 {
			zb0003--
			var zb0007 int
			var zb0008 bool
			zb0007, zb0008, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "EquivocationVotes")
				return
			}
			if zb0007 > bounds.MaxVoteThreshold {
				err = msgp.ErrOverflow(uint64(zb0007), uint64(bounds.MaxVoteThreshold))
				err = msgp.WrapError(err, "struct-from-array", "EquivocationVotes")
				return
			}
			if zb0008 {
				(*z).EquivocationVotes = nil
			} else if (*z).EquivocationVotes != nil && cap((*z).EquivocationVotes) >= zb0007 {
				(*z).EquivocationVotes = ((*z).EquivocationVotes)[:zb0007]
			} else {
				(*z).EquivocationVotes = make([]equivocationVote, zb0007)
			}
			for zb0002 := range (*z).EquivocationVotes {
				bts, err = (*z).EquivocationVotes[zb0002].UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "EquivocationVotes", zb0002)
					return
				}
			}
		}
		if zb0003 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0003)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0004 {
			(*z) = bundle{}
		}
		for zb0003 > 0 {
			zb0003--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "u":
				bts, err = (*z).U.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "U")
					return
				}
			case "vote":
				var zb0009 int
				var zb0010 bool
				zb0009, zb0010, bts, err = msgp.ReadArrayHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Votes")
					return
				}
				if zb0009 > bounds.MaxVoteThreshold {
					err = msgp.ErrOverflow(uint64(zb0009), uint64(bounds.MaxVoteThreshold))
					err = msgp.WrapError(err, "Votes")
					return
				}
				if zb0010 {
					(*z).Votes = nil
				} else if (*z).Votes != nil && cap((*z).Votes) >= zb0009 {
					(*z).Votes = ((*z).Votes)[:zb0009]
				} else {
					(*z).Votes = make([]vote, zb0009)
				}
				for zb0001 := range (*z).Votes {
					bts, err = (*z).Votes[zb0001].UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "Votes", zb0001)
						return
					}
				}
			case "eqv":
				var zb0011 int
				var zb0012 bool
				zb0011, zb0012, bts, err = msgp.ReadArrayHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "EquivocationVotes")
					return
				}
				if zb0011 > bounds.MaxVoteThreshold {
					err = msgp.ErrOverflow(uint64(zb0011), uint64(bounds.MaxVoteThreshold))
					err = msgp.WrapError(err, "EquivocationVotes")
					return
				}
				if zb0012 {
					(*z).EquivocationVotes = nil
				} else if (*z).EquivocationVotes != nil && cap((*z).EquivocationVotes) >= zb0011 {
					(*z).EquivocationVotes = ((*z).EquivocationVotes)[:zb0011]
				} else {
					(*z).EquivocationVotes = make([]equivocationVote, zb0011)
				}
				for zb0002 := range (*z).EquivocationVotes {
					bts, err = (*z).EquivocationVotes[zb0002].UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "EquivocationVotes", zb0002)
						return
					}
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *bundle) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *bundle) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*bundle)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *bundle) Msgsize() (s int) {
	s = 1 + 2 + (*z).U.Msgsize() + 5 + msgp.ArrayHeaderSize
	for zb0001 := range (*z).Votes {
		s += (*z).Votes[zb0001].Msgsize()
	}
	s += 4 + msgp.ArrayHeaderSize
	for zb0002 := range (*z).EquivocationVotes {
		s += (*z).EquivocationVotes[zb0002].Msgsize()
	}
	return
}

// MsgIsZero returns whether this is a zero value
func (z *bundle) MsgIsZero() bool {
	return ((*z).U.MsgIsZero()) && (len((*z).Votes) == 0) && (len((*z).EquivocationVotes) == 0)
}

// MaxSize returns a maximum valid message size for this message type
func BundleMaxSize() (s int) {
	s = 1 + 2 + UnauthenticatedBundleMaxSize() + 5
	// Calculating size of slice: z.Votes
	s += msgp.ArrayHeaderSize + ((bounds.MaxVoteThreshold) * (VoteMaxSize()))
	s += 4
	// Calculating size of slice: z.EquivocationVotes
	s += msgp.ArrayHeaderSize + ((bounds.MaxVoteThreshold) * (EquivocationVoteMaxSize()))
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *compoundMessage) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 2
	// string "Proposal"
	o = append(o, 0x82, 0xa8, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c)
	o = (*z).Proposal.MarshalMsg(o)
	// string "Vote"
	o = append(o, 0xa4, 0x56, 0x6f, 0x74, 0x65)
	o = (*z).Vote.MarshalMsg(o)
	return
}

func (_ *compoundMessage) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*compoundMessage)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *compoundMessage) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0001 int
	var zb0002 bool
	zb0001, zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0001, zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).Vote.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Vote")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).Proposal.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Proposal")
				return
			}
		}
		if zb0001 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0001)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 {
			(*z) = compoundMessage{}
		}
		for zb0001 > 0 {
			zb0001--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "Vote":
				bts, err = (*z).Vote.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Vote")
					return
				}
			case "Proposal":
				bts, err = (*z).Proposal.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Proposal")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *compoundMessage) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *compoundMessage) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*compoundMessage)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *compoundMessage) Msgsize() (s int) {
	s = 1 + 5 + (*z).Vote.Msgsize() + 9 + (*z).Proposal.Msgsize()
	return
}

// MsgIsZero returns whether this is a zero value
func (z *compoundMessage) MsgIsZero() bool {
	return ((*z).Vote.MsgIsZero()) && ((*z).Proposal.MsgIsZero())
}

// MaxSize returns a maximum valid message size for this message type
func CompoundMessageMaxSize() (s int) {
	s = 1 + 5 + UnauthenticatedVoteMaxSize() + 9 + UnauthenticatedProposalMaxSize()
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *diskState) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 5
	// string "ActionTypes"
	o = append(o, 0x85, 0xab, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x73)
	if (*z).ActionTypes == nil {
		o = msgp.AppendNil(o)
	} else {
		o = msgp.AppendArrayHeader(o, uint32(len((*z).ActionTypes)))
	}
	for zb0001 := range (*z).ActionTypes {
		o = msgp.AppendUint8(o, uint8((*z).ActionTypes[zb0001]))
	}
	// string "Actions"
	o = append(o, 0xa7, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73)
	if (*z).Actions == nil {
		o = msgp.AppendNil(o)
	} else {
		o = msgp.AppendArrayHeader(o, uint32(len((*z).Actions)))
	}
	for zb0002 := range (*z).Actions {
		o = msgp.AppendBytes(o, (*z).Actions[zb0002])
	}
	// string "Clock"
	o = append(o, 0xa5, 0x43, 0x6c, 0x6f, 0x63, 0x6b)
	o = msgp.AppendBytes(o, (*z).Clock)
	// string "Player"
	o = append(o, 0xa6, 0x50, 0x6c, 0x61, 0x79, 0x65, 0x72)
	o = msgp.AppendBytes(o, (*z).Player)
	// string "Router"
	o = append(o, 0xa6, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x72)
	o = msgp.AppendBytes(o, (*z).Router)
	return
}

func (_ *diskState) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*diskState)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *diskState) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0003 int
	var zb0004 bool
	zb0003, zb0004, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0003, zb0004, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0003 > 0 {
			zb0003--
			(*z).Router, bts, err = msgp.ReadBytesBytes(bts, (*z).Router)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Router")
				return
			}
		}
		if zb0003 > 0 {
			zb0003--
			(*z).Player, bts, err = msgp.ReadBytesBytes(bts, (*z).Player)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Player")
				return
			}
		}
		if zb0003 > 0 {
			zb0003--
			(*z).Clock, bts, err = msgp.ReadBytesBytes(bts, (*z).Clock)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Clock")
				return
			}
		}
		if zb0003 > 0 {
			zb0003--
			var zb0005 int
			var zb0006 bool
			zb0005, zb0006, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "ActionTypes")
				return
			}
			if zb0006 {
				(*z).ActionTypes = nil
			} else if (*z).ActionTypes != nil && cap((*z).ActionTypes) >= zb0005 {
				(*z).ActionTypes = ((*z).ActionTypes)[:zb0005]
			} else {
				(*z).ActionTypes = make([]actionType, zb0005)
			}
			for zb0001 := range (*z).ActionTypes {
				{
					var zb0007 uint8
					zb0007, bts, err = msgp.ReadUint8Bytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "ActionTypes", zb0001)
						return
					}
					(*z).ActionTypes[zb0001] = actionType(zb0007)
				}
			}
		}
		if zb0003 > 0 {
			zb0003--
			var zb0008 int
			var zb0009 bool
			zb0008, zb0009, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Actions")
				return
			}
			if zb0009 {
				(*z).Actions = nil
			} else if (*z).Actions != nil && cap((*z).Actions) >= zb0008 {
				(*z).Actions = ((*z).Actions)[:zb0008]
			} else {
				(*z).Actions = make([][]byte, zb0008)
			}
			for zb0002 := range (*z).Actions {
				(*z).Actions[zb0002], bts, err = msgp.ReadBytesBytes(bts, (*z).Actions[zb0002])
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Actions", zb0002)
					return
				}
			}
		}
		if zb0003 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0003)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0004 {
			(*z) = diskState{}
		}
		for zb0003 > 0 {
			zb0003--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "Router":
				(*z).Router, bts, err = msgp.ReadBytesBytes(bts, (*z).Router)
				if err != nil {
					err = msgp.WrapError(err, "Router")
					return
				}
			case "Player":
				(*z).Player, bts, err = msgp.ReadBytesBytes(bts, (*z).Player)
				if err != nil {
					err = msgp.WrapError(err, "Player")
					return
				}
			case "Clock":
				(*z).Clock, bts, err = msgp.ReadBytesBytes(bts, (*z).Clock)
				if err != nil {
					err = msgp.WrapError(err, "Clock")
					return
				}
			case "ActionTypes":
				var zb0010 int
				var zb0011 bool
				zb0010, zb0011, bts, err = msgp.ReadArrayHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "ActionTypes")
					return
				}
				if zb0011 {
					(*z).ActionTypes = nil
				} else if (*z).ActionTypes != nil && cap((*z).ActionTypes) >= zb0010 {
					(*z).ActionTypes = ((*z).ActionTypes)[:zb0010]
				} else {
					(*z).ActionTypes = make([]actionType, zb0010)
				}
				for zb0001 := range (*z).ActionTypes {
					{
						var zb0012 uint8
						zb0012, bts, err = msgp.ReadUint8Bytes(bts)
						if err != nil {
							err = msgp.WrapError(err, "ActionTypes", zb0001)
							return
						}
						(*z).ActionTypes[zb0001] = actionType(zb0012)
					}
				}
			case "Actions":
				var zb0013 int
				var zb0014 bool
				zb0013, zb0014, bts, err = msgp.ReadArrayHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Actions")
					return
				}
				if zb0014 {
					(*z).Actions = nil
				} else if (*z).Actions != nil && cap((*z).Actions) >= zb0013 {
					(*z).Actions = ((*z).Actions)[:zb0013]
				} else {
					(*z).Actions = make([][]byte, zb0013)
				}
				for zb0002 := range (*z).Actions {
					(*z).Actions[zb0002], bts, err = msgp.ReadBytesBytes(bts, (*z).Actions[zb0002])
					if err != nil {
						err = msgp.WrapError(err, "Actions", zb0002)
						return
					}
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *diskState) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *diskState) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*diskState)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *diskState) Msgsize() (s int) {
	s = 1 + 7 + msgp.BytesPrefixSize + len((*z).Router) + 7 + msgp.BytesPrefixSize + len((*z).Player) + 6 + msgp.BytesPrefixSize + len((*z).Clock) + 12 + msgp.ArrayHeaderSize + (len((*z).ActionTypes) * (msgp.Uint8Size)) + 8 + msgp.ArrayHeaderSize
	for zb0002 := range (*z).Actions {
		s += msgp.BytesPrefixSize + len((*z).Actions[zb0002])
	}
	return
}

// MsgIsZero returns whether this is a zero value
func (z *diskState) MsgIsZero() bool {
	return (len((*z).Router) == 0) && (len((*z).Player) == 0) && (len((*z).Clock) == 0) && (len((*z).ActionTypes) == 0) && (len((*z).Actions) == 0)
}

// MaxSize returns a maximum valid message size for this message type
func DiskStateMaxSize() (s int) {
	s = 1 + 7
	panic("Unable to determine max size: Byteslice type z.Router is unbounded")
}

// MarshalMsg implements msgp.Marshaler
func (z *equivocationVote) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0003Len := uint32(7)
	var zb0003Mask uint8 /* 8 bits */
	if (*z).Cred.MsgIsZero() {
		zb0003Len--
		zb0003Mask |= 0x2
	}
	if (*z).Period == 0 {
		zb0003Len--
		zb0003Mask |= 0x4
	}
	if ((*z).Proposals[0].MsgIsZero()) && ((*z).Proposals[1].MsgIsZero()) {
		zb0003Len--
		zb0003Mask |= 0x8
	}
	if (*z).Round.MsgIsZero() {
		zb0003Len--
		zb0003Mask |= 0x10
	}
	if ((*z).Sigs[0].MsgIsZero()) && ((*z).Sigs[1].MsgIsZero()) {
		zb0003Len--
		zb0003Mask |= 0x20
	}
	if (*z).Sender.MsgIsZero() {
		zb0003Len--
		zb0003Mask |= 0x40
	}
	if (*z).Step == 0 {
		zb0003Len--
		zb0003Mask |= 0x80
	}
	// variable map header, size zb0003Len
	o = append(o, 0x80|uint8(zb0003Len))
	if zb0003Len != 0 {
		if (zb0003Mask & 0x2) == 0 { // if not empty
			// string "cred"
			o = append(o, 0xa4, 0x63, 0x72, 0x65, 0x64)
			o = (*z).Cred.MarshalMsg(o)
		}
		if (zb0003Mask & 0x4) == 0 { // if not empty
			// string "per"
			o = append(o, 0xa3, 0x70, 0x65, 0x72)
			o = msgp.AppendUint64(o, uint64((*z).Period))
		}
		if (zb0003Mask & 0x8) == 0 { // if not empty
			// string "props"
			o = append(o, 0xa5, 0x70, 0x72, 0x6f, 0x70, 0x73)
			o = msgp.AppendArrayHeader(o, 2)
			for zb0001 := range (*z).Proposals {
				o = (*z).Proposals[zb0001].MarshalMsg(o)
			}
		}
		if (zb0003Mask & 0x10) == 0 { // if not empty
			// string "rnd"
			o = append(o, 0xa3, 0x72, 0x6e, 0x64)
			o = (*z).Round.MarshalMsg(o)
		}
		if (zb0003Mask & 0x20) == 0 { // if not empty
			// string "sigs"
			o = append(o, 0xa4, 0x73, 0x69, 0x67, 0x73)
			o = msgp.AppendArrayHeader(o, 2)
			for zb0002 := range (*z).Sigs {
				o = (*z).Sigs[zb0002].MarshalMsg(o)
			}
		}
		if (zb0003Mask & 0x40) == 0 { // if not empty
			// string "snd"
			o = append(o, 0xa3, 0x73, 0x6e, 0x64)
			o = (*z).Sender.MarshalMsg(o)
		}
		if (zb0003Mask & 0x80) == 0 { // if not empty
			// string "step"
			o = append(o, 0xa4, 0x73, 0x74, 0x65, 0x70)
			o = msgp.AppendUint64(o, uint64((*z).Step))
		}
	}
	return
}

func (_ *equivocationVote) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*equivocationVote)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *equivocationVote) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0003 int
	var zb0004 bool
	zb0003, zb0004, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0003, zb0004, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0003 > 0 {
			zb0003--
			bts, err = (*z).Sender.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Sender")
				return
			}
		}
		if zb0003 > 0 {
			zb0003--
			bts, err = (*z).Round.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Round")
				return
			}
		}
		if zb0003 > 0 {
			zb0003--
			{
				var zb0005 uint64
				zb0005, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Period")
					return
				}
				(*z).Period = period(zb0005)
			}
		}
		if zb0003 > 0 {
			zb0003--
			{
				var zb0006 uint64
				zb0006, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Step")
					return
				}
				(*z).Step = step(zb0006)
			}
		}
		if zb0003 > 0 {
			zb0003--
			bts, err = (*z).Cred.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Cred")
				return
			}
		}
		if zb0003 > 0 {
			zb0003--
			var zb0007 int
			zb0007, _, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Proposals")
				return
			}
			if zb0007 > 2 {
				err = msgp.ArrayError{Wanted: 2, Got: zb0007}
				return
			}
			for zb0001 := 0; zb0001 < zb0007; zb0001++ {
				bts, err = (*z).Proposals[zb0001].UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Proposals", zb0001)
					return
				}
			}
		}
		if zb0003 > 0 {
			zb0003--
			var zb0008 int
			zb0008, _, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Sigs")
				return
			}
			if zb0008 > 2 {
				err = msgp.ArrayError{Wanted: 2, Got: zb0008}
				return
			}
			for zb0002 := 0; zb0002 < zb0008; zb0002++ {
				bts, err = (*z).Sigs[zb0002].UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Sigs", zb0002)
					return
				}
			}
		}
		if zb0003 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0003)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0004 {
			(*z) = equivocationVote{}
		}
		for zb0003 > 0 {
			zb0003--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "snd":
				bts, err = (*z).Sender.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Sender")
					return
				}
			case "rnd":
				bts, err = (*z).Round.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Round")
					return
				}
			case "per":
				{
					var zb0009 uint64
					zb0009, bts, err = msgp.ReadUint64Bytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "Period")
						return
					}
					(*z).Period = period(zb0009)
				}
			case "step":
				{
					var zb0010 uint64
					zb0010, bts, err = msgp.ReadUint64Bytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "Step")
						return
					}
					(*z).Step = step(zb0010)
				}
			case "cred":
				bts, err = (*z).Cred.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Cred")
					return
				}
			case "props":
				var zb0011 int
				zb0011, _, bts, err = msgp.ReadArrayHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Proposals")
					return
				}
				if zb0011 > 2 {
					err = msgp.ArrayError{Wanted: 2, Got: zb0011}
					return
				}
				for zb0001 := 0; zb0001 < zb0011; zb0001++ {
					bts, err = (*z).Proposals[zb0001].UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "Proposals", zb0001)
						return
					}
				}
			case "sigs":
				var zb0012 int
				zb0012, _, bts, err = msgp.ReadArrayHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Sigs")
					return
				}
				if zb0012 > 2 {
					err = msgp.ArrayError{Wanted: 2, Got: zb0012}
					return
				}
				for zb0002 := 0; zb0002 < zb0012; zb0002++ {
					bts, err = (*z).Sigs[zb0002].UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "Sigs", zb0002)
						return
					}
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *equivocationVote) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *equivocationVote) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*equivocationVote)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *equivocationVote) Msgsize() (s int) {
	s = 1 + 4 + (*z).Sender.Msgsize() + 4 + (*z).Round.Msgsize() + 4 + msgp.Uint64Size + 5 + msgp.Uint64Size + 5 + (*z).Cred.Msgsize() + 6 + msgp.ArrayHeaderSize
	for zb0001 := range (*z).Proposals {
		s += (*z).Proposals[zb0001].Msgsize()
	}
	s += 5 + msgp.ArrayHeaderSize
	for zb0002 := range (*z).Sigs {
		s += (*z).Sigs[zb0002].Msgsize()
	}
	return
}

// MsgIsZero returns whether this is a zero value
func (z *equivocationVote) MsgIsZero() bool {
	return ((*z).Sender.MsgIsZero()) && ((*z).Round.MsgIsZero()) && ((*z).Period == 0) && ((*z).Step == 0) && ((*z).Cred.MsgIsZero()) && (((*z).Proposals[0].MsgIsZero()) && ((*z).Proposals[1].MsgIsZero())) && (((*z).Sigs[0].MsgIsZero()) && ((*z).Sigs[1].MsgIsZero()))
}

// MaxSize returns a maximum valid message size for this message type
func EquivocationVoteMaxSize() (s int) {
	s = 1 + 4 + basics.AddressMaxSize() + 4 + basics.RoundMaxSize() + 4 + msgp.Uint64Size + 5 + msgp.Uint64Size + 5 + committee.CredentialMaxSize() + 6
	// Calculating size of array: z.Proposals
	s += msgp.ArrayHeaderSize + ((2) * (ProposalValueMaxSize()))
	s += 5
	// Calculating size of array: z.Sigs
	s += msgp.ArrayHeaderSize + ((2) * (crypto.OneTimeSignatureMaxSize()))
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *equivocationVoteAuthenticator) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0003Len := uint32(4)
	// variable map header, size zb0003Len
	o = append(o, 0x80|uint8(zb0003Len))
	if zb0003Len != 0 {
		// string "cred"
		o = append(o, 0xa4, 0x63, 0x72, 0x65, 0x64)
		o = (*z).Cred.MarshalMsg(o)
		// string "props"
		o = append(o, 0xa5, 0x70, 0x72, 0x6f, 0x70, 0x73)
		o = msgp.AppendArrayHeader(o, 2)
		for zb0002 := range (*z).Proposals {
			o = (*z).Proposals[zb0002].MarshalMsg(o)
		}
		// string "sig"
		o = append(o, 0xa3, 0x73, 0x69, 0x67)
		o = msgp.AppendArrayHeader(o, 2)
		for zb0001 := range (*z).Sigs {
			o = (*z).Sigs[zb0001].MarshalMsg(o)
		}
		// string "snd"
		o = append(o, 0xa3, 0x73, 0x6e, 0x64)
		o = (*z).Sender.MarshalMsg(o)
	}
	return
}

func (_ *equivocationVoteAuthenticator) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*equivocationVoteAuthenticator)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *equivocationVoteAuthenticator) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0003 int
	var zb0004 bool
	zb0003, zb0004, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0003, zb0004, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0003 > 0 {
			zb0003--
			bts, err = (*z).Sender.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Sender")
				return
			}
		}
		if zb0003 > 0 {
			zb0003--
			bts, err = (*z).Cred.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Cred")
				return
			}
		}
		if zb0003 > 0 {
			zb0003--
			var zb0005 int
			zb0005, _, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Sigs")
				return
			}
			if zb0005 > 2 {
				err = msgp.ArrayError{Wanted: 2, Got: zb0005}
				return
			}
			for zb0001 := 0; zb0001 < zb0005; zb0001++ {
				bts, err = (*z).Sigs[zb0001].UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Sigs", zb0001)
					return
				}
			}
		}
		if zb0003 > 0 {
			zb0003--
			var zb0006 int
			zb0006, _, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Proposals")
				return
			}
			if zb0006 > 2 {
				err = msgp.ArrayError{Wanted: 2, Got: zb0006}
				return
			}
			for zb0002 := 0; zb0002 < zb0006; zb0002++ {
				bts, err = (*z).Proposals[zb0002].UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Proposals", zb0002)
					return
				}
			}
		}
		if zb0003 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0003)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0004 {
			(*z) = equivocationVoteAuthenticator{}
		}
		for zb0003 > 0 {
			zb0003--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "snd":
				bts, err = (*z).Sender.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Sender")
					return
				}
			case "cred":
				bts, err = (*z).Cred.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Cred")
					return
				}
			case "sig":
				var zb0007 int
				zb0007, _, bts, err = msgp.ReadArrayHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Sigs")
					return
				}
				if zb0007 > 2 {
					err = msgp.ArrayError{Wanted: 2, Got: zb0007}
					return
				}
				for zb0001 := 0; zb0001 < zb0007; zb0001++ {
					bts, err = (*z).Sigs[zb0001].UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "Sigs", zb0001)
						return
					}
				}
			case "props":
				var zb0008 int
				zb0008, _, bts, err = msgp.ReadArrayHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Proposals")
					return
				}
				if zb0008 > 2 {
					err = msgp.ArrayError{Wanted: 2, Got: zb0008}
					return
				}
				for zb0002 := 0; zb0002 < zb0008; zb0002++ {
					bts, err = (*z).Proposals[zb0002].UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "Proposals", zb0002)
						return
					}
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *equivocationVoteAuthenticator) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *equivocationVoteAuthenticator) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*equivocationVoteAuthenticator)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *equivocationVoteAuthenticator) Msgsize() (s int) {
	s = 1 + 4 + (*z).Sender.Msgsize() + 5 + (*z).Cred.Msgsize() + 4 + msgp.ArrayHeaderSize
	for zb0001 := range (*z).Sigs {
		s += (*z).Sigs[zb0001].Msgsize()
	}
	s += 6 + msgp.ArrayHeaderSize
	for zb0002 := range (*z).Proposals {
		s += (*z).Proposals[zb0002].Msgsize()
	}
	return
}

// MsgIsZero returns whether this is a zero value
func (z *equivocationVoteAuthenticator) MsgIsZero() bool {
	return ((*z).Sender.MsgIsZero()) && ((*z).Cred.MsgIsZero()) && (((*z).Sigs[0].MsgIsZero()) && ((*z).Sigs[1].MsgIsZero())) && (((*z).Proposals[0].MsgIsZero()) && ((*z).Proposals[1].MsgIsZero()))
}

// MaxSize returns a maximum valid message size for this message type
func EquivocationVoteAuthenticatorMaxSize() (s int) {
	s = 1 + 4 + basics.AddressMaxSize() + 5 + committee.UnauthenticatedCredentialMaxSize() + 4
	// Calculating size of array: z.Sigs
	s += msgp.ArrayHeaderSize + ((2) * (crypto.OneTimeSignatureMaxSize()))
	s += 6
	// Calculating size of array: z.Proposals
	s += msgp.ArrayHeaderSize + ((2) * (ProposalValueMaxSize()))
	return
}

// MarshalMsg implements msgp.Marshaler
func (z eventType) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	o = msgp.AppendUint8(o, uint8(z))
	return
}

func (_ eventType) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(eventType)
	if !ok {
		_, ok = (z).(*eventType)
	}
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *eventType) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	{
		var zb0001 uint8
		zb0001, bts, err = msgp.ReadUint8Bytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		(*z) = eventType(zb0001)
	}
	o = bts
	return
}

func (z *eventType) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *eventType) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*eventType)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z eventType) Msgsize() (s int) {
	s = msgp.Uint8Size
	return
}

// MsgIsZero returns whether this is a zero value
func (z eventType) MsgIsZero() bool {
	return z == 0
}

// MaxSize returns a maximum valid message size for this message type
func EventTypeMaxSize() (s int) {
	s = msgp.Uint8Size
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *freshnessData) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 4
	// string "PlayerLastConcluding"
	o = append(o, 0x84, 0xb4, 0x50, 0x6c, 0x61, 0x79, 0x65, 0x72, 0x4c, 0x61, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x69, 0x6e, 0x67)
	o = msgp.AppendUint64(o, uint64((*z).PlayerLastConcluding))
	// string "PlayerPeriod"
	o = append(o, 0xac, 0x50, 0x6c, 0x61, 0x79, 0x65, 0x72, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64)
	o = msgp.AppendUint64(o, uint64((*z).PlayerPeriod))
	// string "PlayerRound"
	o = append(o, 0xab, 0x50, 0x6c, 0x61, 0x79, 0x65, 0x72, 0x52, 0x6f, 0x75, 0x6e, 0x64)
	o = (*z).PlayerRound.MarshalMsg(o)
	// string "PlayerStep"
	o = append(o, 0xaa, 0x50, 0x6c, 0x61, 0x79, 0x65, 0x72, 0x53, 0x74, 0x65, 0x70)
	o = msgp.AppendUint64(o, uint64((*z).PlayerStep))
	return
}

func (_ *freshnessData) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*freshnessData)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *freshnessData) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0001 int
	var zb0002 bool
	zb0001, zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0001, zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).PlayerRound.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "PlayerRound")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			{
				var zb0003 uint64
				zb0003, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "PlayerPeriod")
					return
				}
				(*z).PlayerPeriod = period(zb0003)
			}
		}
		if zb0001 > 0 {
			zb0001--
			{
				var zb0004 uint64
				zb0004, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "PlayerStep")
					return
				}
				(*z).PlayerStep = step(zb0004)
			}
		}
		if zb0001 > 0 {
			zb0001--
			{
				var zb0005 uint64
				zb0005, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "PlayerLastConcluding")
					return
				}
				(*z).PlayerLastConcluding = step(zb0005)
			}
		}
		if zb0001 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0001)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 {
			(*z) = freshnessData{}
		}
		for zb0001 > 0 {
			zb0001--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "PlayerRound":
				bts, err = (*z).PlayerRound.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "PlayerRound")
					return
				}
			case "PlayerPeriod":
				{
					var zb0006 uint64
					zb0006, bts, err = msgp.ReadUint64Bytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "PlayerPeriod")
						return
					}
					(*z).PlayerPeriod = period(zb0006)
				}
			case "PlayerStep":
				{
					var zb0007 uint64
					zb0007, bts, err = msgp.ReadUint64Bytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "PlayerStep")
						return
					}
					(*z).PlayerStep = step(zb0007)
				}
			case "PlayerLastConcluding":
				{
					var zb0008 uint64
					zb0008, bts, err = msgp.ReadUint64Bytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "PlayerLastConcluding")
						return
					}
					(*z).PlayerLastConcluding = step(zb0008)
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *freshnessData) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *freshnessData) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*freshnessData)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *freshnessData) Msgsize() (s int) {
	s = 1 + 12 + (*z).PlayerRound.Msgsize() + 13 + msgp.Uint64Size + 11 + msgp.Uint64Size + 21 + msgp.Uint64Size
	return
}

// MsgIsZero returns whether this is a zero value
func (z *freshnessData) MsgIsZero() bool {
	return ((*z).PlayerRound.MsgIsZero()) && ((*z).PlayerPeriod == 0) && ((*z).PlayerStep == 0) && ((*z).PlayerLastConcluding == 0)
}

// MaxSize returns a maximum valid message size for this message type
func FreshnessDataMaxSize() (s int) {
	s = 1 + 12 + basics.RoundMaxSize() + 13 + msgp.Uint64Size + 11 + msgp.Uint64Size + 21 + msgp.Uint64Size
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *message) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 8
	// string "Bundle"
	o = append(o, 0x88, 0xa6, 0x42, 0x75, 0x6e, 0x64, 0x6c, 0x65)
	o = (*z).Bundle.MarshalMsg(o)
	// string "CompoundMessage"
	o = append(o, 0xaf, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x75, 0x6e, 0x64, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65)
	// map header, size 2
	// string "Proposal"
	o = append(o, 0x82, 0xa8, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c)
	o = (*z).CompoundMessage.Proposal.MarshalMsg(o)
	// string "Vote"
	o = append(o, 0xa4, 0x56, 0x6f, 0x74, 0x65)
	o = (*z).CompoundMessage.Vote.MarshalMsg(o)
	// string "Proposal"
	o = append(o, 0xa8, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c)
	o = (*z).Proposal.MarshalMsg(o)
	// string "Tag"
	o = append(o, 0xa3, 0x54, 0x61, 0x67)
	o = (*z).Tag.MarshalMsg(o)
	// string "UnauthenticatedBundle"
	o = append(o, 0xb5, 0x55, 0x6e, 0x61, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64, 0x42, 0x75, 0x6e, 0x64, 0x6c, 0x65)
	o = (*z).UnauthenticatedBundle.MarshalMsg(o)
	// string "UnauthenticatedProposal"
	o = append(o, 0xb7, 0x55, 0x6e, 0x61, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c)
	o = (*z).UnauthenticatedProposal.MarshalMsg(o)
	// string "UnauthenticatedVote"
	o = append(o, 0xb3, 0x55, 0x6e, 0x61, 0x75, 0x74, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64, 0x56, 0x6f, 0x74, 0x65)
	o = (*z).UnauthenticatedVote.MarshalMsg(o)
	// string "Vote"
	o = append(o, 0xa4, 0x56, 0x6f, 0x74, 0x65)
	o = (*z).Vote.MarshalMsg(o)
	return
}

func (_ *message) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*message)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *message) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0001 int
	var zb0002 bool
	zb0001, zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0001, zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).Tag.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Tag")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).Vote.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Vote")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).Proposal.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Proposal")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).Bundle.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Bundle")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).UnauthenticatedVote.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "UnauthenticatedVote")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).UnauthenticatedProposal.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "UnauthenticatedProposal")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).UnauthenticatedBundle.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "UnauthenticatedBundle")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			var zb0003 int
			var zb0004 bool
			zb0003, zb0004, bts, err = msgp.ReadMapHeaderBytes(bts)
			if _, ok := err.(msgp.TypeError); ok {
				zb0003, zb0004, bts, err = msgp.ReadArrayHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "CompoundMessage")
					return
				}
				if zb0003 > 0 {
					zb0003--
					bts, err = (*z).CompoundMessage.Vote.UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "CompoundMessage", "struct-from-array", "Vote")
						return
					}
				}
				if zb0003 > 0 {
					zb0003--
					bts, err = (*z).CompoundMessage.Proposal.UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "CompoundMessage", "struct-from-array", "Proposal")
						return
					}
				}
				if zb0003 > 0 {
					err = msgp.ErrTooManyArrayFields(zb0003)
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "CompoundMessage", "struct-from-array")
						return
					}
				}
			} else {
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "CompoundMessage")
					return
				}
				if zb0004 {
					(*z).CompoundMessage = compoundMessage{}
				}
				for zb0003 > 0 {
					zb0003--
					field, bts, err = msgp.ReadMapKeyZC(bts)
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "CompoundMessage")
						return
					}
					switch string(field) {
					case "Vote":
						bts, err = (*z).CompoundMessage.Vote.UnmarshalMsgWithState(bts, st)
						if err != nil {
							err = msgp.WrapError(err, "struct-from-array", "CompoundMessage", "Vote")
							return
						}
					case "Proposal":
						bts, err = (*z).CompoundMessage.Proposal.UnmarshalMsgWithState(bts, st)
						if err != nil {
							err = msgp.WrapError(err, "struct-from-array", "CompoundMessage", "Proposal")
							return
						}
					default:
						err = msgp.ErrNoField(string(field))
						if err != nil {
							err = msgp.WrapError(err, "struct-from-array", "CompoundMessage")
							return
						}
					}
				}
			}
		}
		if zb0001 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0001)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 {
			(*z) = message{}
		}
		for zb0001 > 0 {
			zb0001--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "Tag":
				bts, err = (*z).Tag.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Tag")
					return
				}
			case "Vote":
				bts, err = (*z).Vote.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Vote")
					return
				}
			case "Proposal":
				bts, err = (*z).Proposal.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Proposal")
					return
				}
			case "Bundle":
				bts, err = (*z).Bundle.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Bundle")
					return
				}
			case "UnauthenticatedVote":
				bts, err = (*z).UnauthenticatedVote.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "UnauthenticatedVote")
					return
				}
			case "UnauthenticatedProposal":
				bts, err = (*z).UnauthenticatedProposal.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "UnauthenticatedProposal")
					return
				}
			case "UnauthenticatedBundle":
				bts, err = (*z).UnauthenticatedBundle.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "UnauthenticatedBundle")
					return
				}
			case "CompoundMessage":
				var zb0005 int
				var zb0006 bool
				zb0005, zb0006, bts, err = msgp.ReadMapHeaderBytes(bts)
				if _, ok := err.(msgp.TypeError); ok {
					zb0005, zb0006, bts, err = msgp.ReadArrayHeaderBytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "CompoundMessage")
						return
					}
					if zb0005 > 0 {
						zb0005--
						bts, err = (*z).CompoundMessage.Vote.UnmarshalMsgWithState(bts, st)
						if err != nil {
							err = msgp.WrapError(err, "CompoundMessage", "struct-from-array", "Vote")
							return
						}
					}
					if zb0005 > 0 {
						zb0005--
						bts, err = (*z).CompoundMessage.Proposal.UnmarshalMsgWithState(bts, st)
						if err != nil {
							err = msgp.WrapError(err, "CompoundMessage", "struct-from-array", "Proposal")
							return
						}
					}
					if zb0005 > 0 {
						err = msgp.ErrTooManyArrayFields(zb0005)
						if err != nil {
							err = msgp.WrapError(err, "CompoundMessage", "struct-from-array")
							return
						}
					}
				} else {
					if err != nil {
						err = msgp.WrapError(err, "CompoundMessage")
						return
					}
					if zb0006 {
						(*z).CompoundMessage = compoundMessage{}
					}
					for zb0005 > 0 {
						zb0005--
						field, bts, err = msgp.ReadMapKeyZC(bts)
						if err != nil {
							err = msgp.WrapError(err, "CompoundMessage")
							return
						}
						switch string(field) {
						case "Vote":
							bts, err = (*z).CompoundMessage.Vote.UnmarshalMsgWithState(bts, st)
							if err != nil {
								err = msgp.WrapError(err, "CompoundMessage", "Vote")
								return
							}
						case "Proposal":
							bts, err = (*z).CompoundMessage.Proposal.UnmarshalMsgWithState(bts, st)
							if err != nil {
								err = msgp.WrapError(err, "CompoundMessage", "Proposal")
								return
							}
						default:
							err = msgp.ErrNoField(string(field))
							if err != nil {
								err = msgp.WrapError(err, "CompoundMessage")
								return
							}
						}
					}
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *message) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *message) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*message)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *message) Msgsize() (s int) {
	s = 1 + 4 + (*z).Tag.Msgsize() + 5 + (*z).Vote.Msgsize() + 9 + (*z).Proposal.Msgsize() + 7 + (*z).Bundle.Msgsize() + 20 + (*z).UnauthenticatedVote.Msgsize() + 24 + (*z).UnauthenticatedProposal.Msgsize() + 22 + (*z).UnauthenticatedBundle.Msgsize() + 16 + 1 + 5 + (*z).CompoundMessage.Vote.Msgsize() + 9 + (*z).CompoundMessage.Proposal.Msgsize()
	return
}

// MsgIsZero returns whether this is a zero value
func (z *message) MsgIsZero() bool {
	return ((*z).Tag.MsgIsZero()) && ((*z).Vote.MsgIsZero()) && ((*z).Proposal.MsgIsZero()) && ((*z).Bundle.MsgIsZero()) && ((*z).UnauthenticatedVote.MsgIsZero()) && ((*z).UnauthenticatedProposal.MsgIsZero()) && ((*z).UnauthenticatedBundle.MsgIsZero()) && (((*z).CompoundMessage.Vote.MsgIsZero()) && ((*z).CompoundMessage.Proposal.MsgIsZero()))
}

// MaxSize returns a maximum valid message size for this message type
func MessageMaxSize() (s int) {
	s = 1 + 4 + protocol.TagMaxSize() + 5 + VoteMaxSize() + 9 + ProposalMaxSize() + 7 + BundleMaxSize() + 20 + UnauthenticatedVoteMaxSize() + 24 + UnauthenticatedProposalMaxSize() + 22 + UnauthenticatedBundleMaxSize() + 16 + 1 + 5 + UnauthenticatedVoteMaxSize() + 9 + UnauthenticatedProposalMaxSize()
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *messageEvent) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 7
	// string "Cancelled"
	o = append(o, 0x87, 0xa9, 0x43, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x6c, 0x65, 0x64)
	o = msgp.AppendBool(o, (*z).Cancelled)
	// string "Err"
	o = append(o, 0xa3, 0x45, 0x72, 0x72)
	if (*z).Err == nil {
		o = msgp.AppendNil(o)
	} else {
		o = msgp.AppendString(o, string(*(*z).Err))
	}
	// string "Input"
	o = append(o, 0xa5, 0x49, 0x6e, 0x70, 0x75, 0x74)
	o = (*z).Input.MarshalMsg(o)
	// string "Proto"
	o = append(o, 0xa5, 0x50, 0x72, 0x6f, 0x74, 0x6f)
	o = (*z).Proto.MarshalMsg(o)
	// string "T"
	o = append(o, 0xa1, 0x54)
	o = msgp.AppendUint8(o, uint8((*z).T))
	// string "Tail"
	o = append(o, 0xa4, 0x54, 0x61, 0x69, 0x6c)
	if (*z).Tail == nil {
		o = msgp.AppendNil(o)
	} else {
		o = (*z).Tail.MarshalMsg(o)
	}
	// string "TaskIndex"
	o = append(o, 0xa9, 0x54, 0x61, 0x73, 0x6b, 0x49, 0x6e, 0x64, 0x65, 0x78)
	o = msgp.AppendUint64(o, (*z).TaskIndex)
	return
}

func (_ *messageEvent) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*messageEvent)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *messageEvent) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0001 int
	var zb0002 bool
	zb0001, zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0001, zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0001 > 0 {
			zb0001--
			{
				var zb0003 uint8
				zb0003, bts, err = msgp.ReadUint8Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "T")
					return
				}
				(*z).T = eventType(zb0003)
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).Input.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Input")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			if msgp.IsNil(bts) {
				bts, err = msgp.ReadNilBytes(bts)
				if err != nil {
					return
				}
				(*z).Err = nil
			} else {
				if (*z).Err == nil {
					(*z).Err = new(serializableError)
				}
				{
					var zb0004 string
					zb0004, bts, err = msgp.ReadStringBytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "Err")
						return
					}
					*(*z).Err = serializableError(zb0004)
				}
			}
		}
		if zb0001 > 0 {
			zb0001--
			(*z).TaskIndex, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "TaskIndex")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			if msgp.IsNil(bts) {
				bts, err = msgp.ReadNilBytes(bts)
				if err != nil {
					return
				}
				(*z).Tail = nil
			} else {
				if (*z).Tail == nil {
					(*z).Tail = new(messageEvent)
				}
				bts, err = (*z).Tail.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Tail")
					return
				}
			}
		}
		if zb0001 > 0 {
			zb0001--
			(*z).Cancelled, bts, err = msgp.ReadBoolBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Cancelled")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).Proto.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Proto")
				return
			}
		}
		if zb0001 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0001)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 {
			(*z) = messageEvent{}
		}
		for zb0001 > 0 {
			zb0001--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "T":
				{
					var zb0005 uint8
					zb0005, bts, err = msgp.ReadUint8Bytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "T")
						return
					}
					(*z).T = eventType(zb0005)
				}
			case "Input":
				bts, err = (*z).Input.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Input")
					return
				}
			case "Err":
				if msgp.IsNil(bts) {
					bts, err = msgp.ReadNilBytes(bts)
					if err != nil {
						return
					}
					(*z).Err = nil
				} else {
					if (*z).Err == nil {
						(*z).Err = new(serializableError)
					}
					{
						var zb0006 string
						zb0006, bts, err = msgp.ReadStringBytes(bts)
						if err != nil {
							err = msgp.WrapError(err, "Err")
							return
						}
						*(*z).Err = serializableError(zb0006)
					}
				}
			case "TaskIndex":
				(*z).TaskIndex, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "TaskIndex")
					return
				}
			case "Tail":
				if msgp.IsNil(bts) {
					bts, err = msgp.ReadNilBytes(bts)
					if err != nil {
						return
					}
					(*z).Tail = nil
				} else {
					if (*z).Tail == nil {
						(*z).Tail = new(messageEvent)
					}
					bts, err = (*z).Tail.UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "Tail")
						return
					}
				}
			case "Cancelled":
				(*z).Cancelled, bts, err = msgp.ReadBoolBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Cancelled")
					return
				}
			case "Proto":
				bts, err = (*z).Proto.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Proto")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *messageEvent) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *messageEvent) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*messageEvent)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *messageEvent) Msgsize() (s int) {
	s = 1 + 2 + msgp.Uint8Size + 6 + (*z).Input.Msgsize() + 4
	if (*z).Err == nil {
		s += msgp.NilSize
	} else {
		s += msgp.StringPrefixSize + len(string(*(*z).Err))
	}
	s += 10 + msgp.Uint64Size + 5
	if (*z).Tail == nil {
		s += msgp.NilSize
	} else {
		s += (*z).Tail.Msgsize()
	}
	s += 10 + msgp.BoolSize + 6 + (*z).Proto.Msgsize()
	return
}

// MsgIsZero returns whether this is a zero value
func (z *messageEvent) MsgIsZero() bool {
	return ((*z).T == 0) && ((*z).Input.MsgIsZero()) && ((*z).Err == nil) && ((*z).TaskIndex == 0) && ((*z).Tail == nil) && ((*z).Cancelled == false) && ((*z).Proto.MsgIsZero())
}

// MaxSize returns a maximum valid message size for this message type
func MessageEventMaxSize() (s int) {
	s = 1 + 2 + msgp.Uint8Size + 6 + MessageMaxSize() + 4
	panic("Unable to determine max size: String type string(*z.Err) is unbounded")
}

// MarshalMsg implements msgp.Marshaler
func (z *nextThresholdStatusEvent) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 2
	// string "Bottom"
	o = append(o, 0x82, 0xa6, 0x42, 0x6f, 0x74, 0x74, 0x6f, 0x6d)
	o = msgp.AppendBool(o, (*z).Bottom)
	// string "Proposal"
	o = append(o, 0xa8, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c)
	o = (*z).Proposal.MarshalMsg(o)
	return
}

func (_ *nextThresholdStatusEvent) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*nextThresholdStatusEvent)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *nextThresholdStatusEvent) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0001 int
	var zb0002 bool
	zb0001, zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0001, zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0001 > 0 {
			zb0001--
			(*z).Bottom, bts, err = msgp.ReadBoolBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Bottom")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).Proposal.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Proposal")
				return
			}
		}
		if zb0001 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0001)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 {
			(*z) = nextThresholdStatusEvent{}
		}
		for zb0001 > 0 {
			zb0001--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "Bottom":
				(*z).Bottom, bts, err = msgp.ReadBoolBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Bottom")
					return
				}
			case "Proposal":
				bts, err = (*z).Proposal.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Proposal")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *nextThresholdStatusEvent) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *nextThresholdStatusEvent) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*nextThresholdStatusEvent)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *nextThresholdStatusEvent) Msgsize() (s int) {
	s = 1 + 7 + msgp.BoolSize + 9 + (*z).Proposal.Msgsize()
	return
}

// MsgIsZero returns whether this is a zero value
func (z *nextThresholdStatusEvent) MsgIsZero() bool {
	return ((*z).Bottom == false) && ((*z).Proposal.MsgIsZero())
}

// MaxSize returns a maximum valid message size for this message type
func NextThresholdStatusEventMaxSize() (s int) {
	s = 1 + 7 + msgp.BoolSize + 9 + ProposalValueMaxSize()
	return
}

// MarshalMsg implements msgp.Marshaler
func (z period) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	o = msgp.AppendUint64(o, uint64(z))
	return
}

func (_ period) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(period)
	if !ok {
		_, ok = (z).(*period)
	}
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *period) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	{
		var zb0001 uint64
		zb0001, bts, err = msgp.ReadUint64Bytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		(*z) = period(zb0001)
	}
	o = bts
	return
}

func (z *period) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *period) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*period)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z period) Msgsize() (s int) {
	s = msgp.Uint64Size
	return
}

// MsgIsZero returns whether this is a zero value
func (z period) MsgIsZero() bool {
	return z == 0
}

// MaxSize returns a maximum valid message size for this message type
func PeriodMaxSize() (s int) {
	s = msgp.Uint64Size
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *periodRouter) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 4
	// string "Children"
	o = append(o, 0x84, 0xa8, 0x43, 0x68, 0x69, 0x6c, 0x64, 0x72, 0x65, 0x6e)
	if (*z).Children == nil {
		o = msgp.AppendNil(o)
	} else {
		o = msgp.AppendMapHeader(o, uint32(len((*z).Children)))
	}
	zb0001_keys := make([]step, 0, len((*z).Children))
	for zb0001 := range (*z).Children {
		zb0001_keys = append(zb0001_keys, zb0001)
	}
	sort.Sort(SortStep(zb0001_keys))
	for _, zb0001 := range zb0001_keys {
		zb0002 := (*z).Children[zb0001]
		_ = zb0002
		o = zb0001.MarshalMsg(o)
		if zb0002 == nil {
			o = msgp.AppendNil(o)
		} else {
			o = zb0002.MarshalMsg(o)
		}
	}
	// string "ProposalTracker"
	o = append(o, 0xaf, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x65, 0x72)
	o = (*z).ProposalTracker.MarshalMsg(o)
	// string "ProposalTrackerContract"
	o = append(o, 0xb7, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x61, 0x63, 0x74)
	o = (*z).ProposalTrackerContract.MarshalMsg(o)
	// string "VoteTrackerPeriod"
	o = append(o, 0xb1, 0x56, 0x6f, 0x74, 0x65, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x65, 0x72, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64)
	o = (*z).VoteTrackerPeriod.MarshalMsg(o)
	return
}

func (_ *periodRouter) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*periodRouter)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *periodRouter) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0003 int
	var zb0004 bool
	zb0003, zb0004, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0003, zb0004, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0003 > 0 {
			zb0003--
			bts, err = (*z).ProposalTracker.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "ProposalTracker")
				return
			}
		}
		if zb0003 > 0 {
			zb0003--
			bts, err = (*z).VoteTrackerPeriod.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "VoteTrackerPeriod")
				return
			}
		}
		if zb0003 > 0 {
			zb0003--
			bts, err = (*z).ProposalTrackerContract.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "ProposalTrackerContract")
				return
			}
		}
		if zb0003 > 0 {
			zb0003--
			var zb0005 int
			var zb0006 bool
			zb0005, zb0006, bts, err = msgp.ReadMapHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Children")
				return
			}
			if zb0006 {
				(*z).Children = nil
			} else if (*z).Children == nil {
				(*z).Children = make(map[step]*stepRouter, zb0005)
			}
			for zb0005 > 0 {
				var zb0001 step
				var zb0002 *stepRouter
				zb0005--
				bts, err = zb0001.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Children")
					return
				}
				if msgp.IsNil(bts) {
					bts, err = msgp.ReadNilBytes(bts)
					if err != nil {
						return
					}
					zb0002 = nil
				} else {
					if zb0002 == nil {
						zb0002 = new(stepRouter)
					}
					bts, err = zb0002.UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "Children", zb0001)
						return
					}
				}
				(*z).Children[zb0001] = zb0002
			}
		}
		if zb0003 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0003)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0004 {
			(*z) = periodRouter{}
		}
		for zb0003 > 0 {
			zb0003--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "ProposalTracker":
				bts, err = (*z).ProposalTracker.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "ProposalTracker")
					return
				}
			case "VoteTrackerPeriod":
				bts, err = (*z).VoteTrackerPeriod.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "VoteTrackerPeriod")
					return
				}
			case "ProposalTrackerContract":
				bts, err = (*z).ProposalTrackerContract.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "ProposalTrackerContract")
					return
				}
			case "Children":
				var zb0007 int
				var zb0008 bool
				zb0007, zb0008, bts, err = msgp.ReadMapHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Children")
					return
				}
				if zb0008 {
					(*z).Children = nil
				} else if (*z).Children == nil {
					(*z).Children = make(map[step]*stepRouter, zb0007)
				}
				for zb0007 > 0 {
					var zb0001 step
					var zb0002 *stepRouter
					zb0007--
					bts, err = zb0001.UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "Children")
						return
					}
					if msgp.IsNil(bts) {
						bts, err = msgp.ReadNilBytes(bts)
						if err != nil {
							return
						}
						zb0002 = nil
					} else {
						if zb0002 == nil {
							zb0002 = new(stepRouter)
						}
						bts, err = zb0002.UnmarshalMsgWithState(bts, st)
						if err != nil {
							err = msgp.WrapError(err, "Children", zb0001)
							return
						}
					}
					(*z).Children[zb0001] = zb0002
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *periodRouter) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *periodRouter) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*periodRouter)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *periodRouter) Msgsize() (s int) {
	s = 1 + 16 + (*z).ProposalTracker.Msgsize() + 18 + (*z).VoteTrackerPeriod.Msgsize() + 24 + (*z).ProposalTrackerContract.Msgsize() + 9 + msgp.MapHeaderSize
	if (*z).Children != nil {
		for zb0001, zb0002 := range (*z).Children {
			_ = zb0001
			_ = zb0002
			s += 0 + zb0001.Msgsize()
			if zb0002 == nil {
				s += msgp.NilSize
			} else {
				s += zb0002.Msgsize()
			}
		}
	}
	return
}

// MsgIsZero returns whether this is a zero value
func (z *periodRouter) MsgIsZero() bool {
	return ((*z).ProposalTracker.MsgIsZero()) && ((*z).VoteTrackerPeriod.MsgIsZero()) && ((*z).ProposalTrackerContract.MsgIsZero()) && (len((*z).Children) == 0)
}

// MaxSize returns a maximum valid message size for this message type
func PeriodRouterMaxSize() (s int) {
	s = 1 + 16 + ProposalTrackerMaxSize() + 18 + VoteTrackerPeriodMaxSize() + 24 + ProposalTrackerContractMaxSize() + 9
	s += msgp.MapHeaderSize
	panic("Map z.Children is unbounded")
}

// MarshalMsg implements msgp.Marshaler
func (z *player) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0001Len := uint32(9)
	var zb0001Mask uint16 /* 12 bits */
	if (*z).OldDeadline == 0 {
		zb0001Len--
		zb0001Mask |= 0x1
	}
	// variable map header, size zb0001Len
	o = append(o, 0x80|uint8(zb0001Len))
	if zb0001Len != 0 {
		if (zb0001Mask & 0x1) == 0 { // if not empty
			// string "Deadline"
			o = append(o, 0xa8, 0x44, 0x65, 0x61, 0x64, 0x6c, 0x69, 0x6e, 0x65)
			o = msgp.AppendDuration(o, (*z).OldDeadline)
		}
		// string "FastRecoveryDeadline"
		o = append(o, 0xb4, 0x46, 0x61, 0x73, 0x74, 0x52, 0x65, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x44, 0x65, 0x61, 0x64, 0x6c, 0x69, 0x6e, 0x65)
		o = msgp.AppendDuration(o, (*z).FastRecoveryDeadline)
		// string "LastConcluding"
		o = append(o, 0xae, 0x4c, 0x61, 0x73, 0x74, 0x43, 0x6f, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x69, 0x6e, 0x67)
		o = msgp.AppendUint64(o, uint64((*z).LastConcluding))
		// string "Napping"
		o = append(o, 0xa7, 0x4e, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67)
		o = msgp.AppendBool(o, (*z).Napping)
		// string "Pending"
		o = append(o, 0xa7, 0x50, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67)
		o = (*z).Pending.MarshalMsg(o)
		// string "Period"
		o = append(o, 0xa6, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64)
		o = msgp.AppendUint64(o, uint64((*z).Period))
		// string "Round"
		o = append(o, 0xa5, 0x52, 0x6f, 0x75, 0x6e, 0x64)
		o = (*z).Round.MarshalMsg(o)
		// string "Step"
		o = append(o, 0xa4, 0x53, 0x74, 0x65, 0x70)
		o = msgp.AppendUint64(o, uint64((*z).Step))
		// string "TimersDeadline"
		o = append(o, 0xae, 0x54, 0x69, 0x6d, 0x65, 0x72, 0x73, 0x44, 0x65, 0x61, 0x64, 0x6c, 0x69, 0x6e, 0x65)
		o = (*z).Deadline.MarshalMsg(o)
	}
	return
}

func (_ *player) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*player)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *player) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0001 int
	var zb0002 bool
	zb0001, zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0001, zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).Round.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Round")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			{
				var zb0003 uint64
				zb0003, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Period")
					return
				}
				(*z).Period = period(zb0003)
			}
		}
		if zb0001 > 0 {
			zb0001--
			{
				var zb0004 uint64
				zb0004, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Step")
					return
				}
				(*z).Step = step(zb0004)
			}
		}
		if zb0001 > 0 {
			zb0001--
			{
				var zb0005 uint64
				zb0005, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "LastConcluding")
					return
				}
				(*z).LastConcluding = step(zb0005)
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).Deadline.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Deadline")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			(*z).OldDeadline, bts, err = msgp.ReadDurationBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "OldDeadline")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			(*z).Napping, bts, err = msgp.ReadBoolBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Napping")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			(*z).FastRecoveryDeadline, bts, err = msgp.ReadDurationBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "FastRecoveryDeadline")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).Pending.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Pending")
				return
			}
		}
		if zb0001 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0001)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 {
			(*z) = player{}
		}
		for zb0001 > 0 {
			zb0001--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "Round":
				bts, err = (*z).Round.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Round")
					return
				}
			case "Period":
				{
					var zb0006 uint64
					zb0006, bts, err = msgp.ReadUint64Bytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "Period")
						return
					}
					(*z).Period = period(zb0006)
				}
			case "Step":
				{
					var zb0007 uint64
					zb0007, bts, err = msgp.ReadUint64Bytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "Step")
						return
					}
					(*z).Step = step(zb0007)
				}
			case "LastConcluding":
				{
					var zb0008 uint64
					zb0008, bts, err = msgp.ReadUint64Bytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "LastConcluding")
						return
					}
					(*z).LastConcluding = step(zb0008)
				}
			case "TimersDeadline":
				bts, err = (*z).Deadline.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Deadline")
					return
				}
			case "Deadline":
				(*z).OldDeadline, bts, err = msgp.ReadDurationBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "OldDeadline")
					return
				}
			case "Napping":
				(*z).Napping, bts, err = msgp.ReadBoolBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Napping")
					return
				}
			case "FastRecoveryDeadline":
				(*z).FastRecoveryDeadline, bts, err = msgp.ReadDurationBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "FastRecoveryDeadline")
					return
				}
			case "Pending":
				bts, err = (*z).Pending.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Pending")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *player) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *player) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*player)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *player) Msgsize() (s int) {
	s = 1 + 6 + (*z).Round.Msgsize() + 7 + msgp.Uint64Size + 5 + msgp.Uint64Size + 15 + msgp.Uint64Size + 15 + (*z).Deadline.Msgsize() + 9 + msgp.DurationSize + 8 + msgp.BoolSize + 21 + msgp.DurationSize + 8 + (*z).Pending.Msgsize()
	return
}

// MsgIsZero returns whether this is a zero value
func (z *player) MsgIsZero() bool {
	return ((*z).Round.MsgIsZero()) && ((*z).Period == 0) && ((*z).Step == 0) && ((*z).LastConcluding == 0) && ((*z).Deadline.MsgIsZero()) && ((*z).OldDeadline == 0) && ((*z).Napping == false) && ((*z).FastRecoveryDeadline == 0) && ((*z).Pending.MsgIsZero())
}

// MaxSize returns a maximum valid message size for this message type
func PlayerMaxSize() (s int) {
	s = 1 + 6 + basics.RoundMaxSize() + 7 + msgp.Uint64Size + 5 + msgp.Uint64Size + 15 + msgp.Uint64Size + 15 + DeadlineMaxSize() + 9 + msgp.DurationSize + 8 + msgp.BoolSize + 21 + msgp.DurationSize + 8 + ProposalTableMaxSize()
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *proposal) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0005Len := uint32(36)
	var zb0005Mask uint64 /* 45 bits */
	if (*z).unauthenticatedProposal.Block.BlockHeader.Bonus.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x40
	}
	if (*z).unauthenticatedProposal.Block.BlockHeader.RewardsState.RewardsLevel == 0 {
		zb0005Len--
		zb0005Mask |= 0x80
	}
	if (*z).unauthenticatedProposal.Block.BlockHeader.FeesCollected.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x100
	}
	if (*z).unauthenticatedProposal.Block.BlockHeader.RewardsState.FeeSink.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x200
	}
	if (*z).unauthenticatedProposal.Block.BlockHeader.RewardsState.RewardsResidue == 0 {
		zb0005Len--
		zb0005Mask |= 0x400
	}
	if (*z).unauthenticatedProposal.Block.BlockHeader.GenesisID == "" {
		zb0005Len--
		zb0005Mask |= 0x800
	}
	if (*z).unauthenticatedProposal.Block.BlockHeader.GenesisHash.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x1000
	}
	if (*z).unauthenticatedProposal.Block.BlockHeader.UpgradeState.NextProtocolVoteBefore.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x2000
	}
	if (*z).unauthenticatedProposal.Block.BlockHeader.UpgradeState.NextProtocol.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x4000
	}
	if (*z).unauthenticatedProposal.Block.BlockHeader.UpgradeState.NextProtocolSwitchOn.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x8000
	}
	if (*z).unauthenticatedProposal.Block.BlockHeader.UpgradeState.NextProtocolApprovals.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x10000
	}
	if (*z).unauthenticatedProposal.OriginalPeriod == 0 {
		zb0005Len--
		zb0005Mask |= 0x20000
	}
	if (*z).unauthenticatedProposal.OriginalProposer.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x40000
	}
	if len((*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.AbsentParticipationAccounts) == 0 {
		zb0005Len--
		zb0005Mask |= 0x80000
	}
	if len((*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts) == 0 {
		zb0005Len--
		zb0005Mask |= 0x100000
	}
	if (*z).unauthenticatedProposal.Block.BlockHeader.ProposerPayout.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x200000
	}
	if (*z).unauthenticatedProposal.Block.BlockHeader.Branch.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x400000
	}
	if (*z).unauthenticatedProposal.Block.BlockHeader.Branch512.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x800000
	}
	if (*z).unauthenticatedProposal.Block.BlockHeader.UpgradeState.CurrentProtocol.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x1000000
	}
	if (*z).unauthenticatedProposal.Block.BlockHeader.Proposer.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x2000000
	}
	if (*z).unauthenticatedProposal.Block.BlockHeader.RewardsState.RewardsRate == 0 {
		zb0005Len--
		zb0005Mask |= 0x4000000
	}
	if (*z).unauthenticatedProposal.Block.BlockHeader.Round.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x10000000
	}
	if (*z).unauthenticatedProposal.Block.BlockHeader.RewardsState.RewardsRecalculationRound.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x20000000
	}
	if (*z).unauthenticatedProposal.Block.BlockHeader.RewardsState.RewardsPool.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x40000000
	}
	if (*z).unauthenticatedProposal.SeedProof.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x80000000
	}
	if (*z).unauthenticatedProposal.Block.BlockHeader.Seed.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x100000000
	}
	if len((*z).unauthenticatedProposal.Block.BlockHeader.StateProofTracking) == 0 {
		zb0005Len--
		zb0005Mask |= 0x200000000
	}
	if (*z).unauthenticatedProposal.Block.BlockHeader.TxnCounter == 0 {
		zb0005Len--
		zb0005Mask |= 0x400000000
	}
	if (*z).unauthenticatedProposal.Block.BlockHeader.TimeStamp == 0 {
		zb0005Len--
		zb0005Mask |= 0x800000000
	}
	if (*z).unauthenticatedProposal.Block.BlockHeader.TxnCommitments.NativeSha512_256Commitment.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x1000000000
	}
	if (*z).unauthenticatedProposal.Block.BlockHeader.TxnCommitments.Sha256Commitment.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x2000000000
	}
	if (*z).unauthenticatedProposal.Block.BlockHeader.TxnCommitments.Sha512Commitment.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x4000000000
	}
	if (*z).unauthenticatedProposal.Block.Payset.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x8000000000
	}
	if (*z).unauthenticatedProposal.Block.BlockHeader.UpgradeVote.UpgradeDelay.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x10000000000
	}
	if (*z).unauthenticatedProposal.Block.BlockHeader.UpgradeVote.UpgradePropose.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x20000000000
	}
	if (*z).unauthenticatedProposal.Block.BlockHeader.UpgradeVote.UpgradeApprove == false {
		zb0005Len--
		zb0005Mask |= 0x40000000000
	}
	// variable map header, size zb0005Len
	o = msgp.AppendMapHeader(o, zb0005Len)
	if zb0005Len != 0 {
		if (zb0005Mask & 0x40) == 0 { // if not empty
			// string "bi"
			o = append(o, 0xa2, 0x62, 0x69)
			o = (*z).unauthenticatedProposal.Block.BlockHeader.Bonus.MarshalMsg(o)
		}
		if (zb0005Mask & 0x80) == 0 { // if not empty
			// string "earn"
			o = append(o, 0xa4, 0x65, 0x61, 0x72, 0x6e)
			o = msgp.AppendUint64(o, (*z).unauthenticatedProposal.Block.BlockHeader.RewardsState.RewardsLevel)
		}
		if (zb0005Mask & 0x100) == 0 { // if not empty
			// string "fc"
			o = append(o, 0xa2, 0x66, 0x63)
			o = (*z).unauthenticatedProposal.Block.BlockHeader.FeesCollected.MarshalMsg(o)
		}
		if (zb0005Mask & 0x200) == 0 { // if not empty
			// string "fees"
			o = append(o, 0xa4, 0x66, 0x65, 0x65, 0x73)
			o = (*z).unauthenticatedProposal.Block.BlockHeader.RewardsState.FeeSink.MarshalMsg(o)
		}
		if (zb0005Mask & 0x400) == 0 { // if not empty
			// string "frac"
			o = append(o, 0xa4, 0x66, 0x72, 0x61, 0x63)
			o = msgp.AppendUint64(o, (*z).unauthenticatedProposal.Block.BlockHeader.RewardsState.RewardsResidue)
		}
		if (zb0005Mask & 0x800) == 0 { // if not empty
			// string "gen"
			o = append(o, 0xa3, 0x67, 0x65, 0x6e)
			o = msgp.AppendString(o, (*z).unauthenticatedProposal.Block.BlockHeader.GenesisID)
		}
		if (zb0005Mask & 0x1000) == 0 { // if not empty
			// string "gh"
			o = append(o, 0xa2, 0x67, 0x68)
			o = (*z).unauthenticatedProposal.Block.BlockHeader.GenesisHash.MarshalMsg(o)
		}
		if (zb0005Mask & 0x2000) == 0 { // if not empty
			// string "nextbefore"
			o = append(o, 0xaa, 0x6e, 0x65, 0x78, 0x74, 0x62, 0x65, 0x66, 0x6f, 0x72, 0x65)
			o = (*z).unauthenticatedProposal.Block.BlockHeader.UpgradeState.NextProtocolVoteBefore.MarshalMsg(o)
		}
		if (zb0005Mask & 0x4000) == 0 { // if not empty
			// string "nextproto"
			o = append(o, 0xa9, 0x6e, 0x65, 0x78, 0x74, 0x70, 0x72, 0x6f, 0x74, 0x6f)
			o = (*z).unauthenticatedProposal.Block.BlockHeader.UpgradeState.NextProtocol.MarshalMsg(o)
		}
		if (zb0005Mask & 0x8000) == 0 { // if not empty
			// string "nextswitch"
			o = append(o, 0xaa, 0x6e, 0x65, 0x78, 0x74, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68)
			o = (*z).unauthenticatedProposal.Block.BlockHeader.UpgradeState.NextProtocolSwitchOn.MarshalMsg(o)
		}
		if (zb0005Mask & 0x10000) == 0 { // if not empty
			// string "nextyes"
			o = append(o, 0xa7, 0x6e, 0x65, 0x78, 0x74, 0x79, 0x65, 0x73)
			o = (*z).unauthenticatedProposal.Block.BlockHeader.UpgradeState.NextProtocolApprovals.MarshalMsg(o)
		}
		if (zb0005Mask & 0x20000) == 0 { // if not empty
			// string "oper"
			o = append(o, 0xa4, 0x6f, 0x70, 0x65, 0x72)
			o = msgp.AppendUint64(o, uint64((*z).unauthenticatedProposal.OriginalPeriod))
		}
		if (zb0005Mask & 0x40000) == 0 { // if not empty
			// string "oprop"
			o = append(o, 0xa5, 0x6f, 0x70, 0x72, 0x6f, 0x70)
			o = (*z).unauthenticatedProposal.OriginalProposer.MarshalMsg(o)
		}
		if (zb0005Mask & 0x80000) == 0 { // if not empty
			// string "partupdabs"
			o = append(o, 0xaa, 0x70, 0x61, 0x72, 0x74, 0x75, 0x70, 0x64, 0x61, 0x62, 0x73)
			if (*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.AbsentParticipationAccounts == nil {
				o = msgp.AppendNil(o)
			} else {
				o = msgp.AppendArrayHeader(o, uint32(len((*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.AbsentParticipationAccounts)))
			}
			for zb0004 := range (*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.AbsentParticipationAccounts {
				o = (*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.AbsentParticipationAccounts[zb0004].MarshalMsg(o)
			}
		}
		if (zb0005Mask & 0x100000) == 0 { // if not empty
			// string "partupdrmv"
			o = append(o, 0xaa, 0x70, 0x61, 0x72, 0x74, 0x75, 0x70, 0x64, 0x72, 0x6d, 0x76)
			if (*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts == nil {
				o = msgp.AppendNil(o)
			} else {
				o = msgp.AppendArrayHeader(o, uint32(len((*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts)))
			}
			for zb0003 := range (*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts {
				o = (*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts[zb0003].MarshalMsg(o)
			}
		}
		if (zb0005Mask & 0x200000) == 0 { // if not empty
			// string "pp"
			o = append(o, 0xa2, 0x70, 0x70)
			o = (*z).unauthenticatedProposal.Block.BlockHeader.ProposerPayout.MarshalMsg(o)
		}
		if (zb0005Mask & 0x400000) == 0 { // if not empty
			// string "prev"
			o = append(o, 0xa4, 0x70, 0x72, 0x65, 0x76)
			o = (*z).unauthenticatedProposal.Block.BlockHeader.Branch.MarshalMsg(o)
		}
		if (zb0005Mask & 0x800000) == 0 { // if not empty
			// string "prev512"
			o = append(o, 0xa7, 0x70, 0x72, 0x65, 0x76, 0x35, 0x31, 0x32)
			o = (*z).unauthenticatedProposal.Block.BlockHeader.Branch512.MarshalMsg(o)
		}
		if (zb0005Mask & 0x1000000) == 0 { // if not empty
			// string "proto"
			o = append(o, 0xa5, 0x70, 0x72, 0x6f, 0x74, 0x6f)
			o = (*z).unauthenticatedProposal.Block.BlockHeader.UpgradeState.CurrentProtocol.MarshalMsg(o)
		}
		if (zb0005Mask & 0x2000000) == 0 { // if not empty
			// string "prp"
			o = append(o, 0xa3, 0x70, 0x72, 0x70)
			o = (*z).unauthenticatedProposal.Block.BlockHeader.Proposer.MarshalMsg(o)
		}
		if (zb0005Mask & 0x4000000) == 0 { // if not empty
			// string "rate"
			o = append(o, 0xa4, 0x72, 0x61, 0x74, 0x65)
			o = msgp.AppendUint64(o, (*z).unauthenticatedProposal.Block.BlockHeader.RewardsState.RewardsRate)
		}
		if (zb0005Mask & 0x10000000) == 0 { // if not empty
			// string "rnd"
			o = append(o, 0xa3, 0x72, 0x6e, 0x64)
			o = (*z).unauthenticatedProposal.Block.BlockHeader.Round.MarshalMsg(o)
		}
		if (zb0005Mask & 0x20000000) == 0 { // if not empty
			// string "rwcalr"
			o = append(o, 0xa6, 0x72, 0x77, 0x63, 0x61, 0x6c, 0x72)
			o = (*z).unauthenticatedProposal.Block.BlockHeader.RewardsState.RewardsRecalculationRound.MarshalMsg(o)
		}
		if (zb0005Mask & 0x40000000) == 0 { // if not empty
			// string "rwd"
			o = append(o, 0xa3, 0x72, 0x77, 0x64)
			o = (*z).unauthenticatedProposal.Block.BlockHeader.RewardsState.RewardsPool.MarshalMsg(o)
		}
		if (zb0005Mask & 0x80000000) == 0 { // if not empty
			// string "sdpf"
			o = append(o, 0xa4, 0x73, 0x64, 0x70, 0x66)
			o = (*z).unauthenticatedProposal.SeedProof.MarshalMsg(o)
		}
		if (zb0005Mask & 0x100000000) == 0 { // if not empty
			// string "seed"
			o = append(o, 0xa4, 0x73, 0x65, 0x65, 0x64)
			o = (*z).unauthenticatedProposal.Block.BlockHeader.Seed.MarshalMsg(o)
		}
		if (zb0005Mask & 0x200000000) == 0 { // if not empty
			// string "spt"
			o = append(o, 0xa3, 0x73, 0x70, 0x74)
			if (*z).unauthenticatedProposal.Block.BlockHeader.StateProofTracking == nil {
				o = msgp.AppendNil(o)
			} else {
				o = msgp.AppendMapHeader(o, uint32(len((*z).unauthenticatedProposal.Block.BlockHeader.StateProofTracking)))
			}
			zb0001_keys := make([]protocol.StateProofType, 0, len((*z).unauthenticatedProposal.Block.BlockHeader.StateProofTracking))
			for zb0001 := range (*z).unauthenticatedProposal.Block.BlockHeader.StateProofTracking {
				zb0001_keys = append(zb0001_keys, zb0001)
			}
			sort.Sort(protocol.SortStateProofType(zb0001_keys))
			for _, zb0001 := range zb0001_keys {
				zb0002 := (*z).unauthenticatedProposal.Block.BlockHeader.StateProofTracking[zb0001]
				_ = zb0002
				o = zb0001.MarshalMsg(o)
				o = zb0002.MarshalMsg(o)
			}
		}
		if (zb0005Mask & 0x400000000) == 0 { // if not empty
			// string "tc"
			o = append(o, 0xa2, 0x74, 0x63)
			o = msgp.AppendUint64(o, (*z).unauthenticatedProposal.Block.BlockHeader.TxnCounter)
		}
		if (zb0005Mask & 0x800000000) == 0 { // if not empty
			// string "ts"
			o = append(o, 0xa2, 0x74, 0x73)
			o = msgp.AppendInt64(o, (*z).unauthenticatedProposal.Block.BlockHeader.TimeStamp)
		}
		if (zb0005Mask & 0x1000000000) == 0 { // if not empty
			// string "txn"
			o = append(o, 0xa3, 0x74, 0x78, 0x6e)
			o = (*z).unauthenticatedProposal.Block.BlockHeader.TxnCommitments.NativeSha512_256Commitment.MarshalMsg(o)
		}
		if (zb0005Mask & 0x2000000000) == 0 { // if not empty
			// string "txn256"
			o = append(o, 0xa6, 0x74, 0x78, 0x6e, 0x32, 0x35, 0x36)
			o = (*z).unauthenticatedProposal.Block.BlockHeader.TxnCommitments.Sha256Commitment.MarshalMsg(o)
		}
		if (zb0005Mask & 0x4000000000) == 0 { // if not empty
			// string "txn512"
			o = append(o, 0xa6, 0x74, 0x78, 0x6e, 0x35, 0x31, 0x32)
			o = (*z).unauthenticatedProposal.Block.BlockHeader.TxnCommitments.Sha512Commitment.MarshalMsg(o)
		}
		if (zb0005Mask & 0x8000000000) == 0 { // if not empty
			// string "txns"
			o = append(o, 0xa4, 0x74, 0x78, 0x6e, 0x73)
			o = (*z).unauthenticatedProposal.Block.Payset.MarshalMsg(o)
		}
		if (zb0005Mask & 0x10000000000) == 0 { // if not empty
			// string "upgradedelay"
			o = append(o, 0xac, 0x75, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x64, 0x65, 0x6c, 0x61, 0x79)
			o = (*z).unauthenticatedProposal.Block.BlockHeader.UpgradeVote.UpgradeDelay.MarshalMsg(o)
		}
		if (zb0005Mask & 0x20000000000) == 0 { // if not empty
			// string "upgradeprop"
			o = append(o, 0xab, 0x75, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x70, 0x72, 0x6f, 0x70)
			o = (*z).unauthenticatedProposal.Block.BlockHeader.UpgradeVote.UpgradePropose.MarshalMsg(o)
		}
		if (zb0005Mask & 0x40000000000) == 0 { // if not empty
			// string "upgradeyes"
			o = append(o, 0xaa, 0x75, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x79, 0x65, 0x73)
			o = msgp.AppendBool(o, (*z).unauthenticatedProposal.Block.BlockHeader.UpgradeVote.UpgradeApprove)
		}
	}
	return
}

func (_ *proposal) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*proposal)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *proposal) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0005 int
	var zb0006 bool
	zb0005, zb0006, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0005, zb0006, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.Round.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Round")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.Branch.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Branch")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.Branch512.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Branch512")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.Seed.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Seed")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.TxnCommitments.NativeSha512_256Commitment.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "NativeSha512_256Commitment")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.TxnCommitments.Sha256Commitment.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Sha256Commitment")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.TxnCommitments.Sha512Commitment.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Sha512Commitment")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			(*z).unauthenticatedProposal.Block.BlockHeader.TimeStamp, bts, err = msgp.ReadInt64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "TimeStamp")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			var zb0007 int
			zb0007, err = msgp.ReadBytesBytesHeader(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "GenesisID")
				return
			}
			if zb0007 > bounds.MaxGenesisIDLen {
				err = msgp.ErrOverflow(uint64(zb0007), uint64(bounds.MaxGenesisIDLen))
				return
			}
			(*z).unauthenticatedProposal.Block.BlockHeader.GenesisID, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "GenesisID")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.GenesisHash.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "GenesisHash")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.Proposer.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Proposer")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.FeesCollected.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "FeesCollected")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.Bonus.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Bonus")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.ProposerPayout.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "ProposerPayout")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.RewardsState.FeeSink.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "FeeSink")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.RewardsState.RewardsPool.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "RewardsPool")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			(*z).unauthenticatedProposal.Block.BlockHeader.RewardsState.RewardsLevel, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "RewardsLevel")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			(*z).unauthenticatedProposal.Block.BlockHeader.RewardsState.RewardsRate, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "RewardsRate")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			(*z).unauthenticatedProposal.Block.BlockHeader.RewardsState.RewardsResidue, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "RewardsResidue")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.RewardsState.RewardsRecalculationRound.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "RewardsRecalculationRound")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.UpgradeState.CurrentProtocol.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "CurrentProtocol")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.UpgradeState.NextProtocol.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "NextProtocol")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.UpgradeState.NextProtocolApprovals.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "NextProtocolApprovals")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.UpgradeState.NextProtocolVoteBefore.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "NextProtocolVoteBefore")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.UpgradeState.NextProtocolSwitchOn.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "NextProtocolSwitchOn")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.UpgradeVote.UpgradePropose.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "UpgradePropose")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.UpgradeVote.UpgradeDelay.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "UpgradeDelay")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			(*z).unauthenticatedProposal.Block.BlockHeader.UpgradeVote.UpgradeApprove, bts, err = msgp.ReadBoolBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "UpgradeApprove")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			(*z).unauthenticatedProposal.Block.BlockHeader.TxnCounter, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "TxnCounter")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			var zb0008 int
			var zb0009 bool
			zb0008, zb0009, bts, err = msgp.ReadMapHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "StateProofTracking")
				return
			}
			if zb0008 > protocol.NumStateProofTypes {
				err = msgp.ErrOverflow(uint64(zb0008), uint64(protocol.NumStateProofTypes))
				err = msgp.WrapError(err, "struct-from-array", "StateProofTracking")
				return
			}
			if zb0009 {
				(*z).unauthenticatedProposal.Block.BlockHeader.StateProofTracking = nil
			} else if (*z).unauthenticatedProposal.Block.BlockHeader.StateProofTracking == nil {
				(*z).unauthenticatedProposal.Block.BlockHeader.StateProofTracking = make(map[protocol.StateProofType]bookkeeping.StateProofTrackingData, zb0008)
			}
			for zb0008 > 0 {
				var zb0001 protocol.StateProofType
				var zb0002 bookkeeping.StateProofTrackingData
				zb0008--
				bts, err = zb0001.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "StateProofTracking")
					return
				}
				bts, err = zb0002.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "StateProofTracking", zb0001)
					return
				}
				(*z).unauthenticatedProposal.Block.BlockHeader.StateProofTracking[zb0001] = zb0002
			}
		}
		if zb0005 > 0 {
			zb0005--
			var zb0010 int
			var zb0011 bool
			zb0010, zb0011, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "ExpiredParticipationAccounts")
				return
			}
			if zb0010 > bounds.MaxProposedExpiredOnlineAccounts {
				err = msgp.ErrOverflow(uint64(zb0010), uint64(bounds.MaxProposedExpiredOnlineAccounts))
				err = msgp.WrapError(err, "struct-from-array", "ExpiredParticipationAccounts")
				return
			}
			if zb0011 {
				(*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts = nil
			} else if (*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts != nil && cap((*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts) >= zb0010 {
				(*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts = ((*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts)[:zb0010]
			} else {
				(*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts = make([]basics.Address, zb0010)
			}
			for zb0003 := range (*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts {
				bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts[zb0003].UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "ExpiredParticipationAccounts", zb0003)
					return
				}
			}
		}
		if zb0005 > 0 {
			zb0005--
			var zb0012 int
			var zb0013 bool
			zb0012, zb0013, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "AbsentParticipationAccounts")
				return
			}
			if zb0012 > bounds.MaxMarkAbsent {
				err = msgp.ErrOverflow(uint64(zb0012), uint64(bounds.MaxMarkAbsent))
				err = msgp.WrapError(err, "struct-from-array", "AbsentParticipationAccounts")
				return
			}
			if zb0013 {
				(*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.AbsentParticipationAccounts = nil
			} else if (*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.AbsentParticipationAccounts != nil && cap((*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.AbsentParticipationAccounts) >= zb0012 {
				(*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.AbsentParticipationAccounts = ((*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.AbsentParticipationAccounts)[:zb0012]
			} else {
				(*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.AbsentParticipationAccounts = make([]basics.Address, zb0012)
			}
			for zb0004 := range (*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.AbsentParticipationAccounts {
				bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.AbsentParticipationAccounts[zb0004].UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "AbsentParticipationAccounts", zb0004)
					return
				}
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).unauthenticatedProposal.Block.Payset.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Payset")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).unauthenticatedProposal.SeedProof.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "SeedProof")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			{
				var zb0014 uint64
				zb0014, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "OriginalPeriod")
					return
				}
				(*z).unauthenticatedProposal.OriginalPeriod = period(zb0014)
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).unauthenticatedProposal.OriginalProposer.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "OriginalProposer")
				return
			}
		}
		if zb0005 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0005)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0006 {
			(*z) = proposal{}
		}
		for zb0005 > 0 {
			zb0005--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "rnd":
				bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.Round.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Round")
					return
				}
			case "prev":
				bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.Branch.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Branch")
					return
				}
			case "prev512":
				bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.Branch512.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Branch512")
					return
				}
			case "seed":
				bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.Seed.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Seed")
					return
				}
			case "txn":
				bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.TxnCommitments.NativeSha512_256Commitment.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "NativeSha512_256Commitment")
					return
				}
			case "txn256":
				bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.TxnCommitments.Sha256Commitment.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Sha256Commitment")
					return
				}
			case "txn512":
				bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.TxnCommitments.Sha512Commitment.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Sha512Commitment")
					return
				}
			case "ts":
				(*z).unauthenticatedProposal.Block.BlockHeader.TimeStamp, bts, err = msgp.ReadInt64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "TimeStamp")
					return
				}
			case "gen":
				var zb0015 int
				zb0015, err = msgp.ReadBytesBytesHeader(bts)
				if err != nil {
					err = msgp.WrapError(err, "GenesisID")
					return
				}
				if zb0015 > bounds.MaxGenesisIDLen {
					err = msgp.ErrOverflow(uint64(zb0015), uint64(bounds.MaxGenesisIDLen))
					return
				}
				(*z).unauthenticatedProposal.Block.BlockHeader.GenesisID, bts, err = msgp.ReadStringBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "GenesisID")
					return
				}
			case "gh":
				bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.GenesisHash.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "GenesisHash")
					return
				}
			case "prp":
				bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.Proposer.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Proposer")
					return
				}
			case "fc":
				bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.FeesCollected.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "FeesCollected")
					return
				}
			case "bi":
				bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.Bonus.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Bonus")
					return
				}
			case "pp":
				bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.ProposerPayout.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "ProposerPayout")
					return
				}
			case "fees":
				bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.RewardsState.FeeSink.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "FeeSink")
					return
				}
			case "rwd":
				bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.RewardsState.RewardsPool.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "RewardsPool")
					return
				}
			case "earn":
				(*z).unauthenticatedProposal.Block.BlockHeader.RewardsState.RewardsLevel, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "RewardsLevel")
					return
				}
			case "rate":
				(*z).unauthenticatedProposal.Block.BlockHeader.RewardsState.RewardsRate, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "RewardsRate")
					return
				}
			case "frac":
				(*z).unauthenticatedProposal.Block.BlockHeader.RewardsState.RewardsResidue, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "RewardsResidue")
					return
				}
			case "rwcalr":
				bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.RewardsState.RewardsRecalculationRound.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "RewardsRecalculationRound")
					return
				}
			case "proto":
				bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.UpgradeState.CurrentProtocol.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "CurrentProtocol")
					return
				}
			case "nextproto":
				bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.UpgradeState.NextProtocol.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "NextProtocol")
					return
				}
			case "nextyes":
				bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.UpgradeState.NextProtocolApprovals.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "NextProtocolApprovals")
					return
				}
			case "nextbefore":
				bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.UpgradeState.NextProtocolVoteBefore.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "NextProtocolVoteBefore")
					return
				}
			case "nextswitch":
				bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.UpgradeState.NextProtocolSwitchOn.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "NextProtocolSwitchOn")
					return
				}
			case "upgradeprop":
				bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.UpgradeVote.UpgradePropose.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "UpgradePropose")
					return
				}
			case "upgradedelay":
				bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.UpgradeVote.UpgradeDelay.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "UpgradeDelay")
					return
				}
			case "upgradeyes":
				(*z).unauthenticatedProposal.Block.BlockHeader.UpgradeVote.UpgradeApprove, bts, err = msgp.ReadBoolBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "UpgradeApprove")
					return
				}
			case "tc":
				(*z).unauthenticatedProposal.Block.BlockHeader.TxnCounter, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "TxnCounter")
					return
				}
			case "spt":
				var zb0016 int
				var zb0017 bool
				zb0016, zb0017, bts, err = msgp.ReadMapHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "StateProofTracking")
					return
				}
				if zb0016 > protocol.NumStateProofTypes {
					err = msgp.ErrOverflow(uint64(zb0016), uint64(protocol.NumStateProofTypes))
					err = msgp.WrapError(err, "StateProofTracking")
					return
				}
				if zb0017 {
					(*z).unauthenticatedProposal.Block.BlockHeader.StateProofTracking = nil
				} else if (*z).unauthenticatedProposal.Block.BlockHeader.StateProofTracking == nil {
					(*z).unauthenticatedProposal.Block.BlockHeader.StateProofTracking = make(map[protocol.StateProofType]bookkeeping.StateProofTrackingData, zb0016)
				}
				for zb0016 > 0 {
					var zb0001 protocol.StateProofType
					var zb0002 bookkeeping.StateProofTrackingData
					zb0016--
					bts, err = zb0001.UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "StateProofTracking")
						return
					}
					bts, err = zb0002.UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "StateProofTracking", zb0001)
						return
					}
					(*z).unauthenticatedProposal.Block.BlockHeader.StateProofTracking[zb0001] = zb0002
				}
			case "partupdrmv":
				var zb0018 int
				var zb0019 bool
				zb0018, zb0019, bts, err = msgp.ReadArrayHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "ExpiredParticipationAccounts")
					return
				}
				if zb0018 > bounds.MaxProposedExpiredOnlineAccounts {
					err = msgp.ErrOverflow(uint64(zb0018), uint64(bounds.MaxProposedExpiredOnlineAccounts))
					err = msgp.WrapError(err, "ExpiredParticipationAccounts")
					return
				}
				if zb0019 {
					(*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts = nil
				} else if (*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts != nil && cap((*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts) >= zb0018 {
					(*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts = ((*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts)[:zb0018]
				} else {
					(*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts = make([]basics.Address, zb0018)
				}
				for zb0003 := range (*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts {
					bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts[zb0003].UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "ExpiredParticipationAccounts", zb0003)
						return
					}
				}
			case "partupdabs":
				var zb0020 int
				var zb0021 bool
				zb0020, zb0021, bts, err = msgp.ReadArrayHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "AbsentParticipationAccounts")
					return
				}
				if zb0020 > bounds.MaxMarkAbsent {
					err = msgp.ErrOverflow(uint64(zb0020), uint64(bounds.MaxMarkAbsent))
					err = msgp.WrapError(err, "AbsentParticipationAccounts")
					return
				}
				if zb0021 {
					(*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.AbsentParticipationAccounts = nil
				} else if (*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.AbsentParticipationAccounts != nil && cap((*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.AbsentParticipationAccounts) >= zb0020 {
					(*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.AbsentParticipationAccounts = ((*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.AbsentParticipationAccounts)[:zb0020]
				} else {
					(*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.AbsentParticipationAccounts = make([]basics.Address, zb0020)
				}
				for zb0004 := range (*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.AbsentParticipationAccounts {
					bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.AbsentParticipationAccounts[zb0004].UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "AbsentParticipationAccounts", zb0004)
						return
					}
				}
			case "txns":
				bts, err = (*z).unauthenticatedProposal.Block.Payset.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Payset")
					return
				}
			case "sdpf":
				bts, err = (*z).unauthenticatedProposal.SeedProof.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "SeedProof")
					return
				}
			case "oper":
				{
					var zb0022 uint64
					zb0022, bts, err = msgp.ReadUint64Bytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "OriginalPeriod")
						return
					}
					(*z).unauthenticatedProposal.OriginalPeriod = period(zb0022)
				}
			case "oprop":
				bts, err = (*z).unauthenticatedProposal.OriginalProposer.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "OriginalProposer")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *proposal) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *proposal) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*proposal)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *proposal) Msgsize() (s int) {
	s = 3 + 4 + (*z).unauthenticatedProposal.Block.BlockHeader.Round.Msgsize() + 5 + (*z).unauthenticatedProposal.Block.BlockHeader.Branch.Msgsize() + 8 + (*z).unauthenticatedProposal.Block.BlockHeader.Branch512.Msgsize() + 5 + (*z).unauthenticatedProposal.Block.BlockHeader.Seed.Msgsize() + 4 + (*z).unauthenticatedProposal.Block.BlockHeader.TxnCommitments.NativeSha512_256Commitment.Msgsize() + 7 + (*z).unauthenticatedProposal.Block.BlockHeader.TxnCommitments.Sha256Commitment.Msgsize() + 7 + (*z).unauthenticatedProposal.Block.BlockHeader.TxnCommitments.Sha512Commitment.Msgsize() + 3 + msgp.Int64Size + 4 + msgp.StringPrefixSize + len((*z).unauthenticatedProposal.Block.BlockHeader.GenesisID) + 3 + (*z).unauthenticatedProposal.Block.BlockHeader.GenesisHash.Msgsize() + 4 + (*z).unauthenticatedProposal.Block.BlockHeader.Proposer.Msgsize() + 3 + (*z).unauthenticatedProposal.Block.BlockHeader.FeesCollected.Msgsize() + 3 + (*z).unauthenticatedProposal.Block.BlockHeader.Bonus.Msgsize() + 3 + (*z).unauthenticatedProposal.Block.BlockHeader.ProposerPayout.Msgsize() + 5 + (*z).unauthenticatedProposal.Block.BlockHeader.RewardsState.FeeSink.Msgsize() + 4 + (*z).unauthenticatedProposal.Block.BlockHeader.RewardsState.RewardsPool.Msgsize() + 5 + msgp.Uint64Size + 5 + msgp.Uint64Size + 5 + msgp.Uint64Size + 7 + (*z).unauthenticatedProposal.Block.BlockHeader.RewardsState.RewardsRecalculationRound.Msgsize() + 6 + (*z).unauthenticatedProposal.Block.BlockHeader.UpgradeState.CurrentProtocol.Msgsize() + 10 + (*z).unauthenticatedProposal.Block.BlockHeader.UpgradeState.NextProtocol.Msgsize() + 8 + (*z).unauthenticatedProposal.Block.BlockHeader.UpgradeState.NextProtocolApprovals.Msgsize() + 11 + (*z).unauthenticatedProposal.Block.BlockHeader.UpgradeState.NextProtocolVoteBefore.Msgsize() + 11 + (*z).unauthenticatedProposal.Block.BlockHeader.UpgradeState.NextProtocolSwitchOn.Msgsize() + 12 + (*z).unauthenticatedProposal.Block.BlockHeader.UpgradeVote.UpgradePropose.Msgsize() + 13 + (*z).unauthenticatedProposal.Block.BlockHeader.UpgradeVote.UpgradeDelay.Msgsize() + 11 + msgp.BoolSize + 3 + msgp.Uint64Size + 4 + msgp.MapHeaderSize
	if (*z).unauthenticatedProposal.Block.BlockHeader.StateProofTracking != nil {
		for zb0001, zb0002 := range (*z).unauthenticatedProposal.Block.BlockHeader.StateProofTracking {
			_ = zb0001
			_ = zb0002
			s += 0 + zb0001.Msgsize() + zb0002.Msgsize()
		}
	}
	s += 11 + msgp.ArrayHeaderSize
	for zb0003 := range (*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts {
		s += (*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts[zb0003].Msgsize()
	}
	s += 11 + msgp.ArrayHeaderSize
	for zb0004 := range (*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.AbsentParticipationAccounts {
		s += (*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.AbsentParticipationAccounts[zb0004].Msgsize()
	}
	s += 5 + (*z).unauthenticatedProposal.Block.Payset.Msgsize() + 5 + (*z).unauthenticatedProposal.SeedProof.Msgsize() + 5 + msgp.Uint64Size + 6 + (*z).unauthenticatedProposal.OriginalProposer.Msgsize()
	return
}

// MsgIsZero returns whether this is a zero value
func (z *proposal) MsgIsZero() bool {
	return ((*z).unauthenticatedProposal.Block.BlockHeader.Round.MsgIsZero()) && ((*z).unauthenticatedProposal.Block.BlockHeader.Branch.MsgIsZero()) && ((*z).unauthenticatedProposal.Block.BlockHeader.Branch512.MsgIsZero()) && ((*z).unauthenticatedProposal.Block.BlockHeader.Seed.MsgIsZero()) && ((*z).unauthenticatedProposal.Block.BlockHeader.TxnCommitments.NativeSha512_256Commitment.MsgIsZero()) && ((*z).unauthenticatedProposal.Block.BlockHeader.TxnCommitments.Sha256Commitment.MsgIsZero()) && ((*z).unauthenticatedProposal.Block.BlockHeader.TxnCommitments.Sha512Commitment.MsgIsZero()) && ((*z).unauthenticatedProposal.Block.BlockHeader.TimeStamp == 0) && ((*z).unauthenticatedProposal.Block.BlockHeader.GenesisID == "") && ((*z).unauthenticatedProposal.Block.BlockHeader.GenesisHash.MsgIsZero()) && ((*z).unauthenticatedProposal.Block.BlockHeader.Proposer.MsgIsZero()) && ((*z).unauthenticatedProposal.Block.BlockHeader.FeesCollected.MsgIsZero()) && ((*z).unauthenticatedProposal.Block.BlockHeader.Bonus.MsgIsZero()) && ((*z).unauthenticatedProposal.Block.BlockHeader.ProposerPayout.MsgIsZero()) && ((*z).unauthenticatedProposal.Block.BlockHeader.RewardsState.FeeSink.MsgIsZero()) && ((*z).unauthenticatedProposal.Block.BlockHeader.RewardsState.RewardsPool.MsgIsZero()) && ((*z).unauthenticatedProposal.Block.BlockHeader.RewardsState.RewardsLevel == 0) && ((*z).unauthenticatedProposal.Block.BlockHeader.RewardsState.RewardsRate == 0) && ((*z).unauthenticatedProposal.Block.BlockHeader.RewardsState.RewardsResidue == 0) && ((*z).unauthenticatedProposal.Block.BlockHeader.RewardsState.RewardsRecalculationRound.MsgIsZero()) && ((*z).unauthenticatedProposal.Block.BlockHeader.UpgradeState.CurrentProtocol.MsgIsZero()) && ((*z).unauthenticatedProposal.Block.BlockHeader.UpgradeState.NextProtocol.MsgIsZero()) && ((*z).unauthenticatedProposal.Block.BlockHeader.UpgradeState.NextProtocolApprovals.MsgIsZero()) && ((*z).unauthenticatedProposal.Block.BlockHeader.UpgradeState.NextProtocolVoteBefore.MsgIsZero()) && ((*z).unauthenticatedProposal.Block.BlockHeader.UpgradeState.NextProtocolSwitchOn.MsgIsZero()) && ((*z).unauthenticatedProposal.Block.BlockHeader.UpgradeVote.UpgradePropose.MsgIsZero()) && ((*z).unauthenticatedProposal.Block.BlockHeader.UpgradeVote.UpgradeDelay.MsgIsZero()) && ((*z).unauthenticatedProposal.Block.BlockHeader.UpgradeVote.UpgradeApprove == false) && ((*z).unauthenticatedProposal.Block.BlockHeader.TxnCounter == 0) && (len((*z).unauthenticatedProposal.Block.BlockHeader.StateProofTracking) == 0) && (len((*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts) == 0) && (len((*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.AbsentParticipationAccounts) == 0) && ((*z).unauthenticatedProposal.Block.Payset.MsgIsZero()) && ((*z).unauthenticatedProposal.SeedProof.MsgIsZero()) && ((*z).unauthenticatedProposal.OriginalPeriod == 0) && ((*z).unauthenticatedProposal.OriginalProposer.MsgIsZero())
}

// MaxSize returns a maximum valid message size for this message type
func ProposalMaxSize() (s int) {
	s = 3 + 4 + basics.RoundMaxSize() + 5 + bookkeeping.BlockHashMaxSize() + 8 + crypto.Sha512DigestMaxSize() + 5 + committee.SeedMaxSize() + 4 + crypto.DigestMaxSize() + 7 + crypto.DigestMaxSize() + 7 + crypto.Sha512DigestMaxSize() + 3 + msgp.Int64Size + 4 + msgp.StringPrefixSize + bounds.MaxGenesisIDLen + 3 + crypto.DigestMaxSize() + 4 + basics.AddressMaxSize() + 3 + basics.MicroAlgosMaxSize() + 3 + basics.MicroAlgosMaxSize() + 3 + basics.MicroAlgosMaxSize() + 5 + basics.AddressMaxSize() + 4 + basics.AddressMaxSize() + 5 + msgp.Uint64Size + 5 + msgp.Uint64Size + 5 + msgp.Uint64Size + 7 + basics.RoundMaxSize() + 6 + protocol.ConsensusVersionMaxSize() + 10 + protocol.ConsensusVersionMaxSize() + 8 + basics.RoundMaxSize() + 11 + basics.RoundMaxSize() + 11 + basics.RoundMaxSize() + 12 + protocol.ConsensusVersionMaxSize() + 13 + basics.RoundMaxSize() + 11 + msgp.BoolSize + 3 + msgp.Uint64Size + 4
	s += msgp.MapHeaderSize
	// Adding size of map keys for z.unauthenticatedProposal.Block.BlockHeader.StateProofTracking
	s += protocol.NumStateProofTypes * (protocol.StateProofTypeMaxSize())
	// Adding size of map values for z.unauthenticatedProposal.Block.BlockHeader.StateProofTracking
	s += protocol.NumStateProofTypes * (bookkeeping.StateProofTrackingDataMaxSize())
	s += 11
	// Calculating size of slice: z.unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts
	s += msgp.ArrayHeaderSize + ((bounds.MaxProposedExpiredOnlineAccounts) * (basics.AddressMaxSize()))
	s += 11
	// Calculating size of slice: z.unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.AbsentParticipationAccounts
	s += msgp.ArrayHeaderSize + ((bounds.MaxMarkAbsent) * (basics.AddressMaxSize()))
	s += 5
	// Using maxtotalbytes for: z.unauthenticatedProposal.Block.Payset
	s += bounds.MaxTxnBytesPerBlock
	s += 5 + crypto.VrfProofMaxSize() + 5 + msgp.Uint64Size + 6 + basics.AddressMaxSize()
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *proposalManager) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 0
	o = append(o, 0x80)
	return
}

func (_ *proposalManager) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*proposalManager)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *proposalManager) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0001 int
	var zb0002 bool
	zb0001, zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0001, zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0001 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0001)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 {
			(*z) = proposalManager{}
		}
		for zb0001 > 0 {
			zb0001--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *proposalManager) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *proposalManager) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*proposalManager)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *proposalManager) Msgsize() (s int) {
	s = 1
	return
}

// MsgIsZero returns whether this is a zero value
func (z *proposalManager) MsgIsZero() bool {
	return true
}

// MaxSize returns a maximum valid message size for this message type
func ProposalManagerMaxSize() (s int) {
	s = 1
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *proposalSeeker) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 3
	// string "Filled"
	o = append(o, 0x83, 0xa6, 0x46, 0x69, 0x6c, 0x6c, 0x65, 0x64)
	o = msgp.AppendBool(o, (*z).Filled)
	// string "Frozen"
	o = append(o, 0xa6, 0x46, 0x72, 0x6f, 0x7a, 0x65, 0x6e)
	o = msgp.AppendBool(o, (*z).Frozen)
	// string "Lowest"
	o = append(o, 0xa6, 0x4c, 0x6f, 0x77, 0x65, 0x73, 0x74)
	o = (*z).Lowest.MarshalMsg(o)
	return
}

func (_ *proposalSeeker) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*proposalSeeker)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *proposalSeeker) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0001 int
	var zb0002 bool
	zb0001, zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0001, zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).Lowest.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Lowest")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			(*z).Filled, bts, err = msgp.ReadBoolBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Filled")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			(*z).Frozen, bts, err = msgp.ReadBoolBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Frozen")
				return
			}
		}
		if zb0001 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0001)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 {
			(*z) = proposalSeeker{}
		}
		for zb0001 > 0 {
			zb0001--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "Lowest":
				bts, err = (*z).Lowest.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Lowest")
					return
				}
			case "Filled":
				(*z).Filled, bts, err = msgp.ReadBoolBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Filled")
					return
				}
			case "Frozen":
				(*z).Frozen, bts, err = msgp.ReadBoolBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Frozen")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *proposalSeeker) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *proposalSeeker) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*proposalSeeker)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *proposalSeeker) Msgsize() (s int) {
	s = 1 + 7 + (*z).Lowest.Msgsize() + 7 + msgp.BoolSize + 7 + msgp.BoolSize
	return
}

// MsgIsZero returns whether this is a zero value
func (z *proposalSeeker) MsgIsZero() bool {
	return ((*z).Lowest.MsgIsZero()) && ((*z).Filled == false) && ((*z).Frozen == false)
}

// MaxSize returns a maximum valid message size for this message type
func ProposalSeekerMaxSize() (s int) {
	s = 1 + 7 + VoteMaxSize() + 7 + msgp.BoolSize + 7 + msgp.BoolSize
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *proposalStore) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 3
	// string "Assemblers"
	o = append(o, 0x83, 0xaa, 0x41, 0x73, 0x73, 0x65, 0x6d, 0x62, 0x6c, 0x65, 0x72, 0x73)
	if (*z).Assemblers == nil {
		o = msgp.AppendNil(o)
	} else {
		o = msgp.AppendMapHeader(o, uint32(len((*z).Assemblers)))
	}
	zb0003_keys := make([]proposalValue, 0, len((*z).Assemblers))
	for zb0003 := range (*z).Assemblers {
		zb0003_keys = append(zb0003_keys, zb0003)
	}
	sort.Sort(SortProposalValue(zb0003_keys))
	for _, zb0003 := range zb0003_keys {
		zb0004 := (*z).Assemblers[zb0003]
		_ = zb0004
		o = zb0003.MarshalMsg(o)
		o = zb0004.MarshalMsg(o)
	}
	// string "Pinned"
	o = append(o, 0xa6, 0x50, 0x69, 0x6e, 0x6e, 0x65, 0x64)
	o = (*z).Pinned.MarshalMsg(o)
	// string "Relevant"
	o = append(o, 0xa8, 0x52, 0x65, 0x6c, 0x65, 0x76, 0x61, 0x6e, 0x74)
	if (*z).Relevant == nil {
		o = msgp.AppendNil(o)
	} else {
		o = msgp.AppendMapHeader(o, uint32(len((*z).Relevant)))
	}
	zb0001_keys := make([]period, 0, len((*z).Relevant))
	for zb0001 := range (*z).Relevant {
		zb0001_keys = append(zb0001_keys, zb0001)
	}
	sort.Sort(SortPeriod(zb0001_keys))
	for _, zb0001 := range zb0001_keys {
		zb0002 := (*z).Relevant[zb0001]
		_ = zb0002
		o = zb0001.MarshalMsg(o)
		o = zb0002.MarshalMsg(o)
	}
	return
}

func (_ *proposalStore) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*proposalStore)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *proposalStore) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0005 int
	var zb0006 bool
	zb0005, zb0006, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0005, zb0006, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0005 > 0 {
			zb0005--
			var zb0007 int
			var zb0008 bool
			zb0007, zb0008, bts, err = msgp.ReadMapHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Relevant")
				return
			}
			if zb0008 {
				(*z).Relevant = nil
			} else if (*z).Relevant == nil {
				(*z).Relevant = make(map[period]proposalValue, zb0007)
			}
			for zb0007 > 0 {
				var zb0001 period
				var zb0002 proposalValue
				zb0007--
				bts, err = zb0001.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Relevant")
					return
				}
				bts, err = zb0002.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Relevant", zb0001)
					return
				}
				(*z).Relevant[zb0001] = zb0002
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).Pinned.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Pinned")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			var zb0009 int
			var zb0010 bool
			zb0009, zb0010, bts, err = msgp.ReadMapHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Assemblers")
				return
			}
			if zb0010 {
				(*z).Assemblers = nil
			} else if (*z).Assemblers == nil {
				(*z).Assemblers = make(map[proposalValue]blockAssembler, zb0009)
			}
			for zb0009 > 0 {
				var zb0003 proposalValue
				var zb0004 blockAssembler
				zb0009--
				bts, err = zb0003.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Assemblers")
					return
				}
				bts, err = zb0004.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Assemblers", zb0003)
					return
				}
				(*z).Assemblers[zb0003] = zb0004
			}
		}
		if zb0005 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0005)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0006 {
			(*z) = proposalStore{}
		}
		for zb0005 > 0 {
			zb0005--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "Relevant":
				var zb0011 int
				var zb0012 bool
				zb0011, zb0012, bts, err = msgp.ReadMapHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Relevant")
					return
				}
				if zb0012 {
					(*z).Relevant = nil
				} else if (*z).Relevant == nil {
					(*z).Relevant = make(map[period]proposalValue, zb0011)
				}
				for zb0011 > 0 {
					var zb0001 period
					var zb0002 proposalValue
					zb0011--
					bts, err = zb0001.UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "Relevant")
						return
					}
					bts, err = zb0002.UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "Relevant", zb0001)
						return
					}
					(*z).Relevant[zb0001] = zb0002
				}
			case "Pinned":
				bts, err = (*z).Pinned.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Pinned")
					return
				}
			case "Assemblers":
				var zb0013 int
				var zb0014 bool
				zb0013, zb0014, bts, err = msgp.ReadMapHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Assemblers")
					return
				}
				if zb0014 {
					(*z).Assemblers = nil
				} else if (*z).Assemblers == nil {
					(*z).Assemblers = make(map[proposalValue]blockAssembler, zb0013)
				}
				for zb0013 > 0 {
					var zb0003 proposalValue
					var zb0004 blockAssembler
					zb0013--
					bts, err = zb0003.UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "Assemblers")
						return
					}
					bts, err = zb0004.UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "Assemblers", zb0003)
						return
					}
					(*z).Assemblers[zb0003] = zb0004
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *proposalStore) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *proposalStore) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*proposalStore)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *proposalStore) Msgsize() (s int) {
	s = 1 + 9 + msgp.MapHeaderSize
	if (*z).Relevant != nil {
		for zb0001, zb0002 := range (*z).Relevant {
			_ = zb0001
			_ = zb0002
			s += 0 + zb0001.Msgsize() + zb0002.Msgsize()
		}
	}
	s += 7 + (*z).Pinned.Msgsize() + 11 + msgp.MapHeaderSize
	if (*z).Assemblers != nil {
		for zb0003, zb0004 := range (*z).Assemblers {
			_ = zb0003
			_ = zb0004
			s += 0 + zb0003.Msgsize() + zb0004.Msgsize()
		}
	}
	return
}

// MsgIsZero returns whether this is a zero value
func (z *proposalStore) MsgIsZero() bool {
	return (len((*z).Relevant) == 0) && ((*z).Pinned.MsgIsZero()) && (len((*z).Assemblers) == 0)
}

// MaxSize returns a maximum valid message size for this message type
func ProposalStoreMaxSize() (s int) {
	s = 1 + 9
	s += msgp.MapHeaderSize
	panic("Map z.Relevant is unbounded")
}

// MarshalMsg implements msgp.Marshaler
func (z *proposalTable) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0003Len := uint32(2)
	var zb0003Mask uint8 /* 3 bits */
	if len((*z).Pending) == 0 {
		zb0003Len--
		zb0003Mask |= 0x1
	}
	if (*z).PendingNext == 0 {
		zb0003Len--
		zb0003Mask |= 0x2
	}
	// variable map header, size zb0003Len
	o = append(o, 0x80|uint8(zb0003Len))
	if zb0003Len != 0 {
		if (zb0003Mask & 0x1) == 0 { // if not empty
			// string "Pending"
			o = append(o, 0xa7, 0x50, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67)
			if (*z).Pending == nil {
				o = msgp.AppendNil(o)
			} else {
				o = msgp.AppendMapHeader(o, uint32(len((*z).Pending)))
			}
			zb0001_keys := make([]uint64, 0, len((*z).Pending))
			for zb0001 := range (*z).Pending {
				zb0001_keys = append(zb0001_keys, zb0001)
			}
			sort.Sort(SortUint64(zb0001_keys))
			for _, zb0001 := range zb0001_keys {
				zb0002 := (*z).Pending[zb0001]
				_ = zb0002
				o = msgp.AppendUint64(o, zb0001)
				if zb0002 == nil {
					o = msgp.AppendNil(o)
				} else {
					o = zb0002.MarshalMsg(o)
				}
			}
		}
		if (zb0003Mask & 0x2) == 0 { // if not empty
			// string "PendingNext"
			o = append(o, 0xab, 0x50, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x4e, 0x65, 0x78, 0x74)
			o = msgp.AppendUint64(o, (*z).PendingNext)
		}
	}
	return
}

func (_ *proposalTable) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*proposalTable)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *proposalTable) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0003 int
	var zb0004 bool
	zb0003, zb0004, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0003, zb0004, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0003 > 0 {
			zb0003--
			var zb0005 int
			var zb0006 bool
			zb0005, zb0006, bts, err = msgp.ReadMapHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Pending")
				return
			}
			if zb0006 {
				(*z).Pending = nil
			} else if (*z).Pending == nil {
				(*z).Pending = make(map[uint64]*messageEvent, zb0005)
			}
			for zb0005 > 0 {
				var zb0001 uint64
				var zb0002 *messageEvent
				zb0005--
				zb0001, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Pending")
					return
				}
				if msgp.IsNil(bts) {
					bts, err = msgp.ReadNilBytes(bts)
					if err != nil {
						return
					}
					zb0002 = nil
				} else {
					if zb0002 == nil {
						zb0002 = new(messageEvent)
					}
					bts, err = zb0002.UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "Pending", zb0001)
						return
					}
				}
				(*z).Pending[zb0001] = zb0002
			}
		}
		if zb0003 > 0 {
			zb0003--
			(*z).PendingNext, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "PendingNext")
				return
			}
		}
		if zb0003 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0003)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0004 {
			(*z) = proposalTable{}
		}
		for zb0003 > 0 {
			zb0003--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "Pending":
				var zb0007 int
				var zb0008 bool
				zb0007, zb0008, bts, err = msgp.ReadMapHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Pending")
					return
				}
				if zb0008 {
					(*z).Pending = nil
				} else if (*z).Pending == nil {
					(*z).Pending = make(map[uint64]*messageEvent, zb0007)
				}
				for zb0007 > 0 {
					var zb0001 uint64
					var zb0002 *messageEvent
					zb0007--
					zb0001, bts, err = msgp.ReadUint64Bytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "Pending")
						return
					}
					if msgp.IsNil(bts) {
						bts, err = msgp.ReadNilBytes(bts)
						if err != nil {
							return
						}
						zb0002 = nil
					} else {
						if zb0002 == nil {
							zb0002 = new(messageEvent)
						}
						bts, err = zb0002.UnmarshalMsgWithState(bts, st)
						if err != nil {
							err = msgp.WrapError(err, "Pending", zb0001)
							return
						}
					}
					(*z).Pending[zb0001] = zb0002
				}
			case "PendingNext":
				(*z).PendingNext, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "PendingNext")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *proposalTable) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *proposalTable) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*proposalTable)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *proposalTable) Msgsize() (s int) {
	s = 1 + 8 + msgp.MapHeaderSize
	if (*z).Pending != nil {
		for zb0001, zb0002 := range (*z).Pending {
			_ = zb0001
			_ = zb0002
			s += 0 + msgp.Uint64Size
			if zb0002 == nil {
				s += msgp.NilSize
			} else {
				s += zb0002.Msgsize()
			}
		}
	}
	s += 12 + msgp.Uint64Size
	return
}

// MsgIsZero returns whether this is a zero value
func (z *proposalTable) MsgIsZero() bool {
	return (len((*z).Pending) == 0) && ((*z).PendingNext == 0)
}

// MaxSize returns a maximum valid message size for this message type
func ProposalTableMaxSize() (s int) {
	s = 1 + 8
	s += msgp.MapHeaderSize
	panic("Map z.Pending is unbounded")
}

// MarshalMsg implements msgp.Marshaler
func (z *proposalTracker) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 3
	// string "Duplicate"
	o = append(o, 0x83, 0xa9, 0x44, 0x75, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x65)
	if (*z).Duplicate == nil {
		o = msgp.AppendNil(o)
	} else {
		o = msgp.AppendMapHeader(o, uint32(len((*z).Duplicate)))
	}
	zb0001_keys := make([]basics.Address, 0, len((*z).Duplicate))
	for zb0001 := range (*z).Duplicate {
		zb0001_keys = append(zb0001_keys, zb0001)
	}
	sort.Sort(SortAddress(zb0001_keys))
	for _, zb0001 := range zb0001_keys {
		zb0002 := (*z).Duplicate[zb0001]
		_ = zb0002
		o = zb0001.MarshalMsg(o)
		o = msgp.AppendBool(o, zb0002)
	}
	// string "Freezer"
	o = append(o, 0xa7, 0x46, 0x72, 0x65, 0x65, 0x7a, 0x65, 0x72)
	o = (*z).Freezer.MarshalMsg(o)
	// string "Staging"
	o = append(o, 0xa7, 0x53, 0x74, 0x61, 0x67, 0x69, 0x6e, 0x67)
	o = (*z).Staging.MarshalMsg(o)
	return
}

func (_ *proposalTracker) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*proposalTracker)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *proposalTracker) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0003 int
	var zb0004 bool
	zb0003, zb0004, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0003, zb0004, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0003 > 0 {
			zb0003--
			var zb0005 int
			var zb0006 bool
			zb0005, zb0006, bts, err = msgp.ReadMapHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Duplicate")
				return
			}
			if zb0006 {
				(*z).Duplicate = nil
			} else if (*z).Duplicate == nil {
				(*z).Duplicate = make(map[basics.Address]bool, zb0005)
			}
			for zb0005 > 0 {
				var zb0001 basics.Address
				var zb0002 bool
				zb0005--
				bts, err = zb0001.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Duplicate")
					return
				}
				zb0002, bts, err = msgp.ReadBoolBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Duplicate", zb0001)
					return
				}
				(*z).Duplicate[zb0001] = zb0002
			}
		}
		if zb0003 > 0 {
			zb0003--
			bts, err = (*z).Freezer.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Freezer")
				return
			}
		}
		if zb0003 > 0 {
			zb0003--
			bts, err = (*z).Staging.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Staging")
				return
			}
		}
		if zb0003 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0003)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0004 {
			(*z) = proposalTracker{}
		}
		for zb0003 > 0 {
			zb0003--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "Duplicate":
				var zb0007 int
				var zb0008 bool
				zb0007, zb0008, bts, err = msgp.ReadMapHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Duplicate")
					return
				}
				if zb0008 {
					(*z).Duplicate = nil
				} else if (*z).Duplicate == nil {
					(*z).Duplicate = make(map[basics.Address]bool, zb0007)
				}
				for zb0007 > 0 {
					var zb0001 basics.Address
					var zb0002 bool
					zb0007--
					bts, err = zb0001.UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "Duplicate")
						return
					}
					zb0002, bts, err = msgp.ReadBoolBytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "Duplicate", zb0001)
						return
					}
					(*z).Duplicate[zb0001] = zb0002
				}
			case "Freezer":
				bts, err = (*z).Freezer.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Freezer")
					return
				}
			case "Staging":
				bts, err = (*z).Staging.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Staging")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *proposalTracker) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *proposalTracker) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*proposalTracker)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *proposalTracker) Msgsize() (s int) {
	s = 1 + 10 + msgp.MapHeaderSize
	if (*z).Duplicate != nil {
		for zb0001, zb0002 := range (*z).Duplicate {
			_ = zb0001
			_ = zb0002
			s += 0 + zb0001.Msgsize() + msgp.BoolSize
		}
	}
	s += 8 + (*z).Freezer.Msgsize() + 8 + (*z).Staging.Msgsize()
	return
}

// MsgIsZero returns whether this is a zero value
func (z *proposalTracker) MsgIsZero() bool {
	return (len((*z).Duplicate) == 0) && ((*z).Freezer.MsgIsZero()) && ((*z).Staging.MsgIsZero())
}

// MaxSize returns a maximum valid message size for this message type
func ProposalTrackerMaxSize() (s int) {
	s = 1 + 10
	s += msgp.MapHeaderSize
	panic("Map z.Duplicate is unbounded")
}

// MarshalMsg implements msgp.Marshaler
func (z *proposalTrackerContract) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 4
	// string "Froze"
	o = append(o, 0x84, 0xa5, 0x46, 0x72, 0x6f, 0x7a, 0x65)
	o = msgp.AppendBool(o, (*z).Froze)
	// string "SawCertThreshold"
	o = append(o, 0xb0, 0x53, 0x61, 0x77, 0x43, 0x65, 0x72, 0x74, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64)
	o = msgp.AppendBool(o, (*z).SawCertThreshold)
	// string "SawOneVote"
	o = append(o, 0xaa, 0x53, 0x61, 0x77, 0x4f, 0x6e, 0x65, 0x56, 0x6f, 0x74, 0x65)
	o = msgp.AppendBool(o, (*z).SawOneVote)
	// string "SawSoftThreshold"
	o = append(o, 0xb0, 0x53, 0x61, 0x77, 0x53, 0x6f, 0x66, 0x74, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64)
	o = msgp.AppendBool(o, (*z).SawSoftThreshold)
	return
}

func (_ *proposalTrackerContract) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*proposalTrackerContract)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *proposalTrackerContract) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0001 int
	var zb0002 bool
	zb0001, zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0001, zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0001 > 0 {
			zb0001--
			(*z).SawOneVote, bts, err = msgp.ReadBoolBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "SawOneVote")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			(*z).Froze, bts, err = msgp.ReadBoolBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Froze")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			(*z).SawSoftThreshold, bts, err = msgp.ReadBoolBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "SawSoftThreshold")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			(*z).SawCertThreshold, bts, err = msgp.ReadBoolBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "SawCertThreshold")
				return
			}
		}
		if zb0001 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0001)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 {
			(*z) = proposalTrackerContract{}
		}
		for zb0001 > 0 {
			zb0001--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "SawOneVote":
				(*z).SawOneVote, bts, err = msgp.ReadBoolBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "SawOneVote")
					return
				}
			case "Froze":
				(*z).Froze, bts, err = msgp.ReadBoolBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Froze")
					return
				}
			case "SawSoftThreshold":
				(*z).SawSoftThreshold, bts, err = msgp.ReadBoolBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "SawSoftThreshold")
					return
				}
			case "SawCertThreshold":
				(*z).SawCertThreshold, bts, err = msgp.ReadBoolBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "SawCertThreshold")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *proposalTrackerContract) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *proposalTrackerContract) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*proposalTrackerContract)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *proposalTrackerContract) Msgsize() (s int) {
	s = 1 + 11 + msgp.BoolSize + 6 + msgp.BoolSize + 17 + msgp.BoolSize + 17 + msgp.BoolSize
	return
}

// MsgIsZero returns whether this is a zero value
func (z *proposalTrackerContract) MsgIsZero() bool {
	return ((*z).SawOneVote == false) && ((*z).Froze == false) && ((*z).SawSoftThreshold == false) && ((*z).SawCertThreshold == false)
}

// MaxSize returns a maximum valid message size for this message type
func ProposalTrackerContractMaxSize() (s int) {
	s = 1 + 11 + msgp.BoolSize + 6 + msgp.BoolSize + 17 + msgp.BoolSize + 17 + msgp.BoolSize
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *proposalValue) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0001Len := uint32(4)
	var zb0001Mask uint8 /* 5 bits */
	if (*z).BlockDigest.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x2
	}
	if (*z).EncodingDigest.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x4
	}
	if (*z).OriginalPeriod == 0 {
		zb0001Len--
		zb0001Mask |= 0x8
	}
	if (*z).OriginalProposer.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x10
	}
	// variable map header, size zb0001Len
	o = append(o, 0x80|uint8(zb0001Len))
	if zb0001Len != 0 {
		if (zb0001Mask & 0x2) == 0 { // if not empty
			// string "dig"
			o = append(o, 0xa3, 0x64, 0x69, 0x67)
			o = (*z).BlockDigest.MarshalMsg(o)
		}
		if (zb0001Mask & 0x4) == 0 { // if not empty
			// string "encdig"
			o = append(o, 0xa6, 0x65, 0x6e, 0x63, 0x64, 0x69, 0x67)
			o = (*z).EncodingDigest.MarshalMsg(o)
		}
		if (zb0001Mask & 0x8) == 0 { // if not empty
			// string "oper"
			o = append(o, 0xa4, 0x6f, 0x70, 0x65, 0x72)
			o = msgp.AppendUint64(o, uint64((*z).OriginalPeriod))
		}
		if (zb0001Mask & 0x10) == 0 { // if not empty
			// string "oprop"
			o = append(o, 0xa5, 0x6f, 0x70, 0x72, 0x6f, 0x70)
			o = (*z).OriginalProposer.MarshalMsg(o)
		}
	}
	return
}

func (_ *proposalValue) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*proposalValue)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *proposalValue) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0001 int
	var zb0002 bool
	zb0001, zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0001, zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0001 > 0 {
			zb0001--
			{
				var zb0003 uint64
				zb0003, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "OriginalPeriod")
					return
				}
				(*z).OriginalPeriod = period(zb0003)
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).OriginalProposer.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "OriginalProposer")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).BlockDigest.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "BlockDigest")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).EncodingDigest.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "EncodingDigest")
				return
			}
		}
		if zb0001 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0001)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 {
			(*z) = proposalValue{}
		}
		for zb0001 > 0 {
			zb0001--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "oper":
				{
					var zb0004 uint64
					zb0004, bts, err = msgp.ReadUint64Bytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "OriginalPeriod")
						return
					}
					(*z).OriginalPeriod = period(zb0004)
				}
			case "oprop":
				bts, err = (*z).OriginalProposer.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "OriginalProposer")
					return
				}
			case "dig":
				bts, err = (*z).BlockDigest.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "BlockDigest")
					return
				}
			case "encdig":
				bts, err = (*z).EncodingDigest.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "EncodingDigest")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *proposalValue) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *proposalValue) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*proposalValue)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *proposalValue) Msgsize() (s int) {
	s = 1 + 5 + msgp.Uint64Size + 6 + (*z).OriginalProposer.Msgsize() + 4 + (*z).BlockDigest.Msgsize() + 7 + (*z).EncodingDigest.Msgsize()
	return
}

// MsgIsZero returns whether this is a zero value
func (z *proposalValue) MsgIsZero() bool {
	return ((*z).OriginalPeriod == 0) && ((*z).OriginalProposer.MsgIsZero()) && ((*z).BlockDigest.MsgIsZero()) && ((*z).EncodingDigest.MsgIsZero())
}

// MaxSize returns a maximum valid message size for this message type
func ProposalValueMaxSize() (s int) {
	s = 1 + 5 + msgp.Uint64Size + 6 + basics.AddressMaxSize() + 4 + crypto.DigestMaxSize() + 7 + crypto.DigestMaxSize()
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *proposalVoteCounter) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 2
	// string "Count"
	o = append(o, 0x82, 0xa5, 0x43, 0x6f, 0x75, 0x6e, 0x74)
	o = msgp.AppendUint64(o, (*z).Count)
	// string "Votes"
	o = append(o, 0xa5, 0x56, 0x6f, 0x74, 0x65, 0x73)
	if (*z).Votes == nil {
		o = msgp.AppendNil(o)
	} else {
		o = msgp.AppendMapHeader(o, uint32(len((*z).Votes)))
	}
	zb0001_keys := make([]basics.Address, 0, len((*z).Votes))
	for zb0001 := range (*z).Votes {
		zb0001_keys = append(zb0001_keys, zb0001)
	}
	sort.Sort(SortAddress(zb0001_keys))
	for _, zb0001 := range zb0001_keys {
		zb0002 := (*z).Votes[zb0001]
		_ = zb0002
		o = zb0001.MarshalMsg(o)
		o = zb0002.MarshalMsg(o)
	}
	return
}

func (_ *proposalVoteCounter) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*proposalVoteCounter)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *proposalVoteCounter) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0003 int
	var zb0004 bool
	zb0003, zb0004, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0003, zb0004, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0003 > 0 {
			zb0003--
			(*z).Count, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Count")
				return
			}
		}
		if zb0003 > 0 {
			zb0003--
			var zb0005 int
			var zb0006 bool
			zb0005, zb0006, bts, err = msgp.ReadMapHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Votes")
				return
			}
			if zb0006 {
				(*z).Votes = nil
			} else if (*z).Votes == nil {
				(*z).Votes = make(map[basics.Address]vote, zb0005)
			}
			for zb0005 > 0 {
				var zb0001 basics.Address
				var zb0002 vote
				zb0005--
				bts, err = zb0001.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Votes")
					return
				}
				bts, err = zb0002.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Votes", zb0001)
					return
				}
				(*z).Votes[zb0001] = zb0002
			}
		}
		if zb0003 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0003)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0004 {
			(*z) = proposalVoteCounter{}
		}
		for zb0003 > 0 {
			zb0003--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "Count":
				(*z).Count, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Count")
					return
				}
			case "Votes":
				var zb0007 int
				var zb0008 bool
				zb0007, zb0008, bts, err = msgp.ReadMapHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Votes")
					return
				}
				if zb0008 {
					(*z).Votes = nil
				} else if (*z).Votes == nil {
					(*z).Votes = make(map[basics.Address]vote, zb0007)
				}
				for zb0007 > 0 {
					var zb0001 basics.Address
					var zb0002 vote
					zb0007--
					bts, err = zb0001.UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "Votes")
						return
					}
					bts, err = zb0002.UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "Votes", zb0001)
						return
					}
					(*z).Votes[zb0001] = zb0002
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *proposalVoteCounter) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *proposalVoteCounter) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*proposalVoteCounter)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *proposalVoteCounter) Msgsize() (s int) {
	s = 1 + 6 + msgp.Uint64Size + 6 + msgp.MapHeaderSize
	if (*z).Votes != nil {
		for zb0001, zb0002 := range (*z).Votes {
			_ = zb0001
			_ = zb0002
			s += 0 + zb0001.Msgsize() + zb0002.Msgsize()
		}
	}
	return
}

// MsgIsZero returns whether this is a zero value
func (z *proposalVoteCounter) MsgIsZero() bool {
	return ((*z).Count == 0) && (len((*z).Votes) == 0)
}

// MaxSize returns a maximum valid message size for this message type
func ProposalVoteCounterMaxSize() (s int) {
	s = 1 + 6 + msgp.Uint64Size + 6
	s += msgp.MapHeaderSize
	panic("Map z.Votes is unbounded")
}

// MarshalMsg implements msgp.Marshaler
func (z *proposerSeed) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 2
	// string "addr"
	o = append(o, 0x82, 0xa4, 0x61, 0x64, 0x64, 0x72)
	o = (*z).Addr.MarshalMsg(o)
	// string "vrf"
	o = append(o, 0xa3, 0x76, 0x72, 0x66)
	o = (*z).VRF.MarshalMsg(o)
	return
}

func (_ *proposerSeed) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*proposerSeed)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *proposerSeed) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0001 int
	var zb0002 bool
	zb0001, zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0001, zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).Addr.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Addr")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).VRF.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "VRF")
				return
			}
		}
		if zb0001 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0001)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 {
			(*z) = proposerSeed{}
		}
		for zb0001 > 0 {
			zb0001--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "addr":
				bts, err = (*z).Addr.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Addr")
					return
				}
			case "vrf":
				bts, err = (*z).VRF.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "VRF")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *proposerSeed) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *proposerSeed) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*proposerSeed)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *proposerSeed) Msgsize() (s int) {
	s = 1 + 5 + (*z).Addr.Msgsize() + 4 + (*z).VRF.Msgsize()
	return
}

// MsgIsZero returns whether this is a zero value
func (z *proposerSeed) MsgIsZero() bool {
	return ((*z).Addr.MsgIsZero()) && ((*z).VRF.MsgIsZero())
}

// MaxSize returns a maximum valid message size for this message type
func ProposerSeedMaxSize() (s int) {
	s = 1 + 5 + basics.AddressMaxSize() + 4 + crypto.VrfOutputMaxSize()
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *rawVote) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0001Len := uint32(5)
	var zb0001Mask uint8 /* 6 bits */
	if (*z).Period == 0 {
		zb0001Len--
		zb0001Mask |= 0x2
	}
	if (*z).Proposal.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x4
	}
	if (*z).Round.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x8
	}
	if (*z).Sender.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x10
	}
	if (*z).Step == 0 {
		zb0001Len--
		zb0001Mask |= 0x20
	}
	// variable map header, size zb0001Len
	o = append(o, 0x80|uint8(zb0001Len))
	if zb0001Len != 0 {
		if (zb0001Mask & 0x2) == 0 { // if not empty
			// string "per"
			o = append(o, 0xa3, 0x70, 0x65, 0x72)
			o = msgp.AppendUint64(o, uint64((*z).Period))
		}
		if (zb0001Mask & 0x4) == 0 { // if not empty
			// string "prop"
			o = append(o, 0xa4, 0x70, 0x72, 0x6f, 0x70)
			o = (*z).Proposal.MarshalMsg(o)
		}
		if (zb0001Mask & 0x8) == 0 { // if not empty
			// string "rnd"
			o = append(o, 0xa3, 0x72, 0x6e, 0x64)
			o = (*z).Round.MarshalMsg(o)
		}
		if (zb0001Mask & 0x10) == 0 { // if not empty
			// string "snd"
			o = append(o, 0xa3, 0x73, 0x6e, 0x64)
			o = (*z).Sender.MarshalMsg(o)
		}
		if (zb0001Mask & 0x20) == 0 { // if not empty
			// string "step"
			o = append(o, 0xa4, 0x73, 0x74, 0x65, 0x70)
			o = msgp.AppendUint64(o, uint64((*z).Step))
		}
	}
	return
}

func (_ *rawVote) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*rawVote)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *rawVote) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0001 int
	var zb0002 bool
	zb0001, zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0001, zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).Sender.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Sender")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).Round.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Round")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			{
				var zb0003 uint64
				zb0003, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Period")
					return
				}
				(*z).Period = period(zb0003)
			}
		}
		if zb0001 > 0 {
			zb0001--
			{
				var zb0004 uint64
				zb0004, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Step")
					return
				}
				(*z).Step = step(zb0004)
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).Proposal.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Proposal")
				return
			}
		}
		if zb0001 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0001)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 {
			(*z) = rawVote{}
		}
		for zb0001 > 0 {
			zb0001--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "snd":
				bts, err = (*z).Sender.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Sender")
					return
				}
			case "rnd":
				bts, err = (*z).Round.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Round")
					return
				}
			case "per":
				{
					var zb0005 uint64
					zb0005, bts, err = msgp.ReadUint64Bytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "Period")
						return
					}
					(*z).Period = period(zb0005)
				}
			case "step":
				{
					var zb0006 uint64
					zb0006, bts, err = msgp.ReadUint64Bytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "Step")
						return
					}
					(*z).Step = step(zb0006)
				}
			case "prop":
				bts, err = (*z).Proposal.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Proposal")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *rawVote) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *rawVote) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*rawVote)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *rawVote) Msgsize() (s int) {
	s = 1 + 4 + (*z).Sender.Msgsize() + 4 + (*z).Round.Msgsize() + 4 + msgp.Uint64Size + 5 + msgp.Uint64Size + 5 + (*z).Proposal.Msgsize()
	return
}

// MsgIsZero returns whether this is a zero value
func (z *rawVote) MsgIsZero() bool {
	return ((*z).Sender.MsgIsZero()) && ((*z).Round.MsgIsZero()) && ((*z).Period == 0) && ((*z).Step == 0) && ((*z).Proposal.MsgIsZero())
}

// MaxSize returns a maximum valid message size for this message type
func RawVoteMaxSize() (s int) {
	s = 1 + 4 + basics.AddressMaxSize() + 4 + basics.RoundMaxSize() + 4 + msgp.Uint64Size + 5 + msgp.Uint64Size + 5 + ProposalValueMaxSize()
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *rootRouter) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 3
	// string "Children"
	o = append(o, 0x83, 0xa8, 0x43, 0x68, 0x69, 0x6c, 0x64, 0x72, 0x65, 0x6e)
	if (*z).Children == nil {
		o = msgp.AppendNil(o)
	} else {
		o = msgp.AppendMapHeader(o, uint32(len((*z).Children)))
	}
	zb0001_keys := make([]basics.Round, 0, len((*z).Children))
	for zb0001 := range (*z).Children {
		zb0001_keys = append(zb0001_keys, zb0001)
	}
	sort.Sort(SortRound(zb0001_keys))
	for _, zb0001 := range zb0001_keys {
		zb0002 := (*z).Children[zb0001]
		_ = zb0002
		o = zb0001.MarshalMsg(o)
		if zb0002 == nil {
			o = msgp.AppendNil(o)
		} else {
			o = zb0002.MarshalMsg(o)
		}
	}
	// string "ProposalManager"
	o = append(o, 0xaf, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72)
	// map header, size 0
	o = append(o, 0x80)
	// string "VoteAggregator"
	o = append(o, 0xae, 0x56, 0x6f, 0x74, 0x65, 0x41, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x6f, 0x72)
	// map header, size 0
	o = append(o, 0x80)
	return
}

func (_ *rootRouter) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*rootRouter)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *rootRouter) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0003 int
	var zb0004 bool
	zb0003, zb0004, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0003, zb0004, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0003 > 0 {
			zb0003--
			var zb0005 int
			var zb0006 bool
			zb0005, zb0006, bts, err = msgp.ReadMapHeaderBytes(bts)
			if _, ok := err.(msgp.TypeError); ok {
				zb0005, zb0006, bts, err = msgp.ReadArrayHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "ProposalManager")
					return
				}
				if zb0005 > 0 {
					err = msgp.ErrTooManyArrayFields(zb0005)
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "ProposalManager", "struct-from-array")
						return
					}
				}
			} else {
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "ProposalManager")
					return
				}
				if zb0006 {
					(*z).ProposalManager = proposalManager{}
				}
				for zb0005 > 0 {
					zb0005--
					field, bts, err = msgp.ReadMapKeyZC(bts)
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "ProposalManager")
						return
					}
					switch string(field) {
					default:
						err = msgp.ErrNoField(string(field))
						if err != nil {
							err = msgp.WrapError(err, "struct-from-array", "ProposalManager")
							return
						}
					}
				}
			}
		}
		if zb0003 > 0 {
			zb0003--
			var zb0007 int
			var zb0008 bool
			zb0007, zb0008, bts, err = msgp.ReadMapHeaderBytes(bts)
			if _, ok := err.(msgp.TypeError); ok {
				zb0007, zb0008, bts, err = msgp.ReadArrayHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "VoteAggregator")
					return
				}
				if zb0007 > 0 {
					err = msgp.ErrTooManyArrayFields(zb0007)
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "VoteAggregator", "struct-from-array")
						return
					}
				}
			} else {
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "VoteAggregator")
					return
				}
				if zb0008 {
					(*z).VoteAggregator = voteAggregator{}
				}
				for zb0007 > 0 {
					zb0007--
					field, bts, err = msgp.ReadMapKeyZC(bts)
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "VoteAggregator")
						return
					}
					switch string(field) {
					default:
						err = msgp.ErrNoField(string(field))
						if err != nil {
							err = msgp.WrapError(err, "struct-from-array", "VoteAggregator")
							return
						}
					}
				}
			}
		}
		if zb0003 > 0 {
			zb0003--
			var zb0009 int
			var zb0010 bool
			zb0009, zb0010, bts, err = msgp.ReadMapHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Children")
				return
			}
			if zb0010 {
				(*z).Children = nil
			} else if (*z).Children == nil {
				(*z).Children = make(map[round]*roundRouter, zb0009)
			}
			for zb0009 > 0 {
				var zb0001 basics.Round
				var zb0002 *roundRouter
				zb0009--
				bts, err = zb0001.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Children")
					return
				}
				if msgp.IsNil(bts) {
					bts, err = msgp.ReadNilBytes(bts)
					if err != nil {
						return
					}
					zb0002 = nil
				} else {
					if zb0002 == nil {
						zb0002 = new(roundRouter)
					}
					bts, err = zb0002.UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "Children", zb0001)
						return
					}
				}
				(*z).Children[zb0001] = zb0002
			}
		}
		if zb0003 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0003)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0004 {
			(*z) = rootRouter{}
		}
		for zb0003 > 0 {
			zb0003--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "ProposalManager":
				var zb0011 int
				var zb0012 bool
				zb0011, zb0012, bts, err = msgp.ReadMapHeaderBytes(bts)
				if _, ok := err.(msgp.TypeError); ok {
					zb0011, zb0012, bts, err = msgp.ReadArrayHeaderBytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "ProposalManager")
						return
					}
					if zb0011 > 0 {
						err = msgp.ErrTooManyArrayFields(zb0011)
						if err != nil {
							err = msgp.WrapError(err, "ProposalManager", "struct-from-array")
							return
						}
					}
				} else {
					if err != nil {
						err = msgp.WrapError(err, "ProposalManager")
						return
					}
					if zb0012 {
						(*z).ProposalManager = proposalManager{}
					}
					for zb0011 > 0 {
						zb0011--
						field, bts, err = msgp.ReadMapKeyZC(bts)
						if err != nil {
							err = msgp.WrapError(err, "ProposalManager")
							return
						}
						switch string(field) {
						default:
							err = msgp.ErrNoField(string(field))
							if err != nil {
								err = msgp.WrapError(err, "ProposalManager")
								return
							}
						}
					}
				}
			case "VoteAggregator":
				var zb0013 int
				var zb0014 bool
				zb0013, zb0014, bts, err = msgp.ReadMapHeaderBytes(bts)
				if _, ok := err.(msgp.TypeError); ok {
					zb0013, zb0014, bts, err = msgp.ReadArrayHeaderBytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "VoteAggregator")
						return
					}
					if zb0013 > 0 {
						err = msgp.ErrTooManyArrayFields(zb0013)
						if err != nil {
							err = msgp.WrapError(err, "VoteAggregator", "struct-from-array")
							return
						}
					}
				} else {
					if err != nil {
						err = msgp.WrapError(err, "VoteAggregator")
						return
					}
					if zb0014 {
						(*z).VoteAggregator = voteAggregator{}
					}
					for zb0013 > 0 {
						zb0013--
						field, bts, err = msgp.ReadMapKeyZC(bts)
						if err != nil {
							err = msgp.WrapError(err, "VoteAggregator")
							return
						}
						switch string(field) {
						default:
							err = msgp.ErrNoField(string(field))
							if err != nil {
								err = msgp.WrapError(err, "VoteAggregator")
								return
							}
						}
					}
				}
			case "Children":
				var zb0015 int
				var zb0016 bool
				zb0015, zb0016, bts, err = msgp.ReadMapHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Children")
					return
				}
				if zb0016 {
					(*z).Children = nil
				} else if (*z).Children == nil {
					(*z).Children = make(map[round]*roundRouter, zb0015)
				}
				for zb0015 > 0 {
					var zb0001 basics.Round
					var zb0002 *roundRouter
					zb0015--
					bts, err = zb0001.UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "Children")
						return
					}
					if msgp.IsNil(bts) {
						bts, err = msgp.ReadNilBytes(bts)
						if err != nil {
							return
						}
						zb0002 = nil
					} else {
						if zb0002 == nil {
							zb0002 = new(roundRouter)
						}
						bts, err = zb0002.UnmarshalMsgWithState(bts, st)
						if err != nil {
							err = msgp.WrapError(err, "Children", zb0001)
							return
						}
					}
					(*z).Children[zb0001] = zb0002
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *rootRouter) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *rootRouter) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*rootRouter)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *rootRouter) Msgsize() (s int) {
	s = 1 + 16 + 1 + 15 + 1 + 9 + msgp.MapHeaderSize
	if (*z).Children != nil {
		for zb0001, zb0002 := range (*z).Children {
			_ = zb0001
			_ = zb0002
			s += 0 + zb0001.Msgsize()
			if zb0002 == nil {
				s += msgp.NilSize
			} else {
				s += zb0002.Msgsize()
			}
		}
	}
	return
}

// MsgIsZero returns whether this is a zero value
func (z *rootRouter) MsgIsZero() bool {
	return (len((*z).Children) == 0)
}

// MaxSize returns a maximum valid message size for this message type
func RootRouterMaxSize() (s int) {
	s = 1 + 16 + 1 + 15 + 1 + 9
	s += msgp.MapHeaderSize
	panic("Map z.Children is unbounded")
}

// MarshalMsg implements msgp.Marshaler
func (z *roundRouter) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 3
	// string "Children"
	o = append(o, 0x83, 0xa8, 0x43, 0x68, 0x69, 0x6c, 0x64, 0x72, 0x65, 0x6e)
	if (*z).Children == nil {
		o = msgp.AppendNil(o)
	} else {
		o = msgp.AppendMapHeader(o, uint32(len((*z).Children)))
	}
	zb0001_keys := make([]period, 0, len((*z).Children))
	for zb0001 := range (*z).Children {
		zb0001_keys = append(zb0001_keys, zb0001)
	}
	sort.Sort(SortPeriod(zb0001_keys))
	for _, zb0001 := range zb0001_keys {
		zb0002 := (*z).Children[zb0001]
		_ = zb0002
		o = zb0001.MarshalMsg(o)
		if zb0002 == nil {
			o = msgp.AppendNil(o)
		} else {
			o = zb0002.MarshalMsg(o)
		}
	}
	// string "ProposalStore"
	o = append(o, 0xad, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c, 0x53, 0x74, 0x6f, 0x72, 0x65)
	o = (*z).ProposalStore.MarshalMsg(o)
	// string "VoteTrackerRound"
	o = append(o, 0xb0, 0x56, 0x6f, 0x74, 0x65, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x65, 0x72, 0x52, 0x6f, 0x75, 0x6e, 0x64)
	// map header, size 2
	// string "Freshest"
	o = append(o, 0x82, 0xa8, 0x46, 0x72, 0x65, 0x73, 0x68, 0x65, 0x73, 0x74)
	o = (*z).VoteTrackerRound.Freshest.MarshalMsg(o)
	// string "Ok"
	o = append(o, 0xa2, 0x4f, 0x6b)
	o = msgp.AppendBool(o, (*z).VoteTrackerRound.Ok)
	return
}

func (_ *roundRouter) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*roundRouter)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *roundRouter) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0003 int
	var zb0004 bool
	zb0003, zb0004, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0003, zb0004, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0003 > 0 {
			zb0003--
			bts, err = (*z).ProposalStore.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "ProposalStore")
				return
			}
		}
		if zb0003 > 0 {
			zb0003--
			var zb0005 int
			var zb0006 bool
			zb0005, zb0006, bts, err = msgp.ReadMapHeaderBytes(bts)
			if _, ok := err.(msgp.TypeError); ok {
				zb0005, zb0006, bts, err = msgp.ReadArrayHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "VoteTrackerRound")
					return
				}
				if zb0005 > 0 {
					zb0005--
					bts, err = (*z).VoteTrackerRound.Freshest.UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "VoteTrackerRound", "struct-from-array", "Freshest")
						return
					}
				}
				if zb0005 > 0 {
					zb0005--
					(*z).VoteTrackerRound.Ok, bts, err = msgp.ReadBoolBytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "VoteTrackerRound", "struct-from-array", "Ok")
						return
					}
				}
				if zb0005 > 0 {
					err = msgp.ErrTooManyArrayFields(zb0005)
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "VoteTrackerRound", "struct-from-array")
						return
					}
				}
			} else {
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "VoteTrackerRound")
					return
				}
				if zb0006 {
					(*z).VoteTrackerRound = voteTrackerRound{}
				}
				for zb0005 > 0 {
					zb0005--
					field, bts, err = msgp.ReadMapKeyZC(bts)
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "VoteTrackerRound")
						return
					}
					switch string(field) {
					case "Freshest":
						bts, err = (*z).VoteTrackerRound.Freshest.UnmarshalMsgWithState(bts, st)
						if err != nil {
							err = msgp.WrapError(err, "struct-from-array", "VoteTrackerRound", "Freshest")
							return
						}
					case "Ok":
						(*z).VoteTrackerRound.Ok, bts, err = msgp.ReadBoolBytes(bts)
						if err != nil {
							err = msgp.WrapError(err, "struct-from-array", "VoteTrackerRound", "Ok")
							return
						}
					default:
						err = msgp.ErrNoField(string(field))
						if err != nil {
							err = msgp.WrapError(err, "struct-from-array", "VoteTrackerRound")
							return
						}
					}
				}
			}
		}
		if zb0003 > 0 {
			zb0003--
			var zb0007 int
			var zb0008 bool
			zb0007, zb0008, bts, err = msgp.ReadMapHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Children")
				return
			}
			if zb0008 {
				(*z).Children = nil
			} else if (*z).Children == nil {
				(*z).Children = make(map[period]*periodRouter, zb0007)
			}
			for zb0007 > 0 {
				var zb0001 period
				var zb0002 *periodRouter
				zb0007--
				bts, err = zb0001.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Children")
					return
				}
				if msgp.IsNil(bts) {
					bts, err = msgp.ReadNilBytes(bts)
					if err != nil {
						return
					}
					zb0002 = nil
				} else {
					if zb0002 == nil {
						zb0002 = new(periodRouter)
					}
					bts, err = zb0002.UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "Children", zb0001)
						return
					}
				}
				(*z).Children[zb0001] = zb0002
			}
		}
		if zb0003 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0003)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0004 {
			(*z) = roundRouter{}
		}
		for zb0003 > 0 {
			zb0003--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "ProposalStore":
				bts, err = (*z).ProposalStore.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "ProposalStore")
					return
				}
			case "VoteTrackerRound":
				var zb0009 int
				var zb0010 bool
				zb0009, zb0010, bts, err = msgp.ReadMapHeaderBytes(bts)
				if _, ok := err.(msgp.TypeError); ok {
					zb0009, zb0010, bts, err = msgp.ReadArrayHeaderBytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "VoteTrackerRound")
						return
					}
					if zb0009 > 0 {
						zb0009--
						bts, err = (*z).VoteTrackerRound.Freshest.UnmarshalMsgWithState(bts, st)
						if err != nil {
							err = msgp.WrapError(err, "VoteTrackerRound", "struct-from-array", "Freshest")
							return
						}
					}
					if zb0009 > 0 {
						zb0009--
						(*z).VoteTrackerRound.Ok, bts, err = msgp.ReadBoolBytes(bts)
						if err != nil {
							err = msgp.WrapError(err, "VoteTrackerRound", "struct-from-array", "Ok")
							return
						}
					}
					if zb0009 > 0 {
						err = msgp.ErrTooManyArrayFields(zb0009)
						if err != nil {
							err = msgp.WrapError(err, "VoteTrackerRound", "struct-from-array")
							return
						}
					}
				} else {
					if err != nil {
						err = msgp.WrapError(err, "VoteTrackerRound")
						return
					}
					if zb0010 {
						(*z).VoteTrackerRound = voteTrackerRound{}
					}
					for zb0009 > 0 {
						zb0009--
						field, bts, err = msgp.ReadMapKeyZC(bts)
						if err != nil {
							err = msgp.WrapError(err, "VoteTrackerRound")
							return
						}
						switch string(field) {
						case "Freshest":
							bts, err = (*z).VoteTrackerRound.Freshest.UnmarshalMsgWithState(bts, st)
							if err != nil {
								err = msgp.WrapError(err, "VoteTrackerRound", "Freshest")
								return
							}
						case "Ok":
							(*z).VoteTrackerRound.Ok, bts, err = msgp.ReadBoolBytes(bts)
							if err != nil {
								err = msgp.WrapError(err, "VoteTrackerRound", "Ok")
								return
							}
						default:
							err = msgp.ErrNoField(string(field))
							if err != nil {
								err = msgp.WrapError(err, "VoteTrackerRound")
								return
							}
						}
					}
				}
			case "Children":
				var zb0011 int
				var zb0012 bool
				zb0011, zb0012, bts, err = msgp.ReadMapHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Children")
					return
				}
				if zb0012 {
					(*z).Children = nil
				} else if (*z).Children == nil {
					(*z).Children = make(map[period]*periodRouter, zb0011)
				}
				for zb0011 > 0 {
					var zb0001 period
					var zb0002 *periodRouter
					zb0011--
					bts, err = zb0001.UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "Children")
						return
					}
					if msgp.IsNil(bts) {
						bts, err = msgp.ReadNilBytes(bts)
						if err != nil {
							return
						}
						zb0002 = nil
					} else {
						if zb0002 == nil {
							zb0002 = new(periodRouter)
						}
						bts, err = zb0002.UnmarshalMsgWithState(bts, st)
						if err != nil {
							err = msgp.WrapError(err, "Children", zb0001)
							return
						}
					}
					(*z).Children[zb0001] = zb0002
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *roundRouter) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *roundRouter) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*roundRouter)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *roundRouter) Msgsize() (s int) {
	s = 1 + 14 + (*z).ProposalStore.Msgsize() + 17 + 1 + 9 + (*z).VoteTrackerRound.Freshest.Msgsize() + 3 + msgp.BoolSize + 9 + msgp.MapHeaderSize
	if (*z).Children != nil {
		for zb0001, zb0002 := range (*z).Children {
			_ = zb0001
			_ = zb0002
			s += 0 + zb0001.Msgsize()
			if zb0002 == nil {
				s += msgp.NilSize
			} else {
				s += zb0002.Msgsize()
			}
		}
	}
	return
}

// MsgIsZero returns whether this is a zero value
func (z *roundRouter) MsgIsZero() bool {
	return ((*z).ProposalStore.MsgIsZero()) && (((*z).VoteTrackerRound.Freshest.MsgIsZero()) && ((*z).VoteTrackerRound.Ok == false)) && (len((*z).Children) == 0)
}

// MaxSize returns a maximum valid message size for this message type
func RoundRouterMaxSize() (s int) {
	s = 1 + 14 + ProposalStoreMaxSize() + 17 + 1 + 9 + ThresholdEventMaxSize() + 3 + msgp.BoolSize + 9
	s += msgp.MapHeaderSize
	panic("Map z.Children is unbounded")
}

// MarshalMsg implements msgp.Marshaler
func (z *seedInput) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 2
	// string "alpha"
	o = append(o, 0x82, 0xa5, 0x61, 0x6c, 0x70, 0x68, 0x61)
	o = (*z).Alpha.MarshalMsg(o)
	// string "hist"
	o = append(o, 0xa4, 0x68, 0x69, 0x73, 0x74)
	o = (*z).History.MarshalMsg(o)
	return
}

func (_ *seedInput) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*seedInput)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *seedInput) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0001 int
	var zb0002 bool
	zb0001, zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0001, zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).Alpha.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Alpha")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).History.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "History")
				return
			}
		}
		if zb0001 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0001)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 {
			(*z) = seedInput{}
		}
		for zb0001 > 0 {
			zb0001--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "alpha":
				bts, err = (*z).Alpha.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Alpha")
					return
				}
			case "hist":
				bts, err = (*z).History.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "History")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *seedInput) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *seedInput) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*seedInput)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *seedInput) Msgsize() (s int) {
	s = 1 + 6 + (*z).Alpha.Msgsize() + 5 + (*z).History.Msgsize()
	return
}

// MsgIsZero returns whether this is a zero value
func (z *seedInput) MsgIsZero() bool {
	return ((*z).Alpha.MsgIsZero()) && ((*z).History.MsgIsZero())
}

// MaxSize returns a maximum valid message size for this message type
func SeedInputMaxSize() (s int) {
	s = 1 + 6 + crypto.DigestMaxSize() + 5 + crypto.DigestMaxSize()
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *selector) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 4
	// string "per"
	o = append(o, 0x84, 0xa3, 0x70, 0x65, 0x72)
	o = msgp.AppendUint64(o, uint64((*z).Period))
	// string "rnd"
	o = append(o, 0xa3, 0x72, 0x6e, 0x64)
	o = (*z).Round.MarshalMsg(o)
	// string "seed"
	o = append(o, 0xa4, 0x73, 0x65, 0x65, 0x64)
	o = (*z).Seed.MarshalMsg(o)
	// string "step"
	o = append(o, 0xa4, 0x73, 0x74, 0x65, 0x70)
	o = msgp.AppendUint64(o, uint64((*z).Step))
	return
}

func (_ *selector) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*selector)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *selector) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0001 int
	var zb0002 bool
	zb0001, zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0001, zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).Seed.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Seed")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).Round.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Round")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			{
				var zb0003 uint64
				zb0003, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Period")
					return
				}
				(*z).Period = period(zb0003)
			}
		}
		if zb0001 > 0 {
			zb0001--
			{
				var zb0004 uint64
				zb0004, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Step")
					return
				}
				(*z).Step = step(zb0004)
			}
		}
		if zb0001 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0001)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 {
			(*z) = selector{}
		}
		for zb0001 > 0 {
			zb0001--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "seed":
				bts, err = (*z).Seed.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Seed")
					return
				}
			case "rnd":
				bts, err = (*z).Round.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Round")
					return
				}
			case "per":
				{
					var zb0005 uint64
					zb0005, bts, err = msgp.ReadUint64Bytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "Period")
						return
					}
					(*z).Period = period(zb0005)
				}
			case "step":
				{
					var zb0006 uint64
					zb0006, bts, err = msgp.ReadUint64Bytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "Step")
						return
					}
					(*z).Step = step(zb0006)
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *selector) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *selector) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*selector)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *selector) Msgsize() (s int) {
	s = 1 + 5 + (*z).Seed.Msgsize() + 4 + (*z).Round.Msgsize() + 4 + msgp.Uint64Size + 5 + msgp.Uint64Size
	return
}

// MsgIsZero returns whether this is a zero value
func (z *selector) MsgIsZero() bool {
	return ((*z).Seed.MsgIsZero()) && ((*z).Round.MsgIsZero()) && ((*z).Period == 0) && ((*z).Step == 0)
}

// MaxSize returns a maximum valid message size for this message type
func SelectorMaxSize() (s int) {
	s = 1 + 5 + committee.SeedMaxSize() + 4 + basics.RoundMaxSize() + 4 + msgp.Uint64Size + 5 + msgp.Uint64Size
	return
}

// MarshalMsg implements msgp.Marshaler
func (z serializableError) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	o = msgp.AppendString(o, string(z))
	return
}

func (_ serializableError) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(serializableError)
	if !ok {
		_, ok = (z).(*serializableError)
	}
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *serializableError) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	{
		var zb0001 string
		zb0001, bts, err = msgp.ReadStringBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		(*z) = serializableError(zb0001)
	}
	o = bts
	return
}

func (z *serializableError) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *serializableError) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*serializableError)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z serializableError) Msgsize() (s int) {
	s = msgp.StringPrefixSize + len(string(z))
	return
}

// MsgIsZero returns whether this is a zero value
func (z serializableError) MsgIsZero() bool {
	return z == ""
}

// MaxSize returns a maximum valid message size for this message type
func SerializableErrorMaxSize() (s int) {
	panic("Unable to determine max size: String type string(z) is unbounded")
}

// MarshalMsg implements msgp.Marshaler
func (z step) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	o = msgp.AppendUint64(o, uint64(z))
	return
}

func (_ step) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(step)
	if !ok {
		_, ok = (z).(*step)
	}
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *step) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	{
		var zb0001 uint64
		zb0001, bts, err = msgp.ReadUint64Bytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		(*z) = step(zb0001)
	}
	o = bts
	return
}

func (z *step) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *step) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*step)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z step) Msgsize() (s int) {
	s = msgp.Uint64Size
	return
}

// MsgIsZero returns whether this is a zero value
func (z step) MsgIsZero() bool {
	return z == 0
}

// MaxSize returns a maximum valid message size for this message type
func StepMaxSize() (s int) {
	s = msgp.Uint64Size
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *stepRouter) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 2
	// string "VoteTracker"
	o = append(o, 0x82, 0xab, 0x56, 0x6f, 0x74, 0x65, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x65, 0x72)
	o = (*z).VoteTracker.MarshalMsg(o)
	// string "VoteTrackerContract"
	o = append(o, 0xb3, 0x56, 0x6f, 0x74, 0x65, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x65, 0x72, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x61, 0x63, 0x74)
	o = (*z).VoteTrackerContract.MarshalMsg(o)
	return
}

func (_ *stepRouter) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*stepRouter)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *stepRouter) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0001 int
	var zb0002 bool
	zb0001, zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0001, zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).VoteTracker.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "VoteTracker")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).VoteTrackerContract.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "VoteTrackerContract")
				return
			}
		}
		if zb0001 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0001)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 {
			(*z) = stepRouter{}
		}
		for zb0001 > 0 {
			zb0001--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "VoteTracker":
				bts, err = (*z).VoteTracker.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "VoteTracker")
					return
				}
			case "VoteTrackerContract":
				bts, err = (*z).VoteTrackerContract.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "VoteTrackerContract")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *stepRouter) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *stepRouter) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*stepRouter)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *stepRouter) Msgsize() (s int) {
	s = 1 + 12 + (*z).VoteTracker.Msgsize() + 20 + (*z).VoteTrackerContract.Msgsize()
	return
}

// MsgIsZero returns whether this is a zero value
func (z *stepRouter) MsgIsZero() bool {
	return ((*z).VoteTracker.MsgIsZero()) && ((*z).VoteTrackerContract.MsgIsZero())
}

// MaxSize returns a maximum valid message size for this message type
func StepRouterMaxSize() (s int) {
	s = 1 + 12 + VoteTrackerMaxSize() + 20 + VoteTrackerContractMaxSize()
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *thresholdEvent) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 7
	// string "Bundle"
	o = append(o, 0x87, 0xa6, 0x42, 0x75, 0x6e, 0x64, 0x6c, 0x65)
	o = (*z).Bundle.MarshalMsg(o)
	// string "Period"
	o = append(o, 0xa6, 0x50, 0x65, 0x72, 0x69, 0x6f, 0x64)
	o = msgp.AppendUint64(o, uint64((*z).Period))
	// string "Proposal"
	o = append(o, 0xa8, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c)
	o = (*z).Proposal.MarshalMsg(o)
	// string "Proto"
	o = append(o, 0xa5, 0x50, 0x72, 0x6f, 0x74, 0x6f)
	o = (*z).Proto.MarshalMsg(o)
	// string "Round"
	o = append(o, 0xa5, 0x52, 0x6f, 0x75, 0x6e, 0x64)
	o = (*z).Round.MarshalMsg(o)
	// string "Step"
	o = append(o, 0xa4, 0x53, 0x74, 0x65, 0x70)
	o = msgp.AppendUint64(o, uint64((*z).Step))
	// string "T"
	o = append(o, 0xa1, 0x54)
	o = msgp.AppendUint8(o, uint8((*z).T))
	return
}

func (_ *thresholdEvent) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*thresholdEvent)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *thresholdEvent) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0001 int
	var zb0002 bool
	zb0001, zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0001, zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0001 > 0 {
			zb0001--
			{
				var zb0003 uint8
				zb0003, bts, err = msgp.ReadUint8Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "T")
					return
				}
				(*z).T = eventType(zb0003)
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).Round.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Round")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			{
				var zb0004 uint64
				zb0004, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Period")
					return
				}
				(*z).Period = period(zb0004)
			}
		}
		if zb0001 > 0 {
			zb0001--
			{
				var zb0005 uint64
				zb0005, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Step")
					return
				}
				(*z).Step = step(zb0005)
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).Proposal.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Proposal")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).Bundle.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Bundle")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).Proto.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Proto")
				return
			}
		}
		if zb0001 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0001)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 {
			(*z) = thresholdEvent{}
		}
		for zb0001 > 0 {
			zb0001--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "T":
				{
					var zb0006 uint8
					zb0006, bts, err = msgp.ReadUint8Bytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "T")
						return
					}
					(*z).T = eventType(zb0006)
				}
			case "Round":
				bts, err = (*z).Round.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Round")
					return
				}
			case "Period":
				{
					var zb0007 uint64
					zb0007, bts, err = msgp.ReadUint64Bytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "Period")
						return
					}
					(*z).Period = period(zb0007)
				}
			case "Step":
				{
					var zb0008 uint64
					zb0008, bts, err = msgp.ReadUint64Bytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "Step")
						return
					}
					(*z).Step = step(zb0008)
				}
			case "Proposal":
				bts, err = (*z).Proposal.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Proposal")
					return
				}
			case "Bundle":
				bts, err = (*z).Bundle.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Bundle")
					return
				}
			case "Proto":
				bts, err = (*z).Proto.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Proto")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *thresholdEvent) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *thresholdEvent) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*thresholdEvent)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *thresholdEvent) Msgsize() (s int) {
	s = 1 + 2 + msgp.Uint8Size + 6 + (*z).Round.Msgsize() + 7 + msgp.Uint64Size + 5 + msgp.Uint64Size + 9 + (*z).Proposal.Msgsize() + 7 + (*z).Bundle.Msgsize() + 6 + (*z).Proto.Msgsize()
	return
}

// MsgIsZero returns whether this is a zero value
func (z *thresholdEvent) MsgIsZero() bool {
	return ((*z).T == 0) && ((*z).Round.MsgIsZero()) && ((*z).Period == 0) && ((*z).Step == 0) && ((*z).Proposal.MsgIsZero()) && ((*z).Bundle.MsgIsZero()) && ((*z).Proto.MsgIsZero())
}

// MaxSize returns a maximum valid message size for this message type
func ThresholdEventMaxSize() (s int) {
	s = 1 + 2 + msgp.Uint8Size + 6 + basics.RoundMaxSize() + 7 + msgp.Uint64Size + 5 + msgp.Uint64Size + 9 + ProposalValueMaxSize() + 7 + UnauthenticatedBundleMaxSize() + 6 + protocol.ConsensusVersionMaxSize()
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *transmittedPayload) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0005Len := uint32(37)
	var zb0005Mask uint64 /* 45 bits */
	if (*z).unauthenticatedProposal.Block.BlockHeader.Bonus.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x80
	}
	if (*z).unauthenticatedProposal.Block.BlockHeader.RewardsState.RewardsLevel == 0 {
		zb0005Len--
		zb0005Mask |= 0x100
	}
	if (*z).unauthenticatedProposal.Block.BlockHeader.FeesCollected.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x200
	}
	if (*z).unauthenticatedProposal.Block.BlockHeader.RewardsState.FeeSink.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x400
	}
	if (*z).unauthenticatedProposal.Block.BlockHeader.RewardsState.RewardsResidue == 0 {
		zb0005Len--
		zb0005Mask |= 0x800
	}
	if (*z).unauthenticatedProposal.Block.BlockHeader.GenesisID == "" {
		zb0005Len--
		zb0005Mask |= 0x1000
	}
	if (*z).unauthenticatedProposal.Block.BlockHeader.GenesisHash.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x2000
	}
	if (*z).unauthenticatedProposal.Block.BlockHeader.UpgradeState.NextProtocolVoteBefore.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x4000
	}
	if (*z).unauthenticatedProposal.Block.BlockHeader.UpgradeState.NextProtocol.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x8000
	}
	if (*z).unauthenticatedProposal.Block.BlockHeader.UpgradeState.NextProtocolSwitchOn.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x10000
	}
	if (*z).unauthenticatedProposal.Block.BlockHeader.UpgradeState.NextProtocolApprovals.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x20000
	}
	if (*z).unauthenticatedProposal.OriginalPeriod == 0 {
		zb0005Len--
		zb0005Mask |= 0x40000
	}
	if (*z).unauthenticatedProposal.OriginalProposer.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x80000
	}
	if len((*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.AbsentParticipationAccounts) == 0 {
		zb0005Len--
		zb0005Mask |= 0x100000
	}
	if len((*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts) == 0 {
		zb0005Len--
		zb0005Mask |= 0x200000
	}
	if (*z).unauthenticatedProposal.Block.BlockHeader.ProposerPayout.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x400000
	}
	if (*z).unauthenticatedProposal.Block.BlockHeader.Branch.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x800000
	}
	if (*z).unauthenticatedProposal.Block.BlockHeader.Branch512.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x1000000
	}
	if (*z).unauthenticatedProposal.Block.BlockHeader.UpgradeState.CurrentProtocol.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x2000000
	}
	if (*z).unauthenticatedProposal.Block.BlockHeader.Proposer.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x4000000
	}
	if (*z).PriorVote.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x8000000
	}
	if (*z).unauthenticatedProposal.Block.BlockHeader.RewardsState.RewardsRate == 0 {
		zb0005Len--
		zb0005Mask |= 0x10000000
	}
	if (*z).unauthenticatedProposal.Block.BlockHeader.Round.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x40000000
	}
	if (*z).unauthenticatedProposal.Block.BlockHeader.RewardsState.RewardsRecalculationRound.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x80000000
	}
	if (*z).unauthenticatedProposal.Block.BlockHeader.RewardsState.RewardsPool.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x100000000
	}
	if (*z).unauthenticatedProposal.SeedProof.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x200000000
	}
	if (*z).unauthenticatedProposal.Block.BlockHeader.Seed.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x400000000
	}
	if len((*z).unauthenticatedProposal.Block.BlockHeader.StateProofTracking) == 0 {
		zb0005Len--
		zb0005Mask |= 0x800000000
	}
	if (*z).unauthenticatedProposal.Block.BlockHeader.TxnCounter == 0 {
		zb0005Len--
		zb0005Mask |= 0x1000000000
	}
	if (*z).unauthenticatedProposal.Block.BlockHeader.TimeStamp == 0 {
		zb0005Len--
		zb0005Mask |= 0x2000000000
	}
	if (*z).unauthenticatedProposal.Block.BlockHeader.TxnCommitments.NativeSha512_256Commitment.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x4000000000
	}
	if (*z).unauthenticatedProposal.Block.BlockHeader.TxnCommitments.Sha256Commitment.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x8000000000
	}
	if (*z).unauthenticatedProposal.Block.BlockHeader.TxnCommitments.Sha512Commitment.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x10000000000
	}
	if (*z).unauthenticatedProposal.Block.Payset.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x20000000000
	}
	if (*z).unauthenticatedProposal.Block.BlockHeader.UpgradeVote.UpgradeDelay.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x40000000000
	}
	if (*z).unauthenticatedProposal.Block.BlockHeader.UpgradeVote.UpgradePropose.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x80000000000
	}
	if (*z).unauthenticatedProposal.Block.BlockHeader.UpgradeVote.UpgradeApprove == false {
		zb0005Len--
		zb0005Mask |= 0x100000000000
	}
	// variable map header, size zb0005Len
	o = msgp.AppendMapHeader(o, zb0005Len)
	if zb0005Len != 0 {
		if (zb0005Mask & 0x80) == 0 { // if not empty
			// string "bi"
			o = append(o, 0xa2, 0x62, 0x69)
			o = (*z).unauthenticatedProposal.Block.BlockHeader.Bonus.MarshalMsg(o)
		}
		if (zb0005Mask & 0x100) == 0 { // if not empty
			// string "earn"
			o = append(o, 0xa4, 0x65, 0x61, 0x72, 0x6e)
			o = msgp.AppendUint64(o, (*z).unauthenticatedProposal.Block.BlockHeader.RewardsState.RewardsLevel)
		}
		if (zb0005Mask & 0x200) == 0 { // if not empty
			// string "fc"
			o = append(o, 0xa2, 0x66, 0x63)
			o = (*z).unauthenticatedProposal.Block.BlockHeader.FeesCollected.MarshalMsg(o)
		}
		if (zb0005Mask & 0x400) == 0 { // if not empty
			// string "fees"
			o = append(o, 0xa4, 0x66, 0x65, 0x65, 0x73)
			o = (*z).unauthenticatedProposal.Block.BlockHeader.RewardsState.FeeSink.MarshalMsg(o)
		}
		if (zb0005Mask & 0x800) == 0 { // if not empty
			// string "frac"
			o = append(o, 0xa4, 0x66, 0x72, 0x61, 0x63)
			o = msgp.AppendUint64(o, (*z).unauthenticatedProposal.Block.BlockHeader.RewardsState.RewardsResidue)
		}
		if (zb0005Mask & 0x1000) == 0 { // if not empty
			// string "gen"
			o = append(o, 0xa3, 0x67, 0x65, 0x6e)
			o = msgp.AppendString(o, (*z).unauthenticatedProposal.Block.BlockHeader.GenesisID)
		}
		if (zb0005Mask & 0x2000) == 0 { // if not empty
			// string "gh"
			o = append(o, 0xa2, 0x67, 0x68)
			o = (*z).unauthenticatedProposal.Block.BlockHeader.GenesisHash.MarshalMsg(o)
		}
		if (zb0005Mask & 0x4000) == 0 { // if not empty
			// string "nextbefore"
			o = append(o, 0xaa, 0x6e, 0x65, 0x78, 0x74, 0x62, 0x65, 0x66, 0x6f, 0x72, 0x65)
			o = (*z).unauthenticatedProposal.Block.BlockHeader.UpgradeState.NextProtocolVoteBefore.MarshalMsg(o)
		}
		if (zb0005Mask & 0x8000) == 0 { // if not empty
			// string "nextproto"
			o = append(o, 0xa9, 0x6e, 0x65, 0x78, 0x74, 0x70, 0x72, 0x6f, 0x74, 0x6f)
			o = (*z).unauthenticatedProposal.Block.BlockHeader.UpgradeState.NextProtocol.MarshalMsg(o)
		}
		if (zb0005Mask & 0x10000) == 0 { // if not empty
			// string "nextswitch"
			o = append(o, 0xaa, 0x6e, 0x65, 0x78, 0x74, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68)
			o = (*z).unauthenticatedProposal.Block.BlockHeader.UpgradeState.NextProtocolSwitchOn.MarshalMsg(o)
		}
		if (zb0005Mask & 0x20000) == 0 { // if not empty
			// string "nextyes"
			o = append(o, 0xa7, 0x6e, 0x65, 0x78, 0x74, 0x79, 0x65, 0x73)
			o = (*z).unauthenticatedProposal.Block.BlockHeader.UpgradeState.NextProtocolApprovals.MarshalMsg(o)
		}
		if (zb0005Mask & 0x40000) == 0 { // if not empty
			// string "oper"
			o = append(o, 0xa4, 0x6f, 0x70, 0x65, 0x72)
			o = msgp.AppendUint64(o, uint64((*z).unauthenticatedProposal.OriginalPeriod))
		}
		if (zb0005Mask & 0x80000) == 0 { // if not empty
			// string "oprop"
			o = append(o, 0xa5, 0x6f, 0x70, 0x72, 0x6f, 0x70)
			o = (*z).unauthenticatedProposal.OriginalProposer.MarshalMsg(o)
		}
		if (zb0005Mask & 0x100000) == 0 { // if not empty
			// string "partupdabs"
			o = append(o, 0xaa, 0x70, 0x61, 0x72, 0x74, 0x75, 0x70, 0x64, 0x61, 0x62, 0x73)
			if (*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.AbsentParticipationAccounts == nil {
				o = msgp.AppendNil(o)
			} else {
				o = msgp.AppendArrayHeader(o, uint32(len((*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.AbsentParticipationAccounts)))
			}
			for zb0004 := range (*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.AbsentParticipationAccounts {
				o = (*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.AbsentParticipationAccounts[zb0004].MarshalMsg(o)
			}
		}
		if (zb0005Mask & 0x200000) == 0 { // if not empty
			// string "partupdrmv"
			o = append(o, 0xaa, 0x70, 0x61, 0x72, 0x74, 0x75, 0x70, 0x64, 0x72, 0x6d, 0x76)
			if (*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts == nil {
				o = msgp.AppendNil(o)
			} else {
				o = msgp.AppendArrayHeader(o, uint32(len((*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts)))
			}
			for zb0003 := range (*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts {
				o = (*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts[zb0003].MarshalMsg(o)
			}
		}
		if (zb0005Mask & 0x400000) == 0 { // if not empty
			// string "pp"
			o = append(o, 0xa2, 0x70, 0x70)
			o = (*z).unauthenticatedProposal.Block.BlockHeader.ProposerPayout.MarshalMsg(o)
		}
		if (zb0005Mask & 0x800000) == 0 { // if not empty
			// string "prev"
			o = append(o, 0xa4, 0x70, 0x72, 0x65, 0x76)
			o = (*z).unauthenticatedProposal.Block.BlockHeader.Branch.MarshalMsg(o)
		}
		if (zb0005Mask & 0x1000000) == 0 { // if not empty
			// string "prev512"
			o = append(o, 0xa7, 0x70, 0x72, 0x65, 0x76, 0x35, 0x31, 0x32)
			o = (*z).unauthenticatedProposal.Block.BlockHeader.Branch512.MarshalMsg(o)
		}
		if (zb0005Mask & 0x2000000) == 0 { // if not empty
			// string "proto"
			o = append(o, 0xa5, 0x70, 0x72, 0x6f, 0x74, 0x6f)
			o = (*z).unauthenticatedProposal.Block.BlockHeader.UpgradeState.CurrentProtocol.MarshalMsg(o)
		}
		if (zb0005Mask & 0x4000000) == 0 { // if not empty
			// string "prp"
			o = append(o, 0xa3, 0x70, 0x72, 0x70)
			o = (*z).unauthenticatedProposal.Block.BlockHeader.Proposer.MarshalMsg(o)
		}
		if (zb0005Mask & 0x8000000) == 0 { // if not empty
			// string "pv"
			o = append(o, 0xa2, 0x70, 0x76)
			o = (*z).PriorVote.MarshalMsg(o)
		}
		if (zb0005Mask & 0x10000000) == 0 { // if not empty
			// string "rate"
			o = append(o, 0xa4, 0x72, 0x61, 0x74, 0x65)
			o = msgp.AppendUint64(o, (*z).unauthenticatedProposal.Block.BlockHeader.RewardsState.RewardsRate)
		}
		if (zb0005Mask & 0x40000000) == 0 { // if not empty
			// string "rnd"
			o = append(o, 0xa3, 0x72, 0x6e, 0x64)
			o = (*z).unauthenticatedProposal.Block.BlockHeader.Round.MarshalMsg(o)
		}
		if (zb0005Mask & 0x80000000) == 0 { // if not empty
			// string "rwcalr"
			o = append(o, 0xa6, 0x72, 0x77, 0x63, 0x61, 0x6c, 0x72)
			o = (*z).unauthenticatedProposal.Block.BlockHeader.RewardsState.RewardsRecalculationRound.MarshalMsg(o)
		}
		if (zb0005Mask & 0x100000000) == 0 { // if not empty
			// string "rwd"
			o = append(o, 0xa3, 0x72, 0x77, 0x64)
			o = (*z).unauthenticatedProposal.Block.BlockHeader.RewardsState.RewardsPool.MarshalMsg(o)
		}
		if (zb0005Mask & 0x200000000) == 0 { // if not empty
			// string "sdpf"
			o = append(o, 0xa4, 0x73, 0x64, 0x70, 0x66)
			o = (*z).unauthenticatedProposal.SeedProof.MarshalMsg(o)
		}
		if (zb0005Mask & 0x400000000) == 0 { // if not empty
			// string "seed"
			o = append(o, 0xa4, 0x73, 0x65, 0x65, 0x64)
			o = (*z).unauthenticatedProposal.Block.BlockHeader.Seed.MarshalMsg(o)
		}
		if (zb0005Mask & 0x800000000) == 0 { // if not empty
			// string "spt"
			o = append(o, 0xa3, 0x73, 0x70, 0x74)
			if (*z).unauthenticatedProposal.Block.BlockHeader.StateProofTracking == nil {
				o = msgp.AppendNil(o)
			} else {
				o = msgp.AppendMapHeader(o, uint32(len((*z).unauthenticatedProposal.Block.BlockHeader.StateProofTracking)))
			}
			zb0001_keys := make([]protocol.StateProofType, 0, len((*z).unauthenticatedProposal.Block.BlockHeader.StateProofTracking))
			for zb0001 := range (*z).unauthenticatedProposal.Block.BlockHeader.StateProofTracking {
				zb0001_keys = append(zb0001_keys, zb0001)
			}
			sort.Sort(protocol.SortStateProofType(zb0001_keys))
			for _, zb0001 := range zb0001_keys {
				zb0002 := (*z).unauthenticatedProposal.Block.BlockHeader.StateProofTracking[zb0001]
				_ = zb0002
				o = zb0001.MarshalMsg(o)
				o = zb0002.MarshalMsg(o)
			}
		}
		if (zb0005Mask & 0x1000000000) == 0 { // if not empty
			// string "tc"
			o = append(o, 0xa2, 0x74, 0x63)
			o = msgp.AppendUint64(o, (*z).unauthenticatedProposal.Block.BlockHeader.TxnCounter)
		}
		if (zb0005Mask & 0x2000000000) == 0 { // if not empty
			// string "ts"
			o = append(o, 0xa2, 0x74, 0x73)
			o = msgp.AppendInt64(o, (*z).unauthenticatedProposal.Block.BlockHeader.TimeStamp)
		}
		if (zb0005Mask & 0x4000000000) == 0 { // if not empty
			// string "txn"
			o = append(o, 0xa3, 0x74, 0x78, 0x6e)
			o = (*z).unauthenticatedProposal.Block.BlockHeader.TxnCommitments.NativeSha512_256Commitment.MarshalMsg(o)
		}
		if (zb0005Mask & 0x8000000000) == 0 { // if not empty
			// string "txn256"
			o = append(o, 0xa6, 0x74, 0x78, 0x6e, 0x32, 0x35, 0x36)
			o = (*z).unauthenticatedProposal.Block.BlockHeader.TxnCommitments.Sha256Commitment.MarshalMsg(o)
		}
		if (zb0005Mask & 0x10000000000) == 0 { // if not empty
			// string "txn512"
			o = append(o, 0xa6, 0x74, 0x78, 0x6e, 0x35, 0x31, 0x32)
			o = (*z).unauthenticatedProposal.Block.BlockHeader.TxnCommitments.Sha512Commitment.MarshalMsg(o)
		}
		if (zb0005Mask & 0x20000000000) == 0 { // if not empty
			// string "txns"
			o = append(o, 0xa4, 0x74, 0x78, 0x6e, 0x73)
			o = (*z).unauthenticatedProposal.Block.Payset.MarshalMsg(o)
		}
		if (zb0005Mask & 0x40000000000) == 0 { // if not empty
			// string "upgradedelay"
			o = append(o, 0xac, 0x75, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x64, 0x65, 0x6c, 0x61, 0x79)
			o = (*z).unauthenticatedProposal.Block.BlockHeader.UpgradeVote.UpgradeDelay.MarshalMsg(o)
		}
		if (zb0005Mask & 0x80000000000) == 0 { // if not empty
			// string "upgradeprop"
			o = append(o, 0xab, 0x75, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x70, 0x72, 0x6f, 0x70)
			o = (*z).unauthenticatedProposal.Block.BlockHeader.UpgradeVote.UpgradePropose.MarshalMsg(o)
		}
		if (zb0005Mask & 0x100000000000) == 0 { // if not empty
			// string "upgradeyes"
			o = append(o, 0xaa, 0x75, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x79, 0x65, 0x73)
			o = msgp.AppendBool(o, (*z).unauthenticatedProposal.Block.BlockHeader.UpgradeVote.UpgradeApprove)
		}
	}
	return
}

func (_ *transmittedPayload) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*transmittedPayload)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *transmittedPayload) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0005 int
	var zb0006 bool
	zb0005, zb0006, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0005, zb0006, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.Round.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Round")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.Branch.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Branch")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.Branch512.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Branch512")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.Seed.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Seed")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.TxnCommitments.NativeSha512_256Commitment.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "NativeSha512_256Commitment")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.TxnCommitments.Sha256Commitment.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Sha256Commitment")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.TxnCommitments.Sha512Commitment.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Sha512Commitment")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			(*z).unauthenticatedProposal.Block.BlockHeader.TimeStamp, bts, err = msgp.ReadInt64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "TimeStamp")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			var zb0007 int
			zb0007, err = msgp.ReadBytesBytesHeader(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "GenesisID")
				return
			}
			if zb0007 > bounds.MaxGenesisIDLen {
				err = msgp.ErrOverflow(uint64(zb0007), uint64(bounds.MaxGenesisIDLen))
				return
			}
			(*z).unauthenticatedProposal.Block.BlockHeader.GenesisID, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "GenesisID")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.GenesisHash.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "GenesisHash")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.Proposer.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Proposer")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.FeesCollected.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "FeesCollected")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.Bonus.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Bonus")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.ProposerPayout.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "ProposerPayout")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.RewardsState.FeeSink.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "FeeSink")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.RewardsState.RewardsPool.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "RewardsPool")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			(*z).unauthenticatedProposal.Block.BlockHeader.RewardsState.RewardsLevel, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "RewardsLevel")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			(*z).unauthenticatedProposal.Block.BlockHeader.RewardsState.RewardsRate, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "RewardsRate")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			(*z).unauthenticatedProposal.Block.BlockHeader.RewardsState.RewardsResidue, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "RewardsResidue")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.RewardsState.RewardsRecalculationRound.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "RewardsRecalculationRound")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.UpgradeState.CurrentProtocol.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "CurrentProtocol")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.UpgradeState.NextProtocol.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "NextProtocol")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.UpgradeState.NextProtocolApprovals.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "NextProtocolApprovals")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.UpgradeState.NextProtocolVoteBefore.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "NextProtocolVoteBefore")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.UpgradeState.NextProtocolSwitchOn.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "NextProtocolSwitchOn")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.UpgradeVote.UpgradePropose.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "UpgradePropose")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.UpgradeVote.UpgradeDelay.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "UpgradeDelay")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			(*z).unauthenticatedProposal.Block.BlockHeader.UpgradeVote.UpgradeApprove, bts, err = msgp.ReadBoolBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "UpgradeApprove")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			(*z).unauthenticatedProposal.Block.BlockHeader.TxnCounter, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "TxnCounter")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			var zb0008 int
			var zb0009 bool
			zb0008, zb0009, bts, err = msgp.ReadMapHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "StateProofTracking")
				return
			}
			if zb0008 > protocol.NumStateProofTypes {
				err = msgp.ErrOverflow(uint64(zb0008), uint64(protocol.NumStateProofTypes))
				err = msgp.WrapError(err, "struct-from-array", "StateProofTracking")
				return
			}
			if zb0009 {
				(*z).unauthenticatedProposal.Block.BlockHeader.StateProofTracking = nil
			} else if (*z).unauthenticatedProposal.Block.BlockHeader.StateProofTracking == nil {
				(*z).unauthenticatedProposal.Block.BlockHeader.StateProofTracking = make(map[protocol.StateProofType]bookkeeping.StateProofTrackingData, zb0008)
			}
			for zb0008 > 0 {
				var zb0001 protocol.StateProofType
				var zb0002 bookkeeping.StateProofTrackingData
				zb0008--
				bts, err = zb0001.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "StateProofTracking")
					return
				}
				bts, err = zb0002.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "StateProofTracking", zb0001)
					return
				}
				(*z).unauthenticatedProposal.Block.BlockHeader.StateProofTracking[zb0001] = zb0002
			}
		}
		if zb0005 > 0 {
			zb0005--
			var zb0010 int
			var zb0011 bool
			zb0010, zb0011, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "ExpiredParticipationAccounts")
				return
			}
			if zb0010 > bounds.MaxProposedExpiredOnlineAccounts {
				err = msgp.ErrOverflow(uint64(zb0010), uint64(bounds.MaxProposedExpiredOnlineAccounts))
				err = msgp.WrapError(err, "struct-from-array", "ExpiredParticipationAccounts")
				return
			}
			if zb0011 {
				(*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts = nil
			} else if (*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts != nil && cap((*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts) >= zb0010 {
				(*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts = ((*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts)[:zb0010]
			} else {
				(*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts = make([]basics.Address, zb0010)
			}
			for zb0003 := range (*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts {
				bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts[zb0003].UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "ExpiredParticipationAccounts", zb0003)
					return
				}
			}
		}
		if zb0005 > 0 {
			zb0005--
			var zb0012 int
			var zb0013 bool
			zb0012, zb0013, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "AbsentParticipationAccounts")
				return
			}
			if zb0012 > bounds.MaxMarkAbsent {
				err = msgp.ErrOverflow(uint64(zb0012), uint64(bounds.MaxMarkAbsent))
				err = msgp.WrapError(err, "struct-from-array", "AbsentParticipationAccounts")
				return
			}
			if zb0013 {
				(*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.AbsentParticipationAccounts = nil
			} else if (*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.AbsentParticipationAccounts != nil && cap((*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.AbsentParticipationAccounts) >= zb0012 {
				(*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.AbsentParticipationAccounts = ((*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.AbsentParticipationAccounts)[:zb0012]
			} else {
				(*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.AbsentParticipationAccounts = make([]basics.Address, zb0012)
			}
			for zb0004 := range (*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.AbsentParticipationAccounts {
				bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.AbsentParticipationAccounts[zb0004].UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "AbsentParticipationAccounts", zb0004)
					return
				}
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).unauthenticatedProposal.Block.Payset.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Payset")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).unauthenticatedProposal.SeedProof.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "SeedProof")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			{
				var zb0014 uint64
				zb0014, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "OriginalPeriod")
					return
				}
				(*z).unauthenticatedProposal.OriginalPeriod = period(zb0014)
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).unauthenticatedProposal.OriginalProposer.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "OriginalProposer")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).PriorVote.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "PriorVote")
				return
			}
		}
		if zb0005 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0005)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0006 {
			(*z) = transmittedPayload{}
		}
		for zb0005 > 0 {
			zb0005--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "rnd":
				bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.Round.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Round")
					return
				}
			case "prev":
				bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.Branch.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Branch")
					return
				}
			case "prev512":
				bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.Branch512.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Branch512")
					return
				}
			case "seed":
				bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.Seed.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Seed")
					return
				}
			case "txn":
				bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.TxnCommitments.NativeSha512_256Commitment.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "NativeSha512_256Commitment")
					return
				}
			case "txn256":
				bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.TxnCommitments.Sha256Commitment.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Sha256Commitment")
					return
				}
			case "txn512":
				bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.TxnCommitments.Sha512Commitment.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Sha512Commitment")
					return
				}
			case "ts":
				(*z).unauthenticatedProposal.Block.BlockHeader.TimeStamp, bts, err = msgp.ReadInt64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "TimeStamp")
					return
				}
			case "gen":
				var zb0015 int
				zb0015, err = msgp.ReadBytesBytesHeader(bts)
				if err != nil {
					err = msgp.WrapError(err, "GenesisID")
					return
				}
				if zb0015 > bounds.MaxGenesisIDLen {
					err = msgp.ErrOverflow(uint64(zb0015), uint64(bounds.MaxGenesisIDLen))
					return
				}
				(*z).unauthenticatedProposal.Block.BlockHeader.GenesisID, bts, err = msgp.ReadStringBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "GenesisID")
					return
				}
			case "gh":
				bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.GenesisHash.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "GenesisHash")
					return
				}
			case "prp":
				bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.Proposer.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Proposer")
					return
				}
			case "fc":
				bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.FeesCollected.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "FeesCollected")
					return
				}
			case "bi":
				bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.Bonus.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Bonus")
					return
				}
			case "pp":
				bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.ProposerPayout.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "ProposerPayout")
					return
				}
			case "fees":
				bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.RewardsState.FeeSink.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "FeeSink")
					return
				}
			case "rwd":
				bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.RewardsState.RewardsPool.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "RewardsPool")
					return
				}
			case "earn":
				(*z).unauthenticatedProposal.Block.BlockHeader.RewardsState.RewardsLevel, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "RewardsLevel")
					return
				}
			case "rate":
				(*z).unauthenticatedProposal.Block.BlockHeader.RewardsState.RewardsRate, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "RewardsRate")
					return
				}
			case "frac":
				(*z).unauthenticatedProposal.Block.BlockHeader.RewardsState.RewardsResidue, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "RewardsResidue")
					return
				}
			case "rwcalr":
				bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.RewardsState.RewardsRecalculationRound.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "RewardsRecalculationRound")
					return
				}
			case "proto":
				bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.UpgradeState.CurrentProtocol.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "CurrentProtocol")
					return
				}
			case "nextproto":
				bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.UpgradeState.NextProtocol.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "NextProtocol")
					return
				}
			case "nextyes":
				bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.UpgradeState.NextProtocolApprovals.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "NextProtocolApprovals")
					return
				}
			case "nextbefore":
				bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.UpgradeState.NextProtocolVoteBefore.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "NextProtocolVoteBefore")
					return
				}
			case "nextswitch":
				bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.UpgradeState.NextProtocolSwitchOn.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "NextProtocolSwitchOn")
					return
				}
			case "upgradeprop":
				bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.UpgradeVote.UpgradePropose.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "UpgradePropose")
					return
				}
			case "upgradedelay":
				bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.UpgradeVote.UpgradeDelay.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "UpgradeDelay")
					return
				}
			case "upgradeyes":
				(*z).unauthenticatedProposal.Block.BlockHeader.UpgradeVote.UpgradeApprove, bts, err = msgp.ReadBoolBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "UpgradeApprove")
					return
				}
			case "tc":
				(*z).unauthenticatedProposal.Block.BlockHeader.TxnCounter, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "TxnCounter")
					return
				}
			case "spt":
				var zb0016 int
				var zb0017 bool
				zb0016, zb0017, bts, err = msgp.ReadMapHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "StateProofTracking")
					return
				}
				if zb0016 > protocol.NumStateProofTypes {
					err = msgp.ErrOverflow(uint64(zb0016), uint64(protocol.NumStateProofTypes))
					err = msgp.WrapError(err, "StateProofTracking")
					return
				}
				if zb0017 {
					(*z).unauthenticatedProposal.Block.BlockHeader.StateProofTracking = nil
				} else if (*z).unauthenticatedProposal.Block.BlockHeader.StateProofTracking == nil {
					(*z).unauthenticatedProposal.Block.BlockHeader.StateProofTracking = make(map[protocol.StateProofType]bookkeeping.StateProofTrackingData, zb0016)
				}
				for zb0016 > 0 {
					var zb0001 protocol.StateProofType
					var zb0002 bookkeeping.StateProofTrackingData
					zb0016--
					bts, err = zb0001.UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "StateProofTracking")
						return
					}
					bts, err = zb0002.UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "StateProofTracking", zb0001)
						return
					}
					(*z).unauthenticatedProposal.Block.BlockHeader.StateProofTracking[zb0001] = zb0002
				}
			case "partupdrmv":
				var zb0018 int
				var zb0019 bool
				zb0018, zb0019, bts, err = msgp.ReadArrayHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "ExpiredParticipationAccounts")
					return
				}
				if zb0018 > bounds.MaxProposedExpiredOnlineAccounts {
					err = msgp.ErrOverflow(uint64(zb0018), uint64(bounds.MaxProposedExpiredOnlineAccounts))
					err = msgp.WrapError(err, "ExpiredParticipationAccounts")
					return
				}
				if zb0019 {
					(*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts = nil
				} else if (*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts != nil && cap((*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts) >= zb0018 {
					(*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts = ((*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts)[:zb0018]
				} else {
					(*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts = make([]basics.Address, zb0018)
				}
				for zb0003 := range (*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts {
					bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts[zb0003].UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "ExpiredParticipationAccounts", zb0003)
						return
					}
				}
			case "partupdabs":
				var zb0020 int
				var zb0021 bool
				zb0020, zb0021, bts, err = msgp.ReadArrayHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "AbsentParticipationAccounts")
					return
				}
				if zb0020 > bounds.MaxMarkAbsent {
					err = msgp.ErrOverflow(uint64(zb0020), uint64(bounds.MaxMarkAbsent))
					err = msgp.WrapError(err, "AbsentParticipationAccounts")
					return
				}
				if zb0021 {
					(*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.AbsentParticipationAccounts = nil
				} else if (*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.AbsentParticipationAccounts != nil && cap((*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.AbsentParticipationAccounts) >= zb0020 {
					(*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.AbsentParticipationAccounts = ((*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.AbsentParticipationAccounts)[:zb0020]
				} else {
					(*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.AbsentParticipationAccounts = make([]basics.Address, zb0020)
				}
				for zb0004 := range (*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.AbsentParticipationAccounts {
					bts, err = (*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.AbsentParticipationAccounts[zb0004].UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "AbsentParticipationAccounts", zb0004)
						return
					}
				}
			case "txns":
				bts, err = (*z).unauthenticatedProposal.Block.Payset.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Payset")
					return
				}
			case "sdpf":
				bts, err = (*z).unauthenticatedProposal.SeedProof.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "SeedProof")
					return
				}
			case "oper":
				{
					var zb0022 uint64
					zb0022, bts, err = msgp.ReadUint64Bytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "OriginalPeriod")
						return
					}
					(*z).unauthenticatedProposal.OriginalPeriod = period(zb0022)
				}
			case "oprop":
				bts, err = (*z).unauthenticatedProposal.OriginalProposer.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "OriginalProposer")
					return
				}
			case "pv":
				bts, err = (*z).PriorVote.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "PriorVote")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *transmittedPayload) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *transmittedPayload) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*transmittedPayload)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *transmittedPayload) Msgsize() (s int) {
	s = 3 + 4 + (*z).unauthenticatedProposal.Block.BlockHeader.Round.Msgsize() + 5 + (*z).unauthenticatedProposal.Block.BlockHeader.Branch.Msgsize() + 8 + (*z).unauthenticatedProposal.Block.BlockHeader.Branch512.Msgsize() + 5 + (*z).unauthenticatedProposal.Block.BlockHeader.Seed.Msgsize() + 4 + (*z).unauthenticatedProposal.Block.BlockHeader.TxnCommitments.NativeSha512_256Commitment.Msgsize() + 7 + (*z).unauthenticatedProposal.Block.BlockHeader.TxnCommitments.Sha256Commitment.Msgsize() + 7 + (*z).unauthenticatedProposal.Block.BlockHeader.TxnCommitments.Sha512Commitment.Msgsize() + 3 + msgp.Int64Size + 4 + msgp.StringPrefixSize + len((*z).unauthenticatedProposal.Block.BlockHeader.GenesisID) + 3 + (*z).unauthenticatedProposal.Block.BlockHeader.GenesisHash.Msgsize() + 4 + (*z).unauthenticatedProposal.Block.BlockHeader.Proposer.Msgsize() + 3 + (*z).unauthenticatedProposal.Block.BlockHeader.FeesCollected.Msgsize() + 3 + (*z).unauthenticatedProposal.Block.BlockHeader.Bonus.Msgsize() + 3 + (*z).unauthenticatedProposal.Block.BlockHeader.ProposerPayout.Msgsize() + 5 + (*z).unauthenticatedProposal.Block.BlockHeader.RewardsState.FeeSink.Msgsize() + 4 + (*z).unauthenticatedProposal.Block.BlockHeader.RewardsState.RewardsPool.Msgsize() + 5 + msgp.Uint64Size + 5 + msgp.Uint64Size + 5 + msgp.Uint64Size + 7 + (*z).unauthenticatedProposal.Block.BlockHeader.RewardsState.RewardsRecalculationRound.Msgsize() + 6 + (*z).unauthenticatedProposal.Block.BlockHeader.UpgradeState.CurrentProtocol.Msgsize() + 10 + (*z).unauthenticatedProposal.Block.BlockHeader.UpgradeState.NextProtocol.Msgsize() + 8 + (*z).unauthenticatedProposal.Block.BlockHeader.UpgradeState.NextProtocolApprovals.Msgsize() + 11 + (*z).unauthenticatedProposal.Block.BlockHeader.UpgradeState.NextProtocolVoteBefore.Msgsize() + 11 + (*z).unauthenticatedProposal.Block.BlockHeader.UpgradeState.NextProtocolSwitchOn.Msgsize() + 12 + (*z).unauthenticatedProposal.Block.BlockHeader.UpgradeVote.UpgradePropose.Msgsize() + 13 + (*z).unauthenticatedProposal.Block.BlockHeader.UpgradeVote.UpgradeDelay.Msgsize() + 11 + msgp.BoolSize + 3 + msgp.Uint64Size + 4 + msgp.MapHeaderSize
	if (*z).unauthenticatedProposal.Block.BlockHeader.StateProofTracking != nil {
		for zb0001, zb0002 := range (*z).unauthenticatedProposal.Block.BlockHeader.StateProofTracking {
			_ = zb0001
			_ = zb0002
			s += 0 + zb0001.Msgsize() + zb0002.Msgsize()
		}
	}
	s += 11 + msgp.ArrayHeaderSize
	for zb0003 := range (*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts {
		s += (*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts[zb0003].Msgsize()
	}
	s += 11 + msgp.ArrayHeaderSize
	for zb0004 := range (*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.AbsentParticipationAccounts {
		s += (*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.AbsentParticipationAccounts[zb0004].Msgsize()
	}
	s += 5 + (*z).unauthenticatedProposal.Block.Payset.Msgsize() + 5 + (*z).unauthenticatedProposal.SeedProof.Msgsize() + 5 + msgp.Uint64Size + 6 + (*z).unauthenticatedProposal.OriginalProposer.Msgsize() + 3 + (*z).PriorVote.Msgsize()
	return
}

// MsgIsZero returns whether this is a zero value
func (z *transmittedPayload) MsgIsZero() bool {
	return ((*z).unauthenticatedProposal.Block.BlockHeader.Round.MsgIsZero()) && ((*z).unauthenticatedProposal.Block.BlockHeader.Branch.MsgIsZero()) && ((*z).unauthenticatedProposal.Block.BlockHeader.Branch512.MsgIsZero()) && ((*z).unauthenticatedProposal.Block.BlockHeader.Seed.MsgIsZero()) && ((*z).unauthenticatedProposal.Block.BlockHeader.TxnCommitments.NativeSha512_256Commitment.MsgIsZero()) && ((*z).unauthenticatedProposal.Block.BlockHeader.TxnCommitments.Sha256Commitment.MsgIsZero()) && ((*z).unauthenticatedProposal.Block.BlockHeader.TxnCommitments.Sha512Commitment.MsgIsZero()) && ((*z).unauthenticatedProposal.Block.BlockHeader.TimeStamp == 0) && ((*z).unauthenticatedProposal.Block.BlockHeader.GenesisID == "") && ((*z).unauthenticatedProposal.Block.BlockHeader.GenesisHash.MsgIsZero()) && ((*z).unauthenticatedProposal.Block.BlockHeader.Proposer.MsgIsZero()) && ((*z).unauthenticatedProposal.Block.BlockHeader.FeesCollected.MsgIsZero()) && ((*z).unauthenticatedProposal.Block.BlockHeader.Bonus.MsgIsZero()) && ((*z).unauthenticatedProposal.Block.BlockHeader.ProposerPayout.MsgIsZero()) && ((*z).unauthenticatedProposal.Block.BlockHeader.RewardsState.FeeSink.MsgIsZero()) && ((*z).unauthenticatedProposal.Block.BlockHeader.RewardsState.RewardsPool.MsgIsZero()) && ((*z).unauthenticatedProposal.Block.BlockHeader.RewardsState.RewardsLevel == 0) && ((*z).unauthenticatedProposal.Block.BlockHeader.RewardsState.RewardsRate == 0) && ((*z).unauthenticatedProposal.Block.BlockHeader.RewardsState.RewardsResidue == 0) && ((*z).unauthenticatedProposal.Block.BlockHeader.RewardsState.RewardsRecalculationRound.MsgIsZero()) && ((*z).unauthenticatedProposal.Block.BlockHeader.UpgradeState.CurrentProtocol.MsgIsZero()) && ((*z).unauthenticatedProposal.Block.BlockHeader.UpgradeState.NextProtocol.MsgIsZero()) && ((*z).unauthenticatedProposal.Block.BlockHeader.UpgradeState.NextProtocolApprovals.MsgIsZero()) && ((*z).unauthenticatedProposal.Block.BlockHeader.UpgradeState.NextProtocolVoteBefore.MsgIsZero()) && ((*z).unauthenticatedProposal.Block.BlockHeader.UpgradeState.NextProtocolSwitchOn.MsgIsZero()) && ((*z).unauthenticatedProposal.Block.BlockHeader.UpgradeVote.UpgradePropose.MsgIsZero()) && ((*z).unauthenticatedProposal.Block.BlockHeader.UpgradeVote.UpgradeDelay.MsgIsZero()) && ((*z).unauthenticatedProposal.Block.BlockHeader.UpgradeVote.UpgradeApprove == false) && ((*z).unauthenticatedProposal.Block.BlockHeader.TxnCounter == 0) && (len((*z).unauthenticatedProposal.Block.BlockHeader.StateProofTracking) == 0) && (len((*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts) == 0) && (len((*z).unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.AbsentParticipationAccounts) == 0) && ((*z).unauthenticatedProposal.Block.Payset.MsgIsZero()) && ((*z).unauthenticatedProposal.SeedProof.MsgIsZero()) && ((*z).unauthenticatedProposal.OriginalPeriod == 0) && ((*z).unauthenticatedProposal.OriginalProposer.MsgIsZero()) && ((*z).PriorVote.MsgIsZero())
}

// MaxSize returns a maximum valid message size for this message type
func TransmittedPayloadMaxSize() (s int) {
	s = 3 + 4 + basics.RoundMaxSize() + 5 + bookkeeping.BlockHashMaxSize() + 8 + crypto.Sha512DigestMaxSize() + 5 + committee.SeedMaxSize() + 4 + crypto.DigestMaxSize() + 7 + crypto.DigestMaxSize() + 7 + crypto.Sha512DigestMaxSize() + 3 + msgp.Int64Size + 4 + msgp.StringPrefixSize + bounds.MaxGenesisIDLen + 3 + crypto.DigestMaxSize() + 4 + basics.AddressMaxSize() + 3 + basics.MicroAlgosMaxSize() + 3 + basics.MicroAlgosMaxSize() + 3 + basics.MicroAlgosMaxSize() + 5 + basics.AddressMaxSize() + 4 + basics.AddressMaxSize() + 5 + msgp.Uint64Size + 5 + msgp.Uint64Size + 5 + msgp.Uint64Size + 7 + basics.RoundMaxSize() + 6 + protocol.ConsensusVersionMaxSize() + 10 + protocol.ConsensusVersionMaxSize() + 8 + basics.RoundMaxSize() + 11 + basics.RoundMaxSize() + 11 + basics.RoundMaxSize() + 12 + protocol.ConsensusVersionMaxSize() + 13 + basics.RoundMaxSize() + 11 + msgp.BoolSize + 3 + msgp.Uint64Size + 4
	s += msgp.MapHeaderSize
	// Adding size of map keys for z.unauthenticatedProposal.Block.BlockHeader.StateProofTracking
	s += protocol.NumStateProofTypes * (protocol.StateProofTypeMaxSize())
	// Adding size of map values for z.unauthenticatedProposal.Block.BlockHeader.StateProofTracking
	s += protocol.NumStateProofTypes * (bookkeeping.StateProofTrackingDataMaxSize())
	s += 11
	// Calculating size of slice: z.unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts
	s += msgp.ArrayHeaderSize + ((bounds.MaxProposedExpiredOnlineAccounts) * (basics.AddressMaxSize()))
	s += 11
	// Calculating size of slice: z.unauthenticatedProposal.Block.BlockHeader.ParticipationUpdates.AbsentParticipationAccounts
	s += msgp.ArrayHeaderSize + ((bounds.MaxMarkAbsent) * (basics.AddressMaxSize()))
	s += 5
	// Using maxtotalbytes for: z.unauthenticatedProposal.Block.Payset
	s += bounds.MaxTxnBytesPerBlock
	s += 5 + crypto.VrfProofMaxSize() + 5 + msgp.Uint64Size + 6 + basics.AddressMaxSize() + 3 + UnauthenticatedVoteMaxSize()
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *unauthenticatedBundle) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0003Len := uint32(6)
	var zb0003Mask uint8 /* 7 bits */
	if len((*z).EquivocationVotes) == 0 {
		zb0003Len--
		zb0003Mask |= 0x2
	}
	if (*z).Period == 0 {
		zb0003Len--
		zb0003Mask |= 0x4
	}
	if (*z).Proposal.MsgIsZero() {
		zb0003Len--
		zb0003Mask |= 0x8
	}
	if (*z).Round.MsgIsZero() {
		zb0003Len--
		zb0003Mask |= 0x10
	}
	if (*z).Step == 0 {
		zb0003Len--
		zb0003Mask |= 0x20
	}
	if len((*z).Votes) == 0 {
		zb0003Len--
		zb0003Mask |= 0x40
	}
	// variable map header, size zb0003Len
	o = append(o, 0x80|uint8(zb0003Len))
	if zb0003Len != 0 {
		if (zb0003Mask & 0x2) == 0 { // if not empty
			// string "eqv"
			o = append(o, 0xa3, 0x65, 0x71, 0x76)
			if (*z).EquivocationVotes == nil {
				o = msgp.AppendNil(o)
			} else {
				o = msgp.AppendArrayHeader(o, uint32(len((*z).EquivocationVotes)))
			}
			for zb0002 := range (*z).EquivocationVotes {
				o = (*z).EquivocationVotes[zb0002].MarshalMsg(o)
			}
		}
		if (zb0003Mask & 0x4) == 0 { // if not empty
			// string "per"
			o = append(o, 0xa3, 0x70, 0x65, 0x72)
			o = msgp.AppendUint64(o, uint64((*z).Period))
		}
		if (zb0003Mask & 0x8) == 0 { // if not empty
			// string "prop"
			o = append(o, 0xa4, 0x70, 0x72, 0x6f, 0x70)
			o = (*z).Proposal.MarshalMsg(o)
		}
		if (zb0003Mask & 0x10) == 0 { // if not empty
			// string "rnd"
			o = append(o, 0xa3, 0x72, 0x6e, 0x64)
			o = (*z).Round.MarshalMsg(o)
		}
		if (zb0003Mask & 0x20) == 0 { // if not empty
			// string "step"
			o = append(o, 0xa4, 0x73, 0x74, 0x65, 0x70)
			o = msgp.AppendUint64(o, uint64((*z).Step))
		}
		if (zb0003Mask & 0x40) == 0 { // if not empty
			// string "vote"
			o = append(o, 0xa4, 0x76, 0x6f, 0x74, 0x65)
			if (*z).Votes == nil {
				o = msgp.AppendNil(o)
			} else {
				o = msgp.AppendArrayHeader(o, uint32(len((*z).Votes)))
			}
			for zb0001 := range (*z).Votes {
				o = (*z).Votes[zb0001].MarshalMsg(o)
			}
		}
	}
	return
}

func (_ *unauthenticatedBundle) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*unauthenticatedBundle)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *unauthenticatedBundle) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0003 int
	var zb0004 bool
	zb0003, zb0004, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0003, zb0004, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0003 > 0 {
			zb0003--
			bts, err = (*z).Round.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Round")
				return
			}
		}
		if zb0003 > 0 {
			zb0003--
			{
				var zb0005 uint64
				zb0005, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Period")
					return
				}
				(*z).Period = period(zb0005)
			}
		}
		if zb0003 > 0 {
			zb0003--
			{
				var zb0006 uint64
				zb0006, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Step")
					return
				}
				(*z).Step = step(zb0006)
			}
		}
		if zb0003 > 0 {
			zb0003--
			bts, err = (*z).Proposal.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Proposal")
				return
			}
		}
		if zb0003 > 0 {
			zb0003--
			var zb0007 int
			var zb0008 bool
			zb0007, zb0008, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Votes")
				return
			}
			if zb0007 > bounds.MaxVoteThreshold {
				err = msgp.ErrOverflow(uint64(zb0007), uint64(bounds.MaxVoteThreshold))
				err = msgp.WrapError(err, "struct-from-array", "Votes")
				return
			}
			if zb0008 {
				(*z).Votes = nil
			} else if (*z).Votes != nil && cap((*z).Votes) >= zb0007 {
				(*z).Votes = ((*z).Votes)[:zb0007]
			} else {
				(*z).Votes = make([]voteAuthenticator, zb0007)
			}
			for zb0001 := range (*z).Votes {
				bts, err = (*z).Votes[zb0001].UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Votes", zb0001)
					return
				}
			}
		}
		if zb0003 > 0 {
			zb0003--
			var zb0009 int
			var zb0010 bool
			zb0009, zb0010, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "EquivocationVotes")
				return
			}
			if zb0009 > bounds.MaxVoteThreshold {
				err = msgp.ErrOverflow(uint64(zb0009), uint64(bounds.MaxVoteThreshold))
				err = msgp.WrapError(err, "struct-from-array", "EquivocationVotes")
				return
			}
			if zb0010 {
				(*z).EquivocationVotes = nil
			} else if (*z).EquivocationVotes != nil && cap((*z).EquivocationVotes) >= zb0009 {
				(*z).EquivocationVotes = ((*z).EquivocationVotes)[:zb0009]
			} else {
				(*z).EquivocationVotes = make([]equivocationVoteAuthenticator, zb0009)
			}
			for zb0002 := range (*z).EquivocationVotes {
				bts, err = (*z).EquivocationVotes[zb0002].UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "EquivocationVotes", zb0002)
					return
				}
			}
		}
		if zb0003 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0003)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0004 {
			(*z) = unauthenticatedBundle{}
		}
		for zb0003 > 0 {
			zb0003--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "rnd":
				bts, err = (*z).Round.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Round")
					return
				}
			case "per":
				{
					var zb0011 uint64
					zb0011, bts, err = msgp.ReadUint64Bytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "Period")
						return
					}
					(*z).Period = period(zb0011)
				}
			case "step":
				{
					var zb0012 uint64
					zb0012, bts, err = msgp.ReadUint64Bytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "Step")
						return
					}
					(*z).Step = step(zb0012)
				}
			case "prop":
				bts, err = (*z).Proposal.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Proposal")
					return
				}
			case "vote":
				var zb0013 int
				var zb0014 bool
				zb0013, zb0014, bts, err = msgp.ReadArrayHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Votes")
					return
				}
				if zb0013 > bounds.MaxVoteThreshold {
					err = msgp.ErrOverflow(uint64(zb0013), uint64(bounds.MaxVoteThreshold))
					err = msgp.WrapError(err, "Votes")
					return
				}
				if zb0014 {
					(*z).Votes = nil
				} else if (*z).Votes != nil && cap((*z).Votes) >= zb0013 {
					(*z).Votes = ((*z).Votes)[:zb0013]
				} else {
					(*z).Votes = make([]voteAuthenticator, zb0013)
				}
				for zb0001 := range (*z).Votes {
					bts, err = (*z).Votes[zb0001].UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "Votes", zb0001)
						return
					}
				}
			case "eqv":
				var zb0015 int
				var zb0016 bool
				zb0015, zb0016, bts, err = msgp.ReadArrayHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "EquivocationVotes")
					return
				}
				if zb0015 > bounds.MaxVoteThreshold {
					err = msgp.ErrOverflow(uint64(zb0015), uint64(bounds.MaxVoteThreshold))
					err = msgp.WrapError(err, "EquivocationVotes")
					return
				}
				if zb0016 {
					(*z).EquivocationVotes = nil
				} else if (*z).EquivocationVotes != nil && cap((*z).EquivocationVotes) >= zb0015 {
					(*z).EquivocationVotes = ((*z).EquivocationVotes)[:zb0015]
				} else {
					(*z).EquivocationVotes = make([]equivocationVoteAuthenticator, zb0015)
				}
				for zb0002 := range (*z).EquivocationVotes {
					bts, err = (*z).EquivocationVotes[zb0002].UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "EquivocationVotes", zb0002)
						return
					}
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *unauthenticatedBundle) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *unauthenticatedBundle) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*unauthenticatedBundle)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *unauthenticatedBundle) Msgsize() (s int) {
	s = 1 + 4 + (*z).Round.Msgsize() + 4 + msgp.Uint64Size + 5 + msgp.Uint64Size + 5 + (*z).Proposal.Msgsize() + 5 + msgp.ArrayHeaderSize
	for zb0001 := range (*z).Votes {
		s += (*z).Votes[zb0001].Msgsize()
	}
	s += 4 + msgp.ArrayHeaderSize
	for zb0002 := range (*z).EquivocationVotes {
		s += (*z).EquivocationVotes[zb0002].Msgsize()
	}
	return
}

// MsgIsZero returns whether this is a zero value
func (z *unauthenticatedBundle) MsgIsZero() bool {
	return ((*z).Round.MsgIsZero()) && ((*z).Period == 0) && ((*z).Step == 0) && ((*z).Proposal.MsgIsZero()) && (len((*z).Votes) == 0) && (len((*z).EquivocationVotes) == 0)
}

// MaxSize returns a maximum valid message size for this message type
func UnauthenticatedBundleMaxSize() (s int) {
	s = 1 + 4 + basics.RoundMaxSize() + 4 + msgp.Uint64Size + 5 + msgp.Uint64Size + 5 + ProposalValueMaxSize() + 5
	// Calculating size of slice: z.Votes
	s += msgp.ArrayHeaderSize + ((bounds.MaxVoteThreshold) * (VoteAuthenticatorMaxSize()))
	s += 4
	// Calculating size of slice: z.EquivocationVotes
	s += msgp.ArrayHeaderSize + ((bounds.MaxVoteThreshold) * (EquivocationVoteAuthenticatorMaxSize()))
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *unauthenticatedEquivocationVote) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0003Len := uint32(7)
	var zb0003Mask uint8 /* 8 bits */
	if (*z).Cred.MsgIsZero() {
		zb0003Len--
		zb0003Mask |= 0x2
	}
	if (*z).Period == 0 {
		zb0003Len--
		zb0003Mask |= 0x4
	}
	if ((*z).Proposals[0].MsgIsZero()) && ((*z).Proposals[1].MsgIsZero()) {
		zb0003Len--
		zb0003Mask |= 0x8
	}
	if (*z).Round.MsgIsZero() {
		zb0003Len--
		zb0003Mask |= 0x10
	}
	if ((*z).Sigs[0].MsgIsZero()) && ((*z).Sigs[1].MsgIsZero()) {
		zb0003Len--
		zb0003Mask |= 0x20
	}
	if (*z).Sender.MsgIsZero() {
		zb0003Len--
		zb0003Mask |= 0x40
	}
	if (*z).Step == 0 {
		zb0003Len--
		zb0003Mask |= 0x80
	}
	// variable map header, size zb0003Len
	o = append(o, 0x80|uint8(zb0003Len))
	if zb0003Len != 0 {
		if (zb0003Mask & 0x2) == 0 { // if not empty
			// string "cred"
			o = append(o, 0xa4, 0x63, 0x72, 0x65, 0x64)
			o = (*z).Cred.MarshalMsg(o)
		}
		if (zb0003Mask & 0x4) == 0 { // if not empty
			// string "per"
			o = append(o, 0xa3, 0x70, 0x65, 0x72)
			o = msgp.AppendUint64(o, uint64((*z).Period))
		}
		if (zb0003Mask & 0x8) == 0 { // if not empty
			// string "props"
			o = append(o, 0xa5, 0x70, 0x72, 0x6f, 0x70, 0x73)
			o = msgp.AppendArrayHeader(o, 2)
			for zb0001 := range (*z).Proposals {
				o = (*z).Proposals[zb0001].MarshalMsg(o)
			}
		}
		if (zb0003Mask & 0x10) == 0 { // if not empty
			// string "rnd"
			o = append(o, 0xa3, 0x72, 0x6e, 0x64)
			o = (*z).Round.MarshalMsg(o)
		}
		if (zb0003Mask & 0x20) == 0 { // if not empty
			// string "sigs"
			o = append(o, 0xa4, 0x73, 0x69, 0x67, 0x73)
			o = msgp.AppendArrayHeader(o, 2)
			for zb0002 := range (*z).Sigs {
				o = (*z).Sigs[zb0002].MarshalMsg(o)
			}
		}
		if (zb0003Mask & 0x40) == 0 { // if not empty
			// string "snd"
			o = append(o, 0xa3, 0x73, 0x6e, 0x64)
			o = (*z).Sender.MarshalMsg(o)
		}
		if (zb0003Mask & 0x80) == 0 { // if not empty
			// string "step"
			o = append(o, 0xa4, 0x73, 0x74, 0x65, 0x70)
			o = msgp.AppendUint64(o, uint64((*z).Step))
		}
	}
	return
}

func (_ *unauthenticatedEquivocationVote) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*unauthenticatedEquivocationVote)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *unauthenticatedEquivocationVote) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0003 int
	var zb0004 bool
	zb0003, zb0004, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0003, zb0004, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0003 > 0 {
			zb0003--
			bts, err = (*z).Sender.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Sender")
				return
			}
		}
		if zb0003 > 0 {
			zb0003--
			bts, err = (*z).Round.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Round")
				return
			}
		}
		if zb0003 > 0 {
			zb0003--
			{
				var zb0005 uint64
				zb0005, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Period")
					return
				}
				(*z).Period = period(zb0005)
			}
		}
		if zb0003 > 0 {
			zb0003--
			{
				var zb0006 uint64
				zb0006, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Step")
					return
				}
				(*z).Step = step(zb0006)
			}
		}
		if zb0003 > 0 {
			zb0003--
			bts, err = (*z).Cred.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Cred")
				return
			}
		}
		if zb0003 > 0 {
			zb0003--
			var zb0007 int
			zb0007, _, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Proposals")
				return
			}
			if zb0007 > 2 {
				err = msgp.ArrayError{Wanted: 2, Got: zb0007}
				return
			}
			for zb0001 := 0; zb0001 < zb0007; zb0001++ {
				bts, err = (*z).Proposals[zb0001].UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Proposals", zb0001)
					return
				}
			}
		}
		if zb0003 > 0 {
			zb0003--
			var zb0008 int
			zb0008, _, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Sigs")
				return
			}
			if zb0008 > 2 {
				err = msgp.ArrayError{Wanted: 2, Got: zb0008}
				return
			}
			for zb0002 := 0; zb0002 < zb0008; zb0002++ {
				bts, err = (*z).Sigs[zb0002].UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Sigs", zb0002)
					return
				}
			}
		}
		if zb0003 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0003)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0004 {
			(*z) = unauthenticatedEquivocationVote{}
		}
		for zb0003 > 0 {
			zb0003--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "snd":
				bts, err = (*z).Sender.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Sender")
					return
				}
			case "rnd":
				bts, err = (*z).Round.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Round")
					return
				}
			case "per":
				{
					var zb0009 uint64
					zb0009, bts, err = msgp.ReadUint64Bytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "Period")
						return
					}
					(*z).Period = period(zb0009)
				}
			case "step":
				{
					var zb0010 uint64
					zb0010, bts, err = msgp.ReadUint64Bytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "Step")
						return
					}
					(*z).Step = step(zb0010)
				}
			case "cred":
				bts, err = (*z).Cred.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Cred")
					return
				}
			case "props":
				var zb0011 int
				zb0011, _, bts, err = msgp.ReadArrayHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Proposals")
					return
				}
				if zb0011 > 2 {
					err = msgp.ArrayError{Wanted: 2, Got: zb0011}
					return
				}
				for zb0001 := 0; zb0001 < zb0011; zb0001++ {
					bts, err = (*z).Proposals[zb0001].UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "Proposals", zb0001)
						return
					}
				}
			case "sigs":
				var zb0012 int
				zb0012, _, bts, err = msgp.ReadArrayHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Sigs")
					return
				}
				if zb0012 > 2 {
					err = msgp.ArrayError{Wanted: 2, Got: zb0012}
					return
				}
				for zb0002 := 0; zb0002 < zb0012; zb0002++ {
					bts, err = (*z).Sigs[zb0002].UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "Sigs", zb0002)
						return
					}
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *unauthenticatedEquivocationVote) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *unauthenticatedEquivocationVote) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*unauthenticatedEquivocationVote)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *unauthenticatedEquivocationVote) Msgsize() (s int) {
	s = 1 + 4 + (*z).Sender.Msgsize() + 4 + (*z).Round.Msgsize() + 4 + msgp.Uint64Size + 5 + msgp.Uint64Size + 5 + (*z).Cred.Msgsize() + 6 + msgp.ArrayHeaderSize
	for zb0001 := range (*z).Proposals {
		s += (*z).Proposals[zb0001].Msgsize()
	}
	s += 5 + msgp.ArrayHeaderSize
	for zb0002 := range (*z).Sigs {
		s += (*z).Sigs[zb0002].Msgsize()
	}
	return
}

// MsgIsZero returns whether this is a zero value
func (z *unauthenticatedEquivocationVote) MsgIsZero() bool {
	return ((*z).Sender.MsgIsZero()) && ((*z).Round.MsgIsZero()) && ((*z).Period == 0) && ((*z).Step == 0) && ((*z).Cred.MsgIsZero()) && (((*z).Proposals[0].MsgIsZero()) && ((*z).Proposals[1].MsgIsZero())) && (((*z).Sigs[0].MsgIsZero()) && ((*z).Sigs[1].MsgIsZero()))
}

// MaxSize returns a maximum valid message size for this message type
func UnauthenticatedEquivocationVoteMaxSize() (s int) {
	s = 1 + 4 + basics.AddressMaxSize() + 4 + basics.RoundMaxSize() + 4 + msgp.Uint64Size + 5 + msgp.Uint64Size + 5 + committee.UnauthenticatedCredentialMaxSize() + 6
	// Calculating size of array: z.Proposals
	s += msgp.ArrayHeaderSize + ((2) * (ProposalValueMaxSize()))
	s += 5
	// Calculating size of array: z.Sigs
	s += msgp.ArrayHeaderSize + ((2) * (crypto.OneTimeSignatureMaxSize()))
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *unauthenticatedProposal) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0005Len := uint32(36)
	var zb0005Mask uint64 /* 43 bits */
	if (*z).Block.BlockHeader.Bonus.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x40
	}
	if (*z).Block.BlockHeader.RewardsState.RewardsLevel == 0 {
		zb0005Len--
		zb0005Mask |= 0x80
	}
	if (*z).Block.BlockHeader.FeesCollected.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x100
	}
	if (*z).Block.BlockHeader.RewardsState.FeeSink.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x200
	}
	if (*z).Block.BlockHeader.RewardsState.RewardsResidue == 0 {
		zb0005Len--
		zb0005Mask |= 0x400
	}
	if (*z).Block.BlockHeader.GenesisID == "" {
		zb0005Len--
		zb0005Mask |= 0x800
	}
	if (*z).Block.BlockHeader.GenesisHash.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x1000
	}
	if (*z).Block.BlockHeader.UpgradeState.NextProtocolVoteBefore.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x2000
	}
	if (*z).Block.BlockHeader.UpgradeState.NextProtocol.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x4000
	}
	if (*z).Block.BlockHeader.UpgradeState.NextProtocolSwitchOn.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x8000
	}
	if (*z).Block.BlockHeader.UpgradeState.NextProtocolApprovals.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x10000
	}
	if (*z).OriginalPeriod == 0 {
		zb0005Len--
		zb0005Mask |= 0x20000
	}
	if (*z).OriginalProposer.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x40000
	}
	if len((*z).Block.BlockHeader.ParticipationUpdates.AbsentParticipationAccounts) == 0 {
		zb0005Len--
		zb0005Mask |= 0x80000
	}
	if len((*z).Block.BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts) == 0 {
		zb0005Len--
		zb0005Mask |= 0x100000
	}
	if (*z).Block.BlockHeader.ProposerPayout.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x200000
	}
	if (*z).Block.BlockHeader.Branch.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x400000
	}
	if (*z).Block.BlockHeader.Branch512.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x800000
	}
	if (*z).Block.BlockHeader.UpgradeState.CurrentProtocol.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x1000000
	}
	if (*z).Block.BlockHeader.Proposer.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x2000000
	}
	if (*z).Block.BlockHeader.RewardsState.RewardsRate == 0 {
		zb0005Len--
		zb0005Mask |= 0x4000000
	}
	if (*z).Block.BlockHeader.Round.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x10000000
	}
	if (*z).Block.BlockHeader.RewardsState.RewardsRecalculationRound.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x20000000
	}
	if (*z).Block.BlockHeader.RewardsState.RewardsPool.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x40000000
	}
	if (*z).SeedProof.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x80000000
	}
	if (*z).Block.BlockHeader.Seed.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x100000000
	}
	if len((*z).Block.BlockHeader.StateProofTracking) == 0 {
		zb0005Len--
		zb0005Mask |= 0x200000000
	}
	if (*z).Block.BlockHeader.TxnCounter == 0 {
		zb0005Len--
		zb0005Mask |= 0x400000000
	}
	if (*z).Block.BlockHeader.TimeStamp == 0 {
		zb0005Len--
		zb0005Mask |= 0x800000000
	}
	if (*z).Block.BlockHeader.TxnCommitments.NativeSha512_256Commitment.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x1000000000
	}
	if (*z).Block.BlockHeader.TxnCommitments.Sha256Commitment.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x2000000000
	}
	if (*z).Block.BlockHeader.TxnCommitments.Sha512Commitment.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x4000000000
	}
	if (*z).Block.Payset.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x8000000000
	}
	if (*z).Block.BlockHeader.UpgradeVote.UpgradeDelay.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x10000000000
	}
	if (*z).Block.BlockHeader.UpgradeVote.UpgradePropose.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x20000000000
	}
	if (*z).Block.BlockHeader.UpgradeVote.UpgradeApprove == false {
		zb0005Len--
		zb0005Mask |= 0x40000000000
	}
	// variable map header, size zb0005Len
	o = msgp.AppendMapHeader(o, zb0005Len)
	if zb0005Len != 0 {
		if (zb0005Mask & 0x40) == 0 { // if not empty
			// string "bi"
			o = append(o, 0xa2, 0x62, 0x69)
			o = (*z).Block.BlockHeader.Bonus.MarshalMsg(o)
		}
		if (zb0005Mask & 0x80) == 0 { // if not empty
			// string "earn"
			o = append(o, 0xa4, 0x65, 0x61, 0x72, 0x6e)
			o = msgp.AppendUint64(o, (*z).Block.BlockHeader.RewardsState.RewardsLevel)
		}
		if (zb0005Mask & 0x100) == 0 { // if not empty
			// string "fc"
			o = append(o, 0xa2, 0x66, 0x63)
			o = (*z).Block.BlockHeader.FeesCollected.MarshalMsg(o)
		}
		if (zb0005Mask & 0x200) == 0 { // if not empty
			// string "fees"
			o = append(o, 0xa4, 0x66, 0x65, 0x65, 0x73)
			o = (*z).Block.BlockHeader.RewardsState.FeeSink.MarshalMsg(o)
		}
		if (zb0005Mask & 0x400) == 0 { // if not empty
			// string "frac"
			o = append(o, 0xa4, 0x66, 0x72, 0x61, 0x63)
			o = msgp.AppendUint64(o, (*z).Block.BlockHeader.RewardsState.RewardsResidue)
		}
		if (zb0005Mask & 0x800) == 0 { // if not empty
			// string "gen"
			o = append(o, 0xa3, 0x67, 0x65, 0x6e)
			o = msgp.AppendString(o, (*z).Block.BlockHeader.GenesisID)
		}
		if (zb0005Mask & 0x1000) == 0 { // if not empty
			// string "gh"
			o = append(o, 0xa2, 0x67, 0x68)
			o = (*z).Block.BlockHeader.GenesisHash.MarshalMsg(o)
		}
		if (zb0005Mask & 0x2000) == 0 { // if not empty
			// string "nextbefore"
			o = append(o, 0xaa, 0x6e, 0x65, 0x78, 0x74, 0x62, 0x65, 0x66, 0x6f, 0x72, 0x65)
			o = (*z).Block.BlockHeader.UpgradeState.NextProtocolVoteBefore.MarshalMsg(o)
		}
		if (zb0005Mask & 0x4000) == 0 { // if not empty
			// string "nextproto"
			o = append(o, 0xa9, 0x6e, 0x65, 0x78, 0x74, 0x70, 0x72, 0x6f, 0x74, 0x6f)
			o = (*z).Block.BlockHeader.UpgradeState.NextProtocol.MarshalMsg(o)
		}
		if (zb0005Mask & 0x8000) == 0 { // if not empty
			// string "nextswitch"
			o = append(o, 0xaa, 0x6e, 0x65, 0x78, 0x74, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68)
			o = (*z).Block.BlockHeader.UpgradeState.NextProtocolSwitchOn.MarshalMsg(o)
		}
		if (zb0005Mask & 0x10000) == 0 { // if not empty
			// string "nextyes"
			o = append(o, 0xa7, 0x6e, 0x65, 0x78, 0x74, 0x79, 0x65, 0x73)
			o = (*z).Block.BlockHeader.UpgradeState.NextProtocolApprovals.MarshalMsg(o)
		}
		if (zb0005Mask & 0x20000) == 0 { // if not empty
			// string "oper"
			o = append(o, 0xa4, 0x6f, 0x70, 0x65, 0x72)
			o = msgp.AppendUint64(o, uint64((*z).OriginalPeriod))
		}
		if (zb0005Mask & 0x40000) == 0 { // if not empty
			// string "oprop"
			o = append(o, 0xa5, 0x6f, 0x70, 0x72, 0x6f, 0x70)
			o = (*z).OriginalProposer.MarshalMsg(o)
		}
		if (zb0005Mask & 0x80000) == 0 { // if not empty
			// string "partupdabs"
			o = append(o, 0xaa, 0x70, 0x61, 0x72, 0x74, 0x75, 0x70, 0x64, 0x61, 0x62, 0x73)
			if (*z).Block.BlockHeader.ParticipationUpdates.AbsentParticipationAccounts == nil {
				o = msgp.AppendNil(o)
			} else {
				o = msgp.AppendArrayHeader(o, uint32(len((*z).Block.BlockHeader.ParticipationUpdates.AbsentParticipationAccounts)))
			}
			for zb0004 := range (*z).Block.BlockHeader.ParticipationUpdates.AbsentParticipationAccounts {
				o = (*z).Block.BlockHeader.ParticipationUpdates.AbsentParticipationAccounts[zb0004].MarshalMsg(o)
			}
		}
		if (zb0005Mask & 0x100000) == 0 { // if not empty
			// string "partupdrmv"
			o = append(o, 0xaa, 0x70, 0x61, 0x72, 0x74, 0x75, 0x70, 0x64, 0x72, 0x6d, 0x76)
			if (*z).Block.BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts == nil {
				o = msgp.AppendNil(o)
			} else {
				o = msgp.AppendArrayHeader(o, uint32(len((*z).Block.BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts)))
			}
			for zb0003 := range (*z).Block.BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts {
				o = (*z).Block.BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts[zb0003].MarshalMsg(o)
			}
		}
		if (zb0005Mask & 0x200000) == 0 { // if not empty
			// string "pp"
			o = append(o, 0xa2, 0x70, 0x70)
			o = (*z).Block.BlockHeader.ProposerPayout.MarshalMsg(o)
		}
		if (zb0005Mask & 0x400000) == 0 { // if not empty
			// string "prev"
			o = append(o, 0xa4, 0x70, 0x72, 0x65, 0x76)
			o = (*z).Block.BlockHeader.Branch.MarshalMsg(o)
		}
		if (zb0005Mask & 0x800000) == 0 { // if not empty
			// string "prev512"
			o = append(o, 0xa7, 0x70, 0x72, 0x65, 0x76, 0x35, 0x31, 0x32)
			o = (*z).Block.BlockHeader.Branch512.MarshalMsg(o)
		}
		if (zb0005Mask & 0x1000000) == 0 { // if not empty
			// string "proto"
			o = append(o, 0xa5, 0x70, 0x72, 0x6f, 0x74, 0x6f)
			o = (*z).Block.BlockHeader.UpgradeState.CurrentProtocol.MarshalMsg(o)
		}
		if (zb0005Mask & 0x2000000) == 0 { // if not empty
			// string "prp"
			o = append(o, 0xa3, 0x70, 0x72, 0x70)
			o = (*z).Block.BlockHeader.Proposer.MarshalMsg(o)
		}
		if (zb0005Mask & 0x4000000) == 0 { // if not empty
			// string "rate"
			o = append(o, 0xa4, 0x72, 0x61, 0x74, 0x65)
			o = msgp.AppendUint64(o, (*z).Block.BlockHeader.RewardsState.RewardsRate)
		}
		if (zb0005Mask & 0x10000000) == 0 { // if not empty
			// string "rnd"
			o = append(o, 0xa3, 0x72, 0x6e, 0x64)
			o = (*z).Block.BlockHeader.Round.MarshalMsg(o)
		}
		if (zb0005Mask & 0x20000000) == 0 { // if not empty
			// string "rwcalr"
			o = append(o, 0xa6, 0x72, 0x77, 0x63, 0x61, 0x6c, 0x72)
			o = (*z).Block.BlockHeader.RewardsState.RewardsRecalculationRound.MarshalMsg(o)
		}
		if (zb0005Mask & 0x40000000) == 0 { // if not empty
			// string "rwd"
			o = append(o, 0xa3, 0x72, 0x77, 0x64)
			o = (*z).Block.BlockHeader.RewardsState.RewardsPool.MarshalMsg(o)
		}
		if (zb0005Mask & 0x80000000) == 0 { // if not empty
			// string "sdpf"
			o = append(o, 0xa4, 0x73, 0x64, 0x70, 0x66)
			o = (*z).SeedProof.MarshalMsg(o)
		}
		if (zb0005Mask & 0x100000000) == 0 { // if not empty
			// string "seed"
			o = append(o, 0xa4, 0x73, 0x65, 0x65, 0x64)
			o = (*z).Block.BlockHeader.Seed.MarshalMsg(o)
		}
		if (zb0005Mask & 0x200000000) == 0 { // if not empty
			// string "spt"
			o = append(o, 0xa3, 0x73, 0x70, 0x74)
			if (*z).Block.BlockHeader.StateProofTracking == nil {
				o = msgp.AppendNil(o)
			} else {
				o = msgp.AppendMapHeader(o, uint32(len((*z).Block.BlockHeader.StateProofTracking)))
			}
			zb0001_keys := make([]protocol.StateProofType, 0, len((*z).Block.BlockHeader.StateProofTracking))
			for zb0001 := range (*z).Block.BlockHeader.StateProofTracking {
				zb0001_keys = append(zb0001_keys, zb0001)
			}
			sort.Sort(protocol.SortStateProofType(zb0001_keys))
			for _, zb0001 := range zb0001_keys {
				zb0002 := (*z).Block.BlockHeader.StateProofTracking[zb0001]
				_ = zb0002
				o = zb0001.MarshalMsg(o)
				o = zb0002.MarshalMsg(o)
			}
		}
		if (zb0005Mask & 0x400000000) == 0 { // if not empty
			// string "tc"
			o = append(o, 0xa2, 0x74, 0x63)
			o = msgp.AppendUint64(o, (*z).Block.BlockHeader.TxnCounter)
		}
		if (zb0005Mask & 0x800000000) == 0 { // if not empty
			// string "ts"
			o = append(o, 0xa2, 0x74, 0x73)
			o = msgp.AppendInt64(o, (*z).Block.BlockHeader.TimeStamp)
		}
		if (zb0005Mask & 0x1000000000) == 0 { // if not empty
			// string "txn"
			o = append(o, 0xa3, 0x74, 0x78, 0x6e)
			o = (*z).Block.BlockHeader.TxnCommitments.NativeSha512_256Commitment.MarshalMsg(o)
		}
		if (zb0005Mask & 0x2000000000) == 0 { // if not empty
			// string "txn256"
			o = append(o, 0xa6, 0x74, 0x78, 0x6e, 0x32, 0x35, 0x36)
			o = (*z).Block.BlockHeader.TxnCommitments.Sha256Commitment.MarshalMsg(o)
		}
		if (zb0005Mask & 0x4000000000) == 0 { // if not empty
			// string "txn512"
			o = append(o, 0xa6, 0x74, 0x78, 0x6e, 0x35, 0x31, 0x32)
			o = (*z).Block.BlockHeader.TxnCommitments.Sha512Commitment.MarshalMsg(o)
		}
		if (zb0005Mask & 0x8000000000) == 0 { // if not empty
			// string "txns"
			o = append(o, 0xa4, 0x74, 0x78, 0x6e, 0x73)
			o = (*z).Block.Payset.MarshalMsg(o)
		}
		if (zb0005Mask & 0x10000000000) == 0 { // if not empty
			// string "upgradedelay"
			o = append(o, 0xac, 0x75, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x64, 0x65, 0x6c, 0x61, 0x79)
			o = (*z).Block.BlockHeader.UpgradeVote.UpgradeDelay.MarshalMsg(o)
		}
		if (zb0005Mask & 0x20000000000) == 0 { // if not empty
			// string "upgradeprop"
			o = append(o, 0xab, 0x75, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x70, 0x72, 0x6f, 0x70)
			o = (*z).Block.BlockHeader.UpgradeVote.UpgradePropose.MarshalMsg(o)
		}
		if (zb0005Mask & 0x40000000000) == 0 { // if not empty
			// string "upgradeyes"
			o = append(o, 0xaa, 0x75, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x79, 0x65, 0x73)
			o = msgp.AppendBool(o, (*z).Block.BlockHeader.UpgradeVote.UpgradeApprove)
		}
	}
	return
}

func (_ *unauthenticatedProposal) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*unauthenticatedProposal)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *unauthenticatedProposal) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0005 int
	var zb0006 bool
	zb0005, zb0006, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0005, zb0006, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).Block.BlockHeader.Round.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Round")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).Block.BlockHeader.Branch.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Branch")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).Block.BlockHeader.Branch512.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Branch512")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).Block.BlockHeader.Seed.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Seed")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).Block.BlockHeader.TxnCommitments.NativeSha512_256Commitment.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "NativeSha512_256Commitment")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).Block.BlockHeader.TxnCommitments.Sha256Commitment.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Sha256Commitment")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).Block.BlockHeader.TxnCommitments.Sha512Commitment.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Sha512Commitment")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			(*z).Block.BlockHeader.TimeStamp, bts, err = msgp.ReadInt64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "TimeStamp")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			var zb0007 int
			zb0007, err = msgp.ReadBytesBytesHeader(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "GenesisID")
				return
			}
			if zb0007 > bounds.MaxGenesisIDLen {
				err = msgp.ErrOverflow(uint64(zb0007), uint64(bounds.MaxGenesisIDLen))
				return
			}
			(*z).Block.BlockHeader.GenesisID, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "GenesisID")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).Block.BlockHeader.GenesisHash.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "GenesisHash")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).Block.BlockHeader.Proposer.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Proposer")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).Block.BlockHeader.FeesCollected.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "FeesCollected")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).Block.BlockHeader.Bonus.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Bonus")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).Block.BlockHeader.ProposerPayout.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "ProposerPayout")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).Block.BlockHeader.RewardsState.FeeSink.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "FeeSink")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).Block.BlockHeader.RewardsState.RewardsPool.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "RewardsPool")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			(*z).Block.BlockHeader.RewardsState.RewardsLevel, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "RewardsLevel")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			(*z).Block.BlockHeader.RewardsState.RewardsRate, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "RewardsRate")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			(*z).Block.BlockHeader.RewardsState.RewardsResidue, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "RewardsResidue")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).Block.BlockHeader.RewardsState.RewardsRecalculationRound.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "RewardsRecalculationRound")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).Block.BlockHeader.UpgradeState.CurrentProtocol.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "CurrentProtocol")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).Block.BlockHeader.UpgradeState.NextProtocol.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "NextProtocol")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).Block.BlockHeader.UpgradeState.NextProtocolApprovals.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "NextProtocolApprovals")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).Block.BlockHeader.UpgradeState.NextProtocolVoteBefore.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "NextProtocolVoteBefore")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).Block.BlockHeader.UpgradeState.NextProtocolSwitchOn.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "NextProtocolSwitchOn")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).Block.BlockHeader.UpgradeVote.UpgradePropose.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "UpgradePropose")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).Block.BlockHeader.UpgradeVote.UpgradeDelay.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "UpgradeDelay")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			(*z).Block.BlockHeader.UpgradeVote.UpgradeApprove, bts, err = msgp.ReadBoolBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "UpgradeApprove")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			(*z).Block.BlockHeader.TxnCounter, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "TxnCounter")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			var zb0008 int
			var zb0009 bool
			zb0008, zb0009, bts, err = msgp.ReadMapHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "StateProofTracking")
				return
			}
			if zb0008 > protocol.NumStateProofTypes {
				err = msgp.ErrOverflow(uint64(zb0008), uint64(protocol.NumStateProofTypes))
				err = msgp.WrapError(err, "struct-from-array", "StateProofTracking")
				return
			}
			if zb0009 {
				(*z).Block.BlockHeader.StateProofTracking = nil
			} else if (*z).Block.BlockHeader.StateProofTracking == nil {
				(*z).Block.BlockHeader.StateProofTracking = make(map[protocol.StateProofType]bookkeeping.StateProofTrackingData, zb0008)
			}
			for zb0008 > 0 {
				var zb0001 protocol.StateProofType
				var zb0002 bookkeeping.StateProofTrackingData
				zb0008--
				bts, err = zb0001.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "StateProofTracking")
					return
				}
				bts, err = zb0002.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "StateProofTracking", zb0001)
					return
				}
				(*z).Block.BlockHeader.StateProofTracking[zb0001] = zb0002
			}
		}
		if zb0005 > 0 {
			zb0005--
			var zb0010 int
			var zb0011 bool
			zb0010, zb0011, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "ExpiredParticipationAccounts")
				return
			}
			if zb0010 > bounds.MaxProposedExpiredOnlineAccounts {
				err = msgp.ErrOverflow(uint64(zb0010), uint64(bounds.MaxProposedExpiredOnlineAccounts))
				err = msgp.WrapError(err, "struct-from-array", "ExpiredParticipationAccounts")
				return
			}
			if zb0011 {
				(*z).Block.BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts = nil
			} else if (*z).Block.BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts != nil && cap((*z).Block.BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts) >= zb0010 {
				(*z).Block.BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts = ((*z).Block.BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts)[:zb0010]
			} else {
				(*z).Block.BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts = make([]basics.Address, zb0010)
			}
			for zb0003 := range (*z).Block.BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts {
				bts, err = (*z).Block.BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts[zb0003].UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "ExpiredParticipationAccounts", zb0003)
					return
				}
			}
		}
		if zb0005 > 0 {
			zb0005--
			var zb0012 int
			var zb0013 bool
			zb0012, zb0013, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "AbsentParticipationAccounts")
				return
			}
			if zb0012 > bounds.MaxMarkAbsent {
				err = msgp.ErrOverflow(uint64(zb0012), uint64(bounds.MaxMarkAbsent))
				err = msgp.WrapError(err, "struct-from-array", "AbsentParticipationAccounts")
				return
			}
			if zb0013 {
				(*z).Block.BlockHeader.ParticipationUpdates.AbsentParticipationAccounts = nil
			} else if (*z).Block.BlockHeader.ParticipationUpdates.AbsentParticipationAccounts != nil && cap((*z).Block.BlockHeader.ParticipationUpdates.AbsentParticipationAccounts) >= zb0012 {
				(*z).Block.BlockHeader.ParticipationUpdates.AbsentParticipationAccounts = ((*z).Block.BlockHeader.ParticipationUpdates.AbsentParticipationAccounts)[:zb0012]
			} else {
				(*z).Block.BlockHeader.ParticipationUpdates.AbsentParticipationAccounts = make([]basics.Address, zb0012)
			}
			for zb0004 := range (*z).Block.BlockHeader.ParticipationUpdates.AbsentParticipationAccounts {
				bts, err = (*z).Block.BlockHeader.ParticipationUpdates.AbsentParticipationAccounts[zb0004].UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "AbsentParticipationAccounts", zb0004)
					return
				}
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).Block.Payset.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Payset")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).SeedProof.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "SeedProof")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			{
				var zb0014 uint64
				zb0014, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "OriginalPeriod")
					return
				}
				(*z).OriginalPeriod = period(zb0014)
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).OriginalProposer.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "OriginalProposer")
				return
			}
		}
		if zb0005 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0005)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0006 {
			(*z) = unauthenticatedProposal{}
		}
		for zb0005 > 0 {
			zb0005--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "rnd":
				bts, err = (*z).Block.BlockHeader.Round.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Round")
					return
				}
			case "prev":
				bts, err = (*z).Block.BlockHeader.Branch.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Branch")
					return
				}
			case "prev512":
				bts, err = (*z).Block.BlockHeader.Branch512.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Branch512")
					return
				}
			case "seed":
				bts, err = (*z).Block.BlockHeader.Seed.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Seed")
					return
				}
			case "txn":
				bts, err = (*z).Block.BlockHeader.TxnCommitments.NativeSha512_256Commitment.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "NativeSha512_256Commitment")
					return
				}
			case "txn256":
				bts, err = (*z).Block.BlockHeader.TxnCommitments.Sha256Commitment.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Sha256Commitment")
					return
				}
			case "txn512":
				bts, err = (*z).Block.BlockHeader.TxnCommitments.Sha512Commitment.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Sha512Commitment")
					return
				}
			case "ts":
				(*z).Block.BlockHeader.TimeStamp, bts, err = msgp.ReadInt64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "TimeStamp")
					return
				}
			case "gen":
				var zb0015 int
				zb0015, err = msgp.ReadBytesBytesHeader(bts)
				if err != nil {
					err = msgp.WrapError(err, "GenesisID")
					return
				}
				if zb0015 > bounds.MaxGenesisIDLen {
					err = msgp.ErrOverflow(uint64(zb0015), uint64(bounds.MaxGenesisIDLen))
					return
				}
				(*z).Block.BlockHeader.GenesisID, bts, err = msgp.ReadStringBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "GenesisID")
					return
				}
			case "gh":
				bts, err = (*z).Block.BlockHeader.GenesisHash.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "GenesisHash")
					return
				}
			case "prp":
				bts, err = (*z).Block.BlockHeader.Proposer.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Proposer")
					return
				}
			case "fc":
				bts, err = (*z).Block.BlockHeader.FeesCollected.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "FeesCollected")
					return
				}
			case "bi":
				bts, err = (*z).Block.BlockHeader.Bonus.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Bonus")
					return
				}
			case "pp":
				bts, err = (*z).Block.BlockHeader.ProposerPayout.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "ProposerPayout")
					return
				}
			case "fees":
				bts, err = (*z).Block.BlockHeader.RewardsState.FeeSink.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "FeeSink")
					return
				}
			case "rwd":
				bts, err = (*z).Block.BlockHeader.RewardsState.RewardsPool.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "RewardsPool")
					return
				}
			case "earn":
				(*z).Block.BlockHeader.RewardsState.RewardsLevel, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "RewardsLevel")
					return
				}
			case "rate":
				(*z).Block.BlockHeader.RewardsState.RewardsRate, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "RewardsRate")
					return
				}
			case "frac":
				(*z).Block.BlockHeader.RewardsState.RewardsResidue, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "RewardsResidue")
					return
				}
			case "rwcalr":
				bts, err = (*z).Block.BlockHeader.RewardsState.RewardsRecalculationRound.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "RewardsRecalculationRound")
					return
				}
			case "proto":
				bts, err = (*z).Block.BlockHeader.UpgradeState.CurrentProtocol.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "CurrentProtocol")
					return
				}
			case "nextproto":
				bts, err = (*z).Block.BlockHeader.UpgradeState.NextProtocol.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "NextProtocol")
					return
				}
			case "nextyes":
				bts, err = (*z).Block.BlockHeader.UpgradeState.NextProtocolApprovals.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "NextProtocolApprovals")
					return
				}
			case "nextbefore":
				bts, err = (*z).Block.BlockHeader.UpgradeState.NextProtocolVoteBefore.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "NextProtocolVoteBefore")
					return
				}
			case "nextswitch":
				bts, err = (*z).Block.BlockHeader.UpgradeState.NextProtocolSwitchOn.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "NextProtocolSwitchOn")
					return
				}
			case "upgradeprop":
				bts, err = (*z).Block.BlockHeader.UpgradeVote.UpgradePropose.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "UpgradePropose")
					return
				}
			case "upgradedelay":
				bts, err = (*z).Block.BlockHeader.UpgradeVote.UpgradeDelay.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "UpgradeDelay")
					return
				}
			case "upgradeyes":
				(*z).Block.BlockHeader.UpgradeVote.UpgradeApprove, bts, err = msgp.ReadBoolBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "UpgradeApprove")
					return
				}
			case "tc":
				(*z).Block.BlockHeader.TxnCounter, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "TxnCounter")
					return
				}
			case "spt":
				var zb0016 int
				var zb0017 bool
				zb0016, zb0017, bts, err = msgp.ReadMapHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "StateProofTracking")
					return
				}
				if zb0016 > protocol.NumStateProofTypes {
					err = msgp.ErrOverflow(uint64(zb0016), uint64(protocol.NumStateProofTypes))
					err = msgp.WrapError(err, "StateProofTracking")
					return
				}
				if zb0017 {
					(*z).Block.BlockHeader.StateProofTracking = nil
				} else if (*z).Block.BlockHeader.StateProofTracking == nil {
					(*z).Block.BlockHeader.StateProofTracking = make(map[protocol.StateProofType]bookkeeping.StateProofTrackingData, zb0016)
				}
				for zb0016 > 0 {
					var zb0001 protocol.StateProofType
					var zb0002 bookkeeping.StateProofTrackingData
					zb0016--
					bts, err = zb0001.UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "StateProofTracking")
						return
					}
					bts, err = zb0002.UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "StateProofTracking", zb0001)
						return
					}
					(*z).Block.BlockHeader.StateProofTracking[zb0001] = zb0002
				}
			case "partupdrmv":
				var zb0018 int
				var zb0019 bool
				zb0018, zb0019, bts, err = msgp.ReadArrayHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "ExpiredParticipationAccounts")
					return
				}
				if zb0018 > bounds.MaxProposedExpiredOnlineAccounts {
					err = msgp.ErrOverflow(uint64(zb0018), uint64(bounds.MaxProposedExpiredOnlineAccounts))
					err = msgp.WrapError(err, "ExpiredParticipationAccounts")
					return
				}
				if zb0019 {
					(*z).Block.BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts = nil
				} else if (*z).Block.BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts != nil && cap((*z).Block.BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts) >= zb0018 {
					(*z).Block.BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts = ((*z).Block.BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts)[:zb0018]
				} else {
					(*z).Block.BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts = make([]basics.Address, zb0018)
				}
				for zb0003 := range (*z).Block.BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts {
					bts, err = (*z).Block.BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts[zb0003].UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "ExpiredParticipationAccounts", zb0003)
						return
					}
				}
			case "partupdabs":
				var zb0020 int
				var zb0021 bool
				zb0020, zb0021, bts, err = msgp.ReadArrayHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "AbsentParticipationAccounts")
					return
				}
				if zb0020 > bounds.MaxMarkAbsent {
					err = msgp.ErrOverflow(uint64(zb0020), uint64(bounds.MaxMarkAbsent))
					err = msgp.WrapError(err, "AbsentParticipationAccounts")
					return
				}
				if zb0021 {
					(*z).Block.BlockHeader.ParticipationUpdates.AbsentParticipationAccounts = nil
				} else if (*z).Block.BlockHeader.ParticipationUpdates.AbsentParticipationAccounts != nil && cap((*z).Block.BlockHeader.ParticipationUpdates.AbsentParticipationAccounts) >= zb0020 {
					(*z).Block.BlockHeader.ParticipationUpdates.AbsentParticipationAccounts = ((*z).Block.BlockHeader.ParticipationUpdates.AbsentParticipationAccounts)[:zb0020]
				} else {
					(*z).Block.BlockHeader.ParticipationUpdates.AbsentParticipationAccounts = make([]basics.Address, zb0020)
				}
				for zb0004 := range (*z).Block.BlockHeader.ParticipationUpdates.AbsentParticipationAccounts {
					bts, err = (*z).Block.BlockHeader.ParticipationUpdates.AbsentParticipationAccounts[zb0004].UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "AbsentParticipationAccounts", zb0004)
						return
					}
				}
			case "txns":
				bts, err = (*z).Block.Payset.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Payset")
					return
				}
			case "sdpf":
				bts, err = (*z).SeedProof.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "SeedProof")
					return
				}
			case "oper":
				{
					var zb0022 uint64
					zb0022, bts, err = msgp.ReadUint64Bytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "OriginalPeriod")
						return
					}
					(*z).OriginalPeriod = period(zb0022)
				}
			case "oprop":
				bts, err = (*z).OriginalProposer.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "OriginalProposer")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *unauthenticatedProposal) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *unauthenticatedProposal) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*unauthenticatedProposal)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *unauthenticatedProposal) Msgsize() (s int) {
	s = 3 + 4 + (*z).Block.BlockHeader.Round.Msgsize() + 5 + (*z).Block.BlockHeader.Branch.Msgsize() + 8 + (*z).Block.BlockHeader.Branch512.Msgsize() + 5 + (*z).Block.BlockHeader.Seed.Msgsize() + 4 + (*z).Block.BlockHeader.TxnCommitments.NativeSha512_256Commitment.Msgsize() + 7 + (*z).Block.BlockHeader.TxnCommitments.Sha256Commitment.Msgsize() + 7 + (*z).Block.BlockHeader.TxnCommitments.Sha512Commitment.Msgsize() + 3 + msgp.Int64Size + 4 + msgp.StringPrefixSize + len((*z).Block.BlockHeader.GenesisID) + 3 + (*z).Block.BlockHeader.GenesisHash.Msgsize() + 4 + (*z).Block.BlockHeader.Proposer.Msgsize() + 3 + (*z).Block.BlockHeader.FeesCollected.Msgsize() + 3 + (*z).Block.BlockHeader.Bonus.Msgsize() + 3 + (*z).Block.BlockHeader.ProposerPayout.Msgsize() + 5 + (*z).Block.BlockHeader.RewardsState.FeeSink.Msgsize() + 4 + (*z).Block.BlockHeader.RewardsState.RewardsPool.Msgsize() + 5 + msgp.Uint64Size + 5 + msgp.Uint64Size + 5 + msgp.Uint64Size + 7 + (*z).Block.BlockHeader.RewardsState.RewardsRecalculationRound.Msgsize() + 6 + (*z).Block.BlockHeader.UpgradeState.CurrentProtocol.Msgsize() + 10 + (*z).Block.BlockHeader.UpgradeState.NextProtocol.Msgsize() + 8 + (*z).Block.BlockHeader.UpgradeState.NextProtocolApprovals.Msgsize() + 11 + (*z).Block.BlockHeader.UpgradeState.NextProtocolVoteBefore.Msgsize() + 11 + (*z).Block.BlockHeader.UpgradeState.NextProtocolSwitchOn.Msgsize() + 12 + (*z).Block.BlockHeader.UpgradeVote.UpgradePropose.Msgsize() + 13 + (*z).Block.BlockHeader.UpgradeVote.UpgradeDelay.Msgsize() + 11 + msgp.BoolSize + 3 + msgp.Uint64Size + 4 + msgp.MapHeaderSize
	if (*z).Block.BlockHeader.StateProofTracking != nil {
		for zb0001, zb0002 := range (*z).Block.BlockHeader.StateProofTracking {
			_ = zb0001
			_ = zb0002
			s += 0 + zb0001.Msgsize() + zb0002.Msgsize()
		}
	}
	s += 11 + msgp.ArrayHeaderSize
	for zb0003 := range (*z).Block.BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts {
		s += (*z).Block.BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts[zb0003].Msgsize()
	}
	s += 11 + msgp.ArrayHeaderSize
	for zb0004 := range (*z).Block.BlockHeader.ParticipationUpdates.AbsentParticipationAccounts {
		s += (*z).Block.BlockHeader.ParticipationUpdates.AbsentParticipationAccounts[zb0004].Msgsize()
	}
	s += 5 + (*z).Block.Payset.Msgsize() + 5 + (*z).SeedProof.Msgsize() + 5 + msgp.Uint64Size + 6 + (*z).OriginalProposer.Msgsize()
	return
}

// MsgIsZero returns whether this is a zero value
func (z *unauthenticatedProposal) MsgIsZero() bool {
	return ((*z).Block.BlockHeader.Round.MsgIsZero()) && ((*z).Block.BlockHeader.Branch.MsgIsZero()) && ((*z).Block.BlockHeader.Branch512.MsgIsZero()) && ((*z).Block.BlockHeader.Seed.MsgIsZero()) && ((*z).Block.BlockHeader.TxnCommitments.NativeSha512_256Commitment.MsgIsZero()) && ((*z).Block.BlockHeader.TxnCommitments.Sha256Commitment.MsgIsZero()) && ((*z).Block.BlockHeader.TxnCommitments.Sha512Commitment.MsgIsZero()) && ((*z).Block.BlockHeader.TimeStamp == 0) && ((*z).Block.BlockHeader.GenesisID == "") && ((*z).Block.BlockHeader.GenesisHash.MsgIsZero()) && ((*z).Block.BlockHeader.Proposer.MsgIsZero()) && ((*z).Block.BlockHeader.FeesCollected.MsgIsZero()) && ((*z).Block.BlockHeader.Bonus.MsgIsZero()) && ((*z).Block.BlockHeader.ProposerPayout.MsgIsZero()) && ((*z).Block.BlockHeader.RewardsState.FeeSink.MsgIsZero()) && ((*z).Block.BlockHeader.RewardsState.RewardsPool.MsgIsZero()) && ((*z).Block.BlockHeader.RewardsState.RewardsLevel == 0) && ((*z).Block.BlockHeader.RewardsState.RewardsRate == 0) && ((*z).Block.BlockHeader.RewardsState.RewardsResidue == 0) && ((*z).Block.BlockHeader.RewardsState.RewardsRecalculationRound.MsgIsZero()) && ((*z).Block.BlockHeader.UpgradeState.CurrentProtocol.MsgIsZero()) && ((*z).Block.BlockHeader.UpgradeState.NextProtocol.MsgIsZero()) && ((*z).Block.BlockHeader.UpgradeState.NextProtocolApprovals.MsgIsZero()) && ((*z).Block.BlockHeader.UpgradeState.NextProtocolVoteBefore.MsgIsZero()) && ((*z).Block.BlockHeader.UpgradeState.NextProtocolSwitchOn.MsgIsZero()) && ((*z).Block.BlockHeader.UpgradeVote.UpgradePropose.MsgIsZero()) && ((*z).Block.BlockHeader.UpgradeVote.UpgradeDelay.MsgIsZero()) && ((*z).Block.BlockHeader.UpgradeVote.UpgradeApprove == false) && ((*z).Block.BlockHeader.TxnCounter == 0) && (len((*z).Block.BlockHeader.StateProofTracking) == 0) && (len((*z).Block.BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts) == 0) && (len((*z).Block.BlockHeader.ParticipationUpdates.AbsentParticipationAccounts) == 0) && ((*z).Block.Payset.MsgIsZero()) && ((*z).SeedProof.MsgIsZero()) && ((*z).OriginalPeriod == 0) && ((*z).OriginalProposer.MsgIsZero())
}

// MaxSize returns a maximum valid message size for this message type
func UnauthenticatedProposalMaxSize() (s int) {
	s = 3 + 4 + basics.RoundMaxSize() + 5 + bookkeeping.BlockHashMaxSize() + 8 + crypto.Sha512DigestMaxSize() + 5 + committee.SeedMaxSize() + 4 + crypto.DigestMaxSize() + 7 + crypto.DigestMaxSize() + 7 + crypto.Sha512DigestMaxSize() + 3 + msgp.Int64Size + 4 + msgp.StringPrefixSize + bounds.MaxGenesisIDLen + 3 + crypto.DigestMaxSize() + 4 + basics.AddressMaxSize() + 3 + basics.MicroAlgosMaxSize() + 3 + basics.MicroAlgosMaxSize() + 3 + basics.MicroAlgosMaxSize() + 5 + basics.AddressMaxSize() + 4 + basics.AddressMaxSize() + 5 + msgp.Uint64Size + 5 + msgp.Uint64Size + 5 + msgp.Uint64Size + 7 + basics.RoundMaxSize() + 6 + protocol.ConsensusVersionMaxSize() + 10 + protocol.ConsensusVersionMaxSize() + 8 + basics.RoundMaxSize() + 11 + basics.RoundMaxSize() + 11 + basics.RoundMaxSize() + 12 + protocol.ConsensusVersionMaxSize() + 13 + basics.RoundMaxSize() + 11 + msgp.BoolSize + 3 + msgp.Uint64Size + 4
	s += msgp.MapHeaderSize
	// Adding size of map keys for z.Block.BlockHeader.StateProofTracking
	s += protocol.NumStateProofTypes * (protocol.StateProofTypeMaxSize())
	// Adding size of map values for z.Block.BlockHeader.StateProofTracking
	s += protocol.NumStateProofTypes * (bookkeeping.StateProofTrackingDataMaxSize())
	s += 11
	// Calculating size of slice: z.Block.BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts
	s += msgp.ArrayHeaderSize + ((bounds.MaxProposedExpiredOnlineAccounts) * (basics.AddressMaxSize()))
	s += 11
	// Calculating size of slice: z.Block.BlockHeader.ParticipationUpdates.AbsentParticipationAccounts
	s += msgp.ArrayHeaderSize + ((bounds.MaxMarkAbsent) * (basics.AddressMaxSize()))
	s += 5
	// Using maxtotalbytes for: z.Block.Payset
	s += bounds.MaxTxnBytesPerBlock
	s += 5 + crypto.VrfProofMaxSize() + 5 + msgp.Uint64Size + 6 + basics.AddressMaxSize()
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *unauthenticatedVote) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0001Len := uint32(3)
	var zb0001Mask uint8 /* 4 bits */
	if (*z).Cred.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x2
	}
	if (*z).R.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x4
	}
	if (*z).Sig.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x8
	}
	// variable map header, size zb0001Len
	o = append(o, 0x80|uint8(zb0001Len))
	if zb0001Len != 0 {
		if (zb0001Mask & 0x2) == 0 { // if not empty
			// string "cred"
			o = append(o, 0xa4, 0x63, 0x72, 0x65, 0x64)
			o = (*z).Cred.MarshalMsg(o)
		}
		if (zb0001Mask & 0x4) == 0 { // if not empty
			// string "r"
			o = append(o, 0xa1, 0x72)
			o = (*z).R.MarshalMsg(o)
		}
		if (zb0001Mask & 0x8) == 0 { // if not empty
			// string "sig"
			o = append(o, 0xa3, 0x73, 0x69, 0x67)
			o = (*z).Sig.MarshalMsg(o)
		}
	}
	return
}

func (_ *unauthenticatedVote) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*unauthenticatedVote)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *unauthenticatedVote) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0001 int
	var zb0002 bool
	zb0001, zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0001, zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).R.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "R")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).Cred.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Cred")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).Sig.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Sig")
				return
			}
		}
		if zb0001 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0001)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 {
			(*z) = unauthenticatedVote{}
		}
		for zb0001 > 0 {
			zb0001--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "r":
				bts, err = (*z).R.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "R")
					return
				}
			case "cred":
				bts, err = (*z).Cred.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Cred")
					return
				}
			case "sig":
				bts, err = (*z).Sig.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Sig")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *unauthenticatedVote) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *unauthenticatedVote) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*unauthenticatedVote)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *unauthenticatedVote) Msgsize() (s int) {
	s = 1 + 2 + (*z).R.Msgsize() + 5 + (*z).Cred.Msgsize() + 4 + (*z).Sig.Msgsize()
	return
}

// MsgIsZero returns whether this is a zero value
func (z *unauthenticatedVote) MsgIsZero() bool {
	return ((*z).R.MsgIsZero()) && ((*z).Cred.MsgIsZero()) && ((*z).Sig.MsgIsZero())
}

// MaxSize returns a maximum valid message size for this message type
func UnauthenticatedVoteMaxSize() (s int) {
	s = 1 + 2 + RawVoteMaxSize() + 5 + committee.UnauthenticatedCredentialMaxSize() + 4 + crypto.OneTimeSignatureMaxSize()
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *vote) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0001Len := uint32(3)
	var zb0001Mask uint8 /* 5 bits */
	if (*z).Cred.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x2
	}
	if (*z).R.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x4
	}
	if (*z).Sig.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x8
	}
	// variable map header, size zb0001Len
	o = append(o, 0x80|uint8(zb0001Len))
	if zb0001Len != 0 {
		if (zb0001Mask & 0x2) == 0 { // if not empty
			// string "cred"
			o = append(o, 0xa4, 0x63, 0x72, 0x65, 0x64)
			o = (*z).Cred.MarshalMsg(o)
		}
		if (zb0001Mask & 0x4) == 0 { // if not empty
			// string "r"
			o = append(o, 0xa1, 0x72)
			o = (*z).R.MarshalMsg(o)
		}
		if (zb0001Mask & 0x8) == 0 { // if not empty
			// string "sig"
			o = append(o, 0xa3, 0x73, 0x69, 0x67)
			o = (*z).Sig.MarshalMsg(o)
		}
	}
	return
}

func (_ *vote) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*vote)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *vote) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0001 int
	var zb0002 bool
	zb0001, zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0001, zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).R.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "R")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).Cred.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Cred")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).Sig.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Sig")
				return
			}
		}
		if zb0001 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0001)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 {
			(*z) = vote{}
		}
		for zb0001 > 0 {
			zb0001--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "r":
				bts, err = (*z).R.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "R")
					return
				}
			case "cred":
				bts, err = (*z).Cred.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Cred")
					return
				}
			case "sig":
				bts, err = (*z).Sig.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Sig")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *vote) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *vote) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*vote)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *vote) Msgsize() (s int) {
	s = 1 + 2 + (*z).R.Msgsize() + 5 + (*z).Cred.Msgsize() + 4 + (*z).Sig.Msgsize()
	return
}

// MsgIsZero returns whether this is a zero value
func (z *vote) MsgIsZero() bool {
	return ((*z).R.MsgIsZero()) && ((*z).Cred.MsgIsZero()) && ((*z).Sig.MsgIsZero())
}

// MaxSize returns a maximum valid message size for this message type
func VoteMaxSize() (s int) {
	s = 1 + 2 + RawVoteMaxSize() + 5 + committee.CredentialMaxSize() + 4 + crypto.OneTimeSignatureMaxSize()
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *voteAggregator) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 0
	o = append(o, 0x80)
	return
}

func (_ *voteAggregator) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*voteAggregator)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *voteAggregator) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0001 int
	var zb0002 bool
	zb0001, zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0001, zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0001 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0001)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 {
			(*z) = voteAggregator{}
		}
		for zb0001 > 0 {
			zb0001--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *voteAggregator) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *voteAggregator) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*voteAggregator)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *voteAggregator) Msgsize() (s int) {
	s = 1
	return
}

// MsgIsZero returns whether this is a zero value
func (z *voteAggregator) MsgIsZero() bool {
	return true
}

// MaxSize returns a maximum valid message size for this message type
func VoteAggregatorMaxSize() (s int) {
	s = 1
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *voteAuthenticator) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0001Len := uint32(3)
	var zb0001Mask uint8 /* 4 bits */
	if (*z).Sig.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x4
	}
	// variable map header, size zb0001Len
	o = append(o, 0x80|uint8(zb0001Len))
	if zb0001Len != 0 {
		// string "cred"
		o = append(o, 0xa4, 0x63, 0x72, 0x65, 0x64)
		o = (*z).Cred.MarshalMsg(o)
		if (zb0001Mask & 0x4) == 0 { // if not empty
			// string "sig"
			o = append(o, 0xa3, 0x73, 0x69, 0x67)
			o = (*z).Sig.MarshalMsg(o)
		}
		// string "snd"
		o = append(o, 0xa3, 0x73, 0x6e, 0x64)
		o = (*z).Sender.MarshalMsg(o)
	}
	return
}

func (_ *voteAuthenticator) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*voteAuthenticator)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *voteAuthenticator) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0001 int
	var zb0002 bool
	zb0001, zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0001, zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).Sender.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Sender")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).Cred.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Cred")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).Sig.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Sig")
				return
			}
		}
		if zb0001 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0001)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 {
			(*z) = voteAuthenticator{}
		}
		for zb0001 > 0 {
			zb0001--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "snd":
				bts, err = (*z).Sender.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Sender")
					return
				}
			case "cred":
				bts, err = (*z).Cred.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Cred")
					return
				}
			case "sig":
				bts, err = (*z).Sig.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Sig")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *voteAuthenticator) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *voteAuthenticator) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*voteAuthenticator)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *voteAuthenticator) Msgsize() (s int) {
	s = 1 + 4 + (*z).Sender.Msgsize() + 5 + (*z).Cred.Msgsize() + 4 + (*z).Sig.Msgsize()
	return
}

// MsgIsZero returns whether this is a zero value
func (z *voteAuthenticator) MsgIsZero() bool {
	return ((*z).Sender.MsgIsZero()) && ((*z).Cred.MsgIsZero()) && ((*z).Sig.MsgIsZero())
}

// MaxSize returns a maximum valid message size for this message type
func VoteAuthenticatorMaxSize() (s int) {
	s = 1 + 4 + basics.AddressMaxSize() + 5 + committee.UnauthenticatedCredentialMaxSize() + 4 + crypto.OneTimeSignatureMaxSize()
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *voteTracker) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 4
	// string "Counts"
	o = append(o, 0x84, 0xa6, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x73)
	if (*z).Counts == nil {
		o = msgp.AppendNil(o)
	} else {
		o = msgp.AppendMapHeader(o, uint32(len((*z).Counts)))
	}
	zb0003_keys := make([]proposalValue, 0, len((*z).Counts))
	for zb0003 := range (*z).Counts {
		zb0003_keys = append(zb0003_keys, zb0003)
	}
	sort.Sort(SortProposalValue(zb0003_keys))
	for _, zb0003 := range zb0003_keys {
		zb0004 := (*z).Counts[zb0003]
		_ = zb0004
		o = zb0003.MarshalMsg(o)
		o = zb0004.MarshalMsg(o)
	}
	// string "Equivocators"
	o = append(o, 0xac, 0x45, 0x71, 0x75, 0x69, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x6f, 0x72, 0x73)
	if (*z).Equivocators == nil {
		o = msgp.AppendNil(o)
	} else {
		o = msgp.AppendMapHeader(o, uint32(len((*z).Equivocators)))
	}
	zb0005_keys := make([]basics.Address, 0, len((*z).Equivocators))
	for zb0005 := range (*z).Equivocators {
		zb0005_keys = append(zb0005_keys, zb0005)
	}
	sort.Sort(SortAddress(zb0005_keys))
	for _, zb0005 := range zb0005_keys {
		zb0006 := (*z).Equivocators[zb0005]
		_ = zb0006
		o = zb0005.MarshalMsg(o)
		o = zb0006.MarshalMsg(o)
	}
	// string "EquivocatorsCount"
	o = append(o, 0xb1, 0x45, 0x71, 0x75, 0x69, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x6f, 0x72, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74)
	o = msgp.AppendUint64(o, (*z).EquivocatorsCount)
	// string "Voters"
	o = append(o, 0xa6, 0x56, 0x6f, 0x74, 0x65, 0x72, 0x73)
	if (*z).Voters == nil {
		o = msgp.AppendNil(o)
	} else {
		o = msgp.AppendMapHeader(o, uint32(len((*z).Voters)))
	}
	zb0001_keys := make([]basics.Address, 0, len((*z).Voters))
	for zb0001 := range (*z).Voters {
		zb0001_keys = append(zb0001_keys, zb0001)
	}
	sort.Sort(SortAddress(zb0001_keys))
	for _, zb0001 := range zb0001_keys {
		zb0002 := (*z).Voters[zb0001]
		_ = zb0002
		o = zb0001.MarshalMsg(o)
		o = zb0002.MarshalMsg(o)
	}
	return
}

func (_ *voteTracker) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*voteTracker)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *voteTracker) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0007 int
	var zb0008 bool
	zb0007, zb0008, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0007, zb0008, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0007 > 0 {
			zb0007--
			var zb0009 int
			var zb0010 bool
			zb0009, zb0010, bts, err = msgp.ReadMapHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Voters")
				return
			}
			if zb0010 {
				(*z).Voters = nil
			} else if (*z).Voters == nil {
				(*z).Voters = make(map[basics.Address]vote, zb0009)
			}
			for zb0009 > 0 {
				var zb0001 basics.Address
				var zb0002 vote
				zb0009--
				bts, err = zb0001.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Voters")
					return
				}
				bts, err = zb0002.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Voters", zb0001)
					return
				}
				(*z).Voters[zb0001] = zb0002
			}
		}
		if zb0007 > 0 {
			zb0007--
			var zb0011 int
			var zb0012 bool
			zb0011, zb0012, bts, err = msgp.ReadMapHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Counts")
				return
			}
			if zb0012 {
				(*z).Counts = nil
			} else if (*z).Counts == nil {
				(*z).Counts = make(map[proposalValue]proposalVoteCounter, zb0011)
			}
			for zb0011 > 0 {
				var zb0003 proposalValue
				var zb0004 proposalVoteCounter
				zb0011--
				bts, err = zb0003.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Counts")
					return
				}
				bts, err = zb0004.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Counts", zb0003)
					return
				}
				(*z).Counts[zb0003] = zb0004
			}
		}
		if zb0007 > 0 {
			zb0007--
			var zb0013 int
			var zb0014 bool
			zb0013, zb0014, bts, err = msgp.ReadMapHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Equivocators")
				return
			}
			if zb0014 {
				(*z).Equivocators = nil
			} else if (*z).Equivocators == nil {
				(*z).Equivocators = make(map[basics.Address]equivocationVote, zb0013)
			}
			for zb0013 > 0 {
				var zb0005 basics.Address
				var zb0006 equivocationVote
				zb0013--
				bts, err = zb0005.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Equivocators")
					return
				}
				bts, err = zb0006.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Equivocators", zb0005)
					return
				}
				(*z).Equivocators[zb0005] = zb0006
			}
		}
		if zb0007 > 0 {
			zb0007--
			(*z).EquivocatorsCount, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "EquivocatorsCount")
				return
			}
		}
		if zb0007 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0007)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0008 {
			(*z) = voteTracker{}
		}
		for zb0007 > 0 {
			zb0007--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "Voters":
				var zb0015 int
				var zb0016 bool
				zb0015, zb0016, bts, err = msgp.ReadMapHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Voters")
					return
				}
				if zb0016 {
					(*z).Voters = nil
				} else if (*z).Voters == nil {
					(*z).Voters = make(map[basics.Address]vote, zb0015)
				}
				for zb0015 > 0 {
					var zb0001 basics.Address
					var zb0002 vote
					zb0015--
					bts, err = zb0001.UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "Voters")
						return
					}
					bts, err = zb0002.UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "Voters", zb0001)
						return
					}
					(*z).Voters[zb0001] = zb0002
				}
			case "Counts":
				var zb0017 int
				var zb0018 bool
				zb0017, zb0018, bts, err = msgp.ReadMapHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Counts")
					return
				}
				if zb0018 {
					(*z).Counts = nil
				} else if (*z).Counts == nil {
					(*z).Counts = make(map[proposalValue]proposalVoteCounter, zb0017)
				}
				for zb0017 > 0 {
					var zb0003 proposalValue
					var zb0004 proposalVoteCounter
					zb0017--
					bts, err = zb0003.UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "Counts")
						return
					}
					bts, err = zb0004.UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "Counts", zb0003)
						return
					}
					(*z).Counts[zb0003] = zb0004
				}
			case "Equivocators":
				var zb0019 int
				var zb0020 bool
				zb0019, zb0020, bts, err = msgp.ReadMapHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Equivocators")
					return
				}
				if zb0020 {
					(*z).Equivocators = nil
				} else if (*z).Equivocators == nil {
					(*z).Equivocators = make(map[basics.Address]equivocationVote, zb0019)
				}
				for zb0019 > 0 {
					var zb0005 basics.Address
					var zb0006 equivocationVote
					zb0019--
					bts, err = zb0005.UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "Equivocators")
						return
					}
					bts, err = zb0006.UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "Equivocators", zb0005)
						return
					}
					(*z).Equivocators[zb0005] = zb0006
				}
			case "EquivocatorsCount":
				(*z).EquivocatorsCount, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "EquivocatorsCount")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *voteTracker) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *voteTracker) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*voteTracker)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *voteTracker) Msgsize() (s int) {
	s = 1 + 7 + msgp.MapHeaderSize
	if (*z).Voters != nil {
		for zb0001, zb0002 := range (*z).Voters {
			_ = zb0001
			_ = zb0002
			s += 0 + zb0001.Msgsize() + zb0002.Msgsize()
		}
	}
	s += 7 + msgp.MapHeaderSize
	if (*z).Counts != nil {
		for zb0003, zb0004 := range (*z).Counts {
			_ = zb0003
			_ = zb0004
			s += 0 + zb0003.Msgsize() + zb0004.Msgsize()
		}
	}
	s += 13 + msgp.MapHeaderSize
	if (*z).Equivocators != nil {
		for zb0005, zb0006 := range (*z).Equivocators {
			_ = zb0005
			_ = zb0006
			s += 0 + zb0005.Msgsize() + zb0006.Msgsize()
		}
	}
	s += 18 + msgp.Uint64Size
	return
}

// MsgIsZero returns whether this is a zero value
func (z *voteTracker) MsgIsZero() bool {
	return (len((*z).Voters) == 0) && (len((*z).Counts) == 0) && (len((*z).Equivocators) == 0) && ((*z).EquivocatorsCount == 0)
}

// MaxSize returns a maximum valid message size for this message type
func VoteTrackerMaxSize() (s int) {
	s = 1 + 7
	s += msgp.MapHeaderSize
	panic("Map z.Voters is unbounded")
}

// MarshalMsg implements msgp.Marshaler
func (z *voteTrackerContract) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 3
	// string "Emitted"
	o = append(o, 0x83, 0xa7, 0x45, 0x6d, 0x69, 0x74, 0x74, 0x65, 0x64)
	o = msgp.AppendBool(o, (*z).Emitted)
	// string "Step"
	o = append(o, 0xa4, 0x53, 0x74, 0x65, 0x70)
	o = msgp.AppendUint64(o, uint64((*z).Step))
	// string "StepOk"
	o = append(o, 0xa6, 0x53, 0x74, 0x65, 0x70, 0x4f, 0x6b)
	o = msgp.AppendBool(o, (*z).StepOk)
	return
}

func (_ *voteTrackerContract) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*voteTrackerContract)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *voteTrackerContract) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0001 int
	var zb0002 bool
	zb0001, zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0001, zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0001 > 0 {
			zb0001--
			{
				var zb0003 uint64
				zb0003, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Step")
					return
				}
				(*z).Step = step(zb0003)
			}
		}
		if zb0001 > 0 {
			zb0001--
			(*z).StepOk, bts, err = msgp.ReadBoolBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "StepOk")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			(*z).Emitted, bts, err = msgp.ReadBoolBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Emitted")
				return
			}
		}
		if zb0001 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0001)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 {
			(*z) = voteTrackerContract{}
		}
		for zb0001 > 0 {
			zb0001--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "Step":
				{
					var zb0004 uint64
					zb0004, bts, err = msgp.ReadUint64Bytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "Step")
						return
					}
					(*z).Step = step(zb0004)
				}
			case "StepOk":
				(*z).StepOk, bts, err = msgp.ReadBoolBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "StepOk")
					return
				}
			case "Emitted":
				(*z).Emitted, bts, err = msgp.ReadBoolBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Emitted")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *voteTrackerContract) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *voteTrackerContract) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*voteTrackerContract)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *voteTrackerContract) Msgsize() (s int) {
	s = 1 + 5 + msgp.Uint64Size + 7 + msgp.BoolSize + 8 + msgp.BoolSize
	return
}

// MsgIsZero returns whether this is a zero value
func (z *voteTrackerContract) MsgIsZero() bool {
	return ((*z).Step == 0) && ((*z).StepOk == false) && ((*z).Emitted == false)
}

// MaxSize returns a maximum valid message size for this message type
func VoteTrackerContractMaxSize() (s int) {
	s = 1 + 5 + msgp.Uint64Size + 7 + msgp.BoolSize + 8 + msgp.BoolSize
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *voteTrackerPeriod) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 1
	// string "Cached"
	o = append(o, 0x81, 0xa6, 0x43, 0x61, 0x63, 0x68, 0x65, 0x64)
	// map header, size 2
	// string "Bottom"
	o = append(o, 0x82, 0xa6, 0x42, 0x6f, 0x74, 0x74, 0x6f, 0x6d)
	o = msgp.AppendBool(o, (*z).Cached.Bottom)
	// string "Proposal"
	o = append(o, 0xa8, 0x50, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61, 0x6c)
	o = (*z).Cached.Proposal.MarshalMsg(o)
	return
}

func (_ *voteTrackerPeriod) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*voteTrackerPeriod)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *voteTrackerPeriod) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0001 int
	var zb0002 bool
	zb0001, zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0001, zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0001 > 0 {
			zb0001--
			var zb0003 int
			var zb0004 bool
			zb0003, zb0004, bts, err = msgp.ReadMapHeaderBytes(bts)
			if _, ok := err.(msgp.TypeError); ok {
				zb0003, zb0004, bts, err = msgp.ReadArrayHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Cached")
					return
				}
				if zb0003 > 0 {
					zb0003--
					(*z).Cached.Bottom, bts, err = msgp.ReadBoolBytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "Cached", "struct-from-array", "Bottom")
						return
					}
				}
				if zb0003 > 0 {
					zb0003--
					bts, err = (*z).Cached.Proposal.UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "Cached", "struct-from-array", "Proposal")
						return
					}
				}
				if zb0003 > 0 {
					err = msgp.ErrTooManyArrayFields(zb0003)
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "Cached", "struct-from-array")
						return
					}
				}
			} else {
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Cached")
					return
				}
				if zb0004 {
					(*z).Cached = nextThresholdStatusEvent{}
				}
				for zb0003 > 0 {
					zb0003--
					field, bts, err = msgp.ReadMapKeyZC(bts)
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "Cached")
						return
					}
					switch string(field) {
					case "Bottom":
						(*z).Cached.Bottom, bts, err = msgp.ReadBoolBytes(bts)
						if err != nil {
							err = msgp.WrapError(err, "struct-from-array", "Cached", "Bottom")
							return
						}
					case "Proposal":
						bts, err = (*z).Cached.Proposal.UnmarshalMsgWithState(bts, st)
						if err != nil {
							err = msgp.WrapError(err, "struct-from-array", "Cached", "Proposal")
							return
						}
					default:
						err = msgp.ErrNoField(string(field))
						if err != nil {
							err = msgp.WrapError(err, "struct-from-array", "Cached")
							return
						}
					}
				}
			}
		}
		if zb0001 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0001)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 {
			(*z) = voteTrackerPeriod{}
		}
		for zb0001 > 0 {
			zb0001--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "Cached":
				var zb0005 int
				var zb0006 bool
				zb0005, zb0006, bts, err = msgp.ReadMapHeaderBytes(bts)
				if _, ok := err.(msgp.TypeError); ok {
					zb0005, zb0006, bts, err = msgp.ReadArrayHeaderBytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "Cached")
						return
					}
					if zb0005 > 0 {
						zb0005--
						(*z).Cached.Bottom, bts, err = msgp.ReadBoolBytes(bts)
						if err != nil {
							err = msgp.WrapError(err, "Cached", "struct-from-array", "Bottom")
							return
						}
					}
					if zb0005 > 0 {
						zb0005--
						bts, err = (*z).Cached.Proposal.UnmarshalMsgWithState(bts, st)
						if err != nil {
							err = msgp.WrapError(err, "Cached", "struct-from-array", "Proposal")
							return
						}
					}
					if zb0005 > 0 {
						err = msgp.ErrTooManyArrayFields(zb0005)
						if err != nil {
							err = msgp.WrapError(err, "Cached", "struct-from-array")
							return
						}
					}
				} else {
					if err != nil {
						err = msgp.WrapError(err, "Cached")
						return
					}
					if zb0006 {
						(*z).Cached = nextThresholdStatusEvent{}
					}
					for zb0005 > 0 {
						zb0005--
						field, bts, err = msgp.ReadMapKeyZC(bts)
						if err != nil {
							err = msgp.WrapError(err, "Cached")
							return
						}
						switch string(field) {
						case "Bottom":
							(*z).Cached.Bottom, bts, err = msgp.ReadBoolBytes(bts)
							if err != nil {
								err = msgp.WrapError(err, "Cached", "Bottom")
								return
							}
						case "Proposal":
							bts, err = (*z).Cached.Proposal.UnmarshalMsgWithState(bts, st)
							if err != nil {
								err = msgp.WrapError(err, "Cached", "Proposal")
								return
							}
						default:
							err = msgp.ErrNoField(string(field))
							if err != nil {
								err = msgp.WrapError(err, "Cached")
								return
							}
						}
					}
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *voteTrackerPeriod) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *voteTrackerPeriod) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*voteTrackerPeriod)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *voteTrackerPeriod) Msgsize() (s int) {
	s = 1 + 7 + 1 + 7 + msgp.BoolSize + 9 + (*z).Cached.Proposal.Msgsize()
	return
}

// MsgIsZero returns whether this is a zero value
func (z *voteTrackerPeriod) MsgIsZero() bool {
	return (((*z).Cached.Bottom == false) && ((*z).Cached.Proposal.MsgIsZero()))
}

// MaxSize returns a maximum valid message size for this message type
func VoteTrackerPeriodMaxSize() (s int) {
	s = 1 + 7 + 1 + 7 + msgp.BoolSize + 9 + ProposalValueMaxSize()
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *voteTrackerRound) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 2
	// string "Freshest"
	o = append(o, 0x82, 0xa8, 0x46, 0x72, 0x65, 0x73, 0x68, 0x65, 0x73, 0x74)
	o = (*z).Freshest.MarshalMsg(o)
	// string "Ok"
	o = append(o, 0xa2, 0x4f, 0x6b)
	o = msgp.AppendBool(o, (*z).Ok)
	return
}

func (_ *voteTrackerRound) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*voteTrackerRound)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *voteTrackerRound) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0001 int
	var zb0002 bool
	zb0001, zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0001, zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).Freshest.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Freshest")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			(*z).Ok, bts, err = msgp.ReadBoolBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Ok")
				return
			}
		}
		if zb0001 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0001)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 {
			(*z) = voteTrackerRound{}
		}
		for zb0001 > 0 {
			zb0001--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "Freshest":
				bts, err = (*z).Freshest.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Freshest")
					return
				}
			case "Ok":
				(*z).Ok, bts, err = msgp.ReadBoolBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Ok")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *voteTrackerRound) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *voteTrackerRound) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*voteTrackerRound)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *voteTrackerRound) Msgsize() (s int) {
	s = 1 + 9 + (*z).Freshest.Msgsize() + 3 + msgp.BoolSize
	return
}

// MsgIsZero returns whether this is a zero value
func (z *voteTrackerRound) MsgIsZero() bool {
	return ((*z).Freshest.MsgIsZero()) && ((*z).Ok == false)
}

// MaxSize returns a maximum valid message size for this message type
func VoteTrackerRoundMaxSize() (s int) {
	s = 1 + 9 + ThresholdEventMaxSize() + 3 + msgp.BoolSize
	return
}
