package node

// Code generated by github.com/algorand/msgp DO NOT EDIT.

import (
	"github.com/algorand/msgp/msgp"

	"github.com/algorand/go-algorand/crypto"
	"github.com/algorand/go-algorand/data/basics"
)

// The following msgp objects are implemented in this file:
// netPrioResponse
//        |-----> (*) MarshalMsg
//        |-----> (*) CanMarshalMsg
//        |-----> (*) UnmarshalMsg
//        |-----> (*) UnmarshalMsgWithState
//        |-----> (*) CanUnmarshalMsg
//        |-----> (*) Msgsize
//        |-----> (*) MsgIsZero
//        |-----> NetPrioResponseMaxSize()
//
// netPrioResponseSigned
//           |-----> (*) MarshalMsg
//           |-----> (*) CanMarshalMsg
//           |-----> (*) UnmarshalMsg
//           |-----> (*) UnmarshalMsgWithState
//           |-----> (*) CanUnmarshalMsg
//           |-----> (*) Msgsize
//           |-----> (*) MsgIsZero
//           |-----> NetPrioResponseSignedMaxSize()
//

// MarshalMsg implements msgp.Marshaler
func (z *netPrioResponse) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0001Len := uint32(1)
	var zb0001Mask uint8 /* 2 bits */
	if (*z).Nonce == "" {
		zb0001Len--
		zb0001Mask |= 0x1
	}
	// variable map header, size zb0001Len
	o = append(o, 0x80|uint8(zb0001Len))
	if zb0001Len != 0 {
		if (zb0001Mask & 0x1) == 0 { // if not empty
			// string "Nonce"
			o = append(o, 0xa5, 0x4e, 0x6f, 0x6e, 0x63, 0x65)
			o = msgp.AppendString(o, (*z).Nonce)
		}
	}
	return
}

func (_ *netPrioResponse) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*netPrioResponse)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *netPrioResponse) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0001 int
	var zb0002 bool
	zb0001, zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0001, zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0001 > 0 {
			zb0001--
			var zb0003 int
			zb0003, err = msgp.ReadBytesBytesHeader(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Nonce")
				return
			}
			if zb0003 > netPrioChallengeSizeBase64Encoded {
				err = msgp.ErrOverflow(uint64(zb0003), uint64(netPrioChallengeSizeBase64Encoded))
				return
			}
			(*z).Nonce, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Nonce")
				return
			}
		}
		if zb0001 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0001)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 {
			(*z) = netPrioResponse{}
		}
		for zb0001 > 0 {
			zb0001--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "Nonce":
				var zb0004 int
				zb0004, err = msgp.ReadBytesBytesHeader(bts)
				if err != nil {
					err = msgp.WrapError(err, "Nonce")
					return
				}
				if zb0004 > netPrioChallengeSizeBase64Encoded {
					err = msgp.ErrOverflow(uint64(zb0004), uint64(netPrioChallengeSizeBase64Encoded))
					return
				}
				(*z).Nonce, bts, err = msgp.ReadStringBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Nonce")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *netPrioResponse) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *netPrioResponse) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*netPrioResponse)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *netPrioResponse) Msgsize() (s int) {
	s = 1 + 6 + msgp.StringPrefixSize + len((*z).Nonce)
	return
}

// MsgIsZero returns whether this is a zero value
func (z *netPrioResponse) MsgIsZero() bool {
	return ((*z).Nonce == "")
}

// MaxSize returns a maximum valid message size for this message type
func NetPrioResponseMaxSize() (s int) {
	s = 1 + 6 + msgp.StringPrefixSize + netPrioChallengeSizeBase64Encoded
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *netPrioResponseSigned) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0001Len := uint32(4)
	var zb0001Mask uint8 /* 5 bits */
	if (*z).Response.Nonce == "" {
		zb0001Len--
		zb0001Mask |= 0x1
	}
	if (*z).Round.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x2
	}
	if (*z).Sender.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x4
	}
	if (*z).Sig.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x8
	}
	// variable map header, size zb0001Len
	o = append(o, 0x80|uint8(zb0001Len))
	if zb0001Len != 0 {
		if (zb0001Mask & 0x1) == 0 { // if not empty
			// string "Response"
			o = append(o, 0xa8, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65)
			// omitempty: check for empty values
			zb0002Len := uint32(1)
			var zb0002Mask uint8 /* 2 bits */
			if (*z).Response.Nonce == "" {
				zb0002Len--
				zb0002Mask |= 0x1
			}
			// variable map header, size zb0002Len
			o = append(o, 0x80|uint8(zb0002Len))
			if (zb0002Mask & 0x1) == 0 { // if not empty
				// string "Nonce"
				o = append(o, 0xa5, 0x4e, 0x6f, 0x6e, 0x63, 0x65)
				o = msgp.AppendString(o, (*z).Response.Nonce)
			}
		}
		if (zb0001Mask & 0x2) == 0 { // if not empty
			// string "Round"
			o = append(o, 0xa5, 0x52, 0x6f, 0x75, 0x6e, 0x64)
			o = (*z).Round.MarshalMsg(o)
		}
		if (zb0001Mask & 0x4) == 0 { // if not empty
			// string "Sender"
			o = append(o, 0xa6, 0x53, 0x65, 0x6e, 0x64, 0x65, 0x72)
			o = (*z).Sender.MarshalMsg(o)
		}
		if (zb0001Mask & 0x8) == 0 { // if not empty
			// string "Sig"
			o = append(o, 0xa3, 0x53, 0x69, 0x67)
			o = (*z).Sig.MarshalMsg(o)
		}
	}
	return
}

func (_ *netPrioResponseSigned) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*netPrioResponseSigned)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *netPrioResponseSigned) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0001 int
	var zb0002 bool
	zb0001, zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0001, zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0001 > 0 {
			zb0001--
			var zb0003 int
			var zb0004 bool
			zb0003, zb0004, bts, err = msgp.ReadMapHeaderBytes(bts)
			if _, ok := err.(msgp.TypeError); ok {
				zb0003, zb0004, bts, err = msgp.ReadArrayHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Response")
					return
				}
				if zb0003 > 0 {
					zb0003--
					var zb0005 int
					zb0005, err = msgp.ReadBytesBytesHeader(bts)
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "Response", "struct-from-array", "Nonce")
						return
					}
					if zb0005 > netPrioChallengeSizeBase64Encoded {
						err = msgp.ErrOverflow(uint64(zb0005), uint64(netPrioChallengeSizeBase64Encoded))
						return
					}
					(*z).Response.Nonce, bts, err = msgp.ReadStringBytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "Response", "struct-from-array", "Nonce")
						return
					}
				}
				if zb0003 > 0 {
					err = msgp.ErrTooManyArrayFields(zb0003)
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "Response", "struct-from-array")
						return
					}
				}
			} else {
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Response")
					return
				}
				if zb0004 {
					(*z).Response = netPrioResponse{}
				}
				for zb0003 > 0 {
					zb0003--
					field, bts, err = msgp.ReadMapKeyZC(bts)
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "Response")
						return
					}
					switch string(field) {
					case "Nonce":
						var zb0006 int
						zb0006, err = msgp.ReadBytesBytesHeader(bts)
						if err != nil {
							err = msgp.WrapError(err, "struct-from-array", "Response", "Nonce")
							return
						}
						if zb0006 > netPrioChallengeSizeBase64Encoded {
							err = msgp.ErrOverflow(uint64(zb0006), uint64(netPrioChallengeSizeBase64Encoded))
							return
						}
						(*z).Response.Nonce, bts, err = msgp.ReadStringBytes(bts)
						if err != nil {
							err = msgp.WrapError(err, "struct-from-array", "Response", "Nonce")
							return
						}
					default:
						err = msgp.ErrNoField(string(field))
						if err != nil {
							err = msgp.WrapError(err, "struct-from-array", "Response")
							return
						}
					}
				}
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).Round.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Round")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).Sender.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Sender")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).Sig.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Sig")
				return
			}
		}
		if zb0001 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0001)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 {
			(*z) = netPrioResponseSigned{}
		}
		for zb0001 > 0 {
			zb0001--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "Response":
				var zb0007 int
				var zb0008 bool
				zb0007, zb0008, bts, err = msgp.ReadMapHeaderBytes(bts)
				if _, ok := err.(msgp.TypeError); ok {
					zb0007, zb0008, bts, err = msgp.ReadArrayHeaderBytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "Response")
						return
					}
					if zb0007 > 0 {
						zb0007--
						var zb0009 int
						zb0009, err = msgp.ReadBytesBytesHeader(bts)
						if err != nil {
							err = msgp.WrapError(err, "Response", "struct-from-array", "Nonce")
							return
						}
						if zb0009 > netPrioChallengeSizeBase64Encoded {
							err = msgp.ErrOverflow(uint64(zb0009), uint64(netPrioChallengeSizeBase64Encoded))
							return
						}
						(*z).Response.Nonce, bts, err = msgp.ReadStringBytes(bts)
						if err != nil {
							err = msgp.WrapError(err, "Response", "struct-from-array", "Nonce")
							return
						}
					}
					if zb0007 > 0 {
						err = msgp.ErrTooManyArrayFields(zb0007)
						if err != nil {
							err = msgp.WrapError(err, "Response", "struct-from-array")
							return
						}
					}
				} else {
					if err != nil {
						err = msgp.WrapError(err, "Response")
						return
					}
					if zb0008 {
						(*z).Response = netPrioResponse{}
					}
					for zb0007 > 0 {
						zb0007--
						field, bts, err = msgp.ReadMapKeyZC(bts)
						if err != nil {
							err = msgp.WrapError(err, "Response")
							return
						}
						switch string(field) {
						case "Nonce":
							var zb0010 int
							zb0010, err = msgp.ReadBytesBytesHeader(bts)
							if err != nil {
								err = msgp.WrapError(err, "Response", "Nonce")
								return
							}
							if zb0010 > netPrioChallengeSizeBase64Encoded {
								err = msgp.ErrOverflow(uint64(zb0010), uint64(netPrioChallengeSizeBase64Encoded))
								return
							}
							(*z).Response.Nonce, bts, err = msgp.ReadStringBytes(bts)
							if err != nil {
								err = msgp.WrapError(err, "Response", "Nonce")
								return
							}
						default:
							err = msgp.ErrNoField(string(field))
							if err != nil {
								err = msgp.WrapError(err, "Response")
								return
							}
						}
					}
				}
			case "Round":
				bts, err = (*z).Round.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Round")
					return
				}
			case "Sender":
				bts, err = (*z).Sender.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Sender")
					return
				}
			case "Sig":
				bts, err = (*z).Sig.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Sig")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *netPrioResponseSigned) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *netPrioResponseSigned) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*netPrioResponseSigned)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *netPrioResponseSigned) Msgsize() (s int) {
	s = 1 + 9 + 1 + 6 + msgp.StringPrefixSize + len((*z).Response.Nonce) + 6 + (*z).Round.Msgsize() + 7 + (*z).Sender.Msgsize() + 4 + (*z).Sig.Msgsize()
	return
}

// MsgIsZero returns whether this is a zero value
func (z *netPrioResponseSigned) MsgIsZero() bool {
	return ((*z).Response.Nonce == "") && ((*z).Round.MsgIsZero()) && ((*z).Sender.MsgIsZero()) && ((*z).Sig.MsgIsZero())
}

// MaxSize returns a maximum valid message size for this message type
func NetPrioResponseSignedMaxSize() (s int) {
	s = 1 + 9 + 1 + 6 + msgp.StringPrefixSize + netPrioChallengeSizeBase64Encoded + 6 + basics.RoundMaxSize() + 7 + basics.AddressMaxSize() + 4 + crypto.OneTimeSignatureMaxSize()
	return
}
