package ledger

// Code generated by github.com/algorand/msgp DO NOT EDIT.

import (
	"github.com/algorand/msgp/msgp"

	"github.com/algorand/go-algorand/crypto"
	"github.com/algorand/go-algorand/data/basics"
	"github.com/algorand/go-algorand/ledger/encoded"
	"github.com/algorand/go-algorand/ledger/ledgercore"
)

// The following msgp objects are implemented in this file:
// CatchpointCatchupState
//            |-----> MarshalMsg
//            |-----> CanMarshalMsg
//            |-----> (*) UnmarshalMsg
//            |-----> (*) UnmarshalMsgWithState
//            |-----> (*) CanUnmarshalMsg
//            |-----> Msgsize
//            |-----> MsgIsZero
//            |-----> CatchpointCatchupStateMaxSize()
//
// CatchpointFileHeader
//           |-----> (*) MarshalMsg
//           |-----> (*) CanMarshalMsg
//           |-----> (*) UnmarshalMsg
//           |-----> (*) UnmarshalMsgWithState
//           |-----> (*) CanUnmarshalMsg
//           |-----> (*) Msgsize
//           |-----> (*) MsgIsZero
//           |-----> CatchpointFileHeaderMaxSize()
//
// CatchpointSnapshotChunkV5
//             |-----> (*) MarshalMsg
//             |-----> (*) CanMarshalMsg
//             |-----> (*) UnmarshalMsg
//             |-----> (*) UnmarshalMsgWithState
//             |-----> (*) CanUnmarshalMsg
//             |-----> (*) Msgsize
//             |-----> (*) MsgIsZero
//             |-----> CatchpointSnapshotChunkV5MaxSize()
//
// CatchpointSnapshotChunkV6
//             |-----> (*) MarshalMsg
//             |-----> (*) CanMarshalMsg
//             |-----> (*) UnmarshalMsg
//             |-----> (*) UnmarshalMsgWithState
//             |-----> (*) CanUnmarshalMsg
//             |-----> (*) Msgsize
//             |-----> (*) MsgIsZero
//             |-----> CatchpointSnapshotChunkV6MaxSize()
//
// catchpointStateProofVerificationContext
//                    |-----> (*) MarshalMsg
//                    |-----> (*) CanMarshalMsg
//                    |-----> (*) UnmarshalMsg
//                    |-----> (*) UnmarshalMsgWithState
//                    |-----> (*) CanUnmarshalMsg
//                    |-----> (*) Msgsize
//                    |-----> (*) MsgIsZero
//                    |-----> CatchpointStateProofVerificationContextMaxSize()
//

// MarshalMsg implements msgp.Marshaler
func (z CatchpointCatchupState) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	o = msgp.AppendInt32(o, int32(z))
	return
}

func (_ CatchpointCatchupState) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(CatchpointCatchupState)
	if !ok {
		_, ok = (z).(*CatchpointCatchupState)
	}
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *CatchpointCatchupState) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	{
		var zb0001 int32
		zb0001, bts, err = msgp.ReadInt32Bytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		(*z) = CatchpointCatchupState(zb0001)
	}
	o = bts
	return
}

func (z *CatchpointCatchupState) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *CatchpointCatchupState) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*CatchpointCatchupState)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z CatchpointCatchupState) Msgsize() (s int) {
	s = msgp.Int32Size
	return
}

// MsgIsZero returns whether this is a zero value
func (z CatchpointCatchupState) MsgIsZero() bool {
	return z == 0
}

// MaxSize returns a maximum valid message size for this message type
func CatchpointCatchupStateMaxSize() (s int) {
	s = msgp.Int32Size
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *CatchpointFileHeader) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0001Len := uint32(11)
	var zb0001Mask uint16 /* 12 bits */
	if (*z).Totals.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x2
	}
	if (*z).TotalAccounts == 0 {
		zb0001Len--
		zb0001Mask |= 0x4
	}
	if (*z).BalancesRound.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x8
	}
	if (*z).BlockHeaderDigest.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x10
	}
	if (*z).BlocksRound.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x20
	}
	if (*z).Catchpoint == "" {
		zb0001Len--
		zb0001Mask |= 0x40
	}
	if (*z).TotalChunks == 0 {
		zb0001Len--
		zb0001Mask |= 0x80
	}
	if (*z).TotalKVs == 0 {
		zb0001Len--
		zb0001Mask |= 0x100
	}
	if (*z).TotalOnlineAccounts == 0 {
		zb0001Len--
		zb0001Mask |= 0x200
	}
	if (*z).TotalOnlineRoundParams == 0 {
		zb0001Len--
		zb0001Mask |= 0x400
	}
	if (*z).Version == 0 {
		zb0001Len--
		zb0001Mask |= 0x800
	}
	// variable map header, size zb0001Len
	o = append(o, 0x80|uint8(zb0001Len))
	if zb0001Len != 0 {
		if (zb0001Mask & 0x2) == 0 { // if not empty
			// string "accountTotals"
			o = append(o, 0xad, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x54, 0x6f, 0x74, 0x61, 0x6c, 0x73)
			o = (*z).Totals.MarshalMsg(o)
		}
		if (zb0001Mask & 0x4) == 0 { // if not empty
			// string "accountsCount"
			o = append(o, 0xad, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74)
			o = msgp.AppendUint64(o, (*z).TotalAccounts)
		}
		if (zb0001Mask & 0x8) == 0 { // if not empty
			// string "balancesRound"
			o = append(o, 0xad, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x52, 0x6f, 0x75, 0x6e, 0x64)
			o = (*z).BalancesRound.MarshalMsg(o)
		}
		if (zb0001Mask & 0x10) == 0 { // if not empty
			// string "blockHeaderDigest"
			o = append(o, 0xb1, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x44, 0x69, 0x67, 0x65, 0x73, 0x74)
			o = (*z).BlockHeaderDigest.MarshalMsg(o)
		}
		if (zb0001Mask & 0x20) == 0 { // if not empty
			// string "blocksRound"
			o = append(o, 0xab, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x73, 0x52, 0x6f, 0x75, 0x6e, 0x64)
			o = (*z).BlocksRound.MarshalMsg(o)
		}
		if (zb0001Mask & 0x40) == 0 { // if not empty
			// string "catchpoint"
			o = append(o, 0xaa, 0x63, 0x61, 0x74, 0x63, 0x68, 0x70, 0x6f, 0x69, 0x6e, 0x74)
			o = msgp.AppendString(o, (*z).Catchpoint)
		}
		if (zb0001Mask & 0x80) == 0 { // if not empty
			// string "chunksCount"
			o = append(o, 0xab, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74)
			o = msgp.AppendUint64(o, (*z).TotalChunks)
		}
		if (zb0001Mask & 0x100) == 0 { // if not empty
			// string "kvsCount"
			o = append(o, 0xa8, 0x6b, 0x76, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74)
			o = msgp.AppendUint64(o, (*z).TotalKVs)
		}
		if (zb0001Mask & 0x200) == 0 { // if not empty
			// string "onlineAccountsCount"
			o = append(o, 0xb3, 0x6f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74)
			o = msgp.AppendUint64(o, (*z).TotalOnlineAccounts)
		}
		if (zb0001Mask & 0x400) == 0 { // if not empty
			// string "onlineRoundParamsCount"
			o = append(o, 0xb6, 0x6f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x6f, 0x75, 0x6e, 0x64, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74)
			o = msgp.AppendUint64(o, (*z).TotalOnlineRoundParams)
		}
		if (zb0001Mask & 0x800) == 0 { // if not empty
			// string "version"
			o = append(o, 0xa7, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e)
			o = msgp.AppendUint64(o, (*z).Version)
		}
	}
	return
}

func (_ *CatchpointFileHeader) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*CatchpointFileHeader)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *CatchpointFileHeader) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0001 int
	var zb0002 bool
	zb0001, zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0001, zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0001 > 0 {
			zb0001--
			(*z).Version, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Version")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).BalancesRound.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "BalancesRound")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).BlocksRound.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "BlocksRound")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).Totals.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Totals")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			(*z).TotalAccounts, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "TotalAccounts")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			(*z).TotalChunks, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "TotalChunks")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			(*z).TotalKVs, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "TotalKVs")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			(*z).TotalOnlineAccounts, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "TotalOnlineAccounts")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			(*z).TotalOnlineRoundParams, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "TotalOnlineRoundParams")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			(*z).Catchpoint, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Catchpoint")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).BlockHeaderDigest.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "BlockHeaderDigest")
				return
			}
		}
		if zb0001 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0001)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 {
			(*z) = CatchpointFileHeader{}
		}
		for zb0001 > 0 {
			zb0001--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "version":
				(*z).Version, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Version")
					return
				}
			case "balancesRound":
				bts, err = (*z).BalancesRound.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "BalancesRound")
					return
				}
			case "blocksRound":
				bts, err = (*z).BlocksRound.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "BlocksRound")
					return
				}
			case "accountTotals":
				bts, err = (*z).Totals.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Totals")
					return
				}
			case "accountsCount":
				(*z).TotalAccounts, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "TotalAccounts")
					return
				}
			case "chunksCount":
				(*z).TotalChunks, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "TotalChunks")
					return
				}
			case "kvsCount":
				(*z).TotalKVs, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "TotalKVs")
					return
				}
			case "onlineAccountsCount":
				(*z).TotalOnlineAccounts, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "TotalOnlineAccounts")
					return
				}
			case "onlineRoundParamsCount":
				(*z).TotalOnlineRoundParams, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "TotalOnlineRoundParams")
					return
				}
			case "catchpoint":
				(*z).Catchpoint, bts, err = msgp.ReadStringBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Catchpoint")
					return
				}
			case "blockHeaderDigest":
				bts, err = (*z).BlockHeaderDigest.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "BlockHeaderDigest")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *CatchpointFileHeader) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *CatchpointFileHeader) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*CatchpointFileHeader)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *CatchpointFileHeader) Msgsize() (s int) {
	s = 1 + 8 + msgp.Uint64Size + 14 + (*z).BalancesRound.Msgsize() + 12 + (*z).BlocksRound.Msgsize() + 14 + (*z).Totals.Msgsize() + 14 + msgp.Uint64Size + 12 + msgp.Uint64Size + 9 + msgp.Uint64Size + 20 + msgp.Uint64Size + 23 + msgp.Uint64Size + 11 + msgp.StringPrefixSize + len((*z).Catchpoint) + 18 + (*z).BlockHeaderDigest.Msgsize()
	return
}

// MsgIsZero returns whether this is a zero value
func (z *CatchpointFileHeader) MsgIsZero() bool {
	return ((*z).Version == 0) && ((*z).BalancesRound.MsgIsZero()) && ((*z).BlocksRound.MsgIsZero()) && ((*z).Totals.MsgIsZero()) && ((*z).TotalAccounts == 0) && ((*z).TotalChunks == 0) && ((*z).TotalKVs == 0) && ((*z).TotalOnlineAccounts == 0) && ((*z).TotalOnlineRoundParams == 0) && ((*z).Catchpoint == "") && ((*z).BlockHeaderDigest.MsgIsZero())
}

// MaxSize returns a maximum valid message size for this message type
func CatchpointFileHeaderMaxSize() (s int) {
	s = 1 + 8 + msgp.Uint64Size + 14 + basics.RoundMaxSize() + 12 + basics.RoundMaxSize() + 14 + ledgercore.AccountTotalsMaxSize() + 14 + msgp.Uint64Size + 12 + msgp.Uint64Size + 9 + msgp.Uint64Size + 20 + msgp.Uint64Size + 23 + msgp.Uint64Size + 11
	panic("Unable to determine max size: String type z.Catchpoint is unbounded")
	s += 18 + crypto.DigestMaxSize()
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *CatchpointSnapshotChunkV5) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0002Len := uint32(1)
	var zb0002Mask uint8 /* 2 bits */
	if len((*z).Balances) == 0 {
		zb0002Len--
		zb0002Mask |= 0x2
	}
	// variable map header, size zb0002Len
	o = append(o, 0x80|uint8(zb0002Len))
	if zb0002Len != 0 {
		if (zb0002Mask & 0x2) == 0 { // if not empty
			// string "bl"
			o = append(o, 0xa2, 0x62, 0x6c)
			if (*z).Balances == nil {
				o = msgp.AppendNil(o)
			} else {
				o = msgp.AppendArrayHeader(o, uint32(len((*z).Balances)))
			}
			for zb0001 := range (*z).Balances {
				o = (*z).Balances[zb0001].MarshalMsg(o)
			}
		}
	}
	return
}

func (_ *CatchpointSnapshotChunkV5) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*CatchpointSnapshotChunkV5)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *CatchpointSnapshotChunkV5) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0002 int
	var zb0003 bool
	zb0002, zb0003, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0002, zb0003, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 > 0 {
			zb0002--
			var zb0004 int
			var zb0005 bool
			zb0004, zb0005, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Balances")
				return
			}
			if zb0004 > BalancesPerCatchpointFileChunk {
				err = msgp.ErrOverflow(uint64(zb0004), uint64(BalancesPerCatchpointFileChunk))
				err = msgp.WrapError(err, "struct-from-array", "Balances")
				return
			}
			if zb0005 {
				(*z).Balances = nil
			} else if (*z).Balances != nil && cap((*z).Balances) >= zb0004 {
				(*z).Balances = ((*z).Balances)[:zb0004]
			} else {
				(*z).Balances = make([]encoded.BalanceRecordV5, zb0004)
			}
			for zb0001 := range (*z).Balances {
				bts, err = (*z).Balances[zb0001].UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Balances", zb0001)
					return
				}
			}
		}
		if zb0002 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0002)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0003 {
			(*z) = CatchpointSnapshotChunkV5{}
		}
		for zb0002 > 0 {
			zb0002--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "bl":
				var zb0006 int
				var zb0007 bool
				zb0006, zb0007, bts, err = msgp.ReadArrayHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Balances")
					return
				}
				if zb0006 > BalancesPerCatchpointFileChunk {
					err = msgp.ErrOverflow(uint64(zb0006), uint64(BalancesPerCatchpointFileChunk))
					err = msgp.WrapError(err, "Balances")
					return
				}
				if zb0007 {
					(*z).Balances = nil
				} else if (*z).Balances != nil && cap((*z).Balances) >= zb0006 {
					(*z).Balances = ((*z).Balances)[:zb0006]
				} else {
					(*z).Balances = make([]encoded.BalanceRecordV5, zb0006)
				}
				for zb0001 := range (*z).Balances {
					bts, err = (*z).Balances[zb0001].UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "Balances", zb0001)
						return
					}
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *CatchpointSnapshotChunkV5) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *CatchpointSnapshotChunkV5) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*CatchpointSnapshotChunkV5)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *CatchpointSnapshotChunkV5) Msgsize() (s int) {
	s = 1 + 3 + msgp.ArrayHeaderSize
	for zb0001 := range (*z).Balances {
		s += (*z).Balances[zb0001].Msgsize()
	}
	return
}

// MsgIsZero returns whether this is a zero value
func (z *CatchpointSnapshotChunkV5) MsgIsZero() bool {
	return (len((*z).Balances) == 0)
}

// MaxSize returns a maximum valid message size for this message type
func CatchpointSnapshotChunkV5MaxSize() (s int) {
	s = 1 + 3
	// Calculating size of slice: z.Balances
	s += msgp.ArrayHeaderSize + ((BalancesPerCatchpointFileChunk) * (encoded.BalanceRecordV5MaxSize()))
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *CatchpointSnapshotChunkV6) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0005Len := uint32(4)
	var zb0005Mask uint8 /* 6 bits */
	if len((*z).Balances) == 0 {
		zb0005Len--
		zb0005Mask |= 0x2
	}
	if len((*z).KVs) == 0 {
		zb0005Len--
		zb0005Mask |= 0x4
	}
	if len((*z).OnlineAccounts) == 0 {
		zb0005Len--
		zb0005Mask |= 0x10
	}
	if len((*z).OnlineRoundParams) == 0 {
		zb0005Len--
		zb0005Mask |= 0x20
	}
	// variable map header, size zb0005Len
	o = append(o, 0x80|uint8(zb0005Len))
	if zb0005Len != 0 {
		if (zb0005Mask & 0x2) == 0 { // if not empty
			// string "bl"
			o = append(o, 0xa2, 0x62, 0x6c)
			if (*z).Balances == nil {
				o = msgp.AppendNil(o)
			} else {
				o = msgp.AppendArrayHeader(o, uint32(len((*z).Balances)))
			}
			for zb0001 := range (*z).Balances {
				o = (*z).Balances[zb0001].MarshalMsg(o)
			}
		}
		if (zb0005Mask & 0x4) == 0 { // if not empty
			// string "kv"
			o = append(o, 0xa2, 0x6b, 0x76)
			if (*z).KVs == nil {
				o = msgp.AppendNil(o)
			} else {
				o = msgp.AppendArrayHeader(o, uint32(len((*z).KVs)))
			}
			for zb0002 := range (*z).KVs {
				o = (*z).KVs[zb0002].MarshalMsg(o)
			}
		}
		if (zb0005Mask & 0x10) == 0 { // if not empty
			// string "oa"
			o = append(o, 0xa2, 0x6f, 0x61)
			if (*z).OnlineAccounts == nil {
				o = msgp.AppendNil(o)
			} else {
				o = msgp.AppendArrayHeader(o, uint32(len((*z).OnlineAccounts)))
			}
			for zb0003 := range (*z).OnlineAccounts {
				o = (*z).OnlineAccounts[zb0003].MarshalMsg(o)
			}
		}
		if (zb0005Mask & 0x20) == 0 { // if not empty
			// string "orp"
			o = append(o, 0xa3, 0x6f, 0x72, 0x70)
			if (*z).OnlineRoundParams == nil {
				o = msgp.AppendNil(o)
			} else {
				o = msgp.AppendArrayHeader(o, uint32(len((*z).OnlineRoundParams)))
			}
			for zb0004 := range (*z).OnlineRoundParams {
				o = (*z).OnlineRoundParams[zb0004].MarshalMsg(o)
			}
		}
	}
	return
}

func (_ *CatchpointSnapshotChunkV6) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*CatchpointSnapshotChunkV6)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *CatchpointSnapshotChunkV6) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0005 int
	var zb0006 bool
	zb0005, zb0006, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0005, zb0006, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0005 > 0 {
			zb0005--
			var zb0007 int
			var zb0008 bool
			zb0007, zb0008, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Balances")
				return
			}
			if zb0007 > BalancesPerCatchpointFileChunk {
				err = msgp.ErrOverflow(uint64(zb0007), uint64(BalancesPerCatchpointFileChunk))
				err = msgp.WrapError(err, "struct-from-array", "Balances")
				return
			}
			if zb0008 {
				(*z).Balances = nil
			} else if (*z).Balances != nil && cap((*z).Balances) >= zb0007 {
				(*z).Balances = ((*z).Balances)[:zb0007]
			} else {
				(*z).Balances = make([]encoded.BalanceRecordV6, zb0007)
			}
			for zb0001 := range (*z).Balances {
				bts, err = (*z).Balances[zb0001].UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Balances", zb0001)
					return
				}
			}
		}
		if zb0005 > 0 {
			zb0005--
			var zb0009 int
			var zb0010 bool
			zb0009, zb0010, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "KVs")
				return
			}
			if zb0009 > BalancesPerCatchpointFileChunk {
				err = msgp.ErrOverflow(uint64(zb0009), uint64(BalancesPerCatchpointFileChunk))
				err = msgp.WrapError(err, "struct-from-array", "KVs")
				return
			}
			if zb0010 {
				(*z).KVs = nil
			} else if (*z).KVs != nil && cap((*z).KVs) >= zb0009 {
				(*z).KVs = ((*z).KVs)[:zb0009]
			} else {
				(*z).KVs = make([]encoded.KVRecordV6, zb0009)
			}
			for zb0002 := range (*z).KVs {
				bts, err = (*z).KVs[zb0002].UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "KVs", zb0002)
					return
				}
			}
		}
		if zb0005 > 0 {
			zb0005--
			var zb0011 int
			var zb0012 bool
			zb0011, zb0012, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "OnlineAccounts")
				return
			}
			if zb0011 > BalancesPerCatchpointFileChunk {
				err = msgp.ErrOverflow(uint64(zb0011), uint64(BalancesPerCatchpointFileChunk))
				err = msgp.WrapError(err, "struct-from-array", "OnlineAccounts")
				return
			}
			if zb0012 {
				(*z).OnlineAccounts = nil
			} else if (*z).OnlineAccounts != nil && cap((*z).OnlineAccounts) >= zb0011 {
				(*z).OnlineAccounts = ((*z).OnlineAccounts)[:zb0011]
			} else {
				(*z).OnlineAccounts = make([]encoded.OnlineAccountRecordV6, zb0011)
			}
			for zb0003 := range (*z).OnlineAccounts {
				bts, err = (*z).OnlineAccounts[zb0003].UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "OnlineAccounts", zb0003)
					return
				}
			}
		}
		if zb0005 > 0 {
			zb0005--
			var zb0013 int
			var zb0014 bool
			zb0013, zb0014, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "OnlineRoundParams")
				return
			}
			if zb0013 > BalancesPerCatchpointFileChunk {
				err = msgp.ErrOverflow(uint64(zb0013), uint64(BalancesPerCatchpointFileChunk))
				err = msgp.WrapError(err, "struct-from-array", "OnlineRoundParams")
				return
			}
			if zb0014 {
				(*z).OnlineRoundParams = nil
			} else if (*z).OnlineRoundParams != nil && cap((*z).OnlineRoundParams) >= zb0013 {
				(*z).OnlineRoundParams = ((*z).OnlineRoundParams)[:zb0013]
			} else {
				(*z).OnlineRoundParams = make([]encoded.OnlineRoundParamsRecordV6, zb0013)
			}
			for zb0004 := range (*z).OnlineRoundParams {
				bts, err = (*z).OnlineRoundParams[zb0004].UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "OnlineRoundParams", zb0004)
					return
				}
			}
		}
		if zb0005 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0005)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0006 {
			(*z) = CatchpointSnapshotChunkV6{}
		}
		for zb0005 > 0 {
			zb0005--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "bl":
				var zb0015 int
				var zb0016 bool
				zb0015, zb0016, bts, err = msgp.ReadArrayHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Balances")
					return
				}
				if zb0015 > BalancesPerCatchpointFileChunk {
					err = msgp.ErrOverflow(uint64(zb0015), uint64(BalancesPerCatchpointFileChunk))
					err = msgp.WrapError(err, "Balances")
					return
				}
				if zb0016 {
					(*z).Balances = nil
				} else if (*z).Balances != nil && cap((*z).Balances) >= zb0015 {
					(*z).Balances = ((*z).Balances)[:zb0015]
				} else {
					(*z).Balances = make([]encoded.BalanceRecordV6, zb0015)
				}
				for zb0001 := range (*z).Balances {
					bts, err = (*z).Balances[zb0001].UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "Balances", zb0001)
						return
					}
				}
			case "kv":
				var zb0017 int
				var zb0018 bool
				zb0017, zb0018, bts, err = msgp.ReadArrayHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "KVs")
					return
				}
				if zb0017 > BalancesPerCatchpointFileChunk {
					err = msgp.ErrOverflow(uint64(zb0017), uint64(BalancesPerCatchpointFileChunk))
					err = msgp.WrapError(err, "KVs")
					return
				}
				if zb0018 {
					(*z).KVs = nil
				} else if (*z).KVs != nil && cap((*z).KVs) >= zb0017 {
					(*z).KVs = ((*z).KVs)[:zb0017]
				} else {
					(*z).KVs = make([]encoded.KVRecordV6, zb0017)
				}
				for zb0002 := range (*z).KVs {
					bts, err = (*z).KVs[zb0002].UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "KVs", zb0002)
						return
					}
				}
			case "oa":
				var zb0019 int
				var zb0020 bool
				zb0019, zb0020, bts, err = msgp.ReadArrayHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "OnlineAccounts")
					return
				}
				if zb0019 > BalancesPerCatchpointFileChunk {
					err = msgp.ErrOverflow(uint64(zb0019), uint64(BalancesPerCatchpointFileChunk))
					err = msgp.WrapError(err, "OnlineAccounts")
					return
				}
				if zb0020 {
					(*z).OnlineAccounts = nil
				} else if (*z).OnlineAccounts != nil && cap((*z).OnlineAccounts) >= zb0019 {
					(*z).OnlineAccounts = ((*z).OnlineAccounts)[:zb0019]
				} else {
					(*z).OnlineAccounts = make([]encoded.OnlineAccountRecordV6, zb0019)
				}
				for zb0003 := range (*z).OnlineAccounts {
					bts, err = (*z).OnlineAccounts[zb0003].UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "OnlineAccounts", zb0003)
						return
					}
				}
			case "orp":
				var zb0021 int
				var zb0022 bool
				zb0021, zb0022, bts, err = msgp.ReadArrayHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "OnlineRoundParams")
					return
				}
				if zb0021 > BalancesPerCatchpointFileChunk {
					err = msgp.ErrOverflow(uint64(zb0021), uint64(BalancesPerCatchpointFileChunk))
					err = msgp.WrapError(err, "OnlineRoundParams")
					return
				}
				if zb0022 {
					(*z).OnlineRoundParams = nil
				} else if (*z).OnlineRoundParams != nil && cap((*z).OnlineRoundParams) >= zb0021 {
					(*z).OnlineRoundParams = ((*z).OnlineRoundParams)[:zb0021]
				} else {
					(*z).OnlineRoundParams = make([]encoded.OnlineRoundParamsRecordV6, zb0021)
				}
				for zb0004 := range (*z).OnlineRoundParams {
					bts, err = (*z).OnlineRoundParams[zb0004].UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "OnlineRoundParams", zb0004)
						return
					}
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *CatchpointSnapshotChunkV6) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *CatchpointSnapshotChunkV6) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*CatchpointSnapshotChunkV6)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *CatchpointSnapshotChunkV6) Msgsize() (s int) {
	s = 1 + 3 + msgp.ArrayHeaderSize
	for zb0001 := range (*z).Balances {
		s += (*z).Balances[zb0001].Msgsize()
	}
	s += 3 + msgp.ArrayHeaderSize
	for zb0002 := range (*z).KVs {
		s += (*z).KVs[zb0002].Msgsize()
	}
	s += 3 + msgp.ArrayHeaderSize
	for zb0003 := range (*z).OnlineAccounts {
		s += (*z).OnlineAccounts[zb0003].Msgsize()
	}
	s += 4 + msgp.ArrayHeaderSize
	for zb0004 := range (*z).OnlineRoundParams {
		s += (*z).OnlineRoundParams[zb0004].Msgsize()
	}
	return
}

// MsgIsZero returns whether this is a zero value
func (z *CatchpointSnapshotChunkV6) MsgIsZero() bool {
	return (len((*z).Balances) == 0) && (len((*z).KVs) == 0) && (len((*z).OnlineAccounts) == 0) && (len((*z).OnlineRoundParams) == 0)
}

// MaxSize returns a maximum valid message size for this message type
func CatchpointSnapshotChunkV6MaxSize() (s int) {
	s = 1 + 3
	// Calculating size of slice: z.Balances
	s += msgp.ArrayHeaderSize + ((BalancesPerCatchpointFileChunk) * (encoded.BalanceRecordV6MaxSize()))
	s += 3
	// Calculating size of slice: z.KVs
	s += msgp.ArrayHeaderSize + ((BalancesPerCatchpointFileChunk) * (encoded.KVRecordV6MaxSize()))
	s += 3
	// Calculating size of slice: z.OnlineAccounts
	s += msgp.ArrayHeaderSize + ((BalancesPerCatchpointFileChunk) * (encoded.OnlineAccountRecordV6MaxSize()))
	s += 4
	// Calculating size of slice: z.OnlineRoundParams
	s += msgp.ArrayHeaderSize + ((BalancesPerCatchpointFileChunk) * (encoded.OnlineRoundParamsRecordV6MaxSize()))
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *catchpointStateProofVerificationContext) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0002Len := uint32(1)
	var zb0002Mask uint8 /* 2 bits */
	if len((*z).Data) == 0 {
		zb0002Len--
		zb0002Mask |= 0x2
	}
	// variable map header, size zb0002Len
	o = append(o, 0x80|uint8(zb0002Len))
	if zb0002Len != 0 {
		if (zb0002Mask & 0x2) == 0 { // if not empty
			// string "spd"
			o = append(o, 0xa3, 0x73, 0x70, 0x64)
			if (*z).Data == nil {
				o = msgp.AppendNil(o)
			} else {
				o = msgp.AppendArrayHeader(o, uint32(len((*z).Data)))
			}
			for zb0001 := range (*z).Data {
				o = (*z).Data[zb0001].MarshalMsg(o)
			}
		}
	}
	return
}

func (_ *catchpointStateProofVerificationContext) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*catchpointStateProofVerificationContext)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *catchpointStateProofVerificationContext) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0002 int
	var zb0003 bool
	zb0002, zb0003, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0002, zb0003, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 > 0 {
			zb0002--
			var zb0004 int
			var zb0005 bool
			zb0004, zb0005, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Data")
				return
			}
			if zb0004 > SPContextPerCatchpointFile {
				err = msgp.ErrOverflow(uint64(zb0004), uint64(SPContextPerCatchpointFile))
				err = msgp.WrapError(err, "struct-from-array", "Data")
				return
			}
			if zb0005 {
				(*z).Data = nil
			} else if (*z).Data != nil && cap((*z).Data) >= zb0004 {
				(*z).Data = ((*z).Data)[:zb0004]
			} else {
				(*z).Data = make([]ledgercore.StateProofVerificationContext, zb0004)
			}
			for zb0001 := range (*z).Data {
				bts, err = (*z).Data[zb0001].UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Data", zb0001)
					return
				}
			}
		}
		if zb0002 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0002)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0003 {
			(*z) = catchpointStateProofVerificationContext{}
		}
		for zb0002 > 0 {
			zb0002--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "spd":
				var zb0006 int
				var zb0007 bool
				zb0006, zb0007, bts, err = msgp.ReadArrayHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Data")
					return
				}
				if zb0006 > SPContextPerCatchpointFile {
					err = msgp.ErrOverflow(uint64(zb0006), uint64(SPContextPerCatchpointFile))
					err = msgp.WrapError(err, "Data")
					return
				}
				if zb0007 {
					(*z).Data = nil
				} else if (*z).Data != nil && cap((*z).Data) >= zb0006 {
					(*z).Data = ((*z).Data)[:zb0006]
				} else {
					(*z).Data = make([]ledgercore.StateProofVerificationContext, zb0006)
				}
				for zb0001 := range (*z).Data {
					bts, err = (*z).Data[zb0001].UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "Data", zb0001)
						return
					}
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *catchpointStateProofVerificationContext) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *catchpointStateProofVerificationContext) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*catchpointStateProofVerificationContext)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *catchpointStateProofVerificationContext) Msgsize() (s int) {
	s = 1 + 4 + msgp.ArrayHeaderSize
	for zb0001 := range (*z).Data {
		s += (*z).Data[zb0001].Msgsize()
	}
	return
}

// MsgIsZero returns whether this is a zero value
func (z *catchpointStateProofVerificationContext) MsgIsZero() bool {
	return (len((*z).Data) == 0)
}

// MaxSize returns a maximum valid message size for this message type
func CatchpointStateProofVerificationContextMaxSize() (s int) {
	s = 1 + 4
	// Calculating size of slice: z.Data
	s += msgp.ArrayHeaderSize + ((SPContextPerCatchpointFile) * (ledgercore.StateProofVerificationContextMaxSize()))
	return
}
