package stateproofmsg

// Code generated by github.com/algorand/msgp DO NOT EDIT.

import (
	"github.com/algorand/msgp/msgp"

	"github.com/algorand/go-algorand/crypto"
	"github.com/algorand/go-algorand/data/basics"
)

// The following msgp objects are implemented in this file:
// Message
//    |-----> (*) MarshalMsg
//    |-----> (*) CanMarshalMsg
//    |-----> (*) UnmarshalMsg
//    |-----> (*) UnmarshalMsgWithState
//    |-----> (*) CanUnmarshalMsg
//    |-----> (*) Msgsize
//    |-----> (*) MsgIsZero
//    |-----> MessageMaxSize()
//

// MarshalMsg implements msgp.Marshaler
func (z *Message) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0001Len := uint32(5)
	var zb0001Mask uint8 /* 6 bits */
	if (*z).LnProvenWeight == 0 {
		zb0001Len--
		zb0001Mask |= 0x1
	}
	if len((*z).BlockHeadersCommitment) == 0 {
		zb0001Len--
		zb0001Mask |= 0x4
	}
	if (*z).FirstAttestedRound.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x8
	}
	if (*z).LastAttestedRound.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x10
	}
	if len((*z).VotersCommitment) == 0 {
		zb0001Len--
		zb0001Mask |= 0x20
	}
	// variable map header, size zb0001Len
	o = append(o, 0x80|uint8(zb0001Len))
	if zb0001Len != 0 {
		if (zb0001Mask & 0x1) == 0 { // if not empty
			// string "P"
			o = append(o, 0xa1, 0x50)
			o = msgp.AppendUint64(o, (*z).LnProvenWeight)
		}
		if (zb0001Mask & 0x4) == 0 { // if not empty
			// string "b"
			o = append(o, 0xa1, 0x62)
			o = msgp.AppendBytes(o, (*z).BlockHeadersCommitment)
		}
		if (zb0001Mask & 0x8) == 0 { // if not empty
			// string "f"
			o = append(o, 0xa1, 0x66)
			o = (*z).FirstAttestedRound.MarshalMsg(o)
		}
		if (zb0001Mask & 0x10) == 0 { // if not empty
			// string "l"
			o = append(o, 0xa1, 0x6c)
			o = (*z).LastAttestedRound.MarshalMsg(o)
		}
		if (zb0001Mask & 0x20) == 0 { // if not empty
			// string "v"
			o = append(o, 0xa1, 0x76)
			o = msgp.AppendBytes(o, (*z).VotersCommitment)
		}
	}
	return
}

func (_ *Message) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*Message)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *Message) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0001 int
	var zb0002 bool
	zb0001, zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0001, zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0001 > 0 {
			zb0001--
			var zb0003 int
			zb0003, err = msgp.ReadBytesBytesHeader(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "BlockHeadersCommitment")
				return
			}
			if zb0003 > crypto.Sha256Size {
				err = msgp.ErrOverflow(uint64(zb0003), uint64(crypto.Sha256Size))
				return
			}
			(*z).BlockHeadersCommitment, bts, err = msgp.ReadBytesBytes(bts, (*z).BlockHeadersCommitment)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "BlockHeadersCommitment")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			var zb0004 int
			zb0004, err = msgp.ReadBytesBytesHeader(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "VotersCommitment")
				return
			}
			if zb0004 > crypto.SumhashDigestSize {
				err = msgp.ErrOverflow(uint64(zb0004), uint64(crypto.SumhashDigestSize))
				return
			}
			(*z).VotersCommitment, bts, err = msgp.ReadBytesBytes(bts, (*z).VotersCommitment)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "VotersCommitment")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			(*z).LnProvenWeight, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "LnProvenWeight")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).FirstAttestedRound.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "FirstAttestedRound")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).LastAttestedRound.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "LastAttestedRound")
				return
			}
		}
		if zb0001 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0001)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 {
			(*z) = Message{}
		}
		for zb0001 > 0 {
			zb0001--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "b":
				var zb0005 int
				zb0005, err = msgp.ReadBytesBytesHeader(bts)
				if err != nil {
					err = msgp.WrapError(err, "BlockHeadersCommitment")
					return
				}
				if zb0005 > crypto.Sha256Size {
					err = msgp.ErrOverflow(uint64(zb0005), uint64(crypto.Sha256Size))
					return
				}
				(*z).BlockHeadersCommitment, bts, err = msgp.ReadBytesBytes(bts, (*z).BlockHeadersCommitment)
				if err != nil {
					err = msgp.WrapError(err, "BlockHeadersCommitment")
					return
				}
			case "v":
				var zb0006 int
				zb0006, err = msgp.ReadBytesBytesHeader(bts)
				if err != nil {
					err = msgp.WrapError(err, "VotersCommitment")
					return
				}
				if zb0006 > crypto.SumhashDigestSize {
					err = msgp.ErrOverflow(uint64(zb0006), uint64(crypto.SumhashDigestSize))
					return
				}
				(*z).VotersCommitment, bts, err = msgp.ReadBytesBytes(bts, (*z).VotersCommitment)
				if err != nil {
					err = msgp.WrapError(err, "VotersCommitment")
					return
				}
			case "P":
				(*z).LnProvenWeight, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "LnProvenWeight")
					return
				}
			case "f":
				bts, err = (*z).FirstAttestedRound.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "FirstAttestedRound")
					return
				}
			case "l":
				bts, err = (*z).LastAttestedRound.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "LastAttestedRound")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *Message) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *Message) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*Message)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *Message) Msgsize() (s int) {
	s = 1 + 2 + msgp.BytesPrefixSize + len((*z).BlockHeadersCommitment) + 2 + msgp.BytesPrefixSize + len((*z).VotersCommitment) + 2 + msgp.Uint64Size + 2 + (*z).FirstAttestedRound.Msgsize() + 2 + (*z).LastAttestedRound.Msgsize()
	return
}

// MsgIsZero returns whether this is a zero value
func (z *Message) MsgIsZero() bool {
	return (len((*z).BlockHeadersCommitment) == 0) && (len((*z).VotersCommitment) == 0) && ((*z).LnProvenWeight == 0) && ((*z).FirstAttestedRound.MsgIsZero()) && ((*z).LastAttestedRound.MsgIsZero())
}

// MaxSize returns a maximum valid message size for this message type
func MessageMaxSize() (s int) {
	s = 1 + 2 + msgp.BytesPrefixSize + crypto.Sha256Size + 2 + msgp.BytesPrefixSize + crypto.SumhashDigestSize + 2 + msgp.Uint64Size + 2 + basics.RoundMaxSize() + 2 + basics.RoundMaxSize()
	return
}
