// Package private provides primitives to interact with the openapi HTTP API.
//
// Code generated by github.com/oapi-codegen/oapi-codegen/v2 version v2.4.1 DO NOT EDIT.
package private

import (
	"bytes"
	"compress/gzip"
	"encoding/base64"
	"fmt"
	"net/http"
	"net/url"
	"path"
	"strings"

	. "github.com/algorand/go-algorand/daemon/algod/api/server/v2/generated/model"
	"github.com/algorand/go-algorand/data/basics"
	"github.com/getkin/kin-openapi/openapi3"
	"github.com/labstack/echo/v4"
	"github.com/oapi-codegen/runtime"
)

// ServerInterface represents all server handlers.
type ServerInterface interface {
	// Gets the merged config file.
	// (GET /debug/settings/config)
	GetConfig(ctx echo.Context) error

	// (GET /debug/settings/pprof)
	GetDebugSettingsProf(ctx echo.Context) error

	// (PUT /debug/settings/pprof)
	PutDebugSettingsProf(ctx echo.Context) error
	// Return a list of participation keys
	// (GET /v2/participation)
	GetParticipationKeys(ctx echo.Context) error
	// Add a participation key to the node
	// (POST /v2/participation)
	AddParticipationKey(ctx echo.Context) error
	// Generate and install participation keys to the node.
	// (POST /v2/participation/generate/{address})
	GenerateParticipationKeys(ctx echo.Context, address basics.Address, params GenerateParticipationKeysParams) error
	// Delete a given participation key by ID
	// (DELETE /v2/participation/{participation-id})
	DeleteParticipationKeyByID(ctx echo.Context, participationId string) error
	// Get participation key info given a participation ID
	// (GET /v2/participation/{participation-id})
	GetParticipationKeyByID(ctx echo.Context, participationId string) error
	// Append state proof keys to a participation key
	// (POST /v2/participation/{participation-id})
	AppendKeys(ctx echo.Context, participationId string) error
}

// ServerInterfaceWrapper converts echo contexts to parameters.
type ServerInterfaceWrapper struct {
	Handler ServerInterface
}

// GetConfig converts echo context to params.
func (w *ServerInterfaceWrapper) GetConfig(ctx echo.Context) error {
	var err error

	ctx.Set(Api_keyScopes, []string{})

	// Invoke the callback with all the unmarshaled arguments
	err = w.Handler.GetConfig(ctx)
	return err
}

// GetDebugSettingsProf converts echo context to params.
func (w *ServerInterfaceWrapper) GetDebugSettingsProf(ctx echo.Context) error {
	var err error

	ctx.Set(Api_keyScopes, []string{})

	// Invoke the callback with all the unmarshaled arguments
	err = w.Handler.GetDebugSettingsProf(ctx)
	return err
}

// PutDebugSettingsProf converts echo context to params.
func (w *ServerInterfaceWrapper) PutDebugSettingsProf(ctx echo.Context) error {
	var err error

	ctx.Set(Api_keyScopes, []string{})

	// Invoke the callback with all the unmarshaled arguments
	err = w.Handler.PutDebugSettingsProf(ctx)
	return err
}

// GetParticipationKeys converts echo context to params.
func (w *ServerInterfaceWrapper) GetParticipationKeys(ctx echo.Context) error {
	var err error

	ctx.Set(Api_keyScopes, []string{})

	// Invoke the callback with all the unmarshaled arguments
	err = w.Handler.GetParticipationKeys(ctx)
	return err
}

// AddParticipationKey converts echo context to params.
func (w *ServerInterfaceWrapper) AddParticipationKey(ctx echo.Context) error {
	var err error

	ctx.Set(Api_keyScopes, []string{})

	// Invoke the callback with all the unmarshaled arguments
	err = w.Handler.AddParticipationKey(ctx)
	return err
}

// GenerateParticipationKeys converts echo context to params.
func (w *ServerInterfaceWrapper) GenerateParticipationKeys(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "address" -------------
	var address basics.Address

	err = runtime.BindStyledParameterWithOptions("simple", "address", ctx.Param("address"), &address, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter address: %s", err))
	}

	ctx.Set(Api_keyScopes, []string{})

	// Parameter object where we will unmarshal all parameters from the context
	var params GenerateParticipationKeysParams
	// ------------- Optional query parameter "dilution" -------------

	err = runtime.BindQueryParameter("form", true, false, "dilution", ctx.QueryParams(), &params.Dilution)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter dilution: %s", err))
	}

	// ------------- Required query parameter "first" -------------

	err = runtime.BindQueryParameter("form", true, true, "first", ctx.QueryParams(), &params.First)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter first: %s", err))
	}

	// ------------- Required query parameter "last" -------------

	err = runtime.BindQueryParameter("form", true, true, "last", ctx.QueryParams(), &params.Last)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter last: %s", err))
	}

	// Invoke the callback with all the unmarshaled arguments
	err = w.Handler.GenerateParticipationKeys(ctx, address, params)
	return err
}

// DeleteParticipationKeyByID converts echo context to params.
func (w *ServerInterfaceWrapper) DeleteParticipationKeyByID(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "participation-id" -------------
	var participationId string

	err = runtime.BindStyledParameterWithOptions("simple", "participation-id", ctx.Param("participation-id"), &participationId, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter participation-id: %s", err))
	}

	ctx.Set(Api_keyScopes, []string{})

	// Invoke the callback with all the unmarshaled arguments
	err = w.Handler.DeleteParticipationKeyByID(ctx, participationId)
	return err
}

// GetParticipationKeyByID converts echo context to params.
func (w *ServerInterfaceWrapper) GetParticipationKeyByID(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "participation-id" -------------
	var participationId string

	err = runtime.BindStyledParameterWithOptions("simple", "participation-id", ctx.Param("participation-id"), &participationId, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter participation-id: %s", err))
	}

	ctx.Set(Api_keyScopes, []string{})

	// Invoke the callback with all the unmarshaled arguments
	err = w.Handler.GetParticipationKeyByID(ctx, participationId)
	return err
}

// AppendKeys converts echo context to params.
func (w *ServerInterfaceWrapper) AppendKeys(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "participation-id" -------------
	var participationId string

	err = runtime.BindStyledParameterWithOptions("simple", "participation-id", ctx.Param("participation-id"), &participationId, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter participation-id: %s", err))
	}

	ctx.Set(Api_keyScopes, []string{})

	// Invoke the callback with all the unmarshaled arguments
	err = w.Handler.AppendKeys(ctx, participationId)
	return err
}

// This is a simple interface which specifies echo.Route addition functions which
// are present on both echo.Echo and echo.Group, since we want to allow using
// either of them for path registration
type EchoRouter interface {
	CONNECT(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	DELETE(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	GET(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	HEAD(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	OPTIONS(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	PATCH(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	POST(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	PUT(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	TRACE(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
}

// RegisterHandlers adds each server route to the EchoRouter.
func RegisterHandlers(router EchoRouter, si ServerInterface, m ...echo.MiddlewareFunc) {
	RegisterHandlersWithBaseURL(router, si, "", m...)
}

// Registers handlers, and prepends BaseURL to the paths, so that the paths
// can be served under a prefix.
func RegisterHandlersWithBaseURL(router EchoRouter, si ServerInterface, baseURL string, m ...echo.MiddlewareFunc) {

	wrapper := ServerInterfaceWrapper{
		Handler: si,
	}

	router.GET(baseURL+"/debug/settings/config", wrapper.GetConfig, m...)
	router.GET(baseURL+"/debug/settings/pprof", wrapper.GetDebugSettingsProf, m...)
	router.PUT(baseURL+"/debug/settings/pprof", wrapper.PutDebugSettingsProf, m...)
	router.GET(baseURL+"/v2/participation", wrapper.GetParticipationKeys, m...)
	router.POST(baseURL+"/v2/participation", wrapper.AddParticipationKey, m...)
	router.POST(baseURL+"/v2/participation/generate/:address", wrapper.GenerateParticipationKeys, m...)
	router.DELETE(baseURL+"/v2/participation/:participation-id", wrapper.DeleteParticipationKeyByID, m...)
	router.GET(baseURL+"/v2/participation/:participation-id", wrapper.GetParticipationKeyByID, m...)
	router.POST(baseURL+"/v2/participation/:participation-id", wrapper.AppendKeys, m...)

}

// Base64 encoded, gzipped, json marshaled Swagger object
var swaggerSpec = []string{

	"H4sIAAAAAAAC/+y9a3MbN5Mo/FdQ3K3yZUlKduxs4ree2leJc9HGiV2Wkj27lk8CzjRJPBoCEwAjkfHx",
	"fz+FxmUwMxhySNF2UiefbHFwaTQajUZf340ysSoFB67V6Nm7UUklXYEGiX/RPJeg8L85qEyyUjPBR89G",
	"Z5zQLBMV16SsZgXLyDVspqPxiJmvJdXL0XjE6QpGz8Ig45GE3ysmIR8907KC8UhlS1hRO63WIE3fN2eT",
	"/zmdfPn23dMv3o/GI70pzRhKS8YXo/FoPVmIiftxRhXL1PTMjf9+11dalgXLqFnChOXpRdVNCMuBazZn",
	"IPsW1hxv2/pWjLNVtRo9Ow1LYlzDAmTPmsrynOew7ltU9JkqBbp3PebjgJX4MY66BjPo1lU0GmRUZ8tS",
	"MK4TKyH4ldjPySVE3bctYi7kiup2+4j8kPYejR+dvv+XQIqPxk8/SxMjLRZCUp5Pwrhfh3HJhW33fo+G",
	"/msbAV8LPmeLSoIit0vQS5BEL4FIUKXgCoiY/RMyTZgi/3nx8iciJPkRlKILeEWzawI8EznkU3I+J1xo",
	"Ukpxw3LIxySHOa0KrYgW2DPQx+8VyE2NXQdXjEnghhbejP6pBB+NRyu1KGl2PXrbRtP79+NRwVYssaof",
	"6dpQFOHVagaSiLlZkAdHgq4k7wPIjhjDs5UkK8b150/adFj/uqLrLniXsuIZ1ZBHAGpJuaKZaYFQ5kyV",
	"Bd0gald0/Y/TsQNcEVoUpASeM74ges1V31LM3EdbCId1AtGXSyDmCynpAiI8T8nPCpCS8KsW18ADdZDZ",
	"Bj+VEm6YqFTo1LMOnDqxkIgOpKh4ilER/ODQ3MOjbN9jMqjXOOL77d8UW7hPbagv2OJyUwKZs8Lcl+Sf",
	"ldKBgCuF274EokrIDO/NiRnGIF+xBae6kvDsij80f5EJudCU51Tm5peV/enHqtDsgi3MT4X96YVYsOyC",
	"LXp2IMCaOqcKu63sP2a89FHV6+Rd8kKI66qMF5TFZ8HQyvnzPsqwY/aTRppBngW5AffHjXW5Pn/ex1K3",
	"99DrsJE9QPbirqSm4TVsJBhoaTbHf9ZzJC06l3+MrHhheutynkKtIX/HrlGgOrPy01ktRLx2n83XTHAN",
	"9iqMxIwTZLbP3sWSkxQlSM3soLQsJ4XIaDFRmmoc6V8lzEfPRv9yUgt6J7a7Ookmf2F6XWAncxlLMIxv",
	"QstyjzFeGeERRa2eg274kD3qcyHJ7ZJlS6KXTBHG7Sai3GU4TQE3lOvpaK+T/D7mDm8cEPVW2EvSbkWL",
	"AfXuBbENZ6CQ9p3Qe081JEXEOEGME8pzsijELPxw/6wsa+Ti97OytKgaEzYnwPA+hzVTWj1AzND6kMXz",
	"nD+fku/isW9ZURDBiw2Zgbt3IDdjWr7t+LgTwA1icQ31iPcUwZ0Wcmp2zaPByGXHIEaUKpeiMFfgTjIy",
	"jb93bWMKNL8P6vyXp74Y7f10hxK9QypSk/2lfriR+y2i6tIU9jDUdNbuexhFmVG20JI6rxF8bLrCX5iG",
	"ldpJJBFEEaG57aFS0o2XoCYoCXUp6GcFlnhKumAcoR0bgZyTFb22+yEQ74YQQAVJ25KZFa9umV7WIldA",
	"/bTzvvhrE3Jqz4nZcMqMbEwKprQRhnAzFVlCgQInDYqFmIoOIpoBtLBlEQHmW0lLS+bui5XjGCc0vL8s",
	"rHe8yQdeskmYY7VFjXeE6mBmvpPhJiGxCocmDF8VIrv+nqrlEQ7/zI/VPRY4DVkCzUGSJVXLxJlq0XY9",
	"2hD6Ng2RZsksmmoalvhCLNQRlliIfbhaWX5Ni8JM3eVmrdXiwIMOclEQ05jAimnzAGYcT8CC3QC3rGdK",
	"vqHZ0ggTJKNFMa71EqKcFHADBRGSMM5BjoleUl0ffhzZP5TwHCkwfFADiVbjdBpTcrkECXMh8aEqgawo",
	"Xk4r8zwqi2afwFwVXUFLdsLLUlTawBi9XM6f+9XBDXDkSWFoBD+sER/88eBTM7f7hDNzYRdHJaCihfGs",
	"qPIaf4FfNIA2reurltdTCJmjoodq8xuTJBPSDmEvfze5+Q9QWXe21Hm/lDBxQ0h6A1LRwqyutagHgXyP",
	"dTp3nMycahqdTEeF6Red5RzYD4VCkAntxkv8Dy2I+WwEHENJNfUwlFNQpgn7gXe2QZWdyTQwfEsLsrJ6",
	"M1LS7HovKL+uJ0+zmUEn7xurqnNb6BYRduhyzXJ1rG3Cwfr2qnlCrM7Hs6OOmLKV6URzDUHApSiJZR8t",
	"ECynwNEsQsT66NfaV2Kdgukrse5caWINR9kJM85gZv+VWD93kAm5G/M49hCkmwVyugKFt1vDDGJmqVXV",
	"ZzMhD5MmOqaJWgFPqBk1EqbGLSRh06qcuLOZUI/bBq2BSFAvbRcC2sOnMNbAwoWmHwALyox6DCw0Bzo2",
	"FsSqZAUcgfSXSSFuRhV89phcfH/29NHjXx8//dyQZCnFQtIVmW00KHLf6fmI0psCHiQfTihdpEf//Ik3",
	"iDTHTY2jRCUzWNGyO5Q1tNiHsW1GTLsu1ppoxlUHAAdxRDBXm0U7eW37vR+PnsOsWlyA1uYR/EqK+dG5",
	"YWeGFHTY6FUpjWChmkYpJy2d5KbJCay1pCcltgSeW9ObWQdT5g24mh2FqPo2Pq9nyYnDaA47D8W+21RP",
	"s4m3Sm5kdQzNB0gpZPIKLqXQIhPFxMh5TCR0F69cC+Ja+O0q279baMktVcTMjQawiuc9Kgq95sPvLzv0",
	"5ZrXuNl6g9n1Jlbn5h2yL03k16+QEuRErzlB6mxoTuZSrAglOXZEWeM70Fb+Yiu40HRVvpzPj6MjFThQ",
	"QsXDVqDMTMS2MNKPgkzwXO3U5nhrYAuZbqohOGtjy9uydD9UDk0XG56hGukYZ7lf++VMfURteBapwgyM",
	"BeSLBq1+UJVXH6YsFPdUAlKDqRf4GS0Cz6HQ9FshL2tx9zspqvLo7Lw959DlULcYZ3PITV+vUWZ8UUBD",
	"Ul8Y2KepNX6SBX0dlA52DQg9EusLtljq6H35SooPcIcmZ0kBih+scqkwfboqpp9EbpiPrtQRRM96sJoj",
	"GrqN+SCdiUoTSrjIATe/UmmhtMdrxxzUrJISuI7lXNRnMEVmYKgro5VZbVUSLVL3S91xQjN7QieIGtXj",
	"5hBcNWwrO92S3gChhQSab8gMgBMxM4uuvRxwkVSR0sjOTqxzIvFQftsAtpQiA6Ugnzh99k54fTt7/+gt",
	"yMPV4CrCLEQJMqfyw6zg+mYn8NewmdzQojLi+Q+/qAd/lkVooWmxYwuwTWoj2uq77lLuANM2Im5DFJOy",
	"1Rbak2BEbMN0CtDQh+y7Y693+9tgdojgAyHwBiR61HzQo+Un+QBEGeD/wAfrgyyhKidGDOxVPxjJ1ew3",
	"p1x42XDHDGGCgio92XWlmEYNvYlZasTFU7cIDtwjT76gSqMYSBjPUX9rr0Kcx8qWZorRnk5lOGXva8xM",
	"+ot/iHWnzcz1zlWlwqtMVWUppIY8tTy0WffO9ROsw1xiHo0dnn5akErBrpH7EBiN7/DoFAH4B9XBQu1s",
	"3t3FodeBEV82+2K5AV+No20wXvhWEeJjp9oeGJmq98CSG1MtepsJUQBFlanSoiwNh9KTiod+fRi8sK3P",
	"9M912y5JWjOQlVRyAQpNTK69g/zWIl2hrWtJFXFweP8EVHhZF7kuzOZYTxTjGUy2nRd8BJtW8cE56LhX",
	"5ULSHCY5FHST8Lawn4n9vCdh+LGRQGr9gdAwmaE1MU0j9Znw/qaHzSpwKpUSvAl+IZk55+YZVZOa6334",
	"pDngtCm+6Yj1XpgFwUjSgR8PkWXpKTEi3v03QhuyckSHq3G30h3X0oO9MOsHQSCOO6kVAe3Z/xuUmzsI",
	"YEedfwOqb+H11Mdado/6H+/2xoXZuspat03yiujlyzsYYx8P6rFFvKJSs4yV+Fz9ATZHf723J0j6SpAc",
	"NGUF5CT6YF/yZdyfWDfk9piHveYHqVu74Hf0rYnleM+sJvDXsEG1ySsb0RBpq46hjkiMai5cygkC6r3m",
	"zYsnbgJrmuliYwRbvYQNuQUJRFUz67XSNaFpUU7iAdIxU/0zOoN80hy+1UPgAoeKlpfyPLSvre3wXbae",
	"XA10uFdWKUSR0H+2T3wHGUkIBrkLkVKYXWe0KDZEh7AZT0kNIN0Fgd4YQZ65pxpoxhWQ/xYVySjHF26l",
	"IQhpQqLkg8KymcGIm2FO56paYwgKWIF9zeOXhw/bC3/40O05U2QOt9blhmPDNjoePkRV3CuhdONwHUHb",
	"bY7beeLSQVuluWTdq63NU3Y7ubmRh+zkq9bgwcBpzpRSjnDN8u/MAFoncz1k7TGNDHPww3EHme+aLmGd",
	"deO+X7BVVVB9DEMl3NBiIm5ASpbDTk7uJmaCf3NDi5eh2/vxCNaQGRrNYJJhlODAseDS9LGBhWYcxpk5",
	"wDZwZChAcG57XdhOO17atd8yW60gZ1RDsSGlhAxslJyRUlVY6pTYkIlsSfkCX0BSVAvn6mzHQYZfKasJ",
	"kxXvDLGvKKbXfIImDJUMU0OzpY+2NEIYUPOybds/7GPtlgZQ7GU06NKOtqdtD0qaTMej3oe/wfdN/fC3",
	"eGuGjB5qTGzIhxHSamgGWs8Qn0ZW6iIx3kZz+AwxfBgrTT10CsruxJFTeP2xzy/8oirLYnMEIckORCSU",
	"EhReabEaUNmvYk5+ZJkUZ8VChDtPbZSGVdd4Y7v+2nNcXx/yAha8YBwmK8Eh8aR/iV9/xI+D1Y72Gu4Z",
	"EQWivQZsP3waSGgtoDn5EJK+6yYhybTPftvSqb4V8lhWdjvg4DfFAMv1TrcON+Wh9nVaFAmTtFU/dLiI",
	"GgencCYJVUpkDAXF81yNnfe5tWJbt/YW+l+F0KgjHOD2uC3baxSGZRX5UJSEkqxgqOYXXGlZZfqKU9T0",
	"RUtNOAt65UC/Wvhr3ySth06oid1QV5yio2jQ/yUdg+aQ0EN9C+C1w6paLEDp1gNrDnDFXSvGScWZxrlW",
	"5rhM7HkpQaLH3tS2XNENmRua0IL8AVKQWaWbT45VpTRRmhWFMwSbaYiYX3GqSQFUafIj45drHM77kfgj",
	"y0HfCnkdsDAdzrgWwEExNUl7On5nv2JQicPJ0gWYYKyF/ew9nuvcECOz9kbSiv99/z+evTmb/A+d/HE6",
	"+fLfTt6+e/L+wcPOj4/f/+Mf/6f502fv//HgP/41tX0e9lQwuIP8/Ll7o58/x4dYFCfShv3PYJBZMT5J",
	"EmXsUNSiRXIf82U4gnvQ1PvpJVxxveaG8G5owXLDi45GPu1rqnOg7RFrUVlj41pqPI+APZ9Dd2BVJMGp",
	"Wvz1g8hz7Qm2OtzEW96KMXCcUR0dQDdwCq72nCm32nvffXNJThwhqHtILG7oKLVA4gXjIhgbXj5ml+LA",
	"rit+xZ/DHN+Dgj+74jnV9MSeppNKgfyKFpRnMF0I8swHRT6nml7xzjXUm0AqCmqOMkilOAVdpddydfWG",
	"FgtxdfW244fQla3cVDEXdeesqybzU06M3CAqPXFJXCYSbqlM2UJ8ig8XDY29t8JhZRJRWSWWTxLjxp8O",
	"hbIsVTvZQxdFZVkYFEWkqly+ArOtRGkRAscMM3ext4YGfhLOqUTSW//krRQo8tuKlm8Y12/J5Ko6Pf0M",
	"Q/DqFAe/OR5o6HZTwuCHb28yivZ7Fxdu5XJ0Kp+UdJGymVxdvdFAS6QQFDhW+NIsCoLdGuGBPhIAh6oX",
	"EGKR99gSC9necb243Avby6f1Si8KP+GmNmOn77SDUVT8wRu4I7KeVno5MRwhuSpljoHfK59ggC7MleM9",
	"CBRb4ANALUVllgwkW0J27TJbwarUm3Gju3d0cXexZzhMoc7IBQfOmcFfRrkZsCpz6gQZyjftFDfKBkPg",
	"oK/hGjaXwnafDswOFmWji1KsqL6ji7Qb3bWGfOOD7MZob77zu/Ixoi4dCcZderJ4FujC9+k/2lYAOMKx",
	"ThFFI89HHyKoTCDCEn8PCg5YqBnvTqSfWh7jGXDNbmACBVuwWZFg0//VtWt4WA1VSsiA3fio3jCgImxO",
	"zOtoZq9j92KSlC/AXOrmIhaKFui0P00a+lE6XAKVegZUb9XX8jjNhIcOBfJbDJpGpcnYLAHWZr+ZRiUI",
	"h1vzwMO3t23jHImnB7lT2TVBfiCovnsdJD095BHhEJ7IZ+fv+7An4b3g/NNi6kSQ7feVweFCiluzmwZA",
	"4VM3YoKX6J6qFF3A0OuoYSoamBKjYQHCQXZJP0l5R8zbYk1Hxhi4CNt9YvCS5A5gvhj2gGaAloujn9ua",
	"EJ1V4SUvNh6pswIF6uAgakmHyoadjS/2AzbNxkDyWlj1gDWxFh/9JVX+6OfjiKMfKC1+mlQy2/LnnUfe",
	"d1R3s+P5a7rN2sdWnzMDIrjp4bPo+dR5Pl/eaLxX7rvxyIU4pPZOcJSicyhgYXFiG3s6q/Mz1btp4Hg5",
	"nyPTm6Qc+SJlZCSZuDnAPMQeEmI15mTwCKlTEIGNlnUcmPwk4sPOF/sAyV1+KerHxrsr+hvSwYLWG99I",
	"yaI0tz7rsVplnqW49Ba1yNNyccZhCONjYjjpDS0MJ3WBp/UgnVxt+PZpZWZzvh0P+t5EAw+aWyNKJ3ut",
	"0sozh6wvFrz9MtKvgr3WMBPriY2MTj6tZuuZORPJeAWM004dXps5754iM7FGnyK84ayD+97Q9UPmAYvc",
	"QNZMIZVjvz6x0YK3HyDbBfkUNSskPadXC2TXJ8keBkyPON1HdvejFHpHAqmlwKzTgDuNzk49S1Pa6koi",
	"9XU7DtlhQ5haitX0Hc7kTvZgtKs8bea6+75Od9ifHM2f1Y+S5K+rlLtLXkbbubS5FvdJy9gmhwYQW7D6",
	"qi3EJtHadFxq4jXCWoolGUbfNXZ10aagANQETBpy9eQ6ZZa+unqjAGWGC98t0nPi7lG+eRB5w0lYMKWh",
	"Ni54J5ePb/tBdaJ5bIl5/+p0Kedmfa+FCIKGNcdix8YyP/oK0HV9zqTSE7TMJJdgGn2rUJP2rWmaFoSb",
	"/nZMWVPP3nIwQnQNm0nOiipNyg6kH54biH4KN5eqZnhRMm69jWaYCj/poLuHbRLhsY7dWxH0wiLoBf0Y",
	"+Bl2sExTA5M0lNec/i9yxFq8cBtnSdByipi6G9qL0i28Noql7zLaSIiO3C6m22w+nXOZ+7F3emP5iP4+",
	"IcKOlFxLlBExHUAoFgvIfaY3FxRqs165fHqF4Is6l6D5fUv6wCmxWfwwCd+W/H3OPR36nNMb5USwKkYS",
	"+vgxg5DX0XWYexAnWQC3mVtG+9cbKZKIix3jsUWkGf24vL3jNp90Hb5suQvXPr12D8Nm4/YUQHP3rFLg",
	"17f90Ha3y6Fu3Od03EgRu/2A4YBIcUyrSIDpEE0P56ZlyfJ1y/BnR50eQBIDxb1uJvgWzpAtucF24Kfp",
	"WLyjVs89cztie2fsOMFn/ol5ZFp/ZueRa84GzVy2gbySaE1qeAt38+mHh+bAtf/wy4UWki7AWQQnFqQ7",
	"DYHL2QcNUUp6RTSzDtI5m88htoSpQ6w4DeA69o58AGH3kGDXXBbellvps0tkO2irXsFuhKbpKUEpfT4X",
	"l117pH94RLq1cNlEG3eAUTGZUOAH2Ex+oUVlXkJMqto31RkIm9f6HjRxs/oBNjjyTpdPA9iOXUFV3GtA",
	"Ck1ZV8InFWUJv6ca1RfwDdzYwj126iy9S0faGldKo/9o1DdUo55Ecykf7tjULjIG0iF7dZH2OjFnC5rb",
	"0ib0XVvE8t2yT/QEiadi6L1xyCUXMm3s9C4DWnjCx8WO3o9Hd/P3SN2TbsQdO/EqXM3JXUBvTGv/bzh9",
	"7bkhtCyluKHFxPnJ9AkdUtw4oQObe7eaj/y+Sp+Ky2/OXrxy4L8fj7ICqJwEVUfvqrBd+ZdZlS3Bsf0a",
	"sunYnW7XqsKizQ8ps2NPmltMvd7SpnVq3dR+U9FBdZ4187Sn+E6+6Vy87BK3uHpBGTy9aou0dfRqOnfR",
	"G8oKb/j10A7VstvlDquulOQT8QB3dhKLvP/uPFZvnMDV1Zsbj9nanmIdpUJK/IQvnTrQ07nDa9Jntab1",
	"HRwS1/kSM5mm313c5TlFxugczujR5cBvhWxcVC6qMemw9uEERPOYsHhMG+UvnRW+IxZOiRUhf1v8ZnjD",
	"w4fxwX/4cEx+K9yHCED8feZ+x3fUw4dJw3BS1WdYFmryOF3BgxAX0bsRH1cNweF2mLhwdrMKMrLoJ8NA",
	"odbzzKP71mHvVjKHz9z9kkMB5qfpEFVFvOkW3TEwQ07QRV9UYnB+XtlynooI3o7BxyhZQ1p49bgKHtbO",
	"3j1CvFqh3XmiCpalnX74TBmWxK1Lr2lMsPFgG7KZo2I9fuW8YtHoppk6yOTZWkg0axLhKpkJuMbvTDgW",
	"UHH2ewVRWV+8iVuXs38K4agdATutX3QDt6sGjw4p+Ht3E6HXqm1TGG01uT4PZkCPiFSdqT3jHeIZO8x/",
	"S6yCoyh/fWJg29K5Du+krK3vvO1FoJ0Z2LNPZ3HtfyC5cph2M58P2WmmJnMp/oC07IBGwkTqDm/dZqiA",
	"/wN4yke1zciC50BdsLqefReBDNct9JHKnXUJftGhat4hV3iaT+y30XsqDaL97lcbqHR6cbcJfQ/V2PGk",
	"GUjTw8zwwEZu4VjLx7u7UW5PqM1r0Yg8S5/zOFD0xI5fn3MHcye4tqC3M5oqdGTeiwamaPsbjnlaEN/Z",
	"b5AKqRns7CSKZQhtmU32V4KsrUfdVMkHvv3stINfffUjDykuft6Nra9KoURimIrfUo5+hNjPckDXW4H1",
	"wzC9boXEBJ8q7UOYQ8ZWSWX41dWbPOt6fuVswWxJ8UoBoXPt8jy6gWxReUtFrpp3yEXiUHM+J6fj+sz6",
	"3cjZDVNsVgC2eGRbzKjCCzr4RIQuZnnA9VJh88cDmi8rnkvI9VJZxCpBwvscRc/gCTsDfQvAySm2e/Ql",
	"uY8Ow4rdwIP0BeOEtdGzR1+Ot1XORoxjkfhtTD5HLu8DGdKUjV7VdgzDVt2o6ciEuQT4A/rvky3ny3Yd",
	"crqwpbuCdp+uFeXUICQF02oHTLYv7i+6crTwwq11BpSWYkOYTs8PmhqO1RNNbhiiBYNkYrVieuU8RZVY",
	"GQqry5DbSf1wWF/Pl0HzcPmP6IJdJt74n+C5RVc9EY7oVf8T2ttjtI4JtRlbC1bHX/gKteTcZ6bGunCh",
	"HJzFjZnLLB3lVQzHmJNSMq5Ra1Tp+eQL83yXNDMMcdoH7mT2+ZNEfbVmCSK+H+AfHe8SFMibNOplD9l7",
	"Kcf1Jfe54JOV4Sj5gzqlQ3Qqe33F0/69fW7HPUPfWbo24056CbBqECCNuPmdSJFvGfCOxBnWsxeF7r2y",
	"j06rlUwTDK3MDv38+oWTRFZCpipd1AzASSUStGRwg/Gl6U0yY95xL2QxaBfuAv2n9W7zYmkkuvnTnXws",
	"RFblxDstpFUykv4vP9b58dG4beN2W9pLIRN6Wqdx/MhuqfvpC9s2dOsOiN96MDcYbThKFys94R42niP0",
	"+RT+Xm2Q7J43VKWPfiPSvONR1n/4EIF++HDsROXfHjc/W/b+8OFwl9m0vtD8mkDNYXdNO3ul6Zva6q9E",
	"Qnvnq3gGvzGXqiShYU3eZeZKnbkxxqRZKvHjyx3HiVfc2w05fYA8avBzGzefmL/iZtYRMP38oVk9Nkk+",
	"efgexVBQ8pVYDyWi1rXl6elPgKIelAzUCuJKOtVxk54SO918IrI1o86gEOalGhfAGuy18hfaBYOa8Za9",
	"qFiR/1JboVs3k6Q8Wyadymem46/2GRA1iDQY2ZJyDkWyt30t/+pf1Yl3/z9Fz7ArxtOf2oWYLewtSGuw",
	"mkD4Kf34BldMF2aCGEXNhFwhxUmxEDnBeerKJTVr7FY0T1WSTcT447CrSjuvZEye4AqKzFmBbrRpezi2",
	"nEiqe7gqlv33Ja7MOFiFX1m1hB0dJKFshde2oquyADyENyDpArsKDq3umLENR47KkhBVmk/YEpO/CKIr",
	"yYmYz6NlANdMQrEZk5IqZQc5NcuCNc49evbo9PR0mJER8TVg7RavfuEv68U9OsEm9our/GULJuwF/iHQ",
	"v6+pbp/N7xKXK7/6ewVKp1gsfrAB2WghNve6Lb0aygRPyXeYn8wQeqNEACpFfYblZk7QqiwEzceYFPry",
	"m7MXxM5q+0hA1GHp1wVqAJtHJGnkGZ4j1edf68ldNXyc7alzzKqVnoSirKlMiqZFXUuWtbyfUDcYY2dK",
	"nlu1bHDssZMQTC0uV5BHNWCtGgCJw/xHa5otUd85HW1VKfdUAxpewthzwNpcFMW9hoJZyMHNMlwVY1vE",
	"eEyEXoK8ZQow7wTcQDNhY8h26hTyPoFjc7Wy4twSznQP6TWUx9p3FzxwVvT1/hVJyFr7cGfbX53JA4uc",
	"71vs+QJ7peN2WpWjW34PtmTG2hfdmJIfnbEjo1xwlmGxiZQIjqkYh5lVB9TlSNs71cid5cQxTNarDgHq",
	"Dou9Faw9y3SI6zo1RF/NflvCsX9qWLsigAvQyvFAyMe+fLwz0DGuwBVAM/QVc1QhE65fybCY4EJyRJf0",
	"8QizqfXoWr81335yunnMGXPNOOrcHFLdS9Aa2ArF0M7OCdNkIUC51TbjwtQb02d6ueYIwtvpC7Fg2QVb",
	"4BjWFdEgxXoBd4c68z7BzgfXtP3atHW1C8LPDZc6O6lf99skC1Fh/1M113vRn/L98o40EXLD+PFoW4hx",
	"q6s/3suGDOEGPf+gxPu8QzahfH1zlG/Mk9XSG7YgNnI3mTaY8QQYLxj3Bt90HqwseZfgxuBp7umnMkm1",
	"fXQM4niXQIuecBgMqrceA3cdql2JwaAE1+jn6N/GuvJ+D1sJDerXBeUb4g+Foe5IKPmaFsEZPlFHH6Uz",
	"J4xZZ+FWZf0UWzFsfeJDcxvo2hkIGrpjNZR976m+bKOzKl+AntA8T+Wd+wq/EvzqAwphDVkVioCFONNm",
	"uvYutbmJMsFVtdoyl29wx+lypqhSsJoVCdfb5+Ej5GGHMRHVbIP/pipg9e+Mc3rfO/rbe7jn+9Uo6Eaz",
	"p6RnQ9MTxRaT4ZjAO+Xu6KinPozQ6/5HpXQf+P2niOtucbl4j1L87RtzccRpujs+/vZqCVm00Z9e4Hef",
	"Dyxkcm1yJbzKOnXe0CMDNy+xZS3gfcMk4De06Mm4EFtt7P1qLRl9eRey3rQiVLvsdZqSmicMUWH05/+y",
	"Htgty1DXvNnnY21drD+k8cThYyvS+y2NPzTsitbrrWYovfbEw0x+NRHsa/NzpRi6+lJaFCIbzBncMGem",
	"U3+qXrFaucz3Ca+8m5XI47MQe3MBpBmbdVhOhFbgwzb5DZ9WyS/yNj1aQz8SiGZo1jJEo1vC2AZmevA8",
	"MHbqeKJIZeswS75lBRaH+s+Llz+N+jcy2oHulrrU2UkVdt/GhEi1NnksRAMfW3iA4EVa/616VOqYGyp9",
	"Glx14uSHb62CcAhINk/SPq1fDB28QwALYatCpepmdLPTjOrt8MiPqKHeXstRYupIUUW72lLi7WOVnnUT",
	"EgqRDipM2pCRhhR3StURci8Fr4G1F43LR2eLK3XqMnUY6PMhwmEHH+/Ho/N8L/EpVYtqZEdJMdgXbLHU",
	"XxUiu/4eaA7S1hNJPSdtNZEVmGeoWrIS3z+lUKyuB1yYwVwi7yUONx0amnO5BJcVxicJ6IzlHahvINNY",
	"H7p2A5UAw/0cyvQSDQTeoIhNPoEriATIodTLrcKSde4u9bIuGwou8owpMgNnurgBPiZsCtN2sFpeJ4Ui",
	"BdC5V8JKIfSAurohbAnRGAOdoq9OjebtYmAn51uU0tCW0p0OL8JyFmICbKDlLVV15qhWGoXB4drzOWSY",
	"8H5r+r3/WgKP8rGNveoOYZlH2fhYCBfEkg1H1WjXsG5LhLcV1Kgm1YeEtC8hxjVs7inSoKFkReAQYXtI",
	"BnhEjrXj+qICfaYN5xjJVKAnRJD3g3cJ+OsaS4cUAYiyUx4Ihqdxcz3VGSsPg8ZLNAeAYbpO71S0v06H",
	"h4JpX3a/bnX1/pfycyxmr5xTKQ3p5mN9EjnvlmO+denqMdFisBb6xPWg/G8+QaudpWDXrkINIszaZm+p",
	"zH2Lo6TJs/cmSwM9DzOzOjCq6+Wzr1+OjVDMCmEEoElfYGgzUim48N5T1te6TlqGUM9BSsiDTbAQCiZa",
	"+DCrPZJ/uvDJLdizXuYH4a3l0b9HyLBdUW8Nhdd1IQksB0mxZgJ1zucxVoiEFTXQy6i4Q1oNumuHvrbf",
	"fU4RX95vu3q1D+/hXOyukO1D75jqYD4+XXPihIO9uVcjEckBmlnGOciJN+K2SzvwZppMzKucV5kVVeKz",
	"GbTXg9OObeFmSaVm1l1l6wkVZeW4hs2JVfv4quN+x2OgrQxpQY8SSreI4qi6apWCe3EU8D5t+s5SiGLS",
	"Yxk879ajaB+Ga5ZdAyZmDZEpRgq+1zw2ZhJyHw1SwWfkdrnx1RbKEjjkD6aEnHEbHejdR5oVSFuT83t6",
	"2/xrnDWvbIUZp4GeXvF0mBVWepF35H5+mC08r483KTD88o7z20EOmF2veZ+P3C2WhGnWCZ4OVW90/Tta",
	"IlREfhaKlAB1YQ3BXyNLSLyjCGZnidIIoX8AJc6ATFQhUl74h2SQMUOlMRVPhgBp4AOeqzUUbvAkApyT",
	"3Y6srO6zzzsq5kRC7ZtxaAJWl9PUMnHVpxppzxxmaXLGuZAQz4h+pjZRc4hswzzH+J8Z05LKzSFpUpuo",
	"SqmherG801syOErWC6mdJbs4LApxO0G2NgnVlVLqANNONa9tX6e07meO+gwit0uqnIi4IUuak0xICVnc",
	"Ix3ibaFaCQmTQqAXZsqxY67NI2GFcZ2cFGJBRJmJHGwhtDQF9c1VcU5R9oLIlS2JAks7mDLA9onoeOCU",
	"5va15tkJyms7C234zb80fWz6ijr9nV30xLoI9MQXgHLp7hyGbOMuvEg4NiNTWymbFpHnbI10AzJ15OdE",
	"ywrGxLVoV+F3B59KICumlAUl0NItKwrMHsHWkUND8AdKo7ZHdj5HP+gbhg5vzUwiVqQuze0Y0q/EPOAi",
	"zshG9FKKarGM6gMEOP3TXVbuYR+P8rOq0CcRQ0TNFE/ISijtnsV2pHrJtQvo/UxwLUVRNBV5Vs5fOKPv",
	"j3R9lmX6hRDXM5pdP8BHOBc6rDQf+5QKbd/deibZysE47KWg13yC5KF2p1m37dCr1dHzYN7Z4n4dw8Mu",
	"TX4E5tvdzHW3XeOsu7D2upp8Nv0WOuOEarFiWfq4/bW8X3t9VlPcK5lp0VYhtllosBnygfgeC+5MyD27",
	"aAZOk2VUz4jjEc6tAzmR+S+K8e1xyRwcD+q5Q7t8xwlYk6xXDGwBgJDaRAi6krZ0cSykBYYjFjZxCjql",
	"tAEdeOGg79/dYDMjHB0oDXcCquONHAC8bzUYY5sR03o2z8Taf39Qp8w8CPj326m8wTz6nCovatKS1q3S",
	"J7Lq4QjpAgRbPRAvMQnGbKgfYihFP/DyjwDo90xswDDIP3FfMOaUFZBPUlWKz4MObBw9112MZTS6r+do",
	"OXlGK18J2IxdSXCJlaz0L5vmxJIaUhKheVcjznNYg43R+gOksHV8x5E5Cwpb5relURDlpIAbaDhsumxP",
	"FUqh7AZ8XxU6kxygRItvW9GW8kSMqwS2tC9u7ZPIl20IdpPqGItYu1Nkh64lqRla84k9JmroUTIQ3bC8",
	"og38qX1FjqYu0RzlBKo6z4eJf2IOneZnO8JrP8CZ758SZTwm3g7jQ3uzoDTqtjGgnZ7Jleo79TztmByn",
	"MguGIpwtD3ZtS+I131AlveX9Ws0uydcvsYH7xASPEPvNGjKUatxTCHL3GOqxnLgcSEjtHCC3DwbTJaHN",
	"XwInXEQ1j2+pCq+YOqur/8FOjI0Ydw/tA2z0tf/w3XeW4GBEtZItpkuUBrK+m47/k5zErQexd7wUjShw",
	"obxbVGOeut2zAxuIqsgJN/tpZH+sEexuMcfFx2RW+YGKQtzaIsbxE/U5eHuupT5vYnJiOQvXsveTHruE",
	"w20tCIsiRFZ0Q4TEf8yD9PeKFmy+QT5jwffdiFpSQ0LOgGy9KJzftZl4u3g19oB5RYzwU9l1s6FjRsNt",
	"zCgR0OYi92XbBFnRa4i3AR1ELP/MtGGcqpqhUsNc2a3t7GLBLd6nZ1rRPFYCYKLZTYM7+ITnpvf/V4et",
	"xlP5/I9lQTNfstoVn2vyGaxq74lLL2G1Pcy5y9c8CYRK+TXRSp8mIz9Am7on60rF/PQVx2qA3SkB3qkL",
	"dqdlDFQKt2ocbQkQH7SUY+/CcWI4O0uKS/3uWlxc+fjj7E4yQ3TfMoaA/yfalYZ7RSeyLV1BPV6PLZb+",
	"EXahkYgnAatVg8/EeiJhrnY50lg9+Eysa4BV0N0ynkmgyvodnb90z9Y6ATLj5hltvXaDWTWMksOc8ZrV",
	"Ml5WOvEKwjzIfBMhLLYmIFp7bHN9MoYRRW9o8fIGpGR538aZ02NLA8dFerwFxfVNKEDCjdwdgKn6BYjx",
	"1LV+Pm5mrn9bYND6zipNeU5lHjdnnGQgjdRAbulGHW6qClaHXcYqGslCzWwhkdkKSdsCUmyctfmOhqQA",
	"ID2iRWmAJQidtBNWIKsY0qLH8NOF4S9hCVrR9aQQC4z67TkQLs81mg7tA1JwVKJb6W7Yuv08iv0B26fB",
	"UiSOEWmBsw6ZYvu5f4lbiY/QnznTW0++1XC2w7Ctp7M9mB6pfFGHZ1hi6Z7HVOS8S8wUR897UdWnKfG0",
	"B9EmJl2iO1r1nl1E/wqXdiFWoQ8vVtl04UjF51u9wgT1DWpLAAaoOq6AZs5DrKuI6ygqLFLGLrvBnno6",
	"q93391IPeKhIUe6sN6cNDjpmnH0qfG7PZzApRTnJhvi22mpFuTMyOEibMPbQR2RC6Fl38LtRoX5XIyda",
	"o5DXvkVOewuJ7bKVldk2lUGfkqmHozcNGGKOvAyPsFWtYaxVUMWM/ePcG7ubSrTAJAglErJKopL5lm52",
	"F37syT5/8f3Z00ePf3389HNiGpCcLUDVNQ1ahRNr10TG21qjj+uM2FmeTm+CzxZiEeetlz7sLWyKO2uW",
	"26o6GXGnbOQ+2unEBZAKzu2WyDtor3CcOiziz7VdqUUefcdSKPjweyZFUaRrygS5KmF+Se1WZIAxL5AS",
	"pGJKG0bYtJ8yXTtlqyUqFzFr+I3NDSV4Bl777KiA6R5frtRC+nx6kZ9hLgZncyKwLgvHq6ydaNu63DvN",
	"6vdQaER3mxmQUpROtGdzkoIIY7ZkBUGv7tSmqE+P3HQDs7UOuylCdM7vadI74+4lLOZkO7dvluLWaU5v",
	"NjEhXvhDeQBp9lk3+vOMHMJJasPAn4Z/JBKnHI1rhOV+CF6RfB9siQo/63hNhKQhg0DrJshIkAcC0BMP",
	"3QhajYLsotzk0toY0Brhzc9t8ePH2iy9MzIFIfEddoAXxzLX7UIwhQPnEyf2/jEgJVrK2z5KaCx/V3i0",
	"Z73hIom2yClNtAZl2ZLoioVRQLz6OsSZ97xKOuHoUghNzMu0KBJh7FaPg2cqJhzzJJA3tPj4XONbJpU+",
	"Q3xA/ro/cCsOW46RbFGpjp6Q8wUdBFYUovxRoOKvMLb+v8DsbPJ2dLM4w3/nDkSVEC2st/c8WMCBk1sc",
	"0zp2PfqczFy5n1JCxlTboeDWizQh3hYkmzv/WljrduzvncsE/SL0HY7D3PsDkZ8iI1vwHHAw10f9EzOn",
	"Hg6QPC0pUu0QSgJ/KV4XF1Xfce3csTTMYamcosSNe6Zy6paLH7o8XAdeXpWC7joH3/oN3CYu/HptQ3OV",
	"Da4wc3X1Rs+GJBRLV4Mx3THH2VHKwty9KMxHSXBmUenGcJAkCasWuXdlr2n5S0Z5Gpq7aMT9ngLyS4t+",
	"Mxo+CuYVt+OFAqgYK+7ZupiPgxeD4KbbM3LFHxK1pP5t4f58/PTz0XgEvFqZxdffR+OR+/o29VLL18m4",
	"0jqRTsdH1FUTuKdISTdDgtl3ps5J4rfOFPTxRRql2Sz9pvve7Bk+XF0AwjlHVo/sxd6gLn/O3wmAthJD",
	"67CGE2NJsk4PFLZiV6agX/rS4tvU7z3VPlrct2LFTie5RiGW9+PRwiYpw+okv7padR932z0EPfkC3dLv",
	"kgbMIiax1sbk0VRRUrcBBVlct0SFDIy8zirJ9ObC4N+r3dmv16lkUN+F9Ewu51ewwDvZV4tr4N7HrE7m",
	"VCkvXX8naIHSp3UM4EbmFMWUfGMrhLhr8R/3Zv8On33xJD/97NG/z744fXqawZOnX56e0i+f0EdffvYI",
	"Hn/x9MkpPJp//uXscf74yePZk8dPPn/6ZfbZk0ezJ59/+e/3DKUbkC2gvvLPs9H/mpwVCzE5e3U+uTTA",
	"1jihJfsBzN6ghm2OCQoRqRlesbCirBg98z/9//6inGZiVQ/vfx25epCjpdalenZycnt7O427nCwwB8pE",
	"iypbnvh5MJdl473y6jzEBVnfP9zR2uaEmxry+5lvr7+5uCRnr86nNcGMno1Op6fTR5hPsQROSzZ6NvoM",
	"f8LTs8R9P8Es2ifKFeM5qUNHk9b+1xgm45/0cgE5uR+CAP8t+HuoBz6WcO6yUP5TWWIMqzjPkbhc3fQR",
	"1n1FB1AE6/Hpqd8L966JxMsTjDh79m5k+UcqHW4HqZc1wEnI6qrT3UX/zK+5uOUEU/7aA1StVlRu7Aoa",
	"2IgGx22iC4WmOcluMDOj6d3GeVm6Ekh9KMeqms1T7jsjgYT6OOaE2bI5rpCRSqG8W37pjtjfmgK6M1li",
	"d7DRKwOzT3MW0ia7m9DhDD1NLMLCGbHKyg6ix6OySqDzGwzmU9twNo5K9lhoRJEHjHcw+qr6fwSjhnQX",
	"If2v+WsJtEDRyPyxMoSa+U8SaL5x/1e3dLEAOXXrND/dPD7xOoeTdy6f1Ptt305iL9STd42kXPmOnt6P",
	"cleTk3cuT9WOAWOzyInzb486DAR0W7OTGdbbHNoU4tX1LwVpXp28Q91c7+8nTk5Pf0T1qb1hT/zjo6el",
	"zSGU/thA4Tu9NgvZPpxpE42XUZ0tq/LkHf4HyTZakc3ff6LX/ATdzU7eNRDhPncQ0fy97h63wLTTHjgx",
	"nytk2ts+n7yz/0YTwboEyVbAbclx96vNZnuC5a033Z83PEv+2F1HI2nnjsscs8Qq74PZzPWZvD7aCUTV",
	"XZndsCRc7bSlXQG7K0ltW9n78ejJEblysx5AApivaE58nhWc+9HHm/uc20gSI1paERghePLxIGhsH/kB",
	"NuQnocm3Xof/9GPuxDk3L0daeIHuQNFv2PFpX6NG9g7N+MIKKsLm3mketbM87xC9fUOC0l8JvF37MLZS",
	"i9L5dtRIq5/QjJsljIeJzd0MwDYFpBckuMhhFD9utazg/R15QssrlEp9nrA2oUUVg8uc1aYBajIxbdtn",
	"zo6cyLS+g4TPn/tJ65isv3nK3zwl8JSnp599vOkvQN6wDMglrEohqWTFhvzMQ7DfwTzuLM+TOcCbR38n",
	"jxuP1pNM5LAAPnEMbDIT+cbV3Rs1JrgGqy3rCDInXrvUeDH0cE+vt0pJK3UQyejZm5QzlQupLqtZwTKz",
	"4KnXLZVULyPVT0iH3OR+45iTBUXlm7PJ/5xOvnz77ukX75Mx1N1wqjoOcevXRC0ZkrOiCllp9K1wWR+6",
	"l1SkwdGCqN8lXmZ4uJnekFvGc3H7IGDg9wrw7nAo8NOMxqmbZkvRi26xxdqZwYDcAbQPAvSC2LoFg6xg",
	"/Q4GW751698etoaCfqolvP3QmreQ4PQ/L17+FMV9W/2KdZ7EqGN7YDHISwoMXrql6D1vy09/bTVfxQbz",
	"F2iqK9UobDv9+/b9+8a7+433XUjVb+vWaiw52WWa0Q04HSTmJ2+0d40/nbZmZENXUqnyze+EkgVWJ+9e",
	"y7MNOX/eebPbbu2L8KsNNm3dhYlLrg3iVj7VZgc97GWbIGcWshA6BPDYRf0tWv8tWt/puT748Ax5sSf1",
	"ad/hwLTzCh378v+NIEksd4EuAh1QhmjdPunxPcrGdzV6KQ2eLcsBOYk+2DxAbTT/zSL+ZhF3YxHfQeIw",
	"4ql1TCNBdPtp+IYyDExalzfc0b3U4ZtXBZVR8oRdivszHDH9AP4gXONjqymTuLJaSoyxYja4ILGBx9Vc",
	"/s3y/mZ5fx2Wd7ab0TQFkzvr+q5hs6Jl0PCpZaVzcRv5BSAsNjCoa9m0D//23ye3lOnJXEhXNY7ONchu",
	"Zw20QGQzTOcc/1qX++58wRrm0Y9x2s/krye0aaptugsY1tvXseNLkPrqzOU9jXy+Gf+59lSMPf+Q7Qef",
	"vzdvDctWIG/8jVA7sj07OcH0ZUuh9AlqvJpObvHHt4E83oV7xJHJe6QLIdmCcVpMnEfIpHZWezw9Hb3/",
	"vwEAAP//CeiNZR0iAQA=",
}

// GetSwagger returns the content of the embedded swagger specification file
// or error if failed to decode
func decodeSpec() ([]byte, error) {
	zipped, err := base64.StdEncoding.DecodeString(strings.Join(swaggerSpec, ""))
	if err != nil {
		return nil, fmt.Errorf("error base64 decoding spec: %w", err)
	}
	zr, err := gzip.NewReader(bytes.NewReader(zipped))
	if err != nil {
		return nil, fmt.Errorf("error decompressing spec: %w", err)
	}
	var buf bytes.Buffer
	_, err = buf.ReadFrom(zr)
	if err != nil {
		return nil, fmt.Errorf("error decompressing spec: %w", err)
	}

	return buf.Bytes(), nil
}

var rawSpec = decodeSpecCached()

// a naive cached of a decoded swagger spec
func decodeSpecCached() func() ([]byte, error) {
	data, err := decodeSpec()
	return func() ([]byte, error) {
		return data, err
	}
}

// Constructs a synthetic filesystem for resolving external references when loading openapi specifications.
func PathToRawSpec(pathToFile string) map[string]func() ([]byte, error) {
	res := make(map[string]func() ([]byte, error))
	if len(pathToFile) > 0 {
		res[pathToFile] = rawSpec
	}

	return res
}

// GetSwagger returns the Swagger specification corresponding to the generated code
// in this file. The external references of Swagger specification are resolved.
// The logic of resolving external references is tightly connected to "import-mapping" feature.
// Externally referenced files must be embedded in the corresponding golang packages.
// Urls can be supported but this task was out of the scope.
func GetSwagger() (swagger *openapi3.T, err error) {
	resolvePath := PathToRawSpec("")

	loader := openapi3.NewLoader()
	loader.IsExternalRefsAllowed = true
	loader.ReadFromURIFunc = func(loader *openapi3.Loader, url *url.URL) ([]byte, error) {
		pathToFile := url.String()
		pathToFile = path.Clean(pathToFile)
		getSpec, ok := resolvePath[pathToFile]
		if !ok {
			err1 := fmt.Errorf("path not found: %s", pathToFile)
			return nil, err1
		}
		return getSpec()
	}
	var specData []byte
	specData, err = rawSpec()
	if err != nil {
		return
	}
	swagger, err = loader.LoadFromData(specData)
	if err != nil {
		return
	}
	return
}
