// Copyright (C) 2019-2025 Algorand, Inc.
// This file is part of go-algorand
//
// go-algorand is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as
// published by the Free Software Foundation, either version 3 of the
// License, or (at your option) any later version.
//
// go-algorand is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with go-algorand.  If not, see <https://www.gnu.org/licenses/>.

package agreement

import "fmt"

type voteAggregatorContract struct {
}

func (c voteAggregatorContract) pre(p player, in event) (pre []error) {
	if in.t() == voteAccepted {
		if in.(voteAcceptedEvent).Vote.R.Step == propose {
			pre = append(pre, fmt.Errorf("incoming event has step propose"))
		}
	}

	return
}

func (c voteAggregatorContract) post(p player, in, out event) (errs []error) {
	// prop 1: voteFiltered directly preceded by votePresent or voteVerified
	if out.t() == voteFiltered {
		if in.t() != votePresent && in.t() != voteVerified {
			errs = append(errs, fmt.Errorf("voteFiltered event has no corresponding request"))
		}
	}
	// prop 2: voteMalformed directly preceded by voteVerified
	// (for intuition, we can think of voteVerified as coming straight from the verifier;
	//  hence voteMalformed is generated by the vote machine, not the player, who is just
	//  forwarding the message)
	if out.t() == voteMalformed {
		if in.t() != voteVerified {
			errs = append(errs, fmt.Errorf("voteMalformed event has no corresponding voteVerified request"))
		}
	}
	// prop 3: voteThresholdEvents directly preceded by voteVerified or bundleVerified
	if out.t() == softThreshold || out.t() == certThreshold || out.t() == nextThreshold {
		if in.t() != voteVerified && in.t() != bundleVerified {
			errs = append(errs, fmt.Errorf("threshold event has no corresponding voteVerified/bundleVerified request"))
		}
	}
	// Relay rule contracts should go here...

	return errs
}
