# Differential test for txn propagation test over Gossip and TxSync

## Overview

The test checks behavior of old (prev release) and new (release candidate) binaries in the following scenarios:
1. Pre upgraded network (old and new binaries)
2. Upgrade proposed but not applied (old and new binaries)
3. Upgraded network (new binaries)
4. Upgrade and upgrade+1 round (new binaries)

Checks:
* Gossip and TxSync work as expected
* All basic txn (txn types/fields valid in prev release) valid for both old and new binaries
* New txn (txn types/fields valid only in release candidate) are rejected by old binary and before the upgrade
* Submitting transactions during upgrade works as expected
  - submit at upgrade round
  - txn land into next block and they are valid at upgrade+1 round

## How it works

The script creates a network and then rebuilds binaries to generate all txn needed in tests:
* Basic transactions
* New transactions

The generation happens on the same network so that the network is upgraded during generation phase. At the end there are basic txn generated by new and old binaries, and new txns generated by new binary that are valid on the same network.

Then the script rebuild binaries with either Gossip or TxSync enabled and runs pre-generated transactions. At each iteration it compares 

### Building binaries and Patches

The script requires a path to `go-algorand` repo to checkout required version, patch and rebuild.
Patches per version are stored under `patch` directory in according to **git tag** names.

#### Patches for old version

1. Disable txn broadcast in `node-no-tx-broadcast.diff` file
2. Logging a fact txn landed into transaction pool in `txpool-remember.diff` file

#### Patches for new version

1. Same as for before for broadcast disabling and tnx logging
2. Optional `consensus-version-next-proto.diff` patch to set `ConsensusCurrentVersion` to **Future**
3. Upgrade path `upgrade-path-to-next-proto.diff` to a new protocol version
4. Upgrade path and fast upgrade `fast-upgrade-to-next-proto.diff` to a new protocol version

### Transaction generation

There are two related functions: `generate_transactions` and `check_new_transactions`. Both have a trigger for new txn generation.
```bash
    if version_gt "$alogd_version" "$BASE_VERSION" ; then
        if [ "$proto" == "$NEXT_PROTO" ]; then
        # ...
        fi
    fi
```

The first one `generate_transactions` only _generates_ and saves txn, but the second `check_new_transactions` sends transactions to the network. This is useful for the scenario when subsequent transaction depends on previous: **asset create** txn can be run at upgrade round but **asset config** requires the asset to exist, so that it can only be executed at next round.
If there is no such dependencies then `check_new_transactions` can be simply omitted.

## How to run

1. Define versions and ensure git tags exist:
    ```bash
    BASE_VERSION="2.0.6"
    RELEASE_V2="v${BASE_VERSION}-stable"

    CURRENT_VERSION="2.0.574"
    CURRENT="rel/nightly-${CURRENT_VERSION}"

    # git revision of the previous release
    STABLE=$RELEASE_V2
    # git revision of the current (new) release
    TESTING=$CURRENT
    ```
    Base is a prev release, current is a new version.
2. Define protocols:
    ```bash
    V23="https://github.com/algorandfoundation/specs/tree/e5f565421d720c6f75cdd186f7098495caf9101f"
    VFU="future"

    BASE_PROTO=$V23
    NEXT_PROTO=$VFU
    ```
3. Create patches. See previous section and existing patches for reference.
4. Set `init_generate_network_and_txn` parameter and run the script to generate network and transactions.
5. Disable `init_generate_network_and_txn` and revisit txn counters:
    ```bash
    # payset, keyreg, lsig, group, asset
    TXN_BASE_COUNT=5
    # base + app call, rekey, rekeyed
    TXN_ALL_COUNT=8
    ```
6. Use test switches for tests selection
    ```bash
    test_new_pre_upgrade=""
    test_old_pre_upgrade=""
    test_new_upgrade_proposed=""
    test_new_upgrade_applied=""
    test_at_upgrade_round=""
    ```

The script prints out errors if any.
