package committee

// Code generated by github.com/algorand/msgp DO NOT EDIT.

import (
	"github.com/algorand/msgp/msgp"

	"github.com/algorand/go-algorand/crypto"
	"github.com/algorand/go-algorand/data/basics"
)

// The following msgp objects are implemented in this file:
// Credential
//      |-----> (*) MarshalMsg
//      |-----> (*) CanMarshalMsg
//      |-----> (*) UnmarshalMsg
//      |-----> (*) UnmarshalMsgWithState
//      |-----> (*) CanUnmarshalMsg
//      |-----> (*) Msgsize
//      |-----> (*) MsgIsZero
//      |-----> CredentialMaxSize()
//
// Seed
//   |-----> (*) MarshalMsg
//   |-----> (*) CanMarshalMsg
//   |-----> (*) UnmarshalMsg
//   |-----> (*) UnmarshalMsgWithState
//   |-----> (*) CanUnmarshalMsg
//   |-----> (*) Msgsize
//   |-----> (*) MsgIsZero
//   |-----> SeedMaxSize()
//
// UnauthenticatedCredential
//             |-----> (*) MarshalMsg
//             |-----> (*) CanMarshalMsg
//             |-----> (*) UnmarshalMsg
//             |-----> (*) UnmarshalMsgWithState
//             |-----> (*) CanUnmarshalMsg
//             |-----> (*) Msgsize
//             |-----> (*) MsgIsZero
//             |-----> UnauthenticatedCredentialMaxSize()
//
// hashableCredential
//          |-----> (*) MarshalMsg
//          |-----> (*) CanMarshalMsg
//          |-----> (*) UnmarshalMsg
//          |-----> (*) UnmarshalMsgWithState
//          |-----> (*) CanUnmarshalMsg
//          |-----> (*) Msgsize
//          |-----> (*) MsgIsZero
//          |-----> HashableCredentialMaxSize()
//

// MarshalMsg implements msgp.Marshaler
func (z *Credential) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0001Len := uint32(5)
	var zb0001Mask uint8 /* 7 bits */
	if (*z).DomainSeparationEnabled == false {
		zb0001Len--
		zb0001Mask |= 0x4
	}
	if (*z).VrfOut.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x8
	}
	if (*z).Hashable.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x10
	}
	if (*z).UnauthenticatedCredential.Proof.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x20
	}
	if (*z).Weight == 0 {
		zb0001Len--
		zb0001Mask |= 0x40
	}
	// variable map header, size zb0001Len
	o = append(o, 0x80|uint8(zb0001Len))
	if zb0001Len != 0 {
		if (zb0001Mask & 0x4) == 0 { // if not empty
			// string "ds"
			o = append(o, 0xa2, 0x64, 0x73)
			o = msgp.AppendBool(o, (*z).DomainSeparationEnabled)
		}
		if (zb0001Mask & 0x8) == 0 { // if not empty
			// string "h"
			o = append(o, 0xa1, 0x68)
			o = (*z).VrfOut.MarshalMsg(o)
		}
		if (zb0001Mask & 0x10) == 0 { // if not empty
			// string "hc"
			o = append(o, 0xa2, 0x68, 0x63)
			o = (*z).Hashable.MarshalMsg(o)
		}
		if (zb0001Mask & 0x20) == 0 { // if not empty
			// string "pf"
			o = append(o, 0xa2, 0x70, 0x66)
			o = (*z).UnauthenticatedCredential.Proof.MarshalMsg(o)
		}
		if (zb0001Mask & 0x40) == 0 { // if not empty
			// string "wt"
			o = append(o, 0xa2, 0x77, 0x74)
			o = msgp.AppendUint64(o, (*z).Weight)
		}
	}
	return
}

func (_ *Credential) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*Credential)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *Credential) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0001 int
	var zb0002 bool
	zb0001, zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0001, zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0001 > 0 {
			zb0001--
			(*z).Weight, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Weight")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).VrfOut.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "VrfOut")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			(*z).DomainSeparationEnabled, bts, err = msgp.ReadBoolBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "DomainSeparationEnabled")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).Hashable.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Hashable")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).UnauthenticatedCredential.Proof.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Proof")
				return
			}
		}
		if zb0001 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0001)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 {
			(*z) = Credential{}
		}
		for zb0001 > 0 {
			zb0001--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "wt":
				(*z).Weight, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Weight")
					return
				}
			case "h":
				bts, err = (*z).VrfOut.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "VrfOut")
					return
				}
			case "ds":
				(*z).DomainSeparationEnabled, bts, err = msgp.ReadBoolBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "DomainSeparationEnabled")
					return
				}
			case "hc":
				bts, err = (*z).Hashable.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Hashable")
					return
				}
			case "pf":
				bts, err = (*z).UnauthenticatedCredential.Proof.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Proof")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *Credential) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *Credential) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*Credential)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *Credential) Msgsize() (s int) {
	s = 1 + 3 + msgp.Uint64Size + 2 + (*z).VrfOut.Msgsize() + 3 + msgp.BoolSize + 3 + (*z).Hashable.Msgsize() + 3 + (*z).UnauthenticatedCredential.Proof.Msgsize()
	return
}

// MsgIsZero returns whether this is a zero value
func (z *Credential) MsgIsZero() bool {
	return ((*z).Weight == 0) && ((*z).VrfOut.MsgIsZero()) && ((*z).DomainSeparationEnabled == false) && ((*z).Hashable.MsgIsZero()) && ((*z).UnauthenticatedCredential.Proof.MsgIsZero())
}

// MaxSize returns a maximum valid message size for this message type
func CredentialMaxSize() (s int) {
	s = 1 + 3 + msgp.Uint64Size + 2 + crypto.DigestMaxSize() + 3 + msgp.BoolSize + 3 + HashableCredentialMaxSize() + 3 + crypto.VrfProofMaxSize()
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *Seed) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	o = msgp.AppendBytes(o, (*z)[:])
	return
}

func (_ *Seed) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*Seed)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *Seed) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	bts, err = msgp.ReadExactBytes(bts, (*z)[:])
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	o = bts
	return
}

func (z *Seed) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *Seed) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*Seed)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *Seed) Msgsize() (s int) {
	s = msgp.ArrayHeaderSize + (32 * (msgp.ByteSize))
	return
}

// MsgIsZero returns whether this is a zero value
func (z *Seed) MsgIsZero() bool {
	return (*z) == (Seed{})
}

// MaxSize returns a maximum valid message size for this message type
func SeedMaxSize() (s int) {
	// Calculating size of array: z
	s = msgp.ArrayHeaderSize + ((32) * (msgp.ByteSize))
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *UnauthenticatedCredential) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0001Len := uint32(1)
	var zb0001Mask uint8 /* 2 bits */
	if (*z).Proof.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x2
	}
	// variable map header, size zb0001Len
	o = append(o, 0x80|uint8(zb0001Len))
	if zb0001Len != 0 {
		if (zb0001Mask & 0x2) == 0 { // if not empty
			// string "pf"
			o = append(o, 0xa2, 0x70, 0x66)
			o = (*z).Proof.MarshalMsg(o)
		}
	}
	return
}

func (_ *UnauthenticatedCredential) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*UnauthenticatedCredential)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *UnauthenticatedCredential) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0001 int
	var zb0002 bool
	zb0001, zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0001, zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).Proof.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Proof")
				return
			}
		}
		if zb0001 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0001)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 {
			(*z) = UnauthenticatedCredential{}
		}
		for zb0001 > 0 {
			zb0001--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "pf":
				bts, err = (*z).Proof.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Proof")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *UnauthenticatedCredential) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *UnauthenticatedCredential) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*UnauthenticatedCredential)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *UnauthenticatedCredential) Msgsize() (s int) {
	s = 1 + 3 + (*z).Proof.Msgsize()
	return
}

// MsgIsZero returns whether this is a zero value
func (z *UnauthenticatedCredential) MsgIsZero() bool {
	return ((*z).Proof.MsgIsZero())
}

// MaxSize returns a maximum valid message size for this message type
func UnauthenticatedCredentialMaxSize() (s int) {
	s = 1 + 3 + crypto.VrfProofMaxSize()
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *hashableCredential) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0001Len := uint32(3)
	var zb0001Mask uint8 /* 4 bits */
	if (*z).Iter == 0 {
		zb0001Len--
		zb0001Mask |= 0x2
	}
	if (*z).Member.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x4
	}
	if (*z).RawOut.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x8
	}
	// variable map header, size zb0001Len
	o = append(o, 0x80|uint8(zb0001Len))
	if zb0001Len != 0 {
		if (zb0001Mask & 0x2) == 0 { // if not empty
			// string "i"
			o = append(o, 0xa1, 0x69)
			o = msgp.AppendUint64(o, (*z).Iter)
		}
		if (zb0001Mask & 0x4) == 0 { // if not empty
			// string "m"
			o = append(o, 0xa1, 0x6d)
			o = (*z).Member.MarshalMsg(o)
		}
		if (zb0001Mask & 0x8) == 0 { // if not empty
			// string "v"
			o = append(o, 0xa1, 0x76)
			o = (*z).RawOut.MarshalMsg(o)
		}
	}
	return
}

func (_ *hashableCredential) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*hashableCredential)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *hashableCredential) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0001 int
	var zb0002 bool
	zb0001, zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0001, zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).RawOut.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "RawOut")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).Member.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Member")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			(*z).Iter, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Iter")
				return
			}
		}
		if zb0001 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0001)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 {
			(*z) = hashableCredential{}
		}
		for zb0001 > 0 {
			zb0001--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "v":
				bts, err = (*z).RawOut.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "RawOut")
					return
				}
			case "m":
				bts, err = (*z).Member.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Member")
					return
				}
			case "i":
				(*z).Iter, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Iter")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *hashableCredential) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *hashableCredential) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*hashableCredential)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *hashableCredential) Msgsize() (s int) {
	s = 1 + 2 + (*z).RawOut.Msgsize() + 2 + (*z).Member.Msgsize() + 2 + msgp.Uint64Size
	return
}

// MsgIsZero returns whether this is a zero value
func (z *hashableCredential) MsgIsZero() bool {
	return ((*z).RawOut.MsgIsZero()) && ((*z).Member.MsgIsZero()) && ((*z).Iter == 0)
}

// MaxSize returns a maximum valid message size for this message type
func HashableCredentialMaxSize() (s int) {
	s = 1 + 2 + crypto.VrfOutputMaxSize() + 2 + basics.AddressMaxSize() + 2 + msgp.Uint64Size
	return
}
