package basics

// Code generated by github.com/algorand/msgp DO NOT EDIT.

import (
	"sort"

	"github.com/algorand/msgp/msgp"

	"github.com/algorand/go-algorand/config/bounds"
	"github.com/algorand/go-algorand/crypto"
	"github.com/algorand/go-algorand/crypto/merklesignature"
)

// The following msgp objects are implemented in this file:
// AccountData
//      |-----> (*) MarshalMsg
//      |-----> (*) CanMarshalMsg
//      |-----> (*) UnmarshalMsg
//      |-----> (*) UnmarshalMsgWithState
//      |-----> (*) CanUnmarshalMsg
//      |-----> (*) Msgsize
//      |-----> (*) MsgIsZero
//      |-----> AccountDataMaxSize()
//
// Address
//    |-----> (*) MarshalMsg
//    |-----> (*) CanMarshalMsg
//    |-----> (*) UnmarshalMsg
//    |-----> (*) UnmarshalMsgWithState
//    |-----> (*) CanUnmarshalMsg
//    |-----> (*) Msgsize
//    |-----> (*) MsgIsZero
//
// AppIndex
//     |-----> MarshalMsg
//     |-----> CanMarshalMsg
//     |-----> (*) UnmarshalMsg
//     |-----> (*) UnmarshalMsgWithState
//     |-----> (*) CanUnmarshalMsg
//     |-----> Msgsize
//     |-----> MsgIsZero
//     |-----> AppIndexMaxSize()
//
// AppLocalState
//       |-----> (*) MarshalMsg
//       |-----> (*) CanMarshalMsg
//       |-----> (*) UnmarshalMsg
//       |-----> (*) UnmarshalMsgWithState
//       |-----> (*) CanUnmarshalMsg
//       |-----> (*) Msgsize
//       |-----> (*) MsgIsZero
//       |-----> AppLocalStateMaxSize()
//
// AppParams
//     |-----> (*) MarshalMsg
//     |-----> (*) CanMarshalMsg
//     |-----> (*) UnmarshalMsg
//     |-----> (*) UnmarshalMsgWithState
//     |-----> (*) CanUnmarshalMsg
//     |-----> (*) Msgsize
//     |-----> (*) MsgIsZero
//     |-----> AppParamsMaxSize()
//
// AssetHolding
//       |-----> (*) MarshalMsg
//       |-----> (*) CanMarshalMsg
//       |-----> (*) UnmarshalMsg
//       |-----> (*) UnmarshalMsgWithState
//       |-----> (*) CanUnmarshalMsg
//       |-----> (*) Msgsize
//       |-----> (*) MsgIsZero
//       |-----> AssetHoldingMaxSize()
//
// AssetIndex
//      |-----> MarshalMsg
//      |-----> CanMarshalMsg
//      |-----> (*) UnmarshalMsg
//      |-----> (*) UnmarshalMsgWithState
//      |-----> (*) CanUnmarshalMsg
//      |-----> Msgsize
//      |-----> MsgIsZero
//      |-----> AssetIndexMaxSize()
//
// AssetParams
//      |-----> (*) MarshalMsg
//      |-----> (*) CanMarshalMsg
//      |-----> (*) UnmarshalMsg
//      |-----> (*) UnmarshalMsgWithState
//      |-----> (*) CanUnmarshalMsg
//      |-----> (*) Msgsize
//      |-----> (*) MsgIsZero
//      |-----> AssetParamsMaxSize()
//
// BalanceRecord
//       |-----> (*) MarshalMsg
//       |-----> (*) CanMarshalMsg
//       |-----> (*) UnmarshalMsg
//       |-----> (*) UnmarshalMsgWithState
//       |-----> (*) CanUnmarshalMsg
//       |-----> (*) Msgsize
//       |-----> (*) MsgIsZero
//       |-----> BalanceRecordMaxSize()
//
// CreatableIndex
//        |-----> MarshalMsg
//        |-----> CanMarshalMsg
//        |-----> (*) UnmarshalMsg
//        |-----> (*) UnmarshalMsgWithState
//        |-----> (*) CanUnmarshalMsg
//        |-----> Msgsize
//        |-----> MsgIsZero
//        |-----> CreatableIndexMaxSize()
//
// CreatableType
//       |-----> MarshalMsg
//       |-----> CanMarshalMsg
//       |-----> (*) UnmarshalMsg
//       |-----> (*) UnmarshalMsgWithState
//       |-----> (*) CanUnmarshalMsg
//       |-----> Msgsize
//       |-----> MsgIsZero
//       |-----> CreatableTypeMaxSize()
//
// DeltaAction
//      |-----> MarshalMsg
//      |-----> CanMarshalMsg
//      |-----> (*) UnmarshalMsg
//      |-----> (*) UnmarshalMsgWithState
//      |-----> (*) CanUnmarshalMsg
//      |-----> Msgsize
//      |-----> MsgIsZero
//      |-----> DeltaActionMaxSize()
//
// Participant
//      |-----> (*) MarshalMsg
//      |-----> (*) CanMarshalMsg
//      |-----> (*) UnmarshalMsg
//      |-----> (*) UnmarshalMsgWithState
//      |-----> (*) CanUnmarshalMsg
//      |-----> (*) Msgsize
//      |-----> (*) MsgIsZero
//      |-----> ParticipantMaxSize()
//
// Round
//   |-----> MarshalMsg
//   |-----> CanMarshalMsg
//   |-----> (*) UnmarshalMsg
//   |-----> (*) UnmarshalMsgWithState
//   |-----> (*) CanUnmarshalMsg
//   |-----> Msgsize
//   |-----> MsgIsZero
//   |-----> RoundMaxSize()
//
// RoundInterval
//       |-----> MarshalMsg
//       |-----> CanMarshalMsg
//       |-----> (*) UnmarshalMsg
//       |-----> (*) UnmarshalMsgWithState
//       |-----> (*) CanUnmarshalMsg
//       |-----> Msgsize
//       |-----> MsgIsZero
//       |-----> RoundIntervalMaxSize()
//
// StateDelta
//      |-----> MarshalMsg
//      |-----> CanMarshalMsg
//      |-----> (*) UnmarshalMsg
//      |-----> (*) UnmarshalMsgWithState
//      |-----> (*) CanUnmarshalMsg
//      |-----> Msgsize
//      |-----> MsgIsZero
//      |-----> StateDeltaMaxSize()
//
// StateSchema
//      |-----> (*) MarshalMsg
//      |-----> (*) CanMarshalMsg
//      |-----> (*) UnmarshalMsg
//      |-----> (*) UnmarshalMsgWithState
//      |-----> (*) CanUnmarshalMsg
//      |-----> (*) Msgsize
//      |-----> (*) MsgIsZero
//      |-----> StateSchemaMaxSize()
//
// StateSchemas
//       |-----> (*) MarshalMsg
//       |-----> (*) CanMarshalMsg
//       |-----> (*) UnmarshalMsg
//       |-----> (*) UnmarshalMsgWithState
//       |-----> (*) CanUnmarshalMsg
//       |-----> (*) Msgsize
//       |-----> (*) MsgIsZero
//       |-----> StateSchemasMaxSize()
//
// Status
//    |-----> MarshalMsg
//    |-----> CanMarshalMsg
//    |-----> (*) UnmarshalMsg
//    |-----> (*) UnmarshalMsgWithState
//    |-----> (*) CanUnmarshalMsg
//    |-----> Msgsize
//    |-----> MsgIsZero
//    |-----> StatusMaxSize()
//
// TealKeyValue
//       |-----> MarshalMsg
//       |-----> CanMarshalMsg
//       |-----> (*) UnmarshalMsg
//       |-----> (*) UnmarshalMsgWithState
//       |-----> (*) CanUnmarshalMsg
//       |-----> Msgsize
//       |-----> MsgIsZero
//       |-----> TealKeyValueMaxSize()
//
// TealType
//     |-----> MarshalMsg
//     |-----> CanMarshalMsg
//     |-----> (*) UnmarshalMsg
//     |-----> (*) UnmarshalMsgWithState
//     |-----> (*) CanUnmarshalMsg
//     |-----> Msgsize
//     |-----> MsgIsZero
//     |-----> TealTypeMaxSize()
//
// TealValue
//     |-----> (*) MarshalMsg
//     |-----> (*) CanMarshalMsg
//     |-----> (*) UnmarshalMsg
//     |-----> (*) UnmarshalMsgWithState
//     |-----> (*) CanUnmarshalMsg
//     |-----> (*) Msgsize
//     |-----> (*) MsgIsZero
//     |-----> TealValueMaxSize()
//
// ValueDelta
//      |-----> (*) MarshalMsg
//      |-----> (*) CanMarshalMsg
//      |-----> (*) UnmarshalMsg
//      |-----> (*) UnmarshalMsgWithState
//      |-----> (*) CanUnmarshalMsg
//      |-----> (*) Msgsize
//      |-----> (*) MsgIsZero
//      |-----> ValueDeltaMaxSize()
//
// crypto.Digest
//       |-----> crypto.DigestMaxSize()
//

// MarshalMsg implements msgp.Marshaler
func (z *AccountData) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0009Len := uint32(22)
	var zb0009Mask uint32 /* 23 bits */
	if (*z).MicroAlgos.MsgIsZero() {
		zb0009Len--
		zb0009Mask |= 0x2
	}
	if len((*z).AssetParams) == 0 {
		zb0009Len--
		zb0009Mask |= 0x4
	}
	if len((*z).AppLocalStates) == 0 {
		zb0009Len--
		zb0009Mask |= 0x8
	}
	if len((*z).AppParams) == 0 {
		zb0009Len--
		zb0009Mask |= 0x10
	}
	if len((*z).Assets) == 0 {
		zb0009Len--
		zb0009Mask |= 0x20
	}
	if (*z).RewardsBase == 0 {
		zb0009Len--
		zb0009Mask |= 0x40
	}
	if (*z).RewardedMicroAlgos.MsgIsZero() {
		zb0009Len--
		zb0009Mask |= 0x80
	}
	if (*z).IncentiveEligible == false {
		zb0009Len--
		zb0009Mask |= 0x100
	}
	if (*z).LastHeartbeat == 0 {
		zb0009Len--
		zb0009Mask |= 0x200
	}
	if (*z).LastProposed == 0 {
		zb0009Len--
		zb0009Mask |= 0x400
	}
	if (*z).Status == 0 {
		zb0009Len--
		zb0009Mask |= 0x800
	}
	if (*z).SelectionID.MsgIsZero() {
		zb0009Len--
		zb0009Mask |= 0x1000
	}
	if (*z).AuthAddr.MsgIsZero() {
		zb0009Len--
		zb0009Mask |= 0x2000
	}
	if (*z).StateProofID.MsgIsZero() {
		zb0009Len--
		zb0009Mask |= 0x4000
	}
	if (*z).TotalBoxes == 0 {
		zb0009Len--
		zb0009Mask |= 0x8000
	}
	if (*z).TotalBoxBytes == 0 {
		zb0009Len--
		zb0009Mask |= 0x10000
	}
	if (*z).TotalExtraAppPages == 0 {
		zb0009Len--
		zb0009Mask |= 0x20000
	}
	if ((*z).TotalAppSchema.NumUint == 0) && ((*z).TotalAppSchema.NumByteSlice == 0) {
		zb0009Len--
		zb0009Mask |= 0x40000
	}
	if (*z).VoteID.MsgIsZero() {
		zb0009Len--
		zb0009Mask |= 0x80000
	}
	if (*z).VoteFirstValid == 0 {
		zb0009Len--
		zb0009Mask |= 0x100000
	}
	if (*z).VoteKeyDilution == 0 {
		zb0009Len--
		zb0009Mask |= 0x200000
	}
	if (*z).VoteLastValid == 0 {
		zb0009Len--
		zb0009Mask |= 0x400000
	}
	// variable map header, size zb0009Len
	o = msgp.AppendMapHeader(o, zb0009Len)
	if zb0009Len != 0 {
		if (zb0009Mask & 0x2) == 0 { // if not empty
			// string "algo"
			o = append(o, 0xa4, 0x61, 0x6c, 0x67, 0x6f)
			o = (*z).MicroAlgos.MarshalMsg(o)
		}
		if (zb0009Mask & 0x4) == 0 { // if not empty
			// string "apar"
			o = append(o, 0xa4, 0x61, 0x70, 0x61, 0x72)
			if (*z).AssetParams == nil {
				o = msgp.AppendNil(o)
			} else {
				o = msgp.AppendMapHeader(o, uint32(len((*z).AssetParams)))
			}
			zb0001_keys := make([]AssetIndex, 0, len((*z).AssetParams))
			for zb0001 := range (*z).AssetParams {
				zb0001_keys = append(zb0001_keys, zb0001)
			}
			sort.Sort(SortAssetIndex(zb0001_keys))
			for _, zb0001 := range zb0001_keys {
				zb0002 := (*z).AssetParams[zb0001]
				_ = zb0002
				o = zb0001.MarshalMsg(o)
				o = zb0002.MarshalMsg(o)
			}
		}
		if (zb0009Mask & 0x8) == 0 { // if not empty
			// string "appl"
			o = append(o, 0xa4, 0x61, 0x70, 0x70, 0x6c)
			if (*z).AppLocalStates == nil {
				o = msgp.AppendNil(o)
			} else {
				o = msgp.AppendMapHeader(o, uint32(len((*z).AppLocalStates)))
			}
			zb0005_keys := make([]AppIndex, 0, len((*z).AppLocalStates))
			for zb0005 := range (*z).AppLocalStates {
				zb0005_keys = append(zb0005_keys, zb0005)
			}
			sort.Sort(SortAppIndex(zb0005_keys))
			for _, zb0005 := range zb0005_keys {
				zb0006 := (*z).AppLocalStates[zb0005]
				_ = zb0006
				o = zb0005.MarshalMsg(o)
				o = zb0006.MarshalMsg(o)
			}
		}
		if (zb0009Mask & 0x10) == 0 { // if not empty
			// string "appp"
			o = append(o, 0xa4, 0x61, 0x70, 0x70, 0x70)
			if (*z).AppParams == nil {
				o = msgp.AppendNil(o)
			} else {
				o = msgp.AppendMapHeader(o, uint32(len((*z).AppParams)))
			}
			zb0007_keys := make([]AppIndex, 0, len((*z).AppParams))
			for zb0007 := range (*z).AppParams {
				zb0007_keys = append(zb0007_keys, zb0007)
			}
			sort.Sort(SortAppIndex(zb0007_keys))
			for _, zb0007 := range zb0007_keys {
				zb0008 := (*z).AppParams[zb0007]
				_ = zb0008
				o = zb0007.MarshalMsg(o)
				o = zb0008.MarshalMsg(o)
			}
		}
		if (zb0009Mask & 0x20) == 0 { // if not empty
			// string "asset"
			o = append(o, 0xa5, 0x61, 0x73, 0x73, 0x65, 0x74)
			if (*z).Assets == nil {
				o = msgp.AppendNil(o)
			} else {
				o = msgp.AppendMapHeader(o, uint32(len((*z).Assets)))
			}
			zb0003_keys := make([]AssetIndex, 0, len((*z).Assets))
			for zb0003 := range (*z).Assets {
				zb0003_keys = append(zb0003_keys, zb0003)
			}
			sort.Sort(SortAssetIndex(zb0003_keys))
			for _, zb0003 := range zb0003_keys {
				zb0004 := (*z).Assets[zb0003]
				_ = zb0004
				o = zb0003.MarshalMsg(o)
				// omitempty: check for empty values
				zb0010Len := uint32(2)
				var zb0010Mask uint8 /* 3 bits */
				if zb0004.Amount == 0 {
					zb0010Len--
					zb0010Mask |= 0x2
				}
				if zb0004.Frozen == false {
					zb0010Len--
					zb0010Mask |= 0x4
				}
				// variable map header, size zb0010Len
				o = append(o, 0x80|uint8(zb0010Len))
				if zb0010Len != 0 {
					if (zb0010Mask & 0x2) == 0 { // if not empty
						// string "a"
						o = append(o, 0xa1, 0x61)
						o = msgp.AppendUint64(o, zb0004.Amount)
					}
					if (zb0010Mask & 0x4) == 0 { // if not empty
						// string "f"
						o = append(o, 0xa1, 0x66)
						o = msgp.AppendBool(o, zb0004.Frozen)
					}
				}
			}
		}
		if (zb0009Mask & 0x40) == 0 { // if not empty
			// string "ebase"
			o = append(o, 0xa5, 0x65, 0x62, 0x61, 0x73, 0x65)
			o = msgp.AppendUint64(o, (*z).RewardsBase)
		}
		if (zb0009Mask & 0x80) == 0 { // if not empty
			// string "ern"
			o = append(o, 0xa3, 0x65, 0x72, 0x6e)
			o = (*z).RewardedMicroAlgos.MarshalMsg(o)
		}
		if (zb0009Mask & 0x100) == 0 { // if not empty
			// string "ie"
			o = append(o, 0xa2, 0x69, 0x65)
			o = msgp.AppendBool(o, (*z).IncentiveEligible)
		}
		if (zb0009Mask & 0x200) == 0 { // if not empty
			// string "lhb"
			o = append(o, 0xa3, 0x6c, 0x68, 0x62)
			o = msgp.AppendUint64(o, uint64((*z).LastHeartbeat))
		}
		if (zb0009Mask & 0x400) == 0 { // if not empty
			// string "lpr"
			o = append(o, 0xa3, 0x6c, 0x70, 0x72)
			o = msgp.AppendUint64(o, uint64((*z).LastProposed))
		}
		if (zb0009Mask & 0x800) == 0 { // if not empty
			// string "onl"
			o = append(o, 0xa3, 0x6f, 0x6e, 0x6c)
			o = msgp.AppendByte(o, byte((*z).Status))
		}
		if (zb0009Mask & 0x1000) == 0 { // if not empty
			// string "sel"
			o = append(o, 0xa3, 0x73, 0x65, 0x6c)
			o = (*z).SelectionID.MarshalMsg(o)
		}
		if (zb0009Mask & 0x2000) == 0 { // if not empty
			// string "spend"
			o = append(o, 0xa5, 0x73, 0x70, 0x65, 0x6e, 0x64)
			o = (*z).AuthAddr.MarshalMsg(o)
		}
		if (zb0009Mask & 0x4000) == 0 { // if not empty
			// string "stprf"
			o = append(o, 0xa5, 0x73, 0x74, 0x70, 0x72, 0x66)
			o = (*z).StateProofID.MarshalMsg(o)
		}
		if (zb0009Mask & 0x8000) == 0 { // if not empty
			// string "tbx"
			o = append(o, 0xa3, 0x74, 0x62, 0x78)
			o = msgp.AppendUint64(o, (*z).TotalBoxes)
		}
		if (zb0009Mask & 0x10000) == 0 { // if not empty
			// string "tbxb"
			o = append(o, 0xa4, 0x74, 0x62, 0x78, 0x62)
			o = msgp.AppendUint64(o, (*z).TotalBoxBytes)
		}
		if (zb0009Mask & 0x20000) == 0 { // if not empty
			// string "teap"
			o = append(o, 0xa4, 0x74, 0x65, 0x61, 0x70)
			o = msgp.AppendUint32(o, (*z).TotalExtraAppPages)
		}
		if (zb0009Mask & 0x40000) == 0 { // if not empty
			// string "tsch"
			o = append(o, 0xa4, 0x74, 0x73, 0x63, 0x68)
			// omitempty: check for empty values
			zb0011Len := uint32(2)
			var zb0011Mask uint8 /* 3 bits */
			if (*z).TotalAppSchema.NumByteSlice == 0 {
				zb0011Len--
				zb0011Mask |= 0x2
			}
			if (*z).TotalAppSchema.NumUint == 0 {
				zb0011Len--
				zb0011Mask |= 0x4
			}
			// variable map header, size zb0011Len
			o = append(o, 0x80|uint8(zb0011Len))
			if (zb0011Mask & 0x2) == 0 { // if not empty
				// string "nbs"
				o = append(o, 0xa3, 0x6e, 0x62, 0x73)
				o = msgp.AppendUint64(o, (*z).TotalAppSchema.NumByteSlice)
			}
			if (zb0011Mask & 0x4) == 0 { // if not empty
				// string "nui"
				o = append(o, 0xa3, 0x6e, 0x75, 0x69)
				o = msgp.AppendUint64(o, (*z).TotalAppSchema.NumUint)
			}
		}
		if (zb0009Mask & 0x80000) == 0 { // if not empty
			// string "vote"
			o = append(o, 0xa4, 0x76, 0x6f, 0x74, 0x65)
			o = (*z).VoteID.MarshalMsg(o)
		}
		if (zb0009Mask & 0x100000) == 0 { // if not empty
			// string "voteFst"
			o = append(o, 0xa7, 0x76, 0x6f, 0x74, 0x65, 0x46, 0x73, 0x74)
			o = msgp.AppendUint64(o, uint64((*z).VoteFirstValid))
		}
		if (zb0009Mask & 0x200000) == 0 { // if not empty
			// string "voteKD"
			o = append(o, 0xa6, 0x76, 0x6f, 0x74, 0x65, 0x4b, 0x44)
			o = msgp.AppendUint64(o, (*z).VoteKeyDilution)
		}
		if (zb0009Mask & 0x400000) == 0 { // if not empty
			// string "voteLst"
			o = append(o, 0xa7, 0x76, 0x6f, 0x74, 0x65, 0x4c, 0x73, 0x74)
			o = msgp.AppendUint64(o, uint64((*z).VoteLastValid))
		}
	}
	return
}

func (_ *AccountData) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*AccountData)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *AccountData) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0009 int
	var zb0010 bool
	zb0009, zb0010, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0009, zb0010, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0009 > 0 {
			zb0009--
			{
				var zb0011 byte
				zb0011, bts, err = msgp.ReadByteBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Status")
					return
				}
				(*z).Status = Status(zb0011)
			}
		}
		if zb0009 > 0 {
			zb0009--
			bts, err = (*z).MicroAlgos.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "MicroAlgos")
				return
			}
		}
		if zb0009 > 0 {
			zb0009--
			(*z).RewardsBase, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "RewardsBase")
				return
			}
		}
		if zb0009 > 0 {
			zb0009--
			bts, err = (*z).RewardedMicroAlgos.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "RewardedMicroAlgos")
				return
			}
		}
		if zb0009 > 0 {
			zb0009--
			bts, err = (*z).VoteID.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "VoteID")
				return
			}
		}
		if zb0009 > 0 {
			zb0009--
			bts, err = (*z).SelectionID.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "SelectionID")
				return
			}
		}
		if zb0009 > 0 {
			zb0009--
			bts, err = (*z).StateProofID.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "StateProofID")
				return
			}
		}
		if zb0009 > 0 {
			zb0009--
			{
				var zb0012 uint64
				zb0012, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "VoteFirstValid")
					return
				}
				(*z).VoteFirstValid = Round(zb0012)
			}
		}
		if zb0009 > 0 {
			zb0009--
			{
				var zb0013 uint64
				zb0013, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "VoteLastValid")
					return
				}
				(*z).VoteLastValid = Round(zb0013)
			}
		}
		if zb0009 > 0 {
			zb0009--
			(*z).VoteKeyDilution, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "VoteKeyDilution")
				return
			}
		}
		if zb0009 > 0 {
			zb0009--
			{
				var zb0014 uint64
				zb0014, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "LastProposed")
					return
				}
				(*z).LastProposed = Round(zb0014)
			}
		}
		if zb0009 > 0 {
			zb0009--
			{
				var zb0015 uint64
				zb0015, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "LastHeartbeat")
					return
				}
				(*z).LastHeartbeat = Round(zb0015)
			}
		}
		if zb0009 > 0 {
			zb0009--
			var zb0016 int
			var zb0017 bool
			zb0016, zb0017, bts, err = msgp.ReadMapHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "AssetParams")
				return
			}
			if zb0016 > bounds.EncodedMaxAssetsPerAccount {
				err = msgp.ErrOverflow(uint64(zb0016), uint64(bounds.EncodedMaxAssetsPerAccount))
				err = msgp.WrapError(err, "struct-from-array", "AssetParams")
				return
			}
			if zb0017 {
				(*z).AssetParams = nil
			} else if (*z).AssetParams == nil {
				(*z).AssetParams = make(map[AssetIndex]AssetParams, zb0016)
			}
			for zb0016 > 0 {
				var zb0001 AssetIndex
				var zb0002 AssetParams
				zb0016--
				bts, err = zb0001.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "AssetParams")
					return
				}
				bts, err = zb0002.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "AssetParams", zb0001)
					return
				}
				(*z).AssetParams[zb0001] = zb0002
			}
		}
		if zb0009 > 0 {
			zb0009--
			var zb0018 int
			var zb0019 bool
			zb0018, zb0019, bts, err = msgp.ReadMapHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Assets")
				return
			}
			if zb0018 > bounds.EncodedMaxAssetsPerAccount {
				err = msgp.ErrOverflow(uint64(zb0018), uint64(bounds.EncodedMaxAssetsPerAccount))
				err = msgp.WrapError(err, "struct-from-array", "Assets")
				return
			}
			if zb0019 {
				(*z).Assets = nil
			} else if (*z).Assets == nil {
				(*z).Assets = make(map[AssetIndex]AssetHolding, zb0018)
			}
			for zb0018 > 0 {
				var zb0003 AssetIndex
				var zb0004 AssetHolding
				zb0018--
				bts, err = zb0003.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Assets")
					return
				}
				var zb0020 int
				var zb0021 bool
				zb0020, zb0021, bts, err = msgp.ReadMapHeaderBytes(bts)
				if _, ok := err.(msgp.TypeError); ok {
					zb0020, zb0021, bts, err = msgp.ReadArrayHeaderBytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "Assets", zb0003)
						return
					}
					if zb0020 > 0 {
						zb0020--
						zb0004.Amount, bts, err = msgp.ReadUint64Bytes(bts)
						if err != nil {
							err = msgp.WrapError(err, "struct-from-array", "Assets", zb0003, "struct-from-array", "Amount")
							return
						}
					}
					if zb0020 > 0 {
						zb0020--
						zb0004.Frozen, bts, err = msgp.ReadBoolBytes(bts)
						if err != nil {
							err = msgp.WrapError(err, "struct-from-array", "Assets", zb0003, "struct-from-array", "Frozen")
							return
						}
					}
					if zb0020 > 0 {
						err = msgp.ErrTooManyArrayFields(zb0020)
						if err != nil {
							err = msgp.WrapError(err, "struct-from-array", "Assets", zb0003, "struct-from-array")
							return
						}
					}
				} else {
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "Assets", zb0003)
						return
					}
					if zb0021 {
						zb0004 = AssetHolding{}
					}
					for zb0020 > 0 {
						zb0020--
						field, bts, err = msgp.ReadMapKeyZC(bts)
						if err != nil {
							err = msgp.WrapError(err, "struct-from-array", "Assets", zb0003)
							return
						}
						switch string(field) {
						case "a":
							zb0004.Amount, bts, err = msgp.ReadUint64Bytes(bts)
							if err != nil {
								err = msgp.WrapError(err, "struct-from-array", "Assets", zb0003, "Amount")
								return
							}
						case "f":
							zb0004.Frozen, bts, err = msgp.ReadBoolBytes(bts)
							if err != nil {
								err = msgp.WrapError(err, "struct-from-array", "Assets", zb0003, "Frozen")
								return
							}
						default:
							err = msgp.ErrNoField(string(field))
							if err != nil {
								err = msgp.WrapError(err, "struct-from-array", "Assets", zb0003)
								return
							}
						}
					}
				}
				(*z).Assets[zb0003] = zb0004
			}
		}
		if zb0009 > 0 {
			zb0009--
			bts, err = (*z).AuthAddr.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "AuthAddr")
				return
			}
		}
		if zb0009 > 0 {
			zb0009--
			(*z).IncentiveEligible, bts, err = msgp.ReadBoolBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "IncentiveEligible")
				return
			}
		}
		if zb0009 > 0 {
			zb0009--
			var zb0022 int
			var zb0023 bool
			zb0022, zb0023, bts, err = msgp.ReadMapHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "AppLocalStates")
				return
			}
			if zb0022 > bounds.EncodedMaxAppLocalStates {
				err = msgp.ErrOverflow(uint64(zb0022), uint64(bounds.EncodedMaxAppLocalStates))
				err = msgp.WrapError(err, "struct-from-array", "AppLocalStates")
				return
			}
			if zb0023 {
				(*z).AppLocalStates = nil
			} else if (*z).AppLocalStates == nil {
				(*z).AppLocalStates = make(map[AppIndex]AppLocalState, zb0022)
			}
			for zb0022 > 0 {
				var zb0005 AppIndex
				var zb0006 AppLocalState
				zb0022--
				bts, err = zb0005.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "AppLocalStates")
					return
				}
				bts, err = zb0006.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "AppLocalStates", zb0005)
					return
				}
				(*z).AppLocalStates[zb0005] = zb0006
			}
		}
		if zb0009 > 0 {
			zb0009--
			var zb0024 int
			var zb0025 bool
			zb0024, zb0025, bts, err = msgp.ReadMapHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "AppParams")
				return
			}
			if zb0024 > bounds.EncodedMaxAppParams {
				err = msgp.ErrOverflow(uint64(zb0024), uint64(bounds.EncodedMaxAppParams))
				err = msgp.WrapError(err, "struct-from-array", "AppParams")
				return
			}
			if zb0025 {
				(*z).AppParams = nil
			} else if (*z).AppParams == nil {
				(*z).AppParams = make(map[AppIndex]AppParams, zb0024)
			}
			for zb0024 > 0 {
				var zb0007 AppIndex
				var zb0008 AppParams
				zb0024--
				bts, err = zb0007.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "AppParams")
					return
				}
				bts, err = zb0008.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "AppParams", zb0007)
					return
				}
				(*z).AppParams[zb0007] = zb0008
			}
		}
		if zb0009 > 0 {
			zb0009--
			var zb0026 int
			var zb0027 bool
			zb0026, zb0027, bts, err = msgp.ReadMapHeaderBytes(bts)
			if _, ok := err.(msgp.TypeError); ok {
				zb0026, zb0027, bts, err = msgp.ReadArrayHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "TotalAppSchema")
					return
				}
				if zb0026 > 0 {
					zb0026--
					(*z).TotalAppSchema.NumUint, bts, err = msgp.ReadUint64Bytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "TotalAppSchema", "struct-from-array", "NumUint")
						return
					}
				}
				if zb0026 > 0 {
					zb0026--
					(*z).TotalAppSchema.NumByteSlice, bts, err = msgp.ReadUint64Bytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "TotalAppSchema", "struct-from-array", "NumByteSlice")
						return
					}
				}
				if zb0026 > 0 {
					err = msgp.ErrTooManyArrayFields(zb0026)
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "TotalAppSchema", "struct-from-array")
						return
					}
				}
			} else {
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "TotalAppSchema")
					return
				}
				if zb0027 {
					(*z).TotalAppSchema = StateSchema{}
				}
				for zb0026 > 0 {
					zb0026--
					field, bts, err = msgp.ReadMapKeyZC(bts)
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "TotalAppSchema")
						return
					}
					switch string(field) {
					case "nui":
						(*z).TotalAppSchema.NumUint, bts, err = msgp.ReadUint64Bytes(bts)
						if err != nil {
							err = msgp.WrapError(err, "struct-from-array", "TotalAppSchema", "NumUint")
							return
						}
					case "nbs":
						(*z).TotalAppSchema.NumByteSlice, bts, err = msgp.ReadUint64Bytes(bts)
						if err != nil {
							err = msgp.WrapError(err, "struct-from-array", "TotalAppSchema", "NumByteSlice")
							return
						}
					default:
						err = msgp.ErrNoField(string(field))
						if err != nil {
							err = msgp.WrapError(err, "struct-from-array", "TotalAppSchema")
							return
						}
					}
				}
			}
		}
		if zb0009 > 0 {
			zb0009--
			(*z).TotalExtraAppPages, bts, err = msgp.ReadUint32Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "TotalExtraAppPages")
				return
			}
		}
		if zb0009 > 0 {
			zb0009--
			(*z).TotalBoxes, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "TotalBoxes")
				return
			}
		}
		if zb0009 > 0 {
			zb0009--
			(*z).TotalBoxBytes, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "TotalBoxBytes")
				return
			}
		}
		if zb0009 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0009)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0010 {
			(*z) = AccountData{}
		}
		for zb0009 > 0 {
			zb0009--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "onl":
				{
					var zb0028 byte
					zb0028, bts, err = msgp.ReadByteBytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "Status")
						return
					}
					(*z).Status = Status(zb0028)
				}
			case "algo":
				bts, err = (*z).MicroAlgos.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "MicroAlgos")
					return
				}
			case "ebase":
				(*z).RewardsBase, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "RewardsBase")
					return
				}
			case "ern":
				bts, err = (*z).RewardedMicroAlgos.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "RewardedMicroAlgos")
					return
				}
			case "vote":
				bts, err = (*z).VoteID.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "VoteID")
					return
				}
			case "sel":
				bts, err = (*z).SelectionID.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "SelectionID")
					return
				}
			case "stprf":
				bts, err = (*z).StateProofID.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "StateProofID")
					return
				}
			case "voteFst":
				{
					var zb0029 uint64
					zb0029, bts, err = msgp.ReadUint64Bytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "VoteFirstValid")
						return
					}
					(*z).VoteFirstValid = Round(zb0029)
				}
			case "voteLst":
				{
					var zb0030 uint64
					zb0030, bts, err = msgp.ReadUint64Bytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "VoteLastValid")
						return
					}
					(*z).VoteLastValid = Round(zb0030)
				}
			case "voteKD":
				(*z).VoteKeyDilution, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "VoteKeyDilution")
					return
				}
			case "lpr":
				{
					var zb0031 uint64
					zb0031, bts, err = msgp.ReadUint64Bytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "LastProposed")
						return
					}
					(*z).LastProposed = Round(zb0031)
				}
			case "lhb":
				{
					var zb0032 uint64
					zb0032, bts, err = msgp.ReadUint64Bytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "LastHeartbeat")
						return
					}
					(*z).LastHeartbeat = Round(zb0032)
				}
			case "apar":
				var zb0033 int
				var zb0034 bool
				zb0033, zb0034, bts, err = msgp.ReadMapHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "AssetParams")
					return
				}
				if zb0033 > bounds.EncodedMaxAssetsPerAccount {
					err = msgp.ErrOverflow(uint64(zb0033), uint64(bounds.EncodedMaxAssetsPerAccount))
					err = msgp.WrapError(err, "AssetParams")
					return
				}
				if zb0034 {
					(*z).AssetParams = nil
				} else if (*z).AssetParams == nil {
					(*z).AssetParams = make(map[AssetIndex]AssetParams, zb0033)
				}
				for zb0033 > 0 {
					var zb0001 AssetIndex
					var zb0002 AssetParams
					zb0033--
					bts, err = zb0001.UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "AssetParams")
						return
					}
					bts, err = zb0002.UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "AssetParams", zb0001)
						return
					}
					(*z).AssetParams[zb0001] = zb0002
				}
			case "asset":
				var zb0035 int
				var zb0036 bool
				zb0035, zb0036, bts, err = msgp.ReadMapHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Assets")
					return
				}
				if zb0035 > bounds.EncodedMaxAssetsPerAccount {
					err = msgp.ErrOverflow(uint64(zb0035), uint64(bounds.EncodedMaxAssetsPerAccount))
					err = msgp.WrapError(err, "Assets")
					return
				}
				if zb0036 {
					(*z).Assets = nil
				} else if (*z).Assets == nil {
					(*z).Assets = make(map[AssetIndex]AssetHolding, zb0035)
				}
				for zb0035 > 0 {
					var zb0003 AssetIndex
					var zb0004 AssetHolding
					zb0035--
					bts, err = zb0003.UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "Assets")
						return
					}
					var zb0037 int
					var zb0038 bool
					zb0037, zb0038, bts, err = msgp.ReadMapHeaderBytes(bts)
					if _, ok := err.(msgp.TypeError); ok {
						zb0037, zb0038, bts, err = msgp.ReadArrayHeaderBytes(bts)
						if err != nil {
							err = msgp.WrapError(err, "Assets", zb0003)
							return
						}
						if zb0037 > 0 {
							zb0037--
							zb0004.Amount, bts, err = msgp.ReadUint64Bytes(bts)
							if err != nil {
								err = msgp.WrapError(err, "Assets", zb0003, "struct-from-array", "Amount")
								return
							}
						}
						if zb0037 > 0 {
							zb0037--
							zb0004.Frozen, bts, err = msgp.ReadBoolBytes(bts)
							if err != nil {
								err = msgp.WrapError(err, "Assets", zb0003, "struct-from-array", "Frozen")
								return
							}
						}
						if zb0037 > 0 {
							err = msgp.ErrTooManyArrayFields(zb0037)
							if err != nil {
								err = msgp.WrapError(err, "Assets", zb0003, "struct-from-array")
								return
							}
						}
					} else {
						if err != nil {
							err = msgp.WrapError(err, "Assets", zb0003)
							return
						}
						if zb0038 {
							zb0004 = AssetHolding{}
						}
						for zb0037 > 0 {
							zb0037--
							field, bts, err = msgp.ReadMapKeyZC(bts)
							if err != nil {
								err = msgp.WrapError(err, "Assets", zb0003)
								return
							}
							switch string(field) {
							case "a":
								zb0004.Amount, bts, err = msgp.ReadUint64Bytes(bts)
								if err != nil {
									err = msgp.WrapError(err, "Assets", zb0003, "Amount")
									return
								}
							case "f":
								zb0004.Frozen, bts, err = msgp.ReadBoolBytes(bts)
								if err != nil {
									err = msgp.WrapError(err, "Assets", zb0003, "Frozen")
									return
								}
							default:
								err = msgp.ErrNoField(string(field))
								if err != nil {
									err = msgp.WrapError(err, "Assets", zb0003)
									return
								}
							}
						}
					}
					(*z).Assets[zb0003] = zb0004
				}
			case "spend":
				bts, err = (*z).AuthAddr.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "AuthAddr")
					return
				}
			case "ie":
				(*z).IncentiveEligible, bts, err = msgp.ReadBoolBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "IncentiveEligible")
					return
				}
			case "appl":
				var zb0039 int
				var zb0040 bool
				zb0039, zb0040, bts, err = msgp.ReadMapHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "AppLocalStates")
					return
				}
				if zb0039 > bounds.EncodedMaxAppLocalStates {
					err = msgp.ErrOverflow(uint64(zb0039), uint64(bounds.EncodedMaxAppLocalStates))
					err = msgp.WrapError(err, "AppLocalStates")
					return
				}
				if zb0040 {
					(*z).AppLocalStates = nil
				} else if (*z).AppLocalStates == nil {
					(*z).AppLocalStates = make(map[AppIndex]AppLocalState, zb0039)
				}
				for zb0039 > 0 {
					var zb0005 AppIndex
					var zb0006 AppLocalState
					zb0039--
					bts, err = zb0005.UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "AppLocalStates")
						return
					}
					bts, err = zb0006.UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "AppLocalStates", zb0005)
						return
					}
					(*z).AppLocalStates[zb0005] = zb0006
				}
			case "appp":
				var zb0041 int
				var zb0042 bool
				zb0041, zb0042, bts, err = msgp.ReadMapHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "AppParams")
					return
				}
				if zb0041 > bounds.EncodedMaxAppParams {
					err = msgp.ErrOverflow(uint64(zb0041), uint64(bounds.EncodedMaxAppParams))
					err = msgp.WrapError(err, "AppParams")
					return
				}
				if zb0042 {
					(*z).AppParams = nil
				} else if (*z).AppParams == nil {
					(*z).AppParams = make(map[AppIndex]AppParams, zb0041)
				}
				for zb0041 > 0 {
					var zb0007 AppIndex
					var zb0008 AppParams
					zb0041--
					bts, err = zb0007.UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "AppParams")
						return
					}
					bts, err = zb0008.UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "AppParams", zb0007)
						return
					}
					(*z).AppParams[zb0007] = zb0008
				}
			case "tsch":
				var zb0043 int
				var zb0044 bool
				zb0043, zb0044, bts, err = msgp.ReadMapHeaderBytes(bts)
				if _, ok := err.(msgp.TypeError); ok {
					zb0043, zb0044, bts, err = msgp.ReadArrayHeaderBytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "TotalAppSchema")
						return
					}
					if zb0043 > 0 {
						zb0043--
						(*z).TotalAppSchema.NumUint, bts, err = msgp.ReadUint64Bytes(bts)
						if err != nil {
							err = msgp.WrapError(err, "TotalAppSchema", "struct-from-array", "NumUint")
							return
						}
					}
					if zb0043 > 0 {
						zb0043--
						(*z).TotalAppSchema.NumByteSlice, bts, err = msgp.ReadUint64Bytes(bts)
						if err != nil {
							err = msgp.WrapError(err, "TotalAppSchema", "struct-from-array", "NumByteSlice")
							return
						}
					}
					if zb0043 > 0 {
						err = msgp.ErrTooManyArrayFields(zb0043)
						if err != nil {
							err = msgp.WrapError(err, "TotalAppSchema", "struct-from-array")
							return
						}
					}
				} else {
					if err != nil {
						err = msgp.WrapError(err, "TotalAppSchema")
						return
					}
					if zb0044 {
						(*z).TotalAppSchema = StateSchema{}
					}
					for zb0043 > 0 {
						zb0043--
						field, bts, err = msgp.ReadMapKeyZC(bts)
						if err != nil {
							err = msgp.WrapError(err, "TotalAppSchema")
							return
						}
						switch string(field) {
						case "nui":
							(*z).TotalAppSchema.NumUint, bts, err = msgp.ReadUint64Bytes(bts)
							if err != nil {
								err = msgp.WrapError(err, "TotalAppSchema", "NumUint")
								return
							}
						case "nbs":
							(*z).TotalAppSchema.NumByteSlice, bts, err = msgp.ReadUint64Bytes(bts)
							if err != nil {
								err = msgp.WrapError(err, "TotalAppSchema", "NumByteSlice")
								return
							}
						default:
							err = msgp.ErrNoField(string(field))
							if err != nil {
								err = msgp.WrapError(err, "TotalAppSchema")
								return
							}
						}
					}
				}
			case "teap":
				(*z).TotalExtraAppPages, bts, err = msgp.ReadUint32Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "TotalExtraAppPages")
					return
				}
			case "tbx":
				(*z).TotalBoxes, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "TotalBoxes")
					return
				}
			case "tbxb":
				(*z).TotalBoxBytes, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "TotalBoxBytes")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *AccountData) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *AccountData) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*AccountData)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *AccountData) Msgsize() (s int) {
	s = 3 + 4 + msgp.ByteSize + 5 + (*z).MicroAlgos.Msgsize() + 6 + msgp.Uint64Size + 4 + (*z).RewardedMicroAlgos.Msgsize() + 5 + (*z).VoteID.Msgsize() + 4 + (*z).SelectionID.Msgsize() + 6 + (*z).StateProofID.Msgsize() + 8 + msgp.Uint64Size + 8 + msgp.Uint64Size + 7 + msgp.Uint64Size + 4 + msgp.Uint64Size + 4 + msgp.Uint64Size + 5 + msgp.MapHeaderSize
	if (*z).AssetParams != nil {
		for zb0001, zb0002 := range (*z).AssetParams {
			_ = zb0001
			_ = zb0002
			s += 0 + zb0001.Msgsize() + zb0002.Msgsize()
		}
	}
	s += 6 + msgp.MapHeaderSize
	if (*z).Assets != nil {
		for zb0003, zb0004 := range (*z).Assets {
			_ = zb0003
			_ = zb0004
			s += 0 + zb0003.Msgsize() + 1 + 2 + msgp.Uint64Size + 2 + msgp.BoolSize
		}
	}
	s += 6 + (*z).AuthAddr.Msgsize() + 3 + msgp.BoolSize + 5 + msgp.MapHeaderSize
	if (*z).AppLocalStates != nil {
		for zb0005, zb0006 := range (*z).AppLocalStates {
			_ = zb0005
			_ = zb0006
			s += 0 + zb0005.Msgsize() + zb0006.Msgsize()
		}
	}
	s += 5 + msgp.MapHeaderSize
	if (*z).AppParams != nil {
		for zb0007, zb0008 := range (*z).AppParams {
			_ = zb0007
			_ = zb0008
			s += 0 + zb0007.Msgsize() + zb0008.Msgsize()
		}
	}
	s += 5 + 1 + 4 + msgp.Uint64Size + 4 + msgp.Uint64Size + 5 + msgp.Uint32Size + 4 + msgp.Uint64Size + 5 + msgp.Uint64Size
	return
}

// MsgIsZero returns whether this is a zero value
func (z *AccountData) MsgIsZero() bool {
	return ((*z).Status == 0) && ((*z).MicroAlgos.MsgIsZero()) && ((*z).RewardsBase == 0) && ((*z).RewardedMicroAlgos.MsgIsZero()) && ((*z).VoteID.MsgIsZero()) && ((*z).SelectionID.MsgIsZero()) && ((*z).StateProofID.MsgIsZero()) && ((*z).VoteFirstValid == 0) && ((*z).VoteLastValid == 0) && ((*z).VoteKeyDilution == 0) && ((*z).LastProposed == 0) && ((*z).LastHeartbeat == 0) && (len((*z).AssetParams) == 0) && (len((*z).Assets) == 0) && ((*z).AuthAddr.MsgIsZero()) && ((*z).IncentiveEligible == false) && (len((*z).AppLocalStates) == 0) && (len((*z).AppParams) == 0) && (((*z).TotalAppSchema.NumUint == 0) && ((*z).TotalAppSchema.NumByteSlice == 0)) && ((*z).TotalExtraAppPages == 0) && ((*z).TotalBoxes == 0) && ((*z).TotalBoxBytes == 0)
}

// MaxSize returns a maximum valid message size for this message type
func AccountDataMaxSize() (s int) {
	s = 3 + 4 + msgp.ByteSize + 5 + MicroAlgosMaxSize() + 6 + msgp.Uint64Size + 4 + MicroAlgosMaxSize() + 5 + crypto.OneTimeSignatureVerifierMaxSize() + 4 + crypto.VRFVerifierMaxSize() + 6 + merklesignature.CommitmentMaxSize() + 8 + msgp.Uint64Size + 8 + msgp.Uint64Size + 7 + msgp.Uint64Size + 4 + msgp.Uint64Size + 4 + msgp.Uint64Size + 5
	s += msgp.MapHeaderSize
	// Adding size of map keys for z.AssetParams
	s += bounds.EncodedMaxAssetsPerAccount * (AssetIndexMaxSize())
	// Adding size of map values for z.AssetParams
	s += bounds.EncodedMaxAssetsPerAccount * (AssetParamsMaxSize())
	s += 6
	s += msgp.MapHeaderSize
	// Adding size of map keys for z.Assets
	s += bounds.EncodedMaxAssetsPerAccount * (AssetIndexMaxSize())
	// Adding size of map values for z.Assets
	s += bounds.EncodedMaxAssetsPerAccount * (1)
	s += 2 + msgp.Uint64Size + 2 + msgp.BoolSize
	s += 6 + AddressMaxSize() + 3 + msgp.BoolSize + 5
	s += msgp.MapHeaderSize
	// Adding size of map keys for z.AppLocalStates
	s += bounds.EncodedMaxAppLocalStates * (AppIndexMaxSize())
	// Adding size of map values for z.AppLocalStates
	s += bounds.EncodedMaxAppLocalStates * (AppLocalStateMaxSize())
	s += 5
	s += msgp.MapHeaderSize
	// Adding size of map keys for z.AppParams
	s += bounds.EncodedMaxAppParams * (AppIndexMaxSize())
	// Adding size of map values for z.AppParams
	s += bounds.EncodedMaxAppParams * (AppParamsMaxSize())
	s += 5 + 1 + 4 + msgp.Uint64Size + 4 + msgp.Uint64Size + 5 + msgp.Uint32Size + 4 + msgp.Uint64Size + 5 + msgp.Uint64Size
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *Address) MarshalMsg(b []byte) []byte {
	return ((*(crypto.Digest))(z)).MarshalMsg(b)
}
func (_ *Address) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*Address)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *Address) UnmarshalMsg(bts []byte) ([]byte, error) {
	return ((*(crypto.Digest))(z)).UnmarshalMsg(bts)
}
func (z *Address) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) ([]byte, error) {
	return ((*(crypto.Digest))(z)).UnmarshalMsgWithState(bts, st)
}
func (_ *Address) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*Address)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *Address) Msgsize() int {
	return ((*(crypto.Digest))(z)).Msgsize()
}

// MsgIsZero returns whether this is a zero value
func (z *Address) MsgIsZero() bool {
	return ((*(crypto.Digest))(z)).MsgIsZero()
}

// MaxSize returns a maximum valid message size for this message type
func AddressMaxSize() int {
	return crypto.DigestMaxSize()
}

// MarshalMsg implements msgp.Marshaler
func (z AppIndex) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	o = msgp.AppendUint64(o, uint64(z))
	return
}

func (_ AppIndex) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(AppIndex)
	if !ok {
		_, ok = (z).(*AppIndex)
	}
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *AppIndex) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	{
		var zb0001 uint64
		zb0001, bts, err = msgp.ReadUint64Bytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		(*z) = AppIndex(zb0001)
	}
	o = bts
	return
}

func (z *AppIndex) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *AppIndex) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*AppIndex)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z AppIndex) Msgsize() (s int) {
	s = msgp.Uint64Size
	return
}

// MsgIsZero returns whether this is a zero value
func (z AppIndex) MsgIsZero() bool {
	return z == 0
}

// MaxSize returns a maximum valid message size for this message type
func AppIndexMaxSize() (s int) {
	s = msgp.Uint64Size
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *AppLocalState) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0003Len := uint32(2)
	var zb0003Mask uint8 /* 3 bits */
	if ((*z).Schema.NumUint == 0) && ((*z).Schema.NumByteSlice == 0) {
		zb0003Len--
		zb0003Mask |= 0x2
	}
	if len((*z).KeyValue) == 0 {
		zb0003Len--
		zb0003Mask |= 0x4
	}
	// variable map header, size zb0003Len
	o = append(o, 0x80|uint8(zb0003Len))
	if zb0003Len != 0 {
		if (zb0003Mask & 0x2) == 0 { // if not empty
			// string "hsch"
			o = append(o, 0xa4, 0x68, 0x73, 0x63, 0x68)
			// omitempty: check for empty values
			zb0004Len := uint32(2)
			var zb0004Mask uint8 /* 3 bits */
			if (*z).Schema.NumByteSlice == 0 {
				zb0004Len--
				zb0004Mask |= 0x2
			}
			if (*z).Schema.NumUint == 0 {
				zb0004Len--
				zb0004Mask |= 0x4
			}
			// variable map header, size zb0004Len
			o = append(o, 0x80|uint8(zb0004Len))
			if (zb0004Mask & 0x2) == 0 { // if not empty
				// string "nbs"
				o = append(o, 0xa3, 0x6e, 0x62, 0x73)
				o = msgp.AppendUint64(o, (*z).Schema.NumByteSlice)
			}
			if (zb0004Mask & 0x4) == 0 { // if not empty
				// string "nui"
				o = append(o, 0xa3, 0x6e, 0x75, 0x69)
				o = msgp.AppendUint64(o, (*z).Schema.NumUint)
			}
		}
		if (zb0003Mask & 0x4) == 0 { // if not empty
			// string "tkv"
			o = append(o, 0xa3, 0x74, 0x6b, 0x76)
			if (*z).KeyValue == nil {
				o = msgp.AppendNil(o)
			} else {
				o = msgp.AppendMapHeader(o, uint32(len((*z).KeyValue)))
			}
			zb0001_keys := make([]string, 0, len((*z).KeyValue))
			for zb0001 := range (*z).KeyValue {
				zb0001_keys = append(zb0001_keys, zb0001)
			}
			sort.Sort(SortString(zb0001_keys))
			for _, zb0001 := range zb0001_keys {
				zb0002 := (*z).KeyValue[zb0001]
				_ = zb0002
				o = msgp.AppendString(o, zb0001)
				o = zb0002.MarshalMsg(o)
			}
		}
	}
	return
}

func (_ *AppLocalState) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*AppLocalState)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *AppLocalState) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0003 int
	var zb0004 bool
	zb0003, zb0004, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0003, zb0004, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0003 > 0 {
			zb0003--
			var zb0005 int
			var zb0006 bool
			zb0005, zb0006, bts, err = msgp.ReadMapHeaderBytes(bts)
			if _, ok := err.(msgp.TypeError); ok {
				zb0005, zb0006, bts, err = msgp.ReadArrayHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Schema")
					return
				}
				if zb0005 > 0 {
					zb0005--
					(*z).Schema.NumUint, bts, err = msgp.ReadUint64Bytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "Schema", "struct-from-array", "NumUint")
						return
					}
				}
				if zb0005 > 0 {
					zb0005--
					(*z).Schema.NumByteSlice, bts, err = msgp.ReadUint64Bytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "Schema", "struct-from-array", "NumByteSlice")
						return
					}
				}
				if zb0005 > 0 {
					err = msgp.ErrTooManyArrayFields(zb0005)
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "Schema", "struct-from-array")
						return
					}
				}
			} else {
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Schema")
					return
				}
				if zb0006 {
					(*z).Schema = StateSchema{}
				}
				for zb0005 > 0 {
					zb0005--
					field, bts, err = msgp.ReadMapKeyZC(bts)
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "Schema")
						return
					}
					switch string(field) {
					case "nui":
						(*z).Schema.NumUint, bts, err = msgp.ReadUint64Bytes(bts)
						if err != nil {
							err = msgp.WrapError(err, "struct-from-array", "Schema", "NumUint")
							return
						}
					case "nbs":
						(*z).Schema.NumByteSlice, bts, err = msgp.ReadUint64Bytes(bts)
						if err != nil {
							err = msgp.WrapError(err, "struct-from-array", "Schema", "NumByteSlice")
							return
						}
					default:
						err = msgp.ErrNoField(string(field))
						if err != nil {
							err = msgp.WrapError(err, "struct-from-array", "Schema")
							return
						}
					}
				}
			}
		}
		if zb0003 > 0 {
			zb0003--
			var zb0007 int
			var zb0008 bool
			zb0007, zb0008, bts, err = msgp.ReadMapHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "KeyValue")
				return
			}
			if zb0007 > bounds.EncodedMaxKeyValueEntries {
				err = msgp.ErrOverflow(uint64(zb0007), uint64(bounds.EncodedMaxKeyValueEntries))
				err = msgp.WrapError(err, "struct-from-array", "KeyValue")
				return
			}
			if zb0008 {
				(*z).KeyValue = nil
			} else if (*z).KeyValue == nil {
				(*z).KeyValue = make(TealKeyValue, zb0007)
			}
			for zb0007 > 0 {
				var zb0001 string
				var zb0002 TealValue
				zb0007--
				zb0001, bts, err = msgp.ReadStringBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "KeyValue")
					return
				}
				bts, err = zb0002.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "KeyValue", zb0001)
					return
				}
				(*z).KeyValue[zb0001] = zb0002
			}
		}
		if zb0003 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0003)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0004 {
			(*z) = AppLocalState{}
		}
		for zb0003 > 0 {
			zb0003--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "hsch":
				var zb0009 int
				var zb0010 bool
				zb0009, zb0010, bts, err = msgp.ReadMapHeaderBytes(bts)
				if _, ok := err.(msgp.TypeError); ok {
					zb0009, zb0010, bts, err = msgp.ReadArrayHeaderBytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "Schema")
						return
					}
					if zb0009 > 0 {
						zb0009--
						(*z).Schema.NumUint, bts, err = msgp.ReadUint64Bytes(bts)
						if err != nil {
							err = msgp.WrapError(err, "Schema", "struct-from-array", "NumUint")
							return
						}
					}
					if zb0009 > 0 {
						zb0009--
						(*z).Schema.NumByteSlice, bts, err = msgp.ReadUint64Bytes(bts)
						if err != nil {
							err = msgp.WrapError(err, "Schema", "struct-from-array", "NumByteSlice")
							return
						}
					}
					if zb0009 > 0 {
						err = msgp.ErrTooManyArrayFields(zb0009)
						if err != nil {
							err = msgp.WrapError(err, "Schema", "struct-from-array")
							return
						}
					}
				} else {
					if err != nil {
						err = msgp.WrapError(err, "Schema")
						return
					}
					if zb0010 {
						(*z).Schema = StateSchema{}
					}
					for zb0009 > 0 {
						zb0009--
						field, bts, err = msgp.ReadMapKeyZC(bts)
						if err != nil {
							err = msgp.WrapError(err, "Schema")
							return
						}
						switch string(field) {
						case "nui":
							(*z).Schema.NumUint, bts, err = msgp.ReadUint64Bytes(bts)
							if err != nil {
								err = msgp.WrapError(err, "Schema", "NumUint")
								return
							}
						case "nbs":
							(*z).Schema.NumByteSlice, bts, err = msgp.ReadUint64Bytes(bts)
							if err != nil {
								err = msgp.WrapError(err, "Schema", "NumByteSlice")
								return
							}
						default:
							err = msgp.ErrNoField(string(field))
							if err != nil {
								err = msgp.WrapError(err, "Schema")
								return
							}
						}
					}
				}
			case "tkv":
				var zb0011 int
				var zb0012 bool
				zb0011, zb0012, bts, err = msgp.ReadMapHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "KeyValue")
					return
				}
				if zb0011 > bounds.EncodedMaxKeyValueEntries {
					err = msgp.ErrOverflow(uint64(zb0011), uint64(bounds.EncodedMaxKeyValueEntries))
					err = msgp.WrapError(err, "KeyValue")
					return
				}
				if zb0012 {
					(*z).KeyValue = nil
				} else if (*z).KeyValue == nil {
					(*z).KeyValue = make(TealKeyValue, zb0011)
				}
				for zb0011 > 0 {
					var zb0001 string
					var zb0002 TealValue
					zb0011--
					zb0001, bts, err = msgp.ReadStringBytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "KeyValue")
						return
					}
					bts, err = zb0002.UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "KeyValue", zb0001)
						return
					}
					(*z).KeyValue[zb0001] = zb0002
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *AppLocalState) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *AppLocalState) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*AppLocalState)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *AppLocalState) Msgsize() (s int) {
	s = 1 + 5 + 1 + 4 + msgp.Uint64Size + 4 + msgp.Uint64Size + 4 + msgp.MapHeaderSize
	if (*z).KeyValue != nil {
		for zb0001, zb0002 := range (*z).KeyValue {
			_ = zb0001
			_ = zb0002
			s += 0 + msgp.StringPrefixSize + len(zb0001) + zb0002.Msgsize()
		}
	}
	return
}

// MsgIsZero returns whether this is a zero value
func (z *AppLocalState) MsgIsZero() bool {
	return (((*z).Schema.NumUint == 0) && ((*z).Schema.NumByteSlice == 0)) && (len((*z).KeyValue) == 0)
}

// MaxSize returns a maximum valid message size for this message type
func AppLocalStateMaxSize() (s int) {
	s = 1 + 5 + 1 + 4 + msgp.Uint64Size + 4 + msgp.Uint64Size + 4
	s += msgp.MapHeaderSize
	// Adding size of map keys for z.KeyValue
	s += bounds.EncodedMaxKeyValueEntries * (msgp.StringPrefixSize + bounds.MaxAppBytesKeyLen)
	// Adding size of map values for z.KeyValue
	s += bounds.EncodedMaxKeyValueEntries * (TealValueMaxSize())
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *AppParams) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0003Len := uint32(7)
	var zb0003Mask uint16 /* 9 bits */
	if len((*z).ApprovalProgram) == 0 {
		zb0003Len--
		zb0003Mask |= 0x4
	}
	if len((*z).ClearStateProgram) == 0 {
		zb0003Len--
		zb0003Mask |= 0x8
	}
	if (*z).ExtraProgramPages == 0 {
		zb0003Len--
		zb0003Mask |= 0x10
	}
	if len((*z).GlobalState) == 0 {
		zb0003Len--
		zb0003Mask |= 0x20
	}
	if ((*z).StateSchemas.GlobalStateSchema.NumUint == 0) && ((*z).StateSchemas.GlobalStateSchema.NumByteSlice == 0) {
		zb0003Len--
		zb0003Mask |= 0x40
	}
	if ((*z).StateSchemas.LocalStateSchema.NumUint == 0) && ((*z).StateSchemas.LocalStateSchema.NumByteSlice == 0) {
		zb0003Len--
		zb0003Mask |= 0x80
	}
	if (*z).Version == 0 {
		zb0003Len--
		zb0003Mask |= 0x100
	}
	// variable map header, size zb0003Len
	o = append(o, 0x80|uint8(zb0003Len))
	if zb0003Len != 0 {
		if (zb0003Mask & 0x4) == 0 { // if not empty
			// string "approv"
			o = append(o, 0xa6, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76)
			o = msgp.AppendBytes(o, (*z).ApprovalProgram)
		}
		if (zb0003Mask & 0x8) == 0 { // if not empty
			// string "clearp"
			o = append(o, 0xa6, 0x63, 0x6c, 0x65, 0x61, 0x72, 0x70)
			o = msgp.AppendBytes(o, (*z).ClearStateProgram)
		}
		if (zb0003Mask & 0x10) == 0 { // if not empty
			// string "epp"
			o = append(o, 0xa3, 0x65, 0x70, 0x70)
			o = msgp.AppendUint32(o, (*z).ExtraProgramPages)
		}
		if (zb0003Mask & 0x20) == 0 { // if not empty
			// string "gs"
			o = append(o, 0xa2, 0x67, 0x73)
			if (*z).GlobalState == nil {
				o = msgp.AppendNil(o)
			} else {
				o = msgp.AppendMapHeader(o, uint32(len((*z).GlobalState)))
			}
			zb0001_keys := make([]string, 0, len((*z).GlobalState))
			for zb0001 := range (*z).GlobalState {
				zb0001_keys = append(zb0001_keys, zb0001)
			}
			sort.Sort(SortString(zb0001_keys))
			for _, zb0001 := range zb0001_keys {
				zb0002 := (*z).GlobalState[zb0001]
				_ = zb0002
				o = msgp.AppendString(o, zb0001)
				o = zb0002.MarshalMsg(o)
			}
		}
		if (zb0003Mask & 0x40) == 0 { // if not empty
			// string "gsch"
			o = append(o, 0xa4, 0x67, 0x73, 0x63, 0x68)
			// omitempty: check for empty values
			zb0004Len := uint32(2)
			var zb0004Mask uint8 /* 3 bits */
			if (*z).StateSchemas.GlobalStateSchema.NumByteSlice == 0 {
				zb0004Len--
				zb0004Mask |= 0x2
			}
			if (*z).StateSchemas.GlobalStateSchema.NumUint == 0 {
				zb0004Len--
				zb0004Mask |= 0x4
			}
			// variable map header, size zb0004Len
			o = append(o, 0x80|uint8(zb0004Len))
			if (zb0004Mask & 0x2) == 0 { // if not empty
				// string "nbs"
				o = append(o, 0xa3, 0x6e, 0x62, 0x73)
				o = msgp.AppendUint64(o, (*z).StateSchemas.GlobalStateSchema.NumByteSlice)
			}
			if (zb0004Mask & 0x4) == 0 { // if not empty
				// string "nui"
				o = append(o, 0xa3, 0x6e, 0x75, 0x69)
				o = msgp.AppendUint64(o, (*z).StateSchemas.GlobalStateSchema.NumUint)
			}
		}
		if (zb0003Mask & 0x80) == 0 { // if not empty
			// string "lsch"
			o = append(o, 0xa4, 0x6c, 0x73, 0x63, 0x68)
			// omitempty: check for empty values
			zb0005Len := uint32(2)
			var zb0005Mask uint8 /* 3 bits */
			if (*z).StateSchemas.LocalStateSchema.NumByteSlice == 0 {
				zb0005Len--
				zb0005Mask |= 0x2
			}
			if (*z).StateSchemas.LocalStateSchema.NumUint == 0 {
				zb0005Len--
				zb0005Mask |= 0x4
			}
			// variable map header, size zb0005Len
			o = append(o, 0x80|uint8(zb0005Len))
			if (zb0005Mask & 0x2) == 0 { // if not empty
				// string "nbs"
				o = append(o, 0xa3, 0x6e, 0x62, 0x73)
				o = msgp.AppendUint64(o, (*z).StateSchemas.LocalStateSchema.NumByteSlice)
			}
			if (zb0005Mask & 0x4) == 0 { // if not empty
				// string "nui"
				o = append(o, 0xa3, 0x6e, 0x75, 0x69)
				o = msgp.AppendUint64(o, (*z).StateSchemas.LocalStateSchema.NumUint)
			}
		}
		if (zb0003Mask & 0x100) == 0 { // if not empty
			// string "v"
			o = append(o, 0xa1, 0x76)
			o = msgp.AppendUint64(o, (*z).Version)
		}
	}
	return
}

func (_ *AppParams) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*AppParams)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *AppParams) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0003 int
	var zb0004 bool
	zb0003, zb0004, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0003, zb0004, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0003 > 0 {
			zb0003--
			var zb0005 int
			zb0005, err = msgp.ReadBytesBytesHeader(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "ApprovalProgram")
				return
			}
			if zb0005 > bounds.MaxAvailableAppProgramLen {
				err = msgp.ErrOverflow(uint64(zb0005), uint64(bounds.MaxAvailableAppProgramLen))
				return
			}
			(*z).ApprovalProgram, bts, err = msgp.ReadBytesBytes(bts, (*z).ApprovalProgram)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "ApprovalProgram")
				return
			}
		}
		if zb0003 > 0 {
			zb0003--
			var zb0006 int
			zb0006, err = msgp.ReadBytesBytesHeader(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "ClearStateProgram")
				return
			}
			if zb0006 > bounds.MaxAvailableAppProgramLen {
				err = msgp.ErrOverflow(uint64(zb0006), uint64(bounds.MaxAvailableAppProgramLen))
				return
			}
			(*z).ClearStateProgram, bts, err = msgp.ReadBytesBytes(bts, (*z).ClearStateProgram)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "ClearStateProgram")
				return
			}
		}
		if zb0003 > 0 {
			zb0003--
			var zb0007 int
			var zb0008 bool
			zb0007, zb0008, bts, err = msgp.ReadMapHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "GlobalState")
				return
			}
			if zb0007 > bounds.EncodedMaxKeyValueEntries {
				err = msgp.ErrOverflow(uint64(zb0007), uint64(bounds.EncodedMaxKeyValueEntries))
				err = msgp.WrapError(err, "struct-from-array", "GlobalState")
				return
			}
			if zb0008 {
				(*z).GlobalState = nil
			} else if (*z).GlobalState == nil {
				(*z).GlobalState = make(TealKeyValue, zb0007)
			}
			for zb0007 > 0 {
				var zb0001 string
				var zb0002 TealValue
				zb0007--
				zb0001, bts, err = msgp.ReadStringBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "GlobalState")
					return
				}
				bts, err = zb0002.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "GlobalState", zb0001)
					return
				}
				(*z).GlobalState[zb0001] = zb0002
			}
		}
		if zb0003 > 0 {
			zb0003--
			var zb0009 int
			var zb0010 bool
			zb0009, zb0010, bts, err = msgp.ReadMapHeaderBytes(bts)
			if _, ok := err.(msgp.TypeError); ok {
				zb0009, zb0010, bts, err = msgp.ReadArrayHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "LocalStateSchema")
					return
				}
				if zb0009 > 0 {
					zb0009--
					(*z).StateSchemas.LocalStateSchema.NumUint, bts, err = msgp.ReadUint64Bytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "LocalStateSchema", "struct-from-array", "NumUint")
						return
					}
				}
				if zb0009 > 0 {
					zb0009--
					(*z).StateSchemas.LocalStateSchema.NumByteSlice, bts, err = msgp.ReadUint64Bytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "LocalStateSchema", "struct-from-array", "NumByteSlice")
						return
					}
				}
				if zb0009 > 0 {
					err = msgp.ErrTooManyArrayFields(zb0009)
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "LocalStateSchema", "struct-from-array")
						return
					}
				}
			} else {
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "LocalStateSchema")
					return
				}
				if zb0010 {
					(*z).StateSchemas.LocalStateSchema = StateSchema{}
				}
				for zb0009 > 0 {
					zb0009--
					field, bts, err = msgp.ReadMapKeyZC(bts)
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "LocalStateSchema")
						return
					}
					switch string(field) {
					case "nui":
						(*z).StateSchemas.LocalStateSchema.NumUint, bts, err = msgp.ReadUint64Bytes(bts)
						if err != nil {
							err = msgp.WrapError(err, "struct-from-array", "LocalStateSchema", "NumUint")
							return
						}
					case "nbs":
						(*z).StateSchemas.LocalStateSchema.NumByteSlice, bts, err = msgp.ReadUint64Bytes(bts)
						if err != nil {
							err = msgp.WrapError(err, "struct-from-array", "LocalStateSchema", "NumByteSlice")
							return
						}
					default:
						err = msgp.ErrNoField(string(field))
						if err != nil {
							err = msgp.WrapError(err, "struct-from-array", "LocalStateSchema")
							return
						}
					}
				}
			}
		}
		if zb0003 > 0 {
			zb0003--
			var zb0011 int
			var zb0012 bool
			zb0011, zb0012, bts, err = msgp.ReadMapHeaderBytes(bts)
			if _, ok := err.(msgp.TypeError); ok {
				zb0011, zb0012, bts, err = msgp.ReadArrayHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "GlobalStateSchema")
					return
				}
				if zb0011 > 0 {
					zb0011--
					(*z).StateSchemas.GlobalStateSchema.NumUint, bts, err = msgp.ReadUint64Bytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "GlobalStateSchema", "struct-from-array", "NumUint")
						return
					}
				}
				if zb0011 > 0 {
					zb0011--
					(*z).StateSchemas.GlobalStateSchema.NumByteSlice, bts, err = msgp.ReadUint64Bytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "GlobalStateSchema", "struct-from-array", "NumByteSlice")
						return
					}
				}
				if zb0011 > 0 {
					err = msgp.ErrTooManyArrayFields(zb0011)
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "GlobalStateSchema", "struct-from-array")
						return
					}
				}
			} else {
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "GlobalStateSchema")
					return
				}
				if zb0012 {
					(*z).StateSchemas.GlobalStateSchema = StateSchema{}
				}
				for zb0011 > 0 {
					zb0011--
					field, bts, err = msgp.ReadMapKeyZC(bts)
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "GlobalStateSchema")
						return
					}
					switch string(field) {
					case "nui":
						(*z).StateSchemas.GlobalStateSchema.NumUint, bts, err = msgp.ReadUint64Bytes(bts)
						if err != nil {
							err = msgp.WrapError(err, "struct-from-array", "GlobalStateSchema", "NumUint")
							return
						}
					case "nbs":
						(*z).StateSchemas.GlobalStateSchema.NumByteSlice, bts, err = msgp.ReadUint64Bytes(bts)
						if err != nil {
							err = msgp.WrapError(err, "struct-from-array", "GlobalStateSchema", "NumByteSlice")
							return
						}
					default:
						err = msgp.ErrNoField(string(field))
						if err != nil {
							err = msgp.WrapError(err, "struct-from-array", "GlobalStateSchema")
							return
						}
					}
				}
			}
		}
		if zb0003 > 0 {
			zb0003--
			(*z).ExtraProgramPages, bts, err = msgp.ReadUint32Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "ExtraProgramPages")
				return
			}
		}
		if zb0003 > 0 {
			zb0003--
			(*z).Version, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Version")
				return
			}
		}
		if zb0003 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0003)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0004 {
			(*z) = AppParams{}
		}
		for zb0003 > 0 {
			zb0003--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "approv":
				var zb0013 int
				zb0013, err = msgp.ReadBytesBytesHeader(bts)
				if err != nil {
					err = msgp.WrapError(err, "ApprovalProgram")
					return
				}
				if zb0013 > bounds.MaxAvailableAppProgramLen {
					err = msgp.ErrOverflow(uint64(zb0013), uint64(bounds.MaxAvailableAppProgramLen))
					return
				}
				(*z).ApprovalProgram, bts, err = msgp.ReadBytesBytes(bts, (*z).ApprovalProgram)
				if err != nil {
					err = msgp.WrapError(err, "ApprovalProgram")
					return
				}
			case "clearp":
				var zb0014 int
				zb0014, err = msgp.ReadBytesBytesHeader(bts)
				if err != nil {
					err = msgp.WrapError(err, "ClearStateProgram")
					return
				}
				if zb0014 > bounds.MaxAvailableAppProgramLen {
					err = msgp.ErrOverflow(uint64(zb0014), uint64(bounds.MaxAvailableAppProgramLen))
					return
				}
				(*z).ClearStateProgram, bts, err = msgp.ReadBytesBytes(bts, (*z).ClearStateProgram)
				if err != nil {
					err = msgp.WrapError(err, "ClearStateProgram")
					return
				}
			case "gs":
				var zb0015 int
				var zb0016 bool
				zb0015, zb0016, bts, err = msgp.ReadMapHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "GlobalState")
					return
				}
				if zb0015 > bounds.EncodedMaxKeyValueEntries {
					err = msgp.ErrOverflow(uint64(zb0015), uint64(bounds.EncodedMaxKeyValueEntries))
					err = msgp.WrapError(err, "GlobalState")
					return
				}
				if zb0016 {
					(*z).GlobalState = nil
				} else if (*z).GlobalState == nil {
					(*z).GlobalState = make(TealKeyValue, zb0015)
				}
				for zb0015 > 0 {
					var zb0001 string
					var zb0002 TealValue
					zb0015--
					zb0001, bts, err = msgp.ReadStringBytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "GlobalState")
						return
					}
					bts, err = zb0002.UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "GlobalState", zb0001)
						return
					}
					(*z).GlobalState[zb0001] = zb0002
				}
			case "lsch":
				var zb0017 int
				var zb0018 bool
				zb0017, zb0018, bts, err = msgp.ReadMapHeaderBytes(bts)
				if _, ok := err.(msgp.TypeError); ok {
					zb0017, zb0018, bts, err = msgp.ReadArrayHeaderBytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "LocalStateSchema")
						return
					}
					if zb0017 > 0 {
						zb0017--
						(*z).StateSchemas.LocalStateSchema.NumUint, bts, err = msgp.ReadUint64Bytes(bts)
						if err != nil {
							err = msgp.WrapError(err, "LocalStateSchema", "struct-from-array", "NumUint")
							return
						}
					}
					if zb0017 > 0 {
						zb0017--
						(*z).StateSchemas.LocalStateSchema.NumByteSlice, bts, err = msgp.ReadUint64Bytes(bts)
						if err != nil {
							err = msgp.WrapError(err, "LocalStateSchema", "struct-from-array", "NumByteSlice")
							return
						}
					}
					if zb0017 > 0 {
						err = msgp.ErrTooManyArrayFields(zb0017)
						if err != nil {
							err = msgp.WrapError(err, "LocalStateSchema", "struct-from-array")
							return
						}
					}
				} else {
					if err != nil {
						err = msgp.WrapError(err, "LocalStateSchema")
						return
					}
					if zb0018 {
						(*z).StateSchemas.LocalStateSchema = StateSchema{}
					}
					for zb0017 > 0 {
						zb0017--
						field, bts, err = msgp.ReadMapKeyZC(bts)
						if err != nil {
							err = msgp.WrapError(err, "LocalStateSchema")
							return
						}
						switch string(field) {
						case "nui":
							(*z).StateSchemas.LocalStateSchema.NumUint, bts, err = msgp.ReadUint64Bytes(bts)
							if err != nil {
								err = msgp.WrapError(err, "LocalStateSchema", "NumUint")
								return
							}
						case "nbs":
							(*z).StateSchemas.LocalStateSchema.NumByteSlice, bts, err = msgp.ReadUint64Bytes(bts)
							if err != nil {
								err = msgp.WrapError(err, "LocalStateSchema", "NumByteSlice")
								return
							}
						default:
							err = msgp.ErrNoField(string(field))
							if err != nil {
								err = msgp.WrapError(err, "LocalStateSchema")
								return
							}
						}
					}
				}
			case "gsch":
				var zb0019 int
				var zb0020 bool
				zb0019, zb0020, bts, err = msgp.ReadMapHeaderBytes(bts)
				if _, ok := err.(msgp.TypeError); ok {
					zb0019, zb0020, bts, err = msgp.ReadArrayHeaderBytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "GlobalStateSchema")
						return
					}
					if zb0019 > 0 {
						zb0019--
						(*z).StateSchemas.GlobalStateSchema.NumUint, bts, err = msgp.ReadUint64Bytes(bts)
						if err != nil {
							err = msgp.WrapError(err, "GlobalStateSchema", "struct-from-array", "NumUint")
							return
						}
					}
					if zb0019 > 0 {
						zb0019--
						(*z).StateSchemas.GlobalStateSchema.NumByteSlice, bts, err = msgp.ReadUint64Bytes(bts)
						if err != nil {
							err = msgp.WrapError(err, "GlobalStateSchema", "struct-from-array", "NumByteSlice")
							return
						}
					}
					if zb0019 > 0 {
						err = msgp.ErrTooManyArrayFields(zb0019)
						if err != nil {
							err = msgp.WrapError(err, "GlobalStateSchema", "struct-from-array")
							return
						}
					}
				} else {
					if err != nil {
						err = msgp.WrapError(err, "GlobalStateSchema")
						return
					}
					if zb0020 {
						(*z).StateSchemas.GlobalStateSchema = StateSchema{}
					}
					for zb0019 > 0 {
						zb0019--
						field, bts, err = msgp.ReadMapKeyZC(bts)
						if err != nil {
							err = msgp.WrapError(err, "GlobalStateSchema")
							return
						}
						switch string(field) {
						case "nui":
							(*z).StateSchemas.GlobalStateSchema.NumUint, bts, err = msgp.ReadUint64Bytes(bts)
							if err != nil {
								err = msgp.WrapError(err, "GlobalStateSchema", "NumUint")
								return
							}
						case "nbs":
							(*z).StateSchemas.GlobalStateSchema.NumByteSlice, bts, err = msgp.ReadUint64Bytes(bts)
							if err != nil {
								err = msgp.WrapError(err, "GlobalStateSchema", "NumByteSlice")
								return
							}
						default:
							err = msgp.ErrNoField(string(field))
							if err != nil {
								err = msgp.WrapError(err, "GlobalStateSchema")
								return
							}
						}
					}
				}
			case "epp":
				(*z).ExtraProgramPages, bts, err = msgp.ReadUint32Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "ExtraProgramPages")
					return
				}
			case "v":
				(*z).Version, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Version")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *AppParams) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *AppParams) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*AppParams)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *AppParams) Msgsize() (s int) {
	s = 1 + 7 + msgp.BytesPrefixSize + len((*z).ApprovalProgram) + 7 + msgp.BytesPrefixSize + len((*z).ClearStateProgram) + 3 + msgp.MapHeaderSize
	if (*z).GlobalState != nil {
		for zb0001, zb0002 := range (*z).GlobalState {
			_ = zb0001
			_ = zb0002
			s += 0 + msgp.StringPrefixSize + len(zb0001) + zb0002.Msgsize()
		}
	}
	s += 5 + 1 + 4 + msgp.Uint64Size + 4 + msgp.Uint64Size + 5 + 1 + 4 + msgp.Uint64Size + 4 + msgp.Uint64Size + 4 + msgp.Uint32Size + 2 + msgp.Uint64Size
	return
}

// MsgIsZero returns whether this is a zero value
func (z *AppParams) MsgIsZero() bool {
	return (len((*z).ApprovalProgram) == 0) && (len((*z).ClearStateProgram) == 0) && (len((*z).GlobalState) == 0) && (((*z).StateSchemas.LocalStateSchema.NumUint == 0) && ((*z).StateSchemas.LocalStateSchema.NumByteSlice == 0)) && (((*z).StateSchemas.GlobalStateSchema.NumUint == 0) && ((*z).StateSchemas.GlobalStateSchema.NumByteSlice == 0)) && ((*z).ExtraProgramPages == 0) && ((*z).Version == 0)
}

// MaxSize returns a maximum valid message size for this message type
func AppParamsMaxSize() (s int) {
	s = 1 + 7 + msgp.BytesPrefixSize + bounds.MaxAvailableAppProgramLen + 7 + msgp.BytesPrefixSize + bounds.MaxAvailableAppProgramLen + 3
	s += msgp.MapHeaderSize
	// Adding size of map keys for z.GlobalState
	s += bounds.EncodedMaxKeyValueEntries * (msgp.StringPrefixSize + bounds.MaxAppBytesKeyLen)
	// Adding size of map values for z.GlobalState
	s += bounds.EncodedMaxKeyValueEntries * (TealValueMaxSize())
	s += 5 + 1 + 4 + msgp.Uint64Size + 4 + msgp.Uint64Size + 5 + 1 + 4 + msgp.Uint64Size + 4 + msgp.Uint64Size + 4 + msgp.Uint32Size + 2 + msgp.Uint64Size
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *AssetHolding) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0001Len := uint32(2)
	var zb0001Mask uint8 /* 3 bits */
	if (*z).Amount == 0 {
		zb0001Len--
		zb0001Mask |= 0x2
	}
	if (*z).Frozen == false {
		zb0001Len--
		zb0001Mask |= 0x4
	}
	// variable map header, size zb0001Len
	o = append(o, 0x80|uint8(zb0001Len))
	if zb0001Len != 0 {
		if (zb0001Mask & 0x2) == 0 { // if not empty
			// string "a"
			o = append(o, 0xa1, 0x61)
			o = msgp.AppendUint64(o, (*z).Amount)
		}
		if (zb0001Mask & 0x4) == 0 { // if not empty
			// string "f"
			o = append(o, 0xa1, 0x66)
			o = msgp.AppendBool(o, (*z).Frozen)
		}
	}
	return
}

func (_ *AssetHolding) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*AssetHolding)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *AssetHolding) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0001 int
	var zb0002 bool
	zb0001, zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0001, zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0001 > 0 {
			zb0001--
			(*z).Amount, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Amount")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			(*z).Frozen, bts, err = msgp.ReadBoolBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Frozen")
				return
			}
		}
		if zb0001 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0001)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 {
			(*z) = AssetHolding{}
		}
		for zb0001 > 0 {
			zb0001--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "a":
				(*z).Amount, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Amount")
					return
				}
			case "f":
				(*z).Frozen, bts, err = msgp.ReadBoolBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Frozen")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *AssetHolding) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *AssetHolding) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*AssetHolding)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *AssetHolding) Msgsize() (s int) {
	s = 1 + 2 + msgp.Uint64Size + 2 + msgp.BoolSize
	return
}

// MsgIsZero returns whether this is a zero value
func (z *AssetHolding) MsgIsZero() bool {
	return ((*z).Amount == 0) && ((*z).Frozen == false)
}

// MaxSize returns a maximum valid message size for this message type
func AssetHoldingMaxSize() (s int) {
	s = 1 + 2 + msgp.Uint64Size + 2 + msgp.BoolSize
	return
}

// MarshalMsg implements msgp.Marshaler
func (z AssetIndex) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	o = msgp.AppendUint64(o, uint64(z))
	return
}

func (_ AssetIndex) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(AssetIndex)
	if !ok {
		_, ok = (z).(*AssetIndex)
	}
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *AssetIndex) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	{
		var zb0001 uint64
		zb0001, bts, err = msgp.ReadUint64Bytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		(*z) = AssetIndex(zb0001)
	}
	o = bts
	return
}

func (z *AssetIndex) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *AssetIndex) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*AssetIndex)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z AssetIndex) Msgsize() (s int) {
	s = msgp.Uint64Size
	return
}

// MsgIsZero returns whether this is a zero value
func (z AssetIndex) MsgIsZero() bool {
	return z == 0
}

// MaxSize returns a maximum valid message size for this message type
func AssetIndexMaxSize() (s int) {
	s = msgp.Uint64Size
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *AssetParams) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0002Len := uint32(11)
	var zb0002Mask uint16 /* 12 bits */
	if (*z).MetadataHash == ([32]byte{}) {
		zb0002Len--
		zb0002Mask |= 0x2
	}
	if (*z).AssetName == "" {
		zb0002Len--
		zb0002Mask |= 0x4
	}
	if (*z).URL == "" {
		zb0002Len--
		zb0002Mask |= 0x8
	}
	if (*z).Clawback.MsgIsZero() {
		zb0002Len--
		zb0002Mask |= 0x10
	}
	if (*z).Decimals == 0 {
		zb0002Len--
		zb0002Mask |= 0x20
	}
	if (*z).DefaultFrozen == false {
		zb0002Len--
		zb0002Mask |= 0x40
	}
	if (*z).Freeze.MsgIsZero() {
		zb0002Len--
		zb0002Mask |= 0x80
	}
	if (*z).Manager.MsgIsZero() {
		zb0002Len--
		zb0002Mask |= 0x100
	}
	if (*z).Reserve.MsgIsZero() {
		zb0002Len--
		zb0002Mask |= 0x200
	}
	if (*z).Total == 0 {
		zb0002Len--
		zb0002Mask |= 0x400
	}
	if (*z).UnitName == "" {
		zb0002Len--
		zb0002Mask |= 0x800
	}
	// variable map header, size zb0002Len
	o = append(o, 0x80|uint8(zb0002Len))
	if zb0002Len != 0 {
		if (zb0002Mask & 0x2) == 0 { // if not empty
			// string "am"
			o = append(o, 0xa2, 0x61, 0x6d)
			o = msgp.AppendBytes(o, ((*z).MetadataHash)[:])
		}
		if (zb0002Mask & 0x4) == 0 { // if not empty
			// string "an"
			o = append(o, 0xa2, 0x61, 0x6e)
			o = msgp.AppendString(o, (*z).AssetName)
		}
		if (zb0002Mask & 0x8) == 0 { // if not empty
			// string "au"
			o = append(o, 0xa2, 0x61, 0x75)
			o = msgp.AppendString(o, (*z).URL)
		}
		if (zb0002Mask & 0x10) == 0 { // if not empty
			// string "c"
			o = append(o, 0xa1, 0x63)
			o = (*z).Clawback.MarshalMsg(o)
		}
		if (zb0002Mask & 0x20) == 0 { // if not empty
			// string "dc"
			o = append(o, 0xa2, 0x64, 0x63)
			o = msgp.AppendUint32(o, (*z).Decimals)
		}
		if (zb0002Mask & 0x40) == 0 { // if not empty
			// string "df"
			o = append(o, 0xa2, 0x64, 0x66)
			o = msgp.AppendBool(o, (*z).DefaultFrozen)
		}
		if (zb0002Mask & 0x80) == 0 { // if not empty
			// string "f"
			o = append(o, 0xa1, 0x66)
			o = (*z).Freeze.MarshalMsg(o)
		}
		if (zb0002Mask & 0x100) == 0 { // if not empty
			// string "m"
			o = append(o, 0xa1, 0x6d)
			o = (*z).Manager.MarshalMsg(o)
		}
		if (zb0002Mask & 0x200) == 0 { // if not empty
			// string "r"
			o = append(o, 0xa1, 0x72)
			o = (*z).Reserve.MarshalMsg(o)
		}
		if (zb0002Mask & 0x400) == 0 { // if not empty
			// string "t"
			o = append(o, 0xa1, 0x74)
			o = msgp.AppendUint64(o, (*z).Total)
		}
		if (zb0002Mask & 0x800) == 0 { // if not empty
			// string "un"
			o = append(o, 0xa2, 0x75, 0x6e)
			o = msgp.AppendString(o, (*z).UnitName)
		}
	}
	return
}

func (_ *AssetParams) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*AssetParams)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *AssetParams) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0002 int
	var zb0003 bool
	zb0002, zb0003, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0002, zb0003, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 > 0 {
			zb0002--
			(*z).Total, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Total")
				return
			}
		}
		if zb0002 > 0 {
			zb0002--
			(*z).Decimals, bts, err = msgp.ReadUint32Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Decimals")
				return
			}
		}
		if zb0002 > 0 {
			zb0002--
			(*z).DefaultFrozen, bts, err = msgp.ReadBoolBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "DefaultFrozen")
				return
			}
		}
		if zb0002 > 0 {
			zb0002--
			var zb0004 int
			zb0004, err = msgp.ReadBytesBytesHeader(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "UnitName")
				return
			}
			if zb0004 > bounds.MaxAssetUnitNameBytes {
				err = msgp.ErrOverflow(uint64(zb0004), uint64(bounds.MaxAssetUnitNameBytes))
				return
			}
			(*z).UnitName, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "UnitName")
				return
			}
		}
		if zb0002 > 0 {
			zb0002--
			var zb0005 int
			zb0005, err = msgp.ReadBytesBytesHeader(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "AssetName")
				return
			}
			if zb0005 > bounds.MaxAssetNameBytes {
				err = msgp.ErrOverflow(uint64(zb0005), uint64(bounds.MaxAssetNameBytes))
				return
			}
			(*z).AssetName, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "AssetName")
				return
			}
		}
		if zb0002 > 0 {
			zb0002--
			var zb0006 int
			zb0006, err = msgp.ReadBytesBytesHeader(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "URL")
				return
			}
			if zb0006 > bounds.MaxAssetURLBytes {
				err = msgp.ErrOverflow(uint64(zb0006), uint64(bounds.MaxAssetURLBytes))
				return
			}
			(*z).URL, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "URL")
				return
			}
		}
		if zb0002 > 0 {
			zb0002--
			bts, err = msgp.ReadExactBytes(bts, ((*z).MetadataHash)[:])
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "MetadataHash")
				return
			}
		}
		if zb0002 > 0 {
			zb0002--
			bts, err = (*z).Manager.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Manager")
				return
			}
		}
		if zb0002 > 0 {
			zb0002--
			bts, err = (*z).Reserve.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Reserve")
				return
			}
		}
		if zb0002 > 0 {
			zb0002--
			bts, err = (*z).Freeze.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Freeze")
				return
			}
		}
		if zb0002 > 0 {
			zb0002--
			bts, err = (*z).Clawback.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Clawback")
				return
			}
		}
		if zb0002 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0002)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0003 {
			(*z) = AssetParams{}
		}
		for zb0002 > 0 {
			zb0002--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "t":
				(*z).Total, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Total")
					return
				}
			case "dc":
				(*z).Decimals, bts, err = msgp.ReadUint32Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Decimals")
					return
				}
			case "df":
				(*z).DefaultFrozen, bts, err = msgp.ReadBoolBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "DefaultFrozen")
					return
				}
			case "un":
				var zb0007 int
				zb0007, err = msgp.ReadBytesBytesHeader(bts)
				if err != nil {
					err = msgp.WrapError(err, "UnitName")
					return
				}
				if zb0007 > bounds.MaxAssetUnitNameBytes {
					err = msgp.ErrOverflow(uint64(zb0007), uint64(bounds.MaxAssetUnitNameBytes))
					return
				}
				(*z).UnitName, bts, err = msgp.ReadStringBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "UnitName")
					return
				}
			case "an":
				var zb0008 int
				zb0008, err = msgp.ReadBytesBytesHeader(bts)
				if err != nil {
					err = msgp.WrapError(err, "AssetName")
					return
				}
				if zb0008 > bounds.MaxAssetNameBytes {
					err = msgp.ErrOverflow(uint64(zb0008), uint64(bounds.MaxAssetNameBytes))
					return
				}
				(*z).AssetName, bts, err = msgp.ReadStringBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "AssetName")
					return
				}
			case "au":
				var zb0009 int
				zb0009, err = msgp.ReadBytesBytesHeader(bts)
				if err != nil {
					err = msgp.WrapError(err, "URL")
					return
				}
				if zb0009 > bounds.MaxAssetURLBytes {
					err = msgp.ErrOverflow(uint64(zb0009), uint64(bounds.MaxAssetURLBytes))
					return
				}
				(*z).URL, bts, err = msgp.ReadStringBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "URL")
					return
				}
			case "am":
				bts, err = msgp.ReadExactBytes(bts, ((*z).MetadataHash)[:])
				if err != nil {
					err = msgp.WrapError(err, "MetadataHash")
					return
				}
			case "m":
				bts, err = (*z).Manager.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Manager")
					return
				}
			case "r":
				bts, err = (*z).Reserve.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Reserve")
					return
				}
			case "f":
				bts, err = (*z).Freeze.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Freeze")
					return
				}
			case "c":
				bts, err = (*z).Clawback.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Clawback")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *AssetParams) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *AssetParams) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*AssetParams)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *AssetParams) Msgsize() (s int) {
	s = 1 + 2 + msgp.Uint64Size + 3 + msgp.Uint32Size + 3 + msgp.BoolSize + 3 + msgp.StringPrefixSize + len((*z).UnitName) + 3 + msgp.StringPrefixSize + len((*z).AssetName) + 3 + msgp.StringPrefixSize + len((*z).URL) + 3 + msgp.ArrayHeaderSize + (32 * (msgp.ByteSize)) + 2 + (*z).Manager.Msgsize() + 2 + (*z).Reserve.Msgsize() + 2 + (*z).Freeze.Msgsize() + 2 + (*z).Clawback.Msgsize()
	return
}

// MsgIsZero returns whether this is a zero value
func (z *AssetParams) MsgIsZero() bool {
	return ((*z).Total == 0) && ((*z).Decimals == 0) && ((*z).DefaultFrozen == false) && ((*z).UnitName == "") && ((*z).AssetName == "") && ((*z).URL == "") && ((*z).MetadataHash == ([32]byte{})) && ((*z).Manager.MsgIsZero()) && ((*z).Reserve.MsgIsZero()) && ((*z).Freeze.MsgIsZero()) && ((*z).Clawback.MsgIsZero())
}

// MaxSize returns a maximum valid message size for this message type
func AssetParamsMaxSize() (s int) {
	s = 1 + 2 + msgp.Uint64Size + 3 + msgp.Uint32Size + 3 + msgp.BoolSize + 3 + msgp.StringPrefixSize + bounds.MaxAssetUnitNameBytes + 3 + msgp.StringPrefixSize + bounds.MaxAssetNameBytes + 3 + msgp.StringPrefixSize + bounds.MaxAssetURLBytes + 3
	// Calculating size of array: z.MetadataHash
	s += msgp.ArrayHeaderSize + ((32) * (msgp.ByteSize))
	s += 2 + AddressMaxSize() + 2 + AddressMaxSize() + 2 + AddressMaxSize() + 2 + AddressMaxSize()
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *BalanceRecord) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0009Len := uint32(23)
	var zb0009Mask uint32 /* 25 bits */
	if (*z).Addr.MsgIsZero() {
		zb0009Len--
		zb0009Mask |= 0x4
	}
	if (*z).AccountData.MicroAlgos.MsgIsZero() {
		zb0009Len--
		zb0009Mask |= 0x8
	}
	if len((*z).AccountData.AssetParams) == 0 {
		zb0009Len--
		zb0009Mask |= 0x10
	}
	if len((*z).AccountData.AppLocalStates) == 0 {
		zb0009Len--
		zb0009Mask |= 0x20
	}
	if len((*z).AccountData.AppParams) == 0 {
		zb0009Len--
		zb0009Mask |= 0x40
	}
	if len((*z).AccountData.Assets) == 0 {
		zb0009Len--
		zb0009Mask |= 0x80
	}
	if (*z).AccountData.RewardsBase == 0 {
		zb0009Len--
		zb0009Mask |= 0x100
	}
	if (*z).AccountData.RewardedMicroAlgos.MsgIsZero() {
		zb0009Len--
		zb0009Mask |= 0x200
	}
	if (*z).AccountData.IncentiveEligible == false {
		zb0009Len--
		zb0009Mask |= 0x400
	}
	if (*z).AccountData.LastHeartbeat == 0 {
		zb0009Len--
		zb0009Mask |= 0x800
	}
	if (*z).AccountData.LastProposed == 0 {
		zb0009Len--
		zb0009Mask |= 0x1000
	}
	if (*z).AccountData.Status == 0 {
		zb0009Len--
		zb0009Mask |= 0x2000
	}
	if (*z).AccountData.SelectionID.MsgIsZero() {
		zb0009Len--
		zb0009Mask |= 0x4000
	}
	if (*z).AccountData.AuthAddr.MsgIsZero() {
		zb0009Len--
		zb0009Mask |= 0x8000
	}
	if (*z).AccountData.StateProofID.MsgIsZero() {
		zb0009Len--
		zb0009Mask |= 0x10000
	}
	if (*z).AccountData.TotalBoxes == 0 {
		zb0009Len--
		zb0009Mask |= 0x20000
	}
	if (*z).AccountData.TotalBoxBytes == 0 {
		zb0009Len--
		zb0009Mask |= 0x40000
	}
	if (*z).AccountData.TotalExtraAppPages == 0 {
		zb0009Len--
		zb0009Mask |= 0x80000
	}
	if ((*z).AccountData.TotalAppSchema.NumUint == 0) && ((*z).AccountData.TotalAppSchema.NumByteSlice == 0) {
		zb0009Len--
		zb0009Mask |= 0x100000
	}
	if (*z).AccountData.VoteID.MsgIsZero() {
		zb0009Len--
		zb0009Mask |= 0x200000
	}
	if (*z).AccountData.VoteFirstValid == 0 {
		zb0009Len--
		zb0009Mask |= 0x400000
	}
	if (*z).AccountData.VoteKeyDilution == 0 {
		zb0009Len--
		zb0009Mask |= 0x800000
	}
	if (*z).AccountData.VoteLastValid == 0 {
		zb0009Len--
		zb0009Mask |= 0x1000000
	}
	// variable map header, size zb0009Len
	o = msgp.AppendMapHeader(o, zb0009Len)
	if zb0009Len != 0 {
		if (zb0009Mask & 0x4) == 0 { // if not empty
			// string "addr"
			o = append(o, 0xa4, 0x61, 0x64, 0x64, 0x72)
			o = (*z).Addr.MarshalMsg(o)
		}
		if (zb0009Mask & 0x8) == 0 { // if not empty
			// string "algo"
			o = append(o, 0xa4, 0x61, 0x6c, 0x67, 0x6f)
			o = (*z).AccountData.MicroAlgos.MarshalMsg(o)
		}
		if (zb0009Mask & 0x10) == 0 { // if not empty
			// string "apar"
			o = append(o, 0xa4, 0x61, 0x70, 0x61, 0x72)
			if (*z).AccountData.AssetParams == nil {
				o = msgp.AppendNil(o)
			} else {
				o = msgp.AppendMapHeader(o, uint32(len((*z).AccountData.AssetParams)))
			}
			zb0001_keys := make([]AssetIndex, 0, len((*z).AccountData.AssetParams))
			for zb0001 := range (*z).AccountData.AssetParams {
				zb0001_keys = append(zb0001_keys, zb0001)
			}
			sort.Sort(SortAssetIndex(zb0001_keys))
			for _, zb0001 := range zb0001_keys {
				zb0002 := (*z).AccountData.AssetParams[zb0001]
				_ = zb0002
				o = zb0001.MarshalMsg(o)
				o = zb0002.MarshalMsg(o)
			}
		}
		if (zb0009Mask & 0x20) == 0 { // if not empty
			// string "appl"
			o = append(o, 0xa4, 0x61, 0x70, 0x70, 0x6c)
			if (*z).AccountData.AppLocalStates == nil {
				o = msgp.AppendNil(o)
			} else {
				o = msgp.AppendMapHeader(o, uint32(len((*z).AccountData.AppLocalStates)))
			}
			zb0005_keys := make([]AppIndex, 0, len((*z).AccountData.AppLocalStates))
			for zb0005 := range (*z).AccountData.AppLocalStates {
				zb0005_keys = append(zb0005_keys, zb0005)
			}
			sort.Sort(SortAppIndex(zb0005_keys))
			for _, zb0005 := range zb0005_keys {
				zb0006 := (*z).AccountData.AppLocalStates[zb0005]
				_ = zb0006
				o = zb0005.MarshalMsg(o)
				o = zb0006.MarshalMsg(o)
			}
		}
		if (zb0009Mask & 0x40) == 0 { // if not empty
			// string "appp"
			o = append(o, 0xa4, 0x61, 0x70, 0x70, 0x70)
			if (*z).AccountData.AppParams == nil {
				o = msgp.AppendNil(o)
			} else {
				o = msgp.AppendMapHeader(o, uint32(len((*z).AccountData.AppParams)))
			}
			zb0007_keys := make([]AppIndex, 0, len((*z).AccountData.AppParams))
			for zb0007 := range (*z).AccountData.AppParams {
				zb0007_keys = append(zb0007_keys, zb0007)
			}
			sort.Sort(SortAppIndex(zb0007_keys))
			for _, zb0007 := range zb0007_keys {
				zb0008 := (*z).AccountData.AppParams[zb0007]
				_ = zb0008
				o = zb0007.MarshalMsg(o)
				o = zb0008.MarshalMsg(o)
			}
		}
		if (zb0009Mask & 0x80) == 0 { // if not empty
			// string "asset"
			o = append(o, 0xa5, 0x61, 0x73, 0x73, 0x65, 0x74)
			if (*z).AccountData.Assets == nil {
				o = msgp.AppendNil(o)
			} else {
				o = msgp.AppendMapHeader(o, uint32(len((*z).AccountData.Assets)))
			}
			zb0003_keys := make([]AssetIndex, 0, len((*z).AccountData.Assets))
			for zb0003 := range (*z).AccountData.Assets {
				zb0003_keys = append(zb0003_keys, zb0003)
			}
			sort.Sort(SortAssetIndex(zb0003_keys))
			for _, zb0003 := range zb0003_keys {
				zb0004 := (*z).AccountData.Assets[zb0003]
				_ = zb0004
				o = zb0003.MarshalMsg(o)
				// omitempty: check for empty values
				zb0010Len := uint32(2)
				var zb0010Mask uint8 /* 3 bits */
				if zb0004.Amount == 0 {
					zb0010Len--
					zb0010Mask |= 0x2
				}
				if zb0004.Frozen == false {
					zb0010Len--
					zb0010Mask |= 0x4
				}
				// variable map header, size zb0010Len
				o = append(o, 0x80|uint8(zb0010Len))
				if zb0010Len != 0 {
					if (zb0010Mask & 0x2) == 0 { // if not empty
						// string "a"
						o = append(o, 0xa1, 0x61)
						o = msgp.AppendUint64(o, zb0004.Amount)
					}
					if (zb0010Mask & 0x4) == 0 { // if not empty
						// string "f"
						o = append(o, 0xa1, 0x66)
						o = msgp.AppendBool(o, zb0004.Frozen)
					}
				}
			}
		}
		if (zb0009Mask & 0x100) == 0 { // if not empty
			// string "ebase"
			o = append(o, 0xa5, 0x65, 0x62, 0x61, 0x73, 0x65)
			o = msgp.AppendUint64(o, (*z).AccountData.RewardsBase)
		}
		if (zb0009Mask & 0x200) == 0 { // if not empty
			// string "ern"
			o = append(o, 0xa3, 0x65, 0x72, 0x6e)
			o = (*z).AccountData.RewardedMicroAlgos.MarshalMsg(o)
		}
		if (zb0009Mask & 0x400) == 0 { // if not empty
			// string "ie"
			o = append(o, 0xa2, 0x69, 0x65)
			o = msgp.AppendBool(o, (*z).AccountData.IncentiveEligible)
		}
		if (zb0009Mask & 0x800) == 0 { // if not empty
			// string "lhb"
			o = append(o, 0xa3, 0x6c, 0x68, 0x62)
			o = msgp.AppendUint64(o, uint64((*z).AccountData.LastHeartbeat))
		}
		if (zb0009Mask & 0x1000) == 0 { // if not empty
			// string "lpr"
			o = append(o, 0xa3, 0x6c, 0x70, 0x72)
			o = msgp.AppendUint64(o, uint64((*z).AccountData.LastProposed))
		}
		if (zb0009Mask & 0x2000) == 0 { // if not empty
			// string "onl"
			o = append(o, 0xa3, 0x6f, 0x6e, 0x6c)
			o = msgp.AppendByte(o, byte((*z).AccountData.Status))
		}
		if (zb0009Mask & 0x4000) == 0 { // if not empty
			// string "sel"
			o = append(o, 0xa3, 0x73, 0x65, 0x6c)
			o = (*z).AccountData.SelectionID.MarshalMsg(o)
		}
		if (zb0009Mask & 0x8000) == 0 { // if not empty
			// string "spend"
			o = append(o, 0xa5, 0x73, 0x70, 0x65, 0x6e, 0x64)
			o = (*z).AccountData.AuthAddr.MarshalMsg(o)
		}
		if (zb0009Mask & 0x10000) == 0 { // if not empty
			// string "stprf"
			o = append(o, 0xa5, 0x73, 0x74, 0x70, 0x72, 0x66)
			o = (*z).AccountData.StateProofID.MarshalMsg(o)
		}
		if (zb0009Mask & 0x20000) == 0 { // if not empty
			// string "tbx"
			o = append(o, 0xa3, 0x74, 0x62, 0x78)
			o = msgp.AppendUint64(o, (*z).AccountData.TotalBoxes)
		}
		if (zb0009Mask & 0x40000) == 0 { // if not empty
			// string "tbxb"
			o = append(o, 0xa4, 0x74, 0x62, 0x78, 0x62)
			o = msgp.AppendUint64(o, (*z).AccountData.TotalBoxBytes)
		}
		if (zb0009Mask & 0x80000) == 0 { // if not empty
			// string "teap"
			o = append(o, 0xa4, 0x74, 0x65, 0x61, 0x70)
			o = msgp.AppendUint32(o, (*z).AccountData.TotalExtraAppPages)
		}
		if (zb0009Mask & 0x100000) == 0 { // if not empty
			// string "tsch"
			o = append(o, 0xa4, 0x74, 0x73, 0x63, 0x68)
			// omitempty: check for empty values
			zb0011Len := uint32(2)
			var zb0011Mask uint8 /* 3 bits */
			if (*z).AccountData.TotalAppSchema.NumByteSlice == 0 {
				zb0011Len--
				zb0011Mask |= 0x2
			}
			if (*z).AccountData.TotalAppSchema.NumUint == 0 {
				zb0011Len--
				zb0011Mask |= 0x4
			}
			// variable map header, size zb0011Len
			o = append(o, 0x80|uint8(zb0011Len))
			if (zb0011Mask & 0x2) == 0 { // if not empty
				// string "nbs"
				o = append(o, 0xa3, 0x6e, 0x62, 0x73)
				o = msgp.AppendUint64(o, (*z).AccountData.TotalAppSchema.NumByteSlice)
			}
			if (zb0011Mask & 0x4) == 0 { // if not empty
				// string "nui"
				o = append(o, 0xa3, 0x6e, 0x75, 0x69)
				o = msgp.AppendUint64(o, (*z).AccountData.TotalAppSchema.NumUint)
			}
		}
		if (zb0009Mask & 0x200000) == 0 { // if not empty
			// string "vote"
			o = append(o, 0xa4, 0x76, 0x6f, 0x74, 0x65)
			o = (*z).AccountData.VoteID.MarshalMsg(o)
		}
		if (zb0009Mask & 0x400000) == 0 { // if not empty
			// string "voteFst"
			o = append(o, 0xa7, 0x76, 0x6f, 0x74, 0x65, 0x46, 0x73, 0x74)
			o = msgp.AppendUint64(o, uint64((*z).AccountData.VoteFirstValid))
		}
		if (zb0009Mask & 0x800000) == 0 { // if not empty
			// string "voteKD"
			o = append(o, 0xa6, 0x76, 0x6f, 0x74, 0x65, 0x4b, 0x44)
			o = msgp.AppendUint64(o, (*z).AccountData.VoteKeyDilution)
		}
		if (zb0009Mask & 0x1000000) == 0 { // if not empty
			// string "voteLst"
			o = append(o, 0xa7, 0x76, 0x6f, 0x74, 0x65, 0x4c, 0x73, 0x74)
			o = msgp.AppendUint64(o, uint64((*z).AccountData.VoteLastValid))
		}
	}
	return
}

func (_ *BalanceRecord) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*BalanceRecord)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *BalanceRecord) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0009 int
	var zb0010 bool
	zb0009, zb0010, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0009, zb0010, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0009 > 0 {
			zb0009--
			bts, err = (*z).Addr.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Addr")
				return
			}
		}
		if zb0009 > 0 {
			zb0009--
			{
				var zb0011 byte
				zb0011, bts, err = msgp.ReadByteBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Status")
					return
				}
				(*z).AccountData.Status = Status(zb0011)
			}
		}
		if zb0009 > 0 {
			zb0009--
			bts, err = (*z).AccountData.MicroAlgos.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "MicroAlgos")
				return
			}
		}
		if zb0009 > 0 {
			zb0009--
			(*z).AccountData.RewardsBase, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "RewardsBase")
				return
			}
		}
		if zb0009 > 0 {
			zb0009--
			bts, err = (*z).AccountData.RewardedMicroAlgos.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "RewardedMicroAlgos")
				return
			}
		}
		if zb0009 > 0 {
			zb0009--
			bts, err = (*z).AccountData.VoteID.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "VoteID")
				return
			}
		}
		if zb0009 > 0 {
			zb0009--
			bts, err = (*z).AccountData.SelectionID.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "SelectionID")
				return
			}
		}
		if zb0009 > 0 {
			zb0009--
			bts, err = (*z).AccountData.StateProofID.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "StateProofID")
				return
			}
		}
		if zb0009 > 0 {
			zb0009--
			{
				var zb0012 uint64
				zb0012, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "VoteFirstValid")
					return
				}
				(*z).AccountData.VoteFirstValid = Round(zb0012)
			}
		}
		if zb0009 > 0 {
			zb0009--
			{
				var zb0013 uint64
				zb0013, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "VoteLastValid")
					return
				}
				(*z).AccountData.VoteLastValid = Round(zb0013)
			}
		}
		if zb0009 > 0 {
			zb0009--
			(*z).AccountData.VoteKeyDilution, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "VoteKeyDilution")
				return
			}
		}
		if zb0009 > 0 {
			zb0009--
			{
				var zb0014 uint64
				zb0014, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "LastProposed")
					return
				}
				(*z).AccountData.LastProposed = Round(zb0014)
			}
		}
		if zb0009 > 0 {
			zb0009--
			{
				var zb0015 uint64
				zb0015, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "LastHeartbeat")
					return
				}
				(*z).AccountData.LastHeartbeat = Round(zb0015)
			}
		}
		if zb0009 > 0 {
			zb0009--
			var zb0016 int
			var zb0017 bool
			zb0016, zb0017, bts, err = msgp.ReadMapHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "AssetParams")
				return
			}
			if zb0016 > bounds.EncodedMaxAssetsPerAccount {
				err = msgp.ErrOverflow(uint64(zb0016), uint64(bounds.EncodedMaxAssetsPerAccount))
				err = msgp.WrapError(err, "struct-from-array", "AssetParams")
				return
			}
			if zb0017 {
				(*z).AccountData.AssetParams = nil
			} else if (*z).AccountData.AssetParams == nil {
				(*z).AccountData.AssetParams = make(map[AssetIndex]AssetParams, zb0016)
			}
			for zb0016 > 0 {
				var zb0001 AssetIndex
				var zb0002 AssetParams
				zb0016--
				bts, err = zb0001.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "AssetParams")
					return
				}
				bts, err = zb0002.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "AssetParams", zb0001)
					return
				}
				(*z).AccountData.AssetParams[zb0001] = zb0002
			}
		}
		if zb0009 > 0 {
			zb0009--
			var zb0018 int
			var zb0019 bool
			zb0018, zb0019, bts, err = msgp.ReadMapHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Assets")
				return
			}
			if zb0018 > bounds.EncodedMaxAssetsPerAccount {
				err = msgp.ErrOverflow(uint64(zb0018), uint64(bounds.EncodedMaxAssetsPerAccount))
				err = msgp.WrapError(err, "struct-from-array", "Assets")
				return
			}
			if zb0019 {
				(*z).AccountData.Assets = nil
			} else if (*z).AccountData.Assets == nil {
				(*z).AccountData.Assets = make(map[AssetIndex]AssetHolding, zb0018)
			}
			for zb0018 > 0 {
				var zb0003 AssetIndex
				var zb0004 AssetHolding
				zb0018--
				bts, err = zb0003.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Assets")
					return
				}
				var zb0020 int
				var zb0021 bool
				zb0020, zb0021, bts, err = msgp.ReadMapHeaderBytes(bts)
				if _, ok := err.(msgp.TypeError); ok {
					zb0020, zb0021, bts, err = msgp.ReadArrayHeaderBytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "Assets", zb0003)
						return
					}
					if zb0020 > 0 {
						zb0020--
						zb0004.Amount, bts, err = msgp.ReadUint64Bytes(bts)
						if err != nil {
							err = msgp.WrapError(err, "struct-from-array", "Assets", zb0003, "struct-from-array", "Amount")
							return
						}
					}
					if zb0020 > 0 {
						zb0020--
						zb0004.Frozen, bts, err = msgp.ReadBoolBytes(bts)
						if err != nil {
							err = msgp.WrapError(err, "struct-from-array", "Assets", zb0003, "struct-from-array", "Frozen")
							return
						}
					}
					if zb0020 > 0 {
						err = msgp.ErrTooManyArrayFields(zb0020)
						if err != nil {
							err = msgp.WrapError(err, "struct-from-array", "Assets", zb0003, "struct-from-array")
							return
						}
					}
				} else {
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "Assets", zb0003)
						return
					}
					if zb0021 {
						zb0004 = AssetHolding{}
					}
					for zb0020 > 0 {
						zb0020--
						field, bts, err = msgp.ReadMapKeyZC(bts)
						if err != nil {
							err = msgp.WrapError(err, "struct-from-array", "Assets", zb0003)
							return
						}
						switch string(field) {
						case "a":
							zb0004.Amount, bts, err = msgp.ReadUint64Bytes(bts)
							if err != nil {
								err = msgp.WrapError(err, "struct-from-array", "Assets", zb0003, "Amount")
								return
							}
						case "f":
							zb0004.Frozen, bts, err = msgp.ReadBoolBytes(bts)
							if err != nil {
								err = msgp.WrapError(err, "struct-from-array", "Assets", zb0003, "Frozen")
								return
							}
						default:
							err = msgp.ErrNoField(string(field))
							if err != nil {
								err = msgp.WrapError(err, "struct-from-array", "Assets", zb0003)
								return
							}
						}
					}
				}
				(*z).AccountData.Assets[zb0003] = zb0004
			}
		}
		if zb0009 > 0 {
			zb0009--
			bts, err = (*z).AccountData.AuthAddr.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "AuthAddr")
				return
			}
		}
		if zb0009 > 0 {
			zb0009--
			(*z).AccountData.IncentiveEligible, bts, err = msgp.ReadBoolBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "IncentiveEligible")
				return
			}
		}
		if zb0009 > 0 {
			zb0009--
			var zb0022 int
			var zb0023 bool
			zb0022, zb0023, bts, err = msgp.ReadMapHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "AppLocalStates")
				return
			}
			if zb0022 > bounds.EncodedMaxAppLocalStates {
				err = msgp.ErrOverflow(uint64(zb0022), uint64(bounds.EncodedMaxAppLocalStates))
				err = msgp.WrapError(err, "struct-from-array", "AppLocalStates")
				return
			}
			if zb0023 {
				(*z).AccountData.AppLocalStates = nil
			} else if (*z).AccountData.AppLocalStates == nil {
				(*z).AccountData.AppLocalStates = make(map[AppIndex]AppLocalState, zb0022)
			}
			for zb0022 > 0 {
				var zb0005 AppIndex
				var zb0006 AppLocalState
				zb0022--
				bts, err = zb0005.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "AppLocalStates")
					return
				}
				bts, err = zb0006.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "AppLocalStates", zb0005)
					return
				}
				(*z).AccountData.AppLocalStates[zb0005] = zb0006
			}
		}
		if zb0009 > 0 {
			zb0009--
			var zb0024 int
			var zb0025 bool
			zb0024, zb0025, bts, err = msgp.ReadMapHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "AppParams")
				return
			}
			if zb0024 > bounds.EncodedMaxAppParams {
				err = msgp.ErrOverflow(uint64(zb0024), uint64(bounds.EncodedMaxAppParams))
				err = msgp.WrapError(err, "struct-from-array", "AppParams")
				return
			}
			if zb0025 {
				(*z).AccountData.AppParams = nil
			} else if (*z).AccountData.AppParams == nil {
				(*z).AccountData.AppParams = make(map[AppIndex]AppParams, zb0024)
			}
			for zb0024 > 0 {
				var zb0007 AppIndex
				var zb0008 AppParams
				zb0024--
				bts, err = zb0007.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "AppParams")
					return
				}
				bts, err = zb0008.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "AppParams", zb0007)
					return
				}
				(*z).AccountData.AppParams[zb0007] = zb0008
			}
		}
		if zb0009 > 0 {
			zb0009--
			var zb0026 int
			var zb0027 bool
			zb0026, zb0027, bts, err = msgp.ReadMapHeaderBytes(bts)
			if _, ok := err.(msgp.TypeError); ok {
				zb0026, zb0027, bts, err = msgp.ReadArrayHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "TotalAppSchema")
					return
				}
				if zb0026 > 0 {
					zb0026--
					(*z).AccountData.TotalAppSchema.NumUint, bts, err = msgp.ReadUint64Bytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "TotalAppSchema", "struct-from-array", "NumUint")
						return
					}
				}
				if zb0026 > 0 {
					zb0026--
					(*z).AccountData.TotalAppSchema.NumByteSlice, bts, err = msgp.ReadUint64Bytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "TotalAppSchema", "struct-from-array", "NumByteSlice")
						return
					}
				}
				if zb0026 > 0 {
					err = msgp.ErrTooManyArrayFields(zb0026)
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "TotalAppSchema", "struct-from-array")
						return
					}
				}
			} else {
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "TotalAppSchema")
					return
				}
				if zb0027 {
					(*z).AccountData.TotalAppSchema = StateSchema{}
				}
				for zb0026 > 0 {
					zb0026--
					field, bts, err = msgp.ReadMapKeyZC(bts)
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "TotalAppSchema")
						return
					}
					switch string(field) {
					case "nui":
						(*z).AccountData.TotalAppSchema.NumUint, bts, err = msgp.ReadUint64Bytes(bts)
						if err != nil {
							err = msgp.WrapError(err, "struct-from-array", "TotalAppSchema", "NumUint")
							return
						}
					case "nbs":
						(*z).AccountData.TotalAppSchema.NumByteSlice, bts, err = msgp.ReadUint64Bytes(bts)
						if err != nil {
							err = msgp.WrapError(err, "struct-from-array", "TotalAppSchema", "NumByteSlice")
							return
						}
					default:
						err = msgp.ErrNoField(string(field))
						if err != nil {
							err = msgp.WrapError(err, "struct-from-array", "TotalAppSchema")
							return
						}
					}
				}
			}
		}
		if zb0009 > 0 {
			zb0009--
			(*z).AccountData.TotalExtraAppPages, bts, err = msgp.ReadUint32Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "TotalExtraAppPages")
				return
			}
		}
		if zb0009 > 0 {
			zb0009--
			(*z).AccountData.TotalBoxes, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "TotalBoxes")
				return
			}
		}
		if zb0009 > 0 {
			zb0009--
			(*z).AccountData.TotalBoxBytes, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "TotalBoxBytes")
				return
			}
		}
		if zb0009 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0009)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0010 {
			(*z) = BalanceRecord{}
		}
		for zb0009 > 0 {
			zb0009--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "addr":
				bts, err = (*z).Addr.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Addr")
					return
				}
			case "onl":
				{
					var zb0028 byte
					zb0028, bts, err = msgp.ReadByteBytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "Status")
						return
					}
					(*z).AccountData.Status = Status(zb0028)
				}
			case "algo":
				bts, err = (*z).AccountData.MicroAlgos.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "MicroAlgos")
					return
				}
			case "ebase":
				(*z).AccountData.RewardsBase, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "RewardsBase")
					return
				}
			case "ern":
				bts, err = (*z).AccountData.RewardedMicroAlgos.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "RewardedMicroAlgos")
					return
				}
			case "vote":
				bts, err = (*z).AccountData.VoteID.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "VoteID")
					return
				}
			case "sel":
				bts, err = (*z).AccountData.SelectionID.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "SelectionID")
					return
				}
			case "stprf":
				bts, err = (*z).AccountData.StateProofID.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "StateProofID")
					return
				}
			case "voteFst":
				{
					var zb0029 uint64
					zb0029, bts, err = msgp.ReadUint64Bytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "VoteFirstValid")
						return
					}
					(*z).AccountData.VoteFirstValid = Round(zb0029)
				}
			case "voteLst":
				{
					var zb0030 uint64
					zb0030, bts, err = msgp.ReadUint64Bytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "VoteLastValid")
						return
					}
					(*z).AccountData.VoteLastValid = Round(zb0030)
				}
			case "voteKD":
				(*z).AccountData.VoteKeyDilution, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "VoteKeyDilution")
					return
				}
			case "lpr":
				{
					var zb0031 uint64
					zb0031, bts, err = msgp.ReadUint64Bytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "LastProposed")
						return
					}
					(*z).AccountData.LastProposed = Round(zb0031)
				}
			case "lhb":
				{
					var zb0032 uint64
					zb0032, bts, err = msgp.ReadUint64Bytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "LastHeartbeat")
						return
					}
					(*z).AccountData.LastHeartbeat = Round(zb0032)
				}
			case "apar":
				var zb0033 int
				var zb0034 bool
				zb0033, zb0034, bts, err = msgp.ReadMapHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "AssetParams")
					return
				}
				if zb0033 > bounds.EncodedMaxAssetsPerAccount {
					err = msgp.ErrOverflow(uint64(zb0033), uint64(bounds.EncodedMaxAssetsPerAccount))
					err = msgp.WrapError(err, "AssetParams")
					return
				}
				if zb0034 {
					(*z).AccountData.AssetParams = nil
				} else if (*z).AccountData.AssetParams == nil {
					(*z).AccountData.AssetParams = make(map[AssetIndex]AssetParams, zb0033)
				}
				for zb0033 > 0 {
					var zb0001 AssetIndex
					var zb0002 AssetParams
					zb0033--
					bts, err = zb0001.UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "AssetParams")
						return
					}
					bts, err = zb0002.UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "AssetParams", zb0001)
						return
					}
					(*z).AccountData.AssetParams[zb0001] = zb0002
				}
			case "asset":
				var zb0035 int
				var zb0036 bool
				zb0035, zb0036, bts, err = msgp.ReadMapHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Assets")
					return
				}
				if zb0035 > bounds.EncodedMaxAssetsPerAccount {
					err = msgp.ErrOverflow(uint64(zb0035), uint64(bounds.EncodedMaxAssetsPerAccount))
					err = msgp.WrapError(err, "Assets")
					return
				}
				if zb0036 {
					(*z).AccountData.Assets = nil
				} else if (*z).AccountData.Assets == nil {
					(*z).AccountData.Assets = make(map[AssetIndex]AssetHolding, zb0035)
				}
				for zb0035 > 0 {
					var zb0003 AssetIndex
					var zb0004 AssetHolding
					zb0035--
					bts, err = zb0003.UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "Assets")
						return
					}
					var zb0037 int
					var zb0038 bool
					zb0037, zb0038, bts, err = msgp.ReadMapHeaderBytes(bts)
					if _, ok := err.(msgp.TypeError); ok {
						zb0037, zb0038, bts, err = msgp.ReadArrayHeaderBytes(bts)
						if err != nil {
							err = msgp.WrapError(err, "Assets", zb0003)
							return
						}
						if zb0037 > 0 {
							zb0037--
							zb0004.Amount, bts, err = msgp.ReadUint64Bytes(bts)
							if err != nil {
								err = msgp.WrapError(err, "Assets", zb0003, "struct-from-array", "Amount")
								return
							}
						}
						if zb0037 > 0 {
							zb0037--
							zb0004.Frozen, bts, err = msgp.ReadBoolBytes(bts)
							if err != nil {
								err = msgp.WrapError(err, "Assets", zb0003, "struct-from-array", "Frozen")
								return
							}
						}
						if zb0037 > 0 {
							err = msgp.ErrTooManyArrayFields(zb0037)
							if err != nil {
								err = msgp.WrapError(err, "Assets", zb0003, "struct-from-array")
								return
							}
						}
					} else {
						if err != nil {
							err = msgp.WrapError(err, "Assets", zb0003)
							return
						}
						if zb0038 {
							zb0004 = AssetHolding{}
						}
						for zb0037 > 0 {
							zb0037--
							field, bts, err = msgp.ReadMapKeyZC(bts)
							if err != nil {
								err = msgp.WrapError(err, "Assets", zb0003)
								return
							}
							switch string(field) {
							case "a":
								zb0004.Amount, bts, err = msgp.ReadUint64Bytes(bts)
								if err != nil {
									err = msgp.WrapError(err, "Assets", zb0003, "Amount")
									return
								}
							case "f":
								zb0004.Frozen, bts, err = msgp.ReadBoolBytes(bts)
								if err != nil {
									err = msgp.WrapError(err, "Assets", zb0003, "Frozen")
									return
								}
							default:
								err = msgp.ErrNoField(string(field))
								if err != nil {
									err = msgp.WrapError(err, "Assets", zb0003)
									return
								}
							}
						}
					}
					(*z).AccountData.Assets[zb0003] = zb0004
				}
			case "spend":
				bts, err = (*z).AccountData.AuthAddr.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "AuthAddr")
					return
				}
			case "ie":
				(*z).AccountData.IncentiveEligible, bts, err = msgp.ReadBoolBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "IncentiveEligible")
					return
				}
			case "appl":
				var zb0039 int
				var zb0040 bool
				zb0039, zb0040, bts, err = msgp.ReadMapHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "AppLocalStates")
					return
				}
				if zb0039 > bounds.EncodedMaxAppLocalStates {
					err = msgp.ErrOverflow(uint64(zb0039), uint64(bounds.EncodedMaxAppLocalStates))
					err = msgp.WrapError(err, "AppLocalStates")
					return
				}
				if zb0040 {
					(*z).AccountData.AppLocalStates = nil
				} else if (*z).AccountData.AppLocalStates == nil {
					(*z).AccountData.AppLocalStates = make(map[AppIndex]AppLocalState, zb0039)
				}
				for zb0039 > 0 {
					var zb0005 AppIndex
					var zb0006 AppLocalState
					zb0039--
					bts, err = zb0005.UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "AppLocalStates")
						return
					}
					bts, err = zb0006.UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "AppLocalStates", zb0005)
						return
					}
					(*z).AccountData.AppLocalStates[zb0005] = zb0006
				}
			case "appp":
				var zb0041 int
				var zb0042 bool
				zb0041, zb0042, bts, err = msgp.ReadMapHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "AppParams")
					return
				}
				if zb0041 > bounds.EncodedMaxAppParams {
					err = msgp.ErrOverflow(uint64(zb0041), uint64(bounds.EncodedMaxAppParams))
					err = msgp.WrapError(err, "AppParams")
					return
				}
				if zb0042 {
					(*z).AccountData.AppParams = nil
				} else if (*z).AccountData.AppParams == nil {
					(*z).AccountData.AppParams = make(map[AppIndex]AppParams, zb0041)
				}
				for zb0041 > 0 {
					var zb0007 AppIndex
					var zb0008 AppParams
					zb0041--
					bts, err = zb0007.UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "AppParams")
						return
					}
					bts, err = zb0008.UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "AppParams", zb0007)
						return
					}
					(*z).AccountData.AppParams[zb0007] = zb0008
				}
			case "tsch":
				var zb0043 int
				var zb0044 bool
				zb0043, zb0044, bts, err = msgp.ReadMapHeaderBytes(bts)
				if _, ok := err.(msgp.TypeError); ok {
					zb0043, zb0044, bts, err = msgp.ReadArrayHeaderBytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "TotalAppSchema")
						return
					}
					if zb0043 > 0 {
						zb0043--
						(*z).AccountData.TotalAppSchema.NumUint, bts, err = msgp.ReadUint64Bytes(bts)
						if err != nil {
							err = msgp.WrapError(err, "TotalAppSchema", "struct-from-array", "NumUint")
							return
						}
					}
					if zb0043 > 0 {
						zb0043--
						(*z).AccountData.TotalAppSchema.NumByteSlice, bts, err = msgp.ReadUint64Bytes(bts)
						if err != nil {
							err = msgp.WrapError(err, "TotalAppSchema", "struct-from-array", "NumByteSlice")
							return
						}
					}
					if zb0043 > 0 {
						err = msgp.ErrTooManyArrayFields(zb0043)
						if err != nil {
							err = msgp.WrapError(err, "TotalAppSchema", "struct-from-array")
							return
						}
					}
				} else {
					if err != nil {
						err = msgp.WrapError(err, "TotalAppSchema")
						return
					}
					if zb0044 {
						(*z).AccountData.TotalAppSchema = StateSchema{}
					}
					for zb0043 > 0 {
						zb0043--
						field, bts, err = msgp.ReadMapKeyZC(bts)
						if err != nil {
							err = msgp.WrapError(err, "TotalAppSchema")
							return
						}
						switch string(field) {
						case "nui":
							(*z).AccountData.TotalAppSchema.NumUint, bts, err = msgp.ReadUint64Bytes(bts)
							if err != nil {
								err = msgp.WrapError(err, "TotalAppSchema", "NumUint")
								return
							}
						case "nbs":
							(*z).AccountData.TotalAppSchema.NumByteSlice, bts, err = msgp.ReadUint64Bytes(bts)
							if err != nil {
								err = msgp.WrapError(err, "TotalAppSchema", "NumByteSlice")
								return
							}
						default:
							err = msgp.ErrNoField(string(field))
							if err != nil {
								err = msgp.WrapError(err, "TotalAppSchema")
								return
							}
						}
					}
				}
			case "teap":
				(*z).AccountData.TotalExtraAppPages, bts, err = msgp.ReadUint32Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "TotalExtraAppPages")
					return
				}
			case "tbx":
				(*z).AccountData.TotalBoxes, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "TotalBoxes")
					return
				}
			case "tbxb":
				(*z).AccountData.TotalBoxBytes, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "TotalBoxBytes")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *BalanceRecord) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *BalanceRecord) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*BalanceRecord)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *BalanceRecord) Msgsize() (s int) {
	s = 3 + 5 + (*z).Addr.Msgsize() + 4 + msgp.ByteSize + 5 + (*z).AccountData.MicroAlgos.Msgsize() + 6 + msgp.Uint64Size + 4 + (*z).AccountData.RewardedMicroAlgos.Msgsize() + 5 + (*z).AccountData.VoteID.Msgsize() + 4 + (*z).AccountData.SelectionID.Msgsize() + 6 + (*z).AccountData.StateProofID.Msgsize() + 8 + msgp.Uint64Size + 8 + msgp.Uint64Size + 7 + msgp.Uint64Size + 4 + msgp.Uint64Size + 4 + msgp.Uint64Size + 5 + msgp.MapHeaderSize
	if (*z).AccountData.AssetParams != nil {
		for zb0001, zb0002 := range (*z).AccountData.AssetParams {
			_ = zb0001
			_ = zb0002
			s += 0 + zb0001.Msgsize() + zb0002.Msgsize()
		}
	}
	s += 6 + msgp.MapHeaderSize
	if (*z).AccountData.Assets != nil {
		for zb0003, zb0004 := range (*z).AccountData.Assets {
			_ = zb0003
			_ = zb0004
			s += 0 + zb0003.Msgsize() + 1 + 2 + msgp.Uint64Size + 2 + msgp.BoolSize
		}
	}
	s += 6 + (*z).AccountData.AuthAddr.Msgsize() + 3 + msgp.BoolSize + 5 + msgp.MapHeaderSize
	if (*z).AccountData.AppLocalStates != nil {
		for zb0005, zb0006 := range (*z).AccountData.AppLocalStates {
			_ = zb0005
			_ = zb0006
			s += 0 + zb0005.Msgsize() + zb0006.Msgsize()
		}
	}
	s += 5 + msgp.MapHeaderSize
	if (*z).AccountData.AppParams != nil {
		for zb0007, zb0008 := range (*z).AccountData.AppParams {
			_ = zb0007
			_ = zb0008
			s += 0 + zb0007.Msgsize() + zb0008.Msgsize()
		}
	}
	s += 5 + 1 + 4 + msgp.Uint64Size + 4 + msgp.Uint64Size + 5 + msgp.Uint32Size + 4 + msgp.Uint64Size + 5 + msgp.Uint64Size
	return
}

// MsgIsZero returns whether this is a zero value
func (z *BalanceRecord) MsgIsZero() bool {
	return ((*z).Addr.MsgIsZero()) && ((*z).AccountData.Status == 0) && ((*z).AccountData.MicroAlgos.MsgIsZero()) && ((*z).AccountData.RewardsBase == 0) && ((*z).AccountData.RewardedMicroAlgos.MsgIsZero()) && ((*z).AccountData.VoteID.MsgIsZero()) && ((*z).AccountData.SelectionID.MsgIsZero()) && ((*z).AccountData.StateProofID.MsgIsZero()) && ((*z).AccountData.VoteFirstValid == 0) && ((*z).AccountData.VoteLastValid == 0) && ((*z).AccountData.VoteKeyDilution == 0) && ((*z).AccountData.LastProposed == 0) && ((*z).AccountData.LastHeartbeat == 0) && (len((*z).AccountData.AssetParams) == 0) && (len((*z).AccountData.Assets) == 0) && ((*z).AccountData.AuthAddr.MsgIsZero()) && ((*z).AccountData.IncentiveEligible == false) && (len((*z).AccountData.AppLocalStates) == 0) && (len((*z).AccountData.AppParams) == 0) && (((*z).AccountData.TotalAppSchema.NumUint == 0) && ((*z).AccountData.TotalAppSchema.NumByteSlice == 0)) && ((*z).AccountData.TotalExtraAppPages == 0) && ((*z).AccountData.TotalBoxes == 0) && ((*z).AccountData.TotalBoxBytes == 0)
}

// MaxSize returns a maximum valid message size for this message type
func BalanceRecordMaxSize() (s int) {
	s = 3 + 5 + AddressMaxSize() + 4 + msgp.ByteSize + 5 + MicroAlgosMaxSize() + 6 + msgp.Uint64Size + 4 + MicroAlgosMaxSize() + 5 + crypto.OneTimeSignatureVerifierMaxSize() + 4 + crypto.VRFVerifierMaxSize() + 6 + merklesignature.CommitmentMaxSize() + 8 + msgp.Uint64Size + 8 + msgp.Uint64Size + 7 + msgp.Uint64Size + 4 + msgp.Uint64Size + 4 + msgp.Uint64Size + 5
	s += msgp.MapHeaderSize
	// Adding size of map keys for z.AccountData.AssetParams
	s += bounds.EncodedMaxAssetsPerAccount * (AssetIndexMaxSize())
	// Adding size of map values for z.AccountData.AssetParams
	s += bounds.EncodedMaxAssetsPerAccount * (AssetParamsMaxSize())
	s += 6
	s += msgp.MapHeaderSize
	// Adding size of map keys for z.AccountData.Assets
	s += bounds.EncodedMaxAssetsPerAccount * (AssetIndexMaxSize())
	// Adding size of map values for z.AccountData.Assets
	s += bounds.EncodedMaxAssetsPerAccount * (1)
	s += 2 + msgp.Uint64Size + 2 + msgp.BoolSize
	s += 6 + AddressMaxSize() + 3 + msgp.BoolSize + 5
	s += msgp.MapHeaderSize
	// Adding size of map keys for z.AccountData.AppLocalStates
	s += bounds.EncodedMaxAppLocalStates * (AppIndexMaxSize())
	// Adding size of map values for z.AccountData.AppLocalStates
	s += bounds.EncodedMaxAppLocalStates * (AppLocalStateMaxSize())
	s += 5
	s += msgp.MapHeaderSize
	// Adding size of map keys for z.AccountData.AppParams
	s += bounds.EncodedMaxAppParams * (AppIndexMaxSize())
	// Adding size of map values for z.AccountData.AppParams
	s += bounds.EncodedMaxAppParams * (AppParamsMaxSize())
	s += 5 + 1 + 4 + msgp.Uint64Size + 4 + msgp.Uint64Size + 5 + msgp.Uint32Size + 4 + msgp.Uint64Size + 5 + msgp.Uint64Size
	return
}

// MarshalMsg implements msgp.Marshaler
func (z CreatableIndex) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	o = msgp.AppendUint64(o, uint64(z))
	return
}

func (_ CreatableIndex) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(CreatableIndex)
	if !ok {
		_, ok = (z).(*CreatableIndex)
	}
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *CreatableIndex) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	{
		var zb0001 uint64
		zb0001, bts, err = msgp.ReadUint64Bytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		(*z) = CreatableIndex(zb0001)
	}
	o = bts
	return
}

func (z *CreatableIndex) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *CreatableIndex) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*CreatableIndex)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z CreatableIndex) Msgsize() (s int) {
	s = msgp.Uint64Size
	return
}

// MsgIsZero returns whether this is a zero value
func (z CreatableIndex) MsgIsZero() bool {
	return z == 0
}

// MaxSize returns a maximum valid message size for this message type
func CreatableIndexMaxSize() (s int) {
	s = msgp.Uint64Size
	return
}

// MarshalMsg implements msgp.Marshaler
func (z CreatableType) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	o = msgp.AppendUint64(o, uint64(z))
	return
}

func (_ CreatableType) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(CreatableType)
	if !ok {
		_, ok = (z).(*CreatableType)
	}
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *CreatableType) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	{
		var zb0001 uint64
		zb0001, bts, err = msgp.ReadUint64Bytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		(*z) = CreatableType(zb0001)
	}
	o = bts
	return
}

func (z *CreatableType) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *CreatableType) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*CreatableType)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z CreatableType) Msgsize() (s int) {
	s = msgp.Uint64Size
	return
}

// MsgIsZero returns whether this is a zero value
func (z CreatableType) MsgIsZero() bool {
	return z == 0
}

// MaxSize returns a maximum valid message size for this message type
func CreatableTypeMaxSize() (s int) {
	s = msgp.Uint64Size
	return
}

// MarshalMsg implements msgp.Marshaler
func (z DeltaAction) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	o = msgp.AppendUint64(o, uint64(z))
	return
}

func (_ DeltaAction) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(DeltaAction)
	if !ok {
		_, ok = (z).(*DeltaAction)
	}
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *DeltaAction) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	{
		var zb0001 uint64
		zb0001, bts, err = msgp.ReadUint64Bytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		(*z) = DeltaAction(zb0001)
	}
	o = bts
	return
}

func (z *DeltaAction) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *DeltaAction) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*DeltaAction)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z DeltaAction) Msgsize() (s int) {
	s = msgp.Uint64Size
	return
}

// MsgIsZero returns whether this is a zero value
func (z DeltaAction) MsgIsZero() bool {
	return z == 0
}

// MaxSize returns a maximum valid message size for this message type
func DeltaActionMaxSize() (s int) {
	s = msgp.Uint64Size
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *Participant) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0001Len := uint32(2)
	var zb0001Mask uint8 /* 3 bits */
	if (*z).PK.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x2
	}
	if (*z).Weight == 0 {
		zb0001Len--
		zb0001Mask |= 0x4
	}
	// variable map header, size zb0001Len
	o = append(o, 0x80|uint8(zb0001Len))
	if zb0001Len != 0 {
		if (zb0001Mask & 0x2) == 0 { // if not empty
			// string "p"
			o = append(o, 0xa1, 0x70)
			o = (*z).PK.MarshalMsg(o)
		}
		if (zb0001Mask & 0x4) == 0 { // if not empty
			// string "w"
			o = append(o, 0xa1, 0x77)
			o = msgp.AppendUint64(o, (*z).Weight)
		}
	}
	return
}

func (_ *Participant) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*Participant)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *Participant) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0001 int
	var zb0002 bool
	zb0001, zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0001, zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).PK.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "PK")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			(*z).Weight, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Weight")
				return
			}
		}
		if zb0001 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0001)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 {
			(*z) = Participant{}
		}
		for zb0001 > 0 {
			zb0001--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "p":
				bts, err = (*z).PK.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "PK")
					return
				}
			case "w":
				(*z).Weight, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Weight")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *Participant) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *Participant) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*Participant)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *Participant) Msgsize() (s int) {
	s = 1 + 2 + (*z).PK.Msgsize() + 2 + msgp.Uint64Size
	return
}

// MsgIsZero returns whether this is a zero value
func (z *Participant) MsgIsZero() bool {
	return ((*z).PK.MsgIsZero()) && ((*z).Weight == 0)
}

// MaxSize returns a maximum valid message size for this message type
func ParticipantMaxSize() (s int) {
	s = 1 + 2 + merklesignature.VerifierMaxSize() + 2 + msgp.Uint64Size
	return
}

// MarshalMsg implements msgp.Marshaler
func (z Round) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	o = msgp.AppendUint64(o, uint64(z))
	return
}

func (_ Round) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(Round)
	if !ok {
		_, ok = (z).(*Round)
	}
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *Round) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	{
		var zb0001 uint64
		zb0001, bts, err = msgp.ReadUint64Bytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		(*z) = Round(zb0001)
	}
	o = bts
	return
}

func (z *Round) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *Round) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*Round)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z Round) Msgsize() (s int) {
	s = msgp.Uint64Size
	return
}

// MsgIsZero returns whether this is a zero value
func (z Round) MsgIsZero() bool {
	return z == 0
}

// MaxSize returns a maximum valid message size for this message type
func RoundMaxSize() (s int) {
	s = msgp.Uint64Size
	return
}

// MarshalMsg implements msgp.Marshaler
func (z RoundInterval) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	o = msgp.AppendUint64(o, uint64(z))
	return
}

func (_ RoundInterval) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(RoundInterval)
	if !ok {
		_, ok = (z).(*RoundInterval)
	}
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *RoundInterval) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	{
		var zb0001 uint64
		zb0001, bts, err = msgp.ReadUint64Bytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		(*z) = RoundInterval(zb0001)
	}
	o = bts
	return
}

func (z *RoundInterval) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *RoundInterval) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*RoundInterval)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z RoundInterval) Msgsize() (s int) {
	s = msgp.Uint64Size
	return
}

// MsgIsZero returns whether this is a zero value
func (z RoundInterval) MsgIsZero() bool {
	return z == 0
}

// MaxSize returns a maximum valid message size for this message type
func RoundIntervalMaxSize() (s int) {
	s = msgp.Uint64Size
	return
}

// MarshalMsg implements msgp.Marshaler
func (z StateDelta) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	if z == nil {
		o = msgp.AppendNil(o)
	} else {
		o = msgp.AppendMapHeader(o, uint32(len(z)))
	}
	za0001_keys := make([]string, 0, len(z))
	for za0001 := range z {
		za0001_keys = append(za0001_keys, za0001)
	}
	sort.Sort(SortString(za0001_keys))
	for _, za0001 := range za0001_keys {
		za0002 := z[za0001]
		_ = za0002
		o = msgp.AppendString(o, za0001)
		o = za0002.MarshalMsg(o)
	}
	return
}

func (_ StateDelta) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(StateDelta)
	if !ok {
		_, ok = (z).(*StateDelta)
	}
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *StateDelta) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var zb0003 int
	var zb0004 bool
	zb0003, zb0004, bts, err = msgp.ReadMapHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	if zb0003 > bounds.MaxStateDeltaKeys {
		err = msgp.ErrOverflow(uint64(zb0003), uint64(bounds.MaxStateDeltaKeys))
		err = msgp.WrapError(err)
		return
	}
	if zb0004 {
		(*z) = nil
	} else if (*z) == nil {
		(*z) = make(StateDelta, zb0003)
	}
	for zb0003 > 0 {
		var zb0001 string
		var zb0002 ValueDelta
		zb0003--
		zb0001, bts, err = msgp.ReadStringBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		bts, err = zb0002.UnmarshalMsgWithState(bts, st)
		if err != nil {
			err = msgp.WrapError(err, zb0001)
			return
		}
		(*z)[zb0001] = zb0002
	}
	o = bts
	return
}

func (z *StateDelta) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *StateDelta) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*StateDelta)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z StateDelta) Msgsize() (s int) {
	s = msgp.MapHeaderSize
	if z != nil {
		for za0001, za0002 := range z {
			_ = za0001
			_ = za0002
			s += 0 + msgp.StringPrefixSize + len(za0001) + za0002.Msgsize()
		}
	}
	return
}

// MsgIsZero returns whether this is a zero value
func (z StateDelta) MsgIsZero() bool {
	return len(z) == 0
}

// MaxSize returns a maximum valid message size for this message type
func StateDeltaMaxSize() (s int) {
	s += msgp.MapHeaderSize
	// Adding size of map keys for z
	s += bounds.MaxStateDeltaKeys * (msgp.StringPrefixSize + bounds.MaxAppBytesKeyLen)
	// Adding size of map values for z
	s += bounds.MaxStateDeltaKeys * (ValueDeltaMaxSize())
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *StateSchema) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0001Len := uint32(2)
	var zb0001Mask uint8 /* 3 bits */
	if (*z).NumByteSlice == 0 {
		zb0001Len--
		zb0001Mask |= 0x2
	}
	if (*z).NumUint == 0 {
		zb0001Len--
		zb0001Mask |= 0x4
	}
	// variable map header, size zb0001Len
	o = append(o, 0x80|uint8(zb0001Len))
	if zb0001Len != 0 {
		if (zb0001Mask & 0x2) == 0 { // if not empty
			// string "nbs"
			o = append(o, 0xa3, 0x6e, 0x62, 0x73)
			o = msgp.AppendUint64(o, (*z).NumByteSlice)
		}
		if (zb0001Mask & 0x4) == 0 { // if not empty
			// string "nui"
			o = append(o, 0xa3, 0x6e, 0x75, 0x69)
			o = msgp.AppendUint64(o, (*z).NumUint)
		}
	}
	return
}

func (_ *StateSchema) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*StateSchema)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *StateSchema) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0001 int
	var zb0002 bool
	zb0001, zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0001, zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0001 > 0 {
			zb0001--
			(*z).NumUint, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "NumUint")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			(*z).NumByteSlice, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "NumByteSlice")
				return
			}
		}
		if zb0001 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0001)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 {
			(*z) = StateSchema{}
		}
		for zb0001 > 0 {
			zb0001--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "nui":
				(*z).NumUint, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "NumUint")
					return
				}
			case "nbs":
				(*z).NumByteSlice, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "NumByteSlice")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *StateSchema) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *StateSchema) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*StateSchema)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *StateSchema) Msgsize() (s int) {
	s = 1 + 4 + msgp.Uint64Size + 4 + msgp.Uint64Size
	return
}

// MsgIsZero returns whether this is a zero value
func (z *StateSchema) MsgIsZero() bool {
	return ((*z).NumUint == 0) && ((*z).NumByteSlice == 0)
}

// MaxSize returns a maximum valid message size for this message type
func StateSchemaMaxSize() (s int) {
	s = 1 + 4 + msgp.Uint64Size + 4 + msgp.Uint64Size
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *StateSchemas) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0001Len := uint32(2)
	var zb0001Mask uint8 /* 3 bits */
	if ((*z).GlobalStateSchema.NumUint == 0) && ((*z).GlobalStateSchema.NumByteSlice == 0) {
		zb0001Len--
		zb0001Mask |= 0x2
	}
	if ((*z).LocalStateSchema.NumUint == 0) && ((*z).LocalStateSchema.NumByteSlice == 0) {
		zb0001Len--
		zb0001Mask |= 0x4
	}
	// variable map header, size zb0001Len
	o = append(o, 0x80|uint8(zb0001Len))
	if zb0001Len != 0 {
		if (zb0001Mask & 0x2) == 0 { // if not empty
			// string "gsch"
			o = append(o, 0xa4, 0x67, 0x73, 0x63, 0x68)
			// omitempty: check for empty values
			zb0002Len := uint32(2)
			var zb0002Mask uint8 /* 3 bits */
			if (*z).GlobalStateSchema.NumByteSlice == 0 {
				zb0002Len--
				zb0002Mask |= 0x2
			}
			if (*z).GlobalStateSchema.NumUint == 0 {
				zb0002Len--
				zb0002Mask |= 0x4
			}
			// variable map header, size zb0002Len
			o = append(o, 0x80|uint8(zb0002Len))
			if (zb0002Mask & 0x2) == 0 { // if not empty
				// string "nbs"
				o = append(o, 0xa3, 0x6e, 0x62, 0x73)
				o = msgp.AppendUint64(o, (*z).GlobalStateSchema.NumByteSlice)
			}
			if (zb0002Mask & 0x4) == 0 { // if not empty
				// string "nui"
				o = append(o, 0xa3, 0x6e, 0x75, 0x69)
				o = msgp.AppendUint64(o, (*z).GlobalStateSchema.NumUint)
			}
		}
		if (zb0001Mask & 0x4) == 0 { // if not empty
			// string "lsch"
			o = append(o, 0xa4, 0x6c, 0x73, 0x63, 0x68)
			// omitempty: check for empty values
			zb0003Len := uint32(2)
			var zb0003Mask uint8 /* 3 bits */
			if (*z).LocalStateSchema.NumByteSlice == 0 {
				zb0003Len--
				zb0003Mask |= 0x2
			}
			if (*z).LocalStateSchema.NumUint == 0 {
				zb0003Len--
				zb0003Mask |= 0x4
			}
			// variable map header, size zb0003Len
			o = append(o, 0x80|uint8(zb0003Len))
			if (zb0003Mask & 0x2) == 0 { // if not empty
				// string "nbs"
				o = append(o, 0xa3, 0x6e, 0x62, 0x73)
				o = msgp.AppendUint64(o, (*z).LocalStateSchema.NumByteSlice)
			}
			if (zb0003Mask & 0x4) == 0 { // if not empty
				// string "nui"
				o = append(o, 0xa3, 0x6e, 0x75, 0x69)
				o = msgp.AppendUint64(o, (*z).LocalStateSchema.NumUint)
			}
		}
	}
	return
}

func (_ *StateSchemas) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*StateSchemas)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *StateSchemas) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0001 int
	var zb0002 bool
	zb0001, zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0001, zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0001 > 0 {
			zb0001--
			var zb0003 int
			var zb0004 bool
			zb0003, zb0004, bts, err = msgp.ReadMapHeaderBytes(bts)
			if _, ok := err.(msgp.TypeError); ok {
				zb0003, zb0004, bts, err = msgp.ReadArrayHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "LocalStateSchema")
					return
				}
				if zb0003 > 0 {
					zb0003--
					(*z).LocalStateSchema.NumUint, bts, err = msgp.ReadUint64Bytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "LocalStateSchema", "struct-from-array", "NumUint")
						return
					}
				}
				if zb0003 > 0 {
					zb0003--
					(*z).LocalStateSchema.NumByteSlice, bts, err = msgp.ReadUint64Bytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "LocalStateSchema", "struct-from-array", "NumByteSlice")
						return
					}
				}
				if zb0003 > 0 {
					err = msgp.ErrTooManyArrayFields(zb0003)
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "LocalStateSchema", "struct-from-array")
						return
					}
				}
			} else {
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "LocalStateSchema")
					return
				}
				if zb0004 {
					(*z).LocalStateSchema = StateSchema{}
				}
				for zb0003 > 0 {
					zb0003--
					field, bts, err = msgp.ReadMapKeyZC(bts)
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "LocalStateSchema")
						return
					}
					switch string(field) {
					case "nui":
						(*z).LocalStateSchema.NumUint, bts, err = msgp.ReadUint64Bytes(bts)
						if err != nil {
							err = msgp.WrapError(err, "struct-from-array", "LocalStateSchema", "NumUint")
							return
						}
					case "nbs":
						(*z).LocalStateSchema.NumByteSlice, bts, err = msgp.ReadUint64Bytes(bts)
						if err != nil {
							err = msgp.WrapError(err, "struct-from-array", "LocalStateSchema", "NumByteSlice")
							return
						}
					default:
						err = msgp.ErrNoField(string(field))
						if err != nil {
							err = msgp.WrapError(err, "struct-from-array", "LocalStateSchema")
							return
						}
					}
				}
			}
		}
		if zb0001 > 0 {
			zb0001--
			var zb0005 int
			var zb0006 bool
			zb0005, zb0006, bts, err = msgp.ReadMapHeaderBytes(bts)
			if _, ok := err.(msgp.TypeError); ok {
				zb0005, zb0006, bts, err = msgp.ReadArrayHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "GlobalStateSchema")
					return
				}
				if zb0005 > 0 {
					zb0005--
					(*z).GlobalStateSchema.NumUint, bts, err = msgp.ReadUint64Bytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "GlobalStateSchema", "struct-from-array", "NumUint")
						return
					}
				}
				if zb0005 > 0 {
					zb0005--
					(*z).GlobalStateSchema.NumByteSlice, bts, err = msgp.ReadUint64Bytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "GlobalStateSchema", "struct-from-array", "NumByteSlice")
						return
					}
				}
				if zb0005 > 0 {
					err = msgp.ErrTooManyArrayFields(zb0005)
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "GlobalStateSchema", "struct-from-array")
						return
					}
				}
			} else {
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "GlobalStateSchema")
					return
				}
				if zb0006 {
					(*z).GlobalStateSchema = StateSchema{}
				}
				for zb0005 > 0 {
					zb0005--
					field, bts, err = msgp.ReadMapKeyZC(bts)
					if err != nil {
						err = msgp.WrapError(err, "struct-from-array", "GlobalStateSchema")
						return
					}
					switch string(field) {
					case "nui":
						(*z).GlobalStateSchema.NumUint, bts, err = msgp.ReadUint64Bytes(bts)
						if err != nil {
							err = msgp.WrapError(err, "struct-from-array", "GlobalStateSchema", "NumUint")
							return
						}
					case "nbs":
						(*z).GlobalStateSchema.NumByteSlice, bts, err = msgp.ReadUint64Bytes(bts)
						if err != nil {
							err = msgp.WrapError(err, "struct-from-array", "GlobalStateSchema", "NumByteSlice")
							return
						}
					default:
						err = msgp.ErrNoField(string(field))
						if err != nil {
							err = msgp.WrapError(err, "struct-from-array", "GlobalStateSchema")
							return
						}
					}
				}
			}
		}
		if zb0001 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0001)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 {
			(*z) = StateSchemas{}
		}
		for zb0001 > 0 {
			zb0001--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "lsch":
				var zb0007 int
				var zb0008 bool
				zb0007, zb0008, bts, err = msgp.ReadMapHeaderBytes(bts)
				if _, ok := err.(msgp.TypeError); ok {
					zb0007, zb0008, bts, err = msgp.ReadArrayHeaderBytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "LocalStateSchema")
						return
					}
					if zb0007 > 0 {
						zb0007--
						(*z).LocalStateSchema.NumUint, bts, err = msgp.ReadUint64Bytes(bts)
						if err != nil {
							err = msgp.WrapError(err, "LocalStateSchema", "struct-from-array", "NumUint")
							return
						}
					}
					if zb0007 > 0 {
						zb0007--
						(*z).LocalStateSchema.NumByteSlice, bts, err = msgp.ReadUint64Bytes(bts)
						if err != nil {
							err = msgp.WrapError(err, "LocalStateSchema", "struct-from-array", "NumByteSlice")
							return
						}
					}
					if zb0007 > 0 {
						err = msgp.ErrTooManyArrayFields(zb0007)
						if err != nil {
							err = msgp.WrapError(err, "LocalStateSchema", "struct-from-array")
							return
						}
					}
				} else {
					if err != nil {
						err = msgp.WrapError(err, "LocalStateSchema")
						return
					}
					if zb0008 {
						(*z).LocalStateSchema = StateSchema{}
					}
					for zb0007 > 0 {
						zb0007--
						field, bts, err = msgp.ReadMapKeyZC(bts)
						if err != nil {
							err = msgp.WrapError(err, "LocalStateSchema")
							return
						}
						switch string(field) {
						case "nui":
							(*z).LocalStateSchema.NumUint, bts, err = msgp.ReadUint64Bytes(bts)
							if err != nil {
								err = msgp.WrapError(err, "LocalStateSchema", "NumUint")
								return
							}
						case "nbs":
							(*z).LocalStateSchema.NumByteSlice, bts, err = msgp.ReadUint64Bytes(bts)
							if err != nil {
								err = msgp.WrapError(err, "LocalStateSchema", "NumByteSlice")
								return
							}
						default:
							err = msgp.ErrNoField(string(field))
							if err != nil {
								err = msgp.WrapError(err, "LocalStateSchema")
								return
							}
						}
					}
				}
			case "gsch":
				var zb0009 int
				var zb0010 bool
				zb0009, zb0010, bts, err = msgp.ReadMapHeaderBytes(bts)
				if _, ok := err.(msgp.TypeError); ok {
					zb0009, zb0010, bts, err = msgp.ReadArrayHeaderBytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "GlobalStateSchema")
						return
					}
					if zb0009 > 0 {
						zb0009--
						(*z).GlobalStateSchema.NumUint, bts, err = msgp.ReadUint64Bytes(bts)
						if err != nil {
							err = msgp.WrapError(err, "GlobalStateSchema", "struct-from-array", "NumUint")
							return
						}
					}
					if zb0009 > 0 {
						zb0009--
						(*z).GlobalStateSchema.NumByteSlice, bts, err = msgp.ReadUint64Bytes(bts)
						if err != nil {
							err = msgp.WrapError(err, "GlobalStateSchema", "struct-from-array", "NumByteSlice")
							return
						}
					}
					if zb0009 > 0 {
						err = msgp.ErrTooManyArrayFields(zb0009)
						if err != nil {
							err = msgp.WrapError(err, "GlobalStateSchema", "struct-from-array")
							return
						}
					}
				} else {
					if err != nil {
						err = msgp.WrapError(err, "GlobalStateSchema")
						return
					}
					if zb0010 {
						(*z).GlobalStateSchema = StateSchema{}
					}
					for zb0009 > 0 {
						zb0009--
						field, bts, err = msgp.ReadMapKeyZC(bts)
						if err != nil {
							err = msgp.WrapError(err, "GlobalStateSchema")
							return
						}
						switch string(field) {
						case "nui":
							(*z).GlobalStateSchema.NumUint, bts, err = msgp.ReadUint64Bytes(bts)
							if err != nil {
								err = msgp.WrapError(err, "GlobalStateSchema", "NumUint")
								return
							}
						case "nbs":
							(*z).GlobalStateSchema.NumByteSlice, bts, err = msgp.ReadUint64Bytes(bts)
							if err != nil {
								err = msgp.WrapError(err, "GlobalStateSchema", "NumByteSlice")
								return
							}
						default:
							err = msgp.ErrNoField(string(field))
							if err != nil {
								err = msgp.WrapError(err, "GlobalStateSchema")
								return
							}
						}
					}
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *StateSchemas) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *StateSchemas) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*StateSchemas)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *StateSchemas) Msgsize() (s int) {
	s = 1 + 5 + 1 + 4 + msgp.Uint64Size + 4 + msgp.Uint64Size + 5 + 1 + 4 + msgp.Uint64Size + 4 + msgp.Uint64Size
	return
}

// MsgIsZero returns whether this is a zero value
func (z *StateSchemas) MsgIsZero() bool {
	return (((*z).LocalStateSchema.NumUint == 0) && ((*z).LocalStateSchema.NumByteSlice == 0)) && (((*z).GlobalStateSchema.NumUint == 0) && ((*z).GlobalStateSchema.NumByteSlice == 0))
}

// MaxSize returns a maximum valid message size for this message type
func StateSchemasMaxSize() (s int) {
	s = 1 + 5 + 1 + 4 + msgp.Uint64Size + 4 + msgp.Uint64Size + 5 + 1 + 4 + msgp.Uint64Size + 4 + msgp.Uint64Size
	return
}

// MarshalMsg implements msgp.Marshaler
func (z Status) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	o = msgp.AppendByte(o, byte(z))
	return
}

func (_ Status) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(Status)
	if !ok {
		_, ok = (z).(*Status)
	}
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *Status) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	{
		var zb0001 byte
		zb0001, bts, err = msgp.ReadByteBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		(*z) = Status(zb0001)
	}
	o = bts
	return
}

func (z *Status) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *Status) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*Status)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z Status) Msgsize() (s int) {
	s = msgp.ByteSize
	return
}

// MsgIsZero returns whether this is a zero value
func (z Status) MsgIsZero() bool {
	return z == 0
}

// MaxSize returns a maximum valid message size for this message type
func StatusMaxSize() (s int) {
	s = msgp.ByteSize
	return
}

// MarshalMsg implements msgp.Marshaler
func (z TealKeyValue) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	if z == nil {
		o = msgp.AppendNil(o)
	} else {
		o = msgp.AppendMapHeader(o, uint32(len(z)))
	}
	za0001_keys := make([]string, 0, len(z))
	for za0001 := range z {
		za0001_keys = append(za0001_keys, za0001)
	}
	sort.Sort(SortString(za0001_keys))
	for _, za0001 := range za0001_keys {
		za0002 := z[za0001]
		_ = za0002
		o = msgp.AppendString(o, za0001)
		o = za0002.MarshalMsg(o)
	}
	return
}

func (_ TealKeyValue) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(TealKeyValue)
	if !ok {
		_, ok = (z).(*TealKeyValue)
	}
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *TealKeyValue) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var zb0003 int
	var zb0004 bool
	zb0003, zb0004, bts, err = msgp.ReadMapHeaderBytes(bts)
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	if zb0003 > bounds.EncodedMaxKeyValueEntries {
		err = msgp.ErrOverflow(uint64(zb0003), uint64(bounds.EncodedMaxKeyValueEntries))
		err = msgp.WrapError(err)
		return
	}
	if zb0004 {
		(*z) = nil
	} else if (*z) == nil {
		(*z) = make(TealKeyValue, zb0003)
	}
	for zb0003 > 0 {
		var zb0001 string
		var zb0002 TealValue
		zb0003--
		zb0001, bts, err = msgp.ReadStringBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		bts, err = zb0002.UnmarshalMsgWithState(bts, st)
		if err != nil {
			err = msgp.WrapError(err, zb0001)
			return
		}
		(*z)[zb0001] = zb0002
	}
	o = bts
	return
}

func (z *TealKeyValue) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *TealKeyValue) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*TealKeyValue)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z TealKeyValue) Msgsize() (s int) {
	s = msgp.MapHeaderSize
	if z != nil {
		for za0001, za0002 := range z {
			_ = za0001
			_ = za0002
			s += 0 + msgp.StringPrefixSize + len(za0001) + za0002.Msgsize()
		}
	}
	return
}

// MsgIsZero returns whether this is a zero value
func (z TealKeyValue) MsgIsZero() bool {
	return len(z) == 0
}

// MaxSize returns a maximum valid message size for this message type
func TealKeyValueMaxSize() (s int) {
	s += msgp.MapHeaderSize
	// Adding size of map keys for z
	s += bounds.EncodedMaxKeyValueEntries * (msgp.StringPrefixSize + bounds.MaxAppBytesKeyLen)
	// Adding size of map values for z
	s += bounds.EncodedMaxKeyValueEntries * (TealValueMaxSize())
	return
}

// MarshalMsg implements msgp.Marshaler
func (z TealType) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	o = msgp.AppendUint64(o, uint64(z))
	return
}

func (_ TealType) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(TealType)
	if !ok {
		_, ok = (z).(*TealType)
	}
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *TealType) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	{
		var zb0001 uint64
		zb0001, bts, err = msgp.ReadUint64Bytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		(*z) = TealType(zb0001)
	}
	o = bts
	return
}

func (z *TealType) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *TealType) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*TealType)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z TealType) Msgsize() (s int) {
	s = msgp.Uint64Size
	return
}

// MsgIsZero returns whether this is a zero value
func (z TealType) MsgIsZero() bool {
	return z == 0
}

// MaxSize returns a maximum valid message size for this message type
func TealTypeMaxSize() (s int) {
	s = msgp.Uint64Size
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *TealValue) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0001Len := uint32(3)
	var zb0001Mask uint8 /* 4 bits */
	if (*z).Bytes == "" {
		zb0001Len--
		zb0001Mask |= 0x2
	}
	if (*z).Type == 0 {
		zb0001Len--
		zb0001Mask |= 0x4
	}
	if (*z).Uint == 0 {
		zb0001Len--
		zb0001Mask |= 0x8
	}
	// variable map header, size zb0001Len
	o = append(o, 0x80|uint8(zb0001Len))
	if zb0001Len != 0 {
		if (zb0001Mask & 0x2) == 0 { // if not empty
			// string "tb"
			o = append(o, 0xa2, 0x74, 0x62)
			o = msgp.AppendString(o, (*z).Bytes)
		}
		if (zb0001Mask & 0x4) == 0 { // if not empty
			// string "tt"
			o = append(o, 0xa2, 0x74, 0x74)
			o = msgp.AppendUint64(o, uint64((*z).Type))
		}
		if (zb0001Mask & 0x8) == 0 { // if not empty
			// string "ui"
			o = append(o, 0xa2, 0x75, 0x69)
			o = msgp.AppendUint64(o, (*z).Uint)
		}
	}
	return
}

func (_ *TealValue) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*TealValue)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *TealValue) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0001 int
	var zb0002 bool
	zb0001, zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0001, zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0001 > 0 {
			zb0001--
			{
				var zb0003 uint64
				zb0003, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Type")
					return
				}
				(*z).Type = TealType(zb0003)
			}
		}
		if zb0001 > 0 {
			zb0001--
			(*z).Bytes, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Bytes")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			(*z).Uint, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Uint")
				return
			}
		}
		if zb0001 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0001)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 {
			(*z) = TealValue{}
		}
		for zb0001 > 0 {
			zb0001--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "tt":
				{
					var zb0004 uint64
					zb0004, bts, err = msgp.ReadUint64Bytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "Type")
						return
					}
					(*z).Type = TealType(zb0004)
				}
			case "tb":
				(*z).Bytes, bts, err = msgp.ReadStringBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Bytes")
					return
				}
			case "ui":
				(*z).Uint, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Uint")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *TealValue) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *TealValue) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*TealValue)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *TealValue) Msgsize() (s int) {
	s = 1 + 3 + msgp.Uint64Size + 3 + msgp.StringPrefixSize + len((*z).Bytes) + 3 + msgp.Uint64Size
	return
}

// MsgIsZero returns whether this is a zero value
func (z *TealValue) MsgIsZero() bool {
	return ((*z).Type == 0) && ((*z).Bytes == "") && ((*z).Uint == 0)
}

// MaxSize returns a maximum valid message size for this message type
func TealValueMaxSize() (s int) {
	s = 1 + 3 + msgp.Uint64Size + 3
	panic("Unable to determine max size: String type z.Bytes is unbounded")
	s += 3 + msgp.Uint64Size
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *ValueDelta) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0001Len := uint32(3)
	var zb0001Mask uint8 /* 4 bits */
	if (*z).Action == 0 {
		zb0001Len--
		zb0001Mask |= 0x2
	}
	if (*z).Bytes == "" {
		zb0001Len--
		zb0001Mask |= 0x4
	}
	if (*z).Uint == 0 {
		zb0001Len--
		zb0001Mask |= 0x8
	}
	// variable map header, size zb0001Len
	o = append(o, 0x80|uint8(zb0001Len))
	if zb0001Len != 0 {
		if (zb0001Mask & 0x2) == 0 { // if not empty
			// string "at"
			o = append(o, 0xa2, 0x61, 0x74)
			o = msgp.AppendUint64(o, uint64((*z).Action))
		}
		if (zb0001Mask & 0x4) == 0 { // if not empty
			// string "bs"
			o = append(o, 0xa2, 0x62, 0x73)
			o = msgp.AppendString(o, (*z).Bytes)
		}
		if (zb0001Mask & 0x8) == 0 { // if not empty
			// string "ui"
			o = append(o, 0xa2, 0x75, 0x69)
			o = msgp.AppendUint64(o, (*z).Uint)
		}
	}
	return
}

func (_ *ValueDelta) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*ValueDelta)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *ValueDelta) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0001 int
	var zb0002 bool
	zb0001, zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0001, zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0001 > 0 {
			zb0001--
			{
				var zb0003 uint64
				zb0003, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Action")
					return
				}
				(*z).Action = DeltaAction(zb0003)
			}
		}
		if zb0001 > 0 {
			zb0001--
			var zb0004 int
			zb0004, err = msgp.ReadBytesBytesHeader(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Bytes")
				return
			}
			if zb0004 > bounds.MaxAppBytesValueLen {
				err = msgp.ErrOverflow(uint64(zb0004), uint64(bounds.MaxAppBytesValueLen))
				return
			}
			(*z).Bytes, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Bytes")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			(*z).Uint, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Uint")
				return
			}
		}
		if zb0001 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0001)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 {
			(*z) = ValueDelta{}
		}
		for zb0001 > 0 {
			zb0001--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "at":
				{
					var zb0005 uint64
					zb0005, bts, err = msgp.ReadUint64Bytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "Action")
						return
					}
					(*z).Action = DeltaAction(zb0005)
				}
			case "bs":
				var zb0006 int
				zb0006, err = msgp.ReadBytesBytesHeader(bts)
				if err != nil {
					err = msgp.WrapError(err, "Bytes")
					return
				}
				if zb0006 > bounds.MaxAppBytesValueLen {
					err = msgp.ErrOverflow(uint64(zb0006), uint64(bounds.MaxAppBytesValueLen))
					return
				}
				(*z).Bytes, bts, err = msgp.ReadStringBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Bytes")
					return
				}
			case "ui":
				(*z).Uint, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Uint")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *ValueDelta) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *ValueDelta) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*ValueDelta)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *ValueDelta) Msgsize() (s int) {
	s = 1 + 3 + msgp.Uint64Size + 3 + msgp.StringPrefixSize + len((*z).Bytes) + 3 + msgp.Uint64Size
	return
}

// MsgIsZero returns whether this is a zero value
func (z *ValueDelta) MsgIsZero() bool {
	return ((*z).Action == 0) && ((*z).Bytes == "") && ((*z).Uint == 0)
}

// MaxSize returns a maximum valid message size for this message type
func ValueDeltaMaxSize() (s int) {
	s = 1 + 3 + msgp.Uint64Size + 3 + msgp.StringPrefixSize + bounds.MaxAppBytesValueLen + 3 + msgp.Uint64Size
	return
}
