// Package public provides primitives to interact with the openapi HTTP API.
//
// Code generated by github.com/oapi-codegen/oapi-codegen/v2 version v2.4.1 DO NOT EDIT.
package public

import (
	"bytes"
	"compress/gzip"
	"encoding/base64"
	"fmt"
	"net/http"
	"net/url"
	"path"
	"strings"

	. "github.com/algorand/go-algorand/daemon/algod/api/server/v2/generated/model"
	"github.com/algorand/go-algorand/data/basics"
	"github.com/getkin/kin-openapi/openapi3"
	"github.com/labstack/echo/v4"
	"github.com/oapi-codegen/runtime"
)

// ServerInterface represents all server handlers.
type ServerInterface interface {
	// Get a list of unconfirmed transactions currently in the transaction pool by address.
	// (GET /v2/accounts/{address}/transactions/pending)
	GetPendingTransactionsByAddress(ctx echo.Context, address basics.Address, params GetPendingTransactionsByAddressParams) error
	// Broadcasts a raw transaction or transaction group to the network.
	// (POST /v2/transactions)
	RawTransaction(ctx echo.Context) error
	// Get a list of unconfirmed transactions currently in the transaction pool.
	// (GET /v2/transactions/pending)
	GetPendingTransactions(ctx echo.Context, params GetPendingTransactionsParams) error
	// Get a specific pending transaction.
	// (GET /v2/transactions/pending/{txid})
	PendingTransactionInformation(ctx echo.Context, txid string, params PendingTransactionInformationParams) error
}

// ServerInterfaceWrapper converts echo contexts to parameters.
type ServerInterfaceWrapper struct {
	Handler ServerInterface
}

// GetPendingTransactionsByAddress converts echo context to params.
func (w *ServerInterfaceWrapper) GetPendingTransactionsByAddress(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "address" -------------
	var address basics.Address

	err = runtime.BindStyledParameterWithOptions("simple", "address", ctx.Param("address"), &address, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter address: %s", err))
	}

	ctx.Set(Api_keyScopes, []string{})

	// Parameter object where we will unmarshal all parameters from the context
	var params GetPendingTransactionsByAddressParams
	// ------------- Optional query parameter "max" -------------

	err = runtime.BindQueryParameter("form", true, false, "max", ctx.QueryParams(), &params.Max)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter max: %s", err))
	}

	// ------------- Optional query parameter "format" -------------

	err = runtime.BindQueryParameter("form", true, false, "format", ctx.QueryParams(), &params.Format)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter format: %s", err))
	}

	// Invoke the callback with all the unmarshaled arguments
	err = w.Handler.GetPendingTransactionsByAddress(ctx, address, params)
	return err
}

// RawTransaction converts echo context to params.
func (w *ServerInterfaceWrapper) RawTransaction(ctx echo.Context) error {
	var err error

	ctx.Set(Api_keyScopes, []string{})

	// Invoke the callback with all the unmarshaled arguments
	err = w.Handler.RawTransaction(ctx)
	return err
}

// GetPendingTransactions converts echo context to params.
func (w *ServerInterfaceWrapper) GetPendingTransactions(ctx echo.Context) error {
	var err error

	ctx.Set(Api_keyScopes, []string{})

	// Parameter object where we will unmarshal all parameters from the context
	var params GetPendingTransactionsParams
	// ------------- Optional query parameter "max" -------------

	err = runtime.BindQueryParameter("form", true, false, "max", ctx.QueryParams(), &params.Max)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter max: %s", err))
	}

	// ------------- Optional query parameter "format" -------------

	err = runtime.BindQueryParameter("form", true, false, "format", ctx.QueryParams(), &params.Format)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter format: %s", err))
	}

	// Invoke the callback with all the unmarshaled arguments
	err = w.Handler.GetPendingTransactions(ctx, params)
	return err
}

// PendingTransactionInformation converts echo context to params.
func (w *ServerInterfaceWrapper) PendingTransactionInformation(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "txid" -------------
	var txid string

	err = runtime.BindStyledParameterWithOptions("simple", "txid", ctx.Param("txid"), &txid, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter txid: %s", err))
	}

	ctx.Set(Api_keyScopes, []string{})

	// Parameter object where we will unmarshal all parameters from the context
	var params PendingTransactionInformationParams
	// ------------- Optional query parameter "format" -------------

	err = runtime.BindQueryParameter("form", true, false, "format", ctx.QueryParams(), &params.Format)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter format: %s", err))
	}

	// Invoke the callback with all the unmarshaled arguments
	err = w.Handler.PendingTransactionInformation(ctx, txid, params)
	return err
}

// This is a simple interface which specifies echo.Route addition functions which
// are present on both echo.Echo and echo.Group, since we want to allow using
// either of them for path registration
type EchoRouter interface {
	CONNECT(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	DELETE(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	GET(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	HEAD(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	OPTIONS(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	PATCH(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	POST(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	PUT(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	TRACE(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
}

// RegisterHandlers adds each server route to the EchoRouter.
func RegisterHandlers(router EchoRouter, si ServerInterface, m ...echo.MiddlewareFunc) {
	RegisterHandlersWithBaseURL(router, si, "", m...)
}

// Registers handlers, and prepends BaseURL to the paths, so that the paths
// can be served under a prefix.
func RegisterHandlersWithBaseURL(router EchoRouter, si ServerInterface, baseURL string, m ...echo.MiddlewareFunc) {

	wrapper := ServerInterfaceWrapper{
		Handler: si,
	}

	router.GET(baseURL+"/v2/accounts/:address/transactions/pending", wrapper.GetPendingTransactionsByAddress, m...)
	router.POST(baseURL+"/v2/transactions", wrapper.RawTransaction, m...)
	router.GET(baseURL+"/v2/transactions/pending", wrapper.GetPendingTransactions, m...)
	router.GET(baseURL+"/v2/transactions/pending/:txid", wrapper.PendingTransactionInformation, m...)

}

// Base64 encoded, gzipped, json marshaled Swagger object
var swaggerSpec = []string{

	"H4sIAAAAAAAC/+y9e3Mbt5Io/lXw426VYy1JyY6TPfGvUnuVOA9t7NgVKdmH5ZuAM00SR0NgDoChyPj6",
	"u99C4zGYGQw5lGg72Zu/bHHwaDQajUY/344ysSoFB67V6OnbUUklXYEGiX/RPJeg8L85qEyyUjPBR09H",
	"55zQLBMV16SsZgXLyA1sp6PxiJmvJdXL0XjE6QpGT8Mg45GEf1RMQj56qmUF45HKlrCidlqtQZq+r88n",
	"/302+eLN28/+9m40HultacZQWjK+GI1Hm8lCTNyPM6pYpqbnbvx3+77SsixYRs0SJixPL6puQlgOXLM5",
	"A9m3sOZ4u9a3YpytqtXo6VlYEuMaFiB71lSWFzyHTd+ios9UKdC96zEfB6zEj3HUNZhBd66i0SCjOluW",
	"gnGdWAnBr8R+Ti4h6r5rEXMhV1S320fkh7T3aPzo7N0/BVJ8NP7s0zQx0mIhJOX5JIz7dRiXXNp27w5o",
	"6L+2EfC14HO2qCQocrsEvQRJ9BKIBFUKroCI2d8h04Qp8u+XL38kQpIXoBRdwCua3RDgmcghn5KLOeFC",
	"k1KKNcshH5Mc5rQqtCJaYM9AH/+oQG5r7Dq4YkwCN7TwevR3JfhoPFqpRUmzm9GbNprevRuPCrZiiVW9",
	"oBtDUYRXqxlIIuZmQR4cCbqSvA8gO2IMz06SrBjXnz9p02H964puuuBdyYpnVEMeAagl5YpmpgVCmTNV",
	"FnSLqF3RzZdnYwe4IrQoSAk8Z3xB9IarvqWYuY+2EA6bBKKvlkDMF1LSBUR4npKfFSAl4VctboAH6iCz",
	"LX4qJayZqFTo1LMOnDqxkIgOpKh4ilER/ODQ3MOjbN9jMqifcMR3u78ptnCf2lBfssXVtgQyZ4W5L8nf",
	"K6UDAVcKt30JRJWQGd6bEzOMQb5iC051JeHpNT8xf5EJudSU51Tm5peV/elFVWh2yRbmp8L+9FwsWHbJ",
	"Fj07EGBNnVOF3Vb2HzNe+qjqTfIueS7ETVXGC8ris2Bo5eJZH2XYMftJI80gz4PcgPvjxrraXDzrY6m7",
	"e+hN2MgeIHtxV1LT8Aa2Egy0NJvjP5s5khady99HVrwwvXU5T6HWkL9j1yhQnVv56bwWIn5yn83XTHAN",
	"9iqMxIxTZLZP38aSkxQlSM3soLQsJ4XIaDFRmmoc6Z8lzEdPR/90Wgt6p7a7Oo0mf256XWIncxlLMIxv",
	"QsvygDFeGeERRa2eg274kD3qcyHJ7ZJlS6KXTBHG7Sai3GU4TQFryvV0dNBJfhdzh9cOiHor7CVpt6LF",
	"gHr3gtiGM1BI+07ofaAakiJinCDGCeU5WRRiFn745Lwsa+Ti9/OytKgaEzYnwPA+hw1TWj1EzND6kMXz",
	"XDybku/isW9ZURDBiy2Zgbt3IDdjWr7t+LgTwA1icQ31iA8UwZ0Wcmp2zaPByGXHIEaUKpeiMFfgXjIy",
	"jb93bWMKNL8P6vynp74Y7f10hxK9QypSk/2lfriRT1pE1aUp7GGo6bzd924UZUbZQUvqokbwsekKf2Ea",
	"VmovkUQQRYTmtodKSbdegpqgJNSloJ8VWOIp6YJxhHZsBHJOVvTG7odAvBtCABUkbUtmVry6ZXpZi1wB",
	"9dPO++LPTcipPSdmwykzsjEpmNJGGMLNVGQJBQqcNCgWYiq6E9EMoIUdiwgw30paWjJ3X6wcxzih4f1l",
	"Yb3nTT7wkk3CHKstarwjVHdm5nsZbhISq3BowvBVIbKb76laHuHwz/xY3WOB05Al0BwkWVK1TJypFm3X",
	"ow2hb9MQaZbMoqmmYYnPxUIdYYmFOISrleXXtCjM1F1u1lotDjzoIBcFMY0JrJg2D2DG8QQs2Bq4ZT1T",
	"8g3NlkaYIBktinGtlxDlpIA1FERIwjgHOSZ6SXV9+HFk/1DCc6TA8EENJFqN02lMydUSJMyFxIeqBLKi",
	"eDmtzPOoLJp9AnNVdAUt2QkvS1FpA2P0crl45lcHa+DIk8LQCH5YIz7448GnZm73CWfmwi6OSkBFC+NZ",
	"UeU1/gK/aABtWtdXLa+nEDJHRQ/V5jcmSSakHcJe/m5y8x+gsu5sqfOTUsLEDSHpGqSihVlda1EPA/ke",
	"63TuOZk51TQ6mY4K0y86yzmwHwqFIBPajZf4H1oQ89kIOIaSauphKKegTBP2A+9sgyo7k2lg+JYWZGX1",
	"ZqSk2c1BUH5dT55mM4NO3jdWVee20C0i7NDVhuXqWNuEg/XtVfOEWJ2PZ0cdMWUn04nmGoKAK1ESyz5a",
	"IFhOgaNZhIjN0a+1r8QmBdNXYtO50sQGjrITZpzBzP4rsXnmIBNyP+Zx7CFINwvkdAUKb7eGGcTMUquq",
	"z2dC3k2a6JgmagU8oWbUSJgat5CETaty4s5mQj1uG7QGIkG9tFsIaA+fwlgDC5eavgcsKDPqMbDQHOjY",
	"WBCrkhVwBNJfJoW4GVXw6WNy+f35Z48e//r4s88NSZZSLCRdkdlWgyKfOD0fUXpbwMPkwwmli/Tonz/x",
	"BpHmuKlxlKhkBitadoeyhhb7MLbNiGnXxVoTzbjqAOAgjgjmarNoJz/Zfu/Go2cwqxaXoLV5BL+SYn50",
	"btiZIQUdNnpVSiNYqKZRyklLp7lpcgobLelpiS2B59b0ZtbBlHkDrmZHIaq+jc/rWXLiMJrD3kNx6DbV",
	"02zjrZJbWR1D8wFSCpm8gksptMhEMTFyHhMJ3cUr14K4Fn67yvbvFlpySxUxc6MBrOJ5j4pCb/jw+8sO",
	"fbXhNW523mB2vYnVuXmH7EsT+fUrpAQ50RtOkDobmpO5FCtCSY4dUdb4DrSVv9gKLjVdlS/n8+PoSAUO",
	"lFDxsBUoMxOxLYz0oyATPFd7tTneGthCpptqCM7a2PK2LN0PlUPT5ZZnqEY6xlnu1345Ux9RW55FqjAD",
	"YwH5okGr71Xl1YcpC8UDlYDUYOo5fkaLwDMoNP1WyKta3P1Oiqo8Ojtvzzl0OdQtxtkcctPXa5QZXxTQ",
	"kNQXBvZpao0fZUFfB6WDXQNCj8T6nC2WOnpfvpLiPdyhyVlSgOIHq1wqTJ+uiulHkRvmoyt1BNGzHqzm",
	"iIZuYz5IZ6LShBIucsDNr1RaKO3x2jEHNaukBK5jORf1GUyRGRjqymhlVluVRIvU/VJ3nNDMntAJokb1",
	"uDkEVw3byk63pGsgtJBA8y2ZAXAiZmbRtZcDLpIqUhrZ2Yl1TiQeym8bwJZSZKAU5BOnz94Lr29n7x+9",
	"A3m4GlxFmIUoQeZUvp8V3Kz3An8D28maFpURz3/4RT38oyxCC02LPVuAbVIb0VbfdZdyD5h2EXEbopiU",
	"rbbQngQjYhumU4CGPmTfH3u9298Gs0ME7wmBa5DoUfNej5af5D0QZYD/PR+s97KEqpwYMbBX/WAkV7Pf",
	"nHLhZcM9M4QJCqr0ZN+VYho19CZmqREXT90iOHCPPPmcKo1iIGE8R/2tvQpxHitbmilGBzqV4ZS9rzEz",
	"6S/+IdadNjPXO1eVCq8yVZWlkBry1PLQZt0714+wCXOJeTR2ePppQSoF+0buQ2A0vsOjUwTgH1QHC7Wz",
	"eXcXh14HRnzZHorlBnw1jnbBeOlbRYiPnWp7YGSq3gNLbky16G0mRAEUVaZKi7I0HEpPKh769WHw0rY+",
	"1z/Xbbskac1AVlLJBSg0Mbn2DvJbi3SFtq4lVcTB4f0TUOFlXeS6MJtjPVGMZzDZdV7wEWxaxQfnTse9",
	"KheS5jDJoaDbhLeF/Uzs5wMJw4+NBFLrD4SGyQytiWkaqc+E9ze926wCp1IpwZvgF5KZc26eUTWpud53",
	"nzQHnDbFNx2xPgizIBhJOvDjIbIsPSVGxLt/LbQhK0d0uBp3K91zLT3YC7O+FwTiuJNaEdCe/b9AubmD",
	"AHbU+beg+hZeT32sZfeo//Fub1yYrausddskr4hevryHMfbxoB5bxCsqNctYic/VH2B79Nd7e4KkrwTJ",
	"QVNWQE6iD/YlX8b9iXVDbo95t9f8IHVrF/yOvjWxHO+Z1QT+BraoNnllIxoibdUx1BGJUc2FSzlBQL3X",
	"vHnxxE1gQzNdbI1gq5ewJbcggahqZr1WuiY0LcpJPEA6Zqp/RmeQT5rDd3oIXOJQ0fJSnof2tbUbvqvW",
	"k6uBDvfKKoUoEvrP9onvICMJwSB3IVIKs+uMFsWW6BA24ympAaS7INAbI8gzD1QDzbgC8l+iIhnl+MKt",
	"NAQhTUiUfFBYNjMYcTPM6VxVawxBASuwr3n8cnLSXvjJidtzpsgcbq3LDceGbXScnKAq7pVQunG4jqDt",
	"NsftInHpoK3SXLLu1dbmKfud3NzIQ3byVWvwYOA0Z0opR7hm+fdmAK2TuRmy9phGhjn44biDzHdNl7DO",
	"unHfL9mqKqg+hqES1rSYiDVIyXLYy8ndxEzwb9a0eBm6vRuPYAOZodEMJhlGCQ4cC65MHxtYaMZhnJkD",
	"bANHhgIEF7bXpe2056Vd+y2z1QpyRjUUW1JKyMBGyRkpVYWlTokNmciWlC/wBSRFtXCuznYcZPiVspow",
	"WfHOEIeKYnrDJ2jCUMkwNTRb+mhLI4QBNS/btv3DPtZuaQDFXkaDLu1oe9r2oKTJdDzqffgbfK/rh7/F",
	"WzNk9K7GxIZ8GCGthmag9QzxaWSlLhLjbTSHzxDD+7HS1EOnoOxOHDmF1x/7/MIvq7IstkcQkuxAREIp",
	"QeGVFqsBlf0q5uQFy6Q4LxYi3HlqqzSsusYb2/XXnuP6011ewIIXjMNkJTgknvQv8esL/DhY7Wiv4Z4R",
	"USA6aMD2w6eBhNYCmpMPIen7bhKSTPvsty2d6lshj2VltwMOflMMsFzvdetwU97Vvk6LImGStuqHDhdR",
	"4+AUziShSomMoaB4kaux8z63Vmzr1t5C/6sQGnWEA9wet2V7jcKwrCIfipJQkhUM1fyCKy2rTF9zipq+",
	"aKkJZ0GvHOhXC3/tm6T10Ak1sRvqmlN0FA36v6Rj0BwSeqhvAbx2WFWLBSjdemDNAa65a8U4qTjTONfK",
	"HJeJPS8lSPTYm9qWK7olc0MTWpDfQQoyq3TzybGqlCZKs6JwhmAzDRHza041KYAqTV4wfrXB4bwfiT+y",
	"HPStkDcBC9PhjGsBHBRTk7Sn43f2KwaVOJwsXYAJxlrYz97juc4NMTJrbySt+N+f/NvT1+eT/6aT388m",
	"X/zL6Zu3T949POn8+Pjdl1/+n+ZPn7778uG//XNq+zzsqWBwB/nFM/dGv3iGD7EoTqQN+x/BILNifJIk",
	"ytihqEWL5BPMl+EI7mFT76eXcM31hhvCW9OC5YYXHY182tdU50DbI9aissbGtdR4HgEHPofuwapIglO1",
	"+Ot7kefaE+x0uIm3vBVj4DijOjqAbuAUXO05U261D7775oqcOkJQD5BY3NBRaoHEC8ZFMDa8fMwuxYFd",
	"1/yaP4M5vgcFf3rNc6rpqT1Np5UC+RUtKM9guhDkqQ+KfEY1veada6g3gVQU1BxlkEpxCrpKr+X6+jUt",
	"FuL6+k3HD6ErW7mpYi7qzllXTeannBi5QVR64pK4TCTcUpmyhfgUHy4aGnvvhMPKJKKySiyfJMaNPx0K",
	"ZVmqdrKHLorKsjAoikhVuXwFZluJ0iIEjhlm7mJvDQ38KJxTiaS3/slbKVDktxUtXzOu35DJdXV29imG",
	"4NUpDn5zPNDQ7baEwQ/f3mQU7fcuLtzK5ehUPinpImUzub5+rYGWSCEocKzwpVkUBLs1wgN9JAAOVS8g",
	"xCIfsCUWsoPjenG5l7aXT+uVXhR+wk1txk7fawejqPg7b+CeyHpa6eXEcITkqpQ5Bn6vfIIBujBXjvcg",
	"UGyBDwC1FJVZMpBsCdmNy2wFq1Jvx43u3tHF3cWe4TCFOiMXHDhnBn8Z5WbAqsypE2Qo37ZT3CgbDIGD",
	"/gQ3sL0Stvt0YHawKBtdlGJF9R1dpN3orjXkGx9kN0Z7853flY8RdelIMO7Sk8XTQBe+T//RtgLAEY51",
	"iigaeT76EEFlAhGW+HtQcIeFmvHuRfqp5TGeAddsDRMo2ILNigSb/o+uXcPDaqhSQgZs7aN6w4CKsDkx",
	"r6OZvY7di0lSvgBzqZuLWChaoNP+NGnoR+lwCVTqGVC9U1/L4zQTHjoUyG8xaBqVJmOzBNiY/WYalSAc",
	"bs0DD9/eto1zJJ7eyZ3KrgnyO4Lqu9dB0tO7PCIcwhP57Px9H/YkvBecf1pMnQiy/b4yOFxIcWt20wAo",
	"fOpGTPAS3VOVogsYeh01TEUDU2I0LEA4yD7pJynviHlbrOnIGAMXYbtPDF6S3AHMF8Me0AzQcnH0c1sT",
	"orMqvOTF1iN1VqBAHRxELelQ2bCz8cVhwKbZGEheC6sesCbW4qO/pMof/XwccfQ7SosfJ5XMrvx5F5H3",
	"HdXd7Hj+mm6z9rHV58yACG56+Cx6PnWez5c3Gh+U+248ciEOqb0THKXoHApYWJzYxp7O6vxM9W4aOF7O",
	"58j0JilHvkgZGUkmbg4wD7ETQqzGnAweIXUKIrDRso4Dkx9FfNj54hAgucsvRf3YeHdFf0M6WNB64xsp",
	"WZTm1mc9VqvMsxSX3qIWeVouzjgMYXxMDCdd08JwUhd4Wg/SydWGb59WZjbn2/Gw70008KC5NaJ0ctAq",
	"rTxzl/XFgrdfRvpVcNAaZmIzsZHRyafVbDMzZyIZr4Bx2qnDazPnPVBkJjboU4Q3nHVwPxi6fsg8YJEb",
	"yIYppHLs1yc2WvAOA2S3IJ+iZoWk5/Rqgez6JNm7AdMjTveR3SdRCr0jgdRSYNZpwJ1GZ6+epSltdSWR",
	"+rodh+ywIUwtxWr6DmdyJ3sw2lWeNnPdfV+nO+xPjubP6gdJ8tdVyt0nL6PtXNpci4ekZWyTQwOIHVh9",
	"1RZik2htOi418RphLcWSDKPvGru6aFNQAGoCJg25enKTMktfX79WgDLDpe8W6Tlx9yjfPoy84SQsmNJQ",
	"Gxe8k8uHt/2gOtE8tsS8f3W6lHOzvp+ECIKGNcdix8YyP/gK0HV9zqTSE7TMJJdgGn2rUJP2rWmaFoSb",
	"/nZMWVPPwXIwQnQD20nOiipNyg6kH54ZiH4MN5eqZnhRMm69jWaYCj/poHuAbRLhsY7dOxH03CLoOf0Q",
	"+Bl2sExTA5M0lNec/k9yxFq8cBdnSdByipi6G9qL0h28Noql7zLaSIiO3C6mu2w+nXOZ+7H3emP5iP4+",
	"IcKOlFxLlBExHUAoFgvIfaY3FxRqs165fHqF4Is6l6D5fUf6wCmxWfwwCd+O/H3OPR36nNMb5USwKkYS",
	"+vgxg5DX0XWYexAnWQC3mVtGh9cbKZKIix3jsUWkGf2wvL3jNp90Hb5quQvXPr12D8Nm4/YUQHP3rFLg",
	"17f70Ha3y6Fu3Od03EgRu/uA4YBIcUyrSIDpEE0P56ZlyfJNy/BnR53egSQGinvdTPAtnCFbcoPtwU/T",
	"sXhPrZ4H5nbE9s7YcYrP/FPzyLT+zM4j15wNmrlsA3kl0ZrU8Bbu5tMPD82Ba//hl0stJF2AswhOLEj3",
	"GgKXcwgaopT0imhmHaRzNp9DbAlTd7HiNIDr2DvyAYTdQ4Jdc1l4W+6kzy6R7aGtegX7EZqmpwSl9Plc",
	"XHXtkf7hEenWwmUTbdwdjIrJhAI/wHbyCy0q8xJiUtW+qc5A2LzWD6CJ9eoH2OLIe10+DWB7dgVVcT8B",
	"UmjKuhI+qShL+APVqL6Ab+DGFh6wU+fpXTrS1rhSGv1Ho76hGvUkmkt5f8emdpExkA7Zq8u014k5W9Dc",
	"ljah79silu+XfaInSDwVQ++Nu1xyIdPGXu8yoIUnfFzs6N14dD9/j9Q96UbcsxOvwtWc3AX0xrT2/4bT",
	"14EbQstSijUtJs5Ppk/okGLthA5s7t1qPvD7Kn0qrr45f/7Kgf9uPMoKoHISVB29q8J25Z9mVbYEx+5r",
	"yKZjd7pdqwqLNj+kzI49aW4x9XpLm9apdVP7TUUH1XnWzNOe4nv5pnPxskvc4eoFZfD0qi3S1tGr6dxF",
	"15QV3vDroR2qZbfLHVZdKckn4gHu7SQWef/de6zeOIHr69drj9nanmIdpUJK/IQvnbqjp3OH16TPak3r",
	"ezgkrvMlZjJNv7u4y3OKjNE5nNGjy4HfCtm4qFxUY9Jh7f0JiOYxYfGYNspfOSt8RyycEitC/rb4zfCG",
	"k5P44J+cjMlvhfsQAYi/z9zv+I46OUkahpOqPsOyUJPH6QoehriI3o34sGoIDrfDxIXz9SrIyKKfDAOF",
	"Ws8zj+5bh71byRw+c/dLDgWYn6ZDVBXxplt0x8AMOUGXfVGJwfl5Zct5KiJ4OwYfo2QNaeHV4yp4WDt7",
	"9wjxaoV254kqWJZ2+uEzZVgSty69pjHBxoNtyGaOivX4lfOKRaObZupOJs/WQqJZkwhXyUzANX5nwrGA",
	"irN/VBCV9cWbuHU5+6cQjtoRsNP6RTdwu2rw6C4Ff+9vIvRatV0Ko50m12fBDOgRkaozdWC8Qzxjh/nv",
	"iFVwFOWvTwxsWzrX4b2UtfOdt7sItDMDe/bpLK79DyRXDtNu5rMhO83UZC7F75CWHdBImEjd4a3bDBXw",
	"vwNP+ai2GVnwHKgLVtez7yOQ4bqFPlK5ty7BLzpUzbvLFZ7mE4dt9IFKg2i/+9UGKp1e3G1C30M1djxp",
	"BtL0MDM8sJFbONby8e5ulNsTavNaNCLP0uc8DhQ9tePX59zB3AmuLejtjKYKHZn3ooEp2v6GY54WxHf2",
	"G6RCagY7O4liGUJbZpP9lSBr61E3VfId33522sGvvvqRhxQXP+/G1lelUCIxTMVvKUc/QuxnOaDrrcD6",
	"YZhet0Jigk+V9iHMIWOrpDL8+vp1nnU9v3K2YLakeKWA0Ll2eR7dQLaovKUiV8075CJxqLmYk7NxfWb9",
	"buRszRSbFYAtHtkWM6rwgg4+EaGLWR5wvVTY/PGA5suK5xJyvVQWsUqQ8D5H0TN4ws5A3wJwcobtHn1B",
	"PkGHYcXW8DB9wThhbfT00RfjXZWzEeNYJH4Xk8+Ry/tAhjRlo1e1HcOwVTdqOjJhLgF+h/77ZMf5sl2H",
	"nC5s6a6g/adrRTk1CEnBtNoDk+2L+4uuHC28cGudAaWl2BKm0/ODpoZj9USTG4ZowSCZWK2YXjlPUSVW",
	"hsLqMuR2Uj8c1tfzZdA8XP4jumCXiTf+R3hu0VVPhCN61f+I9vYYrWNCbcbWgtXxF75CLbnwmamxLlwo",
	"B2dxY+YyS0d5FcMx5qSUjGvUGlV6Pvmbeb5LmhmGOO0DdzL7/EmivlqzBBE/DPAPjncJCuQ6jXrZQ/Ze",
	"ynF9ySdc8MnKcJT8YZ3SITqVvb7iaf/ePrfjnqHvLV2bcSe9BFg1CJBG3PxepMh3DHhP4gzrOYhCD17Z",
	"B6fVSqYJhlZmh37+6bmTRFZCpipd1AzASSUStGSwxvjS9CaZMe+5F7IYtAv3gf7jerd5sTQS3fzpTj4W",
	"Iqty4p0W0ioZSf+XF3V+fDRu27jdlvZSyISe1mkcP7Bb6mH6wrYN3boD4rcezA1GG47SxUpPuIeN5wh9",
	"Poa/Vxsku+cNVemj34g073iU9U9OEOiTk7ETlX973Pxs2fvJyXCX2bS+0PyaQM3d7pp29krTN7XVX4mE",
	"9s5X8Qx+Yy5VSULDmrzLzJU6c2OMSbNU4oeXO44Tr3iwG3L6AHnU4Oc2bj4yf8XNrCNg+vlDs3psknzy",
	"8D2KoaDkK7EZSkSta8vT0x8ART0oGagVxJV0quMmPSX2uvlEZGtGnUEhzEs1LoA12GvlT7QLBjXjHXtR",
	"sSL/pbZCt24mSXm2TDqVz0zHX+0zIGoQaTCyJeUcimRv+1r+1b+qE+/+v4ueYVeMpz+1CzFb2FuQ1mA1",
	"gfBT+vENrpguzAQxipoJuUKKk2IhcoLz1JVLatbYrWieqiSbiPHHYVeVdl7JmDzBFRSZswLdaNP2cGw5",
	"kVT3cFUs++9LXJlxsAq/smoJOzpIQtkKr21FV2UBeAjXIOkCuwoOre6YsQ1HjsqSEFWaT9gSk78IoivJ",
	"iZjPo2UA10xCsR2TkiplBzkzy4INzj16+ujs7GyYkRHxNWDtFq9+4S/rxT06xSb2i6v8ZQsmHAT+XaB/",
	"V1PdIZvfJS5XfvUfFSidYrH4wQZko4XY3Ou29GooEzwl32F+MkPojRIBqBT1GZabOUGrshA0H2NS6Ktv",
	"zp8TO6vtIwFRh6VfF6gBbB6RpJFneI5Un3+tJ3fV8HF2p84xq1Z6EoqypjIpmhZ1LVnW8n5C3WCMnSl5",
	"ZtWywbHHTkIwtbhcQR7VgLVqACQO8x+tabZEfed0tFOl3FMNaHgJY88Ba3NRFPcaCmYhBzfLcFWMbRHj",
	"MRF6CfKWKcC8E7CGZsLGkO3UKeR9AsfmamXFuSWc6QHSayiPdegueOCs6Ov9K5KQtfbh3ra/OpMHFjk/",
	"tNjzJfZKx+20Kke3/B5syYyNL7oxJS+csSOjXHCWYbGJlAiOqRiHmVUH1OVI2zvVyJ3lxDFM1qsOAeoO",
	"i70VrD3LdIjrOjVEX81+W8Kxf2rYuCKAC9DK8UDIx758vDPQMa7AFUAz9BVzVCETrl/JsJjgQnJEl/Tx",
	"CLOp9ehavzXffnS6ecwZc8M46twcUt1L0BrYCsXQzs4J02QhQLnVNuPC1GvTZ3q14QjCm+lzsWDZJVvg",
	"GNYV0SDFegF3hzr3PsHOB9e0/dq0dbULws8Nlzo7qV/3myQLUWH/UzXXe9Gf8v3yjjQRcsP48Wg7iHGn",
	"qz/ey4YMYY2ef1Difd4hm1C+vjnKN+bJaukNWxAbuZtMG8x4AoznjHuDbzoPVpa8S3Bj8DT39FOZpNo+",
	"OgZxvCugRU84DAbVW4+B+w7VrsRgUIJr9HP0b2Ndeb+HrYQG9euC8i3xh8JQdySUfE2L4AyfqKOP0pkT",
	"xqyzcKuyfoqtGLY+8aG5DXTtDQQN3bEayqH3VF+20VmVL0BPaJ6n8s59hV8JfvUBhbCBrApFwEKcaTNd",
	"e5fa3ESZ4Kpa7ZjLN7jndDlTVClYzYqE6+2z8BHysMOYiGq2xX9TFbD6d8Y5vR8c/e093PPDahR0o9lT",
	"0rOh6Ylii8lwTOCdcn901FPfjdDr/keldB/4/YeI625xuXiPUvztG3NxxGm6Oz7+9moJWbTRn17gd58P",
	"LGRybXIlvMo6dd7QIwM3L7FlLeB9wyTga1r0ZFyIrTb2frWWjL68C1lvWhGqXfY6TUnNE4aoMPrzf1kP",
	"7JZlqGve7POxti7W79N44vCxE+n9lsYfGnZF6/VWM5Ree+LdTH41ERxq83OlGLr6UloUIhvMGdww56ZT",
	"f6pesVq5zPcJr7z1SuTxWYi9uQDSjM06LCdCK/Bhm/yGT6vkF3mbHq2hHwlEMzRrGaLRLWFsAzM9eB4Y",
	"O3U8UaSydZgl37ICi0P9++XLH0f9GxntQHdLXerspAq7b2NCpFqbPBaigY8dPEDwIq3/Vj0qdcwNlT4N",
	"rjpx8sO3VkE4BCSbJ+mQ1s+HDt4hgIWwVaFSdTO62WlG9XZ45EfUUG+v5SgxdaSool1tKfH2sUrPugkJ",
	"hUgHFSZtyEhDijul6gi5l4LXwNqLxuWjs8WVOnWZOgz02RDhsIOPd+PRRX6Q+JSqRTWyo6QY7HO2WOqv",
	"CpHdfA80B2nriaSek7aayArMM1QtWYnvn1IoVtcDLsxgLpH3EoebDg3NuVqCywrjkwR0xvIO1GvINNaH",
	"rt1AJcBwP4cyvUQDgTcoYpOP4AoiAXIo9XKnsGSdu0u9rMuGgos8Y4rMwJku1sDHhE1h2g5Wy+ukUKQA",
	"OvdKWCmEHlBXN4QtIRpjoFP01anRvFsM7OR8i1Ia2lK60+FFWM5DTIANtLylqs4c1UqjMDhcez6HDBPe",
	"70y/9x9L4FE+trFX3SEs8ygbHwvhgliy4aga7RrWXYnwdoIa1aR6n5D2JcS4ge0DRRo0lKwIHCJs75IB",
	"HpFj7bi+qECfacM5RjIV6AkR5P3gXQL+usbSXYoARNkp7wiGp3FzPdUZK+8GjZdo7gCG6Tq9V9H+Oh0e",
	"CqZ92f261dX7X8rPsJi9ck6lNKSbj/VJ5KJbjvnWpavHRIvBWugT14Pyv/kErXaWgt24CjWIMGubvaUy",
	"9y2OkibP3pssDfQ8zMzqwKiul8+hfjk2QjErhBGAJn2Boc1IpeDC+0BZX+s6aRlCPQcpIQ82wUIomGjh",
	"w6wOSP7pwid3YM96md8Jby2P/gNChu2Kemso/FQXksBykBRrJlDnfB5jhUhYUQO9jIo7pNWg+3boa/vd",
	"5xTx5f12q1f78B7Oxf4K2T70jqkO5uPTNSdOODiYezUSkdxBM8s4BznxRtx2aQfeTJOJeZXzKrOiSnw2",
	"g/Z6cNqxHdwsqdTMuqtsPaGirBw3sD21ah9fddzveAy0lSEt6FFC6RZRHFVXrVJwL44C3sdN31kKUUx6",
	"LIMX3XoU7cNww7IbwMSsITLFSMEPmsfGTEI+QYNU8Bm5XW59tYWyBA75wykh59xGB3r3kWYF0tbk/IHe",
	"Nf8GZ80rW2HGaaCn1zwdZoWVXuQ9uZ8fZgfP6+NNCgy/vOf8dpA7zK43vM9H7hZLwjTrBE+Hqje6/h0t",
	"ESoiPwtFSoC6tIbgr5ElJN5RBLOzRGmE0D+AEmdAJqoQKS/8u2SQMUOlMRVPhgBp4AOeqzUUbvAkApyT",
	"3Z6srO6zzzsq5kRC7Ztx1wSsLqepZeKqTzXSnjnM0uSMcyEhnhH9TG2i5hDZhnmO8T8zpiWV27ukSW2i",
	"KqWG6sXyXm/J4ChZL6R2luzisCjE7QTZ2iRUV0qpA0w71by2fZ3Sup856jOI3C6pciLilixpTjIhJWRx",
	"j3SIt4VqJSRMCoFemCnHjrk2j4QVxnVyUogFEWUmcrCF0NIU1DdXxTlF2QsiV7YkCiztYMoA2yei44FT",
	"mtvXmmcnKK/tLbThN//K9LHpK+r0d3bRE+si0BNfAMqlu3MYso278CLh2IxMbaVsWkSesw3SDcjUkZ8T",
	"LSsYE9eiXYXfHXwqgayYUhaUQEu3rCgwewTbRA4NwR8ojdoe2fkC/aDXDB3emplErEhdmtsxpF+JecBl",
	"nJGN6KUU1WIZ1QcIcPqnu6zcwz4e5WdVoU8ihoiaKZ6QlVDaPYvtSPWSaxfQTzLBtRRF0VTkWTl/4Yy+",
	"L+jmPMv0cyFuZjS7eYiPcC50WGk+9ikV2r679UyylYNx2EtBb/gEyUPtT7Nu26FXq6Pnwbyzxf06hod9",
	"mvwIzDf7met+u8Z5d2HtdTX5bPotdM4J1WLFsvRx+3N5v/b6rKa4VzLToq1CbLPQYDPkA/E9FtyZkHt2",
	"0QycJsuonhPHI5xbB3Ii818U49vjkjk4HtRzh3b5jhOwJlmvGNgCACG1iRB0JW3p4lhICwxHLGziFHRK",
	"aQM68MJB37/7wWZGODpQGu4FVMcbOQD4idVgjG1GTOvZPBMb//1hnTLzTsC/203lDebR51R5WZOWtG6V",
	"PpFVD0dIFyDY6YF4hUkwZkP9EEMp+oGXfwRAv2diA4ZB/omHgjGnrIB8kqpSfBF0YOPoue5iLKPRfT1H",
	"y8kzWvlKwGbsSoJLrGSlf9k0J5bUkJIIzbsacZ7DBmyM1u8gha3jO47MWVDYMr8tjYIoJwWsoeGw6bI9",
	"VSiFsjX4vip0JjlAiRbftqIt5YkYVwlsaV/c2ieRL9sQ7CbVMRaxdqfIHl1LUjO04RN7TNTQo2QgWrO8",
	"og38qUNFjqYu0RzlBKo6z4eJf2IOneZnO8JPfoBz3z8lynhMvBnGhw5mQWnU7WJAez2TK9V36nnaMTlO",
	"ZRYMRThbHuzalsRrvqFKesv7tZpdkq9fYgP3iQkeIfabDWQo1binEOTuMdRjOXE5kJDaOUBuHwymS0Kb",
	"vwROuIhqHt9SFV4xdVZX/4OdGBsx7h7ad7DR1/7D999ZgoMR1Uq2mC5RGsj6fjr+j3ISdx7E3vFSNKLA",
	"hfLuUI156nbPDmwgqiIn3Oynkf2xRrC7xRwXH5NZ5QcqCnFrixjHT9Rn4O25lvq8icmJ5Sxcy95PeuwS",
	"Dre1ICyKEFnRLRES/zEP0n9UtGDzLfIZC77vRtSSGhJyBmTrReH8rs3Eu8WrsQfMK2KEn8qumw0dMxpu",
	"a0aJgDYXuS/bJsiK3kC8DeggYvlnpg3jVNUMlRrmym5tZxcLbvE+PdOK5rESABPNbhvcwSc8N73//zps",
	"NZ7K538sC5r5ktWu+FyTz2BVe09cegmr3WHOXb7mSSBUyq+JVvo0GfkdtKkHsq5UzE9fcawG2J0S4J26",
	"YPdaxkClcKvG0Y4A8UFLOfYuHCeGs7OkuNTvvsXFlY8/zO4kM0T3LWMI+H+gXWm4V3Qi29IV1OP12GLp",
	"H2AXGol4ErBaNfhMbCYS5mqfI43Vg8/EpgZYBd0t45kEqqzf0cVL92ytEyAzbp7R1ms3mFXDKDnMGa9Z",
	"LeNlpROvIMyDzLcRwmJrAqK1xzbXJ2MYUXRNi5drkJLlfRtnTo8tDRwX6fEWFNc3oQAJN3J3AKbqFyDG",
	"U9f6+biZuf5tgUHrO6s05TmVedyccZKBNFIDuaVbdXdTVbA67DNW0UgWamYLicxWSNoWkGLrrM33NCQF",
	"AOkRLUoDLEHopJ2wAlnFkBY9hp8uDH8KS9CKbiaFWGDUb8+BcHmu0XRoH5CCoxLdSnfD1u3nUex32D0N",
	"liJxjEgLnHXIFLvP/UvcSnyE/syZ3nnyrYazHYZtPZ3twfRI5Ys6PMMSS/c8piLnXWKmOHrei6o+TYmn",
	"PYg2MekS3dGq9+wi+le4tAuxCn14scqmC0cqPt/qFSaob1A7AjBA1XEFNHMeYl1FXEdRYZEydtkNDtTT",
	"We2+v5d6wENFinJnvTltcNAx4xxS4XN3PoNJKcpJNsS31VYryp2RwUHahLGHPiITQs+6g9+NCvW7GjnR",
	"GoW8Di1y2ltIbJ+trMx2qQz6lEw9HL1pwBBz5GV4hK1qDWOtgipm7B/n3tjdVKIFJkEokZBVEpXMt3S7",
	"v/BjT/b5y+/PP3v0+NfHn31OTAOSswWouqZBq3Bi7ZrIeFtr9GGdETvL0+lN8NlCLOK89dKHvYVNcWfN",
	"cltVJyPulI08RDuduABSwbndEnl32iscpw6L+GNtV2qRR9+xFAre/55JURTpmjJBrkqYX1K7FRlgzAuk",
	"BKmY0oYRNu2nTNdO2WqJykXMGr62uaEEz8Brnx0VMN3jy5VaSJ9PL/IzzMXgbE4ENmXheJW1E+1al3un",
	"Wf0eCo3objMDUorSifZsTlIQYcyWrCDo1Z3aFPXpkZtuYLbWYTdFiM75PU1659y9hMWc7Ob2zVLcOs3p",
	"zSYmxAt/KO9Amn3Wjf48I3fhJLVh4A/DPxKJU47GNcJy3wevSL4PdkSFn3e8JkLSkEGgdRNkJMgDAeiJ",
	"h24ErUZBdlFucmltDGiN8ObntvjxojZL741MQUh8hz3gxbHMdbsQTOHA+ciJvV8EpERLedNHCY3l7wuP",
	"9qw3XCTRFjmlidagLFsSXbEwCohXX4c4855XSSccXQqhiXmZFkUijN3qcfBMxYRjngRyTYsPzzW+ZVLp",
	"c8QH5D/1B27FYcsxki0q1dETcj6ng8CKQpQ/CFT8FcbW/weYnU3ejm4WZ/jv3IGoEqKF9faeBws4cHKL",
	"Y1rHrkefk5kr91NKyJhqOxTcepEmxNuCZHPnXwsb3Y79vXeZoF+EvsdxmHt/IPJjZGQLngMO5vqof2Tm",
	"1MMBkqclRaodQkngL8Xr4qLqe66de5aGuVsqpyhx44GpnLrl4ocuD9eBl1eloLvOwbd+A7eJC79e29Bc",
	"ZYMrzFxfv9azIQnF0tVgTHfMcXaUsjD3LwrzQRKcWVS6MRwkScKqRe592Wta/pJRnobmLhpxv6eA/NKi",
	"34yGj4J5xe14oQAqxop7ti7m4+DFILjp9pRc8xOiltS/Ldyfjz/7fDQeAa9WZvH199F45L6+Sb3U8k0y",
	"rrROpNPxEXXVBB4oUtLtkGD2valzkvitMwV9eJFGaTZLv+m+N3uGD1cXgHDBkdUje7E3qMuf81cCoJ3E",
	"0Dqs4cRYkqzTA4Wt2Jcp6Je+tPg29XtPtY8W961YsddJrlGI5d14tLBJyrA6ya+uVt2H3XYPQU++QLf0",
	"+6QBs4hJrLUxeTRVlNRtQEEW1y1RIQMjr7NKMr29NPj3anf2600qGdR3IT2Ty/kVLPBO9tXiBrj3MauT",
	"OVXKS9ffCVqg9GkdA7iROUUxJd/YCiHuWvzywexf4dO/PcnPPn30r7O/nX12lsGTz744O6NfPKGPvvj0",
	"ETz+22dPzuDR/PMvZo/zx08ez548fvL5Z19knz55NHvy+Rf/+sBQugHZAuor/zwd/efkvFiIyfmri8mV",
	"AbbGCS3ZD2D2BjVsc0xQiEjN8IqFFWXF6Kn/6X/5i3KaiVU9vP915OpBjpZal+rp6ent7e007nK6wBwo",
	"Ey2qbHnq58Fclo33yquLEBdkff9wR2ubE25qyO9nvv30zeUVOX91Ma0JZvR0dDY9mz7CfIolcFqy0dPR",
	"p/gTnp4l7vspZtE+Va4Yz2kIHX037nwrS1uqx3xahDSg5q8l0AJZpPljBVqyzH+SQPOt+7+6pYsFyClG",
	"jNmf1o9P/dvj9K3LK/Nu17fT2Bvt9G0jOU++p6f3p9rX5PStL/e/e8BGKXfn52qQmnSU+A60S6NnNZaJ",
	"PEdon3Sjj4nCujvmp1IyYc7r2IgLOaA3EbrUSqwvomXFM+tiYqcAjv99cf6f6Gbz4vw/yZfkbOyCnBSq",
	"QVLT21QRgdAucgt21zdafbU9D5mgapec0dPXKdW0c1Avq1nBMvOKmPqTasgwOkhhyJpRoiFiZC8K9A8I",
	"bN+w8rPJF2/efva3d0mP9K5zWu3VufNrR8IM+I0yJzXcTIQv5I74XtHNl33Y3riAGTPuPyqQ23r5K2pu",
	"6XqpAyXA5K+JlJk+8vHW1UyPna4jd+x/v3z5IxGSOMXeK5rdhKhPHwFcRz3HAcCmZ9/a3O0dL8/L1S58",
	"dKUWZbOWQNADvMGi0Ago8qzHZ2eeUTulR8QFTh1ziWZqicZdakYPwsiG0k3/oQhsaKaLLaEqcuFCd2xf",
	"wL0VmyvKSSNCaKfVpjuj25JkeNWhGUgSpXCEpsUe+K5axa4b6HDvltLc5PtTfnSQkYQgme423lpPI3/t",
	"7v+M3e2KPqQU5kwzDDip7zV/ZzaAdAJvsfXg9qRhmpL/EhUKqObpUWkILFBIZGfhVrbmWjeny0IXvdLq",
	"mEj8cnLSXvjJSe2RPIdbZLKUY8M2Ok5OpmannhzIynaa0BoVCQadnUOG62zWC7oJihRKuOATDguq2RpI",
	"5E315OzRn3aFF9wG4BiJ3L4c3o1Hn/2Jt+yCG+GJFgRb2tV8+qddzSXINcuAXMGqFJJKVmzJzzxEONmX",
	"FconXfb3M7/h4pZ7RJhHcbVaUbl1kjoNPKfiUSnCnfynk/+tluaRi9KFQjc9lIOt4Ozz3vLF6M07/9AY",
	"+MDZ1ex0hvW6hzaF+FXU/wRCLaU6fYu2vd7fT52eL/0Rza/2hX7qlZc9LW0OwvTHxtPrrd6YhewezrSJ",
	"xsuozpZVefoW/4OP7WhFtv7Pqd7wU3RXP33bQIT73EFE8/e6e9wCy1Z44MR8rvCxuOvz6Vv7bzQRbEqQ",
	"zFxHmBrZ/Wqz4Z+qqiyLbffnLc+SP3bX0Uj63fPzqdf1pN7tzZZvG382aUotK52L22gWtJJax4AuZOZj",
	"pdp/n95Spo2Q5LJG07kG2e2sgRanrjJh69e63E/nC9Ywin5siVWlsInTms/mn+jtVSPIXdosQF8J1Ib0",
	"MdzNZMY4cqGYS9a6T/ux+0Tq8EasH7/VtdNJQgbVgsykoHlGlTZ/1GVGmu/vd/d8f7WTFl0k/AYQTNRp",
	"dG0khp9M99qHcdwhQma0L+TimZ+wjqx974JZB6KvaE58pr0JeUELs+GQk3Mn/jew8b6Fqo8vBX1kseWD",
	"yRlf+cOnCMW0o40HokxnA4vq8A4RKswr0jCABfCJY0GTmci3ruLpSNJbvbHJh9rM7ZQ2b4ymtpNKulJ9",
	"H4+gCv1j6z/3qT3/Uhn+pTL8S6n0l8rwr939S2V4dJXhXwq1vxRq/08q1A7RoqUEUqco6pdL2Rq4Dbtp",
	"vRBpXWoosPhmAkWmg/TWiIXHqkZMTwm5wuxX1NwSsAZJC5JRZaUrl6lthc7mmIYR8qfXfNKAxDpwm4k/",
	"qf9r3eyvq7OzT4GcPWz3UZoVRcybu31RMsZPNkjuS3I9uh51RpKwEmvIrZdaXGfC9to77P8Xxn3ZKWiD",
	"qTwwvZjP1khUNZ+zjFmUF4IvCF2IOnoE01VzgV9AGuCsbyNheuyi7ZhL8WB3pVUOoynjdyWAi3oL93o4",
	"tMgl7dtgCO9Ax4Z/Sak8/pLSBzK7XQn97stId47d4ap/cZUPwVU+Ol/5s5tzIyXk/0gx88nZkz/tgmKV",
	"9Y9Ck2997Ns9xDGXKzlLFly8q6Dls115xWDtJx37HeMtGjyOX78xF4ECufYXbO1G+/T0FJMnLoXSp6ik",
	"arrYxh/fBJjf+tuplGxtoHmHelAh2YJxWkycH+qkdpV9PD0bvfu/AQAA///38T8KmyYBAA==",
}

// GetSwagger returns the content of the embedded swagger specification file
// or error if failed to decode
func decodeSpec() ([]byte, error) {
	zipped, err := base64.StdEncoding.DecodeString(strings.Join(swaggerSpec, ""))
	if err != nil {
		return nil, fmt.Errorf("error base64 decoding spec: %w", err)
	}
	zr, err := gzip.NewReader(bytes.NewReader(zipped))
	if err != nil {
		return nil, fmt.Errorf("error decompressing spec: %w", err)
	}
	var buf bytes.Buffer
	_, err = buf.ReadFrom(zr)
	if err != nil {
		return nil, fmt.Errorf("error decompressing spec: %w", err)
	}

	return buf.Bytes(), nil
}

var rawSpec = decodeSpecCached()

// a naive cached of a decoded swagger spec
func decodeSpecCached() func() ([]byte, error) {
	data, err := decodeSpec()
	return func() ([]byte, error) {
		return data, err
	}
}

// Constructs a synthetic filesystem for resolving external references when loading openapi specifications.
func PathToRawSpec(pathToFile string) map[string]func() ([]byte, error) {
	res := make(map[string]func() ([]byte, error))
	if len(pathToFile) > 0 {
		res[pathToFile] = rawSpec
	}

	return res
}

// GetSwagger returns the Swagger specification corresponding to the generated code
// in this file. The external references of Swagger specification are resolved.
// The logic of resolving external references is tightly connected to "import-mapping" feature.
// Externally referenced files must be embedded in the corresponding golang packages.
// Urls can be supported but this task was out of the scope.
func GetSwagger() (swagger *openapi3.T, err error) {
	resolvePath := PathToRawSpec("")

	loader := openapi3.NewLoader()
	loader.IsExternalRefsAllowed = true
	loader.ReadFromURIFunc = func(loader *openapi3.Loader, url *url.URL) ([]byte, error) {
		pathToFile := url.String()
		pathToFile = path.Clean(pathToFile)
		getSpec, ok := resolvePath[pathToFile]
		if !ok {
			err1 := fmt.Errorf("path not found: %s", pathToFile)
			return nil, err1
		}
		return getSpec()
	}
	var specData []byte
	specData, err = rawSpec()
	if err != nil {
		return
	}
	swagger, err = loader.LoadFromData(specData)
	if err != nil {
		return
	}
	return
}
