// Package public provides primitives to interact with the openapi HTTP API.
//
// Code generated by github.com/oapi-codegen/oapi-codegen/v2 version v2.4.1 DO NOT EDIT.
package public

import (
	"bytes"
	"compress/gzip"
	"encoding/base64"
	"fmt"
	"net/http"
	"net/url"
	"path"
	"strings"

	. "github.com/algorand/go-algorand/daemon/algod/api/server/v2/generated/model"
	"github.com/algorand/go-algorand/data/basics"
	"github.com/getkin/kin-openapi/openapi3"
	"github.com/labstack/echo/v4"
	"github.com/oapi-codegen/runtime"
)

// ServerInterface represents all server handlers.
type ServerInterface interface {
	// Get account information.
	// (GET /v2/accounts/{address})
	AccountInformation(ctx echo.Context, address basics.Address, params AccountInformationParams) error
	// Get account information about a given app.
	// (GET /v2/accounts/{address}/applications/{application-id})
	AccountApplicationInformation(ctx echo.Context, address basics.Address, applicationId basics.AppIndex, params AccountApplicationInformationParams) error
	// Get account information about a given asset.
	// (GET /v2/accounts/{address}/assets/{asset-id})
	AccountAssetInformation(ctx echo.Context, address basics.Address, assetId basics.AssetIndex, params AccountAssetInformationParams) error
	// Get application information.
	// (GET /v2/applications/{application-id})
	GetApplicationByID(ctx echo.Context, applicationId basics.AppIndex) error
	// Get box information for a given application.
	// (GET /v2/applications/{application-id}/box)
	GetApplicationBoxByName(ctx echo.Context, applicationId basics.AppIndex, params GetApplicationBoxByNameParams) error
	// Get all box names for a given application.
	// (GET /v2/applications/{application-id}/boxes)
	GetApplicationBoxes(ctx echo.Context, applicationId basics.AppIndex, params GetApplicationBoxesParams) error
	// Get asset information.
	// (GET /v2/assets/{asset-id})
	GetAssetByID(ctx echo.Context, assetId basics.AssetIndex) error
	// Get the block for the given round.
	// (GET /v2/blocks/{round})
	GetBlock(ctx echo.Context, round basics.Round, params GetBlockParams) error
	// Get the block hash for the block on the given round.
	// (GET /v2/blocks/{round}/hash)
	GetBlockHash(ctx echo.Context, round basics.Round) error
	// Gets a proof for a given light block header inside a state proof commitment
	// (GET /v2/blocks/{round}/lightheader/proof)
	GetLightBlockHeaderProof(ctx echo.Context, round basics.Round) error
	// Get all of the logs from outer and inner app calls in the given round
	// (GET /v2/blocks/{round}/logs)
	GetBlockLogs(ctx echo.Context, round basics.Round) error
	// Get a proof for a transaction in a block.
	// (GET /v2/blocks/{round}/transactions/{txid}/proof)
	GetTransactionProof(ctx echo.Context, round basics.Round, txid string, params GetTransactionProofParams) error
	// Get the top level transaction IDs for the block on the given round.
	// (GET /v2/blocks/{round}/txids)
	GetBlockTxids(ctx echo.Context, round basics.Round) error
	// Get a LedgerStateDelta object for a given transaction group
	// (GET /v2/deltas/txn/group/{id})
	GetLedgerStateDeltaForTransactionGroup(ctx echo.Context, id string, params GetLedgerStateDeltaForTransactionGroupParams) error
	// Get a LedgerStateDelta object for a given round
	// (GET /v2/deltas/{round})
	GetLedgerStateDelta(ctx echo.Context, round basics.Round, params GetLedgerStateDeltaParams) error
	// Get LedgerStateDelta objects for all transaction groups in a given round
	// (GET /v2/deltas/{round}/txn/group)
	GetTransactionGroupLedgerStateDeltasForRound(ctx echo.Context, round basics.Round, params GetTransactionGroupLedgerStateDeltasForRoundParams) error
	// Returns the timestamp offset. Timestamp offsets can only be set in dev mode.
	// (GET /v2/devmode/blocks/offset)
	GetBlockTimeStampOffset(ctx echo.Context) error
	// Given a timestamp offset in seconds, adds the offset to every subsequent block header's timestamp.
	// (POST /v2/devmode/blocks/offset/{offset})
	SetBlockTimeStampOffset(ctx echo.Context, offset uint64) error
	// Get the current supply reported by the ledger.
	// (GET /v2/ledger/supply)
	GetSupply(ctx echo.Context) error
	// Get a state proof that covers a given round
	// (GET /v2/stateproofs/{round})
	GetStateProof(ctx echo.Context, round basics.Round) error
	// Gets the current node status.
	// (GET /v2/status)
	GetStatus(ctx echo.Context) error
	// Gets the node status after waiting for a round after the given round.
	// (GET /v2/status/wait-for-block-after/{round})
	WaitForBlock(ctx echo.Context, round basics.Round) error
	// Compile TEAL source code to binary, produce its hash
	// (POST /v2/teal/compile)
	TealCompile(ctx echo.Context, params TealCompileParams) error
	// Disassemble program bytes into the TEAL source code.
	// (POST /v2/teal/disassemble)
	TealDisassemble(ctx echo.Context) error
	// Provide debugging information for a transaction (or group).
	// (POST /v2/teal/dryrun)
	TealDryrun(ctx echo.Context) error
	// Get parameters for constructing a new transaction
	// (GET /v2/transactions/params)
	TransactionParams(ctx echo.Context) error
	// Simulates a raw transaction or transaction group as it would be evaluated on the network. The simulation will use blockchain state from the latest committed round.
	// (POST /v2/transactions/simulate)
	SimulateTransaction(ctx echo.Context, params SimulateTransactionParams) error
}

// ServerInterfaceWrapper converts echo contexts to parameters.
type ServerInterfaceWrapper struct {
	Handler ServerInterface
}

// AccountInformation converts echo context to params.
func (w *ServerInterfaceWrapper) AccountInformation(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "address" -------------
	var address basics.Address

	err = runtime.BindStyledParameterWithOptions("simple", "address", ctx.Param("address"), &address, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter address: %s", err))
	}

	ctx.Set(Api_keyScopes, []string{})

	// Parameter object where we will unmarshal all parameters from the context
	var params AccountInformationParams
	// ------------- Optional query parameter "exclude" -------------

	err = runtime.BindQueryParameter("form", true, false, "exclude", ctx.QueryParams(), &params.Exclude)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter exclude: %s", err))
	}

	// ------------- Optional query parameter "format" -------------

	err = runtime.BindQueryParameter("form", true, false, "format", ctx.QueryParams(), &params.Format)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter format: %s", err))
	}

	// Invoke the callback with all the unmarshaled arguments
	err = w.Handler.AccountInformation(ctx, address, params)
	return err
}

// AccountApplicationInformation converts echo context to params.
func (w *ServerInterfaceWrapper) AccountApplicationInformation(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "address" -------------
	var address basics.Address

	err = runtime.BindStyledParameterWithOptions("simple", "address", ctx.Param("address"), &address, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter address: %s", err))
	}

	// ------------- Path parameter "application-id" -------------
	var applicationId basics.AppIndex

	err = runtime.BindStyledParameterWithOptions("simple", "application-id", ctx.Param("application-id"), &applicationId, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter application-id: %s", err))
	}

	ctx.Set(Api_keyScopes, []string{})

	// Parameter object where we will unmarshal all parameters from the context
	var params AccountApplicationInformationParams
	// ------------- Optional query parameter "format" -------------

	err = runtime.BindQueryParameter("form", true, false, "format", ctx.QueryParams(), &params.Format)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter format: %s", err))
	}

	// Invoke the callback with all the unmarshaled arguments
	err = w.Handler.AccountApplicationInformation(ctx, address, applicationId, params)
	return err
}

// AccountAssetInformation converts echo context to params.
func (w *ServerInterfaceWrapper) AccountAssetInformation(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "address" -------------
	var address basics.Address

	err = runtime.BindStyledParameterWithOptions("simple", "address", ctx.Param("address"), &address, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter address: %s", err))
	}

	// ------------- Path parameter "asset-id" -------------
	var assetId basics.AssetIndex

	err = runtime.BindStyledParameterWithOptions("simple", "asset-id", ctx.Param("asset-id"), &assetId, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter asset-id: %s", err))
	}

	ctx.Set(Api_keyScopes, []string{})

	// Parameter object where we will unmarshal all parameters from the context
	var params AccountAssetInformationParams
	// ------------- Optional query parameter "format" -------------

	err = runtime.BindQueryParameter("form", true, false, "format", ctx.QueryParams(), &params.Format)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter format: %s", err))
	}

	// Invoke the callback with all the unmarshaled arguments
	err = w.Handler.AccountAssetInformation(ctx, address, assetId, params)
	return err
}

// GetApplicationByID converts echo context to params.
func (w *ServerInterfaceWrapper) GetApplicationByID(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "application-id" -------------
	var applicationId basics.AppIndex

	err = runtime.BindStyledParameterWithOptions("simple", "application-id", ctx.Param("application-id"), &applicationId, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter application-id: %s", err))
	}

	ctx.Set(Api_keyScopes, []string{})

	// Invoke the callback with all the unmarshaled arguments
	err = w.Handler.GetApplicationByID(ctx, applicationId)
	return err
}

// GetApplicationBoxByName converts echo context to params.
func (w *ServerInterfaceWrapper) GetApplicationBoxByName(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "application-id" -------------
	var applicationId basics.AppIndex

	err = runtime.BindStyledParameterWithOptions("simple", "application-id", ctx.Param("application-id"), &applicationId, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter application-id: %s", err))
	}

	ctx.Set(Api_keyScopes, []string{})

	// Parameter object where we will unmarshal all parameters from the context
	var params GetApplicationBoxByNameParams
	// ------------- Required query parameter "name" -------------

	err = runtime.BindQueryParameter("form", true, true, "name", ctx.QueryParams(), &params.Name)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter name: %s", err))
	}

	// Invoke the callback with all the unmarshaled arguments
	err = w.Handler.GetApplicationBoxByName(ctx, applicationId, params)
	return err
}

// GetApplicationBoxes converts echo context to params.
func (w *ServerInterfaceWrapper) GetApplicationBoxes(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "application-id" -------------
	var applicationId basics.AppIndex

	err = runtime.BindStyledParameterWithOptions("simple", "application-id", ctx.Param("application-id"), &applicationId, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter application-id: %s", err))
	}

	ctx.Set(Api_keyScopes, []string{})

	// Parameter object where we will unmarshal all parameters from the context
	var params GetApplicationBoxesParams
	// ------------- Optional query parameter "max" -------------

	err = runtime.BindQueryParameter("form", true, false, "max", ctx.QueryParams(), &params.Max)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter max: %s", err))
	}

	// Invoke the callback with all the unmarshaled arguments
	err = w.Handler.GetApplicationBoxes(ctx, applicationId, params)
	return err
}

// GetAssetByID converts echo context to params.
func (w *ServerInterfaceWrapper) GetAssetByID(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "asset-id" -------------
	var assetId basics.AssetIndex

	err = runtime.BindStyledParameterWithOptions("simple", "asset-id", ctx.Param("asset-id"), &assetId, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter asset-id: %s", err))
	}

	ctx.Set(Api_keyScopes, []string{})

	// Invoke the callback with all the unmarshaled arguments
	err = w.Handler.GetAssetByID(ctx, assetId)
	return err
}

// GetBlock converts echo context to params.
func (w *ServerInterfaceWrapper) GetBlock(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "round" -------------
	var round basics.Round

	err = runtime.BindStyledParameterWithOptions("simple", "round", ctx.Param("round"), &round, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter round: %s", err))
	}

	ctx.Set(Api_keyScopes, []string{})

	// Parameter object where we will unmarshal all parameters from the context
	var params GetBlockParams
	// ------------- Optional query parameter "header-only" -------------

	err = runtime.BindQueryParameter("form", true, false, "header-only", ctx.QueryParams(), &params.HeaderOnly)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter header-only: %s", err))
	}

	// ------------- Optional query parameter "format" -------------

	err = runtime.BindQueryParameter("form", true, false, "format", ctx.QueryParams(), &params.Format)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter format: %s", err))
	}

	// Invoke the callback with all the unmarshaled arguments
	err = w.Handler.GetBlock(ctx, round, params)
	return err
}

// GetBlockHash converts echo context to params.
func (w *ServerInterfaceWrapper) GetBlockHash(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "round" -------------
	var round basics.Round

	err = runtime.BindStyledParameterWithOptions("simple", "round", ctx.Param("round"), &round, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter round: %s", err))
	}

	ctx.Set(Api_keyScopes, []string{})

	// Invoke the callback with all the unmarshaled arguments
	err = w.Handler.GetBlockHash(ctx, round)
	return err
}

// GetLightBlockHeaderProof converts echo context to params.
func (w *ServerInterfaceWrapper) GetLightBlockHeaderProof(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "round" -------------
	var round basics.Round

	err = runtime.BindStyledParameterWithOptions("simple", "round", ctx.Param("round"), &round, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter round: %s", err))
	}

	ctx.Set(Api_keyScopes, []string{})

	// Invoke the callback with all the unmarshaled arguments
	err = w.Handler.GetLightBlockHeaderProof(ctx, round)
	return err
}

// GetBlockLogs converts echo context to params.
func (w *ServerInterfaceWrapper) GetBlockLogs(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "round" -------------
	var round basics.Round

	err = runtime.BindStyledParameterWithOptions("simple", "round", ctx.Param("round"), &round, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter round: %s", err))
	}

	ctx.Set(Api_keyScopes, []string{})

	// Invoke the callback with all the unmarshaled arguments
	err = w.Handler.GetBlockLogs(ctx, round)
	return err
}

// GetTransactionProof converts echo context to params.
func (w *ServerInterfaceWrapper) GetTransactionProof(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "round" -------------
	var round basics.Round

	err = runtime.BindStyledParameterWithOptions("simple", "round", ctx.Param("round"), &round, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter round: %s", err))
	}

	// ------------- Path parameter "txid" -------------
	var txid string

	err = runtime.BindStyledParameterWithOptions("simple", "txid", ctx.Param("txid"), &txid, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter txid: %s", err))
	}

	ctx.Set(Api_keyScopes, []string{})

	// Parameter object where we will unmarshal all parameters from the context
	var params GetTransactionProofParams
	// ------------- Optional query parameter "hashtype" -------------

	err = runtime.BindQueryParameter("form", true, false, "hashtype", ctx.QueryParams(), &params.Hashtype)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter hashtype: %s", err))
	}

	// ------------- Optional query parameter "format" -------------

	err = runtime.BindQueryParameter("form", true, false, "format", ctx.QueryParams(), &params.Format)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter format: %s", err))
	}

	// Invoke the callback with all the unmarshaled arguments
	err = w.Handler.GetTransactionProof(ctx, round, txid, params)
	return err
}

// GetBlockTxids converts echo context to params.
func (w *ServerInterfaceWrapper) GetBlockTxids(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "round" -------------
	var round basics.Round

	err = runtime.BindStyledParameterWithOptions("simple", "round", ctx.Param("round"), &round, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter round: %s", err))
	}

	ctx.Set(Api_keyScopes, []string{})

	// Invoke the callback with all the unmarshaled arguments
	err = w.Handler.GetBlockTxids(ctx, round)
	return err
}

// GetLedgerStateDeltaForTransactionGroup converts echo context to params.
func (w *ServerInterfaceWrapper) GetLedgerStateDeltaForTransactionGroup(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameterWithOptions("simple", "id", ctx.Param("id"), &id, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	ctx.Set(Api_keyScopes, []string{})

	// Parameter object where we will unmarshal all parameters from the context
	var params GetLedgerStateDeltaForTransactionGroupParams
	// ------------- Optional query parameter "format" -------------

	err = runtime.BindQueryParameter("form", true, false, "format", ctx.QueryParams(), &params.Format)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter format: %s", err))
	}

	// Invoke the callback with all the unmarshaled arguments
	err = w.Handler.GetLedgerStateDeltaForTransactionGroup(ctx, id, params)
	return err
}

// GetLedgerStateDelta converts echo context to params.
func (w *ServerInterfaceWrapper) GetLedgerStateDelta(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "round" -------------
	var round basics.Round

	err = runtime.BindStyledParameterWithOptions("simple", "round", ctx.Param("round"), &round, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter round: %s", err))
	}

	ctx.Set(Api_keyScopes, []string{})

	// Parameter object where we will unmarshal all parameters from the context
	var params GetLedgerStateDeltaParams
	// ------------- Optional query parameter "format" -------------

	err = runtime.BindQueryParameter("form", true, false, "format", ctx.QueryParams(), &params.Format)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter format: %s", err))
	}

	// Invoke the callback with all the unmarshaled arguments
	err = w.Handler.GetLedgerStateDelta(ctx, round, params)
	return err
}

// GetTransactionGroupLedgerStateDeltasForRound converts echo context to params.
func (w *ServerInterfaceWrapper) GetTransactionGroupLedgerStateDeltasForRound(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "round" -------------
	var round basics.Round

	err = runtime.BindStyledParameterWithOptions("simple", "round", ctx.Param("round"), &round, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter round: %s", err))
	}

	ctx.Set(Api_keyScopes, []string{})

	// Parameter object where we will unmarshal all parameters from the context
	var params GetTransactionGroupLedgerStateDeltasForRoundParams
	// ------------- Optional query parameter "format" -------------

	err = runtime.BindQueryParameter("form", true, false, "format", ctx.QueryParams(), &params.Format)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter format: %s", err))
	}

	// Invoke the callback with all the unmarshaled arguments
	err = w.Handler.GetTransactionGroupLedgerStateDeltasForRound(ctx, round, params)
	return err
}

// GetBlockTimeStampOffset converts echo context to params.
func (w *ServerInterfaceWrapper) GetBlockTimeStampOffset(ctx echo.Context) error {
	var err error

	ctx.Set(Api_keyScopes, []string{})

	// Invoke the callback with all the unmarshaled arguments
	err = w.Handler.GetBlockTimeStampOffset(ctx)
	return err
}

// SetBlockTimeStampOffset converts echo context to params.
func (w *ServerInterfaceWrapper) SetBlockTimeStampOffset(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "offset" -------------
	var offset uint64

	err = runtime.BindStyledParameterWithOptions("simple", "offset", ctx.Param("offset"), &offset, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter offset: %s", err))
	}

	ctx.Set(Api_keyScopes, []string{})

	// Invoke the callback with all the unmarshaled arguments
	err = w.Handler.SetBlockTimeStampOffset(ctx, offset)
	return err
}

// GetSupply converts echo context to params.
func (w *ServerInterfaceWrapper) GetSupply(ctx echo.Context) error {
	var err error

	ctx.Set(Api_keyScopes, []string{})

	// Invoke the callback with all the unmarshaled arguments
	err = w.Handler.GetSupply(ctx)
	return err
}

// GetStateProof converts echo context to params.
func (w *ServerInterfaceWrapper) GetStateProof(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "round" -------------
	var round basics.Round

	err = runtime.BindStyledParameterWithOptions("simple", "round", ctx.Param("round"), &round, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter round: %s", err))
	}

	ctx.Set(Api_keyScopes, []string{})

	// Invoke the callback with all the unmarshaled arguments
	err = w.Handler.GetStateProof(ctx, round)
	return err
}

// GetStatus converts echo context to params.
func (w *ServerInterfaceWrapper) GetStatus(ctx echo.Context) error {
	var err error

	ctx.Set(Api_keyScopes, []string{})

	// Invoke the callback with all the unmarshaled arguments
	err = w.Handler.GetStatus(ctx)
	return err
}

// WaitForBlock converts echo context to params.
func (w *ServerInterfaceWrapper) WaitForBlock(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "round" -------------
	var round basics.Round

	err = runtime.BindStyledParameterWithOptions("simple", "round", ctx.Param("round"), &round, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter round: %s", err))
	}

	ctx.Set(Api_keyScopes, []string{})

	// Invoke the callback with all the unmarshaled arguments
	err = w.Handler.WaitForBlock(ctx, round)
	return err
}

// TealCompile converts echo context to params.
func (w *ServerInterfaceWrapper) TealCompile(ctx echo.Context) error {
	var err error

	ctx.Set(Api_keyScopes, []string{})

	// Parameter object where we will unmarshal all parameters from the context
	var params TealCompileParams
	// ------------- Optional query parameter "sourcemap" -------------

	err = runtime.BindQueryParameter("form", true, false, "sourcemap", ctx.QueryParams(), &params.Sourcemap)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter sourcemap: %s", err))
	}

	// Invoke the callback with all the unmarshaled arguments
	err = w.Handler.TealCompile(ctx, params)
	return err
}

// TealDisassemble converts echo context to params.
func (w *ServerInterfaceWrapper) TealDisassemble(ctx echo.Context) error {
	var err error

	ctx.Set(Api_keyScopes, []string{})

	// Invoke the callback with all the unmarshaled arguments
	err = w.Handler.TealDisassemble(ctx)
	return err
}

// TealDryrun converts echo context to params.
func (w *ServerInterfaceWrapper) TealDryrun(ctx echo.Context) error {
	var err error

	ctx.Set(Api_keyScopes, []string{})

	// Invoke the callback with all the unmarshaled arguments
	err = w.Handler.TealDryrun(ctx)
	return err
}

// TransactionParams converts echo context to params.
func (w *ServerInterfaceWrapper) TransactionParams(ctx echo.Context) error {
	var err error

	ctx.Set(Api_keyScopes, []string{})

	// Invoke the callback with all the unmarshaled arguments
	err = w.Handler.TransactionParams(ctx)
	return err
}

// SimulateTransaction converts echo context to params.
func (w *ServerInterfaceWrapper) SimulateTransaction(ctx echo.Context) error {
	var err error

	ctx.Set(Api_keyScopes, []string{})

	// Parameter object where we will unmarshal all parameters from the context
	var params SimulateTransactionParams
	// ------------- Optional query parameter "format" -------------

	err = runtime.BindQueryParameter("form", true, false, "format", ctx.QueryParams(), &params.Format)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter format: %s", err))
	}

	// Invoke the callback with all the unmarshaled arguments
	err = w.Handler.SimulateTransaction(ctx, params)
	return err
}

// This is a simple interface which specifies echo.Route addition functions which
// are present on both echo.Echo and echo.Group, since we want to allow using
// either of them for path registration
type EchoRouter interface {
	CONNECT(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	DELETE(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	GET(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	HEAD(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	OPTIONS(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	PATCH(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	POST(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	PUT(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	TRACE(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
}

// RegisterHandlers adds each server route to the EchoRouter.
func RegisterHandlers(router EchoRouter, si ServerInterface, m ...echo.MiddlewareFunc) {
	RegisterHandlersWithBaseURL(router, si, "", m...)
}

// Registers handlers, and prepends BaseURL to the paths, so that the paths
// can be served under a prefix.
func RegisterHandlersWithBaseURL(router EchoRouter, si ServerInterface, baseURL string, m ...echo.MiddlewareFunc) {

	wrapper := ServerInterfaceWrapper{
		Handler: si,
	}

	router.GET(baseURL+"/v2/accounts/:address", wrapper.AccountInformation, m...)
	router.GET(baseURL+"/v2/accounts/:address/applications/:application-id", wrapper.AccountApplicationInformation, m...)
	router.GET(baseURL+"/v2/accounts/:address/assets/:asset-id", wrapper.AccountAssetInformation, m...)
	router.GET(baseURL+"/v2/applications/:application-id", wrapper.GetApplicationByID, m...)
	router.GET(baseURL+"/v2/applications/:application-id/box", wrapper.GetApplicationBoxByName, m...)
	router.GET(baseURL+"/v2/applications/:application-id/boxes", wrapper.GetApplicationBoxes, m...)
	router.GET(baseURL+"/v2/assets/:asset-id", wrapper.GetAssetByID, m...)
	router.GET(baseURL+"/v2/blocks/:round", wrapper.GetBlock, m...)
	router.GET(baseURL+"/v2/blocks/:round/hash", wrapper.GetBlockHash, m...)
	router.GET(baseURL+"/v2/blocks/:round/lightheader/proof", wrapper.GetLightBlockHeaderProof, m...)
	router.GET(baseURL+"/v2/blocks/:round/logs", wrapper.GetBlockLogs, m...)
	router.GET(baseURL+"/v2/blocks/:round/transactions/:txid/proof", wrapper.GetTransactionProof, m...)
	router.GET(baseURL+"/v2/blocks/:round/txids", wrapper.GetBlockTxids, m...)
	router.GET(baseURL+"/v2/deltas/txn/group/:id", wrapper.GetLedgerStateDeltaForTransactionGroup, m...)
	router.GET(baseURL+"/v2/deltas/:round", wrapper.GetLedgerStateDelta, m...)
	router.GET(baseURL+"/v2/deltas/:round/txn/group", wrapper.GetTransactionGroupLedgerStateDeltasForRound, m...)
	router.GET(baseURL+"/v2/devmode/blocks/offset", wrapper.GetBlockTimeStampOffset, m...)
	router.POST(baseURL+"/v2/devmode/blocks/offset/:offset", wrapper.SetBlockTimeStampOffset, m...)
	router.GET(baseURL+"/v2/ledger/supply", wrapper.GetSupply, m...)
	router.GET(baseURL+"/v2/stateproofs/:round", wrapper.GetStateProof, m...)
	router.GET(baseURL+"/v2/status", wrapper.GetStatus, m...)
	router.GET(baseURL+"/v2/status/wait-for-block-after/:round", wrapper.WaitForBlock, m...)
	router.POST(baseURL+"/v2/teal/compile", wrapper.TealCompile, m...)
	router.POST(baseURL+"/v2/teal/disassemble", wrapper.TealDisassemble, m...)
	router.POST(baseURL+"/v2/teal/dryrun", wrapper.TealDryrun, m...)
	router.GET(baseURL+"/v2/transactions/params", wrapper.TransactionParams, m...)
	router.POST(baseURL+"/v2/transactions/simulate", wrapper.SimulateTransaction, m...)

}

// Base64 encoded, gzipped, json marshaled Swagger object
var swaggerSpec = []string{

	"H4sIAAAAAAAC/+y9a5PbNpMo/FdQOlvly0oa23GyT/xWat+JnctsHNvlmWTPbuyTQGRLwg4F8AHAGSk+",
	"/u+n0LgQJEGJmtH4kswne0QSaDQa3Y2+vhtlYlUKDlyr0ZN3o5JKugINEv+ieS5B4X9zUJlkpWaCj56M",
	"jjmhWSYqrklZzQqWkXPYTEfjETNPS6qXo/GI0xWMnoRBxiMJ/6yYhHz0RMsKxiOVLWFF7bRagzTf/nY8",
	"+e8Hk6/fvvvyH+9H45HelGYMpSXji9F4tJ4sxMT9OKOKZWp67MZ/v+spLcuCZdQsYcLy9KLqVwjLgWs2",
	"ZyD7FtYcb9v6VoyzVbUaPXkQlsS4hgXInjWV5QnPYd23qOgxVQp073rMwwEr8WMcdA1m0K2raLyQUZ0t",
	"S8G4TqyE4FNiHyeXEH2+bRFzIVdUt9+PyA9p7+H44YP3/yuQ4sPxl1+kiZEWCyEpzydh3KdhXHJq33u/",
	"x4v+aRsBTwWfs0UlQZHLJeglSKKXQCSoUnAFRMz+BzJNmCL/cfryBRGS/AxK0QW8otk5AZ6JHPIpOZkT",
	"LjQppbhgOeRjksOcVoVWRAv8MtDHPyuQmxq7Dq4Yk8ANLfw2+h8l+Gg8WqlFSbPz0ds2mt6/H48KtmKJ",
	"Vf1M14aiCK9WM5BEzM2CPDgSdCV5H0B2xBierSRZMa6/etymw/rXFV13wTuTFc+ohjwCUEvKFc3MGwhl",
	"zlRZ0A2idkXX3zwYO8AVoUVBSuA54wui11z1LcXMfbCFcFgnEH22BGKekJIuIMLzlPyiACkJn2pxDjxQ",
	"B5lt8FEp4YKJSoWPetaBUycWEtGBFBVPMSqCDxyae3iU/faQDOo1jvh++zPFFu5RG+pTtjjblEDmrDDy",
	"kvxPpXQg4Erhti+BqBIyw3tzYoYxyFdswamuJDx5w++bv8iEnGrKcypz88vK/vRzVWh2yhbmp8L+9Fws",
	"WHbKFj07EGBNnVOFn63sP2a89FHV66QseS7EeVXGC8ris2Bo5eRZH2XYMftJI80gj4PegPvjxjpbnzzr",
	"Y6nbv9DrsJE9QPbirqTmxXPYSDDQ0myO/6znSFp0Lv8cWfXCfK3LeQq1hvwdu0aF6tjqT8e1EvHaPTZP",
	"M8E1WFEYqRlHyGyfvIs1JylKkJrZQWlZTgqR0WKiNNU40r9ImI+ejP7XUa3oHdnP1VE0+XPz1Sl+ZISx",
	"BMP4JrQs9xjjlVEeUdXqOeiGD9mjPheSXC5ZtiR6yRRh3G4i6l2G0xRwQbmejvY6ye9j7vCbA6LeCisk",
	"7Va0GFDvXhD74gwU0r5Teu+ohqaIGCeIcUJ5ThaFmIUf7h6XZY1cfH5clhZVY8LmBBjKc1gzpdU9xAyt",
	"D1k8z8mzKfkhHvuSFQURvNiQGTi5A7kZ0/Jtx8edAm4Qi2uoR7yjCO60kFOzax4NRi87BDGiVrkUhRGB",
	"O8nIvPyjezemQPP7oI8/e+qL0d5Pd6jRO6QiNdlf6osbudsiqi5N4ReGmo7b316NoswoW2hJndQIPjRd",
	"4S9Mw0rtJJIIoojQ3PZQKenGa1AT1IS6FPSLAks8JV0wjtCOjULOyYqe2/0QiHdDCKCCpm3JzKpXl0wv",
	"a5UroH7auV983oSc2nNiNpwyoxuTgiltlCHcTEWWUKDCSYNhIaaiKxHNAFrYsogA86WkpSVz98TqcYwT",
	"Gu5fFtZrSvKBQjYJc2y2qPGOUF2Zme9kuElIrMGhCcO3hcjOf6RqeYDDP/NjdY8FTkOWQHOQZEnVMnGm",
	"WrRdjzaEvs2LSLNkFk01DUt8LhbqAEssxD5crSyf0qIwU3e5WWu1OPCgg1wUxLxMYMW0uQAzjidgwS6A",
	"W9YzJd/RbGmUCZLRohjXdglRTgq4gIIISRjnIMdEL6muDz+O7C9KeI4UGD6ogUSrcTaNKTlbgoS5kHhR",
	"lUBWFIXTylyPyqL5TWCuiq6gpTuhsBSVNjBGN5eTZ351cAEceVIYGsEPa8QLfzz41MztHuHMXNjFUQlo",
	"aGE8K6q8xl/gFw2gzdu1qOX1FELmaOih2vzGJMmEtENY4e8mN/8BKuuPLXXeLSVM3BCSXoBUtDCray3q",
	"XiDfQ53OHSczp5pGJ9NRYfpGZzkHfodKIciEdeMl/ocWxDw2Co6hpJp6GOopqNOE/UCZbVBlZzIvGL6l",
	"BVlZuxkpaXa+F5RP68nTbGbQyfvOmurcFrpFhB06W7NcHWqbcLC+vWqeEGvz8eyoo6ZsZTrRXEMQcCZK",
	"YtlHCwTLKXA0ixCxPrhY+1asUzB9K9YdkSbWcJCdMOMMZvbfivUzB5mQuzGPYw9BulkgpytQKN0abhAz",
	"S22qPp4JeTVtouOaqA3whJpRI2Vq3EISvlqVE3c2E+Zx+0JrIBLMS9uVgPbwKYw1sHCq6Q1gQZlRD4GF",
	"5kCHxoJYlayAA5D+MqnEzaiCLx6R0x+Pv3z46PdHX35lSLKUYiHpisw2GhS56+x8ROlNAfeSFyfULtKj",
	"f/XYO0Sa46bGUaKSGaxo2R3KOlrsxdi+Rsx7Xaw10YyrDgAO4ohgRJtFO3ltv3s/Hj2DWbU4Ba3NJfiV",
	"FPODc8PODCno8KVXpTSKhWo6pZy2dJSbV45grSU9KvFN4Ll1vZl1MGXugKvZQYiqb+PzepacOIzmsPNQ",
	"7LtN9TSbeKvkRlaHsHyAlEImRXAphRaZKCZGz2MiYbt45d4g7g2/XWX7dwstuaSKmLnRAVbxvMdEodd8",
	"uPyyQ5+teY2brRLMrjexOjfvkH1pIr++hZQgJ3rNCVJnw3Iyl2JFKMnxQ9Q1fgBt9S+2glNNV+XL+fww",
	"NlKBAyVMPGwFysxE7BtG+1GQCZ6rndYc7w1sIdNNNQRnbWx5X5buh8qh6XTDMzQjHeIs91u/nKuPqA3P",
	"IlOYgbGAfNGg1Rs1efVhykJxRyUgNZh6jo/RI/AMCk2/F/KsVnd/kKIqD87O23MOXQ51i3E+h9x86y3K",
	"jC8KaGjqCwP7NLXGj7Kgp8HoYNeA0COxPmeLpY7ul6+kuAEZmpwlBSg+sMalwnzTNTG9ELlhPrpSB1A9",
	"68FqjmjoNuaDdCYqTSjhIgfc/EqlldKeqB1zULNKSuA61nPRnsEUmYGhroxWZrVVSbRIyZf6wwnN7Amd",
	"IGpUT5hDCNWwb9nplvQCCC0k0HxDZgCciJlZdB3lgIukipRGd3ZqnVOJh/LbBrClFBkoBfnE2bN3wuvf",
	"s/JHb0EergZXEWYhSpA5lTezgvOLncCfw2ZyQYvKqOc//arufSqL0ELTYscW4DupjWib77pLuQZM24i4",
	"DVFMytZaaE+CUbEN0ylAQx+yr4+93u1vg9khghtC4AVIjKi50aPlJ7kBogzw3/DBupElVOXEqIG95gej",
	"uZr95pQLrxvumCFMUFClJ7tEinmpYTcxS424eEqK4MA9+uRzqjSqgYTxHO23VhTiPFa3NFOM9gwqwyl7",
	"b2Nm0l/9Raw7bWbEO1eVCrcyVZWlkBry1PLQZ9071wtYh7nEPBo7XP20IJWCXSP3ITAa3+HRGQLwD6qD",
	"h9r5vLuLw6gDo75s9sVyA74aR9tgPPVvRYiPg2p7YGSq3gNLbky16G0mRAEUTaZKi7I0HEpPKh6+68Pg",
	"qX37WP9Sv9slSesGsppKLkChi8m97yC/tEhX6OtaUkUcHD4+AQ1eNkSuC7M51hPFeAaTbecFL8Hmrfjg",
	"XOm4V+VC0hwmORR0k4i2sI+JfbwnYfixkUBq+4HQMJmhNzFNI/WZ8PGmV5tV4FQqpXgTfEIyc87NNaom",
	"Nff11SfNAadN8U1HrHfCLAhGkg78eIgsS0+JEVH2XwhtyMoRHa7GSaVrrqUHe2HWG0EgjjupDQHt2f8L",
	"lJs7KGAHnX8Dqm/h9dSHWnaP+R9le0NgtkRZS9okRUQvX97BGPt4UI8v4hWVmmWsxOvqT7A5+O29PUEy",
	"VoLkoCkrICfRA3uTL+PviQ1Dbo95tdv8IHNrF/yOvTWxHB+Z1QT+HDZoNnllMxoia9UhzBGJUY3ApZwg",
	"oD5q3tx44ldgTTNdbIxiq5ewIZcggahqZqNWui40LcpJPEA6Z6p/RueQT7rDt0YInOJQ0fJSkYf2trUd",
	"vrPWlauBDnfLKoUoEvbP9onvICMJwaBwIVIKs+uMFsWG6JA24ympAaQTEBiNEfSZO6qBZlwB+S9RkYxy",
	"vOFWGoKSJiRqPqgsmxmMuhnmdKGqNYaggBXY2zw+uX+/vfD7992eM0XmcGlDbji+2EbH/ftoinsllG4c",
	"rgNYu81xO0kIHfRVGiHrbm1tnrI7yM2NPGQnX7UGDw5Oc6aUcoRrln9tBtA6mesha49pZFiAH447yH3X",
	"DAnrrBv3/ZStqoLqQzgq4YIWE3EBUrIcdnJyNzET/LsLWrwMn70fj2ANmaHRDCYZZgkOHAvOzDc2sdCM",
	"wzgzB9gmjgwFCE7sV6f2ox037Tpuma1WkDOqodiQUkIGNkvOaKkqLHVKbMpEtqR8gTcgKaqFC3W24yDD",
	"r5S1hMmKd4bYVxXTaz5BF4ZKpqmh29JnWxolDKi52bb9H/aydkkDKFYYDRLa0fa0/UFJl+l41HvxN/i+",
	"qC/+Fm/NlNGrOhMb+mGEtBqagd4zxKfRlbpIjLfRHD5DDDfjpamHTkHZnTgKCq8f9sWFn1ZlWWwOoCTZ",
	"gYiEUoJCkRabAZV9KubkZ5ZJcVwsRJB5aqM0rLrOG/vp7z3H9fVVbsCCF4zDZCU4JK70L/Hpz/hwsNnR",
	"iuGeEVEh2mvA9sWngYTWApqTDyHp624Skkz77Lc9nep7IQ/lZbcDDr5TDPBc7wzrcFNe1b9OiyLhkrbm",
	"hw4XUeMQFM4koUqJjKGieJKrsYs+t15sG9beQv+rkBp1gAPcHrfle43SsKwhH4qSUJIVDM38gistq0y/",
	"4RQtfdFSE8GC3jjQbxZ+6l9J26ETZmI31BtOMVA02P+SgUFzSNihvgfw1mFVLRagdOuCNQd4w91bjJOK",
	"M41zrcxxmdjzUoLEiL2pfXNFN2RuaEIL8idIQWaVbl45VpXSRGlWFM4RbKYhYv6GU00KoEqTnxk/W+Nw",
	"Po7EH1kO+lLI84CF6XDGtQAOiqlJOtLxB/sUk0ocTpYuwQRzLexjH/Fc14YYmbU3ilb8n7v//uS348l/",
	"08mfDyZf/+vR23eP39+73/nx0ftvvvm/zZ++eP/NvX//l9T2edhTyeAO8pNn7o5+8gwvYlGeSBv2T8Eh",
	"s2J8kiTKOKCoRYvkLtbLcAR3r2n300t4w/WaG8K7oAXLDS86GPm0xVTnQNsj1qKyxsa1zHgeAXteh67B",
	"qkiCU7X4643oc+0JtgbcxFveyjFwnFEdHEA3cAqu9pypsNo7P3x3Ro4cIag7SCxu6Ki0QOIG4zIYG1E+",
	"ZpfixK43/A1/BnO8Dwr+5A3PqaZH9jQdVQrkt7SgPIPpQpAnPinyGdX0De+Iod4CUlFSc1RBKsUp6Cq9",
	"ljdvfqPFQrx587YTh9DVrdxUMRd156xrJvNTTozeICo9cUVcJhIuqUz5QnyJD5cNjV9vhcPqJKKyRixf",
	"JMaNPx0KZVmqdrGHLorKsjAoikhVuXoFZluJ0iIkjhlm7nJvDQ28EC6oRNJLf+WtFCjyx4qWvzGu35LJ",
	"m+rBgy8wBa8ucfCH44GGbjclDL749hajaN93ceFWL8eg8klJFymfyZs3v2mgJVIIKhwrvGkWBcHPGumB",
	"PhMAh6oXEHKR99gSC9neeb243FP7lS/rlV4UPsJNbeZOX2sHo6z4K2/gjsx6WunlxHCE5KqUOQZ+r3yB",
	"AbowIsdHECi2wAuAWorKLBlItoTs3FW2glWpN+PG5z7Qxcliz3CYQpuRSw6cM4O/jHIzYFXm1CkylG/a",
	"JW6UTYbAQV/DOWzOhP18OrA6WFSNLiqxovqOLtJuJGsN+cYH2Y3R3nwXd+VzRF05Esy79GTxJNCF/6b/",
	"aFsF4ADHOkUUjToffYigMoEIS/w9KLjCQs141yL91PIYz4BrdgETKNiCzYoEm/7Prl/Dw2qoUkIG7MJn",
	"9YYBFWFzYm5HMyuO3Y1JUr4AI9SNIBaKFhi0P006+lE7XAKVegZUb7XX8rjMhIcOFfJLTJpGo8nYLAHW",
	"Zr+ZRiMIh0tzwcO7t33HBRJPrxROZdcE+RVB9Z/XSdLTq1wiHMIT9ey8vA97Eu4LLj4tpk4E2T5fGRwu",
	"pLg0u2kAFL50IxZ4ieRUpegChoqjhqtoYEmMhgcIB9ml/ST1HTFvqzUdHWPgIuznE4OXJHcA88SwB3QD",
	"tEIc/dzWhei8Ci95sfFInRWoUIcAUUs6VDb8bHyxH7BpNgaS18qqB6yJtfjoL6nyRz8fRxz9itrixykl",
	"s61+3kkUfUd1tzqeF9Nt1j629pwZEMHNF76Kni+d5+vljcZ71b4bj1yKQ2rvBEctOocCFhYn9mVPZ3V9",
	"pno3DRwv53NkepNUIF9kjIw0EzcHmIvYfUKsxZwMHiF1CiKw0bOOA5MXIj7sfLEPkNzVl6J+bJRd0d+Q",
	"Tha00fhGSxalkfqsx2uVeZbiylvUKk8rxBmHIYyPieGkF7QwnNQlntaDdGq14d2nVZnNxXbc67sTDTxo",
	"bo2oney1SqvPXGV9seLtl5G+Fey1hplYT2xmdPJqNVvPzJlI5itgnnbq8NrKeXcUmYk1xhShhLMB7ntD",
	"1w+ZBywKA1kzhVSO3/WpjRa8/QDZrsinqFkh6Tm7WiC7Pk32asD0qNN9ZHc3KqF3IJBaBsy6DLiz6Oy0",
	"szS1ra4mUovbcagOG9LUUqym73Amd7IHo13jabPW3Y91ucP+4mj+rH6QIn9do9x16jLaj0tba3Gfsoxt",
	"cmgAsQWrr9pKbBKtzcClJl4jrKVYkmH0XWdXF20KCkBLwKShV0/OU27pN29+U4A6w6n/LLJz4u5RvrkX",
	"RcNJWDCloXYu+CCXD+/7QXOiuWyJef/qdCnnZn2vhQiKhnXH4oeNZX7wFWDo+pxJpSfomUkuwbz0vUJL",
	"2vfm1bQi3Iy3Y8q6evbWgxGic9hMclZUaVJ2IP30zED0IkguVc1QUDJuo41mWAo/GaC7h28S4bGB3VsR",
	"9Nwi6Dn9EPgZdrDMqwYmaSivOf1ncsRavHAbZ0nQcoqYuhvai9ItvDbKpe8y2kiJjsIuptt8Pp1zmfux",
	"d0Zj+Yz+PiXCjpRcS1QRMZ1AKBYLyH2lN5cUaqteuXp6heCLupag+X1L+cApsVX8sAjflvp9Ljwd+oLT",
	"G+1EsCtGEvr4MoOQ19l1WHsQJ1kAt5VbRvv3GymSiIsD4/GNyDL6YXl7J2w+GTp81goXrmN67R6Gzcbt",
	"KYDm7lqlwK9v+6HtbpdD3bgv6LhRInb7AcMBkeKYVpEC0yGaHs5Ny5Ll65bjz446vQJJDFT3upXgWzhD",
	"tuQG24GfZmDxjl49d4x0xPeds+MIr/lH5pJp45ldRK45GzRz1QbySqI3qREt3K2nHy6aA9f+06+nWki6",
	"AOcRnFiQrjUELmcfNEQl6RXRzAZI52w+h9gTpq7ixWkA1/F35AMIu4cEu+6ycLfcSp9dIttBW/UKdiM0",
	"TU8JSumLuTjr+iP9xSOyrQVhE23cFZyKyYICP8Fm8istKnMTYlLVsanOQdgU63vQxMXqJ9jgyDtDPg1g",
	"O3YFTXGvASk05V0Jj1RUJfyOanRfwDtwYwv32Knj9C4daGtcK43+o1FLqEY/ieZSbu7Y1CEyBtIhe3Wa",
	"jjoxZwua29Im9F1bxPLduk90BYmnYhi9cRUhFypt7IwuA1p4wsfFjt6PR9eL90jJSTfijp14FURzchcw",
	"GtP6/xtBX3tuCC1LKS5oMXFxMn1KhxQXTunA131YzQe+X6VPxdl3x89fOfDfj0dZAVROgqmjd1X4XvnZ",
	"rMq24Nguhmw5dmfbtaawaPNDyew4kuYSS6+3rGmdXjd13FR0UF1kzTwdKb6Tb7oQL7vELaFeUIZIr9oj",
	"bQO9msFd9IKywjt+PbRDrex2ucO6KyX5RDzAtYPEoui/a4/Vmyfw5s1vFx6ztT/FBkqFkviJWDp1xUjn",
	"Dq9Jn9Wa1ndwSFznS6xkmr53cVfnFBmjCzijB9cDvxeyIahcVmMyYO3mFERzmbB4TDvlz5wXvqMWTolV",
	"If9Y/GF4w/378cG/f39M/ijcgwhA/H3mfsd71P37Scdw0tRnWBZa8jhdwb2QF9G7ER/WDMHhcpi6cHyx",
	"Cjqy6CfDQKE28syj+9Jh71Iyh8/c/ZJDAean6RBTRbzpFt0xMENO0GlfVmIIfl7Zdp6KCN7OwccsWUNa",
	"KHpcBw/rZ+8eIV6t0O88UQXL0kE/fKYMS+I2pNe8TPDlwT5kM0fFeuLKecWi0c1r6kouz9ZColmTCFfJ",
	"SsA1fmfCsYCKs39WELX1RUncEs7+KoSjdhTstH3RDdzuGjy6SsPf67sIvVVtm8Foq8v1WXADekSk+kzt",
	"me8Qz9hh/ltyFRxFefGJiW1LFzq8k7K23vO2N4F2bmDPPp3Htf+C5Nph2s18NmSnmZrMpfgT0roDOgkT",
	"pTu8d5uhAf5P4KkY1TYjC5EDdcPqevZdBDLcttBHKte2JfhFh655VxHhaT6x30bvaTSI9rvfbKDS5cXd",
	"JvRdVOPAk2YiTQ8zwwMbhYVjLx8f7ka5PaG2rkUj8yx9zuNE0SM7fn3OHcyd5NqCXs5oqtGRuS8amKLt",
	"bwTmaUH8x36DVCjNYGcnUS5DeJfZYn8lyNp71C2VfMW7n5128K2vvuQhxcXXu7GNVSmUSAxT8UvKMY4Q",
	"v7Mc0H2twMZhmK8uhcQCnyodQ5hDxlZJY/ibN7/lWTfyK2cLZluKVwoInWtX59ENZJvKWypy3bxDLRKH",
	"mpM5eTCuz6zfjZxdMMVmBeAbD+0bM6pQQIeYiPCJWR5wvVT4+qMBry8rnkvI9VJZxCpBwv0cVc8QCTsD",
	"fQnAyQN87+HX5C4GDCt2AffSAsYpa6MnD78eb+ucjRjHJvHbmHyOXN4nMqQpG6Oq7RiGrbpR05kJcwnw",
	"J/TLky3ny3465HThm04E7T5dK8qpQUgKptUOmOy3uL8YytHCC7feGVBaig1hOj0/aGo4Vk82uWGIFgyS",
	"idWK6ZWLFFViZSisbkNuJ/XDYX893wbNw+UfYgh2mbjjf4TrFl31ZDhiVP0L9LfHaB0Taiu2FqzOv/Ad",
	"asmJr0yNfeFCOziLGzOXWTrqq5iOMSelZFyj1ajS88k/zPVd0swwxGkfuJPZV48T/dWaLYj4foB/cLxL",
	"UCAv0qiXPWTvtRz3LbnLBZ+sDEfJ79UlHaJT2Rsrno7v7Qs77hn62tq1GXfSS4BVgwBpxM2vRYp8y4DX",
	"JM6wnr0odO+VfXBarWSaYGhlduiX18+dJrISMtXpomYATiuRoCWDC8wvTW+SGfOaeyGLQbtwHeg/bnSb",
	"V0sj1c2f7uRlIfIqJ+5poayS0fR//bmuj4/ObZu327JeCpmw0zqL4wcOS93PXtj2odtwQHzWg7nBaMNR",
	"uljpSfew+Rzhm48R79UGye55w1T68A8izT0edf379xHo+/fHTlX+41HzsWXv9+8PD5lN2wvNrwnUXE3W",
	"tKtXmm9TW/2tSFjvfBfPEDfmSpUkLKxJWWZE6syNMSbNVokfXu84TL7i3mHI6QPkUYOP27j5yPwVN7PO",
	"gOnnD83usUnyycPzKIeCkm/FeigRtcSWp6dPAEU9KBloFcSVdLrjJiMldob5RGRrRp1BIcxNNW6ANThq",
	"5TPaBYOa8Za9qFiR/1p7oVuSSVKeLZNB5TPz4e/2GhC9EFkwsiXlHIrk1/a2/Lu/VSfu/f8jeoZdMZ5+",
	"1G7EbGFvQVqD1QTCT+nHN7hiujATxChqFuQKJU6KhcgJzlN3LqlZY7ejeaqTbCLHH4ddVdpFJWPxBNdQ",
	"ZM4KDKNN+8PxzYmkuoerYtt/3+LKjINd+JU1S9jRQRLKVii2FV2VBeAhvABJF/ip4ND6HCu24chRWxKi",
	"SvMI38TiL4LoSnIi5vNoGcA1k1BsxqSkStlBHphlwRrnHj15+ODBg2FORsTXgLVbvPqFv6wX9/AIX7FP",
	"XOcv2zBhL/CvAv37mur22fwucbn2q/+sQOkUi8UHNiEbPcRGrtvWq6FN8JT8gPXJDKE3WgSgUdRXWG7W",
	"BK3KQtB8jEWhz747fk7srPYbCYg6bP26QAtg84gknTzDa6T6+ms9tauGj7O9dI5ZtdKT0JQ1VUnRvFH3",
	"kmWt6Ce0DcbYmZJn1iwbAnvsJARLi8sV5FEPWGsGQOIw/9GaZku0d05HW03KPd2Ahrcw9hywdhdFea+h",
	"YRZycLMM18XYNjEeE6GXIC+ZAqw7ARfQLNgYqp06g7wv4Nhcraw4t4Qz3UN7De2x9t0FD5xVfX18RRKy",
	"1j5c2/dXV/LAJuf7Nns+xa/SeTutztGtuAfbMmPtm25Myc/O2ZFRLjjLsNlESgXHUozD3KoD+nKk/Z1q",
	"5M5y4hgm+1WHBHWHxd4O1p5lOsR1gxqip2a/LeHYPzWsXRPABWjleCDkY98+3jnoGFfgGqAZ+oo5qpCJ",
	"0K9kWkwIITlgSPp4hNXUemyt35tnL5xtHmvGnDOONjeHVHcTtA62QjH0s3PCNFkIUG61zbww9Zv5Znq2",
	"5gjC2+lzsWDZKVvgGDYU0SDFRgF3hzr2McEuBte8+9S863oXhJ8bIXV2Ur/ut0kWosL+p3qu96I/Ffvl",
	"A2ki5Ibx49G2EOPWUH+Uy4YM4QIj/6BEed4hm9C+vjnKd+bKaukN3yA2czdZNpjxBBjPGfcO33QdrCwp",
	"S3Bj8DT3fKcySbW9dAzieGdAi550GEyqtxED1x2q3YnBoATX6Ofo38a6834PWwkv1LcLyjfEHwpD3ZFS",
	"8pQWIRg+0UcftTOnjNlg4VZn/RRbMWx94lNzG+jamQgaPsduKPvKqb5qo7MqX4Ce0DxP1Z37Fp8SfOoT",
	"CmENWRWagIU802a59i61uYkywVW12jKXf+Ga0+VMUaVgNSsSobfPwkPIww5jIarZBv9NdcDq3xkX9L53",
	"9rePcM/361HQzWZPac+GpieKLSbDMYEy5froqKe+GqHX3x+U0n3i9yeR193icvEepfjbd0ZwxGW6OzH+",
	"VrSEKtoYTy/wua8HFiq5NrkSirJOnzeMyMDNS2xZC3j/YhLwC1r0VFyIvTZWvlpPRl/dhay3rAjVrnqd",
	"pqTmCUNMGP31v2wEdssz1HVv9sVY2xDrm3SeOHxsRXq/p/Gnhl/RRr3VDKXXn3g1l19NBPv6/Fwrhq69",
	"lBaFyAZzBjfMsfmov1SvWK1c5ftEVN7FSuTxWYijuQDSjM0GLCdSK/Bim3yGV6vkE3mZHq1hHwlEM7Rq",
	"GaLRLWFsEzM9eB4YO3U8UWSydZgl37MCm0P9x+nLF6P+jYx2oLulrnR20oTdtzEhU61NHgvRwMcWHiB4",
	"kbZ/qx6TOtaGSp8G1504+eB7ayAcApKtk7TP28+HDt4hgIWwXaFSfTO61WlG9XZ45EfUUG+v5SgxdaSo",
	"ot1tKXH3sUbP+hUSGpEOakza0JGGNHdK9RFyNwVvgbWCxtWjs82VOn2ZOgz02RDlsIOP9+PRSb6X+pTq",
	"RTWyo6QY7HO2WOpvC5Gd/wg0B2n7iaSuk7abyArMNVQtWYn3n1IoVvcDLsxgrpD3EoebDk3NOVuCqwrj",
	"iwR0xvIB1BeQaewPXYeBSoDhcQ5leokGAu9QxFc+QiiIBMih1MutypIN7i71sm4bCi7zjCkyA+e6uAA+",
	"JmwK03ayWl4XhSIF0Lk3wkoh9IC+uiFtCdEYA52ir06P5u1qYKfmW1TS0LbSnQ5vwnIccgJsouUlVXXl",
	"qFYZhcHp2vM5ZFjwfmv5vf9cAo/qsY296Q5hmUfV+FhIF8SWDQe1aNewbiuEtxXUqCfVTULaVxDjHDZ3",
	"FGnQULIjcMiwvUoFeESO9eP6pgJ9rg0XGMlUoCdEkI+DdwX46x5LV2kCEFWnvCIYnsaNeKorVl4NGq/R",
	"XAEM8+n0Wk3763J4qJj2Vffrdlfvvyk/w2b2ygWV0lBuPrYnkZNuO+ZLV64eCy0Gb6EvXA/K/+YLtNpZ",
	"CnbuOtQgwqxv9pLK3L9xkDJ5Vm6yNNDzMDOrE6O6UT77xuXYDMWsEEYBmvQlhjYzlUII7x1lY63romUI",
	"9RykhDz4BAuhYKKFT7Pao/inS5/cgj0bZX4lvLUi+vdIGbYr6u2h8LpuJIHtICn2TKAu+DzGCpGwogZ6",
	"GTV3SJtBd+3QU/vc1xTx7f22m1f78B7Oxe4O2T71jqkO5uPTNSdOOdibezUKkVzBMss4BznxTtx2awfe",
	"LJOJdZXzKrOqSnw2g/V6cNmxLdwsadTMuqtsXaGiqhznsDmyZh/fddzveAy01SEt6FFB6RZRHNRWrVJw",
	"Lw4C3sct31kKUUx6PIMn3X4U7cNwzrJzwMKsITPFaMF3msfGTELuokMqxIxcLje+20JZAof83pSQY26z",
	"A334SLMDaWtyfkdvm3+Ns+aV7TDjLNDTNzydZoWdXuQ1uZ8fZgvP6+NNCgy/vOb8dpArzK7XvC9G7hJb",
	"wjT7BE+Hmje68R0tFSoiPwtFSoE6tY7gp8gSEvcogtVZojJCGB9AiXMgE1WIVBT+VSrImKHSmIonQ4A0",
	"8AHX1RoKN3gSAS7IbkdVVvfY1x0VcyKhjs24agFWV9PUMnHVZxppzxxmaXLGuZAQz4hxprZQc8hswzrH",
	"+J8Z05LKzVXKpDZRlTJD9WJ5Z7RkCJSsF1IHS3ZxWBTicoJsbRK6K6XMAeY91RTbvk9p/Z056jOIwi6p",
	"cirihixpTjIhJWTxF+kUbwvVSkiYFAKjMFOBHXNtLgkrzOvkpBALIspM5GAboaUpqG+uinOKuhdEoWxJ",
	"FFjawZIB9puIjgdOaaSvdc9OUF/b2WjDb/6Z+caWr6jL39lFT2yIQE9+AShX7s5hyL7chRcJx1Zkahtl",
	"0yrynK2RbkCmjvycaFnBmLg32l343cGnEsiKKWVBCbR0yYoCq0ewdRTQEOKB0qjt0Z1PMA76gmHAW7OS",
	"iFWpSyMdQ/mVmAecxhXZiF5KUS2WUX+AAKe/usvKXezjUX5RFcYkYoqomeIxWQml3bXYjlQvuQ4BvZsJ",
	"rqUoiqYhz+r5C+f0/Zmuj7NMPxfifEaz83t4CedCh5XmY19SoR27W88kWzUYh90U9JpPkDzU7jLr9j2M",
	"anX0PJh3trhfx/Gwy5Ifgfl2N3Pd7dc47i6sva4mn03fhY45oVqsWJY+bp9X9GtvzGqKeyUrLdouxLYK",
	"Db6GfCCWYyGcCblnF83AabKN6jFxPMKFdSAnMv9FNb49LpmD40E9MrTLd5yCNcl61cAWAAipLYSgK2lb",
	"F8dKWmA4YmELp2BQShvQgQIHY/+uB5sZ4eBAabgWUJ1o5ADgXWvBGNuKmDayeSbW/vm9umTmlYB/v53K",
	"G8yjL6jytCYtacMqfSGrHo6QbkCwNQLxDItgzIbGIYZW9AOFfwRAf2RiA4ZB8Yn7gjGnrIB8kupSfBJs",
	"YOPouu5yLKPRfT9Hy8kzWvlOwGbsSoIrrGS1f9l0J5bUkJIIr3ct4jyHNdgcrT9BCtvHdxy5s6CwbX5b",
	"FgVRTgq4gEbApqv2VKEWyi7Af6vCxyQHKNHj2za0pSIR4y6BLeuLW/skimUbgt2kOcYi1u4U2WFrSVqG",
	"1nxij4kaepQMRBcsr2gDf2pflaNpSzRHOYGqzvVh4q+YQ6f5xY7w2g9w7L9PqTIeE2+H8aG9WVAaddsY",
	"0M7I5Er1nXqeDkyOS5kFRxHOlge/tiXxmm+okl7yfqtml+Trm9jAfWKCR4j9bg0ZajXuKgS5uwz1eE5c",
	"DSSkdg6Q2wuD+SRhzV8CJ1xEPY8vqQq3mLqqq//BTowvMe4u2lfw0dfxw9ffWYKDEdUqtphuURrI+no2",
	"/o9yErcexN7xUjSiwKXybjGNeep21w58QVRFTrjZT6P7Y49gJ8UcFx+TWeUHKgpxaZsYx1fUZ+D9uZb6",
	"vIvJqeUsiGUfJz12BYfbVhAWZYis6IYIif+YC+k/K1qw+Qb5jAXff0bUkhoScg5kG0Xh4q7NxNvVq7EH",
	"zBtihJ/KrpsNHTMabmNGiYA2gty3bRNkRc8h3gYMELH8M9OGcapqhkYNI7Jb29nFglu8L8+0onlsBMBC",
	"s5sGd/AFz83X/1+dthpP5es/lgXNfMtq13yuyWewq70nLr2E1fY05y5f8yQQOuXXRCt9mYz8CtbUPVlX",
	"KuenrzlWA+xOC/BOX7BrLWOgUbjV42hLgvigpRx6Fw6Tw9lZUtzqd9fi4s7HH2Z3khWi+5YxBPxPaFca",
	"4RWdzLZ0B/V4PbZZ+gfYhUYhngSs1gw+E+uJhLnaFUhj7eAzsa4BVsF2y3gmgSobd3Ty0l1b6wLIjJtr",
	"tI3aDW7VMEoOc8ZrVst4WenELQjrIPNNhLDYm4Bo7fHN9ekYRhW9oMXLC5CS5X0bZ06PbQ0cN+nxHhT3",
	"bcIAEiRydwCm6hsg5lPX9vn4NSP+bYNBGzurNOU5lXn8OuMkA2m0BnJJN+rqrqrgddjlrKKRLtSsFhK5",
	"rZC0LSDFxnmbr+lICgDSA3qUBniCMEg74QWyhiEtehw/XRg+C0/Qiq4nhVhg1m/PgXB1rtF1aC+QgqMR",
	"3Wp3w9bt51HsT9g+DbYicYxIC5x1yBTbz/1L3Eq8hP7Cmd568q2Fs52GbSOd7cH0SOWLOj3DEkv3PKYy",
	"511hpjh73quqvkyJpz2INjEZEt2xqvfsIsZXuLILsQl9eLPKZghHKj/f2hUmaG9QWxIwQNV5BTRzEWJd",
	"Q1zHUGGRMnbVDfa001nrvpdLPeChIUW5s96cNgTomHH26fC5vZ7BpBTlJBsS22q7FeXOyeAgbcLYQx+R",
	"C6Fn3SHuRoX+XY2aaI1GXvs2Oe1tJLbLV1Zm20wGfUamHo7edGCIOfIyPMLWtIa5VsEUM/aXc+/sbhrR",
	"ApMglEjIKolG5ku62d34saf6/OmPx18+fPT7oy+/IuYFkrMFqLqnQatxYh2ayHjbavRhgxE7y9PpTfDV",
	"QizivPfSp72FTXFnzXJbVRcj7rSN3Mc6nRAAqeTcbou8K+0VjlOnRXxa25Va5MF3LIWCm98zKYoi3VMm",
	"6FUJ90tqtyIHjLmBlCAVU9owwqb/lOk6KFst0biIVcMvbG0owTPw1mdHBUz3xHKlFtIX04v8DGsxOJ8T",
	"gXVZOF5l/UTb1uXuada+h0ojhtvMgJSidKo9m5MURJizJSsIdnVnNkV7ehSmG5itDdhNEaILfk+T3jF3",
	"N2ExJ9u5fbMVt05zerOJCfXCH8orkGafd6O/zshVOEntGPhk+EeicMrBuEZY7k3wiuT9YEtW+HEnaiIU",
	"DRkEWrdARoI8EICefOhG0mqUZBfVJpfWx4DeCO9+bqsfP9du6Z2ZKQiJ/2AHeHEuc/1eSKZw4Hzkwt4/",
	"B6RES3nbRwmN5e9Kj/asNwiSaIuc0URrUJYtia5aGCXEq6chz7znVtJJR5dCaGJupkWRSGO3dhw8UzHh",
	"mCuBvKDFh+ca3zOp9DHiA/LX/YlbcdpyjGSLSnXwgpzP6SCwohTlDwIVf4W59f8JZmeT0tHN4hz/HRmI",
	"JiFa2GjvefCAAyeXOKYN7Hr4FZm5dj+lhIypdkDBpVdpQr4tSDZ38bWw1u3c32u3CfpV6Gsch7mPByIv",
	"IidbiBxwMNdH/SMzpx4OkDwtKVLtEEoCfyleFzdV3yF2rtka5mqlnKLCjXuWcuq2ix+6PFwHCq9KQXed",
	"g6V+A7cJgV+vbWitssEdZt68+U3PhhQUS3eDMZ9jjbODtIW5flOYD1LgzKLSjeEgSRJWrXLvql7TipeM",
	"6jQ0d9Go+z0N5JcW/WY0vBTMK27HCw1QMVfcs3UxH4coBsHNZ0/IG36fqCX1dwv356MvvxqNR8CrlVl8",
	"/Xw0Hrmnb1M3tXydzCutC+l0YkRdN4E7ipR0MySZfWfpnCR+60pBH16lUZrN0ne6H82e4cXVJSCccGT1",
	"yF6sBHX1c24LAG0lhtZhDSfGkmRdHihsxa5KQb/2lcW3pd97un20uG/Fip1Bco1GLO/Ho4UtUobdSX53",
	"veo+7LZ7CHrqBbqlX6cMmEVMYq2NyaOpoqJuAxqyuM8SHTIw8zqrJNObU4N/b3Znv5+nikH9EMozuZpf",
	"wQPvdF8tzoH7GLO6mFOlvHb9g6AFap82MIAbnVMUU/Kd7RDixOI3d2b/Bl/843H+4IuH/zb7x4MvH2Tw",
	"+MuvHzygXz+mD7/+4iE8+seXjx/Aw/lXX88e5Y8eP5o9fvT4qy+/zr54/HD2+Kuv/+2OoXQDsgXUd/55",
	"Mvrfk+NiISbHr04mZwbYGie0ZD+B2Ru0sM2xQCEiNUMRCyvKitET/9P/7wXlNBOrenj/68j1gxwttS7V",
	"k6Ojy8vLafzJ0QJroEy0qLLlkZ8Ha1k27iuvTkJekI39wx2tfU64qaG+n3n2+rvTM3L86mRaE8zoyejB",
	"9MH0IdZTLIHTko2ejL7An/D0LHHfj7CK9pFyzXiOQuro+3HnWVnaVj3m0SKUATV/LYEWyCLNHyvQkmX+",
	"kQSab9z/1SVdLEBOMWPM/nTx6MjfPY7euboy7w1gyWAD25Ul6r3hg5/LalawzGiorloWep1sUo+KG+I7",
	"f1ylxmRGC8oz8IkDPMewSFt2xWg5AeEnuUG0/f6kZnaIRh+NMnryW8oq2wFv6onU7EBEQ6GuUs0j0AY/",
	"sjwSXeOB4xku9mDy9dt3X/7jfTIYuxuXVQc0bn2aLEWmAPs6/0GL4g9rAYc1hs63gufGfUGP47pcD35Q",
	"o22MxubwNPq8fqfZnOQPLjj8EdD4zwrkpsajA2wU480rcLQozIuCQ0Jv6y79aZ0seOnajMdxylEE83+c",
	"vnxBhCTOFvaKZuchUdInzdaJwnHOrPmybylO4KVW4jIuV2pRNsvvh9W8xT7KCCge80cPHnje5uwEEa6P",
	"3HmMZhrUbMi6M8MoHpwrDNTlgfbR61A8W9LSnuNjn+5gVH7nULYvTQ11Pz7gQpslvq+93PZwnUV/S3Mi",
	"XSUGXMrDz3YpJ9yGrhtZZmXu+/Hoy894b0644b20IPimFdp4jrtC6hd+zsUl928afatarajcoDalg1Bo",
	"d8mjC4VRHCgrLKeKim/yxejt+16JeRTHaB+9a5Ssy68lT61bt9FOcreI7ZEDOJZNonU/3D0uSwxRPw3P",
	"j8vyleH9CgOXgCHnhTVTWt2bkh/irxveWAuJdcY2cpgcjnwBzWZwTtQ6PCnvG/VV/lai/7hpumQ5cM3m",
	"zFYQTq2jQXNblzO4VVsi1n/741shHlNNJ68yqk23bw5JaOLhlLWJ6zs7cAx7pA/YZ/l6dUwtEMn66jvl",
	"yC1a90drn4IXLSXoenUf6A8jVHzd+CADG8LuBkXOZ66u/kwLQ0LRclu9/E6e3aqxfys1NtRwXli9siwP",
	"oNj6JLhdrxy9c0WGD6HvoplikKYbW0Cib6M8pbstjnNvSo7b71yNrbjKzTt1WJuU97fTXm1J6Z16q6Oa",
	"w2qsjTzIXS/caq396lWcyrtPZm1DpzK/D/r4r6um3uJxL73ULGK3RnoF5t/RNp2ouTGh8JfUMh3SbvXL",
	"v7V+GRo/XEvDjJMcjly1mkjfvJZhtW04ZTrokc1+IRHTw7JUWLfFHuFxndBlWIzNVHE5Kmrsr77oXLe3",
	"YrtZ487FuKsg/gDxDfzbzcmzIbrh52YVvFFnWP1lUpykN/mmmXLStfT6w7iWhjG5xw8efzgI4l14ITT5",
	"3oeOf/kh9+CQvDFNVvvywm2s7Wgm1rvYG2/xt1AR1Rz+BrMLNbHH0XPztg3+uYtFImZUwVeP/f3l3pR8",
	"616ty065cMmFMBzPJxdTubAfGaZpkEHu+D+f4Ph3puR7TJnXaowRy5iLhy8yrp88fPTFY/eKpJc2ILj9",
	"3uyrx0+Ov/nGvVZKxjWGi9hrT+d1peWTJRSFcB84YdMd1zx48r//67+n0+mdnfxZrL/dvDB89S/IpMep",
	"Wr2Bkvq2/TPf7dTlm9sN7t+CDxnr8a1YJ8WJWN+Ks48mzgz2/xJibNYkI3c1DsbjRje8A4o1e0z2EWxj",
	"J8gwgTBIpSl5IVx/1Kqg0tYmw+LviiwqKinXAPnUUypmfytbgjUrGJatkUSBvAA5USz0X6gkhAJapYQL",
	"zNiqy5M3INgtMTBh468vLX6m6yigfhYUBy0c7tAcuqJrgv2yNFGgx7aI6Jp88w15MK4vZkVhBpgEDKe4",
	"9IquRwmmvCtdI/XrYQ2mgb6HVsF75vAo5O6YdRx7iBmt1txCMeb6mvR3Fxaf7a3DHgy3sQdi1nv77mrf",
	"XGxMce1Dt5pRrC6psXWAqsqy2NRF441i6bW2NFc1Mwy1kHwunqcbtYygsyB1G2/v1S1HuLWGXIsvtQlq",
	"Tx6EyZfq6B0aKGIG1GECmJi4kwE4x5ZVR3rOvnQ56Yc7+KEewpZnvZWeQgexuC4GuYvpFFirDSu0brDk",
	"o8SSqmyOpaHu+Rb0rpsCltypI/LTypMdfmImTSlRUUecW894v6KHtNjtnxBvYE5tCZ4hnUuj+gro8wWZ",
	"OIov8T+0iEkgNAzz9YyRmAI9uJ701gRiE2JdQpEvDFLSRmf+3VA+rSfv6qiIlkO4zG8RvB+COyz+O1fv",
	"yPIUt4i/QpKOv9BPyAtRF5ex/P4v6ZK+Sf3kphf0QnCwsRfmMmBp8dbNHpSnWuj7WmT2Sld37ryqInXk",
	"6z1s1aZ+tJUIPlON6gZE+o/JKhkNqWMQO91ZMKkebQiz9mU4aEMFnH7Mu9lH4a+f4IXtY3CwD8NybL0e",
	"x3ecmsAPy4Sw3J8l5qNQLKePIz03L0d62itXMuVvyp22EUwaVQnCCaWIaKL04vRveJyfurZq2hemsuUm",
	"FeMZECVWgLcKo8a7rhUWwn98OAg1W0FORIU1M6OM9I/McL588MWHm/4U5AXLgJzBqhSSSlZsyC88tE+7",
	"DgNUhLo9j23o3cNBGEe3YLMsaRbXPrwGXxSLLW5QZ+2vCyu78lSi0iBtSd1Wl0zW4dspKzoyjOdm6luV",
	"D7/22zC0NcRTWhSIv12+Ohx4UMR7UdgNhhXTum40FUtg8h3NlmGzx7XtLTQT9h1Jxq0a1jiy6yxry3Uo",
	"MBuvgUSriSwcIGEusEskSPDGxVVVaFYWzW9Ct23sPpiIRLPEGlfAO3nmV2fd6mJeD90maN+/xA0+NXO7",
	"RzgzF3ZxVAIy89gAGtskpw2gbR9OH8ofdU90PSBdeWQmW/Wq66insgQq648tw7hbSpi4ISS9AKkont7W",
	"ou7dqvOfhjq/dg0SPhFlPunqvS7zv7psakTkv9Nrlr/frbt3io7+ddw0Z62ioSfP4qwpEarueb2iZzEG",
	"kXsmav7raEClrJuuwJp0IdXVLbuumGGlWm+9S4MZSudsbbvn9ZX0/dCip84ciw86EW2V4KOKIP2xRNCk",
	"JYOaaPl4Eglb4Iyj8J1SCi0yUdiovaoshdShILCaDrqIQZ+Ya9zD+mtRX0OUrVmudhrBz/Ct2ytRbQU/",
	"83hLmcGb51dtae+9M6KxnmvIXelMlMTed1ogfFRGd6tjpxhcy2L+uRvMdS/pHdh+nlGdLavy6B3+B6sQ",
	"v6/TYbGrkzrSa36EfXyP3m2N2UQeW0BuiBE/bZi8Ol2Bk5GXz/HzuvnU90JG+sgP5rvdrLOJtHFbC7A9",
	"iTG4M8FUb0ZtvtU2+1wLrQ2/vkM9MWLnvIZqD1En00C7UUszX8DB9jFOkPBtAMintaDa3zJnPCc02sbW",
	"pVrImhHcsM/lphf9MVw4Hz7q5cvP+Jy9EJqcrMoCVsA15NeLgCZtDuelx1Zxu59i4ER/N0y6K/Njie8z",
	"RYIuslPA/4Usd7cy/pOS8U+DWyom0FuJ/flIbOkP4a1w/vSF8xef7WpuMPpjoLC+ghetKaDrO/qeorqj",
	"JjjrVsuksM0Bh5fy9irV90L6Vpy38v0vl49k93hwLMsQq84u662b8hDJPp8U9MNsE0WRsE70HeFxCJdh",
	"WD5RZAxbLp3kauzicqxBw53vW5Xok1aJor2+1YhuzRWfmbmiR/9xloKiGKKC7KsaXaxEDt47K+ZzV8m4",
	"Ty9q9tQ05Kk0XZXEfjntjW09Yys4NW++tFMcVMTWYLfcki3wDLIUZILn6qrdY91UVxVO6LHqh+qDu0jD",
	"tnhYXAmg6ZXp+HVU2bBDHqS9IwobpPpazg4ZOVwQQ5XTA9Dy0Tv7L9rlSqESqzn1VN3ZmLtuW2xxajtu",
	"A0DyCjVTW+XafyXm5IGtUV1xTDheMtdHHWMEtdwY7dUXwJNAC5I1Eg0DHN3jdNp7nLbeHM5Sq+tZU/pa",
	"Iepje+17xZXKPrXSwX/64EflKeXucHRRqQWhhMOCanYBPspgeltV6crC0NU02sIqx4TmuT239SbABcgN",
	"UdVMGVWJN9NG7qjmydqDtcC6BMmMhKdF7fO3t4wjWzJpWyzTqX3jmjKvxbVsoSbZbLbuBbMr4yTm5GeW",
	"SXFcLESIRlYbpWHV6UjuPv29pzGBt1DsZTEQvGAcJivBUy20X+LTn/HhYJaBZar6RjwzD/casCXem0ho",
	"LaA5+RAV4Lqb9ImwkGsF6LRWK6EU0tywZ7awjj1Ee55Hf/I2POsexw3PImecexgNFPfYbvx85OPFGx23",
	"k2++a/zp6rO5N9Wy0rm4jGZBO4SNyxxSTQkvALcptr1EHOEndebC00SX5Pphf6Pkv2nSrXMpxSmVLmXt",
	"AqRqXTJvM2//Upm3g/d9Ly5thqzULk5XqcMqRi9EDnbcOtvSHP1UvxQuciDKA9HSh0KYZ7pLk5dr9XsW",
	"b0yRGWB9TVotlppUJdGiG/c4jiaY0Myy5om9j6UnjMr42lsbTrekF0BoIYHm5g4NnIiZWXQtYXGRVGFF",
	"Zp+85oJZh6tdEbClFBkoBfnEN43ZBa9/z6bL6S3Iw9XgKsIsRAkyp/JmVnB+sRP4c9hM8PauyN2fflX3",
	"PpVFWF10+xbYmq6JjWgn5XaXcg2YthFxG6KYlG0OsD0JmB0nVmUBLj8ugezrY693+9tgdojghhB4AZLN",
	"2Q0fLT/JDRBlgP+GD9aNLKEqJ0bP6ML91D49YyvUGDnlwhtsd8wQJiio0pNdIsW8FC9amaVGXDwlRXDg",
	"njv7c6o06uOE8RyrFlpRiPPYm4OZYt9bPU5plAN7lUpM+qt9mJo2M2Keq0oRN4LPXYM8tTwO6y1zvYB1",
	"mAtLgPixQ3KctbTuGrkPgdH4Do9Ryx5CdWjQCMQMl1gc2oGpM//sheUGfDWOtsF46t+KEB+HX/TAyFS9",
	"B5bcsBdATG+h9Ox4pLQoS8Oh9KTi4bs+DJ7at4/1L/W7XZK0xR2sppILUHFOo4P80iJdoQ19SRVxcJAV",
	"PXdpjwvXcbcLsznWEywkNNl2XtCqbt6KD86VjntVLiTNYZJDQRN2ql/sY2If70kYfmwkEE/okwuhYTLD",
	"GiFpGqnPhLyKKS/MKnAqlVK8CT4hmTnncyEjUnNfX33SHHDaFN90xHonzIJgJOnAj4fIsvTUY0Q0Yxiy",
	"ckSHq3FS6Zpr6cFemPVGEIjjTmoLUHv2/wLl5g4K2EHn34DqW3g99aGW3bbpxrK9ITBboqwlbZIiopcv",
	"72CMfTwoZUX+LN1G7SC6G8z7bFrRozv89Cr2iaNLyvRkLqS9t0zoXIPcmc3xn5T5uAznZNLC1SAiOILT",
	"Edw4KLXipn+OY1kQiJN/hkRcrScjlCl5SFaMV9o+EZUe26LWEmi2NHek2LxuR8LW0K6MkoQFlXmBvYHn",
	"QREQ0pZl0i1lBoFOpMg2jTZm3d8L+ZkX/H97a3G6tTjdWpxuLU63Fqdbi9OtxenW4nRrcbq1ON1anG4t",
	"TrcWp1uL09/V4vSxKrNNvIbma59ywSftYOrbWOq/VKH/IHu9AQytT5eUIQuMCqP026X2MPRpoAXigBXQ",
	"nwdig87Pvjt+TpSoZAYkMxAyTsqCmksXrHVoeD6jCr567DOVrS5AV2S2MWzFKAzmhS8ekdMfj33t3qXr",
	"JNR89+6xDTUlSm8KuOea2QHPrULuu9oBN0h3Te2oFz++MbprE88KzKFR5Dt8+xlcQCFKkLagKra07Fr0",
	"zoAWTx1udhj0/tNM7kLt/zCj/TFuGDUd2la09Nciv1aqCLUJ2+RZlML9x5wWCv7oy+K2461oub0b5lvL",
	"fUHpb0W+aZ0Qs2tHuIHNsxEa+80Yp3KTKEzXTZZqk4YWhl05wuoaMd8fNMltmex/1SWzXRSWupnYRgTp",
	"0fuoPDVOvWGdoWye/7xFJ6NUinosSpe2DZoDcFAtUkyosntCXtvvPm7lUYTIHbGamX8ygcbNNwPTwHfN",
	"rcixns81l8gjPnl68eyPDWHnVQaEaUUcxQ0QL0YjNCMtgE8cA5rMRL6ZNNjXqCGFcqaoUrCa7ZZEMf/E",
	"ExeEj3myXU59HDHyLFrcNp4cE8164hhwD3feaBjMmwO2cETHniOM3zSL7mOjMQjE8aeUba3F+/ZlevU0",
	"m1vGd8v4otPY0ggYd0182kxkeoOMT25kxft53ndryCoDXHyS76LfA72qsNYNJ3oOs2qxMLeFrpsVGxnh",
	"eEzwj8QK7XKHcsH9KMgO/tqnwVy3xkV7uC53icpO3PXFYO/hdlC+QY/QqqR8Y3YD80gmiq2qwuLQtgI/",
	"LKO1fQtSVe1r62SfBf+VN0pGxmgnapu/W7SQS6qI3V/IScVzl6zYKae/5sPLJNmhz9a8ZtNbSyLZ9SZW",
	"5+YdIiL8LjeLUihSgpzoNbcHqnGY0DtGiT25H7V8/63Y+HBiw5a0gB4G2+0IUjOEA0kPGfE1FB9R16s6",
	"p7bRC4s2M4Ebz9Ci0Z+FFrfwsW8eNDaoM3wzRKg2tzh/MxQloSQrGHqjBVdaVpl+wyk6pKKFTbvhQ96G",
	"3c/7nvpX0u7ShDfTDfWGUwwiC26qJA+cQ8Jd8j2AZ7GqWixAGT4aE9Ac4A13bzFOKm5uYWJOViyTYmKz",
	"4s35MrrL1L65ohsyx4JIgvwJUpCZkfrRrltbstKsKFy8kpmGiPkbTjUpgCpNfmaGA5vhfOGVEFII+lLI",
	"84CF6XC3/gI4KKYmaWvND/Yp9hR3OPFWQbRw2sd1f532NajuqPB/7v77k9+OJ/9NJ38+mHz9r0dv3z1+",
	"f+9+58dH77/55v82f/ri/Tf3/v1fUtvnYWd5L+QnzzAwEavCF0zFbTHbsH8KcQMrxidJojxbAnFxhW1a",
	"JHex5KQjuHtN95RewhtupKUWBCUE1Qckn7YbqXOg7RFrUVlj41reJo+AQXfIg7AqkuBUt76bv1CqeEQH",
	"3nOKG2/7grT2fk8/TUNuA3Z47ZPq9qnrgtnzkruFNCxtrXpa7o2zBshbnSCff2nbw19IPRoPdiXtDthl",
	"V83mn4g3v+FjQgvBF7a2q7miCtwnxstKY5bATVoB4YIWE3EBUrIc1MCVMsG/u6DFy/DZ+/EI1pBNtKQZ",
	"TKxZYijWzsw3lk7NOIwzzWgxwav5UIDgxH51aj/aIb/PQogaW60gZ1RDsSGlhAxyW/eQKVIbBaa2EAvJ",
	"lpQvUNRLUS2W9jU7ziVICH1SzT28PcS+uoBe84mtmdkF/9i14o4LjgPNloleWCj7LmkABfJGm72B29Oo",
	"iNxnBBiPehV5g++LOgzR4q3Jga6qdTT0hwhpNTSHqCt9e0huD8nf7ZCkKsQiPuctk4pFYryNN2x7u+ki",
	"yR/QlPdRKqjfNij5qzco8WxJEUokbdxx0j0zqSJMk0ssrzYDYuRdhS4E14jUGQkw3TM66q5wsHJtS7Ml",
	"ZdzV5grJKgiHuXKvVkxr38f7Rqyvlpmh2dWgA7JKMr3BWxEt2e/nYP7/1lwrFMgLf2GqZDF6MlpqXT45",
	"OipERoulUPoI+4TUz1Tr4dsA/zt/1ykluzD3t/cItpBswbiR0Zd0sQBZ2zlHj6YPRu//XwAAAP//d/EP",
	"a0PJAQA=",
}

// GetSwagger returns the content of the embedded swagger specification file
// or error if failed to decode
func decodeSpec() ([]byte, error) {
	zipped, err := base64.StdEncoding.DecodeString(strings.Join(swaggerSpec, ""))
	if err != nil {
		return nil, fmt.Errorf("error base64 decoding spec: %w", err)
	}
	zr, err := gzip.NewReader(bytes.NewReader(zipped))
	if err != nil {
		return nil, fmt.Errorf("error decompressing spec: %w", err)
	}
	var buf bytes.Buffer
	_, err = buf.ReadFrom(zr)
	if err != nil {
		return nil, fmt.Errorf("error decompressing spec: %w", err)
	}

	return buf.Bytes(), nil
}

var rawSpec = decodeSpecCached()

// a naive cached of a decoded swagger spec
func decodeSpecCached() func() ([]byte, error) {
	data, err := decodeSpec()
	return func() ([]byte, error) {
		return data, err
	}
}

// Constructs a synthetic filesystem for resolving external references when loading openapi specifications.
func PathToRawSpec(pathToFile string) map[string]func() ([]byte, error) {
	res := make(map[string]func() ([]byte, error))
	if len(pathToFile) > 0 {
		res[pathToFile] = rawSpec
	}

	return res
}

// GetSwagger returns the Swagger specification corresponding to the generated code
// in this file. The external references of Swagger specification are resolved.
// The logic of resolving external references is tightly connected to "import-mapping" feature.
// Externally referenced files must be embedded in the corresponding golang packages.
// Urls can be supported but this task was out of the scope.
func GetSwagger() (swagger *openapi3.T, err error) {
	resolvePath := PathToRawSpec("")

	loader := openapi3.NewLoader()
	loader.IsExternalRefsAllowed = true
	loader.ReadFromURIFunc = func(loader *openapi3.Loader, url *url.URL) ([]byte, error) {
		pathToFile := url.String()
		pathToFile = path.Clean(pathToFile)
		getSpec, ok := resolvePath[pathToFile]
		if !ok {
			err1 := fmt.Errorf("path not found: %s", pathToFile)
			return nil, err1
		}
		return getSpec()
	}
	var specData []byte
	specData, err = rawSpec()
	if err != nil {
		return
	}
	swagger, err = loader.LoadFromData(specData)
	if err != nil {
		return
	}
	return
}
