// Package experimental provides primitives to interact with the openapi HTTP API.
//
// Code generated by github.com/oapi-codegen/oapi-codegen/v2 version v2.4.1 DO NOT EDIT.
package experimental

import (
	"bytes"
	"compress/gzip"
	"encoding/base64"
	"fmt"
	"net/http"
	"net/url"
	"path"
	"strings"

	. "github.com/algorand/go-algorand/daemon/algod/api/server/v2/generated/model"
	"github.com/algorand/go-algorand/data/basics"
	"github.com/getkin/kin-openapi/openapi3"
	"github.com/labstack/echo/v4"
	"github.com/oapi-codegen/runtime"
)

// ServerInterface represents all server handlers.
type ServerInterface interface {
	// Get a list of assets held by an account, inclusive of asset params.
	// (GET /v2/accounts/{address}/assets)
	AccountAssetsInformation(ctx echo.Context, address basics.Address, params AccountAssetsInformationParams) error
	// Returns OK if experimental API is enabled.
	// (GET /v2/experimental)
	ExperimentalCheck(ctx echo.Context) error
	// Fast track for broadcasting a raw transaction or transaction group to the network through the tx handler without performing most of the checks and reporting detailed errors. Should be only used for development and performance testing.
	// (POST /v2/transactions/async)
	RawTransactionAsync(ctx echo.Context) error
}

// ServerInterfaceWrapper converts echo contexts to parameters.
type ServerInterfaceWrapper struct {
	Handler ServerInterface
}

// AccountAssetsInformation converts echo context to params.
func (w *ServerInterfaceWrapper) AccountAssetsInformation(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "address" -------------
	var address basics.Address

	err = runtime.BindStyledParameterWithOptions("simple", "address", ctx.Param("address"), &address, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter address: %s", err))
	}

	ctx.Set(Api_keyScopes, []string{})

	// Parameter object where we will unmarshal all parameters from the context
	var params AccountAssetsInformationParams
	// ------------- Optional query parameter "limit" -------------

	err = runtime.BindQueryParameter("form", true, false, "limit", ctx.QueryParams(), &params.Limit)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter limit: %s", err))
	}

	// ------------- Optional query parameter "next" -------------

	err = runtime.BindQueryParameter("form", true, false, "next", ctx.QueryParams(), &params.Next)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter next: %s", err))
	}

	// Invoke the callback with all the unmarshaled arguments
	err = w.Handler.AccountAssetsInformation(ctx, address, params)
	return err
}

// ExperimentalCheck converts echo context to params.
func (w *ServerInterfaceWrapper) ExperimentalCheck(ctx echo.Context) error {
	var err error

	ctx.Set(Api_keyScopes, []string{})

	// Invoke the callback with all the unmarshaled arguments
	err = w.Handler.ExperimentalCheck(ctx)
	return err
}

// RawTransactionAsync converts echo context to params.
func (w *ServerInterfaceWrapper) RawTransactionAsync(ctx echo.Context) error {
	var err error

	ctx.Set(Api_keyScopes, []string{})

	// Invoke the callback with all the unmarshaled arguments
	err = w.Handler.RawTransactionAsync(ctx)
	return err
}

// This is a simple interface which specifies echo.Route addition functions which
// are present on both echo.Echo and echo.Group, since we want to allow using
// either of them for path registration
type EchoRouter interface {
	CONNECT(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	DELETE(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	GET(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	HEAD(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	OPTIONS(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	PATCH(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	POST(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	PUT(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	TRACE(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
}

// RegisterHandlers adds each server route to the EchoRouter.
func RegisterHandlers(router EchoRouter, si ServerInterface, m ...echo.MiddlewareFunc) {
	RegisterHandlersWithBaseURL(router, si, "", m...)
}

// Registers handlers, and prepends BaseURL to the paths, so that the paths
// can be served under a prefix.
func RegisterHandlersWithBaseURL(router EchoRouter, si ServerInterface, baseURL string, m ...echo.MiddlewareFunc) {

	wrapper := ServerInterfaceWrapper{
		Handler: si,
	}

	router.GET(baseURL+"/v2/accounts/:address/assets", wrapper.AccountAssetsInformation, m...)
	router.GET(baseURL+"/v2/experimental", wrapper.ExperimentalCheck, m...)
	router.POST(baseURL+"/v2/transactions/async", wrapper.RawTransactionAsync, m...)

}

// Base64 encoded, gzipped, json marshaled Swagger object
var swaggerSpec = []string{

	"H4sIAAAAAAAC/+x9+3MbN5Pgv4LibpVjH4eyHTv7xVdf7SlxHto4sctSsrdr+RJwpkni0xCYD8BIZHz6",
	"36/QeAxmBkMOKdlJqu4nWxw8Go1Go9HPD5NcrCvBgWs1efFhUlFJ16BB4l+0KCQo/G8BKpes0kzwyYvJ",
	"KSc0z0XNNanqeclycgXb2WQ6YeZrRfVqMp1wuobJizDIdCLhnzWTUExeaFnDdKLyFaypnVZrkKbvu9Ps",
	"vx9nX77/8Pxvt5PpRG8rM4bSkvHlZDrZZEuRuR/nVLFczU7d+Lf7vtKqKllOzRIyVqQX1TQhrACu2YKB",
	"HFpYe7xd61szztb1evLicVgS4xqWIAfWVFVnvIDN0KKiz1Qp0IPrMR9HrMSPca9rMIPuXEWrQU51vqoE",
	"4zqxEoJfif2cXELUfdciFkKuqe62j8gPae/J9Mnj238JpPhk+vzzNDHScikk5UUWxv06jEvObbvbAxr6",
	"r10EfC34gi1rCYrcrECvQBK9AiJBVYIrIGL+D8g1YYr8x/nrn4iQ5EdQii7hDc2vCPBcFFDMyNmCcKFJ",
	"JcU1K6CYkgIWtC61Ilpgz0Af/6xBbhvsOrhiTAI3tPBu8g8l+GQ6WatlRfOryfsumm5vp5OSrVliVT/S",
	"jaEowuv1HCQRC7MgD44EXUs+BJAdMYZnJ0nWjOsvnnXpsPl1TTd98C5kzXOqoYgA1JJyRXPTAqEsmKpK",
	"ukXUrunm74+nDnBFaFmSCnjB+JLoDVdDSzFz39tCOGwSiL5YATFfSEWXEOF5Rn5WgJSEX7W4Ah6og8y3",
	"+KmScM1ErUKngXXg1ImFRHQgRc1TjIrgB4fmAR5l+94ng3qLI97u/qbY0n3qQn3OlhfbCsiClea+JP+o",
	"lQ4EXCvc9hUQVUFueG9BzDAG+YotOdW1hBeX/JH5i2TkXFNeUFmYX9b2px/rUrNztjQ/lfanV2LJ8nO2",
	"HNiBAGvqnCrstrb/mPHSR1VvknfJKyGu6ipeUB6fBUMrZy+HKMOOOUwaaQZ5GuQG3B831sXm7OUQS93d",
	"Q2/CRg4AOYi7ipqGV7CVYKCl+QL/2SyQtOhC/j6x4oXpratFCrWG/B27RoHq1MpPp40Q8dZ9Nl9zwTXY",
	"qzASM06Q2b74EEtOUlQgNbOD0qrKSpHTMlOaahzpXyUsJi8m/3LSCHontrs6iSZ/ZXqdYydzGUswjC+j",
	"VXXAGG+M8Iii1sBBN3zIHvWFkORmxfIV0SumCON2E1HuMpymhGvK9Wxy0Em+jbnDOwdEsxX2krRb0WFA",
	"g3tBbMM5KKR9J/Q+UC1JETFOEOOE8oIsSzEPP3x2WlUNcvH7aVVZVE0JWxBgeJ/DhimtHiJmaHPI4nnO",
	"Xs7Id/HYN6wsieDllszB3TtQmDEt33Z83AngBrG4hmbEB4rgTgs5M7vm0WDksvsgRpQqV6I0V+BeMjKN",
	"v3dtYwo0v4/q/Jenvhjtw3SHEr1DKlKT/aV5uJHPOkTVpynsYajptNv3OIoyo+ygJXXWIPi+6Qp/YRrW",
	"ai+RRBBFhOa2h0pJt16CylAS6lPQzwos8VR0yThCOzUCOSdremX3QyDeDSGACpK2JTMrXt0wvWpEroD6",
	"We998dcm5NSeE7PhlBnZmJRMaSMM4WYqsoISBU4aFAsxFR1FNCNoYcciAsw3klaWzN0XK8cxTmh4f1lY",
	"73iTj7xkkzDHaosG7wjV0cx8L8NNQmIVDm0YvipFfvU9Vat7OPxzP1b/WOA0ZAW0AElWVK0SZ6pD281o",
	"Y+jbNESaJfNoqllY4iuxVPewxFIcwtWq6mtalmbqPjfrrBYHHnWQy5KYxgTWTJsHMON4ApbsGrhlPTPy",
	"Dc1XRpggOS3LaaOXEFVWwjWUREjCOAc5JXpFdXP4cWT/UMJzpMDwQQ0kWo3TaczIxQokLITEh6oEsqZ4",
	"Oa3N86gq230Cc1V0DR3ZCS9LUWsDY/RyOXvpVwfXwJEnhaER/LBGfPDHg8/M3O4TzsyFXRyVgIoWxvOy",
	"Lhr8BX7RAtq0bq5a3kwhZIGKHqrNb0ySXEg7hL383eTmP0Bl09lS52eVhMwNIek1SEVLs7rOoh4G8r2v",
	"07nnZBZU0+hkOipMv+gs58B+KBSCTGg3XuN/aEnMZyPgGEpqqIehnIIyTdgPvLMNquxMpoHhW1qQtdWb",
	"kYrmVwdB+XUzeZrNjDp531hVndtCt4iwQxcbVqj72iYcbGiv2ifE6nw8O+qJKTuZTjTXGARciIpY9tEB",
	"wXIKHM0iRGzu/Vr7SmxSMH0lNr0rTWzgXnbCjDOa2X8lNi8dZELuxzyOPQbpZoGcrkHh7dYyg5hZGlX1",
	"6VzI46SJnmmiUcATakaNhKlpB0nYtK4ydzYT6nHboDMQCeql3UJAd/gUxlpYONf0I2BBmVHvAwvtge4b",
	"C2JdsRLugfRXSSFuThV8/pScf3/6/MnTX58+/8KQZCXFUtI1mW81KPKZ0/MRpbclPEw+nFC6SI/+xTNv",
	"EGmPmxpHiVrmsKZVfyhraLEPY9uMmHZ9rLXRjKsOAI7iiGCuNot28tb2u51OXsK8Xp6D1uYR/EaKxb1z",
	"w94MKeiw0ZtKGsFCtY1STlo6KUyTE9hoSU8qbAm8sKY3sw6mzBtwPb8Xohra+KKZpSAOowXsPRSHblMz",
	"zTbeKrmV9X1oPkBKIZNXcCWFFrkoMyPnMZHQXbxxLYhr4ber6v5uoSU3VBEzNxrAal4MqCj0ho+/v+zQ",
	"Fxve4GbnDWbXm1idm3fMvrSR37xCKpCZ3nCC1NnSnCykWBNKCuyIssZ3oK38xdZwrum6er1Y3I+OVOBA",
	"CRUPW4MyMxHbwkg/CnLBC7VXm+OtgR1kuqnG4KyLLW/L0sNQOTSdb3mOaqT7OMvD2i9n6iNqy/NIFWZg",
	"LKFYtmj1o6q8hjBloXigEpAaTL3Cz2gReAmlpt8KedGIu99JUVf3zs67c45dDnWLcTaHwvT1GmXGlyW0",
	"JPWlgX2WWuMfsqCvg9LBrgGhR2J9xZYrHb0v30jxEe7Q5CwpQPGDVS6Vpk9fxfSTKAzz0bW6B9GzGazh",
	"iIZuYz5I56LWhBIuCsDNr1VaKB3w2jEHNa+lBK5jORf1GUyRORjqymltVltXRIvU/dJ0zGhuT2iGqFED",
	"bg7BVcO2stOt6DUQWkqgxZbMATgRc7PoxssBF0kVqYzs7MQ6JxKP5bctYCspclAKiszps/fC69vZ+0fv",
	"QB6uBlcRZiFKkAWVH2cFV9d7gb+CbXZNy9qI5z/8oh7+WRahhablni3ANqmN6Krv+ku5A0y7iLgLUUzK",
	"VltoT4IRsQ3TKUHDELLvjr3B7e+C2SOCj4TAa5DoUfNRj5af5CMQZYD/Ix+sj7KEusqMGDiofjCSq9lv",
	"TrnwsuGeGcIEJVU623elmEYtvYlZasTFU7cIDjwgT76iSqMYSBgvUH9rr0Kcx8qWZorJgU5lOOXga8xM",
	"+ot/iPWnzc31zlWtwqtM1VUlpIYitTy0WQ/O9RNswlxiEY0dnn5akFrBvpGHEBiN7/DoFAH4B9XBQu1s",
	"3v3FodeBEV+2h2K5BV+Do10wnvtWEeJjp9oBGJlq9sCSG1MdepsLUQJFlanSoqoMh9JZzUO/IQye29an",
	"+uembZ8krRnISiqFAIUmJtfeQX5jka7Q1rWiijg4vH8CKrysi1wfZnOsM8V4Dtmu84KPYNMqPjhHHfe6",
	"WkpaQFZASbcJbwv7mdjPBxKGHxsJpNEfCA3ZHK2JaRppzoT3Nz1uVoFTqZTgTfALyc05N8+ohtRc7+Mn",
	"LQCnTfFNR6wPwiwIRpIO/HiILEtPiRHx7r8W2pCVIzpcjbuV7riWAeyFWT8KAnHcrFEEdGf/L1Bu7iCA",
	"3ev8W1BDC2+mvq9lD6j/8W5vXZidq6xz2ySviEG+vIcxDvGgAVvEGyo1y1mFz9UfYHvvr/fuBElfCVKA",
	"pqyEgkQf7Eu+ivsT64bcHfO41/wodWsf/J6+NbEc75nVBv4Ktqg2eWMjGiJt1X2oIxKjmguXcoKAeq95",
	"8+KJm8CG5rrcGsFWr2BLbkACUfXceq30TWhaVFk8QDpmanhGZ5BPmsN3egic41DR8lKeh/a1tRu+i86T",
	"q4UO98qqhCgT+s/uie8hIwnBKHchUgmz64yW5ZboEDbjKakFpLsg0BsjyDMPVAvNuALyX6ImOeX4wq01",
	"BCFNSJR8UFg2MxhxM8zpXFUbDEEJa7Cvefzy6FF34Y8euT1niizgxrrccGzYRcejR6iKeyOUbh2ue9B2",
	"m+N2lrh00FZpLln3auvylP1Obm7kMTv5pjN4MHCaM6WUI1yz/DszgM7J3IxZe0wj4xz8cNxR5ru2S1hv",
	"3bjv52xdl1Tfh6ESrmmZiWuQkhWwl5O7iZng31zT8nXodjudwAZyQ6M5ZDlGCY4cCy5MHxtYaMZhnJkD",
	"bANHxgIEZ7bXue2056Xd+C2z9RoKRjWUW1JJyMFGyRkpVYWlzogNmchXlC/xBSRFvXSuznYcZPi1spow",
	"WfPeEIeKYnrDMzRhqGSYGpotfbSlEcKAmpdt1/5hH2s3NIBiL6NRl3a0PV17UNJkOp0MPvwNvq+bh7/F",
	"Wztk9FhjYks+jJDWQDPSeob4NLJSH4nxNprDZ4jh41hpmqFTUPYnjpzCm49DfuHndVWV23sQkuxAREIl",
	"QeGVFqsBlf0qFuRHlktxWi5FuPPUVmlY9403tuuvA8f17TEvYMFLxiFbCw6JJ/1r/PojfhytdrTX8MCI",
	"KBAdNGD34dNCQmcB7cnHkPRdNwlJpnv2u5ZO9a2Q92VltwOOflOMsFzvdetwUx5rX6dlmTBJW/VDj4uo",
	"aXAKZ5JQpUTOUFA8K9TUeZ9bK7Z1a++g/00IjbqHA9wdt2N7jcKwrCIfyopQkpcM1fyCKy3rXF9yipq+",
	"aKkJZ0GvHBhWC3/tm6T10Ak1sRvqklN0FA36v6Rj0AISeqhvAbx2WNXLJSjdeWAtAC65a8U4qTnTONfa",
	"HJfMnpcKJHrszWzLNd2ShaEJLcjvIAWZ17r95FjXShOlWVk6Q7CZhojFJaealECVJj8yfrHB4bwfiT+y",
	"HPSNkFcBC7PxjGsJHBRTWdrT8Tv7FYNKHE5WLsAEYy3sZ+/x3OSGmJi1t5JW/J/P/v3Fu9Psv2n2++Ps",
	"y/9x8v7Ds9uHj3o/Pr39+9//b/unz2///vDf/zW1fR72VDC4g/zspXujn73Eh1gUJ9KF/c9gkFkzniWJ",
	"MnYo6tAi+QzzZTiCe9jW++kVXHK94YbwrmnJCsOL7o18utdU70DbI9ahstbGddR4HgEHPofuwKpIglN1",
	"+OtHkee6E+x0uIm3vBNj4DijuncA3cApuLpzptxqH3z3zQU5cYSgHiCxuKGj1AKJF4yLYGx5+ZhdigO7",
	"LvklfwkLfA8K/uKSF1TTE3uaTmoF8itaUp7DbCnICx8U+ZJqesl719BgAqkoqDnKIJXiFHSdXsvl5Tta",
	"LsXl5fueH0JftnJTxVzUnbO+msxPmRm5QdQ6c0lcMgk3VKZsIT7Fh4uGxt474bAyiaitEssniXHjz8ZC",
	"WVWqm+yhj6KqKg2KIlJVLl+B2VaitAiBY4aZu9hbQwM/CedUIumNf/LWChT5bU2rd4zr9yS7rB8//hxD",
	"8JoUB785HmjodlvB6IfvYDKK7nsXF27lcnQqzyq6TNlMLi/faaAVUggKHGt8aZYlwW6t8EAfCYBDNQsI",
	"scgHbImF7OC4Xlzuue3l03qlF4WfcFPbsdN32sEoKv7oDdwTWU9rvcoMR0iuSplj4PfKJxigS3PleA8C",
	"xZb4AFArUZslA8lXkF+5zFawrvR22uruHV3cXewZDlOoM3LBgQtm8JdTbgasq4I6QYbybTfFjbLBEDjo",
	"W7iC7YWw3Wcjs4NF2eiiFCtq6Ogi7UZ3rSHf+CC7Mbqb7/yufIyoS0eCcZeeLF4EuvB9ho+2FQDu4Vin",
	"iKKV52MIEVQmEGGJfwAFRyzUjHcn0k8tj/EcuGbXkEHJlmxeJtj0f/btGh5WQ5UScmDXPqo3DKgIWxDz",
	"Oprb69i9mCTlSzCXurmIhaIlOu3PkoZ+lA5XQKWeA9U79bU8TjPhoUOB/AaDplFpMjVLgI3Zb6ZRCcLh",
	"xjzw8O1t2zhH4tlR7lR2TVAcCarv3gRJz455RDiEJ/LZ+fs+7El4Lzj/tJg6EWT7fW1wuJTixuymAVD4",
	"1I2Y4CW6p2pFlzD2OmqZikamxGhZgHCQfdJPUt4Ri65Y05MxRi7Cds8MXpLcAcwXwx7QDNBxcfRzWxOi",
	"syq85uXWI3VeokAdHEQt6VDZsrPx5WHAptkYSN4Iqx6wNtbio7+iyh/9Yhpx9COlxT8mlcyu/Hlnkfcd",
	"1f3seP6a7rL2qdXnzIEIbnr4LHo+dZ7PlzeZHpT7bjpxIQ6pvRMcpegCSlhanNjGns6a/EzNbho4Xi8W",
	"yPSylCNfpIyMJBM3B5iH2CNCrMacjB4hdQoisNGyjgOTn0R82PnyECC5yy9F/dh4d0V/QzpY0HrjGylZ",
	"VObWZwNWq9yzFJfeohF5Oi7OOAxhfEoMJ72mpeGkLvC0GaSXqw3fPp3MbM634+HQm2jkQXNrROnkoFVa",
	"eeaY9cWCt19G+lVw0BrmYpPZyOjk02q+mZszkYxXwDjt1OG1mfMeKDIXG/QpwhvOOrgfDN0wZB6wyA1k",
	"wxRSOfYbEhsteIcBsluQT1GzQtJzerVAdkOS7HHADIjTQ2T3WZRC755A6igwmzTgTqOzV8/Slrb6kkhz",
	"3U5DdtgQppZiNUOHM7mTAxjtK0/bue6+b9IdDidH82f1kyT56yvl7pKX0XaubK7FQ9IydsmhBcQOrL7p",
	"CrFJtLYdl9p4jbCWYkmG0feNXX20KSgBNQFZS67OrlJm6cvLdwpQZjj33SI9J+4e5duHkTechCVTGhrj",
	"gndy+fS2H1QnmseWWAyvTldyYdb3VoggaFhzLHZsLfOTrwBd1xdMKp2hZSa5BNPoW4WatG9N07Qg3Pa3",
	"Y8qaeg6WgxGiK9hmBSvrNCk7kH54aSD6Kdxcqp7jRcm49TaaYyr8pIPuAbZJhMc6du9E0CuLoFf0U+Bn",
	"3MEyTQ1M0lBee/q/yBHr8MJdnCVByyli6m/oIEp38Noolr7PaCMhOnK7mO2y+fTOZeHH3uuN5SP6h4QI",
	"O1JyLVFGxHQAoVguofCZ3lxQqM165fLplYIvm1yC5vcd6QNnxGbxwyR8O/L3Ofd0GHJOb5UTwaoYSejj",
	"xwxC3kTXYe5BnGQJ3GZumRxeb6RMIi52jMcWkWb00/L2ntt80nX4ouMu3Pj02j0Mm43bUwIt3LNKgV/f",
	"7kPb3y6HuumQ03ErRezuA4YDIsUxrSIBpkc0A5ybVhUrNh3Dnx11dgRJjBT3+pngOzhDtuQG24OftmPx",
	"nlo9D8ztiO2dseMEn/kn5pFp/ZmdR645GzR32QaKWqI1qeUt3M+nHx6aI9f+wy/nWki6BGcRzCxIdxoC",
	"l3MIGqKU9IpoZh2kC7ZYQGwJU8dYcVrA9ewdxQjCHiDBvrksvC130mefyPbQVrOC/QhN01OCUoZ8Li76",
	"9kj/8Ih0a+GyiTbuCKNiMqHAD7DNfqFlbV5CTKrGN9UZCNvX+gE0cb3+AbY48l6XTwPYnl1BVdxbQApN",
	"WVfCJxVlCX+gWtUX8A3c2sIDduo0vUv3tDWulMbw0WhuqFY9ifZSPt6xaVxkDKRj9uo87XVizha0t6VL",
	"6Pu2iBX7ZZ/oCRJPxdB745hLLmTa2OtdBrT0hI+LndxOJ3fz90jdk27EPTvxJlzNyV1Ab0xr/285fR24",
	"IbSqpLimZeb8ZIaEDimundCBzb1bzSd+X6VPxcU3p6/eOPBvp5O8BCqzoOoYXBW2q/4yq7IlOHZfQzYd",
	"u9PtWlVYtPkhZXbsSXODqdc72rRerZvGbyo6qM6zZpH2FN/LN52Ll13iDlcvqIKnV2ORto5ebecuek1Z",
	"6Q2/HtqxWna73HHVlZJ8Ih7gzk5ikfffnccajBO4vHx37THb2FOso1RIiZ/wpVNHejr3eE36rDa0vodD",
	"4jpfYybT9LuLuzynyBidwxm9dznwWyFbF5WLakw6rH08AdE8Jiwe00b5C2eF74mFM2JFyN+Wvxne8OhR",
	"fPAfPZqS30r3IQIQf5+73/Ed9ehR0jCcVPUZloWaPE7X8DDERQxuxKdVQ3C4GScunF6vg4wshskwUKj1",
	"PPPovnHYu5HM4bNwvxRQgvlpNkZVEW+6RXcMzJgTdD4UlRicn9e2nKcigndj8DFK1pAWXj2ugoe1s/eP",
	"EK/XaHfOVMnytNMPnyvDkrh16TWNCTYebUM2c9RswK+c1ywa3TRTR5k8OwuJZk0iXCUzATf4nQvHAmrO",
	"/llDVNYXb+LO5eyfQjhqT8BO6xfdwN2qwZNjCv7e3UTotWq7FEY7Ta4vgxnQIyJVZ+rAeId4xh7z3xGr",
	"4CjKX58Y2LZyrsN7KWvnO293EWhnBvbs01lchx9Irhym3cyXY3aaqWwhxe+Qlh3QSJhI3eGt2wwV8L8D",
	"T/modhlZ8BxoClY3s+8jkPG6hSFSubMuwS86VM075gpP84nDNvpApUG038NqA5VOL+42YeihGjuetANp",
	"BpgZHtjILRxr+Xh3N8rtCbV5LVqRZ+lzHgeKntjxm3PuYO4F15b0Zk5ThY7Me9HAFG1/yzFPC+I7+w1S",
	"ITWDnZ1EsQyhLbPJ/iqQjfWonyr5yLefnXb0q6955CHFxc+7qfVVKZVIDFPzG8rRjxD7WQ7oeiuwfhim",
	"142QmOBTpX0IC8jZOqkMv7x8V+R9z6+CLZktKV4rIHShXZ5HN5AtKm+pyFXzDrlIHGrOFuTxtDmzfjcK",
	"ds0Um5eALZ7YFnOq8IIOPhGhi1kecL1S2PzpiOarmhcSCr1SFrFKkPA+R9EzeMLOQd8AcPIY2z35knyG",
	"DsOKXcPD9AXjhLXJiydfTndVzkaMY5H4XUy+QC7vAxnSlI1e1XYMw1bdqOnIhIUE+B2G75Md58t2HXO6",
	"sKW7gvafrjXl1CAkBdN6D0y2L+4vunJ08MKtdQaUlmJLmE7PD5oajjUQTW4YogWD5GK9ZnrtPEWVWBsK",
	"a8qQ20n9cFhfz5dB83D5j+iCXSXe+H/Ac4uuByIc0av+J7S3x2idEmoztpasib/wFWrJmc9MjXXhQjk4",
	"ixszl1k6yqsYjrEglWRco9ao1ovsb+b5LmluGOJsCNxs/sWzRH21dgkifhjgnxzvEhTI6zTq5QDZeynH",
	"9SWfccGzteEoxcMmpUN0Kgd9xdP+vUNuxwND31m6NuNmgwRYtwiQRtz8TqTIdwx4R+IM6zmIQg9e2Sen",
	"1VqmCYbWZod+fvvKSSJrIVOVLhoG4KQSCVoyuMb40vQmmTHvuBeyHLULd4H+j/Vu82JpJLr50518LERW",
	"5cQ7LaRVMpL+Lz82+fHRuG3jdjvaSyETelqncfzEbqmH6Qu7NnTrDojfBjA3Gm04Sh8rA+EeNp4j9Pkj",
	"/L26INk9b6lKn/xGpHnHo6z/6BEC/ejR1InKvz1tf7bs/dGj8S6zaX2h+TWBmuPumm72StM3tdVfiYT2",
	"zlfxDH5jLlVJQsOavMvMlTp3Y0xJu1Tip5c77ide8WA35PQB8qjBz13c/MH8FTeziYAZ5g/t6rFJ8inC",
	"9yiGgpKvxGYsEXWuLU9PfwIUDaBkpFYQV9Krjpv0lNjr5hORrRl1DqUwL9W4ANZor5W/0C4Y1Ex37EXN",
	"yuKXxgrduZkk5fkq6VQ+Nx1/tc+AqEGkwchXlHMok73ta/lX/6pOvPv/IQaGXTOe/tQtxGxh70DagNUG",
	"wk/pxze4Yro0E8QoaifkCilOyqUoCM7TVC5pWGO/onmqkmwixh+HXdfaeSVj8gRXUGTBSnSjTdvDsWUm",
	"qR7gqlj235e4MuNgFX5l1RJ2dJCEsjVe24quqxLwEF6DpEvsKjh0umPGNhw5KktCVGU+YUtM/iKIriUn",
	"YrGIlgFcMwnldkoqqpQd5LFZFmxw7smLJ48fPx5nZER8jVi7xatf+OtmcU9OsIn94ip/2YIJB4F/DPS3",
	"DdUdsvl94nLlV/9Zg9IpFosfbEA2WojNvW5Lr4YywTPyHeYnM4TeKhGASlGfYbmdE7SuSkGLKSaFvvjm",
	"9BWxs9o+EhB1WPp1iRrA9hFJGnnG50j1+dcGcleNH2d36hyzaqWzUJQ1lUnRtGhqybKO9xPqBmPszMhL",
	"q5YNjj12EoKpxeUaiqgGrFUDIHGY/2hN8xXqO2eTnSrlgWpA40sYew7YmIuiuNdQMAs5uFmGq2JsixhP",
	"idArkDdMAeadgGtoJ2wM2U6dQt4ncGyvVtacW8KZHSC9hvJYh+6CB86Kvt6/IglZZx/ubPtrMnlgkfND",
	"iz2fY6903E6ncnTH78GWzNj4ohsz8qMzduSUC85yLDaREsExFeM4s+qIuhxpe6eauLOcOIbJetUhQN1h",
	"cbCCtWeZDnF9p4boq9lvSzj2Tw0bVwRwCVo5HgjF1JePdwY6xhW4AmiGvmKOKmTC9SsZFhNcSO7RJX06",
	"wWxqA7rWb823n5xuHnPGXDGOOjeHVPcStAa2UjG0s3PCNFkKUG617bgw9c70mV1sOILwfvZKLFl+zpY4",
	"hnVFNEixXsD9oU69T7DzwTVtvzZtXe2C8HPLpc5O6tf9PslCVNj/VM31QfSnfL+8I02E3DB+PNoOYtzp",
	"6o/3siFDuEbPP6jwPu+RTShf3x7lG/NktfSGLYiN3E2mDWY8AcYrxr3BN50HK0/eJbgxeJoH+qlcUm0f",
	"HaM43gXQciAcBoPqrcfAXYfqVmIwKME1+jmGt7GpvD/AVkKD5nVB+Zb4Q2GoOxJKvqZlcIZP1NFH6cwJ",
	"Y9ZZuFNZP8VWDFvPfGhuC117A0FDd6yGcug9NZRtdF4XS9AZLYpU3rmv8CvBrz6gEDaQ16EIWIgzbadr",
	"71ObmygXXNXrHXP5BnecrmCKKgXreZlwvX0ZPkIRdhgTUc23+G+qAtbwzjin94Ojv72He3FYjYJ+NHtK",
	"ejY0nSm2zMZjAu+Uu6Ojmfo4Qm/63yul+8DvP0Vcd4fLxXuU4m/fmIsjTtPd8/G3V0vIoo3+9AK/+3xg",
	"IZNrmyvhVdar84YeGbh5iS3rAO8bJgG/puVAxoXYamPvV2vJGMq7kA+mFaHaZa/TlDQ8YYwKYzj/l/XA",
	"7liG+ubNIR9r62L9MY0nDh87kT5safyhZVe0Xm8NQxm0Jx5n8muI4FCbnyvF0NeX0rIU+WjO4IY5NZ2G",
	"U/WK9dplvk945V2vRRGfhdibCyDN2KzDciK0Ah+2yW/4tEp+kTfp0Vr6kUA0Y7OWIRrdEqY2MNOD54Gx",
	"U8cTRSpbh1nyLSuxONR/nL/+aTK8kdEO9LfUpc5OqrCHNiZEqnXJYyla+NjBAwQv0/pvNaBSx9xQ6dPg",
	"qhMnP3xrFYRjQLJ5kg5p/Wrs4D0CWApbFSpVN6OfnWbSbIdHfkQNzfZajhJTR4oqutWWEm8fq/RsmpBQ",
	"iHRUYdKWjDSmuFOqjpB7KXgNrL1oXD46W1ypV5epx0BfjhEOe/i4nU7OioPEp1QtqokdJcVgX7HlSn9V",
	"ivzqe6AFSFtPJPWctNVE1mCeoWrFKnz/VEKxph5waQZzibxXONxsbGjOxQpcVhifJKA3lnegvoZcY33o",
	"xg1UAoz3c6jSSzQQeIMiNvkDXEEkQAGVXu0Ulqxzd6VXTdlQcJFnTJE5ONPFNfApYTOYdYPViiYpFCmB",
	"LrwSVgqhR9TVDWFLiMYY6BR99Wo07xYDeznfopSGtpTubHwRltMQE2ADLW+oajJHddIojA7XXiwgx4T3",
	"O9Pv/ecKeJSPbepVdwjLIsrGx0K4IJZsuFeNdgPrrkR4O0GNalJ9TEiHEmJcwfaBIi0aSlYEDhG2x2SA",
	"R+RYO64vKjBk2nCOkUwFekIEeT94l4C/qbF0TBGAKDvlkWB4GjfXU5Ox8jhovERzBBim6+xORfubdHgo",
	"mA5l9+tXVx9+Kb/EYvbKOZXSkG4+1ieRs3455huXrh4TLQZroU9cD8r/5hO02llKduUq1CDCrG32hsrC",
	"t7iXNHn23mRpoBdhZtYERvW9fA71y7ERinkpjACUDQWGtiOVggvvA2V9rZukZQj1AqSEItgES6Eg08KH",
	"WR2Q/NOFT+7AnvUyPwpvHY/+A0KG7YoGayi8bQpJYDlIijUTqHM+j7FCJKypgV5GxR3SatB9O/S1/e5z",
	"ivjyfrvVq0N4D+dif4VsH3rHVA/z8elaECccHMy9WolIjtDMMs5BZt6I2y3twNtpMjGvclHnVlSJz2bQ",
	"Xo9OO7aDmyWVmnl/lZ0nVJSV4wq2J1bt46uO+x2PgbYypAU9SijdIYp71VWrFNzLewHvj03fWQlRZgOW",
	"wbN+PYruYbhi+RVgYtYQmWKk4AftY2MmIZ+hQSr4jNystr7aQlUBh+LhjJBTbqMDvftIuwJpZ3L+QO+a",
	"f4OzFrWtMOM00LNLng6zwkov8o7czw+zg+cN8SYFhl/ecX47yBGz6w0f8pG7wZIw7TrBs7Hqjb5/R0eE",
	"isjPQpESoM6tIfhrZAmJdxTB7CxRGiH0D6DEGZCJKkXKC/+YDDJmqDSm4skQIA18xHO1gcINnkSAc7Lb",
	"k5XVffZ5R8WCSGh8M45NwOpymlomroZUI92ZwyxtzrgQEuIZ0c/UJmoOkW2Y5xj/M2daUrk9Jk1qG1Up",
	"NdQglvd6SwZHyWYhjbNkH4dlKW4yZGtZqK6UUgeYdqp9bfs6pU0/c9TnELldUuVExC1Z0YLkQkrI4x7p",
	"EG8L1VpIyEqBXpgpx46FNo+ENcZ1clKKJRFVLgqwhdDSFDQ0V805RdkLIle2JAos7WDKANsnouORU5rb",
	"15pnM5TX9hba8Jt/YfrY9BVN+ju76My6CAzEF4By6e4chmzjPrxIODYjU1cpmxaRF2yDdAMydeQXRMsa",
	"psS16FbhdwefSiBrppQFJdDSDStLzB7BNpFDQ/AHSqN2QHY+Qz/oa4YOb+1MIlakrsztGNKvxDzgPM7I",
	"RvRKinq5iuoDBDj9013W7mEfj/KzqtEnEUNEzRTPyFoo7Z7FdqRmyY0L6Ge54FqKsmwr8qycv3RG3x/p",
	"5jTP9SshruY0v3qIj3AudFhpMfUpFbq+u81MspODcdxLQW94huSh9qdZt+3Qq9XR82je2eF+PcPDPk1+",
	"BOb7/cx1v13jtL+w7rrafDb9FjrlhGqxZnn6uP21vF8HfVZT3CuZadFWIbZZaLAZ8oH4HgvuTMg9+2gG",
	"TpNlVE+J4xHOrQM5kfkvivHdcckCHA8auEP7fMcJWFk+KAZ2AEBIbSIEXUtbujgW0gLDEUubOAWdUrqA",
	"jrxw0PfvbrCZEe4dKA13AqrnjRwA/MxqMKY2I6b1bJ6Ljf/+sEmZeRTwt7upvMU8hpwqzxvSktat0iey",
	"GuAI6QIEOz0QLzAJxnysH2IoRT/y8o8AGPZMbMEwyj/xUDAWlJVQZKkqxWdBBzaNnusuxjIa3ddztJw8",
	"p7WvBGzGriW4xEpW+pdtc2JFDSmJ0LyvEecFbMDGaP0OUtg6vtPInAWlLfPb0SiIKivhGloOmy7bU41S",
	"KLsG31eFzqQAqNDi21W0pTwR4yqBHe2LW3sW+bKNwW5SHWMRa3eK7NG1JDVDG57ZY6LGHiUD0TUratrC",
	"nzpU5GjrEs1RTqCq93zI/BNz7DQ/2xHe+gFOff+UKOMx8X4cHzqYBaVRt4sB7fVMrtXQqedpx+Q4lVkw",
	"FOFsRbBrWxJv+Iaq6A0f1mr2Sb55iY3cJyZ4hNhvNpCjVOOeQlC4x9CA5cTlQEJq5wCFfTCYLglt/go4",
	"4SKqeXxDVXjFNFld/Q92YmzEuHtoH2Gjb/yH776zBAcjqpNsMV2iNJD13XT8f8hJ3HkQB8dL0YgCF8q7",
	"QzXmqds9O7CBqMuCcLOfRvbHGsHuFnNcfErmtR+oLMWNLWIcP1FfgrfnWurzJiYnlrNwLXs/6alLONzV",
	"grAoQmRNt0RI/Mc8SP9Z05IttshnLPi+G1ErakjIGZCtF4XzuzYT7xavph4wr4gRfiq7bjZ2zGi4rRkl",
	"Atpc5L5smyBregXxNqCDiOWfuTaMU9VzVGqYK7uznX0suMX79ExrWsRKAEw0u21xB5/w3PT+n03YajyV",
	"z/9YlTT3Jatd8bk2n8Gq9p649ArWu8Oc+3zNk0ColN8QrfRpMoojtKkHsq5UzM9QcawW2L0S4L26YHda",
	"xkilcKfG0Y4A8VFLue9duJ8Yzt6S4lK/+xYXVz7+NLuTzBA9tIwx4P+JdqXlXtGLbEtXUI/XY4ulf4Jd",
	"aCXiScBq1eBzsckkLNQ+RxqrB5+LTQOwCrpbxnMJVFm/o7PX7tnaJEBm3DyjrdduMKuGUQpYMN6wWsar",
	"WideQZgHmW8jhMXWBETrgG1uSMYwoug1LV9fg5SsGNo4c3psaeC4SI+3oLi+CQVIuJH7AzDVvAAxnrrR",
	"z8fNzPVvCwxa31mlKS+oLOLmjJMcpJEayA3dquNNVcHqsM9YRSNZqJ0tJDJbIWlbQMqtszbf0ZAUAKT3",
	"aFEaYQlCJ+2EFcgqhrQYMPz0YfhLWILWdJOVYolRvwMHwuW5RtOhfUAKjkp0K92NW7efR7HfYfc0WIrE",
	"MSItcNYxU+w+969xK/ER+jNneufJtxrObhi29XS2B9MjlS+b8AxLLP3zmIqcd4mZ4uh5L6r6NCWe9iDa",
	"xKRLdE+rPrCL6F/h0i7EKvTxxSrbLhyp+HyrV8hQ36B2BGCAauIKaO48xPqKuJ6iwiJl6rIbHKins9p9",
	"fy8NgIeKFOXOenva4KBjxjmkwufufAZZJaosH+PbaqsVFc7I4CBtwzhAH5EJYWDdwe9GhfpdrZxorUJe",
	"hxY5HSwkts9WVuW7VAZDSqYBjt42YIgF8jI8wla1hrFWQRUz9Y9zb+xuK9ECkyCUSMhriUrmG7rdX/hx",
	"IPv8+fenz588/fXp8y+IaUAKtgTV1DToFE5sXBMZ72qNPq0zYm95Or0JPluIRZy3Xvqwt7Ap7qxZbqua",
	"ZMS9spGHaKcTF0AqOLdfIu+ovcJxmrCIP9d2pRZ57zuWQsHH3zMpyjJdUybIVQnzS2q3IgOMeYFUIBVT",
	"2jDCtv2U6cYpW61QuYhZw69tbijBc/DaZ0cFTA/4cqUWMuTTi/wMczE4mxOBTVU6XmXtRLvW5d5pVr+H",
	"QiO628yBVKJyoj1bkBREGLMlawh6dac2RX165KYbmK112E0RonN+T5PeKXcvYbEgu7l9uxS3TnN6s4kJ",
	"8cIfyiNIc8i6MZxn5BhO0hgG/jT8I5E45d64Rljux+AVyffBjqjw057XREgaMgq0foKMBHkgAAPx0K2g",
	"1SjILspNLq2NAa0R3vzcFT9+bMzSeyNTEBLfYQ94cSxz0y4EUzhw/uDE3j8GpERLeT9ECa3l7wuP9qw3",
	"XCTRFjmlidagLFsSfbEwCohXX4c484FXSS8cXQqhiXmZlmUijN3qcfBMxYRjngTympafnmt8y6TSp4gP",
	"KN4OB27FYcsxki0q1b0n5HxFR4EVhSh/Eqj4G4yt/08wO5u8Hd0szvDfuwNRJURL6+29CBZw4OQGx7SO",
	"XU++IHNX7qeSkDPVdSi48SJNiLcFyRbOvxY2uhv7e+cyQb8IfYfjsPD+QOSnyMgWPAcczM1R/4OZ0wAH",
	"SJ6WFKn2CCWBvxSvi4uq77l27lga5rhUTlHixgNTOfXLxY9dHq4DL69aQX+do2/9Fm4TF36ztrG5ykZX",
	"mLm8fKfnYxKKpavBmO6Y4+xeysLcvSjMJ0lwZlHpxnCQJAmrEbn3Za/p+EtGeRrau2jE/YEC8iuLfjMa",
	"PgoWNbfjhQKoGCvu2bpYTIMXg+Cm2wtyyR8RtaL+beH+fPr8i8l0Arxem8U33yfTifv6PvVSKzbJuNIm",
	"kU7PR9RVE3igSEW3Y4LZ96bOSeK3yRT06UUapdk8/ab73uwZPlxdAMIZR1aP7MXeoC5/zv9PALSTGDqH",
	"NZwYS5JNeqCwFfsyBf0ylBbfpn4fqPbR4b41K/c6ybUKsdxOJ0ubpAyrk/zqatV92m33EAzkC3RLv0sa",
	"MIuYxFpbk0dTRUndRhRkcd0SFTIw8jqvJdPbc4N/r3Znv16lkkF9F9IzuZxfwQLvZF8troB7H7MmmVOt",
	"vHT9naAlSp/WMYAbmVOUM/KNrRDirsW/P5j/G3z+t2fF48+f/Nv8b4+fP87h2fMvHz+mXz6jT778/Ak8",
	"/dvzZ4/hyeKLL+dPi6fPns6fPX32xfMv88+fPZk/++LLf3tgKN2AbAH1lX9eTP53dlouRXb65iy7MMA2",
	"OKEV+wHM3qCGbYEJChGpOV6xsKasnLzwP/0vf1HOcrFuhve/Tlw9yMlK60q9ODm5ubmZxV1OlpgDJdOi",
	"zlcnfh7MZdl6r7w5C3FB1vcPd7SxOeGmhvx+5tvbb84vyOmbs1lDMJMXk8ezx7MnmE+xAk4rNnkx+Rx/",
	"wtOzwn0/wSzaJ8oV4zkJoaO30963qrKlesynZUgDav5aAS2RRZo/1qAly/0nCbTYuv+rG7pcgpxhxJj9",
	"6frpiX97nHxweWVud307ib3RTj60kvMUe3oGf6qkJ8MrIa7Qkca/hh6ojneYQW/YhrPCoN+2RLcnddYw",
	"QkSx91SZvHiX0tg6v+2qnpcsN8L1zBOw2Z2IvkLOpYZ/oH5+Yvknms0DNzQc7nH25fsPz/92m3TU7vts",
	"Nc6OO7921/Cj80Bo7jEXQYDxqhhPFVb0zxrktlkSugdN4gWMFHeSvybtwObtWrl6TQ6uGfnZOWHhV8u4",
	"gqu7C4StJFwzUavQaWAJZojUCsLr9T2WMkafZqS5p48fe/binuoR7Z64IxFvadss2nNpPCTZS+xymHpn",
	"mcVkiI/+sfhZ2dR8BpuMUxsuhHEEa3plDcLoKUykyxXgMOqCDxDJITDObYu/QT5iHca75TmzQCTyr/a5",
	"9QAH8OEDsTq/ZNZY4Zw2V1Da7ES8yV9yO508O5BQdqrVW1nKE+D/SEsDMhQ+qZeF4Mmng+CMWy93c+3Z",
	"6/l2Onn+KXFwxg3vpCXBlvZCxrj2xGHgV1zccN/SyFL1ek3lFiUlPWaPXYY69IDw7eyRsBc7Ncf73cRe",
	"C1hIrQLJ1sCxfvHtvuvt5IPLtbbnMoxNeycuRiPqMPKS3dXsZI41Y8c2BRU1Hl4KvpTVyQc8oYO/n7i3",
	"ZvojmgCslHjiH9ADLW0erPTHFgo/6I1ZyO7hTJtovJzqfFVXJx/wPyjwRSuyNShO9IafoMvkyYcWItzn",
	"HiLavzfd4xaYOt0DJxYLhfLQrs8nH+y/0UQtwmyEqraA9E3U6OsV5FeT9LXYKdAT9SJWHqbzEgrLnJ6N",
	"6MCFjjsddaDfogyjyOsfCFsQ6E7BlJ/hgHNrE1afYAX7bYNL//OW58kf+9vcyss78POJf46lROt2yw+t",
	"P9tHTq1qXYibaBY0ZFjbXR8y87FW3b9PbijT2UJIl9iVLjTIfmcNtDxxxcM6vzYVOXpfsMxI9GMcmZv8",
	"9YQ6VE8qoRJk+5beRErMU2xsJQRQ+iuBL5qh22mTzRlHCopvqEZ/YT/2zR29ewlrQG91YzjupyXD3EhS",
	"0CKnyki0pCkV0H4s3CaP3aeWNr6iBfEppTLSyB6n7pXcWtqfQxJJspuXcA2loRgiJNnHe/5gWeb5488/",
	"3fTnIK9ZDuQC1pWQVLJyS37mIejwaFb8LZK3pE4tHEje+pRLetOOY5TpTDrtGpY+5xIQvSEryovS5R4R",
	"NdbzNbSJriIiclY0V5gv6VoJiQDYzMFQWPctNSPnwbkNXcVq/4IqLNmgDRZz9dtJKDq+WeeHEVeJecYY",
	"frAEnjmOlM1FsXVFDCeS3uiNzSfSY3tWzhzgiT0pMPXVCToDjXy0i//c6EljvSMqRILG8d1781ZWIK+9",
	"rqRRo704OcHgyZVQ+gSf+m0VW/zxfcCcLxU/qSS7xtpTiDQhmXnBlpnTQzV1XydPZ48nt/8vAAD//1hz",
	"GYWbDgEA",
}

// GetSwagger returns the content of the embedded swagger specification file
// or error if failed to decode
func decodeSpec() ([]byte, error) {
	zipped, err := base64.StdEncoding.DecodeString(strings.Join(swaggerSpec, ""))
	if err != nil {
		return nil, fmt.Errorf("error base64 decoding spec: %w", err)
	}
	zr, err := gzip.NewReader(bytes.NewReader(zipped))
	if err != nil {
		return nil, fmt.Errorf("error decompressing spec: %w", err)
	}
	var buf bytes.Buffer
	_, err = buf.ReadFrom(zr)
	if err != nil {
		return nil, fmt.Errorf("error decompressing spec: %w", err)
	}

	return buf.Bytes(), nil
}

var rawSpec = decodeSpecCached()

// a naive cached of a decoded swagger spec
func decodeSpecCached() func() ([]byte, error) {
	data, err := decodeSpec()
	return func() ([]byte, error) {
		return data, err
	}
}

// Constructs a synthetic filesystem for resolving external references when loading openapi specifications.
func PathToRawSpec(pathToFile string) map[string]func() ([]byte, error) {
	res := make(map[string]func() ([]byte, error))
	if len(pathToFile) > 0 {
		res[pathToFile] = rawSpec
	}

	return res
}

// GetSwagger returns the Swagger specification corresponding to the generated code
// in this file. The external references of Swagger specification are resolved.
// The logic of resolving external references is tightly connected to "import-mapping" feature.
// Externally referenced files must be embedded in the corresponding golang packages.
// Urls can be supported but this task was out of the scope.
func GetSwagger() (swagger *openapi3.T, err error) {
	resolvePath := PathToRawSpec("")

	loader := openapi3.NewLoader()
	loader.IsExternalRefsAllowed = true
	loader.ReadFromURIFunc = func(loader *openapi3.Loader, url *url.URL) ([]byte, error) {
		pathToFile := url.String()
		pathToFile = path.Clean(pathToFile)
		getSpec, ok := resolvePath[pathToFile]
		if !ok {
			err1 := fmt.Errorf("path not found: %s", pathToFile)
			return nil, err1
		}
		return getSpec()
	}
	var specData []byte
	specData, err = rawSpec()
	if err != nil {
		return
	}
	swagger, err = loader.LoadFromData(specData)
	if err != nil {
		return
	}
	return
}
