// Package data provides primitives to interact with the openapi HTTP API.
//
// Code generated by github.com/oapi-codegen/oapi-codegen/v2 version v2.4.1 DO NOT EDIT.
package data

import (
	"bytes"
	"compress/gzip"
	"encoding/base64"
	"fmt"
	"net/http"
	"net/url"
	"path"
	"strings"

	. "github.com/algorand/go-algorand/daemon/algod/api/server/v2/generated/model"
	"github.com/algorand/go-algorand/data/basics"
	"github.com/getkin/kin-openapi/openapi3"
	"github.com/labstack/echo/v4"
	"github.com/oapi-codegen/runtime"
)

// ServerInterface represents all server handlers.
type ServerInterface interface {
	// Removes minimum sync round restriction from the ledger.
	// (DELETE /v2/ledger/sync)
	UnsetSyncRound(ctx echo.Context) error
	// Returns the minimum sync round the ledger is keeping in cache.
	// (GET /v2/ledger/sync)
	GetSyncRound(ctx echo.Context) error
	// Given a round, tells the ledger to keep that round in its cache.
	// (POST /v2/ledger/sync/{round})
	SetSyncRound(ctx echo.Context, round basics.Round) error
}

// ServerInterfaceWrapper converts echo contexts to parameters.
type ServerInterfaceWrapper struct {
	Handler ServerInterface
}

// UnsetSyncRound converts echo context to params.
func (w *ServerInterfaceWrapper) UnsetSyncRound(ctx echo.Context) error {
	var err error

	ctx.Set(Api_keyScopes, []string{})

	// Invoke the callback with all the unmarshaled arguments
	err = w.Handler.UnsetSyncRound(ctx)
	return err
}

// GetSyncRound converts echo context to params.
func (w *ServerInterfaceWrapper) GetSyncRound(ctx echo.Context) error {
	var err error

	ctx.Set(Api_keyScopes, []string{})

	// Invoke the callback with all the unmarshaled arguments
	err = w.Handler.GetSyncRound(ctx)
	return err
}

// SetSyncRound converts echo context to params.
func (w *ServerInterfaceWrapper) SetSyncRound(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "round" -------------
	var round basics.Round

	err = runtime.BindStyledParameterWithOptions("simple", "round", ctx.Param("round"), &round, runtime.BindStyledParameterOptions{ParamLocation: runtime.ParamLocationPath, Explode: false, Required: true})
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter round: %s", err))
	}

	ctx.Set(Api_keyScopes, []string{})

	// Invoke the callback with all the unmarshaled arguments
	err = w.Handler.SetSyncRound(ctx, round)
	return err
}

// This is a simple interface which specifies echo.Route addition functions which
// are present on both echo.Echo and echo.Group, since we want to allow using
// either of them for path registration
type EchoRouter interface {
	CONNECT(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	DELETE(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	GET(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	HEAD(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	OPTIONS(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	PATCH(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	POST(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	PUT(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	TRACE(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
}

// RegisterHandlers adds each server route to the EchoRouter.
func RegisterHandlers(router EchoRouter, si ServerInterface, m ...echo.MiddlewareFunc) {
	RegisterHandlersWithBaseURL(router, si, "", m...)
}

// Registers handlers, and prepends BaseURL to the paths, so that the paths
// can be served under a prefix.
func RegisterHandlersWithBaseURL(router EchoRouter, si ServerInterface, baseURL string, m ...echo.MiddlewareFunc) {

	wrapper := ServerInterfaceWrapper{
		Handler: si,
	}

	router.DELETE(baseURL+"/v2/ledger/sync", wrapper.UnsetSyncRound, m...)
	router.GET(baseURL+"/v2/ledger/sync", wrapper.GetSyncRound, m...)
	router.POST(baseURL+"/v2/ledger/sync/:round", wrapper.SetSyncRound, m...)

}

// Base64 encoded, gzipped, json marshaled Swagger object
var swaggerSpec = []string{

	"H4sIAAAAAAAC/+x9a5MbN5LgX0FwN0KWjmRLsuwZ62Jir2350WvZUqjbnttV62ywKkliugjUACg2aV3/",
	"9wskHoWqQpFFNiXbF/NJahYeiUQikcjn+1EmVqXgwLUaPX8/KqmkK9Ag8S+a5xIU/jcHlUlWaib46Pno",
	"nBOaZaLimpTVrGAZuYHtdDQeMfO1pHo5Go84XcHoeRhkPJLwz4pJyEfPtaxgPFLZElbUTqs1SNP37fnk",
	"vx9Pvnj3/rO/3o3GI70tzRhKS8YXo/FoM1mIiftxRhXL1PTcjX+37ysty4Jl1CxhwvL0ouomhOXANZsz",
	"kH0La463a30rxtmqWo2ePw5LYlzDAmTPmsryguew6VtU9JkqBbp3PebjgJX4MU66BjPozlU0GmRUZ8tS",
	"MK4TKyH4ldjPySVE3XctYi7kiup2+4j8kPaejJ88vvu3QIpPxp99miZGWiyEpDyfhHG/CuOSS9vu7oCG",
	"/msbAV8JPmeLSoIit0vQS5BEL4FIUKXgCoiY/QMyTZgi/3n56kciJPkBlKILeE2zGwI8EznkU3IxJ1xo",
	"UkqxZjnkY5LDnFaFVkQL7Bno458VyG2NXQdXjEnghhbejv6hBB+NRyu1KGl2M3rXRtPd3XhUsBVLrOoH",
	"ujEURXi1moEkYm4W5MGRoCvJ+wCyI8bw7CTJinH9+bM2Hda/ruimC96VrHhGNeQRgFpSrmhmWiCUOVNl",
	"QbeI2hXd/O3x2AGuCC0KUgLPGV8QveGqbylm7pMthMMmgeirJRDzhZR0ARGep+QnBUhJ+FWLG+CBOshs",
	"i59KCWsmKhU69awDp04sJKIDKSqeYlQEPzg09/Ao2/eUDOoNjni3+5tiC/epDfUlW1xtSyBzVpj7kvyj",
	"UjoQcKVw25dAVAmZ4b05McMY5Cu24FRXEp5f80fmLzIhl5rynMrc/LKyP/1QFZpdsoX5qbA/vRQLll2y",
	"Rc8OBFhT51Rht5X9x4yXPqp6k7xLXgpxU5XxgrL4LBhauXjRRxl2zH7SSDPI8yA34P64sa42Fy/6WOru",
	"HnoTNrIHyF7cldQ0vIGtBAMtzeb4z2aOpEXn8reRFS9Mb13OU6g15O/YNQpU51Z+Oq+FiDfus/maCa7B",
	"XoWRmHGGzPb5+1hykqIEqZkdlJblpBAZLSZKU40j/buE+ej56N/OakHvzHZXZ9HkL02vS+xkLmMJhvFN",
	"aFkeMMZrIzyiqNVz0A0fskd9LiS5XbJsSfSSKcK43USUuwynKWBNuZ6ODjrJdzF3eOuAqLfCXpJ2K1oM",
	"qHcviG04A4W074TeB6ohKSLGCWKcUJ6TRSFm4YdPzsuyRi5+Py9Li6oxYXMCDO9z2DCl1UPEDK0PWTzP",
	"xYsp+TYe+5YVBRG82JIZuHsHcjOm5duOjzsB3CAW11CP+EAR3Gkhp2bXPBqMXHYKYkSpcikKcwXuJSPT",
	"+DvXNqZA8/ugzn966ovR3k93KNE7pCI12V/qhxv5pEVUXZrCHoaaztt9j6MoM8oOWlIXNYJPTVf4C9Ow",
	"UnuJJIIoIjS3PVRKuvUS1AQloS4F/aTAEk9JF4wjtGMjkHOyojd2PwTi3RACqCBpWzKz4tUt08ta5Aqo",
	"n3beF39uQk7tOTEbTpmRjUnBlDbCEG6mIksoUOCkQbEQU9FRRDOAFnYsIsB8K2lpydx9sXIc44SG95eF",
	"9Z43+cBLNglzrLao8Y5QHc3M9zLcJCRW4dCE4ctCZDffUbU8weGf+bG6xwKnIUugOUiypGqZOFMt2q5H",
	"G0LfpiHSLJlFU03DEl+KhTrBEgtxCFcry69oUZipu9ystVoceNBBLgpiGhNYMW0ewIzjCViwNXDLeqbk",
	"a5otjTBBMloU41ovIcpJAWsoiJCEcQ5yTPSS6vrw48j+oYTnSIHhgxpItBqn05iSqyVImAuJD1UJZEXx",
	"clqZ51FZNPsE5qroClqyE16WotIGxujlcvHCrw7WwJEnhaER/LBGfPDHg0/N3O4TzsyFXRyVgIoWxrOi",
	"ymv8BX7RANq0rq9aXk8hZI6KHqrNb0ySTEg7hL383eTmP0Bl3dlS5yelhIkbQtI1SEULs7rWoh4G8j3V",
	"6dxzMnOqaXQyHRWmX3SWc2A/FApBJrQbr/A/tCDmsxFwDCXV1MNQTkGZJuwH3tkGVXYm08DwLS3IyurN",
	"SEmzm4Og/KqePM1mBp28r62qzm2hW0TYoasNy9WptgkH69ur5gmxOh/Pjjpiyk6mE801BAFXoiSWfbRA",
	"sJwCR7MIEZuTX2tfik0Kpi/FpnOliQ2cZCfMOIOZ/Zdi88JBJuR+zOPYQ5BuFsjpChTebg0ziJmlVlWf",
	"z4Q8TpromCZqBTyhZtRImBq3kIRNq3LizmZCPW4btAYiQb20WwhoD5/CWAMLl5p+ACwoM+opsNAc6NRY",
	"EKuSFXAC0l8mhbgZVfDpU3L53flnT57+8vSzzw1JllIsJF2R2VaDIp84PR9RelvAw+TDCaWL9OifP/MG",
	"kea4qXGUqGQGK1p2h7KGFvswts2IadfFWhPNuOoA4CCOCOZqs2gnb2y/u/HoBcyqxSVobR7Br6WYn5wb",
	"dmZIQYeNXpfSCBaqaZRy0tJZbpqcwUZLelZiS+C5Nb2ZdTBl3oCr2UmIqm/j83qWnDiM5rD3UBy6TfU0",
	"23ir5FZWp9B8gJRCJq/gUgotMlFMjJzHREJ38dq1IK6F366y/buFltxSRczcaACreN6jotAbPvz+skNf",
	"bXiNm503mF1vYnVu3iH70kR+/QopQU70hhOkzobmZC7FilCSY0eUNb4FbeUvtoJLTVflq/n8NDpSgQMl",
	"VDxsBcrMRGwLI/0oyATP1V5tjrcGtpDpphqCsza2vC1L90Pl0HS55RmqkU5xlvu1X87UR9SWZ5EqzMBY",
	"QL5o0OoHVXn1YcpC8UAlIDWYeomf0SLwAgpNvxHyqhZ3v5WiKk/OzttzDl0OdYtxNofc9PUaZcYXBTQk",
	"9YWBfZpa4++yoK+C0sGuAaFHYn3JFksdvS9fS/EB7tDkLClA8YNVLhWmT1fF9KPIDfPRlTqB6FkPVnNE",
	"Q7cxH6QzUWlCCRc54OZXKi2U9njtmIOaVVIC17Gci/oMpsgMDHVltDKrrUqiRep+qTtOaGZP6ARRo3rc",
	"HIKrhm1lp1vSNRBaSKD5lswAOBEzs+jaywEXSRUpjezsxDonEg/ltw1gSykyUAryidNn74XXt7P3j96B",
	"PFwNriLMQpQgcyo/zApu1nuBv4HtZE2Lyojn3/+sHv5RFqGFpsWeLcA2qY1oq++6S7kHTLuIuA1RTMpW",
	"W2hPghGxDdMpQEMfsu+Pvd7tb4PZIYIPhMA1SPSo+aBHy0/yAYgywP+BD9YHWUJVTowY2Kt+MJKr2W9O",
	"ufCy4Z4ZwgQFVXqy70oxjRp6E7PUiIunbhEcuEeefEmVRjGQMJ6j/tZehTiPlS3NFKMDncpwyt7XmJn0",
	"Z/8Q606bmeudq0qFV5mqylJIDXlqeWiz7p3rR9iEucQ8Gjs8/bQglYJ9I/chMBrf4dEpAvAPqoOF2tm8",
	"u4tDrwMjvmwPxXIDvhpHu2C89K0ixMdOtT0wMlXvgSU3plr0NhOiAIoqU6VFWRoOpScVD/36MHhpW5/r",
	"n+q2XZK0ZiArqeQCFJqYXHsH+a1FukJb15Iq4uDw/gmo8LIucl2YzbGeKMYzmOw6L/gINq3ig3PUca/K",
	"haQ5THIo6DbhbWE/E/v5QMLwYyOB1PoDoWEyQ2timkbqM+H9TY+bVeBUKiV4E/xCMnPOzTOqJjXX+/hJ",
	"c8BpU3zTEeuDMAuCkaQDPx4iy9JTYkS8+9dCG7JyRIercbfSPdfSg70w6wdBII47qRUB7dn/C5SbOwhg",
	"J51/C6pv4fXUp1p2j/of7/bGhdm6ylq3TfKK6OXLexhjHw/qsUW8plKzjJX4XP0etid/vbcnSPpKkBw0",
	"ZQXkJPpgX/Jl3J9YN+T2mMe95gepW7vgd/StieV4z6wm8DewRbXJaxvREGmrTqGOSIxqLlzKCQLqvebN",
	"iyduAhua6WJrBFu9hC25BQlEVTPrtdI1oWlRTuIB0jFT/TM6g3zSHL7TQ+ASh4qWl/I8tK+t3fBdtZ5c",
	"DXS4V1YpRJHQf7ZPfAcZSQgGuQuRUphdZ7QotkSHsBlPSQ0g3QWB3hhBnnmgGmjGFZD/EhXJKMcXbqUh",
	"CGlCouSDwrKZwYibYU7nqlpjCApYgX3N45dHj9oLf/TI7TlTZA631uWGY8M2Oh49QlXca6F043CdQNtt",
	"jttF4tJBW6W5ZN2rrc1T9ju5uZGH7OTr1uDBwGnOlFKOcM3y780AWidzM2TtMY0Mc/DDcQeZ75ouYZ11",
	"475fslVVUH0KQyWsaTERa5CS5bCXk7uJmeBfr2nxKnS7G49gA5mh0QwmGUYJDhwLrkwfG1hoxmGcmQNs",
	"A0eGAgQXttel7bTnpV37LbPVCnJGNRRbUkrIwEbJGSlVhaVOiQ2ZyJaUL/AFJEW1cK7Odhxk+JWymjBZ",
	"8c4Qh4piesMnaMJQyTA1NFv6aEsjhAE1L9u2/cM+1m5pAMVeRoMu7Wh72vagpMl0POp9+Bt8r+uHv8Vb",
	"M2T0WGNiQz6MkFZDM9B6hvg0slIXifE2msNniOHDWGnqoVNQdieOnMLrj31+4ZdVWRbbEwhJdiAioZSg",
	"8EqL1YDKfhVz8gPLpDgvFiLceWqrNKy6xhvb9Zee4/rmmBew4AXjMFkJDokn/Sv8+gN+HKx2tNdwz4go",
	"EB00YPvh00BCawHNyYeQ9H03CUmmffbblk71jZCnsrLbAQe/KQZYrve6dbgpj7Wv06JImKSt+qHDRdQ4",
	"OIUzSahSImMoKF7kauy8z60V27q1t9D/OoRGneAAt8dt2V6jMCyryIeiJJRkBUM1v+BKyyrT15yipi9a",
	"asJZ0CsH+tXCX/kmaT10Qk3shrrmFB1Fg/4v6Rg0h4Qe6hsArx1W1WIBSrceWHOAa+5aMU4qzjTOtTLH",
	"ZWLPSwkSPfamtuWKbsnc0IQW5DeQgswq3XxyrCqlidKsKJwh2ExDxPyaU00KoEqTHxi/2uBw3o/EH1kO",
	"+lbIm4CF6XDGtQAOiqlJ2tPxW/sVg0ocTpYuwARjLexn7/Fc54YYmbU3klb8n0/+4/nb88l/08lvjydf",
	"/I+zd++f3T181Pnx6d3f/vZ/mz99eve3h//x76nt87CngsEd5Bcv3Bv94gU+xKI4kTbsfwSDzIrxSZIo",
	"Y4eiFi2STzBfhiO4h029n17CNdcbbghvTQuWG150MvJpX1OdA22PWIvKGhvXUuN5BBz4HLoHqyIJTtXi",
	"rx9EnmtPsNPhJt7yVoyB44zq5AC6gVNwtedMudU++PbrK3LmCEE9QGJxQ0epBRIvGBfB2PDyMbsUB3Zd",
	"82v+Aub4HhT8+TXPqaZn9jSdVQrkl7SgPIPpQpDnPijyBdX0mneuod4EUlFQc5RBKsUp6Cq9luvrt7RY",
	"iOvrdx0/hK5s5aaKuag7Z101mZ9yYuQGUemJS+IykXBLZcoW4lN8uGho7L0TDiuTiMoqsXySGDf+dCiU",
	"ZanayR66KCrLwqAoIlXl8hWYbSVKixA4Zpi5i701NPCjcE4lkt76J2+lQJFfV7R8y7h+RybX1ePHn2II",
	"Xp3i4FfHAw3dbksY/PDtTUbRfu/iwq1cjk7lk5IuUjaT6+u3GmiJFIICxwpfmkVBsFsjPNBHAuBQ9QJC",
	"LPIBW2IhOziuF5d7aXv5tF7pReEn3NRm7PS9djCKij96A/dE1tNKLyeGIyRXpcwx8HvlEwzQhblyvAeB",
	"Ygt8AKilqMySgWRLyG5cZitYlXo7bnT3ji7uLvYMhynUGbngwDkz+MsoNwNWZU6dIEP5tp3iRtlgCBz0",
	"DdzA9krY7tOB2cGibHRRihXVd3SRdqO71pBvfJDdGO3Nd35XPkbUpSPBuEtPFs8DXfg+/UfbCgAnONYp",
	"omjk+ehDBJUJRFji70HBEQs1492L9FPLYzwDrtkaJlCwBZsVCTb9965dw8NqqFJCBmzto3rDgIqwOTGv",
	"o5m9jt2LSVK+AHOpm4tYKFqg0/40aehH6XAJVOoZUL1TX8vjNBMeOhTIbzFoGpUmY7ME2Jj9ZhqVIBxu",
	"zQMP3962jXMknh7lTmXXBPmRoPrudZD09JhHhEN4Ip+dv+/DnoT3gvNPi6kTQbbfVwaHCyluzW4aAIVP",
	"3YgJXqJ7qlJ0AUOvo4apaGBKjIYFCAfZJ/0k5R0xb4s1HRlj4CJs94nBS5I7gPli2AOaAVoujn5ua0J0",
	"VoVXvNh6pM4KFKiDg6glHSobdja+OAzYNBsDyWth1QPWxFp89JdU+aOfjyOOfqS0+PukktmVP+8i8r6j",
	"upsdz1/TbdY+tvqcGRDBTQ+fRc+nzvP58kbjg3LfjUcuxCG1d4KjFJ1DAQuLE9vY01mdn6neTQPHq/kc",
	"md4k5cgXKSMjycTNAeYh9ogQqzEng0dInYIIbLSs48DkRxEfdr44BEju8ktRPzbeXdHfkA4WtN74RkoW",
	"pbn1WY/VKvMsxaW3qEWeloszDkMYHxPDSde0MJzUBZ7Wg3RyteHbp5WZzfl2POx7Ew08aG6NKJ0ctEor",
	"zxyzvljw9stIvwoOWsNMbCY2Mjr5tJptZuZMJOMVME47dXht5rwHiszEBn2K8IazDu4HQ9cPmQcscgPZ",
	"MIVUjv36xEYL3mGA7BbkU9SskPScXi2QXZ8kexwwPeJ0H9l9EqXQOxFILQVmnQbcaXT26lma0lZXEqmv",
	"23HIDhvC1FKspu9wJneyB6Nd5Wkz1913dbrD/uRo/qx+lCR/XaXcffIy2s6lzbV4SFrGNjk0gNiB1ddt",
	"ITaJ1qbjUhOvEdZSLMkw+q6xq4s2BQWgJmDSkKsnNymz9PX1WwUoM1z6bpGeE3eP8u3DyBtOwoIpDbVx",
	"wTu5fHzbD6oTzWNLzPtXp0s5N+t7I0QQNKw5Fjs2lvnRV4Cu63MmlZ6gZSa5BNPoG4WatG9M07Qg3PS3",
	"Y8qaeg6WgxGiG9hOclZUaVJ2IH3/wkD0Y7i5VDXDi5Jx6200w1T4SQfdA2yTCI917N6JoJcWQS/px8DP",
	"sINlmhqYpKG85vR/kiPW4oW7OEuCllPE1N3QXpTu4LVRLH2X0UZCdOR2Md1l8+mcy9yPvdcby0f09wkR",
	"dqTkWqKMiOkAQrFYQO4zvbmgUJv1yuXTKwRf1LkEze870gdOic3ih0n4duTvc+7p0Oec3ignglUxktDH",
	"jxmEvI6uw9yDOMkCuM3cMjq83kiRRFzsGI8tIs3ox+XtHbf5pOvwVctduPbptXsYNhu3pwCau2eVAr++",
	"3Ye2u10OdeM+p+NGitjdBwwHRIpjWkUCTIdoejg3LUuWb1qGPzvq9AiSGCjudTPBt3CGbMkNtgc/Tcfi",
	"PbV6HpjbEds7Y8cZPvPPzCPT+jM7j1xzNmjmsg3klURrUsNbuJtPPzw0B679+58vtZB0Ac4iOLEg3WsI",
	"XM4haIhS0iuimXWQztl8DrElTB1jxWkA17F35AMIu4cEu+ay8LbcSZ9dIttDW/UK9iM0TU8JSunzubjq",
	"2iP9wyPSrYXLJtq4I4yKyYQC38N28jMtKvMSYlLVvqnOQNi81g+gifXqe9jiyHtdPg1ge3YFVXFvACk0",
	"ZV0Jn1SUJfyBalRfwDdwYwsP2Knz9C6daGtcKY3+o1HfUI16Es2lfLhjU7vIGEiH7NVl2uvEnC1obkub",
	"0PdtEcv3yz7REySeiqH3xjGXXMi0sde7DGjhCR8XO7obj+7n75G6J92Ie3bidbiak7uA3pjW/t9w+jpw",
	"Q2hZSrGmxcT5yfQJHVKsndCBzb1bzUd+X6VPxdXX5y9fO/DvxqOsAConQdXRuypsV/5pVmVLcOy+hmw6",
	"dqfbtaqwaPNDyuzYk+YWU6+3tGmdWje131R0UJ1nzTztKb6XbzoXL7vEHa5eUAZPr9oibR29ms5ddE1Z",
	"4Q2/HtqhWna73GHVlZJ8Ih7g3k5ikfffvcfqjRO4vn679pit7SnWUSqkxE/40qkjPZ07vCZ9Vmta38Mh",
	"cZ2vMJNp+t3FXZ5TZIzO4YyeXA78RsjGReWiGpMOax9OQDSPCYvHtFH+ylnhO2LhlFgR8tfFr4Y3PHoU",
	"H/xHj8bk18J9iADE32fud3xHPXqUNAwnVX2GZaEmj9MVPAxxEb0b8XHVEBxuh4kL5+tVkJFFPxkGCrWe",
	"Zx7dtw57t5I5fObulxwKMD9Nh6gq4k236I6BGXKCLvuiEoPz88qW81RE8HYMPkbJGtLCq8dV8LB29u4R",
	"4tUK7c4TVbAs7fTDZ8qwJG5dek1jgo0H25DNHBXr8SvnFYtGN83UUSbP1kKiWZMIV8lMwDV+Z8KxgIqz",
	"f1YQlfXFm7h1OfunEI7aEbDT+kU3cLtq8OiYgr/3NxF6rdouhdFOk+uLYAb0iEjVmTow3iGescP8d8Qq",
	"OIry1ycGti2d6/Beytr5zttdBNqZgT37dBbX/geSK4dpN/PFkJ1majKX4jdIyw5oJEyk7vDWbYYK+N+A",
	"p3xU24wseA7UBavr2fcRyHDdQh+p3FuX4BcdquYdc4Wn+cRhG32g0iDa7361gUqnF3eb0PdQjR1PmoE0",
	"PcwMD2zkFo61fLy7G+X2hNq8Fo3Is/Q5jwNFz+z49Tl3MHeCawt6O6OpQkfmvWhgira/4ZinBfGd/Qap",
	"kJrBzk6iWIbQltlkfyXI2nrUTZV85NvPTjv41Vc/8pDi4ufd2PqqFEokhqn4LeXoR4j9LAd0vRVYPwzT",
	"61ZITPCp0j6EOWRslVSGX1+/zbOu51fOFsyWFK8UEDrXLs+jG8gWlbdU5Kp5h1wkDjUXc/J4XJ9Zvxs5",
	"WzPFZgVgiye2xYwqvKCDT0ToYpYHXC8VNn86oPmy4rmEXC+VRawSJLzPUfQMnrAz0LcAnDzGdk++IJ+g",
	"w7Bia3iYvmCcsDZ6/uSL8a7K2YhxLBK/i8nnyOV9IEOastGr2o5h2KobNR2ZMJcAv0H/fbLjfNmuQ04X",
	"tnRX0P7TtaKcGoSkYFrtgcn2xf1FV44WXri1zoDSUmwJ0+n5QVPDsXqiyQ1DtGCQTKxWTK+cp6gSK0Nh",
	"dRlyO6kfDuvr+TJoHi7/EV2wy8Qb/3d4btFVT4QjetX/iPb2GK1jQm3G1oLV8Re+Qi258JmpsS5cKAdn",
	"cWPmMktHeRXDMeaklIxr1BpVej75q3m+S5oZhjjtA3cy+/xZor5aswQRPwzwj453CQrkOo162UP2Xspx",
	"fcknXPDJynCU/GGd0iE6lb2+4mn/3j63456h7y1dm3EnvQRYNQiQRtz8XqTIdwx4T+IM6zmIQg9e2Uen",
	"1UqmCYZWZod+evPSSSIrIVOVLmoG4KQSCVoyWGN8aXqTzJj33AtZDNqF+0D/+3q3ebE0Et386U4+FiKr",
	"cuKdFtIqGUn/5x/q/Pho3LZxuy3tpZAJPa3TOH5kt9TD9IVtG7p1B8RvPZgbjDYcpYuVnnAPG88R+vwe",
	"/l5tkOyeN1SlT34l0rzjUdZ/9AiBfvRo7ETlX582P1v2/ujRcJfZtL7Q/JpAzXF3TTt7pemb2uovRUJ7",
	"56t4Br8xl6okoWFN3mXmSp25McakWSrx48sdp4lXPNgNOX2APGrwcxs3vzN/xc2sI2D6+UOzemySfPLw",
	"PYqhoORLsRlKRK1ry9PTHwBFPSgZqBXElXSq4yY9Jfa6+URka0adQSHMSzUugDXYa+VPtAsGNeMde1Gx",
	"Iv+5tkK3biZJebZMOpXPTMdf7DMgahBpMLIl5RyKZG/7Wv7Fv6oT7/5/iJ5hV4ynP7ULMVvYW5DWYDWB",
	"8FP68Q2umC7MBDGKmgm5QoqTYiFygvPUlUtq1titaJ6qJJuI8cdhV5V2XsmYPMEVFJmzAt1o0/ZwbDmR",
	"VPdwVSz770tcmXGwCr+yagk7OkhC2QqvbUVXZQF4CNcg6QK7Cg6t7pixDUeOypIQVZpP2BKTvwiiK8mJ",
	"mM+jZQDXTEKxHZOSKmUHeWyWBRuce/T8yePHj4cZGRFfA9Zu8eoX/qpe3JMzbGK/uMpftmDCQeAfA/1d",
	"TXWHbH6XuFz51X9WoHSKxeIHG5CNFmJzr9vSq6FM8JR8i/nJDKE3SgSgUtRnWG7mBK3KQtB8jEmhr74+",
	"f0nsrLaPBEQdln5doAaweUSSRp7hOVJ9/rWe3FXDx9mdOsesWulJKMqayqRoWtS1ZFnL+wl1gzF2puSF",
	"VcsGxx47CcHU4nIFeVQD1qoBkDjMf7Sm2RL1ndPRTpVyTzWg4SWMPQeszUVR3GsomIUc3CzDVTG2RYzH",
	"ROglyFumAPNOwBqaCRtDtlOnkPcJHJurlRXnlnCmB0ivoTzWobvggbOir/evSELW2od72/7qTB5Y5PzQ",
	"Ys+X2Csdt9OqHN3ye7AlMza+6MaU/OCMHRnlgrMMi02kRHBMxTjMrDqgLkfa3qlG7iwnjmGyXnUIUHdY",
	"7K1g7VmmQ1zXqSH6avbbEo79U8PGFQFcgFaOB0I+9uXjnYGOcQWuAJqhr5ijCplw/UqGxQQXkhO6pI9H",
	"mE2tR9f6jfn2o9PNY86YG8ZR5+aQ6l6C1sBWKIZ2dk6YJgsByq22GRem3po+06sNRxDeTV+KBcsu2QLH",
	"sK6IBinWC7g71Ln3CXY+uKbtV6atq10Qfm641NlJ/brfJVmICvufqrnei/6U75d3pImQG8aPR9tBjDtd",
	"/fFeNmQIa/T8gxLv8w7ZhPL1zVG+Nk9WS2/YgtjI3WTaYMYTYLxk3Bt803mwsuRdghuDp7mnn8ok1fbR",
	"MYjjXQEtesJhMKjeegzcd6h2JQaDElyjn6N/G+vK+z1sJTSoXxeUb4k/FIa6I6HkK1oEZ/hEHX2Uzpww",
	"Zp2FW5X1U2zFsPWJD81toGtvIGjojtVQDr2n+rKNzqp8AXpC8zyVd+5L/Erwqw8ohA1kVSgCFuJMm+na",
	"u9TmJsoEV9Vqx1y+wT2ny5miSsFqViRcb1+Ej5CHHcZEVLMt/puqgNW/M87p/eDob+/hnh9Wo6AbzZ6S",
	"ng1NTxRbTIZjAu+U+6Ojnvo4Qq/7n5TSfeD3HyKuu8Xl4j1K8bevzcURp+nu+PjbqyVk0UZ/eoHffT6w",
	"kMm1yZXwKuvUeUOPDNy8xJa1gPcNk4CvadGTcSG22tj71Voy+vIuZL1pRah22es0JTVPGKLC6M//ZT2w",
	"W5ahrnmzz8faulh/SOOJw8dOpPdbGr9v2BWt11vNUHrticeZ/GoiONTm50oxdPWltChENpgzuGHOTaf+",
	"VL1itXKZ7xNeeeuVyOOzEHtzAaQZm3VYToRW4MM2+Q2fVskv8jY9WkM/EohmaNYyRKNbwtgGZnrwPDB2",
	"6niiSGXrMEu+YQUWh/rPy1c/jvo3MtqB7pa61NlJFXbfxoRItTZ5LEQDHzt4gOBFWv+telTqmBsqfRpc",
	"deLkh2+sgnAISDZP0iGtXw4dvEMAC2GrQqXqZnSz04zq7fDIj6ih3l7LUWLqSFFFu9pS4u1jlZ51ExIK",
	"kQ4qTNqQkYYUd0rVEXIvBa+BtReNy0dniyt16jJ1GOiLIcJhBx9349FFfpD4lKpFNbKjpBjsS7ZY6i8L",
	"kd18BzQHaeuJpJ6TtprICswzVC1Zie+fUihW1wMuzGAukfcSh5sODc25WoLLCuOTBHTG8g7Ua8g01oeu",
	"3UAlwHA/hzK9RAOBNyhik9/BFUQC5FDq5U5hyTp3l3pZlw0FF3nGFJmBM12sgY8Jm8K0HayW10mhSAF0",
	"7pWwUgg9oK5uCFtCNMZAp+irU6N5txjYyfkWpTS0pXSnw4uwnIeYABtoeUtVnTmqlUZhcLj2fA4ZJrzf",
	"mX7v70vgUT62sVfdISzzKBsfC+GCWLLhpBrtGtZdifB2ghrVpPqQkPYlxLiB7QNFGjSUrAgcImyPyQCP",
	"yLF2XF9UoM+04RwjmQr0hAjyfvAuAX9dY+mYIgBRdsojwfA0bq6nOmPlcdB4ieYIMEzX6b2K9tfp8FAw",
	"7cvu162u3v9SfoHF7JVzKqUh3XysTyIX3XLMty5dPSZaDNZCn7gelP/NJ2i1sxTsxlWoQYRZ2+wtlblv",
	"cZI0efbeZGmg52FmVgdGdb18DvXLsRGKWSGMADTpCwxtRioFF94Hyvpa10nLEOo5SAl5sAkWQsFECx9m",
	"dUDyTxc+uQN71sv8KLy1PPoPCBm2K+qtofCmLiSB5SAp1kygzvk8xgqRsKIGehkVd0irQfft0Ff2u88p",
	"4sv77Vav9uE9nIv9FbJ96B1THczHp2tOnHBwMPdqJCI5QjPLOAc58UbcdmkH3kyTiXmV8yqzokp8NoP2",
	"enDasR3cLKnUzLqrbD2hoqwcN7A9s2ofX3Xc73gMtJUhLehRQukWUZxUV61ScC9OAt7vm76zFKKY9FgG",
	"L7r1KNqH4YZlN4CJWUNkipGCHzSPjZmEfIIGqeAzcrvc+moLZQkc8odTQs65jQ707iPNCqStyfkDvWv+",
	"Dc6aV7bCjNNAT695OswKK73Ie3I/P8wOntfHmxQYfnnP+e0gR8yuN7zPR+4WS8I06wRPh6o3uv4dLREq",
	"Ij8LRUqAurSG4K+QJSTeUQSzs0RphNA/gBJnQCaqECkv/GMyyJih0piKJ0OANPABz9UaCjd4EgHOyW5P",
	"Vlb32ecdFXMiofbNODYBq8tpapm46lONtGcOszQ541xIiGdEP1ObqDlEtmGeY/zPjGlJ5faYNKlNVKXU",
	"UL1Y3ustGRwl64XUzpJdHBaFuJ0gW5uE6kopdYBpp5rXtq9TWvczR30GkdslVU5E3JIlzUkmpIQs7pEO",
	"8bZQrYSESSHQCzPl2DHX5pGwwrhOTgqxIKLMRA62EFqagvrmqjinKHtB5MqWRIGlHUwZYPtEdDxwSnP7",
	"WvPsBOW1vYU2/OZfmT42fUWd/s4uemJdBHriC0C5dHcOQ7ZxF14kHJuRqa2UTYvIc7ZBugGZOvJzomUF",
	"Y+JatKvwu4NPJZAVU8qCEmjplhUFZo9gm8ihIfgDpVHbIztfoB/0mqHDWzOTiBWpS3M7hvQrMQ+4jDOy",
	"Eb2Uoloso/oAAU7/dJeVe9jHo/ykKvRJxBBRM8UzshJKu2exHalecu0C+kkmuJaiKJqKPCvnL5zR9we6",
	"Oc8y/VKImxnNbh7iI5wLHVaaj31Khbbvbj2TbOVgHPZS0Bs+QfJQ+9Os23bo1eroeTDvbHG/juFhnyY/",
	"AvPdfua6365x3l1Ye11NPpt+C51zQrVYsSx93P5c3q+9Pqsp7pXMtGirENssNNgM+UB8jwV3JuSeXTQD",
	"p8kyqufE8Qjn1oGcyPwXxfj2uGQOjgf13KFdvuMErEnWKwa2AEBIbSIEXUlbujgW0gLDEQubOAWdUtqA",
	"Drxw0PfvfrCZEU4OlIZ7AdXxRg4AfmI1GGObEdN6Ns/Exn9/WKfMPAr4u91U3mAefU6VlzVpSetW6RNZ",
	"9XCEdAGCnR6IV5gEYzbUDzGUoh94+UcA9HsmNmAY5J94KBhzygrIJ6kqxRdBBzaOnusuxjIa3ddztJw8",
	"o5WvBGzGriS4xEpW+pdNc2JJDSmJ0LyrEec5bMDGaP0GUtg6vuPInAWFLfPb0iiIclLAGhoOmy7bU4VS",
	"KFuD76tCZ5IDlGjxbSvaUp6IcZXAlvbFrX0S+bINwW5SHWMRa3eK7NG1JDVDGz6xx0QNPUoGojXLK9rA",
	"nzpU5GjqEs1RTqCq83yY+Cfm0Gl+siO88QOc+/4pUcZj4t0wPnQwC0qjbhcD2uuZXKm+U8/TjslxKrNg",
	"KMLZ8mDXtiRe8w1V0lver9Xsknz9Ehu4T0zwCLFfbyBDqcY9hSB3j6Eey4nLgYTUzgFy+2AwXRLa/CVw",
	"wkVU8/iWqvCKqbO6+h/sxNiIcffQPsJGX/sP339nCQ5GVCvZYrpEaSDr++n4f5eTuPMg9o6XohEFLpR3",
	"h2rMU7d7dmADURU54WY/jeyPNYLdLea4+JjMKj9QUYhbW8Q4fqK+AG/PtdTnTUxOLGfhWvZ+0mOXcLit",
	"BWFRhMiKbomQ+I95kP6zogWbb5HPWPB9N6KW1JCQMyBbLwrnd20m3i1ejT1gXhEj/FR23WzomNFwWzNK",
	"BLS5yH3ZNkFW9AbibUAHEcs/M20Yp6pmqNQwV3ZrO7tYcIv36ZlWNI+VAJhodtvgDj7huen9P+uw1Xgq",
	"n/+xLGjmS1a74nNNPoNV7T1x6SWsdoc5d/maJ4FQKb8mWunTZORHaFMPZF2pmJ++4lgNsDslwDt1we61",
	"jIFK4VaNox0B4oOWcupdOE0MZ2dJcanffYuLKx9/nN1JZojuW8YQ8P9Au9Jwr+hEtqUrqMfrscXSP8Iu",
	"NBLxJGC1avCZ2EwkzNU+RxqrB5+JTQ2wCrpbxjMJVFm/o4tX7tlaJ0Bm3DyjrdduMKuGUXKYM16zWsbL",
	"SideQZgHmW8jhMXWBERrj22uT8YwouiaFq/WICXL+zbOnB5bGjgu0uMtKK5vQgESbuTuAEzVL0CMp671",
	"83Ezc/3bAoPWd1ZpynMq87g54yQDaaQGcku36nhTVbA67DNW0UgWamYLicxWSNoWkGLrrM33NCQFAOkJ",
	"LUoDLEHopJ2wAlnFkBY9hp8uDH8KS9CKbiaFWGDUb8+BcHmu0XRoH5CCoxLdSnfD1u3nUew32D0NliJx",
	"jEgLnHXIFLvP/SvcSnyE/sSZ3nnyrYazHYZtPZ3twfRI5Ys6PMMSS/c8piLnXWKmOHrei6o+TYmnPYg2",
	"MekS3dGq9+wi+le4tAuxCn14scqmC0cqPt/qFSaob1A7AjBA1XEFNHMeYl1FXEdRYZEydtkNDtTTWe2+",
	"v5d6wENFinJnvTltcNAx4xxS4XN3PoNJKcpJNsS31VYryp2RwUHahLGHPiITQs+6g9+NCvW7GjnRGoW8",
	"Di1y2ltIbJ+trMx2qQz6lEw9HL1pwBBz5GV4hK1qDWOtgipm7B/n3tjdVKIFJkEokZBVEpXMt3S7v/Bj",
	"T/b5y+/OP3vy9Jenn31OTAOSswWouqZBq3Bi7ZrIeFtr9HGdETvL0+lN8NlCLOK89dKHvYVNcWfNcltV",
	"JyPulI08RDuduABSwbndEnlH7RWOU4dF/LG2K7XIk+9YCgUffs+kKIp0TZkgVyXML6ndigww5gVSglRM",
	"acMIm/ZTpmunbLVE5SJmDV/b3FCCZ+C1z44KmO7x5UotpM+nF/kZ5mJwNicCm7JwvMraiXaty73TrH4P",
	"hUZ0t5kBKUXpRHs2JymIMGZLVhD06k5tivr0yE03MFvrsJsiROf8nia9c+5ewmJOdnP7Ziluneb0ZhMT",
	"4oU/lEeQZp91oz/PyDGcpDYM/GH4RyJxysm4Rljuh+AVyffBjqjw847XREgaMgi0boKMBHkgAD3x0I2g",
	"1SjILspNLq2NAa0R3vzcFj9+qM3SeyNTEBLfYQ94cSxz3S4EUzhwfufE3j8EpERLeddHCY3l7wuP9qw3",
	"XCTRFjmlidagLFsSXbEwCohXX4U4855XSSccXQqhiXmZFkUijN3qcfBMxYRjngRyTYuPzzW+YVLpc8QH",
	"5G/6A7fisOUYyRaV6uQJOV/SQWBFIcofBSr+GmPr/w5mZ5O3o5vFGf47dyCqhGhhvb3nwQIOnNzimNax",
	"68nnZObK/ZQSMqbaDgW3XqQJ8bYg2dz518JGt2N/710m6Geh73Ec5t4fiPwYGdmC54CDuT7qvzNz6uEA",
	"ydOSItUOoSTwl+J1cVH1PdfOPUvDHJfKKUrceGAqp265+KHLw3Xg5VUp6K5z8K3fwG3iwq/XNjRX2eAK",
	"M9fXb/VsSEKxdDUY0x1znJ2kLMz9i8J8lARnFpVuDAdJkrBqkXtf9pqWv2SUp6G5i0bc7ykgv7ToN6Ph",
	"o2BecTteKICKseKerYv5OHgxCG66PSfX/BFRS+rfFu7Pp599PhqPgFcrs/j6+2g8cl/fpV5q+SYZV1on",
	"0un4iLpqAg8UKel2SDD73tQ5SfzWmYI+vkijNJul33TfmT3Dh6sLQLjgyOqRvdgb1OXP+VcCoJ3E0Dqs",
	"4cRYkqzTA4Wt2Jcp6Oe+tPg29XtPtY8W961YsddJrlGI5W48WtgkZVid5BdXq+7jbruHoCdfoFv6fdKA",
	"WcQk1tqYPJoqSuo2oCCL65aokIGR11klmd5eGvx7tTv75SaVDOrbkJ7J5fwKFngn+2pxA9z7mNXJnCrl",
	"petvBS1Q+rSOAdzInKKYkq9thRB3Lf7twewv8Olfn+WPP33yl9lfH3/2OINnn33x+DH94hl98sWnT+Dp",
	"Xz979hiezD//YvY0f/rs6ezZ02eff/ZF9umzJ7Nnn3/xlweG0g3IFlBf+ef56H9PzouFmJy/vphcGWBr",
	"nNCSfQ9mb1DDNscEhYjUDK9YWFFWjJ77n/6XvyinmVjVw/tfR64e5Gipdamen53d3t5O4y5nC8yBMtGi",
	"ypZnfh7MZdl4r7y+CHFB1vcPd7S2OeGmhvx+5tubry+vyPnri2lNMKPno8fTx9MnmE+xBE5LNno++hR/",
	"wtOzxH0/wyzaZ8oV4zkLoaN34863srSlesynRUgDav5aAi2QRZo/VqAly/wnCTTfuv+rW7pYgJxixJj9",
	"af30zL89zt67vDJ3u76dxd5oZ+8byXnyPT29P9W+Jmfvfbn/3QM2Srk7P9eow0BAdzU7m2HdvaFNIV5d",
	"/1JQ2lBn7/GN3vv7mbuv0x9RjWJP2pkXQnpa2lwi6Y8NFL7XG7OQ3cOZNtF4GdXZsirP3uN/8NBEK7J5",
	"vM/0hp+h28nZ+wYi3OcOIpq/193jFph+1gMn5nOF3jG7Pp+9t/9GE8GmBMnM2xNTnLlfbVbLMyxzu+3+",
	"vOXOSaKAVCqwn7gCq2Pz9Ym2PKsjcQMfuch948stz/wj2fthI3d4+vixnf4Z/mfk6ju2smKdufM8svf5",
	"XlVvI3M28t6Wlj/Aa+ONjUCMMDz5eDBccOt7bZixvTTuxqPPPiYWLriRb2hBsKWd/tOPuAkg1ywDcgWr",
	"UkgqWbElP/HgPh6V6U9R4A0Xt9xDbiSOarWicotS80qsQRFXrikiTiLByE72rYLCcE3DeOVRw0fejspq",
	"VrBsNLZ50t+htKZTgotXPXdn8mr3evDmqfh275kYvgtNeXhHGq5BcB6fus/OnEgp3Nl6TxZtnw4LxYPU",
	"3o3+xSP+xSNOyCN0JXnv6Y2uNsx0CaWLuM9otoRdrKJ7kUZ3/6gUqRQ4lzv4iKuL1sdGLptspPZdHj1/",
	"2w1Nd9SMWoGpf8sYQb1+asjAkPy5RkeNaD8HV8FrW1H6v737QwgFX1HuT3qDFqwHBZUFAxnog/JuEbt/",
	"8Yf/b/iDLc5J7b6OiYaiUDFX0AK5glXAuVzJ3DoBDOQQjazXtQTe+PnMKztSD9dmy/eNP5uPMbWsdC5u",
	"o1nQTGgt492niflYqfbfZ7eU6clcSJc2mc41yG5nDbQ4c6X5Wr/W9W46X7CIT/RjHPee/PWMujdK6hty",
	"wb6OnUd06qt7J/Y08gEX/nOtqotVX8iBg9Lr7TvD5RTItWfOtSbn+dkZxu8thdJno7vx+5aWJ/74LhCW",
	"r1Y+KiVbY/mjd4bHCskWjNNi4lQhdenR0dPp49Hd/wsAAP//auagyh4NAQA=",
}

// GetSwagger returns the content of the embedded swagger specification file
// or error if failed to decode
func decodeSpec() ([]byte, error) {
	zipped, err := base64.StdEncoding.DecodeString(strings.Join(swaggerSpec, ""))
	if err != nil {
		return nil, fmt.Errorf("error base64 decoding spec: %w", err)
	}
	zr, err := gzip.NewReader(bytes.NewReader(zipped))
	if err != nil {
		return nil, fmt.Errorf("error decompressing spec: %w", err)
	}
	var buf bytes.Buffer
	_, err = buf.ReadFrom(zr)
	if err != nil {
		return nil, fmt.Errorf("error decompressing spec: %w", err)
	}

	return buf.Bytes(), nil
}

var rawSpec = decodeSpecCached()

// a naive cached of a decoded swagger spec
func decodeSpecCached() func() ([]byte, error) {
	data, err := decodeSpec()
	return func() ([]byte, error) {
		return data, err
	}
}

// Constructs a synthetic filesystem for resolving external references when loading openapi specifications.
func PathToRawSpec(pathToFile string) map[string]func() ([]byte, error) {
	res := make(map[string]func() ([]byte, error))
	if len(pathToFile) > 0 {
		res[pathToFile] = rawSpec
	}

	return res
}

// GetSwagger returns the Swagger specification corresponding to the generated code
// in this file. The external references of Swagger specification are resolved.
// The logic of resolving external references is tightly connected to "import-mapping" feature.
// Externally referenced files must be embedded in the corresponding golang packages.
// Urls can be supported but this task was out of the scope.
func GetSwagger() (swagger *openapi3.T, err error) {
	resolvePath := PathToRawSpec("")

	loader := openapi3.NewLoader()
	loader.IsExternalRefsAllowed = true
	loader.ReadFromURIFunc = func(loader *openapi3.Loader, url *url.URL) ([]byte, error) {
		pathToFile := url.String()
		pathToFile = path.Clean(pathToFile)
		getSpec, ok := resolvePath[pathToFile]
		if !ok {
			err1 := fmt.Errorf("path not found: %s", pathToFile)
			return nil, err1
		}
		return getSpec()
	}
	var specData []byte
	specData, err = rawSpec()
	if err != nil {
		return
	}
	swagger, err = loader.LoadFromData(specData)
	if err != nil {
		return
	}
	return
}
