package trackerdb

// Code generated by github.com/algorand/msgp DO NOT EDIT.

import (
	"github.com/algorand/msgp/msgp"

	"github.com/algorand/go-algorand/config"
	"github.com/algorand/go-algorand/crypto"
	"github.com/algorand/go-algorand/crypto/merklesignature"
	"github.com/algorand/go-algorand/data/basics"
	"github.com/algorand/go-algorand/data/bookkeeping"
	"github.com/algorand/go-algorand/data/transactions"
	"github.com/algorand/go-algorand/ledger/ledgercore"
)

// The following msgp objects are implemented in this file:
// BaseAccountData
//        |-----> (*) MarshalMsg
//        |-----> (*) CanMarshalMsg
//        |-----> (*) UnmarshalMsg
//        |-----> (*) UnmarshalMsgWithState
//        |-----> (*) CanUnmarshalMsg
//        |-----> (*) Msgsize
//        |-----> (*) MsgIsZero
//        |-----> BaseAccountDataMaxSize()
//
// BaseOnlineAccountData
//           |-----> (*) MarshalMsg
//           |-----> (*) CanMarshalMsg
//           |-----> (*) UnmarshalMsg
//           |-----> (*) UnmarshalMsgWithState
//           |-----> (*) CanUnmarshalMsg
//           |-----> (*) Msgsize
//           |-----> (*) MsgIsZero
//           |-----> BaseOnlineAccountDataMaxSize()
//
// BaseVotingData
//        |-----> (*) MarshalMsg
//        |-----> (*) CanMarshalMsg
//        |-----> (*) UnmarshalMsg
//        |-----> (*) UnmarshalMsgWithState
//        |-----> (*) CanUnmarshalMsg
//        |-----> (*) Msgsize
//        |-----> (*) MsgIsZero
//        |-----> BaseVotingDataMaxSize()
//
// CatchpointFirstStageInfo
//             |-----> (*) MarshalMsg
//             |-----> (*) CanMarshalMsg
//             |-----> (*) UnmarshalMsg
//             |-----> (*) UnmarshalMsgWithState
//             |-----> (*) CanUnmarshalMsg
//             |-----> (*) Msgsize
//             |-----> (*) MsgIsZero
//             |-----> CatchpointFirstStageInfoMaxSize()
//
// ResourceFlags
//       |-----> MarshalMsg
//       |-----> CanMarshalMsg
//       |-----> (*) UnmarshalMsg
//       |-----> (*) UnmarshalMsgWithState
//       |-----> (*) CanUnmarshalMsg
//       |-----> Msgsize
//       |-----> MsgIsZero
//       |-----> ResourceFlagsMaxSize()
//
// ResourcesData
//       |-----> (*) MarshalMsg
//       |-----> (*) CanMarshalMsg
//       |-----> (*) UnmarshalMsg
//       |-----> (*) UnmarshalMsgWithState
//       |-----> (*) CanUnmarshalMsg
//       |-----> (*) Msgsize
//       |-----> (*) MsgIsZero
//       |-----> ResourcesDataMaxSize()
//
// TxTailRound
//      |-----> (*) MarshalMsg
//      |-----> (*) CanMarshalMsg
//      |-----> (*) UnmarshalMsg
//      |-----> (*) UnmarshalMsgWithState
//      |-----> (*) CanUnmarshalMsg
//      |-----> (*) Msgsize
//      |-----> (*) MsgIsZero
//      |-----> TxTailRoundMaxSize()
//
// TxTailRoundLease
//         |-----> (*) MarshalMsg
//         |-----> (*) CanMarshalMsg
//         |-----> (*) UnmarshalMsg
//         |-----> (*) UnmarshalMsgWithState
//         |-----> (*) CanUnmarshalMsg
//         |-----> (*) Msgsize
//         |-----> (*) MsgIsZero
//         |-----> TxTailRoundLeaseMaxSize()
//

// MarshalMsg implements msgp.Marshaler
func (z *BaseAccountData) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0001Len := uint32(24)
	var zb0001Mask uint32 /* 26 bits */
	if (*z).BaseVotingData.VoteID.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x1
	}
	if (*z).BaseVotingData.SelectionID.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x2
	}
	if (*z).BaseVotingData.VoteFirstValid.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x4
	}
	if (*z).BaseVotingData.VoteLastValid.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x8
	}
	if (*z).BaseVotingData.VoteKeyDilution == 0 {
		zb0001Len--
		zb0001Mask |= 0x10
	}
	if (*z).BaseVotingData.StateProofID.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x20
	}
	if (*z).Status.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x100
	}
	if (*z).MicroAlgos.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x200
	}
	if (*z).RewardsBase == 0 {
		zb0001Len--
		zb0001Mask |= 0x400
	}
	if (*z).RewardedMicroAlgos.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x800
	}
	if (*z).AuthAddr.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x1000
	}
	if (*z).TotalAppSchemaNumUint == 0 {
		zb0001Len--
		zb0001Mask |= 0x2000
	}
	if (*z).TotalAppSchemaNumByteSlice == 0 {
		zb0001Len--
		zb0001Mask |= 0x4000
	}
	if (*z).TotalExtraAppPages == 0 {
		zb0001Len--
		zb0001Mask |= 0x8000
	}
	if (*z).TotalAssetParams == 0 {
		zb0001Len--
		zb0001Mask |= 0x10000
	}
	if (*z).TotalAssets == 0 {
		zb0001Len--
		zb0001Mask |= 0x20000
	}
	if (*z).TotalAppParams == 0 {
		zb0001Len--
		zb0001Mask |= 0x40000
	}
	if (*z).TotalAppLocalStates == 0 {
		zb0001Len--
		zb0001Mask |= 0x80000
	}
	if (*z).TotalBoxes == 0 {
		zb0001Len--
		zb0001Mask |= 0x100000
	}
	if (*z).TotalBoxBytes == 0 {
		zb0001Len--
		zb0001Mask |= 0x200000
	}
	if (*z).IncentiveEligible == false {
		zb0001Len--
		zb0001Mask |= 0x400000
	}
	if (*z).LastProposed.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x800000
	}
	if (*z).LastHeartbeat.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x1000000
	}
	if (*z).UpdateRound == 0 {
		zb0001Len--
		zb0001Mask |= 0x2000000
	}
	// variable map header, size zb0001Len
	o = msgp.AppendMapHeader(o, zb0001Len)
	if zb0001Len != 0 {
		if (zb0001Mask & 0x1) == 0 { // if not empty
			// string "A"
			o = append(o, 0xa1, 0x41)
			o = (*z).BaseVotingData.VoteID.MarshalMsg(o)
		}
		if (zb0001Mask & 0x2) == 0 { // if not empty
			// string "B"
			o = append(o, 0xa1, 0x42)
			o = (*z).BaseVotingData.SelectionID.MarshalMsg(o)
		}
		if (zb0001Mask & 0x4) == 0 { // if not empty
			// string "C"
			o = append(o, 0xa1, 0x43)
			o = (*z).BaseVotingData.VoteFirstValid.MarshalMsg(o)
		}
		if (zb0001Mask & 0x8) == 0 { // if not empty
			// string "D"
			o = append(o, 0xa1, 0x44)
			o = (*z).BaseVotingData.VoteLastValid.MarshalMsg(o)
		}
		if (zb0001Mask & 0x10) == 0 { // if not empty
			// string "E"
			o = append(o, 0xa1, 0x45)
			o = msgp.AppendUint64(o, (*z).BaseVotingData.VoteKeyDilution)
		}
		if (zb0001Mask & 0x20) == 0 { // if not empty
			// string "F"
			o = append(o, 0xa1, 0x46)
			o = (*z).BaseVotingData.StateProofID.MarshalMsg(o)
		}
		if (zb0001Mask & 0x100) == 0 { // if not empty
			// string "a"
			o = append(o, 0xa1, 0x61)
			o = (*z).Status.MarshalMsg(o)
		}
		if (zb0001Mask & 0x200) == 0 { // if not empty
			// string "b"
			o = append(o, 0xa1, 0x62)
			o = (*z).MicroAlgos.MarshalMsg(o)
		}
		if (zb0001Mask & 0x400) == 0 { // if not empty
			// string "c"
			o = append(o, 0xa1, 0x63)
			o = msgp.AppendUint64(o, (*z).RewardsBase)
		}
		if (zb0001Mask & 0x800) == 0 { // if not empty
			// string "d"
			o = append(o, 0xa1, 0x64)
			o = (*z).RewardedMicroAlgos.MarshalMsg(o)
		}
		if (zb0001Mask & 0x1000) == 0 { // if not empty
			// string "e"
			o = append(o, 0xa1, 0x65)
			o = (*z).AuthAddr.MarshalMsg(o)
		}
		if (zb0001Mask & 0x2000) == 0 { // if not empty
			// string "f"
			o = append(o, 0xa1, 0x66)
			o = msgp.AppendUint64(o, (*z).TotalAppSchemaNumUint)
		}
		if (zb0001Mask & 0x4000) == 0 { // if not empty
			// string "g"
			o = append(o, 0xa1, 0x67)
			o = msgp.AppendUint64(o, (*z).TotalAppSchemaNumByteSlice)
		}
		if (zb0001Mask & 0x8000) == 0 { // if not empty
			// string "h"
			o = append(o, 0xa1, 0x68)
			o = msgp.AppendUint32(o, (*z).TotalExtraAppPages)
		}
		if (zb0001Mask & 0x10000) == 0 { // if not empty
			// string "i"
			o = append(o, 0xa1, 0x69)
			o = msgp.AppendUint64(o, (*z).TotalAssetParams)
		}
		if (zb0001Mask & 0x20000) == 0 { // if not empty
			// string "j"
			o = append(o, 0xa1, 0x6a)
			o = msgp.AppendUint64(o, (*z).TotalAssets)
		}
		if (zb0001Mask & 0x40000) == 0 { // if not empty
			// string "k"
			o = append(o, 0xa1, 0x6b)
			o = msgp.AppendUint64(o, (*z).TotalAppParams)
		}
		if (zb0001Mask & 0x80000) == 0 { // if not empty
			// string "l"
			o = append(o, 0xa1, 0x6c)
			o = msgp.AppendUint64(o, (*z).TotalAppLocalStates)
		}
		if (zb0001Mask & 0x100000) == 0 { // if not empty
			// string "m"
			o = append(o, 0xa1, 0x6d)
			o = msgp.AppendUint64(o, (*z).TotalBoxes)
		}
		if (zb0001Mask & 0x200000) == 0 { // if not empty
			// string "n"
			o = append(o, 0xa1, 0x6e)
			o = msgp.AppendUint64(o, (*z).TotalBoxBytes)
		}
		if (zb0001Mask & 0x400000) == 0 { // if not empty
			// string "o"
			o = append(o, 0xa1, 0x6f)
			o = msgp.AppendBool(o, (*z).IncentiveEligible)
		}
		if (zb0001Mask & 0x800000) == 0 { // if not empty
			// string "p"
			o = append(o, 0xa1, 0x70)
			o = (*z).LastProposed.MarshalMsg(o)
		}
		if (zb0001Mask & 0x1000000) == 0 { // if not empty
			// string "q"
			o = append(o, 0xa1, 0x71)
			o = (*z).LastHeartbeat.MarshalMsg(o)
		}
		if (zb0001Mask & 0x2000000) == 0 { // if not empty
			// string "z"
			o = append(o, 0xa1, 0x7a)
			o = msgp.AppendUint64(o, (*z).UpdateRound)
		}
	}
	return
}

func (_ *BaseAccountData) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*BaseAccountData)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *BaseAccountData) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0001 int
	var zb0002 bool
	zb0001, zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0001, zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).Status.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Status")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).MicroAlgos.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "MicroAlgos")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			(*z).RewardsBase, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "RewardsBase")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).RewardedMicroAlgos.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "RewardedMicroAlgos")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).AuthAddr.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "AuthAddr")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			(*z).TotalAppSchemaNumUint, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "TotalAppSchemaNumUint")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			(*z).TotalAppSchemaNumByteSlice, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "TotalAppSchemaNumByteSlice")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			(*z).TotalExtraAppPages, bts, err = msgp.ReadUint32Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "TotalExtraAppPages")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			(*z).TotalAssetParams, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "TotalAssetParams")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			(*z).TotalAssets, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "TotalAssets")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			(*z).TotalAppParams, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "TotalAppParams")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			(*z).TotalAppLocalStates, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "TotalAppLocalStates")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			(*z).TotalBoxes, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "TotalBoxes")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			(*z).TotalBoxBytes, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "TotalBoxBytes")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			(*z).IncentiveEligible, bts, err = msgp.ReadBoolBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "IncentiveEligible")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).LastProposed.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "LastProposed")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).LastHeartbeat.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "LastHeartbeat")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).BaseVotingData.VoteID.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "VoteID")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).BaseVotingData.SelectionID.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "SelectionID")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).BaseVotingData.VoteFirstValid.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "VoteFirstValid")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).BaseVotingData.VoteLastValid.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "VoteLastValid")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			(*z).BaseVotingData.VoteKeyDilution, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "VoteKeyDilution")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).BaseVotingData.StateProofID.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "StateProofID")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			(*z).UpdateRound, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "UpdateRound")
				return
			}
		}
		if zb0001 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0001)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 {
			(*z) = BaseAccountData{}
		}
		for zb0001 > 0 {
			zb0001--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "a":
				bts, err = (*z).Status.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Status")
					return
				}
			case "b":
				bts, err = (*z).MicroAlgos.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "MicroAlgos")
					return
				}
			case "c":
				(*z).RewardsBase, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "RewardsBase")
					return
				}
			case "d":
				bts, err = (*z).RewardedMicroAlgos.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "RewardedMicroAlgos")
					return
				}
			case "e":
				bts, err = (*z).AuthAddr.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "AuthAddr")
					return
				}
			case "f":
				(*z).TotalAppSchemaNumUint, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "TotalAppSchemaNumUint")
					return
				}
			case "g":
				(*z).TotalAppSchemaNumByteSlice, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "TotalAppSchemaNumByteSlice")
					return
				}
			case "h":
				(*z).TotalExtraAppPages, bts, err = msgp.ReadUint32Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "TotalExtraAppPages")
					return
				}
			case "i":
				(*z).TotalAssetParams, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "TotalAssetParams")
					return
				}
			case "j":
				(*z).TotalAssets, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "TotalAssets")
					return
				}
			case "k":
				(*z).TotalAppParams, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "TotalAppParams")
					return
				}
			case "l":
				(*z).TotalAppLocalStates, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "TotalAppLocalStates")
					return
				}
			case "m":
				(*z).TotalBoxes, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "TotalBoxes")
					return
				}
			case "n":
				(*z).TotalBoxBytes, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "TotalBoxBytes")
					return
				}
			case "o":
				(*z).IncentiveEligible, bts, err = msgp.ReadBoolBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "IncentiveEligible")
					return
				}
			case "p":
				bts, err = (*z).LastProposed.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "LastProposed")
					return
				}
			case "q":
				bts, err = (*z).LastHeartbeat.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "LastHeartbeat")
					return
				}
			case "A":
				bts, err = (*z).BaseVotingData.VoteID.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "VoteID")
					return
				}
			case "B":
				bts, err = (*z).BaseVotingData.SelectionID.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "SelectionID")
					return
				}
			case "C":
				bts, err = (*z).BaseVotingData.VoteFirstValid.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "VoteFirstValid")
					return
				}
			case "D":
				bts, err = (*z).BaseVotingData.VoteLastValid.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "VoteLastValid")
					return
				}
			case "E":
				(*z).BaseVotingData.VoteKeyDilution, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "VoteKeyDilution")
					return
				}
			case "F":
				bts, err = (*z).BaseVotingData.StateProofID.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "StateProofID")
					return
				}
			case "z":
				(*z).UpdateRound, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "UpdateRound")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *BaseAccountData) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *BaseAccountData) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*BaseAccountData)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *BaseAccountData) Msgsize() (s int) {
	s = 3 + 2 + (*z).Status.Msgsize() + 2 + (*z).MicroAlgos.Msgsize() + 2 + msgp.Uint64Size + 2 + (*z).RewardedMicroAlgos.Msgsize() + 2 + (*z).AuthAddr.Msgsize() + 2 + msgp.Uint64Size + 2 + msgp.Uint64Size + 2 + msgp.Uint32Size + 2 + msgp.Uint64Size + 2 + msgp.Uint64Size + 2 + msgp.Uint64Size + 2 + msgp.Uint64Size + 2 + msgp.Uint64Size + 2 + msgp.Uint64Size + 2 + msgp.BoolSize + 2 + (*z).LastProposed.Msgsize() + 2 + (*z).LastHeartbeat.Msgsize() + 2 + (*z).BaseVotingData.VoteID.Msgsize() + 2 + (*z).BaseVotingData.SelectionID.Msgsize() + 2 + (*z).BaseVotingData.VoteFirstValid.Msgsize() + 2 + (*z).BaseVotingData.VoteLastValid.Msgsize() + 2 + msgp.Uint64Size + 2 + (*z).BaseVotingData.StateProofID.Msgsize() + 2 + msgp.Uint64Size
	return
}

// MsgIsZero returns whether this is a zero value
func (z *BaseAccountData) MsgIsZero() bool {
	return ((*z).Status.MsgIsZero()) && ((*z).MicroAlgos.MsgIsZero()) && ((*z).RewardsBase == 0) && ((*z).RewardedMicroAlgos.MsgIsZero()) && ((*z).AuthAddr.MsgIsZero()) && ((*z).TotalAppSchemaNumUint == 0) && ((*z).TotalAppSchemaNumByteSlice == 0) && ((*z).TotalExtraAppPages == 0) && ((*z).TotalAssetParams == 0) && ((*z).TotalAssets == 0) && ((*z).TotalAppParams == 0) && ((*z).TotalAppLocalStates == 0) && ((*z).TotalBoxes == 0) && ((*z).TotalBoxBytes == 0) && ((*z).IncentiveEligible == false) && ((*z).LastProposed.MsgIsZero()) && ((*z).LastHeartbeat.MsgIsZero()) && ((*z).BaseVotingData.VoteID.MsgIsZero()) && ((*z).BaseVotingData.SelectionID.MsgIsZero()) && ((*z).BaseVotingData.VoteFirstValid.MsgIsZero()) && ((*z).BaseVotingData.VoteLastValid.MsgIsZero()) && ((*z).BaseVotingData.VoteKeyDilution == 0) && ((*z).BaseVotingData.StateProofID.MsgIsZero()) && ((*z).UpdateRound == 0)
}

// MaxSize returns a maximum valid message size for this message type
func BaseAccountDataMaxSize() (s int) {
	s = 3 + 2 + basics.StatusMaxSize() + 2 + basics.MicroAlgosMaxSize() + 2 + msgp.Uint64Size + 2 + basics.MicroAlgosMaxSize() + 2 + basics.AddressMaxSize() + 2 + msgp.Uint64Size + 2 + msgp.Uint64Size + 2 + msgp.Uint32Size + 2 + msgp.Uint64Size + 2 + msgp.Uint64Size + 2 + msgp.Uint64Size + 2 + msgp.Uint64Size + 2 + msgp.Uint64Size + 2 + msgp.Uint64Size + 2 + msgp.BoolSize + 2 + basics.RoundMaxSize() + 2 + basics.RoundMaxSize() + 2 + crypto.OneTimeSignatureVerifierMaxSize() + 2 + crypto.VRFVerifierMaxSize() + 2 + basics.RoundMaxSize() + 2 + basics.RoundMaxSize() + 2 + msgp.Uint64Size + 2 + merklesignature.CommitmentMaxSize() + 2 + msgp.Uint64Size
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *BaseOnlineAccountData) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0001Len := uint32(11)
	var zb0001Mask uint16 /* 13 bits */
	if (*z).BaseVotingData.VoteID.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x1
	}
	if (*z).BaseVotingData.SelectionID.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x2
	}
	if (*z).BaseVotingData.VoteFirstValid.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x4
	}
	if (*z).BaseVotingData.VoteLastValid.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x8
	}
	if (*z).BaseVotingData.VoteKeyDilution == 0 {
		zb0001Len--
		zb0001Mask |= 0x10
	}
	if (*z).BaseVotingData.StateProofID.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x20
	}
	if (*z).LastProposed.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x40
	}
	if (*z).LastHeartbeat.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x80
	}
	if (*z).IncentiveEligible == false {
		zb0001Len--
		zb0001Mask |= 0x100
	}
	if (*z).MicroAlgos.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x200
	}
	if (*z).RewardsBase == 0 {
		zb0001Len--
		zb0001Mask |= 0x400
	}
	// variable map header, size zb0001Len
	o = append(o, 0x80|uint8(zb0001Len))
	if zb0001Len != 0 {
		if (zb0001Mask & 0x1) == 0 { // if not empty
			// string "A"
			o = append(o, 0xa1, 0x41)
			o = (*z).BaseVotingData.VoteID.MarshalMsg(o)
		}
		if (zb0001Mask & 0x2) == 0 { // if not empty
			// string "B"
			o = append(o, 0xa1, 0x42)
			o = (*z).BaseVotingData.SelectionID.MarshalMsg(o)
		}
		if (zb0001Mask & 0x4) == 0 { // if not empty
			// string "C"
			o = append(o, 0xa1, 0x43)
			o = (*z).BaseVotingData.VoteFirstValid.MarshalMsg(o)
		}
		if (zb0001Mask & 0x8) == 0 { // if not empty
			// string "D"
			o = append(o, 0xa1, 0x44)
			o = (*z).BaseVotingData.VoteLastValid.MarshalMsg(o)
		}
		if (zb0001Mask & 0x10) == 0 { // if not empty
			// string "E"
			o = append(o, 0xa1, 0x45)
			o = msgp.AppendUint64(o, (*z).BaseVotingData.VoteKeyDilution)
		}
		if (zb0001Mask & 0x20) == 0 { // if not empty
			// string "F"
			o = append(o, 0xa1, 0x46)
			o = (*z).BaseVotingData.StateProofID.MarshalMsg(o)
		}
		if (zb0001Mask & 0x40) == 0 { // if not empty
			// string "V"
			o = append(o, 0xa1, 0x56)
			o = (*z).LastProposed.MarshalMsg(o)
		}
		if (zb0001Mask & 0x80) == 0 { // if not empty
			// string "W"
			o = append(o, 0xa1, 0x57)
			o = (*z).LastHeartbeat.MarshalMsg(o)
		}
		if (zb0001Mask & 0x100) == 0 { // if not empty
			// string "X"
			o = append(o, 0xa1, 0x58)
			o = msgp.AppendBool(o, (*z).IncentiveEligible)
		}
		if (zb0001Mask & 0x200) == 0 { // if not empty
			// string "Y"
			o = append(o, 0xa1, 0x59)
			o = (*z).MicroAlgos.MarshalMsg(o)
		}
		if (zb0001Mask & 0x400) == 0 { // if not empty
			// string "Z"
			o = append(o, 0xa1, 0x5a)
			o = msgp.AppendUint64(o, (*z).RewardsBase)
		}
	}
	return
}

func (_ *BaseOnlineAccountData) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*BaseOnlineAccountData)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *BaseOnlineAccountData) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0001 int
	var zb0002 bool
	zb0001, zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0001, zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).BaseVotingData.VoteID.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "VoteID")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).BaseVotingData.SelectionID.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "SelectionID")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).BaseVotingData.VoteFirstValid.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "VoteFirstValid")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).BaseVotingData.VoteLastValid.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "VoteLastValid")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			(*z).BaseVotingData.VoteKeyDilution, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "VoteKeyDilution")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).BaseVotingData.StateProofID.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "StateProofID")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).LastProposed.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "LastProposed")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).LastHeartbeat.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "LastHeartbeat")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			(*z).IncentiveEligible, bts, err = msgp.ReadBoolBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "IncentiveEligible")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).MicroAlgos.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "MicroAlgos")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			(*z).RewardsBase, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "RewardsBase")
				return
			}
		}
		if zb0001 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0001)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 {
			(*z) = BaseOnlineAccountData{}
		}
		for zb0001 > 0 {
			zb0001--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "A":
				bts, err = (*z).BaseVotingData.VoteID.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "VoteID")
					return
				}
			case "B":
				bts, err = (*z).BaseVotingData.SelectionID.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "SelectionID")
					return
				}
			case "C":
				bts, err = (*z).BaseVotingData.VoteFirstValid.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "VoteFirstValid")
					return
				}
			case "D":
				bts, err = (*z).BaseVotingData.VoteLastValid.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "VoteLastValid")
					return
				}
			case "E":
				(*z).BaseVotingData.VoteKeyDilution, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "VoteKeyDilution")
					return
				}
			case "F":
				bts, err = (*z).BaseVotingData.StateProofID.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "StateProofID")
					return
				}
			case "V":
				bts, err = (*z).LastProposed.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "LastProposed")
					return
				}
			case "W":
				bts, err = (*z).LastHeartbeat.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "LastHeartbeat")
					return
				}
			case "X":
				(*z).IncentiveEligible, bts, err = msgp.ReadBoolBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "IncentiveEligible")
					return
				}
			case "Y":
				bts, err = (*z).MicroAlgos.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "MicroAlgos")
					return
				}
			case "Z":
				(*z).RewardsBase, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "RewardsBase")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *BaseOnlineAccountData) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *BaseOnlineAccountData) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*BaseOnlineAccountData)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *BaseOnlineAccountData) Msgsize() (s int) {
	s = 1 + 2 + (*z).BaseVotingData.VoteID.Msgsize() + 2 + (*z).BaseVotingData.SelectionID.Msgsize() + 2 + (*z).BaseVotingData.VoteFirstValid.Msgsize() + 2 + (*z).BaseVotingData.VoteLastValid.Msgsize() + 2 + msgp.Uint64Size + 2 + (*z).BaseVotingData.StateProofID.Msgsize() + 2 + (*z).LastProposed.Msgsize() + 2 + (*z).LastHeartbeat.Msgsize() + 2 + msgp.BoolSize + 2 + (*z).MicroAlgos.Msgsize() + 2 + msgp.Uint64Size
	return
}

// MsgIsZero returns whether this is a zero value
func (z *BaseOnlineAccountData) MsgIsZero() bool {
	return ((*z).BaseVotingData.VoteID.MsgIsZero()) && ((*z).BaseVotingData.SelectionID.MsgIsZero()) && ((*z).BaseVotingData.VoteFirstValid.MsgIsZero()) && ((*z).BaseVotingData.VoteLastValid.MsgIsZero()) && ((*z).BaseVotingData.VoteKeyDilution == 0) && ((*z).BaseVotingData.StateProofID.MsgIsZero()) && ((*z).LastProposed.MsgIsZero()) && ((*z).LastHeartbeat.MsgIsZero()) && ((*z).IncentiveEligible == false) && ((*z).MicroAlgos.MsgIsZero()) && ((*z).RewardsBase == 0)
}

// MaxSize returns a maximum valid message size for this message type
func BaseOnlineAccountDataMaxSize() (s int) {
	s = 1 + 2 + crypto.OneTimeSignatureVerifierMaxSize() + 2 + crypto.VRFVerifierMaxSize() + 2 + basics.RoundMaxSize() + 2 + basics.RoundMaxSize() + 2 + msgp.Uint64Size + 2 + merklesignature.CommitmentMaxSize() + 2 + basics.RoundMaxSize() + 2 + basics.RoundMaxSize() + 2 + msgp.BoolSize + 2 + basics.MicroAlgosMaxSize() + 2 + msgp.Uint64Size
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *BaseVotingData) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0001Len := uint32(6)
	var zb0001Mask uint8 /* 7 bits */
	if (*z).VoteID.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x1
	}
	if (*z).SelectionID.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x2
	}
	if (*z).VoteFirstValid.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x4
	}
	if (*z).VoteLastValid.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x8
	}
	if (*z).VoteKeyDilution == 0 {
		zb0001Len--
		zb0001Mask |= 0x10
	}
	if (*z).StateProofID.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x20
	}
	// variable map header, size zb0001Len
	o = append(o, 0x80|uint8(zb0001Len))
	if zb0001Len != 0 {
		if (zb0001Mask & 0x1) == 0 { // if not empty
			// string "A"
			o = append(o, 0xa1, 0x41)
			o = (*z).VoteID.MarshalMsg(o)
		}
		if (zb0001Mask & 0x2) == 0 { // if not empty
			// string "B"
			o = append(o, 0xa1, 0x42)
			o = (*z).SelectionID.MarshalMsg(o)
		}
		if (zb0001Mask & 0x4) == 0 { // if not empty
			// string "C"
			o = append(o, 0xa1, 0x43)
			o = (*z).VoteFirstValid.MarshalMsg(o)
		}
		if (zb0001Mask & 0x8) == 0 { // if not empty
			// string "D"
			o = append(o, 0xa1, 0x44)
			o = (*z).VoteLastValid.MarshalMsg(o)
		}
		if (zb0001Mask & 0x10) == 0 { // if not empty
			// string "E"
			o = append(o, 0xa1, 0x45)
			o = msgp.AppendUint64(o, (*z).VoteKeyDilution)
		}
		if (zb0001Mask & 0x20) == 0 { // if not empty
			// string "F"
			o = append(o, 0xa1, 0x46)
			o = (*z).StateProofID.MarshalMsg(o)
		}
	}
	return
}

func (_ *BaseVotingData) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*BaseVotingData)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *BaseVotingData) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0001 int
	var zb0002 bool
	zb0001, zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0001, zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).VoteID.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "VoteID")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).SelectionID.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "SelectionID")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).VoteFirstValid.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "VoteFirstValid")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).VoteLastValid.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "VoteLastValid")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			(*z).VoteKeyDilution, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "VoteKeyDilution")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).StateProofID.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "StateProofID")
				return
			}
		}
		if zb0001 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0001)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 {
			(*z) = BaseVotingData{}
		}
		for zb0001 > 0 {
			zb0001--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "A":
				bts, err = (*z).VoteID.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "VoteID")
					return
				}
			case "B":
				bts, err = (*z).SelectionID.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "SelectionID")
					return
				}
			case "C":
				bts, err = (*z).VoteFirstValid.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "VoteFirstValid")
					return
				}
			case "D":
				bts, err = (*z).VoteLastValid.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "VoteLastValid")
					return
				}
			case "E":
				(*z).VoteKeyDilution, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "VoteKeyDilution")
					return
				}
			case "F":
				bts, err = (*z).StateProofID.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "StateProofID")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *BaseVotingData) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *BaseVotingData) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*BaseVotingData)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *BaseVotingData) Msgsize() (s int) {
	s = 1 + 2 + (*z).VoteID.Msgsize() + 2 + (*z).SelectionID.Msgsize() + 2 + (*z).VoteFirstValid.Msgsize() + 2 + (*z).VoteLastValid.Msgsize() + 2 + msgp.Uint64Size + 2 + (*z).StateProofID.Msgsize()
	return
}

// MsgIsZero returns whether this is a zero value
func (z *BaseVotingData) MsgIsZero() bool {
	return ((*z).VoteID.MsgIsZero()) && ((*z).SelectionID.MsgIsZero()) && ((*z).VoteFirstValid.MsgIsZero()) && ((*z).VoteLastValid.MsgIsZero()) && ((*z).VoteKeyDilution == 0) && ((*z).StateProofID.MsgIsZero())
}

// MaxSize returns a maximum valid message size for this message type
func BaseVotingDataMaxSize() (s int) {
	s = 1 + 2 + crypto.OneTimeSignatureVerifierMaxSize() + 2 + crypto.VRFVerifierMaxSize() + 2 + basics.RoundMaxSize() + 2 + basics.RoundMaxSize() + 2 + msgp.Uint64Size + 2 + merklesignature.CommitmentMaxSize()
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *CatchpointFirstStageInfo) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0001Len := uint32(11)
	var zb0001Mask uint16 /* 12 bits */
	if (*z).Totals.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x2
	}
	if (*z).TotalAccounts == 0 {
		zb0001Len--
		zb0001Mask |= 0x4
	}
	if (*z).BiggestChunkLen == 0 {
		zb0001Len--
		zb0001Mask |= 0x8
	}
	if (*z).TotalChunks == 0 {
		zb0001Len--
		zb0001Mask |= 0x10
	}
	if (*z).TotalKVs == 0 {
		zb0001Len--
		zb0001Mask |= 0x20
	}
	if (*z).TotalOnlineAccounts == 0 {
		zb0001Len--
		zb0001Mask |= 0x40
	}
	if (*z).OnlineAccountsHash.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x80
	}
	if (*z).TotalOnlineRoundParams == 0 {
		zb0001Len--
		zb0001Mask |= 0x100
	}
	if (*z).OnlineRoundParamsHash.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x200
	}
	if (*z).StateProofVerificationHash.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x400
	}
	if (*z).TrieBalancesHash.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x800
	}
	// variable map header, size zb0001Len
	o = append(o, 0x80|uint8(zb0001Len))
	if zb0001Len != 0 {
		if (zb0001Mask & 0x2) == 0 { // if not empty
			// string "accountTotals"
			o = append(o, 0xad, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x54, 0x6f, 0x74, 0x61, 0x6c, 0x73)
			o = (*z).Totals.MarshalMsg(o)
		}
		if (zb0001Mask & 0x4) == 0 { // if not empty
			// string "accountsCount"
			o = append(o, 0xad, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74)
			o = msgp.AppendUint64(o, (*z).TotalAccounts)
		}
		if (zb0001Mask & 0x8) == 0 { // if not empty
			// string "biggestChunk"
			o = append(o, 0xac, 0x62, 0x69, 0x67, 0x67, 0x65, 0x73, 0x74, 0x43, 0x68, 0x75, 0x6e, 0x6b)
			o = msgp.AppendUint64(o, (*z).BiggestChunkLen)
		}
		if (zb0001Mask & 0x10) == 0 { // if not empty
			// string "chunksCount"
			o = append(o, 0xab, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74)
			o = msgp.AppendUint64(o, (*z).TotalChunks)
		}
		if (zb0001Mask & 0x20) == 0 { // if not empty
			// string "kvsCount"
			o = append(o, 0xa8, 0x6b, 0x76, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74)
			o = msgp.AppendUint64(o, (*z).TotalKVs)
		}
		if (zb0001Mask & 0x40) == 0 { // if not empty
			// string "onlineAccountsCount"
			o = append(o, 0xb3, 0x6f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74)
			o = msgp.AppendUint64(o, (*z).TotalOnlineAccounts)
		}
		if (zb0001Mask & 0x80) == 0 { // if not empty
			// string "onlineAccountsHash"
			o = append(o, 0xb2, 0x6f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x48, 0x61, 0x73, 0x68)
			o = (*z).OnlineAccountsHash.MarshalMsg(o)
		}
		if (zb0001Mask & 0x100) == 0 { // if not empty
			// string "onlineRoundParamsCount"
			o = append(o, 0xb6, 0x6f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x6f, 0x75, 0x6e, 0x64, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74)
			o = msgp.AppendUint64(o, (*z).TotalOnlineRoundParams)
		}
		if (zb0001Mask & 0x200) == 0 { // if not empty
			// string "onlineRoundParamsHash"
			o = append(o, 0xb5, 0x6f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x52, 0x6f, 0x75, 0x6e, 0x64, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x48, 0x61, 0x73, 0x68)
			o = (*z).OnlineRoundParamsHash.MarshalMsg(o)
		}
		if (zb0001Mask & 0x400) == 0 { // if not empty
			// string "spVerificationHash"
			o = append(o, 0xb2, 0x73, 0x70, 0x56, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x61, 0x73, 0x68)
			o = (*z).StateProofVerificationHash.MarshalMsg(o)
		}
		if (zb0001Mask & 0x800) == 0 { // if not empty
			// string "trieBalancesHash"
			o = append(o, 0xb0, 0x74, 0x72, 0x69, 0x65, 0x42, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x48, 0x61, 0x73, 0x68)
			o = (*z).TrieBalancesHash.MarshalMsg(o)
		}
	}
	return
}

func (_ *CatchpointFirstStageInfo) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*CatchpointFirstStageInfo)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *CatchpointFirstStageInfo) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0001 int
	var zb0002 bool
	zb0001, zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0001, zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).Totals.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Totals")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).TrieBalancesHash.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "TrieBalancesHash")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			(*z).TotalAccounts, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "TotalAccounts")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			(*z).TotalKVs, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "TotalKVs")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			(*z).TotalOnlineAccounts, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "TotalOnlineAccounts")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			(*z).TotalOnlineRoundParams, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "TotalOnlineRoundParams")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			(*z).TotalChunks, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "TotalChunks")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			(*z).BiggestChunkLen, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "BiggestChunkLen")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).StateProofVerificationHash.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "StateProofVerificationHash")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).OnlineAccountsHash.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "OnlineAccountsHash")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).OnlineRoundParamsHash.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "OnlineRoundParamsHash")
				return
			}
		}
		if zb0001 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0001)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 {
			(*z) = CatchpointFirstStageInfo{}
		}
		for zb0001 > 0 {
			zb0001--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "accountTotals":
				bts, err = (*z).Totals.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Totals")
					return
				}
			case "trieBalancesHash":
				bts, err = (*z).TrieBalancesHash.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "TrieBalancesHash")
					return
				}
			case "accountsCount":
				(*z).TotalAccounts, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "TotalAccounts")
					return
				}
			case "kvsCount":
				(*z).TotalKVs, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "TotalKVs")
					return
				}
			case "onlineAccountsCount":
				(*z).TotalOnlineAccounts, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "TotalOnlineAccounts")
					return
				}
			case "onlineRoundParamsCount":
				(*z).TotalOnlineRoundParams, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "TotalOnlineRoundParams")
					return
				}
			case "chunksCount":
				(*z).TotalChunks, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "TotalChunks")
					return
				}
			case "biggestChunk":
				(*z).BiggestChunkLen, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "BiggestChunkLen")
					return
				}
			case "spVerificationHash":
				bts, err = (*z).StateProofVerificationHash.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "StateProofVerificationHash")
					return
				}
			case "onlineAccountsHash":
				bts, err = (*z).OnlineAccountsHash.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "OnlineAccountsHash")
					return
				}
			case "onlineRoundParamsHash":
				bts, err = (*z).OnlineRoundParamsHash.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "OnlineRoundParamsHash")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *CatchpointFirstStageInfo) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *CatchpointFirstStageInfo) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*CatchpointFirstStageInfo)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *CatchpointFirstStageInfo) Msgsize() (s int) {
	s = 1 + 14 + (*z).Totals.Msgsize() + 17 + (*z).TrieBalancesHash.Msgsize() + 14 + msgp.Uint64Size + 9 + msgp.Uint64Size + 20 + msgp.Uint64Size + 23 + msgp.Uint64Size + 12 + msgp.Uint64Size + 13 + msgp.Uint64Size + 19 + (*z).StateProofVerificationHash.Msgsize() + 19 + (*z).OnlineAccountsHash.Msgsize() + 22 + (*z).OnlineRoundParamsHash.Msgsize()
	return
}

// MsgIsZero returns whether this is a zero value
func (z *CatchpointFirstStageInfo) MsgIsZero() bool {
	return ((*z).Totals.MsgIsZero()) && ((*z).TrieBalancesHash.MsgIsZero()) && ((*z).TotalAccounts == 0) && ((*z).TotalKVs == 0) && ((*z).TotalOnlineAccounts == 0) && ((*z).TotalOnlineRoundParams == 0) && ((*z).TotalChunks == 0) && ((*z).BiggestChunkLen == 0) && ((*z).StateProofVerificationHash.MsgIsZero()) && ((*z).OnlineAccountsHash.MsgIsZero()) && ((*z).OnlineRoundParamsHash.MsgIsZero())
}

// MaxSize returns a maximum valid message size for this message type
func CatchpointFirstStageInfoMaxSize() (s int) {
	s = 1 + 14 + ledgercore.AccountTotalsMaxSize() + 17 + crypto.DigestMaxSize() + 14 + msgp.Uint64Size + 9 + msgp.Uint64Size + 20 + msgp.Uint64Size + 23 + msgp.Uint64Size + 12 + msgp.Uint64Size + 13 + msgp.Uint64Size + 19 + crypto.DigestMaxSize() + 19 + crypto.DigestMaxSize() + 22 + crypto.DigestMaxSize()
	return
}

// MarshalMsg implements msgp.Marshaler
func (z ResourceFlags) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	o = msgp.AppendUint8(o, uint8(z))
	return
}

func (_ ResourceFlags) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(ResourceFlags)
	if !ok {
		_, ok = (z).(*ResourceFlags)
	}
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *ResourceFlags) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	{
		var zb0001 uint8
		zb0001, bts, err = msgp.ReadUint8Bytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		(*z) = ResourceFlags(zb0001)
	}
	o = bts
	return
}

func (z *ResourceFlags) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *ResourceFlags) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*ResourceFlags)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z ResourceFlags) Msgsize() (s int) {
	s = msgp.Uint8Size
	return
}

// MsgIsZero returns whether this is a zero value
func (z ResourceFlags) MsgIsZero() bool {
	return z == 0
}

// MaxSize returns a maximum valid message size for this message type
func ResourceFlagsMaxSize() (s int) {
	s = msgp.Uint8Size
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *ResourcesData) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0002Len := uint32(27)
	var zb0002Mask uint32 /* 28 bits */
	if (*z).Version == 0 {
		zb0002Len--
		zb0002Mask |= 0x1
	}
	if (*z).Total == 0 {
		zb0002Len--
		zb0002Mask |= 0x4
	}
	if (*z).Decimals == 0 {
		zb0002Len--
		zb0002Mask |= 0x8
	}
	if (*z).DefaultFrozen == false {
		zb0002Len--
		zb0002Mask |= 0x10
	}
	if (*z).UnitName == "" {
		zb0002Len--
		zb0002Mask |= 0x20
	}
	if (*z).AssetName == "" {
		zb0002Len--
		zb0002Mask |= 0x40
	}
	if (*z).URL == "" {
		zb0002Len--
		zb0002Mask |= 0x80
	}
	if (*z).MetadataHash == ([32]byte{}) {
		zb0002Len--
		zb0002Mask |= 0x100
	}
	if (*z).Manager.MsgIsZero() {
		zb0002Len--
		zb0002Mask |= 0x200
	}
	if (*z).Reserve.MsgIsZero() {
		zb0002Len--
		zb0002Mask |= 0x400
	}
	if (*z).Freeze.MsgIsZero() {
		zb0002Len--
		zb0002Mask |= 0x800
	}
	if (*z).Clawback.MsgIsZero() {
		zb0002Len--
		zb0002Mask |= 0x1000
	}
	if (*z).Amount == 0 {
		zb0002Len--
		zb0002Mask |= 0x2000
	}
	if (*z).Frozen == false {
		zb0002Len--
		zb0002Mask |= 0x4000
	}
	if (*z).SchemaNumUint == 0 {
		zb0002Len--
		zb0002Mask |= 0x8000
	}
	if (*z).SchemaNumByteSlice == 0 {
		zb0002Len--
		zb0002Mask |= 0x10000
	}
	if (*z).KeyValue.MsgIsZero() {
		zb0002Len--
		zb0002Mask |= 0x20000
	}
	if len((*z).ApprovalProgram) == 0 {
		zb0002Len--
		zb0002Mask |= 0x40000
	}
	if len((*z).ClearStateProgram) == 0 {
		zb0002Len--
		zb0002Mask |= 0x80000
	}
	if (*z).GlobalState.MsgIsZero() {
		zb0002Len--
		zb0002Mask |= 0x100000
	}
	if (*z).LocalStateSchemaNumUint == 0 {
		zb0002Len--
		zb0002Mask |= 0x200000
	}
	if (*z).LocalStateSchemaNumByteSlice == 0 {
		zb0002Len--
		zb0002Mask |= 0x400000
	}
	if (*z).GlobalStateSchemaNumUint == 0 {
		zb0002Len--
		zb0002Mask |= 0x800000
	}
	if (*z).GlobalStateSchemaNumByteSlice == 0 {
		zb0002Len--
		zb0002Mask |= 0x1000000
	}
	if (*z).ExtraProgramPages == 0 {
		zb0002Len--
		zb0002Mask |= 0x2000000
	}
	if (*z).ResourceFlags == 0 {
		zb0002Len--
		zb0002Mask |= 0x4000000
	}
	if (*z).UpdateRound == 0 {
		zb0002Len--
		zb0002Mask |= 0x8000000
	}
	// variable map header, size zb0002Len
	o = msgp.AppendMapHeader(o, zb0002Len)
	if zb0002Len != 0 {
		if (zb0002Mask & 0x1) == 0 { // if not empty
			// string "A"
			o = append(o, 0xa1, 0x41)
			o = msgp.AppendUint64(o, (*z).Version)
		}
		if (zb0002Mask & 0x4) == 0 { // if not empty
			// string "a"
			o = append(o, 0xa1, 0x61)
			o = msgp.AppendUint64(o, (*z).Total)
		}
		if (zb0002Mask & 0x8) == 0 { // if not empty
			// string "b"
			o = append(o, 0xa1, 0x62)
			o = msgp.AppendUint32(o, (*z).Decimals)
		}
		if (zb0002Mask & 0x10) == 0 { // if not empty
			// string "c"
			o = append(o, 0xa1, 0x63)
			o = msgp.AppendBool(o, (*z).DefaultFrozen)
		}
		if (zb0002Mask & 0x20) == 0 { // if not empty
			// string "d"
			o = append(o, 0xa1, 0x64)
			o = msgp.AppendString(o, (*z).UnitName)
		}
		if (zb0002Mask & 0x40) == 0 { // if not empty
			// string "e"
			o = append(o, 0xa1, 0x65)
			o = msgp.AppendString(o, (*z).AssetName)
		}
		if (zb0002Mask & 0x80) == 0 { // if not empty
			// string "f"
			o = append(o, 0xa1, 0x66)
			o = msgp.AppendString(o, (*z).URL)
		}
		if (zb0002Mask & 0x100) == 0 { // if not empty
			// string "g"
			o = append(o, 0xa1, 0x67)
			o = msgp.AppendBytes(o, ((*z).MetadataHash)[:])
		}
		if (zb0002Mask & 0x200) == 0 { // if not empty
			// string "h"
			o = append(o, 0xa1, 0x68)
			o = (*z).Manager.MarshalMsg(o)
		}
		if (zb0002Mask & 0x400) == 0 { // if not empty
			// string "i"
			o = append(o, 0xa1, 0x69)
			o = (*z).Reserve.MarshalMsg(o)
		}
		if (zb0002Mask & 0x800) == 0 { // if not empty
			// string "j"
			o = append(o, 0xa1, 0x6a)
			o = (*z).Freeze.MarshalMsg(o)
		}
		if (zb0002Mask & 0x1000) == 0 { // if not empty
			// string "k"
			o = append(o, 0xa1, 0x6b)
			o = (*z).Clawback.MarshalMsg(o)
		}
		if (zb0002Mask & 0x2000) == 0 { // if not empty
			// string "l"
			o = append(o, 0xa1, 0x6c)
			o = msgp.AppendUint64(o, (*z).Amount)
		}
		if (zb0002Mask & 0x4000) == 0 { // if not empty
			// string "m"
			o = append(o, 0xa1, 0x6d)
			o = msgp.AppendBool(o, (*z).Frozen)
		}
		if (zb0002Mask & 0x8000) == 0 { // if not empty
			// string "n"
			o = append(o, 0xa1, 0x6e)
			o = msgp.AppendUint64(o, (*z).SchemaNumUint)
		}
		if (zb0002Mask & 0x10000) == 0 { // if not empty
			// string "o"
			o = append(o, 0xa1, 0x6f)
			o = msgp.AppendUint64(o, (*z).SchemaNumByteSlice)
		}
		if (zb0002Mask & 0x20000) == 0 { // if not empty
			// string "p"
			o = append(o, 0xa1, 0x70)
			o = (*z).KeyValue.MarshalMsg(o)
		}
		if (zb0002Mask & 0x40000) == 0 { // if not empty
			// string "q"
			o = append(o, 0xa1, 0x71)
			o = msgp.AppendBytes(o, (*z).ApprovalProgram)
		}
		if (zb0002Mask & 0x80000) == 0 { // if not empty
			// string "r"
			o = append(o, 0xa1, 0x72)
			o = msgp.AppendBytes(o, (*z).ClearStateProgram)
		}
		if (zb0002Mask & 0x100000) == 0 { // if not empty
			// string "s"
			o = append(o, 0xa1, 0x73)
			o = (*z).GlobalState.MarshalMsg(o)
		}
		if (zb0002Mask & 0x200000) == 0 { // if not empty
			// string "t"
			o = append(o, 0xa1, 0x74)
			o = msgp.AppendUint64(o, (*z).LocalStateSchemaNumUint)
		}
		if (zb0002Mask & 0x400000) == 0 { // if not empty
			// string "u"
			o = append(o, 0xa1, 0x75)
			o = msgp.AppendUint64(o, (*z).LocalStateSchemaNumByteSlice)
		}
		if (zb0002Mask & 0x800000) == 0 { // if not empty
			// string "v"
			o = append(o, 0xa1, 0x76)
			o = msgp.AppendUint64(o, (*z).GlobalStateSchemaNumUint)
		}
		if (zb0002Mask & 0x1000000) == 0 { // if not empty
			// string "w"
			o = append(o, 0xa1, 0x77)
			o = msgp.AppendUint64(o, (*z).GlobalStateSchemaNumByteSlice)
		}
		if (zb0002Mask & 0x2000000) == 0 { // if not empty
			// string "x"
			o = append(o, 0xa1, 0x78)
			o = msgp.AppendUint32(o, (*z).ExtraProgramPages)
		}
		if (zb0002Mask & 0x4000000) == 0 { // if not empty
			// string "y"
			o = append(o, 0xa1, 0x79)
			o = msgp.AppendUint8(o, uint8((*z).ResourceFlags))
		}
		if (zb0002Mask & 0x8000000) == 0 { // if not empty
			// string "z"
			o = append(o, 0xa1, 0x7a)
			o = msgp.AppendUint64(o, (*z).UpdateRound)
		}
	}
	return
}

func (_ *ResourcesData) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*ResourcesData)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *ResourcesData) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0002 int
	var zb0003 bool
	zb0002, zb0003, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0002, zb0003, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 > 0 {
			zb0002--
			(*z).Total, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Total")
				return
			}
		}
		if zb0002 > 0 {
			zb0002--
			(*z).Decimals, bts, err = msgp.ReadUint32Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Decimals")
				return
			}
		}
		if zb0002 > 0 {
			zb0002--
			(*z).DefaultFrozen, bts, err = msgp.ReadBoolBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "DefaultFrozen")
				return
			}
		}
		if zb0002 > 0 {
			zb0002--
			(*z).UnitName, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "UnitName")
				return
			}
		}
		if zb0002 > 0 {
			zb0002--
			(*z).AssetName, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "AssetName")
				return
			}
		}
		if zb0002 > 0 {
			zb0002--
			(*z).URL, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "URL")
				return
			}
		}
		if zb0002 > 0 {
			zb0002--
			bts, err = msgp.ReadExactBytes(bts, ((*z).MetadataHash)[:])
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "MetadataHash")
				return
			}
		}
		if zb0002 > 0 {
			zb0002--
			bts, err = (*z).Manager.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Manager")
				return
			}
		}
		if zb0002 > 0 {
			zb0002--
			bts, err = (*z).Reserve.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Reserve")
				return
			}
		}
		if zb0002 > 0 {
			zb0002--
			bts, err = (*z).Freeze.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Freeze")
				return
			}
		}
		if zb0002 > 0 {
			zb0002--
			bts, err = (*z).Clawback.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Clawback")
				return
			}
		}
		if zb0002 > 0 {
			zb0002--
			(*z).Amount, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Amount")
				return
			}
		}
		if zb0002 > 0 {
			zb0002--
			(*z).Frozen, bts, err = msgp.ReadBoolBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Frozen")
				return
			}
		}
		if zb0002 > 0 {
			zb0002--
			(*z).SchemaNumUint, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "SchemaNumUint")
				return
			}
		}
		if zb0002 > 0 {
			zb0002--
			(*z).SchemaNumByteSlice, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "SchemaNumByteSlice")
				return
			}
		}
		if zb0002 > 0 {
			zb0002--
			bts, err = (*z).KeyValue.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "KeyValue")
				return
			}
		}
		if zb0002 > 0 {
			zb0002--
			var zb0004 int
			zb0004, err = msgp.ReadBytesBytesHeader(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "ApprovalProgram")
				return
			}
			if zb0004 > config.MaxAvailableAppProgramLen {
				err = msgp.ErrOverflow(uint64(zb0004), uint64(config.MaxAvailableAppProgramLen))
				return
			}
			(*z).ApprovalProgram, bts, err = msgp.ReadBytesBytes(bts, (*z).ApprovalProgram)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "ApprovalProgram")
				return
			}
		}
		if zb0002 > 0 {
			zb0002--
			var zb0005 int
			zb0005, err = msgp.ReadBytesBytesHeader(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "ClearStateProgram")
				return
			}
			if zb0005 > config.MaxAvailableAppProgramLen {
				err = msgp.ErrOverflow(uint64(zb0005), uint64(config.MaxAvailableAppProgramLen))
				return
			}
			(*z).ClearStateProgram, bts, err = msgp.ReadBytesBytes(bts, (*z).ClearStateProgram)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "ClearStateProgram")
				return
			}
		}
		if zb0002 > 0 {
			zb0002--
			bts, err = (*z).GlobalState.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "GlobalState")
				return
			}
		}
		if zb0002 > 0 {
			zb0002--
			(*z).LocalStateSchemaNumUint, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "LocalStateSchemaNumUint")
				return
			}
		}
		if zb0002 > 0 {
			zb0002--
			(*z).LocalStateSchemaNumByteSlice, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "LocalStateSchemaNumByteSlice")
				return
			}
		}
		if zb0002 > 0 {
			zb0002--
			(*z).GlobalStateSchemaNumUint, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "GlobalStateSchemaNumUint")
				return
			}
		}
		if zb0002 > 0 {
			zb0002--
			(*z).GlobalStateSchemaNumByteSlice, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "GlobalStateSchemaNumByteSlice")
				return
			}
		}
		if zb0002 > 0 {
			zb0002--
			(*z).ExtraProgramPages, bts, err = msgp.ReadUint32Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "ExtraProgramPages")
				return
			}
		}
		if zb0002 > 0 {
			zb0002--
			{
				var zb0006 uint8
				zb0006, bts, err = msgp.ReadUint8Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "ResourceFlags")
					return
				}
				(*z).ResourceFlags = ResourceFlags(zb0006)
			}
		}
		if zb0002 > 0 {
			zb0002--
			(*z).UpdateRound, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "UpdateRound")
				return
			}
		}
		if zb0002 > 0 {
			zb0002--
			(*z).Version, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Version")
				return
			}
		}
		if zb0002 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0002)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0003 {
			(*z) = ResourcesData{}
		}
		for zb0002 > 0 {
			zb0002--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "a":
				(*z).Total, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Total")
					return
				}
			case "b":
				(*z).Decimals, bts, err = msgp.ReadUint32Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Decimals")
					return
				}
			case "c":
				(*z).DefaultFrozen, bts, err = msgp.ReadBoolBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "DefaultFrozen")
					return
				}
			case "d":
				(*z).UnitName, bts, err = msgp.ReadStringBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "UnitName")
					return
				}
			case "e":
				(*z).AssetName, bts, err = msgp.ReadStringBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "AssetName")
					return
				}
			case "f":
				(*z).URL, bts, err = msgp.ReadStringBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "URL")
					return
				}
			case "g":
				bts, err = msgp.ReadExactBytes(bts, ((*z).MetadataHash)[:])
				if err != nil {
					err = msgp.WrapError(err, "MetadataHash")
					return
				}
			case "h":
				bts, err = (*z).Manager.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Manager")
					return
				}
			case "i":
				bts, err = (*z).Reserve.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Reserve")
					return
				}
			case "j":
				bts, err = (*z).Freeze.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Freeze")
					return
				}
			case "k":
				bts, err = (*z).Clawback.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Clawback")
					return
				}
			case "l":
				(*z).Amount, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Amount")
					return
				}
			case "m":
				(*z).Frozen, bts, err = msgp.ReadBoolBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Frozen")
					return
				}
			case "n":
				(*z).SchemaNumUint, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "SchemaNumUint")
					return
				}
			case "o":
				(*z).SchemaNumByteSlice, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "SchemaNumByteSlice")
					return
				}
			case "p":
				bts, err = (*z).KeyValue.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "KeyValue")
					return
				}
			case "q":
				var zb0007 int
				zb0007, err = msgp.ReadBytesBytesHeader(bts)
				if err != nil {
					err = msgp.WrapError(err, "ApprovalProgram")
					return
				}
				if zb0007 > config.MaxAvailableAppProgramLen {
					err = msgp.ErrOverflow(uint64(zb0007), uint64(config.MaxAvailableAppProgramLen))
					return
				}
				(*z).ApprovalProgram, bts, err = msgp.ReadBytesBytes(bts, (*z).ApprovalProgram)
				if err != nil {
					err = msgp.WrapError(err, "ApprovalProgram")
					return
				}
			case "r":
				var zb0008 int
				zb0008, err = msgp.ReadBytesBytesHeader(bts)
				if err != nil {
					err = msgp.WrapError(err, "ClearStateProgram")
					return
				}
				if zb0008 > config.MaxAvailableAppProgramLen {
					err = msgp.ErrOverflow(uint64(zb0008), uint64(config.MaxAvailableAppProgramLen))
					return
				}
				(*z).ClearStateProgram, bts, err = msgp.ReadBytesBytes(bts, (*z).ClearStateProgram)
				if err != nil {
					err = msgp.WrapError(err, "ClearStateProgram")
					return
				}
			case "s":
				bts, err = (*z).GlobalState.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "GlobalState")
					return
				}
			case "t":
				(*z).LocalStateSchemaNumUint, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "LocalStateSchemaNumUint")
					return
				}
			case "u":
				(*z).LocalStateSchemaNumByteSlice, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "LocalStateSchemaNumByteSlice")
					return
				}
			case "v":
				(*z).GlobalStateSchemaNumUint, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "GlobalStateSchemaNumUint")
					return
				}
			case "w":
				(*z).GlobalStateSchemaNumByteSlice, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "GlobalStateSchemaNumByteSlice")
					return
				}
			case "x":
				(*z).ExtraProgramPages, bts, err = msgp.ReadUint32Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "ExtraProgramPages")
					return
				}
			case "y":
				{
					var zb0009 uint8
					zb0009, bts, err = msgp.ReadUint8Bytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "ResourceFlags")
						return
					}
					(*z).ResourceFlags = ResourceFlags(zb0009)
				}
			case "z":
				(*z).UpdateRound, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "UpdateRound")
					return
				}
			case "A":
				(*z).Version, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Version")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *ResourcesData) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *ResourcesData) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*ResourcesData)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *ResourcesData) Msgsize() (s int) {
	s = 3 + 2 + msgp.Uint64Size + 2 + msgp.Uint32Size + 2 + msgp.BoolSize + 2 + msgp.StringPrefixSize + len((*z).UnitName) + 2 + msgp.StringPrefixSize + len((*z).AssetName) + 2 + msgp.StringPrefixSize + len((*z).URL) + 2 + msgp.ArrayHeaderSize + (32 * (msgp.ByteSize)) + 2 + (*z).Manager.Msgsize() + 2 + (*z).Reserve.Msgsize() + 2 + (*z).Freeze.Msgsize() + 2 + (*z).Clawback.Msgsize() + 2 + msgp.Uint64Size + 2 + msgp.BoolSize + 2 + msgp.Uint64Size + 2 + msgp.Uint64Size + 2 + (*z).KeyValue.Msgsize() + 2 + msgp.BytesPrefixSize + len((*z).ApprovalProgram) + 2 + msgp.BytesPrefixSize + len((*z).ClearStateProgram) + 2 + (*z).GlobalState.Msgsize() + 2 + msgp.Uint64Size + 2 + msgp.Uint64Size + 2 + msgp.Uint64Size + 2 + msgp.Uint64Size + 2 + msgp.Uint32Size + 2 + msgp.Uint8Size + 2 + msgp.Uint64Size + 2 + msgp.Uint64Size
	return
}

// MsgIsZero returns whether this is a zero value
func (z *ResourcesData) MsgIsZero() bool {
	return ((*z).Total == 0) && ((*z).Decimals == 0) && ((*z).DefaultFrozen == false) && ((*z).UnitName == "") && ((*z).AssetName == "") && ((*z).URL == "") && ((*z).MetadataHash == ([32]byte{})) && ((*z).Manager.MsgIsZero()) && ((*z).Reserve.MsgIsZero()) && ((*z).Freeze.MsgIsZero()) && ((*z).Clawback.MsgIsZero()) && ((*z).Amount == 0) && ((*z).Frozen == false) && ((*z).SchemaNumUint == 0) && ((*z).SchemaNumByteSlice == 0) && ((*z).KeyValue.MsgIsZero()) && (len((*z).ApprovalProgram) == 0) && (len((*z).ClearStateProgram) == 0) && ((*z).GlobalState.MsgIsZero()) && ((*z).LocalStateSchemaNumUint == 0) && ((*z).LocalStateSchemaNumByteSlice == 0) && ((*z).GlobalStateSchemaNumUint == 0) && ((*z).GlobalStateSchemaNumByteSlice == 0) && ((*z).ExtraProgramPages == 0) && ((*z).ResourceFlags == 0) && ((*z).UpdateRound == 0) && ((*z).Version == 0)
}

// MaxSize returns a maximum valid message size for this message type
func ResourcesDataMaxSize() (s int) {
	s = 3 + 2 + msgp.Uint64Size + 2 + msgp.Uint32Size + 2 + msgp.BoolSize + 2
	panic("Unable to determine max size: String type z.UnitName is unbounded")
	s += 2
	panic("Unable to determine max size: String type z.AssetName is unbounded")
	s += 2
	panic("Unable to determine max size: String type z.URL is unbounded")
	s += 2
	// Calculating size of array: z.MetadataHash
	s += msgp.ArrayHeaderSize + ((32) * (msgp.ByteSize))
	s += 2 + basics.AddressMaxSize() + 2 + basics.AddressMaxSize() + 2 + basics.AddressMaxSize() + 2 + basics.AddressMaxSize() + 2 + msgp.Uint64Size + 2 + msgp.BoolSize + 2 + msgp.Uint64Size + 2 + msgp.Uint64Size + 2 + basics.TealKeyValueMaxSize() + 2 + msgp.BytesPrefixSize + config.MaxAvailableAppProgramLen + 2 + msgp.BytesPrefixSize + config.MaxAvailableAppProgramLen + 2 + basics.TealKeyValueMaxSize() + 2 + msgp.Uint64Size + 2 + msgp.Uint64Size + 2 + msgp.Uint64Size + 2 + msgp.Uint64Size + 2 + msgp.Uint32Size + 2 + msgp.Uint8Size + 2 + msgp.Uint64Size + 2 + msgp.Uint64Size
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *TxTailRound) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0004Len := uint32(4)
	var zb0004Mask uint8 /* 5 bits */
	if (*z).Hdr.MsgIsZero() {
		zb0004Len--
		zb0004Mask |= 0x2
	}
	if len((*z).TxnIDs) == 0 {
		zb0004Len--
		zb0004Mask |= 0x4
	}
	if len((*z).Leases) == 0 {
		zb0004Len--
		zb0004Mask |= 0x8
	}
	if len((*z).LastValid) == 0 {
		zb0004Len--
		zb0004Mask |= 0x10
	}
	// variable map header, size zb0004Len
	o = append(o, 0x80|uint8(zb0004Len))
	if zb0004Len != 0 {
		if (zb0004Mask & 0x2) == 0 { // if not empty
			// string "h"
			o = append(o, 0xa1, 0x68)
			o = (*z).Hdr.MarshalMsg(o)
		}
		if (zb0004Mask & 0x4) == 0 { // if not empty
			// string "i"
			o = append(o, 0xa1, 0x69)
			if (*z).TxnIDs == nil {
				o = msgp.AppendNil(o)
			} else {
				o = msgp.AppendArrayHeader(o, uint32(len((*z).TxnIDs)))
			}
			for zb0001 := range (*z).TxnIDs {
				o = (*z).TxnIDs[zb0001].MarshalMsg(o)
			}
		}
		if (zb0004Mask & 0x8) == 0 { // if not empty
			// string "l"
			o = append(o, 0xa1, 0x6c)
			if (*z).Leases == nil {
				o = msgp.AppendNil(o)
			} else {
				o = msgp.AppendArrayHeader(o, uint32(len((*z).Leases)))
			}
			for zb0003 := range (*z).Leases {
				o = (*z).Leases[zb0003].MarshalMsg(o)
			}
		}
		if (zb0004Mask & 0x10) == 0 { // if not empty
			// string "v"
			o = append(o, 0xa1, 0x76)
			if (*z).LastValid == nil {
				o = msgp.AppendNil(o)
			} else {
				o = msgp.AppendArrayHeader(o, uint32(len((*z).LastValid)))
			}
			for zb0002 := range (*z).LastValid {
				o = (*z).LastValid[zb0002].MarshalMsg(o)
			}
		}
	}
	return
}

func (_ *TxTailRound) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*TxTailRound)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *TxTailRound) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0004 int
	var zb0005 bool
	zb0004, zb0005, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0004, zb0005, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0004 > 0 {
			zb0004--
			var zb0006 int
			var zb0007 bool
			zb0006, zb0007, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "TxnIDs")
				return
			}
			if zb0007 {
				(*z).TxnIDs = nil
			} else if (*z).TxnIDs != nil && cap((*z).TxnIDs) >= zb0006 {
				(*z).TxnIDs = ((*z).TxnIDs)[:zb0006]
			} else {
				(*z).TxnIDs = make([]transactions.Txid, zb0006)
			}
			for zb0001 := range (*z).TxnIDs {
				bts, err = (*z).TxnIDs[zb0001].UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "TxnIDs", zb0001)
					return
				}
			}
		}
		if zb0004 > 0 {
			zb0004--
			var zb0008 int
			var zb0009 bool
			zb0008, zb0009, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "LastValid")
				return
			}
			if zb0009 {
				(*z).LastValid = nil
			} else if (*z).LastValid != nil && cap((*z).LastValid) >= zb0008 {
				(*z).LastValid = ((*z).LastValid)[:zb0008]
			} else {
				(*z).LastValid = make([]basics.Round, zb0008)
			}
			for zb0002 := range (*z).LastValid {
				bts, err = (*z).LastValid[zb0002].UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "LastValid", zb0002)
					return
				}
			}
		}
		if zb0004 > 0 {
			zb0004--
			var zb0010 int
			var zb0011 bool
			zb0010, zb0011, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Leases")
				return
			}
			if zb0011 {
				(*z).Leases = nil
			} else if (*z).Leases != nil && cap((*z).Leases) >= zb0010 {
				(*z).Leases = ((*z).Leases)[:zb0010]
			} else {
				(*z).Leases = make([]TxTailRoundLease, zb0010)
			}
			for zb0003 := range (*z).Leases {
				bts, err = (*z).Leases[zb0003].UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Leases", zb0003)
					return
				}
			}
		}
		if zb0004 > 0 {
			zb0004--
			bts, err = (*z).Hdr.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Hdr")
				return
			}
		}
		if zb0004 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0004)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0005 {
			(*z) = TxTailRound{}
		}
		for zb0004 > 0 {
			zb0004--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "i":
				var zb0012 int
				var zb0013 bool
				zb0012, zb0013, bts, err = msgp.ReadArrayHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "TxnIDs")
					return
				}
				if zb0013 {
					(*z).TxnIDs = nil
				} else if (*z).TxnIDs != nil && cap((*z).TxnIDs) >= zb0012 {
					(*z).TxnIDs = ((*z).TxnIDs)[:zb0012]
				} else {
					(*z).TxnIDs = make([]transactions.Txid, zb0012)
				}
				for zb0001 := range (*z).TxnIDs {
					bts, err = (*z).TxnIDs[zb0001].UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "TxnIDs", zb0001)
						return
					}
				}
			case "v":
				var zb0014 int
				var zb0015 bool
				zb0014, zb0015, bts, err = msgp.ReadArrayHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "LastValid")
					return
				}
				if zb0015 {
					(*z).LastValid = nil
				} else if (*z).LastValid != nil && cap((*z).LastValid) >= zb0014 {
					(*z).LastValid = ((*z).LastValid)[:zb0014]
				} else {
					(*z).LastValid = make([]basics.Round, zb0014)
				}
				for zb0002 := range (*z).LastValid {
					bts, err = (*z).LastValid[zb0002].UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "LastValid", zb0002)
						return
					}
				}
			case "l":
				var zb0016 int
				var zb0017 bool
				zb0016, zb0017, bts, err = msgp.ReadArrayHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Leases")
					return
				}
				if zb0017 {
					(*z).Leases = nil
				} else if (*z).Leases != nil && cap((*z).Leases) >= zb0016 {
					(*z).Leases = ((*z).Leases)[:zb0016]
				} else {
					(*z).Leases = make([]TxTailRoundLease, zb0016)
				}
				for zb0003 := range (*z).Leases {
					bts, err = (*z).Leases[zb0003].UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "Leases", zb0003)
						return
					}
				}
			case "h":
				bts, err = (*z).Hdr.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Hdr")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *TxTailRound) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *TxTailRound) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*TxTailRound)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *TxTailRound) Msgsize() (s int) {
	s = 1 + 2 + msgp.ArrayHeaderSize
	for zb0001 := range (*z).TxnIDs {
		s += (*z).TxnIDs[zb0001].Msgsize()
	}
	s += 2 + msgp.ArrayHeaderSize
	for zb0002 := range (*z).LastValid {
		s += (*z).LastValid[zb0002].Msgsize()
	}
	s += 2 + msgp.ArrayHeaderSize
	for zb0003 := range (*z).Leases {
		s += (*z).Leases[zb0003].Msgsize()
	}
	s += 2 + (*z).Hdr.Msgsize()
	return
}

// MsgIsZero returns whether this is a zero value
func (z *TxTailRound) MsgIsZero() bool {
	return (len((*z).TxnIDs) == 0) && (len((*z).LastValid) == 0) && (len((*z).Leases) == 0) && ((*z).Hdr.MsgIsZero())
}

// MaxSize returns a maximum valid message size for this message type
func TxTailRoundMaxSize() (s int) {
	s = 1 + 2
	// Calculating size of slice: z.TxnIDs
	panic("Slice z.TxnIDs is unbounded")
	s += 2
	// Calculating size of slice: z.LastValid
	panic("Slice z.LastValid is unbounded")
	s += 2
	// Calculating size of slice: z.Leases
	panic("Slice z.Leases is unbounded")
	s += 2 + bookkeeping.BlockHeaderMaxSize()
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *TxTailRoundLease) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0002Len := uint32(3)
	var zb0002Mask uint8 /* 4 bits */
	if (*z).TxnIdx == 0 {
		zb0002Len--
		zb0002Mask |= 0x1
	}
	if (*z).Lease == ([32]byte{}) {
		zb0002Len--
		zb0002Mask |= 0x4
	}
	if (*z).Sender.MsgIsZero() {
		zb0002Len--
		zb0002Mask |= 0x8
	}
	// variable map header, size zb0002Len
	o = append(o, 0x80|uint8(zb0002Len))
	if zb0002Len != 0 {
		if (zb0002Mask & 0x1) == 0 { // if not empty
			// string "TxnIdx"
			o = append(o, 0xa6, 0x54, 0x78, 0x6e, 0x49, 0x64, 0x78)
			o = msgp.AppendUint64(o, (*z).TxnIdx)
		}
		if (zb0002Mask & 0x4) == 0 { // if not empty
			// string "l"
			o = append(o, 0xa1, 0x6c)
			o = msgp.AppendBytes(o, ((*z).Lease)[:])
		}
		if (zb0002Mask & 0x8) == 0 { // if not empty
			// string "s"
			o = append(o, 0xa1, 0x73)
			o = (*z).Sender.MarshalMsg(o)
		}
	}
	return
}

func (_ *TxTailRoundLease) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*TxTailRoundLease)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *TxTailRoundLease) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0002 int
	var zb0003 bool
	zb0002, zb0003, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0002, zb0003, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 > 0 {
			zb0002--
			bts, err = (*z).Sender.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Sender")
				return
			}
		}
		if zb0002 > 0 {
			zb0002--
			bts, err = msgp.ReadExactBytes(bts, ((*z).Lease)[:])
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Lease")
				return
			}
		}
		if zb0002 > 0 {
			zb0002--
			(*z).TxnIdx, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "TxnIdx")
				return
			}
		}
		if zb0002 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0002)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0003 {
			(*z) = TxTailRoundLease{}
		}
		for zb0002 > 0 {
			zb0002--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "s":
				bts, err = (*z).Sender.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Sender")
					return
				}
			case "l":
				bts, err = msgp.ReadExactBytes(bts, ((*z).Lease)[:])
				if err != nil {
					err = msgp.WrapError(err, "Lease")
					return
				}
			case "TxnIdx":
				(*z).TxnIdx, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "TxnIdx")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *TxTailRoundLease) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *TxTailRoundLease) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*TxTailRoundLease)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *TxTailRoundLease) Msgsize() (s int) {
	s = 1 + 2 + (*z).Sender.Msgsize() + 2 + msgp.ArrayHeaderSize + (32 * (msgp.ByteSize)) + 7 + msgp.Uint64Size
	return
}

// MsgIsZero returns whether this is a zero value
func (z *TxTailRoundLease) MsgIsZero() bool {
	return ((*z).Sender.MsgIsZero()) && ((*z).Lease == ([32]byte{})) && ((*z).TxnIdx == 0)
}

// MaxSize returns a maximum valid message size for this message type
func TxTailRoundLeaseMaxSize() (s int) {
	s = 1 + 2 + basics.AddressMaxSize() + 2
	// Calculating size of array: z.Lease
	s += msgp.ArrayHeaderSize + ((32) * (msgp.ByteSize))
	s += 7 + msgp.Uint64Size
	return
}
