# Agreement Service

The Algorand Agreement Service manages the consensus protocol and is composed of the following components. Detailed implementation notes are in the [agreement README](../agreement/README.md).

The agreement service learns what blocks the community has reached consensus on and writes them to the ledger. When your account is called upon to propose a block or serve on a committee, the agreement service handles that too. Other parts of the `agreement` package deal with related issues -- asking the network for blocks we're missing (and helping peers who are missing blocks), generally figuring out how to handle incoming messages from the network, etc. Most of the complicated logic lives in this package (along with most of the subtle concurrency issues). Reading the Algorand SOSP paper before diving into this package will be super helpful for understanding what's going on.

## Dispatcher

The dispatcher provides an interface between the Agreement Service components and the Algorand Network.  Incoming messages are distributed between the Vote Manager and Proposal Manager.  Outgoing Votes and Proposals generated by the Consensus State Machine are passed through the Dispatcher. 

## Consensus State Machine

The Consensus State Machine manages the Rounds, Periods, and Steps of the Algorand Consensus Protocol.  

## Vote Manager

The Vote Manager is responsible for processing Votes received from Algorand peer nodes.  Votes are sorted and collected based on their Round, Period, Vote Type, and Proposal.  The Vote Manager will filter stale Votes from past Rounds and Periods.  The Vote Manager also detects equivocation votes and applies the associated weights to all proposals within the same Round, Period, and Vote Type.  The Vote Manager tallies votes based and sends alerts when a particular Round, Period, Vote Type, and Proposal reaches a quorum.   

## Proposal Manager

The Proposal Manager receives and processes incoming Proposals.  For a given Round and Period, the Proposal Manager will select the best Proposal and Leader.  

## CryptoVerifier

Performs expensive crypto verification functions asynchronously.  The Crypto Verifier is used to construct and validate certificates and signatures.

## Ledger

The Ledger manages the Blocks that make up the blockchain.  New Blocks can be added, and existing Blocks can also be looked up and returned. The Ledger is distributed.  All nodes within the Algorand Network manage a copy of the Ledger.  Blocks contain a Block Header and a set of transactions.  A Transaction Pool is used to stage transactions for inclusion into Blocks.  Transactions are fairly included into Blocks based on the Transaction creation time and the associated Fee.  Transactions are processed on a first come first serve basis with priority given to transactions with higher transaction fees.  

## Balance Tree

The Balance Tree is used to manage Account balances and is separate from the Ledger.  The Balance Tree is a map of accounts with their corresponding balances.  

## Terminology 
The following is a short summary of terminology. 

## Block

A Block contains a set of Transactions.  Blocks include the hash of the previous block to link the blocks together.  Blocks also contain a block header.  

## Seed

A Seed is used as input to cryptographic functions to deterministically randomize the result. In the consensus protocol, a Seed is used to randomize committee selection, where the Seed is the header of a previously generated Block.  

## Transaction

Transactions describe the transfer of value from one account to another.  The transaction includes the from account, to account, amount, fee, and an optional noteField.  Another type of transaction is used for Account Key registration.  

## Account

Accounts are used to manage Algos, a unit of value, within the Algorand system.  Accounts include an address which uniquely identifies the Account and a balance which specifies the account value in Algos.  Accounts also contain asymmetric keys which are used by the Account to submit Transactions and participate in the Consensus Protocol.  There are three types of Keys: Spending Keys, Participation Keys, and Ephemeral Keys.

### Spending Key

The Account’s Spending Key is used to sign transactions issued by the Account.  The Spending Key is also used to sign transactions that register generated Participation Keys and Ephemeral Keys.

### Participation Keys

Participation Keys (also called VRF keys) are used to generate Credentials.  Credentials determine if the account is part of the committee for a given Round, Period and Step. Credentials specify the weight for the associated Account, where a non zero weight indicates that the Account is on the committee. Participation Keys are generated randomly and registered to an account using the Account’s Spending Key, and are regenerated after a specified set of Rounds. 

### Ephemeral Keys

Ephemeral Keys, also known as Signing Keys, are used to sign messages (e.g. Votes, Proposals).  Ephemeral Keys are generated per Round -- the idea is that if a node is compromised, the adversary can’t maliciously sign old votes for bad blocks because the key for that round will already be erased. Each round’s ephemeral key is signed by a longer-term key that is signed by a “master ephemeral key”. The master ephemeral key is registered to the account in a key registration transaction signed by the spending key. This two-level tree structure means we don’t need to generate millions of keys in advance, only thousands. Eventually, to improve security, new Ephemeral Keys may be generated for each Step.

## Wallet

Wallets contain a set of Accounts and provide a means for users to manage one or more Accounts.  Wallets also provide key management for the contained Accounts.

## User

End Users who manage Wallets and Accounts. 

## Round

A Round defines the top level cycle of the Algorand consensus protocol.  Completing a Round results in the addition of a Block of Transactions to the Ledger.  Rounds are composed of one or more Periods.  Each Round is assigned a monotonically increasing number to identify the Round, which is also assigned to the Block produced by the Round.

## Period

A Period is a cycle within a Round. One or more Periods will be processed until the parent Round completes by reaching consensus and produces a Block.  A Period is composed of multiple Steps. Within a Round, Periods are assigned monotonically increasing number starting with 0 for the first Period within the Round.  

## Step

Steps are discrete units of logic that define each of the states of the state machine for the Algorand Consensus protocol.  There are 5 separate Steps, each Step helps move closer to reaching consensus for the next Block among the Algorand participants.  Some Steps require a period of time to pass prior to moving to the next Step.   Steps 4 and 5 will repeat with increasing timeouts until a consensus is reached for the current Period.  Consensus may be to certify a Proposal and start a new Round or to abandon the current Period and start a new Period.  

## Committee

A Committee is a set of participants selected from the Algorand network.  A new Committee is selected for each Step using cryptographic sortition implemented using a Verifiable Random Function (VRF).  Within a Step, only Committee members are permitted to submit Votes or Proposals.

## Proposer

A member of the Committee for the first Step of each Period.

## Credential

A value generated by each participant for each Step using the VRF.  A participant uses its Credential to determine whether it is on the Committee for a Step and compares the Credentials of the Proposers to determine a Leader.

## Leader

The Leader is the Proposer with the best Credential (lowest VRF value), selected by each participant from the Proposals it received in a given Period.  A participant votes to support the Proposal of its selected Leader.  For a given Period, the Leader is determined by who has the lowest VRF value, and who reaches soft vote quorum first.

## Proposal

Proposals for the next Block are submitted by Committee members (potential Leaders) in Step 1 of the Consensus Protocol.

## Vote

Votes are submitted by participating Committee members.  Votes are weighted based on the stake of the associated Account.  The stake is determined based on the Account’s balance in a previous and recent Round.

### Next Vote

Next Votes are submitted by Committee members to indicate that the current Period has not been able to reach consensus and a new Period should be started.  There are 2 types of Next Votes:

- Start a new Period with the Proposal from the current Period.  
- Start a new Period with no Proposal (aka as Bottom Vote)

### Soft Vote

Soft Votes are submitted by Committee members to choose a Leader and Proposal for the Period.

### Cert Vote

Cert Votes are submitted by Committee members when a quorum of Soft Votes has been received and the associated Block has been received and verified.  Verification includes validating each of the included transactions.  

### Equivocation Vote

An Equivocation Vote is created when 2 or more different Proposals are received from the same Committee member for a given Round and Period.  Equivocation Votes count as wild card votes for all Proposals received for a Round and Period, the associated weight for the Equivocation Vote is applied equally across all proposals for the Round, Period, and Vote type. 

If an Account votes for 2 or more different Proposals, this is considered malicious behavior. The weighted Vote of the associated Account is applied to all Proposals to allow reaching quorum in the face to malicious users.  Only 2 proposals are saved to avoid a possible Denial of Service (DoS) attack. 

### Vote Bundle 

A Vote Bundle is a set of votes used to prove that a Proposal has a quorum of Votes.  A Vote Bundle includes both Votes and Equivocation Votes.  A quorum is a subset of Votes with sufficient weight that reaches the required threshold. 
