package bookkeeping

// Code generated by github.com/algorand/msgp DO NOT EDIT.

import (
	"sort"

	"github.com/algorand/msgp/msgp"

	"github.com/algorand/go-algorand/config"
	"github.com/algorand/go-algorand/crypto"
	"github.com/algorand/go-algorand/crypto/merklesignature"
	"github.com/algorand/go-algorand/data/basics"
	"github.com/algorand/go-algorand/data/committee"
	"github.com/algorand/go-algorand/protocol"
)

// The following msgp objects are implemented in this file:
// Block
//   |-----> (*) MarshalMsg
//   |-----> (*) CanMarshalMsg
//   |-----> (*) UnmarshalMsg
//   |-----> (*) UnmarshalMsgWithState
//   |-----> (*) CanUnmarshalMsg
//   |-----> (*) Msgsize
//   |-----> (*) MsgIsZero
//   |-----> BlockMaxSize()
//
// BlockHash
//     |-----> (*) MarshalMsg
//     |-----> (*) CanMarshalMsg
//     |-----> (*) UnmarshalMsg
//     |-----> (*) UnmarshalMsgWithState
//     |-----> (*) CanUnmarshalMsg
//     |-----> (*) Msgsize
//     |-----> (*) MsgIsZero
//
// BlockHeader
//      |-----> (*) MarshalMsg
//      |-----> (*) CanMarshalMsg
//      |-----> (*) UnmarshalMsg
//      |-----> (*) UnmarshalMsgWithState
//      |-----> (*) CanUnmarshalMsg
//      |-----> (*) Msgsize
//      |-----> (*) MsgIsZero
//      |-----> BlockHeaderMaxSize()
//
// Genesis
//    |-----> (*) MarshalMsg
//    |-----> (*) CanMarshalMsg
//    |-----> (*) UnmarshalMsg
//    |-----> (*) UnmarshalMsgWithState
//    |-----> (*) CanUnmarshalMsg
//    |-----> (*) Msgsize
//    |-----> (*) MsgIsZero
//    |-----> GenesisMaxSize()
//
// GenesisAccountData
//          |-----> (*) MarshalMsg
//          |-----> (*) CanMarshalMsg
//          |-----> (*) UnmarshalMsg
//          |-----> (*) UnmarshalMsgWithState
//          |-----> (*) CanUnmarshalMsg
//          |-----> (*) Msgsize
//          |-----> (*) MsgIsZero
//          |-----> GenesisAccountDataMaxSize()
//
// GenesisAllocation
//         |-----> (*) MarshalMsg
//         |-----> (*) CanMarshalMsg
//         |-----> (*) UnmarshalMsg
//         |-----> (*) UnmarshalMsgWithState
//         |-----> (*) CanUnmarshalMsg
//         |-----> (*) Msgsize
//         |-----> (*) MsgIsZero
//         |-----> GenesisAllocationMaxSize()
//
// LightBlockHeader
//         |-----> (*) MarshalMsg
//         |-----> (*) CanMarshalMsg
//         |-----> (*) UnmarshalMsg
//         |-----> (*) UnmarshalMsgWithState
//         |-----> (*) CanUnmarshalMsg
//         |-----> (*) Msgsize
//         |-----> (*) MsgIsZero
//         |-----> LightBlockHeaderMaxSize()
//
// ParticipationUpdates
//           |-----> (*) MarshalMsg
//           |-----> (*) CanMarshalMsg
//           |-----> (*) UnmarshalMsg
//           |-----> (*) UnmarshalMsgWithState
//           |-----> (*) CanUnmarshalMsg
//           |-----> (*) Msgsize
//           |-----> (*) MsgIsZero
//           |-----> ParticipationUpdatesMaxSize()
//
// RewardsState
//       |-----> (*) MarshalMsg
//       |-----> (*) CanMarshalMsg
//       |-----> (*) UnmarshalMsg
//       |-----> (*) UnmarshalMsgWithState
//       |-----> (*) CanUnmarshalMsg
//       |-----> (*) Msgsize
//       |-----> (*) MsgIsZero
//       |-----> RewardsStateMaxSize()
//
// StateProofTrackingData
//            |-----> (*) MarshalMsg
//            |-----> (*) CanMarshalMsg
//            |-----> (*) UnmarshalMsg
//            |-----> (*) UnmarshalMsgWithState
//            |-----> (*) CanUnmarshalMsg
//            |-----> (*) Msgsize
//            |-----> (*) MsgIsZero
//            |-----> StateProofTrackingDataMaxSize()
//
// TxnCommitments
//        |-----> (*) MarshalMsg
//        |-----> (*) CanMarshalMsg
//        |-----> (*) UnmarshalMsg
//        |-----> (*) UnmarshalMsgWithState
//        |-----> (*) CanUnmarshalMsg
//        |-----> (*) Msgsize
//        |-----> (*) MsgIsZero
//        |-----> TxnCommitmentsMaxSize()
//
// UpgradeVote
//      |-----> (*) MarshalMsg
//      |-----> (*) CanMarshalMsg
//      |-----> (*) UnmarshalMsg
//      |-----> (*) UnmarshalMsgWithState
//      |-----> (*) CanUnmarshalMsg
//      |-----> (*) Msgsize
//      |-----> (*) MsgIsZero
//      |-----> UpgradeVoteMaxSize()
//
// crypto.Digest
//       |-----> crypto.DigestMaxSize()
//

// MarshalMsg implements msgp.Marshaler
func (z *Block) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0005Len := uint32(31)
	var zb0005Mask uint64 /* 36 bits */
	if (*z).BlockHeader.Bonus.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x20
	}
	if (*z).BlockHeader.RewardsState.RewardsLevel == 0 {
		zb0005Len--
		zb0005Mask |= 0x40
	}
	if (*z).BlockHeader.FeesCollected.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x80
	}
	if (*z).BlockHeader.RewardsState.FeeSink.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x100
	}
	if (*z).BlockHeader.RewardsState.RewardsResidue == 0 {
		zb0005Len--
		zb0005Mask |= 0x200
	}
	if (*z).BlockHeader.GenesisID == "" {
		zb0005Len--
		zb0005Mask |= 0x400
	}
	if (*z).BlockHeader.GenesisHash.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x800
	}
	if (*z).BlockHeader.UpgradeState.NextProtocolVoteBefore.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x1000
	}
	if (*z).BlockHeader.UpgradeState.NextProtocol.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x2000
	}
	if (*z).BlockHeader.UpgradeState.NextProtocolSwitchOn.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x4000
	}
	if (*z).BlockHeader.UpgradeState.NextProtocolApprovals == 0 {
		zb0005Len--
		zb0005Mask |= 0x8000
	}
	if len((*z).BlockHeader.ParticipationUpdates.AbsentParticipationAccounts) == 0 {
		zb0005Len--
		zb0005Mask |= 0x10000
	}
	if len((*z).BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts) == 0 {
		zb0005Len--
		zb0005Mask |= 0x20000
	}
	if (*z).BlockHeader.ProposerPayout.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x40000
	}
	if (*z).BlockHeader.Branch.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x80000
	}
	if (*z).BlockHeader.UpgradeState.CurrentProtocol.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x100000
	}
	if (*z).BlockHeader.Proposer.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x200000
	}
	if (*z).BlockHeader.RewardsState.RewardsRate == 0 {
		zb0005Len--
		zb0005Mask |= 0x400000
	}
	if (*z).BlockHeader.Round.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x800000
	}
	if (*z).BlockHeader.RewardsState.RewardsRecalculationRound.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x1000000
	}
	if (*z).BlockHeader.RewardsState.RewardsPool.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x2000000
	}
	if (*z).BlockHeader.Seed.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x4000000
	}
	if len((*z).BlockHeader.StateProofTracking) == 0 {
		zb0005Len--
		zb0005Mask |= 0x8000000
	}
	if (*z).BlockHeader.TxnCounter == 0 {
		zb0005Len--
		zb0005Mask |= 0x10000000
	}
	if (*z).BlockHeader.TimeStamp == 0 {
		zb0005Len--
		zb0005Mask |= 0x20000000
	}
	if (*z).BlockHeader.TxnCommitments.NativeSha512_256Commitment.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x40000000
	}
	if (*z).BlockHeader.TxnCommitments.Sha256Commitment.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x80000000
	}
	if (*z).Payset.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x100000000
	}
	if (*z).BlockHeader.UpgradeVote.UpgradeDelay.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x200000000
	}
	if (*z).BlockHeader.UpgradeVote.UpgradePropose.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x400000000
	}
	if (*z).BlockHeader.UpgradeVote.UpgradeApprove == false {
		zb0005Len--
		zb0005Mask |= 0x800000000
	}
	// variable map header, size zb0005Len
	o = msgp.AppendMapHeader(o, zb0005Len)
	if zb0005Len != 0 {
		if (zb0005Mask & 0x20) == 0 { // if not empty
			// string "bi"
			o = append(o, 0xa2, 0x62, 0x69)
			o = (*z).BlockHeader.Bonus.MarshalMsg(o)
		}
		if (zb0005Mask & 0x40) == 0 { // if not empty
			// string "earn"
			o = append(o, 0xa4, 0x65, 0x61, 0x72, 0x6e)
			o = msgp.AppendUint64(o, (*z).BlockHeader.RewardsState.RewardsLevel)
		}
		if (zb0005Mask & 0x80) == 0 { // if not empty
			// string "fc"
			o = append(o, 0xa2, 0x66, 0x63)
			o = (*z).BlockHeader.FeesCollected.MarshalMsg(o)
		}
		if (zb0005Mask & 0x100) == 0 { // if not empty
			// string "fees"
			o = append(o, 0xa4, 0x66, 0x65, 0x65, 0x73)
			o = (*z).BlockHeader.RewardsState.FeeSink.MarshalMsg(o)
		}
		if (zb0005Mask & 0x200) == 0 { // if not empty
			// string "frac"
			o = append(o, 0xa4, 0x66, 0x72, 0x61, 0x63)
			o = msgp.AppendUint64(o, (*z).BlockHeader.RewardsState.RewardsResidue)
		}
		if (zb0005Mask & 0x400) == 0 { // if not empty
			// string "gen"
			o = append(o, 0xa3, 0x67, 0x65, 0x6e)
			o = msgp.AppendString(o, (*z).BlockHeader.GenesisID)
		}
		if (zb0005Mask & 0x800) == 0 { // if not empty
			// string "gh"
			o = append(o, 0xa2, 0x67, 0x68)
			o = (*z).BlockHeader.GenesisHash.MarshalMsg(o)
		}
		if (zb0005Mask & 0x1000) == 0 { // if not empty
			// string "nextbefore"
			o = append(o, 0xaa, 0x6e, 0x65, 0x78, 0x74, 0x62, 0x65, 0x66, 0x6f, 0x72, 0x65)
			o = (*z).BlockHeader.UpgradeState.NextProtocolVoteBefore.MarshalMsg(o)
		}
		if (zb0005Mask & 0x2000) == 0 { // if not empty
			// string "nextproto"
			o = append(o, 0xa9, 0x6e, 0x65, 0x78, 0x74, 0x70, 0x72, 0x6f, 0x74, 0x6f)
			o = (*z).BlockHeader.UpgradeState.NextProtocol.MarshalMsg(o)
		}
		if (zb0005Mask & 0x4000) == 0 { // if not empty
			// string "nextswitch"
			o = append(o, 0xaa, 0x6e, 0x65, 0x78, 0x74, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68)
			o = (*z).BlockHeader.UpgradeState.NextProtocolSwitchOn.MarshalMsg(o)
		}
		if (zb0005Mask & 0x8000) == 0 { // if not empty
			// string "nextyes"
			o = append(o, 0xa7, 0x6e, 0x65, 0x78, 0x74, 0x79, 0x65, 0x73)
			o = msgp.AppendUint64(o, (*z).BlockHeader.UpgradeState.NextProtocolApprovals)
		}
		if (zb0005Mask & 0x10000) == 0 { // if not empty
			// string "partupdabs"
			o = append(o, 0xaa, 0x70, 0x61, 0x72, 0x74, 0x75, 0x70, 0x64, 0x61, 0x62, 0x73)
			if (*z).BlockHeader.ParticipationUpdates.AbsentParticipationAccounts == nil {
				o = msgp.AppendNil(o)
			} else {
				o = msgp.AppendArrayHeader(o, uint32(len((*z).BlockHeader.ParticipationUpdates.AbsentParticipationAccounts)))
			}
			for zb0004 := range (*z).BlockHeader.ParticipationUpdates.AbsentParticipationAccounts {
				o = (*z).BlockHeader.ParticipationUpdates.AbsentParticipationAccounts[zb0004].MarshalMsg(o)
			}
		}
		if (zb0005Mask & 0x20000) == 0 { // if not empty
			// string "partupdrmv"
			o = append(o, 0xaa, 0x70, 0x61, 0x72, 0x74, 0x75, 0x70, 0x64, 0x72, 0x6d, 0x76)
			if (*z).BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts == nil {
				o = msgp.AppendNil(o)
			} else {
				o = msgp.AppendArrayHeader(o, uint32(len((*z).BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts)))
			}
			for zb0003 := range (*z).BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts {
				o = (*z).BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts[zb0003].MarshalMsg(o)
			}
		}
		if (zb0005Mask & 0x40000) == 0 { // if not empty
			// string "pp"
			o = append(o, 0xa2, 0x70, 0x70)
			o = (*z).BlockHeader.ProposerPayout.MarshalMsg(o)
		}
		if (zb0005Mask & 0x80000) == 0 { // if not empty
			// string "prev"
			o = append(o, 0xa4, 0x70, 0x72, 0x65, 0x76)
			o = (*z).BlockHeader.Branch.MarshalMsg(o)
		}
		if (zb0005Mask & 0x100000) == 0 { // if not empty
			// string "proto"
			o = append(o, 0xa5, 0x70, 0x72, 0x6f, 0x74, 0x6f)
			o = (*z).BlockHeader.UpgradeState.CurrentProtocol.MarshalMsg(o)
		}
		if (zb0005Mask & 0x200000) == 0 { // if not empty
			// string "prp"
			o = append(o, 0xa3, 0x70, 0x72, 0x70)
			o = (*z).BlockHeader.Proposer.MarshalMsg(o)
		}
		if (zb0005Mask & 0x400000) == 0 { // if not empty
			// string "rate"
			o = append(o, 0xa4, 0x72, 0x61, 0x74, 0x65)
			o = msgp.AppendUint64(o, (*z).BlockHeader.RewardsState.RewardsRate)
		}
		if (zb0005Mask & 0x800000) == 0 { // if not empty
			// string "rnd"
			o = append(o, 0xa3, 0x72, 0x6e, 0x64)
			o = (*z).BlockHeader.Round.MarshalMsg(o)
		}
		if (zb0005Mask & 0x1000000) == 0 { // if not empty
			// string "rwcalr"
			o = append(o, 0xa6, 0x72, 0x77, 0x63, 0x61, 0x6c, 0x72)
			o = (*z).BlockHeader.RewardsState.RewardsRecalculationRound.MarshalMsg(o)
		}
		if (zb0005Mask & 0x2000000) == 0 { // if not empty
			// string "rwd"
			o = append(o, 0xa3, 0x72, 0x77, 0x64)
			o = (*z).BlockHeader.RewardsState.RewardsPool.MarshalMsg(o)
		}
		if (zb0005Mask & 0x4000000) == 0 { // if not empty
			// string "seed"
			o = append(o, 0xa4, 0x73, 0x65, 0x65, 0x64)
			o = (*z).BlockHeader.Seed.MarshalMsg(o)
		}
		if (zb0005Mask & 0x8000000) == 0 { // if not empty
			// string "spt"
			o = append(o, 0xa3, 0x73, 0x70, 0x74)
			if (*z).BlockHeader.StateProofTracking == nil {
				o = msgp.AppendNil(o)
			} else {
				o = msgp.AppendMapHeader(o, uint32(len((*z).BlockHeader.StateProofTracking)))
			}
			zb0001_keys := make([]protocol.StateProofType, 0, len((*z).BlockHeader.StateProofTracking))
			for zb0001 := range (*z).BlockHeader.StateProofTracking {
				zb0001_keys = append(zb0001_keys, zb0001)
			}
			sort.Sort(protocol.SortStateProofType(zb0001_keys))
			for _, zb0001 := range zb0001_keys {
				zb0002 := (*z).BlockHeader.StateProofTracking[zb0001]
				_ = zb0002
				o = zb0001.MarshalMsg(o)
				o = zb0002.MarshalMsg(o)
			}
		}
		if (zb0005Mask & 0x10000000) == 0 { // if not empty
			// string "tc"
			o = append(o, 0xa2, 0x74, 0x63)
			o = msgp.AppendUint64(o, (*z).BlockHeader.TxnCounter)
		}
		if (zb0005Mask & 0x20000000) == 0 { // if not empty
			// string "ts"
			o = append(o, 0xa2, 0x74, 0x73)
			o = msgp.AppendInt64(o, (*z).BlockHeader.TimeStamp)
		}
		if (zb0005Mask & 0x40000000) == 0 { // if not empty
			// string "txn"
			o = append(o, 0xa3, 0x74, 0x78, 0x6e)
			o = (*z).BlockHeader.TxnCommitments.NativeSha512_256Commitment.MarshalMsg(o)
		}
		if (zb0005Mask & 0x80000000) == 0 { // if not empty
			// string "txn256"
			o = append(o, 0xa6, 0x74, 0x78, 0x6e, 0x32, 0x35, 0x36)
			o = (*z).BlockHeader.TxnCommitments.Sha256Commitment.MarshalMsg(o)
		}
		if (zb0005Mask & 0x100000000) == 0 { // if not empty
			// string "txns"
			o = append(o, 0xa4, 0x74, 0x78, 0x6e, 0x73)
			o = (*z).Payset.MarshalMsg(o)
		}
		if (zb0005Mask & 0x200000000) == 0 { // if not empty
			// string "upgradedelay"
			o = append(o, 0xac, 0x75, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x64, 0x65, 0x6c, 0x61, 0x79)
			o = (*z).BlockHeader.UpgradeVote.UpgradeDelay.MarshalMsg(o)
		}
		if (zb0005Mask & 0x400000000) == 0 { // if not empty
			// string "upgradeprop"
			o = append(o, 0xab, 0x75, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x70, 0x72, 0x6f, 0x70)
			o = (*z).BlockHeader.UpgradeVote.UpgradePropose.MarshalMsg(o)
		}
		if (zb0005Mask & 0x800000000) == 0 { // if not empty
			// string "upgradeyes"
			o = append(o, 0xaa, 0x75, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x79, 0x65, 0x73)
			o = msgp.AppendBool(o, (*z).BlockHeader.UpgradeVote.UpgradeApprove)
		}
	}
	return
}

func (_ *Block) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*Block)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *Block) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0005 int
	var zb0006 bool
	zb0005, zb0006, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0005, zb0006, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).BlockHeader.Round.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Round")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).BlockHeader.Branch.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Branch")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).BlockHeader.Seed.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Seed")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).BlockHeader.TxnCommitments.NativeSha512_256Commitment.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "NativeSha512_256Commitment")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).BlockHeader.TxnCommitments.Sha256Commitment.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Sha256Commitment")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			(*z).BlockHeader.TimeStamp, bts, err = msgp.ReadInt64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "TimeStamp")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			var zb0007 int
			zb0007, err = msgp.ReadBytesBytesHeader(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "GenesisID")
				return
			}
			if zb0007 > config.MaxGenesisIDLen {
				err = msgp.ErrOverflow(uint64(zb0007), uint64(config.MaxGenesisIDLen))
				return
			}
			(*z).BlockHeader.GenesisID, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "GenesisID")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).BlockHeader.GenesisHash.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "GenesisHash")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).BlockHeader.Proposer.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Proposer")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).BlockHeader.FeesCollected.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "FeesCollected")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).BlockHeader.Bonus.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Bonus")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).BlockHeader.ProposerPayout.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "ProposerPayout")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).BlockHeader.RewardsState.FeeSink.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "FeeSink")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).BlockHeader.RewardsState.RewardsPool.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "RewardsPool")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			(*z).BlockHeader.RewardsState.RewardsLevel, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "RewardsLevel")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			(*z).BlockHeader.RewardsState.RewardsRate, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "RewardsRate")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			(*z).BlockHeader.RewardsState.RewardsResidue, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "RewardsResidue")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).BlockHeader.RewardsState.RewardsRecalculationRound.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "RewardsRecalculationRound")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).BlockHeader.UpgradeState.CurrentProtocol.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "CurrentProtocol")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).BlockHeader.UpgradeState.NextProtocol.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "NextProtocol")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			(*z).BlockHeader.UpgradeState.NextProtocolApprovals, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "NextProtocolApprovals")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).BlockHeader.UpgradeState.NextProtocolVoteBefore.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "NextProtocolVoteBefore")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).BlockHeader.UpgradeState.NextProtocolSwitchOn.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "NextProtocolSwitchOn")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).BlockHeader.UpgradeVote.UpgradePropose.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "UpgradePropose")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).BlockHeader.UpgradeVote.UpgradeDelay.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "UpgradeDelay")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			(*z).BlockHeader.UpgradeVote.UpgradeApprove, bts, err = msgp.ReadBoolBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "UpgradeApprove")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			(*z).BlockHeader.TxnCounter, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "TxnCounter")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			var zb0008 int
			var zb0009 bool
			zb0008, zb0009, bts, err = msgp.ReadMapHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "StateProofTracking")
				return
			}
			if zb0008 > protocol.NumStateProofTypes {
				err = msgp.ErrOverflow(uint64(zb0008), uint64(protocol.NumStateProofTypes))
				err = msgp.WrapError(err, "struct-from-array", "StateProofTracking")
				return
			}
			if zb0009 {
				(*z).BlockHeader.StateProofTracking = nil
			} else if (*z).BlockHeader.StateProofTracking == nil {
				(*z).BlockHeader.StateProofTracking = make(map[protocol.StateProofType]StateProofTrackingData, zb0008)
			}
			for zb0008 > 0 {
				var zb0001 protocol.StateProofType
				var zb0002 StateProofTrackingData
				zb0008--
				bts, err = zb0001.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "StateProofTracking")
					return
				}
				bts, err = zb0002.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "StateProofTracking", zb0001)
					return
				}
				(*z).BlockHeader.StateProofTracking[zb0001] = zb0002
			}
		}
		if zb0005 > 0 {
			zb0005--
			var zb0010 int
			var zb0011 bool
			zb0010, zb0011, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "ExpiredParticipationAccounts")
				return
			}
			if zb0010 > config.MaxProposedExpiredOnlineAccounts {
				err = msgp.ErrOverflow(uint64(zb0010), uint64(config.MaxProposedExpiredOnlineAccounts))
				err = msgp.WrapError(err, "struct-from-array", "ExpiredParticipationAccounts")
				return
			}
			if zb0011 {
				(*z).BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts = nil
			} else if (*z).BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts != nil && cap((*z).BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts) >= zb0010 {
				(*z).BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts = ((*z).BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts)[:zb0010]
			} else {
				(*z).BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts = make([]basics.Address, zb0010)
			}
			for zb0003 := range (*z).BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts {
				bts, err = (*z).BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts[zb0003].UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "ExpiredParticipationAccounts", zb0003)
					return
				}
			}
		}
		if zb0005 > 0 {
			zb0005--
			var zb0012 int
			var zb0013 bool
			zb0012, zb0013, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "AbsentParticipationAccounts")
				return
			}
			if zb0012 > config.MaxMarkAbsent {
				err = msgp.ErrOverflow(uint64(zb0012), uint64(config.MaxMarkAbsent))
				err = msgp.WrapError(err, "struct-from-array", "AbsentParticipationAccounts")
				return
			}
			if zb0013 {
				(*z).BlockHeader.ParticipationUpdates.AbsentParticipationAccounts = nil
			} else if (*z).BlockHeader.ParticipationUpdates.AbsentParticipationAccounts != nil && cap((*z).BlockHeader.ParticipationUpdates.AbsentParticipationAccounts) >= zb0012 {
				(*z).BlockHeader.ParticipationUpdates.AbsentParticipationAccounts = ((*z).BlockHeader.ParticipationUpdates.AbsentParticipationAccounts)[:zb0012]
			} else {
				(*z).BlockHeader.ParticipationUpdates.AbsentParticipationAccounts = make([]basics.Address, zb0012)
			}
			for zb0004 := range (*z).BlockHeader.ParticipationUpdates.AbsentParticipationAccounts {
				bts, err = (*z).BlockHeader.ParticipationUpdates.AbsentParticipationAccounts[zb0004].UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "AbsentParticipationAccounts", zb0004)
					return
				}
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).Payset.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Payset")
				return
			}
		}
		if zb0005 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0005)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0006 {
			(*z) = Block{}
		}
		for zb0005 > 0 {
			zb0005--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "rnd":
				bts, err = (*z).BlockHeader.Round.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Round")
					return
				}
			case "prev":
				bts, err = (*z).BlockHeader.Branch.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Branch")
					return
				}
			case "seed":
				bts, err = (*z).BlockHeader.Seed.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Seed")
					return
				}
			case "txn":
				bts, err = (*z).BlockHeader.TxnCommitments.NativeSha512_256Commitment.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "NativeSha512_256Commitment")
					return
				}
			case "txn256":
				bts, err = (*z).BlockHeader.TxnCommitments.Sha256Commitment.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Sha256Commitment")
					return
				}
			case "ts":
				(*z).BlockHeader.TimeStamp, bts, err = msgp.ReadInt64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "TimeStamp")
					return
				}
			case "gen":
				var zb0014 int
				zb0014, err = msgp.ReadBytesBytesHeader(bts)
				if err != nil {
					err = msgp.WrapError(err, "GenesisID")
					return
				}
				if zb0014 > config.MaxGenesisIDLen {
					err = msgp.ErrOverflow(uint64(zb0014), uint64(config.MaxGenesisIDLen))
					return
				}
				(*z).BlockHeader.GenesisID, bts, err = msgp.ReadStringBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "GenesisID")
					return
				}
			case "gh":
				bts, err = (*z).BlockHeader.GenesisHash.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "GenesisHash")
					return
				}
			case "prp":
				bts, err = (*z).BlockHeader.Proposer.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Proposer")
					return
				}
			case "fc":
				bts, err = (*z).BlockHeader.FeesCollected.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "FeesCollected")
					return
				}
			case "bi":
				bts, err = (*z).BlockHeader.Bonus.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Bonus")
					return
				}
			case "pp":
				bts, err = (*z).BlockHeader.ProposerPayout.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "ProposerPayout")
					return
				}
			case "fees":
				bts, err = (*z).BlockHeader.RewardsState.FeeSink.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "FeeSink")
					return
				}
			case "rwd":
				bts, err = (*z).BlockHeader.RewardsState.RewardsPool.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "RewardsPool")
					return
				}
			case "earn":
				(*z).BlockHeader.RewardsState.RewardsLevel, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "RewardsLevel")
					return
				}
			case "rate":
				(*z).BlockHeader.RewardsState.RewardsRate, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "RewardsRate")
					return
				}
			case "frac":
				(*z).BlockHeader.RewardsState.RewardsResidue, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "RewardsResidue")
					return
				}
			case "rwcalr":
				bts, err = (*z).BlockHeader.RewardsState.RewardsRecalculationRound.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "RewardsRecalculationRound")
					return
				}
			case "proto":
				bts, err = (*z).BlockHeader.UpgradeState.CurrentProtocol.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "CurrentProtocol")
					return
				}
			case "nextproto":
				bts, err = (*z).BlockHeader.UpgradeState.NextProtocol.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "NextProtocol")
					return
				}
			case "nextyes":
				(*z).BlockHeader.UpgradeState.NextProtocolApprovals, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "NextProtocolApprovals")
					return
				}
			case "nextbefore":
				bts, err = (*z).BlockHeader.UpgradeState.NextProtocolVoteBefore.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "NextProtocolVoteBefore")
					return
				}
			case "nextswitch":
				bts, err = (*z).BlockHeader.UpgradeState.NextProtocolSwitchOn.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "NextProtocolSwitchOn")
					return
				}
			case "upgradeprop":
				bts, err = (*z).BlockHeader.UpgradeVote.UpgradePropose.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "UpgradePropose")
					return
				}
			case "upgradedelay":
				bts, err = (*z).BlockHeader.UpgradeVote.UpgradeDelay.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "UpgradeDelay")
					return
				}
			case "upgradeyes":
				(*z).BlockHeader.UpgradeVote.UpgradeApprove, bts, err = msgp.ReadBoolBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "UpgradeApprove")
					return
				}
			case "tc":
				(*z).BlockHeader.TxnCounter, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "TxnCounter")
					return
				}
			case "spt":
				var zb0015 int
				var zb0016 bool
				zb0015, zb0016, bts, err = msgp.ReadMapHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "StateProofTracking")
					return
				}
				if zb0015 > protocol.NumStateProofTypes {
					err = msgp.ErrOverflow(uint64(zb0015), uint64(protocol.NumStateProofTypes))
					err = msgp.WrapError(err, "StateProofTracking")
					return
				}
				if zb0016 {
					(*z).BlockHeader.StateProofTracking = nil
				} else if (*z).BlockHeader.StateProofTracking == nil {
					(*z).BlockHeader.StateProofTracking = make(map[protocol.StateProofType]StateProofTrackingData, zb0015)
				}
				for zb0015 > 0 {
					var zb0001 protocol.StateProofType
					var zb0002 StateProofTrackingData
					zb0015--
					bts, err = zb0001.UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "StateProofTracking")
						return
					}
					bts, err = zb0002.UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "StateProofTracking", zb0001)
						return
					}
					(*z).BlockHeader.StateProofTracking[zb0001] = zb0002
				}
			case "partupdrmv":
				var zb0017 int
				var zb0018 bool
				zb0017, zb0018, bts, err = msgp.ReadArrayHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "ExpiredParticipationAccounts")
					return
				}
				if zb0017 > config.MaxProposedExpiredOnlineAccounts {
					err = msgp.ErrOverflow(uint64(zb0017), uint64(config.MaxProposedExpiredOnlineAccounts))
					err = msgp.WrapError(err, "ExpiredParticipationAccounts")
					return
				}
				if zb0018 {
					(*z).BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts = nil
				} else if (*z).BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts != nil && cap((*z).BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts) >= zb0017 {
					(*z).BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts = ((*z).BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts)[:zb0017]
				} else {
					(*z).BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts = make([]basics.Address, zb0017)
				}
				for zb0003 := range (*z).BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts {
					bts, err = (*z).BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts[zb0003].UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "ExpiredParticipationAccounts", zb0003)
						return
					}
				}
			case "partupdabs":
				var zb0019 int
				var zb0020 bool
				zb0019, zb0020, bts, err = msgp.ReadArrayHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "AbsentParticipationAccounts")
					return
				}
				if zb0019 > config.MaxMarkAbsent {
					err = msgp.ErrOverflow(uint64(zb0019), uint64(config.MaxMarkAbsent))
					err = msgp.WrapError(err, "AbsentParticipationAccounts")
					return
				}
				if zb0020 {
					(*z).BlockHeader.ParticipationUpdates.AbsentParticipationAccounts = nil
				} else if (*z).BlockHeader.ParticipationUpdates.AbsentParticipationAccounts != nil && cap((*z).BlockHeader.ParticipationUpdates.AbsentParticipationAccounts) >= zb0019 {
					(*z).BlockHeader.ParticipationUpdates.AbsentParticipationAccounts = ((*z).BlockHeader.ParticipationUpdates.AbsentParticipationAccounts)[:zb0019]
				} else {
					(*z).BlockHeader.ParticipationUpdates.AbsentParticipationAccounts = make([]basics.Address, zb0019)
				}
				for zb0004 := range (*z).BlockHeader.ParticipationUpdates.AbsentParticipationAccounts {
					bts, err = (*z).BlockHeader.ParticipationUpdates.AbsentParticipationAccounts[zb0004].UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "AbsentParticipationAccounts", zb0004)
						return
					}
				}
			case "txns":
				bts, err = (*z).Payset.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Payset")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *Block) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *Block) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*Block)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *Block) Msgsize() (s int) {
	s = 3 + 4 + (*z).BlockHeader.Round.Msgsize() + 5 + (*z).BlockHeader.Branch.Msgsize() + 5 + (*z).BlockHeader.Seed.Msgsize() + 4 + (*z).BlockHeader.TxnCommitments.NativeSha512_256Commitment.Msgsize() + 7 + (*z).BlockHeader.TxnCommitments.Sha256Commitment.Msgsize() + 3 + msgp.Int64Size + 4 + msgp.StringPrefixSize + len((*z).BlockHeader.GenesisID) + 3 + (*z).BlockHeader.GenesisHash.Msgsize() + 4 + (*z).BlockHeader.Proposer.Msgsize() + 3 + (*z).BlockHeader.FeesCollected.Msgsize() + 3 + (*z).BlockHeader.Bonus.Msgsize() + 3 + (*z).BlockHeader.ProposerPayout.Msgsize() + 5 + (*z).BlockHeader.RewardsState.FeeSink.Msgsize() + 4 + (*z).BlockHeader.RewardsState.RewardsPool.Msgsize() + 5 + msgp.Uint64Size + 5 + msgp.Uint64Size + 5 + msgp.Uint64Size + 7 + (*z).BlockHeader.RewardsState.RewardsRecalculationRound.Msgsize() + 6 + (*z).BlockHeader.UpgradeState.CurrentProtocol.Msgsize() + 10 + (*z).BlockHeader.UpgradeState.NextProtocol.Msgsize() + 8 + msgp.Uint64Size + 11 + (*z).BlockHeader.UpgradeState.NextProtocolVoteBefore.Msgsize() + 11 + (*z).BlockHeader.UpgradeState.NextProtocolSwitchOn.Msgsize() + 12 + (*z).BlockHeader.UpgradeVote.UpgradePropose.Msgsize() + 13 + (*z).BlockHeader.UpgradeVote.UpgradeDelay.Msgsize() + 11 + msgp.BoolSize + 3 + msgp.Uint64Size + 4 + msgp.MapHeaderSize
	if (*z).BlockHeader.StateProofTracking != nil {
		for zb0001, zb0002 := range (*z).BlockHeader.StateProofTracking {
			_ = zb0001
			_ = zb0002
			s += 0 + zb0001.Msgsize() + zb0002.Msgsize()
		}
	}
	s += 11 + msgp.ArrayHeaderSize
	for zb0003 := range (*z).BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts {
		s += (*z).BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts[zb0003].Msgsize()
	}
	s += 11 + msgp.ArrayHeaderSize
	for zb0004 := range (*z).BlockHeader.ParticipationUpdates.AbsentParticipationAccounts {
		s += (*z).BlockHeader.ParticipationUpdates.AbsentParticipationAccounts[zb0004].Msgsize()
	}
	s += 5 + (*z).Payset.Msgsize()
	return
}

// MsgIsZero returns whether this is a zero value
func (z *Block) MsgIsZero() bool {
	return ((*z).BlockHeader.Round.MsgIsZero()) && ((*z).BlockHeader.Branch.MsgIsZero()) && ((*z).BlockHeader.Seed.MsgIsZero()) && ((*z).BlockHeader.TxnCommitments.NativeSha512_256Commitment.MsgIsZero()) && ((*z).BlockHeader.TxnCommitments.Sha256Commitment.MsgIsZero()) && ((*z).BlockHeader.TimeStamp == 0) && ((*z).BlockHeader.GenesisID == "") && ((*z).BlockHeader.GenesisHash.MsgIsZero()) && ((*z).BlockHeader.Proposer.MsgIsZero()) && ((*z).BlockHeader.FeesCollected.MsgIsZero()) && ((*z).BlockHeader.Bonus.MsgIsZero()) && ((*z).BlockHeader.ProposerPayout.MsgIsZero()) && ((*z).BlockHeader.RewardsState.FeeSink.MsgIsZero()) && ((*z).BlockHeader.RewardsState.RewardsPool.MsgIsZero()) && ((*z).BlockHeader.RewardsState.RewardsLevel == 0) && ((*z).BlockHeader.RewardsState.RewardsRate == 0) && ((*z).BlockHeader.RewardsState.RewardsResidue == 0) && ((*z).BlockHeader.RewardsState.RewardsRecalculationRound.MsgIsZero()) && ((*z).BlockHeader.UpgradeState.CurrentProtocol.MsgIsZero()) && ((*z).BlockHeader.UpgradeState.NextProtocol.MsgIsZero()) && ((*z).BlockHeader.UpgradeState.NextProtocolApprovals == 0) && ((*z).BlockHeader.UpgradeState.NextProtocolVoteBefore.MsgIsZero()) && ((*z).BlockHeader.UpgradeState.NextProtocolSwitchOn.MsgIsZero()) && ((*z).BlockHeader.UpgradeVote.UpgradePropose.MsgIsZero()) && ((*z).BlockHeader.UpgradeVote.UpgradeDelay.MsgIsZero()) && ((*z).BlockHeader.UpgradeVote.UpgradeApprove == false) && ((*z).BlockHeader.TxnCounter == 0) && (len((*z).BlockHeader.StateProofTracking) == 0) && (len((*z).BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts) == 0) && (len((*z).BlockHeader.ParticipationUpdates.AbsentParticipationAccounts) == 0) && ((*z).Payset.MsgIsZero())
}

// MaxSize returns a maximum valid message size for this message type
func BlockMaxSize() (s int) {
	s = 3 + 4 + basics.RoundMaxSize() + 5 + BlockHashMaxSize() + 5 + committee.SeedMaxSize() + 4 + crypto.DigestMaxSize() + 7 + crypto.DigestMaxSize() + 3 + msgp.Int64Size + 4 + msgp.StringPrefixSize + config.MaxGenesisIDLen + 3 + crypto.DigestMaxSize() + 4 + basics.AddressMaxSize() + 3 + basics.MicroAlgosMaxSize() + 3 + basics.MicroAlgosMaxSize() + 3 + basics.MicroAlgosMaxSize() + 5 + basics.AddressMaxSize() + 4 + basics.AddressMaxSize() + 5 + msgp.Uint64Size + 5 + msgp.Uint64Size + 5 + msgp.Uint64Size + 7 + basics.RoundMaxSize() + 6 + protocol.ConsensusVersionMaxSize() + 10 + protocol.ConsensusVersionMaxSize() + 8 + msgp.Uint64Size + 11 + basics.RoundMaxSize() + 11 + basics.RoundMaxSize() + 12 + protocol.ConsensusVersionMaxSize() + 13 + basics.RoundMaxSize() + 11 + msgp.BoolSize + 3 + msgp.Uint64Size + 4
	s += msgp.MapHeaderSize
	// Adding size of map keys for z.BlockHeader.StateProofTracking
	s += protocol.NumStateProofTypes * (protocol.StateProofTypeMaxSize())
	// Adding size of map values for z.BlockHeader.StateProofTracking
	s += protocol.NumStateProofTypes * (StateProofTrackingDataMaxSize())
	s += 11
	// Calculating size of slice: z.BlockHeader.ParticipationUpdates.ExpiredParticipationAccounts
	s += msgp.ArrayHeaderSize + ((config.MaxProposedExpiredOnlineAccounts) * (basics.AddressMaxSize()))
	s += 11
	// Calculating size of slice: z.BlockHeader.ParticipationUpdates.AbsentParticipationAccounts
	s += msgp.ArrayHeaderSize + ((config.MaxMarkAbsent) * (basics.AddressMaxSize()))
	s += 5
	// Using maxtotalbytes for: z.Payset
	s += config.MaxTxnBytesPerBlock
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *BlockHash) MarshalMsg(b []byte) []byte {
	return ((*(crypto.Digest))(z)).MarshalMsg(b)
}
func (_ *BlockHash) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*BlockHash)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *BlockHash) UnmarshalMsg(bts []byte) ([]byte, error) {
	return ((*(crypto.Digest))(z)).UnmarshalMsg(bts)
}
func (z *BlockHash) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) ([]byte, error) {
	return ((*(crypto.Digest))(z)).UnmarshalMsgWithState(bts, st)
}
func (_ *BlockHash) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*BlockHash)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *BlockHash) Msgsize() int {
	return ((*(crypto.Digest))(z)).Msgsize()
}

// MsgIsZero returns whether this is a zero value
func (z *BlockHash) MsgIsZero() bool {
	return ((*(crypto.Digest))(z)).MsgIsZero()
}

// MaxSize returns a maximum valid message size for this message type
func BlockHashMaxSize() int {
	return crypto.DigestMaxSize()
}

// MarshalMsg implements msgp.Marshaler
func (z *BlockHeader) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0005Len := uint32(30)
	var zb0005Mask uint64 /* 35 bits */
	if (*z).Bonus.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x20
	}
	if (*z).RewardsState.RewardsLevel == 0 {
		zb0005Len--
		zb0005Mask |= 0x40
	}
	if (*z).FeesCollected.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x80
	}
	if (*z).RewardsState.FeeSink.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x100
	}
	if (*z).RewardsState.RewardsResidue == 0 {
		zb0005Len--
		zb0005Mask |= 0x200
	}
	if (*z).GenesisID == "" {
		zb0005Len--
		zb0005Mask |= 0x400
	}
	if (*z).GenesisHash.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x800
	}
	if (*z).UpgradeState.NextProtocolVoteBefore.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x1000
	}
	if (*z).UpgradeState.NextProtocol.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x2000
	}
	if (*z).UpgradeState.NextProtocolSwitchOn.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x4000
	}
	if (*z).UpgradeState.NextProtocolApprovals == 0 {
		zb0005Len--
		zb0005Mask |= 0x8000
	}
	if len((*z).ParticipationUpdates.AbsentParticipationAccounts) == 0 {
		zb0005Len--
		zb0005Mask |= 0x10000
	}
	if len((*z).ParticipationUpdates.ExpiredParticipationAccounts) == 0 {
		zb0005Len--
		zb0005Mask |= 0x20000
	}
	if (*z).ProposerPayout.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x40000
	}
	if (*z).Branch.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x80000
	}
	if (*z).UpgradeState.CurrentProtocol.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x100000
	}
	if (*z).Proposer.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x200000
	}
	if (*z).RewardsState.RewardsRate == 0 {
		zb0005Len--
		zb0005Mask |= 0x400000
	}
	if (*z).Round.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x800000
	}
	if (*z).RewardsState.RewardsRecalculationRound.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x1000000
	}
	if (*z).RewardsState.RewardsPool.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x2000000
	}
	if (*z).Seed.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x4000000
	}
	if len((*z).StateProofTracking) == 0 {
		zb0005Len--
		zb0005Mask |= 0x8000000
	}
	if (*z).TxnCounter == 0 {
		zb0005Len--
		zb0005Mask |= 0x10000000
	}
	if (*z).TimeStamp == 0 {
		zb0005Len--
		zb0005Mask |= 0x20000000
	}
	if (*z).TxnCommitments.NativeSha512_256Commitment.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x40000000
	}
	if (*z).TxnCommitments.Sha256Commitment.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x80000000
	}
	if (*z).UpgradeVote.UpgradeDelay.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x100000000
	}
	if (*z).UpgradeVote.UpgradePropose.MsgIsZero() {
		zb0005Len--
		zb0005Mask |= 0x200000000
	}
	if (*z).UpgradeVote.UpgradeApprove == false {
		zb0005Len--
		zb0005Mask |= 0x400000000
	}
	// variable map header, size zb0005Len
	o = msgp.AppendMapHeader(o, zb0005Len)
	if zb0005Len != 0 {
		if (zb0005Mask & 0x20) == 0 { // if not empty
			// string "bi"
			o = append(o, 0xa2, 0x62, 0x69)
			o = (*z).Bonus.MarshalMsg(o)
		}
		if (zb0005Mask & 0x40) == 0 { // if not empty
			// string "earn"
			o = append(o, 0xa4, 0x65, 0x61, 0x72, 0x6e)
			o = msgp.AppendUint64(o, (*z).RewardsState.RewardsLevel)
		}
		if (zb0005Mask & 0x80) == 0 { // if not empty
			// string "fc"
			o = append(o, 0xa2, 0x66, 0x63)
			o = (*z).FeesCollected.MarshalMsg(o)
		}
		if (zb0005Mask & 0x100) == 0 { // if not empty
			// string "fees"
			o = append(o, 0xa4, 0x66, 0x65, 0x65, 0x73)
			o = (*z).RewardsState.FeeSink.MarshalMsg(o)
		}
		if (zb0005Mask & 0x200) == 0 { // if not empty
			// string "frac"
			o = append(o, 0xa4, 0x66, 0x72, 0x61, 0x63)
			o = msgp.AppendUint64(o, (*z).RewardsState.RewardsResidue)
		}
		if (zb0005Mask & 0x400) == 0 { // if not empty
			// string "gen"
			o = append(o, 0xa3, 0x67, 0x65, 0x6e)
			o = msgp.AppendString(o, (*z).GenesisID)
		}
		if (zb0005Mask & 0x800) == 0 { // if not empty
			// string "gh"
			o = append(o, 0xa2, 0x67, 0x68)
			o = (*z).GenesisHash.MarshalMsg(o)
		}
		if (zb0005Mask & 0x1000) == 0 { // if not empty
			// string "nextbefore"
			o = append(o, 0xaa, 0x6e, 0x65, 0x78, 0x74, 0x62, 0x65, 0x66, 0x6f, 0x72, 0x65)
			o = (*z).UpgradeState.NextProtocolVoteBefore.MarshalMsg(o)
		}
		if (zb0005Mask & 0x2000) == 0 { // if not empty
			// string "nextproto"
			o = append(o, 0xa9, 0x6e, 0x65, 0x78, 0x74, 0x70, 0x72, 0x6f, 0x74, 0x6f)
			o = (*z).UpgradeState.NextProtocol.MarshalMsg(o)
		}
		if (zb0005Mask & 0x4000) == 0 { // if not empty
			// string "nextswitch"
			o = append(o, 0xaa, 0x6e, 0x65, 0x78, 0x74, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68)
			o = (*z).UpgradeState.NextProtocolSwitchOn.MarshalMsg(o)
		}
		if (zb0005Mask & 0x8000) == 0 { // if not empty
			// string "nextyes"
			o = append(o, 0xa7, 0x6e, 0x65, 0x78, 0x74, 0x79, 0x65, 0x73)
			o = msgp.AppendUint64(o, (*z).UpgradeState.NextProtocolApprovals)
		}
		if (zb0005Mask & 0x10000) == 0 { // if not empty
			// string "partupdabs"
			o = append(o, 0xaa, 0x70, 0x61, 0x72, 0x74, 0x75, 0x70, 0x64, 0x61, 0x62, 0x73)
			if (*z).ParticipationUpdates.AbsentParticipationAccounts == nil {
				o = msgp.AppendNil(o)
			} else {
				o = msgp.AppendArrayHeader(o, uint32(len((*z).ParticipationUpdates.AbsentParticipationAccounts)))
			}
			for zb0004 := range (*z).ParticipationUpdates.AbsentParticipationAccounts {
				o = (*z).ParticipationUpdates.AbsentParticipationAccounts[zb0004].MarshalMsg(o)
			}
		}
		if (zb0005Mask & 0x20000) == 0 { // if not empty
			// string "partupdrmv"
			o = append(o, 0xaa, 0x70, 0x61, 0x72, 0x74, 0x75, 0x70, 0x64, 0x72, 0x6d, 0x76)
			if (*z).ParticipationUpdates.ExpiredParticipationAccounts == nil {
				o = msgp.AppendNil(o)
			} else {
				o = msgp.AppendArrayHeader(o, uint32(len((*z).ParticipationUpdates.ExpiredParticipationAccounts)))
			}
			for zb0003 := range (*z).ParticipationUpdates.ExpiredParticipationAccounts {
				o = (*z).ParticipationUpdates.ExpiredParticipationAccounts[zb0003].MarshalMsg(o)
			}
		}
		if (zb0005Mask & 0x40000) == 0 { // if not empty
			// string "pp"
			o = append(o, 0xa2, 0x70, 0x70)
			o = (*z).ProposerPayout.MarshalMsg(o)
		}
		if (zb0005Mask & 0x80000) == 0 { // if not empty
			// string "prev"
			o = append(o, 0xa4, 0x70, 0x72, 0x65, 0x76)
			o = (*z).Branch.MarshalMsg(o)
		}
		if (zb0005Mask & 0x100000) == 0 { // if not empty
			// string "proto"
			o = append(o, 0xa5, 0x70, 0x72, 0x6f, 0x74, 0x6f)
			o = (*z).UpgradeState.CurrentProtocol.MarshalMsg(o)
		}
		if (zb0005Mask & 0x200000) == 0 { // if not empty
			// string "prp"
			o = append(o, 0xa3, 0x70, 0x72, 0x70)
			o = (*z).Proposer.MarshalMsg(o)
		}
		if (zb0005Mask & 0x400000) == 0 { // if not empty
			// string "rate"
			o = append(o, 0xa4, 0x72, 0x61, 0x74, 0x65)
			o = msgp.AppendUint64(o, (*z).RewardsState.RewardsRate)
		}
		if (zb0005Mask & 0x800000) == 0 { // if not empty
			// string "rnd"
			o = append(o, 0xa3, 0x72, 0x6e, 0x64)
			o = (*z).Round.MarshalMsg(o)
		}
		if (zb0005Mask & 0x1000000) == 0 { // if not empty
			// string "rwcalr"
			o = append(o, 0xa6, 0x72, 0x77, 0x63, 0x61, 0x6c, 0x72)
			o = (*z).RewardsState.RewardsRecalculationRound.MarshalMsg(o)
		}
		if (zb0005Mask & 0x2000000) == 0 { // if not empty
			// string "rwd"
			o = append(o, 0xa3, 0x72, 0x77, 0x64)
			o = (*z).RewardsState.RewardsPool.MarshalMsg(o)
		}
		if (zb0005Mask & 0x4000000) == 0 { // if not empty
			// string "seed"
			o = append(o, 0xa4, 0x73, 0x65, 0x65, 0x64)
			o = (*z).Seed.MarshalMsg(o)
		}
		if (zb0005Mask & 0x8000000) == 0 { // if not empty
			// string "spt"
			o = append(o, 0xa3, 0x73, 0x70, 0x74)
			if (*z).StateProofTracking == nil {
				o = msgp.AppendNil(o)
			} else {
				o = msgp.AppendMapHeader(o, uint32(len((*z).StateProofTracking)))
			}
			zb0001_keys := make([]protocol.StateProofType, 0, len((*z).StateProofTracking))
			for zb0001 := range (*z).StateProofTracking {
				zb0001_keys = append(zb0001_keys, zb0001)
			}
			sort.Sort(protocol.SortStateProofType(zb0001_keys))
			for _, zb0001 := range zb0001_keys {
				zb0002 := (*z).StateProofTracking[zb0001]
				_ = zb0002
				o = zb0001.MarshalMsg(o)
				o = zb0002.MarshalMsg(o)
			}
		}
		if (zb0005Mask & 0x10000000) == 0 { // if not empty
			// string "tc"
			o = append(o, 0xa2, 0x74, 0x63)
			o = msgp.AppendUint64(o, (*z).TxnCounter)
		}
		if (zb0005Mask & 0x20000000) == 0 { // if not empty
			// string "ts"
			o = append(o, 0xa2, 0x74, 0x73)
			o = msgp.AppendInt64(o, (*z).TimeStamp)
		}
		if (zb0005Mask & 0x40000000) == 0 { // if not empty
			// string "txn"
			o = append(o, 0xa3, 0x74, 0x78, 0x6e)
			o = (*z).TxnCommitments.NativeSha512_256Commitment.MarshalMsg(o)
		}
		if (zb0005Mask & 0x80000000) == 0 { // if not empty
			// string "txn256"
			o = append(o, 0xa6, 0x74, 0x78, 0x6e, 0x32, 0x35, 0x36)
			o = (*z).TxnCommitments.Sha256Commitment.MarshalMsg(o)
		}
		if (zb0005Mask & 0x100000000) == 0 { // if not empty
			// string "upgradedelay"
			o = append(o, 0xac, 0x75, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x64, 0x65, 0x6c, 0x61, 0x79)
			o = (*z).UpgradeVote.UpgradeDelay.MarshalMsg(o)
		}
		if (zb0005Mask & 0x200000000) == 0 { // if not empty
			// string "upgradeprop"
			o = append(o, 0xab, 0x75, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x70, 0x72, 0x6f, 0x70)
			o = (*z).UpgradeVote.UpgradePropose.MarshalMsg(o)
		}
		if (zb0005Mask & 0x400000000) == 0 { // if not empty
			// string "upgradeyes"
			o = append(o, 0xaa, 0x75, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x79, 0x65, 0x73)
			o = msgp.AppendBool(o, (*z).UpgradeVote.UpgradeApprove)
		}
	}
	return
}

func (_ *BlockHeader) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*BlockHeader)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *BlockHeader) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0005 int
	var zb0006 bool
	zb0005, zb0006, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0005, zb0006, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).Round.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Round")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).Branch.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Branch")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).Seed.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Seed")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).TxnCommitments.NativeSha512_256Commitment.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "NativeSha512_256Commitment")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).TxnCommitments.Sha256Commitment.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Sha256Commitment")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			(*z).TimeStamp, bts, err = msgp.ReadInt64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "TimeStamp")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			var zb0007 int
			zb0007, err = msgp.ReadBytesBytesHeader(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "GenesisID")
				return
			}
			if zb0007 > config.MaxGenesisIDLen {
				err = msgp.ErrOverflow(uint64(zb0007), uint64(config.MaxGenesisIDLen))
				return
			}
			(*z).GenesisID, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "GenesisID")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).GenesisHash.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "GenesisHash")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).Proposer.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Proposer")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).FeesCollected.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "FeesCollected")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).Bonus.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Bonus")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).ProposerPayout.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "ProposerPayout")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).RewardsState.FeeSink.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "FeeSink")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).RewardsState.RewardsPool.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "RewardsPool")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			(*z).RewardsState.RewardsLevel, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "RewardsLevel")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			(*z).RewardsState.RewardsRate, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "RewardsRate")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			(*z).RewardsState.RewardsResidue, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "RewardsResidue")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).RewardsState.RewardsRecalculationRound.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "RewardsRecalculationRound")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).UpgradeState.CurrentProtocol.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "CurrentProtocol")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).UpgradeState.NextProtocol.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "NextProtocol")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			(*z).UpgradeState.NextProtocolApprovals, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "NextProtocolApprovals")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).UpgradeState.NextProtocolVoteBefore.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "NextProtocolVoteBefore")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).UpgradeState.NextProtocolSwitchOn.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "NextProtocolSwitchOn")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).UpgradeVote.UpgradePropose.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "UpgradePropose")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = (*z).UpgradeVote.UpgradeDelay.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "UpgradeDelay")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			(*z).UpgradeVote.UpgradeApprove, bts, err = msgp.ReadBoolBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "UpgradeApprove")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			(*z).TxnCounter, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "TxnCounter")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			var zb0008 int
			var zb0009 bool
			zb0008, zb0009, bts, err = msgp.ReadMapHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "StateProofTracking")
				return
			}
			if zb0008 > protocol.NumStateProofTypes {
				err = msgp.ErrOverflow(uint64(zb0008), uint64(protocol.NumStateProofTypes))
				err = msgp.WrapError(err, "struct-from-array", "StateProofTracking")
				return
			}
			if zb0009 {
				(*z).StateProofTracking = nil
			} else if (*z).StateProofTracking == nil {
				(*z).StateProofTracking = make(map[protocol.StateProofType]StateProofTrackingData, zb0008)
			}
			for zb0008 > 0 {
				var zb0001 protocol.StateProofType
				var zb0002 StateProofTrackingData
				zb0008--
				bts, err = zb0001.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "StateProofTracking")
					return
				}
				bts, err = zb0002.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "StateProofTracking", zb0001)
					return
				}
				(*z).StateProofTracking[zb0001] = zb0002
			}
		}
		if zb0005 > 0 {
			zb0005--
			var zb0010 int
			var zb0011 bool
			zb0010, zb0011, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "ExpiredParticipationAccounts")
				return
			}
			if zb0010 > config.MaxProposedExpiredOnlineAccounts {
				err = msgp.ErrOverflow(uint64(zb0010), uint64(config.MaxProposedExpiredOnlineAccounts))
				err = msgp.WrapError(err, "struct-from-array", "ExpiredParticipationAccounts")
				return
			}
			if zb0011 {
				(*z).ParticipationUpdates.ExpiredParticipationAccounts = nil
			} else if (*z).ParticipationUpdates.ExpiredParticipationAccounts != nil && cap((*z).ParticipationUpdates.ExpiredParticipationAccounts) >= zb0010 {
				(*z).ParticipationUpdates.ExpiredParticipationAccounts = ((*z).ParticipationUpdates.ExpiredParticipationAccounts)[:zb0010]
			} else {
				(*z).ParticipationUpdates.ExpiredParticipationAccounts = make([]basics.Address, zb0010)
			}
			for zb0003 := range (*z).ParticipationUpdates.ExpiredParticipationAccounts {
				bts, err = (*z).ParticipationUpdates.ExpiredParticipationAccounts[zb0003].UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "ExpiredParticipationAccounts", zb0003)
					return
				}
			}
		}
		if zb0005 > 0 {
			zb0005--
			var zb0012 int
			var zb0013 bool
			zb0012, zb0013, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "AbsentParticipationAccounts")
				return
			}
			if zb0012 > config.MaxMarkAbsent {
				err = msgp.ErrOverflow(uint64(zb0012), uint64(config.MaxMarkAbsent))
				err = msgp.WrapError(err, "struct-from-array", "AbsentParticipationAccounts")
				return
			}
			if zb0013 {
				(*z).ParticipationUpdates.AbsentParticipationAccounts = nil
			} else if (*z).ParticipationUpdates.AbsentParticipationAccounts != nil && cap((*z).ParticipationUpdates.AbsentParticipationAccounts) >= zb0012 {
				(*z).ParticipationUpdates.AbsentParticipationAccounts = ((*z).ParticipationUpdates.AbsentParticipationAccounts)[:zb0012]
			} else {
				(*z).ParticipationUpdates.AbsentParticipationAccounts = make([]basics.Address, zb0012)
			}
			for zb0004 := range (*z).ParticipationUpdates.AbsentParticipationAccounts {
				bts, err = (*z).ParticipationUpdates.AbsentParticipationAccounts[zb0004].UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "AbsentParticipationAccounts", zb0004)
					return
				}
			}
		}
		if zb0005 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0005)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0006 {
			(*z) = BlockHeader{}
		}
		for zb0005 > 0 {
			zb0005--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "rnd":
				bts, err = (*z).Round.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Round")
					return
				}
			case "prev":
				bts, err = (*z).Branch.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Branch")
					return
				}
			case "seed":
				bts, err = (*z).Seed.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Seed")
					return
				}
			case "txn":
				bts, err = (*z).TxnCommitments.NativeSha512_256Commitment.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "NativeSha512_256Commitment")
					return
				}
			case "txn256":
				bts, err = (*z).TxnCommitments.Sha256Commitment.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Sha256Commitment")
					return
				}
			case "ts":
				(*z).TimeStamp, bts, err = msgp.ReadInt64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "TimeStamp")
					return
				}
			case "gen":
				var zb0014 int
				zb0014, err = msgp.ReadBytesBytesHeader(bts)
				if err != nil {
					err = msgp.WrapError(err, "GenesisID")
					return
				}
				if zb0014 > config.MaxGenesisIDLen {
					err = msgp.ErrOverflow(uint64(zb0014), uint64(config.MaxGenesisIDLen))
					return
				}
				(*z).GenesisID, bts, err = msgp.ReadStringBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "GenesisID")
					return
				}
			case "gh":
				bts, err = (*z).GenesisHash.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "GenesisHash")
					return
				}
			case "prp":
				bts, err = (*z).Proposer.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Proposer")
					return
				}
			case "fc":
				bts, err = (*z).FeesCollected.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "FeesCollected")
					return
				}
			case "bi":
				bts, err = (*z).Bonus.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Bonus")
					return
				}
			case "pp":
				bts, err = (*z).ProposerPayout.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "ProposerPayout")
					return
				}
			case "fees":
				bts, err = (*z).RewardsState.FeeSink.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "FeeSink")
					return
				}
			case "rwd":
				bts, err = (*z).RewardsState.RewardsPool.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "RewardsPool")
					return
				}
			case "earn":
				(*z).RewardsState.RewardsLevel, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "RewardsLevel")
					return
				}
			case "rate":
				(*z).RewardsState.RewardsRate, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "RewardsRate")
					return
				}
			case "frac":
				(*z).RewardsState.RewardsResidue, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "RewardsResidue")
					return
				}
			case "rwcalr":
				bts, err = (*z).RewardsState.RewardsRecalculationRound.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "RewardsRecalculationRound")
					return
				}
			case "proto":
				bts, err = (*z).UpgradeState.CurrentProtocol.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "CurrentProtocol")
					return
				}
			case "nextproto":
				bts, err = (*z).UpgradeState.NextProtocol.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "NextProtocol")
					return
				}
			case "nextyes":
				(*z).UpgradeState.NextProtocolApprovals, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "NextProtocolApprovals")
					return
				}
			case "nextbefore":
				bts, err = (*z).UpgradeState.NextProtocolVoteBefore.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "NextProtocolVoteBefore")
					return
				}
			case "nextswitch":
				bts, err = (*z).UpgradeState.NextProtocolSwitchOn.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "NextProtocolSwitchOn")
					return
				}
			case "upgradeprop":
				bts, err = (*z).UpgradeVote.UpgradePropose.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "UpgradePropose")
					return
				}
			case "upgradedelay":
				bts, err = (*z).UpgradeVote.UpgradeDelay.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "UpgradeDelay")
					return
				}
			case "upgradeyes":
				(*z).UpgradeVote.UpgradeApprove, bts, err = msgp.ReadBoolBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "UpgradeApprove")
					return
				}
			case "tc":
				(*z).TxnCounter, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "TxnCounter")
					return
				}
			case "spt":
				var zb0015 int
				var zb0016 bool
				zb0015, zb0016, bts, err = msgp.ReadMapHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "StateProofTracking")
					return
				}
				if zb0015 > protocol.NumStateProofTypes {
					err = msgp.ErrOverflow(uint64(zb0015), uint64(protocol.NumStateProofTypes))
					err = msgp.WrapError(err, "StateProofTracking")
					return
				}
				if zb0016 {
					(*z).StateProofTracking = nil
				} else if (*z).StateProofTracking == nil {
					(*z).StateProofTracking = make(map[protocol.StateProofType]StateProofTrackingData, zb0015)
				}
				for zb0015 > 0 {
					var zb0001 protocol.StateProofType
					var zb0002 StateProofTrackingData
					zb0015--
					bts, err = zb0001.UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "StateProofTracking")
						return
					}
					bts, err = zb0002.UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "StateProofTracking", zb0001)
						return
					}
					(*z).StateProofTracking[zb0001] = zb0002
				}
			case "partupdrmv":
				var zb0017 int
				var zb0018 bool
				zb0017, zb0018, bts, err = msgp.ReadArrayHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "ExpiredParticipationAccounts")
					return
				}
				if zb0017 > config.MaxProposedExpiredOnlineAccounts {
					err = msgp.ErrOverflow(uint64(zb0017), uint64(config.MaxProposedExpiredOnlineAccounts))
					err = msgp.WrapError(err, "ExpiredParticipationAccounts")
					return
				}
				if zb0018 {
					(*z).ParticipationUpdates.ExpiredParticipationAccounts = nil
				} else if (*z).ParticipationUpdates.ExpiredParticipationAccounts != nil && cap((*z).ParticipationUpdates.ExpiredParticipationAccounts) >= zb0017 {
					(*z).ParticipationUpdates.ExpiredParticipationAccounts = ((*z).ParticipationUpdates.ExpiredParticipationAccounts)[:zb0017]
				} else {
					(*z).ParticipationUpdates.ExpiredParticipationAccounts = make([]basics.Address, zb0017)
				}
				for zb0003 := range (*z).ParticipationUpdates.ExpiredParticipationAccounts {
					bts, err = (*z).ParticipationUpdates.ExpiredParticipationAccounts[zb0003].UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "ExpiredParticipationAccounts", zb0003)
						return
					}
				}
			case "partupdabs":
				var zb0019 int
				var zb0020 bool
				zb0019, zb0020, bts, err = msgp.ReadArrayHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "AbsentParticipationAccounts")
					return
				}
				if zb0019 > config.MaxMarkAbsent {
					err = msgp.ErrOverflow(uint64(zb0019), uint64(config.MaxMarkAbsent))
					err = msgp.WrapError(err, "AbsentParticipationAccounts")
					return
				}
				if zb0020 {
					(*z).ParticipationUpdates.AbsentParticipationAccounts = nil
				} else if (*z).ParticipationUpdates.AbsentParticipationAccounts != nil && cap((*z).ParticipationUpdates.AbsentParticipationAccounts) >= zb0019 {
					(*z).ParticipationUpdates.AbsentParticipationAccounts = ((*z).ParticipationUpdates.AbsentParticipationAccounts)[:zb0019]
				} else {
					(*z).ParticipationUpdates.AbsentParticipationAccounts = make([]basics.Address, zb0019)
				}
				for zb0004 := range (*z).ParticipationUpdates.AbsentParticipationAccounts {
					bts, err = (*z).ParticipationUpdates.AbsentParticipationAccounts[zb0004].UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "AbsentParticipationAccounts", zb0004)
						return
					}
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *BlockHeader) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *BlockHeader) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*BlockHeader)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *BlockHeader) Msgsize() (s int) {
	s = 3 + 4 + (*z).Round.Msgsize() + 5 + (*z).Branch.Msgsize() + 5 + (*z).Seed.Msgsize() + 4 + (*z).TxnCommitments.NativeSha512_256Commitment.Msgsize() + 7 + (*z).TxnCommitments.Sha256Commitment.Msgsize() + 3 + msgp.Int64Size + 4 + msgp.StringPrefixSize + len((*z).GenesisID) + 3 + (*z).GenesisHash.Msgsize() + 4 + (*z).Proposer.Msgsize() + 3 + (*z).FeesCollected.Msgsize() + 3 + (*z).Bonus.Msgsize() + 3 + (*z).ProposerPayout.Msgsize() + 5 + (*z).RewardsState.FeeSink.Msgsize() + 4 + (*z).RewardsState.RewardsPool.Msgsize() + 5 + msgp.Uint64Size + 5 + msgp.Uint64Size + 5 + msgp.Uint64Size + 7 + (*z).RewardsState.RewardsRecalculationRound.Msgsize() + 6 + (*z).UpgradeState.CurrentProtocol.Msgsize() + 10 + (*z).UpgradeState.NextProtocol.Msgsize() + 8 + msgp.Uint64Size + 11 + (*z).UpgradeState.NextProtocolVoteBefore.Msgsize() + 11 + (*z).UpgradeState.NextProtocolSwitchOn.Msgsize() + 12 + (*z).UpgradeVote.UpgradePropose.Msgsize() + 13 + (*z).UpgradeVote.UpgradeDelay.Msgsize() + 11 + msgp.BoolSize + 3 + msgp.Uint64Size + 4 + msgp.MapHeaderSize
	if (*z).StateProofTracking != nil {
		for zb0001, zb0002 := range (*z).StateProofTracking {
			_ = zb0001
			_ = zb0002
			s += 0 + zb0001.Msgsize() + zb0002.Msgsize()
		}
	}
	s += 11 + msgp.ArrayHeaderSize
	for zb0003 := range (*z).ParticipationUpdates.ExpiredParticipationAccounts {
		s += (*z).ParticipationUpdates.ExpiredParticipationAccounts[zb0003].Msgsize()
	}
	s += 11 + msgp.ArrayHeaderSize
	for zb0004 := range (*z).ParticipationUpdates.AbsentParticipationAccounts {
		s += (*z).ParticipationUpdates.AbsentParticipationAccounts[zb0004].Msgsize()
	}
	return
}

// MsgIsZero returns whether this is a zero value
func (z *BlockHeader) MsgIsZero() bool {
	return ((*z).Round.MsgIsZero()) && ((*z).Branch.MsgIsZero()) && ((*z).Seed.MsgIsZero()) && ((*z).TxnCommitments.NativeSha512_256Commitment.MsgIsZero()) && ((*z).TxnCommitments.Sha256Commitment.MsgIsZero()) && ((*z).TimeStamp == 0) && ((*z).GenesisID == "") && ((*z).GenesisHash.MsgIsZero()) && ((*z).Proposer.MsgIsZero()) && ((*z).FeesCollected.MsgIsZero()) && ((*z).Bonus.MsgIsZero()) && ((*z).ProposerPayout.MsgIsZero()) && ((*z).RewardsState.FeeSink.MsgIsZero()) && ((*z).RewardsState.RewardsPool.MsgIsZero()) && ((*z).RewardsState.RewardsLevel == 0) && ((*z).RewardsState.RewardsRate == 0) && ((*z).RewardsState.RewardsResidue == 0) && ((*z).RewardsState.RewardsRecalculationRound.MsgIsZero()) && ((*z).UpgradeState.CurrentProtocol.MsgIsZero()) && ((*z).UpgradeState.NextProtocol.MsgIsZero()) && ((*z).UpgradeState.NextProtocolApprovals == 0) && ((*z).UpgradeState.NextProtocolVoteBefore.MsgIsZero()) && ((*z).UpgradeState.NextProtocolSwitchOn.MsgIsZero()) && ((*z).UpgradeVote.UpgradePropose.MsgIsZero()) && ((*z).UpgradeVote.UpgradeDelay.MsgIsZero()) && ((*z).UpgradeVote.UpgradeApprove == false) && ((*z).TxnCounter == 0) && (len((*z).StateProofTracking) == 0) && (len((*z).ParticipationUpdates.ExpiredParticipationAccounts) == 0) && (len((*z).ParticipationUpdates.AbsentParticipationAccounts) == 0)
}

// MaxSize returns a maximum valid message size for this message type
func BlockHeaderMaxSize() (s int) {
	s = 3 + 4 + basics.RoundMaxSize() + 5 + BlockHashMaxSize() + 5 + committee.SeedMaxSize() + 4 + crypto.DigestMaxSize() + 7 + crypto.DigestMaxSize() + 3 + msgp.Int64Size + 4 + msgp.StringPrefixSize + config.MaxGenesisIDLen + 3 + crypto.DigestMaxSize() + 4 + basics.AddressMaxSize() + 3 + basics.MicroAlgosMaxSize() + 3 + basics.MicroAlgosMaxSize() + 3 + basics.MicroAlgosMaxSize() + 5 + basics.AddressMaxSize() + 4 + basics.AddressMaxSize() + 5 + msgp.Uint64Size + 5 + msgp.Uint64Size + 5 + msgp.Uint64Size + 7 + basics.RoundMaxSize() + 6 + protocol.ConsensusVersionMaxSize() + 10 + protocol.ConsensusVersionMaxSize() + 8 + msgp.Uint64Size + 11 + basics.RoundMaxSize() + 11 + basics.RoundMaxSize() + 12 + protocol.ConsensusVersionMaxSize() + 13 + basics.RoundMaxSize() + 11 + msgp.BoolSize + 3 + msgp.Uint64Size + 4
	s += msgp.MapHeaderSize
	// Adding size of map keys for z.StateProofTracking
	s += protocol.NumStateProofTypes * (protocol.StateProofTypeMaxSize())
	// Adding size of map values for z.StateProofTracking
	s += protocol.NumStateProofTypes * (StateProofTrackingDataMaxSize())
	s += 11
	// Calculating size of slice: z.ParticipationUpdates.ExpiredParticipationAccounts
	s += msgp.ArrayHeaderSize + ((config.MaxProposedExpiredOnlineAccounts) * (basics.AddressMaxSize()))
	s += 11
	// Calculating size of slice: z.ParticipationUpdates.AbsentParticipationAccounts
	s += msgp.ArrayHeaderSize + ((config.MaxMarkAbsent) * (basics.AddressMaxSize()))
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *Genesis) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0002Len := uint32(9)
	var zb0002Mask uint16 /* 10 bits */
	if len((*z).Allocation) == 0 {
		zb0002Len--
		zb0002Mask |= 0x2
	}
	if (*z).Comment == "" {
		zb0002Len--
		zb0002Mask |= 0x4
	}
	if (*z).DevMode == false {
		zb0002Len--
		zb0002Mask |= 0x8
	}
	if (*z).FeeSink == "" {
		zb0002Len--
		zb0002Mask |= 0x10
	}
	if (*z).SchemaID == "" {
		zb0002Len--
		zb0002Mask |= 0x20
	}
	if (*z).Network.MsgIsZero() {
		zb0002Len--
		zb0002Mask |= 0x40
	}
	if (*z).Proto.MsgIsZero() {
		zb0002Len--
		zb0002Mask |= 0x80
	}
	if (*z).RewardsPool == "" {
		zb0002Len--
		zb0002Mask |= 0x100
	}
	if (*z).Timestamp == 0 {
		zb0002Len--
		zb0002Mask |= 0x200
	}
	// variable map header, size zb0002Len
	o = append(o, 0x80|uint8(zb0002Len))
	if zb0002Len != 0 {
		if (zb0002Mask & 0x2) == 0 { // if not empty
			// string "alloc"
			o = append(o, 0xa5, 0x61, 0x6c, 0x6c, 0x6f, 0x63)
			if (*z).Allocation == nil {
				o = msgp.AppendNil(o)
			} else {
				o = msgp.AppendArrayHeader(o, uint32(len((*z).Allocation)))
			}
			for zb0001 := range (*z).Allocation {
				o = (*z).Allocation[zb0001].MarshalMsg(o)
			}
		}
		if (zb0002Mask & 0x4) == 0 { // if not empty
			// string "comment"
			o = append(o, 0xa7, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74)
			o = msgp.AppendString(o, (*z).Comment)
		}
		if (zb0002Mask & 0x8) == 0 { // if not empty
			// string "devmode"
			o = append(o, 0xa7, 0x64, 0x65, 0x76, 0x6d, 0x6f, 0x64, 0x65)
			o = msgp.AppendBool(o, (*z).DevMode)
		}
		if (zb0002Mask & 0x10) == 0 { // if not empty
			// string "fees"
			o = append(o, 0xa4, 0x66, 0x65, 0x65, 0x73)
			o = msgp.AppendString(o, (*z).FeeSink)
		}
		if (zb0002Mask & 0x20) == 0 { // if not empty
			// string "id"
			o = append(o, 0xa2, 0x69, 0x64)
			o = msgp.AppendString(o, (*z).SchemaID)
		}
		if (zb0002Mask & 0x40) == 0 { // if not empty
			// string "network"
			o = append(o, 0xa7, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b)
			o = (*z).Network.MarshalMsg(o)
		}
		if (zb0002Mask & 0x80) == 0 { // if not empty
			// string "proto"
			o = append(o, 0xa5, 0x70, 0x72, 0x6f, 0x74, 0x6f)
			o = (*z).Proto.MarshalMsg(o)
		}
		if (zb0002Mask & 0x100) == 0 { // if not empty
			// string "rwd"
			o = append(o, 0xa3, 0x72, 0x77, 0x64)
			o = msgp.AppendString(o, (*z).RewardsPool)
		}
		if (zb0002Mask & 0x200) == 0 { // if not empty
			// string "timestamp"
			o = append(o, 0xa9, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70)
			o = msgp.AppendInt64(o, (*z).Timestamp)
		}
	}
	return
}

func (_ *Genesis) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*Genesis)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *Genesis) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0002 int
	var zb0003 bool
	zb0002, zb0003, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0002, zb0003, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 > 0 {
			zb0002--
			(*z).SchemaID, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "SchemaID")
				return
			}
		}
		if zb0002 > 0 {
			zb0002--
			bts, err = (*z).Network.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Network")
				return
			}
		}
		if zb0002 > 0 {
			zb0002--
			bts, err = (*z).Proto.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Proto")
				return
			}
		}
		if zb0002 > 0 {
			zb0002--
			var zb0004 int
			var zb0005 bool
			zb0004, zb0005, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Allocation")
				return
			}
			if zb0004 > MaxInitialGenesisAllocationSize {
				err = msgp.ErrOverflow(uint64(zb0004), uint64(MaxInitialGenesisAllocationSize))
				err = msgp.WrapError(err, "struct-from-array", "Allocation")
				return
			}
			if zb0005 {
				(*z).Allocation = nil
			} else if (*z).Allocation != nil && cap((*z).Allocation) >= zb0004 {
				(*z).Allocation = ((*z).Allocation)[:zb0004]
			} else {
				(*z).Allocation = make([]GenesisAllocation, zb0004)
			}
			for zb0001 := range (*z).Allocation {
				bts, err = (*z).Allocation[zb0001].UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Allocation", zb0001)
					return
				}
			}
		}
		if zb0002 > 0 {
			zb0002--
			(*z).RewardsPool, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "RewardsPool")
				return
			}
		}
		if zb0002 > 0 {
			zb0002--
			(*z).FeeSink, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "FeeSink")
				return
			}
		}
		if zb0002 > 0 {
			zb0002--
			(*z).Timestamp, bts, err = msgp.ReadInt64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Timestamp")
				return
			}
		}
		if zb0002 > 0 {
			zb0002--
			(*z).Comment, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Comment")
				return
			}
		}
		if zb0002 > 0 {
			zb0002--
			(*z).DevMode, bts, err = msgp.ReadBoolBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "DevMode")
				return
			}
		}
		if zb0002 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0002)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0003 {
			(*z) = Genesis{}
		}
		for zb0002 > 0 {
			zb0002--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "id":
				(*z).SchemaID, bts, err = msgp.ReadStringBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "SchemaID")
					return
				}
			case "network":
				bts, err = (*z).Network.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Network")
					return
				}
			case "proto":
				bts, err = (*z).Proto.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Proto")
					return
				}
			case "alloc":
				var zb0006 int
				var zb0007 bool
				zb0006, zb0007, bts, err = msgp.ReadArrayHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Allocation")
					return
				}
				if zb0006 > MaxInitialGenesisAllocationSize {
					err = msgp.ErrOverflow(uint64(zb0006), uint64(MaxInitialGenesisAllocationSize))
					err = msgp.WrapError(err, "Allocation")
					return
				}
				if zb0007 {
					(*z).Allocation = nil
				} else if (*z).Allocation != nil && cap((*z).Allocation) >= zb0006 {
					(*z).Allocation = ((*z).Allocation)[:zb0006]
				} else {
					(*z).Allocation = make([]GenesisAllocation, zb0006)
				}
				for zb0001 := range (*z).Allocation {
					bts, err = (*z).Allocation[zb0001].UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "Allocation", zb0001)
						return
					}
				}
			case "rwd":
				(*z).RewardsPool, bts, err = msgp.ReadStringBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "RewardsPool")
					return
				}
			case "fees":
				(*z).FeeSink, bts, err = msgp.ReadStringBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "FeeSink")
					return
				}
			case "timestamp":
				(*z).Timestamp, bts, err = msgp.ReadInt64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Timestamp")
					return
				}
			case "comment":
				(*z).Comment, bts, err = msgp.ReadStringBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Comment")
					return
				}
			case "devmode":
				(*z).DevMode, bts, err = msgp.ReadBoolBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "DevMode")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *Genesis) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *Genesis) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*Genesis)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *Genesis) Msgsize() (s int) {
	s = 1 + 3 + msgp.StringPrefixSize + len((*z).SchemaID) + 8 + (*z).Network.Msgsize() + 6 + (*z).Proto.Msgsize() + 6 + msgp.ArrayHeaderSize
	for zb0001 := range (*z).Allocation {
		s += (*z).Allocation[zb0001].Msgsize()
	}
	s += 4 + msgp.StringPrefixSize + len((*z).RewardsPool) + 5 + msgp.StringPrefixSize + len((*z).FeeSink) + 10 + msgp.Int64Size + 8 + msgp.StringPrefixSize + len((*z).Comment) + 8 + msgp.BoolSize
	return
}

// MsgIsZero returns whether this is a zero value
func (z *Genesis) MsgIsZero() bool {
	return ((*z).SchemaID == "") && ((*z).Network.MsgIsZero()) && ((*z).Proto.MsgIsZero()) && (len((*z).Allocation) == 0) && ((*z).RewardsPool == "") && ((*z).FeeSink == "") && ((*z).Timestamp == 0) && ((*z).Comment == "") && ((*z).DevMode == false)
}

// MaxSize returns a maximum valid message size for this message type
func GenesisMaxSize() (s int) {
	s = 1 + 3
	panic("Unable to determine max size: String type z.SchemaID is unbounded")
	s += 8 + protocol.NetworkIDMaxSize() + 6 + protocol.ConsensusVersionMaxSize() + 6
	// Calculating size of slice: z.Allocation
	s += msgp.ArrayHeaderSize + ((MaxInitialGenesisAllocationSize) * (GenesisAllocationMaxSize()))
	s += 4
	panic("Unable to determine max size: String type z.RewardsPool is unbounded")
	s += 5
	panic("Unable to determine max size: String type z.FeeSink is unbounded")
	s += 10 + msgp.Int64Size + 8
	panic("Unable to determine max size: String type z.Comment is unbounded")
	s += 8 + msgp.BoolSize
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *GenesisAccountData) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0001Len := uint32(8)
	var zb0001Mask uint16 /* 9 bits */
	if (*z).MicroAlgos.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x2
	}
	if (*z).Status.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x4
	}
	if (*z).SelectionID.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x8
	}
	if (*z).StateProofID.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x10
	}
	if (*z).VoteID.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x20
	}
	if (*z).VoteFirstValid.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x40
	}
	if (*z).VoteKeyDilution == 0 {
		zb0001Len--
		zb0001Mask |= 0x80
	}
	if (*z).VoteLastValid.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x100
	}
	// variable map header, size zb0001Len
	o = append(o, 0x80|uint8(zb0001Len))
	if zb0001Len != 0 {
		if (zb0001Mask & 0x2) == 0 { // if not empty
			// string "algo"
			o = append(o, 0xa4, 0x61, 0x6c, 0x67, 0x6f)
			o = (*z).MicroAlgos.MarshalMsg(o)
		}
		if (zb0001Mask & 0x4) == 0 { // if not empty
			// string "onl"
			o = append(o, 0xa3, 0x6f, 0x6e, 0x6c)
			o = (*z).Status.MarshalMsg(o)
		}
		if (zb0001Mask & 0x8) == 0 { // if not empty
			// string "sel"
			o = append(o, 0xa3, 0x73, 0x65, 0x6c)
			o = (*z).SelectionID.MarshalMsg(o)
		}
		if (zb0001Mask & 0x10) == 0 { // if not empty
			// string "stprf"
			o = append(o, 0xa5, 0x73, 0x74, 0x70, 0x72, 0x66)
			o = (*z).StateProofID.MarshalMsg(o)
		}
		if (zb0001Mask & 0x20) == 0 { // if not empty
			// string "vote"
			o = append(o, 0xa4, 0x76, 0x6f, 0x74, 0x65)
			o = (*z).VoteID.MarshalMsg(o)
		}
		if (zb0001Mask & 0x40) == 0 { // if not empty
			// string "voteFst"
			o = append(o, 0xa7, 0x76, 0x6f, 0x74, 0x65, 0x46, 0x73, 0x74)
			o = (*z).VoteFirstValid.MarshalMsg(o)
		}
		if (zb0001Mask & 0x80) == 0 { // if not empty
			// string "voteKD"
			o = append(o, 0xa6, 0x76, 0x6f, 0x74, 0x65, 0x4b, 0x44)
			o = msgp.AppendUint64(o, (*z).VoteKeyDilution)
		}
		if (zb0001Mask & 0x100) == 0 { // if not empty
			// string "voteLst"
			o = append(o, 0xa7, 0x76, 0x6f, 0x74, 0x65, 0x4c, 0x73, 0x74)
			o = (*z).VoteLastValid.MarshalMsg(o)
		}
	}
	return
}

func (_ *GenesisAccountData) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*GenesisAccountData)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *GenesisAccountData) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0001 int
	var zb0002 bool
	zb0001, zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0001, zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).Status.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Status")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).MicroAlgos.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "MicroAlgos")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).VoteID.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "VoteID")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).StateProofID.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "StateProofID")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).SelectionID.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "SelectionID")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).VoteFirstValid.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "VoteFirstValid")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).VoteLastValid.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "VoteLastValid")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			(*z).VoteKeyDilution, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "VoteKeyDilution")
				return
			}
		}
		if zb0001 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0001)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 {
			(*z) = GenesisAccountData{}
		}
		for zb0001 > 0 {
			zb0001--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "onl":
				bts, err = (*z).Status.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Status")
					return
				}
			case "algo":
				bts, err = (*z).MicroAlgos.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "MicroAlgos")
					return
				}
			case "vote":
				bts, err = (*z).VoteID.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "VoteID")
					return
				}
			case "stprf":
				bts, err = (*z).StateProofID.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "StateProofID")
					return
				}
			case "sel":
				bts, err = (*z).SelectionID.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "SelectionID")
					return
				}
			case "voteFst":
				bts, err = (*z).VoteFirstValid.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "VoteFirstValid")
					return
				}
			case "voteLst":
				bts, err = (*z).VoteLastValid.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "VoteLastValid")
					return
				}
			case "voteKD":
				(*z).VoteKeyDilution, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "VoteKeyDilution")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *GenesisAccountData) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *GenesisAccountData) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*GenesisAccountData)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *GenesisAccountData) Msgsize() (s int) {
	s = 1 + 4 + (*z).Status.Msgsize() + 5 + (*z).MicroAlgos.Msgsize() + 5 + (*z).VoteID.Msgsize() + 6 + (*z).StateProofID.Msgsize() + 4 + (*z).SelectionID.Msgsize() + 8 + (*z).VoteFirstValid.Msgsize() + 8 + (*z).VoteLastValid.Msgsize() + 7 + msgp.Uint64Size
	return
}

// MsgIsZero returns whether this is a zero value
func (z *GenesisAccountData) MsgIsZero() bool {
	return ((*z).Status.MsgIsZero()) && ((*z).MicroAlgos.MsgIsZero()) && ((*z).VoteID.MsgIsZero()) && ((*z).StateProofID.MsgIsZero()) && ((*z).SelectionID.MsgIsZero()) && ((*z).VoteFirstValid.MsgIsZero()) && ((*z).VoteLastValid.MsgIsZero()) && ((*z).VoteKeyDilution == 0)
}

// MaxSize returns a maximum valid message size for this message type
func GenesisAccountDataMaxSize() (s int) {
	s = 1 + 4 + basics.StatusMaxSize() + 5 + basics.MicroAlgosMaxSize() + 5 + crypto.OneTimeSignatureVerifierMaxSize() + 6 + merklesignature.CommitmentMaxSize() + 4 + crypto.VRFVerifierMaxSize() + 8 + basics.RoundMaxSize() + 8 + basics.RoundMaxSize() + 7 + msgp.Uint64Size
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *GenesisAllocation) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 3
	// string "addr"
	o = append(o, 0x83, 0xa4, 0x61, 0x64, 0x64, 0x72)
	o = msgp.AppendString(o, (*z).Address)
	// string "comment"
	o = append(o, 0xa7, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74)
	o = msgp.AppendString(o, (*z).Comment)
	// string "state"
	o = append(o, 0xa5, 0x73, 0x74, 0x61, 0x74, 0x65)
	o = (*z).State.MarshalMsg(o)
	return
}

func (_ *GenesisAllocation) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*GenesisAllocation)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *GenesisAllocation) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0001 int
	var zb0002 bool
	zb0001, zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0001, zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0001 > 0 {
			zb0001--
			(*z).Address, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Address")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			(*z).Comment, bts, err = msgp.ReadStringBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Comment")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).State.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "State")
				return
			}
		}
		if zb0001 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0001)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 {
			(*z) = GenesisAllocation{}
		}
		for zb0001 > 0 {
			zb0001--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "addr":
				(*z).Address, bts, err = msgp.ReadStringBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Address")
					return
				}
			case "comment":
				(*z).Comment, bts, err = msgp.ReadStringBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Comment")
					return
				}
			case "state":
				bts, err = (*z).State.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "State")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *GenesisAllocation) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *GenesisAllocation) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*GenesisAllocation)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *GenesisAllocation) Msgsize() (s int) {
	s = 1 + 5 + msgp.StringPrefixSize + len((*z).Address) + 8 + msgp.StringPrefixSize + len((*z).Comment) + 6 + (*z).State.Msgsize()
	return
}

// MsgIsZero returns whether this is a zero value
func (z *GenesisAllocation) MsgIsZero() bool {
	return ((*z).Address == "") && ((*z).Comment == "") && ((*z).State.MsgIsZero())
}

// MaxSize returns a maximum valid message size for this message type
func GenesisAllocationMaxSize() (s int) {
	s = 1 + 5
	panic("Unable to determine max size: String type z.Address is unbounded")
	s += 8
	panic("Unable to determine max size: String type z.Comment is unbounded")
	s += 6 + GenesisAccountDataMaxSize()
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *LightBlockHeader) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0001Len := uint32(5)
	var zb0001Mask uint8 /* 6 bits */
	if (*z).Seed.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x1
	}
	if (*z).BlockHash.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x2
	}
	if (*z).GenesisHash.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x8
	}
	if (*z).Round.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x10
	}
	if (*z).Sha256TxnCommitment.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x20
	}
	// variable map header, size zb0001Len
	o = append(o, 0x80|uint8(zb0001Len))
	if zb0001Len != 0 {
		if (zb0001Mask & 0x1) == 0 { // if not empty
			// string "0"
			o = append(o, 0xa1, 0x30)
			o = (*z).Seed.MarshalMsg(o)
		}
		if (zb0001Mask & 0x2) == 0 { // if not empty
			// string "1"
			o = append(o, 0xa1, 0x31)
			o = (*z).BlockHash.MarshalMsg(o)
		}
		if (zb0001Mask & 0x8) == 0 { // if not empty
			// string "gh"
			o = append(o, 0xa2, 0x67, 0x68)
			o = (*z).GenesisHash.MarshalMsg(o)
		}
		if (zb0001Mask & 0x10) == 0 { // if not empty
			// string "r"
			o = append(o, 0xa1, 0x72)
			o = (*z).Round.MarshalMsg(o)
		}
		if (zb0001Mask & 0x20) == 0 { // if not empty
			// string "tc"
			o = append(o, 0xa2, 0x74, 0x63)
			o = (*z).Sha256TxnCommitment.MarshalMsg(o)
		}
	}
	return
}

func (_ *LightBlockHeader) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*LightBlockHeader)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *LightBlockHeader) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0001 int
	var zb0002 bool
	zb0001, zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0001, zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).Seed.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Seed")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).BlockHash.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "BlockHash")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).Round.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Round")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).GenesisHash.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "GenesisHash")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).Sha256TxnCommitment.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Sha256TxnCommitment")
				return
			}
		}
		if zb0001 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0001)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 {
			(*z) = LightBlockHeader{}
		}
		for zb0001 > 0 {
			zb0001--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "0":
				bts, err = (*z).Seed.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Seed")
					return
				}
			case "1":
				bts, err = (*z).BlockHash.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "BlockHash")
					return
				}
			case "r":
				bts, err = (*z).Round.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Round")
					return
				}
			case "gh":
				bts, err = (*z).GenesisHash.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "GenesisHash")
					return
				}
			case "tc":
				bts, err = (*z).Sha256TxnCommitment.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Sha256TxnCommitment")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *LightBlockHeader) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *LightBlockHeader) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*LightBlockHeader)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *LightBlockHeader) Msgsize() (s int) {
	s = 1 + 2 + (*z).Seed.Msgsize() + 2 + (*z).BlockHash.Msgsize() + 2 + (*z).Round.Msgsize() + 3 + (*z).GenesisHash.Msgsize() + 3 + (*z).Sha256TxnCommitment.Msgsize()
	return
}

// MsgIsZero returns whether this is a zero value
func (z *LightBlockHeader) MsgIsZero() bool {
	return ((*z).Seed.MsgIsZero()) && ((*z).BlockHash.MsgIsZero()) && ((*z).Round.MsgIsZero()) && ((*z).GenesisHash.MsgIsZero()) && ((*z).Sha256TxnCommitment.MsgIsZero())
}

// MaxSize returns a maximum valid message size for this message type
func LightBlockHeaderMaxSize() (s int) {
	s = 1 + 2 + committee.SeedMaxSize() + 2 + BlockHashMaxSize() + 2 + basics.RoundMaxSize() + 3 + crypto.DigestMaxSize() + 3 + crypto.GenericDigestMaxSize()
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *ParticipationUpdates) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0003Len := uint32(2)
	var zb0003Mask uint8 /* 3 bits */
	if len((*z).AbsentParticipationAccounts) == 0 {
		zb0003Len--
		zb0003Mask |= 0x2
	}
	if len((*z).ExpiredParticipationAccounts) == 0 {
		zb0003Len--
		zb0003Mask |= 0x4
	}
	// variable map header, size zb0003Len
	o = append(o, 0x80|uint8(zb0003Len))
	if zb0003Len != 0 {
		if (zb0003Mask & 0x2) == 0 { // if not empty
			// string "partupdabs"
			o = append(o, 0xaa, 0x70, 0x61, 0x72, 0x74, 0x75, 0x70, 0x64, 0x61, 0x62, 0x73)
			if (*z).AbsentParticipationAccounts == nil {
				o = msgp.AppendNil(o)
			} else {
				o = msgp.AppendArrayHeader(o, uint32(len((*z).AbsentParticipationAccounts)))
			}
			for zb0002 := range (*z).AbsentParticipationAccounts {
				o = (*z).AbsentParticipationAccounts[zb0002].MarshalMsg(o)
			}
		}
		if (zb0003Mask & 0x4) == 0 { // if not empty
			// string "partupdrmv"
			o = append(o, 0xaa, 0x70, 0x61, 0x72, 0x74, 0x75, 0x70, 0x64, 0x72, 0x6d, 0x76)
			if (*z).ExpiredParticipationAccounts == nil {
				o = msgp.AppendNil(o)
			} else {
				o = msgp.AppendArrayHeader(o, uint32(len((*z).ExpiredParticipationAccounts)))
			}
			for zb0001 := range (*z).ExpiredParticipationAccounts {
				o = (*z).ExpiredParticipationAccounts[zb0001].MarshalMsg(o)
			}
		}
	}
	return
}

func (_ *ParticipationUpdates) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*ParticipationUpdates)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *ParticipationUpdates) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0003 int
	var zb0004 bool
	zb0003, zb0004, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0003, zb0004, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0003 > 0 {
			zb0003--
			var zb0005 int
			var zb0006 bool
			zb0005, zb0006, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "ExpiredParticipationAccounts")
				return
			}
			if zb0005 > config.MaxProposedExpiredOnlineAccounts {
				err = msgp.ErrOverflow(uint64(zb0005), uint64(config.MaxProposedExpiredOnlineAccounts))
				err = msgp.WrapError(err, "struct-from-array", "ExpiredParticipationAccounts")
				return
			}
			if zb0006 {
				(*z).ExpiredParticipationAccounts = nil
			} else if (*z).ExpiredParticipationAccounts != nil && cap((*z).ExpiredParticipationAccounts) >= zb0005 {
				(*z).ExpiredParticipationAccounts = ((*z).ExpiredParticipationAccounts)[:zb0005]
			} else {
				(*z).ExpiredParticipationAccounts = make([]basics.Address, zb0005)
			}
			for zb0001 := range (*z).ExpiredParticipationAccounts {
				bts, err = (*z).ExpiredParticipationAccounts[zb0001].UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "ExpiredParticipationAccounts", zb0001)
					return
				}
			}
		}
		if zb0003 > 0 {
			zb0003--
			var zb0007 int
			var zb0008 bool
			zb0007, zb0008, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "AbsentParticipationAccounts")
				return
			}
			if zb0007 > config.MaxMarkAbsent {
				err = msgp.ErrOverflow(uint64(zb0007), uint64(config.MaxMarkAbsent))
				err = msgp.WrapError(err, "struct-from-array", "AbsentParticipationAccounts")
				return
			}
			if zb0008 {
				(*z).AbsentParticipationAccounts = nil
			} else if (*z).AbsentParticipationAccounts != nil && cap((*z).AbsentParticipationAccounts) >= zb0007 {
				(*z).AbsentParticipationAccounts = ((*z).AbsentParticipationAccounts)[:zb0007]
			} else {
				(*z).AbsentParticipationAccounts = make([]basics.Address, zb0007)
			}
			for zb0002 := range (*z).AbsentParticipationAccounts {
				bts, err = (*z).AbsentParticipationAccounts[zb0002].UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "AbsentParticipationAccounts", zb0002)
					return
				}
			}
		}
		if zb0003 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0003)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0004 {
			(*z) = ParticipationUpdates{}
		}
		for zb0003 > 0 {
			zb0003--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "partupdrmv":
				var zb0009 int
				var zb0010 bool
				zb0009, zb0010, bts, err = msgp.ReadArrayHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "ExpiredParticipationAccounts")
					return
				}
				if zb0009 > config.MaxProposedExpiredOnlineAccounts {
					err = msgp.ErrOverflow(uint64(zb0009), uint64(config.MaxProposedExpiredOnlineAccounts))
					err = msgp.WrapError(err, "ExpiredParticipationAccounts")
					return
				}
				if zb0010 {
					(*z).ExpiredParticipationAccounts = nil
				} else if (*z).ExpiredParticipationAccounts != nil && cap((*z).ExpiredParticipationAccounts) >= zb0009 {
					(*z).ExpiredParticipationAccounts = ((*z).ExpiredParticipationAccounts)[:zb0009]
				} else {
					(*z).ExpiredParticipationAccounts = make([]basics.Address, zb0009)
				}
				for zb0001 := range (*z).ExpiredParticipationAccounts {
					bts, err = (*z).ExpiredParticipationAccounts[zb0001].UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "ExpiredParticipationAccounts", zb0001)
						return
					}
				}
			case "partupdabs":
				var zb0011 int
				var zb0012 bool
				zb0011, zb0012, bts, err = msgp.ReadArrayHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "AbsentParticipationAccounts")
					return
				}
				if zb0011 > config.MaxMarkAbsent {
					err = msgp.ErrOverflow(uint64(zb0011), uint64(config.MaxMarkAbsent))
					err = msgp.WrapError(err, "AbsentParticipationAccounts")
					return
				}
				if zb0012 {
					(*z).AbsentParticipationAccounts = nil
				} else if (*z).AbsentParticipationAccounts != nil && cap((*z).AbsentParticipationAccounts) >= zb0011 {
					(*z).AbsentParticipationAccounts = ((*z).AbsentParticipationAccounts)[:zb0011]
				} else {
					(*z).AbsentParticipationAccounts = make([]basics.Address, zb0011)
				}
				for zb0002 := range (*z).AbsentParticipationAccounts {
					bts, err = (*z).AbsentParticipationAccounts[zb0002].UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "AbsentParticipationAccounts", zb0002)
						return
					}
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *ParticipationUpdates) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *ParticipationUpdates) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*ParticipationUpdates)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *ParticipationUpdates) Msgsize() (s int) {
	s = 1 + 11 + msgp.ArrayHeaderSize
	for zb0001 := range (*z).ExpiredParticipationAccounts {
		s += (*z).ExpiredParticipationAccounts[zb0001].Msgsize()
	}
	s += 11 + msgp.ArrayHeaderSize
	for zb0002 := range (*z).AbsentParticipationAccounts {
		s += (*z).AbsentParticipationAccounts[zb0002].Msgsize()
	}
	return
}

// MsgIsZero returns whether this is a zero value
func (z *ParticipationUpdates) MsgIsZero() bool {
	return (len((*z).ExpiredParticipationAccounts) == 0) && (len((*z).AbsentParticipationAccounts) == 0)
}

// MaxSize returns a maximum valid message size for this message type
func ParticipationUpdatesMaxSize() (s int) {
	s = 1 + 11
	// Calculating size of slice: z.ExpiredParticipationAccounts
	s += msgp.ArrayHeaderSize + ((config.MaxProposedExpiredOnlineAccounts) * (basics.AddressMaxSize()))
	s += 11
	// Calculating size of slice: z.AbsentParticipationAccounts
	s += msgp.ArrayHeaderSize + ((config.MaxMarkAbsent) * (basics.AddressMaxSize()))
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *RewardsState) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0001Len := uint32(6)
	var zb0001Mask uint8 /* 7 bits */
	if (*z).RewardsLevel == 0 {
		zb0001Len--
		zb0001Mask |= 0x2
	}
	if (*z).FeeSink.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x4
	}
	if (*z).RewardsResidue == 0 {
		zb0001Len--
		zb0001Mask |= 0x8
	}
	if (*z).RewardsRate == 0 {
		zb0001Len--
		zb0001Mask |= 0x10
	}
	if (*z).RewardsRecalculationRound.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x20
	}
	if (*z).RewardsPool.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x40
	}
	// variable map header, size zb0001Len
	o = append(o, 0x80|uint8(zb0001Len))
	if zb0001Len != 0 {
		if (zb0001Mask & 0x2) == 0 { // if not empty
			// string "earn"
			o = append(o, 0xa4, 0x65, 0x61, 0x72, 0x6e)
			o = msgp.AppendUint64(o, (*z).RewardsLevel)
		}
		if (zb0001Mask & 0x4) == 0 { // if not empty
			// string "fees"
			o = append(o, 0xa4, 0x66, 0x65, 0x65, 0x73)
			o = (*z).FeeSink.MarshalMsg(o)
		}
		if (zb0001Mask & 0x8) == 0 { // if not empty
			// string "frac"
			o = append(o, 0xa4, 0x66, 0x72, 0x61, 0x63)
			o = msgp.AppendUint64(o, (*z).RewardsResidue)
		}
		if (zb0001Mask & 0x10) == 0 { // if not empty
			// string "rate"
			o = append(o, 0xa4, 0x72, 0x61, 0x74, 0x65)
			o = msgp.AppendUint64(o, (*z).RewardsRate)
		}
		if (zb0001Mask & 0x20) == 0 { // if not empty
			// string "rwcalr"
			o = append(o, 0xa6, 0x72, 0x77, 0x63, 0x61, 0x6c, 0x72)
			o = (*z).RewardsRecalculationRound.MarshalMsg(o)
		}
		if (zb0001Mask & 0x40) == 0 { // if not empty
			// string "rwd"
			o = append(o, 0xa3, 0x72, 0x77, 0x64)
			o = (*z).RewardsPool.MarshalMsg(o)
		}
	}
	return
}

func (_ *RewardsState) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*RewardsState)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *RewardsState) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0001 int
	var zb0002 bool
	zb0001, zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0001, zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).FeeSink.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "FeeSink")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).RewardsPool.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "RewardsPool")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			(*z).RewardsLevel, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "RewardsLevel")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			(*z).RewardsRate, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "RewardsRate")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			(*z).RewardsResidue, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "RewardsResidue")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).RewardsRecalculationRound.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "RewardsRecalculationRound")
				return
			}
		}
		if zb0001 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0001)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 {
			(*z) = RewardsState{}
		}
		for zb0001 > 0 {
			zb0001--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "fees":
				bts, err = (*z).FeeSink.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "FeeSink")
					return
				}
			case "rwd":
				bts, err = (*z).RewardsPool.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "RewardsPool")
					return
				}
			case "earn":
				(*z).RewardsLevel, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "RewardsLevel")
					return
				}
			case "rate":
				(*z).RewardsRate, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "RewardsRate")
					return
				}
			case "frac":
				(*z).RewardsResidue, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "RewardsResidue")
					return
				}
			case "rwcalr":
				bts, err = (*z).RewardsRecalculationRound.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "RewardsRecalculationRound")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *RewardsState) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *RewardsState) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*RewardsState)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *RewardsState) Msgsize() (s int) {
	s = 1 + 5 + (*z).FeeSink.Msgsize() + 4 + (*z).RewardsPool.Msgsize() + 5 + msgp.Uint64Size + 5 + msgp.Uint64Size + 5 + msgp.Uint64Size + 7 + (*z).RewardsRecalculationRound.Msgsize()
	return
}

// MsgIsZero returns whether this is a zero value
func (z *RewardsState) MsgIsZero() bool {
	return ((*z).FeeSink.MsgIsZero()) && ((*z).RewardsPool.MsgIsZero()) && ((*z).RewardsLevel == 0) && ((*z).RewardsRate == 0) && ((*z).RewardsResidue == 0) && ((*z).RewardsRecalculationRound.MsgIsZero())
}

// MaxSize returns a maximum valid message size for this message type
func RewardsStateMaxSize() (s int) {
	s = 1 + 5 + basics.AddressMaxSize() + 4 + basics.AddressMaxSize() + 5 + msgp.Uint64Size + 5 + msgp.Uint64Size + 5 + msgp.Uint64Size + 7 + basics.RoundMaxSize()
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *StateProofTrackingData) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0001Len := uint32(3)
	var zb0001Mask uint8 /* 4 bits */
	if (*z).StateProofNextRound.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x2
	}
	if (*z).StateProofOnlineTotalWeight.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x4
	}
	if (*z).StateProofVotersCommitment.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x8
	}
	// variable map header, size zb0001Len
	o = append(o, 0x80|uint8(zb0001Len))
	if zb0001Len != 0 {
		if (zb0001Mask & 0x2) == 0 { // if not empty
			// string "n"
			o = append(o, 0xa1, 0x6e)
			o = (*z).StateProofNextRound.MarshalMsg(o)
		}
		if (zb0001Mask & 0x4) == 0 { // if not empty
			// string "t"
			o = append(o, 0xa1, 0x74)
			o = (*z).StateProofOnlineTotalWeight.MarshalMsg(o)
		}
		if (zb0001Mask & 0x8) == 0 { // if not empty
			// string "v"
			o = append(o, 0xa1, 0x76)
			o = (*z).StateProofVotersCommitment.MarshalMsg(o)
		}
	}
	return
}

func (_ *StateProofTrackingData) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*StateProofTrackingData)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *StateProofTrackingData) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0001 int
	var zb0002 bool
	zb0001, zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0001, zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).StateProofVotersCommitment.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "StateProofVotersCommitment")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).StateProofOnlineTotalWeight.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "StateProofOnlineTotalWeight")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).StateProofNextRound.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "StateProofNextRound")
				return
			}
		}
		if zb0001 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0001)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 {
			(*z) = StateProofTrackingData{}
		}
		for zb0001 > 0 {
			zb0001--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "v":
				bts, err = (*z).StateProofVotersCommitment.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "StateProofVotersCommitment")
					return
				}
			case "t":
				bts, err = (*z).StateProofOnlineTotalWeight.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "StateProofOnlineTotalWeight")
					return
				}
			case "n":
				bts, err = (*z).StateProofNextRound.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "StateProofNextRound")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *StateProofTrackingData) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *StateProofTrackingData) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*StateProofTrackingData)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *StateProofTrackingData) Msgsize() (s int) {
	s = 1 + 2 + (*z).StateProofVotersCommitment.Msgsize() + 2 + (*z).StateProofOnlineTotalWeight.Msgsize() + 2 + (*z).StateProofNextRound.Msgsize()
	return
}

// MsgIsZero returns whether this is a zero value
func (z *StateProofTrackingData) MsgIsZero() bool {
	return ((*z).StateProofVotersCommitment.MsgIsZero()) && ((*z).StateProofOnlineTotalWeight.MsgIsZero()) && ((*z).StateProofNextRound.MsgIsZero())
}

// MaxSize returns a maximum valid message size for this message type
func StateProofTrackingDataMaxSize() (s int) {
	s = 1 + 2 + crypto.GenericDigestMaxSize() + 2 + basics.MicroAlgosMaxSize() + 2 + basics.RoundMaxSize()
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *TxnCommitments) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0001Len := uint32(2)
	var zb0001Mask uint8 /* 3 bits */
	if (*z).NativeSha512_256Commitment.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x2
	}
	if (*z).Sha256Commitment.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x4
	}
	// variable map header, size zb0001Len
	o = append(o, 0x80|uint8(zb0001Len))
	if zb0001Len != 0 {
		if (zb0001Mask & 0x2) == 0 { // if not empty
			// string "txn"
			o = append(o, 0xa3, 0x74, 0x78, 0x6e)
			o = (*z).NativeSha512_256Commitment.MarshalMsg(o)
		}
		if (zb0001Mask & 0x4) == 0 { // if not empty
			// string "txn256"
			o = append(o, 0xa6, 0x74, 0x78, 0x6e, 0x32, 0x35, 0x36)
			o = (*z).Sha256Commitment.MarshalMsg(o)
		}
	}
	return
}

func (_ *TxnCommitments) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*TxnCommitments)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *TxnCommitments) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0001 int
	var zb0002 bool
	zb0001, zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0001, zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).NativeSha512_256Commitment.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "NativeSha512_256Commitment")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).Sha256Commitment.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Sha256Commitment")
				return
			}
		}
		if zb0001 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0001)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 {
			(*z) = TxnCommitments{}
		}
		for zb0001 > 0 {
			zb0001--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "txn":
				bts, err = (*z).NativeSha512_256Commitment.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "NativeSha512_256Commitment")
					return
				}
			case "txn256":
				bts, err = (*z).Sha256Commitment.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "Sha256Commitment")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *TxnCommitments) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *TxnCommitments) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*TxnCommitments)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *TxnCommitments) Msgsize() (s int) {
	s = 1 + 4 + (*z).NativeSha512_256Commitment.Msgsize() + 7 + (*z).Sha256Commitment.Msgsize()
	return
}

// MsgIsZero returns whether this is a zero value
func (z *TxnCommitments) MsgIsZero() bool {
	return ((*z).NativeSha512_256Commitment.MsgIsZero()) && ((*z).Sha256Commitment.MsgIsZero())
}

// MaxSize returns a maximum valid message size for this message type
func TxnCommitmentsMaxSize() (s int) {
	s = 1 + 4 + crypto.DigestMaxSize() + 7 + crypto.DigestMaxSize()
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *UpgradeVote) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0001Len := uint32(3)
	var zb0001Mask uint8 /* 4 bits */
	if (*z).UpgradeDelay.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x2
	}
	if (*z).UpgradePropose.MsgIsZero() {
		zb0001Len--
		zb0001Mask |= 0x4
	}
	if (*z).UpgradeApprove == false {
		zb0001Len--
		zb0001Mask |= 0x8
	}
	// variable map header, size zb0001Len
	o = append(o, 0x80|uint8(zb0001Len))
	if zb0001Len != 0 {
		if (zb0001Mask & 0x2) == 0 { // if not empty
			// string "upgradedelay"
			o = append(o, 0xac, 0x75, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x64, 0x65, 0x6c, 0x61, 0x79)
			o = (*z).UpgradeDelay.MarshalMsg(o)
		}
		if (zb0001Mask & 0x4) == 0 { // if not empty
			// string "upgradeprop"
			o = append(o, 0xab, 0x75, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x70, 0x72, 0x6f, 0x70)
			o = (*z).UpgradePropose.MarshalMsg(o)
		}
		if (zb0001Mask & 0x8) == 0 { // if not empty
			// string "upgradeyes"
			o = append(o, 0xaa, 0x75, 0x70, 0x67, 0x72, 0x61, 0x64, 0x65, 0x79, 0x65, 0x73)
			o = msgp.AppendBool(o, (*z).UpgradeApprove)
		}
	}
	return
}

func (_ *UpgradeVote) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*UpgradeVote)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *UpgradeVote) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0001 int
	var zb0002 bool
	zb0001, zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0001, zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).UpgradePropose.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "UpgradePropose")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			bts, err = (*z).UpgradeDelay.UnmarshalMsgWithState(bts, st)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "UpgradeDelay")
				return
			}
		}
		if zb0001 > 0 {
			zb0001--
			(*z).UpgradeApprove, bts, err = msgp.ReadBoolBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "UpgradeApprove")
				return
			}
		}
		if zb0001 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0001)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 {
			(*z) = UpgradeVote{}
		}
		for zb0001 > 0 {
			zb0001--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "upgradeprop":
				bts, err = (*z).UpgradePropose.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "UpgradePropose")
					return
				}
			case "upgradedelay":
				bts, err = (*z).UpgradeDelay.UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "UpgradeDelay")
					return
				}
			case "upgradeyes":
				(*z).UpgradeApprove, bts, err = msgp.ReadBoolBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "UpgradeApprove")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *UpgradeVote) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *UpgradeVote) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*UpgradeVote)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *UpgradeVote) Msgsize() (s int) {
	s = 1 + 12 + (*z).UpgradePropose.Msgsize() + 13 + (*z).UpgradeDelay.Msgsize() + 11 + msgp.BoolSize
	return
}

// MsgIsZero returns whether this is a zero value
func (z *UpgradeVote) MsgIsZero() bool {
	return ((*z).UpgradePropose.MsgIsZero()) && ((*z).UpgradeDelay.MsgIsZero()) && ((*z).UpgradeApprove == false)
}

// MaxSize returns a maximum valid message size for this message type
func UpgradeVoteMaxSize() (s int) {
	s = 1 + 12 + protocol.ConsensusVersionMaxSize() + 13 + basics.RoundMaxSize() + 11 + msgp.BoolSize
	return
}
