// Package public provides primitives to interact with the openapi HTTP API.
//
// Code generated by github.com/algorand/oapi-codegen DO NOT EDIT.
package public

import (
	"bytes"
	"compress/gzip"
	"encoding/base64"
	"fmt"
	"net/http"
	"net/url"
	"path"
	"strings"

	. "github.com/algorand/go-algorand/daemon/algod/api/server/v2/generated/model"
	"github.com/algorand/oapi-codegen/pkg/runtime"
	"github.com/getkin/kin-openapi/openapi3"
	"github.com/labstack/echo/v4"
)

// ServerInterface represents all server handlers.
type ServerInterface interface {
	// Get a list of unconfirmed transactions currently in the transaction pool by address.
	// (GET /v2/accounts/{address}/transactions/pending)
	GetPendingTransactionsByAddress(ctx echo.Context, address string, params GetPendingTransactionsByAddressParams) error
	// Broadcasts a raw transaction or transaction group to the network.
	// (POST /v2/transactions)
	RawTransaction(ctx echo.Context) error
	// Get a list of unconfirmed transactions currently in the transaction pool.
	// (GET /v2/transactions/pending)
	GetPendingTransactions(ctx echo.Context, params GetPendingTransactionsParams) error
	// Get a specific pending transaction.
	// (GET /v2/transactions/pending/{txid})
	PendingTransactionInformation(ctx echo.Context, txid string, params PendingTransactionInformationParams) error
}

// ServerInterfaceWrapper converts echo contexts to parameters.
type ServerInterfaceWrapper struct {
	Handler ServerInterface
}

// GetPendingTransactionsByAddress converts echo context to params.
func (w *ServerInterfaceWrapper) GetPendingTransactionsByAddress(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "address" -------------
	var address string

	err = runtime.BindStyledParameterWithLocation("simple", false, "address", runtime.ParamLocationPath, ctx.Param("address"), &address)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter address: %s", err))
	}

	ctx.Set(Api_keyScopes, []string{""})

	// Parameter object where we will unmarshal all parameters from the context
	var params GetPendingTransactionsByAddressParams
	// ------------- Optional query parameter "max" -------------

	err = runtime.BindQueryParameter("form", true, false, "max", ctx.QueryParams(), &params.Max)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter max: %s", err))
	}

	// ------------- Optional query parameter "format" -------------

	err = runtime.BindQueryParameter("form", true, false, "format", ctx.QueryParams(), &params.Format)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter format: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetPendingTransactionsByAddress(ctx, address, params)
	return err
}

// RawTransaction converts echo context to params.
func (w *ServerInterfaceWrapper) RawTransaction(ctx echo.Context) error {
	var err error

	ctx.Set(Api_keyScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.RawTransaction(ctx)
	return err
}

// GetPendingTransactions converts echo context to params.
func (w *ServerInterfaceWrapper) GetPendingTransactions(ctx echo.Context) error {
	var err error

	ctx.Set(Api_keyScopes, []string{""})

	// Parameter object where we will unmarshal all parameters from the context
	var params GetPendingTransactionsParams
	// ------------- Optional query parameter "max" -------------

	err = runtime.BindQueryParameter("form", true, false, "max", ctx.QueryParams(), &params.Max)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter max: %s", err))
	}

	// ------------- Optional query parameter "format" -------------

	err = runtime.BindQueryParameter("form", true, false, "format", ctx.QueryParams(), &params.Format)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter format: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetPendingTransactions(ctx, params)
	return err
}

// PendingTransactionInformation converts echo context to params.
func (w *ServerInterfaceWrapper) PendingTransactionInformation(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "txid" -------------
	var txid string

	err = runtime.BindStyledParameterWithLocation("simple", false, "txid", runtime.ParamLocationPath, ctx.Param("txid"), &txid)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter txid: %s", err))
	}

	ctx.Set(Api_keyScopes, []string{""})

	// Parameter object where we will unmarshal all parameters from the context
	var params PendingTransactionInformationParams
	// ------------- Optional query parameter "format" -------------

	err = runtime.BindQueryParameter("form", true, false, "format", ctx.QueryParams(), &params.Format)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter format: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.PendingTransactionInformation(ctx, txid, params)
	return err
}

// This is a simple interface which specifies echo.Route addition functions which
// are present on both echo.Echo and echo.Group, since we want to allow using
// either of them for path registration
type EchoRouter interface {
	CONNECT(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	DELETE(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	GET(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	HEAD(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	OPTIONS(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	PATCH(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	POST(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	PUT(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	TRACE(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
}

// RegisterHandlers adds each server route to the EchoRouter.
func RegisterHandlers(router EchoRouter, si ServerInterface, m ...echo.MiddlewareFunc) {
	RegisterHandlersWithBaseURL(router, si, "", m...)
}

// Registers handlers, and prepends BaseURL to the paths, so that the paths
// can be served under a prefix.
func RegisterHandlersWithBaseURL(router EchoRouter, si ServerInterface, baseURL string, m ...echo.MiddlewareFunc) {

	wrapper := ServerInterfaceWrapper{
		Handler: si,
	}

	router.GET(baseURL+"/v2/accounts/:address/transactions/pending", wrapper.GetPendingTransactionsByAddress, m...)
	router.POST(baseURL+"/v2/transactions", wrapper.RawTransaction, m...)
	router.GET(baseURL+"/v2/transactions/pending", wrapper.GetPendingTransactions, m...)
	router.GET(baseURL+"/v2/transactions/pending/:txid", wrapper.PendingTransactionInformation, m...)

}

// Base64 encoded, gzipped, json marshaled Swagger object
var swaggerSpec = []string{

	"H4sIAAAAAAAC/+x9a3fctpLgX8H2zDm2NU1JfiRz4z05s4od52pixz6Wkpk7ljdBk9XduCIBXgDsR7z+",
	"73tQAEiQBLvZkmInM/lkq4lHoVAo1AtVHyapKErBgWs1efphUlJJC9Ag8S+apqLiOmGZ+SsDlUpWaib4",
	"5Kn/RpSWjC8m0wkzv5ZULyfTCacFNG1M/+lEwj8qJiGbPNWygulEpUsoqBlYb0vTuh5pkyxE4oY4s0Oc",
	"P5983PGBZpkEpfpQvub5ljCe5lUGREvKFU3NJ0XWTC+JXjJFXGfCOBEciJgTvWw1JnMGeaaO/SL/UYHc",
	"Bqt0kw8v6WMDYiJFDn04n4lixjh4qKAGqt4QogXJYI6NllQTM4OB1TfUgiigMl2SuZB7QLVAhPACr4rJ",
	"03cTBTwDibuVAlvhf+cS4FdINJUL0JP309ji5hpkolkRWdq5w74EVeVaEWyLa1ywFXBieh2TV5XSZAaE",
	"cvL2xTPy+PHjr8xCCqo1ZI7IBlfVzB6uyXafPJ1kVIP/3Kc1mi+EpDxL6vZvXzzD+S/cAse2okpB/LCc",
	"mS/k/PnQAnzHCAkxrmGB+9CiftMjciian2cwFxJG7oltfKebEs7/WXclpTpdloJxHdkXgl+J/RzlYUH3",
	"XTysBqDVvjSYkmbQd6fJV+8/PJw+PP34T+/Okv9yf37x+OPI5T+rx92DgWjDtJISeLpNFhIonpYl5X18",
	"vHX0oJaiyjOypCvcfFogq3d9ielrWeeK5pWhE5ZKcZYvhCLUkVEGc1rlmviJScVzw6bMaI7aCVOklGLF",
	"MsimhvuulyxdkpQqOwS2I2uW54YGKwXZEK3FV7fjMH0MUWLguhE+cEG/X2Q069qDCdggN0jSXChItNhz",
	"Pfkbh/KMhBdKc1epwy4rcrkEgpObD/ayRdxxQ9N5viUa9zUjVBFK/NU0JWxOtqIia9ycnF1jf7cag7WC",
	"GKTh5rTuUXN4h9DXQ0YEeTMhcqAckefPXR9lfM4WlQRF1kvQS3fnSVCl4AqImP0dUm22/d8vXv9AhCSv",
	"QCm6gDc0vSbAU5FBdkzO54QLHZCGoyXEoek5tA4HV+yS/7sShiYKtShpeh2/0XNWsMiqXtENK6qC8KqY",
	"gTRb6q8QLYgEXUk+BJAdcQ8pFnTTn/RSVjzF/W+mbclyhtqYKnO6RYQVdPP16dSBowjNc1ICzxhfEL3h",
	"g3KcmXs/eIkUFc9GiDna7GlwsaoSUjZnkJF6lB2QuGn2wcP4YfA0wlcAjh9kEJx6lj3gcNhEaMacbvOF",
	"lHQBAckckx8dc8OvWlwDrwmdzLb4qZSwYqJSdacBGHHq3RI4FxqSUsKcRWjswqHDMBjbxnHgwslAqeCa",
	"Mg6ZYc4ItNBgmdUgTMGEu/Wd/i0+owq+fDJ0xzdfR+7+XHR3feeOj9ptbJTYIxm5Os1Xd2DjklWr/wj9",
	"MJxbsUVif+5tJFtcmttmznK8if5u9s+joVLIBFqI8HeTYgtOdSXh6RU/Mn+RhFxoyjMqM/NLYX96VeWa",
	"XbCF+Sm3P70UC5ZesMUAMmtYowoXdivsP2a8ODvWm6he8VKI66oMF5S2FNfZlpw/H9pkO+ahhHlWa7uh",
	"4nG58crIoT30pt7IASAHcVdS0/AathIMtDSd4z+bOdITnctfzT9lmZveupzHUGvo2F3JaD5wZoWzssxZ",
	"Sg0S37rP5qthAmAVCdq0OMEL9emHAMRSihKkZnZQWpZJLlKaJ0pTjSP9s4T55Onkn04a+8uJ7a5Ogslf",
	"ml4X2MmIrFYMSmhZHjDGGyP6qB3MwjBo/IRswrI9FJoYt5toSIkZFpzDinJ93KgsLX5QH+B3bqYG31ba",
	"sfjuqGCDCCe24QyUlYBtw3uKBKgniFaCaEWBdJGLWf3D/bOybDCI38/K0uIDpUdgKJjBhimtHuDyaXOS",
	"wnnOnx+T78KxURQXPN+ay8GKGuZumLtby91itW3JraEZ8Z4iuJ1CHput8WgwYv5dUByqFUuRG6lnL62Y",
	"xn91bUMyM7+P6vzHILEQt8PEhYqWw5zVcfCXQLm536GcPuE4c88xOev2vRnZmFF2EIw6b7B418SDvzAN",
	"hdpLCQFEATW57aFS0u3ECYkJCnt9MvlRgaWQki4YR2inRn3ipKDXdj8E4t0QAqhaL7K0ZCXI2oTqZE6H",
	"+uOeneUPQK2xjfWSqJFUc6Y06tXYmCwhR8GZck/QIanciDJGbPiORdQwryUtLS27L1bsYhz1edvIwnrL",
	"i3fknRiFOWD3wUYjVDdmy3tZZxQS5BodGL7JRXr9V6qWd3DCZ36sPu3jNGQJNANJllQtIwenQ9vNaGPo",
	"2zREmiWzYKrjeokvxULdwRJzcQjrKstnNM/N1H2W1VktDjzqIOc5MY0JFAwN5k5xtBZ2q3+Rb2m6NGIB",
	"SWmeTxtTkSiTHFaQG6WdcQ5ySvSS6ubw48her8FzpMAwOw0kWI0zM6GJTda2CAmkoHgDFUabKfN2n5qD",
	"KlpARwrCG1FUaEUIFI3z5351sAKOPKkeGsGv14jWmnDwYzO3+4Qzc2EXZy2A2rvvavzV/KIFtGnd3Ke8",
	"mULIzNqstfmNSZIKaYewN7yb3PwHqGw6W+q8X0pI3BCSrkAqmpvVdRb1oCbfuzqde05mRjUNTqajwrgC",
	"ZjkH9kPxDmTESvMa/0NzYj4bKcZQUkM9DIUREbhTM3sxG1TZmUwDtLcKUlhTJilpen0QlM+ayeNsZtTJ",
	"+9ZaT90WukXUO3S5YZm6q23CwYb2qn1CrO3Ks6OeLLKT6QRzjUHApSiJZR8dECynwNEsQsTmzq+1b8Qm",
	"BtM3YtO70sQG7mQnzDijmf03YvPcQSbkfszj2GOQbhbIaQEKbzceMk4zS+OXO5sJeTNponPBcNJ4Gwk1",
	"owbC1LSDJGxalYk7mxGPhW3QGagJ8NgtBHSHj2GshYULTX8DLCgz6l1goT3QXWNBFCXL4Q5IfxkV4mZU",
	"weNH5OKvZ188fPTzoy++NCRZSrGQtCCzrQZF7juzHFF6m8ODqHaE0kV89C+feB9Ve9zYOEpUMoWClv2h",
	"rO/Lar+2GTHt+lhroxlXXQM4iiOCudos2ol16xrQnsOsWlyA1kbTfSPF/M65YW+GGHTY6E0pjWCh2n5C",
	"Jy2dZKbJCWy0pCcltgSe2TgDsw6mjA5YzO6EqIY2PmtmyYjDaAZ7D8Wh29RMsw23Sm5ldRfmDZBSyOgV",
	"XEqhRSryxMh5TEQMFG9cC+Ja+O0qu79baMmaKmLmRu9lxbMBO4Te8PH3lx36csMb3Oy8wex6I6tz847Z",
	"lzbyGy2kBJnoDSdInS3zyFyKglCSYUeUNb4DbeUvVsCFpkX5ej6/G2unwIEidhxWgDIzEdvCSD8KUsFt",
	"MN8ek40bdQx6uojxXiY9DIDDyMWWp+gqu4tjO2zNKhhHv73a8jQwbRkYc8gWLbK8vQlrCB12qnsqAo5B",
	"x0v8jLb655Br+kLIy0Z8/U6Kqrxz9tydc+xyqFuM8wZkpq83AzO+yNsBpAsD+3FsjZ9lQc9qI4JdA0KP",
	"FPmSLZY60BffSPEb3InRWWKA4gdrLMpNn77J6AeRGWaiK3UHomQzWMPhDN2GfI3ORKUJJVxkgJtfqbiQ",
	"ORByiLFOGKKlQ7kV7RNMkRkY6kppZVZblQQDkHr3RdMxoak9oQmiRg2EX9RxM7aVnc6Gs+USaLYlMwBO",
	"xMzFOLjoC1wkxegp7cU0J+JG+EULrlKKFJSCLHGm6L2g+Xb26tA78ISAI8D1LEQJMqfy1sBer/bCeQ3b",
	"BGP9FLn//U/qwWeAVwtN8z2IxTYx9HbtaX2ox02/i+C6k4dkZy11lmqNeGsYRA4ahlB4EE4G968LUW8X",
	"b4+WFUgMKflNKd5PcjsCqkH9jen9ttBW5UAEu1PTjYRnNoxTLrxgFRssp0on+9iyadSyJZgVBJwwxolx",
	"4AHB6yVV2oZBMZ6hTdNeJziPFcLMFMMAD6ohZuSfvAbSHzs19yBXlarVEVWVpZAastga0CM7ONcPsKnn",
	"EvNg7Frn0YJUCvaNPISlYHyHLKcB4x9U1/5X59HtLw596uae30ZR2QKiQcQuQC58qwC7YRTvACBMNYi2",
	"hMNUh3Lq0OHpRGlRloZb6KTidb8hNF3Y1mf6x6Ztn7isk8Pe25kAhQ4U195BvraYtfHbS6qIg8O72NGc",
	"Y+O1+jCbw5goxlNIdlE+qnimVXgE9h7SqlxImkGSQU63keAA+5nYz7sGwB1v1F2hIbGBuPFNbyjZxz3u",
	"GFrgeComPBL8QlJzBI0q0BCI671n5Axw7BhzcnR0rx4K54pukR8Pl223OjIi3oYroc2OO3pAkB1HHwPw",
	"AB7qoW+OCuycNLpnd4q/gXIT1HLE4ZNsQQ0toRn/oAUM2ILdG6fgvHTYe4cDR9nmIBvbw0eGjuyAYfoN",
	"lZqlrERd53vY3rnq150g6jgnGWjKcshI8MGqgWXYn9gQ0u6YN1MFR9ne+uD3jG+R5fgwnTbw17BFnfuN",
	"fZsQmDruQpeNjGruJ8oJAuojno0IHjaBDU11vjWCml7ClqxBAlHVzIYw9P0pWpRJOEDUP7NjRuedjfpG",
	"d7qLL3CoYHmxWDOrE+yG77KjGLTQ4XSBUoh8hIWsh4woBKNiR0gpzK4z9/zJP4DxlNQC0jFtdM3X1/89",
	"1UIzroD8TVQkpRxVrkpDLdMIiYICCpBmBiOC1XO64MQGQ5BDAVaTxC9HR92FHx25PWeKzGHt3wyahl10",
	"HB2hHeeNULp1uO7AHmqO23nk+kDHlbn4nBbS5Sn7I57cyGN28k1n8NrbZc6UUo5wzfJvzQA6J3MzZu0h",
	"jYyL9sJxR/ly2vFBvXXjvl+wosqpvguvFaxonogVSMky2MvJ3cRM8G9XNH9dd8P3kJAaGk0hSfEV38ix",
	"4NL0sQ//zDiMM3OAbdD/WIDg3Pa6sJ32qJhNpCorCsgY1ZBvSSkhBfvezUiOql7qMbGR8OmS8gUqDFJU",
	"CxfcasdBhl8pa5qRFe8NERWq9IYnaOSOXQAuTM0/eTTiFFCj0nUt5FaBWdN6PvfKdczNHOxB12MQdZJN",
	"J4Mar0HqqtF4LXLa7zZHXAYteS/ATzPxSFcKos7IPn18hdtiDpPZ3N/GZN8MHYOyP3EQ8dt8HAr6Nep2",
	"vr0DoccORCSUEhReUaGZStmvYh6+0fahgluloehb8m3XnweO39tBfVHwnHFICsFhG01Lwji8wo/R44TX",
	"5EBnFFiG+nZ1kBb8HbDa84yhxtviF3e7e0K7Hiv1Qsi7conaAUeL9yM8kHvd7W7Km/pJaZ5HXIvuBWeX",
	"AahpHazLJKFKiZShzHaeqamLCrbeSPfcs43+N/W7lDs4e91xOz60MDkA2oghLwklac7Qgiy40rJK9RWn",
	"aKMKlhoJ4vLK+LDV8plvEjeTRqyYbqgrTjGAr7ZcRQM25hAx07wA8MZLVS0WoHRH15kDXHHXinFScaZx",
	"rsIcl8SelxIkRlId25YF3ZK5oQktyK8gBZlVui394wNlpVmeO4eemYaI+RWnmuRAlSavGL/c4HDe6e+P",
	"LAe9FvK6xkL8dl8AB8VUEg82+85+xbh+t/yli/HHcHf72QedNhkTJmaZrSQp//f+vz19d5b8F01+PU2+",
	"+peT9x+efHxw1Pvx0cevv/5/7Z8ef/z6wb/9c2ynPOyx57MO8vPnTjM+f47qTxCq34X9k9n/C8aTKJGF",
	"0Rwd2iL3MVWEI6AHbeOYXsIV1xtuCGlFc5YZ3nITcujeML2zaE9Hh2paG9Exhvm1HqhU3ILLkAiT6bDG",
	"G0tR/fjM+EN1dEq6t+d4XuYVt1vppW/7DtPHl4n5tE5GYPOUPSX4Un1JfZCn+/PRF19Ops0L8/r7ZDpx",
	"X99HKJllm1gegQw2MV0xfCRxT5GSbhXoOPdA2KOhdDa2Ixy2gGIGUi1Z+ek5hdJsFudw/smSszlt+Dm3",
	"Af7m/KCLc+s8J2L+6eHWEiCDUi9j+Ytaghq2anYToBN2UkqxAj4l7BiOuzafzOiLLqgvBzr3galSiDHa",
	"UH0OLKF5qgiwHi5klGElRj+d5w3u8ld3rg65gWNwdeeMRfTe++7bS3LiGKa6Z1Na2KGDJAQRVdo9nmwF",
	"JBluFr4pu+JX/DnM0fog+NMrnlFNT2ZUsVSdVArkNzSnPIXjhSBP/XvM51TTK96TtAYTKwaPpklZzXKW",
	"kutQIWnI0ybL6o9wdfWO5gtxdfW+F5vRVx/cVFH+YidIjCAsKp24VD+JhDWVMd+XqlO94Mg2l9euWa2Q",
	"LSprIPWphNz4cZ5Hy1J1Uz70l1+WuVl+QIbKJTQwW0aUFvV7NCOguCe9Zn9/EO5ikHTt7SqVAkV+KWj5",
	"jnH9niRX1enpY3zZ1+RA+MVd+YYmtyWMtq4MpqToGlVw4VatxFj1pKSLmIvt6uqdBlri7qO8XKCNI88J",
	"dmu9OvQPDHCoZgH1E+fBDbBwHPw4GBd3YXv5tI7xJeAn3ML2A+xb7Vfwfv7G27XnDT6t9DIxZzu6KmVI",
	"3O9Mne1tYYQsH42h2AK1VZcYbwYkXUJ67TKWQVHq7bTV3Qf8OEHTsw6mbC47+8IQsymhg2IGpCoz6kRx",
	"yrfdtDbKvqjAQd/CNWwvRZOM6ZA8Nu20KmrooCKlBtKlIdbw2Loxupvvosr8Q1OXnQQfb3qyeFrThe8z",
	"fJCtyHsHhzhGFK20H0OIoDKCCEv8Ayi4wULNeLci/djyGE+Ba7aCBHK2YLNYGt7/6PvDPKyGKl3mQReF",
	"XA+oCJsTo8rP7MXq1HtJ+QLM9WyuVKFobrOqRoM2UB9aApV6BlTvtPPzMCGFhw5VyjW+vEYL39QsATZm",
	"v5lGix2HtdEq0FBk27jo5ePh+DMLOGQ3hMd3bzSF40Fd16EuknHQ38o1dmu11oXmhXSGcNnvBWDKUrE2",
	"+2KgEC7bpk3qEtwvlaILGNBdQu/dyHwYLY8fDrJPIonKIGLeFTV6kkAUZNs4MWuOnmEwX8whRjWzE5Dp",
	"Z7IOYuczwiTaDmGzHAXYOnLV7j2VLS+qzQo8BFqctYDkjSjowWhjJDyOS6r8ccR8qZ7LjpLOfsO0L7tS",
	"050HsYRBUtQ68Zy/DbsctKf3uwR1PiudT0UXKv0j0soZ3QufL8S2Q3AUTTPIYWEXbht7QmkSJjUbZOB4",
	"PZ8jb0liYYmBgToQANwcYDSXI0Ksb4SMHiFGxgHYGPiAA5MfRHg2+eIQILlL+ET92HhFBH9D/GGfDdQ3",
	"wqgozeXKBvyNqecALhVFI1l0IqpxGML4lBg2t6K5YXNOF28G6WVIQ4Wikw/Nhd48GFI0drim7JV/0Jqs",
	"kHCT1YTSrAc6LmrvgHgmNol9oRzVRWabmaH36NsFfC8dO5g2F909RWZig+FceLXYWPk9sAzD4cEIbC8b",
	"ppBesd+QnGWB2TXtbjk3RoUKScYZWmtyGRL0xkw9IFsOkcv9IL3cjQDomKGaWg3OLLHXfNAWT/qXeXOr",
	"TZu0qf5ZWOz4Dx2h6C4N4K9vH2snhPtrk/hvOLmYP1GfJBNe37J0mwyFtnNpsw4ekqCwSw4tIHZg9U1X",
	"DoyitR3r1cZrgLUYKzHMt++U7KNNQQ6oBCct0TS5jkUKGF0e8B6/8N0CYx3uHuXbB0EAoYQFUxoap5GP",
	"C/oc5niK6ZOFmA+vTpdybtb3Voj68rduc+zYWuYnXwFG4M+ZVDpBj1t0CabRC4VGpBemaVwCbYco2mID",
	"LItzXJz2GrZJxvIqTq9u3u+fm2l/qC8aVc3wFmPcBmjNsDhGNHB5x9Q2tn3ngl/aBb+kd7becafBNDUT",
	"S0Mu7Tn+IOeiw8B2sYMIAcaIo79rgyjdwSCDB+d97hhIo0FMy/Eub0PvMGV+7L1Rav7Z+9DNb0eKriVI",
	"Axh/ISgWC8h8ejPvD+NBErlc8EVQxaksd+XMOyY2dR1mntuRtM6F4cNQEH4g7ieMZ7CJQx9qBQh587IO",
	"E+7hJAvgNl1J3CwURU0Y4o8tAlvdJ/aFdh8ARIOgLzvO7CY62e5SvZ24ATnQzOkkCvz6dh/L/oY41E2H",
	"wqdbmU93HyEcEGmK6aCwST8NwQADpmXJsk3H8WRHHTSC0YOsywPSFrIWN9geDLSDoKME10ql7UKtnYH9",
	"BHXeE6OV2dhrF1hs6Jum7gF+Vkn0YLQim/t522tdbeTav//pQgtJF+C8UIkF6VZD4HIOQUOQFV0RzWw4",
	"Scbmcwi9L+omnoMWcD0bezaCdCNEFnfRVIzrL5/EyGgP9TQw7kdZnGIitDDkk7/se7m8TB+YkuorIdia",
	"G7iqos/1v4dt8hPNK6NkMKma8Fzndmpfvgfs+qr4HrY48t6oVwPYnl1By9NbQBqMWfrrTypIYH1PtVL8",
	"o3rZ2sIDduosvkt3tDWuKMMw8Te3TKtoQXsptzkYTZCEgWXMblzEYxPM6YE24rukvG8TWLZfBgnk/XAq",
	"pnwJy/5VVOei2Ee7l0BzT7y4nMnH6eR2kQCx28yNuAfXb+oLNIpnjDS1nuFWYM+BKKdlKcWK5omLlxi6",
	"/KVYucsfm/vwik+sycQp+/Lbs5dvHPgfp5M0ByqT2hIwuCpsV/5hVmXLOOy+Smy2b2fotJaiYPPrjMxh",
	"jMUaM3t3jE29oihN/ExwFF3MxTwe8L6X97lQH7vEHSE/UNYRP43P0wb8tIN86Iqy3DsbPbQDwem4uHGV",
	"daJcIRzg1sFCQczXrccafNxwdfVu5fHYuAlswEydXz0SQaVGGMi7TCR+CBsi3sP6cEmvMQNmXLHhLj8m",
	"cjwXY0TvXEh7IWTrjnEPIKMxSr+d9GZkeYvHgZBwXyazK7MdEyvf/bL4xRz6o6PwRB8dTckvufsQAIi/",
	"z9zvqMYcHUWdlFFrmeFFaAzjtIAH9WOOwY34tHo+h/U4OeBsVdQCrBgmw5pCbbCRR/faYW8tmcNn5n7J",
	"IAfz0/EYW0C46RbdITBjTtDF0IPHOpa1sJU5FRG8G7qNb20NaeGd4io/WJ9v/wjxqkA/aaJylsYjSPhM",
	"Ge7DbcymaUyw8YBR2IxYsYEQYF6xYCzTbExq1g6QwRxRZKpodtgGdzPhjnfF2T8qICwzytOcgcTrs3Oj",
	"eh0ER+3JvXHzmxvYusOa4W9jbtnh1vImp122lp1uwue168ovNFZb6MBA83DGHuPeESTu6MPfcvhobtmO",
	"9BynLo2p0O4ZnfMJDswRrbjOVDKX4leIX9jopork2/D+VYbW5F+BxwIEuyyl9l03heOb2fdt93gVfGjj",
	"b61y+0XXxc1ucpnGT/VhG3kT3VrFs0I7JA/pemEgQ/sFwgBrweMVxNxitRUf5ES5PU822UTrIVv8VIZP",
	"Rk/s+M2pdDD3ntnmdD2jsVI0RuUyMAXb2wrH0oL4zn4DVJ1Kwc5OgkDxui2zCetKkI2ro5/89obqk512",
	"tOLU6ElIUaGGNLXRELkSkWEqvqbcFis3/Sy/cr0VWE+/6bUWEtNNqnjkWAYpK6JW36urd1najxLK2ILZ",
	"OtyVgqDQsxuI2JyWSEWuWHadIMSh5nxOTqdBtXm3GxlbMcVmOWCLh7bFjCq8Lmuve93FLA+4Xips/mhE",
	"82XFMwmZXiqLWCVIreKikFfHP85ArwE4OcV2D78i9zHyU7EVPDBYdELQ5OnDrzBux/5xGrtlXR31XSw7",
	"Q57tY8LjdIyhr3YMwyTdqPEg77kE+BWGb4cdp8l2HXOWsKW7UPafpYJyuoD4M5BiD0y2L+4mRg108MKt",
	"0wGUlmJLmI7PD5oa/jTwtNywPwsGSUVRMF24+EAlCkNPTRVnO6kfDuud+bJUHi7/EcNsy4ia/BnUGFoM",
	"PA3DYOgf0BUconVKqM0xmrMmAN6XBSXnPoUx1umqy3NZ3Ji5zNJRlsR4+DkpJeMazSyVnid/MWqxpKlh",
	"f8dD4CazL59E6l21S8LwwwD/5HiXoECu4qiXA2TvZRbXl9zngieF4SjZgyaVQ3AqB+OB45GfQ+Gnu4ce",
	"K/maUZJBcqta5EYDTn0rwuM7BrwlKdbrOYgeD17ZJ6fMSsbJg1Zmh358+9JJGYWQsboEzXF3EocELRms",
	"8GFefJPMmLfcC5mP2oXbQP95w6y8yBmIZf4sRxWBwHG6602+keJ/etUkWEf/rX3w2LEBChmxdjq73ScO",
	"ajzM6tZ1E9u4NPw2gLnRaMNR+lgZCPK3Ufx1n88RltQFye55y+D48BcijQ6OcvzREQJ9dDR1YvAvj9qf",
	"LXs/OornOY6a3MyvDRZuoxFj39gefiMiBjBfHLGOW3JpGCIGyKFLynwwTHDmhpqSdiG6Ty9F3M0zsnhQ",
	"a/wUXF29wy8eD/hHFxGfmVniBjaPIYYPe7sQZ5Rksvp7EE5PyTdiM5ZwOneQJ57fAYoGUDLSPIcr6RUa",
	"jUYF7A1LCWjUjDqDXBglM6w9FNrz/zh4Nouf7sB2xfLsp8bL2rlIJOXpMhqMPDMdf7YyeusKtqwyWs5k",
	"STmHPDqc1W1/9jpwREv/uxg7T8H4yLbdQrd2uZ3FNYC3wfRA+QkNepnOzQQhVtvZuersD/lCZATnaWpn",
	"NMyxXzE6Vqkz8owahy0q7cJj8cm5y2s0ZzlGe8b9xtgykVQP5OnCsuq+jJEZB6ucK2tmsKODJJQVeDEr",
	"WpQ54MlcgaQL7Co4dLpjpjYcOSiMQVRpPmFLzIshiK4kJ2I+D5YBXDMJ+XZKSqqUHeTULAs2OPfk6cPT",
	"06jZC7EzYqUWi36Zr5ulPDzBJvaLq+VkKw4cBOx+WD82FHXIxvYJx5Wu/EcFSsd4Kn6wD2TRS2pubVu2",
	"si6xeky+wwRLhohbGfXRXOlzFbfzdlZlLmg2xRzKl9+evSR2VtvHVqq3ZTMXaK1rk3/UvTI+j6lPIDWQ",
	"oGf8OLszhphVK53UVS5jKRBNi6YOJ+uE9qAdL8TOMXluTah1HIudhGAmbllAFhTVtEo8Eof5j9Y0XaJt",
	"siUBDfPK8fVePTtrPDfBI8e6yBIybAO3K/lqK75OidBLkGumAB/+wwraWRfrFKTONu6zMLaXJyvOLaUc",
	"HyCM1iWVDkW7B85Ksj6oIApZB/EHWqZs2edDy99eYK/4k49OLd2O19/n8POZvMkr51xIKRecpVhxISZJ",
	"Y4a4cW7KEcUp4v5FNXEnNHK4ohV86yfHDouDNX09I3SI67v8g69mUy112D81bFxltwVo5TgbZFNfUNs5",
	"xBhX4IpmGSIK+aSQkaCm6HuLOoDiQDLC5E8DFs4X5tsPzv6NuTeuGUdLl0Ob08+syypXDD3TnDBNFgKU",
	"W0/70ZB6Z/ocYzLIDDbvj1+KBUsv2ALHsGF0Ztk2NLU/1JkPVHWBoabtM9PWpeivf26Fg9lJz8rSTTpc",
	"bj0qSOoNH0RwLG7JB5IEyK3HD0fbQW47I8zxPjWEBiuMWoMS7+EeYdQlu9ujfGt0S0tR2ILYh5vRPL2M",
	"R8B4ybh3ocYviDR6JeDG4Hkd6KdSSbXVHUbxtEug+cA7C3wIbX3wtx2qW6DAoATX6OcY3sam2vgA46gb",
	"NBI/5VviD4Wh7kCYeEbzOkI7UjscpSonRNmY1k418RjjMIw78S8zW+ja+0qw7o5FPw69iYZSIc6qbAE6",
	"oVkWy6D1DX4l+NW/RYMNpFVd66p+hNhOhd6nNjdRKriqih1z+Qa3nC4ozx+hhvojZPUOY0Kf2Rb/jRV6",
	"Gt4ZF5t98ONfH4idHZb/v/+YOSb1GppOFFsk4zGBd8rt0dFMfTNCb/rfKaX7V8G/i0e/HS4X7lGMv31r",
	"Lo4wP3AvPt1eLXX6XowFF/jd51WqE0+2uRJeZb1yZhj1gJsX2bIO8L5hFPAVzQce3Ie+Enu/Wv/B0LP7",
	"dDBLBNUuC5imZCcLGsysZGOFO96XvgtxKD7YhgffndfCrXUnQod9d9+3PHU2RqxhFoMeups50ZoNPtSL",
	"5uoa9E2aNM9FOvrUu2HOTKfhrKGiKFw67UgM26oQWUjnYTQUQJxp2fDcSMg/6p7Rb6gYRb/IdXy0ls3i",
	"UFOpRaNbwtS+BPTgeWDs1OFEgYnUYZa8YDnWQ/r3i9c/TIY3MtiB/pa6LL5Ro/LQxtSPpbrksRAtfFTD",
	"thPB85gSMZ2oASM35uqJnwZX9Db64YU12o0Byaa0OaT1y7GD9whgIWJJ6vspRybNRni0B3TQbKzlJSFd",
	"xOjh+9VQihVf5we/h/WEXHje1JWRgBUTlQ+r9I8bvK3H/upSeLXqBg0wtuiToc/tjhx0nl66+td2mc7Y",
	"9v1PNryCANdy+ztwpfY2vVuUKqLGWrtz04TUpVNHlVJtibtjamDFyi05pc8bwa3M0KKlXvmqHlk9HyPn",
	"9/DxcTo5zw6ShGMluyZ2lNh9+pItlhorfvwVaAbyzZ6KJk0VEzxipVCsqWCcm8FcCuklDnc89hWRIWAW",
	"VmTpj+Wjy1eQaixb3UTNSoBD6rOYybw398/KJsN3Qf3YyhU02VXFpF+reo/w3ku8FiQPtHV+j8fX7Dir",
	"30bYp51rqpp0T52cC6Nffs/nkGJW9Z2J7v5jCTxIojb1BleEZR7kvWP1A0WsC3C4O6EBaFceup3wBPW5",
	"bg3OUB6Ma9jeU6RFDdHCw/Xr3JskHkcMWN+2z0E/5CFy4aBM1ZSBWPCx/i6Ve1NcZzBnfJC28YZzeZI0",
	"F0eTynHHlF5+vMFcputBaWNR1h/KhdevuT5sWHiOJe6Vi3yldeLy0PxGzvuFt9Yu8TmmJaydoj4FOij/",
	"m89BamfJ2bWrP4JYsS7oNZWZb3EnSeXs3cTiQM/rmVnzMqsfvRQp5YKPHNNcGDEiGXop2n4MVUcS31M2",
	"5LtJAIZwzUFKyGpfZy4UJFr4l1y74NiFChvXfiMkqMHyaRa4wdT5b5vaAFhGkmKqfOrC2cMFEgkFNdDJ",
	"IIP/8Jy7kP3MfvdJPHwZwb2m45pe99ez9m/ymOohMaT6OXG35f7kIDexIjPOQSbepdxN58/bGR0xb29W",
	"pfaCDg9GbWkfnXtrByuJGmDT/io7OkKQ/eIatidWCfKFwP0OhkBbycmCHiQs7mzyndrVVQzuxZ2A93nz",
	"UJZC5MmAF/O8X4OgS/HXLL0GzCFav10xst+99tkwk5D76Dyrw1TWy63PuV+WwCF7cEzIGbevBX3ESrs8",
	"aWdyfk/vmn+Ds2aVLQvirOXHVzz+7AoLdshbcjM/zG4epsCwultOZQfZk+F+w4di6dZY3KNdBfh4rFbe",
	"jyHpSCUBUVkoYjLJhXVFP8ODHjMcYW6TIAkPRihQ4lzYROUiFqR/k/wrZqg4psLJECANfEwakBoKN3gU",
	"AS48b09KUffZJ80UcyKhiQ65afZQl5DTsmY1pNF3Z65nafO7uZAQzojRpzZTcP2iDdPw4n9mTEsqtzfJ",
	"8dlGVcx6MojlvXGWdYhls5AmzLKPwzwX6wSZVVLXyYmptqadal/Gvmhj08+c6hkEAZtUOUFtS5Y0I6mQ",
	"EtKwR/wht4WqEBKSXGD8Ziy0ZK6N3F3g601OcrEgokxFBrbeVJyChuaqOKcoNkEQLhdFgaUdTANg+wR0",
	"PHJKc6daB3GCotbe8gx+8y9NH5uSoskKZxed2CCFgacIoFwWOIch27gPLxKOzWfUtSXGefOcbZBuQMaO",
	"/JxoWcGUuBbdGvvu4FMJpGBKWVBqWlqzPMeMEGwThFTUEUlx1A6IvecYL71iGFTXzg5ipeHS3Hl1ypSQ",
	"B1yE+cyIXkpRLZZBgvoaTq/yysopxOEoP6oK4x7xaaiZ4gkphNJO07QjNUtuYknvp4JrKfK8bZSyIvrC",
	"Wdpf0c1ZmuqXQlzPaHr9APVaLnS90mzqEyd0o36bmWQnNWH7Ak6QBtT+VN+2HcbAOqIdzSA7LK5nFN9n",
	"ZQ7AfL+fg+63uZ/1F9ZdV5uZxtWYM06oFgVL42fqjxVGOxj8GmNR0WSEtjarTR+DzfCwh5dVHTWFLLKP",
	"ZuA0WlzyjDhG4KJHkN2Y/6IE3h2XzMExmoGLss9cnBSVpIOyXgcAhNTmNNCVtAVdQ0ms5ipiYXOgYOxL",
	"F9CRtwqGGN4ONjPCnQOl4VZA9cKaawDvW+PD1CaNtCHSM7Hx3x80WSVvBPzH3VTeYh5DsZsXDWlJG73p",
	"M1ANcIR4ivydgY6XmM9iNjbcsS6+PfKGDwAYDoBswTAqDPJQMOaU5ZAlsdqt57WNahpo2u7NZbt2Pd7L",
	"lpOntPKlU83YlQSXEcmK+LLt/yqpISVRN+9bknkGG7APtn4FKWxN1Gngf4HclkztGANEmeSwglZcqEvT",
	"VKGoyVbg+6q6M8kASvRGdm1ksYDH8C7vGE7c2pMgZG4MdqOWFItYu1Nkj5kkatTZ8MQeEzX2KBmIViyr",
	"aAt/6lCRo20GNEc5gqqejpB4PXLsND/aEd76Ac58/5go4zHxfhwfOpgFxVG3iwHtDYCu1NCp5/H45zAH",
	"We1gwdmy2hFrSbzhG6qkaz5skOyTfKNujdwnJniA2G83kKJU4/QdyJzGM+CkcOmMkNo5QGa1AtMlYm1f",
	"AidcBCVq11TVqkqTHNX/YCfGRow7bfoGTuUmTPn2O0twMKI6WRIHFQlZ0+nNzfOf5STuPIiD48VoRIF7",
	"17vD/uWp26kd2EBUeUa42U8j+2ORV3eLOS4+JbPKD5TnYm1rzoZ66HPwflBLfd4F5MRyVl/LPhx76vL2",
	"dk0dLHiIUtAtERL/MVrnPyqas/kW+YwF33cjakkNCTnHq40IcOHdZuLd4tXUA+atLcJPZdfNxo4ZDLc1",
	"owRAm4vcFwcTpKDXEG4DBjtY/plqwzhVNUPLhbmyO9vZx4JbvM+9VNAs1PQxA+y2xR18TnDT+383j1zD",
	"qXzixjKnqa8w7EqctfkMVhH3xKWXUOx+Bd3na54E6srkDdFKnzYju4HJ9EDWFXtaNFS+qQV2r2Jzr3LV",
	"rZYx0vLbqdGz4/34qKXc9S6MjbrpAR3Wed0Hflj29tPgP5qceWgZY8D/veB9oNB1CK+taf0JsNxKrROB",
	"1VqrZ2KTSJirfQEm1lxt1HnZJOXxJlbGUwlU2Yib89dO8WxyDzNuFGEbE1r7NOtRMpgz3jBLxstKR/QY",
	"TEHMtwHCQqM/onXAhTYkJRhhckXz1yuQkmVDG2dOhy0JG5aY8Y4O1zdiwqjv1P4ATDU6HD68bszoYTNz",
	"gdsidjZcU2nKMyqzsDnjJAVp7n2yplt1c49S7RzY51OigTTTTgcSeJeQtC0g+dY5hW/p76kBpHfo+Bnh",
	"sMG44Iizxpp2tBjwz/Rh+EM4bAq6SXKxwOfBAwfCJZ1GD59VAQVHM7iVz8at28+j2K+wexqst+EYkRY4",
	"65gpdp/717iVqEb+yJneefKtjbL7XtvG3dqD6ZHKF03wvyWW/nmMPbF3WZXCZ/Ze2PRPVTztQbCJMOAf",
	"atvFB3YRwyBcfobQCD6+XGI70iL2kN9aBhK0GKgd4f2gmlB2mrrwrL4prWdqsEiZujQIB1rarH3e30sD",
	"4KEpRLmz3p62Dpkx4xxSY3J34oOkFGWSjon5tCV5MucmcJC2YRygj8AJMLDuOjxG1UWqWgnNWtWqDi2z",
	"OVgta5+3q0x3Kf1DZqIBjt52QYg58jI8wtY4hi95amPKtPvGrG0Gq5kEoURCWkk0E6/pdn/ZwoFU8Bd/",
	"Pfvi4aOfH33xJTENSMYWoJpyAp2yf01cIONdu8+njQTsLU/HN8GnFbGI8/5H/6iq3hR31iy3VU2u4F7R",
	"w0Psy5ELIPbSt18H7kZ7heM0of2/r+2KLfLOdyyGgt9+z6TI83g5l1quijhQYrsVuFCMBlKCVExpwwjb",
	"HlCmm4hotUTzICb1Xtk0UYKn4O3HjgqYHgi5ii1kKKAW+RkmbXBeIwKbMne8ynp6dq3L6WnWQodCI0bF",
	"zICUonSiPZuTGET4gkgGL2ud4RMt4kGMbM1sbbRsjBBd5Hmc9MKC+7u5fbsYtI5zerOJEfHCH8obkOaQ",
	"f2I4IclNOElj2v/d8I9IhpU74xr1cn8LXhHVD3a8OT7rxT3U2UVGgdbPthEhDwRg4LVt651k8FAsyDAu",
	"rZcA/QnegdwVP141juW9z0IQEt9hD3jh89mmXf2SwYHzmVN1v6qREizl/RAltJa/70WuZ731RRJskTOa",
	"aA3KsiXRFwuD59bqWf2KeUAr6T12lkJoYjTTPI88krZ2HDxTIeEYlUCuaP7pucYLJpU+Q3xA9nb4aVT4",
	"UjZEskWlulkCzpd01NzBq9i7m5q/wYfZ/wFmj6L3nBvKOeF7txkad2huw6vntTcaOFnjmDbI6uGXZOaq",
	"6JQSUqa6zv21F07qh6Eg2dwFtMJG73mJum+dPwl9CzKe+0gc8kPg3qp99g7C5oh+ZqYycHKjVB6jvh5Z",
	"RPAX41Fhce8918UtK67cLJ9TkJnxwHxO/bLlY5dnU5uYS6dS0F/n6Nu6hdvIRd2sbWwystGFW66u3unZ",
	"mBxi8SIrpjsmMbuTaisH1Vr5DdKXWRy5Mdy8MYr5aSihtU3aPJB0v7MfFcv3Bqy0Sih8nE4WNoMRFgn4",
	"2RWF+rR3qYdgII2YW/pt0sVYxETW2po8mCrI+DSiLoLrFklmj68a00oyvcWC4N6Axn6O5mP6rs7t4XLD",
	"1L40d/dpcQ3cx3s0mUAq5W/X7wTN8T6yLj5ubiGRH5Nvbep+d1C+vjf7V3j8lyfZ6eOH/zr7y+kXpyk8",
	"+eKr01P61RP68KvHD+HRX754cgoP519+NXuUPXryaPbk0ZMvv/gqffzk4ezJl1/96z3DhwzIFlBfs+Pp",
	"5D+Ts3whkrM358mlAbbBCS3Z92D2BnXlOeYtQ6SmeBKhoCyfPPU//R9/wo5TUTTD+18nrvDaZKl1qZ6e",
	"nKzX6+Owy8kCn/4nWlTp8sTPgynuWvLKm/M6Rt/G4eCONtZj3NQ6+Zf59vbbi0ty9ub8uCGYydPJ6fHp",
	"8UNXs57Tkk2eTh7jT3h6lrjvJ5g490S5mhgn9Vutj9Pet7K0FTPMp0WdHdD8tQSaY4Id80cBWrLUf5JA",
	"s637v1rTxQLkMb7esD+tHp14aeTkg8uc8HHXt5MwMuTkQyvBRLanp4982Nfk5IOvib17wFY9ZBdzZpAa",
	"dXl+B9qlW7K2h0iuDvQ0uNGnRGFBDPNTKZkw53VqLt8MMC4Aw9skVgbQsuKpdRbbKYDjf1+d/Sc6zF+d",
	"/Sf5mpxO3YMDhQpNbHr74romtPPMgt2PU1TfbM/qbCaNc33y9F3MyOSCRctqlrOUWDkFD6qhwuAc1SM2",
	"fBItihN7T6Cjr+b6hpOfJl+9//DFXz7GpMmebFwjKUjw0fL6Cl/SGJFW0M3XQyjbuAh0M+4/KpDbZhEF",
	"3UxCgPse1EjWM/9AyFd2D2MTg6jFf794/QMRkjjt+Q1Nr+vHUf41XPMCMHwMZ3oOQewu1hBo4FVh7ij3",
	"yqpQi7Kd2btG83ssg4qAIjt5dHrqeajTUIIDeuLOfTBTx6zVJzQM0wkMlf2n8IrAhqY63xKqgjgJjFr0",
	"JYs7T9hEmbQC6XeaRvszui2JvkI49DV+pPSE0DTfA99lp7xrCx0u5Kc0l+z+5+89ZEQhiKapDLfW08if",
	"u/vfY3f7UgkphTnTDOOymyvHX2ctIJ0smm89uAOJRo7J30SFsqPRCioNNQsUEtlZfWFan4ib0+VFCgLp",
	"mqdD+OXoqLvwo6Mm7G8Oa2SylGPDLjqOjo7NTj05kJXttFO38oOPOjuHDNfbrFd0U0dNU8IFTzgsqGYr",
	"IIHC+eT04R92hefcxqkbYdkK9R+nky/+wFt2zo1gQ3OCLe1qHv9hV3MBcsVSIJdQlEJSyfIt+ZHXDwGs",
	"0oPySZ/9/civuVhzjwijr1ZFQeXWCdG05jkVDwp67eQ/vQxHjaCNXJQuFMbCoIhqZVqfBZEvJu8/eh1g",
	"pO6xq9nJDEvbjm0KocIyrJ2gZ0KdfEDb+uDvJ85BGv+IPg6rPJ/43IsDLW2WrfjHllb0QW/MQnYPZ9oE",
	"46VUp8uqPPmA/0E9OFiRrcZxojf8BGNCTz60EOE+9xDR/r3pHrbARPMeODGfK9Tjdn0++WD/DSaCTQmS",
	"mesIE2W6X21C4xMsEb/t/7zlafTH/jpayVwHfj7xZpiYSt1u+aH1Z5um1LLSmVgHs6ADw3rf+pCZj5Xq",
	"/n2ypkwbIcnlEKVzDbLfWQPNT1wlsM6vTfGN3hesKBL82BGrSmGTCLU12rd0fdl6CyptsoxvBBoqhhju",
	"Jpkxjlwo5JKNWdJ+7KtIPd54uQQbf+s9uxEZVAsyk4JmKVXa/NEUBmjrxh9vqX91c3ucR/x2CCaaG/rp",
	"KA0/Od7rzMFxxwiZwb6Q8+d+wuYB2m8umPUg+oZmxGedSsgrmpsNh4ycOfG/hY3fWqj6/FLQZxZbPpmc",
	"8Y0/fIpQTMHXUhBlPGlOUNxyjFBhtEjDABbAE8eCkpnItq7+4ETStd7YHB1d5nZC2zdG2xBJJS3U0Mc7",
	"sFL+vk2T+yySfxoC/zQE/mkq+tMQ+Ofu/mkIHGkI/NNM9qeZ7H+kmewQ21hMzHTmn2Fpk62A24j1jt5H",
	"m/oUNYtvZw9jupbJWs9IsRQG08eEXGLqF2puCViBpDlJqbLSlUtTVGB0J+Ygg+zpFU9akNgYSjPx/ea/",
	"Nnj1qjo9fQzk9EG3j9Isz0Pe3O+L8i5+su9LviZXk6tJbyQJhVhBZh/DhvnRba+9w/6vetzXvcIK+Aoe",
	"c+v4VGVEVfM5S5lFeS74gtCFaAKvMSErF/gFpAHOlqciTE/dQxXmXkfbXemkcW9L7n0J4LzZwr0hBR1y",
	"iUcTGMI7MJTgX8bEEfyPltJvms3qtox059g9rvonV/kUXOWz85U/upM2MC3+txQzn5w++cMuKDRE/yA0",
	"eYGPCm4njrlEoWm0StdNBS2fKMab+5rA5DDQF2/ROsT33XtzESiQK3/BNnGrT09OMHPYUih9MjHXXzum",
	"Nfz4vob5g7+dSslWWN8drZtCsgXjNE9c4GfSxKY+Oj6dfPz/AQAA//82PehVOSYBAA==",
}

// GetSwagger returns the content of the embedded swagger specification file
// or error if failed to decode
func decodeSpec() ([]byte, error) {
	zipped, err := base64.StdEncoding.DecodeString(strings.Join(swaggerSpec, ""))
	if err != nil {
		return nil, fmt.Errorf("error base64 decoding spec: %s", err)
	}
	zr, err := gzip.NewReader(bytes.NewReader(zipped))
	if err != nil {
		return nil, fmt.Errorf("error decompressing spec: %s", err)
	}
	var buf bytes.Buffer
	_, err = buf.ReadFrom(zr)
	if err != nil {
		return nil, fmt.Errorf("error decompressing spec: %s", err)
	}

	return buf.Bytes(), nil
}

var rawSpec = decodeSpecCached()

// a naive cached of a decoded swagger spec
func decodeSpecCached() func() ([]byte, error) {
	data, err := decodeSpec()
	return func() ([]byte, error) {
		return data, err
	}
}

// Constructs a synthetic filesystem for resolving external references when loading openapi specifications.
func PathToRawSpec(pathToFile string) map[string]func() ([]byte, error) {
	var res = make(map[string]func() ([]byte, error))
	if len(pathToFile) > 0 {
		res[pathToFile] = rawSpec
	}

	return res
}

// GetSwagger returns the Swagger specification corresponding to the generated code
// in this file. The external references of Swagger specification are resolved.
// The logic of resolving external references is tightly connected to "import-mapping" feature.
// Externally referenced files must be embedded in the corresponding golang packages.
// Urls can be supported but this task was out of the scope.
func GetSwagger() (swagger *openapi3.T, err error) {
	var resolvePath = PathToRawSpec("")

	loader := openapi3.NewLoader()
	loader.IsExternalRefsAllowed = true
	loader.ReadFromURIFunc = func(loader *openapi3.Loader, url *url.URL) ([]byte, error) {
		var pathToFile = url.String()
		pathToFile = path.Clean(pathToFile)
		getSpec, ok := resolvePath[pathToFile]
		if !ok {
			err1 := fmt.Errorf("path not found: %s", pathToFile)
			return nil, err1
		}
		return getSpec()
	}
	var specData []byte
	specData, err = rawSpec()
	if err != nil {
		return
	}
	swagger, err = loader.LoadFromData(specData)
	if err != nil {
		return
	}
	return
}
