// Package private provides primitives to interact with the openapi HTTP API.
//
// Code generated by github.com/algorand/oapi-codegen DO NOT EDIT.
package private

import (
	"bytes"
	"compress/gzip"
	"encoding/base64"
	"fmt"
	"net/http"
	"net/url"
	"path"
	"strings"

	. "github.com/algorand/go-algorand/daemon/algod/api/server/v2/generated/model"
	"github.com/algorand/oapi-codegen/pkg/runtime"
	"github.com/getkin/kin-openapi/openapi3"
	"github.com/labstack/echo/v4"
)

// ServerInterface represents all server handlers.
type ServerInterface interface {
	// Gets the merged config file.
	// (GET /debug/settings/config)
	GetConfig(ctx echo.Context) error

	// (GET /debug/settings/pprof)
	GetDebugSettingsProf(ctx echo.Context) error

	// (PUT /debug/settings/pprof)
	PutDebugSettingsProf(ctx echo.Context) error
	// Return a list of participation keys
	// (GET /v2/participation)
	GetParticipationKeys(ctx echo.Context) error
	// Add a participation key to the node
	// (POST /v2/participation)
	AddParticipationKey(ctx echo.Context) error
	// Generate and install participation keys to the node.
	// (POST /v2/participation/generate/{address})
	GenerateParticipationKeys(ctx echo.Context, address string, params GenerateParticipationKeysParams) error
	// Delete a given participation key by ID
	// (DELETE /v2/participation/{participation-id})
	DeleteParticipationKeyByID(ctx echo.Context, participationId string) error
	// Get participation key info given a participation ID
	// (GET /v2/participation/{participation-id})
	GetParticipationKeyByID(ctx echo.Context, participationId string) error
	// Append state proof keys to a participation key
	// (POST /v2/participation/{participation-id})
	AppendKeys(ctx echo.Context, participationId string) error
}

// ServerInterfaceWrapper converts echo contexts to parameters.
type ServerInterfaceWrapper struct {
	Handler ServerInterface
}

// GetConfig converts echo context to params.
func (w *ServerInterfaceWrapper) GetConfig(ctx echo.Context) error {
	var err error

	ctx.Set(Api_keyScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetConfig(ctx)
	return err
}

// GetDebugSettingsProf converts echo context to params.
func (w *ServerInterfaceWrapper) GetDebugSettingsProf(ctx echo.Context) error {
	var err error

	ctx.Set(Api_keyScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetDebugSettingsProf(ctx)
	return err
}

// PutDebugSettingsProf converts echo context to params.
func (w *ServerInterfaceWrapper) PutDebugSettingsProf(ctx echo.Context) error {
	var err error

	ctx.Set(Api_keyScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.PutDebugSettingsProf(ctx)
	return err
}

// GetParticipationKeys converts echo context to params.
func (w *ServerInterfaceWrapper) GetParticipationKeys(ctx echo.Context) error {
	var err error

	ctx.Set(Api_keyScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetParticipationKeys(ctx)
	return err
}

// AddParticipationKey converts echo context to params.
func (w *ServerInterfaceWrapper) AddParticipationKey(ctx echo.Context) error {
	var err error

	ctx.Set(Api_keyScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.AddParticipationKey(ctx)
	return err
}

// GenerateParticipationKeys converts echo context to params.
func (w *ServerInterfaceWrapper) GenerateParticipationKeys(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "address" -------------
	var address string

	err = runtime.BindStyledParameterWithLocation("simple", false, "address", runtime.ParamLocationPath, ctx.Param("address"), &address)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter address: %s", err))
	}

	ctx.Set(Api_keyScopes, []string{""})

	// Parameter object where we will unmarshal all parameters from the context
	var params GenerateParticipationKeysParams
	// ------------- Optional query parameter "dilution" -------------

	err = runtime.BindQueryParameter("form", true, false, "dilution", ctx.QueryParams(), &params.Dilution)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter dilution: %s", err))
	}

	// ------------- Required query parameter "first" -------------

	err = runtime.BindQueryParameter("form", true, true, "first", ctx.QueryParams(), &params.First)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter first: %s", err))
	}

	// ------------- Required query parameter "last" -------------

	err = runtime.BindQueryParameter("form", true, true, "last", ctx.QueryParams(), &params.Last)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter last: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GenerateParticipationKeys(ctx, address, params)
	return err
}

// DeleteParticipationKeyByID converts echo context to params.
func (w *ServerInterfaceWrapper) DeleteParticipationKeyByID(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "participation-id" -------------
	var participationId string

	err = runtime.BindStyledParameterWithLocation("simple", false, "participation-id", runtime.ParamLocationPath, ctx.Param("participation-id"), &participationId)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter participation-id: %s", err))
	}

	ctx.Set(Api_keyScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.DeleteParticipationKeyByID(ctx, participationId)
	return err
}

// GetParticipationKeyByID converts echo context to params.
func (w *ServerInterfaceWrapper) GetParticipationKeyByID(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "participation-id" -------------
	var participationId string

	err = runtime.BindStyledParameterWithLocation("simple", false, "participation-id", runtime.ParamLocationPath, ctx.Param("participation-id"), &participationId)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter participation-id: %s", err))
	}

	ctx.Set(Api_keyScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetParticipationKeyByID(ctx, participationId)
	return err
}

// AppendKeys converts echo context to params.
func (w *ServerInterfaceWrapper) AppendKeys(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "participation-id" -------------
	var participationId string

	err = runtime.BindStyledParameterWithLocation("simple", false, "participation-id", runtime.ParamLocationPath, ctx.Param("participation-id"), &participationId)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter participation-id: %s", err))
	}

	ctx.Set(Api_keyScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.AppendKeys(ctx, participationId)
	return err
}

// This is a simple interface which specifies echo.Route addition functions which
// are present on both echo.Echo and echo.Group, since we want to allow using
// either of them for path registration
type EchoRouter interface {
	CONNECT(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	DELETE(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	GET(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	HEAD(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	OPTIONS(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	PATCH(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	POST(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	PUT(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	TRACE(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
}

// RegisterHandlers adds each server route to the EchoRouter.
func RegisterHandlers(router EchoRouter, si ServerInterface, m ...echo.MiddlewareFunc) {
	RegisterHandlersWithBaseURL(router, si, "", m...)
}

// Registers handlers, and prepends BaseURL to the paths, so that the paths
// can be served under a prefix.
func RegisterHandlersWithBaseURL(router EchoRouter, si ServerInterface, baseURL string, m ...echo.MiddlewareFunc) {

	wrapper := ServerInterfaceWrapper{
		Handler: si,
	}

	router.GET(baseURL+"/debug/settings/config", wrapper.GetConfig, m...)
	router.GET(baseURL+"/debug/settings/pprof", wrapper.GetDebugSettingsProf, m...)
	router.PUT(baseURL+"/debug/settings/pprof", wrapper.PutDebugSettingsProf, m...)
	router.GET(baseURL+"/v2/participation", wrapper.GetParticipationKeys, m...)
	router.POST(baseURL+"/v2/participation", wrapper.AddParticipationKey, m...)
	router.POST(baseURL+"/v2/participation/generate/:address", wrapper.GenerateParticipationKeys, m...)
	router.DELETE(baseURL+"/v2/participation/:participation-id", wrapper.DeleteParticipationKeyByID, m...)
	router.GET(baseURL+"/v2/participation/:participation-id", wrapper.GetParticipationKeyByID, m...)
	router.POST(baseURL+"/v2/participation/:participation-id", wrapper.AppendKeys, m...)

}

// Base64 encoded, gzipped, json marshaled Swagger object
var swaggerSpec = []string{

	"H4sIAAAAAAAC/+y9e3PctpIo/lVQs1vlxw4l23GyJ/7Vqf0pdpKjjRO7LCV7dy3fBEP2zOCIAzAAOI/4",
	"+rvfQuNBkARnOJJiJ3Xzl60hHo1Go9EvdL+f5GJVCQ5cq8mz95OKSroCDRL/onkuaq4zVpi/ClC5ZJVm",
	"gk+e+W9Eacn4YjKdMPNrRfVyMp1wuoKmjek/nUj4tWYSiskzLWuYTlS+hBU1A+tdZVqHkbbZQmRuiDM7",
	"xPmLyYc9H2hRSFCqD+UrXu4I43lZF0C0pFzR3HxSZMP0kuglU8R1JowTwYGIOdHLVmMyZ1AW6sQv8tca",
	"5C5apZt8eEkfGhAzKUrow/lcrGaMg4cKAlBhQ4gWpIA5NlpSTcwMBlbfUAuigMp8SeZCHgDVAhHDC7xe",
	"TZ69nSjgBUjcrRzYGv87lwC/QaapXICevJumFjfXIDPNVomlnTvsS1B1qRXBtrjGBVsDJ6bXCfm+VprM",
	"gFBO3nzznHz22WdfmoWsqNZQOCIbXFUze7wm233ybFJQDf5zn9ZouRCS8iIL7d988xznv3ALHNuKKgXp",
	"w3JmvpDzF0ML8B0TJMS4hgXuQ4v6TY/EoWh+nsFcSBi5J7bxnW5KPP8n3ZWc6nxZCcZ1Yl8IfiX2c5KH",
	"Rd338bAAQKt9ZTAlzaBvH2Vfvnv/ePr40Yd/eXuW/Y/78/PPPoxc/vMw7gEMJBvmtZTA8122kEDxtCwp",
	"7+PjjaMHtRR1WZAlXePm0xWyeteXmL6Wda5pWRs6YbkUZ+VCKEIdGRUwp3WpiZ+Y1Lw0bMqM5qidMEUq",
	"KdasgGJquO9myfIlyamyQ2A7smFlaWiwVlAM0Vp6dXsO04cYJQauG+EDF/THRUazrgOYgC1ygywvhYJM",
	"iwPXk79xKC9IfKE0d5U67rIil0sgOLn5YC9bxB03NF2WO6JxXwtCFaHEX01TwuZkJ2qywc0p2TX2d6sx",
	"WFsRgzTcnNY9ag7vEPp6yEggbyZECZQj8vy566OMz9milqDIZgl66e48CaoSXAERs39Crs22/+fFqx+I",
	"kOR7UIou4DXNrwnwXBRQnJDzOeFCR6ThaAlxaHoOrcPBlbrk/6mEoYmVWlQ0v07f6CVbscSqvqdbtqpX",
	"hNerGUizpf4K0YJI0LXkQwDZEQ+Q4opu+5NeyprnuP/NtC1ZzlAbU1VJd4iwFd3+/dHUgaMILUtSAS8Y",
	"XxC95YNynJn7MHiZFDUvRog52uxpdLGqCnI2Z1CQMMoeSNw0h+Bh/Dh4GuErAscPMghOmOUAOBy2CZox",
	"p9t8IRVdQEQyJ+RHx9zwqxbXwAOhk9kOP1US1kzUKnQagBGn3i+Bc6EhqyTMWYLGLhw6DIOxbRwHXjkZ",
	"KBdcU8ahMMwZgRYaLLMahCmacL++07/FZ1TBF0+H7vjm68jdn4vuru/d8VG7jY0yeyQTV6f56g5sWrJq",
	"9R+hH8ZzK7bI7M+9jWSLS3PbzFmJN9E/zf55NNQKmUALEf5uUmzBqa4lPLviD81fJCMXmvKCysL8srI/",
	"fV+Xml2whfmptD+9FAuWX7DFADIDrEmFC7ut7D9mvDQ71tukXvFSiOu6iheUtxTX2Y6cvxjaZDvmsYR5",
	"FrTdWPG43Hpl5Ngeehs2cgDIQdxV1DS8hp0EAy3N5/jPdo70ROfyN/NPVZWmt67mKdQaOnZXMpoPnFnh",
	"rKpKllODxDfus/lqmABYRYI2LU7xQn32PgKxkqICqZkdlFZVVoqclpnSVONI/yphPnk2+ZfTxv5yarur",
	"02jyl6bXBXYyIqsVgzJaVUeM8dqIPmoPszAMGj8hm7BsD4Umxu0mGlJihgWXsKZcnzQqS4sfhAP81s3U",
	"4NtKOxbfHRVsEOHENpyBshKwbXhPkQj1BNFKEK0okC5KMQs/3D+rqgaD+P2sqiw+UHoEhoIZbJnS6gEu",
	"nzYnKZ7n/MUJ+TYeG0VxwcuduRysqGHuhrm7tdwtFmxLbg3NiPcUwe0U8sRsjUeDEfPvguJQrViK0kg9",
	"B2nFNP6HaxuTmfl9VOc/B4nFuB0mLlS0HOasjoO/RMrN/Q7l9AnHmXtOyFm3783Ixoyyh2DUeYPFuyYe",
	"/IVpWKmDlBBBFFGT2x4qJd1NnJCYobDXJ5MfFVgKqeiCcYR2atQnTlb02u6HQLwbQgAV9CJLS1aCDCZU",
	"J3M61J/07Cx/AmpNbayXRI2kWjKlUa/GxmQJJQrOlHuCjknlRpQxYsP3LCLAvJG0srTsvlixi3HU520j",
	"C+stL96Rd2IS5ojdRxuNUN2YLR9knUlIkGt0YPiqFPn1P6ha3sEJn/mx+rSP05Al0AIkWVK1TBycDm03",
	"o42hb9MQaZbMoqlOwhJfioW6gyWW4hjWVVXPaVmaqfssq7NaHHjUQS5LYhoTWDE0mDvF0VrYrf5Fvqb5",
	"0ogFJKdlOW1MRaLKSlhDaZR2xjnIKdFLqpvDjyN7vQbPkQLD7DSQaDXOzIQmNhlsERLIiuINtDLaTFW2",
	"+wQOqugKOlIQ3oiiRitCpGicv/CrgzVw5ElhaAQ/rBGtNfHgJ2Zu9wln5sIuzloAtXffBfwFftEC2rRu",
	"7lPeTCFkYW3W2vzGJMmFtEPYG95Nbv4DVDadLXXeryRkbghJ1yAVLc3qOot6EMj3rk7ngZNZUE2jk+mo",
	"MK2AWc6B/VC8A5mw0rzC/9CSmM9GijGU1FAPQ2FERO7Uwl7MBlV2JtMA7a2CrKwpk1Q0vz4KyufN5Gk2",
	"M+rkfW2tp24L3SLCDl1uWaHuaptwsKG9ap8Qa7vy7Kgni+xlOtFcYxBwKSpi2UcHBMspcDSLELG982vt",
	"K7FNwfSV2PauNLGFO9kJM85oZv+V2L5wkAl5GPM49hikmwVyugKFtxuPGaeZpfHLnc2EvJk00blgOGm8",
	"jYSaUSNhatpBEjatq8ydzYTHwjboDNQEeOwXArrDpzDWwsKFpr8DFpQZ9S6w0B7orrEgVhUr4Q5If5kU",
	"4mZUwWdPyMU/zj5//OTnJ59/YUiykmIh6YrMdhoUue/MckTpXQkPktoRShfp0b946n1U7XFT4yhRyxxW",
	"tOoPZX1fVvu1zYhp18daG8246gDgKI4I5mqzaCfWrWtAewGzenEBWhtN97UU8zvnhr0ZUtBho9eVNIKF",
	"avsJnbR0Wpgmp7DVkp5W2BJ4YeMMzDqYMjrganYnRDW08UUzS0EcRgs4eCiO3aZmml28VXIn67swb4CU",
	"Qiav4EoKLXJRZkbOYyJhoHjtWhDXwm9X1f3dQks2VBEzN3ova14M2CH0lo+/v+zQl1ve4GbvDWbXm1id",
	"m3fMvrSR32ghFchMbzlB6myZR+ZSrAglBXZEWeNb0Fb+Yiu40HRVvZrP78baKXCghB2HrUCZmYhtYaQf",
	"BbngNpjvgMnGjToGPV3EeC+THgbAYeRix3N0ld3FsR22Zq0YR7+92vE8Mm0ZGEsoFi2yvL0Jawgddqp7",
	"KgGOQcdL/Iy2+hdQavqNkJeN+PqtFHV15+y5O+fY5VC3GOcNKExfbwZmfFG2A0gXBvaT1Bo/yYKeByOC",
	"XQNCjxT5ki2WOtIXX0vxO9yJyVlSgOIHaywqTZ++yegHURhmomt1B6JkM1jD4QzdxnyNzkStCSVcFICb",
	"X6u0kDkQcoixThiipWO5Fe0TTJEZGOrKaW1WW1cEA5B690XTMaO5PaEZokYNhF+EuBnbyk5nw9lKCbTY",
	"kRkAJ2LmYhxc9AUukmL0lPZimhNxE/yiBVclRQ5KQZE5U/RB0Hw7e3XoPXhCwBHgMAtRgsypvDWw1+uD",
	"cF7DLsNYP0Xuf/eTevAJ4NVC0/IAYrFNCr1de1of6nHT7yO47uQx2VlLnaVaI94aBlGChiEUHoWTwf3r",
	"QtTbxdujZQ0SQ0p+V4r3k9yOgAKovzO93xbauhqIYHdqupHwzIZxyoUXrFKDlVTp7BBbNo1atgSzgogT",
	"pjgxDjwgeL2kStswKMYLtGna6wTnsUKYmWIY4EE1xIz8k9dA+mPn5h7kqlZBHVF1VQmpoUitAT2yg3P9",
	"ANswl5hHYwedRwtSKzg08hCWovEdspwGjH9QHfyvzqPbXxz61M09v0uisgVEg4h9gFz4VhF24yjeAUCY",
	"ahBtCYepDuWE0OHpRGlRVYZb6Kzmod8Qmi5s6zP9Y9O2T1zWyWHv7UKAQgeKa+8g31jM2vjtJVXEweFd",
	"7GjOsfFafZjNYcwU4zlk+ygfVTzTKj4CBw9pXS0kLSAroKS7RHCA/Uzs530D4I436q7QkNlA3PSmN5Ts",
	"4x73DC1wPJUSHgl+Ibk5gkYVaAjE9T4wcgE4doo5OTq6F4bCuZJb5MfDZdutToyIt+FaaLPjjh4QZMfR",
	"xwA8gIcw9M1RgZ2zRvfsTvHfoNwEQY44fpIdqKElNOMftYABW7B74xSdlw5773DgJNscZGMH+MjQkR0w",
	"TL+mUrOcVajrfAe7O1f9uhMkHeekAE1ZCQWJPlg1sIr7ExtC2h3zZqrgKNtbH/ye8S2xHB+m0wb+Gnao",
	"c7+2bxMiU8dd6LKJUc39RDlBQH3EsxHB4yawpbkud0ZQ00vYkQ1IIKqe2RCGvj9FiyqLB0j6Z/bM6Lyz",
	"Sd/oXnfxBQ4VLS8Va2Z1gv3wXXYUgxY6nC5QCVGOsJD1kJGEYFTsCKmE2XXmnj/5BzCeklpAOqaNrvlw",
	"/d9TLTTjCsh/i5rklKPKVWsIMo2QKCigAGlmMCJYmNMFJzYYghJWYDVJ/PLwYXfhDx+6PWeKzGHj3wya",
	"hl10PHyIdpzXQunW4boDe6g5bueJ6wMdV+bic1pIl6ccjnhyI4/ZydedwYO3y5wppRzhmuXfmgF0TuZ2",
	"zNpjGhkX7YXjjvLltOODeuvGfb9gq7qk+i68VrCmZSbWICUr4CAndxMzwb9e0/JV6IbvISE3NJpDluMr",
	"vpFjwaXpYx/+mXEYZ+YA26D/sQDBue11YTsdUDGbSFW2WkHBqIZyRyoJOdj3bkZyVGGpJ8RGwudLyheo",
	"MEhRL1xwqx0HGX6trGlG1rw3RFKo0lueoZE7dQG4MDX/5NGIU0CNSte1kFsFZkPDfO6V65ibOdqDrscg",
	"6SSbTgY1XoPUdaPxWuS0322OuAxa8l6En2bika4URJ2Rffr4irfFHCazub+Pyb4ZOgVlf+Io4rf5OBT0",
	"a9TtcncHQo8diEioJCi8omIzlbJfxTx+o+1DBXdKw6pvybddfx44fm8G9UXBS8YhWwkOu2RaEsbhe/yY",
	"PE54TQ50RoFlqG9XB2nB3wGrPc8YarwtfnG3uye067FS3wh5Vy5RO+Bo8X6EB/Kgu91NeVM/KS3LhGvR",
	"veDsMgA1DcG6TBKqlMgZymznhZq6qGDrjXTPPdvofx3epdzB2euO2/GhxckB0EYMZUUoyUuGFmTBlZZ1",
	"rq84RRtVtNREEJdXxoetls99k7SZNGHFdENdcYoBfMFylQzYmEPCTPMNgDdeqnqxAKU7us4c4Iq7VoyT",
	"mjONc63MccnsealAYiTViW25ojsyNzShBfkNpCCzWrelf3ygrDQrS+fQM9MQMb/iVJMSqNLke8Yvtzic",
	"d/r7I8tBb4S8DlhI3+4L4KCYytLBZt/arxjX75a/dDH+GO5uP/ug0yZjwsQss5Uk5X/f/49nb8+y/6HZ",
	"b4+yL//t9N37px8ePOz9+OTD3//+f9o/ffbh7w/+419TO+VhTz2fdZCfv3Ca8fkLVH+iUP0u7B/N/r9i",
	"PEsSWRzN0aEtch9TRTgCetA2juklXHG95YaQ1rRkheEtNyGH7g3TO4v2dHSoprURHWOYX+uRSsUtuAxJ",
	"MJkOa7yxFNWPz0w/VEenpHt7judlXnO7lV76tu8wfXyZmE9DMgKbp+wZwZfqS+qDPN2fTz7/YjJtXpiH",
	"75PpxH19l6BkVmxTeQQK2KZ0xfiRxD1FKrpToNPcA2FPhtLZ2I542BWsZiDVklUfn1MozWZpDuefLDmb",
	"05afcxvgb84Pujh3znMi5h8fbi0BCqj0MpW/qCWoYatmNwE6YSeVFGvgU8JO4KRr8ymMvuiC+kqgcx+Y",
	"KoUYow2Fc2AJzVNFhPV4IaMMKyn66TxvcJe/unN1yA2cgqs7Zyqi9963X1+SU8cw1T2b0sIOHSUhSKjS",
	"7vFkKyDJcLP4TdkVv+IvYI7WB8GfXfGCano6o4rl6rRWIL+iJeU5nCwEeebfY76gml7xnqQ1mFgxejRN",
	"qnpWspxcxwpJQ542WVZ/hKurt7RciKurd73YjL764KZK8hc7QWYEYVHrzKX6ySRsqEz5vlRI9YIj21xe",
	"+2a1QraorYHUpxJy46d5Hq0q1U350F9+VZVm+REZKpfQwGwZUVqE92hGQHFPes3+/iDcxSDpxttVagWK",
	"/LKi1VvG9TuSXdWPHn2GL/uaHAi/uCvf0OSugtHWlcGUFF2jCi7cqpUYq55VdJFysV1dvdVAK9x9lJdX",
	"aOMoS4LdWq8O/QMDHKpZQHjiPLgBFo6jHwfj4i5sL5/WMb0E/IRb2H6Afav9it7P33i7DrzBp7VeZuZs",
	"J1elDIn7nQnZ3hZGyPLRGIotUFt1ifFmQPIl5NcuYxmsKr2btrr7gB8naHrWwZTNZWdfGGI2JXRQzIDU",
	"VUGdKE75rpvWRtkXFTjoG7iG3aVokjEdk8emnVZFDR1UpNRIujTEGh9bN0Z3811UmX9o6rKT4ONNTxbP",
	"Al34PsMH2Yq8d3CIU0TRSvsxhAgqE4iwxD+Aghss1Ix3K9JPLY/xHLhma8igZAs2S6Xh/a++P8zDaqjS",
	"ZR50UchhQEXYnBhVfmYvVqfeS8oXYK5nc6UKRUubVTUZtIH60BKo1DOgeq+dn8cJKTx0qFJu8OU1Wvim",
	"ZgmwNfvNNFrsOGyMVoGGItvGRS+fDMefWcChuCE8vnujKZwM6roOdYmMg/5WDtgNaq0LzYvpDOGy31eA",
	"KUvFxuyLgUK4bJs2qUt0v9SKLmBAd4m9dyPzYbQ8fjjIIYkkKYOIeVfU6EkCSZBt48ysOXmGwXwxhxjV",
	"zE5App/JOoidzwiTaDuEzUoUYEPkqt17KlteVJsVeAi0NGsByRtR0IPRxkh8HJdU+eOI+VI9lx0lnf2O",
	"aV/2paY7j2IJo6SoIfGcvw27HLSn97sEdT4rnU9FFyv9I9LKGd0Lny+ktkNwFE0LKGFhF24be0JpEiY1",
	"G2TgeDWfI2/JUmGJkYE6EgDcHGA0l4eEWN8IGT1CiowjsDHwAQcmP4j4bPLFMUByl/CJ+rHxioj+hvTD",
	"Phuob4RRUZnLlQ34G3PPAVwqikay6ERU4zCE8SkxbG5NS8PmnC7eDNLLkIYKRScfmgu9eTCkaOxxTdkr",
	"/6g1WSHhJquJpVkPdFrU3gPxTGwz+0I5qYvMtjND78m3C/heOnUwbS66e4rMxBbDufBqsbHyB2AZhsOD",
	"EdletkwhvWK/ITnLArNv2v1ybooKFZKMM7QGchkS9MZMPSBbDpHL/Si93I0A6JihmloNzixx0HzQFk/6",
	"l3lzq02btKn+WVjq+A8doeQuDeCvbx9rJ4T7R5P4bzi5mD9RHyUTXt+ydJsMhbZzZbMOHpOgsEsOLSD2",
	"YPV1Vw5MorUd69XGa4S1FCsxzLfvlOyjTUEJqARnLdE0u05FChhdHvAev/DdImMd7h7luwdRAKGEBVMa",
	"GqeRjwv6FOZ4iumThZgPr05Xcm7W90aIcPlbtzl2bC3zo68AI/DnTCqdocctuQTT6BuFRqRvTNO0BNoO",
	"UbTFBliR5rg47TXssoKVdZpe3bzfvTDT/hAuGlXP8BZj3AZozbA4RjJwec/UNrZ974Jf2gW/pHe23nGn",
	"wTQ1E0tDLu05/iTnosPA9rGDBAGmiKO/a4Mo3cMgowfnfe4YSaNRTMvJPm9D7zAVfuyDUWr+2fvQzW9H",
	"Sq4lSgOYfiEoFgsofHoz7w/jURK5UvBFVMWpqvblzDshNnUdZp7bk7TOheHDUBB+JO5njBewTUMfawUI",
	"efOyDhPu4SQL4DZdSdoslERNHOKPLSJb3Uf2hXYfACSDoC87zuwmOtnuUthO3IASaOF0EgV+ffuPZX9D",
	"HOqmQ+HTrcyn+48QDog0xXRU2KSfhmCAAdOqYsW243iyow4awehR1uUBaQtZixvsAAbaQdBJgmul0nah",
	"1s7Afoo676nRymzstQssNvRNc/cAv6glejBakc39vO1BVxu59u9+utBC0gU4L1RmQbrVELicY9AQZUVX",
	"RDMbTlKw+Rxi74u6ieegBVzPxl6MIN0EkaVdNDXj+ounKTI6QD0NjIdRlqaYBC0M+eQv+14uL9NHpqRw",
	"JURbcwNXVfK5/newy36iZW2UDCZVE57r3E7ty/eIXV+vvoMdjnww6tUAdmBX0PL0BpAGU5b+8ElFCazv",
	"qVaKf1QvW1t4xE6dpXfpjrbGFWUYJv7mlmkVLWgv5TYHowmSMLCM2Y2LdGyCOT3QRnyXlA9tAisOyyCR",
	"vB9PxZQvYdm/ikIuikO0ewm09MSLy5l8mE5uFwmQus3ciAdw/TpcoEk8Y6Sp9Qy3AnuORDmtKinWtMxc",
	"vMTQ5S/F2l3+2NyHV3xkTSZN2Zdfn7187cD/MJ3kJVCZBUvA4KqwXfWnWZUt47D/KrHZvp2h01qKos0P",
	"GZnjGIsNZvbuGJt6RVGa+JnoKLqYi3k64P0g73OhPnaJe0J+oAoRP43P0wb8tIN86Jqy0jsbPbQDwem4",
	"uHGVdZJcIR7g1sFCUczXrccafNxwdfV27fHYuAlswEzIr56IoFIjDORdJpI+hA0RH2B9uKRXmAEzrdhw",
	"lx8TOZ6LMaJ3LqR9I2TrjnEPIJMxSr+f9GZkeYvHgZBwXyazK7OdECvf/bL4xRz6hw/jE/3w4ZT8UroP",
	"EYD4+8z9jmrMw4dJJ2XSWmZ4ERrDOF3Bg/CYY3AjPq6ez2EzTg44W6+CACuGyTBQqA028ujeOOxtJHP4",
	"LNwvBZRgfjoZYwuIN92iOwZmzAm6GHrwGGJZV7YypyKCd0O38a2tIS28U1zlB+vz7R8hXq/QT5qpkuXp",
	"CBI+U4b7cBuzaRoTbDxgFDYj1mwgBJjXLBrLNBuTmrUDZDRHEpkqmR22wd1MuONdc/ZrDYQVRnmaM5B4",
	"fXZuVK+D4Kg9uTdtfnMDW3dYM/xtzC173Fre5LTP1rLXTfgiuK78QlO1hY4MNI9n7DHuPUHijj78LYeP",
	"5pbtSM9x6tKYCu2e0Tmf4MAcyYrrTGVzKX6D9IWNbqpEvg3vX2VoTf4NeCpAsMtSgu+6KRzfzH5ou8er",
	"4EMbf2uV2y86FDe7yWWaPtXHbeRNdGuVzgrtkDyk68WBDO0XCAOsBY9XFHOL1VZ8kBPl9jzZZBOth2zp",
	"Uxk/GT214zen0sHce2Zb0s2MpkrRGJXLwBRtbyscSwviO/sNUCGVgp2dRIHioS2zCesqkI2ro5/89obq",
	"k512tOLU6ElIUbGGNLXREKUSiWFqvqHcFis3/Sy/cr0VWE+/6bUREtNNqnTkWAE5WyWtvldXb4u8HyVU",
	"sAWzdbhrBVGhZzcQsTktkYpcseyQIMSh5nxOHk2javNuNwq2ZorNSsAWj22LGVV4XQave+hilgdcLxU2",
	"fzKi+bLmhYRCL5VFrBIkqLgo5IX4xxnoDQAnj7Dd4y/JfYz8VGwNDwwWnRA0efb4S4zbsX88St2yro76",
	"PpZdIM/2MeFpOsbQVzuGYZJu1HSQ91wC/AbDt8Oe02S7jjlL2NJdKIfP0opyuoD0M5DVAZhsX9xNjBro",
	"4IVbpwMoLcWOMJ2eHzQ1/GngablhfxYMkovViumViw9UYmXoqanibCf1w2G9M1+WysPlP2KYbZVQkz+B",
	"GkNXA0/DMBj6B3QFx2idEmpzjJasCYD3ZUHJuU9hjHW6Qnkuixszl1k6ypIYDz8nlWRco5ml1vPsb0Yt",
	"ljQ37O9kCNxs9sXTRL2rdkkYfhzgHx3vEhTIdRr1coDsvczi+pL7XPBsZThK8aBJ5RCdysF44HTk51D4",
	"6f6hx0q+ZpRskNzqFrnRiFPfivD4ngFvSYphPUfR49Er++iUWcs0edDa7NCPb146KWMlZKouQXPcncQh",
	"QUsGa3yYl94kM+Yt90KWo3bhNtB/2jArL3JGYpk/y0lFIHKc7nuTb6T4n75vEqyj/9Y+eOzYAIVMWDud",
	"3e4jBzUeZ3XruoltXBp+G8DcaLThKH2sDAT52yj+0OdThCV1QbJ73jI4Pv6FSKODoxz/8CEC/fDh1InB",
	"vzxpf7bs/eHDdJ7jpMnN/Npg4TYaMfZN7eFXImEA88URQ9ySS8OQMEAOXVLmg2GCMzfUlLQL0X18KeJu",
	"npGlg1rTp+Dq6i1+8XjAP7qI+MTMEjeweQwxfNjbhTiTJFOE71E4PSVfie1YwuncQZ54/gAoGkDJSPMc",
	"rqRXaDQZFXAwLCWiUTPqDEphlMy49lBsz//z4NksfroH2zUri58aL2vnIpGU58tkMPLMdPzZyuitK9iy",
	"ymQ5kyXlHMrkcFa3/dnrwAkt/Z9i7Dwrxke27Ra6tcvtLK4BvA2mB8pPaNDLdGkmiLHazs4Vsj+UC1EQ",
	"nKepndEwx37F6FSlzsQzahx2VWsXHotPzl1eozkrMdoz7TfGlpmkeiBPF5ZV92WMzDhY5VxZM4MdHSSh",
	"bIUXs6KrqgQ8mWuQdIFdBYdOd8zUhiNHhTGIqswnbIl5MQTRteREzOfRMoBrJqHcTUlFlbKDPDLLgi3O",
	"PXn2+NGjpNkLsTNipRaLfpmvmqU8PsUm9our5WQrDhwF7GFYPzQUdczG9gnHla78tQalUzwVP9gHsugl",
	"Nbe2LVsZSqyekG8xwZIh4lZGfTRX+lzF7byddVUKWkwxh/Ll12cviZ3V9rGV6m3ZzAVa69rkn3SvjM9j",
	"6hNIDSToGT/O/owhZtVKZ6HKZSoFomnR1OFkndAetOPF2DkhL6wJNcSx2EkIZuKWKyiioppWiUfiMP/R",
	"muZLtE22JKBhXjm+3qtnZ43nJnrkGIosIcM2cLuSr7bi65QIvQS5YQrw4T+soZ11MaQgdbZxn4WxvTxZ",
	"c24p5eQIYTSUVDoW7R44K8n6oIIkZB3EH2mZsmWfjy1/e4G90k8+OrV0O15/n8PPZ/Im3zvnQk654CzH",
	"igspSRozxI1zU44oTpH2L6qJO6GJw5Ws4BueHDssDtb09YzQIa7v8o++mk211GH/1LB1ld0WoJXjbFBM",
	"fUFt5xBjXIErmmWIKOaTQiaCmpLvLUIAxZFkhMmfBiyc35hvPzj7N+beuGYcLV0ObU4/sy6rUjH0THPC",
	"NFkIUG497UdD6q3pc4LJIAvYvjt5KRYsv2ALHMOG0Zll29DU/lBnPlDVBYaats9NW5eiP/zcCgezk55V",
	"lZt0uNx6UpDUWz6I4FTckg8kiZAbxo9H20NueyPM8T41hAZrjFqDCu/hHmGEkt3tUb42uqWlKGxB7MPN",
	"ZJ5exhNgvGTcu1DTF0SevBJwY/C8DvRTuaTa6g6jeNol0HLgnQU+hLY++NsO1S1QYFCCa/RzDG9jU218",
	"gHGEBo3ET/mO+ENhqDsSJp7TMkRoJ2qHo1TlhCgb09qpJp5iHIZxZ/5lZgtdB18Jhu5Y9OPYm2goFeKs",
	"LhagM1oUqQxaX+FXgl/9WzTYQl6HWlfhEWI7FXqf2txEueCqXu2Zyze45XRRef4ENYSPUIQdxoQ+sx3+",
	"myr0NLwzLjb76Me/PhC7OC7/f/8xc0rqNTSdKbbIxmMC75Tbo6OZ+maE3vS/U0r3r4L/EI9+O1wu3qMU",
	"f/vaXBxxfuBefLq9WkL6XowFF/jd51UKiSfbXAmvsl45M4x6wM1LbFkHeN8wCfialgMP7mNfib1frf9g",
	"6Nl9PpglgmqXBUxTspcFDWZWsrHCHe9L34U4FB9sw4Pvzmvh1roXocO+u+9anjobI9Ywi0EP3c2caM0G",
	"H+tFc3UN+iZNWpYiH33q3TBnptNw1lCxWrl02okYtvVKFDGdx9FQAGmmZcNzEyH/qHsmv6FilPwiN+nR",
	"WjaLY02lFo1uCVP7EtCD54GxU8cTRSZSh1nyDSuxHtJ/Xrz6YTK8kdEO9LfUZfFNGpWHNiY8luqSx0K0",
	"8FEP204EL1NKxHSiBozcmKsnfRpc0dvkh2+s0W4MSDalzTGtX44dvEcAC5FKUt9POTJpNsKjPaKDZmMt",
	"L4npIkUP362HUqz4Oj/4Pa4n5MLzpq6MBKyZqH1YpX/c4G099leXwqtVN2iAsSWfDH1qd+Sg8/TS1b+2",
	"y3TGtu9+suEVBLiWuz+AK7W36d2iVAk11tqdmyYklE4dVUq1Je6OqYGVKrfklD5vBLcyQ4uWeuWremT1",
	"Yoyc38PHh+nkvDhKEk6V7JrYUVL36Uu2WGqs+PEPoAXI1wcqmjRVTPCIVUKxpoJxaQZzKaSXONzJ2FdE",
	"hoBZXJGlP5aPLl9DrrFsdRM1KwGOqc9iJvPe3L8qmwzfBeGxlStosq+KSb9W9QHhvZd4LUoeaOv8noyv",
	"2XEW3kbYp50bqpp0T52cC6Nffs/nkGNW9b2J7v5rCTxKojb1BleEZR7lvWPhgSLWBTjendAAtC8P3V54",
	"ovpctwZnKA/GNezuKdKihmTh4fA69yaJxxED1rftc9APeYhcOChTgTIQCz7W36Vyb4rrDOaMj9I23nAu",
	"T5Lm4mhSOe6Z0suPN5jLdD0qbSzK+kO58Po114cNCy+wxL1yka80JC6PzW/kvF94a+MSn2NawuAU9SnQ",
	"QfnffA5SO0vJrl39EcSKdUFvqCx8iztJKmfvJpYGeh5mZs3LrH70UqKUCz5yzEthxIhs6KVo+zFUiCS+",
	"p2zId5MADOGag5RQBF9nKRRkWviXXPvg2IcKG9d+IySowfJpFrjB1PlvmtoAWEaSYqp86sLZ4wUSCStq",
	"oJNRBv/hOfch+7n97pN4+DKCB03HgV4P17P2b/KY6iExpvo5cbfl4eQgN7EiM85BZt6l3E3nz9sZHTFv",
	"b1Hn9oKOD0awtI/OvbWHlSQNsHl/lR0dIcp+cQ27U6sE+ULgfgdjoK3kZEGPEhZ3NvlO7eoqBffiTsD7",
	"tHkoKyHKbMCLed6vQdCl+GuWXwPmEA1vV4zsd699Nswk5D46z0KYyma58zn3qwo4FA9OCDnj9rWgj1hp",
	"lyftTM7v6X3zb3HWorZlQZy1/OSKp59dYcEOeUtu5ofZz8MUGFZ3y6nsIAcy3G/5UCzdBot7tKsAn4zV",
	"yvsxJB2pJCIqC0VKJrmwrujneNBThiPMbRIl4cEIBUqcC5uoUqSC9G+Sf8UMlcZUPBkCpIGPSQMSoHCD",
	"JxHgwvMOpBR1n33STDEnEprokJtmD3UJOS1rVkMafXfmMEub382FhHhGjD61mYLDizZMw4v/mTEtqdzd",
	"JMdnG1Up68kglg/GWYYQy2YhTZhlH4dlKTYZMqss1MlJqbamnWpfxr5oY9PPnOoZRAGbVDlBbUeWtCC5",
	"kBLyuEf6IbeFaiUkZKXA+M1UaMlcG7l7ha83OSnFgogqFwXYelNpChqaq+acotgEUbhcEgWWdjANgO0T",
	"0fHIKc2dah3EGYpaB8sz+M2/NH1sSoomK5xddGaDFAaeIoByWeAchmzjPrxIODafUdeWmObNc7ZFugGZ",
	"OvJzomUNU+JadGvsu4NPJZAVU8qCEmhpw8oSM0KwbRRSESKS0qgdEHvPMV56zTCorp0dxErDlbnzQsqU",
	"mAdcxPnMiF5KUS+WUYL6AKdXeWXtFOJ4lB9VjXGP+DTUTPGUrITSTtO0IzVLbmJJ7+eCaynKsm2UsiL6",
	"wlnav6fbszzXL4W4ntH8+gHqtVzosNJi6hMndKN+m5lkJzVh+wLOkAbU4VTfth3GwDqiHc0gOyyuZxQ/",
	"ZGWOwHx3mIMetrmf9RfWXVebmabVmDNOqBYrlqfP1J8rjHYw+DXFopLJCG1tVps+BpvhYY8vqxA1hSyy",
	"j2bgNFlc8ow4RuCiR5DdmP+iBN4dl8zBMZqBi7LPXJwUleWDsl4HAITU5jTQtbQFXWNJLHAVsbA5UDD2",
	"pQvoyFsFQwxvB5sZ4c6B0nAroHphzQHA+9b4MLVJI22I9Exs/fcHTVbJGwH/YT+Vt5jHUOzmRUNa0kZv",
	"+gxUAxwhnSJ/b6DjJeazmI0NdwzFt0fe8BEAwwGQLRhGhUEeC8acshKKLFW79TzYqKaRpu3eXLZr1+O9",
	"bDl5TmtfOtWMXUtwGZGsiC/b/q+KGlISoXnfkswL2IJ9sPUbSGFrok4j/wuUtmRqxxggqqyENbTiQl2a",
	"phpFTbYG31eFzqQAqNAb2bWRpQIe47u8Yzhxa8+ikLkx2E1aUixi7U6RA2aSpFFnyzN7TNTYo2QgWrOi",
	"pi38qWNFjrYZ0BzlBKp6OkLm9cix0/xoR3jjBzjz/VOijMfEu3F86GgWlEbdPgZ0MAC6VkOnnqfjn+Mc",
	"ZMHBgrMVwRFrSbzhG6qiGz5skOyTfKNujdwnJniE2K+3kKNU4/QdKJzGM+CkcOmMkNo5QGG1AtMlYW1f",
	"AidcRCVqN1QFVaVJjup/sBNjI8adNn0Dp3ITpnz7nSU4GFGdLImDioQMdHpz8/wnOYl7D+LgeCkaUeDe",
	"9e6xf3nqdmoHNhB1WRBu9tPI/ljk1d1ijotPyaz2A5Wl2Nias7Ee+gK8H9RSn3cBObGchWvZh2NPXd7e",
	"rqmDRQ9RVnRHhMR/jNb5a01LNt8hn7Hg+25ELakhIed4tREBLrzbTLxfvJp6wLy1Rfip7LrZ2DGj4XZm",
	"lAhoc5H74mCCrOg1xNuAwQ6Wf+baME5Vz9ByYa7sznb2seAW73MvrWgRa/qYAXbX4g4+J7jp/f81j1zj",
	"qXzixqqkua8w7EqctfkMVhH3xKWXsNr/CrrP1zwJhMrkDdFKnzajuIHJ9EjWlXpaNFS+qQV2r2Jzr3LV",
	"rZYx0vLbqdGz5/34qKXc9S6MjbrpAR3XeT0Eflz29uPgP5mceWgZY8D/o+B9oNB1DK+taf0RsNxKrZOA",
	"1VqrZ2KbSZirQwEm1lxt1HnZJOXxJlbGcwlU2Yib81dO8WxyDzNuFGEbExp8mmGUAuaMN8yS8arWCT0G",
	"UxDzXYSw2OiPaB1woQ1JCUaYXNPy1RqkZMXQxpnTYUvCxiVmvKPD9U2YMMKd2h+AqUaHw4fXjRk9bmYu",
	"cFvEzoZrKk15QWURN2ec5CDNvU82dKdu7lEKzoFDPiUaSTPtdCCRdwlJ2wJS7pxT+Jb+ngAgvUPHzwiH",
	"DcYFJ5w11rSjxYB/pg/Dn8Jhs6LbrBQLfB48cCBc0mn08FkVUHA0g1v5bNy6/TyK/Qb7p8F6G44RaYGz",
	"jpli/7l/hVuJauSPnOm9J9/aKLvvtW3crT2YHql80QT/W2Lpn8fUE3uXVSl+Zu+FTf9UxdMeRJsIA/6h",
	"tl18YBcxDMLlZ4iN4OPLJbYjLVIP+a1lIEOLgdoT3g+qCWWnuQvP6pvSeqYGi5SpS4NwpKXN2uf9vTQA",
	"HppClDvr7WlDyIwZ55gak/sTH2SVqLJ8TMynLclTODeBg7QN4wB9RE6AgXWH8BgVilS1Epq1qlUdW2Zz",
	"sFrWIW9Xle9T+ofMRAMcve2CEHPkZXiErXEMX/IEY8q0+8asbQYLTIJQIiGvJZqJN3R3uGzhQCr4i3+c",
	"ff74yc9PPv+CmAakYAtQTTmBTtm/Ji6Q8a7d5+NGAvaWp9Ob4NOKWMR5/6N/VBU2xZ01y21Vkyu4V/Tw",
	"GPty4gJIvfTt14G70V7hOE1o/x9ru1KLvPMdS6Hg998zKcoyXc4lyFUJB0pqtyIXitFAKpCKKW0YYdsD",
	"ynQTEa2WaB7EpN5rmyZK8By8/dhRAdMDIVephQwF1CI/w6QNzmtEYFuVjldZT8++dTk9zVroUGjEqJgZ",
	"kEpUTrRnc5KCCF8QyehlrTN8okU8ipENzNZGy6YI0UWep0kvLri/n9u3i0HrNKc3m5gQL/yhvAFpDvkn",
	"hhOS3ISTNKb9Pwz/SGRYuTOuEZb7e/CKpH6w583xWS/uIWQXGQVaP9tGgjwQgIHXtq13ktFDsSjDuLRe",
	"AvQneAdyV/z4vnEsH3wWgpD4DgfAi5/PNu3CSwYHzidO1f19QEq0lHdDlNBa/qEXuZ71hosk2iJnNNEa",
	"lGVLoi8WRs+t1fPwinlAK+k9dpZCaGI007JMPJK2dhw8UzHhGJVArmn58bnGN0wqfYb4gOLN8NOo+KVs",
	"jGSLSnWzBJwv6ai5o1exdzc1f40Ps/8LzB4l7zk3lHPC924zNO7Q0oZXz4M3GjjZ4Jg2yOrxF2TmquhU",
	"EnKmus79jRdOwsNQkGzuAlphqw+8RD20zp+EvgUZz30kDvkhcm8Fn72DsDmin5ipDJzcJJWnqK9HFgn8",
	"pXhUXNz7wHVxy4orN8vnFGVmPDKfU79s+djl2dQm5tKpFfTXOfq2buE2cVE3axubjGx04Zarq7d6NiaH",
	"WLrIiumOSczupNrKUbVWfof0ZRZHbgw3b4pifhpKaG2TNg8k3e/sR83KgwErrRIKH6aThc1ghEUCfnZF",
	"oT7uXeohGEgj5pZ+m3QxFjGJtbYmj6aKMj6NqIvguiWS2eOrxryWTO+wILg3oLGfk/mYvg25PVxumOBL",
	"c3efFtfAfbxHkwmkVv52/VbQEu8j6+Lj5hYS5Qn52qbudwfl7/dm/w6f/e1p8eizx/8++9ujzx/l8PTz",
	"Lx89ol8+pY+//OwxPPnb508fweP5F1/OnhRPnj6ZPX3y9IvPv8w/e/p49vSLL//9nuFDBmQLqK/Z8Wzy",
	"v7KzciGys9fn2aUBtsEJrdh3YPYGdeU55i1DpOZ4EmFFWTl55n/6//0JO8nFqhne/zpxhdcmS60r9ez0",
	"dLPZnMRdThf49D/Tos6Xp34eTHHXklden4cYfRuHgzvaWI9xU0PyL/PtzdcXl+Ts9flJQzCTZ5NHJ49O",
	"Hrua9ZxWbPJs8hn+hKdnift+iolzT5WriXHavNVK+u3eYMi6F87lAgpyP7y6+bfguVUP/OOduUtO909l",
	"iTGs4rxA4nLFhydYThGDsRCsJ48e+b1wkk504Zzi649n7ycqFLTvChM9pF42ACcha4q59hf9I7/mYsMJ",
	"Zvm0B6herajc2RW0sBENjttEFwqN7JKtMW2b6d3FeVW5SiRDKMfyde1T7jsjgYRSFuaE2QoXrp6ISqG8",
	"XwXlltjfm/W1N1lid7DRawOzT58TMqU6h5DDGfqMLcLCGbFmhx6ip5OqTqDza3xYo/bhbBpV17DQiLII",
	"GO9h9HX9/whGDekuQlZQ89cSaImJtcwfK0Oouf8kgRY793+1oYsFyBO3TvPT+smp10JO37uMKR/2fTuN",
	"I8JO37cSyxQHevqIp0NNTt/7Wvj7B2zVQXexplGHkYDua3Y6w/p3Y5tCvLrhpSDNq9P3qIAP/n7qrKjp",
	"j2gIsTfsqU/QNNDSpuJIf2yh8L3emoXsH860icbLqc6XdXX6Hv+DZButyKbsPtVbfoqBI6fvW4hwn3uI",
	"aP/edI9bYDZaD5yYzxUy7X2fT9/bf6OJYFuBZEYLxWxa7leb9fAU68ju+j/veJ78sb+OVsa3A5c5ZhNU",
	"PpqqnSgueX10s8+p2zK7cblsujnv+gJ2X5Lat7IP08nTO+TK7RTgCWC+ogXxiQ1w7scfb+5zbqO6jWhp",
	"RWCE4OnHg6C1feQ72JEfhCbfoK3mw3Ty+cfciXNuNEdaeoHuhqLfuOPTvUaN7B2a8YUVVIRNdtE+amdF",
	"0SN6q0OC0l8JvF2HMLZSi8p5aRukNSo042YJ03Ficz99pE1y5gUJLgqYxMqtljV8uCVP6MR3UanPEyZl",
	"9I3gQw9ntW2BmsyF2I1+sSMn0jAfIOHzF37S5n3EXzzlL54SeMrnjz77eNNfgFyzHMglrCohqWTljvzI",
	"w8ObG/O4s6JIJpBtH/2DPG462Wa5KGABPHMMLJuJYudKbU1aE1yDtZb1BJlTb11qaQwD3NPbrVLSShMO",
	"Pnn2NhUW4Z43VvWsZDmxlnU0LVVULyPLT8jo2WZ+0z2WiWmiHAQpWFmHbA56I9xr6f6FEllbtCDqV4kX",
	"Dx5Epndkw3ghNg9OPLi/1oB83sHrp5kkAIxifPuVzxqHoQGwB9bQfOhpHIOdPZO/pDebu6THTv3u97ZB",
	"hYx5/3nx6ofoNaK1NNiAIHwLZ0kXHy5IgQH5G4oRobZC6nNrAyp3+KpWU12rVnHGk7/uob94/+15/7ch",
	"hbIty6ix3lqfJUV3wckogTfJ29+3/nR2i4kNx04lPja/E0oWWFK3f0HNduT8RU97td26V8JXO2zauRUS",
	"/L4L4lGMf4C97BNpzEIWQoegdLuov4TMv4TMWymuow/PGN01aVmyha5pTx+b+prVrYc/mLwcQ7x6oIyx",
	"P33S43snG9+3baVsWTbJOhQk+mCzU3TR/BeL+ItF3I5FfAuJw4in1jGNBNEdZ+sayzAwlVLRCrH0Uodv",
	"XpdURg+CD5mwz3DEtCr4u3CNj22wS+LK2uvw3QCzAbOJDbxbG95fLO8vlvfnYXlnhxlNWzC5tdXrGnYr",
	"WgVbl1rWuhCbyEOOsNhg976Pzyr+3b9PN5TpbC6kK9lD5xpkv7MGWp66wvudX5tat70vWMA3+jFORpf8",
	"9ZS2nZZtx7lhvUMde1711FfnOB5o5HMo+M9NzF4cA4dsP0S/vX1nWLYCufY3QhPS9ez0FJPqLIXSp5MP",
	"0/edcK/447tAHu/DPeLI5APShZBswTgtMxcbkTVhW09OHk0+/N8AAAD//0+OWaNUIQEA",
}

// GetSwagger returns the content of the embedded swagger specification file
// or error if failed to decode
func decodeSpec() ([]byte, error) {
	zipped, err := base64.StdEncoding.DecodeString(strings.Join(swaggerSpec, ""))
	if err != nil {
		return nil, fmt.Errorf("error base64 decoding spec: %s", err)
	}
	zr, err := gzip.NewReader(bytes.NewReader(zipped))
	if err != nil {
		return nil, fmt.Errorf("error decompressing spec: %s", err)
	}
	var buf bytes.Buffer
	_, err = buf.ReadFrom(zr)
	if err != nil {
		return nil, fmt.Errorf("error decompressing spec: %s", err)
	}

	return buf.Bytes(), nil
}

var rawSpec = decodeSpecCached()

// a naive cached of a decoded swagger spec
func decodeSpecCached() func() ([]byte, error) {
	data, err := decodeSpec()
	return func() ([]byte, error) {
		return data, err
	}
}

// Constructs a synthetic filesystem for resolving external references when loading openapi specifications.
func PathToRawSpec(pathToFile string) map[string]func() ([]byte, error) {
	var res = make(map[string]func() ([]byte, error))
	if len(pathToFile) > 0 {
		res[pathToFile] = rawSpec
	}

	return res
}

// GetSwagger returns the Swagger specification corresponding to the generated code
// in this file. The external references of Swagger specification are resolved.
// The logic of resolving external references is tightly connected to "import-mapping" feature.
// Externally referenced files must be embedded in the corresponding golang packages.
// Urls can be supported but this task was out of the scope.
func GetSwagger() (swagger *openapi3.T, err error) {
	var resolvePath = PathToRawSpec("")

	loader := openapi3.NewLoader()
	loader.IsExternalRefsAllowed = true
	loader.ReadFromURIFunc = func(loader *openapi3.Loader, url *url.URL) ([]byte, error) {
		var pathToFile = url.String()
		pathToFile = path.Clean(pathToFile)
		getSpec, ok := resolvePath[pathToFile]
		if !ok {
			err1 := fmt.Errorf("path not found: %s", pathToFile)
			return nil, err1
		}
		return getSpec()
	}
	var specData []byte
	specData, err = rawSpec()
	if err != nil {
		return
	}
	swagger, err = loader.LoadFromData(specData)
	if err != nil {
		return
	}
	return
}
