// Package public provides primitives to interact with the openapi HTTP API.
//
// Code generated by github.com/algorand/oapi-codegen DO NOT EDIT.
package public

import (
	"bytes"
	"compress/gzip"
	"encoding/base64"
	"fmt"
	"net/http"
	"net/url"
	"path"
	"strings"

	. "github.com/algorand/go-algorand/daemon/algod/api/server/v2/generated/model"
	"github.com/algorand/oapi-codegen/pkg/runtime"
	"github.com/getkin/kin-openapi/openapi3"
	"github.com/labstack/echo/v4"
)

// ServerInterface represents all server handlers.
type ServerInterface interface {
	// Get account information.
	// (GET /v2/accounts/{address})
	AccountInformation(ctx echo.Context, address string, params AccountInformationParams) error
	// Get account information about a given app.
	// (GET /v2/accounts/{address}/applications/{application-id})
	AccountApplicationInformation(ctx echo.Context, address string, applicationId uint64, params AccountApplicationInformationParams) error
	// Get account information about a given asset.
	// (GET /v2/accounts/{address}/assets/{asset-id})
	AccountAssetInformation(ctx echo.Context, address string, assetId uint64, params AccountAssetInformationParams) error
	// Get application information.
	// (GET /v2/applications/{application-id})
	GetApplicationByID(ctx echo.Context, applicationId uint64) error
	// Get box information for a given application.
	// (GET /v2/applications/{application-id}/box)
	GetApplicationBoxByName(ctx echo.Context, applicationId uint64, params GetApplicationBoxByNameParams) error
	// Get all box names for a given application.
	// (GET /v2/applications/{application-id}/boxes)
	GetApplicationBoxes(ctx echo.Context, applicationId uint64, params GetApplicationBoxesParams) error
	// Get asset information.
	// (GET /v2/assets/{asset-id})
	GetAssetByID(ctx echo.Context, assetId uint64) error
	// Get the block for the given round.
	// (GET /v2/blocks/{round})
	GetBlock(ctx echo.Context, round uint64, params GetBlockParams) error
	// Get the block hash for the block on the given round.
	// (GET /v2/blocks/{round}/hash)
	GetBlockHash(ctx echo.Context, round uint64) error
	// Gets a proof for a given light block header inside a state proof commitment
	// (GET /v2/blocks/{round}/lightheader/proof)
	GetLightBlockHeaderProof(ctx echo.Context, round uint64) error
	// Get all of the logs from outer and inner app calls in the given round
	// (GET /v2/blocks/{round}/logs)
	GetBlockLogs(ctx echo.Context, round uint64) error
	// Get a proof for a transaction in a block.
	// (GET /v2/blocks/{round}/transactions/{txid}/proof)
	GetTransactionProof(ctx echo.Context, round uint64, txid string, params GetTransactionProofParams) error
	// Get the top level transaction IDs for the block on the given round.
	// (GET /v2/blocks/{round}/txids)
	GetBlockTxids(ctx echo.Context, round uint64) error
	// Get a LedgerStateDelta object for a given transaction group
	// (GET /v2/deltas/txn/group/{id})
	GetLedgerStateDeltaForTransactionGroup(ctx echo.Context, id string, params GetLedgerStateDeltaForTransactionGroupParams) error
	// Get a LedgerStateDelta object for a given round
	// (GET /v2/deltas/{round})
	GetLedgerStateDelta(ctx echo.Context, round uint64, params GetLedgerStateDeltaParams) error
	// Get LedgerStateDelta objects for all transaction groups in a given round
	// (GET /v2/deltas/{round}/txn/group)
	GetTransactionGroupLedgerStateDeltasForRound(ctx echo.Context, round uint64, params GetTransactionGroupLedgerStateDeltasForRoundParams) error
	// Returns the timestamp offset. Timestamp offsets can only be set in dev mode.
	// (GET /v2/devmode/blocks/offset)
	GetBlockTimeStampOffset(ctx echo.Context) error
	// Given a timestamp offset in seconds, adds the offset to every subsequent block header's timestamp.
	// (POST /v2/devmode/blocks/offset/{offset})
	SetBlockTimeStampOffset(ctx echo.Context, offset uint64) error
	// Get the current supply reported by the ledger.
	// (GET /v2/ledger/supply)
	GetSupply(ctx echo.Context) error
	// Get a state proof that covers a given round
	// (GET /v2/stateproofs/{round})
	GetStateProof(ctx echo.Context, round uint64) error
	// Gets the current node status.
	// (GET /v2/status)
	GetStatus(ctx echo.Context) error
	// Gets the node status after waiting for a round after the given round.
	// (GET /v2/status/wait-for-block-after/{round})
	WaitForBlock(ctx echo.Context, round uint64) error
	// Compile TEAL source code to binary, produce its hash
	// (POST /v2/teal/compile)
	TealCompile(ctx echo.Context, params TealCompileParams) error
	// Disassemble program bytes into the TEAL source code.
	// (POST /v2/teal/disassemble)
	TealDisassemble(ctx echo.Context) error
	// Provide debugging information for a transaction (or group).
	// (POST /v2/teal/dryrun)
	TealDryrun(ctx echo.Context) error
	// Get parameters for constructing a new transaction
	// (GET /v2/transactions/params)
	TransactionParams(ctx echo.Context) error
	// Simulates a raw transaction or transaction group as it would be evaluated on the network. The simulation will use blockchain state from the latest committed round.
	// (POST /v2/transactions/simulate)
	SimulateTransaction(ctx echo.Context, params SimulateTransactionParams) error
}

// ServerInterfaceWrapper converts echo contexts to parameters.
type ServerInterfaceWrapper struct {
	Handler ServerInterface
}

// AccountInformation converts echo context to params.
func (w *ServerInterfaceWrapper) AccountInformation(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "address" -------------
	var address string

	err = runtime.BindStyledParameterWithLocation("simple", false, "address", runtime.ParamLocationPath, ctx.Param("address"), &address)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter address: %s", err))
	}

	ctx.Set(Api_keyScopes, []string{""})

	// Parameter object where we will unmarshal all parameters from the context
	var params AccountInformationParams
	// ------------- Optional query parameter "format" -------------

	err = runtime.BindQueryParameter("form", true, false, "format", ctx.QueryParams(), &params.Format)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter format: %s", err))
	}

	// ------------- Optional query parameter "exclude" -------------

	err = runtime.BindQueryParameter("form", true, false, "exclude", ctx.QueryParams(), &params.Exclude)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter exclude: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.AccountInformation(ctx, address, params)
	return err
}

// AccountApplicationInformation converts echo context to params.
func (w *ServerInterfaceWrapper) AccountApplicationInformation(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "address" -------------
	var address string

	err = runtime.BindStyledParameterWithLocation("simple", false, "address", runtime.ParamLocationPath, ctx.Param("address"), &address)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter address: %s", err))
	}

	// ------------- Path parameter "application-id" -------------
	var applicationId uint64

	err = runtime.BindStyledParameterWithLocation("simple", false, "application-id", runtime.ParamLocationPath, ctx.Param("application-id"), &applicationId)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter application-id: %s", err))
	}

	ctx.Set(Api_keyScopes, []string{""})

	// Parameter object where we will unmarshal all parameters from the context
	var params AccountApplicationInformationParams
	// ------------- Optional query parameter "format" -------------

	err = runtime.BindQueryParameter("form", true, false, "format", ctx.QueryParams(), &params.Format)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter format: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.AccountApplicationInformation(ctx, address, applicationId, params)
	return err
}

// AccountAssetInformation converts echo context to params.
func (w *ServerInterfaceWrapper) AccountAssetInformation(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "address" -------------
	var address string

	err = runtime.BindStyledParameterWithLocation("simple", false, "address", runtime.ParamLocationPath, ctx.Param("address"), &address)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter address: %s", err))
	}

	// ------------- Path parameter "asset-id" -------------
	var assetId uint64

	err = runtime.BindStyledParameterWithLocation("simple", false, "asset-id", runtime.ParamLocationPath, ctx.Param("asset-id"), &assetId)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter asset-id: %s", err))
	}

	ctx.Set(Api_keyScopes, []string{""})

	// Parameter object where we will unmarshal all parameters from the context
	var params AccountAssetInformationParams
	// ------------- Optional query parameter "format" -------------

	err = runtime.BindQueryParameter("form", true, false, "format", ctx.QueryParams(), &params.Format)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter format: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.AccountAssetInformation(ctx, address, assetId, params)
	return err
}

// GetApplicationByID converts echo context to params.
func (w *ServerInterfaceWrapper) GetApplicationByID(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "application-id" -------------
	var applicationId uint64

	err = runtime.BindStyledParameterWithLocation("simple", false, "application-id", runtime.ParamLocationPath, ctx.Param("application-id"), &applicationId)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter application-id: %s", err))
	}

	ctx.Set(Api_keyScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetApplicationByID(ctx, applicationId)
	return err
}

// GetApplicationBoxByName converts echo context to params.
func (w *ServerInterfaceWrapper) GetApplicationBoxByName(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "application-id" -------------
	var applicationId uint64

	err = runtime.BindStyledParameterWithLocation("simple", false, "application-id", runtime.ParamLocationPath, ctx.Param("application-id"), &applicationId)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter application-id: %s", err))
	}

	ctx.Set(Api_keyScopes, []string{""})

	// Parameter object where we will unmarshal all parameters from the context
	var params GetApplicationBoxByNameParams
	// ------------- Required query parameter "name" -------------

	err = runtime.BindQueryParameter("form", true, true, "name", ctx.QueryParams(), &params.Name)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter name: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetApplicationBoxByName(ctx, applicationId, params)
	return err
}

// GetApplicationBoxes converts echo context to params.
func (w *ServerInterfaceWrapper) GetApplicationBoxes(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "application-id" -------------
	var applicationId uint64

	err = runtime.BindStyledParameterWithLocation("simple", false, "application-id", runtime.ParamLocationPath, ctx.Param("application-id"), &applicationId)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter application-id: %s", err))
	}

	ctx.Set(Api_keyScopes, []string{""})

	// Parameter object where we will unmarshal all parameters from the context
	var params GetApplicationBoxesParams
	// ------------- Optional query parameter "max" -------------

	err = runtime.BindQueryParameter("form", true, false, "max", ctx.QueryParams(), &params.Max)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter max: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetApplicationBoxes(ctx, applicationId, params)
	return err
}

// GetAssetByID converts echo context to params.
func (w *ServerInterfaceWrapper) GetAssetByID(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "asset-id" -------------
	var assetId uint64

	err = runtime.BindStyledParameterWithLocation("simple", false, "asset-id", runtime.ParamLocationPath, ctx.Param("asset-id"), &assetId)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter asset-id: %s", err))
	}

	ctx.Set(Api_keyScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetAssetByID(ctx, assetId)
	return err
}

// GetBlock converts echo context to params.
func (w *ServerInterfaceWrapper) GetBlock(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "round" -------------
	var round uint64

	err = runtime.BindStyledParameterWithLocation("simple", false, "round", runtime.ParamLocationPath, ctx.Param("round"), &round)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter round: %s", err))
	}

	ctx.Set(Api_keyScopes, []string{""})

	// Parameter object where we will unmarshal all parameters from the context
	var params GetBlockParams
	// ------------- Optional query parameter "format" -------------

	err = runtime.BindQueryParameter("form", true, false, "format", ctx.QueryParams(), &params.Format)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter format: %s", err))
	}

	// ------------- Optional query parameter "header-only" -------------

	err = runtime.BindQueryParameter("form", true, false, "header-only", ctx.QueryParams(), &params.HeaderOnly)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter header-only: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetBlock(ctx, round, params)
	return err
}

// GetBlockHash converts echo context to params.
func (w *ServerInterfaceWrapper) GetBlockHash(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "round" -------------
	var round uint64

	err = runtime.BindStyledParameterWithLocation("simple", false, "round", runtime.ParamLocationPath, ctx.Param("round"), &round)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter round: %s", err))
	}

	ctx.Set(Api_keyScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetBlockHash(ctx, round)
	return err
}

// GetLightBlockHeaderProof converts echo context to params.
func (w *ServerInterfaceWrapper) GetLightBlockHeaderProof(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "round" -------------
	var round uint64

	err = runtime.BindStyledParameterWithLocation("simple", false, "round", runtime.ParamLocationPath, ctx.Param("round"), &round)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter round: %s", err))
	}

	ctx.Set(Api_keyScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetLightBlockHeaderProof(ctx, round)
	return err
}

// GetBlockLogs converts echo context to params.
func (w *ServerInterfaceWrapper) GetBlockLogs(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "round" -------------
	var round uint64

	err = runtime.BindStyledParameterWithLocation("simple", false, "round", runtime.ParamLocationPath, ctx.Param("round"), &round)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter round: %s", err))
	}

	ctx.Set(Api_keyScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetBlockLogs(ctx, round)
	return err
}

// GetTransactionProof converts echo context to params.
func (w *ServerInterfaceWrapper) GetTransactionProof(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "round" -------------
	var round uint64

	err = runtime.BindStyledParameterWithLocation("simple", false, "round", runtime.ParamLocationPath, ctx.Param("round"), &round)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter round: %s", err))
	}

	// ------------- Path parameter "txid" -------------
	var txid string

	err = runtime.BindStyledParameterWithLocation("simple", false, "txid", runtime.ParamLocationPath, ctx.Param("txid"), &txid)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter txid: %s", err))
	}

	ctx.Set(Api_keyScopes, []string{""})

	// Parameter object where we will unmarshal all parameters from the context
	var params GetTransactionProofParams
	// ------------- Optional query parameter "hashtype" -------------

	err = runtime.BindQueryParameter("form", true, false, "hashtype", ctx.QueryParams(), &params.Hashtype)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter hashtype: %s", err))
	}

	// ------------- Optional query parameter "format" -------------

	err = runtime.BindQueryParameter("form", true, false, "format", ctx.QueryParams(), &params.Format)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter format: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetTransactionProof(ctx, round, txid, params)
	return err
}

// GetBlockTxids converts echo context to params.
func (w *ServerInterfaceWrapper) GetBlockTxids(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "round" -------------
	var round uint64

	err = runtime.BindStyledParameterWithLocation("simple", false, "round", runtime.ParamLocationPath, ctx.Param("round"), &round)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter round: %s", err))
	}

	ctx.Set(Api_keyScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetBlockTxids(ctx, round)
	return err
}

// GetLedgerStateDeltaForTransactionGroup converts echo context to params.
func (w *ServerInterfaceWrapper) GetLedgerStateDeltaForTransactionGroup(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameterWithLocation("simple", false, "id", runtime.ParamLocationPath, ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	ctx.Set(Api_keyScopes, []string{""})

	// Parameter object where we will unmarshal all parameters from the context
	var params GetLedgerStateDeltaForTransactionGroupParams
	// ------------- Optional query parameter "format" -------------

	err = runtime.BindQueryParameter("form", true, false, "format", ctx.QueryParams(), &params.Format)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter format: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetLedgerStateDeltaForTransactionGroup(ctx, id, params)
	return err
}

// GetLedgerStateDelta converts echo context to params.
func (w *ServerInterfaceWrapper) GetLedgerStateDelta(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "round" -------------
	var round uint64

	err = runtime.BindStyledParameterWithLocation("simple", false, "round", runtime.ParamLocationPath, ctx.Param("round"), &round)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter round: %s", err))
	}

	ctx.Set(Api_keyScopes, []string{""})

	// Parameter object where we will unmarshal all parameters from the context
	var params GetLedgerStateDeltaParams
	// ------------- Optional query parameter "format" -------------

	err = runtime.BindQueryParameter("form", true, false, "format", ctx.QueryParams(), &params.Format)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter format: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetLedgerStateDelta(ctx, round, params)
	return err
}

// GetTransactionGroupLedgerStateDeltasForRound converts echo context to params.
func (w *ServerInterfaceWrapper) GetTransactionGroupLedgerStateDeltasForRound(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "round" -------------
	var round uint64

	err = runtime.BindStyledParameterWithLocation("simple", false, "round", runtime.ParamLocationPath, ctx.Param("round"), &round)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter round: %s", err))
	}

	ctx.Set(Api_keyScopes, []string{""})

	// Parameter object where we will unmarshal all parameters from the context
	var params GetTransactionGroupLedgerStateDeltasForRoundParams
	// ------------- Optional query parameter "format" -------------

	err = runtime.BindQueryParameter("form", true, false, "format", ctx.QueryParams(), &params.Format)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter format: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetTransactionGroupLedgerStateDeltasForRound(ctx, round, params)
	return err
}

// GetBlockTimeStampOffset converts echo context to params.
func (w *ServerInterfaceWrapper) GetBlockTimeStampOffset(ctx echo.Context) error {
	var err error

	ctx.Set(Api_keyScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetBlockTimeStampOffset(ctx)
	return err
}

// SetBlockTimeStampOffset converts echo context to params.
func (w *ServerInterfaceWrapper) SetBlockTimeStampOffset(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "offset" -------------
	var offset uint64

	err = runtime.BindStyledParameterWithLocation("simple", false, "offset", runtime.ParamLocationPath, ctx.Param("offset"), &offset)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter offset: %s", err))
	}

	ctx.Set(Api_keyScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.SetBlockTimeStampOffset(ctx, offset)
	return err
}

// GetSupply converts echo context to params.
func (w *ServerInterfaceWrapper) GetSupply(ctx echo.Context) error {
	var err error

	ctx.Set(Api_keyScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetSupply(ctx)
	return err
}

// GetStateProof converts echo context to params.
func (w *ServerInterfaceWrapper) GetStateProof(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "round" -------------
	var round uint64

	err = runtime.BindStyledParameterWithLocation("simple", false, "round", runtime.ParamLocationPath, ctx.Param("round"), &round)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter round: %s", err))
	}

	ctx.Set(Api_keyScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetStateProof(ctx, round)
	return err
}

// GetStatus converts echo context to params.
func (w *ServerInterfaceWrapper) GetStatus(ctx echo.Context) error {
	var err error

	ctx.Set(Api_keyScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetStatus(ctx)
	return err
}

// WaitForBlock converts echo context to params.
func (w *ServerInterfaceWrapper) WaitForBlock(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "round" -------------
	var round uint64

	err = runtime.BindStyledParameterWithLocation("simple", false, "round", runtime.ParamLocationPath, ctx.Param("round"), &round)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter round: %s", err))
	}

	ctx.Set(Api_keyScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.WaitForBlock(ctx, round)
	return err
}

// TealCompile converts echo context to params.
func (w *ServerInterfaceWrapper) TealCompile(ctx echo.Context) error {
	var err error

	ctx.Set(Api_keyScopes, []string{""})

	// Parameter object where we will unmarshal all parameters from the context
	var params TealCompileParams
	// ------------- Optional query parameter "sourcemap" -------------

	err = runtime.BindQueryParameter("form", true, false, "sourcemap", ctx.QueryParams(), &params.Sourcemap)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter sourcemap: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.TealCompile(ctx, params)
	return err
}

// TealDisassemble converts echo context to params.
func (w *ServerInterfaceWrapper) TealDisassemble(ctx echo.Context) error {
	var err error

	ctx.Set(Api_keyScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.TealDisassemble(ctx)
	return err
}

// TealDryrun converts echo context to params.
func (w *ServerInterfaceWrapper) TealDryrun(ctx echo.Context) error {
	var err error

	ctx.Set(Api_keyScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.TealDryrun(ctx)
	return err
}

// TransactionParams converts echo context to params.
func (w *ServerInterfaceWrapper) TransactionParams(ctx echo.Context) error {
	var err error

	ctx.Set(Api_keyScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.TransactionParams(ctx)
	return err
}

// SimulateTransaction converts echo context to params.
func (w *ServerInterfaceWrapper) SimulateTransaction(ctx echo.Context) error {
	var err error

	ctx.Set(Api_keyScopes, []string{""})

	// Parameter object where we will unmarshal all parameters from the context
	var params SimulateTransactionParams
	// ------------- Optional query parameter "format" -------------

	err = runtime.BindQueryParameter("form", true, false, "format", ctx.QueryParams(), &params.Format)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter format: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.SimulateTransaction(ctx, params)
	return err
}

// This is a simple interface which specifies echo.Route addition functions which
// are present on both echo.Echo and echo.Group, since we want to allow using
// either of them for path registration
type EchoRouter interface {
	CONNECT(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	DELETE(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	GET(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	HEAD(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	OPTIONS(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	PATCH(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	POST(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	PUT(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	TRACE(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
}

// RegisterHandlers adds each server route to the EchoRouter.
func RegisterHandlers(router EchoRouter, si ServerInterface, m ...echo.MiddlewareFunc) {
	RegisterHandlersWithBaseURL(router, si, "", m...)
}

// Registers handlers, and prepends BaseURL to the paths, so that the paths
// can be served under a prefix.
func RegisterHandlersWithBaseURL(router EchoRouter, si ServerInterface, baseURL string, m ...echo.MiddlewareFunc) {

	wrapper := ServerInterfaceWrapper{
		Handler: si,
	}

	router.GET(baseURL+"/v2/accounts/:address", wrapper.AccountInformation, m...)
	router.GET(baseURL+"/v2/accounts/:address/applications/:application-id", wrapper.AccountApplicationInformation, m...)
	router.GET(baseURL+"/v2/accounts/:address/assets/:asset-id", wrapper.AccountAssetInformation, m...)
	router.GET(baseURL+"/v2/applications/:application-id", wrapper.GetApplicationByID, m...)
	router.GET(baseURL+"/v2/applications/:application-id/box", wrapper.GetApplicationBoxByName, m...)
	router.GET(baseURL+"/v2/applications/:application-id/boxes", wrapper.GetApplicationBoxes, m...)
	router.GET(baseURL+"/v2/assets/:asset-id", wrapper.GetAssetByID, m...)
	router.GET(baseURL+"/v2/blocks/:round", wrapper.GetBlock, m...)
	router.GET(baseURL+"/v2/blocks/:round/hash", wrapper.GetBlockHash, m...)
	router.GET(baseURL+"/v2/blocks/:round/lightheader/proof", wrapper.GetLightBlockHeaderProof, m...)
	router.GET(baseURL+"/v2/blocks/:round/logs", wrapper.GetBlockLogs, m...)
	router.GET(baseURL+"/v2/blocks/:round/transactions/:txid/proof", wrapper.GetTransactionProof, m...)
	router.GET(baseURL+"/v2/blocks/:round/txids", wrapper.GetBlockTxids, m...)
	router.GET(baseURL+"/v2/deltas/txn/group/:id", wrapper.GetLedgerStateDeltaForTransactionGroup, m...)
	router.GET(baseURL+"/v2/deltas/:round", wrapper.GetLedgerStateDelta, m...)
	router.GET(baseURL+"/v2/deltas/:round/txn/group", wrapper.GetTransactionGroupLedgerStateDeltasForRound, m...)
	router.GET(baseURL+"/v2/devmode/blocks/offset", wrapper.GetBlockTimeStampOffset, m...)
	router.POST(baseURL+"/v2/devmode/blocks/offset/:offset", wrapper.SetBlockTimeStampOffset, m...)
	router.GET(baseURL+"/v2/ledger/supply", wrapper.GetSupply, m...)
	router.GET(baseURL+"/v2/stateproofs/:round", wrapper.GetStateProof, m...)
	router.GET(baseURL+"/v2/status", wrapper.GetStatus, m...)
	router.GET(baseURL+"/v2/status/wait-for-block-after/:round", wrapper.WaitForBlock, m...)
	router.POST(baseURL+"/v2/teal/compile", wrapper.TealCompile, m...)
	router.POST(baseURL+"/v2/teal/disassemble", wrapper.TealDisassemble, m...)
	router.POST(baseURL+"/v2/teal/dryrun", wrapper.TealDryrun, m...)
	router.GET(baseURL+"/v2/transactions/params", wrapper.TransactionParams, m...)
	router.POST(baseURL+"/v2/transactions/simulate", wrapper.SimulateTransaction, m...)

}

// Base64 encoded, gzipped, json marshaled Swagger object
var swaggerSpec = []string{

	"H4sIAAAAAAAC/+y9/XfbtrIo+q9g6d618nFFOUnTnt281XWfm4/Wp2mSFbvd95ymr4VISMI2BXADoCy1",
	"L//7XZgBSJAEJcqW7aT1T4lFEhgMBjOD+fxzlMplIQUTRo+e/TkqqKJLZpiCv2iaylKYhGf2r4zpVPHC",
	"cClGz/wzoo3iYj4aj7j9taBmMRqPBF2y+h37/Xik2L9Lrlg2emZUycYjnS7YktqBzaawb1cjrZO5TNwQ",
	"xzjEyYvRxy0PaJYppnUXyrci3xAu0rzMGDGKCk1T+0iTC24WxCy4Ju5jwgWRghE5I2bReJnMOMszPfGL",
	"/HfJ1CZYpZu8f0kfaxATJXPWhfO5XE65YB4qVgFVbQgxkmRsBi8tqCF2Bgurf9FIohlV6YLMpNoBKgIR",
	"wstEuRw9+2WkmciYgt1KGV/Bf2eKsT9YYqiaMzP6dRxb3MwwlRi+jCztxGFfMV3mRhN4F9Y45ysmiP1q",
	"Qn4stSFTRqgg7189J1988cXXdiFLagzLHJH1rqqePVwTfj56NsqoYf5xl9ZoPpeKiiyp3n//6jnMf+oW",
	"OPQtqjWLH5Zj+4ScvOhbgP8wQkJcGDaHfWhQv/0icijqn6dsJhUbuCf48kE3JZz/VnclpSZdFJILE9kX",
	"Ak8JPo7ysODzbTysAqDxfmExpeygvzxKvv71z8fjx48+/o9fjpP/dn9++cXHgct/Xo27AwPRF9NSKSbS",
	"TTJXjMJpWVDRxcd7Rw96Ics8Iwu6gs2nS2D17ltiv0XWuaJ5aemEp0oe53OpCXVklLEZLXND/MSkFLll",
	"U3Y0R+2Ea1IoueIZy8aW+14seLogKdU4BLxHLnieWxosNcv6aC2+ui2H6WOIEgvXpfABC/p0kVGvawcm",
	"2Bq4QZLmUrPEyB3iyUscKjISCpRaVun9hBU5WzACk9sHKGwBd8LSdJ5viIF9zQjVhBIvmsaEz8hGluQC",
	"Nifn5/C9W43F2pJYpMHmNOSoPbx96OsgI4K8qZQ5owKQ589dF2VixuelYppcLJhZOJmnmC6k0IzI6b9Y",
	"auy2/+fp2zdEKvIj05rO2TuanhMmUpmxbEJOZkRIE5CGoyXAof2ybx0OrpiQ/5eWliaWel7Q9Dwu0XO+",
	"5JFV/UjXfFkuiSiXU6bslnoRYiRRzJRK9AGEI+4gxSVddyc9U6VIYf/raRu6nKU2roucbgBhS7r+5tHY",
	"gaMJzXNSMJFxMSdmLXr1ODv3bvASJUuRDVBzjN3TQLDqgqV8xllGqlG2QOKm2QUPF/vBUytfATh+kF5w",
	"qll2gCPYOkIz9nTbJ6SgcxaQzIT85JgbPDXynImK0Ml0A48KxVZclrr6qAdGmHq7Bi6kYUmh2IxHaOzU",
	"ocMyGHzHceCl04FSKQzlgmWWOQPQ0jBkVr0wBRNuv+90pfiUavbV0z4ZXz8duPsz2d71rTs+aLfhpQSP",
	"ZER02qfuwMY1q8b3A+6H4dyazxP8ubORfH5mpc2M5yCJ/mX3z6Oh1MAEGojwsknzuaCmVOzZB/HQ/kUS",
	"cmqoyKjK7C9L/OnHMjf8lM/tTzn+9FrOeXrK5z3IrGCNXrjgsyX+Y8eLs2Ozjt4rXkt5XhbhgtLGxXW6",
	"IScv+jYZx9yXMI+r22548Thb+8vIvl+YdbWRPUD24q6g9sVztlHMQkvTGfyzngE90Zn6w/5TFLn92hSz",
	"GGotHTuRDOYDZ1Y4Loqcp9Qi8b17bJ9aJsDwIkHrN45AoD77MwCxULJgynAclBZFksuU5ok21MBI/1Ox",
	"2ejZ6H8c1faXI/xcHwWTv7ZfncJHVmVFNSihRbHHGO+s6qO3MAvLoOERsAlke6A0cYGbaEmJWxacsxUV",
	"ZlJfWRr8oDrAv7iZanyjtoP4bl3BehFO8MUp06gB44v3NAlQTwCtBNAKCuk8l9Pqh/vHRVFjEJ4fFwXi",
	"A7RHxkExY2uujX4Ay6f1SQrnOXkxId+FY4MqLkW+scIBVQ0rG2ZOajkpVtmW3BrqEe9pAtsp1cRujUeD",
	"VfMPQXFwrVjI3Go9O2nFvvy9ezckM/v7oI8/DxILcdtPXHDRcpjDOw78Elxu7rcop0s4ztwzIcftby9H",
	"NnaULQSjT2osHpp44Bdu2FLvpIQAooCa3PZQpehm5JTEBJS9Lpn8pBlSSEHnXAC0Y3t9EmRJz3E/JODd",
	"EgLT1b0IaQk1yMqE6nROh/pJx87yGVBrbGO9Jmo11ZxrA/dqeJksWA6KMxWeoENSuRRlDNjwLYuoYL5Q",
	"tEBadk9Q7eIC7vP4EsJ6RcE7UCZGYQ7YfbDRANWl2fJO1hmFBLhGC4Zvc5mef0/14gAnfOrH6tI+TEMW",
	"jGZMkQXVi8jBadF2PdoQ+rYvAs2SaTDVpFriaznXB1hiLvdhXUXxnOa5nbrLslqrhYEHHeQ8J/ZlwpYc",
	"DObu4ogWdrx/kZc0XVi1gKQ0z8e1qUgWSc5WLLeXdi4EU2NiFtTUhx9G9vcaOEeaWWZnGAlW48xMYGJT",
	"lS1CMbKkIIGW9jZT5M1vKg6q6ZK1tCCQiLIEK0Jw0Th54VfHVkwAT6qGBvCrNYK1Jhx8Yud2j2BmIXFx",
	"aAE03n1X4a/iFw2g7du1PBX1FFJlaLM29jeuSCoVDoES3k1u/8Ooqj9G6rxfKJa4IRRdMaVpblfXWtSD",
	"inwPdTp3nMyMGhqcTEeF8QsYcg74DtQ7piJWmrfwH5oT+9hqMZaSaurhoIzIwJ2aoWC2qMKZ7Atgb5Vk",
	"iaZMUtD0fC8on9eTx9nMoJP3Eq2nbgvdIqodOlvzTB9qm2Cwvr1qnhC0XXl21NFFtjKdYK4hCDiTBUH2",
	"0QIBOQWMhgiR64OLtW/lOgbTt3LdEWlyzQ6yE3acwcz+W7l+4SCTajfmYewhSLcLFHTJNEg3ETJOO0vt",
	"lzueSnU5baIlYASpvY2E2lEDZWrcQhK8WhaJO5sRjwW+0BqoDvDYrgS0h49hrIGFU0OvAQvajnoILDQH",
	"OjQW5LLgOTsA6S+iStyUavbFE3L6/fGXj5/89uTLryxJFkrOFV2S6cYwTe47sxzRZpOzB9HbEWgX8dG/",
	"eup9VM1xY+NoWaqULWnRHQp9X3j7xdeIfa+LtSaaYdUVgIM4IrOiDdFO0K1rQXvBpuX8lBljb7rvlJwd",
	"nBt2ZohBBy+9K5RVLHTTT+i0paPMvnLE1kbRowLeZCLDOAO7Dq7tHXA5PQhR9W18Vs+SEYfRjO08FPtu",
	"Uz3NJtwqtVHlIcwbTCmpoiK4UNLIVOaJ1fO4jBgo3rk3iHvDb1fR/h2hJRdUEzs3eC9LkfXYIcxaDJdf",
	"OPTZWtS42SrBcL2R1bl5h+xLE/n1LaRgKjFrQYA6G+aRmZJLQkkGH4Ku8R0zqH/xJTs1dFm8nc0OY+2U",
	"MFDEjsOXTNuZCL5htR/NUikwmG+HycaNOgQ9bcR4L5PpB8Bh5HQjUnCVHeLY9luzllyA315vRBqYtiyM",
	"OcvmDbK8ugmrDx041T0dAcei4zU8Blv9C5Yb+kqqs1p9/U7Jsjg4e27POXQ51C3GeQMy+603A3Mxz5sB",
	"pHML+yS2xltZ0PPKiIBrAOiBIl/z+cIE98V3Sl6DTIzOEgMUHqCxKLffdE1Gb2RmmYkp9QFUyXqwmsNZ",
	"ug35Gp3K0hBKhMwYbH6p40pmT8ghxDpBiJYJ9VawT3BNpsxSV0pLu9qyIBCA1JEX9YcJTfGEJoAa3RN+",
	"UcXN4Fs4HYaz5YrRbEOmjAkipy7GwUVfwCIpRE8Zr6Y5FTfCLxpwFUqmTGuWJc4UvRM0/x6KDrMFTwA4",
	"AFzNQrQkM6quDOz5aiec52yTQKyfJvd/+Fk/uAV4jTQ034FYeCeG3rY9rQv1sOm3EVx78pDs0FKHVGvV",
	"W8sgcmZYHwr3wknv/rUh6uzi1dGyYgpCSq6V4v0kVyOgCtRrpverQlsWPRHs7ppuNTy7YYIK6RWr2GA5",
	"1SbZxZbtSw1bgl1BwAljnBgG7lG8XlNtMAyKiwxsmihOYB5UwuwU/QD3XkPsyD/7G0h37NTKQaFLXV1H",
	"dFkUUhmWxdYAHtneud6wdTWXnAVjV3ceI0mp2a6R+7AUjO+Q5W7A8Ac1lf/VeXS7iwOfupXzmygqG0DU",
	"iNgGyKl/K8BuGMXbAwjXNaKRcLhuUU4VOjweaSOLwnILk5Si+q4PTaf49rH5qX63S1zo5EC5nUmmwYHi",
	"3neQXyBmMX57QTVxcHgXO5hzMF6rC7M9jInmImXJNsqHK559KzwCOw9pWcwVzViSsZxuIsEB+Jjg420D",
	"wI7X111pWIKBuPFNrynZxz1uGVrCeDqmPBJ4QlJ7BO1VoCYQ9/WOkTMGY8eYk6Oje9VQMFd0i/x4sGzc",
	"6siIIA1X0tgdd/QAIDuOPgTgHjxUQ18eFfBxUt8921P8F9NugkqP2H+SDdN9S6jH32sBPbZgl+MUnJcW",
	"e29x4Cjb7GVjO/hI35HtMUy/o8rwlBdw1/mBbQ5+9WtPEHWck4wZynOWkeABXgOL8HuCIaTtMS93FRxk",
	"e+uC3zG+RZbjw3SawJ+zDdy532FuQmDqOMRdNjKqlU9UEADURzxbFTx8ha1pavKNVdTMgm3IBVOM6HKK",
	"IQxdf4qRRRIOEPXPbJnReWejvtGt7uJTGCpYXizWDO8E2+E7a10MGuhwd4FCynyAhayDjCgEg2JHSCHt",
	"rnOX/uQTYDwlNYB0TBtc85X4v6cbaIYVkP+SJUmpgCtXaVil00gFigIokHYGq4JVc7rgxBpDLGdLhjdJ",
	"ePLwYXvhDx+6PeeazNiFzxm0L7bR8fAh2HHeSW0ah+sA9lB73E4i4gMcV1bwuVtIm6fsjnhyIw/ZyXet",
	"wStvlz1TWjvCtcu/MgNoncz1kLWHNDIs2gvGHeTLacYHddYN+37Kl2VOzSG8VmxF80SumFI8Yzs5uZuY",
	"S/FyRfO31WeQD8lSS6MpS1LI4hs4Fjuz32Dinx2HC24PMAb9DwWIneBXp/jRjitmHanKl0uWcWpYviGF",
	"YinDfDerOepqqROCkfDpgoo5XBiULOcuuBXHAYZfajTNqFJ0hogqVWYtEjByxwSAC1PzKY9WnWLUXuna",
	"FnK8wFzQaj6X5TpEMgd70PYYRJ1k41HvjdcidVXfeBE5zbzNAcKgoe8F+KknHuhKAdRZ3aeLr3Bb7GGy",
	"m3s9Jvt66BiU3YmDiN/6YV/Qr71u55sDKD04EFGsUEyDiArNVBqfylmYo+1DBTfasGXXko+f/tZz/N73",
	"3helyLlgyVIKtomWJeGC/QgPo8cJxGTPx6Cw9H3bvoM04G+B1ZxnCDVeFb+w2+0T2vZY6VdSHcoligMO",
	"Vu8HeCB3utvdlJf1k9I8j7gWXQZnmwHocRWsyxWhWsuUg852kumxiwpGb6RL92yi/12Vl3KAs9cet+VD",
	"C4sDgI2Y5QWhJM05WJCl0EaVqfkgKNiogqVGgrj8ZbzfavncvxI3k0asmG6oD4JCAF9luYoGbMxYxEzz",
	"ijFvvNTlfM60ad11Zox9EO4tLkgpuIG5lva4JHheCqYgkmqCby7phswsTRhJ/mBKkmlpmto/JChrw/Pc",
	"OfTsNETOPghqSM6oNuRHLs7WMJx3+vsjK5i5kOq8wkJcus+ZYJrrJB5s9h0+hbh+t/yFi/GHcHd87INO",
	"64oJI7vMRpGU/+/+/372y3Hy3zT541Hy9f86+vXPpx8fPOz8+OTjN9/8/82fvvj4zYP//T9jO+Vhj6XP",
	"OshPXrib8ckLuP4Eofpt2G/M/r/kIokSWRjN0aItch9KRTgCetA0jpkF+yDMWlhCWtGcZ5a3XIYc2hKm",
	"cxbxdLSoprERLWOYX+uel4orcBkSYTIt1nhpLaobnxlPVAenpMs9h/MyKwVupde+MQ/Tx5fJ2bgqRoB1",
	"yp4RyFRfUB/k6f588uVXo3GdYV49H41H7umvEUrm2TpWRyBj69hdMUySuKdJQTeamTj3ANijoXQY2xEO",
	"u2TLKVN6wYub5xTa8Gmcw/mUJWdzWosTgQH+9vyAi3PjPCdydvNwG8VYxgqziNUvaihq8Fa9m4y1wk4K",
	"JVdMjAmfsEnb5pPZ+6IL6ssZnfnAVCXlkNtQdQ6Q0DxVBFgPFzLIsBKjn1Z6gxP++uDXITdwDK72nLGI",
	"3nvfvTwjR45h6ntY0gKHDooQRK7SLnmyEZBkuVmYU/ZBfBAv2AysD1I8+yAyaujRlGqe6qNSM/UtzalI",
	"2WQuyTOfj/mCGvpBdDSt3sKKQdI0KcppzlNyHl5IavLEYlndET58+IXmc/nhw6+d2Izu9cFNFeUvOEFi",
	"FWFZmsSV+kkUu6Aq5vvSVakXGBlreW2bFZVsWaKB1JcScuPHeR4tCt0u+dBdflHkdvkBGWpX0MBuGdFG",
	"VvloVkFxKb12f99IJxgUvfB2lVIzTX5f0uIXLsyvJPlQPnr0BWT21TUQfnci39LkpmCDrSu9JSnaRhVY",
	"OF4rIVY9Keg85mL78OEXw2gBuw/68hJsHHlO4LNG1qFPMICh6gVUKc69G4Bw7J0cDIs7xa98Wcf4EuAR",
	"bGEzAftK+xXkz196u3bk4NPSLBJ7tqOr0pbE/c5U1d7mVsny0Riaz+G26grjTRlJFyw9dxXL2LIwm3Hj",
	"cx/w4xRNzzq4xlp2mGEI1ZTAQTFlpCwy6lRxKjbtsjYaMypg0PfsnG3OZF2MaZ86Ns2yKrrvoAKlBtql",
	"Jdbw2Lox2pvvosp8oqmrTgLJm54snlV04b/pP8io8h7gEMeIolH2ow8RVEUQgcTfg4JLLNSOdyXSjy2P",
	"i5QJw1csYTmf82msDO8/u/4wD6ulSld50EUhVwNqwmfEXuWnKFjd9V5RMWdWPFuRKjXNsapqNGgD7kML",
	"RpWZMmq22vlFWJDCQwdXygvIvAYL39guga3tfnMDFjvBLuytAgxF+I6LXp70x58h4Cy7JDz+8/qmMOm9",
	"6zrURSoOeqlcYbe61rrQvJDOAC58vmRQslRe2H2xUEhXbROLugTypdR0znruLqH3bmA9jIbHDwbZpZFE",
	"dRA5a6saHU0gCjK+nNg1R88ws0/sIYZrZisg08+EDmLnM4Ii2g5h0xwU2CpyFfeeqoYXFasC94EWZy1M",
	"iVoV9GA0MRIexwXV/jhCvVTPZQdpZ9dY9mVbabqTIJYwKIpaFZ7z0rDNQTv3flegzlel86Xowkv/gLJy",
	"9u4F6Qux7ZACVNOM5WyOC8eXPaHUBZPqDbJwvJ3NgLcksbDEwEAdKABuDmZvLg8JQd8IGTxCjIwDsCHw",
	"AQYmb2R4NsV8HyCFK/hE/dggIoK/WTyxDwP1rTIqCytceY+/MfUcwJWiqDWLVkQ1DEO4GBPL5lY0t2zO",
	"3cXrQToV0uBC0aqH5kJvHvRdNLa4plDk77UmVBIus5pQm/VAx1XtLRBP5TrBDOXoXWS6nlp6j+YuQL50",
	"7GBiLbp7mkzlGsK5QLRgrPwOWPrh8GAEtpc110Cv8F2fnoXAbJt2u54bo0INJOMMrRW59Cl6Q6bu0S37",
	"yOV+UF7uUgC0zFB1rwZnlthpPmiqJ11hXku1cV021aeFxY5/3xGK7lIP/rr2sWZBuO/rwn/9xcX8ibqR",
	"Snhdy9JVKhTixwVWHdynQGGbHBpAbMHqu7YeGEVrM9aridcAazFWYplv1ynZRZtmOYNLcNJQTZPzWKSA",
	"vcszkOOn/rPAWAe7R8XmQRBAqNica8Nqp5GPC7oNczyF8slSzvpXZwo1s+t7L2Ul/NFtDh82lnnjK4AI",
	"/BlX2iTgcYsuwb70SoMR6ZV9Na6BNkMUsdkAz+IcF6Y9Z5sk43kZp1c37w8v7LRvKkGjyylIMS4wQGsK",
	"zTGigctbpsbY9q0Lfo0Lfk0Ptt5hp8G+aidWllyac3wm56LFwLaxgwgBxoiju2u9KN3CIIOE8y53DLTR",
	"IKZlss3b0DlMmR97Z5SaT3vvk/w4UnQtQRnAeIagnM9Z5subeX+YCIrI5VLMgy5ORbGtZt6EYOk6qDy3",
	"pWidC8NnfUH4gbqfcJGxdRz68FYAkNeZdVBwDyaZM4HlSuJmoShqwhB/eCOw1d2wL7SdABANgj5rObPr",
	"6GTcpWo7YQNyRjN3J9HMr2/7sexuiEPduC98ulH5dPsRggGBprgJGpt0yxD0MGBaFDxbtxxPOGqvEYzu",
	"ZV3u0baAtbjBdmCgGQQdJbhGKW0Xau0M7Edw5z2ytzKMvXaBxZa+aeoS8LNSgQejEdncrdte3dUGrv2H",
	"n0+NVHTOnBcqQZCuNAQsZx80BFXRNTEcw0kyPpux0PuiL+M5aADXsbFnA0g3QmRxF03JhfnqaYyMdlBP",
	"DeNulMUpJkILfT75s66Xy+v0gSmpEgnB1lzCVRVN1/+BbZKfaV7aSwZXug7PdW6npvDdY9dXyx/YBkbe",
	"GfVqAduxK2B5es+ABmOW/uqRDgpY39ONEv9wvWxs4R47dRzfpQNtjWvK0E/8tZRpNC1oLuUqB6MOkrCw",
	"DNmN03hsgj09rIn4Ninv2gSe7dZBAn0/nIpr38KyK4qqWhS7aPeM0dwTLyxn9HE8ulokQEyauRF34Ppd",
	"JUCjeIZIU/QMNwJ79kQ5LQolVzRPXLxEn/BXcuWEP7zuwytu+CYTp+yzl8ev3znwP45Hac6oSipLQO+q",
	"4L3is1kVtnHYLkqw2rczdKKlKNj8qiJzGGNxAZW9W8amTlOUOn4mOIou5mIWD3jfyftcqA8ucUvIDyuq",
	"iJ/a54kBP80gH7qiPPfORg9tT3A6LG5YZ50oVwgHuHKwUBDzdeWxepMbPnz4ZeXxWLsJMGCmqq8eiaDS",
	"AwzkbSYSP4Q1Ee9gfbCkt1ABM36xEa4+JnA8F2NED66kvZKqIWNcAmQ0Run6tDeryyMee0LCfZvMts42",
	"Iajf/T7/3R76hw/DE/3w4Zj8nrsHAYDw+9T9DteYhw+jTsqotczyIjCGCbpkD6pkjt6NuNl7vmAXw/SA",
	"49WyUmBlPxlWFIrBRh7dFw57F4o7fGbul4zlzP40GWILCDcd0R0CM+QEnfYlPFaxrEvszKmJFO3Qbci1",
	"taQFMsV1fkCfb/cIiXIJftJE5zyNR5CIqbbcR2DMpn2ZwMs9RmE7Ysl7QoBFyYOx7GtDSrO2gAzmiCJT",
	"R6vD1ribSne8S8H/XTLCM3t5mnGmQHy2JKq/g8CoHb03bn5zA6M7rB7+KuaWLW4tb3LaZmvZ6iZ8Ubmu",
	"/EJjvYX2DDQPZ+ww7i1B4o4+vJSDpLlFM9Jz2HVpSId2z+icT7BnjmjHda6TmZJ/sLjABjdVpN6G969y",
	"sCb/wUQsQLDNUirfdd04vp5913YPv4L3bfyVr9x+0VVzs8sI0/ip3m8jL3O31vGq0A7JfXe9MJChmYHQ",
	"w1rgeAUxt9BtxQc5UYHnCYtNNBLZ4qcyTBk9wvHrU+lg7qTZ5vRiSmOtaOyVy8IUbG8jHMtI4j/2G6Cr",
	"Ugo4OwkCxat3ORasK5iqXR3d4reXvD7htIMvTvU9CSgqvCGNMRoi1zIyTCkuqMBm5fY75Ffua83Q02+/",
	"upAKyk3qeORYxlK+jFp9P3z4JUu7UUIZn3Psw11qFjR6dgMRrGkJVOSaZVcFQhxqTmbk0TjoNu92I+Mr",
	"rvk0Z/DGY3xjSjWIy8rrXn1il8eEWWh4/cmA1xelyBTLzEIjYrUk1RUXlLwq/nHKzAVjgjyC9x5/Te5D",
	"5KfmK/bAYtEpQaNnj7+GuB3841FMyro+6ttYdgY828eEx+kYQl9xDMsk3ajxIO+ZYuwP1i8dtpwm/HTI",
	"WYI3nUDZfZaWVNA5i6eBLHfAhN/CbkLUQAsvAp0OTBslN4Sb+PzMUMufelLLLftDMEgql0tuli4+UMul",
	"pae6izNO6oeDfme+LZWHyz+EMNsick2+hWsMXfakhkEw9BtwBYdoHROKNUZzXgfA+7ag5MSXMIY+XVV7",
	"LsSNncsuHXRJiIefkUJxYcDMUppZ8g97LVY0texv0gduMv3qaaTfVbMljNgP8BvHu2KaqVUc9aqH7L3O",
	"4r4l94UUydJylOxBXcohOJW98cDxyM++8NPtQw/VfO0oSS+5lQ1yowGnvhLhiS0DXpEUq/XsRY97r+zG",
	"KbNUcfKgpd2hn96/dlrGUqpYX4L6uDuNQzGjOFtBYl58k+yYV9wLlQ/ahatAf7thVl7lDNQyf5ajF4HA",
	"cbotJ99q8T//WBdYB/8tJjy2bIBSRaydzm53w0GN+1nd2m5ijEuDZz2YG4w2GKWLlZ4gf4zir765jbCk",
	"Nki45w2D4+PfibJ3cNDjHz4EoB8+HDs1+PcnzcfI3h8+jNc5jprc7K81Fq5yI4ZvY3v4rYwYwHxzxCpu",
	"yZVhiBgg+4SUfWCZ4NQNNSbNRnQ3r0UcJo0sHtQaPwUfPvwCTzwe4I82Im6ZWcIG1skQ/Ye92YgzSjJZ",
	"9TwIp6fkW7keSjgtGeSJ5xNAUQ9KBprnYCWdRqPRqICdYSkBjdpRpyyX9pIZ9h4K7fmfD57t4sdbsF3y",
	"PPu59rK2BImiIl1Eg5Gn9sPfUEdviGBkldF2JgsqBMujw+Hd9jd/B47c0v8lh86z5GLgu+1Gt7jc1uJq",
	"wJtgeqD8hBa93OR2ghCrzepcVfWHfC4zAvPUvTNq5tjtGB3r1BlJo4Zhl6Vx4bGQcu7qGs14DtGecb8x",
	"vJkoanrqdEFbdd/GyI4DXc41mhlwdKYI5UsQzJoui5zByVwxRefwqRSs9TlUaoORg8YYRBf2EbwJdTEk",
	"MaUSRM5mwTKYMFyxfDMmBdUaB3lkl8XWMPfo2eNHj6JmL8DOgJUiFv0y39ZLeXwEr+AT18sJOw7sBexu",
	"WD/WFLXPxnYJx7Wu/HfJtInxVHiACbLgJbVSG9tWVi1WJ+Q7KLBkibhRUR/Mlb5WcbNuZ1nkkmZjqKF8",
	"9vL4NcFZ8RvsVI9tM+dgrWuSf9S9MryOqS8g1VOgZ/g42yuG2FVrk1RdLmMlEO0bdR9O3grtATteiJ0J",
	"eYEm1CqOBSchUIlbLVkWNNXESzwQh/2PMTRdgG2yoQH188rh/V49O6s9N0GSY9VkCRi2hdu1fMWOr2Mi",
	"zYKpC64ZJP6zFWtWXaxKkDrbuK/C2FyeKoVASpnsoYxWLZX2RbsHDjVZH1QQhayF+D0tU9j2ed/2t6fw",
	"VTzlo9VLt+X19zX8fCVv8qNzLqRUSMFT6LgQ06ShQtwwN+WA5hRx/6IeuRMaOVzRDr5VyrHDYm9PX88I",
	"HeK6Lv/gqd1UpA7807C16+w2Z0Y7zsaysW+o7RxiXGjmmmZZIgr5pFSRoKZovkUVQLEnGUHxpx4L5yv7",
	"7I2zf0PtjXMuwNLl0ObuZ+iyyjUHz7Qg3JC5ZNqtp5k0pH+x30ygGGTG1r9OXss5T0/5HMbAMDq7bAxN",
	"7Q517ANVXWCoffe5fdeV6K9+boSD4aTHReEm7W+3HlUkzVr0IjgWt+QDSQLkVuOHo20ht60R5iBPLaGx",
	"FUStsQLkcIcwqpbdzVFe2rslUhS8QTBxM1qnl4sIGK+58C7UuIBIoyIBNgbOa893OlXU4N1hEE87YzTv",
	"ybOARGj0wV91qHaDAosSWKOfo38b627jPYyjeqHW+KnYEH8oLHUHysRzmlcR2pHe4aBVOSUKY1pb3cRj",
	"jMMy7sRnZjbQtTNLsPocmn7sK4n6SiFOy2zOTEKzLFZB61t4SuCpz0Vja5aWVa+rKgmxWQq9S21uolQK",
	"XS63zOVfuOJ0QXv+CDVUD1lW7TAU9Jlu4N9Yo6f+nXGx2Xsn//pA7Gy/+v/dZOaY1mtpOtF8ngzHBMiU",
	"q6OjnvpyhF5/f1BK91nBn0TSb4vLhXsU428vreAI6wN34tNRtFTleyEWXMJzX1epKjzZ5EogyjrtzCDq",
	"ATYvsmUt4P2LUcBXNO9JuA99JShf0X/Ql3af9laJoMZVATOUbGVBvZWVMFa45X3puhD74oMxPPhwXgu3",
	"1q0I7ffd/dDw1GGMWM0sej10l3Oi1Ru8rxfN9TXomjRpnst08Kl3wxzbj/qrhsrl0pXTjsSwrZYyC+k8",
	"jIZiLM60MDw3EvIPd8/oM7gYRZ+oi/hoDZvFvqZSRKNbwhgzAT14HhicOpwoMJE6zJJXPId+SP95+vbN",
	"qH8jgx3obqmr4hs1KvdtTJUs1SaPuWzgo+y3nUiRxy4R45HuMXJDrZ74aXBNb6MPXqHRbghIWNJmn7df",
	"Dx28QwBzGStS3y05Mqo3wqM9oIN6Y5GXhHQRo4cfVn0lVnyfH3ge9hNy4Xlj10aCrbgsfVilT27wth78",
	"1ZXwavQN6mFs0ZSh23ZH9jpPz1z/a1ymM7b98DOGVxAmjNp8Aq7Uzqa3m1JFrrFod65fIVXr1EGtVBvq",
	"7pAeWLF2S+7S543gqDM0aKnTvqpDVi+G6PkdfHwcj06yvTThWMuuEY4Sk6ev+XxhoOPH94xmTL3b0dGk",
	"7mICR6yQmtcdjHM7mCshvYDhJkOziCwB87AjS3csH12+YqmBttV11KxibJ/+LHYy782962zSLwuqZCvX",
	"0GRbF5Nur+odynun8FpQPBD7/E6G9+w4rnIjMLXzguq63FOr5sLgzO/ZjKVQVX1robt/LpgIiqiNvcEV",
	"YJkFde94laAIfQH2dyfUAG2rQ7cVnqA/15XB6auDcc429zRpUEO08XCVnXuZwuOAAfRt+xr0fR4iFw7K",
	"dUUZgAUf6+9KudfNdXprxgdlGy85lydJKzjqUo5bpvT64yXmsp/uVTYWdP2+Wnjdnuv9hoUX0OJeu8hX",
	"WhUuD81v5KTbeOvCFT6HsoSVU9SXQGfa/+ZrkOIsOT93/UcAK+iCvqAq828cpKgcyiYeB3pWzczrzKxu",
	"9FKklQskOaa5tGpE0pcp2kyGqiKJ72kM+a4LgAFcM6YUyypfZy41S4z0mVzb4NiGCoxrvxQSdG/7NASu",
	"t3T++7o3ALSRpFAqn7pw9nCBRLEltdCpoIJ//5zbkP0cn/siHr6N4E7TcUWvu/tZ+5w8rjtIDKl+Rpy0",
	"3F0c5DJWZC4EU4l3KbfL+YtmRUeo25uVKQro8GBUlvbBtbe2sJKoATbtrrJ1RwiqX5yzzRFegnwjcL+D",
	"IdCoOSHoQcHi1iYf1K6uY3DPDwLe7dahLKTMkx4v5km3B0Gb4s95es6ghmiVu2J1v3vNs2EnIffBeVaF",
	"qVwsNr7mflEwwbIHE0KOBWYL+oiVZnvS1uTintk2/xpmzUpsC+Ks5ZMPIp52BQ071BW5mR9mOw/TzLK6",
	"K06Fg+yocL8WfbF0F9Dco9kFeDL0Vt6NIWlpJQFRIRQxneQUXdHP4aDHDEdQ2yQowgMRCpQ4FzbRuYwF",
	"6V+m/oodKo6pcDIAyDAxpAxIBYUbPIoAF563o6Soe+yLZsoZUayODrls9VBXkBNZs+670bdnrmZp8ruZ",
	"VCycEaJPsVJwldEGZXjhP1NuFFWby9T4bKIqZj3pxfLOOMsqxLJeSB1m2cVhnsuLBJhVUvXJiV1t7Xu6",
	"KYx908b6O3uqpywI2KTaKWobsqAZSaVSLA2/iCdyI1RLqViSS4jfjIWWzIzVu5eQvSlILudEFqnMGPab",
	"ilNQ31ylEBTUJhaEy0VRgLQDZQDwm4COB05pZSo6iBNQtXa2Z/Cbf2a/wZIUdVU4XHSCQQo9qQhMuypw",
	"DkP4chdeIBysZ9S2JcZ584yvgW6Yih35GTGqZGPi3mj32HcHnypGllxrBKWipQue51ARgq+DkIoqIimO",
	"2h619wTipVccguqa1UFQGy6szKtKpoQ84DSsZ0bMQslyvggK1Fdw+iuvKt2FOBzlJ11C3COkhtopnpKl",
	"1MbdNHGkesl1LOn9VAqjZJ43jVKoos+dpf1Huj5OU/NayvMpTc8fwL1WSFOtNBv7wgntqN96JtUqTdgU",
	"wAnQgN5d6hvfgxhYR7SDGWSLxXWM4ruszAGYv+7moLtt7sfdhbXX1WSm8WvMsSDUyCVP42fq8wqj7Q1+",
	"jbGoaDFC7M2K5WPgNTjsobCqoqaARXbRzASNNpc8Jo4RuOgRYDf2v6CBt8clM+YYTY+g7DIXp0Ulaa+u",
	"1wIAIMWaBqZU2NA11MQqriLnWAMFYl/agA6UKhBieDXY7AgHB8qwKwHVCWuuALyPxocxFo3EEOmpXPvn",
	"D+qqkpcC/uN2Km8wj77YzdOatBRGb/oKVD0cIV4if2ug4xnUs5gODXesmm8PlPABAP0BkA0YBoVB7gvG",
	"jPKcZUmsd+tJZaMaBzdtl3PZ7F0Pchk5eUpL3zrVjl0q5ioioYqvmv6vglpSktXrXUuyyNiaYcLWH0xJ",
	"7Ik6DvwvLMeWqS1jgCySnK1YIy7UlWkqQdXkK+a/1dXHJGOsAG9k20YWC3gMZXnLcOLWngQhc0OwG7Wk",
	"IGJxp8gOM0nUqLMWCR4TPfQoWYhWPCtpA396X5WjaQa0RzmCqs4dIfH3yKHT/IQjvPcDHPvvY6qMx8Sv",
	"w/jQ3iwojrptDGhnAHSp+069iMc/hzXIKgcLzJZVjlgk8Zpv6IJeiH6DZJfk6+vWwH3iUgSIfblmKWg1",
	"7r7DMnfj6XFSuHJGQO2CsQxvBfaTiLV9wQQRMmhRe0F1dVWpi6P6H3BieIkLd5u+hFO5DlO++s4SGIzo",
	"VpXE3ouEquj08ub5WzmJWw9i73gxGtHM5fVusX956nbXDnhBlnlGhN1Pq/tDk1cnxRwXH5Np6QfKc3mB",
	"PWfDe+gL5v2gSH3eBeTUcl6JZR+OPXZ1e9umDh4koizphkgF/9hb579LmvPZBvgMgu8/I3pBLQk5xytG",
	"BLjwbjvxdvVq7AHz1hbpp8J186FjBsNt7CgB0FaQ++ZgkizpOQu3AYIdkH+mxjJOXU7BcmFFdms7u1hw",
	"i/e1l5Y0C2/6UAF20+AOvia4/fr/qZNcw6l84cYip6nvMOxanDX5DHQR98RlFmy5PQu6y9c8CVSdyWui",
	"Vb5sRnYJk+merCuWWtTXvqkBdqdjc6dz1ZWWMdDy2+rRsyV/fNBSDr0LQ6NuOkCHfV53gR+2vb0Z/EeL",
	"M/ctYwj4nwreexpdh/BiT+sbwHKjtE4EVrRWT+U6UWymdwWYoLnaXudVXZTHm1i5SBWjGiNuTt66i2dd",
	"e5gLexHGmNDKp1mNkrEZFzWz5KIoTeQeAyWIxSZAWGj0B7T2uND6tASrTK5o/nbFlOJZ38bZ04EtYcMW",
	"M97R4b6NmDAqmdodgOv6DgeJ17UZPXzNCnBsYofhmtpQkVGVha9zQVKmrNwnF3SjL+9RqpwDu3xKNNBm",
	"muVAAu8SkDYCkm+cU/iK/p4KQHpAx88Ahw3EBUecNWjaMbLHP9OF4bNw2CzpOsnlHNKDew6EKzoNHj68",
	"AkoBZnDUz4at28+j+R9s+zTQb8MxIiNh1iFTbD/3b2Er4Rr5k+Bm68lHG2U7XxvjbvFgeqSKeR38j8TS",
	"PY+xFHtXVSlMs/fKpk9V8bTHgk1kPf6hpl28ZxchDMLVZwiN4MPbJTYjLWKJ/GgZSMBioLeE9zNdh7LT",
	"1IVndU1pHVMDImXsyiDsaWlD+7yXSz3ggSlEu7PenLYKmbHj7NNjcnvhg6SQRZIOifnEljyZcxM4SJsw",
	"9tBH4AToWXcVHqOrJlWNgmaNblX7ttns7Za1y9tVpNsu/X1moh6O3nRByBnwMjjCaByDTJ7KmDJu55g1",
	"zWAVkyCUKJaWCszEF3Szu21hTyn40++Pv3z85LcnX35F7Ask43Om63YCrbZ/dVwgF227z81GAnaWZ+Kb",
	"4MuKIOK8/9EnVVWb4s4acltd1wruND3cx74cEQCxTN9uH7hL7RWMU4f2f1rbFVvkwXcshoLr3zMl8zze",
	"zqXSqyIOlNhuBS4UewMpmNJcG8sImx5QbuqIaL0A8yAU9V5hmSgpUubtx44KuOkJuYotpC+gFvgZFG1w",
	"XiPC1kXueBV6eraty93T0EIHSiNExUwZKWThVHs+IzGIIINIBZm1zvAJFvEgRrZithgtGyNEF3keJ72w",
	"4f52bt9sBm3inN5uYkS98IfyEqTZ55/oL0hyGU5Sm/Y/Gf4RqbByMK5RLfc6eEX0frAl5/i4E/dQVRcZ",
	"BFq32kaEPACAnmzbRp5kkCgWVBhX6CUAf4J3ILfVjx9rx/LOtBCAxH+wA7wwfbZ+r8pkcODccqnuHyuk",
	"BEv5tY8SGsvflZHrWW8lSIItckYTY5hGtiS7amGQbq2fV1nMPbeSTrKzktIQezPN80iSNNpx4EyFhGOv",
	"BGpF85vnGq+40uYY8MGy9/2pUWGmbIhkRKW+XAHO13TQ3EFW7OGmFu8gMfufzO5RVM65oZwTviPNwLhD",
	"cwyvnlXeaCbIBYyJQVaPvyJT10WnUCzluu3cv/DKSZUYyhSfuYBWtjY7MlF3rfNnaa5AxjMfiUPeBO6t",
	"ymfvIKyP6C0zlZ6TG6XyGPV1yCKCvxiPCpt77xAXV+y4crl6TkFlxj3rOXXblg9dHpY2sUKn1Ky7zsHS",
	"uoHbiKCu1za0GNngxi0fPvxipkNqiMWbrNjPoYjZQbqt7NVr5RrKlyGO3Bhu3hjF/NxX0BqLNvcU3W/t",
	"R8nznQErjRYKH8ejOVYwgiYBv7mmUDcrSz0EPWXE3NKvUi4GERNZa2PyYKqg4tOAvgjus0gxe8hqTEvF",
	"zQYagnsDGv8tWo/pu6q2h6sNU/nSnOwz8pwJH+9RVwIptZeu30magzxCF5+wUkjmE/ISS/e7g/LNvel/",
	"sC/+8TR79MXj/5j+49GXj1L29MuvHz2iXz+lj7/+4jF78o8vnz5ij2dffT19kj15+mT69MnTr778Ov3i",
	"6ePp06++/o97lg9ZkBFQ37Pj2ej/JMf5XCbH706SMwtsjRNa8B+Y3Ru4K8+gbhkgNYWTyJaU56Nn/qf/",
	"15+wSSqX9fD+15FrvDZaGFPoZ0dHFxcXk/CTozmk/idGluniyM8DJe4a+sq7kypGH+NwYEdr6zFsalX8",
	"yz57//L0jBy/O5nUBDN6Nno0eTR57HrWC1rw0bPRF/ATnJ4F7PsRFM490q4nxlGVq/Vx3HlWFNgxwz6a",
	"V9UB7V8LRnMosGP/WDKjeOofKUazjfu/vqDzOVMTyN7An1ZPjrw2cvSnq5zw0QIWdRtiA4Wgar4PRCzK",
	"ac5TX6OMa7QfY4C9DrtGO8t6qcdkio3FfRCvyCBECasR6LC5/klmEY3fn9TMzvdGB7/y6NkvkXJWPvPD",
	"t+wOg86CcLT/PH37hkhF3LXoHU3Pq6wXn+ZUp3aFWU72y4mn+3+XTG1qunQcczzSVd9/JsqlZT4ufWap",
	"50WzZHOtjcWsRR1k+5ktOQUHoip0UjM8MA0GkNTs27LkR8nXv/755T8+jgYAAlV3NIMOrr/TPP8dzWts",
	"DZG1rcibcV9M1LgunAEf1Ds5BktW9TT4vH6n2engdyEF+71vGxxg0X2geW5flILF9uBX6DEKxAJn9cmj",
	"R55BOfU/gO7IHapglkHNPdC7UI3iSeISA3UZGT56XxW9VbTAw3js44c3ReXfwZcmll89PeBCm6V5r7zc",
	"9nCdRX9LM6Jc/jIs5fFnu5QTgbGgViCh4Pw4Hn35Ge/NibA8h+YE3gwaeHclzU/iXMgL4d+0SlO5XFK1",
	"AZXIVLyw3XGKzjU4VYFF4tkOyq+J+ejXj71i7ygMejz6s1E7KbuSUEQvS6Nf22452cM5YSzMSnM/3D8u",
	"Coj5PK2eHxfFO8stNcQRMA7Sj625NvrBhHwXft1wjiAk6BtpJAX49vi+6X7DVx402o0K7UZVgjv5fbvy",
	"+7hpJOEZE4bPOCjsMWAap2ArTJ1opasK0G6SUFAjad+A6KrwvVMtEtdUceAYeJwO2DF0QGkUnClaongn",
	"o77DXQ/u+tSkAN5KY6rbld4Ma/alditJ0hAZ18i4P3Ol70eaWzoJltvqVXXy4k4Z/Fspg1VJzjlqZ0Vx",
	"APXQZ27seuXoT1dm8hBaI1yPB+mL4c07+DYIvr/f4jgPJuS4/c7l2Ior07lTE7Tv3emAn4IOiHVOd2l/",
	"jo5vVe8L8772ScNqKCz290Eff+aK3t8YWb2anYV0t053CfbZ0dccs742tvqX1NMc0u40tL+1hlYVz76S",
	"jhbGvh65MgSBxnYlA1/bgMdNpYk1C6gHnA3qjUBCPh7hcR3nb1kMBjC70GU99pdH8NTivRI3a9y5WnZV",
	"rO9YeIf9dnPyYpd29RmZggY3OI9IgfjeXDcvjXom3t+MZ2IYb3r66OnNQRDuwhtpyCuQ4tfMIa+VpcXJ",
	"al8Wto0jHU3lehdXEi22VFWos4e2waOqQqTj4Ll9GwNA7kPKb7Nz1oMJ+da9WpcBcSntc2kZlU8Vo2qO",
	"H1leZ5FB7vk/n8H49ybkFSRAGj2GODbIrIAXuTDPHj/54ql7RdELDBNrvzf96umz42++ca8VigsDIQN4",
	"z+m8ro16tmB5Lt0HTkZ0x7UPnv2f//rvyWRybydbletvN2+wh/anwlvHsZKHFQH07dZnvkmx27rrbb4T",
	"dTfi4f9WrqNSQK7vpNCtSSGL/b+E9Jk2ychdRCtjZ6MZzwGlER6TfeTR2MkfyOKohMmEvJGuL1qZU4UF",
	"YqCGribzkioqDGPZxFMqpOBprGSX5hxqByiimVoxlWhe1aouFauqmBSKrSD8vq7y2oBgN6OHIN1Plsn/",
	"SNdB3vy0EtNGuiWD2XNJ1wQafRiimRljCbU1+eYb8mhc317y3A6QVIiJMdclXY9u0OpXEdvQukAvHHak",
	"2h37C2MPsSDV2k9VYLK+avzdOfdnq7kjubuNPRDn3NvxUzt2QjuC6z621YKAip2Bcsi6LIp8UxfCtVqe",
	"V6HiLM7OMNQ48An7CHaapqOX0DZ67w7xnRHgSqykTVB7sg1IaNVHf8K9POQZnXMLCXl/L3dp4DtScumd",
	"R5LMmEkXLhe4hfoIe1IuH7GfNy254EsL5aPxAL2rqrNRtVlptG6+D/HmUCkH6uNtoOCWgoJ2fAaFOR74",
	"drSuGjUUPKgDsOOoxeETO2lMDas7ChxYDQOy61ZsDpecUSwZMKQhWpBXCh5HpiKn7i38h+Yh0qoWJb7+",
	"IqC/wqBrEYvWAmwa7XIUfI5zQRstb3dD+byevKtBAloO4bC9Q/B+CO5w85euPgOeQreIv0IWg7/7JuSN",
	"rFPo8cr3l/SVXqcqct0LeiMFw6AAq6ojLd75fys9qRaTvnYKXrjqhmCX1ZmOfM2hrYrT9/alHcrTEHUD",
	"6hddu85xDSL8+2hlpoaUsWub7CwMUY82hDnbF7GDQ6gkTW7z2nUr/PQTvIvdBse6GRYDh9TzGacWiMMy",
	"HShHhMR8VPjaUX0c6LV9OdDLsELTYG5kZBU3xyJ1kMiU5VLM9afJirZRRxwvESrBqlvYCKaz/snf8Ow+",
	"d11ajMuTdrWvNBcpI1ouGVwZrI7uSmgjhP+4OQgNX/pe4yLMx71l7vLloy9ubvpTplY8ZeSMLQupqOL5",
	"hvwkqm4sV+F2mlC356H5OsIcuAD3WLNGWhoWdLoCE3S9/uNmbmdor6s8atSrZGmYwvp+raZbvMOkYwZs",
	"YBiv7dQH0OdyOf/c1DmP9aFlqZ/TPAd07fKKwcCDwqrzHPeTLbkxdZOLULqSlzRdVHs7rs2RVStCXw19",
	"3KqfCSO7vnRYm0Azu8+GkWA1gbWCKWyqbqDTlDOtLcvc8CJvflP16oTeRZG4KaTNsO3ByQu/OvQmy1k9",
	"dJt+fe10N/jEzu0ewcxC4uKoYsC7Q/NfaKadNIDGLl4+XjzoveQ6SLnSjFy1amXWwT5FwaiqP0bKv18o",
	"lrghFF0xpSkc1taiHtyp6p+Gqr52xZk/EUU96lS9Kq+/vChqhH3/adY8+7hbLw/qG++pknMRqOQhu8Cz",
	"dnldfLf7od0L/eRFmFkjqwpgXkHoAcWiaM/ksv81GuizgaoycubuYaVAQH1RTqexurQXORtXgaX2Qipn",
	"z8gH8ZDoBfU1o92fT778qs81QvXC1dLr+p3qgexjHGaI8+mzdqUdVuOo8Pvspnd7v00cj3i2jhTGFxlb",
	"B71Ymr2anTy8p52vLt5dpIjXh64upuGwS2bFlF7w4uZrEGvDp/Ei7N4SV/X8PxHfVgZZLJRrtYbiNmrP",
	"jkdGMZaxwix2lqSGt+rdZK44NdeujRAWDh4TPmETrKtbt3vL5swJJkpyRmdV3zYphyQeBnzGEpqnigDr",
	"4UKGaNJR+gGdF4jy5u2kdYIeCjqPvLZSfKtKmLktJSxpaWFNtNyeTgYNKMZBqFihpJGpzDHusywKqUx1",
	"uvVkkOWB9Sl6DcNDH+FeSZlb80zvdOmcwVsHsAE0KVt/Ni6dM4+mmE8ntqhLFsqt5xrC0s5kQfCC3wLh",
	"Vvna3aUyxs9a7p/P3ftjeknvwM6glJp0URZHf8J/oFDwxzrJGFqo6COzFkfQNPPoz63hwMBSc6ubKOy+",
	"0jDpdlpwRoN6X8PndaeXV1K125vvDPdtIW3cFvrYABTihiPs8Xpuk3/rS9hW11lrw68eDRIZsXNeqxoa",
	"QdvAinaD/kG+LAY2DY2Q8F300qe1oNqfOOMiIzTYxpatSaqaEVyzT/G6F30bLsqbD9n68jM+Z2+kISfL",
	"ImdLJgzLrhapT9oczkuPreJ2P8XAif5uOH9X5ocS3ychVbrITgG/x70nKLvE/HRUQR0kK6tvKGr+TpJ/",
	"UpL8eeVtDcnwTi5/PnJZ+dSpOxH86YvgLz7b1VxjDNNAkXwJ53BTDNc38T0FckcZcDasluFgm18Zrt7t",
	"VepXUvkueXdS/DN1iuJODg7EGmKh2WWJdVMeIuvsk4J+mJ0hzyOWhr6DOq5ivTgUmJQph3ZCJ5keu6Ay",
	"NE64U3yn+HzSik+w13d6z53p4TMzPfRoOe7Wn+dDFI19FaDVUmbMO1blbOYKOvdpP80WlpY8taHLguCX",
	"k9447DO+ZKf2zbc4xUFFbA12Sy1qgWeRpVkqRaYHRHG4US8rh8DR1A/AjXs2qx3wsLhST5NLk+z7oF5k",
	"hxJIG/kaWo/6wtYOGRlbEUuAkwOQ7dGf+C+Y0wqpI6s59QTc2Zj7bluwUjeO2wCQvAMlFEt++6/kjDzC",
	"gt2lgCT3usc4FRkxamMVVV+fUDGak7SR3FrB0T05p70nZ+dVoLO6njXF7wKyPqGHjGBoFRb44cYPwHMq",
	"HMl3EWQkoUSwOTV8xbzLf3JXPevS0szVrtrCAMeEZhmexnoT2IqpDdHlVFtdRzRzlO7p5nnZg2GwdcEU",
	"tyKa5rUDHq8JR1gaa1sc0Sm+cUWh1eJFWJBLNaMWvWR15brkjPzIUyWP87msYuH1Rhu27HTwdp/+1tNg",
	"wRsSujGrUuRcsGQpRayv9Ft4+iM8jH0N5cX6Pj6zD/u+bcnbJvwtsJrzDJHJV8XvJ3L6rxTo0lqtYoVU",
	"9nY7xXpESP97HiV/aDYi7Z6kjUgDp5Z7GAwUtpNu/Hzk0xEazaWjb/7Z+NOV0HNv6kVpMnkRzAI2AAxn",
	"HFI9C5TvPZM8aptbM3uS6+u1ul2ntynAQ+xsVU8jPYPrh/1tg/+mSdjOORMSictpXDGlWxe5u0zsv1Qm",
	"9uB934sbY4/8XRyt1IfVXd7IjOG4dTquPfqxri1CZsy18u+qLFVYZDxlyMuv+r1WEkdKy/nCkLIgRsbS",
	"ReoPE5oik03wIhSfMKiTjNclmG5BV4zQXDGa2csrE0RO7aJrSQqLpBoqVfucExf8GVWaArgKJVOmNcsS",
	"36VmF2j+PQxVN1vwBIADwNUsREsyo+rKwJ6vdsJ5zjYJXIY1uf/Dz/ZqfePwotK4HbFYHzeC3nbadRfq",
	"YdNvI7j25CHZYUI3Ui2kyMllkTOXJBdB4V446d2/NkSdXbw6WiCLjF8zxftJrkZAFajXTO9XhbYsEiu/",
	"uyA+x6dnfAmamKBCegtkbLCcapPsYsv2pXAt2q4g4IQxTgwD91xNX1Nt3rt86QzKPKI4gXlQx7ZT9ANs",
	"pSjeLSIj/4wPY2OnVh4KXWriRvA5UCyLrUGw9Za53rB1NRfUTvFjV0lWaAvcNXIfloLxHbKCVj2EmsDv",
	"b4eLLA4sldSZMrqobABRI2IbIKf+rQC7ocO/BxCua0Qj4UDrgZByqjq145E2sigstzBJKarv+tB0im8f",
	"m5/qd7vEhbUwUG5nkukwAc5BfoGY1WDKXVBNHBxkSc9djtzctV7twmwPYwJllpJtlA/GXftWeAR2HtKy",
	"mCuasSRjOY0YXX7CxwQfbxsAdtyTZ7KShiVTqJES3/SaklWvMakaWsJ4OqY8EnhCUnsE7eW5JhD39Y6R",
	"MwZjx5iTo6N71VAwV3SL/HiwbNzqHgOWHcPuuKMHANlx9CEA9+ChGvryqICPk9p80J7iv5h2E1R6xP6T",
	"bJjuW0I9/l4LaBv+QgHWkBQt9t7iwFG22cvGdvCRviMbMzV+lm6BdpTTNSbZNU2twQVwcpnL7dEF5SaZ",
	"SYWKdEJnhqmdofP/pNw7zn36rnRVVwiM4OSmGweYfNgAz3ERBIE4cWFJxFWSsjKMksdkyUVp8IkszRjL",
	"XytG04VV2kMbLI4ELYxdkSbF5lRlObS3nVVyUyos+mRaAh6AjuQjNm/8dt2vpBrUBaBZOpJyQ0pheB50",
	"Qqru7Z+e9fLOInFnkbizSNxZJO4sEncWiTuLxJ1F4s4icWeRuLNI3Fkk/r4Widsqk5R4jcNXbBRSJO1g",
	"yrtYyr9UVflKVHkDCVgnLig3rq+/r1LQb7fYwxBkGM0BBzxn/dHdGHR69vL4NdGyVCkjqYWQC1Lk1F4N",
	"2NpUXaanVLOvnvpUQxSddImt6kG+2he+eEJOvz/2FUcXrjJm8937xxivRrTZ5OyBa4vGRIaaqO+PxoRF",
	"umuPRr1I8N2oXW9unkNkvCYv4e0XbMVyWTCFxQyhnWDX4nPGaP7c4WaHweefdnIXavu7He33ccPo5dC2",
	"pIVX8/1aqSYUMy7JiyAH8/cZzTX7vS8NE8db0mJAJ0JgJt/KbNM6IXbXjmADm2ejrjvKBVWbSJWobgpE",
	"mzSMtOzKEVbXlvXx4NVxu0TbJbNdFBbT1rEMfnz0PiqPloWtNqwzFCbqzlp0MorlmLZroY4qAAcVBoQ0",
	"CdwT8h6/u90ygACRO2I1M/9kohibb1ZMA961lwjHej7XXAKP+OjphbM/toSdlSkj3GjiC+zuFi/j0Tqx",
	"I82ZSBwDSqYy2yQN9jVqSKGMa6o1W053S6KQf8KJq4SPfbJdTt2OGHkRLG4bTw6JZp04BtzDnTeGDebN",
	"FbZgRMeeA4xfN4vuY6MhCMTxp5hRqcX79mV69TSbO8Z3x/iC09jSCLhwBcnbTGRyjYxPbVQp+nneyzVL",
	"SwtceJLvg3UeXHJsbRpO1oxNy/nc3ha6PjpoowPjcSluiRXicodywf0oCAev2vtfNUm9PVyXuwR54/d9",
	"ZcYHsB1UbMCZsSyo2HiXL0s0X5Y54hCbSh+W0WLN8FiJ6dr212fVfudNfoHt1ona5u+IFnJBNcH9ZRkp",
	"ReYynjq1rddieJ0THPpsLWo2vbWmCa43sjo37xAR4Xe5mWquScFUYtYCD1TjMLkOBnhyb7WW9p3YuDmx",
	"gYnqrIfBdqvx1wzhQNJDBXwNxEfQc6lOzGt0YqLNdMLGM7Bo9Ke4hM2Z8M2DBpZ0hm/Gl9TmFuc/ZXlB",
	"KElzDt5VKbRRZWo+CAr+m2Bhk27siTdU9/O+5/6VuAsx4uFzQ30QFIKMKq9OlAfOWMSF8Yoxz2J1OZ8z",
	"bfloSEAzxj4I9xYXpBT2FiZnZMlTJRNMrbXny+ouE3xzSTdkBhVNJPmDKUmmVuoHu462ZG14nrtgFzsN",
	"kbMPghqSM6oN+ZFbDmyH8+UUqpAzZi6kOq+wEO/VM2eCaa6TuGHmO3wK7XDc8r0BEIyZ+LhuY3GzfXA8",
	"7DzrhfzkBcSoQTXmnOuw/2Ib9hvzjS+5SKJEdrZgxIWLtWmL3IcacI6AHjQdR2bBPggr/YwkwPGpuRw5",
	"tD1AnbOIp6NFNY2NaDmK/FoHXf8OwmVIhMncuV3+QimkAR14zyZsPNbXb+39ni6Whshl0Bq0TyDjU9c+",
	"secld4FoGMlaBW7cG2cNkLf6Lz7/spKHv0t6NB7sNtkdsMuumg3yAG9+w8eE5lLMsa6ivV1K2CcuitJA",
	"APh1GvDYiuaJXDGleMb0wJVyKV6uaP62+uzjeMTWLE2MoilL0KIwFGtn9hukU2g0KLjhNE/gVj0UIHaC",
	"X53iRzvkcdBtdLlkGaeG5RtSKJayDAuRcU3q+/wECzSQdEHFHES3kuV8ga/hOBdMsaoxo71Ct4eIF4JZ",
	"iwSL0nVhPHaNmsO6vYymi0jjGBBw9s7uCSpr9KQauAeNkqN9l/TxqFfRtkhd1aFziJwmmxmgRTT0gQA/",
	"9cSHqNF6R/R3RP+5E32spCKgbtayViC+wm25ZrPWdRcQvUEr2a1UF74r0f9XL9HvOZAmlCjauIPEe8NR",
	"TbghF1AWacqIlV8lWOddwz13X4dMu+Cou0qb2rXnSxeUC1dTp8prADjslXi55Mb49rTXYthEZgYWTYsO",
	"lpaKmw3cWmjBfztn9v+/WrVfM7XyF5pS5aNno4UxxbOjo1ymNF9IbY5GH8fhM916+GsF/5/+LlIovrL3",
	"q48AtlR8zoWVuRd0PmeqNiGOnkwejT7+3wAAAP//bWL/qfvDAQA=",
}

// GetSwagger returns the content of the embedded swagger specification file
// or error if failed to decode
func decodeSpec() ([]byte, error) {
	zipped, err := base64.StdEncoding.DecodeString(strings.Join(swaggerSpec, ""))
	if err != nil {
		return nil, fmt.Errorf("error base64 decoding spec: %s", err)
	}
	zr, err := gzip.NewReader(bytes.NewReader(zipped))
	if err != nil {
		return nil, fmt.Errorf("error decompressing spec: %s", err)
	}
	var buf bytes.Buffer
	_, err = buf.ReadFrom(zr)
	if err != nil {
		return nil, fmt.Errorf("error decompressing spec: %s", err)
	}

	return buf.Bytes(), nil
}

var rawSpec = decodeSpecCached()

// a naive cached of a decoded swagger spec
func decodeSpecCached() func() ([]byte, error) {
	data, err := decodeSpec()
	return func() ([]byte, error) {
		return data, err
	}
}

// Constructs a synthetic filesystem for resolving external references when loading openapi specifications.
func PathToRawSpec(pathToFile string) map[string]func() ([]byte, error) {
	var res = make(map[string]func() ([]byte, error))
	if len(pathToFile) > 0 {
		res[pathToFile] = rawSpec
	}

	return res
}

// GetSwagger returns the Swagger specification corresponding to the generated code
// in this file. The external references of Swagger specification are resolved.
// The logic of resolving external references is tightly connected to "import-mapping" feature.
// Externally referenced files must be embedded in the corresponding golang packages.
// Urls can be supported but this task was out of the scope.
func GetSwagger() (swagger *openapi3.T, err error) {
	var resolvePath = PathToRawSpec("")

	loader := openapi3.NewLoader()
	loader.IsExternalRefsAllowed = true
	loader.ReadFromURIFunc = func(loader *openapi3.Loader, url *url.URL) ([]byte, error) {
		var pathToFile = url.String()
		pathToFile = path.Clean(pathToFile)
		getSpec, ok := resolvePath[pathToFile]
		if !ok {
			err1 := fmt.Errorf("path not found: %s", pathToFile)
			return nil, err1
		}
		return getSpec()
	}
	var specData []byte
	specData, err = rawSpec()
	if err != nil {
		return
	}
	swagger, err = loader.LoadFromData(specData)
	if err != nil {
		return
	}
	return
}
