// Package private provides primitives to interact with the openapi HTTP API.
//
// Code generated by github.com/algorand/oapi-codegen DO NOT EDIT.
package private

import (
	"bytes"
	"compress/gzip"
	"encoding/base64"
	"fmt"
	"net/http"
	"net/url"
	"path"
	"strings"

	. "github.com/algorand/go-algorand/daemon/algod/api/server/v2/generated/model"
	"github.com/algorand/oapi-codegen/pkg/runtime"
	"github.com/getkin/kin-openapi/openapi3"
	"github.com/labstack/echo/v4"
)

// ServerInterface represents all server handlers.
type ServerInterface interface {
	// Gets the merged config file.
	// (GET /debug/settings/config)
	GetConfig(ctx echo.Context) error

	// (GET /debug/settings/pprof)
	GetDebugSettingsProf(ctx echo.Context) error

	// (PUT /debug/settings/pprof)
	PutDebugSettingsProf(ctx echo.Context) error
	// Aborts a catchpoint catchup.
	// (DELETE /v2/catchup/{catchpoint})
	AbortCatchup(ctx echo.Context, catchpoint string) error
	// Starts a catchpoint catchup.
	// (POST /v2/catchup/{catchpoint})
	StartCatchup(ctx echo.Context, catchpoint string, params StartCatchupParams) error

	// (POST /v2/shutdown)
	ShutdownNode(ctx echo.Context, params ShutdownNodeParams) error
}

// ServerInterfaceWrapper converts echo contexts to parameters.
type ServerInterfaceWrapper struct {
	Handler ServerInterface
}

// GetConfig converts echo context to params.
func (w *ServerInterfaceWrapper) GetConfig(ctx echo.Context) error {
	var err error

	ctx.Set(Api_keyScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetConfig(ctx)
	return err
}

// GetDebugSettingsProf converts echo context to params.
func (w *ServerInterfaceWrapper) GetDebugSettingsProf(ctx echo.Context) error {
	var err error

	ctx.Set(Api_keyScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetDebugSettingsProf(ctx)
	return err
}

// PutDebugSettingsProf converts echo context to params.
func (w *ServerInterfaceWrapper) PutDebugSettingsProf(ctx echo.Context) error {
	var err error

	ctx.Set(Api_keyScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.PutDebugSettingsProf(ctx)
	return err
}

// AbortCatchup converts echo context to params.
func (w *ServerInterfaceWrapper) AbortCatchup(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "catchpoint" -------------
	var catchpoint string

	err = runtime.BindStyledParameterWithLocation("simple", false, "catchpoint", runtime.ParamLocationPath, ctx.Param("catchpoint"), &catchpoint)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter catchpoint: %s", err))
	}

	ctx.Set(Api_keyScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.AbortCatchup(ctx, catchpoint)
	return err
}

// StartCatchup converts echo context to params.
func (w *ServerInterfaceWrapper) StartCatchup(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "catchpoint" -------------
	var catchpoint string

	err = runtime.BindStyledParameterWithLocation("simple", false, "catchpoint", runtime.ParamLocationPath, ctx.Param("catchpoint"), &catchpoint)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter catchpoint: %s", err))
	}

	ctx.Set(Api_keyScopes, []string{""})

	// Parameter object where we will unmarshal all parameters from the context
	var params StartCatchupParams
	// ------------- Optional query parameter "min" -------------

	err = runtime.BindQueryParameter("form", true, false, "min", ctx.QueryParams(), &params.Min)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter min: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.StartCatchup(ctx, catchpoint, params)
	return err
}

// ShutdownNode converts echo context to params.
func (w *ServerInterfaceWrapper) ShutdownNode(ctx echo.Context) error {
	var err error

	ctx.Set(Api_keyScopes, []string{""})

	// Parameter object where we will unmarshal all parameters from the context
	var params ShutdownNodeParams
	// ------------- Optional query parameter "timeout" -------------

	err = runtime.BindQueryParameter("form", true, false, "timeout", ctx.QueryParams(), &params.Timeout)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter timeout: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.ShutdownNode(ctx, params)
	return err
}

// This is a simple interface which specifies echo.Route addition functions which
// are present on both echo.Echo and echo.Group, since we want to allow using
// either of them for path registration
type EchoRouter interface {
	CONNECT(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	DELETE(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	GET(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	HEAD(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	OPTIONS(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	PATCH(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	POST(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	PUT(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	TRACE(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
}

// RegisterHandlers adds each server route to the EchoRouter.
func RegisterHandlers(router EchoRouter, si ServerInterface, m ...echo.MiddlewareFunc) {
	RegisterHandlersWithBaseURL(router, si, "", m...)
}

// Registers handlers, and prepends BaseURL to the paths, so that the paths
// can be served under a prefix.
func RegisterHandlersWithBaseURL(router EchoRouter, si ServerInterface, baseURL string, m ...echo.MiddlewareFunc) {

	wrapper := ServerInterfaceWrapper{
		Handler: si,
	}

	router.GET(baseURL+"/debug/settings/config", wrapper.GetConfig, m...)
	router.GET(baseURL+"/debug/settings/pprof", wrapper.GetDebugSettingsProf, m...)
	router.PUT(baseURL+"/debug/settings/pprof", wrapper.PutDebugSettingsProf, m...)
	router.DELETE(baseURL+"/v2/catchup/:catchpoint", wrapper.AbortCatchup, m...)
	router.POST(baseURL+"/v2/catchup/:catchpoint", wrapper.StartCatchup, m...)
	router.POST(baseURL+"/v2/shutdown", wrapper.ShutdownNode, m...)

}

// Base64 encoded, gzipped, json marshaled Swagger object
var swaggerSpec = []string{

	"H4sIAAAAAAAC/+x9a3Mbt5LoX0Fxt8qP5UjyI9kT3zq1V/EjRxsndllK9u5avgk40yRxNATmABiKjK//",
	"+y00HoOZwZBDSbGT2v1ki4NHo9Fo9AvdHye5WFWCA9dq8uzjpKKSrkCDxL9onoua64wV5q8CVC5ZpZng",
	"k2f+G1FaMr6YTCfM/FpRvZxMJ5yuoGlj+k8nEv5RMwnF5JmWNUwnKl/CipqB9bYyrcNIm2whMjfEqR3i",
	"7MXk044PtCgkKNWH8g0vt4TxvKwLIFpSrmhuPilyzfSS6CVTxHUmjBPBgYg50ctWYzJnUBbqyC/yHzXI",
	"bbRKN/nwkj41IGZSlNCH87lYzRgHDxUEoMKGEC1IAXNstKSamBkMrL6hFkQBlfmSzIXcA6oFIoYXeL2a",
	"PHs/UcALkLhbObA1/ncuAX6DTFO5AD35ME0tbq5BZpqtEks7c9iXoOpSK4JtcY0LtgZOTK8j8kOtNJkB",
	"oZy8e/WcPHny5BuzkBXVGgpHZIOramaP12S7T55NCqrBf+7TGi0XQlJeZKH9u1fPcf5zt8CxrahSkD4s",
	"p+YLOXsxtADfMUFCjGtY4D60qN/0SByK5ucZzIWEkXtiG9/ppsTzf9FdyanOl5VgXCf2heBXYj8neVjU",
	"fRcPCwC02lcGU9IM+v4k++bDx0fTRyef/un9afZf7s+vnnwaufznYdw9GEg2zGspgefbbCGB4mlZUt7H",
	"xztHD2op6rIgS7rGzacrZPWuLzF9Letc07I2dMJyKU7LhVCEOjIqYE7rUhM/Mal5adiUGc1RO2GKVFKs",
	"WQHF1HDf6yXLlySnyg6B7cg1K0tDg7WCYojW0qvbcZg+xSgxcN0IH7igPy4ymnXtwQRskBtkeSkUZFrs",
	"uZ78jUN5QeILpbmr1GGXFblYAsHJzQd72SLuuKHpstwSjftaEKoIJf5qmhI2J1tRk2vcnJJdYX+3GoO1",
	"FTFIw81p3aPm8A6hr4eMBPJmQpRAOSLPn7s+yvicLWoJilwvQS/dnSdBVYIrIGL2d8i12fZ/P3/zIxGS",
	"/ABK0QW8pfkVAZ6LAoojcjYnXOiINBwtIQ5Nz6F1OLhSl/zflTA0sVKLiuZX6Ru9ZCuWWNUPdMNW9Yrw",
	"ejUDabbUXyFaEAm6lnwIIDviHlJc0U1/0gtZ8xz3v5m2JcsZamOqKukWEbaim7+eTB04itCyJBXwgvEF",
	"0Rs+KMeZufeDl0lR82KEmKPNnkYXq6ogZ3MGBQmj7IDETbMPHsYPg6cRviJw/CCD4IRZ9oDDYZOgGXO6",
	"zRdS0QVEJHNEfnLMDb9qcQU8EDqZbfFTJWHNRK1CpwEYcerdEjgXGrJKwpwlaOzcocMwGNvGceCVk4Fy",
	"wTVlHArDnBFoocEyq0GYogl36zv9W3xGFXz9dOiOb76O3P256O76zh0ftdvYKLNHMnF1mq/uwKYlq1b/",
	"EfphPLdii8z+3NtItrgwt82clXgT/d3sn0dDrZAJtBDh7ybFFpzqWsKzS/7Q/EUycq4pL6gszC8r+9MP",
	"danZOVuYn0r702uxYPk5WwwgM8CaVLiw28r+Y8ZLs2O9SeoVr4W4qqt4QXlLcZ1tydmLoU22Yx5KmKdB",
	"240Vj4uNV0YO7aE3YSMHgBzEXUVNwyvYSjDQ0nyO/2zmSE90Ln8z/1RVaXrrap5CraFjdyWj+cCZFU6r",
	"qmQ5NUh85z6br4YJgFUkaNPiGC/UZx8jECspKpCa2UFpVWWlyGmZKU01jvTPEuaTZ5N/Om7sL8e2uzqO",
	"Jn9tep1jJyOyWjEoo1V1wBhvjeijdjALw6DxE7IJy/ZQaGLcbqIhJWZYcAlryvVRo7K0+EE4wO/dTA2+",
	"rbRj8d1RwQYRTmzDGSgrAduG9xSJUE8QrQTRigLpohSz8MP906pqMIjfT6vK4gOlR2AomMGGKa0e4PJp",
	"c5Liec5eHJHv4rFRFBe83JrLwYoa5m6Yu1vL3WLBtuTW0Ix4TxHcTiGPzNZ4NBgx/y4oDtWKpSiN1LOX",
	"Vkzjv7m2MZmZ30d1/nOQWIzbYeJCRcthzuo4+Euk3NzvUE6fcJy554icdvvejGzMKDsIRp01WLxr4sFf",
	"mIaV2ksJEUQRNbntoVLS7cQJiRkKe30y+UmBpZCKLhhHaKdGfeJkRa/sfgjEuyEEUEEvsrRkJchgQnUy",
	"p0P9Uc/O8ieg1tTGeknUSKolUxr1amxMllCi4Ey5J+iYVG5EGSM2fMciAszXklaWlt0XK3Yxjvq8bWRh",
	"veXFO/JOTMIcsftooxGqG7PlvawzCQlyjQ4M35Yiv/obVcs7OOEzP1af9nEasgRagCRLqpaJg9Oh7Wa0",
	"MfRtGiLNklk01VFY4muxUHewxFIcwrqq6jktSzN1n2V1VosDjzrIZUlMYwIrhgZzpzhaC7vVv8hLmi+N",
	"WEByWpbTxlQkqqyENZRGaWecg5wSvaS6Ofw4stdr8BwpMMxOA4lW48xMaGKTwRYhgawo3kAro81UZbtP",
	"4KCKrqAjBeGNKGq0IkSKxtkLvzpYA0eeFIZG8MMa0VoTD35k5nafcGYu7OKsBVB7913AX+AXLaBN6+Y+",
	"5c0UQhbWZq3Nb0ySXEg7hL3h3eTmP0Bl09lS5/1KQuaGkHQNUtHSrK6zqAeBfO/qdO45mQXVNDqZjgrT",
	"CpjlHNgPxTuQCSvNG/wPLYn5bKQYQ0kN9TAURkTkTi3sxWxQZWcyDdDeKsjKmjJJRfOrg6B83kyeZjOj",
	"Tt5Laz11W+gWEXboYsMKdVfbhIMN7VX7hFjblWdHPVlkJ9OJ5hqDgAtREcs+OiBYToGjWYSIzZ1fa9+K",
	"TQqmb8Wmd6WJDdzJTphxRjP7b8XmhYNMyP2Yx7HHIN0skNMVKLzdeMw4zSyNX+50JuTNpInOBcNJ420k",
	"1IwaCVPTDpKwaV1l7mwmPBa2QWegJsBjtxDQHT6FsRYWzjX9HbCgzKh3gYX2QHeNBbGqWAl3QPrLpBA3",
	"owqePCbnfzv96tHjXx5/9bUhyUqKhaQrMttqUOS+M8sRpbclPEhqRyhdpEf/+qn3UbXHTY2jRC1zWNGq",
	"P5T1fVnt1zYjpl0fa20046oDgKM4IpirzaKdWLeuAe0FzOrFOWhtNN23UszvnBv2ZkhBh43eVtIIFqrt",
	"J3TS0nFhmhzDRkt6XGFL4IWNMzDrYMrogKvZnRDV0MYXzSwFcRgtYO+hOHSbmmm28VbJrazvwrwBUgqZ",
	"vIIrKbTIRZkZOY+JhIHirWtBXAu/XVX3dwstuaaKmLnRe1nzYsAOoTd8/P1lh77Y8AY3O28wu97E6ty8",
	"Y/aljfxGC6lAZnrDCVJnyzwyl2JFKCmwI8oa34G28hdbwbmmq+rNfH431k6BAyXsOGwFysxEbAsj/SjI",
	"BbfBfHtMNm7UMejpIsZ7mfQwAA4j51ueo6vsLo7tsDVrxTj67dWW55Fpy8BYQrFokeXtTVhD6LBT3VMJ",
	"cAw6XuNntNW/gFLTV0JeNOLrd1LU1Z2z5+6cY5dD3WKcN6Awfb0ZmPFF2Q4gXRjYj1Jr/CILeh6MCHYN",
	"CD1S5Gu2WOpIX3wrxe9wJyZnSQGKH6yxqDR9+iajH0VhmImu1R2Iks1gDYczdBvzNToTtSaUcFEAbn6t",
	"0kLmQMghxjphiJaO5Va0TzBFZmCoK6e1WW1dEQxA6t0XTceM5vaEZogaNRB+EeJmbCs7nQ1nKyXQYktm",
	"AJyImYtxcNEXuEiK0VPai2lOxE3wixZclRQ5KAVF5kzRe0Hz7ezVoXfgCQFHgMMsRAkyp/LWwF6t98J5",
	"BdsMY/0Uuf/9z+rBF4BXC03LPYjFNin0du1pfajHTb+L4LqTx2RnLXWWao14axhECRqGUHgQTgb3rwtR",
	"bxdvj5Y1SAwp+V0p3k9yOwIKoP7O9H5baOtqIILdqelGwjMbxikXXrBKDVZSpbN9bNk0atkSzAoiTpji",
	"xDjwgOD1miptw6AYL9Cmaa8TnMcKYWaKYYAH1RAz8s9eA+mPnZt7kKtaBXVE1VUlpIYitQb0yA7O9SNs",
	"wlxiHo0ddB4tSK1g38hDWIrGd8hyGjD+QXXwvzqPbn9x6FM39/w2icoWEA0idgFy7ltF2I2jeAcAYapB",
	"tCUcpjqUE0KHpxOlRVUZbqGzmod+Q2g6t61P9U9N2z5xWSeHvbcLAQodKK69g/zaYtbGby+pIg4O72JH",
	"c46N1+rDbA5jphjPIdtF+ajimVbxEdh7SOtqIWkBWQEl3SaCA+xnYj/vGgB3vFF3hYbMBuKmN72hZB/3",
	"uGNogeOplPBI8AvJzRE0qkBDIK73npELwLFTzMnR0b0wFM6V3CI/Hi7bbnViRLwN10KbHXf0gCA7jj4G",
	"4AE8hKFvjgrsnDW6Z3eK/wTlJghyxOGTbEENLaEZ/6AFDNiC3Run6Lx02HuHAyfZ5iAb28NHho7sgGH6",
	"LZWa5axCXed72N656tedIOk4JwVoykooSPTBqoFV3J/YENLumDdTBUfZ3vrg94xvieX4MJ028FewRZ37",
	"rX2bEJk67kKXTYxq7ifKCQLqI56NCB43gQ3Ndbk1gppewpZcgwSi6pkNYej7U7SosniApH9mx4zOO5v0",
	"je50F5/jUNHyUrFmVifYDd9FRzFoocPpApUQ5QgLWQ8ZSQhGxY6QSphdZ+75k38A4ympBaRj2uiaD9f/",
	"PdVCM66A/KeoSU45qly1hiDTCImCAgqQZgYjgoU5XXBigyEoYQVWk8QvDx92F/7wodtzpsgcrv2bQdOw",
	"i46HD9GO81Yo3Tpcd2APNcftLHF9oOPKXHxOC+nylP0RT27kMTv5tjN48HaZM6WUI1yz/FszgM7J3IxZ",
	"e0wj46K9cNxRvpx2fFBv3bjv52xVl1TfhdcK1rTMxBqkZAXs5eRuYib4yzUt34Ru+B4SckOjOWQ5vuIb",
	"ORZcmD724Z8Zh3FmDrAN+h8LEJzZXue20x4Vs4lUZasVFIxqKLekkpCDfe9mJEcVlnpEbCR8vqR8gQqD",
	"FPXCBbfacZDh18qaZmTNe0MkhSq94RkauVMXgAtT808ejTgF1Kh0XQu5VWCuaZjPvXIdczNHe9D1GCSd",
	"ZNPJoMZrkLpuNF6LnPa7zRGXQUvei/DTTDzSlYKoM7JPH1/xtpjDZDb39zHZN0OnoOxPHEX8Nh+Hgn6N",
	"ul1u70DosQMRCZUEhVdUbKZS9quYx2+0fajgVmlY9S35tusvA8fv3aC+KHjJOGQrwWGbTEvCOPyAH5PH",
	"Ca/Jgc4osAz17eogLfg7YLXnGUONt8Uv7nb3hHY9VuqVkHflErUDjhbvR3gg97rb3ZQ39ZPSsky4Ft0L",
	"zi4DUNMQrMskoUqJnKHMdlaoqYsKtt5I99yzjf634V3KHZy97rgdH1qcHABtxFBWhJK8ZGhBFlxpWef6",
	"klO0UUVLTQRxeWV82Gr53DdJm0kTVkw31CWnGMAXLFfJgI05JMw0rwC88VLViwUo3dF15gCX3LVinNSc",
	"aZxrZY5LZs9LBRIjqY5syxXdkrmhCS3IbyAFmdW6Lf3jA2WlWVk6h56Zhoj5JaealECVJj8wfrHB4bzT",
	"3x9ZDvpayKuAhfTtvgAOiqksHWz2nf2Kcf1u+UsX44/h7vazDzptMiZMzDJbSVL+7/1/e/b+NPsvmv12",
	"kn3zL8cfPj799OBh78fHn/761//X/unJp78++Ld/Tu2Uhz31fNZBfvbCacZnL1D9iUL1u7B/Nvv/ivEs",
	"SWRxNEeHtsh9TBXhCOhB2ziml3DJ9YYbQlrTkhWGt9yEHLo3TO8s2tPRoZrWRnSMYX6tByoVt+AyJMFk",
	"OqzxxlJUPz4z/VAdnZLu7Tmel3nN7VZ66du+w/TxZWI+DckIbJ6yZwRfqi+pD/J0fz7+6uvJtHlhHr5P",
	"phP39UOCklmxSeURKGCT0hXjRxL3FKnoVoFOcw+EPRlKZ2M74mFXsJqBVEtWfX5OoTSbpTmcf7LkbE4b",
	"fsZtgL85P+ji3DrPiZh/fri1BCig0stU/qKWoIatmt0E6ISdVFKsgU8JO4Kjrs2nMPqiC+orgc59YKoU",
	"Yow2FM6BJTRPFRHW44WMMqyk6KfzvMFd/urO1SE3cAqu7pypiN573728IMeOYap7NqWFHTpKQpBQpd3j",
	"yVZAkuFm8ZuyS37JX8AcrQ+CP7vkBdX0eEYVy9VxrUB+S0vKczhaCPLMv8d8QTW95D1JazCxYvRomlT1",
	"rGQ5uYoVkoY8bbKs/giXl+9puRCXlx96sRl99cFNleQvdoLMCMKi1plL9ZNJuKYy5ftSIdULjmxzee2a",
	"1QrZorYGUp9KyI2f5nm0qlQ35UN/+VVVmuVHZKhcQgOzZURpEd6jGQHFPek1+/ujcBeDpNferlIrUOTX",
	"Fa3eM64/kOyyPjl5gi/7mhwIv7or39DktoLR1pXBlBRdowou3KqVGKueVXSRcrFdXr7XQCvcfZSXV2jj",
	"KEuC3VqvDv0DAxyqWUB44jy4ARaOgx8H4+LObS+f1jG9BPyEW9h+gH2r/Yrez994u/a8wae1XmbmbCdX",
	"pQyJ+50J2d4WRsjy0RiKLVBbdYnxZkDyJeRXLmMZrCq9nba6+4AfJ2h61sGUzWVnXxhiNiV0UMyA1FVB",
	"nShO+bab1kbZFxU46Du4gu2FaJIxHZLHpp1WRQ0dVKTUSLo0xBofWzdGd/NdVJl/aOqyk+DjTU8WzwJd",
	"+D7DB9mKvHdwiFNE0Ur7MYQIKhOIsMQ/gIIbLNSMdyvSTy2P8Ry4ZmvIoGQLNkul4f2Pvj/Mw2qo0mUe",
	"dFHIYUBF2JwYVX5mL1an3kvKF2CuZ3OlCkVLm1U1GbSB+tASqNQzoHqnnZ/HCSk8dKhSXuPLa7TwTc0S",
	"YGP2m2m02HG4NloFGopsGxe9fDQcf2YBh+KG8PjujaZwNKjrOtQlMg76WzlgN6i1LjQvpjOEy35fAaYs",
	"FddmXwwUwmXbtEldovulVnQBA7pL7L0bmQ+j5fHDQfZJJEkZRMy7okZPEkiCbBtnZs3JMwzmiznEqGZ2",
	"AjL9TNZB7HxGmETbIWxWogAbIlft3lPZ8qLarMBDoKVZC0jeiIIejDZG4uO4pMofR8yX6rnsKOnsd0z7",
	"sis13VkUSxglRQ2J5/xt2OWgPb3fJajzWel8KrpY6R+RVs7oXvh8IbUdgqNoWkAJC7tw29gTSpMwqdkg",
	"A8eb+Rx5S5YKS4wM1JEA4OYAo7k8JMT6RsjoEVJkHIGNgQ84MPlRxGeTLw4BkruET9SPjVdE9DekH/bZ",
	"QH0jjIrKXK5swN+Yew7gUlE0kkUnohqHIYxPiWFza1oaNud08WaQXoY0VCg6+dBc6M2DIUVjh2vKXvkH",
	"rckKCTdZTSzNeqDTovYOiGdik9kXykldZLaZGXpPvl3A99Kpg2lz0d1TZCY2GM6FV4uNld8DyzAcHozI",
	"9rJhCukV+w3JWRaYXdPulnNTVKiQZJyhNZDLkKA3ZuoB2XKIXO5H6eVuBEDHDNXUanBmib3mg7Z40r/M",
	"m1tt2qRN9c/CUsd/6Agld2kAf337WDsh3N+axH/DycX8ifosmfD6lqXbZCi0nSubdfCQBIVdcmgBsQOr",
	"b7tyYBKt7VivNl4jrKVYiWG+fadkH20KSkAlOGuJptlVKlLA6PKA9/i57xYZ63D3KN8+iAIIJSyY0tA4",
	"jXxc0Jcwx1NMnyzEfHh1upJzs753QoTL37rNsWNrmZ99BRiBP2dS6Qw9bsklmEavFBqRXpmmaQm0HaJo",
	"iw2wIs1xcdor2GYFK+s0vbp5v39hpv0xXDSqnuEtxrgN0JphcYxk4PKOqW1s+84Fv7YLfk3vbL3jToNp",
	"aiaWhlzac/xJzkWHge1iBwkCTBFHf9cGUbqDQUYPzvvcMZJGo5iWo13eht5hKvzYe6PU/LP3oZvfjpRc",
	"S5QGMP1CUCwWUPj0Zt4fxqMkcqXgi6iKU1Xtypl3RGzqOsw8tyNpnQvDh6Eg/EjczxgvYJOGPtYKEPLm",
	"ZR0m3MNJFsBtupK0WSiJmjjEH1tEtrrP7AvtPgBIBkFfdJzZTXSy3aWwnbgBJdDC6SQK/Pp2H8v+hjjU",
	"TYfCp1uZT3cfIRwQaYrpqLBJPw3BAAOmVcWKTcfxZEcdNILRg6zLA9IWshY32B4MtIOgkwTXSqXtQq2d",
	"gf0Ydd5jo5XZ2GsXWGzom+buAX5RS/RgtCKb+3nbg642cu3f/3yuhaQLcF6ozIJ0qyFwOYegIcqKrohm",
	"NpykYPM5xN4XdRPPQQu4no29GEG6CSJLu2hqxvXXT1NktId6Ghj3oyxNMQlaGPLJX/S9XF6mj0xJ4UqI",
	"tuYGrqrkc/3vYZv9TMvaKBlMqiY817md2pfvAbu+Xn0PWxx5b9SrAWzPrqDl6R0gDaYs/eGTihJY31Ot",
	"FP+oXra28ICdOk3v0h1tjSvKMEz8zS3TKlrQXsptDkYTJGFgGbMb5+nYBHN6oI34Linv2wRW7JdBInk/",
	"noopX8KyfxWFXBT7aPcCaOmJF5cz+TSd3C4SIHWbuRH34PptuECTeMZIU+sZbgX2HIhyWlVSrGmZuXiJ",
	"octfirW7/LG5D6/4zJpMmrIvXp6+fuvA/zSd5CVQmQVLwOCqsF31p1mVLeOw+yqx2b6dodNaiqLNDxmZ",
	"4xiLa8zs3TE29YqiNPEz0VF0MRfzdMD7Xt7nQn3sEneE/EAVIn4an6cN+GkH+dA1ZaV3NnpoB4LTcXHj",
	"KuskuUI8wK2DhaKYr1uPNfi44fLy/drjsXET2ICZkF89EUGlRhjIu0wkfQgbIt7D+nBJbzADZlqx4S4/",
	"JnI8F2NE71xIeyVk645xDyCTMUq/n/RmZHmLx4GQcF8msyuzHREr3/26+NUc+ocP4xP98OGU/Fq6DxGA",
	"+PvM/Y5qzMOHSSdl0lpmeBEawzhdwYPwmGNwIz6vns/hepwccLpeBQFWDJNhoFAbbOTRfe2wdy2Zw2fh",
	"fimgBPPT0RhbQLzpFt0xMGNO0PnQg8cQy7qylTkVEbwbuo1vbQ1p4Z3iKj9Yn2//CPF6hX7STJUsT0eQ",
	"8Jky3IfbmE3TmGDjAaOwGbFmAyHAvGbRWKbZmNSsHSCjOZLIVMnssA3uZsId75qzf9RAWGGUpzkDiddn",
	"50b1OgiO2pN70+Y3N7B1hzXD38bcssOt5U1Ou2wtO92EL4Lryi80VVvowEDzeMYe494RJO7ow99y+Ghu",
	"2Y70HKcujanQ7hmd8wkOzJGsuM5UNpfiN0hf2OimSuTb8P5Vhtbk34CnAgS7LCX4rpvC8c3s+7Z7vAo+",
	"tPG3Vrn9okNxs5tcpulTfdhG3kS3Vums0A7JQ7peHMjQfoEwwFrweEUxt1htxQc5UW7Pk0020XrIlj6V",
	"8ZPRYzt+cyodzL1ntiW9ntFUKRqjchmYou1thWNpQXxnvwEqpFKws5MoUDy0ZTZhXQWycXX0k9/eUH2y",
	"045WnBo9CSkq1pCmNhqiVCIxTM2vKbfFyk0/y69cbwXW0296XQuJ6SZVOnKsgJytklbfy8v3Rd6PEirY",
	"gtk63LWCqNCzG4jYnJZIRa5YdkgQ4lBzNicn06javNuNgq2ZYrMSsMUj22JGFV6XweseupjlAddLhc0f",
	"j2i+rHkhodBLZRGrBAkqLgp5If5xBvoagJMTbPfoG3IfIz8VW8MDg0UnBE2ePfoG43bsHyepW9bVUd/F",
	"sgvk2T4mPE3HGPpqxzBM0o2aDvKeS4DfYPh22HGabNcxZwlbugtl/1laUU4XkH4GstoDk+2Lu4lRAx28",
	"cOt0AKWl2BKm0/ODpoY/DTwtN+zPgkFysVoxvXLxgUqsDD01VZztpH44rHfmy1J5uPxHDLOtEmryF1Bj",
	"6GrgaRgGQ/+IruAYrVNCbY7RkjUB8L4sKDnzKYyxTlcoz2VxY+YyS0dZEuPh56SSjGs0s9R6nv3FqMWS",
	"5ob9HQ2Bm82+fpqod9UuCcMPA/yz412CArlOo14OkL2XWVxfcp8Lnq0MRykeNKkcolM5GA+cjvwcCj/d",
	"PfRYydeMkg2SW90iNxpx6lsRHt8x4C1JMaznIHo8eGWfnTJrmSYPWpsd+undaydlrIRM1SVojruTOCRo",
	"yWCND/PSm2TGvOVeyHLULtwG+i8bZuVFzkgs82c5qQhEjtNdb/KNFP/zD02CdfTf2gePHRugkAlrp7Pb",
	"feagxsOsbl03sY1Lw28DmBuNNhylj5WBIH8bxR/6fImwpC5Ids9bBsdHvxJpdHCU4x8+RKAfPpw6MfjX",
	"x+3Plr0/fJjOc5w0uZlfGyzcRiPGvqk9/FYkDGC+OGKIW3JpGBIGyKFLynwwTHDmhpqSdiG6zy9F3M0z",
	"snRQa/oUXF6+xy8eD/hHFxFfmFniBjaPIYYPe7sQZ5JkivA9Cqen5FuxGUs4nTvIE88fAEUDKBlpnsOV",
	"9AqNJqMC9oalRDRqRp1BKYySGdceiu35fx48m8VPd2C7ZmXxc+Nl7VwkkvJ8mQxGnpmOv1gZvXUFW1aZ",
	"LGeypJxDmRzO6ra/eB04oaX/XYydZ8X4yLbdQrd2uZ3FNYC3wfRA+QkNepkuzQQxVtvZuUL2h3IhCoLz",
	"NLUzGubYrxidqtSZeEaNw65q7cJj8cm5y2s0ZyVGe6b9xtgyk1QP5OnCsuq+jJEZB6ucK2tmsKODJJSt",
	"8GJWdFWVgCdzDZIusKvg0OmOmdpw5KgwBlGV+YQtMS+GILqWnIj5PFoGcM0klNspqahSdpATsyzY4NyT",
	"Z49OTpJmL8TOiJVaLPplvmmW8ugYm9gvrpaTrThwELD7Yf3UUNQhG9snHFe68h81KJ3iqfjBPpBFL6m5",
	"tW3ZylBi9Yh8hwmWDBG3MuqjudLnKm7n7ayrUtBiijmUL16eviZ2VtvHVqq3ZTMXaK1rk3/SvTI+j6lP",
	"IDWQoGf8OLszhphVK52FKpepFIimRVOHk3VCe9COF2PniLywJtQQx2InIZiJW66giIpqWiUeicP8R2ua",
	"L9E22ZKAhnnl+Hqvnp01npvokWMosoQM28DtSr7aiq9TIvQS5DVTgA//YQ3trIshBamzjfssjO3lyZpz",
	"SylHBwijoaTSoWj3wFlJ1gcVJCHrIP5Ay5Qt+3xo+dtz7JV+8tGppdvx+vscfj6TN/nBORdyygVnOVZc",
	"SEnSmCFunJtyRHGKtH9RTdwJTRyuZAXf8OTYYXGwpq9nhA5xfZd/9NVsqqUO+6eGjavstgCtHGeDYuoL",
	"ajuHGOMKXNEsQ0QxnxQyEdSUfG8RAigOJCNM/jRg4Xxlvv3o7N+Ye+OKcbR0ObQ5/cy6rErF0DPNCdNk",
	"IUC59bQfDan3ps8RJoMsYPPh6LVYsPycLXAMG0Znlm1DU/tDnfpAVRcYato+N21div7wcysczE56WlVu",
	"0uFy60lBUm/4IIJTcUs+kCRCbhg/Hm0Hue2MMMf71BAarDFqDSq8h3uEEUp2t0d5aXRLS1HYgtiHm8k8",
	"vYwnwHjNuHehpi+IPHkl4MbgeR3op3JJtdUdRvG0C6DlwDsLfAhtffC3HapboMCgBNfo5xjexqba+ADj",
	"CA0aiZ/yLfGHwlB3JEw8p2WI0E7UDkepyglRNqa1U008xTgM4878y8wWuva+EgzdsejHoTfRUCrEWV0s",
	"QGe0KFIZtL7FrwS/+rdosIG8DrWuwiPEdir0PrW5iXLBVb3aMZdvcMvpovL8CWoIH6EIO4wJfWZb/DdV",
	"6Gl4Z1xs9sGPf30gdnFY/v/+Y+aU1GtoOlNskY3HBN4pt0dHM/XNCL3pf6eU7l8F/yEe/Xa4XLxHKf72",
	"0lwccX7gXny6vVpC+l6MBRf43edVCokn21wJr7JeOTOMesDNS2xZB3jfMAn4mpYDD+5jX4m9X63/YOjZ",
	"fT6YJYJqlwVMU7KTBQ1mVrKxwh3vS9+FOBQfbMOD785r4da6E6HDvrvvW546GyPWMItBD93NnGjNBh/q",
	"RXN1DfomTVqWIh996t0wp6bTcNZQsVq5dNqJGLb1ShQxncfRUABppmXDcxMh/6h7Jr+hYpT8Iq/To7Vs",
	"FoeaSi0a3RKm9iWgB88DY6eOJ4pMpA6z5BUrsR7Sv5+/+XEyvJHRDvS31GXxTRqVhzYmPJbqksdCtPBR",
	"D9tOBC9TSsR0ogaM3JirJ30aXNHb5IdX1mg3BiSb0uaQ1q/HDt4jgIVIJanvpxyZNBvh0R7RQbOxlpfE",
	"dJGih+/XQylWfJ0f/B7XE3LheVNXRgLWTNQ+rNI/bvC2HvurS+HVqhs0wNiST4a+tDty0Hl64epf22U6",
	"Y9v3P9vwCgJcy+0fwJXa2/RuUaqEGmvtzk0TEkqnjiql2hJ3x9TASpVbckqfN4JbmaFFS73yVT2yejFG",
	"zu/h49N0clYcJAmnSnZN7Cip+/Q1Wyw1Vvz4G9AC5Ns9FU2aKiZ4xCqhWFPBuDSDuRTSSxzuaOwrIkPA",
	"LK7I0h/LR5evIddYtrqJmpUAh9RnMZN5b+7/VDYZvgvCYytX0GRXFZN+reo9wnsv8VqUPNDW+T0aX7Pj",
	"NLyNsE87r6lq0j11ci6Mfvk9n0OOWdV3Jrr7jyXwKIna1BtcEZZ5lPeOhQeKWBfgcHdCA9CuPHQ74Ynq",
	"c90anKE8GFewvadIixqShYfD69ybJB5HDFjfts9BP+QhcuGgTAXKQCz4WH+Xyr0prjOYMz5K23jDuTxJ",
	"moujSeW4Y0ovP95gLtP1oLSxKOsP5cLr11wfNiy8wBL3ykW+0pC4PDa/kbN+4a1rl/gc0xIGp6hPgQ7K",
	"/+ZzkNpZSnbl6o8gVqwL+prKwre4k6Ry9m5iaaDnYWbWvMzqRy8lSrngI8e8FEaMyIZeirYfQ4VI4nvK",
	"hnw3CcAQrjlICUXwdZZCQaaFf8m1C45dqLBx7TdCghosn2aBG0yd/66pDYBlJCmmyqcunD1eIJGwogY6",
	"GWXwH55zF7Kf2+8+iYcvI7jXdBzodX89a/8mj6keEmOqnxN3W+5PDnITKzLjHGTmXcrddP68ndER8/YW",
	"dW4v6PhgBEv76NxbO1hJ0gCb91fZ0RGi7BdXsD22SpAvBO53MAbaSk4W9ChhcWeT79SurlJwL+4EvC+b",
	"h7ISoswGvJhn/RoEXYq/YvkVYA7R8HbFyH732mfDTELuo/MshKlcL7c+535VAYfiwREhp9y+FvQRK+3y",
	"pJ3J+T29a/4NzlrUtiyIs5YfXfL0syss2CFvyc38MLt5mALD6m45lR1kT4b7DR+KpbvG4h7tKsBHY7Xy",
	"fgxJRyqJiMpCkZJJzq0r+jke9JThCHObREl4MEKBEufCJqoUqSD9m+RfMUOlMRVPhgBp4GPSgAQo3OBJ",
	"BLjwvD0pRd1nnzRTzImEJjrkptlDXUJOy5rVkEbfnTnM0uZ3cyEhnhGjT22m4PCiDdPw4n9mTEsqtzfJ",
	"8dlGVcp6MojlvXGWIcSyWUgTZtnHYVmK6wyZVRbq5KRUW9NOtS9jX7Sx6WdO9QyigE2qnKC2JUtakFxI",
	"CXncI/2Q20K1EhKyUmD8Ziq0ZK6N3L3C15uclGJBRJWLAmy9qTQFDc1Vc05RbIIoXC6JAks7mAbA9ono",
	"eOSU5k61DuIMRa295Rn85l+YPjYlRZMVzi46s0EKA08RQLkscA5DtnEfXiQcm8+oa0tM8+Y52yDdgEwd",
	"+TnRsoYpcS26NfbdwacSyIopZUEJtHTNyhIzQrBNFFIRIpLSqB0Qe88wXnrNMKiunR3ESsOVufNCypSY",
	"B5zH+cyIXkpRL5ZRgvoAp1d5Ze0U4niUn1SNcY/4NNRM8ZSshNJO07QjNUtuYknv54JrKcqybZSyIvrC",
	"Wdp/oJvTPNevhbia0fzqAeq1XOiw0mLqEyd0o36bmWQnNWH7As6QBtT+VN+2HcbAOqIdzSA7LK5nFN9n",
	"ZY7A/LCfg+63uZ/2F9ZdV5uZptWYU06oFiuWp8/UnyuMdjD4NcWikskIbW1Wmz4Gm+Fhjy+rEDWFLLKP",
	"ZuA0WVzylDhG4KJHkN2Y/6IE3h2XzMExmoGLss9cnBSV5YOyXgcAhNTmNNC1tAVdY0kscBWxsDlQMPal",
	"C+jIWwVDDG8HmxnhzoHScCugemHNAcD71vgwtUkjbYj0TGz89wdNVskbAf9pN5W3mMdQ7OZ5Q1rSRm/6",
	"DFQDHCGdIn9noOMF5rOYjQ13DMW3R97wEQDDAZAtGEaFQR4KxpyyEoosVbv1LNioppGm7d5ctmvX471s",
	"OXlOa1861YxdS3AZkayIL9v+r4oaUhKhed+SzAvYgH2w9RtIYWuiTiP/C5S2ZGrHGCCqrIQ1tOJCXZqm",
	"GkVNtgbfV4XOpACo0BvZtZGlAh7ju7xjOHFrz6KQuTHYTVpSLGLtTpE9ZpKkUWfDM3tM1NijZCBas6Km",
	"LfypQ0WOthnQHOUEqno6Qub1yLHT/GRHeOcHOPX9U6KMx8SHcXzoYBaURt0uBrQ3ALpWQ6eep+Of4xxk",
	"wcGCsxXBEWtJvOEbqqLXfNgg2Sf5Rt0auU9M8AixLzeQo1Tj9B0onMYz4KRw6YyQ2jlAYbUC0yVhbV8C",
	"J1xEJWqvqQqqSpMc1f9gJ8ZGjDtt+gZO5SZM+fY7S3AwojpZEgcVCRno9Obm+S9yEncexMHxUjSiwL3r",
	"3WH/8tTt1A5sIOqyINzsp5H9sciru8UcF5+SWe0HKktxbWvOxnroC/B+UEt93gXkxHIWrmUfjj11eXu7",
	"pg4WPURZ0S0REv8xWuc/alqy+Rb5jAXfdyNqSQ0JOcerjQhw4d1m4t3i1dQD5q0twk9l183GjhkNtzWj",
	"RECbi9wXBxNkRa8g3gYMdrD8M9eGcap6hpYLc2V3trOPBbd4n3tpRYtY08cMsNsWd/A5wU3v/9U8co2n",
	"8okbq5LmvsKwK3HW5jNYRdwTl17Cavcr6D5f8yQQKpM3RCt92oziBibTA1lX6mnRUPmmFti9is29ylW3",
	"WsZIy2+nRs+O9+OjlnLXuzA26qYHdFzndR/4cdnbz4P/ZHLmoWWMAf+PgveBQtcxvLam9WfAciu1TgJW",
	"a62eiU0mYa72BZhYc7VR52WTlMebWBnPJVBlI27O3jjFs8k9zLhRhG1MaPBphlEKmDPeMEvGq1on9BhM",
	"Qcy3EcJioz+idcCFNiQlGGFyTcs3a5CSFUMbZ06HLQkbl5jxjg7XN2HCCHdqfwCmGh0OH143ZvS4mbnA",
	"bRE7G66pNOUFlUXcnHGSgzT3PrmmW3Vzj1JwDuzzKdFImmmnA4m8S0jaFpBy65zCt/T3BADpHTp+Rjhs",
	"MC444ayxph0tBvwzfRj+FA6bFd1kpVjg8+CBA+GSTqOHz6qAgqMZ3Mpn49bt51HsN9g9DdbbcIxIC5x1",
	"zBS7z/0b3EpUI3/iTO88+dZG2X2vbeNu7cH0SOWLJvjfEkv/PKae2LusSvEzey9s+qcqnvYg2kQY8A+1",
	"7eIDu4hhEC4/Q2wEH18usR1pkXrIby0DGVoM1I7wflBNKDvNXXhW35TWMzVYpExdGoQDLW3WPu/vpQHw",
	"0BSi3FlvTxtCZsw4h9SY3J34IKtEleVjYj5tSZ7CuQkcpG0YB+gjcgIMrDuEx6hQpKqV0KxVrerQMpuD",
	"1bL2ebuqfJfSP2QmGuDobReEmCMvwyNsjWP4kicYU6bdN2ZtM1hgEoQSCXkt0Ux8Tbf7yxYOpII//9vp",
	"V48e//L4q6+JaUAKtgDVlBPolP1r4gIZ79p9Pm8kYG95Or0JPq2IRZz3P/pHVWFT3Fmz3FY1uYJ7RQ8P",
	"sS8nLoDUS99+Hbgb7RWO04T2/7G2K7XIO9+xFAp+/z2ToizT5VyCXJVwoKR2K3KhGA2kAqmY0oYRtj2g",
	"TDcR0WqJ5kFM6r22aaIEz8Hbjx0VMD0QcpVayFBALfIzTNrgvEYENlXpeJX19Oxal9PTrIUOhUaMipkB",
	"qUTlRHs2JymI8AWRjF7WOsMnWsSjGNnAbG20bIoQXeR5mvTigvu7uX27GLROc3qziQnxwh/KG5DmkH9i",
	"OCHJTThJY9r/w/CPRIaVO+MaYbm/B69I6gc73hyf9uIeQnaRUaD1s20kyAMBGHht23onGT0UizKMS+sl",
	"QH+CdyB3xY8fGsfy3mchCInvsAe8+Pls0y68ZHDgfOFU3T8EpERL+TBECa3l73uR61lvuEiiLXJGE61B",
	"WbYk+mJh9NxaPQ+vmAe0kt5jZymEJkYzLcvEI2lrx8EzFROOUQnkmpafn2u8YlLpU8QHFO+Gn0bFL2Vj",
	"JFtUqpsl4HxNR80dvYq9u6n5W3yY/R9g9ih5z7mhnBO+d5uhcYeWNrx6HrzRwMk1jmmDrB59TWauik4l",
	"IWeq69y/9sJJeBgKks1dQCts9J6XqPvW+bPQtyDjuY/EIT9G7q3gs3cQNkf0CzOVgZObpPIU9fXIIoG/",
	"FI+Ki3vvuS5uWXHlZvmcosyMB+Zz6pctH7s8m9rEXDq1gv46R9/WLdwmLupmbWOTkY0u3HJ5+V7PxuQQ",
	"SxdZMd0xidmdVFs5qNbK75C+zOLIjeHmTVHMz0MJrW3S5oGk+539qFm5N2ClVULh03SysBmMsEjAL64o",
	"1Oe9Sz0EA2nE3NJvky7GIiax1tbk0VRRxqcRdRFct0Qye3zVmNeS6S0WBPcGNPZLMh/TdyG3h8sNE3xp",
	"7u7T4gq4j/doMoHUyt+u3wla4n1kXXzc3EKiPCIvbep+d1D+em/2r/DkL0+LkyeP/nX2l5OvTnJ4+tU3",
	"Jyf0m6f00TdPHsHjv3z19AQezb/+Zva4ePz08ezp46dff/VN/uTpo9nTr7/513uGDxmQLaC+Zsezyf/J",
	"TsuFyE7fnmUXBtgGJ7Ri34PZG9SV55i3DJGa40mEFWXl5Jn/6X/7E3aUi1UzvP914gqvTZZaV+rZ8fH1",
	"9fVR3OV4gU//My3qfHns58EUdy155e1ZiNG3cTi4o431GDc1JP8y3969PL8gp2/PjhqCmTybnBydHD1y",
	"Nes5rdjk2eQJ/oSnZ4n7foyJc4+Vq4lx3LzVSvrt3mHIuhfO5QIKcj+8uvmX4LlVD/zjnblLTvd3ZYkx",
	"rOKsQOJyxYcnWE4Rg7EQrMcnJ34vnKQTXTjH+Prj2ceJCgXtu8JED6kXDcBJyJpirv1F/8SvuLjmBLN8",
	"2gNUr1ZUbu0KWtiIBsdtoguFRnbJ1pi2zfTu4ryqXCWSIZRj+br2KfedkUBCKQtzwmyFC1dPRKVQ3q+C",
	"ckvs78z62psssTvY6K2B2afPCZlSnUPI4Qx9xhZh4YxYs0MP0dNJVSfQ+RIf1qhdOJtG1TUsNKIsAsZ7",
	"GH1b/zfBqCHdRcgKav5aAi0xsZb5Y2UINfefJNBi6/6vruliAfLIrdP8tH587LWQ448uY8qnXd+O44iw",
	"44+txDLFnp4+4mlfk+OPvhb+7gFbddBdrGnUYSSgu5odz7D+3dimEK9ueClI8+r4Iyrgg78fOytq+iMa",
	"QuwNe+wTNA20tKk40h9bKPyoN2Yhu4czbaLxcqrzZV0df8T/INl+sqe9hFQmJ1t7h5Km+ZQwTehMSCyt",
	"rvOl4Qa+pjNTUcvekT81vZ5bCPA29eFFk2fv+++/cCDiR0IRxdy/jQTRmqkREtGdEjGFIAK32jeC8PuT",
	"7JsPHx9NH518+icj6Lo/v3ryaWT0/PMwLjkPUuzIhh9uyfF6NptmkXaTAgPrKxmOFobf97it6gxEAjL2",
	"FG7tDJ/I2Wq6PL1DHt9OKJ7g79/Sgvg0CTj3o8839xm3MeJGULUC9afp5KvPufozbkiell4ku6HwdmoP",
	"f8wUiNvslPA2nXDBo2SKfGHFDJFKVTHAb5SmN+A356bX//CbVsOelw/f4Vlr64pxDHNr4nrsZRKKVILP",
	"MOvfFtBiTXnuH2M1ryNwv6zk7QgjBODWCuZ16dOQVCWbb60fQpR+IlVXleE4c6oCZbknGUZhtlkUwtCk",
	"5rngNnQKX794BzBmQ0AnsrpiVasLmxuqwlRK/iXWkd/0f9Qgt82ur5jRfHs6UxPc93uycIvHO2Dh7YHu",
	"mIU/PpCN/vlX/N/70np68pfPB4FPXnTBViBq/We9NM/tDXarS9PJ8LawzrHe8GMM7z7+2FJX3OeeutL+",
	"veket8CaEV6FEPO5QtPKrs/HH+2/0USwqUCyFXCNOW/dr/bmODa8vdz2f97yPPljfx2tvMwDPx97i2pK",
	"S263/Nj6s635qWWtC3FtSz8k5RW8PmlJVpTThX3EH4yQ5h50AzQpo8mbKlxU7u0uoVhXU9S6sRLbpyzu",
	"QX/w4+ONFqK5FozjBOiQxVno3HSl0QXuStv2bYjnDrIfRQF92Sh1EToYW5dhOAqpIrIf7sY6GTHeT4cd",
	"FHQc26iHPhmZj7Xq/n18TZk2EpTL3YwY7XfWQMtjV4Gx82tT9Kj3BSs5RT/GWQmSvx7T9rloW1DMlg11",
	"7JlXUl+dBWGgkX9M4z83zpvYGYLkEtwg7z+YXVcg156SGtv+s+NjfF25FEofoyTatvvHHz+Ejfa15cOG",
	"m2+bTEi2YJyWmTOSNWVkJ4+PTiaf/n8AAAD//2smK19dEwEA",
}

// GetSwagger returns the content of the embedded swagger specification file
// or error if failed to decode
func decodeSpec() ([]byte, error) {
	zipped, err := base64.StdEncoding.DecodeString(strings.Join(swaggerSpec, ""))
	if err != nil {
		return nil, fmt.Errorf("error base64 decoding spec: %s", err)
	}
	zr, err := gzip.NewReader(bytes.NewReader(zipped))
	if err != nil {
		return nil, fmt.Errorf("error decompressing spec: %s", err)
	}
	var buf bytes.Buffer
	_, err = buf.ReadFrom(zr)
	if err != nil {
		return nil, fmt.Errorf("error decompressing spec: %s", err)
	}

	return buf.Bytes(), nil
}

var rawSpec = decodeSpecCached()

// a naive cached of a decoded swagger spec
func decodeSpecCached() func() ([]byte, error) {
	data, err := decodeSpec()
	return func() ([]byte, error) {
		return data, err
	}
}

// Constructs a synthetic filesystem for resolving external references when loading openapi specifications.
func PathToRawSpec(pathToFile string) map[string]func() ([]byte, error) {
	var res = make(map[string]func() ([]byte, error))
	if len(pathToFile) > 0 {
		res[pathToFile] = rawSpec
	}

	return res
}

// GetSwagger returns the Swagger specification corresponding to the generated code
// in this file. The external references of Swagger specification are resolved.
// The logic of resolving external references is tightly connected to "import-mapping" feature.
// Externally referenced files must be embedded in the corresponding golang packages.
// Urls can be supported but this task was out of the scope.
func GetSwagger() (swagger *openapi3.T, err error) {
	var resolvePath = PathToRawSpec("")

	loader := openapi3.NewLoader()
	loader.IsExternalRefsAllowed = true
	loader.ReadFromURIFunc = func(loader *openapi3.Loader, url *url.URL) ([]byte, error) {
		var pathToFile = url.String()
		pathToFile = path.Clean(pathToFile)
		getSpec, ok := resolvePath[pathToFile]
		if !ok {
			err1 := fmt.Errorf("path not found: %s", pathToFile)
			return nil, err1
		}
		return getSpec()
	}
	var specData []byte
	specData, err = rawSpec()
	if err != nil {
		return
	}
	swagger, err = loader.LoadFromData(specData)
	if err != nil {
		return
	}
	return
}
