// Package experimental provides primitives to interact with the openapi HTTP API.
//
// Code generated by github.com/algorand/oapi-codegen DO NOT EDIT.
package experimental

import (
	"bytes"
	"compress/gzip"
	"encoding/base64"
	"fmt"
	"net/http"
	"net/url"
	"path"
	"strings"

	. "github.com/algorand/go-algorand/daemon/algod/api/server/v2/generated/model"
	"github.com/algorand/oapi-codegen/pkg/runtime"
	"github.com/getkin/kin-openapi/openapi3"
	"github.com/labstack/echo/v4"
)

// ServerInterface represents all server handlers.
type ServerInterface interface {
	// Get a list of assets held by an account, inclusive of asset params.
	// (GET /v2/accounts/{address}/assets)
	AccountAssetsInformation(ctx echo.Context, address string, params AccountAssetsInformationParams) error
	// Returns OK if experimental API is enabled.
	// (GET /v2/experimental)
	ExperimentalCheck(ctx echo.Context) error
	// Fast track for broadcasting a raw transaction or transaction group to the network through the tx handler without performing most of the checks and reporting detailed errors. Should be only used for development and performance testing.
	// (POST /v2/transactions/async)
	RawTransactionAsync(ctx echo.Context) error
}

// ServerInterfaceWrapper converts echo contexts to parameters.
type ServerInterfaceWrapper struct {
	Handler ServerInterface
}

// AccountAssetsInformation converts echo context to params.
func (w *ServerInterfaceWrapper) AccountAssetsInformation(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "address" -------------
	var address string

	err = runtime.BindStyledParameterWithLocation("simple", false, "address", runtime.ParamLocationPath, ctx.Param("address"), &address)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter address: %s", err))
	}

	ctx.Set(Api_keyScopes, []string{""})

	// Parameter object where we will unmarshal all parameters from the context
	var params AccountAssetsInformationParams
	// ------------- Optional query parameter "limit" -------------

	err = runtime.BindQueryParameter("form", true, false, "limit", ctx.QueryParams(), &params.Limit)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter limit: %s", err))
	}

	// ------------- Optional query parameter "next" -------------

	err = runtime.BindQueryParameter("form", true, false, "next", ctx.QueryParams(), &params.Next)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter next: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.AccountAssetsInformation(ctx, address, params)
	return err
}

// ExperimentalCheck converts echo context to params.
func (w *ServerInterfaceWrapper) ExperimentalCheck(ctx echo.Context) error {
	var err error

	ctx.Set(Api_keyScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.ExperimentalCheck(ctx)
	return err
}

// RawTransactionAsync converts echo context to params.
func (w *ServerInterfaceWrapper) RawTransactionAsync(ctx echo.Context) error {
	var err error

	ctx.Set(Api_keyScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.RawTransactionAsync(ctx)
	return err
}

// This is a simple interface which specifies echo.Route addition functions which
// are present on both echo.Echo and echo.Group, since we want to allow using
// either of them for path registration
type EchoRouter interface {
	CONNECT(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	DELETE(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	GET(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	HEAD(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	OPTIONS(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	PATCH(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	POST(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	PUT(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	TRACE(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
}

// RegisterHandlers adds each server route to the EchoRouter.
func RegisterHandlers(router EchoRouter, si ServerInterface, m ...echo.MiddlewareFunc) {
	RegisterHandlersWithBaseURL(router, si, "", m...)
}

// Registers handlers, and prepends BaseURL to the paths, so that the paths
// can be served under a prefix.
func RegisterHandlersWithBaseURL(router EchoRouter, si ServerInterface, baseURL string, m ...echo.MiddlewareFunc) {

	wrapper := ServerInterfaceWrapper{
		Handler: si,
	}

	router.GET(baseURL+"/v2/accounts/:address/assets", wrapper.AccountAssetsInformation, m...)
	router.GET(baseURL+"/v2/experimental", wrapper.ExperimentalCheck, m...)
	router.POST(baseURL+"/v2/transactions/async", wrapper.RawTransactionAsync, m...)

}

// Base64 encoded, gzipped, json marshaled Swagger object
var swaggerSpec = []string{

	"H4sIAAAAAAAC/+x9f5PbtpLgV0Fpt8qxT5yxHSf74qtXexM7yZuNk7g8TvZ2bd8LRLYkvKEAPgCckeLz",
	"d79CN0CCJChRMxM7qbq/7BHxo9FoNPoXut/PcrWplARpzezp+1nFNd+ABY1/8TxXtbSZKNxfBZhci8oK",
	"JWdPwzdmrBZyNZvPhPu14nY9m88k30DbxvWfzzT8sxYaitlTq2uYz0y+hg13A9td5Vo3I22zlcr8EGc0",
	"xPnz2Yc9H3hRaDBmCOVPstwxIfOyLoBZzaXhuftk2LWwa2bXwjDfmQnJlASmlsyuO43ZUkBZmJOwyH/W",
	"oHfRKv3k40v60IKYaVXCEM5narMQEgJU0ADVbAizihWwxEZrbpmbwcEaGlrFDHCdr9lS6QOgEhAxvCDr",
	"zezpm5kBWYDG3cpBXOF/lxrgN8gs1yuws3fz1OKWFnRmxSaxtHOPfQ2mLq1h2BbXuBJXIJnrdcJ+qI1l",
	"C2BcslffPmOff/75V24hG24tFJ7IRlfVzh6vibrPns4KbiF8HtIaL1dKc1lkTftX3z7D+S/8Aqe24sZA",
	"+rCcuS/s/PnYAkLHBAkJaWGF+9ChftcjcSjanxewVBom7gk1vtNNief/pLuSc5uvKyWkTewLw6+MPid5",
	"WNR9Hw9rAOi0rxymtBv0zcPsq3fvH80fPfzwL2/Osv/2f37x+YeJy3/WjHsAA8mGea01yHyXrTRwPC1r",
	"Lof4eOXpwaxVXRZsza9w8/kGWb3vy1xfYp1XvKwdnYhcq7NypQzjnowKWPK6tCxMzGpZOjblRvPUzoRh",
	"lVZXooBi7rjv9Vrka5ZzQ0NgO3YtytLRYG2gGKO19Or2HKYPMUocXDfCBy7oj4uMdl0HMAFb5AZZXioD",
	"mVUHrqdw43BZsPhCae8qc9xlxV6vgeHk7gNdtog76Wi6LHfM4r4WjBvGWbia5kws2U7V7Bo3pxSX2N+v",
	"xmFtwxzScHM696g7vGPoGyAjgbyFUiVwicgL526IMrkUq1qDYddrsGt/52kwlZIGmFr8A3Lrtv0/Ln76",
	"kSnNfgBj+Ape8vySgcxVAcUJO18yqWxEGp6WEIeu59g6PFypS/4fRjma2JhVxfPL9I1eio1IrOoHvhWb",
	"esNkvVmAdlsarhCrmAZbazkGEI14gBQ3fDuc9LWuZY77307bkeUctQlTlXyHCNvw7V8fzj04hvGyZBXI",
	"QsgVs1s5Kse5uQ+Dl2lVy2KCmGPdnkYXq6kgF0sBBWtG2QOJn+YQPEIeB08rfEXghEFGwWlmOQCOhG2C",
	"Ztzpdl9YxVcQkcwJ+9kzN/xq1SXIhtDZYoefKg1XQtWm6TQCI069XwKXykJWaViKBI1deHQ4BkNtPAfe",
	"eBkoV9JyIaFwzBmBVhaIWY3CFE24X98Z3uILbuDLJ2N3fPt14u4vVX/X9+74pN3GRhkdycTV6b76A5uW",
	"rDr9J+iH8dxGrDL6ebCRYvXa3TZLUeJN9A+3fwENtUEm0EFEuJuMWEluaw1P38oH7i+WsQvLZcF14X7Z",
	"0E8/1KUVF2LlfirppxdqJfILsRpBZgNrUuHCbhv6x42XZsd2m9QrXih1WVfxgvKO4rrYsfPnY5tMYx5L",
	"mGeNthsrHq+3QRk5tofdNhs5AuQo7iruGl7CToODludL/Ge7RHriS/2b+6eqStfbVssUah0d+ysZzQfe",
	"rHBWVaXIuUPiK//ZfXVMAEiR4G2LU7xQn76PQKy0qkBbQYPyqspKlfMyM5ZbHOlfNSxnT2f/ctraX06p",
	"uzmNJn/hel1gJyeykhiU8ao6YoyXTvQxe5iFY9D4CdkEsT0UmoSkTXSkJBwLLuGKS3vSqiwdftAc4Dd+",
	"phbfJO0Qvnsq2CjCGTVcgCEJmBreMyxCPUO0MkQrCqSrUi2aHz47q6oWg/j9rKoIHyg9gkDBDLbCWHMf",
	"l8/bkxTPc/78hH0Xj42iuJLlzl0OJGq4u2Hpby1/izW2Jb+GdsR7huF2Kn3itiagwYn5d0FxqFasVemk",
	"noO04hr/zbeNycz9Pqnzn4PEYtyOExcqWh5zpOPgL5Fy81mPcoaE4809J+ys3/dmZONG2UMw5rzF4l0T",
	"D/4iLGzMQUqIIIqoyW8P15rvZl5IzFDYG5LJzwaIQiq+EhKhnTv1SbINv6T9UIh3RwhgGr2IaIkkyMaE",
	"6mVOj/qTgZ3lT0CtqY0NkqiTVEthLOrV2JitoUTBmctA0DGp3IgyJmz4nkU0MF9rXhEt+y8kdgmJ+jw1",
	"IlhvefFOvBOTMEfsPtpohOrGbPkg60xCglyjB8PXpcov/8bN+g5O+CKMNaR9nIatgReg2ZqbdeLg9Gi7",
	"HW0KfbuGSLNsEU110izxhVqZO1hiqY5hXVX1jJelm3rIsnqrxYEnHeSyZK4xg41Ag7lXHMnCTvoX+4bn",
	"aycWsJyX5bw1FakqK+EKSqe0CylBz5ldc9sefhw56DV4jgw4ZmeBRavxZiY0senGFqGBbTjeQBunzVRl",
	"t0/DQQ3fQE8KwhtR1WhFiBSN8+dhdXAFEnlSMzSC36wRrTXx4Cdubv8JZ5aKFkcWQBvcdw3+Gn7RAdq1",
	"bu9T2U6hdEE2a+t+E5rlStMQdMP7yd1/gOu2M1HnZ5WGzA+h+RVow0u3ut6i7jfke1en88DJLLjl0cn0",
	"VJhWwIhzYD8U70AnrDQ/4X94ydxnJ8U4SmqpR6AwoiJ3akEXs0MVzeQaoL1VsQ2ZMlnF88ujoHzWTp5m",
	"M5NO3jdkPfVb6BfR7NDrrSjMXW0TDja2V90TQrarwI4GsshephPNNQUBr1XFiH30QCBOgaMRQtT2zq+1",
	"r9U2BdPXaju40tQW7mQn3DiTmf3XavvcQ6b0Yczj2FOQ7hYo+QYM3m4yZpxultYvd7ZQ+mbSRO+Ckaz1",
	"NjLuRo2EqXkPSdi0rjJ/NhMeC2rQG6gN8NgvBPSHT2Gsg4ULy38HLBg36l1goTvQXWNBbSpRwh2Q/jop",
	"xC24gc8fs4u/nX3x6PHfH3/xpSPJSquV5hu22Fkw7DNvlmPG7kq4n9SOULpIj/7lk+Cj6o6bGseoWuew",
	"4dVwKPJ9kfZLzZhrN8RaF8246gbASRwR3NVGaGfk1nWgPYdFvboAa52m+1Kr5Z1zw8EMKeiw0ctKO8HC",
	"dP2EXlo6LVyTU9hazU8rbAmyoDgDtw5hnA64WdwJUY1tfNHOUjCP0QIOHopjt6mdZhdvld7p+i7MG6C1",
	"0skruNLKqlyVmZPzhEoYKF76Fsy3CNtV9X8naNk1N8zNjd7LWhYjdgi7ldPvLxr69Va2uNl7g9F6E6vz",
	"807Zly7yWy2kAp3ZrWRInR3zyFKrDeOswI4oa3wHluQvsYELyzfVT8vl3Vg7FQ6UsOOIDRg3E6MWTvox",
	"kCtJwXwHTDZ+1Cno6SMmeJnsOAAeIxc7maOr7C6O7bg1ayMk+u3NTuaRacvBWEKx6pDl7U1YY+igqe6Z",
	"BDgOHS/wM9rqn0Np+bdKv27F1++0qqs7Z8/9Oacuh/vFeG9A4foGM7CQq7IbQLpysJ+k1vhJFvSsMSLQ",
	"GhB6pMgXYrW2kb74Uqvf4U5MzpICFD+Qsah0fYYmox9V4ZiJrc0diJLtYC2Hc3Qb8zW+ULVlnElVAG5+",
	"bdJC5kjIIcY6YYiWjeVWtE8IwxbgqCvntVttXTEMQBrcF23HjOd0QjNEjRkJv2jiZqgVTUfhbKUGXuzY",
	"AkAytfAxDj76AhfJMXrKBjHNi7gJftGBq9IqB2OgyLwp+iBooR1dHXYPnhBwBLiZhRnFllzfGtjLq4Nw",
	"XsIuw1g/wz77/hdz/xPAa5Xl5QHEYpsUevv2tCHU06bfR3D9yWOyI0sdUa0Tbx2DKMHCGAqPwsno/vUh",
	"Guzi7dFyBRpDSn5Xig+T3I6AGlB/Z3q/LbR1NRLB7tV0J+G5DZNcqiBYpQYrubHZIbbsGnVsCW4FESdM",
	"cWIceETwesGNpTAoIQu0adJ1gvOQEOamGAd4VA1xI/8SNJDh2Lm7B6WpTaOOmLqqlLZQpNaAHtnRuX6E",
	"bTOXWkZjNzqPVaw2cGjkMSxF43tkeQ0Y/+C28b96j+5wcehTd/f8LonKDhAtIvYBchFaRdiNo3hHABGm",
	"RTQRjjA9ymlCh+czY1VVOW5hs1o2/cbQdEGtz+zPbdshcZGTg+7tQoFBB4pv7yG/JsxS/PaaG+bhCC52",
	"NOdQvNYQZncYMyNkDtk+ykcVz7WKj8DBQ1pXK80LyAoo+S4RHECfGX3eNwDueKvuKgsZBeKmN72l5BD3",
	"uGdoheOZlPDI8AvL3RF0qkBLIL73gZELwLFTzMnT0b1mKJwruUVhPFw2bXViRLwNr5R1O+7pAUH2HH0K",
	"wCN4aIa+OSqwc9bqnv0p/guMn6CRI46fZAdmbAnt+EctYMQW7N84Reelx957HDjJNkfZ2AE+MnZkRwzT",
	"L7m2IhcV6jrfw+7OVb/+BEnHOSvAclFCwaIPpAZWcX9GIaT9MW+mCk6yvQ3BHxjfEssJYTpd4C9hhzr3",
	"S3qbEJk67kKXTYzq7icuGQIaIp6dCB43gS3Pbblzgppdw45dgwZm6gWFMAz9KVZVWTxA0j+zZ0bvnU36",
	"Rve6iy9wqGh5qVgz0gn2w/e6pxh00OF1gUqpcoKFbICMJASTYkdYpdyuC//8KTyACZTUAdIzbXTNN9f/",
	"PdNBM66A/ZeqWc4lqly1hUamURoFBRQg3QxOBGvm9MGJLYaghA2QJolfHjzoL/zBA7/nwrAlXIc3g65h",
	"Hx0PHqAd56UytnO47sAe6o7beeL6QMeVu/i8FtLnKYcjnvzIU3byZW/wxtvlzpQxnnDd8m/NAHoncztl",
	"7TGNTIv2wnEn+XK68UGDdeO+X4hNXXJ7F14ruOJlpq5Aa1HAQU7uJxZKfnPFy5+abvgeEnJHozlkOb7i",
	"mzgWvHZ96OGfG0dI4Q4wBf1PBQjOqdcFdTqgYraRqmKzgUJwC+WOVRpyoPduTnI0zVJPGEXC52suV6gw",
	"aFWvfHArjYMMvzZkmtG1HAyRFKrsVmZo5E5dAD5MLTx5dOIUcKfS9S3kpMBc82Y+/8p1ys0c7UHfY5B0",
	"ks1noxqvQ+pVq/EScrrvNidcBh15L8JPO/FEVwqizsk+Q3zF2+IOk9vc38dk3w6dgnI4cRTx234cC/p1",
	"6na5uwOhhwZiGioNBq+o2Exl6Ktaxm+0Q6jgzljYDC351PXvI8fv1ai+qGQpJGQbJWGXTEsiJPyAH5PH",
	"Ca/Jkc4osIz17esgHfh7YHXnmUKNt8Uv7nb/hPY9VuZbpe/KJUoDThbvJ3ggD7rb/ZQ39ZPysky4Fv0L",
	"zj4DMPMmWFdoxo1RuUCZ7bwwcx8VTN5I/9yzi/6XzbuUOzh7/XF7PrQ4OQDaiKGsGGd5KdCCrKSxus7t",
	"W8nRRhUtNRHEFZTxcavls9AkbSZNWDH9UG8lxwC+xnKVDNhYQsJM8y1AMF6aerUCY3u6zhLgrfSthGS1",
	"FBbn2rjjktF5qUBjJNUJtdzwHVs6mrCK/QZasUVtu9I/PlA2VpSld+i5aZhavpXcshK4sewHIV9vcbjg",
	"9A9HVoK9VvqywUL6dl+BBCNMlg42+46+Yly/X/7ax/hjuDt9DkGnbcaEmVtmJ0nK//ns35++Ocv+m2e/",
	"Pcy++h+n794/+XD/weDHxx/++tf/2/3p8w9/vf/v/5raqQB76vmsh/z8udeMz5+j+hOF6vdh/2j2/42Q",
	"WZLI4miOHm2xzzBVhCeg+13jmF3DW2m30hHSFS9F4XjLTcihf8MMziKdjh7VdDaiZwwLaz1SqbgFl2EJ",
	"JtNjjTeWoobxmemH6uiU9G/P8bwsa0lbGaRveocZ4svUct4kI6A8ZU8ZvlRf8xDk6f98/MWXs3n7wrz5",
	"PpvP/Nd3CUoWxTaVR6CAbUpXjB9J3DOs4jsDNs09EPZkKB3FdsTDbmCzAG3Wovr4nMJYsUhzuPBkyduc",
	"tvJcUoC/Oz/o4tx5z4lafny4rQYooLLrVP6ijqCGrdrdBOiFnVRaXYGcM3ECJ32bT+H0RR/UVwJfhsBU",
	"rdQUbag5B0RogSoirMcLmWRYSdFP73mDv/zNnatDfuAUXP05UxG997775jU79QzT3KOUFjR0lIQgoUr7",
	"x5OdgCTHzeI3ZW/lW/kclmh9UPLpW1lwy08X3IjcnNYG9Ne85DKHk5ViT8N7zOfc8rdyIGmNJlaMHk2z",
	"ql6UImeXsULSkiclyxqO8PbtG16u1Nu37waxGUP1wU+V5C80QeYEYVXbzKf6yTRcc53yfZkm1QuOTLm8",
	"9s1KQraqyUAaUgn58dM8j1eV6ad8GC6/qkq3/IgMjU9o4LaMGaua92hOQPFPet3+/qj8xaD5dbCr1AYM",
	"+3XDqzdC2ncse1s/fPg5vuxrcyD86q98R5O7CiZbV0ZTUvSNKrhwUisxVj2r+CrlYnv79o0FXuHuo7y8",
	"QRtHWTLs1nl1GB4Y4FDtAponzqMbQHAc/TgYF3dBvUJax/QS8BNuYfcB9q32K3o/f+PtOvAGn9d2nbmz",
	"nVyVcSQedqbJ9rZyQlaIxjBihdqqT4y3AJavIb/0GctgU9ndvNM9BPx4QTOwDmEolx29MMRsSuigWACr",
	"q4J7UZzLXT+tjaEXFTjoK7iE3WvVJmM6Jo9NN62KGTuoSKmRdOmINT62foz+5vuosvDQ1GcnwcebgSye",
	"NnQR+owfZBJ57+AQp4iik/ZjDBFcJxBBxD+Cghss1I13K9JPLU/IHKQVV5BBKVZikUrD+59Df1iA1VGl",
	"zzzoo5CbAQ0TS+ZU+QVdrF6911yuwF3P7kpVhpeUVTUZtIH60Bq4tgvgdq+dX8YJKQJ0qFJe48trtPDN",
	"3RJg6/ZbWLTYSbh2WgUaiqiNj14+GY8/I8ChuCE8oXurKZyM6roedYmMg+FWbrDbqLU+NC+mM4SLvm8A",
	"U5aqa7cvDgrls21SUpfofqkNX8GI7hJ77ybmw+h4/HCQQxJJUgZRy76oMZAEkiBT48ytOXmGwX1xhxjV",
	"zF5AZpiJHMTeZ4RJtD3CFiUKsE3kKu091x0vKmUFHgMtzVpAy1YUDGB0MRIfxzU34ThivtTAZSdJZ79j",
	"2pd9qenOo1jCKClqk3gu3IZ9DjrQ+32CupCVLqSii5X+CWnlnO6FzxdS26EkiqYFlLCihVPjQChtwqR2",
	"gxwcPy2XyFuyVFhiZKCOBAA/BzjN5QFj5Bthk0dIkXEENgY+4MDsRxWfTbk6BkjpEz7xMDZeEdHfkH7Y",
	"R4H6ThhVlbtcxYi/MQ8cwKeiaCWLXkQ1DsOEnDPH5q546dic18XbQQYZ0lCh6OVD86E398cUjT2uKbry",
	"j1oTCQk3WU0szQag06L2HogXapvRC+WkLrLYLhy9J98u4Hvp1MGkXHT3DFuoLYZz4dVCsfIHYBmHI4AR",
	"2V62wiC9Yr8xOYuA2Tftfjk3RYUGScYbWhtyGRP0pkw9IluOkctnUXq5GwHQM0O1tRq8WeKg+aArngwv",
	"8/ZWm7dpU8OzsNTxHztCyV0awd/QPtZNCPe3NvHfeHKxcKI+Sia8oWXpNhkKqXNFWQePSVDYJ4cOEHuw",
	"+rIvBybR2o316uI1wlqKlTjmO3RKDtFmoARUgrOOaJpdpiIFnC4PeI9fhG6RsQ53j8vd/SiAUMNKGAut",
	"0yjEBX0KczzH9MlKLcdXZyu9dOt7pVRz+ZPbHDt2lvnRV4AR+Euhjc3Q45Zcgmv0rUEj0reuaVoC7YYo",
	"UrEBUaQ5Lk57CbusEGWdplc/7/fP3bQ/NheNqRd4iwlJAVoLLI6RDFzeMzXFtu9d8Ata8At+Z+uddhpc",
	"UzexduTSneNPci56DGwfO0gQYIo4hrs2itI9DDJ6cD7kjpE0GsW0nOzzNgwOUxHGPhilFp69j938NFJy",
	"LVEawPQLQbVaQRHSmwV/mIySyJVKrqIqTlW1L2feCaPUdZh5bk/SOh+GD2NB+JG4nwlZwDYNfawVIOTt",
	"yzpMuIeTrEBSupK0WSiJmjjEH1tEtrqP7AvtPwBIBkG/7jmz2+hk2qVmO3EDSuCF10kMhPXtP5bDDfGo",
	"m4+FT3cyn+4/Qjgg0pSwUWGTYRqCEQbMq0oU257jiUYdNYLxo6zLI9IWshY/2AEMdIOgkwTXSaXtQ629",
	"gf0Udd5Tp5VR7LUPLHb0zXP/AL+oNXowOpHNw7ztja42ce3f/3JhleYr8F6ojEC61RC4nGPQEGVFN8wK",
	"CicpxHIJsffF3MRz0AFuYGMvJpBugsjSLppaSPvlkxQZHaCeFsbDKEtTTIIWxnzyr4deriDTR6ak5kqI",
	"tuYGrqrkc/3vYZf9wsvaKRlCmzY817udupfvEbt+tfkedjjywahXB9iBXUHL0ytAGkxZ+ptPJkpgfc90",
	"UvyjetnZwiN26iy9S3e0Nb4owzjxt7dMp2hBdym3ORhtkISDZcpuXKRjE9zpgS7i+6R8aBNEcVgGieT9",
	"eCphQgnL4VXU5KI4RLuvgZeBeHE5sw/z2e0iAVK3mR/xAK5fNhdoEs8YaUqe4U5gz5Eo51Wl1RUvMx8v",
	"MXb5a3XlL39sHsIrPrImk6bs19+cvXjpwf8wn+UlcJ01loDRVWG76k+zKirjsP8qoWzf3tBJlqJo85uM",
	"zHGMxTVm9u4ZmwZFUdr4mego+piLZTrg/SDv86E+tMQ9IT9QNRE/rc+TAn66QT78iosyOBsDtCPB6bi4",
	"aZV1klwhHuDWwUJRzNetxxp93PD27ZurgMfWTUABM01+9UQElZlgIO8zkfQhbIn4AOvDJf2EGTDTio30",
	"+TGR4/kYI37nQtq3SnfuGP8AMhmj9PtJb06WJzyOhISHMpl9me2EkXz36+pXd+gfPIhP9IMHc/Zr6T9E",
	"AOLvC/87qjEPHiSdlElrmeNFaAyTfAP3m8ccoxvxcfV8CdfT5ICzq00jwKpxMmwolIKNArqvPfautfD4",
	"LPwvBZTgfjqZYguIN53QHQMz5QRdjD14bGJZN1SZ0zAl+6Hb+NbWkRbeKb7yA/l8h0dI1hv0k2amFHk6",
	"gkQujOM+kmI2XWOGjUeMwm7EWoyEAMtaRGO5ZlNSs/aAjOZIItMks8O2uFsof7xrKf5ZAxOFU56WAjRe",
	"n70bNeggOOpA7k2b3/zA5A5rh7+NuWWPWyuYnPbZWva6CZ83rquw0FRtoSMDzeMZB4x7T5C4p49wy+Gj",
	"uXU30nOaujSlQntgdN4nODJHsuK6MNlSq98gfWGjmyqRbyP4VwVak38DmQoQ7LOUxnfdFo5vZz+03dNV",
	"8LGNv7XKHRbdFDe7yWWaPtXHbeRNdGuTzgrtkTym68WBDN0XCCOsBY9XFHOL1VZCkBOXdJ4o2UTnIVv6",
	"VMZPRk9p/PZUepgHz2xLfr3gqVI0TuVyMEXb2wnHsoqFzmEDTJNKgWZnUaB401ZQwroKdOvqGCa/vaH6",
	"RNNOVpxaPQkpKtaQ5hQNURqVGKaW11xSsXLXj/iV722APP2u17XSmG7SpCPHCsjFJmn1ffv2TZEPo4QK",
	"sRJUh7s2EBV69gMxymmJVOSLZTcJQjxqzpfs4TyqNu93oxBXwohFCdjiEbVYcIPXZeN1b7q45YG0a4PN",
	"H09ovq5loaGwa0OINYo1Ki4KeU384wLsNYBkD7Hdo6/YZxj5acQV3HdY9ELQ7OmjrzBuh/54mLplfR31",
	"fSy7QJ4dYsLTdIyhrzSGY5J+1HSQ91ID/Abjt8Oe00Rdp5wlbOkvlMNnacMlX0H6GcjmAEzUF3cTowZ6",
	"eJHkdABjtdoxYdPzg+WOP408LXfsj8BgudpshN34+ECjNo6e2irONGkYDuudhbJUAa7wEcNsq4Sa/AnU",
	"GL4ZeRqGwdA/ois4RuucccoxWoo2AD6UBWXnIYUx1ulqynMRbtxcbukoS2I8/JJVWkiLZpbaLrO/OLVY",
	"89yxv5MxcLPFl08S9a66JWHkcYB/dLxrMKCv0qjXI2QfZBbfl30mlcw2jqMU99tUDtGpHI0HTkd+joWf",
	"7h96quTrRslGya3ukBuPOPWtCE/uGfCWpNis5yh6PHplH50ya50mD167Hfr51QsvZWyUTtUlaI+7lzg0",
	"WC3gCh/mpTfJjXnLvdDlpF24DfSfNswqiJyRWBbOclIRiByn+97kOyn+lx/aBOvov6UHjz0boNIJa6e3",
	"233koMbjrG59NzHFpeG3EcxNRhuOMsTKSJA/RfE3fT5FWFIfJNrzjsHx0a9MOx0c5fgHDxDoBw/mXgz+",
	"9XH3M7H3Bw/SeY6TJjf3a4uF22jE2De1h1+rhAEsFEds4pZ8GoaEAXLsknIfHBNc+KHmrFuI7uNLEXfz",
	"jCwd1Jo+BW/fvsEvAQ/4Rx8Rn5hZ4ga2jyHGD3u3EGeSZIrmexROz9nXajuVcHp3UCCePwCKRlAy0TyH",
	"KxkUGk1GBRwMS4lo1I26gFI5JTOuPRTb8/88eHaLn+/Bdi3K4pfWy9q7SDSX+ToZjLxwHf9OMnrnCiZW",
	"mSxnsuZSQpkcjnTbvwcdOKGl/0NNnWcj5MS2/UK3tNze4lrAu2AGoMKEDr3Clm6CGKvd7FxN9odypQqG",
	"87S1M1rmOKwYnarUmXhGjcNuauvDY/HJuc9rtBQlRnum/cbYMtPcjuTpwrLqoYyRGwernBsyM9DooBkX",
	"G7yYDd9UJeDJvALNV9hVSeh1x0xtOHJUGIOZyn3ClpgXQzFba8nUchktA6QVGsrdnFXcGBrkoVsWbHHu",
	"2dNHDx8mzV6InQkrJSyGZf7ULuXRKTahL76WE1UcOArYw7B+aCnqmI0dEo4vXfnPGoxN8VT8QA9k0Uvq",
	"bm0qW9mUWD1h32GCJUfEnYz6aK4MuYq7eTvrqlS8mGMO5dffnL1gNCv1oUr1VDZzhda6Lvkn3SvT85iG",
	"BFIjCXqmj7M/Y4hbtbFZU+UylQLRtWjrcIpeaA/a8WLsnLDnZEJt4lhoEoaZuPUGiqioJinxSBzuP9by",
	"fI22yY4ENM4rp9d7Deys9dxEjxybIkvIsB3cvuQrVXydM2XXoK+FAXz4D1fQzbrYpCD1tvGQhbG7PF1L",
	"SZRycoQw2pRUOhbtATiSZENQQRKyHuKPtExR2edjy99eYK/0k49eLd2e1z/k8AuZvNkP3rmQc6mkyLHi",
	"QkqSxgxx09yUE4pTpP2LZuZPaOJwJSv4Nk+OPRZHa/oGRugRN3T5R1/dphJ10J8Wtr6y2wqs8ZwNinko",
	"qO0dYkIa8EWzHBHFfFLpRFBT8r1FE0BxJBlh8qcRC+e37tuP3v6NuTcuhURLl0eb18/IZVUagZ5pyYRl",
	"KwXGr6f7aMi8cX1OMBlkAdt3Jy/USuQXYoVjUBidWzaFpg6HOguBqj4w1LV95tr6FP3Nz51wMJr0rKr8",
	"pOPl1pOCpN3KUQSn4pZCIEmE3Gb8eLQ95LY3whzvU0docIVRa1DhPTwgjKZkd3eUb5xuSRSFLRg93Ezm",
	"6RUyAcYLIYMLNX1B5MkrATcGz+tIP5Nrbkl3mMTTXgMvR95Z4ENo8sHfdqh+gQKHElxjmGN8G9tq4yOM",
	"o2nQSvxc7lg4FI66I2HiGS+bCO1E7XCUqrwQRTGtvWriKcbhGHcWXmZ20HXwlWDTHYt+HHsTjaVCXNTF",
	"CmzGiyKVQetr/Mrwa3iLBlvI66bWVfMIsZsKfUhtfqJcSVNv9swVGtxyuqg8f4Iamo9QNDuMCX0WO/w3",
	"VehpfGd8bPbRj39DIHZxXP7/4WPmlNTraDozYpVNxwTeKbdHRzv1zQi97X+nlB5eBf8hHv32uFy8Ryn+",
	"9o27OOL8wIP4dLpamvS9GAuu8HvIq9QknuxyJbzKBuXMMOoBNy+xZT3gQ8Mk4Fe8HHlwH/tK6H4l/8HY",
	"s/t8NEsEtz4LmOVsLwsazaxEscI978vQhTgWH0zhwXfntfBr3YvQcd/d9x1PHcWItcxi1EN3Mydau8HH",
	"etF8XYOhSZOXpconn3o/zJnrNJ41VG02Pp12IobtaqOKmM7jaCiANNOi8NxEyD/qnslvqBglv+jr9Ggd",
	"m8WxplJCo1/CnF4CBvACMDR1PFFkIvWYZd+KEush/cfFTz/Oxjcy2oHhlvosvkmj8tjGNI+l+uSxUh18",
	"1OO2EyXLlBIxn5kRIzfm6kmfBl/0NvnhWzLaTQGJUtoc0/rF1MEHBLBSqST1w5Qjs3YjAtojOmg3lnhJ",
	"TBcpevj+aizFSqjzg9/jekI+PG/uy0jAlVB1CKsMjxuCrYd+9Sm8OnWDRhhb8snQp3ZHjjpPX/v617RM",
	"b2z7/hcKr2Agrd79AVypg03vF6VKqLFkd26bsKZ06qRSqh1xd0oNrFS5Ja/0BSM4yQwdWhqUrxqQ1fMp",
	"cv4AHx/ms/PiKEk4VbJrRqOk7tMXYrW2WPHjb8AL0C8PVDRpq5jgEauUEW0F49IN5lNIr3G4k6mviBwB",
	"i7giy3CsEF1+BbnFstVt1KwGOKY+i5sseHP/f2WT8bugeWzlC5rsq2IyrFV9QHgfJF6LkgdSnd+T6TU7",
	"zpq3EfS085qbNt1TL+fC5JffyyXkmFV9b6K7/1yDjJKozYPBFWFZRnnvRPNAEesCHO9OaAHal4duLzxR",
	"fa5bgzOWB+MSdvcM61BDsvBw8zr3JonHEQPk2w456Mc8RD4cVJiGMhALIdbfp3Jvi+uM5oyP0jbecK5A",
	"ku7iaFM57pkyyI83mMt1PSptLMr6Y7nwhjXXxw0Lz7HEvfGRr7xJXB6b39j5sPDWtU98jmkJG6doSIEO",
	"JvwWcpDSLKW49PVHECvkgr7muggt7iSpHN1NIg30splZtC+zhtFLiVIu+MgxL5UTI7Kxl6Ldx1BNJPE9",
	"QyHfbQIwhGsJWkPR+DpLZSCzKrzk2gfHPlRQXPuNkGBGy6cRcKOp81+1tQGwjCTHVPnch7PHC2QaNtxB",
	"p6MM/uNz7kP2M/oekniEMoIHTccNvR6uZx3e5AkzQGJM9Uvmb8vDyUFuYkUWUoLOgku5n85fdjM6Yt7e",
	"os7pgo4PRmNpn5x7aw8rSRpg8+EqezpClP3iEnanpASFQuBhB2OgSXIi0KOExb1NvlO7uknBvboT8D5t",
	"HspKqTIb8WKeD2sQ9Cn+UuSXgDlEm7crTva71z0bbhL2GTrPmjCV6/Uu5NyvKpBQ3D9h7EzSa8EQsdIt",
	"T9qbXN6z++bf4qxFTWVBvLX85K1MP7vCgh36ltwsDLOfhxlwrO6WU9EgBzLcb+VYLN01FvfoVgE+maqV",
	"D2NIelJJRFQERUomuSBX9DM86CnDEeY2iZLwYIQCZ96FzUypUkH6N8m/4oZKYyqeDAGyIKekAWmg8IMn",
	"EeDD8w6kFPWfQ9JMtWQa2uiQm2YP9Qk5iTWbMY2+P3MzS5ffLZWGeEaMPqVMwc2LNkzDi/9ZCKu53t0k",
	"x2cXVSnrySiWD8ZZNiGW7ULaMMshDstSXWfIrLKmTk5KtXXtTPcyDkUb237uVC8gCtjkxgtqO7bmBcuV",
	"1pDHPdIPuQmqjdKQlQrjN1OhJUvr5O4Nvt6UrFQrpqpcFUD1ptIUNDZXLSVHsQmicLkkCoh2MA0A9Yno",
	"eOKU7k4lB3GGotbB8gxh81+7PpSSos0KR4vOKEhh5CkCGJ8FzmOIGg/hRcKhfEZ9W2KaNy/FFukGdOrI",
	"L5nVNcyZb9Gvse8PPtfANsIYAqWhpWtRlpgRQmyjkIomIimN2hGx9xzjpa8EBtV1s4OQNFy5O69JmRLz",
	"gIs4nxmza63q1TpKUN/AGVReXXuFOB7lZ1Nj3CM+DXVTPGEbZazXNGmkdsltLOlnuZJWq7LsGqVIRF95",
	"S/sPfHuW5/aFUpcLnl/eR71WKtustJiHxAn9qN92Jt1LTdi9gDOkAXM41Te1wxhYT7STGWSPxQ2M4oes",
	"zBGY7w5z0MM297Phwvrr6jLTtBpzJhm3aiPy9Jn6c4XRjga/plhUMhkh1Wal9DHYDA97fFk1UVPIIodo",
	"BsmTxSXPmGcEPnoE2Y37L0rg/XHZEjyjGbkoh8zFS1FZPirr9QBASCmnga01FXSNJbGGq6gV5UDB2Jc+",
	"oBNvFQwxvB1sboQ7B8rCrYAahDU3AH5Gxoc5JY2kEOmF2obv99uskjcC/sN+Ku8wj7HYzYuWtDRFb4YM",
	"VCMcIZ0if2+g42vMZ7GYGu7YFN+eeMNHAIwHQHZgmBQGeSwYSy5KKLJU7dbzxkY1jzRt/+ayW7se72Xi",
	"5DmvQ+lUN3atwWdEIhFfd/1fFXekpJrmQ0uyLGAL9GDrN9CKaqLOI/8LlFQytWcMUFVWwhV04kJ9mqYa",
	"RU1xBaGvaTqzAqBCb2TfRpYKeIzv8p7hxK89i0LmpmA3aUkhxNJOsQNmkqRRZyszOiZm6lFyEF2JouYd",
	"/JljRY6uGdAd5QSqBjpCFvTIqdP8TCO8CgOchf4pUSZg4t00PnQ0C0qjbh8DOhgAXZuxUy/T8c9xDrLG",
	"wYKzFY0jlki85Rum4tdy3CA5JPlW3Zq4T0LJCLHfbCFHqcbrO1B4jWfESeHTGSG1S4CCtALXJWFtX4Nk",
	"UkUlaq+5aVSVNjlq+IEmxkZCem36Bk7lNkz59jvLcDBmelkSRxUJ3dDpzc3zn+Qk7j2Io+OlaMSAf9e7",
	"x/4VqNurHdhA1WXBpNtPJ/tjkVd/i3kuPmeLOgxUluqaas7GeuhzCH5Qor7gAvJiuWiu5RCOPfd5e/um",
	"DhE9RNnwHVMa/3Fa5z9rXorlDvkMgR+6MbPmjoS845UiAnx4t5t4v3g1D4AFa4sKU9G6xdQxo+F2bpQI",
	"aHeRh+Jgim34JcTbgMEOxD9z6xinqRdouXBXdm87h1jwiw+5lza8iDV9zAC763CHkBPc9f6f7SPXeKqQ",
	"uLEqeR4qDPsSZ10+g1XEA3HZNWz2v4Ie8rVAAk1l8pZodUibUdzAZHok60o9LRor39QBe1CxeVC56lbL",
	"mGj57dXo2fN+fNJS7noXpkbdDICO67weAj8ue/tx8J9Mzjy2jCng/1HwPlLoOoaXalp/BCx3UuskYCVr",
	"9UJtMw1LcyjAhMzVTp3XbVKeYGIVMtfADUXcnP/kFc8297CQThGmmNDGp9mMUsBSyJZZClnVNqHHYApi",
	"uYsQFhv9Ea0jLrQxKcEJk1e8/OkKtBbF2Ma500ElYeMSM8HR4fsmTBjNnTocQJhWh8OH160ZPW7mLnAq",
	"YkfhmsZyWXBdxM2FZDlod++za74zN/coNc6BQz4lHkkz3XQgkXcJSZsAKXfeKXxLf08DIL9Dx88Ehw3G",
	"BSecNWTasWrEPzOE4U/hsNnwbVaqFT4PHjkQPuk0evhIBVQSzeAkn01bd5jHiN9g/zRYb8MzIqtw1ilT",
	"7D/3P+FWohr5sxR278knG2X/vTbF3dLBDEiVqzb4n4hleB5TT+x9VqX4mX0QNsNTlUB7EG0ijPiHunbx",
	"kV3EMAifnyE2gk8vl9iNtEg95CfLQIYWA7MnvB9MG8rOcx+eNTSlDUwNhJS5T4NwpKWN7PPhXhoBD00h",
	"xp/17rRNyIwb55gak/sTH2SVqrJ8SswnleQpvJvAQ9qFcYQ+IifAyLqb8BjTFKnqJDTrVKs6tszmaLWs",
	"Q96uKt+n9I+ZiUY4etcFoZbIy/AIk3EMX/I0xpR5/41Z1wzWMAnGmYa81mgmvua7w2ULR1LBX/zt7ItH",
	"j//++IsvmWvACrEC05YT6JX9a+MChezbfT5uJOBgeTa9CSGtCCEu+B/Do6pmU/xZI25r2lzBg6KHx9iX",
	"ExdA6qXvsA7cjfYKx2lD+/9Y25Va5J3vWAoFv/+eaVWW6XIujVyVcKCkdityoTgNpAJthLGOEXY9oMK2",
	"EdFmjeZBTOp9RWmilMwh2I89FQg7EnKVWshYQC3yM0za4L1GDLZV6XkVeXr2rcvraWShQ6ERo2IWwCpV",
	"edFeLFkKInxBpKOXtd7wiRbxKEa2YbYULZsiRB95nia9uOD+fm7fLQZt05zebWJCvAiH8gakOeafGE9I",
	"chNO0pr2/zD8I5Fh5c64RrPc34NXJPWDPW+OzwZxD012kUmgDbNtJMgDARh5bdt5Jxk9FIsyjGvyEqA/",
	"ITiQ++LHD61j+eCzEIQkdDgAXvx8tm3XvGTw4HziVN0/NEiJlvJujBI6yz/0Ijew3uYiibbIG02sBUNs",
	"SQ3Fwui5tXnWvGIe0UoGj521UpY5zbQsE4+kyY6DZyomHKcS6Ctefnyu8a3Qxp4hPqB4Nf40Kn4pGyOZ",
	"UGluloDzBZ80d/Qq9u6mli/xYfZ/gtuj5D3nh/JO+MFthsYdXlJ49bLxRoNk1zgmBVk9+pItfBWdSkMu",
	"TN+5fx2Ek+ZhKGix9AGtsLUHXqIeWucvyt6CjJchEof9GLm3Gp+9h7A9op+YqYyc3CSVp6hvQBYJ/KV4",
	"VFzc+8B1ccuKKzfL5xRlZjwyn9OwbPnU5VFqE3fp1AaG65x8W3dwm7io27VNTUY2uXDL27dv7GJKDrF0",
	"kRXXHZOY3Um1laNqrfwO6csIR34MP2+KYn4ZS2hNSZtHku739qMW5cGAlU4JhQ/z2YoyGGGRgL/7olAf",
	"9y4NEIykEfNLv026GEJMYq2dyaOpooxPE+oi+G6JZPb4qjGvtbA7LAgeDGji78l8TN81uT18bpjGl+bv",
	"PqsuQYZ4jzYTSG3C7fqd4iXeR+Tik+4WUuUJ+4ZS9/uD8td7i3+Dz//ypHj4+aN/W/zl4RcPc3jyxVcP",
	"H/KvnvBHX33+CB7/5YsnD+HR8suvFo+Lx08eL548fvLlF1/lnz95tHjy5Vf/ds/xIQcyARpqdjyd/e/s",
	"rFyp7OzlefbaAdvihFfie3B7g7ryEvOWIVJzPImw4aKcPQ0//a9wwk5ytWmHD7/OfOG12drayjw9Pb2+",
	"vj6Ju5yu8Ol/ZlWdr0/DPJjiriOvvDxvYvQpDgd3tLUe46Y2yb/ct1ffXLxmZy/PT1qCmT2dPTx5ePLI",
	"16yXvBKzp7PP8Sc8PWvc91NMnHtqfE2M0+at1of54FtVUcUM92nVZAd0f62Bl5hgx/2xAatFHj5p4MXO",
	"/99c89UK9Am+3qCfrh6fBmnk9L3PnPBh37fTODLk9H0nwURxoGcT+ZD0Sb5Q6hJd4kE+umd6cRwnccn9",
	"88Khn1pi8IU5bxlhqJuOPufZ0zcp24uPoazqRSlyRtc30q/bnIi8mrQhLftAQ9vMNPX8W2boGNzD7Kt3",
	"77/4y4eUkNUH5AfvEGw9ID4kF1954QOFkwDXP2vQuxYw9NbPYjCG7sJ09rStZZWvaOJnO2E/+0gH/Eo8",
	"pYkI9Y/CmsRzodMIYG6IFFwNFt5h8U4M/UNyePzwYTj5Xq6OyOrUU2uM7q7vYRAXdEw6g05F+4RQ5BaT",
	"IT6GFPuzoZRLDptCcoqqx3DbDb8krwsG1DHt3816jPoYXURy837Eb0tg7r9jrbIJj7JppkRyxCG3HDmB",
	"IZQ2NoyVgsx+PrwpVZT+w3z25Ehq2Gug6iQGToD/Ay8dyFCEtDEEwaOPB8G5pIhPd+3Q9fhhPvviY+Lg",
	"XDrmxUuGLaO62gmKl5dSXcvQ0sky9WbD9Q4lFTtlj32WI/QlhnZE93SxcneG38yILWOFoQq0cAojL2fv",
	"Phy6Xk7f+xQ/By6jTi19H68cdZh4ye1rdrrAGopTm4KJGo8vBU1g5vQ9ntDR30+9JT79EY1pJKWdhiRf",
	"Iy0pnUv6YweF7+3WLWT/cK5NNF7Obb6uq9P3+B8UuKIVUdr3U7uVpxh8dPq+gwj/eYCI7u9t97gFZjQO",
	"wKnl0qA8su/z6Xv6N5qoQ5itUNMVUL6JGj1bQ345S999vZoYUS9G8ihflFAQc3oyoYNUNu50owP9CsUP",
	"w376noklg/4UwoQZjji3lFj0FEs171pchp93Mk/+ONzmTlLFkZ9PgzqUEm27Ld93/uweObOubaGuo1nQ",
	"kEhW8CFk7mNt+n+fXnNhs6XSPpcfX1rQw84WeHnqK/L0fm2T4A++YGb/6Mf4lVry11PuUT2rlEmQ7St+",
	"HXn/zrAxSQhg7NcKNYqx22mbLYRECopvqNZ+QB+HsvHgXnJyDQbKBRfMMA8PJgPRihc5N05sZW0G7660",
	"/iF57D62tPE1L1jIoZKxVvY481pqZ2l/DEkkyW6ewxWUjmKY0uwQ7/nEsswXDz//eNNfgL4SObDXsKmU",
	"5lqUO/azbB7g3JgVf4vkrXl+iTJ+Q/IUnan5dfdNj05nlehWfwtJRoDZLVtzWZT+Hb6qsaylo010uqoo",
	"7MddYaH6YaU0AkDZJ6GgQAhzwi6aMBEMuqiDmlQQ2aBXBHMq0yQcQ0jIjTjhKpnPtpnjByuQmedI2UIV",
	"O183bKb5td3S2/oB2yM5c4QnDqTA1Fcv6Iw0CnHj4XNrp4ztfmiQaCx+b945hdiAvgq2itaM9fT0FB8S",
	"rZWxpzOnz3dNXPHHdw3mQhnlWaXFFZZ7QaQpLZyaWmbeDtRWTJw9Pnk4+/D/AgAA//+TZLcgSA4BAA==",
}

// GetSwagger returns the content of the embedded swagger specification file
// or error if failed to decode
func decodeSpec() ([]byte, error) {
	zipped, err := base64.StdEncoding.DecodeString(strings.Join(swaggerSpec, ""))
	if err != nil {
		return nil, fmt.Errorf("error base64 decoding spec: %s", err)
	}
	zr, err := gzip.NewReader(bytes.NewReader(zipped))
	if err != nil {
		return nil, fmt.Errorf("error decompressing spec: %s", err)
	}
	var buf bytes.Buffer
	_, err = buf.ReadFrom(zr)
	if err != nil {
		return nil, fmt.Errorf("error decompressing spec: %s", err)
	}

	return buf.Bytes(), nil
}

var rawSpec = decodeSpecCached()

// a naive cached of a decoded swagger spec
func decodeSpecCached() func() ([]byte, error) {
	data, err := decodeSpec()
	return func() ([]byte, error) {
		return data, err
	}
}

// Constructs a synthetic filesystem for resolving external references when loading openapi specifications.
func PathToRawSpec(pathToFile string) map[string]func() ([]byte, error) {
	var res = make(map[string]func() ([]byte, error))
	if len(pathToFile) > 0 {
		res[pathToFile] = rawSpec
	}

	return res
}

// GetSwagger returns the Swagger specification corresponding to the generated code
// in this file. The external references of Swagger specification are resolved.
// The logic of resolving external references is tightly connected to "import-mapping" feature.
// Externally referenced files must be embedded in the corresponding golang packages.
// Urls can be supported but this task was out of the scope.
func GetSwagger() (swagger *openapi3.T, err error) {
	var resolvePath = PathToRawSpec("")

	loader := openapi3.NewLoader()
	loader.IsExternalRefsAllowed = true
	loader.ReadFromURIFunc = func(loader *openapi3.Loader, url *url.URL) ([]byte, error) {
		var pathToFile = url.String()
		pathToFile = path.Clean(pathToFile)
		getSpec, ok := resolvePath[pathToFile]
		if !ok {
			err1 := fmt.Errorf("path not found: %s", pathToFile)
			return nil, err1
		}
		return getSpec()
	}
	var specData []byte
	specData, err = rawSpec()
	if err != nil {
		return
	}
	swagger, err = loader.LoadFromData(specData)
	if err != nil {
		return
	}
	return
}
