// Package data provides primitives to interact with the openapi HTTP API.
//
// Code generated by github.com/algorand/oapi-codegen DO NOT EDIT.
package data

import (
	"bytes"
	"compress/gzip"
	"encoding/base64"
	"fmt"
	"net/http"
	"net/url"
	"path"
	"strings"

	. "github.com/algorand/go-algorand/daemon/algod/api/server/v2/generated/model"
	"github.com/algorand/oapi-codegen/pkg/runtime"
	"github.com/getkin/kin-openapi/openapi3"
	"github.com/labstack/echo/v4"
)

// ServerInterface represents all server handlers.
type ServerInterface interface {
	// Removes minimum sync round restriction from the ledger.
	// (DELETE /v2/ledger/sync)
	UnsetSyncRound(ctx echo.Context) error
	// Returns the minimum sync round the ledger is keeping in cache.
	// (GET /v2/ledger/sync)
	GetSyncRound(ctx echo.Context) error
	// Given a round, tells the ledger to keep that round in its cache.
	// (POST /v2/ledger/sync/{round})
	SetSyncRound(ctx echo.Context, round uint64) error
}

// ServerInterfaceWrapper converts echo contexts to parameters.
type ServerInterfaceWrapper struct {
	Handler ServerInterface
}

// UnsetSyncRound converts echo context to params.
func (w *ServerInterfaceWrapper) UnsetSyncRound(ctx echo.Context) error {
	var err error

	ctx.Set(Api_keyScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.UnsetSyncRound(ctx)
	return err
}

// GetSyncRound converts echo context to params.
func (w *ServerInterfaceWrapper) GetSyncRound(ctx echo.Context) error {
	var err error

	ctx.Set(Api_keyScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetSyncRound(ctx)
	return err
}

// SetSyncRound converts echo context to params.
func (w *ServerInterfaceWrapper) SetSyncRound(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "round" -------------
	var round uint64

	err = runtime.BindStyledParameterWithLocation("simple", false, "round", runtime.ParamLocationPath, ctx.Param("round"), &round)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter round: %s", err))
	}

	ctx.Set(Api_keyScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.SetSyncRound(ctx, round)
	return err
}

// This is a simple interface which specifies echo.Route addition functions which
// are present on both echo.Echo and echo.Group, since we want to allow using
// either of them for path registration
type EchoRouter interface {
	CONNECT(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	DELETE(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	GET(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	HEAD(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	OPTIONS(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	PATCH(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	POST(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	PUT(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	TRACE(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
}

// RegisterHandlers adds each server route to the EchoRouter.
func RegisterHandlers(router EchoRouter, si ServerInterface, m ...echo.MiddlewareFunc) {
	RegisterHandlersWithBaseURL(router, si, "", m...)
}

// Registers handlers, and prepends BaseURL to the paths, so that the paths
// can be served under a prefix.
func RegisterHandlersWithBaseURL(router EchoRouter, si ServerInterface, baseURL string, m ...echo.MiddlewareFunc) {

	wrapper := ServerInterfaceWrapper{
		Handler: si,
	}

	router.DELETE(baseURL+"/v2/ledger/sync", wrapper.UnsetSyncRound, m...)
	router.GET(baseURL+"/v2/ledger/sync", wrapper.GetSyncRound, m...)
	router.POST(baseURL+"/v2/ledger/sync/:round", wrapper.SetSyncRound, m...)

}

// Base64 encoded, gzipped, json marshaled Swagger object
var swaggerSpec = []string{

	"H4sIAAAAAAAC/+x9f5PbtpLgV0Fpt8qxT5yxHSf74qtXexM7yZuNk7gyTvZ2bV8CkS0JbyiADwBnpPj8",
	"3a/QDZAgCUrUzMROrt5f9oj40Wg0Gv0L3e9mudpUSoK0Zvb03azimm/Agsa/eJ6rWtpMFO6vAkyuRWWF",
	"krOn4RszVgu5ms1nwv1acbuezWeSb6Bt4/rPZxr+UQsNxeyp1TXMZyZfw4a7ge2ucq2bkbbZSmV+iDMa",
	"4vz57P2eD7woNBgzhPIHWe6YkHlZF8Cs5tLw3H0y7FrYNbNrYZjvzIRkSgJTS2bXncZsKaAszElY5D9q",
	"0LtolX7y8SW9b0HMtCphCOcztVkICQEqaIBqNoRZxQpYYqM1t8zN4GANDa1iBrjO12yp9AFQCYgYXpD1",
	"Zvb09cyALEDjbuUgrvC/Sw3wG2SW6xXY2dt5anFLCzqzYpNY2rnHvgZTl9YwbItrXIkrkMz1OmHf1cay",
	"BTAu2Y9fP2OffvrpF24hG24tFJ7IRlfVzh6vibrPns4KbiF8HtIaL1dKc1lkTfsfv36G81/4BU5txY2B",
	"9GE5c1/Y+fOxBYSOCRIS0sIK96FD/a5H4lC0Py9gqTRM3BNqfKebEs//UXcl5zZfV0pIm9gXhl8ZfU7y",
	"sKj7Ph7WANBpXzlMaTfo64fZF2/fPZo/evj+X16fZf/t//zs0/cTl/+sGfcABpIN81prkPkuW2ngeFrW",
	"XA7x8aOnB7NWdVmwNb/CzecbZPW+L3N9iXVe8bJ2dCJyrc7KlTKMezIqYMnr0rIwMatl6diUG81TOxOG",
	"VVpdiQKKueO+12uRr1nODQ2B7di1KEtHg7WBYozW0qvbc5jexyhxcN0IH7igPy4y2nUdwARskRtkeakM",
	"ZFYduJ7CjcNlweILpb2rzHGXFXu1BoaTuw902SLupKPpstwxi/taMG4YZ+FqmjOxZDtVs2vcnFJcYn+/",
	"Goe1DXNIw83p3KPu8I6hb4CMBPIWSpXAJSIvnLshyuRSrGoNhl2vwa79nafBVEoaYGrxd8it2/b/uPjh",
	"e6Y0+w6M4St4yfNLBjJXBRQn7HzJpLIRaXhaQhy6nmPr8HClLvm/G+VoYmNWFc8v0zd6KTYisarv+FZs",
	"6g2T9WYB2m1puEKsYhpsreUYQDTiAVLc8O1w0le6ljnufzttR5Zz1CZMVfIdImzDt399OPfgGMbLklUg",
	"CyFXzG7lqBzn5j4MXqZVLYsJYo51expdrKaCXCwFFKwZZQ8kfppD8Ah5HDyt8BWBEwYZBaeZ5QA4ErYJ",
	"mnGn231hFV9BRDIn7CfP3PCrVZcgG0Jnix1+qjRcCVWbptMIjDj1fglcKgtZpWEpEjR24dHhGAy18Rx4",
	"42WgXEnLhYTCMWcEWlkgZjUKUzThfn1neIsvuIHPn4zd8e3Xibu/VP1d37vjk3YbG2V0JBNXp/vqD2xa",
	"sur0n6AfxnMbscro58FGitUrd9ssRYk30d/d/gU01AaZQAcR4W4yYiW5rTU8fSMfuL9Yxi4slwXXhftl",
	"Qz99V5dWXIiV+6mkn16olcgvxGoEmQ2sSYULu23oHzdemh3bbVKveKHUZV3FC8o7iutix86fj20yjXks",
	"YZ412m6seLzaBmXk2B5222zkCJCjuKu4a3gJOw0OWp4v8Z/tEumJL/Vv7p+qKl1vWy1TqHV07K9kNB94",
	"s8JZVZUi5w6JP/rP7qtjAkCKBG9bnOKF+vRdBGKlVQXaChqUV1VWqpyXmbHc4kj/qmE5ezr7l9PW/nJK",
	"3c1pNPkL1+sCOzmRlcSgjFfVEWO8dKKP2cMsHIPGT8gmiO2h0CQkbaIjJeFYcAlXXNqTVmXp8IPmAL/2",
	"M7X4JmmH8N1TwUYRzqjhAgxJwNTwnmER6hmilSFaUSBdlWrR/PDJWVW1GMTvZ1VF+EDpEQQKZrAVxpr7",
	"uHzenqR4nvPnJ+ybeGwUxZUsd+5yIFHD3Q1Lf2v5W6yxLfk1tCPeMwy3U+kTtzUBDU7MvwuKQ7VirUon",
	"9RykFdf4b75tTGbu90md/xwkFuN2nLhQ0fKYIx0Hf4mUm096lDMkHG/uOWFn/b43Ixs3yh6CMectFu+a",
	"ePAXYWFjDlJCBFFETX57uNZ8N/NCYobC3pBMfjJAFFLxlZAI7dypT5Jt+CXth0K8O0IA0+hFREskQTYm",
	"VC9zetSfDOwsfwJqTW1skESdpFoKY1GvxsZsDSUKzlwGgo5J5UaUMWHD9yyigfla84po2X8hsUtI1Oep",
	"EcF6y4t34p2YhDli99FGI1Q3ZssHWWcSEuQaPRi+LFV++Tdu1ndwwhdhrCHt4zRsDbwAzdbcrBMHp0fb",
	"7WhT6Ns1RJpli2iqk2aJL9TK3MESS3UM66qqZ7ws3dRDltVbLQ486SCXJXONGWwEGsy94kgWdtK/2Fc8",
	"XzuxgOW8LOetqUhVWQlXUDqlXUgJes7smtv28OPIQa/Bc2TAMTsLLFqNNzOhiU03tggNbMPxBto4baYq",
	"u30aDmr4BnpSEN6IqkYrQqRonD8Pq4MrkMiTmqER/GaNaK2JBz9xc/tPOLNUtDiyANrgvmvw1/CLDtCu",
	"dXufynYKpQuyWVv3m9AsV5qGoBveT+7+A1y3nYk6P6k0ZH4Iza9AG1661fUWdb8h37s6nQdOZsEtj06m",
	"p8K0AkacA/uheAc6YaX5Af/DS+Y+OynGUVJLPQKFERW5Uwu6mB2qaCbXAO2tim3IlMkqnl8eBeWzdvI0",
	"m5l08r4i66nfQr+IZodebUVh7mqbcLCxveqeELJdBXY0kEX2Mp1orikIeKUqRuyjBwJxChyNEKK2d36t",
	"fam2KZi+VNvBlaa2cCc74caZzOy/VNvnHjKlD2Mex56CdLdAyTdg8HaTMeN0s7R+ubOF0jeTJnoXjGSt",
	"t5FxN2okTM17SMKmdZX5s5nwWFCD3kBtgMd+IaA/fApjHSxcWP47YMG4Ue8CC92B7hoLalOJEu6A9NdJ",
	"IW7BDXz6mF387eyzR49/efzZ544kK61Wmm/YYmfBsE+8WY4ZuyvhflI7QukiPfrnT4KPqjtuahyjap3D",
	"hlfDocj3RdovNWOu3RBrXTTjqhsAJ3FEcFcboZ2RW9eB9hwW9eoCrHWa7kutlnfODQczpKDDRi8r7QQL",
	"0/UTemnptHBNTmFrNT+tsCXIguIM3DqEcTrgZnEnRDW28UU7S8E8Rgs4eCiO3aZ2ml28VXqn67swb4DW",
	"Siev4Eorq3JVZk7OEyphoHjpWzDfImxX1f+doGXX3DA3N3ova1mM2CHsVk6/v2joV1vZ4mbvDUbrTazO",
	"zztlX7rIb7WQCnRmt5IhdXbMI0utNoyzAjuirPENWJK/xAYuLN9UPyyXd2PtVDhQwo4jNmDcTIxaOOnH",
	"QK4kBfMdMNn4Uaegp4+Y4GWy4wB4jFzsZI6usrs4tuPWrI2Q6Lc3O5lHpi0HYwnFqkOWtzdhjaGDprpn",
	"EuA4dLzAz2irfw6l5V8r/aoVX7/Rqq7unD3355y6HO4X470BhesbzMBCrspuAOnKwX6SWuNHWdCzxohA",
	"a0DokSJfiNXaRvriS61+hzsxOUsKUPxAxqLS9RmajL5XhWMmtjZ3IEq2g7UcztFtzNf4QtWWcSZVAbj5",
	"tUkLmSMhhxjrhCFaNpZb0T4hDFuAo66c1261dcUwAGlwX7QdM57TCc0QNWYk/KKJm6FWNB2Fs5UaeLFj",
	"CwDJ1MLHOPjoC1wkx+gpG8Q0L+Im+EUHrkqrHIyBIvOm6IOghXZ0ddg9eELAEeBmFmYUW3J9a2Avrw7C",
	"eQm7DGP9DPvk25/N/Y8Ar1WWlwcQi21S6O3b04ZQT5t+H8H1J4/Jjix1RLVOvHUMogQLYyg8Ciej+9eH",
	"aLCLt0fLFWgMKfldKT5McjsCakD9nen9ttDW1UgEu1fTnYTnNkxyqYJglRqs5MZmh9iya9SxJbgVRJww",
	"xYlx4BHB6wU3lsKghCzQpknXCc5DQpibYhzgUTXEjfxz0ECGY+fuHpSmNo06YuqqUtpCkVoDemRH5/oe",
	"ts1cahmN3eg8VrHawKGRx7AUje+R5TVg/IPbxv/qPbrDxaFP3d3zuyQqO0C0iNgHyEVoFWE3juIdAUSY",
	"FtFEOML0KKcJHZ7PjFVV5biFzWrZ9BtD0wW1PrM/tW2HxEVODrq3CwUGHSi+vYf8mjBL8dtrbpiHI7jY",
	"0ZxD8VpDmN1hzIyQOWT7KB9VPNcqPgIHD2ldrTQvICug5LtEcAB9ZvR53wC44626qyxkFIib3vSWkkPc",
	"456hFY5nUsIjwy8sd0fQqQItgfjeB0YuAMdOMSdPR/eaoXCu5BaF8XDZtNWJEfE2vFLW7binBwTZc/Qp",
	"AI/goRn65qjAzlmre/an+C8wfoJGjjh+kh2YsSW04x+1gBFbsH/jFJ2XHnvvceAk2xxlYwf4yNiRHTFM",
	"v+TailxUqOt8C7s7V/36EyQd56wAy0UJBYs+kBpYxf0ZhZD2x7yZKjjJ9jYEf2B8SywnhOl0gb+EHerc",
	"L+ltQmTquAtdNjGqu5+4ZAhoiHh2InjcBLY8t+XOCWp2DTt2DRqYqRcUwjD0p1hVZfEASf/Mnhm9dzbp",
	"G93rLr7AoaLlpWLNSCfYD9+rnmLQQYfXBSqlygkWsgEykhBMih1hlXK7Lvzzp/AAJlBSB0jPtNE131z/",
	"90wHzbgC9l+qZjmXqHLVFhqZRmkUFFCAdDM4EayZ0wcnthiCEjZAmiR+efCgv/AHD/yeC8OWcB3eDLqG",
	"fXQ8eIB2nJfK2M7hugN7qDtu54nrAx1X7uLzWkifpxyOePIjT9nJl73BG2+XO1PGeMJ1y781A+idzO2U",
	"tcc0Mi3aC8ed5MvpxgcN1o37fiE2dcntXXit4IqXmboCrUUBBzm5n1go+dUVL39ouuF7SMgdjeaQ5fiK",
	"b+JY8Mr1oYd/bhwhhTvAFPQ/FSA4p14X1OmAitlGqorNBgrBLZQ7VmnIgd67OcnRNEs9YRQJn6+5XKHC",
	"oFW98sGtNA4y/NqQaUbXcjBEUqiyW5mhkTt1AfgwtfDk0YlTwJ1K17eQkwJzzZv5/CvXKTdztAd9j0HS",
	"STafjWq8DqlXrcZLyOm+25xwGXTkvQg/7cQTXSmIOif7DPEVb4s7TG5zfx+TfTt0CsrhxFHEb/txLOjX",
	"qdvl7g6EHhqIaag0GLyiYjOVoa9qGb/RDqGCO2NhM7TkU9dfRo7fj6P6opKlkJBtlIRdMi2JkPAdfkwe",
	"J7wmRzqjwDLWt6+DdODvgdWdZwo13ha/uNv9E9r3WJmvlb4rlygNOFm8n+CBPOhu91Pe1E/KyzLhWvQv",
	"OPsMwMybYF2hGTdG5QJltvPCzH1UMHkj/XPPLvpfNu9S7uDs9cft+dDi5ABoI4ayYpzlpUALspLG6jq3",
	"byRHG1W01EQQV1DGx62Wz0KTtJk0YcX0Q72RHAP4GstVMmBjCQkzzdcAwXhp6tUKjO3pOkuAN9K3EpLV",
	"Ulica+OOS0bnpQKNkVQn1HLDd2zpaMIq9htoxRa17Ur/+EDZWFGW3qHnpmFq+UZyy0rgxrLvhHy1xeGC",
	"0z8cWQn2WunLBgvp230FEowwWTrY7Bv6inH9fvlrH+OP4e70OQSdthkTZm6ZnSQp/+eTf3/6+iz7b579",
	"9jD74n+cvn335P39B4MfH7//61//b/enT9//9f6//2tqpwLsqeezHvLz514zPn+O6k8Uqt+H/YPZ/zdC",
	"Zkkii6M5erTFPsFUEZ6A7neNY3YNb6TdSkdIV7wUheMtNyGH/g0zOIt0OnpU09mInjEsrPVIpeIWXIYl",
	"mEyPNd5YihrGZ6YfqqNT0r89x/OyrCVtZZC+6R1miC9Ty3mTjIDylD1l+FJ9zUOQp//z8Wefz+btC/Pm",
	"+2w+81/fJihZFNtUHoECtildMX4kcc+wiu8M2DT3QNiToXQU2xEPu4HNArRZi+rDcwpjxSLN4cKTJW9z",
	"2spzSQH+7vygi3PnPSdq+eHhthqggMquU/mLOoIatmp3E6AXdlJpdQVyzsQJnPRtPoXTF31QXwl8GQJT",
	"tVJTtKHmHBChBaqIsB4vZJJhJUU/vecN/vI3d64O+YFTcPXnTEX03vvmq1fs1DNMc49SWtDQURKChCrt",
	"H092ApIcN4vflL2Rb+RzWKL1Qcmnb2TBLT9dcCNyc1ob0F/yksscTlaKPQ3vMZ9zy9/IgaQ1mlgxejTN",
	"qnpRipxdxgpJS56ULGs4wps3r3m5Um/evB3EZgzVBz9Vkr/QBJkThFVtM5/qJ9NwzXXK92WaVC84MuXy",
	"2jcrCdmqJgNpSCXkx0/zPF5Vpp/yYbj8qird8iMyND6hgdsyZqxq3qM5AcU/6XX7+73yF4Pm18GuUhsw",
	"7NcNr14Lad+y7E398OGn+LKvzYHwq7/yHU3uKphsXRlNSdE3quDCSa3EWPWs4quUi+3Nm9cWeIW7j/Ly",
	"Bm0cZcmwW+fVYXhggEO1C2ieOI9uAMFx9ONgXNwF9QppHdNLwE+4hd0H2Lfar+j9/I2368AbfF7bdebO",
	"dnJVxpF42Jkm29vKCVkhGsOIFWqrPjHeAli+hvzSZyyDTWV38073EPDjBc3AOoShXHb0whCzKaGDYgGs",
	"rgruRXEud/20NoZeVOCgP8Il7F6pNhnTMXlsumlVzNhBRUqNpEtHrPGx9WP0N99HlYWHpj47CT7eDGTx",
	"tKGL0Gf8IJPIeweHOEUUnbQfY4jgOoEIIv4RFNxgoW68W5F+anlC5iCtuIIMSrESi1Qa3v8c+sMCrI4q",
	"feZBH4XcDGiYWDKnyi/oYvXqveZyBe56dleqMrykrKrJoA3Uh9bAtV0At3vt/DJOSBGgQ5XyGl9eo4Vv",
	"7pYAW7ffwqLFTsK10yrQUERtfPTyyXj8GQEOxQ3hCd1bTeFkVNf1qEtkHAy3coPdRq31oXkxnSFc9H0D",
	"mLJUXbt9cVAon22TkrpE90tt+ApGdJfYezcxH0bH44eDHJJIkjKIWvZFjYEkkASZGmduzckzDO6LO8So",
	"ZvYCMsNM5CD2PiNMou0RtihRgG0iV2nvue54USkr8BhoadYCWraiYACji5H4OK65CccR86UGLjtJOvsd",
	"077sS013HsUSRklRm8Rz4Tbsc9CB3u8T1IWsdCEVXaz0T0gr53QvfL6Q2g4lUTQtoIQVLZwaB0JpEya1",
	"G+Tg+GG5RN6SpcISIwN1JAD4OcBpLg8YI98ImzxCiowjsDHwAQdm36v4bMrVMUBKn/CJh7Hxioj+hvTD",
	"PgrUd8KoqtzlKkb8jXngAD4VRStZ9CKqcRgm5Jw5NnfFS8fmvC7eDjLIkIYKRS8fmg+9uT+maOxxTdGV",
	"f9SaSEi4yWpiaTYAnRa190C8UNuMXigndZHFduHoPfl2Ad9Lpw4m5aK7Z9hCbTGcC68WipU/AMs4HAGM",
	"yPayFQbpFfuNyVkEzL5p98u5KSo0SDLe0NqQy5igN2XqEdlyjFw+idLL3QiAnhmqrdXgzRIHzQdd8WR4",
	"mbe32rxNmxqehaWO/9gRSu7SCP6G9rFuQri/tYn/xpOLhRP1QTLhDS1Lt8lQSJ0ryjp4TILCPjl0gNiD",
	"1Zd9OTCJ1m6sVxevEdZSrMQx36FTcog2AyWgEpx1RNPsMhUp4HR5wHv8InSLjHW4e1zu7kcBhBpWwlho",
	"nUYhLuhjmOM5pk9Wajm+OlvppVvfj0o1lz+5zbFjZ5kffAUYgb8U2tgMPW7JJbhGXxs0In3tmqYl0G6I",
	"IhUbEEWa4+K0l7DLClHWaXr183773E37fXPRmHqBt5iQFKC1wOIYycDlPVNTbPveBb+gBb/gd7beaafB",
	"NXUTa0cu3Tn+JOeix8D2sYMEAaaIY7hroyjdwyCjB+dD7hhJo1FMy8k+b8PgMBVh7INRauHZ+9jNTyMl",
	"1xKlAUy/EFSrFRQhvVnwh8koiVyp5Cqq4lRV+3LmnTBKXYeZ5/YkrfNh+DAWhB+J+5mQBWzT0MdaAULe",
	"vqzDhHs4yQokpStJm4WSqIlD/LFFZKv7wL7Q/gOAZBD0q54zu41Opl1qthM3oAReeJ3EQFjf/mM53BCP",
	"uvlY+HQn8+n+I4QDIk0JGxU2GaYhGGHAvKpEse05nmjUUSMYP8q6PCJtIWvxgx3AQDcIOklwnVTaPtTa",
	"G9hPUec9dVoZxV77wGJH3zz3D/CLWqMHoxPZPMzb3uhqE9f+7c8XVmm+Au+FygikWw2ByzkGDVFWdMOs",
	"oHCSQiyXEHtfzE08Bx3gBjb2YgLpJogs7aKphbSfP0mR0QHqaWE8jLI0xSRoYcwn/2ro5QoyfWRKaq6E",
	"aGtu4KpKPtf/FnbZz7ysnZIhtGnDc73bqXv5HrHrV5tvYYcjH4x6dYAd2BW0PP0ISIMpS3/zyUQJrO+Z",
	"Top/VC87W3jETp2ld+mOtsYXZRgn/vaW6RQt6C7lNgejDZJwsEzZjYt0bII7PdBFfJ+UD22CKA7LIJG8",
	"H08lTChhObyKmlwUh2j3FfAyEC8uZ/Z+PrtdJEDqNvMjHsD1y+YCTeIZI03JM9wJ7DkS5byqtLriZebj",
	"JcYuf62u/OWPzUN4xQfWZNKU/eqrsxcvPfjv57O8BK6zxhIwuipsV/1pVkVlHPZfJZTt2xs6yVIUbX6T",
	"kTmOsbjGzN49Y9OgKEobPxMdRR9zsUwHvB/kfT7Uh5a4J+QHqibip/V5UsBPN8iHX3FRBmdjgHYkOB0X",
	"N62yTpIrxAPcOlgoivm69VijjxvevHl9FfDYugkoYKbJr56IoDITDOR9JpI+hC0RH2B9uKQfMANmWrGR",
	"Pj8mcjwfY8TvXEj7WunOHeMfQCZjlH4/6c3J8oTHkZDwUCazL7OdMJLvfl396g79gwfxiX7wYM5+Lf2H",
	"CED8feF/RzXmwYOkkzJpLXO8CI1hkm/gfvOYY3QjPqyeL+F6mhxwdrVpBFg1ToYNhVKwUUD3tcfetRYe",
	"n4X/pYAS3E8nU2wB8aYTumNgppygi7EHj00s64YqcxqmZD90G9/aOtLCO8VXfiCf7/AIyXqDftLMlCJP",
	"R5DIhXHcR1LMpmvMsPGIUdiNWIuREGBZi2gs12xKatYekNEcSWSaZHbYFncL5Y93LcU/amCicMrTUoDG",
	"67N3owYdBEcdyL1p85sfmNxh7fC3MbfscWsFk9M+W8teN+HzxnUVFpqqLXRkoHk844Bx7wkS9/QRbjl8",
	"NLfuRnpOU5emVGgPjM77BEfmSFZcFyZbavUbpC9sdFMl8m0E/6pAa/JvIFMBgn2W0viu28Lx7eyHtnu6",
	"Cj628bdWucOim+JmN7lM06f6uI28iW5t0lmhPZLHdL04kKH7AmGEteDximJusdpKCHLiks4TJZvoPGRL",
	"n8r4yegpjd+eSg/z4Jltya8XPFWKxqlcDqZoezvhWFax0DlsgGlSKdDsLAoUb9oKSlhXgW5dHcPktzdU",
	"n2jayYpTqychRcUa0pyiIUqjEsPU8ppLKlbu+hG/8r0NkKff9bpWGtNNmnTkWAG52CStvm/evC7yYZRQ",
	"IVaC6nDXBqJCz34gRjktkYp8sewmQYhHzfmSPZxH1eb9bhTiShixKAFbPKIWC27wumy87k0XtzyQdm2w",
	"+eMJzde1LDQUdm0IsUaxRsVFIa+Jf1yAvQaQ7CG2e/QF+wQjP424gvsOi14Imj199AXG7dAfD1O3rK+j",
	"vo9lF8izQ0x4mo4x9JXGcEzSj5oO8l5qgN9g/HbYc5qo65SzhC39hXL4LG245CtIPwPZHICJ+uJuYtRA",
	"Dy+SnA5grFY7Jmx6frDc8aeRp+WO/REYLFebjbAbHx9o1MbRU1vFmSYNw2G9s1CWKsAVPmKYbZVQkz+C",
	"GsM3I0/DMBj6e3QFx2idM045RkvRBsCHsqDsPKQwxjpdTXkuwo2byy0dZUmMh1+ySgtp0cxS22X2F6cW",
	"a5479ncyBm62+PxJot5VtySMPA7wD453DQb0VRr1eoTsg8zi+7JPpJLZxnGU4n6byiE6laPxwOnIz7Hw",
	"0/1DT5V83SjZKLnVHXLjEae+FeHJPQPekhSb9RxFj0ev7INTZq3T5MFrt0M//fjCSxkbpVN1Cdrj7iUO",
	"DVYLuMKHeelNcmPeci90OWkXbgP9xw2zCiJnJJaFs5xUBCLH6b43+U6K//m7NsE6+m/pwWPPBqh0wtrp",
	"7XYfOKjxOKtb301McWn4bQRzk9GGowyxMhLkT1H8TZ+PEZbUB4n2vGNwfPQr004HRzn+wQME+sGDuReD",
	"f33c/Uzs/cGDdJ7jpMnN/dpi4TYaMfZN7eGXKmEAC8URm7gln4YhYYAcu6TcB8cEF36oOesWovvwUsTd",
	"PCNLB7WmT8GbN6/xS8AD/tFHxEdmlriB7WOI8cPeLcSZJJmi+R6F03P2pdpOJZzeHRSI5w+AohGUTDTP",
	"4UoGhUaTUQEHw1IiGnWjLqBUTsmMaw/F9vw/D57d4ud7sF2Lsvi59bL2LhLNZb5OBiMvXMdfSEbvXMHE",
	"KpPlTNZcSiiTw5Fu+0vQgRNa+t/V1Hk2Qk5s2y90S8vtLa4FvAtmACpM6NArbOkmiLHazc7VZH8oV6pg",
	"OE9bO6NljsOK0alKnYln1DjsprY+PBafnPu8RktRYrRn2m+MLTPN7UieLiyrHsoYuXGwyrkhMwONDppx",
	"scGL2fBNVQKezCvQfIVdlYRed8zUhiNHhTGYqdwnbIl5MRSztZZMLZfRMkBaoaHczVnFjaFBHrplwRbn",
	"nj199PBh0uyF2JmwUsJiWOYP7VIenWIT+uJrOVHFgaOAPQzr+5aijtnYIeH40pX/qMHYFE/FD/RAFr2k",
	"7tamspVNidUT9g0mWHJE3Mmoj+bKkKu4m7ezrkrFiznmUH711dkLRrNSH6pUT2UzV2it65J/0r0yPY9p",
	"SCA1kqBn+jj7M4a4VRubNVUuUykQXYu2DqfohfagHS/Gzgl7TibUJo6FJmGYiVtvoIiKapISj8Th/mMt",
	"z9dom+xIQOO8cnq918DOWs9N9MixKbKEDNvB7Uu+UsXXOVN2DfpaGMCH/3AF3ayLTQpSbxsPWRi7y9O1",
	"lEQpJ0cIo01JpWPRHoAjSTYEFSQh6yH+SMsUlX0+tvztBfZKP/no1dLtef1DDr+QyZt9550LOZdKihwr",
	"LqQkacwQN81NOaE4Rdq/aGb+hCYOV7KCb/Pk2GNxtKZvYIQecUOXf/TVbSpRB/1pYesru63AGs/ZoJiH",
	"gtreISakAV80yxFRzCeVTgQ1Jd9bNAEUR5IRJn8asXB+7b597+3fmHvjUki0dHm0ef2MXFalEeiZlkxY",
	"tlJg/Hq6j4bMa9fnBJNBFrB9e/JCrUR+IVY4BoXRuWVTaOpwqLMQqOoDQ13bZ66tT9Hf/NwJB6NJz6rK",
	"Tzpebj0pSNqtHEVwKm4pBJJEyG3Gj0fbQ257I8zxPnWEBlcYtQYV3sMDwmhKdndH+crplkRR2ILRw81k",
	"nl4hE2C8EDK4UNMXRJ68EnBj8LyO9DO55pZ0h0k87RXwcuSdBT6EJh/8bYfqFyhwKME1hjnGt7GtNj7C",
	"OJoGrcTP5Y6FQ+GoOxImnvGyidBO1A5HqcoLURTT2qsmnmIcjnFn4WVmB10HXwk23bHox7E30VgqxEVd",
	"rMBmvChSGbS+xK8Mv4a3aLCFvG5qXTWPELup0IfU5ifKlTT1Zs9cocEtp4vK8yeoofkIRbPDmNBnscN/",
	"U4WexnfGx2Yf/fg3BGIXx+X/Hz5mTkm9jqYzI1bZdEzgnXJ7dLRT34zQ2/53SunhVfAf4tFvj8vFe5Ti",
	"b1+5iyPODzyIT6erpUnfi7HgCr+HvEpN4skuV8KrbFDODKMecPMSW9YDPjRMAn7Fy5EH97GvhO5X8h+M",
	"PbvPR7NEcOuzgFnO9rKg0cxKFCvc874MXYhj8cEUHnx3Xgu/1r0IHffdfdvx1FGMWMssRj10N3OitRt8",
	"rBfN1zUYmjR5Wap88qn3w5y5TuNZQ9Vm49NpJ2LYrjaqiOk8joYCSDMtCs9NhPyj7pn8hopR8ou+To/W",
	"sVkcayolNPolzOklYAAvAENTxxNFJlKPWfa1KLEe0n9c/PD9bHwjox0YbqnP4ps0Ko9tTPNYqk8eK9XB",
	"Rz1uO1GyTCkR85kZMXJjrp70afBFb5Mfviaj3RSQKKXNMa1fTB18QAArlUpSP0w5Mms3IqA9ooN2Y4mX",
	"xHSRoodvr8ZSrIQ6P/g9rifkw/PmvowEXAlVh7DK8Lgh2HroV5/Cq1M3aISxJZ8MfWx35Kjz9JWvf03L",
	"9Ma2b3+m8AoG0urdH8CVOtj0flGqhBpLdue2CWtKp04qpdoRd6fUwEqVW/JKXzCCk8zQoaVB+aoBWT2f",
	"IucP8PF+PjsvjpKEUyW7ZjRK6j59IVZrixU//ga8AP3yQEWTtooJHrFKGdFWMC7dYD6F9BqHO5n6isgR",
	"sIgrsgzHCtHlV5BbLFvdRs1qgGPqs7jJgjf3n5VNxu+C5rGVL2iyr4rJsFb1AeF9kHgtSh5IdX5Pptfs",
	"OGveRtDTzmtu2nRPvZwLk19+L5eQY1b1vYnu/nMNMkqiNg8GV4RlGeW9E80DRawLcLw7oQVoXx66vfBE",
	"9bluDc5YHoxL2N0zrEMNycLDzevcmyQeRwyQbzvkoB/zEPlwUGEaykAshFh/n8q9La4zmjM+Stt4w7kC",
	"SbqLo03luGfKID/eYC7X9ai0sSjrj+XCG9ZcHzcsPMcS98ZHvvImcXlsfmPnw8Jb1z7xOaYlbJyiIQU6",
	"mPBbyEFKs5Ti0tcfQayQC/qa6yK0uJOkcnQ3iTTQy2Zm0b7MGkYvJUq54CPHvFROjMjGXop2H0M1kcT3",
	"DIV8twnAEK4laA1F4+sslYHMqvCSax8c+1BBce03QoIZLZ9GwI2mzv+xrQ2AZSQ5psrnPpw9XiDTsOEO",
	"Oh1l8B+fcx+yn9H3kMQjlBE8aDpu6PVwPevwJk+YARJjql8yf1seTg5yEyuykBJ0FlzK/XT+spvREfP2",
	"FnVOF3R8MBpL++TcW3tYSdIAmw9X2dMRouwXl7A7JSUoFAIPOxgDTZITgR4lLO5t8p3a1U0K7tWdgPdx",
	"81BWSpXZiBfzfFiDoE/xlyK/BMwh2rxdcbLfve7ZcJOwT9B51oSpXK93Ied+VYGE4v4JY2eSXguGiJVu",
	"edLe5PKe3Tf/FmctaioL4q3lJ29k+tkVFuzQt+RmYZj9PMyAY3W3nIoGOZDhfivHYumusbhHtwrwyVSt",
	"fBhD0pNKIqIiKFIyyQW5op/hQU8ZjjC3SZSEByMUOPMubGZKlQrSv0n+FTdUGlPxZAiQBTklDUgDhR88",
	"iQAfnncgpaj/HJJmqiXT0EaH3DR7qE/ISazZjGn0/ZmbWbr8bqk0xDNi9CllCm5etGEaXvzPQljN9e4m",
	"OT67qEpZT0axfDDOsgmxbBfShlkOcViW6jpDZpU1dXJSqq1rZ7qXcSja2PZzp3oBUcAmN15Q27E1L1iu",
	"tIY87pF+yE1QbZSGrFQYv5kKLVlaJ3dv8PWmZKVaMVXlqgCqN5WmoLG5aik5ik0QhcslUUC0g2kAqE9E",
	"xxOndHcqOYgzFLUOlmcIm//K9aGUFG1WOFp0RkEKI08RwPgscB5D1HgILxIO5TPq2xLTvHkptkg3oFNH",
	"fsmsrmHOfIt+jX1/8LkGthHGECgNLV2LssSMEGIbhVQ0EUlp1I6IvecYL30lMKiumx2EpOHK3XlNypSY",
	"B1zE+cyYXWtVr9ZRgvoGzqDy6torxPEoP5ka4x7xaaib4gnbKGO9pkkjtUtuY0k/yZW0WpVl1yhFIvrK",
	"W9q/49uzPLcvlLpc8PzyPuq1UtlmpcU8JE7oR/22M+leasLuBZwhDZjDqb6pHcbAeqKdzCB7LG5gFD9k",
	"ZY7AfHuYgx62uZ8NF9ZfV5eZptWYM8m4VRuRp8/UnyuMdjT4NcWikskIqTYrpY/BZnjY48uqiZpCFjlE",
	"M0ieLC55xjwj8NEjyG7cf1EC74/LluAZzchFOWQuXorK8lFZrwcAQko5DWytqaBrLIk1XEWtKAcKxr70",
	"AZ14q2CI4e1gcyPcOVAWbgXUIKy5AfATMj7MKWkkhUgv1DZ8v99mlbwR8O/3U3mHeYzFbl60pKUpejNk",
	"oBrhCOkU+XsDHV9hPovF1HDHpvj2xBs+AmA8ALIDw6QwyGPBWHJRQpGlareeNzaqeaRp+zeX3dr1eC8T",
	"J895HUqnurFrDT4jEon4uuv/qrgjJdU0H1qSZQFboAdbv4FWVBN1HvlfoKSSqT1jgKqyEq6gExfq0zTV",
	"KGqKKwh9TdOZFQAVeiP7NrJUwGN8l/cMJ37tWRQyNwW7SUsKIZZ2ih0wkySNOluZ0TExU4+Sg+hKFDXv",
	"4M8cK3J0zYDuKCdQNdARsqBHTp3mJxrhxzDAWeifEmUCJt5O40NHs6A06vYxoIMB0LUZO/UyHf8c5yBr",
	"HCw4W9E4YonEW75hKn4txw2SQ5Jv1a2J+ySUjBD71RZylGq8vgOF13hGnBQ+nRFSuwQoSCtwXRLW9jVI",
	"JlVUovaam0ZVaZOjhh9oYmwkpNemb+BUbsOUb7+zDAdjppclcVSR0A2d3tw8/1FO4t6DODpeikYM+He9",
	"e+xfgbq92oENVF0WTLr9dLI/Fnn1t5jn4nO2qMNAZamuqeZsrIc+h+AHJeoLLiAvlovmWg7h2HOft7dv",
	"6hDRQ5QN3zGl8R+ndf6j5qVY7pDPEPihGzNr7kjIO14pIsCHd7uJ94tX8wBYsLaoMBWtW0wdMxpu50aJ",
	"gHYXeSgOptiGX0K8DRjsQPwzt45xmnqBlgt3Zfe2c4gFv/iQe2nDi1jTxwywuw53CDnBXe//2T5yjacK",
	"iRurkuehwrAvcdblM1hFPBCXXcNm/yvoIV8LJNBUJm+JVoe0GcUNTKZHsq7U06Kx8k0dsAcVmweVq261",
	"jImW316Nnj3vxyct5a53YWrUzQDouM7rIfDjsrcfBv/J5Mxjy5gC/h8F7yOFrmN4qab1B8ByJ7VOAlay",
	"Vi/UNtOwNIcCTMhc7dR53SblCSZWIXMN3FDEzfkPXvFscw8L6RRhigltfJrNKAUshWyZpZBVbRN6DKYg",
	"lrsIYbHRH9E64kIbkxKcMHnFyx+uQGtRjG2cOx1UEjYuMRMcHb5vwoTR3KnDAYRpdTh8eN2a0eNm7gKn",
	"InYUrmkslwXXRdxcSJaDdvc+u+Y7c3OPUuMcOORT4pE0000HEnmXkLQJkHLnncK39Pc0API7dPxMcNhg",
	"XHDCWUOmHatG/DNDGP4UDpsN32alWuHz4JED4ZNOo4ePVEAl0QxO8tm0dYd5jPgN9k+D9TY8I7IKZ50y",
	"xf5z/wNuJaqRP0lh9558slH232tT3C0dzIBUuWqD/4lYhucx9cTeZ1WKn9kHYTM8VQm0B9Emwoh/qGsX",
	"H9lFDIPw+RliI/j0condSIvUQ36yDGRoMTB7wvvBtKHsPPfhWUNT2sDUQEiZ+zQIR1rayD4f7qUR8NAU",
	"YvxZ707bhMy4cY6pMbk/8UFWqSrLp8R8UkmewrsJPKRdGEfoI3ICjKy7CY8xTZGqTkKzTrWqY8tsjlbL",
	"OuTtqvJ9Sv+YmWiEo3ddEGqJvAyPMBnH8CVPY0yZ99+Ydc1gDZNgnGnIa41m4mu+O1y2cCQV/MXfzj57",
	"9PiXx599zlwDVogVmLacQK/sXxsXKGTf7vNhIwEHy7PpTQhpRQhxwf8YHlU1m+LPGnFb0+YKHhQ9PMa+",
	"nLgAUi99h3XgbrRXOE4b2v/H2q7UIu98x1Io+P33TKuyTJdzaeSqhAMltVuRC8VpIBVoI4x1jLDrARW2",
	"jYg2azQPYlLvK0oTpWQOwX7sqUDYkZCr1ELGAmqRn2HSBu81YrCtSs+ryNOzb11eTyMLHQqNGBWzAFap",
	"yov2YslSEOELIh29rPWGT7SIRzGyDbOlaNkUIfrI8zTpxQX393P7bjFom+b0bhMT4kU4lDcgzTH/xHhC",
	"kptwkta0/4fhH4kMK3fGNZrl/h68Iqkf7HlzfDaIe2iyi0wCbZhtI0EeCMDIa9vOO8nooViUYVyTlwD9",
	"CcGB3Bc/vmsdywefhSAkocMB8OLns2275iWDB+cjp+r+rkFKtJS3Y5TQWf6hF7mB9TYXSbRF3mhiLRhi",
	"S2ooFkbPrc2z5hXziFYyeOyslbLMaaZlmXgkTXYcPFMx4TiVQF/x8sNzja+FNvYM8QHFj+NPo+KXsjGS",
	"CZXmZgk4X/BJc0evYu9uavkSH2b/J7g9St5zfijvhB/cZmjc4SWFVy8bbzRIdo1jUpDVo8/ZwlfRqTTk",
	"wvSd+9dBOGkehoIWSx/QClt74CXqoXX+rOwtyHgZInHY95F7q/HZewjbI/qRmcrIyU1SeYr6BmSRwF+K",
	"R8XFvQ9cF7esuHKzfE5RZsYj8zkNy5ZPXR6lNnGXTm1guM7Jt3UHt4mLul3b1GRkkwu3vHnz2i6m5BBL",
	"F1lx3TGJ2Z1UWzmq1srvkL6McOTH8POmKObnsYTWlLR5JOl+bz9qUR4MWOmUUHg/n60ogxEWCfjFF4X6",
	"sHdpgGAkjZhf+m3SxRBiEmvtTB5NFWV8mlAXwXdLJLPHV415rYXdYUHwYEATvyTzMX3T5PbwuWEaX5q/",
	"+6y6BBniPdpMILUJt+s3ipd4H5GLT7pbSJUn7CtK3e8Pyl/vLf4NPv3Lk+Lhp4/+bfGXh589zOHJZ188",
	"fMi/eMIfffHpI3j8l8+ePIRHy8+/WDwuHj95vHjy+Mnnn32Rf/rk0eLJ51/82z3HhxzIBGio2fF09r+z",
	"s3KlsrOX59krB2yLE16Jb8HtDerKS8xbhkjN8STChoty9jT89L/CCTvJ1aYdPvw684XXZmtrK/P09PT6",
	"+vok7nK6wqf/mVV1vj4N82CKu4688vK8idGnOBzc0dZ6jJvaJP9y33786uIVO3t5ftISzOzp7OHJw5NH",
	"vma95JWYPZ19ij/h6Vnjvp9i4txT42tinDZvtd7PB9+qiipmuE+rJjug+2sNvMQEO+6PDVgt8vBJAy92",
	"/v/mmq9WoE/w9Qb9dPX4NEgjp+985oT3+76dxpEhp+86CSaKAz1D5MOhJqfvQk3s/QN26iH7mLOow0RA",
	"9zU7XWAdrKlNIV7d+FJQjTGn71AQH/391FtT0h9RIaKTdhoStYy0pCf56Y8dFL6zW7eQ/cO5NtF4Obf5",
	"uq5O3+F/8NBEK6LUvad2K0/RgXz6roMI/3mAiO7vbfe4BWalDMCp5ZIKie/7fPqO/o0mgm0FWjhpFLPq",
	"+F8p+9kp1pPcDX/eSe/uLCGVs+YnaYC05VBKZCfz9ulbw0fOi9D4YifzIDaHmEjkDo8fPqTpn+B/Zr7e",
	"Wi+zy6k/zzO6zw8abTrJcpH39ux1Dbz0wA/syQxhePThYDiXFAfpmDFdGu/ns88+JBbOpZNveMmwJU3/",
	"6QfcBNBXIgf2CjaV0lyLcsd+kk0oZ1T9OkWBl1JdywC5kzjqzYbrHUryG3UFhvnC2hFxMg1OdqJwDwwB",
	"aGkYrzzu+MjrWVUvSpHP5pQa+S1KazYluAQj0nCmYEBrB++eim8Ononpu9CVh/ekrJkE54FkBjR8Iqno",
	"YH/D3vddsDTVvdQGzf7JCP7JCO6QEdhay9EjGt1fmHcNKv/ENef5Gvbxg+FtGV3ws0qlEktc7GEWvmzR",
	"GK+46PKKNtRw9vT1tKqe3utBBu0CjDvMJ0GZcZJ6q2vohiOFM48+12iv/QJmT1PV0N7+Ie73Z1yG89zZ",
	"cXJrcl0K0A0VcDmsJPVPLvD/DRegknic9nXOLJSlic++VXj2yQPk02lK8sxN5AOd7KetMN35+TTYLVI6",
	"aLflu86fXb3KrGtbqOtoFrT4k7tqqGW4j7Xp/316zYXNlkr7pJt8aUEPO1vg5akvndX7ta1WMfiCJTii",
	"H+PnpMlfT7lXN1LfkNeNdRzow6mvXuUbaRSioMPn1uoWW7GQzzb2q9dvHZczoK8CC26NMk9PT/FZzFoZ",
	"ezp7P3/XM9jEH982hBWKAs8qLa6weMnb+WybKS1WQvIy81aNtv7f7PHJw9n7/xcAAP//vH26bRYNAQA=",
}

// GetSwagger returns the content of the embedded swagger specification file
// or error if failed to decode
func decodeSpec() ([]byte, error) {
	zipped, err := base64.StdEncoding.DecodeString(strings.Join(swaggerSpec, ""))
	if err != nil {
		return nil, fmt.Errorf("error base64 decoding spec: %s", err)
	}
	zr, err := gzip.NewReader(bytes.NewReader(zipped))
	if err != nil {
		return nil, fmt.Errorf("error decompressing spec: %s", err)
	}
	var buf bytes.Buffer
	_, err = buf.ReadFrom(zr)
	if err != nil {
		return nil, fmt.Errorf("error decompressing spec: %s", err)
	}

	return buf.Bytes(), nil
}

var rawSpec = decodeSpecCached()

// a naive cached of a decoded swagger spec
func decodeSpecCached() func() ([]byte, error) {
	data, err := decodeSpec()
	return func() ([]byte, error) {
		return data, err
	}
}

// Constructs a synthetic filesystem for resolving external references when loading openapi specifications.
func PathToRawSpec(pathToFile string) map[string]func() ([]byte, error) {
	var res = make(map[string]func() ([]byte, error))
	if len(pathToFile) > 0 {
		res[pathToFile] = rawSpec
	}

	return res
}

// GetSwagger returns the Swagger specification corresponding to the generated code
// in this file. The external references of Swagger specification are resolved.
// The logic of resolving external references is tightly connected to "import-mapping" feature.
// Externally referenced files must be embedded in the corresponding golang packages.
// Urls can be supported but this task was out of the scope.
func GetSwagger() (swagger *openapi3.T, err error) {
	var resolvePath = PathToRawSpec("")

	loader := openapi3.NewLoader()
	loader.IsExternalRefsAllowed = true
	loader.ReadFromURIFunc = func(loader *openapi3.Loader, url *url.URL) ([]byte, error) {
		var pathToFile = url.String()
		pathToFile = path.Clean(pathToFile)
		getSpec, ok := resolvePath[pathToFile]
		if !ok {
			err1 := fmt.Errorf("path not found: %s", pathToFile)
			return nil, err1
		}
		return getSpec()
	}
	var specData []byte
	specData, err = rawSpec()
	if err != nil {
		return
	}
	swagger, err = loader.LoadFromData(specData)
	if err != nil {
		return
	}
	return
}
