package crypto

// Code generated by github.com/algorand/msgp DO NOT EDIT.

import (
	_ "runtime/cgo"
	_ "unsafe"

	cfalcon "github.com/algorand/falcon"
	"github.com/algorand/msgp/msgp"
)

// The following msgp objects are implemented in this file:
// Digest
//    |-----> (*) MarshalMsg
//    |-----> (*) CanMarshalMsg
//    |-----> (*) UnmarshalMsg
//    |-----> (*) UnmarshalMsgWithState
//    |-----> (*) CanUnmarshalMsg
//    |-----> (*) Msgsize
//    |-----> (*) MsgIsZero
//    |-----> DigestMaxSize()
//
// FalconPrivateKey
//         |-----> (*) MarshalMsg
//         |-----> (*) CanMarshalMsg
//         |-----> (*) UnmarshalMsg
//         |-----> (*) UnmarshalMsgWithState
//         |-----> (*) CanUnmarshalMsg
//         |-----> (*) Msgsize
//         |-----> (*) MsgIsZero
//         |-----> FalconPrivateKeyMaxSize()
//
// FalconPublicKey
//        |-----> (*) MarshalMsg
//        |-----> (*) CanMarshalMsg
//        |-----> (*) UnmarshalMsg
//        |-----> (*) UnmarshalMsgWithState
//        |-----> (*) CanUnmarshalMsg
//        |-----> (*) Msgsize
//        |-----> (*) MsgIsZero
//        |-----> FalconPublicKeyMaxSize()
//
// FalconSeed
//      |-----> (*) MarshalMsg
//      |-----> (*) CanMarshalMsg
//      |-----> (*) UnmarshalMsg
//      |-----> (*) UnmarshalMsgWithState
//      |-----> (*) CanUnmarshalMsg
//      |-----> (*) Msgsize
//      |-----> (*) MsgIsZero
//      |-----> FalconSeedMaxSize()
//
// FalconSignature
//        |-----> MarshalMsg
//        |-----> CanMarshalMsg
//        |-----> (*) UnmarshalMsg
//        |-----> (*) UnmarshalMsgWithState
//        |-----> (*) CanUnmarshalMsg
//        |-----> Msgsize
//        |-----> MsgIsZero
//        |-----> FalconSignatureMaxSize()
//
// FalconSigner
//       |-----> (*) MarshalMsg
//       |-----> (*) CanMarshalMsg
//       |-----> (*) UnmarshalMsg
//       |-----> (*) UnmarshalMsgWithState
//       |-----> (*) CanUnmarshalMsg
//       |-----> (*) Msgsize
//       |-----> (*) MsgIsZero
//       |-----> FalconSignerMaxSize()
//
// FalconVerifier
//        |-----> (*) MarshalMsg
//        |-----> (*) CanMarshalMsg
//        |-----> (*) UnmarshalMsg
//        |-----> (*) UnmarshalMsgWithState
//        |-----> (*) CanUnmarshalMsg
//        |-----> (*) Msgsize
//        |-----> (*) MsgIsZero
//        |-----> FalconVerifierMaxSize()
//
// GenericDigest
//       |-----> MarshalMsg
//       |-----> CanMarshalMsg
//       |-----> (*) UnmarshalMsg
//       |-----> (*) UnmarshalMsgWithState
//       |-----> (*) CanUnmarshalMsg
//       |-----> Msgsize
//       |-----> MsgIsZero
//       |-----> GenericDigestMaxSize()
//
// HashFactory
//      |-----> (*) MarshalMsg
//      |-----> (*) CanMarshalMsg
//      |-----> (*) UnmarshalMsg
//      |-----> (*) UnmarshalMsgWithState
//      |-----> (*) CanUnmarshalMsg
//      |-----> (*) Msgsize
//      |-----> (*) MsgIsZero
//      |-----> HashFactoryMaxSize()
//
// HashType
//     |-----> MarshalMsg
//     |-----> CanMarshalMsg
//     |-----> (*) UnmarshalMsg
//     |-----> (*) UnmarshalMsgWithState
//     |-----> (*) CanUnmarshalMsg
//     |-----> Msgsize
//     |-----> MsgIsZero
//     |-----> HashTypeMaxSize()
//
// HeartbeatProof
//        |-----> (*) MarshalMsg
//        |-----> (*) CanMarshalMsg
//        |-----> (*) UnmarshalMsg
//        |-----> (*) UnmarshalMsgWithState
//        |-----> (*) CanUnmarshalMsg
//        |-----> (*) Msgsize
//        |-----> (*) MsgIsZero
//        |-----> HeartbeatProofMaxSize()
//
// MasterDerivationKey
//          |-----> (*) MarshalMsg
//          |-----> (*) CanMarshalMsg
//          |-----> (*) UnmarshalMsg
//          |-----> (*) UnmarshalMsgWithState
//          |-----> (*) CanUnmarshalMsg
//          |-----> (*) Msgsize
//          |-----> (*) MsgIsZero
//          |-----> MasterDerivationKeyMaxSize()
//
// MultisigSig
//      |-----> (*) MarshalMsg
//      |-----> (*) CanMarshalMsg
//      |-----> (*) UnmarshalMsg
//      |-----> (*) UnmarshalMsgWithState
//      |-----> (*) CanUnmarshalMsg
//      |-----> (*) Msgsize
//      |-----> (*) MsgIsZero
//      |-----> MultisigSigMaxSize()
//
// MultisigSubsig
//        |-----> (*) MarshalMsg
//        |-----> (*) CanMarshalMsg
//        |-----> (*) UnmarshalMsg
//        |-----> (*) UnmarshalMsgWithState
//        |-----> (*) CanUnmarshalMsg
//        |-----> (*) Msgsize
//        |-----> (*) MsgIsZero
//        |-----> MultisigSubsigMaxSize()
//
// OneTimeSignature
//         |-----> (*) MarshalMsg
//         |-----> (*) CanMarshalMsg
//         |-----> (*) UnmarshalMsg
//         |-----> (*) UnmarshalMsgWithState
//         |-----> (*) CanUnmarshalMsg
//         |-----> (*) Msgsize
//         |-----> (*) MsgIsZero
//         |-----> OneTimeSignatureMaxSize()
//
// OneTimeSignatureSecrets
//            |-----> (*) MarshalMsg
//            |-----> (*) CanMarshalMsg
//            |-----> (*) UnmarshalMsg
//            |-----> (*) UnmarshalMsgWithState
//            |-----> (*) CanUnmarshalMsg
//            |-----> (*) Msgsize
//            |-----> (*) MsgIsZero
//            |-----> OneTimeSignatureSecretsMaxSize()
//
// OneTimeSignatureSecretsPersistent
//                 |-----> (*) MarshalMsg
//                 |-----> (*) CanMarshalMsg
//                 |-----> (*) UnmarshalMsg
//                 |-----> (*) UnmarshalMsgWithState
//                 |-----> (*) CanUnmarshalMsg
//                 |-----> (*) Msgsize
//                 |-----> (*) MsgIsZero
//                 |-----> OneTimeSignatureSecretsPersistentMaxSize()
//
// OneTimeSignatureSubkeyBatchID
//               |-----> (*) MarshalMsg
//               |-----> (*) CanMarshalMsg
//               |-----> (*) UnmarshalMsg
//               |-----> (*) UnmarshalMsgWithState
//               |-----> (*) CanUnmarshalMsg
//               |-----> (*) Msgsize
//               |-----> (*) MsgIsZero
//               |-----> OneTimeSignatureSubkeyBatchIDMaxSize()
//
// OneTimeSignatureSubkeyOffsetID
//                |-----> (*) MarshalMsg
//                |-----> (*) CanMarshalMsg
//                |-----> (*) UnmarshalMsg
//                |-----> (*) UnmarshalMsgWithState
//                |-----> (*) CanUnmarshalMsg
//                |-----> (*) Msgsize
//                |-----> (*) MsgIsZero
//                |-----> OneTimeSignatureSubkeyOffsetIDMaxSize()
//
// OneTimeSignatureVerifier
//             |-----> (*) MarshalMsg
//             |-----> (*) CanMarshalMsg
//             |-----> (*) UnmarshalMsg
//             |-----> (*) UnmarshalMsgWithState
//             |-----> (*) CanUnmarshalMsg
//             |-----> (*) Msgsize
//             |-----> (*) MsgIsZero
//             |-----> OneTimeSignatureVerifierMaxSize()
//
// PrivateKey
//      |-----> (*) MarshalMsg
//      |-----> (*) CanMarshalMsg
//      |-----> (*) UnmarshalMsg
//      |-----> (*) UnmarshalMsgWithState
//      |-----> (*) CanUnmarshalMsg
//      |-----> (*) Msgsize
//      |-----> (*) MsgIsZero
//      |-----> PrivateKeyMaxSize()
//
// PublicKey
//     |-----> (*) MarshalMsg
//     |-----> (*) CanMarshalMsg
//     |-----> (*) UnmarshalMsg
//     |-----> (*) UnmarshalMsgWithState
//     |-----> (*) CanUnmarshalMsg
//     |-----> (*) Msgsize
//     |-----> (*) MsgIsZero
//     |-----> PublicKeyMaxSize()
//
// Seed
//   |-----> (*) MarshalMsg
//   |-----> (*) CanMarshalMsg
//   |-----> (*) UnmarshalMsg
//   |-----> (*) UnmarshalMsgWithState
//   |-----> (*) CanUnmarshalMsg
//   |-----> (*) Msgsize
//   |-----> (*) MsgIsZero
//   |-----> SeedMaxSize()
//
// Signature
//     |-----> (*) MarshalMsg
//     |-----> (*) CanMarshalMsg
//     |-----> (*) UnmarshalMsg
//     |-----> (*) UnmarshalMsgWithState
//     |-----> (*) CanUnmarshalMsg
//     |-----> (*) Msgsize
//     |-----> (*) MsgIsZero
//     |-----> SignatureMaxSize()
//
// SignatureSecrets
//         |-----> (*) MarshalMsg
//         |-----> (*) CanMarshalMsg
//         |-----> (*) UnmarshalMsg
//         |-----> (*) UnmarshalMsgWithState
//         |-----> (*) CanUnmarshalMsg
//         |-----> (*) Msgsize
//         |-----> (*) MsgIsZero
//         |-----> SignatureSecretsMaxSize()
//
// VRFSecrets
//      |-----> (*) MarshalMsg
//      |-----> (*) CanMarshalMsg
//      |-----> (*) UnmarshalMsg
//      |-----> (*) UnmarshalMsgWithState
//      |-----> (*) CanUnmarshalMsg
//      |-----> (*) Msgsize
//      |-----> (*) MsgIsZero
//      |-----> VRFSecretsMaxSize()
//
// VrfOutput
//     |-----> (*) MarshalMsg
//     |-----> (*) CanMarshalMsg
//     |-----> (*) UnmarshalMsg
//     |-----> (*) UnmarshalMsgWithState
//     |-----> (*) CanUnmarshalMsg
//     |-----> (*) Msgsize
//     |-----> (*) MsgIsZero
//     |-----> VrfOutputMaxSize()
//
// VrfPrivkey
//      |-----> (*) MarshalMsg
//      |-----> (*) CanMarshalMsg
//      |-----> (*) UnmarshalMsg
//      |-----> (*) UnmarshalMsgWithState
//      |-----> (*) CanUnmarshalMsg
//      |-----> (*) Msgsize
//      |-----> (*) MsgIsZero
//      |-----> VrfPrivkeyMaxSize()
//
// VrfProof
//     |-----> (*) MarshalMsg
//     |-----> (*) CanMarshalMsg
//     |-----> (*) UnmarshalMsg
//     |-----> (*) UnmarshalMsgWithState
//     |-----> (*) CanUnmarshalMsg
//     |-----> (*) Msgsize
//     |-----> (*) MsgIsZero
//     |-----> VrfProofMaxSize()
//
// VrfPubkey
//     |-----> (*) MarshalMsg
//     |-----> (*) CanMarshalMsg
//     |-----> (*) UnmarshalMsg
//     |-----> (*) UnmarshalMsgWithState
//     |-----> (*) CanUnmarshalMsg
//     |-----> (*) Msgsize
//     |-----> (*) MsgIsZero
//     |-----> VrfPubkeyMaxSize()
//
// ed25519PrivateKey
//         |-----> (*) MarshalMsg
//         |-----> (*) CanMarshalMsg
//         |-----> (*) UnmarshalMsg
//         |-----> (*) UnmarshalMsgWithState
//         |-----> (*) CanUnmarshalMsg
//         |-----> (*) Msgsize
//         |-----> (*) MsgIsZero
//         |-----> Ed25519PrivateKeyMaxSize()
//
// ed25519PublicKey
//         |-----> (*) MarshalMsg
//         |-----> (*) CanMarshalMsg
//         |-----> (*) UnmarshalMsg
//         |-----> (*) UnmarshalMsgWithState
//         |-----> (*) CanUnmarshalMsg
//         |-----> (*) Msgsize
//         |-----> (*) MsgIsZero
//         |-----> Ed25519PublicKeyMaxSize()
//
// ed25519Seed
//      |-----> (*) MarshalMsg
//      |-----> (*) CanMarshalMsg
//      |-----> (*) UnmarshalMsg
//      |-----> (*) UnmarshalMsgWithState
//      |-----> (*) CanUnmarshalMsg
//      |-----> (*) Msgsize
//      |-----> (*) MsgIsZero
//      |-----> Ed25519SeedMaxSize()
//
// ed25519Signature
//         |-----> (*) MarshalMsg
//         |-----> (*) CanMarshalMsg
//         |-----> (*) UnmarshalMsg
//         |-----> (*) UnmarshalMsgWithState
//         |-----> (*) CanUnmarshalMsg
//         |-----> (*) Msgsize
//         |-----> (*) MsgIsZero
//         |-----> Ed25519SignatureMaxSize()
//
// ephemeralSubkey
//        |-----> (*) MarshalMsg
//        |-----> (*) CanMarshalMsg
//        |-----> (*) UnmarshalMsg
//        |-----> (*) UnmarshalMsgWithState
//        |-----> (*) CanUnmarshalMsg
//        |-----> (*) Msgsize
//        |-----> (*) MsgIsZero
//        |-----> EphemeralSubkeyMaxSize()
//

// MarshalMsg implements msgp.Marshaler
func (z *Digest) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	o = msgp.AppendBytes(o, (*z)[:])
	return
}

func (_ *Digest) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*Digest)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *Digest) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	bts, err = msgp.ReadExactBytes(bts, (*z)[:])
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	o = bts
	return
}

func (z *Digest) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *Digest) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*Digest)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *Digest) Msgsize() (s int) {
	s = msgp.ArrayHeaderSize + (DigestSize * (msgp.ByteSize))
	return
}

// MsgIsZero returns whether this is a zero value
func (z *Digest) MsgIsZero() bool {
	return (*z) == (Digest{})
}

// MaxSize returns a maximum valid message size for this message type
func DigestMaxSize() (s int) {
	// Calculating size of array: z
	s = msgp.ArrayHeaderSize + ((DigestSize) * (msgp.ByteSize))
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *FalconPrivateKey) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	o = msgp.AppendBytes(o, (*z)[:])
	return
}

func (_ *FalconPrivateKey) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*FalconPrivateKey)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *FalconPrivateKey) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	bts, err = msgp.ReadExactBytes(bts, (*z)[:])
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	o = bts
	return
}

func (z *FalconPrivateKey) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *FalconPrivateKey) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*FalconPrivateKey)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *FalconPrivateKey) Msgsize() (s int) {
	s = msgp.ArrayHeaderSize + (cfalcon.PrivateKeySize * (msgp.ByteSize))
	return
}

// MsgIsZero returns whether this is a zero value
func (z *FalconPrivateKey) MsgIsZero() bool {
	return (*z) == (FalconPrivateKey{})
}

// MaxSize returns a maximum valid message size for this message type
func FalconPrivateKeyMaxSize() (s int) {
	// Calculating size of array: z
	s = msgp.ArrayHeaderSize + ((cfalcon.PrivateKeySize) * (msgp.ByteSize))
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *FalconPublicKey) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	o = msgp.AppendBytes(o, (*z)[:])
	return
}

func (_ *FalconPublicKey) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*FalconPublicKey)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *FalconPublicKey) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	bts, err = msgp.ReadExactBytes(bts, (*z)[:])
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	o = bts
	return
}

func (z *FalconPublicKey) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *FalconPublicKey) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*FalconPublicKey)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *FalconPublicKey) Msgsize() (s int) {
	s = msgp.ArrayHeaderSize + (cfalcon.PublicKeySize * (msgp.ByteSize))
	return
}

// MsgIsZero returns whether this is a zero value
func (z *FalconPublicKey) MsgIsZero() bool {
	return (*z) == (FalconPublicKey{})
}

// MaxSize returns a maximum valid message size for this message type
func FalconPublicKeyMaxSize() (s int) {
	// Calculating size of array: z
	s = msgp.ArrayHeaderSize + ((cfalcon.PublicKeySize) * (msgp.ByteSize))
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *FalconSeed) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	o = msgp.AppendBytes(o, (*z)[:])
	return
}

func (_ *FalconSeed) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*FalconSeed)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *FalconSeed) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	bts, err = msgp.ReadExactBytes(bts, (*z)[:])
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	o = bts
	return
}

func (z *FalconSeed) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *FalconSeed) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*FalconSeed)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *FalconSeed) Msgsize() (s int) {
	s = msgp.ArrayHeaderSize + (FalconSeedSize * (msgp.ByteSize))
	return
}

// MsgIsZero returns whether this is a zero value
func (z *FalconSeed) MsgIsZero() bool {
	return (*z) == (FalconSeed{})
}

// MaxSize returns a maximum valid message size for this message type
func FalconSeedMaxSize() (s int) {
	// Calculating size of array: z
	s = msgp.ArrayHeaderSize + ((FalconSeedSize) * (msgp.ByteSize))
	return
}

// MarshalMsg implements msgp.Marshaler
func (z FalconSignature) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	o = msgp.AppendBytes(o, []byte(z))
	return
}

func (_ FalconSignature) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(FalconSignature)
	if !ok {
		_, ok = (z).(*FalconSignature)
	}
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *FalconSignature) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	{
		var zb0001 []byte
		var zb0002 int
		zb0002, err = msgp.ReadBytesBytesHeader(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 > FalconMaxSignatureSize {
			err = msgp.ErrOverflow(uint64(zb0002), uint64(FalconMaxSignatureSize))
			return
		}
		zb0001, bts, err = msgp.ReadBytesBytes(bts, []byte((*z)))
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		(*z) = FalconSignature(zb0001)
	}
	o = bts
	return
}

func (z *FalconSignature) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *FalconSignature) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*FalconSignature)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z FalconSignature) Msgsize() (s int) {
	s = msgp.BytesPrefixSize + len([]byte(z))
	return
}

// MsgIsZero returns whether this is a zero value
func (z FalconSignature) MsgIsZero() bool {
	return len(z) == 0
}

// MaxSize returns a maximum valid message size for this message type
func FalconSignatureMaxSize() (s int) {
	s = msgp.BytesPrefixSize + FalconMaxSignatureSize
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *FalconSigner) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0003Len := uint32(2)
	var zb0003Mask uint8 /* 3 bits */
	if (*z).PublicKey == (FalconPublicKey{}) {
		zb0003Len--
		zb0003Mask |= 0x2
	}
	if (*z).PrivateKey == (FalconPrivateKey{}) {
		zb0003Len--
		zb0003Mask |= 0x4
	}
	// variable map header, size zb0003Len
	o = append(o, 0x80|uint8(zb0003Len))
	if zb0003Len != 0 {
		if (zb0003Mask & 0x2) == 0 { // if not empty
			// string "pk"
			o = append(o, 0xa2, 0x70, 0x6b)
			o = msgp.AppendBytes(o, ((*z).PublicKey)[:])
		}
		if (zb0003Mask & 0x4) == 0 { // if not empty
			// string "sk"
			o = append(o, 0xa2, 0x73, 0x6b)
			o = msgp.AppendBytes(o, ((*z).PrivateKey)[:])
		}
	}
	return
}

func (_ *FalconSigner) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*FalconSigner)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *FalconSigner) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0003 int
	var zb0004 bool
	zb0003, zb0004, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0003, zb0004, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0003 > 0 {
			zb0003--
			bts, err = msgp.ReadExactBytes(bts, ((*z).PublicKey)[:])
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "PublicKey")
				return
			}
		}
		if zb0003 > 0 {
			zb0003--
			bts, err = msgp.ReadExactBytes(bts, ((*z).PrivateKey)[:])
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "PrivateKey")
				return
			}
		}
		if zb0003 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0003)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0004 {
			(*z) = FalconSigner{}
		}
		for zb0003 > 0 {
			zb0003--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "pk":
				bts, err = msgp.ReadExactBytes(bts, ((*z).PublicKey)[:])
				if err != nil {
					err = msgp.WrapError(err, "PublicKey")
					return
				}
			case "sk":
				bts, err = msgp.ReadExactBytes(bts, ((*z).PrivateKey)[:])
				if err != nil {
					err = msgp.WrapError(err, "PrivateKey")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *FalconSigner) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *FalconSigner) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*FalconSigner)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *FalconSigner) Msgsize() (s int) {
	s = 1 + 3 + msgp.ArrayHeaderSize + (cfalcon.PublicKeySize * (msgp.ByteSize)) + 3 + msgp.ArrayHeaderSize + (cfalcon.PrivateKeySize * (msgp.ByteSize))
	return
}

// MsgIsZero returns whether this is a zero value
func (z *FalconSigner) MsgIsZero() bool {
	return ((*z).PublicKey == (FalconPublicKey{})) && ((*z).PrivateKey == (FalconPrivateKey{}))
}

// MaxSize returns a maximum valid message size for this message type
func FalconSignerMaxSize() (s int) {
	s = 1 + 3
	// Calculating size of array: z.PublicKey
	s += msgp.ArrayHeaderSize + ((cfalcon.PublicKeySize) * (msgp.ByteSize))
	s += 3
	// Calculating size of array: z.PrivateKey
	s += msgp.ArrayHeaderSize + ((cfalcon.PrivateKeySize) * (msgp.ByteSize))
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *FalconVerifier) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0002Len := uint32(1)
	var zb0002Mask uint8 /* 2 bits */
	if (*z).PublicKey == (FalconPublicKey{}) {
		zb0002Len--
		zb0002Mask |= 0x2
	}
	// variable map header, size zb0002Len
	o = append(o, 0x80|uint8(zb0002Len))
	if zb0002Len != 0 {
		if (zb0002Mask & 0x2) == 0 { // if not empty
			// string "k"
			o = append(o, 0xa1, 0x6b)
			o = msgp.AppendBytes(o, ((*z).PublicKey)[:])
		}
	}
	return
}

func (_ *FalconVerifier) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*FalconVerifier)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *FalconVerifier) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0002 int
	var zb0003 bool
	zb0002, zb0003, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0002, zb0003, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 > 0 {
			zb0002--
			bts, err = msgp.ReadExactBytes(bts, ((*z).PublicKey)[:])
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "PublicKey")
				return
			}
		}
		if zb0002 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0002)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0003 {
			(*z) = FalconVerifier{}
		}
		for zb0002 > 0 {
			zb0002--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "k":
				bts, err = msgp.ReadExactBytes(bts, ((*z).PublicKey)[:])
				if err != nil {
					err = msgp.WrapError(err, "PublicKey")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *FalconVerifier) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *FalconVerifier) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*FalconVerifier)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *FalconVerifier) Msgsize() (s int) {
	s = 1 + 2 + msgp.ArrayHeaderSize + (cfalcon.PublicKeySize * (msgp.ByteSize))
	return
}

// MsgIsZero returns whether this is a zero value
func (z *FalconVerifier) MsgIsZero() bool {
	return ((*z).PublicKey == (FalconPublicKey{}))
}

// MaxSize returns a maximum valid message size for this message type
func FalconVerifierMaxSize() (s int) {
	s = 1 + 2
	// Calculating size of array: z.PublicKey
	s += msgp.ArrayHeaderSize + ((cfalcon.PublicKeySize) * (msgp.ByteSize))
	return
}

// MarshalMsg implements msgp.Marshaler
func (z GenericDigest) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	o = msgp.AppendBytes(o, []byte(z))
	return
}

func (_ GenericDigest) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(GenericDigest)
	if !ok {
		_, ok = (z).(*GenericDigest)
	}
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *GenericDigest) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	{
		var zb0001 []byte
		var zb0002 int
		zb0002, err = msgp.ReadBytesBytesHeader(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 > MaxHashDigestSize {
			err = msgp.ErrOverflow(uint64(zb0002), uint64(MaxHashDigestSize))
			return
		}
		zb0001, bts, err = msgp.ReadBytesBytes(bts, []byte((*z)))
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		(*z) = GenericDigest(zb0001)
	}
	o = bts
	return
}

func (z *GenericDigest) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *GenericDigest) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*GenericDigest)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z GenericDigest) Msgsize() (s int) {
	s = msgp.BytesPrefixSize + len([]byte(z))
	return
}

// MsgIsZero returns whether this is a zero value
func (z GenericDigest) MsgIsZero() bool {
	return len(z) == 0
}

// MaxSize returns a maximum valid message size for this message type
func GenericDigestMaxSize() (s int) {
	s = msgp.BytesPrefixSize + MaxHashDigestSize
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *HashFactory) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0001Len := uint32(1)
	var zb0001Mask uint8 /* 2 bits */
	if (*z).HashType == 0 {
		zb0001Len--
		zb0001Mask |= 0x2
	}
	// variable map header, size zb0001Len
	o = append(o, 0x80|uint8(zb0001Len))
	if zb0001Len != 0 {
		if (zb0001Mask & 0x2) == 0 { // if not empty
			// string "t"
			o = append(o, 0xa1, 0x74)
			o = msgp.AppendUint16(o, uint16((*z).HashType))
		}
	}
	return
}

func (_ *HashFactory) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*HashFactory)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *HashFactory) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0001 int
	var zb0002 bool
	zb0001, zb0002, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0001, zb0002, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0001 > 0 {
			zb0001--
			{
				var zb0003 uint16
				zb0003, bts, err = msgp.ReadUint16Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "HashType")
					return
				}
				(*z).HashType = HashType(zb0003)
			}
		}
		if zb0001 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0001)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 {
			(*z) = HashFactory{}
		}
		for zb0001 > 0 {
			zb0001--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "t":
				{
					var zb0004 uint16
					zb0004, bts, err = msgp.ReadUint16Bytes(bts)
					if err != nil {
						err = msgp.WrapError(err, "HashType")
						return
					}
					(*z).HashType = HashType(zb0004)
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	if err = z.Validate(); err != nil {
		return
	}
	return
}

func (z *HashFactory) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *HashFactory) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*HashFactory)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *HashFactory) Msgsize() (s int) {
	s = 1 + 2 + msgp.Uint16Size
	return
}

// MsgIsZero returns whether this is a zero value
func (z *HashFactory) MsgIsZero() bool {
	return ((*z).HashType == 0)
}

// MaxSize returns a maximum valid message size for this message type
func HashFactoryMaxSize() (s int) {
	s = 1 + 2 + msgp.Uint16Size
	return
}

// MarshalMsg implements msgp.Marshaler
func (z HashType) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	o = msgp.AppendUint16(o, uint16(z))
	return
}

func (_ HashType) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(HashType)
	if !ok {
		_, ok = (z).(*HashType)
	}
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *HashType) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	{
		var zb0001 uint16
		zb0001, bts, err = msgp.ReadUint16Bytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		(*z) = HashType(zb0001)
	}
	o = bts
	return
}

func (z *HashType) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *HashType) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*HashType)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z HashType) Msgsize() (s int) {
	s = msgp.Uint16Size
	return
}

// MsgIsZero returns whether this is a zero value
func (z HashType) MsgIsZero() bool {
	return z == 0
}

// MaxSize returns a maximum valid message size for this message type
func HashTypeMaxSize() (s int) {
	s = msgp.Uint16Size
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *HeartbeatProof) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0006Len := uint32(5)
	var zb0006Mask uint8 /* 6 bits */
	if (*z).PK == (ed25519PublicKey{}) {
		zb0006Len--
		zb0006Mask |= 0x2
	}
	if (*z).PK1Sig == (ed25519Signature{}) {
		zb0006Len--
		zb0006Mask |= 0x4
	}
	if (*z).PK2 == (ed25519PublicKey{}) {
		zb0006Len--
		zb0006Mask |= 0x8
	}
	if (*z).PK2Sig == (ed25519Signature{}) {
		zb0006Len--
		zb0006Mask |= 0x10
	}
	if (*z).Sig == (ed25519Signature{}) {
		zb0006Len--
		zb0006Mask |= 0x20
	}
	// variable map header, size zb0006Len
	o = append(o, 0x80|uint8(zb0006Len))
	if zb0006Len != 0 {
		if (zb0006Mask & 0x2) == 0 { // if not empty
			// string "p"
			o = append(o, 0xa1, 0x70)
			o = msgp.AppendBytes(o, ((*z).PK)[:])
		}
		if (zb0006Mask & 0x4) == 0 { // if not empty
			// string "p1s"
			o = append(o, 0xa3, 0x70, 0x31, 0x73)
			o = msgp.AppendBytes(o, ((*z).PK1Sig)[:])
		}
		if (zb0006Mask & 0x8) == 0 { // if not empty
			// string "p2"
			o = append(o, 0xa2, 0x70, 0x32)
			o = msgp.AppendBytes(o, ((*z).PK2)[:])
		}
		if (zb0006Mask & 0x10) == 0 { // if not empty
			// string "p2s"
			o = append(o, 0xa3, 0x70, 0x32, 0x73)
			o = msgp.AppendBytes(o, ((*z).PK2Sig)[:])
		}
		if (zb0006Mask & 0x20) == 0 { // if not empty
			// string "s"
			o = append(o, 0xa1, 0x73)
			o = msgp.AppendBytes(o, ((*z).Sig)[:])
		}
	}
	return
}

func (_ *HeartbeatProof) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*HeartbeatProof)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *HeartbeatProof) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0006 int
	var zb0007 bool
	zb0006, zb0007, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0006, zb0007, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0006 > 0 {
			zb0006--
			bts, err = msgp.ReadExactBytes(bts, ((*z).Sig)[:])
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Sig")
				return
			}
		}
		if zb0006 > 0 {
			zb0006--
			bts, err = msgp.ReadExactBytes(bts, ((*z).PK)[:])
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "PK")
				return
			}
		}
		if zb0006 > 0 {
			zb0006--
			bts, err = msgp.ReadExactBytes(bts, ((*z).PK2)[:])
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "PK2")
				return
			}
		}
		if zb0006 > 0 {
			zb0006--
			bts, err = msgp.ReadExactBytes(bts, ((*z).PK1Sig)[:])
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "PK1Sig")
				return
			}
		}
		if zb0006 > 0 {
			zb0006--
			bts, err = msgp.ReadExactBytes(bts, ((*z).PK2Sig)[:])
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "PK2Sig")
				return
			}
		}
		if zb0006 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0006)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0007 {
			(*z) = HeartbeatProof{}
		}
		for zb0006 > 0 {
			zb0006--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "s":
				bts, err = msgp.ReadExactBytes(bts, ((*z).Sig)[:])
				if err != nil {
					err = msgp.WrapError(err, "Sig")
					return
				}
			case "p":
				bts, err = msgp.ReadExactBytes(bts, ((*z).PK)[:])
				if err != nil {
					err = msgp.WrapError(err, "PK")
					return
				}
			case "p2":
				bts, err = msgp.ReadExactBytes(bts, ((*z).PK2)[:])
				if err != nil {
					err = msgp.WrapError(err, "PK2")
					return
				}
			case "p1s":
				bts, err = msgp.ReadExactBytes(bts, ((*z).PK1Sig)[:])
				if err != nil {
					err = msgp.WrapError(err, "PK1Sig")
					return
				}
			case "p2s":
				bts, err = msgp.ReadExactBytes(bts, ((*z).PK2Sig)[:])
				if err != nil {
					err = msgp.WrapError(err, "PK2Sig")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *HeartbeatProof) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *HeartbeatProof) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*HeartbeatProof)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *HeartbeatProof) Msgsize() (s int) {
	s = 1 + 2 + msgp.ArrayHeaderSize + (64 * (msgp.ByteSize)) + 2 + msgp.ArrayHeaderSize + (32 * (msgp.ByteSize)) + 3 + msgp.ArrayHeaderSize + (32 * (msgp.ByteSize)) + 4 + msgp.ArrayHeaderSize + (64 * (msgp.ByteSize)) + 4 + msgp.ArrayHeaderSize + (64 * (msgp.ByteSize))
	return
}

// MsgIsZero returns whether this is a zero value
func (z *HeartbeatProof) MsgIsZero() bool {
	return ((*z).Sig == (ed25519Signature{})) && ((*z).PK == (ed25519PublicKey{})) && ((*z).PK2 == (ed25519PublicKey{})) && ((*z).PK1Sig == (ed25519Signature{})) && ((*z).PK2Sig == (ed25519Signature{}))
}

// MaxSize returns a maximum valid message size for this message type
func HeartbeatProofMaxSize() (s int) {
	s = 1 + 2
	// Calculating size of array: z.Sig
	s += msgp.ArrayHeaderSize + ((64) * (msgp.ByteSize))
	s += 2
	// Calculating size of array: z.PK
	s += msgp.ArrayHeaderSize + ((32) * (msgp.ByteSize))
	s += 3
	// Calculating size of array: z.PK2
	s += msgp.ArrayHeaderSize + ((32) * (msgp.ByteSize))
	s += 4
	// Calculating size of array: z.PK1Sig
	s += msgp.ArrayHeaderSize + ((64) * (msgp.ByteSize))
	s += 4
	// Calculating size of array: z.PK2Sig
	s += msgp.ArrayHeaderSize + ((64) * (msgp.ByteSize))
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *MasterDerivationKey) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	o = msgp.AppendBytes(o, (*z)[:])
	return
}

func (_ *MasterDerivationKey) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*MasterDerivationKey)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *MasterDerivationKey) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	bts, err = msgp.ReadExactBytes(bts, (*z)[:])
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	o = bts
	return
}

func (z *MasterDerivationKey) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *MasterDerivationKey) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*MasterDerivationKey)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *MasterDerivationKey) Msgsize() (s int) {
	s = msgp.ArrayHeaderSize + (masterDerivationKeyLenBytes * (msgp.ByteSize))
	return
}

// MsgIsZero returns whether this is a zero value
func (z *MasterDerivationKey) MsgIsZero() bool {
	return (*z) == (MasterDerivationKey{})
}

// MaxSize returns a maximum valid message size for this message type
func MasterDerivationKeyMaxSize() (s int) {
	// Calculating size of array: z
	s = msgp.ArrayHeaderSize + ((masterDerivationKeyLenBytes) * (msgp.ByteSize))
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *MultisigSig) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0002Len := uint32(3)
	var zb0002Mask uint8 /* 4 bits */
	if len((*z).Subsigs) == 0 {
		zb0002Len--
		zb0002Mask |= 0x2
	}
	if (*z).Threshold == 0 {
		zb0002Len--
		zb0002Mask |= 0x4
	}
	if (*z).Version == 0 {
		zb0002Len--
		zb0002Mask |= 0x8
	}
	// variable map header, size zb0002Len
	o = append(o, 0x80|uint8(zb0002Len))
	if zb0002Len != 0 {
		if (zb0002Mask & 0x2) == 0 { // if not empty
			// string "subsig"
			o = append(o, 0xa6, 0x73, 0x75, 0x62, 0x73, 0x69, 0x67)
			if (*z).Subsigs == nil {
				o = msgp.AppendNil(o)
			} else {
				o = msgp.AppendArrayHeader(o, uint32(len((*z).Subsigs)))
			}
			for zb0001 := range (*z).Subsigs {
				o = (*z).Subsigs[zb0001].MarshalMsg(o)
			}
		}
		if (zb0002Mask & 0x4) == 0 { // if not empty
			// string "thr"
			o = append(o, 0xa3, 0x74, 0x68, 0x72)
			o = msgp.AppendUint8(o, (*z).Threshold)
		}
		if (zb0002Mask & 0x8) == 0 { // if not empty
			// string "v"
			o = append(o, 0xa1, 0x76)
			o = msgp.AppendUint8(o, (*z).Version)
		}
	}
	return
}

func (_ *MultisigSig) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*MultisigSig)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *MultisigSig) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0002 int
	var zb0003 bool
	zb0002, zb0003, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0002, zb0003, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 > 0 {
			zb0002--
			(*z).Version, bts, err = msgp.ReadUint8Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Version")
				return
			}
		}
		if zb0002 > 0 {
			zb0002--
			(*z).Threshold, bts, err = msgp.ReadUint8Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Threshold")
				return
			}
		}
		if zb0002 > 0 {
			zb0002--
			var zb0004 int
			var zb0005 bool
			zb0004, zb0005, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Subsigs")
				return
			}
			if zb0004 > maxMultisig {
				err = msgp.ErrOverflow(uint64(zb0004), uint64(maxMultisig))
				err = msgp.WrapError(err, "struct-from-array", "Subsigs")
				return
			}
			if zb0005 {
				(*z).Subsigs = nil
			} else if (*z).Subsigs != nil && cap((*z).Subsigs) >= zb0004 {
				(*z).Subsigs = ((*z).Subsigs)[:zb0004]
			} else {
				(*z).Subsigs = make([]MultisigSubsig, zb0004)
			}
			for zb0001 := range (*z).Subsigs {
				bts, err = (*z).Subsigs[zb0001].UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Subsigs", zb0001)
					return
				}
			}
		}
		if zb0002 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0002)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0003 {
			(*z) = MultisigSig{}
		}
		for zb0002 > 0 {
			zb0002--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "v":
				(*z).Version, bts, err = msgp.ReadUint8Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Version")
					return
				}
			case "thr":
				(*z).Threshold, bts, err = msgp.ReadUint8Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Threshold")
					return
				}
			case "subsig":
				var zb0006 int
				var zb0007 bool
				zb0006, zb0007, bts, err = msgp.ReadArrayHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Subsigs")
					return
				}
				if zb0006 > maxMultisig {
					err = msgp.ErrOverflow(uint64(zb0006), uint64(maxMultisig))
					err = msgp.WrapError(err, "Subsigs")
					return
				}
				if zb0007 {
					(*z).Subsigs = nil
				} else if (*z).Subsigs != nil && cap((*z).Subsigs) >= zb0006 {
					(*z).Subsigs = ((*z).Subsigs)[:zb0006]
				} else {
					(*z).Subsigs = make([]MultisigSubsig, zb0006)
				}
				for zb0001 := range (*z).Subsigs {
					bts, err = (*z).Subsigs[zb0001].UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "Subsigs", zb0001)
						return
					}
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *MultisigSig) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *MultisigSig) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*MultisigSig)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *MultisigSig) Msgsize() (s int) {
	s = 1 + 2 + msgp.Uint8Size + 4 + msgp.Uint8Size + 7 + msgp.ArrayHeaderSize
	for zb0001 := range (*z).Subsigs {
		s += (*z).Subsigs[zb0001].Msgsize()
	}
	return
}

// MsgIsZero returns whether this is a zero value
func (z *MultisigSig) MsgIsZero() bool {
	return ((*z).Version == 0) && ((*z).Threshold == 0) && (len((*z).Subsigs) == 0)
}

// MaxSize returns a maximum valid message size for this message type
func MultisigSigMaxSize() (s int) {
	s = 1 + 2 + msgp.Uint8Size + 4 + msgp.Uint8Size + 7
	// Calculating size of slice: z.Subsigs
	s += msgp.ArrayHeaderSize + ((maxMultisig) * (MultisigSubsigMaxSize()))
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *MultisigSubsig) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0003Len := uint32(2)
	var zb0003Mask uint8 /* 3 bits */
	if (*z).Key == (PublicKey{}) {
		zb0003Len--
		zb0003Mask |= 0x2
	}
	if (*z).Sig == (Signature{}) {
		zb0003Len--
		zb0003Mask |= 0x4
	}
	// variable map header, size zb0003Len
	o = append(o, 0x80|uint8(zb0003Len))
	if zb0003Len != 0 {
		if (zb0003Mask & 0x2) == 0 { // if not empty
			// string "pk"
			o = append(o, 0xa2, 0x70, 0x6b)
			o = msgp.AppendBytes(o, ((*z).Key)[:])
		}
		if (zb0003Mask & 0x4) == 0 { // if not empty
			// string "s"
			o = append(o, 0xa1, 0x73)
			o = msgp.AppendBytes(o, ((*z).Sig)[:])
		}
	}
	return
}

func (_ *MultisigSubsig) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*MultisigSubsig)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *MultisigSubsig) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0003 int
	var zb0004 bool
	zb0003, zb0004, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0003, zb0004, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0003 > 0 {
			zb0003--
			bts, err = msgp.ReadExactBytes(bts, ((*z).Key)[:])
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Key")
				return
			}
		}
		if zb0003 > 0 {
			zb0003--
			bts, err = msgp.ReadExactBytes(bts, ((*z).Sig)[:])
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Sig")
				return
			}
		}
		if zb0003 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0003)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0004 {
			(*z) = MultisigSubsig{}
		}
		for zb0003 > 0 {
			zb0003--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "pk":
				bts, err = msgp.ReadExactBytes(bts, ((*z).Key)[:])
				if err != nil {
					err = msgp.WrapError(err, "Key")
					return
				}
			case "s":
				bts, err = msgp.ReadExactBytes(bts, ((*z).Sig)[:])
				if err != nil {
					err = msgp.WrapError(err, "Sig")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *MultisigSubsig) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *MultisigSubsig) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*MultisigSubsig)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *MultisigSubsig) Msgsize() (s int) {
	s = 1 + 3 + msgp.ArrayHeaderSize + (32 * (msgp.ByteSize)) + 2 + msgp.ArrayHeaderSize + (64 * (msgp.ByteSize))
	return
}

// MsgIsZero returns whether this is a zero value
func (z *MultisigSubsig) MsgIsZero() bool {
	return ((*z).Key == (PublicKey{})) && ((*z).Sig == (Signature{}))
}

// MaxSize returns a maximum valid message size for this message type
func MultisigSubsigMaxSize() (s int) {
	s = 1 + 3
	// Calculating size of array: z.Key
	s += msgp.ArrayHeaderSize + ((32) * (msgp.ByteSize))
	s += 2
	// Calculating size of array: z.Sig
	s += msgp.ArrayHeaderSize + ((64) * (msgp.ByteSize))
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *OneTimeSignature) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 6
	// string "p"
	o = append(o, 0x86, 0xa1, 0x70)
	o = msgp.AppendBytes(o, ((*z).PK)[:])
	// string "p1s"
	o = append(o, 0xa3, 0x70, 0x31, 0x73)
	o = msgp.AppendBytes(o, ((*z).PK1Sig)[:])
	// string "p2"
	o = append(o, 0xa2, 0x70, 0x32)
	o = msgp.AppendBytes(o, ((*z).PK2)[:])
	// string "p2s"
	o = append(o, 0xa3, 0x70, 0x32, 0x73)
	o = msgp.AppendBytes(o, ((*z).PK2Sig)[:])
	// string "ps"
	o = append(o, 0xa2, 0x70, 0x73)
	o = msgp.AppendBytes(o, ((*z).PKSigOld)[:])
	// string "s"
	o = append(o, 0xa1, 0x73)
	o = msgp.AppendBytes(o, ((*z).Sig)[:])
	return
}

func (_ *OneTimeSignature) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*OneTimeSignature)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *OneTimeSignature) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0007 int
	var zb0008 bool
	zb0007, zb0008, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0007, zb0008, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0007 > 0 {
			zb0007--
			bts, err = msgp.ReadExactBytes(bts, ((*z).Sig)[:])
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Sig")
				return
			}
		}
		if zb0007 > 0 {
			zb0007--
			bts, err = msgp.ReadExactBytes(bts, ((*z).PK)[:])
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "PK")
				return
			}
		}
		if zb0007 > 0 {
			zb0007--
			bts, err = msgp.ReadExactBytes(bts, ((*z).PKSigOld)[:])
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "PKSigOld")
				return
			}
		}
		if zb0007 > 0 {
			zb0007--
			bts, err = msgp.ReadExactBytes(bts, ((*z).PK2)[:])
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "PK2")
				return
			}
		}
		if zb0007 > 0 {
			zb0007--
			bts, err = msgp.ReadExactBytes(bts, ((*z).PK1Sig)[:])
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "PK1Sig")
				return
			}
		}
		if zb0007 > 0 {
			zb0007--
			bts, err = msgp.ReadExactBytes(bts, ((*z).PK2Sig)[:])
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "PK2Sig")
				return
			}
		}
		if zb0007 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0007)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0008 {
			(*z) = OneTimeSignature{}
		}
		for zb0007 > 0 {
			zb0007--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "s":
				bts, err = msgp.ReadExactBytes(bts, ((*z).Sig)[:])
				if err != nil {
					err = msgp.WrapError(err, "Sig")
					return
				}
			case "p":
				bts, err = msgp.ReadExactBytes(bts, ((*z).PK)[:])
				if err != nil {
					err = msgp.WrapError(err, "PK")
					return
				}
			case "ps":
				bts, err = msgp.ReadExactBytes(bts, ((*z).PKSigOld)[:])
				if err != nil {
					err = msgp.WrapError(err, "PKSigOld")
					return
				}
			case "p2":
				bts, err = msgp.ReadExactBytes(bts, ((*z).PK2)[:])
				if err != nil {
					err = msgp.WrapError(err, "PK2")
					return
				}
			case "p1s":
				bts, err = msgp.ReadExactBytes(bts, ((*z).PK1Sig)[:])
				if err != nil {
					err = msgp.WrapError(err, "PK1Sig")
					return
				}
			case "p2s":
				bts, err = msgp.ReadExactBytes(bts, ((*z).PK2Sig)[:])
				if err != nil {
					err = msgp.WrapError(err, "PK2Sig")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *OneTimeSignature) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *OneTimeSignature) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*OneTimeSignature)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *OneTimeSignature) Msgsize() (s int) {
	s = 1 + 2 + msgp.ArrayHeaderSize + (64 * (msgp.ByteSize)) + 2 + msgp.ArrayHeaderSize + (32 * (msgp.ByteSize)) + 3 + msgp.ArrayHeaderSize + (64 * (msgp.ByteSize)) + 3 + msgp.ArrayHeaderSize + (32 * (msgp.ByteSize)) + 4 + msgp.ArrayHeaderSize + (64 * (msgp.ByteSize)) + 4 + msgp.ArrayHeaderSize + (64 * (msgp.ByteSize))
	return
}

// MsgIsZero returns whether this is a zero value
func (z *OneTimeSignature) MsgIsZero() bool {
	return ((*z).Sig == (ed25519Signature{})) && ((*z).PK == (ed25519PublicKey{})) && ((*z).PKSigOld == (ed25519Signature{})) && ((*z).PK2 == (ed25519PublicKey{})) && ((*z).PK1Sig == (ed25519Signature{})) && ((*z).PK2Sig == (ed25519Signature{}))
}

// MaxSize returns a maximum valid message size for this message type
func OneTimeSignatureMaxSize() (s int) {
	s = 1 + 2
	// Calculating size of array: z.Sig
	s += msgp.ArrayHeaderSize + ((64) * (msgp.ByteSize))
	s += 2
	// Calculating size of array: z.PK
	s += msgp.ArrayHeaderSize + ((32) * (msgp.ByteSize))
	s += 3
	// Calculating size of array: z.PKSigOld
	s += msgp.ArrayHeaderSize + ((64) * (msgp.ByteSize))
	s += 3
	// Calculating size of array: z.PK2
	s += msgp.ArrayHeaderSize + ((32) * (msgp.ByteSize))
	s += 4
	// Calculating size of array: z.PK1Sig
	s += msgp.ArrayHeaderSize + ((64) * (msgp.ByteSize))
	s += 4
	// Calculating size of array: z.PK2Sig
	s += msgp.ArrayHeaderSize + ((64) * (msgp.ByteSize))
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *OneTimeSignatureSecrets) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0006Len := uint32(7)
	var zb0006Mask uint16 /* 11 bits */
	if (*z).OneTimeSignatureSecretsPersistent.FirstBatch == 0 {
		zb0006Len--
		zb0006Mask |= 0x1
	}
	if (*z).OneTimeSignatureSecretsPersistent.OneTimeSignatureVerifier == (OneTimeSignatureVerifier{}) {
		zb0006Len--
		zb0006Mask |= 0x2
	}
	if len((*z).OneTimeSignatureSecretsPersistent.Batches) == 0 {
		zb0006Len--
		zb0006Mask |= 0x4
	}
	if (*z).OneTimeSignatureSecretsPersistent.FirstOffset == 0 {
		zb0006Len--
		zb0006Mask |= 0x20
	}
	if len((*z).OneTimeSignatureSecretsPersistent.Offsets) == 0 {
		zb0006Len--
		zb0006Mask |= 0x80
	}
	if (*z).OneTimeSignatureSecretsPersistent.OffsetsPK2 == (ed25519PublicKey{}) {
		zb0006Len--
		zb0006Mask |= 0x100
	}
	if (*z).OneTimeSignatureSecretsPersistent.OffsetsPK2Sig == (ed25519Signature{}) {
		zb0006Len--
		zb0006Mask |= 0x200
	}
	// variable map header, size zb0006Len
	o = append(o, 0x80|uint8(zb0006Len))
	if zb0006Len != 0 {
		if (zb0006Mask & 0x1) == 0 { // if not empty
			// string "First"
			o = append(o, 0xa5, 0x46, 0x69, 0x72, 0x73, 0x74)
			o = msgp.AppendUint64(o, (*z).OneTimeSignatureSecretsPersistent.FirstBatch)
		}
		if (zb0006Mask & 0x2) == 0 { // if not empty
			// string "OneTimeSignatureVerifier"
			o = append(o, 0xb8, 0x4f, 0x6e, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x65, 0x72, 0x69, 0x66, 0x69, 0x65, 0x72)
			o = msgp.AppendBytes(o, ((*z).OneTimeSignatureSecretsPersistent.OneTimeSignatureVerifier)[:])
		}
		if (zb0006Mask & 0x4) == 0 { // if not empty
			// string "Sub"
			o = append(o, 0xa3, 0x53, 0x75, 0x62)
			if (*z).OneTimeSignatureSecretsPersistent.Batches == nil {
				o = msgp.AppendNil(o)
			} else {
				o = msgp.AppendArrayHeader(o, uint32(len((*z).OneTimeSignatureSecretsPersistent.Batches)))
			}
			for zb0002 := range (*z).OneTimeSignatureSecretsPersistent.Batches {
				o = (*z).OneTimeSignatureSecretsPersistent.Batches[zb0002].MarshalMsg(o)
			}
		}
		if (zb0006Mask & 0x20) == 0 { // if not empty
			// string "firstoff"
			o = append(o, 0xa8, 0x66, 0x69, 0x72, 0x73, 0x74, 0x6f, 0x66, 0x66)
			o = msgp.AppendUint64(o, (*z).OneTimeSignatureSecretsPersistent.FirstOffset)
		}
		if (zb0006Mask & 0x80) == 0 { // if not empty
			// string "offkeys"
			o = append(o, 0xa7, 0x6f, 0x66, 0x66, 0x6b, 0x65, 0x79, 0x73)
			if (*z).OneTimeSignatureSecretsPersistent.Offsets == nil {
				o = msgp.AppendNil(o)
			} else {
				o = msgp.AppendArrayHeader(o, uint32(len((*z).OneTimeSignatureSecretsPersistent.Offsets)))
			}
			for zb0003 := range (*z).OneTimeSignatureSecretsPersistent.Offsets {
				o = (*z).OneTimeSignatureSecretsPersistent.Offsets[zb0003].MarshalMsg(o)
			}
		}
		if (zb0006Mask & 0x100) == 0 { // if not empty
			// string "offpk2"
			o = append(o, 0xa6, 0x6f, 0x66, 0x66, 0x70, 0x6b, 0x32)
			o = msgp.AppendBytes(o, ((*z).OneTimeSignatureSecretsPersistent.OffsetsPK2)[:])
		}
		if (zb0006Mask & 0x200) == 0 { // if not empty
			// string "offpk2sig"
			o = append(o, 0xa9, 0x6f, 0x66, 0x66, 0x70, 0x6b, 0x32, 0x73, 0x69, 0x67)
			o = msgp.AppendBytes(o, ((*z).OneTimeSignatureSecretsPersistent.OffsetsPK2Sig)[:])
		}
	}
	return
}

func (_ *OneTimeSignatureSecrets) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*OneTimeSignatureSecrets)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *OneTimeSignatureSecrets) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0006 int
	var zb0007 bool
	zb0006, zb0007, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0006, zb0007, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0006 > 0 {
			zb0006--
			bts, err = msgp.ReadExactBytes(bts, ((*z).OneTimeSignatureSecretsPersistent.OneTimeSignatureVerifier)[:])
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "OneTimeSignatureVerifier")
				return
			}
		}
		if zb0006 > 0 {
			zb0006--
			(*z).OneTimeSignatureSecretsPersistent.FirstBatch, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "FirstBatch")
				return
			}
		}
		if zb0006 > 0 {
			zb0006--
			var zb0008 int
			var zb0009 bool
			zb0008, zb0009, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Batches")
				return
			}
			if zb0009 {
				(*z).OneTimeSignatureSecretsPersistent.Batches = nil
			} else if (*z).OneTimeSignatureSecretsPersistent.Batches != nil && cap((*z).OneTimeSignatureSecretsPersistent.Batches) >= zb0008 {
				(*z).OneTimeSignatureSecretsPersistent.Batches = ((*z).OneTimeSignatureSecretsPersistent.Batches)[:zb0008]
			} else {
				(*z).OneTimeSignatureSecretsPersistent.Batches = make([]ephemeralSubkey, zb0008)
			}
			for zb0002 := range (*z).OneTimeSignatureSecretsPersistent.Batches {
				bts, err = (*z).OneTimeSignatureSecretsPersistent.Batches[zb0002].UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Batches", zb0002)
					return
				}
			}
		}
		if zb0006 > 0 {
			zb0006--
			(*z).OneTimeSignatureSecretsPersistent.FirstOffset, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "FirstOffset")
				return
			}
		}
		if zb0006 > 0 {
			zb0006--
			var zb0010 int
			var zb0011 bool
			zb0010, zb0011, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Offsets")
				return
			}
			if zb0011 {
				(*z).OneTimeSignatureSecretsPersistent.Offsets = nil
			} else if (*z).OneTimeSignatureSecretsPersistent.Offsets != nil && cap((*z).OneTimeSignatureSecretsPersistent.Offsets) >= zb0010 {
				(*z).OneTimeSignatureSecretsPersistent.Offsets = ((*z).OneTimeSignatureSecretsPersistent.Offsets)[:zb0010]
			} else {
				(*z).OneTimeSignatureSecretsPersistent.Offsets = make([]ephemeralSubkey, zb0010)
			}
			for zb0003 := range (*z).OneTimeSignatureSecretsPersistent.Offsets {
				bts, err = (*z).OneTimeSignatureSecretsPersistent.Offsets[zb0003].UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Offsets", zb0003)
					return
				}
			}
		}
		if zb0006 > 0 {
			zb0006--
			bts, err = msgp.ReadExactBytes(bts, ((*z).OneTimeSignatureSecretsPersistent.OffsetsPK2)[:])
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "OffsetsPK2")
				return
			}
		}
		if zb0006 > 0 {
			zb0006--
			bts, err = msgp.ReadExactBytes(bts, ((*z).OneTimeSignatureSecretsPersistent.OffsetsPK2Sig)[:])
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "OffsetsPK2Sig")
				return
			}
		}
		if zb0006 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0006)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0007 {
			(*z) = OneTimeSignatureSecrets{}
		}
		for zb0006 > 0 {
			zb0006--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "OneTimeSignatureVerifier":
				bts, err = msgp.ReadExactBytes(bts, ((*z).OneTimeSignatureSecretsPersistent.OneTimeSignatureVerifier)[:])
				if err != nil {
					err = msgp.WrapError(err, "OneTimeSignatureVerifier")
					return
				}
			case "First":
				(*z).OneTimeSignatureSecretsPersistent.FirstBatch, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "FirstBatch")
					return
				}
			case "Sub":
				var zb0012 int
				var zb0013 bool
				zb0012, zb0013, bts, err = msgp.ReadArrayHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Batches")
					return
				}
				if zb0013 {
					(*z).OneTimeSignatureSecretsPersistent.Batches = nil
				} else if (*z).OneTimeSignatureSecretsPersistent.Batches != nil && cap((*z).OneTimeSignatureSecretsPersistent.Batches) >= zb0012 {
					(*z).OneTimeSignatureSecretsPersistent.Batches = ((*z).OneTimeSignatureSecretsPersistent.Batches)[:zb0012]
				} else {
					(*z).OneTimeSignatureSecretsPersistent.Batches = make([]ephemeralSubkey, zb0012)
				}
				for zb0002 := range (*z).OneTimeSignatureSecretsPersistent.Batches {
					bts, err = (*z).OneTimeSignatureSecretsPersistent.Batches[zb0002].UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "Batches", zb0002)
						return
					}
				}
			case "firstoff":
				(*z).OneTimeSignatureSecretsPersistent.FirstOffset, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "FirstOffset")
					return
				}
			case "offkeys":
				var zb0014 int
				var zb0015 bool
				zb0014, zb0015, bts, err = msgp.ReadArrayHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Offsets")
					return
				}
				if zb0015 {
					(*z).OneTimeSignatureSecretsPersistent.Offsets = nil
				} else if (*z).OneTimeSignatureSecretsPersistent.Offsets != nil && cap((*z).OneTimeSignatureSecretsPersistent.Offsets) >= zb0014 {
					(*z).OneTimeSignatureSecretsPersistent.Offsets = ((*z).OneTimeSignatureSecretsPersistent.Offsets)[:zb0014]
				} else {
					(*z).OneTimeSignatureSecretsPersistent.Offsets = make([]ephemeralSubkey, zb0014)
				}
				for zb0003 := range (*z).OneTimeSignatureSecretsPersistent.Offsets {
					bts, err = (*z).OneTimeSignatureSecretsPersistent.Offsets[zb0003].UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "Offsets", zb0003)
						return
					}
				}
			case "offpk2":
				bts, err = msgp.ReadExactBytes(bts, ((*z).OneTimeSignatureSecretsPersistent.OffsetsPK2)[:])
				if err != nil {
					err = msgp.WrapError(err, "OffsetsPK2")
					return
				}
			case "offpk2sig":
				bts, err = msgp.ReadExactBytes(bts, ((*z).OneTimeSignatureSecretsPersistent.OffsetsPK2Sig)[:])
				if err != nil {
					err = msgp.WrapError(err, "OffsetsPK2Sig")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *OneTimeSignatureSecrets) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *OneTimeSignatureSecrets) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*OneTimeSignatureSecrets)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *OneTimeSignatureSecrets) Msgsize() (s int) {
	s = 1 + 25 + msgp.ArrayHeaderSize + (32 * (msgp.ByteSize)) + 6 + msgp.Uint64Size + 4 + msgp.ArrayHeaderSize
	for zb0002 := range (*z).OneTimeSignatureSecretsPersistent.Batches {
		s += (*z).OneTimeSignatureSecretsPersistent.Batches[zb0002].Msgsize()
	}
	s += 9 + msgp.Uint64Size + 8 + msgp.ArrayHeaderSize
	for zb0003 := range (*z).OneTimeSignatureSecretsPersistent.Offsets {
		s += (*z).OneTimeSignatureSecretsPersistent.Offsets[zb0003].Msgsize()
	}
	s += 7 + msgp.ArrayHeaderSize + (32 * (msgp.ByteSize)) + 10 + msgp.ArrayHeaderSize + (64 * (msgp.ByteSize))
	return
}

// MsgIsZero returns whether this is a zero value
func (z *OneTimeSignatureSecrets) MsgIsZero() bool {
	return ((*z).OneTimeSignatureSecretsPersistent.OneTimeSignatureVerifier == (OneTimeSignatureVerifier{})) && ((*z).OneTimeSignatureSecretsPersistent.FirstBatch == 0) && (len((*z).OneTimeSignatureSecretsPersistent.Batches) == 0) && ((*z).OneTimeSignatureSecretsPersistent.FirstOffset == 0) && (len((*z).OneTimeSignatureSecretsPersistent.Offsets) == 0) && ((*z).OneTimeSignatureSecretsPersistent.OffsetsPK2 == (ed25519PublicKey{})) && ((*z).OneTimeSignatureSecretsPersistent.OffsetsPK2Sig == (ed25519Signature{}))
}

// MaxSize returns a maximum valid message size for this message type
func OneTimeSignatureSecretsMaxSize() (s int) {
	s = 1 + 25
	// Calculating size of array: z.OneTimeSignatureSecretsPersistent.OneTimeSignatureVerifier
	s += msgp.ArrayHeaderSize + ((32) * (msgp.ByteSize))
	s += 6 + msgp.Uint64Size + 4
	// Calculating size of slice: z.OneTimeSignatureSecretsPersistent.Batches
	panic("Slice z.OneTimeSignatureSecretsPersistent.Batches is unbounded")
	s += 9 + msgp.Uint64Size + 8
	// Calculating size of slice: z.OneTimeSignatureSecretsPersistent.Offsets
	panic("Slice z.OneTimeSignatureSecretsPersistent.Offsets is unbounded")
	s += 7
	// Calculating size of array: z.OneTimeSignatureSecretsPersistent.OffsetsPK2
	s += msgp.ArrayHeaderSize + ((32) * (msgp.ByteSize))
	s += 10
	// Calculating size of array: z.OneTimeSignatureSecretsPersistent.OffsetsPK2Sig
	s += msgp.ArrayHeaderSize + ((64) * (msgp.ByteSize))
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *OneTimeSignatureSecretsPersistent) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// omitempty: check for empty values
	zb0006Len := uint32(7)
	var zb0006Mask uint8 /* 8 bits */
	if (*z).FirstBatch == 0 {
		zb0006Len--
		zb0006Mask |= 0x1
	}
	if (*z).OneTimeSignatureVerifier == (OneTimeSignatureVerifier{}) {
		zb0006Len--
		zb0006Mask |= 0x2
	}
	if len((*z).Batches) == 0 {
		zb0006Len--
		zb0006Mask |= 0x4
	}
	if (*z).FirstOffset == 0 {
		zb0006Len--
		zb0006Mask |= 0x10
	}
	if len((*z).Offsets) == 0 {
		zb0006Len--
		zb0006Mask |= 0x20
	}
	if (*z).OffsetsPK2 == (ed25519PublicKey{}) {
		zb0006Len--
		zb0006Mask |= 0x40
	}
	if (*z).OffsetsPK2Sig == (ed25519Signature{}) {
		zb0006Len--
		zb0006Mask |= 0x80
	}
	// variable map header, size zb0006Len
	o = append(o, 0x80|uint8(zb0006Len))
	if zb0006Len != 0 {
		if (zb0006Mask & 0x1) == 0 { // if not empty
			// string "First"
			o = append(o, 0xa5, 0x46, 0x69, 0x72, 0x73, 0x74)
			o = msgp.AppendUint64(o, (*z).FirstBatch)
		}
		if (zb0006Mask & 0x2) == 0 { // if not empty
			// string "OneTimeSignatureVerifier"
			o = append(o, 0xb8, 0x4f, 0x6e, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x65, 0x72, 0x69, 0x66, 0x69, 0x65, 0x72)
			o = msgp.AppendBytes(o, ((*z).OneTimeSignatureVerifier)[:])
		}
		if (zb0006Mask & 0x4) == 0 { // if not empty
			// string "Sub"
			o = append(o, 0xa3, 0x53, 0x75, 0x62)
			if (*z).Batches == nil {
				o = msgp.AppendNil(o)
			} else {
				o = msgp.AppendArrayHeader(o, uint32(len((*z).Batches)))
			}
			for zb0002 := range (*z).Batches {
				o = (*z).Batches[zb0002].MarshalMsg(o)
			}
		}
		if (zb0006Mask & 0x10) == 0 { // if not empty
			// string "firstoff"
			o = append(o, 0xa8, 0x66, 0x69, 0x72, 0x73, 0x74, 0x6f, 0x66, 0x66)
			o = msgp.AppendUint64(o, (*z).FirstOffset)
		}
		if (zb0006Mask & 0x20) == 0 { // if not empty
			// string "offkeys"
			o = append(o, 0xa7, 0x6f, 0x66, 0x66, 0x6b, 0x65, 0x79, 0x73)
			if (*z).Offsets == nil {
				o = msgp.AppendNil(o)
			} else {
				o = msgp.AppendArrayHeader(o, uint32(len((*z).Offsets)))
			}
			for zb0003 := range (*z).Offsets {
				o = (*z).Offsets[zb0003].MarshalMsg(o)
			}
		}
		if (zb0006Mask & 0x40) == 0 { // if not empty
			// string "offpk2"
			o = append(o, 0xa6, 0x6f, 0x66, 0x66, 0x70, 0x6b, 0x32)
			o = msgp.AppendBytes(o, ((*z).OffsetsPK2)[:])
		}
		if (zb0006Mask & 0x80) == 0 { // if not empty
			// string "offpk2sig"
			o = append(o, 0xa9, 0x6f, 0x66, 0x66, 0x70, 0x6b, 0x32, 0x73, 0x69, 0x67)
			o = msgp.AppendBytes(o, ((*z).OffsetsPK2Sig)[:])
		}
	}
	return
}

func (_ *OneTimeSignatureSecretsPersistent) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*OneTimeSignatureSecretsPersistent)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *OneTimeSignatureSecretsPersistent) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0006 int
	var zb0007 bool
	zb0006, zb0007, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0006, zb0007, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0006 > 0 {
			zb0006--
			bts, err = msgp.ReadExactBytes(bts, ((*z).OneTimeSignatureVerifier)[:])
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "OneTimeSignatureVerifier")
				return
			}
		}
		if zb0006 > 0 {
			zb0006--
			(*z).FirstBatch, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "FirstBatch")
				return
			}
		}
		if zb0006 > 0 {
			zb0006--
			var zb0008 int
			var zb0009 bool
			zb0008, zb0009, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Batches")
				return
			}
			if zb0009 {
				(*z).Batches = nil
			} else if (*z).Batches != nil && cap((*z).Batches) >= zb0008 {
				(*z).Batches = ((*z).Batches)[:zb0008]
			} else {
				(*z).Batches = make([]ephemeralSubkey, zb0008)
			}
			for zb0002 := range (*z).Batches {
				bts, err = (*z).Batches[zb0002].UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Batches", zb0002)
					return
				}
			}
		}
		if zb0006 > 0 {
			zb0006--
			(*z).FirstOffset, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "FirstOffset")
				return
			}
		}
		if zb0006 > 0 {
			zb0006--
			var zb0010 int
			var zb0011 bool
			zb0010, zb0011, bts, err = msgp.ReadArrayHeaderBytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Offsets")
				return
			}
			if zb0011 {
				(*z).Offsets = nil
			} else if (*z).Offsets != nil && cap((*z).Offsets) >= zb0010 {
				(*z).Offsets = ((*z).Offsets)[:zb0010]
			} else {
				(*z).Offsets = make([]ephemeralSubkey, zb0010)
			}
			for zb0003 := range (*z).Offsets {
				bts, err = (*z).Offsets[zb0003].UnmarshalMsgWithState(bts, st)
				if err != nil {
					err = msgp.WrapError(err, "struct-from-array", "Offsets", zb0003)
					return
				}
			}
		}
		if zb0006 > 0 {
			zb0006--
			bts, err = msgp.ReadExactBytes(bts, ((*z).OffsetsPK2)[:])
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "OffsetsPK2")
				return
			}
		}
		if zb0006 > 0 {
			zb0006--
			bts, err = msgp.ReadExactBytes(bts, ((*z).OffsetsPK2Sig)[:])
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "OffsetsPK2Sig")
				return
			}
		}
		if zb0006 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0006)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0007 {
			(*z) = OneTimeSignatureSecretsPersistent{}
		}
		for zb0006 > 0 {
			zb0006--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "OneTimeSignatureVerifier":
				bts, err = msgp.ReadExactBytes(bts, ((*z).OneTimeSignatureVerifier)[:])
				if err != nil {
					err = msgp.WrapError(err, "OneTimeSignatureVerifier")
					return
				}
			case "First":
				(*z).FirstBatch, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "FirstBatch")
					return
				}
			case "Sub":
				var zb0012 int
				var zb0013 bool
				zb0012, zb0013, bts, err = msgp.ReadArrayHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Batches")
					return
				}
				if zb0013 {
					(*z).Batches = nil
				} else if (*z).Batches != nil && cap((*z).Batches) >= zb0012 {
					(*z).Batches = ((*z).Batches)[:zb0012]
				} else {
					(*z).Batches = make([]ephemeralSubkey, zb0012)
				}
				for zb0002 := range (*z).Batches {
					bts, err = (*z).Batches[zb0002].UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "Batches", zb0002)
						return
					}
				}
			case "firstoff":
				(*z).FirstOffset, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "FirstOffset")
					return
				}
			case "offkeys":
				var zb0014 int
				var zb0015 bool
				zb0014, zb0015, bts, err = msgp.ReadArrayHeaderBytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Offsets")
					return
				}
				if zb0015 {
					(*z).Offsets = nil
				} else if (*z).Offsets != nil && cap((*z).Offsets) >= zb0014 {
					(*z).Offsets = ((*z).Offsets)[:zb0014]
				} else {
					(*z).Offsets = make([]ephemeralSubkey, zb0014)
				}
				for zb0003 := range (*z).Offsets {
					bts, err = (*z).Offsets[zb0003].UnmarshalMsgWithState(bts, st)
					if err != nil {
						err = msgp.WrapError(err, "Offsets", zb0003)
						return
					}
				}
			case "offpk2":
				bts, err = msgp.ReadExactBytes(bts, ((*z).OffsetsPK2)[:])
				if err != nil {
					err = msgp.WrapError(err, "OffsetsPK2")
					return
				}
			case "offpk2sig":
				bts, err = msgp.ReadExactBytes(bts, ((*z).OffsetsPK2Sig)[:])
				if err != nil {
					err = msgp.WrapError(err, "OffsetsPK2Sig")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *OneTimeSignatureSecretsPersistent) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *OneTimeSignatureSecretsPersistent) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*OneTimeSignatureSecretsPersistent)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *OneTimeSignatureSecretsPersistent) Msgsize() (s int) {
	s = 1 + 25 + msgp.ArrayHeaderSize + (32 * (msgp.ByteSize)) + 6 + msgp.Uint64Size + 4 + msgp.ArrayHeaderSize
	for zb0002 := range (*z).Batches {
		s += (*z).Batches[zb0002].Msgsize()
	}
	s += 9 + msgp.Uint64Size + 8 + msgp.ArrayHeaderSize
	for zb0003 := range (*z).Offsets {
		s += (*z).Offsets[zb0003].Msgsize()
	}
	s += 7 + msgp.ArrayHeaderSize + (32 * (msgp.ByteSize)) + 10 + msgp.ArrayHeaderSize + (64 * (msgp.ByteSize))
	return
}

// MsgIsZero returns whether this is a zero value
func (z *OneTimeSignatureSecretsPersistent) MsgIsZero() bool {
	return ((*z).OneTimeSignatureVerifier == (OneTimeSignatureVerifier{})) && ((*z).FirstBatch == 0) && (len((*z).Batches) == 0) && ((*z).FirstOffset == 0) && (len((*z).Offsets) == 0) && ((*z).OffsetsPK2 == (ed25519PublicKey{})) && ((*z).OffsetsPK2Sig == (ed25519Signature{}))
}

// MaxSize returns a maximum valid message size for this message type
func OneTimeSignatureSecretsPersistentMaxSize() (s int) {
	s = 1 + 25
	// Calculating size of array: z.OneTimeSignatureVerifier
	s += msgp.ArrayHeaderSize + ((32) * (msgp.ByteSize))
	s += 6 + msgp.Uint64Size + 4
	// Calculating size of slice: z.Batches
	panic("Slice z.Batches is unbounded")
	s += 9 + msgp.Uint64Size + 8
	// Calculating size of slice: z.Offsets
	panic("Slice z.Offsets is unbounded")
	s += 7
	// Calculating size of array: z.OffsetsPK2
	s += msgp.ArrayHeaderSize + ((32) * (msgp.ByteSize))
	s += 10
	// Calculating size of array: z.OffsetsPK2Sig
	s += msgp.ArrayHeaderSize + ((64) * (msgp.ByteSize))
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *OneTimeSignatureSubkeyBatchID) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 2
	// string "batch"
	o = append(o, 0x82, 0xa5, 0x62, 0x61, 0x74, 0x63, 0x68)
	o = msgp.AppendUint64(o, (*z).Batch)
	// string "pk"
	o = append(o, 0xa2, 0x70, 0x6b)
	o = msgp.AppendBytes(o, ((*z).SubKeyPK)[:])
	return
}

func (_ *OneTimeSignatureSubkeyBatchID) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*OneTimeSignatureSubkeyBatchID)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *OneTimeSignatureSubkeyBatchID) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0002 int
	var zb0003 bool
	zb0002, zb0003, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0002, zb0003, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 > 0 {
			zb0002--
			bts, err = msgp.ReadExactBytes(bts, ((*z).SubKeyPK)[:])
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "SubKeyPK")
				return
			}
		}
		if zb0002 > 0 {
			zb0002--
			(*z).Batch, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Batch")
				return
			}
		}
		if zb0002 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0002)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0003 {
			(*z) = OneTimeSignatureSubkeyBatchID{}
		}
		for zb0002 > 0 {
			zb0002--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "pk":
				bts, err = msgp.ReadExactBytes(bts, ((*z).SubKeyPK)[:])
				if err != nil {
					err = msgp.WrapError(err, "SubKeyPK")
					return
				}
			case "batch":
				(*z).Batch, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Batch")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *OneTimeSignatureSubkeyBatchID) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *OneTimeSignatureSubkeyBatchID) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*OneTimeSignatureSubkeyBatchID)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *OneTimeSignatureSubkeyBatchID) Msgsize() (s int) {
	s = 1 + 3 + msgp.ArrayHeaderSize + (32 * (msgp.ByteSize)) + 6 + msgp.Uint64Size
	return
}

// MsgIsZero returns whether this is a zero value
func (z *OneTimeSignatureSubkeyBatchID) MsgIsZero() bool {
	return ((*z).SubKeyPK == (ed25519PublicKey{})) && ((*z).Batch == 0)
}

// MaxSize returns a maximum valid message size for this message type
func OneTimeSignatureSubkeyBatchIDMaxSize() (s int) {
	s = 1 + 3
	// Calculating size of array: z.SubKeyPK
	s += msgp.ArrayHeaderSize + ((32) * (msgp.ByteSize))
	s += 6 + msgp.Uint64Size
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *OneTimeSignatureSubkeyOffsetID) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 3
	// string "batch"
	o = append(o, 0x83, 0xa5, 0x62, 0x61, 0x74, 0x63, 0x68)
	o = msgp.AppendUint64(o, (*z).Batch)
	// string "off"
	o = append(o, 0xa3, 0x6f, 0x66, 0x66)
	o = msgp.AppendUint64(o, (*z).Offset)
	// string "pk"
	o = append(o, 0xa2, 0x70, 0x6b)
	o = msgp.AppendBytes(o, ((*z).SubKeyPK)[:])
	return
}

func (_ *OneTimeSignatureSubkeyOffsetID) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*OneTimeSignatureSubkeyOffsetID)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *OneTimeSignatureSubkeyOffsetID) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0002 int
	var zb0003 bool
	zb0002, zb0003, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0002, zb0003, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0002 > 0 {
			zb0002--
			bts, err = msgp.ReadExactBytes(bts, ((*z).SubKeyPK)[:])
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "SubKeyPK")
				return
			}
		}
		if zb0002 > 0 {
			zb0002--
			(*z).Batch, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Batch")
				return
			}
		}
		if zb0002 > 0 {
			zb0002--
			(*z).Offset, bts, err = msgp.ReadUint64Bytes(bts)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "Offset")
				return
			}
		}
		if zb0002 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0002)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0003 {
			(*z) = OneTimeSignatureSubkeyOffsetID{}
		}
		for zb0002 > 0 {
			zb0002--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "pk":
				bts, err = msgp.ReadExactBytes(bts, ((*z).SubKeyPK)[:])
				if err != nil {
					err = msgp.WrapError(err, "SubKeyPK")
					return
				}
			case "batch":
				(*z).Batch, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Batch")
					return
				}
			case "off":
				(*z).Offset, bts, err = msgp.ReadUint64Bytes(bts)
				if err != nil {
					err = msgp.WrapError(err, "Offset")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *OneTimeSignatureSubkeyOffsetID) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *OneTimeSignatureSubkeyOffsetID) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*OneTimeSignatureSubkeyOffsetID)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *OneTimeSignatureSubkeyOffsetID) Msgsize() (s int) {
	s = 1 + 3 + msgp.ArrayHeaderSize + (32 * (msgp.ByteSize)) + 6 + msgp.Uint64Size + 4 + msgp.Uint64Size
	return
}

// MsgIsZero returns whether this is a zero value
func (z *OneTimeSignatureSubkeyOffsetID) MsgIsZero() bool {
	return ((*z).SubKeyPK == (ed25519PublicKey{})) && ((*z).Batch == 0) && ((*z).Offset == 0)
}

// MaxSize returns a maximum valid message size for this message type
func OneTimeSignatureSubkeyOffsetIDMaxSize() (s int) {
	s = 1 + 3
	// Calculating size of array: z.SubKeyPK
	s += msgp.ArrayHeaderSize + ((32) * (msgp.ByteSize))
	s += 6 + msgp.Uint64Size + 4 + msgp.Uint64Size
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *OneTimeSignatureVerifier) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	o = msgp.AppendBytes(o, (*z)[:])
	return
}

func (_ *OneTimeSignatureVerifier) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*OneTimeSignatureVerifier)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *OneTimeSignatureVerifier) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	bts, err = msgp.ReadExactBytes(bts, (*z)[:])
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	o = bts
	return
}

func (z *OneTimeSignatureVerifier) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *OneTimeSignatureVerifier) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*OneTimeSignatureVerifier)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *OneTimeSignatureVerifier) Msgsize() (s int) {
	s = msgp.ArrayHeaderSize + (32 * (msgp.ByteSize))
	return
}

// MsgIsZero returns whether this is a zero value
func (z *OneTimeSignatureVerifier) MsgIsZero() bool {
	return (*z) == (OneTimeSignatureVerifier{})
}

// MaxSize returns a maximum valid message size for this message type
func OneTimeSignatureVerifierMaxSize() (s int) {
	// Calculating size of array: z
	s = msgp.ArrayHeaderSize + ((32) * (msgp.ByteSize))
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *PrivateKey) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	o = msgp.AppendBytes(o, (*z)[:])
	return
}

func (_ *PrivateKey) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*PrivateKey)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *PrivateKey) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	bts, err = msgp.ReadExactBytes(bts, (*z)[:])
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	o = bts
	return
}

func (z *PrivateKey) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *PrivateKey) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*PrivateKey)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *PrivateKey) Msgsize() (s int) {
	s = msgp.ArrayHeaderSize + (64 * (msgp.ByteSize))
	return
}

// MsgIsZero returns whether this is a zero value
func (z *PrivateKey) MsgIsZero() bool {
	return (*z) == (PrivateKey{})
}

// MaxSize returns a maximum valid message size for this message type
func PrivateKeyMaxSize() (s int) {
	// Calculating size of array: z
	s = msgp.ArrayHeaderSize + ((64) * (msgp.ByteSize))
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *PublicKey) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	o = msgp.AppendBytes(o, (*z)[:])
	return
}

func (_ *PublicKey) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*PublicKey)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *PublicKey) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	bts, err = msgp.ReadExactBytes(bts, (*z)[:])
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	o = bts
	return
}

func (z *PublicKey) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *PublicKey) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*PublicKey)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *PublicKey) Msgsize() (s int) {
	s = msgp.ArrayHeaderSize + (32 * (msgp.ByteSize))
	return
}

// MsgIsZero returns whether this is a zero value
func (z *PublicKey) MsgIsZero() bool {
	return (*z) == (PublicKey{})
}

// MaxSize returns a maximum valid message size for this message type
func PublicKeyMaxSize() (s int) {
	// Calculating size of array: z
	s = msgp.ArrayHeaderSize + ((32) * (msgp.ByteSize))
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *Seed) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	o = msgp.AppendBytes(o, (*z)[:])
	return
}

func (_ *Seed) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*Seed)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *Seed) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	bts, err = msgp.ReadExactBytes(bts, (*z)[:])
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	o = bts
	return
}

func (z *Seed) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *Seed) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*Seed)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *Seed) Msgsize() (s int) {
	s = msgp.ArrayHeaderSize + (32 * (msgp.ByteSize))
	return
}

// MsgIsZero returns whether this is a zero value
func (z *Seed) MsgIsZero() bool {
	return (*z) == (Seed{})
}

// MaxSize returns a maximum valid message size for this message type
func SeedMaxSize() (s int) {
	// Calculating size of array: z
	s = msgp.ArrayHeaderSize + ((32) * (msgp.ByteSize))
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *Signature) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	o = msgp.AppendBytes(o, (*z)[:])
	return
}

func (_ *Signature) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*Signature)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *Signature) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	bts, err = msgp.ReadExactBytes(bts, (*z)[:])
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	o = bts
	return
}

func (z *Signature) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *Signature) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*Signature)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *Signature) Msgsize() (s int) {
	s = msgp.ArrayHeaderSize + (64 * (msgp.ByteSize))
	return
}

// MsgIsZero returns whether this is a zero value
func (z *Signature) MsgIsZero() bool {
	return (*z) == (Signature{})
}

// MaxSize returns a maximum valid message size for this message type
func SignatureMaxSize() (s int) {
	// Calculating size of array: z
	s = msgp.ArrayHeaderSize + ((64) * (msgp.ByteSize))
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *SignatureSecrets) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 2
	// string "SK"
	o = append(o, 0x82, 0xa2, 0x53, 0x4b)
	o = msgp.AppendBytes(o, ((*z).SK)[:])
	// string "SignatureVerifier"
	o = append(o, 0xb1, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x56, 0x65, 0x72, 0x69, 0x66, 0x69, 0x65, 0x72)
	o = msgp.AppendBytes(o, ((*z).SignatureVerifier)[:])
	return
}

func (_ *SignatureSecrets) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*SignatureSecrets)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *SignatureSecrets) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0003 int
	var zb0004 bool
	zb0003, zb0004, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0003, zb0004, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0003 > 0 {
			zb0003--
			bts, err = msgp.ReadExactBytes(bts, ((*z).SignatureVerifier)[:])
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "SignatureVerifier")
				return
			}
		}
		if zb0003 > 0 {
			zb0003--
			bts, err = msgp.ReadExactBytes(bts, ((*z).SK)[:])
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "SK")
				return
			}
		}
		if zb0003 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0003)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0004 {
			(*z) = SignatureSecrets{}
		}
		for zb0003 > 0 {
			zb0003--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "SignatureVerifier":
				bts, err = msgp.ReadExactBytes(bts, ((*z).SignatureVerifier)[:])
				if err != nil {
					err = msgp.WrapError(err, "SignatureVerifier")
					return
				}
			case "SK":
				bts, err = msgp.ReadExactBytes(bts, ((*z).SK)[:])
				if err != nil {
					err = msgp.WrapError(err, "SK")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *SignatureSecrets) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *SignatureSecrets) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*SignatureSecrets)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *SignatureSecrets) Msgsize() (s int) {
	s = 1 + 18 + msgp.ArrayHeaderSize + (32 * (msgp.ByteSize)) + 3 + msgp.ArrayHeaderSize + (64 * (msgp.ByteSize))
	return
}

// MsgIsZero returns whether this is a zero value
func (z *SignatureSecrets) MsgIsZero() bool {
	return ((*z).SignatureVerifier == (PublicKey{})) && ((*z).SK == (ed25519PrivateKey{}))
}

// MaxSize returns a maximum valid message size for this message type
func SignatureSecretsMaxSize() (s int) {
	s = 1 + 18
	// Calculating size of array: z.SignatureVerifier
	s += msgp.ArrayHeaderSize + ((32) * (msgp.ByteSize))
	s += 3
	// Calculating size of array: z.SK
	s += msgp.ArrayHeaderSize + ((64) * (msgp.ByteSize))
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *VRFSecrets) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 2
	// string "PK"
	o = append(o, 0x82, 0xa2, 0x50, 0x4b)
	o = msgp.AppendBytes(o, ((*z).PK)[:])
	// string "SK"
	o = append(o, 0xa2, 0x53, 0x4b)
	o = msgp.AppendBytes(o, ((*z).SK)[:])
	return
}

func (_ *VRFSecrets) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*VRFSecrets)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *VRFSecrets) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0003 int
	var zb0004 bool
	zb0003, zb0004, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0003, zb0004, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0003 > 0 {
			zb0003--
			bts, err = msgp.ReadExactBytes(bts, ((*z).PK)[:])
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "PK")
				return
			}
		}
		if zb0003 > 0 {
			zb0003--
			bts, err = msgp.ReadExactBytes(bts, ((*z).SK)[:])
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "SK")
				return
			}
		}
		if zb0003 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0003)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0004 {
			(*z) = VRFSecrets{}
		}
		for zb0003 > 0 {
			zb0003--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "PK":
				bts, err = msgp.ReadExactBytes(bts, ((*z).PK)[:])
				if err != nil {
					err = msgp.WrapError(err, "PK")
					return
				}
			case "SK":
				bts, err = msgp.ReadExactBytes(bts, ((*z).SK)[:])
				if err != nil {
					err = msgp.WrapError(err, "SK")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *VRFSecrets) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *VRFSecrets) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*VRFSecrets)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *VRFSecrets) Msgsize() (s int) {
	s = 1 + 3 + msgp.ArrayHeaderSize + (32 * (msgp.ByteSize)) + 3 + msgp.ArrayHeaderSize + (64 * (msgp.ByteSize))
	return
}

// MsgIsZero returns whether this is a zero value
func (z *VRFSecrets) MsgIsZero() bool {
	return ((*z).PK == (VrfPubkey{})) && ((*z).SK == (VrfPrivkey{}))
}

// MaxSize returns a maximum valid message size for this message type
func VRFSecretsMaxSize() (s int) {
	s = 1 + 3
	// Calculating size of array: z.PK
	s += msgp.ArrayHeaderSize + ((32) * (msgp.ByteSize))
	s += 3
	// Calculating size of array: z.SK
	s += msgp.ArrayHeaderSize + ((64) * (msgp.ByteSize))
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *VrfOutput) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	o = msgp.AppendBytes(o, (*z)[:])
	return
}

func (_ *VrfOutput) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*VrfOutput)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *VrfOutput) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	bts, err = msgp.ReadExactBytes(bts, (*z)[:])
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	o = bts
	return
}

func (z *VrfOutput) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *VrfOutput) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*VrfOutput)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *VrfOutput) Msgsize() (s int) {
	s = msgp.ArrayHeaderSize + (64 * (msgp.ByteSize))
	return
}

// MsgIsZero returns whether this is a zero value
func (z *VrfOutput) MsgIsZero() bool {
	return (*z) == (VrfOutput{})
}

// MaxSize returns a maximum valid message size for this message type
func VrfOutputMaxSize() (s int) {
	// Calculating size of array: z
	s = msgp.ArrayHeaderSize + ((64) * (msgp.ByteSize))
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *VrfPrivkey) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	o = msgp.AppendBytes(o, (*z)[:])
	return
}

func (_ *VrfPrivkey) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*VrfPrivkey)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *VrfPrivkey) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	bts, err = msgp.ReadExactBytes(bts, (*z)[:])
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	o = bts
	return
}

func (z *VrfPrivkey) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *VrfPrivkey) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*VrfPrivkey)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *VrfPrivkey) Msgsize() (s int) {
	s = msgp.ArrayHeaderSize + (64 * (msgp.ByteSize))
	return
}

// MsgIsZero returns whether this is a zero value
func (z *VrfPrivkey) MsgIsZero() bool {
	return (*z) == (VrfPrivkey{})
}

// MaxSize returns a maximum valid message size for this message type
func VrfPrivkeyMaxSize() (s int) {
	// Calculating size of array: z
	s = msgp.ArrayHeaderSize + ((64) * (msgp.ByteSize))
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *VrfProof) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	o = msgp.AppendBytes(o, (*z)[:])
	return
}

func (_ *VrfProof) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*VrfProof)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *VrfProof) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	bts, err = msgp.ReadExactBytes(bts, (*z)[:])
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	o = bts
	return
}

func (z *VrfProof) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *VrfProof) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*VrfProof)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *VrfProof) Msgsize() (s int) {
	s = msgp.ArrayHeaderSize + (80 * (msgp.ByteSize))
	return
}

// MsgIsZero returns whether this is a zero value
func (z *VrfProof) MsgIsZero() bool {
	return (*z) == (VrfProof{})
}

// MaxSize returns a maximum valid message size for this message type
func VrfProofMaxSize() (s int) {
	// Calculating size of array: z
	s = msgp.ArrayHeaderSize + ((80) * (msgp.ByteSize))
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *VrfPubkey) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	o = msgp.AppendBytes(o, (*z)[:])
	return
}

func (_ *VrfPubkey) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*VrfPubkey)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *VrfPubkey) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	bts, err = msgp.ReadExactBytes(bts, (*z)[:])
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	o = bts
	return
}

func (z *VrfPubkey) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *VrfPubkey) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*VrfPubkey)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *VrfPubkey) Msgsize() (s int) {
	s = msgp.ArrayHeaderSize + (32 * (msgp.ByteSize))
	return
}

// MsgIsZero returns whether this is a zero value
func (z *VrfPubkey) MsgIsZero() bool {
	return (*z) == (VrfPubkey{})
}

// MaxSize returns a maximum valid message size for this message type
func VrfPubkeyMaxSize() (s int) {
	// Calculating size of array: z
	s = msgp.ArrayHeaderSize + ((32) * (msgp.ByteSize))
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *ed25519PrivateKey) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	o = msgp.AppendBytes(o, (*z)[:])
	return
}

func (_ *ed25519PrivateKey) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*ed25519PrivateKey)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *ed25519PrivateKey) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	bts, err = msgp.ReadExactBytes(bts, (*z)[:])
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	o = bts
	return
}

func (z *ed25519PrivateKey) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *ed25519PrivateKey) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*ed25519PrivateKey)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *ed25519PrivateKey) Msgsize() (s int) {
	s = msgp.ArrayHeaderSize + (64 * (msgp.ByteSize))
	return
}

// MsgIsZero returns whether this is a zero value
func (z *ed25519PrivateKey) MsgIsZero() bool {
	return (*z) == (ed25519PrivateKey{})
}

// MaxSize returns a maximum valid message size for this message type
func Ed25519PrivateKeyMaxSize() (s int) {
	// Calculating size of array: z
	s = msgp.ArrayHeaderSize + ((64) * (msgp.ByteSize))
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *ed25519PublicKey) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	o = msgp.AppendBytes(o, (*z)[:])
	return
}

func (_ *ed25519PublicKey) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*ed25519PublicKey)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *ed25519PublicKey) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	bts, err = msgp.ReadExactBytes(bts, (*z)[:])
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	o = bts
	return
}

func (z *ed25519PublicKey) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *ed25519PublicKey) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*ed25519PublicKey)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *ed25519PublicKey) Msgsize() (s int) {
	s = msgp.ArrayHeaderSize + (32 * (msgp.ByteSize))
	return
}

// MsgIsZero returns whether this is a zero value
func (z *ed25519PublicKey) MsgIsZero() bool {
	return (*z) == (ed25519PublicKey{})
}

// MaxSize returns a maximum valid message size for this message type
func Ed25519PublicKeyMaxSize() (s int) {
	// Calculating size of array: z
	s = msgp.ArrayHeaderSize + ((32) * (msgp.ByteSize))
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *ed25519Seed) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	o = msgp.AppendBytes(o, (*z)[:])
	return
}

func (_ *ed25519Seed) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*ed25519Seed)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *ed25519Seed) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	bts, err = msgp.ReadExactBytes(bts, (*z)[:])
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	o = bts
	return
}

func (z *ed25519Seed) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *ed25519Seed) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*ed25519Seed)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *ed25519Seed) Msgsize() (s int) {
	s = msgp.ArrayHeaderSize + (32 * (msgp.ByteSize))
	return
}

// MsgIsZero returns whether this is a zero value
func (z *ed25519Seed) MsgIsZero() bool {
	return (*z) == (ed25519Seed{})
}

// MaxSize returns a maximum valid message size for this message type
func Ed25519SeedMaxSize() (s int) {
	// Calculating size of array: z
	s = msgp.ArrayHeaderSize + ((32) * (msgp.ByteSize))
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *ed25519Signature) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	o = msgp.AppendBytes(o, (*z)[:])
	return
}

func (_ *ed25519Signature) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*ed25519Signature)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *ed25519Signature) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	bts, err = msgp.ReadExactBytes(bts, (*z)[:])
	if err != nil {
		err = msgp.WrapError(err)
		return
	}
	o = bts
	return
}

func (z *ed25519Signature) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *ed25519Signature) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*ed25519Signature)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *ed25519Signature) Msgsize() (s int) {
	s = msgp.ArrayHeaderSize + (64 * (msgp.ByteSize))
	return
}

// MsgIsZero returns whether this is a zero value
func (z *ed25519Signature) MsgIsZero() bool {
	return (*z) == (ed25519Signature{})
}

// MaxSize returns a maximum valid message size for this message type
func Ed25519SignatureMaxSize() (s int) {
	// Calculating size of array: z
	s = msgp.ArrayHeaderSize + ((64) * (msgp.ByteSize))
	return
}

// MarshalMsg implements msgp.Marshaler
func (z *ephemeralSubkey) MarshalMsg(b []byte) (o []byte) {
	o = msgp.Require(b, z.Msgsize())
	// map header, size 4
	// string "PK"
	o = append(o, 0x84, 0xa2, 0x50, 0x4b)
	o = msgp.AppendBytes(o, ((*z).PK)[:])
	// string "PKSig"
	o = append(o, 0xa5, 0x50, 0x4b, 0x53, 0x69, 0x67)
	o = msgp.AppendBytes(o, ((*z).PKSigOld)[:])
	// string "SK"
	o = append(o, 0xa2, 0x53, 0x4b)
	o = msgp.AppendBytes(o, ((*z).SK)[:])
	// string "sig2"
	o = append(o, 0xa4, 0x73, 0x69, 0x67, 0x32)
	o = msgp.AppendBytes(o, ((*z).PKSigNew)[:])
	return
}

func (_ *ephemeralSubkey) CanMarshalMsg(z interface{}) bool {
	_, ok := (z).(*ephemeralSubkey)
	return ok
}

// UnmarshalMsg implements msgp.Unmarshaler
func (z *ephemeralSubkey) UnmarshalMsgWithState(bts []byte, st msgp.UnmarshalState) (o []byte, err error) {
	if st.AllowableDepth == 0 {
		err = msgp.ErrMaxDepthExceeded{}
		return
	}
	st.AllowableDepth--
	var field []byte
	_ = field
	var zb0005 int
	var zb0006 bool
	zb0005, zb0006, bts, err = msgp.ReadMapHeaderBytes(bts)
	if _, ok := err.(msgp.TypeError); ok {
		zb0005, zb0006, bts, err = msgp.ReadArrayHeaderBytes(bts)
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = msgp.ReadExactBytes(bts, ((*z).PK)[:])
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "PK")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = msgp.ReadExactBytes(bts, ((*z).SK)[:])
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "SK")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = msgp.ReadExactBytes(bts, ((*z).PKSigOld)[:])
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "PKSigOld")
				return
			}
		}
		if zb0005 > 0 {
			zb0005--
			bts, err = msgp.ReadExactBytes(bts, ((*z).PKSigNew)[:])
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array", "PKSigNew")
				return
			}
		}
		if zb0005 > 0 {
			err = msgp.ErrTooManyArrayFields(zb0005)
			if err != nil {
				err = msgp.WrapError(err, "struct-from-array")
				return
			}
		}
	} else {
		if err != nil {
			err = msgp.WrapError(err)
			return
		}
		if zb0006 {
			(*z) = ephemeralSubkey{}
		}
		for zb0005 > 0 {
			zb0005--
			field, bts, err = msgp.ReadMapKeyZC(bts)
			if err != nil {
				err = msgp.WrapError(err)
				return
			}
			switch string(field) {
			case "PK":
				bts, err = msgp.ReadExactBytes(bts, ((*z).PK)[:])
				if err != nil {
					err = msgp.WrapError(err, "PK")
					return
				}
			case "SK":
				bts, err = msgp.ReadExactBytes(bts, ((*z).SK)[:])
				if err != nil {
					err = msgp.WrapError(err, "SK")
					return
				}
			case "PKSig":
				bts, err = msgp.ReadExactBytes(bts, ((*z).PKSigOld)[:])
				if err != nil {
					err = msgp.WrapError(err, "PKSigOld")
					return
				}
			case "sig2":
				bts, err = msgp.ReadExactBytes(bts, ((*z).PKSigNew)[:])
				if err != nil {
					err = msgp.WrapError(err, "PKSigNew")
					return
				}
			default:
				err = msgp.ErrNoField(string(field))
				if err != nil {
					err = msgp.WrapError(err)
					return
				}
			}
		}
	}
	o = bts
	return
}

func (z *ephemeralSubkey) UnmarshalMsg(bts []byte) (o []byte, err error) {
	return z.UnmarshalMsgWithState(bts, msgp.DefaultUnmarshalState)
}
func (_ *ephemeralSubkey) CanUnmarshalMsg(z interface{}) bool {
	_, ok := (z).(*ephemeralSubkey)
	return ok
}

// Msgsize returns an upper bound estimate of the number of bytes occupied by the serialized message
func (z *ephemeralSubkey) Msgsize() (s int) {
	s = 1 + 3 + msgp.ArrayHeaderSize + (32 * (msgp.ByteSize)) + 3 + msgp.ArrayHeaderSize + (64 * (msgp.ByteSize)) + 6 + msgp.ArrayHeaderSize + (64 * (msgp.ByteSize)) + 5 + msgp.ArrayHeaderSize + (64 * (msgp.ByteSize))
	return
}

// MsgIsZero returns whether this is a zero value
func (z *ephemeralSubkey) MsgIsZero() bool {
	return ((*z).PK == (ed25519PublicKey{})) && ((*z).SK == (ed25519PrivateKey{})) && ((*z).PKSigOld == (ed25519Signature{})) && ((*z).PKSigNew == (ed25519Signature{}))
}

// MaxSize returns a maximum valid message size for this message type
func EphemeralSubkeyMaxSize() (s int) {
	s = 1 + 3
	// Calculating size of array: z.PK
	s += msgp.ArrayHeaderSize + ((32) * (msgp.ByteSize))
	s += 3
	// Calculating size of array: z.SK
	s += msgp.ArrayHeaderSize + ((64) * (msgp.ByteSize))
	s += 6
	// Calculating size of array: z.PKSigOld
	s += msgp.ArrayHeaderSize + ((64) * (msgp.ByteSize))
	s += 5
	// Calculating size of array: z.PKSigNew
	s += msgp.ArrayHeaderSize + ((64) * (msgp.ByteSize))
	return
}
