package org.jmeld.ui;

import org.jdesktop.layout.*;
import org.jmeld.ui.action.MeldAction;
import org.jmeld.ui.swing.DiffLabel;
import org.jmeld.ui.swing.table.JMTreeTable;
import org.jmeld.ui.swing.table.JMTreeTableModel;
import org.jmeld.util.file.FolderDiff;
import org.jmeld.util.file.VersionControlDiff;
import org.jmeld.vc.VersionControlIF;
import org.jmeld.vc.VersionControlUtil;

import javax.swing.*;
import javax.swing.GroupLayout;
import javax.swing.LayoutStyle;
import javax.swing.border.EmptyBorder;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

/**
 * Created by alberto on 7/01/15.
 */
public class VersionControlFolderDiffPanel extends FolderDiffPanel {

    public static final String SEPARATOR = "SEPARATOR";

    protected JComboBox<String> revisionComboBox;

    VersionControlFolderDiffPanel(JMeldPanel mainPanel, VersionControlDiff diff) {
        super(mainPanel, diff);
    }

    public JComboBox<String> getRevisionComboBox() {
        return revisionComboBox;
    }

    @Override
    protected void init() {
        VersionControlDiff versionControlDiff = (VersionControlDiff) diff;
        File file = versionControlDiff.getFile();
        VersionControlIF versionControl = versionControlDiff.getVersionControl();
        revisionComboBox.setModel(new DefaultComboBoxModel<>(versionControl.getRevisions(file)));
        revisionComboBox.addActionListener(new BlockComboListener());
        revisionComboBox.setRenderer(new ComboBoxRenderer());
        revisionComboBox.setFocusable(false);
        super.init();
    }

    @Override
    protected void initActions() {
        super.initActions();
        MeldAction action = actionHandler.createAction(this, mainPanel.actions.FOLDER_FILTER);
        revisionComboBox.setAction(action);
    }

    public void doFilter(ActionEvent ae) {
        treeTableModel = null;
        ((VersionControlDiff)diff).getVersionControl().setReference((String)getRevisionComboBox().getSelectedItem());
        diff.diff();
        super.doFilter(ae);
    }

    class ComboBoxRenderer extends JLabel implements ListCellRenderer<String> {
        JSeparator separator;

        public ComboBoxRenderer() {
            setOpaque(true);
            separator = new JSeparator(JSeparator.HORIZONTAL);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends String> list, String value
                , int index, boolean isSelected, boolean cellHasFocus) {
            String str = (value == null) ? "" : value;
            if (SEPARATOR.equals(str)) {
                return separator;
            }
            if (isSelected) {
                setBackground(list.getSelectionBackground());
                setForeground(list.getSelectionForeground());
            } else {
                setBackground(list.getBackground());
                setForeground(list.getForeground());
            }
            setFont(list.getFont());
            setText(str);
            return this;
        }
    }

    class BlockComboListener implements ActionListener {
        Object currentItem;

        BlockComboListener() {
            currentItem = 0;
        }

        public void actionPerformed(ActionEvent e) {
            JComboBox combo = (JComboBox) e.getSource();
            String tempItem = (String) combo.getSelectedItem();
            if (SEPARATOR.equals(tempItem)) {
                if (currentItem != null) {
                    combo.setSelectedItem(currentItem);
                }
            } else {
                currentItem = tempItem;
            }
        }
    }

    /**
     * This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    protected void initComponents() {

        folder1Label = new DiffLabel();
        folder2Label = new DiffLabel();
        jScrollPane1 = new JScrollPane();
        folderTreeTable = new JMTreeTable();
        onlyRightButton = new JToggleButton();
        leftRightChangedButton = new JToggleButton();
        onlyLeftButton = new JToggleButton();
        leftRightUnChangedButton = new JToggleButton();
        hierarchyComboBox = new JComboBox();
        revisionComboBox = new JComboBox();
        expandAllButton = new JButton();
        collapseAllButton = new JButton();
        deleteLeftButton = new JButton();
        copyToLeftButton = new JButton();
        copyToRightButton = new JButton();
        deleteRightButton = new JButton();
        refreshButton = new JButton();
        compareButton = new JButton();

        folder1Label.setText("Left name of directory");

        folder2Label.setText("Right name of directory");

        jScrollPane1.setViewportView(folderTreeTable);

        onlyRightButton.setText("R");

        leftRightChangedButton.setText("LR");

        onlyLeftButton.setText("L");

        leftRightUnChangedButton.setText("Un");

        hierarchyComboBox.setModel(new DefaultComboBoxModel(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        revisionComboBox.setModel(new DefaultComboBoxModel(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));

        expandAllButton.setText("Exp");

        collapseAllButton.setText("Col");

        deleteLeftButton.setText("DL");
        deleteLeftButton.setMargin(new java.awt.Insets(2, 2, 2, 2));

        copyToLeftButton.setText("CL");
        copyToLeftButton.setMargin(new java.awt.Insets(2, 2, 2, 2));

        copyToRightButton.setText("CR");
        copyToRightButton.setMargin(new java.awt.Insets(2, 2, 2, 2));

        deleteRightButton.setText("DR");
        deleteRightButton.setMargin(new java.awt.Insets(2, 2, 2, 2));

        refreshButton.setText("RS");
        refreshButton.setMargin(new java.awt.Insets(2, 2, 2, 2));

        compareButton.setText("CO");
        compareButton.setMargin(new java.awt.Insets(2, 2, 2, 2));

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(
                this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(
                org.jdesktop.layout.GroupLayout.LEADING).add(
                layout.createSequentialGroup().addContainerGap().add(
                        layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                                .add(
                                        org.jdesktop.layout.GroupLayout.TRAILING,
                                        layout.createSequentialGroup().add(
                                                layout.createParallelGroup(
                                                        org.jdesktop.layout.GroupLayout.LEADING).add(folder1Label,
                                                        org.jdesktop.layout.GroupLayout.PREFERRED_SIZE,
                                                        org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
                                                        org.jdesktop.layout.GroupLayout.PREFERRED_SIZE).add(
                                                        layout.createSequentialGroup().add(expandAllButton)
                                                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                                                .add(collapseAllButton).addPreferredGap(
                                                                org.jdesktop.layout.LayoutStyle.RELATED).add(
                                                                hierarchyComboBox,
                                                                org.jdesktop.layout.GroupLayout.PREFERRED_SIZE,
                                                                org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
                                                                org.jdesktop.layout.GroupLayout.PREFERRED_SIZE).add(
                                                                revisionComboBox,
                                                                org.jdesktop.layout.GroupLayout.PREFERRED_SIZE,
                                                                org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
                                                                org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
                                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                                .add(compareButton).addPreferredGap(
                                                org.jdesktop.layout.LayoutStyle.RELATED).add(refreshButton)
                                                .add(59, 59, 59).add(deleteLeftButton).addPreferredGap(
                                                org.jdesktop.layout.LayoutStyle.RELATED).add(
                                                copyToLeftButton).add(18, 18, 18).add(copyToRightButton)
                                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                                .add(deleteRightButton).addPreferredGap(
                                                org.jdesktop.layout.LayoutStyle.RELATED, 199,
                                                Short.MAX_VALUE).add(
                                                layout.createParallelGroup(
                                                        org.jdesktop.layout.GroupLayout.TRAILING).add(
                                                        layout.createSequentialGroup().add(onlyLeftButton)
                                                                .addPreferredGap(
                                                                        org.jdesktop.layout.LayoutStyle.RELATED).add(
                                                                leftRightChangedButton).addPreferredGap(
                                                                org.jdesktop.layout.LayoutStyle.RELATED).add(
                                                                onlyRightButton).addPreferredGap(
                                                                org.jdesktop.layout.LayoutStyle.RELATED).add(
                                                                leftRightUnChangedButton)).add(folder2Label,
                                                        org.jdesktop.layout.GroupLayout.PREFERRED_SIZE,
                                                        org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
                                                        org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))).add(
                                jScrollPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 875,
                                Short.MAX_VALUE)).addContainerGap()));

        layout.linkSize(new Component[]{leftRightChangedButton,
                        leftRightUnChangedButton, onlyLeftButton, onlyRightButton},
                org.jdesktop.layout.GroupLayout.HORIZONTAL);

        layout.setVerticalGroup(layout.createParallelGroup(
                org.jdesktop.layout.GroupLayout.LEADING).add(
                layout.createSequentialGroup().addContainerGap().add(
                        layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                                .add(folder1Label, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE,
                                        org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
                                        org.jdesktop.layout.GroupLayout.PREFERRED_SIZE).add(folder2Label,
                                org.jdesktop.layout.GroupLayout.PREFERRED_SIZE,
                                org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
                                org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)).addPreferredGap(
                        org.jdesktop.layout.LayoutStyle.RELATED).add(
                        layout.createParallelGroup(org.jdesktop.layout.GroupLayout.CENTER).add(
                                expandAllButton).add(collapseAllButton).add(hierarchyComboBox,
                                org.jdesktop.layout.GroupLayout.PREFERRED_SIZE,
                                org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
                                org.jdesktop.layout.GroupLayout.PREFERRED_SIZE).add(revisionComboBox,
                                org.jdesktop.layout.GroupLayout.PREFERRED_SIZE,
                                org.jdesktop.layout.GroupLayout.DEFAULT_SIZE,
                                org.jdesktop.layout.GroupLayout.PREFERRED_SIZE).add(compareButton)
                                .add(refreshButton).add(deleteLeftButton).add(copyToLeftButton)
                                .add(copyToRightButton).add(deleteRightButton).add(onlyLeftButton)
                                .add(leftRightChangedButton).add(onlyRightButton).add(
                                leftRightUnChangedButton)).addPreferredGap(
                        org.jdesktop.layout.LayoutStyle.RELATED).add(jScrollPane1,
                        org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 362, Short.MAX_VALUE)
                        .addContainerGap()));
    }// </editor-fold>//GEN-END:initComponents

    @Override
    protected JMTreeTableModel createTreeTableModel() {
        return new VersionControlTreeTableModel();
    }
}
