/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeUtils {
    private static final int WRAPPER_TYPE_INDEX = 0;
    private static final int PRIMITIVE_TYPE_INDEX = 1;
    private static final int PRIMITIVE_TYPE_KEY_INDEX = 2;
    private static final Object[][] PRIMITIVE_ARRAY_TYPES = new Object[][]{{Boolean.class, Boolean.TYPE, "Z"}, {Character.class, Character.TYPE, "C"}, {Byte.class, Byte.TYPE, "B"}, {Short.class, Short.TYPE, "S"}, {Integer.class, Integer.TYPE, "I"}, {Long.class, Long.TYPE, "J"}, {Float.class, Float.TYPE, "F"}, {Double.class, Double.TYPE, "D"}};

    public static boolean isPrimitive(Class<?> primitive) {
        for (Object[] primitiveArrayType : PRIMITIVE_ARRAY_TYPES) {
            if (primitiveArrayType[1] != primitive) continue;
            return true;
        }
        return false;
    }

    public static boolean isPrimitiveWrapper(Class<?> wrapperType) {
        for (Object[] primitiveArrayType : PRIMITIVE_ARRAY_TYPES) {
            if (primitiveArrayType[0] != wrapperType) continue;
            return true;
        }
        return false;
    }

    public static Class<?> convertPrimitiveToWrapperType(Class<?> primitive) {
        for (Object[] primitiveArrayType : PRIMITIVE_ARRAY_TYPES) {
            if (primitiveArrayType[1] != primitive) continue;
            return (Class)primitiveArrayType[0];
        }
        return primitive;
    }

    public static Class<?> convertWrapperToPrimitiveType(Class<?> primitive) {
        for (Object[] primitiveArrayType : PRIMITIVE_ARRAY_TYPES) {
            if (primitiveArrayType[0] != primitive) continue;
            return (Class)primitiveArrayType[1];
        }
        return primitive;
    }

    public static boolean isNumericType(Class<?> type) {
        return Number.class.isAssignableFrom(type) || type == Double.TYPE || type == Integer.TYPE || type == Float.TYPE || type == Short.TYPE || type == Long.TYPE;
    }
}

