/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.Searchable;
import com.jidesoft.swing.event.SearchableEvent;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class TableSearchable
extends Searchable
implements TableModelListener,
PropertyChangeListener {
    private int[] _searchColumnIndices = new int[]{0};

    public TableSearchable(JTable table) {
        super(table);
    }

    public void installListeners() {
        super.installListeners();
        if (this._component instanceof JTable) {
            ((JTable)this._component).getModel().addTableModelListener(this);
            this._component.addPropertyChangeListener("model", this);
        }
    }

    public void uninstallListeners() {
        super.uninstallListeners();
        if (this._component instanceof JTable) {
            ((JTable)this._component).getModel().removeTableModelListener(this);
            this._component.removePropertyChangeListener("model", this);
        }
    }

    protected void setSelectedIndex(int index, boolean incremental) {
        JTable table = (JTable)this._component;
        if (this.isColumnSelectionAllowed(table)) {
            int majorIndex = index;
            int minorIndex = this.getMainIndex();
            this.addTableSelection(table, majorIndex, minorIndex, incremental);
        } else if (this.isRowSelectionAllowed(table)) {
            int majorIndex = index;
            int minorIndex = this.getMainIndex();
            this.addTableSelection(table, majorIndex, minorIndex, incremental);
        } else {
            int majorIndex = index / table.getColumnCount();
            int minorIndex = index % table.getColumnCount();
            this.addTableSelection(table, majorIndex, minorIndex, incremental);
        }
    }

    protected void addTableSelection(JTable table, int rowIndex, int columnIndex, boolean incremental) {
        if (!incremental) {
            table.clearSelection();
        }
        if (rowIndex >= 0 && columnIndex >= 0 && rowIndex < table.getRowCount() && columnIndex < table.getColumnCount() && !table.isCellSelected(rowIndex, columnIndex)) {
            table.changeSelection(rowIndex, columnIndex, true, false);
        }
    }

    protected boolean isColumnSelectionAllowed(JTable table) {
        return this.getSearchColumnIndices().length == 1 && table.getColumnSelectionAllowed() && !table.getRowSelectionAllowed();
    }

    protected boolean isRowSelectionAllowed(JTable table) {
        return this.getSearchColumnIndices().length == 1 && !table.getColumnSelectionAllowed() && table.getRowSelectionAllowed();
    }

    protected boolean isSearchSelectedRows() {
        return this.getSearchColumnIndices().length > 1;
    }

    protected int getSelectedIndex() {
        JTable table = (JTable)this._component;
        if (this.isColumnSelectionAllowed(table)) {
            return table.getSelectedColumn();
        }
        if (this.isRowSelectionAllowed(table)) {
            return table.getSelectedRow();
        }
        return table.getSelectedRow() * table.getColumnCount() + table.getSelectedColumn();
    }

    protected Object getElementAt(int index) {
        JTable table = (JTable)this._component;
        if (this.isColumnSelectionAllowed(table)) {
            return this.getValueAt(table, this.getMainIndex(), index);
        }
        if (this.isRowSelectionAllowed(table)) {
            return this.getValueAt(table, index, this.getMainIndex());
        }
        if (this.isSearchSelectedRows()) {
            int columnIndex = index % table.getColumnCount();
            boolean doNotSearch = true;
            for (int i : this.getSearchColumnIndices()) {
                if (i != columnIndex) continue;
                doNotSearch = false;
            }
            if (doNotSearch) {
                return null;
            }
            int rowIndex = index / table.getColumnCount();
            return this.getValueAt(table, rowIndex, columnIndex);
        }
        int columnIndex = index % table.getColumnCount();
        int rowIndex = index / table.getColumnCount();
        return this.getValueAt(table, rowIndex, columnIndex);
    }

    private Object getValueAt(JTable table, int rowIndex, int columnIndex) {
        if (rowIndex >= 0 && rowIndex < table.getRowCount() && columnIndex >= 0 && columnIndex < table.getColumnCount()) {
            return table.getValueAt(rowIndex, columnIndex);
        }
        return null;
    }

    protected int getElementCount() {
        JTable table = (JTable)this._component;
        if (this.isColumnSelectionAllowed(table)) {
            return table.getColumnCount();
        }
        if (this.isRowSelectionAllowed(table)) {
            return table.getRowCount();
        }
        return table.getColumnCount() * table.getRowCount();
    }

    protected String convertElementToString(Object item) {
        if (item != null) {
            return item.toString();
        }
        return "";
    }

    public int[] getSearchColumnIndices() {
        return this._searchColumnIndices;
    }

    public int getMainIndex() {
        if (this._searchColumnIndices.length == 0) {
            return -1;
        }
        return this._searchColumnIndices[0];
    }

    public void setSearchColumnIndices(int[] columnIndices) {
        int[] old;
        if (columnIndices == null) {
            columnIndices = new int[]{};
        }
        if (!JideSwingUtilities.equals(old = this._searchColumnIndices, columnIndices, true)) {
            this._searchColumnIndices = columnIndices;
            this.hidePopup();
        }
    }

    public void setMainIndex(int mainIndex) {
        int[] old;
        int[] temp = new int[]{mainIndex};
        if (mainIndex < 0) {
            temp = new int[]{};
        }
        if ((old = this._searchColumnIndices) != temp) {
            this._searchColumnIndices = temp;
            this.hidePopup();
        }
    }

    protected boolean isFindNextKey(KeyEvent e) {
        int keyCode = e.getKeyCode();
        JTable table = (JTable)this._component;
        if (this.isColumnSelectionAllowed(table)) {
            return keyCode == 39;
        }
        if (this.isRowSelectionAllowed(table)) {
            return keyCode == 40;
        }
        return keyCode == 40 || keyCode == 39;
    }

    protected boolean isFindPreviousKey(KeyEvent e) {
        int keyCode = e.getKeyCode();
        JTable table = (JTable)this._component;
        if (this.isColumnSelectionAllowed(table)) {
            return keyCode == 37;
        }
        if (this.isRowSelectionAllowed(table)) {
            return keyCode == 38;
        }
        return keyCode == 38 || keyCode == 37;
    }

    public void tableChanged(TableModelEvent e) {
        this.hidePopup();
        this.fireSearchableEvent(new SearchableEvent(this, 3005));
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("model".equals(evt.getPropertyName())) {
            this.hidePopup();
            if (evt.getOldValue() instanceof TableModel) {
                ((TableModel)evt.getOldValue()).removeTableModelListener(this);
            }
            if (evt.getNewValue() instanceof TableModel) {
                ((TableModel)evt.getNewValue()).addTableModelListener(this);
            }
            this.fireSearchableEvent(new SearchableEvent(this, 3005));
        }
    }

    protected boolean isActivateKey(KeyEvent e) {
        boolean editable = this.isSelectedCellEditable();
        return !editable && super.isActivateKey(e);
    }

    protected boolean isSelectedCellEditable() {
        int selectedRow = ((JTable)this._component).getSelectedRow();
        int selectedColumn = ((JTable)this._component).getSelectedColumn();
        return selectedRow != -1 && selectedColumn != -1 && ((JTable)this._component).isCellEditable(selectedRow, selectedColumn);
    }
}

