/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.swing.JideButton;
import com.jidesoft.swing.ScrollPaneOverview;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.GeneralPath;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.JScrollPane;
import javax.swing.plaf.UIResource;

public class CornerScroller
extends JideButton {
    protected ScrollPaneOverview _scrollPaneBidule;

    public CornerScroller(JScrollPane scrollPane) {
        this._scrollPaneBidule = new ScrollPaneOverview(scrollPane, this);
        this.setFocusPainted(false);
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CornerScroller.this._scrollPaneBidule.display();
            }
        });
        this.setBorderPainted(false);
        this.setIcon(new ScrollerIcon());
        this.setPreferredSize(new Dimension(16, 16));
    }

    public void setSelectionBorderColor(Color selectionBorder) {
        if (this._scrollPaneBidule != null) {
            this._scrollPaneBidule.setSelectionBorderColor(selectionBorder);
        }
    }

    private static class ScrollerIcon
    implements Icon,
    UIResource,
    Serializable {
        private ScrollerIcon() {
        }

        public int getIconHeight() {
            return 16;
        }

        public int getIconWidth() {
            return 16;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2d = (Graphics2D)g;
            Object oldrenderinghint = g2d.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            GeneralPath path = new GeneralPath();
            int mx = x + this.getIconWidth() / 2;
            int my = y + this.getIconHeight() / 2;
            int gap = 4;
            path.moveTo(mx - gap, my - 2);
            path.lineTo(mx - gap - 2, my);
            path.lineTo(mx - gap, my + 2);
            path.moveTo(mx - 2, my - gap);
            path.lineTo(mx, my - gap - 2);
            path.lineTo(mx + 2, my - gap);
            path.moveTo(mx + gap, my - 2);
            path.lineTo(mx + gap + 2, my);
            path.lineTo(mx + gap, my + 2);
            path.moveTo(mx - 2, my + gap);
            path.lineTo(mx, my + gap + 2);
            path.lineTo(mx + 2, my + gap);
            g.setColor(Color.GRAY);
            g2d.draw(path);
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldrenderinghint);
        }
    }
}

