/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.swing.StyleRange;
import com.jidesoft.swing.StyledLabel;
import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicLabelUI;
import javax.swing.text.View;

public class BasicStyledLabelUI
extends BasicLabelUI
implements SwingConstants {
    public static Comparator<StyleRange> _comparator;
    protected static BasicStyledLabelUI styledLabelUI;
    private List<StyledText> _styledTexts;

    public static ComponentUI createUI(JComponent c) {
        return styledLabelUI;
    }

    public void propertyChange(PropertyChangeEvent e) {
        super.propertyChange(e);
        if ("styleRange".equals(e.getPropertyName())) {
            this._styledTexts = null;
            if (e.getSource() instanceof StyledLabel) {
                ((StyledLabel)e.getSource()).revalidate();
                ((StyledLabel)e.getSource()).repaint();
            }
        } else if ("ignoreColorSettings".equals(e.getPropertyName()) && e.getSource() instanceof StyledLabel) {
            ((StyledLabel)e.getSource()).repaint();
        }
    }

    protected void paintEnabledText(JLabel l, Graphics g, String s, int textX, int textY) {
        View v;
        View view = v = l != null ? (View)l.getClientProperty("html") : null;
        if (v != null) {
            super.paintEnabledText(l, g, s, textX, textY);
        } else {
            this.paintStyledText((StyledLabel)l, g, textX, textY);
        }
    }

    protected void paintDisabledText(JLabel l, Graphics g, String s, int textX, int textY) {
        View v;
        View view = v = l != null ? (View)l.getClientProperty("html") : null;
        if (v != null) {
            super.paintDisabledText(l, g, s, textX, textY);
        } else {
            this.paintStyledText((StyledLabel)l, g, textX, textY);
        }
    }

    protected void buildStyledText(StyledLabel label) {
        if (this._styledTexts == null) {
            this._styledTexts = new ArrayList<StyledText>();
        } else {
            this._styledTexts.clear();
        }
        StyleRange[] styleRanges = label.getStyleRanges();
        if (_comparator == null) {
            _comparator = new Comparator<StyleRange>(){

                @Override
                public int compare(StyleRange r1, StyleRange r2) {
                    if (r1.getStart() < r2.getStart()) {
                        return -1;
                    }
                    if (r1.getStart() > r2.getStart()) {
                        return 1;
                    }
                    return 0;
                }
            };
        }
        Arrays.sort(styleRanges, _comparator);
        String s = label.getText();
        if (s != null && s.length() > 0) {
            int index = 0;
            for (StyleRange styleRange : styleRanges) {
                if (styleRange.getStart() > index) {
                    this._styledTexts.add(new StyledText(s.substring(index, styleRange.getStart())));
                    index = styleRange.getStart();
                }
                if (styleRange.getStart() == index) {
                    if (styleRange.getLength() == -1) {
                        this._styledTexts.add(new StyledText(s.substring(index), styleRange));
                        index = s.length();
                        continue;
                    }
                    this._styledTexts.add(new StyledText(s.substring(index, index + styleRange.getLength()), styleRange));
                    index += styleRange.getLength();
                    continue;
                }
                if (styleRange.getStart() >= index) continue;
            }
            if (index < s.length()) {
                this._styledTexts.add(new StyledText(s.substring(index, s.length())));
            }
        }
    }

    protected String layoutCL(JLabel label, FontMetrics fontMetrics, String text, Icon icon, Rectangle viewR, Rectangle iconR, Rectangle textR) {
        Dimension size = this.getPreferredSize((StyledLabel)label);
        textR.width = size.width;
        textR.height = size.height;
        return BasicStyledLabelUI.layoutCompoundLabel(label, fontMetrics, text, icon, label.getVerticalAlignment(), label.getHorizontalAlignment(), label.getVerticalTextPosition(), label.getHorizontalTextPosition(), viewR, iconR, textR, label.getIconTextGap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Dimension getPreferredSize(StyledLabel label) {
        this.buildStyledText(label);
        int width = 0;
        Font font = this.getFont(label);
        FontMetrics fm = label.getFontMetrics(font);
        int lineHeight = 0;
        int defaultFontSize = font.getSize();
        List<StyledText> list = this._styledTexts;
        synchronized (list) {
            StyledText[] texts = this._styledTexts.toArray(new StyledText[this._styledTexts.size()]);
            for (int i = texts.length - 1; i >= 0; --i) {
                FontMetrics fm2;
                StyledText styledText = texts[i];
                StyleRange style = styledText.styleRange;
                float size = style != null && (style.isSuperscript() || style.isSubscript()) ? (float)Math.round((float)defaultFontSize / style.getFontShrinkRatio()) : (float)defaultFontSize;
                font = this.getFont(label);
                if (style != null && (style.getFontStyle() != -1 && font.getStyle() != style.getFontStyle() || (float)font.getSize() != size)) {
                    font = font.deriveFont(style.getFontStyle() == -1 ? font.getStyle() : style.getFontStyle(), size);
                    fm2 = label.getFontMetrics(font);
                    width += fm2.stringWidth(styledText.text);
                } else {
                    fm2 = fm;
                    width += fm.stringWidth(styledText.text);
                }
                if (style == null) continue;
                if (style.isUnderlined() && lineHeight < 2) {
                    lineHeight = 2;
                }
                if (style.isDotted() && lineHeight < 3) {
                    lineHeight = 3;
                }
                if (!style.isWaved() || lineHeight >= 4) continue;
                lineHeight = 4;
            }
        }
        int fontHeight = fm.getHeight();
        return new Dimension(width, fontHeight + lineHeight);
    }

    protected Font getFont(StyledLabel label) {
        Font font = label.getFont();
        if (font == null) {
            font = UIDefaultsLookup.getFont("Label.font");
        }
        return font;
    }

    protected void paintStyledText(StyledLabel label, Graphics g, int textX, int textY) {
        int x = textX < label.getInsets().left ? label.getInsets().left : textX;
        int mnemonicIndex = label.getDisplayedMnemonicIndex();
        if (UIManager.getLookAndFeel() instanceof WindowsLookAndFeel && WindowsLookAndFeel.isMnemonicHidden()) {
            mnemonicIndex = -1;
        }
        this.buildStyledText(label);
        Color oldColor = g.getColor();
        int charDisplayed = 0;
        boolean displayMnemonic = false;
        int mneIndex = 0;
        Font font = this.getFont(label);
        FontMetrics fm = label.getFontMetrics(font);
        int defaultFontSize = font.getSize();
        for (StyledText styledText : this._styledTexts) {
            Color textColor;
            FontMetrics fm2;
            StyleRange style = styledText.styleRange;
            if (styledText.text.length() > mnemonicIndex - charDisplayed) {
                displayMnemonic = true;
                mneIndex = mnemonicIndex - charDisplayed;
            }
            charDisplayed += styledText.text.length();
            int y = textY;
            float size = style != null && (style.isSuperscript() || style.isSubscript()) ? (float)Math.round((float)defaultFontSize / style.getFontShrinkRatio()) : (float)defaultFontSize;
            font = this.getFont(label);
            if (style != null && (style.getFontStyle() != -1 && font.getStyle() != style.getFontStyle() || (float)font.getSize() != size)) {
                font = font.deriveFont(style.getFontStyle() == -1 ? font.getStyle() : style.getFontStyle(), size);
                fm2 = label.getFontMetrics(font);
            } else {
                fm2 = fm;
            }
            g.setFont(font);
            String s = styledText.text;
            int strWidth = fm2.stringWidth(s);
            boolean stop = false;
            int widthLeft = label.getWidth() - x;
            if (widthLeft < strWidth) {
                s = SwingUtilities.layoutCompoundLabel(label, fm2, s, null, label.getVerticalAlignment(), label.getHorizontalAlignment(), label.getVerticalTextPosition(), label.getHorizontalTextPosition(), new Rectangle(x, y, widthLeft, label.getHeight()), new Rectangle(), new Rectangle(), 0);
                strWidth = fm2.stringWidth(s);
                stop = true;
            }
            if (style != null && style.isSuperscript()) {
                y -= fm.getHeight() - fm2.getHeight();
            }
            if (style != null && style.getBackgroundColor() != null) {
                g.setColor(style.getBackgroundColor());
                g.fillRect(x, y - fm2.getHeight(), strWidth, fm2.getHeight() + 4);
            }
            Color color = textColor = style != null && !label.isIgnoreColorSettings() && style.getFontColor() != null ? style.getFontColor() : label.getForeground();
            if (!label.isEnabled()) {
                textColor = UIDefaultsLookup.getColor("Label.disabledForeground");
            }
            g.setColor(textColor);
            if (displayMnemonic) {
                JideSwingUtilities.drawStringUnderlineCharAt(label, g, s, mneIndex, x, y);
            } else {
                JideSwingUtilities.drawString(label, g, s, x, y);
            }
            if (style != null) {
                int lineY;
                Stroke oldStroke = ((Graphics2D)g).getStroke();
                if (style.getLineStroke() != null) {
                    ((Graphics2D)g).setStroke(style.getLineStroke());
                }
                if (!label.isIgnoreColorSettings() && style.getLineColor() != null) {
                    g.setColor(style.getLineColor());
                }
                if (style.isStrikethrough()) {
                    lineY = y + (fm2.getDescent() - fm2.getAscent()) / 2;
                    g.drawLine(x, lineY, x + strWidth - 1, lineY);
                }
                if (style.isDoublestrikethrough()) {
                    lineY = y + (fm2.getDescent() - fm2.getAscent()) / 2;
                    g.drawLine(x, lineY - 1, x + strWidth - 1, lineY - 1);
                    g.drawLine(x, lineY + 1, x + strWidth - 1, lineY + 1);
                }
                if (style.isUnderlined()) {
                    lineY = y + 1;
                    g.drawLine(x, lineY, x + strWidth - 1, lineY);
                }
                if (style.isDotted()) {
                    int dotY = y + 1;
                    for (int dotX = x; dotX < x + strWidth; dotX += 4) {
                        g.drawRect(dotX, dotY, 1, 1);
                    }
                }
                if (style.isWaved()) {
                    int waveY = y + 1;
                    for (int waveX = x; waveX < x + strWidth; waveX += 4) {
                        if (waveX + 2 <= x + strWidth - 1) {
                            g.drawLine(waveX, waveY + 2, waveX + 2, waveY);
                        }
                        if (waveX + 4 > x + strWidth - 1) continue;
                        g.drawLine(waveX + 3, waveY + 1, waveX + 4, waveY + 2);
                    }
                }
                if (style.getLineStroke() != null) {
                    ((Graphics2D)g).setStroke(oldStroke);
                }
            }
            if (stop) break;
            x += strWidth;
        }
        g.setColor(oldColor);
    }

    public static String layoutCompoundLabel(JComponent c, FontMetrics fm, String text, Icon icon, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewR, Rectangle iconR, Rectangle textR, int textIconGap) {
        boolean orientationIsLeftToRight = true;
        int hAlign = horizontalAlignment;
        int hTextPos = horizontalTextPosition;
        if (c != null && !c.getComponentOrientation().isLeftToRight()) {
            orientationIsLeftToRight = false;
        }
        switch (horizontalAlignment) {
            case 10: {
                hAlign = orientationIsLeftToRight ? 2 : 4;
                break;
            }
            case 11: {
                hAlign = orientationIsLeftToRight ? 4 : 2;
            }
        }
        switch (horizontalTextPosition) {
            case 10: {
                hTextPos = orientationIsLeftToRight ? 2 : 4;
                break;
            }
            case 11: {
                hTextPos = orientationIsLeftToRight ? 4 : 2;
            }
        }
        return BasicStyledLabelUI.layoutCompoundLabelImpl(c, fm, text, icon, verticalAlignment, hAlign, verticalTextPosition, hTextPos, viewR, iconR, textR, textIconGap);
    }

    public static String layoutCompoundLabel(FontMetrics fm, String text, Icon icon, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewR, Rectangle iconR, Rectangle textR, int textIconGap) {
        return BasicStyledLabelUI.layoutCompoundLabelImpl(null, fm, text, icon, verticalAlignment, horizontalAlignment, verticalTextPosition, horizontalTextPosition, viewR, iconR, textR, textIconGap);
    }

    private static String layoutCompoundLabelImpl(JComponent c, FontMetrics fm, String text, Icon icon, int verticalAlignment, int horizontalAlignment, int verticalTextPosition, int horizontalTextPosition, Rectangle viewR, Rectangle iconR, Rectangle textR, int textIconGap) {
        int gap;
        if (icon != null) {
            iconR.width = icon.getIconWidth();
            iconR.height = icon.getIconHeight();
        } else {
            iconR.height = 0;
            iconR.width = 0;
        }
        boolean textIsEmpty = text == null || text.equals("");
        int lsb = 0;
        View v = null;
        if (textIsEmpty) {
            textR.height = 0;
            textR.width = 0;
            text = "";
            gap = 0;
        } else {
            gap = icon == null ? 0 : textIconGap;
            int availTextWidth = horizontalTextPosition == 0 ? viewR.width : viewR.width - (iconR.width + gap);
            View view = v = c != null ? (View)c.getClientProperty("html") : null;
            if (v != null) {
                textR.width = Math.min(availTextWidth, (int)v.getPreferredSpan(0));
                textR.height = (int)v.getPreferredSpan(1);
            }
        }
        textR.y = verticalTextPosition == 1 ? (horizontalTextPosition != 0 ? 0 : -(textR.height + gap)) : (verticalTextPosition == 0 ? iconR.height / 2 - textR.height / 2 : (horizontalTextPosition != 0 ? iconR.height - textR.height : iconR.height + gap));
        textR.x = horizontalTextPosition == 2 ? -(textR.width + gap) : (horizontalTextPosition == 0 ? iconR.width / 2 - textR.width / 2 : iconR.width + gap);
        int labelR_x = Math.min(iconR.x, textR.x);
        int labelR_width = Math.max(iconR.x + iconR.width, textR.x + textR.width) - labelR_x;
        int labelR_y = Math.min(iconR.y, textR.y);
        int labelR_height = Math.max(iconR.y + iconR.height, textR.y + textR.height) - labelR_y;
        int dy = verticalAlignment == 1 ? viewR.y - labelR_y : (verticalAlignment == 0 ? viewR.y + viewR.height / 2 - (labelR_y + labelR_height / 2) : viewR.y + viewR.height - (labelR_y + labelR_height));
        int dx = horizontalAlignment == 2 ? viewR.x - labelR_x : (horizontalAlignment == 4 ? viewR.x + viewR.width - (labelR_x + labelR_width) : viewR.x + viewR.width / 2 - (labelR_x + labelR_width / 2));
        textR.x += dx;
        textR.y += dy;
        iconR.x += dx;
        iconR.y += dy;
        if (lsb < 0) {
            textR.x -= lsb;
        }
        return text;
    }

    static {
        styledLabelUI = new BasicStyledLabelUI();
    }

    class StyledText {
        StyleRange styleRange;
        String text;

        public StyledText(String text) {
            this.text = text;
        }

        public StyledText(String text, StyleRange styleRange) {
            this.text = text;
            this.styleRange = styleRange;
        }
    }
}

