/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.hints;

import com.jidesoft.hints.IntelliHints;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.popup.JidePopup;
import com.jidesoft.popup.JidePopupFactory;
import com.jidesoft.swing.DelegateAction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;

public abstract class AbstractIntelliHints
implements IntelliHints {
    private JidePopup _popup;
    private JTextComponent _textComponent;
    private boolean _followCaret = false;
    private boolean _keyTyped = false;
    private boolean _autoPopup = true;
    private DelegateAction acceptAction = new DelegateAction(){

        public boolean delegateActionPerformed(ActionEvent e) {
            JComponent tf = (JComponent)e.getSource();
            IntelliHints hints = AbstractIntelliHints.getIntelliHints(tf);
            if (hints instanceof AbstractIntelliHints) {
                JButton button;
                AbstractIntelliHints aih = (AbstractIntelliHints)hints;
                aih.hideHintsPopup();
                if (aih.getSelectedHint() != null) {
                    aih.setHintsEnabled(false);
                    aih.acceptHint(hints.getSelectedHint());
                    aih.setHintsEnabled(true);
                    return true;
                }
                if (AbstractIntelliHints.this.getTextComponent().getRootPane() != null && (button = AbstractIntelliHints.this.getTextComponent().getRootPane().getDefaultButton()) != null) {
                    button.doClick();
                    return true;
                }
            }
            return false;
        }
    };
    private static DelegateAction showAction = new DelegateAction(){

        public boolean delegateActionPerformed(ActionEvent e) {
            JComponent tf = (JComponent)e.getSource();
            IntelliHints hints = AbstractIntelliHints.getIntelliHints(tf);
            if (hints instanceof AbstractIntelliHints) {
                AbstractIntelliHints aih = (AbstractIntelliHints)hints;
                if (tf.isEnabled() && !aih.isHintsPopupVisible()) {
                    aih.showHintsPopup();
                    return true;
                }
            }
            return false;
        }
    };
    private DelegateAction hideAction = new DelegateAction(){

        public boolean isEnabled() {
            return AbstractIntelliHints.this._textComponent.isEnabled() && AbstractIntelliHints.this.isHintsPopupVisible();
        }

        public boolean delegateActionPerformed(ActionEvent e) {
            if (this.isEnabled()) {
                AbstractIntelliHints.this.hideHintsPopup();
                return true;
            }
            return false;
        }
    };
    private DocumentListener documentListener = new DocumentListener(){
        private Timer timer = new Timer(200, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (AbstractIntelliHints.this.isKeyTyped()) {
                    if (AbstractIntelliHints.this.isHintsPopupVisible() || AbstractIntelliHints.this.isAutoPopup()) {
                        AbstractIntelliHints.this.showHintsPopup();
                    }
                    AbstractIntelliHints.this.setKeyTyped(false);
                }
            }
        });

        public void insertUpdate(DocumentEvent e) {
            this.startTimer();
        }

        public void removeUpdate(DocumentEvent e) {
            this.startTimer();
        }

        public void changedUpdate(DocumentEvent e) {
        }

        void startTimer() {
            if (this.timer.isRunning()) {
                this.timer.restart();
            } else {
                this.timer.setRepeats(false);
                this.timer.start();
            }
        }
    };

    public AbstractIntelliHints(JTextComponent textComponent) {
        KeyStroke[] keyStrokes;
        this._textComponent = textComponent;
        this.getTextComponent().putClientProperty("INTELLI_HINTS", this);
        this._popup = this.createPopup();
        this.getTextComponent().getDocument().addDocumentListener(this.documentListener);
        this.getTextComponent().addKeyListener(new KeyListener(){

            public void keyTyped(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (27 != e.getKeyCode()) {
                    AbstractIntelliHints.this.setKeyTyped(true);
                }
            }
        });
        this.getTextComponent().addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                Container topLevelAncestor = AbstractIntelliHints.this._popup.getTopLevelAncestor();
                if (topLevelAncestor == null) {
                    return;
                }
                Component oppositeComponent = e.getOppositeComponent();
                if (topLevelAncestor == oppositeComponent || topLevelAncestor.isAncestorOf(oppositeComponent)) {
                    return;
                }
                AbstractIntelliHints.this.hideHintsPopup();
            }
        });
        DelegateAction.replaceAction(this.getTextComponent(), 0, this.getShowHintsKeyStroke(), showAction);
        for (KeyStroke keyStroke : keyStrokes = this.getDelegateKeyStrokes()) {
            DelegateAction.replaceAction(this.getTextComponent(), 0, keyStroke, new LazyDelegateAction(keyStroke));
        }
        this.getDelegateComponent().setRequestFocusEnabled(false);
        this.getDelegateComponent().addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                AbstractIntelliHints.this.hideHintsPopup();
                AbstractIntelliHints.this.setHintsEnabled(false);
                AbstractIntelliHints.this.acceptHint(AbstractIntelliHints.this.getSelectedHint());
                AbstractIntelliHints.this.setHintsEnabled(true);
            }
        });
    }

    protected JidePopup createPopup() {
        JidePopup popup = JidePopupFactory.getSharedInstance().createPopup();
        popup.setLayout(new BorderLayout());
        popup.setResizable(true);
        popup.setPopupBorder(BorderFactory.createLineBorder(UIDefaultsLookup.getColor("controlDkShadow"), 1));
        popup.setMovable(false);
        popup.add(this.createHintsComponent());
        popup.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                DelegateAction.restoreAction((JComponent)AbstractIntelliHints.this.getTextComponent(), 0, KeyStroke.getKeyStroke(27, 0), AbstractIntelliHints.this.hideAction);
                DelegateAction.restoreAction((JComponent)AbstractIntelliHints.this.getTextComponent(), 0, KeyStroke.getKeyStroke(10, 0), AbstractIntelliHints.this.acceptAction);
            }

            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        popup.setTransient(true);
        return popup;
    }

    public JTextComponent getTextComponent() {
        return this._textComponent;
    }

    public void acceptHint(Object selected) {
        String newText;
        if (selected == null) {
            return;
        }
        int pos = this.getTextComponent().getCaretPosition();
        if (this.isMultilineTextComponent()) {
            String text = this.getTextComponent().getText();
            int start = text.lastIndexOf(10, pos - 1);
            String remain = pos == -1 ? "" : text.substring(pos);
            text = text.substring(0, start + 1);
            text = text + selected;
            newText = text = text + remain;
        } else {
            newText = selected.toString();
        }
        this.getTextComponent().setText(newText);
        String actualText = this.getTextComponent().getText();
        int separatorIndex = actualText.indexOf(10, pos);
        this.getTextComponent().setCaretPosition(separatorIndex == -1 ? actualText.length() : separatorIndex);
    }

    protected boolean isMultilineTextComponent() {
        return this.getTextComponent() instanceof JTextArea || this.getTextComponent() instanceof JEditorPane;
    }

    protected void showHintsPopup() {
        if (!this.getTextComponent().isEnabled() || !this.getTextComponent().hasFocus()) {
            return;
        }
        this.showHints();
    }

    public void showHints() {
        if (this.updateHints(this.getContext())) {
            DelegateAction.replaceAction(this.getTextComponent(), 0, KeyStroke.getKeyStroke(27, 0), this.hideAction);
            DelegateAction.replaceAction((JComponent)this.getTextComponent(), 0, KeyStroke.getKeyStroke(10, 0), this.acceptAction, true);
            int x = 0;
            int y = 0;
            int height = 0;
            try {
                int pos = this.getCaretPositionForPopup();
                Rectangle position = this.getCaretRectangleForPopup(pos);
                y = position.y;
                x = position.x;
                height = position.height;
            }
            catch (BadLocationException e) {
                // empty catch block
            }
            this._popup.setOwner(this.getTextComponent());
            this._popup.showPopup(new Insets(y, x, this.getTextComponent().getHeight() - height - y, 0));
        } else {
            this._popup.hidePopup();
        }
    }

    protected Rectangle getCaretRectangleForPopup(int caretPosition) throws BadLocationException {
        return this.getTextComponent().getUI().modelToView(this.getTextComponent(), caretPosition);
    }

    protected int getCaretPositionForPopup() {
        int caretPosition = Math.min(this.getTextComponent().getCaret().getDot(), this.getTextComponent().getCaret().getMark());
        if (this.isFollowCaret()) {
            return caretPosition;
        }
        try {
            Rectangle viewRect = this.getTextComponent().getUI().modelToView(this.getTextComponent(), caretPosition);
            viewRect.x = 0;
            return this.getTextComponent().getUI().viewToModel(this.getTextComponent(), viewRect.getLocation());
        }
        catch (BadLocationException e) {
            return 0;
        }
    }

    protected Object getContext() {
        if (this.isMultilineTextComponent()) {
            int pos = this.getTextComponent().getCaretPosition();
            if (pos == 0) {
                return "";
            }
            String text = this.getTextComponent().getText();
            int start = text.lastIndexOf(10, pos - 1);
            return text.substring(start + 1, pos);
        }
        return this.getTextComponent().getText();
    }

    protected void hideHintsPopup() {
        if (this._popup != null) {
            this._popup.hidePopup();
        }
        this.setKeyTyped(false);
    }

    public void setHintsEnabled(boolean enabled) {
        if (!enabled) {
            this.getTextComponent().getDocument().removeDocumentListener(this.documentListener);
        } else {
            this.getTextComponent().getDocument().addDocumentListener(this.documentListener);
        }
    }

    public boolean isHintsPopupVisible() {
        return this._popup != null && this._popup.isPopupVisible();
    }

    public boolean isFollowCaret() {
        return this._followCaret;
    }

    public void setFollowCaret(boolean followCaret) {
        this._followCaret = followCaret;
    }

    public boolean isAutoPopup() {
        return this._autoPopup;
    }

    public void setAutoPopup(boolean autoPopup) {
        this._autoPopup = autoPopup;
    }

    protected abstract KeyStroke[] getDelegateKeyStrokes();

    protected abstract JComponent getDelegateComponent();

    protected KeyStroke getShowHintsKeyStroke() {
        if (this.isMultilineTextComponent()) {
            return KeyStroke.getKeyStroke(32, 2);
        }
        return KeyStroke.getKeyStroke(40, 0);
    }

    private boolean isKeyTyped() {
        return this._keyTyped;
    }

    private void setKeyTyped(boolean keyTyped) {
        this._keyTyped = keyTyped;
    }

    public static IntelliHints getIntelliHints(JComponent component) {
        return (IntelliHints)component.getClientProperty("INTELLI_HINTS");
    }

    private static class LazyDelegateAction
    extends DelegateAction {
        private KeyStroke _keyStroke;

        public LazyDelegateAction(KeyStroke keyStroke) {
            this._keyStroke = keyStroke;
        }

        public boolean delegateActionPerformed(ActionEvent e) {
            JComponent tf = (JComponent)e.getSource();
            IntelliHints hints = AbstractIntelliHints.getIntelliHints(tf);
            if (hints instanceof AbstractIntelliHints) {
                AbstractIntelliHints aih = (AbstractIntelliHints)hints;
                if (tf.isEnabled() && aih.isHintsPopupVisible()) {
                    Action action;
                    Object key = aih.getDelegateComponent().getInputMap().get(this._keyStroke);
                    Object object = key = key == null ? aih.getTextComponent().getInputMap(1).get(this._keyStroke) : key;
                    if (key != null && (action = aih.getDelegateComponent().getActionMap().get(key)) instanceof Action) {
                        action.actionPerformed(new ActionEvent(aih.getDelegateComponent(), 0, "" + key));
                        return true;
                    }
                }
            }
            return false;
        }
    }
}

