/*
 * Decompiled with CFR 0.152.
 */
package javax.help.search;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.help.HelpSet;
import javax.help.HelpUtilities;
import javax.help.NavigatorView;
import javax.help.search.SearchEngine;
import javax.help.search.SearchEvent;
import javax.help.search.SearchListener;
import javax.help.search.SearchQuery;

public class MergingSearchEngine
extends SearchEngine {
    private Vector engines;
    private Hashtable enginePerView = new Hashtable();
    private boolean stopQuery = false;
    private static final boolean debug = false;

    public MergingSearchEngine(NavigatorView navigatorView) {
        if (navigatorView == null) {
            throw new IllegalArgumentException("view must not be null");
        }
        this.engines = new Vector();
        SearchEngine searchEngine = this.makeEngine(navigatorView);
        this.engines.addElement(searchEngine);
    }

    public MergingSearchEngine(SearchEngine searchEngine) {
        if (searchEngine == null) {
            throw new IllegalArgumentException("engine must not be null");
        }
        this.engines = new Vector();
        this.engines.addElement(searchEngine);
    }

    public SearchQuery createQuery() {
        return new MergingSearchQuery(this);
    }

    public void merge(NavigatorView navigatorView) {
        if (navigatorView == null) {
            throw new IllegalArgumentException("view must not be null");
        }
        SearchEngine searchEngine = this.makeEngine(navigatorView);
        if (searchEngine == null) {
            throw new IllegalArgumentException("view is invalid");
        }
        this.engines.addElement(searchEngine);
        this.enginePerView.put(navigatorView, searchEngine);
    }

    public void remove(NavigatorView navigatorView) {
        if (navigatorView == null) {
            throw new IllegalArgumentException("view is either null or invalid");
        }
        SearchEngine searchEngine = (SearchEngine)this.enginePerView.get(navigatorView);
        if (searchEngine == null) {
            throw new IllegalArgumentException("view is either null or invalid");
        }
        this.engines.removeElement(searchEngine);
        this.enginePerView.remove(searchEngine);
    }

    public Enumeration getEngines() {
        return this.engines.elements();
    }

    private SearchEngine makeEngine(NavigatorView navigatorView) {
        Constructor<?> constructor;
        Class<?> clazz;
        Hashtable hashtable = navigatorView.getParameters();
        if (hashtable == null || hashtable != null && !hashtable.containsKey("data")) {
            return null;
        }
        String string = (String)hashtable.get("engine");
        HelpSet helpSet = navigatorView.getHelpSet();
        URL uRL = helpSet.getHelpSetURL();
        ClassLoader classLoader = helpSet.getLoader();
        if (string == null) {
            string = HelpUtilities.getDefaultQueryEngine();
            hashtable.put("engine", string);
        }
        SearchEngine searchEngine = null;
        Class[] classArray = new Class[]{URL.class, Hashtable.class};
        Object[] objectArray = new Object[]{uRL, hashtable};
        MergingSearchEngine.debug("makeEngine");
        MergingSearchEngine.debug("  base: " + uRL);
        MergingSearchEngine.debug("  params: " + hashtable);
        try {
            clazz = classLoader == null ? Class.forName(string) : classLoader.loadClass(string);
        }
        catch (Throwable throwable) {
            throw new Error("Could not load engine named " + string + " for view: " + navigatorView);
        }
        try {
            constructor = clazz.getConstructor(classArray);
        }
        catch (Throwable throwable) {
            throw new Error("Could not find constructor for " + string + ". For view: " + navigatorView);
        }
        try {
            searchEngine = (SearchEngine)constructor.newInstance(objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            System.err.println("Exception while creating engine named " + string + " for view: " + navigatorView);
            invocationTargetException.printStackTrace();
        }
        catch (Throwable throwable) {
            throw new Error("Could not create engine named " + string + " for view: " + navigatorView);
        }
        return searchEngine;
    }

    private static void debug(String string) {
    }

    private class MergingSearchQuery
    extends SearchQuery
    implements SearchListener {
        private MergingSearchEngine mhs;
        private Vector queries;
        private String searchparams;

        public MergingSearchQuery(SearchEngine searchEngine) {
            super(searchEngine);
            if (searchEngine instanceof MergingSearchEngine) {
                this.mhs = (MergingSearchEngine)searchEngine;
            }
        }

        public synchronized void start(String string, Locale locale) throws IllegalArgumentException, IllegalStateException {
            Object object;
            MergingSearchEngine.debug("startSearch()");
            if (this.isActive()) {
                throw new IllegalStateException();
            }
            MergingSearchEngine.this.stopQuery = false;
            super.start(string, locale);
            this.queries = new Vector();
            Enumeration enumeration = this.mhs.getEngines();
            while (enumeration.hasMoreElements()) {
                object = (SearchEngine)enumeration.nextElement();
                if (object == null) continue;
                this.queries.addElement(((SearchEngine)object).createQuery());
            }
            enumeration = this.queries.elements();
            while (enumeration.hasMoreElements()) {
                object = (SearchQuery)enumeration.nextElement();
                ((SearchQuery)object).addSearchListener(this);
                ((SearchQuery)object).start(string, locale);
            }
        }

        public synchronized void stop() throws IllegalStateException {
            if (this.queries == null) {
                return;
            }
            MergingSearchEngine.this.stopQuery = true;
            boolean bl = true;
            while (bl) {
                bl = false;
                if (this.queries == null) continue;
                Enumeration enumeration = this.queries.elements();
                while (enumeration.hasMoreElements()) {
                    SearchQuery searchQuery = (SearchQuery)enumeration.nextElement();
                    if (!searchQuery.isActive()) continue;
                    MergingSearchEngine.debug("queries are active waiting to stop");
                    bl = true;
                }
                if (!bl) continue;
                try {
                    this.wait(250L);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
            }
            this.queries = null;
        }

        public boolean isActive() {
            if (this.queries == null) {
                return false;
            }
            Enumeration enumeration = this.queries.elements();
            while (enumeration.hasMoreElements()) {
                SearchQuery searchQuery = (SearchQuery)enumeration.nextElement();
                if (!searchQuery.isActive()) continue;
                return true;
            }
            return false;
        }

        public SearchEngine getSearchEngine() {
            return this.mhs;
        }

        public synchronized void itemsFound(SearchEvent searchEvent) {
            SearchQuery searchQuery = (SearchQuery)searchEvent.getSource();
            if (MergingSearchEngine.this.stopQuery) {
                return;
            }
            if (this.queries != null) {
                Enumeration enumeration = this.queries.elements();
                while (enumeration.hasMoreElements()) {
                    SearchQuery searchQuery2 = (SearchQuery)enumeration.nextElement();
                    if (searchQuery2 != searchQuery) continue;
                    this.fireItemsFound(searchEvent);
                }
            }
        }

        public void searchStarted(SearchEvent searchEvent) {
        }

        public synchronized void searchFinished(SearchEvent searchEvent) {
            SearchQuery searchQuery = (SearchQuery)searchEvent.getSource();
            if (this.queries != null) {
                Enumeration enumeration = this.queries.elements();
                while (enumeration.hasMoreElements()) {
                    SearchQuery searchQuery2 = (SearchQuery)enumeration.nextElement();
                    if (searchQuery2 != searchQuery) continue;
                    searchQuery.removeSearchListener(this);
                    this.queries.removeElement(searchQuery2);
                }
                if (this.queries.isEmpty()) {
                    this.queries = null;
                    if (!MergingSearchEngine.this.stopQuery) {
                        this.fireSearchFinished();
                    }
                }
            }
        }
    }
}

