/*
 * Copyright  2002-2004 The Apache Software Foundation
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 */
package org.apache.jmeld.tools.ant.types.selectors;

import org.apache.jmeld.tools.ant.BuildException;

import java.io.File;

/**
 * This is the interface to be used by all selectors.
 *
 * @since 1.5
 */
public interface FileSelector
{
  /**
   * Method that each selector will implement to create their
   * selection behaviour. If there is a problem with the setup
   * of a selector, it can throw a BuildException to indicate
   * the problem.
   *
   * @param basedir A java.io.File object for the base directory
   * @param filename The name of the file to check
   * @param file A File object for this filename
   * @return whether the file should be selected or not
   * @exception BuildException if the selector was not configured correctly
   */
  boolean isSelected(
    File   basedir,
    String filename,
    File   file)
    throws BuildException;
}
