/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.util;

import java.awt.Font;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.text.View;
import javax.swing.text.html.HTMLDocument;

public final class UIManagerUtils {
    private static final Logger LOG = Logger.getLogger(UIManagerUtils.class.getName());

    private UIManagerUtils() {
    }

    public static void initDefault(String string, Object object) {
        Object object2 = UIManager.get(string);
        if (object2 == null) {
            UIManager.put(string, object);
        }
    }

    public static void initDefault(String string, String string2, Object object) {
        Object object2 = UIManager.get(string);
        if (object2 == null) {
            try {
                Method method = ((MetalLookAndFeel)UIManager.getLookAndFeel()).getClass().getMethod(string2, object.getClass());
                UIManager.put(string, method.invoke((Object)UIManager.getLookAndFeel(), string2));
            }
            catch (Exception exception) {
                UIManager.put(string, object);
            }
        }
    }

    public static void htmlize(JComponent jComponent, Font font) {
        String string = "body { margin-top: 0; margin-bottom: 0; margin-left: 0; margin-right: 0; font-family: " + font.getName() + "; font-size: " + font.getSize() + "pt;  }" + "a, p, li { margin-top: 0; margin-bottom: 0; margin-left: 0; margin-right: 0; font-family: " + font.getName() + "; font-size: " + font.getSize() + "pt;  }";
        try {
            HTMLDocument hTMLDocument = null;
            if (jComponent instanceof JEditorPane) {
                if (((JEditorPane)jComponent).getDocument() instanceof HTMLDocument) {
                    hTMLDocument = (HTMLDocument)((JEditorPane)jComponent).getDocument();
                }
            } else {
                View view = (View)jComponent.getClientProperty("html");
                if (view != null && view.getDocument() instanceof HTMLDocument) {
                    hTMLDocument = (HTMLDocument)view.getDocument();
                }
            }
            if (hTMLDocument != null) {
                hTMLDocument.getStyleSheet().loadRules(new StringReader(string), null);
            }
        }
        catch (Exception exception) {
            LOG.log(Level.WARNING, "", exception);
        }
    }
}

