/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf;

import java.util.Map;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import javax.swing.text.JTextComponent;
import org.jdesktop.swingx.plaf.ContextMenuSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextContextMenuSource
extends ContextMenuSource {
    String UNDO = "Undo";
    String CUT = "Cut";
    String COPY = "Copy";
    String PASTE = "Paste";
    String DELETE = "Delete";
    String SELECT_ALL = "Select All";
    String[] keys = new String[]{"cut-to-clipboard", "copy-to-clipboard", "paste-from-clipboard", "delete-next", null, "select-all"};
    String[] defaultValues = new String[]{this.CUT, this.COPY, this.PASTE, this.DELETE, null, this.SELECT_ALL};

    @Override
    public String[] getKeys() {
        return this.keys;
    }

    @Override
    public void updateActionEnabled(JComponent jComponent, ActionMap actionMap) {
        if (!(jComponent instanceof JTextComponent)) {
            return;
        }
        JTextComponent jTextComponent = (JTextComponent)jComponent;
        boolean bl = jTextComponent.getSelectionEnd() - jTextComponent.getSelectionStart() > 0;
        boolean bl2 = jTextComponent.getDocument().getLength() > 0;
        boolean bl3 = jTextComponent.isEditable();
        boolean bl4 = jTextComponent instanceof JPasswordField;
        boolean bl5 = jTextComponent.getToolkit().getSystemClipboard().getContents(null) != null;
        actionMap.get("cut-to-clipboard").setEnabled(!bl4 && bl3 && bl);
        actionMap.get("copy-to-clipboard").setEnabled(!bl4 && bl);
        actionMap.get("paste-from-clipboard").setEnabled(bl3 && bl5);
        actionMap.get("delete-next").setEnabled(bl3 && bl);
        actionMap.get("select-all").setEnabled(bl2);
    }

    @Override
    protected void initNames(Map<String, String> map) {
        for (int i = 0; i < this.keys.length; ++i) {
            if (this.keys[i] == null) continue;
            map.put(this.keys[i], this.getValue(this.keys[i], this.defaultValues[i]));
        }
    }

    @Override
    protected String getResourcePrefix() {
        return "DefaultEditorKit.";
    }
}

