/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.decorator;

import java.awt.Color;
import java.util.regex.Pattern;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.PatternHighlighter;

public class SearchHighlighter
extends PatternHighlighter {
    int highlightRow;
    private boolean enableHighlight;
    private static final String ALL = ".*";

    public SearchHighlighter() {
        this(Color.YELLOW.brighter(), null);
    }

    public SearchHighlighter(Color color, Color color2) {
        super(color, color2, null, 0, -1);
        this.setHighlightRow(-1);
    }

    public void setEnabled(boolean bl) {
        this.enableHighlight = bl;
        this.fireStateChanged();
    }

    protected boolean needsHighlight(ComponentAdapter componentAdapter) {
        if (!this.isEnabled()) {
            return false;
        }
        if (this.highlightRow >= 0 && componentAdapter.row != this.highlightRow) {
            return false;
        }
        return super.needsHighlight(componentAdapter);
    }

    private boolean isEnabled() {
        Pattern pattern = this.getPattern();
        if (pattern == null || ALL.equals(pattern.pattern())) {
            return false;
        }
        return this.enableHighlight;
    }

    protected boolean test(ComponentAdapter componentAdapter) {
        Object object;
        if (this.pattern == null) {
            return false;
        }
        int n = this.testColumn;
        if (n < 0) {
            n = componentAdapter.viewToModel(componentAdapter.column);
        }
        if ((object = componentAdapter.getFilteredValueAt(componentAdapter.row, n)) == null) {
            return false;
        }
        boolean bl = this.pattern.matcher(object.toString()).find();
        return bl;
    }

    public void setHighlightRow(int n) {
        this.highlightRow = n;
        this.fireStateChanged();
    }

    public void setHighlightAll() {
        this.setHighlightCell(-1, -1);
    }

    public void setHighlightCell(int n, int n2) {
        this.testColumn = n2;
        this.highlightColumn = n2;
        this.highlightRow = n;
        this.setEnabled(true);
    }
}

