/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.border;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.border.Border;

public class IconBorder
implements Border {
    private static final int PAD = 4;
    private Icon icon;
    private int iconPosition;
    private Rectangle iconBounds = new Rectangle();

    public IconBorder() {
        this(null);
    }

    public IconBorder(Icon icon) {
        this(icon, 11);
    }

    public IconBorder(Icon icon, int n) {
        this.icon = icon;
        this.iconPosition = n;
    }

    public Insets getBorderInsets(Component component) {
        int n = this.icon.getIconWidth() + 8;
        int n2 = this.bidiDecodeLeadingTrailing(component.getComponentOrientation(), this.iconPosition);
        if (n2 == 3) {
            return new Insets(0, 0, 0, n);
        }
        return new Insets(0, n, 0, 0);
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public boolean isBorderOpaque() {
        return false;
    }

    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        int n5 = this.bidiDecodeLeadingTrailing(component.getComponentOrientation(), this.iconPosition);
        if (n5 == 2) {
            this.iconBounds.y = n2 + 4;
            this.iconBounds.x = n + n3 - 4 - this.icon.getIconWidth();
        } else if (n5 == 3) {
            this.iconBounds.y = n2 + (n4 - this.icon.getIconHeight()) / 2;
            this.iconBounds.x = n + n3 - 4 - this.icon.getIconWidth();
        } else if (n5 == 7) {
            this.iconBounds.y = n2 + (n4 - this.icon.getIconHeight()) / 2;
            this.iconBounds.x = n + 4;
        }
        this.iconBounds.width = this.icon.getIconWidth();
        this.iconBounds.height = this.icon.getIconHeight();
        this.icon.paintIcon(component, graphics, this.iconBounds.x, this.iconBounds.y);
    }

    private int bidiDecodeLeadingTrailing(ComponentOrientation componentOrientation, int n) {
        if (n == 11) {
            if (!componentOrientation.isLeftToRight()) {
                return 7;
            }
            return 3;
        }
        if (n == 10) {
            if (!componentOrientation.isLeftToRight()) {
                return 7;
            }
            return 3;
        }
        return n;
    }
}

