/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.action;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.jdesktop.swingx.action.AbstractActionExt;
import org.jdesktop.swingx.action.ActionContainerFactory;
import org.jdesktop.swingx.action.BoundAction;
import org.jdesktop.swingx.action.CompositeAction;
import org.jdesktop.swingx.action.ServerAction;
import org.jdesktop.swingx.action.TargetableAction;

public class ActionManager {
    private Map actionMap;
    private ActionContainerFactory factory;
    private static ActionManager INSTANCE;
    private static boolean DEBUG;

    public ActionContainerFactory getFactory() {
        if (this.factory == null) {
            this.factory = new ActionContainerFactory(this);
        }
        return this.factory;
    }

    public void setFactory(ActionContainerFactory actionContainerFactory) {
        this.factory = actionContainerFactory;
    }

    public static ActionManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ActionManager();
        }
        return INSTANCE;
    }

    public static void setInstance(ActionManager actionManager) {
        INSTANCE = actionManager;
    }

    public Set getActionIDs() {
        if (this.actionMap == null) {
            return null;
        }
        return this.actionMap.keySet();
    }

    public Action addAction(Action action) {
        return this.addAction(action.getValue("ActionCommandKey"), action);
    }

    public Action addAction(Object object, Action action) {
        if (this.actionMap == null) {
            this.actionMap = new HashMap();
        }
        this.actionMap.put(object, action);
        return action;
    }

    public Action getAction(Object object) {
        if (this.actionMap != null) {
            return (Action)this.actionMap.get(object);
        }
        return null;
    }

    public TargetableAction getTargetableAction(Object object) {
        Action action = this.getAction(object);
        if (action instanceof TargetableAction) {
            return (TargetableAction)action;
        }
        return null;
    }

    public BoundAction getBoundAction(Object object) {
        Action action = this.getAction(object);
        if (action instanceof BoundAction) {
            return (BoundAction)action;
        }
        return null;
    }

    public ServerAction getServerAction(Object object) {
        Action action = this.getAction(object);
        if (action instanceof ServerAction) {
            return (ServerAction)action;
        }
        return null;
    }

    public CompositeAction getCompositeAction(Object object) {
        Action action = this.getAction(object);
        if (action instanceof CompositeAction) {
            return (CompositeAction)action;
        }
        return null;
    }

    private AbstractActionExt getStateChangeAction(Object object) {
        AbstractActionExt abstractActionExt;
        Action action = this.getAction(object);
        if (action != null && action instanceof AbstractActionExt && (abstractActionExt = (AbstractActionExt)action).isStateAction()) {
            return abstractActionExt;
        }
        return null;
    }

    public void setEnabled(Object object, boolean bl) {
        Action action = this.getAction(object);
        if (action != null) {
            action.setEnabled(bl);
        }
    }

    public boolean isEnabled(Object object) {
        Action action = this.getAction(object);
        if (action != null) {
            return action.isEnabled();
        }
        return false;
    }

    public void setSelected(Object object, boolean bl) {
        AbstractActionExt abstractActionExt = this.getStateChangeAction(object);
        if (abstractActionExt != null) {
            abstractActionExt.setSelected(bl);
        }
    }

    public boolean isSelected(Object object) {
        AbstractActionExt abstractActionExt = this.getStateChangeAction(object);
        if (abstractActionExt != null) {
            return abstractActionExt.isSelected();
        }
        return false;
    }

    static void printAction(PrintStream printStream, Action action) {
        printStream.println("Attributes for " + action.getValue("ActionCommandKey"));
        if (action instanceof AbstractAction) {
            Object[] objectArray = ((AbstractAction)action).getKeys();
            for (int i = 0; i < objectArray.length; ++i) {
                printStream.println("\tkey: " + objectArray[i] + "\tvalue: " + action.getValue((String)objectArray[i]));
            }
        }
    }

    public void registerCallback(Object object, Object object2, String string) {
        BoundAction boundAction = this.getBoundAction(object);
        if (boundAction != null) {
            boundAction.registerCallback(object2, string);
        }
    }

    public boolean isStateAction(Object object) {
        Action action = this.getAction(object);
        if (action != null && action instanceof AbstractActionExt) {
            return ((AbstractActionExt)action).isStateAction();
        }
        return false;
    }

    public boolean isTargetableAction(Object object) {
        return this.getTargetableAction(object) != null;
    }

    public boolean isBoundAction(Object object) {
        return this.getBoundAction(object) != null;
    }

    public boolean isCompositeAction(Object object) {
        return this.getCompositeAction(object) != null;
    }

    public boolean isServerAction(Object object) {
        return this.getServerAction(object) != null;
    }

    static {
        DEBUG = false;
    }
}

