/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.EventObject;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.plaf.UIResource;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.JXTree;
import org.jdesktop.swingx.UIAction;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.treetable.AbstractTreeTableModel;
import org.jdesktop.swingx.treetable.DefaultTreeTableModel;
import org.jdesktop.swingx.treetable.TreeTableCellEditor;
import org.jdesktop.swingx.treetable.TreeTableModel;

public class JXTreeTable
extends JXTable {
    private TreeTableCellRenderer renderer;
    private static final Dimension spacing = new Dimension(0, 2);

    public JXTreeTable() {
        this(new DefaultTreeTableModel());
    }

    public JXTreeTable(TreeTableModel treeTableModel) {
        this(treeTableModel, new TreeTableCellRenderer(treeTableModel));
    }

    private JXTreeTable(TreeTableModel treeTableModel, TreeTableCellRenderer treeTableCellRenderer) {
        super(new TreeTableModelAdapter(treeTableModel, treeTableCellRenderer));
        if (treeTableModel != treeTableCellRenderer.getModel()) {
            throw new IllegalArgumentException("Mismatched TreeTableModel");
        }
        this.init(treeTableCellRenderer);
        this.initActions();
        super.setSortable(false);
        this.setDefaultEditor(AbstractTreeTableModel.hierarchicalColumnClass, new TreeTableCellEditor(treeTableCellRenderer));
        this.setShowGrid(false);
        this.setIntercellSpacing(spacing);
        this.adminSetRowHeight(this.getRowHeight());
        this.setRowMargin(this.getRowMargin());
    }

    private void initActions() {
        ActionMap actionMap = this.getActionMap();
        actionMap.put("expand-all", new Actions("expand-all"));
        actionMap.put("collapse-all", new Actions("collapse-all"));
    }

    public void setSortable(boolean bl) {
    }

    public void setShowHorizontalLines(boolean bl) {
        super.setShowHorizontalLines(bl);
    }

    public void setShowVerticalLines(boolean bl) {
        super.setShowVerticalLines(bl);
    }

    public boolean editCellAt(int n, int n2, EventObject eventObject) {
        this.expandOrCollapseNode(eventObject);
        boolean bl = super.editCellAt(n, n2, eventObject);
        if (bl && this.isHierarchical(n2)) {
            this.repaint(this.getCellRect(n, n2, false));
        }
        return bl;
    }

    private void expandOrCollapseNode(EventObject eventObject) {
        MouseEvent mouseEvent;
        if (eventObject instanceof MouseEvent && ((mouseEvent = (MouseEvent)eventObject).getModifiers() == 0 || mouseEvent.getModifiers() == 16)) {
            int n = this.getColumnCount();
            for (int i = n - 1; i >= 0; --i) {
                if (!this.isHierarchical(i)) continue;
                int n2 = this.renderer.getRowHeight();
                this.renderer.setRowHeight(this.getRowHeight());
                MouseEvent mouseEvent2 = new MouseEvent(this.renderer, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX() - this.getCellRect((int)0, (int)i, (boolean)false).x, mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                this.renderer.dispatchEvent(mouseEvent2);
                MouseEvent mouseEvent3 = new MouseEvent(this.renderer, 502, mouseEvent2.getWhen(), mouseEvent2.getModifiers(), mouseEvent2.getX(), mouseEvent2.getY(), mouseEvent2.getClickCount(), mouseEvent2.isPopupTrigger());
                this.renderer.dispatchEvent(mouseEvent3);
                this.renderer.setRowHeight(n2);
                break;
            }
        }
    }

    public int getEditingRow() {
        return this.isHierarchical(this.editingColumn) ? -1 : this.editingRow;
    }

    private int realEditingRow() {
        return this.editingRow;
    }

    public void setTreeTableModel(TreeTableModel treeTableModel) {
        this.renderer.setModel(treeTableModel);
        ((TreeTableModelAdapter)this.getModel()).setTreeTableModel(treeTableModel);
        if (treeTableModel != this.renderer.getModel()) {
            throw new IllegalArgumentException("Mismatched TreeTableModel");
        }
        this.setDefaultEditor(AbstractTreeTableModel.hierarchicalColumnClass, new TreeTableCellEditor(this.renderer));
        this.adminSetRowHeight(this.getRowHeight());
        this.setRowMargin(this.getRowMargin());
    }

    public TreeTableModel getTreeTableModel() {
        return ((TreeTableModelAdapter)this.getModel()).getTreeTableModel();
    }

    public final void setModel(TableModel tableModel) {
        if (tableModel instanceof TreeTableModelAdapter) {
            if (((TreeTableModelAdapter)tableModel).getTreeTable() != null) {
                throw new IllegalArgumentException("model already bound");
            }
        } else {
            throw new IllegalArgumentException("unsupported model type");
        }
        super.setModel(tableModel);
        ((TreeTableModelAdapter)tableModel).bind(this);
    }

    public final void setRowHeight(int n, int n2) {
        throw new UnsupportedOperationException("variable height rows not supported");
    }

    public void setRowHeight(int n) {
        super.setRowHeight(n);
        this.adjustTreeRowHeight();
    }

    public void setColumnMargin(int n) {
        super.setColumnMargin(n);
    }

    public void setRowMargin(int n) {
        super.setRowMargin(n);
        this.adjustTreeRowHeight();
    }

    private void adjustTreeRowHeight() {
        int n = this.rowHeight + (this.rowMargin << 1);
        if (this.renderer != null && this.renderer.getRowHeight() != n) {
            this.renderer.setRowHeight(n);
        }
    }

    public void setSelectionMode(int n) {
        if (this.renderer != null) {
            switch (n) {
                case 1: {
                    this.renderer.getSelectionModel().setSelectionMode(2);
                    break;
                }
                case 2: {
                    this.renderer.getSelectionModel().setSelectionMode(4);
                    break;
                }
                default: {
                    this.renderer.getSelectionModel().setSelectionMode(1);
                }
            }
        }
        super.setSelectionMode(n);
    }

    public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
        Component component = super.prepareRenderer(tableCellRenderer, n, n2);
        ComponentAdapter componentAdapter = this.getComponentAdapter();
        componentAdapter.row = n;
        componentAdapter.column = n2;
        return this.applyRenderer(component, componentAdapter);
    }

    protected Component applyRenderer(Component component, ComponentAdapter componentAdapter) {
        if (component == null) {
            throw new IllegalArgumentException("null component");
        }
        if (componentAdapter == null) {
            throw new IllegalArgumentException("null component data adapter");
        }
        if (this.isHierarchical(componentAdapter.column)) {
            TreeCellRenderer treeCellRenderer = this.renderer.getCellRenderer();
            if (treeCellRenderer instanceof JXTree.DelegatingRenderer) {
                treeCellRenderer = ((JXTree.DelegatingRenderer)treeCellRenderer).getDelegateRenderer();
            }
            if (treeCellRenderer instanceof DefaultTreeCellRenderer) {
                DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)treeCellRenderer;
                if (componentAdapter.isSelected()) {
                    defaultTreeCellRenderer.setTextSelectionColor(component.getForeground());
                    defaultTreeCellRenderer.setBackgroundSelectionColor(component.getBackground());
                } else {
                    defaultTreeCellRenderer.setTextNonSelectionColor(component.getForeground());
                    defaultTreeCellRenderer.setBackgroundNonSelectionColor(component.getBackground());
                }
            }
        }
        return component;
    }

    public void setTreeCellRenderer(TreeCellRenderer treeCellRenderer) {
        if (this.renderer != null) {
            this.renderer.setCellRenderer(treeCellRenderer);
        }
    }

    public TreeCellRenderer getTreeCellRenderer() {
        return this.renderer.getCellRenderer();
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        int n = this.columnAtPoint(mouseEvent.getPoint());
        if (this.isHierarchical(n)) {
            return this.renderer.getToolTipText(mouseEvent);
        }
        return super.getToolTipText(mouseEvent);
    }

    public void setCollapsedIcon(Icon icon) {
        this.renderer.setCollapsedIcon(icon);
    }

    public void setExpandedIcon(Icon icon) {
        this.renderer.setExpandedIcon(icon);
    }

    public void setOpenIcon(Icon icon) {
        this.renderer.setOpenIcon(icon);
    }

    public void setClosedIcon(Icon icon) {
        this.renderer.setClosedIcon(icon);
    }

    public void setLeafIcon(Icon icon) {
        this.renderer.setLeafIcon(icon);
    }

    public void clearSelection() {
        if (this.renderer != null) {
            this.renderer.clearSelection();
        }
        super.clearSelection();
    }

    public void collapseAll() {
        this.renderer.collapseAll();
    }

    public void expandAll() {
        this.renderer.expandAll();
    }

    public void collapsePath(TreePath treePath) {
        this.renderer.collapsePath(treePath);
    }

    public void expandPath(TreePath treePath) {
        this.renderer.expandPath(treePath);
    }

    public void collapseRow(int n) {
        this.renderer.collapseRow(n);
    }

    public void expandRow(int n) {
        this.renderer.expandRow(n);
    }

    public void setRootVisible(boolean bl) {
        this.renderer.setRootVisible(bl);
        this.repaint();
    }

    public boolean isRootVisible() {
        return this.renderer.isRootVisible();
    }

    public boolean isVisible(TreePath treePath) {
        return this.renderer.isVisible(treePath);
    }

    public boolean isExpanded(TreePath treePath) {
        return this.renderer.isExpanded(treePath);
    }

    public boolean isExpanded(int n) {
        return this.renderer.isExpanded(n);
    }

    public boolean isCollapsed(TreePath treePath) {
        return this.renderer.isCollapsed(treePath);
    }

    public boolean isCollapsed(int n) {
        return this.renderer.isCollapsed(n);
    }

    public Enumeration getExpandedDescendants(TreePath treePath) {
        return this.renderer.getExpandedDescendants(treePath);
    }

    public void setExpandsSelectedPaths(boolean bl) {
        this.renderer.setExpandsSelectedPaths(bl);
    }

    public boolean getExpandsSelectedPaths() {
        return this.renderer.getExpandsSelectedPaths();
    }

    public TreePath getPathForLocation(int n, int n2) {
        int n3 = this.rowAtPoint(new Point(n, n2));
        if (n3 == -1) {
            return null;
        }
        return this.renderer.getPathForRow(n3);
    }

    public TreePath getPathForRow(int n) {
        return this.renderer.getPathForRow(n);
    }

    public int getRowForPath(TreePath treePath) {
        return this.renderer.getRowForPath(treePath);
    }

    public void setScrollsOnExpand(boolean bl) {
        this.renderer.setScrollsOnExpand(bl);
    }

    public boolean getScrollsOnExpand() {
        return this.renderer.getScrollsOnExpand();
    }

    public void setShowsRootHandles(boolean bl) {
        this.renderer.setShowsRootHandles(bl);
        this.repaint();
    }

    public boolean getShowsRootHandles() {
        return this.renderer.getShowsRootHandles();
    }

    public void addTreeExpansionListener(TreeExpansionListener treeExpansionListener) {
        this.renderer.addTreeExpansionListener(treeExpansionListener);
    }

    public void removeTreeExpansionListener(TreeExpansionListener treeExpansionListener) {
        this.renderer.removeTreeExpansionListener(treeExpansionListener);
    }

    public void addTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.renderer.addTreeSelectionListener(treeSelectionListener);
    }

    public void removeTreeSelectionListener(TreeSelectionListener treeSelectionListener) {
        this.renderer.removeTreeSelectionListener(treeSelectionListener);
    }

    public void addTreeWillExpandListener(TreeWillExpandListener treeWillExpandListener) {
        this.renderer.addTreeWillExpandListener(treeWillExpandListener);
    }

    public void removeTreeWillExpandListener(TreeWillExpandListener treeWillExpandListener) {
        this.renderer.removeTreeWillExpandListener(treeWillExpandListener);
    }

    public TreeSelectionModel getTreeSelectionModel() {
        return this.renderer.getSelectionModel();
    }

    public void sizeColumnsToFit(int n) {
        super.sizeColumnsToFit(n);
        if (this.getEditingColumn() != -1 && this.isHierarchical(this.editingColumn)) {
            Rectangle rectangle = this.getCellRect(this.realEditingRow(), this.getEditingColumn(), false);
            Component component = this.getEditorComponent();
            component.setBounds(rectangle);
            component.validate();
        }
    }

    public void updateUI() {
        super.updateUI();
        if (this.renderer != null) {
            this.renderer.updateUI();
            this.setDefaultEditor(AbstractTreeTableModel.hierarchicalColumnClass, new TreeTableCellEditor(this.renderer));
            if (this.getBackground() == null || this.getBackground() instanceof UIResource) {
                this.setBackground(this.renderer.getBackground());
            }
        }
    }

    public boolean isHierarchical(int n) {
        return AbstractTreeTableModel.hierarchicalColumnClass.isAssignableFrom(this.getColumnClass(n));
    }

    private final void init(TreeTableCellRenderer treeTableCellRenderer) {
        this.renderer = treeTableCellRenderer;
        ListToTreeSelectionModelWrapper listToTreeSelectionModelWrapper = new ListToTreeSelectionModelWrapper();
        if (treeTableCellRenderer != null) {
            treeTableCellRenderer.bind(this);
            treeTableCellRenderer.setSelectionModel(listToTreeSelectionModelWrapper);
        }
        this.setSelectionModel(listToTreeSelectionModelWrapper.getListSelectionModel());
        this.setDefaultRenderer(AbstractTreeTableModel.hierarchicalColumnClass, treeTableCellRenderer);
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                JXTreeTable.this.renderer.putClientProperty(propertyChangeEvent.getPropertyName(), propertyChangeEvent.getNewValue());
            }
        };
        this.addPropertyChangeListener("JTree.lineStyle", propertyChangeListener);
    }

    protected ComponentAdapter getComponentAdapter() {
        if (this.dataAdapter == null) {
            this.dataAdapter = new TreeTableDataAdapter(this);
        }
        return this.dataAdapter;
    }

    protected static class TreeTableDataAdapter
    extends JXTable.TableAdapter {
        private final JXTreeTable table;

        public TreeTableDataAdapter(JXTreeTable jXTreeTable) {
            super(jXTreeTable);
            this.table = jXTreeTable;
        }

        public JXTreeTable getTreeTable() {
            return this.table;
        }

        public boolean isExpanded() {
            return super.isExpanded();
        }

        public boolean hasFocus() {
            boolean bl = super.hasFocus();
            return bl;
        }

        public boolean isLeaf() {
            return super.isLeaf();
        }

        public boolean isHierarchical() {
            return this.table.isHierarchical(this.column);
        }
    }

    static class TreeTableCellRenderer
    extends JXTree
    implements TableCellRenderer {
        protected Border highlightBorder = null;
        protected JXTreeTable treeTable = null;
        protected int visibleRow = 0;
        private int hierarchicalColumnWidth = 0;

        public TreeTableCellRenderer(TreeTableModel treeTableModel) {
            super(treeTableModel);
            this.putClientProperty("JTree.lineStyle", "None");
            this.setRootVisible(false);
            this.setShowsRootHandles(true);
            this.setOverwriteRendererIcons(true);
            this.setCellRenderer(new ClippedTreeCellRenderer());
        }

        public final void bind(JXTreeTable jXTreeTable) {
            if (jXTreeTable == null) {
                throw new IllegalArgumentException("null treeTable");
            }
            if (this.treeTable != null) {
                throw new IllegalArgumentException("renderer already bound");
            }
            this.treeTable = jXTreeTable;
        }

        public void updateUI() {
            super.updateUI();
            TreeCellRenderer treeCellRenderer = this.getCellRenderer();
            if (treeCellRenderer instanceof DefaultTreeCellRenderer) {
                DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)treeCellRenderer;
                defaultTreeCellRenderer.setBorderSelectionColor(null);
                defaultTreeCellRenderer.setTextSelectionColor(UIManager.getColor("Table.selectionForeground"));
                defaultTreeCellRenderer.setBackgroundSelectionColor(UIManager.getColor("Table.selectionBackground"));
            }
        }

        public void setRowHeight(int n) {
            super.setRowHeight(n);
            if (n > 0 && this.treeTable != null) {
                int n2 = this.treeTable.getRowMargin();
                assert (n2 >= 0);
                int n3 = n - (n2 << 1);
                if (this.treeTable.getRowHeight() != n3) {
                    this.treeTable.adminSetRowHeight(n3);
                }
            }
        }

        public void setBounds(int n, int n2, int n3, int n4) {
            if (this.treeTable != null) {
                n2 = 0;
                n4 = this.treeTable.getRowCount() * this.getRowHeight();
            }
            super.setBounds(n, n2, n3, n4);
        }

        public void paint(Graphics graphics) {
            int n = this.treeTable.getRowMargin();
            int n2 = n + (n >> 1) + n % 2;
            int n3 = n2 + this.visibleRow * this.getRowHeight();
            graphics.translate(0, -n3);
            this.hierarchicalColumnWidth = this.getWidth();
            super.paint(graphics);
            if (this.highlightBorder != null) {
                this.highlightBorder.paintBorder(this, graphics, 0, n3, this.getWidth(), this.getRowHeight() - (n << 1) - n);
            }
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            assert (jTable == this.treeTable);
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
                this.setForeground(jTable.getSelectionForeground());
            } else {
                this.setBackground(jTable.getBackground());
                this.setForeground(jTable.getForeground());
            }
            this.highlightBorder = null;
            if (this.treeTable != null && (this.treeTable.realEditingRow() != n || this.treeTable.getEditingColumn() != n2) && bl2) {
                this.highlightBorder = UIManager.getBorder("Table.focusCellHighlightBorder");
            }
            this.visibleRow = n;
            return this;
        }

        private class ClippedTreeCellRenderer
        extends DefaultTreeCellRenderer {
            private final Rectangle iconRect = new Rectangle();
            private final Rectangle textRect = new Rectangle();
            private final Rectangle itemRect = new Rectangle();

            private ClippedTreeCellRenderer() {
            }

            public void paint(Graphics graphics) {
                String string = super.getText();
                String string2 = SwingUtilities.layoutCompoundLabel(this, graphics.getFontMetrics(), string, this.getIcon(), this.getVerticalAlignment(), this.getHorizontalAlignment(), this.getVerticalTextPosition(), this.getHorizontalTextPosition(), this.getItemRect(this.itemRect), this.iconRect, this.textRect, this.getIconTextGap());
                this.setText(string2);
                super.paint(graphics);
                this.setText(string);
            }

            private Rectangle getItemRect(Rectangle rectangle) {
                this.getBounds(rectangle);
                rectangle.width = TreeTableCellRenderer.this.hierarchicalColumnWidth - rectangle.x;
                return rectangle;
            }
        }
    }

    private static class TreeTableModelAdapter
    extends AbstractTableModel {
        private TreeModelListener treeModelListener;
        private TreeTableModel model;
        private final JTree tree;
        private JXTreeTable treeTable = null;

        TreeTableModelAdapter(TreeTableModel treeTableModel, JTree jTree) {
            assert (treeTableModel != null);
            assert (jTree != null);
            this.tree = jTree;
            this.setTreeTableModel(treeTableModel);
            jTree.addTreeExpansionListener(new TreeExpansionListener(){

                public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                    TreeTableModelAdapter.this.fireTableDataChanged();
                }

                public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
                    TreeTableModelAdapter.this.fireTableDataChanged();
                }
            });
        }

        public void setTreeTableModel(TreeTableModel treeTableModel) {
            TreeTableModel treeTableModel2 = this.getTreeTableModel();
            if (treeTableModel2 != null) {
                treeTableModel2.removeTreeModelListener(this.getTreeModelListener());
            }
            this.model = treeTableModel;
            treeTableModel.addTreeModelListener(this.getTreeModelListener());
            this.fireTableStructureChanged();
        }

        private TreeModelListener getTreeModelListener() {
            if (this.treeModelListener == null) {
                this.treeModelListener = new TreeModelListener(){

                    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
                        TreeTableModelAdapter.this.delayedFireTableDataChanged(treeModelEvent, 0);
                    }

                    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
                        TreeTableModelAdapter.this.delayedFireTableDataChanged(treeModelEvent, 1);
                    }

                    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
                        TreeTableModelAdapter.this.delayedFireTableDataChanged(treeModelEvent, 2);
                    }

                    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
                        TreeTableModelAdapter.this.delayedFireTableDataChanged();
                    }
                };
            }
            return this.treeModelListener;
        }

        public TreeTableModel getTreeTableModel() {
            return this.model;
        }

        protected JXTreeTable getTreeTable() {
            return this.treeTable;
        }

        protected final void bind(JXTreeTable jXTreeTable) {
            if (jXTreeTable == null) {
                throw new IllegalArgumentException("null treeTable");
            }
            if (this.treeTable != null) {
                throw new IllegalArgumentException("adapter already bound");
            }
            this.treeTable = jXTreeTable;
        }

        public Class getColumnClass(int n) {
            return this.model.getColumnClass(n);
        }

        public int getColumnCount() {
            return this.model.getColumnCount();
        }

        public String getColumnName(int n) {
            return this.model.getColumnName(n);
        }

        public int getRowCount() {
            return this.tree.getRowCount();
        }

        public Object getValueAt(int n, int n2) {
            return this.model.getValueAt(this.nodeForRow(n), n2);
        }

        public boolean isCellEditable(int n, int n2) {
            return this.model.isCellEditable(this.nodeForRow(n), n2);
        }

        public void setValueAt(Object object, int n, int n2) {
            this.model.setValueAt(object, this.nodeForRow(n), n2);
        }

        protected Object nodeForRow(int n) {
            return this.tree.getPathForRow(n).getLastPathComponent();
        }

        private void delayedFireTableDataChanged() {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TreeTableModelAdapter.this.fireTableDataChanged();
                }
            });
        }

        private void delayedFireTableDataChanged(final TreeModelEvent treeModelEvent, final int n) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    int[] nArray = treeModelEvent.getChildIndices();
                    TreePath treePath = treeModelEvent.getTreePath();
                    if (nArray != null) {
                        if (TreeTableModelAdapter.this.tree.isExpanded(treePath)) {
                            int n4 = TreeTableModelAdapter.this.tree.getRowForPath(treePath) + 1;
                            int n2 = Integer.MAX_VALUE;
                            int n3 = Integer.MIN_VALUE;
                            for (int i = 0; i < nArray.length; ++i) {
                                if (nArray[i] < n2) {
                                    n2 = nArray[i];
                                }
                                if (nArray[i] <= n3) continue;
                                n3 = nArray[i];
                            }
                            switch (n) {
                                case 0: {
                                    TreeTableModelAdapter.this.fireTableRowsUpdated(n4 + n2, n4 + n3);
                                    break;
                                }
                                case 1: {
                                    TreeTableModelAdapter.this.fireTableRowsInserted(n4 + n2, n4 + n3);
                                    break;
                                }
                                case 2: {
                                    TreeTableModelAdapter.this.fireTableRowsDeleted(n4 + n2, n4 + n3);
                                }
                            }
                        } else {
                            int n5 = TreeTableModelAdapter.this.tree.getRowForPath(treePath);
                            TreeTableModelAdapter.this.fireTableRowsUpdated(n5, n5);
                        }
                    } else {
                        TreeTableModelAdapter.this.fireTableDataChanged();
                    }
                }
            });
        }
    }

    class ListToTreeSelectionModelWrapper
    extends DefaultTreeSelectionModel {
        protected boolean updatingListSelectionModel;

        public ListToTreeSelectionModelWrapper() {
            this.getListSelectionModel().addListSelectionListener(this.createListSelectionListener());
        }

        ListSelectionModel getListSelectionModel() {
            return this.listSelectionModel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resetRowSelection() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    super.resetRowSelection();
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        protected ListSelectionListener createListSelectionListener() {
            return new ListSelectionHandler();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateSelectedPathsFromSelectedRows() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    int n = this.listSelectionModel.getMinSelectionIndex();
                    int n2 = this.listSelectionModel.getMaxSelectionIndex();
                    this.clearSelection();
                    if (n != -1 && n2 != -1) {
                        for (int i = n; i <= n2; ++i) {
                            TreePath treePath;
                            if (!this.listSelectionModel.isSelectedIndex(i) || (treePath = JXTreeTable.this.renderer.getPathForRow(i)) == null) continue;
                            this.addSelectionPath(treePath);
                        }
                    }
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        class ListSelectionHandler
        implements ListSelectionListener {
            ListSelectionHandler() {
            }

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ListToTreeSelectionModelWrapper.this.updateSelectedPathsFromSelectedRows();
            }
        }
    }

    private class Actions
    extends UIAction {
        Actions(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if ("expand-all".equals(this.getName())) {
                JXTreeTable.this.expandAll();
            } else if ("collapse-all".equals(this.getName())) {
                JXTreeTable.this.collapseAll();
            }
        }
    }
}

