/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.dataset.util;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jdesktop.dataset.DataColumn;
import org.jdesktop.dataset.DataRelation;
import org.jdesktop.dataset.DataRelationTable;
import org.jdesktop.dataset.DataSet;
import org.jdesktop.dataset.DataSetUtils;
import org.jdesktop.dataset.DataTable;
import org.jdesktop.dataset.io.schema.DataSetIOUtility;
import org.jdesktop.dataset.io.schema.DataSetSchemaReader;
import org.jdesktop.dataset.io.schema.DataSetSchemaWriter;
import org.jdesktop.dataset.io.schema.JDBCDataSetSchemaReader;
import org.jdesktop.dataset.io.schema.SchemaReaderException;
import org.jdesktop.dataset.io.schema.SchemaWriterException;
import org.jdesktop.dataset.io.schema.XMLDataSetSchemaReader;
import org.jdesktop.dataset.io.schema.XMLDataSetSchemaWriter;
import org.jdesktop.dataset.provider.sql.JDBCDataConnection;
import org.jdesktop.dataset.provider.sql.SQLDataProvider;
import org.jdesktop.dataset.util.SchemaCreationException;

public class DataSetUtility {
    public static DataSet setProviderConnection(DataSet dataSet, JDBCDataConnection jDBCDataConnection) {
        for (DataTable dataTable : dataSet.getTables()) {
            if (dataTable instanceof DataRelationTable || dataTable.getDataProvider() == null) continue;
            dataTable.getDataProvider().setConnection(jDBCDataConnection);
        }
        return dataSet;
    }

    public static DataSet readDataSet(DataSetSchemaReader dataSetSchemaReader) throws SchemaReaderException {
        return dataSetSchemaReader.readDataSet();
    }

    public static DataSet readDataSet(DataSetSchemaReader dataSetSchemaReader, String ... stringArray) throws SchemaReaderException {
        return dataSetSchemaReader.readDataSet(stringArray);
    }

    public static DataSet readDataSetFromJDBC(JDBCDataConnection jDBCDataConnection) throws SchemaReaderException {
        return DataSetUtility.readDataSet(new JDBCDataSetSchemaReader(jDBCDataConnection));
    }

    public static DataSet readDataSetFromJDBC(JDBCDataConnection jDBCDataConnection, String ... stringArray) throws SchemaReaderException {
        return DataSetUtility.readDataSet(new JDBCDataSetSchemaReader(jDBCDataConnection), stringArray);
    }

    public static DataSet readDataSetFromXml(InputStream inputStream, String ... stringArray) throws SchemaReaderException {
        if (stringArray.length == 0) {
            return DataSetUtility.readDataSet(new XMLDataSetSchemaReader(inputStream));
        }
        return DataSetUtility.readDataSet(new XMLDataSetSchemaReader(inputStream), stringArray);
    }

    public static DataSet readDataSetFromXml(Reader reader, String ... stringArray) throws SchemaReaderException {
        if (stringArray.length == 0) {
            return DataSetUtility.readDataSet(new XMLDataSetSchemaReader(reader));
        }
        return DataSetUtility.readDataSet(new XMLDataSetSchemaReader(reader), stringArray);
    }

    public static void writeDataSet(DataSetSchemaWriter dataSetSchemaWriter, DataSet dataSet) throws SchemaWriterException {
        dataSetSchemaWriter.writeDataSet(dataSet);
    }

    public static void writeDataSet(DataSetSchemaWriter dataSetSchemaWriter, DataSet dataSet, String ... stringArray) throws SchemaWriterException {
        dataSetSchemaWriter.writeDataSet(dataSet, stringArray);
    }

    public static void writeDataSetAsXml(OutputStream outputStream, DataSet dataSet) throws SchemaWriterException {
        XMLDataSetSchemaWriter xMLDataSetSchemaWriter = new XMLDataSetSchemaWriter(outputStream);
        xMLDataSetSchemaWriter.writeDataSet(dataSet);
    }

    public static void writeDataSetAsXml(Writer writer, DataSet dataSet) throws SchemaWriterException {
        XMLDataSetSchemaWriter xMLDataSetSchemaWriter = new XMLDataSetSchemaWriter(writer);
        xMLDataSetSchemaWriter.writeDataSet(dataSet);
    }

    public static void createDataTableSchema(JDBCDataConnection jDBCDataConnection, DataSet dataSet, String string, String string2) throws SchemaCreationException {
        assert (jDBCDataConnection != null) : "Cannot supply a null data connection";
        assert (dataSet != null) : "Cannot supply a null DataSet";
        assert (string != null) : "Cannot supply a null table name";
        assert (string2 != null) : "Cannot supply a null statement";
        assert (jDBCDataConnection.isConnected()) : "The data connection must be open";
        System.out.println(string2);
        DataTable dataTable = dataSet.createTable(string);
        try {
            DataColumn dataColumn;
            Object object;
            Connection connection = jDBCDataConnection.getConnection();
            ResultSet resultSet = connection.createStatement().executeQuery(string2);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            if (resultSetMetaData.getColumnCount() == 0) {
                return;
            }
            String string3 = resultSetMetaData.getCatalogName(1);
            HashSet<Object> hashSet = new HashSet<Object>(5);
            for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                String string4 = resultSetMetaData.getCatalogName(i);
                if (!"".equals(string4) && !string3.equals(string4)) {
                    throw new SchemaCreationException("Resulting table has sources from multiple catalogs - " + string3 + " & " + string4);
                }
                object = resultSetMetaData.getTableName(i);
                dataColumn = dataTable.createColumn(resultSetMetaData.getColumnName(i));
                dataColumn.setReadOnly(resultSetMetaData.isReadOnly(i));
                dataColumn.setType(DataSetIOUtility.getType(resultSetMetaData.getColumnType(i)));
                ResultSet resultSet2 = databaseMetaData.getColumns(string3, null, (String)object, dataColumn.getName());
                if (!resultSet2.next()) continue;
                dataColumn.setDefaultValue(resultSet2.getObject(13));
                dataColumn.setRequired(resultSet2.getString(18).equals("NO"));
                hashSet.add(object);
            }
            for (String string4 : hashSet) {
                object = databaseMetaData.getPrimaryKeys(string3, null, string4);
                while (object.next()) {
                    dataColumn = dataTable.getColumn(object.getString(4));
                    if (dataColumn == null) continue;
                    dataColumn.setKeyColumn(true);
                }
            }
        }
        catch (Exception exception) {
            dataSet.dropTable(dataTable);
            exception.printStackTrace();
            throw new SchemaCreationException("Could not create the schema for the table " + string, exception);
        }
    }

    public static DataSet createDataSetSchema(JDBCDataConnection jDBCDataConnection, String ... stringArray) throws SchemaCreationException {
        assert (jDBCDataConnection != null) : "Cannot supply a null data connection";
        assert (stringArray != null) : "Cannot supply a null list of names";
        assert (jDBCDataConnection.isConnected()) : "The data connection must be open";
        DataSet dataSet = new DataSet();
        HashMap hashMap = new HashMap(5);
        for (String object : stringArray) {
            int n = object.indexOf(".");
            if (n != -1) {
                String string3 = object.substring(0, n);
                String string2 = object.substring(n + 1);
                if (!hashMap.containsKey(string3)) {
                    hashMap.put(string3, new HashSet());
                }
                if (hashMap.get(string3) == null) continue;
                ((Set)hashMap.get(string3)).add(string2);
                continue;
            }
            hashMap.put(object, null);
        }
        for (String string : hashMap.keySet()) {
            Set set = (Set)hashMap.get(string);
            if (set == null) {
                DataSetUtility.createDataTableSchema(jDBCDataConnection, dataSet, string, "SELECT * FROM " + string);
            } else {
                assert (set.size() > 0) : "Created an empty column set";
                StringBuilder stringBuilder = new StringBuilder("SELECT ");
                for (String string3 : set) {
                    stringBuilder.append(string3);
                    stringBuilder.append(",");
                }
                stringBuilder.deleteCharAt(stringBuilder.length() - 1);
                stringBuilder.append(" FROM ");
                stringBuilder.append(string);
                stringBuilder.append(" LIMIT 0");
                DataSetUtility.createDataTableSchema(jDBCDataConnection, dataSet, string, stringBuilder.toString());
            }
            SQLDataProvider sQLDataProvider = new SQLDataProvider(string);
            sQLDataProvider.setConnection(jDBCDataConnection);
            dataSet.getTable(string).setDataProvider(sQLDataProvider);
        }
        DataSetUtility.createRelations(jDBCDataConnection, dataSet);
        return dataSet;
    }

    public static void createRelations(JDBCDataConnection jDBCDataConnection, DataSet dataSet) throws SchemaCreationException {
        assert (jDBCDataConnection != null) : "Cannot supply a null connection";
        assert (dataSet != null) : "Cannot supply a null DataSet";
        assert (jDBCDataConnection.isConnected()) : "The data connection must be open";
        List<DataTable> list = dataSet.getTables();
        try {
            Connection connection = jDBCDataConnection.getConnection();
            for (DataTable dataTable : list) {
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                ResultSet resultSet = databaseMetaData.getImportedKeys(connection.getCatalog(), null, dataTable.getName());
                while (resultSet.next()) {
                    if (resultSet.getInt(9) > 1) continue;
                    String string = resultSet.getString(3);
                    DataTable dataTable2 = dataSet.getTable(resultSet.getString(3));
                    for (DataTable dataTable3 : list) {
                        if (!dataTable3.getName().equalsIgnoreCase(string)) continue;
                        dataTable2 = dataTable3;
                        break;
                    }
                    if (dataTable2 == null) continue;
                    DataColumn dataColumn = dataTable2.getColumn(resultSet.getString(4));
                    DataColumn dataColumn2 = dataTable.getColumn(resultSet.getString(8));
                    if (dataColumn2 == null || dataColumn == null || dataColumn2 == dataColumn) continue;
                    DataRelation dataRelation = dataSet.createRelation(resultSet.getString(12));
                    dataRelation.setParentColumn(dataColumn2);
                    dataRelation.setChildColumn(dataColumn);
                }
            }
        }
        catch (Exception exception) {
            throw new SchemaCreationException("Could not create data relations", exception);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        JDBCDataConnection jDBCDataConnection = new JDBCDataConnection();
        jDBCDataConnection.setConnected(true);
        DataSet dataSet = DataSetUtility.createDataSetSchema(jDBCDataConnection, "Addresses", "Customers", "Bookings", "BookingLocations");
        dataSet.loadAndWait();
        jDBCDataConnection.setConnected(false);
        System.out.println(DataSetUtils.getXmlSchema(dataSet));
        System.out.println(dataSet.writeXml());
    }
}

