/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.dataset.provider.sql;

import java.sql.PreparedStatement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdesktop.dataset.DataColumn;
import org.jdesktop.dataset.DataRow;
import org.jdesktop.dataset.provider.sql.AbstractSqlCommand;
import org.jdesktop.dataset.provider.sql.JDBCDataConnection;

public class SQLCommand
extends AbstractSqlCommand {
    private static final Logger LOG = Logger.getLogger(SQLCommand.class.getName());
    private String deleteSql;
    private String insertSql;
    private String selectSql;
    private String updateSql;

    public void setSelectSQL(String string) {
        if (this.selectSql != string) {
            String string2 = this.selectSql;
            this.selectSql = string;
            this.firePropertyChange("selectSql", string2, string);
        }
    }

    public String getSelectSQL() {
        return this.selectSql;
    }

    public void setUpdateSQL(String string) {
        if (this.updateSql != string) {
            String string2 = this.updateSql;
            this.updateSql = string;
            this.firePropertyChange("updateSql", string2, string);
        }
    }

    public String getUpdateSQL() {
        return this.updateSql;
    }

    public void setInsertSQL(String string) {
        if (this.insertSql != string) {
            String string2 = this.insertSql;
            this.insertSql = string;
            this.firePropertyChange("insertSql", string2, string);
        }
    }

    public String getInsertSQL() {
        return this.insertSql;
    }

    public void setDeleteSQL(String string) {
        if (this.deleteSql != string) {
            String string2 = this.deleteSql;
            this.deleteSql = string;
            this.firePropertyChange("deleteSql", string2, string);
        }
    }

    public String getDeleteSQL() {
        return this.deleteSql;
    }

    public String[] getParameterNames() {
        return super.getParameterNames(new String[]{this.selectSql, this.updateSql, this.insertSql, this.deleteSql});
    }

    protected PreparedStatement createPreparedStatement(String string, JDBCDataConnection jDBCDataConnection) throws Exception {
        HashMap<String, List<Integer>> hashMap = new HashMap<String, List<Integer>>();
        String string2 = this.constructSql(string, hashMap);
        PreparedStatement preparedStatement = jDBCDataConnection.prepareStatement(string2);
        for (String string3 : this.getParameterNames()) {
            List list = (List)hashMap.get(string3);
            if (list == null) continue;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                int n = (Integer)iterator.next();
                preparedStatement.setObject(n + 1, this.getParameter(string3));
            }
        }
        return preparedStatement;
    }

    protected PreparedStatement getSelectStatement(JDBCDataConnection jDBCDataConnection) throws Exception {
        if (this.selectSql == null) {
            throw new Exception("SQLCommand not configured with a select sql statement");
        }
        try {
            return this.createPreparedStatement(this.selectSql, jDBCDataConnection);
        }
        catch (Exception exception) {
            LOG.log(Level.WARNING, "Problem with select SQL statement {0}", this.deleteSql);
            LOG.log(Level.WARNING, exception.getMessage(), exception);
            return null;
        }
    }

    protected PreparedStatement getUpdateStatement(JDBCDataConnection jDBCDataConnection, DataRow dataRow) throws Exception {
        if (this.updateSql == null) {
            throw new Exception("SQLCommand not configured with an update sql statement");
        }
        try {
            int n;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            List<DataColumn> list = dataRow.getTable().getColumns();
            for (n = 0; n < list.size(); ++n) {
                DataColumn dataColumn = list.get(n);
                hashMap.put(dataColumn.getName(), dataRow.getValue(dataColumn));
            }
            n = 0;
            for (int i = 0; i < list.size(); ++i) {
                DataColumn dataColumn = list.get(i);
                if (!dataColumn.isKeyColumn()) continue;
                hashMap.put("orig_" + dataColumn.getName(), dataRow.getReferenceValue(dataColumn));
                ++n;
            }
            return super.prepareStatement(this.updateSql, hashMap, jDBCDataConnection);
        }
        catch (Exception exception) {
            LOG.log(Level.WARNING, "Problem with update SQL statement {0}", this.deleteSql);
            LOG.log(Level.WARNING, exception.getMessage(), exception);
            return null;
        }
    }

    protected PreparedStatement getInsertStatement(JDBCDataConnection jDBCDataConnection, DataRow dataRow) throws Exception {
        if (this.insertSql == null) {
            throw new Exception("SQLCommand not configured with an insert sql statement");
        }
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            for (DataColumn dataColumn : dataRow.getTable().getColumns()) {
                hashMap.put(dataColumn.getName(), dataRow.getValue(dataColumn));
            }
            return super.prepareStatement(this.insertSql, hashMap, jDBCDataConnection);
        }
        catch (Exception exception) {
            LOG.log(Level.WARNING, "Problem with insert SQL statement {0}", this.deleteSql);
            LOG.log(Level.WARNING, exception.getMessage(), exception);
            return null;
        }
    }

    protected PreparedStatement getDeleteStatement(JDBCDataConnection jDBCDataConnection, DataRow dataRow) throws Exception {
        if (this.deleteSql == null) {
            throw new Exception("SQLCommand not configured with a delete sql statement");
        }
        try {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            List<DataColumn> list = dataRow.getTable().getColumns();
            for (int i = 0; i < list.size(); ++i) {
                DataColumn dataColumn = list.get(i);
                if (!dataColumn.isKeyColumn()) continue;
                hashMap.put("orig_" + dataColumn.getName(), dataRow.getReferenceValue(dataColumn));
            }
            return super.prepareStatement(this.deleteSql, hashMap, jDBCDataConnection);
        }
        catch (Exception exception) {
            LOG.log(Level.WARNING, "Problem with delete SQL statement {0}", this.deleteSql);
            LOG.log(Level.WARNING, exception.getMessage(), exception);
            return null;
        }
    }
}

