/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.dataset.io.schema;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jdesktop.dataset.DataColumn;
import org.jdesktop.dataset.DataProvider;
import org.jdesktop.dataset.DataRelation;
import org.jdesktop.dataset.DataSet;
import org.jdesktop.dataset.DataTable;
import org.jdesktop.dataset.io.schema.DataSetIOUtility;
import org.jdesktop.dataset.io.schema.DataSetSchemaReader;
import org.jdesktop.dataset.io.schema.SchemaReaderException;
import org.jdesktop.dataset.provider.sql.JDBCDataConnection;
import org.jdesktop.dataset.provider.sql.SQLDataProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCDataSetSchemaReader
implements DataSetSchemaReader {
    private JDBCDataConnection jdbcConn;
    private String catalog;
    private String schema;

    public JDBCDataSetSchemaReader(JDBCDataConnection jDBCDataConnection) {
        this(jDBCDataConnection, null, null);
    }

    public JDBCDataSetSchemaReader(JDBCDataConnection jDBCDataConnection, String string, String string2) {
        this.jdbcConn = jDBCDataConnection;
        this.catalog = string;
        this.schema = string2;
    }

    @Override
    public DataSet readDataSet() throws SchemaReaderException {
        boolean bl = this.jdbcConn.isConnected();
        if (!bl) {
            this.jdbcConn.setConnected(true);
        }
        DataSet dataSet = null;
        try {
            Connection connection = this.jdbcConn.getConnection();
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            String[] stringArray = new String[]{"TABLE"};
            ResultSet resultSet = databaseMetaData.getTables(null, null, "%", stringArray);
            List<String> list = DataSetIOUtility.extractColumn(resultSet, "TABLE_NAME");
            resultSet.close();
            String[] stringArray2 = list.toArray(new String[list.size()]);
            dataSet = this.readDataSet(stringArray2);
        }
        catch (SchemaReaderException schemaReaderException) {
            throw schemaReaderException;
        }
        catch (Exception exception) {
            throw new SchemaReaderException("Could not read schemas to create DataSet", exception);
        }
        finally {
            this.jdbcConn.setConnected(bl);
        }
        return dataSet;
    }

    @Override
    public DataSet readDataSet(String ... stringArray) throws SchemaReaderException {
        boolean bl = this.jdbcConn.isConnected();
        if (!bl) {
            this.jdbcConn.setConnected(true);
        }
        DataSet dataSet = new DataSet();
        try {
            this.addTables(dataSet, stringArray);
            this.addRelations(dataSet, stringArray);
        }
        catch (SchemaReaderException schemaReaderException) {
            throw schemaReaderException;
        }
        catch (Exception exception) {
            throw new SchemaReaderException("Could not read schemas to create DataTables", exception);
        }
        finally {
            this.jdbcConn.setConnected(bl);
        }
        return dataSet;
    }

    @Override
    public List<String> addTables(DataSet dataSet, String ... stringArray) throws SchemaReaderException {
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        boolean bl = this.jdbcConn.isConnected();
        if (!bl) {
            this.jdbcConn.setConnected(true);
        }
        try {
            Object object;
            Object object2;
            Connection connection = this.jdbcConn.getConnection();
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            HashMap hashMap = new HashMap(5);
            for (String object3 : stringArray) {
                int n = object3.indexOf(".");
                if (n != -1) {
                    object2 = object3.substring(0, n);
                    object = object3.substring(n + 1);
                    if (!hashMap.containsKey(object2)) {
                        hashMap.put((String)object2, new HashSet());
                    }
                    if (hashMap.get(object2) == null) continue;
                    ((Set)hashMap.get(object2)).add(object);
                    continue;
                }
                hashMap.put(object3, null);
            }
            for (String string : hashMap.keySet()) {
                if (dataSet.getTable(string) != null) {
                    System.out.println("SKIPPING TABLE " + string + " ALREADY IN DATASET");
                    continue;
                }
                Set set = (Set)hashMap.get(string);
                ArrayList<String> arrayList2 = set == null ? null : new ArrayList<String>(set);
                String string2 = this.getTableSelectNoRowsCommand(string, arrayList2);
                object2 = this.readDataTable(dataSet, string, string2);
                object = new SQLDataProvider(string);
                ((DataProvider)object).setConnection(this.jdbcConn);
                ((DataTable)object2).setDataProvider((DataProvider)object);
                arrayList.add(string);
            }
        }
        catch (SchemaReaderException schemaReaderException) {
            throw schemaReaderException;
        }
        catch (Exception exception) {
            throw new SchemaReaderException("Could not read schemas to create DataTables", exception);
        }
        finally {
            this.jdbcConn.setConnected(bl);
        }
        return arrayList;
    }

    @Override
    public List<String> addRelations(DataSet dataSet, String ... stringArray) throws SchemaReaderException {
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = this.jdbcConn.isConnected();
        if (!bl) {
            this.jdbcConn.setConnected(true);
        }
        Connection connection = this.jdbcConn.getConnection();
        try {
            List<DataTable> list = dataSet.getTables();
            for (String string : stringArray) {
                DataTable dataTable = dataSet.getTable(string);
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                ResultSet resultSet = databaseMetaData.getImportedKeys(connection.getCatalog(), null, dataTable.getName());
                while (resultSet.next()) {
                    if (resultSet.getInt("KEY_SEQ") > 1) continue;
                    DataTable dataTable2 = null;
                    String string2 = resultSet.getString("PKTABLE_NAME");
                    for (DataTable dataTable3 : list) {
                        if (!dataTable3.getName().equalsIgnoreCase(string2)) continue;
                        dataTable2 = dataTable3;
                        break;
                    }
                    if (dataTable2 == null) continue;
                    DataColumn dataColumn = dataTable2.getColumn(resultSet.getString("PKCOLUMN_NAME"));
                    DataColumn dataColumn2 = dataTable.getColumn(resultSet.getString("FKCOLUMN_NAME"));
                    if (dataColumn == null || dataColumn2 == null || dataColumn == dataColumn2) continue;
                    String string3 = resultSet.getString("FK_NAME");
                    if (dataSet.getRelation(string3) != null) {
                        dataSet.dropRelation(string3);
                    }
                    DataRelation dataRelation = dataSet.createRelation(resultSet.getString("FK_NAME"));
                    dataRelation.setParentColumn(dataColumn);
                    dataRelation.setChildColumn(dataColumn2);
                    arrayList.add(dataRelation.getName());
                }
            }
        }
        catch (Exception exception) {
            throw new SchemaReaderException("Could not create data relations", exception);
        }
        finally {
            this.jdbcConn.setConnected(bl);
        }
        return arrayList;
    }

    protected String getTableSelectNoRowsCommand(String string, List<String> list) {
        String string2 = ", \n";
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("SELECT ");
        if (list == null) {
            stringBuilder.append("*\n");
        } else {
            for (String string3 : list) {
                stringBuilder.append(string3 + string2);
            }
            stringBuilder.delete(stringBuilder.length() - string2.length(), stringBuilder.length() - 1);
        }
        stringBuilder.append("FROM " + string + "\n");
        stringBuilder.append("WHERE 1 = 0");
        return stringBuilder.toString();
    }

    private DataTable readDataTable(DataSet dataSet, String string, String string2) throws SchemaReaderException {
        boolean bl = this.jdbcConn.isConnected();
        if (!bl) {
            this.jdbcConn.setConnected(true);
        }
        Connection connection = this.jdbcConn.getConnection();
        DataTable dataTable = null;
        try {
            Object object;
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            Statement statement = connection.createStatement();
            ResultSetMetaData resultSetMetaData = statement.executeQuery(string2).getMetaData();
            dataTable = dataSet.createTable(string);
            int n = resultSetMetaData.getColumnCount();
            String string3 = resultSetMetaData.getCatalogName(1);
            String string4 = resultSetMetaData.getSchemaName(1);
            for (int i = 1; i <= n; ++i) {
                object = resultSetMetaData.getColumnName(i);
                DataColumn dataColumn = dataTable.createColumn((String)object);
                dataColumn.setRequired(resultSetMetaData.isNullable(i) == 1);
                dataColumn.setReadOnly(resultSetMetaData.isReadOnly(i));
                dataColumn.setType(DataSetIOUtility.getType(resultSetMetaData.getColumnType(i)));
                String string5 = "%";
                ResultSet resultSet = databaseMetaData.getColumns(string3, string4, string, string5);
                if (!resultSet.next()) continue;
                dataColumn.setDefaultValue(resultSet.getObject("COLUMN_DEF"));
                resultSet.close();
            }
            ResultSet resultSet = databaseMetaData.getPrimaryKeys(string3, string4, string);
            while (resultSet.next()) {
                object = dataTable.getColumn(resultSet.getString("COLUMN_NAME"));
                if (object == null) continue;
                ((DataColumn)object).setKeyColumn(true);
            }
            object = new SQLDataProvider(string);
            ((DataProvider)object).setConnection(this.jdbcConn);
            dataTable.setDataProvider((DataProvider)object);
        }
        catch (Exception exception) {
            dataSet.dropTable(string);
            throw new SchemaReaderException("Could not create DataTable for table named " + string, exception);
        }
        finally {
            this.jdbcConn.setConnected(bl);
        }
        return dataTable;
    }
}

