/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.dataset.adapter;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.jdesktop.binding.SelectionModel;
import org.jdesktop.binding.SelectionModelEvent;
import org.jdesktop.binding.SelectionModelListener;
import org.jdesktop.dataset.DataSelector;

public class SelectionModelAdapter
implements SelectionModel {
    private DataSelector selector;
    private List<SelectionModelListener> listeners = new ArrayList<SelectionModelListener>();

    public SelectionModelAdapter(DataSelector dataSelector) {
        assert (dataSelector != null);
        this.selector = dataSelector;
        this.selector.addPropertyChangeListener("rowIndices", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                SelectionModelEvent selectionModelEvent = new SelectionModelEvent(SelectionModelAdapter.this, 0, SelectionModelAdapter.this.selector.getDataTable().getRowCount() - 1);
                for (SelectionModelListener selectionModelListener : SelectionModelAdapter.this.listeners) {
                    selectionModelListener.selectionChanged(selectionModelEvent);
                }
            }
        });
    }

    public void addSelectionModelListener(SelectionModelListener selectionModelListener) {
        if (!this.listeners.contains(selectionModelListener)) {
            this.listeners.add(selectionModelListener);
        }
    }

    public void removeSelectionModelListener(SelectionModelListener selectionModelListener) {
        this.listeners.remove(selectionModelListener);
    }

    public void setSelectionIndices(int[] nArray) {
        this.selector.setRowIndices(nArray);
    }

    public int[] getSelectionIndices() {
        List<Integer> list = this.selector.getRowIndices();
        int[] nArray = new int[list.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = list.get(i);
        }
        return nArray;
    }
}

