/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.dataset.adapter;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.jdesktop.binding.DataModel;
import org.jdesktop.binding.ValueChangeEvent;
import org.jdesktop.binding.ValueChangeListener;
import org.jdesktop.binding.metadata.MetaData;
import org.jdesktop.binding.metadata.Validator;
import org.jdesktop.dataset.DataSelector;
import org.jdesktop.dataset.adapter.MetaDataProviderAdapter;
import org.jdesktop.dataset.event.DataTableListener;
import org.jdesktop.dataset.event.RowChangeEvent;
import org.jdesktop.dataset.event.TableChangeEvent;

public class DataModelAdapter
implements DataModel {
    private DataSelector selector;
    private MetaDataProviderAdapter mdp;
    private List<Validator> validators = new ArrayList<Validator>();
    private List<ValueChangeListener> listeners = new ArrayList<ValueChangeListener>();

    public DataModelAdapter(DataSelector dataSelector) {
        assert (dataSelector != null);
        this.selector = dataSelector;
        this.mdp = new MetaDataProviderAdapter(this.selector.getDataTable());
        this.selector.addPropertyChangeListener("rowIndices", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                for (String string : DataModelAdapter.this.mdp.getFieldNames()) {
                    DataModelAdapter.this.fireValueChanged(string);
                }
            }
        });
        this.selector.getDataTable().addDataTableListener(new DataTableListener(){

            public void rowChanged(RowChangeEvent rowChangeEvent) {
            }

            public void tableChanged(TableChangeEvent tableChangeEvent) {
                for (String string : DataModelAdapter.this.mdp.getFieldNames()) {
                    DataModelAdapter.this.fireValueChanged(string);
                }
            }
        });
    }

    public void addValidator(Validator validator) {
        if (!this.validators.contains(validator)) {
            this.validators.add(validator);
        }
    }

    public void removeValidator(Validator validator) {
        this.validators.remove(validator);
    }

    public Validator[] getValidators() {
        return this.validators.toArray(new Validator[this.validators.size()]);
    }

    public void addValueChangeListener(ValueChangeListener valueChangeListener) {
        if (!this.listeners.contains(valueChangeListener)) {
            this.listeners.add(valueChangeListener);
        }
    }

    public void removeValueChangeListener(ValueChangeListener valueChangeListener) {
        this.listeners.remove(valueChangeListener);
    }

    public ValueChangeListener[] getValueChangeListeners() {
        return this.listeners.toArray(new ValueChangeListener[this.listeners.size()]);
    }

    public int getFieldCount() {
        return this.mdp.getFieldCount();
    }

    public String[] getFieldNames() {
        return this.mdp.getFieldNames();
    }

    public MetaData[] getMetaData() {
        return this.mdp.getMetaData();
    }

    public MetaData getMetaData(String string) {
        return this.mdp.getMetaData(string);
    }

    public Object getValue(String string) {
        List<Integer> list = this.selector.getRowIndices();
        if (list.size() > 0) {
            return this.selector.getDataTable().getValue(list.get(0), string);
        }
        return null;
    }

    public void setValue(String string, Object object) {
        List<Integer> list = this.selector.getRowIndices();
        for (int n : list) {
            this.selector.getDataTable().setValue(n, string, object);
        }
    }

    protected void fireValueChanged(String string) {
        ValueChangeEvent valueChangeEvent = new ValueChangeEvent(this, string);
        for (ValueChangeListener valueChangeListener : this.listeners) {
            try {
                valueChangeListener.valueChanged(valueChangeEvent);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

