/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.dataset;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.jga.fn.UnaryFunctor;
import net.sf.jga.parser.ParseException;
import org.jdesktop.dataset.DataRow;
import org.jdesktop.dataset.DataSetUtils;
import org.jdesktop.dataset.DataTable;
import org.jdesktop.dataset.NameGenerator;
import org.jdesktop.dataset.Parser;

public class DataColumn {
    private static final Logger LOG = Logger.getLogger(DataColumn.class.getName());
    protected static final String DEFAULT_NAME_PREFIX = "DataColumn";
    private static final NameGenerator NAMEGEN = new NameGenerator("DataColumn");
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private DataTable table;
    private String name = NAMEGEN.generateName(this);
    private Class type = Object.class;
    private boolean readOnly = false;
    private boolean required = false;
    private Object defaultValue;
    private boolean keyColumn;
    private String expression;
    private UnaryFunctor<DataRow, ?> expImpl;

    protected DataColumn(DataTable dataTable) {
        assert (dataTable != null);
        this.table = dataTable;
    }

    public DataTable getTable() {
        return this.table;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        if (this.name != string) {
            assert (DataSetUtils.isValidName(string));
            assert (!this.table.columns.containsKey(string) && !this.table.selectors.containsKey(string));
            String string2 = this.name;
            this.name = string;
            this.pcs.firePropertyChange("name", string2, string);
        }
    }

    public Class getType() {
        return this.type;
    }

    public void setType(Class clazz) {
        if (this.type != clazz) {
            Class clazz2 = this.type;
            this.type = clazz == null ? Object.class : clazz;
            this.pcs.firePropertyChange("type", clazz2, clazz);
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean bl) {
        if (this.readOnly != bl) {
            boolean bl2 = this.readOnly;
            this.readOnly = bl;
            this.pcs.firePropertyChange("readOnly", bl2, bl);
        }
    }

    public boolean isRequired() {
        return this.required || this.keyColumn;
    }

    public void setRequired(boolean bl) {
        if (this.required != bl) {
            boolean bl2 = this.required;
            this.required = bl;
            this.pcs.firePropertyChange("required", bl2, bl);
        }
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object object) {
        if (this.defaultValue != object) {
            Object object2 = this.defaultValue;
            this.defaultValue = object;
            this.pcs.firePropertyChange("defaultValue", object2, object);
        }
    }

    public boolean isKeyColumn() {
        return this.keyColumn;
    }

    public void setKeyColumn(boolean bl) {
        if (bl != this.keyColumn) {
            boolean bl2 = this.keyColumn;
            this.keyColumn = bl;
            this.pcs.firePropertyChange("keyColumn", bl2, bl);
            if (!bl2 && bl && !this.required) {
                this.pcs.firePropertyChange("required", this.required, true);
            } else if (bl2 && !bl && !this.required) {
                this.pcs.firePropertyChange("required", true, this.required);
            }
        }
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String string) {
        if (string == null) {
            string = "";
        }
        if (!string.equals(this.expression)) {
            String string2 = this.expression;
            this.expression = string;
            this.pcs.firePropertyChange("expression", string2, string);
        }
    }

    public Object getValueForRow(DataRow dataRow) {
        block5: {
            if (this.expImpl == null) {
                if (this.expression == null || this.expression.equals("")) {
                    this.expImpl = null;
                } else {
                    LOG.log(Level.FINE, "Attempting to create the expression implementation");
                    try {
                        UnaryFunctor<DataRow, ?> unaryFunctor = this.getParser().parseComputedColumn(this.getTable(), this.expression);
                        this.expImpl = unaryFunctor;
                    }
                    catch (ParseException parseException) {
                        LOG.log(Level.FINE, "The expression {0} is not valid. {1}", new Object[]{this.expression, parseException});
                        this.expImpl = null;
                        if ($assertionsDisabled) break block5;
                        throw new AssertionError((Object)"The expression is not valid. See log for details");
                    }
                }
            }
        }
        return this.expImpl == null ? null : this.expImpl.fn((Object)dataRow);
    }

    Parser getParser() {
        return this.getTable().getDataSet().getParser();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(string, propertyChangeListener);
    }
}

