/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.binding.swingx.adapter;

import java.util.Date;
import java.util.HashMap;
import org.jdesktop.binding.metadata.Converter;
import org.jdesktop.binding.metadata.Converters;
import org.jdesktop.binding.swingx.adapter.TabularDataMetaData;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HierarchicalDataMetaData
extends TabularDataMetaData {
    private Element columns = null;
    private static HashMap typesMap = new HashMap();

    public HierarchicalDataMetaData(Element element) {
        super(element == null ? 0 : Integer.parseInt(element.getAttribute("columnCount")));
        this.columns = element;
        this.init();
    }

    protected void init() {
        if (this.columns != null) {
            NodeList nodeList = this.columns.getChildNodes();
            int n = 0;
            int n2 = 0;
            int n3 = nodeList.getLength();
            while (n < n3) {
                Class clazz;
                Element element;
                Node node;
                if (!((node = nodeList.item(n++)) instanceof Element) || !(element = (Element)node).getLocalName().equals("columnMetaData")) continue;
                this.setColumnName(++n2, element.getAttribute("name"));
                String string = element.getAttribute("type");
                if (string.length() <= 0 || (clazz = this.decodeType(string)) == null) continue;
                this.setColumnClass(n2, clazz);
                if (clazz == String.class) continue;
                Converter converter = Converters.get(clazz);
                if (converter == null) {
                    System.err.println("warning: couldn't find converter for " + clazz.getName() + ". Reseting class of column " + n2 + "to String.class");
                    this.setColumnClass(n2, String.class);
                    continue;
                }
                this.setColumnConverter(n2, converter);
            }
        }
    }

    private Class decodeType(String string) {
        Class<?> clazz = (Class<?>)typesMap.get(string);
        if (clazz == null) {
            try {
                clazz = Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.out.println("Could not convert type: " + string + " to a java type or class");
            }
        }
        return clazz;
    }

    static {
        typesMap.put("boolean", Boolean.class);
        typesMap.put("date", Date.class);
        typesMap.put("double", Double.class);
        typesMap.put("float", Float.class);
        typesMap.put("integer", Integer.class);
        typesMap.put("string", String.class);
    }
}

